//
//  ExpenditureDetailView.swift
//  CoreDataDemo
//
//  Created by 朱克剛 on 2022/9/9.
//

import SwiftUI

struct ExpenditureDetailView: View {
    @Environment(\.managedObjectContext) private var viewContext
    @FetchRequest(
        sortDescriptors: [SortDescriptor(\.date, order: .reverse)]
    ) private var expenditures: FetchedResults<Expenditure>

    // 接收從第一頁傳過來的title
    var title = ""
    // 給輸入金額的TextField用
    @State private var price: Int16 = 0
    var body: some View {
        List {
            ForEach(
                expenditures.filter(
                    { title == $0.relationshipItem?.title }
                )
            ) { expenditure in
                HStack {
                    Text(expenditure.date!, format: .dateTime)
                    Spacer()
                    Text(expenditure.price, format: .currency(code: "TWD"))
                }
            }
            .onDelete { indexSet in
                viewContext.delete(expenditures[indexSet.first!])
                try! viewContext.save()
            }
        }
        .safeAreaInset(edge: .top) {
            HStack {
                TextField("輸入金額", value: $price, format: .number)
                    .textFieldStyle(.roundedBorder)
                    .background(Color.white)
                Button("新增") {
                    let expenditure = Expenditure(context: viewContext)
                    expenditure.price = price
                    expenditure.date = .now
                    
                    let items = try! viewContext.fetch(Item.fetchRequest())
                    let item = items.first { item in
                        item.title == title
                    }
                    expenditure.relationshipItem = item
                    try! viewContext.save()
                }
            }
            .padding()
        }
        .navigationTitle(title)
    }
}

struct ExpenditureDetailView_Previews: PreviewProvider {
    static var previews: some View {
        ExpenditureDetailView()
    }
}
