//
//  FullSample.swift
//  CoreDataDemo
//
//  Created by 朱克剛 on 2022/9/8.
//

import SwiftUI

struct FullSample: View {
    @Environment(\.managedObjectContext) private var viewContext
    @FetchRequest(
        sortDescriptors: [SortDescriptor(\.title)],
        animation: .default
    ) private var items: FetchedResults<Item>
    
    // 給輸入項目的TextField用
    @State private var title = ""
    
    var body: some View {
        NavigationStack {
            List {
                ForEach(items) { item in
                    NavigationLink {
                        // 這裡進入第二頁
                        ExpenditureDetailView(title: item.title!)
                    } label: {
                        HStack {
                            // 顯示項目
                            Text(item.title!)
                            Spacer()
                            // 顯示筆數
                            Text(
                                item.relationshipExpenditure?.count ?? 0,
                                format: .number
                            )
                        }
                    }
                }
                .onDelete { indexSet in
                    viewContext.delete(items[indexSet.first!])
                    try! viewContext.save()
                }
            }
            .safeAreaInset(edge: .top) {
                HStack {
                    TextField("輸入項目名稱", text: $title)
                        .textFieldStyle(.roundedBorder)
                        .background(Color.white)
                    Button("新增") {
                        Item(context: viewContext).title = title
                        try! viewContext.save()
                    }
                }
                .padding()
            }
            .navigationTitle("記帳")
        }
    }
}

struct FullSample_Previews: PreviewProvider {
    static var previews: some View {
        FullSample()
    }
}
