//
//  ReadSomeData.swift
//  CoreDataDemo
//
//  Created by 朱克剛 on 2022/9/15.
//

import SwiftUI

struct ReadSomeData: View {
    @Environment(\.managedObjectContext) private var viewContext
    
    @FetchRequest(
        sortDescriptors: [SortDescriptor(\.price, order: .reverse)],
        predicate: NSPredicate(format: "price > %d", 100),
        animation: .default
    ) private var expenditures: FetchedResults<Expenditure>
    
    
    var body: some View {
        VStack {
            Button("輸入資料") {
                print($expenditures)
                var expenditure = Expenditure(context: viewContext)
                expenditure.price = 250
                expenditure = Expenditure(context: viewContext)
                expenditure.price = 1100
                try! viewContext.save()
            }
            
            Button("超過100塊的資料") {
                let predicate = NSPredicate(format: "price > %d", 100)
                let sort = NSSortDescriptor(
                    keyPath: \Expenditure.price,
                    ascending: false
                )
                let request = Expenditure.fetchRequest()
                request.predicate = predicate
                request.sortDescriptors = [sort]
                let expenditures = try! viewContext.fetch(request)
                expenditures.forEach { expenditure in
                    print(expenditure.price)
                }
            }
        }
    }
}

struct ReadSomeData_Previews: PreviewProvider {
    static var previews: some View {
        ReadSomeData()
    }
}
