//
//  Relation.swift
//  CoreDataDemo
//
//  Created by 朱克剛 on 2022/9/9.
//

import SwiftUI

struct Relation: View {
    @Environment(\.managedObjectContext) private var viewContext
    var body: some View {
        VStack {
            Button("早餐消費") {
                // 建立一筆消費
                let expenditure = Expenditure(context: viewContext)
                expenditure.price = 80
                expenditure.date = .now
                
                // 找到早餐
                let items = try! viewContext.fetch(Item.fetchRequest())
                let item = items.first { item in
                    item.title == "早餐"
                }
                
                // 產生關連
//                item?.addToRelationshipExpenditure(expenditure)
                expenditure.relationshipItem = item
                
                try! viewContext.save()
            }
            Button("查詢消費項目") {
                let expenditures = try! viewContext.fetch(Expenditure.fetchRequest())
                let expenditure = expenditures.first { expenditure in
                    expenditure.price == 80
                }
                let title = expenditure?.relationshipItem?.title
                print(title)
            }
            Button("讀取所有早餐消費") {
                let items = try! viewContext.fetch(Item.fetchRequest())
                let item = items.first { item in
                    item.title == "早餐"
                }
                item?.relationshipExpenditure?.forEach { el in
                    let expenditure = el as! Expenditure
                    let price = expenditure.price
                    let dateString = expenditure.date!.description
                    print(("早餐", price, dateString))
                }
                
            }
        }
        
    }
}

struct Relation_Previews: PreviewProvider {
    static var previews: some View {
        Relation()
    }
}
