//
//  Barcode.swift
//  VisionDemo
//
//  Created by 朱克剛 on 2022/9/22.
//

import SwiftUI
import Vision

struct Barcode: View {
    private let uiImage = UIImage(named: "qrcode.png")!
    private var ratio: Double {
        uiImage.size.width / uiImage.size.height
    }
    @State private var barcodes: [VNBarcodeObservation] = []
    var body: some View {
        Canvas { context, size in
            // 畫出圖片
            context.draw(
                Image(uiImage: uiImage),
                in: CGRect(origin: .zero, size: size)
            )
            
            barcodes.forEach { item in
                // 畫出範圍
                let box = item.boundingBox
                let rect = CGRect(
                    x: size.width * box.origin.x,
                    y: size.height * (1 - box.origin.y),
                    width: size.width * box.width,
                    height: -size.height * box.height
                )
                var path = Path()
                path.addRect(rect)
                context.stroke(path, with: .color(.yellow), lineWidth: 5)
                
                if let text = item.payloadStringValue {
                    let textRect = CGRect(
                        x: rect.minX, y: rect.minY - 50, width: rect.width, height: 50
                    )
                    context.draw(
                        Text(text)
                            .foregroundColor(.blue)
                            .bold(),
                        in: textRect
                    )
                }
            }
        }
        .frame(width: 400, height: 400 / ratio)
        .onAppear() {
            Task {
                await barcodeDetection()
            }
        }
    }
    
    private func barcodeDetection() async {
        let request = VNDetectBarcodesRequest { request, error in
            guard error == nil else {
                print(error!)
                return
            }
            
            if let barcodes = request.results as? [VNBarcodeObservation] {
                self.barcodes = barcodes
            }
        }
        
        do {
            let handler = VNImageRequestHandler(cgImage: uiImage.cgImage!)
            try handler.perform([request])
        } catch {
            print(error.localizedDescription)
        }
    }

}

struct Barcode_Previews: PreviewProvider {
    static var previews: some View {
        Barcode()
    }
}
