//
//  FaceDetectLiveVideo.swift
//  VisionDemo
//
//  Created by 朱克剛 on 2022/9/22.
//

import SwiftUI
import Vision

struct FaceDetectLiveVideo: View {
    @ObservedObject private var faceVideo = FaceVideo.shared
    private var ratio: Double? {
        if let size = faceVideo.uiImage?.size {
            return size.width / size.height
        }
        return nil
    }
    
    var body: some View {
        VStack {
            Button("click") {
                DispatchQueue.global().async {
                    CameraManager.current.session.startRunning()
                }
            }
            
            Canvas { context, size in
                // 畫出圖片
                if let uiImage = faceVideo.uiImage {
                    context.draw(
                        Image(uiImage: uiImage),
                        in: CGRect(origin: .zero, size: size)
                    )
                }
                
                faceVideo.faces.forEach { face in
                    // 畫出範圍
                    let box = face.boundingBox
                    let rect = CGRect(
                        x: size.width * box.origin.x,
                        y: size.height * (1 - box.origin.y),
                        width: size.width * box.width,
                        height: -size.height * box.height
                    )
                    var path = Path()
                    path.addRect(rect)
                    context.stroke(path, with: .color(.yellow), lineWidth: 5)
                }
            }
            .frame(width: 300, height: 300 / (ratio ?? 1))
            .background(.yellow.opacity(0.1))
        }
    }
}

struct FaceDetectLiveVideo_Previews: PreviewProvider {
    static var previews: some View {
        FaceDetectLiveVideo()
    }
}
