//
//  PoseDetect.swift
//  VisionDemo
//
//  Created by 朱克剛 on 2022/9/22.
//

import SwiftUI
import Vision

struct PoseDetect: View {
    private let uiImage = UIImage(named: "human.jpg")!
    private var ratio: Double {
        uiImage.size.width / uiImage.size.height
    }
    @State private var bodyPoints: [VNHumanBodyPoseObservation] = []
    var body: some View {
        Canvas { context, size in
            // 畫出圖片
            context.draw(
                Image(uiImage: uiImage),
                in: CGRect(origin: .zero, size: size)
            )
            
            bodyPoints.forEach { item in
                if let recognizedPoints = try? item.recognizedPoints(.all) {
                    recognizedPoints.forEach { body in
                        let point = VNImagePointForNormalizedPoint(
                            body.value.location, Int(size.width), Int(size.height)
                        )
                        var path = Path()
                        path.addArc(
                            center: CGPoint(x: point.x, y: size.height - point.y),
                            radius: 4,
                            startAngle: .zero,
                            endAngle: .degrees(360),
                            clockwise: true
                        )
                        context.fill(path, with: .color(.green))

                    }
                }
            }
        }
        .frame(width: 400, height: 400 / ratio)
        .onAppear() {
            Task {
                await poseDetection()
            }
        }
    }
    
    private func poseDetection() async {
        let request = VNDetectHumanBodyPoseRequest { request, error in
            guard error == nil else {
                print(error!)
                return
            }
            
            if let results = request.results as? [VNHumanBodyPoseObservation] {
                self.bodyPoints = results
            }
        }
        
        do {
            let handler = VNImageRequestHandler(cgImage: uiImage.cgImage!)
            try handler.perform([request])
        } catch {
            print(error)
        }
    }
}

struct PoseDetect_Previews: PreviewProvider {
    static var previews: some View {
        PoseDetect()
    }
}
