//
//  VisionCoreML.swift
//  VisionDemo
//
//  Created by 朱克剛 on 2022/9/25.
//

import SwiftUI
import Vision

struct VisionCoreML: View {
    private let uiImage = UIImage(named: "dog.jpg")!
    @State private var results: [VNClassificationObservation] = []
    @State private var text: String = ""

    var body: some View {
        VStack {
            Image(uiImage: uiImage)
                .resizable()
                .scaledToFit()
                .clipped()
                .overlay {
                    // 顯示分類結果
                    VStack {
                        HStack() {
                            Text(text)
                                .font(.caption)
                                .foregroundColor(.black)
                                .background(.white.opacity(0.5))
                            Spacer()
                        }
                        Spacer()
                    }
                }
            Button("Analysis") {
                imageClassification()
                text = ""
                results.prefix(2).forEach { result in
                    print(result)
                    let id = result.identifier
                    let conf = round(result.confidence * 1000) / 10
                    text += "\(id) (\(conf)%)\n"
                }
                text = text.trimmingCharacters(in: .newlines)
            }
            .buttonStyle(.bordered)
        }
        .padding()
    }

    private func loadVNModel(_ name: String) throws -> VNCoreMLModel {
        guard let url = Bundle.main.url(
            forResource: name, withExtension: "mlmodelc"
        ) else {
            throw NSError(
                domain: "myerror",
                code: 100,
                userInfo: [NSLocalizedDescriptionKey: "load model error"]
            )
        }
        
        let mlModel = try MLModel(contentsOf: url)
        let vnModel = try VNCoreMLModel(for: mlModel)
        return vnModel
    }
    
    private func imageClassification() {
        do {
//            let model = try loadVNModel("MobileNetV2")
            let model = try loadVNModel("MyImageClassifier")
            let request = VNCoreMLRequest(model: model) { request, error in
                guard error == nil else {
                    print(error!)
                    return
                }
                
                if let results = request.results as? [VNClassificationObservation] {
                    self.results = results
                }
            }
            
            let handler = VNImageRequestHandler(cgImage: uiImage.cgImage!)
            try handler.perform([request])
        } catch {
            print(error.localizedDescription)
        }
    }

}

struct VisionCoreML_Previews: PreviewProvider {
    static var previews: some View {
        VisionCoreML()
    }
}
