SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

DROP TABLE IF EXISTS `fhx_1_blog`;
CREATE TABLE `fhx_1_blog` (
                              `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
                              `catid` smallint(5) unsigned NOT NULL COMMENT '栏目id',
                              `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '主题',
                              `thumb` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '缩略图',
                              `keywords` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '关键字',
                              `description` text COLLATE utf8mb4_unicode_ci COMMENT '描述',
                              `hits` int(10) unsigned DEFAULT NULL COMMENT '浏览数',
                              `uid` int(10) unsigned NOT NULL COMMENT '作者id',
                              `author` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '笔名',
                              `status` tinyint(2) NOT NULL COMMENT '状态(已废弃)',
                              `url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '地址',
                              `link_id` int(10) NOT NULL DEFAULT '0' COMMENT '同步id',
                              `tableid` smallint(5) unsigned NOT NULL COMMENT '附表id',
                              `inputip` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '客户端ip信息',
                              `inputtime` int(10) unsigned NOT NULL COMMENT '录入时间',
                              `updatetime` int(10) unsigned NOT NULL COMMENT '更新时间',
                              `displayorder` int(10) DEFAULT '0' COMMENT '排序值',
                              `support` int(10) unsigned DEFAULT '0' COMMENT '支持数',
                              `oppose` int(10) unsigned DEFAULT '0' COMMENT '反对数',
                              PRIMARY KEY (`id`),
                              KEY `uid` (`uid`),
                              KEY `catid` (`catid`),
                              KEY `link_id` (`link_id`),
                              KEY `status` (`status`),
                              KEY `updatetime` (`updatetime`),
                              KEY `hits` (`hits`),
                              KEY `category` (`catid`,`status`),
                              KEY `displayorder` (`displayorder`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='内容主表';

INSERT INTO `fhx_1_blog` (`id`, `catid`, `title`, `thumb`, `keywords`, `description`, `hits`, `uid`, `author`, `status`, `url`, `link_id`, `tableid`, `inputip`, `inputtime`, `updatetime`, `displayorder`, `support`, `oppose`) VALUES
                                                                                                                                                                                                                                     (1,	4,	'推开新时代PC的大门，英特尔全新“AI处理器”解析',	'1673',	'',	'此前在今年9月，我们三易生活曾经结合当时最新的架构资料，以及所拿到的一些独家内部数据，率先为大家“解析”了英特尔的最新一代移动处理器架构。当然，现在大家都已经知道，当时我们所“解析”的对象就是刚刚发布的第一代酷睿Ultra处理器的某个ES版本。不过平心而论，当时我们拿到的资料毕竟还比较早期，所以它尽管已经讲得十分详细，但距离最终上市的版本还是有着一些差距，这也就是为什么我们非常要关注2023年12',	3,	1,	'创始人',	9,	'/index.php?c=show&id=1',	0,	0,	'127.0.0.1-54073',	1702706320,	1702706320,	0,	0,	0),
                                                                                                                                                                                                                                     (2,	5,	'如何运行Stable Diffusion？在线和本地运行的5种方法',	'1674',	'',	'Stable Diffusion是由初创公司Stability AI和来自慕尼黑大学以及Runway的研究人员在2022年发布的文本到图像的生成模型，支持文生图、图生图、修改图像、填充低分辨率图像等功能。由于其免费开源，并且生成的图片质量较高，因此广受创作者的喜爱。本篇文章将讲解如何在线和本地运行Stable Diffusion，让你快速上手生成想要的图片。如何在线运行Stable Diffusi',	6,	1,	'创始人',	9,	'/index.php?c=show&id=2',	0,	0,	'127.0.0.1-62265',	1702711042,	1702711042,	0,	0,	0),
                                                                                                                                                                                                                                     (3,	4,	'Imagen2官网体验入口 谷歌AI文生图软件app免费下载地址',	'/uploadfile/202312/9937421eaa24b27.jpg',	'AI文生图软件',	'Imagen2 是Google DeepMind开发的最先进的文本到图像扩散技术产品，可生成高品质、逼真的图像，与用户的文字提示紧密对齐。这款技术利用其训练数据的自然分布生成更逼真的图像，而不是采用预设的风格。开发者和Cloud客户可以通过Google Cloud Vertex AI上的Imagen API体验Imagen2 的强大功能。Google艺术与文化团队也在他们的「文化图标」实验中部署了',	9,	1,	'创始人',	9,	'/index.php?c=show&id=3',	0,	0,	'127.0.0.1-64832',	1702712624,	1702712624,	0,	0,	0),
                                                                                                                                                                                                                                     (4,	4,	'roomGPT官网体验入口 AI家居设计软件app免费下载地址',	'/uploadfile/202312/9c662823202bdb0.png',	'AI家居设计软件,预测',	'roomGPT是一款创新的AI技术产品，专为家居设计和房间改造而设计。它允许用户上传现有的房间照片，然后利用先进的AI技术生成多种风格的房间设计效果供用户选择。那么，你在哪里可以体验这项服务呢？下面就给大家带来roomGPT官网体验入口和免费app下载地址。点击前往roomGPT官网体验入口roomGPT使用控制网(ControlNet)机器学习模型，可以生成房间的不同变体，包括中式风格、欧式风格',	13,	1,	'创始人',	9,	'/index.php?c=show&id=4',	0,	0,	'127.0.0.1-49498',	1702712944,	1702733609,	0,	0,	0),
                                                                                                                                                                                                                                     (5,	4,	'突破性AI方法WHAM：精确有效地预测视频中3D人体运动',	'/uploadfile/202312/b2373ea98e815fd.png',	'预测,3D运动',	'在最新的研究中，卡内基梅隆大学（CMU）和马克斯·普朗克智能系统研究所的研究人员共同发布了一项名为WHAM(World-grounded Humans with Accurate Motion)的创新性AI方法。这一方法在精准性和效率方面实现了从视频中准确估计3D人体运动的突破。3D人体运动重建是一个复杂的过程，涉及准确捕捉和建模人体在三维空间中的运动。当处理由移动摄像机在现实世界环境中拍摄的视频',	12,	1,	'创始人',	9,	'/index.php?c=show&id=5',	0,	0,	'127.0.0.1-56116',	1702718420,	1702718420,	0,	1,	0);

DROP TABLE IF EXISTS `fhx_1_blog_category`;
CREATE TABLE `fhx_1_blog_category` (
                                       `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
                                       `pid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '上级id',
                                       `pids` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '所有上级id',
                                       `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '栏目名称',
                                       `dirname` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '栏目目录',
                                       `pdirname` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '上级目录',
                                       `child` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否有下级',
                                       `disabled` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否禁用',
                                       `ismain` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否主栏目',
                                       `childids` text COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '下级所有id',
                                       `thumb` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '栏目图片',
                                       `show` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否显示',
                                       `setting` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '属性配置',
                                       `displayorder` mediumint(8) NOT NULL DEFAULT '0',
                                       PRIMARY KEY (`id`),
                                       KEY `show` (`show`),
                                       KEY `disabled` (`disabled`),
                                       KEY `ismain` (`ismain`),
                                       KEY `module` (`pid`,`displayorder`,`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='栏目表';


DROP TABLE IF EXISTS `fhx_1_blog_category_data`;
CREATE TABLE `fhx_1_blog_category_data` (
                                            `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
                                            `uid` mediumint(8) unsigned NOT NULL COMMENT '作者uid',
                                            `catid` int(3) unsigned NOT NULL COMMENT '栏目id',
                                            PRIMARY KEY (`id`),
                                            KEY `uid` (`uid`),
                                            KEY `catid` (`catid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='栏目模型表';


DROP TABLE IF EXISTS `fhx_1_blog_data_0`;
CREATE TABLE `fhx_1_blog_data_0` (
                                     `id` int(10) unsigned NOT NULL,
                                     `uid` mediumint(8) unsigned NOT NULL COMMENT '作者uid',
                                     `catid` smallint(5) unsigned NOT NULL COMMENT '栏目id',
                                     `content` mediumtext COLLATE utf8mb4_unicode_ci COMMENT '内容',
                                     UNIQUE KEY `id` (`id`),
                                     KEY `uid` (`uid`),
                                     KEY `catid` (`catid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='内容附表';

INSERT INTO `fhx_1_blog_data_0` (`id`, `uid`, `catid`, `content`) VALUES
                                                                      (1,	1,	4,	'&lt;p style=&quot;text-align: center; &quot;&gt;&lt;img  title=&quot;201811151633430117_47&quot; alt=&quot;201811151633430117_47&quot; src=&quot;/uploadfile/202312/4db1e8b72707c27.jpg&quot;&gt;&lt;/p&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 28px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; font-size: 16px; line-height: 32px; text-align: justify; color: rgb(59, 59, 59); word-break: break-word; font-family: &amp;quot;PingFang SC&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, Helvetica, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; letter-spacing: 0.5px;&quot;&gt;此前在今年9月，我们三易生活曾经结合当时&lt;span class=&quot;spamTxt&quot; style=&quot;margin: 0px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000;&quot;&gt;最新&lt;/span&gt;的架构资料，以及所拿到的一些&lt;span class=&quot;spamTxt&quot; style=&quot;margin: 0px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000;&quot;&gt;独家&lt;/span&gt;内部数据，率先为大家“解析”了&lt;a href=&quot;https://www.chinaz.com/tags/yingteer.shtml&quot; target=&quot;_blank&quot; style=&quot;margin: 0px; padding: 0px 0px 2px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; color: rgb(66, 66, 66); position: relative; z-index: 0; cursor: pointer;&quot;&gt;&lt;span style=&quot;margin: 0px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000;&quot;&gt;英特尔&lt;/span&gt;&lt;/a&gt;的&lt;span class=&quot;spamTxt&quot; style=&quot;margin: 0px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000;&quot;&gt;最新&lt;/span&gt;一代移动处理器架构。&lt;/p&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 28px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; font-size: 16px; line-height: 32px; text-align: justify; color: rgb(59, 59, 59); word-break: break-word; font-family: &amp;quot;PingFang SC&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, Helvetica, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; letter-spacing: 0.5px;&quot;&gt;当然，现在大家都已经知道，当时我们所“解析”的对象就是刚刚发布的&lt;span class=&quot;spamTxt&quot; style=&quot;margin: 0px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000;&quot;&gt;第一&lt;/span&gt;代酷睿Ultra处理器的某个ES版本。&lt;/p&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 28px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; font-size: 16px; line-height: 32px; text-align: justify; color: rgb(59, 59, 59); word-break: break-word; font-family: &amp;quot;PingFang SC&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, Helvetica, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; letter-spacing: 0.5px;&quot;&gt;不过平心而论，当时我们拿到的资料毕竟还比较早期，所以它尽管已经讲得十分详细，但距离最终上市的版本还是有着一些差距，这也就是为什么我们非常要关注2023年12月15日英特尔这场新品发布会的原因。以结果来说，这次活动也确实没有令我们失望。&lt;/p&gt;&lt;ul style=&quot;margin-right: 0px; margin-left: 0px; padding: 0px 0px 0px 20px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; list-style: none; color: rgb(42, 42, 42); font-family: ui-sans-serif, system-ui, -apple-system, BlinkMacSystemFont, &amp;quot;Segoe UI&amp;quot;, Roboto, &amp;quot;Helvetica Neue&amp;quot;, Arial, &amp;quot;Noto Sans&amp;quot;, sans-serif, &amp;quot;Apple Color Emoji&amp;quot;, &amp;quot;Segoe UI Emoji&amp;quot;, &amp;quot;Segoe UI Symbol&amp;quot;, &amp;quot;Noto Color Emoji&amp;quot;; font-size: 16px;&quot;&gt;&lt;li style=&quot;margin: 0px 0px 0px 5px; padding: 0px 0px 0px 20px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; list-style: none; line-height: 2.4; position: relative;&quot;&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 28px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; line-height: 32px; text-align: justify; color: rgb(59, 59, 59); word-break: break-word; font-family: &amp;quot;PingFang SC&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, Helvetica, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; letter-spacing: 0.5px;&quot;&gt;&lt;strong style=&quot;margin: 0px; padding: 0px; outline: 0px; border: 0px; --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; color: rgb(20, 20, 20); white-space-collapse: preserve; display: inline; background: rgb(249, 250, 251);&quot;&gt;更大、更强，第五代可扩展至强“大杀器”登场&lt;/strong&gt;&lt;/p&gt;&lt;/li&gt;&lt;/ul&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 28px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; font-size: 16px; line-height: 32px; text-align: justify; color: rgb(59, 59, 59); word-break: break-word; font-family: &amp;quot;PingFang SC&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, Helvetica, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; letter-spacing: 0.5px;&quot;&gt;不得不说，英特尔此次新品发布会与以往相比&lt;span class=&quot;spamTxt&quot; style=&quot;margin: 0px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000;&quot;&gt;最大&lt;/span&gt;的一点不同，就在于他们几乎是&lt;span class=&quot;spamTxt&quot; style=&quot;margin: 0px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000;&quot;&gt;首次&lt;/span&gt;将面向企业的云端服务器CPU新品，和面向消费者的端侧计算设备CPU新品放到了一起。&lt;/p&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 28px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; font-size: 16px; line-height: 32px; text-align: justify; color: rgb(59, 59, 59); word-break: break-word; font-family: &amp;quot;PingFang SC&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, Helvetica, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; letter-spacing: 0.5px;&quot;&gt;首先亮相的，是第五代至强可扩展处理器。根据相关技术资料显示，与第四代至强可扩展处理器相比，代号“Emerald Rapide-SP”的新CPU依然沿用了Intel7制程，但对架构进行了大幅度的重新设计。&lt;/p&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 28px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; font-size: 16px; line-height: 32px; text-align: justify; color: rgb(59, 59, 59); word-break: break-word; font-family: &amp;quot;PingFang SC&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, Helvetica, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; letter-spacing: 0.5px;&quot;&gt;此次亮相的第五代至强可扩展处理器“完整规格”，拥有64颗、而不再是上代的60颗内核，并且这些核心现在被分为2个MCM模块、而不再是上代的4个。这也就意味着新架构的每一个CPU模块，都具备了相当于上代2倍还多的内核数量。&lt;/p&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 28px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; font-size: 16px; line-height: 32px; text-align: justify; color: rgb(59, 59, 59); word-break: break-word; font-family: &amp;quot;PingFang SC&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, Helvetica, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; letter-spacing: 0.5px;&quot;&gt;在此基础上，第五代至强可扩展处理器的基本架构也从Golden Cove更新到了Raptor Cove，这就意味着它与大家熟悉的13代、14代酷睿一样，对缓存和内存子系统进行了大幅度的增强。比如将新款的Xeon8592+与前代Xeon8490H对比就会发现，它的L3Cache从112.5MB一口气增加到了320MB。同时与前代的DDR5-4800相比，八通道DDR5-5600起步的内存频率，也代表其内存带宽得到了显著的增强。&lt;/p&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 28px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; font-size: 16px; line-height: 32px; text-align: justify; color: rgb(59, 59, 59); word-break: break-word; font-family: &amp;quot;PingFang SC&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, Helvetica, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; letter-spacing: 0.5px;&quot;&gt;当然，以上的这些架构、性能改进，主要服务的都是诸如京东、阿里、百度这样的云服务厂商。也就是说，它的作用在于加速如今AI大模型在云端的迭代和应用效率。但除此之外，大家都知道英特尔还有一个相对“民用”、面向发烧友的产品线Xeon W，所以第五代可扩展至强的架构，实际上也相当于变相预告了下一代Xeon W的诸多信息。&lt;/p&gt;&lt;ul style=&quot;margin-right: 0px; margin-left: 0px; padding: 0px 0px 0px 20px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; list-style: none; color: rgb(42, 42, 42); font-family: ui-sans-serif, system-ui, -apple-system, BlinkMacSystemFont, &amp;quot;Segoe UI&amp;quot;, Roboto, &amp;quot;Helvetica Neue&amp;quot;, Arial, &amp;quot;Noto Sans&amp;quot;, sans-serif, &amp;quot;Apple Color Emoji&amp;quot;, &amp;quot;Segoe UI Emoji&amp;quot;, &amp;quot;Segoe UI Symbol&amp;quot;, &amp;quot;Noto Color Emoji&amp;quot;; font-size: 16px;&quot;&gt;&lt;li style=&quot;margin: 0px 0px 0px 5px; padding: 0px 0px 0px 20px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; list-style: none; line-height: 2.4; position: relative;&quot;&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 28px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; line-height: 32px; text-align: justify; color: rgb(59, 59, 59); word-break: break-word; font-family: &amp;quot;PingFang SC&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, Helvetica, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; letter-spacing: 0.5px;&quot;&gt;&lt;strong style=&quot;margin: 0px; padding: 0px; outline: 0px; border: 0px; --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; color: rgb(20, 20, 20); white-space-collapse: preserve; display: inline; background: rgb(249, 250, 251);&quot;&gt;更多核心、更强核显、还有NPU，酷睿Ultra来了&lt;/strong&gt;&lt;/p&gt;&lt;/li&gt;&lt;/ul&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 28px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; font-size: 16px; line-height: 32px; text-align: justify; color: rgb(59, 59, 59); word-break: break-word; font-family: &amp;quot;PingFang SC&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, Helvetica, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; letter-spacing: 0.5px;&quot;&gt;接下来就是此次发布会的重头戏，全新的英特尔酷睿Ultra处理器了。&lt;/p&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 28px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; font-size: 16px; line-height: 32px; text-align: justify; color: rgb(59, 59, 59); word-break: break-word; font-family: &amp;quot;PingFang SC&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, Helvetica, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; letter-spacing: 0.5px;&quot;&gt;首先在架构上，&lt;span class=&quot;spamTxt&quot; style=&quot;margin: 0px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000;&quot;&gt;第一&lt;/span&gt;代酷睿Ultra是英特尔旗下&lt;span class=&quot;spamTxt&quot; style=&quot;margin: 0px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000;&quot;&gt;首款&lt;/span&gt;采用了多模块、多制程混合封装设计的处理器。它的每一颗核心拥有四个模块，分别是采用Intel4制程的CPU模块、采用台积电5nm制程的GPU模块，以及采用台积电6nm制程的SoC模块、和同样是基于台积电6nm制程的IO模块。&lt;/p&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 28px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; font-size: 16px; line-height: 32px; text-align: justify; color: rgb(59, 59, 59); word-break: break-word; font-family: &amp;quot;PingFang SC&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, Helvetica, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; letter-spacing: 0.5px;&quot;&gt;这样的设计有什么好处呢?一方面它可以让处理器集成更多的功能组件。比如以这一代定位&lt;span class=&quot;spamTxt&quot; style=&quot;margin: 0px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000;&quot;&gt;最高&lt;/span&gt;的酷睿i9-185H为例，它的CPU模块集成了6P+8E、总共14颗CPU核心，同时在SoC模块里还有2颗额外的E核，可以在运行极低负载时完全关闭CPU模块，从而达到更省电的目的。&lt;/p&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 28px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; font-size: 16px; line-height: 32px; text-align: justify; color: rgb(59, 59, 59); word-break: break-word; font-family: &amp;quot;PingFang SC&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, Helvetica, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; letter-spacing: 0.5px;&quot;&gt;又比如说，酷睿Ultra的ARC GPU模块现在拥有更“全”的Xe架构。它最多拥有128个执行单元（而非前代的96个），运行频率可以高达2250MHz，并拥有64个纹理单元和32个光栅单元，此外还支持硬件光追和XeSS硬件AI超分抗锯齿。在这样的配置下，新的核显FP32性能可以高达4.608TFlops，相当于前代的整整两倍。&lt;/p&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 28px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; font-size: 16px; line-height: 32px; text-align: justify; color: rgb(59, 59, 59); word-break: break-word; font-family: &amp;quot;PingFang SC&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, Helvetica, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; letter-spacing: 0.5px;&quot;&gt;除此之外，酷睿Ultra也成为了英特尔&lt;span class=&quot;spamTxt&quot; style=&quot;margin: 0px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000;&quot;&gt;首款&lt;/span&gt;集成NPU的移动处理器方案，根据相关技术资料显示，它的NPU算力可达10TOPs。与此同时，其还集成了雷电4控制器。&lt;/p&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 28px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; font-size: 16px; line-height: 32px; text-align: justify; color: rgb(59, 59, 59); word-break: break-word; font-family: &amp;quot;PingFang SC&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, Helvetica, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; letter-spacing: 0.5px;&quot;&gt;除了架构、设计上的大幅改进，酷睿Ultra此次还有一个非常值得关注的亮点，那就是它标压版本的默认TDP仅28-45W，&lt;span class=&quot;spamTxt&quot; style=&quot;margin: 0px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000;&quot;&gt;最大&lt;/span&gt;TDP也不过115W。要知道自11代开始，标压的移动版酷睿已经很久没有过如此低的官方TDP参数了，诸如14900HX这样的高端标压移动CPU，更是有着157W的官方&lt;span class=&quot;spamTxt&quot; style=&quot;margin: 0px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000;&quot;&gt;最高&lt;/span&gt;TDP设定。从目前各个渠道曝光的相关信息来看，超高的能效比很可能会是&lt;span class=&quot;spamTxt&quot; style=&quot;margin: 0px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000;&quot;&gt;第一&lt;/span&gt;代酷睿Ultra在实际使用中的突出亮点。&lt;/p&gt;&lt;ul style=&quot;margin-right: 0px; margin-left: 0px; padding: 0px 0px 0px 20px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; list-style: none; color: rgb(42, 42, 42); font-family: ui-sans-serif, system-ui, -apple-system, BlinkMacSystemFont, &amp;quot;Segoe UI&amp;quot;, Roboto, &amp;quot;Helvetica Neue&amp;quot;, Arial, &amp;quot;Noto Sans&amp;quot;, sans-serif, &amp;quot;Apple Color Emoji&amp;quot;, &amp;quot;Segoe UI Emoji&amp;quot;, &amp;quot;Segoe UI Symbol&amp;quot;, &amp;quot;Noto Color Emoji&amp;quot;; font-size: 16px;&quot;&gt;&lt;li style=&quot;margin: 0px 0px 0px 5px; padding: 0px 0px 0px 20px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; list-style: none; line-height: 2.4; position: relative;&quot;&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 28px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; line-height: 32px; text-align: justify; color: rgb(59, 59, 59); word-break: break-word; font-family: &amp;quot;PingFang SC&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, Helvetica, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; letter-spacing: 0.5px;&quot;&gt;&lt;strong style=&quot;margin: 0px; padding: 0px; outline: 0px; border: 0px; --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; color: rgb(20, 20, 20); white-space-collapse: preserve; display: inline; background: rgb(249, 250, 251);&quot;&gt;如何让“AI &lt;a href=&quot;https://www.chinaz.com/tags/PC.shtml&quot; target=&quot;_blank&quot; style=&quot;margin: 0px; padding: 0px 0px 2px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; color: rgb(66, 66, 66); position: relative; z-index: 0; cursor: pointer;&quot;&gt;&lt;span style=&quot;margin: 0px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000;&quot;&gt;PC&lt;/span&gt;&lt;/a&gt;”真正实用，英特尔确实带了个好头&lt;/strong&gt;&lt;/p&gt;&lt;/li&gt;&lt;/ul&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 28px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; font-size: 16px; line-height: 32px; text-align: justify; color: rgb(59, 59, 59); word-break: break-word; font-family: &amp;quot;PingFang SC&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, Helvetica, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; letter-spacing: 0.5px;&quot;&gt;如果大家有关注最近的相关信息想必知道，其实英特尔的竞争对手，比如高通、超微，在此前就发布了具备独立NPU的移动CPU产品线。相比之下，英特尔的酷睿Ultra系列反而算是来得比较晚的了。&lt;/p&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 28px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; font-size: 16px; line-height: 32px; text-align: justify; color: rgb(59, 59, 59); word-break: break-word; font-family: &amp;quot;PingFang SC&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, Helvetica, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; letter-spacing: 0.5px;&quot;&gt;但这并不意味着英特尔在“AI PC”的技术路线上，起步得就比竞争对手晚。实际上，早在2019年英特尔就已经在当时的酷睿X系列处理器（Cascade Lake）里，&lt;span class=&quot;spamTxt&quot; style=&quot;margin: 0px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000;&quot;&gt;首次&lt;/span&gt;加入了用于加速深度学习计算的DL Boost指令集。&lt;/p&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 28px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; font-size: 16px; line-height: 32px; text-align: justify; color: rgb(59, 59, 59); word-break: break-word; font-family: &amp;quot;PingFang SC&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, Helvetica, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; letter-spacing: 0.5px;&quot;&gt;后续到了10代、11代酷睿移动版上，DL Boost和AVX-512指令集进一步被普及到更多的普及型产品上，从而使得当时的许多笔记本电脑产品就具备了类似摄像头居中、麦克风降噪、视频超分这类AI体验。&lt;/p&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 28px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; font-size: 16px; line-height: 32px; text-align: justify; color: rgb(59, 59, 59); word-break: break-word; font-family: &amp;quot;PingFang SC&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, Helvetica, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; letter-spacing: 0.5px;&quot;&gt;后续随着英特尔方面将Xe架构引入酷睿处理器的核显，这些核显实际上也具备了AI加速能力。比如在一些12代、13代酷睿的笔记本、甚至台式PC上，就都能够看到基于核显算力去实现的AI语音助手、AI背景虚化等功能。&lt;/p&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 28px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; font-size: 16px; line-height: 32px; text-align: justify; color: rgb(59, 59, 59); word-break: break-word; font-family: &amp;quot;PingFang SC&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, Helvetica, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; letter-spacing: 0.5px;&quot;&gt;正因如此，在&lt;span class=&quot;spamTxt&quot; style=&quot;margin: 0px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000;&quot;&gt;第一&lt;/span&gt;代酷睿Ultra处理器里，虽然表面上看，它的“AI单元”好像就是一个NPU。但实际上，英特尔早就搞定了让CPU、GPU、NPU根据不同代码承担不同AI任务、有时甚至可以协同计算的异构加速体系，并且他们将这种技术称之为“XPU”。&lt;/p&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 28px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; font-size: 16px; line-height: 32px; text-align: justify; color: rgb(59, 59, 59); word-break: break-word; font-family: &amp;quot;PingFang SC&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, Helvetica, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; letter-spacing: 0.5px;&quot;&gt;而且更为重要的是，在今天的发布会上可以看到，英特尔已经拉来了大量的国内软件厂商，演示了他们的产品在酷睿Ultra上通过AI加速运行的效果。据英特尔方面的说法，即便在这个产品才刚刚发布的时间点上，酷睿Ultra就已经得到了超过100款以上软件的官方适配，可以发挥出AI的加&lt;span class=&quot;spamTxt&quot; style=&quot;margin: 0px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000;&quot;&gt;速效&lt;/span&gt;果来。&lt;/p&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 28px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; font-size: 16px; line-height: 32px; text-align: justify; color: rgb(59, 59, 59); word-break: break-word; font-family: &amp;quot;PingFang SC&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, Helvetica, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; letter-spacing: 0.5px;&quot;&gt;不得不说，比起单纯往CPU里塞硬件AI加速单元，英特尔这套独特的异构处理设计，以及他们为推动“AI PC”普及而进行的大量适配，可能才是酷睿Ultra与竞争对手相比最为明显的优势所在。&lt;/p&gt;'),
                                                                      (2,	1,	5,	'&lt;p&gt;&lt;span style=&quot;color: rgb(29, 35, 43); font-family: -apple-system, BlinkMacSystemFont, &amp;quot;Segoe UI&amp;quot;, Roboto, &amp;quot;Helvetica Neue&amp;quot;, Arial, &amp;quot;Noto Sans&amp;quot;, &amp;quot;Liberation Sans&amp;quot;, sans-serif, &amp;quot;Apple Color Emoji&amp;quot;, &amp;quot;Segoe UI Emoji&amp;quot;, &amp;quot;Segoe UI Symbol&amp;quot;, &amp;quot;Noto Color Emoji&amp;quot;; font-size: 16px;&quot;&gt;Stable Diffusion是由初创公司Stability AI和来自慕尼黑大学以及Runway的研究人员在2022年发布的文本到图像的生成模型，支持文生图、图生图、修改图像、填充低分辨率图像等功能。由于其免费开源，并且生成的图片质量较高，因此广受创作者的喜爱。本篇文章将讲解如何在线和本地运行Stable Diffusion，让你快速上手生成想要的图片。&lt;/span&gt;&lt;/p&gt;&lt;div class=&quot;panel-body single mt-2&quot; style=&quot;color: rgb(40, 42, 45); font-family: -apple-system, BlinkMacSystemFont, &amp;quot;Segoe UI&amp;quot;, Roboto, &amp;quot;Helvetica Neue&amp;quot;, Arial, &amp;quot;Noto Sans&amp;quot;, &amp;quot;Liberation Sans&amp;quot;, sans-serif, &amp;quot;Apple Color Emoji&amp;quot;, &amp;quot;Segoe UI Emoji&amp;quot;, &amp;quot;Segoe UI Symbol&amp;quot;, &amp;quot;Noto Color Emoji&amp;quot;; font-size: 16px; user-select: text !important; margin-top: 0.5rem !important;&quot;&gt;&lt;h2 id=&quot;run-stable-diffusion-online&quot; style=&quot;margin-top: 0px; margin-bottom: 1rem; line-height: 1.2; font-size: 1.25rem; -webkit-font-smoothing: antialiased; border-left: 3px solid rgb(89, 97, 249); padding: 0.25rem 0px 0.25rem 1.25rem; margin-left: -1.438rem; border-top-color: rgb(89, 97, 249); border-right-color: rgb(89, 97, 249); border-bottom-color: rgb(89, 97, 249); user-select: text !important;&quot;&gt;如何在线运行Stable Diffusion&lt;/h2&gt;&lt;h3 id=&quot;dreamstudio&quot; style=&quot;margin-top: 0px; margin-bottom: 1rem; line-height: 1.2; font-size: 1.125rem; -webkit-font-smoothing: antialiased; border-left: 3px solid rgb(89, 97, 249); padding-left: 1.25rem; margin-left: -1.438rem; border-top-color: rgb(89, 97, 249); border-right-color: rgb(89, 97, 249); border-bottom-color: rgb(89, 97, 249); user-select: text !important;&quot;&gt;DreamStudio&lt;/h3&gt;&lt;a class=&quot;js&quot; href=&quot;https://ai-bot.cn/wp-content/uploads/2023/07/dream-studio-ai-image.png&quot; data-fancybox=&quot;fancybox&quot; data-caption=&quot;Dream Studio Stable Diffusion&quot; style=&quot;color: rgb(89, 97, 249); user-select: text !important; outline: 0px !important;&quot;&gt;&lt;img decoding=&quot;async&quot; class=&quot;alignnone wp-image-3179 size-full loaded&quot; data-src=&quot;https://ai-bot.cn/wp-content/uploads/2023/07/dream-studio-ai-image.png&quot; src=&quot;https://ai-bot.cn/wp-content/uploads/2023/07/dream-studio-ai-image.png&quot; alt=&quot;Dream Studio Stable Diffusion&quot; width=&quot;800&quot; height=&quot;450&quot; data-was-processed=&quot;true&quot; style=&quot;border-width: 2px; border-style: solid; border-color: rgb(238, 238, 238); margin: 5px 0px 20px; max-width: 100%; height: auto; border-radius: 6px; user-select: none !important;&quot;&gt;&lt;/a&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 1.25rem; color: rgb(29, 35, 43); font-size: 1rem; line-height: 2; overflow-wrap: break-word; user-select: text !important;&quot;&gt;DreamStudio是StabilityAI公司官方推出的方便用户生成图像的网站应用程序，基于Stable Diffusion模型，用户可输入自然语言和更改调节参数控件来创建自定义图像，还支持API访问以在自己开发的应用程序或机器人中使用。注册登录DreamStudio后，可以获得免费赠送的25积分，大约可以生成30张标准图像，若需更多的生成次数，可付费购买，10美元可购买1000积分。&lt;/p&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 1.25rem; color: rgb(29, 35, 43); font-size: 1rem; line-height: 2; overflow-wrap: break-word; user-select: text !important;&quot;&gt;官网地址：&lt;a href=&quot;https://beta.dreamstudio.ai/generate&quot; target=&quot;_blank&quot; rel=&quot;noopener nofollow&quot; class=&quot;external&quot; style=&quot;color: rgb(89, 97, 249); padding-right: 5px; user-select: text !important; outline: 0px !important;&quot;&gt;https://beta.dreamstudio.ai/generate&lt;/a&gt;&lt;/p&gt;&lt;h3 id=&quot;clipdrop-stable-diffusion-xl&quot; style=&quot;margin-top: 0px; margin-bottom: 1rem; line-height: 1.2; font-size: 1.125rem; -webkit-font-smoothing: antialiased; border-left: 3px solid rgb(89, 97, 249); padding-left: 1.25rem; margin-left: -1.438rem; border-top-color: rgb(89, 97, 249); border-right-color: rgb(89, 97, 249); border-bottom-color: rgb(89, 97, 249); user-select: text !important;&quot;&gt;Clipdrop Stable Diffusion XL&lt;/h3&gt;&lt;a class=&quot;js&quot; href=&quot;https://ai-bot.cn/wp-content/uploads/2023/07/clipdrop-stable-diffusion-xl.png&quot; data-fancybox=&quot;fancybox&quot; data-caption=&quot;Clipdrop Stable Diffusion XL&quot; style=&quot;color: rgb(89, 97, 249); user-select: text !important; outline: 0px !important;&quot;&gt;&lt;img decoding=&quot;async&quot; class=&quot;alignnone size-full wp-image-3181 loaded&quot; data-src=&quot;https://ai-bot.cn/wp-content/uploads/2023/07/clipdrop-stable-diffusion-xl.png&quot; src=&quot;https://ai-bot.cn/wp-content/uploads/2023/07/clipdrop-stable-diffusion-xl.png&quot; alt=&quot;Clipdrop Stable Diffusion XL&quot; width=&quot;800&quot; height=&quot;450&quot; data-was-processed=&quot;true&quot; style=&quot;border-width: 2px; border-style: solid; border-color: rgb(238, 238, 238); margin: 5px 0px 20px; max-width: 100%; height: auto; border-radius: 6px; user-select: none !important;&quot;&gt;&lt;/a&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 1.25rem; color: rgb(29, 35, 43); font-size: 1rem; line-height: 2; overflow-wrap: break-word; user-select: text !important;&quot;&gt;Clipdrop是StabilityAI推出的一系列AI图像处理工具套件，支持图片抹除、图片放大、图片打光、背景移除、背景替换、缩放填充等AI图片功能。除了这些功能外，Clipdrop支持了最新的Stable Diffusion XL版本，用户可以访问其网站，输入prompt文本描述，选择图像风格，点击Generate按钮即可生成图片。目前，免费版的Clipdrop允许用户每天使用Stable Diffusion XL生成400张图片，右下角会带有个Clipdrop的小水印。如果想要更多的生成次数和去除水印，可以考虑升级到Clipdrop的高级版本，付费后可以每天生成1500张图片，并且可以无限使用其他的AI功能。&lt;/p&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 1.25rem; color: rgb(29, 35, 43); font-size: 1rem; line-height: 2; overflow-wrap: break-word; user-select: text !important;&quot;&gt;官网地址：&lt;a href=&quot;https://clipdrop.co/stable-diffusion&quot; target=&quot;_blank&quot; rel=&quot;noopener nofollow&quot; class=&quot;external&quot; style=&quot;color: rgb(89, 97, 249); padding-right: 5px; user-select: text !important; outline: 0px !important;&quot;&gt;https://clipdrop.co/stable-diffusion&lt;/a&gt;&lt;/p&gt;&lt;h3 id=&quot;hugging-face-stable-diffusion&quot; style=&quot;margin-top: 0px; margin-bottom: 1rem; line-height: 1.2; font-size: 1.125rem; -webkit-font-smoothing: antialiased; border-left: 3px solid rgb(89, 97, 249); padding-left: 1.25rem; margin-left: -1.438rem; border-top-color: rgb(89, 97, 249); border-right-color: rgb(89, 97, 249); border-bottom-color: rgb(89, 97, 249); user-select: text !important;&quot;&gt;Hugging Face&lt;/h3&gt;&lt;a class=&quot;js&quot; href=&quot;http://aidh.laikephp.cn/uploadfile/202312/80f99da40539701.png&quot; data-fancybox=&quot;fancybox&quot; data-caption=&quot;Hugging Face Stable Diffusion&quot; style=&quot;color: rgb(89, 97, 249); user-select: text !important; outline: 0px !important;&quot;&gt;&lt;img decoding=&quot;async&quot; class=&quot;alignnone size-full wp-image-3186 loaded&quot; data-src=&quot;http://aidh.laikephp.cn/uploadfile/202312/80f99da40539701.png&quot; src=&quot;http://aidh.laikephp.cn/uploadfile/202312/80f99da40539701.png&quot; alt=&quot;Hugging Face Stable Diffusion&quot; width=&quot;800&quot; height=&quot;450&quot; data-was-processed=&quot;true&quot; style=&quot;border-width: 2px; border-style: solid; border-color: rgb(238, 238, 238); margin: 5px 0px 20px; max-width: 100%; height: auto; border-radius: 6px; user-select: none !important;&quot;&gt;&lt;/a&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 1.25rem; color: rgb(29, 35, 43); font-size: 1rem; line-height: 2; overflow-wrap: break-word; user-select: text !important;&quot;&gt;Hugging Face是知名的开源AI模型社区，平台上汇集了全球各大知名AI模型，用户可以通过Hugging Face下载AI模型的数据集，也可以直接在线运行查看实时效果。Hugging Face上的Stable Diffusion由StabilityAI官方创建，目前是2.1版本，用户可直接输入描述，点击Generate image便可以生成图片。由于Hugging Face的用户量巨大，所以生成图片的速度可能较慢，大概需要10秒及以上。&lt;/p&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 1.25rem; color: rgb(29, 35, 43); font-size: 1rem; line-height: 2; overflow-wrap: break-word; user-select: text !important;&quot;&gt;官网地址：&lt;a href=&quot;https://huggingface.co/spaces/stabilityai/stable-diffusion&quot; target=&quot;_blank&quot; rel=&quot;noopener nofollow&quot; class=&quot;external&quot; style=&quot;color: rgb(89, 97, 249); padding-right: 5px; user-select: text !important; outline: 0px !important;&quot;&gt;https://huggingface.co/spaces/stabilityai/stable-diffusion&lt;/a&gt;&lt;/p&gt;&lt;h3 id=&quot;replicate-stable-diffusion&quot; style=&quot;margin-top: 0px; margin-bottom: 1rem; line-height: 1.2; font-size: 1.125rem; -webkit-font-smoothing: antialiased; border-left: 3px solid rgb(89, 97, 249); padding-left: 1.25rem; margin-left: -1.438rem; border-top-color: rgb(89, 97, 249); border-right-color: rgb(89, 97, 249); border-bottom-color: rgb(89, 97, 249); user-select: text !important;&quot;&gt;Replicate&lt;/h3&gt;&lt;a class=&quot;js&quot; href=&quot;https://ai-bot.cn/wp-content/uploads/2023/07/replicate-stable-diffusion.png&quot; data-fancybox=&quot;fancybox&quot; data-caption=&quot;Replicate Stable Diffusion&quot; style=&quot;color: rgb(89, 97, 249); user-select: text !important; outline: 0px !important;&quot;&gt;&lt;img decoding=&quot;async&quot; class=&quot;alignnone size-full wp-image-3187 loaded&quot; data-src=&quot;https://ai-bot.cn/wp-content/uploads/2023/07/replicate-stable-diffusion.png&quot; src=&quot;https://ai-bot.cn/wp-content/uploads/2023/07/replicate-stable-diffusion.png&quot; alt=&quot;Replicate Stable Diffusion&quot; width=&quot;800&quot; height=&quot;450&quot; data-was-processed=&quot;true&quot; style=&quot;border-width: 2px; border-style: solid; border-color: rgb(238, 238, 238); margin: 5px 0px 20px; max-width: 100%; height: auto; border-radius: 6px; user-select: none !important;&quot;&gt;&lt;/a&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 1.25rem; color: rgb(29, 35, 43); font-size: 1rem; line-height: 2; overflow-wrap: break-word; user-select: text !important;&quot;&gt;Replicate是一个帮助用户快速运行开源机器学习模型的平台，如语言模型、视频创作和编辑、图片分辨率提高、图像修复、图片文字互转等，用户只需添加几行代码，便可以快速开发属于自己的AI应用。Replicate的平台上同样提供了Stable Diffusion的在线运行环境，相比于Hugging Face，Replicate的生成速度更快。&lt;/p&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 1.25rem; color: rgb(29, 35, 43); font-size: 1rem; line-height: 2; overflow-wrap: break-word; user-select: text !important;&quot;&gt;官网地址：&lt;a href=&quot;https://replicate.com/stability-ai/stable-diffusion&quot; target=&quot;_blank&quot; rel=&quot;noopener nofollow&quot; class=&quot;external&quot; style=&quot;color: rgb(89, 97, 249); padding-right: 5px; user-select: text !important; outline: 0px !important;&quot;&gt;https://replicate.com/stability-ai/stable-diffusion&lt;/a&gt;&lt;/p&gt;&lt;h2 id=&quot;run-stable-diffusion-local&quot; style=&quot;margin-top: 0px; margin-bottom: 1rem; line-height: 1.2; font-size: 1.25rem; -webkit-font-smoothing: antialiased; border-left: 3px solid rgb(89, 97, 249); padding: 0.25rem 0px 0.25rem 1.25rem; margin-left: -1.438rem; border-top-color: rgb(89, 97, 249); border-right-color: rgb(89, 97, 249); border-bottom-color: rgb(89, 97, 249); user-select: text !important;&quot;&gt;如何本地运行Stable Diffusion&lt;/h2&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 1.25rem; color: rgb(29, 35, 43); font-size: 1rem; line-height: 2; overflow-wrap: break-word; user-select: text !important;&quot;&gt;如果你愿意动手折腾，想对提供的输入对数据模型进行微调，或者出于隐私安全，那么在自己的本地电脑上运行Stable Diffusion模型，可能是个不错的选择。以下是本地运行Stable Diffusion的步骤：&lt;/p&gt;&lt;h3 style=&quot;margin-top: 0px; margin-bottom: 1rem; line-height: 1.2; font-size: 1.125rem; -webkit-font-smoothing: antialiased; border-left: 3px solid rgb(89, 97, 249); padding-left: 1.25rem; margin-left: -1.438rem; border-top-color: rgb(89, 97, 249); border-right-color: rgb(89, 97, 249); border-bottom-color: rgb(89, 97, 249); user-select: text !important;&quot;&gt;第1步：安装Python和Git&lt;/h3&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 1.25rem; color: rgb(29, 35, 43); font-size: 1rem; line-height: 2; overflow-wrap: break-word; user-select: text !important;&quot;&gt;安装Python 3.10.6版本，你可以从&lt;a href=&quot;https://www.python.org/downloads/release/python-3106/&quot; target=&quot;_blank&quot; rel=&quot;noopener nofollow&quot; class=&quot;external&quot; style=&quot;color: rgb(89, 97, 249); padding-right: 5px; user-select: text !important; outline: 0px !important;&quot;&gt;Python的官方网站&lt;/a&gt;上下载安装，安装完毕后可以打开命令行终端，输入&lt;code style=&quot;font-family: SFMono-Regular, Menlo, Monaco, Consolas, &amp;quot;Liberation Mono&amp;quot;, &amp;quot;Courier New&amp;quot;, monospace; font-size: 14px; color: rgb(232, 62, 140); overflow-wrap: break-word; padding: 4px 10px; background: rgba(130, 130, 130, 0.1); user-select: none !important;&quot;&gt;python -version&lt;/code&gt;以检查Python版本。接下来，便是安装代码管理工具Git，可以从&lt;a href=&quot;https://git-scm.com/&quot; target=&quot;_blank&quot; rel=&quot;noopener nofollow&quot; class=&quot;external&quot; style=&quot;color: rgb(89, 97, 249); padding-right: 5px; user-select: text !important; outline: 0px !important;&quot;&gt;Git的官网&lt;/a&gt;下载安装包。&lt;/p&gt;&lt;h3 style=&quot;margin-top: 0px; margin-bottom: 1rem; line-height: 1.2; font-size: 1.125rem; -webkit-font-smoothing: antialiased; border-left: 3px solid rgb(89, 97, 249); padding-left: 1.25rem; margin-left: -1.438rem; border-top-color: rgb(89, 97, 249); border-right-color: rgb(89, 97, 249); border-bottom-color: rgb(89, 97, 249); user-select: text !important;&quot;&gt;第2步：注册GitHub和Hugging Face账号&lt;/h3&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 1.25rem; color: rgb(29, 35, 43); font-size: 1rem; line-height: 2; overflow-wrap: break-word; user-select: text !important;&quot;&gt;GitHub是用于托管软件代码，而Hugging Face则是开源AI模型社区，注册这两个平台的账号，可以方便你后续代码的同步管理，以及下载Stable Diffusion模型。&lt;/p&gt;&lt;h2 style=&quot;margin-top: 0px; margin-bottom: 1rem; line-height: 1.2; font-size: 1.25rem; -webkit-font-smoothing: antialiased; border-left: 3px solid rgb(89, 97, 249); padding: 0.25rem 0px 0.25rem 1.25rem; margin-left: -1.438rem; border-top-color: rgb(89, 97, 249); border-right-color: rgb(89, 97, 249); border-bottom-color: rgb(89, 97, 249); user-select: text !important;&quot;&gt;第3步：克隆Stable Diffusion Web-UI到本地电脑&lt;/h2&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 1.25rem; color: rgb(29, 35, 43); font-size: 1rem; line-height: 2; overflow-wrap: break-word; user-select: text !important;&quot;&gt;Stable Diffusion Web-UI是一个开源的基于&lt;a href=&quot;https://ai-bot.cn/sites/2147.html&quot; style=&quot;color: rgb(89, 97, 249); user-select: text !important; outline: 0px !important;&quot;&gt;Gradio&lt;/a&gt;开发的Stable Diffusion网页界面项目，可以帮助开发者快速创建Stable Diffusion的用户界面。首先创建一个文件夹，如sd-project，然后使用cd命令定位到该文件夹，&lt;code style=&quot;font-family: SFMono-Regular, Menlo, Monaco, Consolas, &amp;quot;Liberation Mono&amp;quot;, &amp;quot;Courier New&amp;quot;, monospace; font-size: 14px; color: rgb(232, 62, 140); overflow-wrap: break-word; padding: 4px 10px; background: rgba(130, 130, 130, 0.1); user-select: none !important;&quot;&gt;cd sd-project&lt;/code&gt;。然后运行git clone命令将该项目下载下来，&lt;code style=&quot;font-family: SFMono-Regular, Menlo, Monaco, Consolas, &amp;quot;Liberation Mono&amp;quot;, &amp;quot;Courier New&amp;quot;, monospace; font-size: 14px; color: rgb(232, 62, 140); overflow-wrap: break-word; padding: 4px 10px; background: rgba(130, 130, 130, 0.1); user-select: none !important;&quot;&gt;git clone https://github.com/AUTOMATIC1111/stable-diffusion-webui.git&lt;/code&gt;&lt;/p&gt;&lt;h3 style=&quot;margin-top: 0px; margin-bottom: 1rem; line-height: 1.2; font-size: 1.125rem; -webkit-font-smoothing: antialiased; border-left: 3px solid rgb(89, 97, 249); padding-left: 1.25rem; margin-left: -1.438rem; border-top-color: rgb(89, 97, 249); border-right-color: rgb(89, 97, 249); border-bottom-color: rgb(89, 97, 249); user-select: text !important;&quot;&gt;第4步：从Hugging Face下载Stable Diffusion模型&lt;/h3&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 1.25rem; color: rgb(29, 35, 43); font-size: 1rem; line-height: 2; overflow-wrap: break-word; user-select: text !important;&quot;&gt;访问Hugging Face官网，登录注册好的账号，&lt;a href=&quot;https://huggingface.co/runwayml/stable-diffusion-v1-5/resolve/main/v1-5-pruned-emaonly.ckpt&quot; target=&quot;_blank&quot; rel=&quot;noopener&quot; class=&quot;external&quot; style=&quot;color: rgb(89, 97, 249); padding-right: 5px; user-select: text !important; outline: 0px !important;&quot;&gt;下载Stable Diffusion 1.5版本&lt;/a&gt;，模型下载完成后，导航到stable-diffusion-webui 文件夹内的“models”文件夹，然后将该模型放到这里。&lt;/p&gt;&lt;h3 style=&quot;margin-top: 0px; margin-bottom: 1rem; line-height: 1.2; font-size: 1.125rem; -webkit-font-smoothing: antialiased; border-left: 3px solid rgb(89, 97, 249); padding-left: 1.25rem; margin-left: -1.438rem; border-top-color: rgb(89, 97, 249); border-right-color: rgb(89, 97, 249); border-bottom-color: rgb(89, 97, 249); user-select: text !important;&quot;&gt;第5步：设置Stable Diffusion Web-UI&lt;/h3&gt;&lt;p class=&quot;p-margin&quot; dir=&quot;ltr&quot; style=&quot;margin-top: 0px; margin-bottom: 1.25rem; color: rgb(29, 35, 43); font-size: 1rem; line-height: 2; overflow-wrap: break-word; user-select: text !important;&quot;&gt;打开命令行终端并使用cd命令定位到 stable-diffusion-webui 文件夹，如&lt;code style=&quot;font-family: SFMono-Regular, Menlo, Monaco, Consolas, &amp;quot;Liberation Mono&amp;quot;, &amp;quot;Courier New&amp;quot;, monospace; font-size: 14px; color: rgb(232, 62, 140); overflow-wrap: break-word; padding: 4px 10px; background: rgba(130, 130, 130, 0.1); user-select: none !important;&quot;&gt;cd xx/sd-project/stable-diffusion-webui&lt;/code&gt;，然后输入&lt;code style=&quot;font-family: SFMono-Regular, Menlo, Monaco, Consolas, &amp;quot;Liberation Mono&amp;quot;, &amp;quot;Courier New&amp;quot;, monospace; font-size: 14px; color: rgb(232, 62, 140); overflow-wrap: break-word; padding: 4px 10px; background: rgba(130, 130, 130, 0.1); user-select: none !important;&quot;&gt;webui-user.bat&lt;/code&gt;安装依赖项。&lt;/p&gt;&lt;h3 dir=&quot;ltr&quot; style=&quot;margin-top: 0px; margin-bottom: 1rem; line-height: 1.2; font-size: 1.125rem; -webkit-font-smoothing: antialiased; border-left: 3px solid rgb(89, 97, 249); padding-left: 1.25rem; margin-left: -1.438rem; border-top-color: rgb(89, 97, 249); border-right-color: rgb(89, 97, 249); border-bottom-color: rgb(89, 97, 249); user-select: text !important;&quot;&gt;第6步：运行Stable Diffusion&lt;/h3&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 1.25rem; color: rgb(29, 35, 43); font-size: 1rem; line-height: 2; overflow-wrap: break-word; user-select: text !important;&quot;&gt;安装依赖项成功后，命令提示符中将出现一个 URL：&lt;span style=&quot;font-weight: bolder; user-select: text !important;&quot;&gt;http://127.0.0.1:7860&lt;/span&gt;。将其复制并粘贴到浏览器地址栏中以运行stable-diffusion-web-ui。&lt;/p&gt;&lt;a class=&quot;js&quot; href=&quot;https://ai-bot.cn/wp-content/uploads/2023/07/stable-diffusion-web-ui-local.png&quot; data-fancybox=&quot;fancybox&quot; data-caption=&quot;Stable Diffusion Web-UI&quot; style=&quot;color: rgb(89, 97, 249); user-select: text !important; outline: 0px !important;&quot;&gt;&lt;img decoding=&quot;async&quot; class=&quot;alignnone size-full wp-image-3190 loaded&quot; data-src=&quot;https://ai-bot.cn/wp-content/uploads/2023/07/stable-diffusion-web-ui-local.png&quot; src=&quot;https://ai-bot.cn/wp-content/uploads/2023/07/stable-diffusion-web-ui-local.png&quot; alt=&quot;Stable Diffusion Web-UI&quot; width=&quot;800&quot; height=&quot;500&quot; data-was-processed=&quot;true&quot; style=&quot;border-width: 2px; border-style: solid; border-color: rgb(238, 238, 238); margin: 5px 0px 20px; max-width: 100%; height: auto; border-radius: 6px; user-select: none !important;&quot;&gt;&lt;/a&gt;&lt;/div&gt;&lt;p&gt;&lt;br&gt;&lt;/p&gt;'),
                                                                      (3,	1,	4,	'&lt;p style=&quot;margin-top: 0px; margin-bottom: 28px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; font-size: 16px; line-height: 32px; text-align: justify; color: rgb(59, 59, 59); word-break: break-word; font-family: &amp;quot;PingFang SC&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, Helvetica, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; letter-spacing: 0.5px;&quot;&gt;&lt;span style=&quot;margin: 0px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; text-indent: 2em;&quot;&gt;&lt;a href=&quot;https://www.chinaz.com/tags/836996.shtml&quot; target=&quot;_blank&quot; style=&quot;margin: 0px; padding: 0px 0px 2px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; color: rgb(66, 66, 66); position: relative; z-index: 0; cursor: pointer;&quot;&gt;&lt;span style=&quot;margin: 0px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000;&quot;&gt;Imagen2&lt;/span&gt;&lt;/a&gt;&amp;nbsp;是Google DeepMind开发的&lt;span class=&quot;spamTxt&quot; style=&quot;margin: 0px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000;&quot;&gt;最先&lt;/span&gt;进的文本到图像扩散技术产品，可生成高品质、逼真的图像，与用户的文字提示紧密对齐。这款技术利用其训练数据的自然分布生成更逼真的图像，而不是采用预设的风格。开发者和Cloud客户可以通过Google Cloud Vertex AI上的Imagen API体验Imagen2 的强大功能。Google艺术与文化团队也在他们的「文化图标」实验中部署了Imagen2 技术，让用户借助Google AI探索、学习和测试他们的文化知识。&lt;/span&gt;&lt;img  title=&quot;6383825633075485686510229&quot; alt=&quot;6383825633075485686510229&quot; src=&quot;/uploadfile/202312/9937421eaa24b27.jpg&quot;&gt;&lt;/p&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 28px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; font-size: 16px; line-height: 32px; text-align: center; color: rgb(59, 59, 59); word-break: break-word; font-family: &amp;quot;PingFang SC&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, Helvetica, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; letter-spacing: 0.5px;&quot;&gt;&lt;span style=&quot;margin: 0px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; text-indent: 2em;&quot;&gt;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;article-content__img&quot; style=&quot;margin-top: 0px; margin-bottom: 28px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; font-size: 16px; line-height: 32px; text-align: center; color: rgb(59, 59, 59); word-break: break-word; font-family: &amp;quot;PingFang SC&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, Helvetica, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; letter-spacing: 0.5px; display: flex; -webkit-box-align: center; align-items: center; -webkit-box-pack: center; justify-content: center; flex-direction: column;&quot;&gt;&lt;/p&gt;&lt;p&gt;&lt;/p&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 28px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; font-size: 16px; line-height: 32px; text-align: justify; color: rgb(59, 59, 59); word-break: break-word; font-family: &amp;quot;PingFang SC&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, Helvetica, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; letter-spacing: 0.5px;&quot;&gt;&lt;a href=&quot;https://top.aibase.com/tool/imagen-2&quot; target=&quot;_blank&quot; textvalue=&quot;点击前往「Imagen 2」官网体验入口&quot; style=&quot;margin: 0px; padding: 0px 0px 2px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; color: rgb(66, 66, 66); position: relative; z-index: 0; cursor: pointer;&quot;&gt;&lt;strong style=&quot;margin: 0px; padding: 0px; outline: 0px; border: 0px; --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; color: rgb(20, 20, 20); white-space-collapse: preserve; display: inline; background: rgb(249, 250, 251);&quot;&gt;点击前往「Imagen 2」官网体验入口&lt;/strong&gt;&lt;/a&gt;&lt;/p&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 28px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; font-size: 16px; line-height: 32px; text-align: justify; color: rgb(59, 59, 59); word-break: break-word; font-family: &amp;quot;PingFang SC&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, Helvetica, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; letter-spacing: 0.5px;&quot;&gt;Imagen2 的改进之处包括：&lt;/p&gt;&lt;ol style=&quot;margin-right: 0px; margin-left: 0px; padding: 0px 0px 0px 20px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; list-style: none; color: rgb(42, 42, 42); font-family: ui-sans-serif, system-ui, -apple-system, BlinkMacSystemFont, &amp;quot;Segoe UI&amp;quot;, Roboto, &amp;quot;Helvetica Neue&amp;quot;, Arial, &amp;quot;Noto Sans&amp;quot;, sans-serif, &amp;quot;Apple Color Emoji&amp;quot;, &amp;quot;Segoe UI Emoji&amp;quot;, &amp;quot;Segoe UI Symbol&amp;quot;, &amp;quot;Noto Color Emoji&amp;quot;; font-size: 16px;&quot;&gt;&lt;li style=&quot;margin: 0px 0px 0px 5px; padding: 0px 0px 0px 5px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; list-style: decimal; line-height: 2.4;&quot;&gt;&lt;strong style=&quot;margin: 0px; padding: 0px; outline: 0px; border: 0px; --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; color: rgb(20, 20, 20); white-space-collapse: preserve; display: inline; background: rgb(249, 250, 251);&quot;&gt;改进的图像-字幕理解&lt;/strong&gt;：Imagen2 通过在训练数据集的图像和字幕中添加更多描述来创建更高质量、更准确的图像，以更好地匹配用户的提示。这些增强的图像-字幕配对帮助Imagen2 更好地理解图像和文字之间的关系，提升了对语境和细微差别的理解。&lt;/li&gt;&lt;li style=&quot;margin: 0px 0px 0px 5px; padding: 0px 0px 0px 5px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; list-style: decimal; line-height: 2.4;&quot;&gt;&lt;strong style=&quot;margin: 0px; padding: 0px; outline: 0px; border: 0px; --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; color: rgb(20, 20, 20); white-space-collapse: preserve; display: inline; background: rgb(249, 250, 251);&quot;&gt;更逼真的图像生成&lt;/strong&gt;：Imagen2 的数据集和模型进步在许多文本到图像工具常挣扎的领域取得了改进，包括逼真地渲染手和人脸，以及保持图像免受干扰的视觉伪影。&lt;/li&gt;&lt;li style=&quot;margin: 0px 0px 0px 5px; padding: 0px 0px 0px 5px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; list-style: decimal; line-height: 2.4;&quot;&gt;&lt;strong style=&quot;margin: 0px; padding: 0px; outline: 0px; border: 0px; --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; color: rgb(20, 20, 20); white-space-collapse: preserve; display: inline; background: rgb(249, 250, 251);&quot;&gt;流畅的风格条件&lt;/strong&gt;：Imagen2 的基于扩散的技术提供了高度的灵活性，使得控制和调整图像风格变得更容易。通过结合引用风格图像和文本提示，可以使Imagen2 生成遵循同样风格的新图像。&lt;/li&gt;&lt;li style=&quot;margin: 0px 0px 0px 5px; padding: 0px 0px 0px 5px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; list-style: decimal; line-height: 2.4;&quot;&gt;&lt;strong style=&quot;margin: 0px; padding: 0px; outline: 0px; border: 0px; --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; color: rgb(20, 20, 20); white-space-collapse: preserve; display: inline; background: rgb(249, 250, 251);&quot;&gt;先进的内画和外画技术&lt;/strong&gt;：Imagen2 还启用了像‘内画’和‘外画’这样的图像编辑功能。通过提供参考图像和图像蒙版，用户可以直接在原始图像中生成新内容，或将原始图像扩展到其边界之外。&lt;/li&gt;&lt;/ol&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 28px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; font-size: 16px; line-height: 32px; text-align: justify; color: rgb(59, 59, 59); word-break: break-word; font-family: &amp;quot;PingFang SC&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, Helvetica, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; letter-spacing: 0.5px;&quot;&gt;Imagen2 在设计和开发阶段就设立了强有力的防护措施，以帮助减轻其文本到图像生成技术可能带来的风险和挑战。Imagen2 集成了先进工具包SynthID，用于水印和识别AI生成的内容，允许列入白名单的Google Cloud客户直接在图像的像素中添加不可感知的数字水印，而不影响图像质量。在向用户发布功能之前，我们会进行严格的安全测试，以尽量减少伤害风险。&lt;/p&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 28px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; font-size: 16px; line-height: 32px; text-align: justify; color: rgb(59, 59, 59); word-break: break-word; font-family: &amp;quot;PingFang SC&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, Helvetica, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; letter-spacing: 0.5px;&quot;&gt;以上就是「Imagen 2」的全部介绍了，感兴趣的小伙伴可以点击上方链接前往体验！&lt;/p&gt;'),
                                                                      (4,	1,	4,	'&lt;p style=&quot;margin-top: 0px; margin-bottom: 28px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; font-size: 16px; line-height: 32px; text-align: justify; color: rgb(59, 59, 59); word-break: break-word; font-family: &amp;quot;PingFang SC&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, Helvetica, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; letter-spacing: 0.5px;&quot;&gt;&lt;span style=&quot;margin: 0px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; text-indent: 2em;&quot;&gt;&lt;a href=&quot;https://www.chinaz.com/tags/837016.shtml&quot; target=&quot;_blank&quot; style=&quot;margin: 0px; padding: 0px 0px 2px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; color: rgb(66, 66, 66); position: relative; z-index: 0; cursor: pointer;&quot;&gt;&lt;span style=&quot;margin: 0px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000;&quot;&gt;roomGPT&lt;/span&gt;&lt;/a&gt;是一款创新的AI技术产品，专为家居设计和房间改造而设计。它允许用户上传现有的房间照片，然后利用先进的AI技术生成多种风格的房间设计效果供用户选择。那么，你在哪里可以体验这项服务呢？下面就给大家带来roomGPT官网体验入口和免费app下载地址。&lt;/span&gt;&lt;img  title=&quot;6383825194065341987053654&quot; alt=&quot;6383825194065341987053654&quot; src=&quot;/uploadfile/202312/9c662823202bdb0.png&quot;&gt;&lt;/p&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 28px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; font-size: 16px; line-height: 32px; text-align: center; color: rgb(59, 59, 59); word-break: break-word; font-family: &amp;quot;PingFang SC&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, Helvetica, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; letter-spacing: 0.5px;&quot;&gt;&lt;span style=&quot;margin: 0px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; text-indent: 2em;&quot;&gt;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;article-content__img&quot; style=&quot;margin-top: 0px; margin-bottom: 28px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; font-size: 16px; line-height: 32px; text-align: center; color: rgb(59, 59, 59); word-break: break-word; font-family: &amp;quot;PingFang SC&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, Helvetica, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; letter-spacing: 0.5px; display: flex; -webkit-box-align: center; align-items: center; -webkit-box-pack: center; justify-content: center; flex-direction: column;&quot;&gt;&lt;/p&gt;&lt;p&gt;&lt;/p&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 28px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; font-size: 16px; line-height: 32px; text-align: justify; color: rgb(59, 59, 59); word-break: break-word; font-family: &amp;quot;PingFang SC&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, Helvetica, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; letter-spacing: 0.5px;&quot;&gt;&lt;a href=&quot;https://top.aibase.com/tool/roomgpt&quot; target=&quot;_blank&quot; style=&quot;margin: 0px; padding: 0px 0px 2px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; color: rgb(66, 66, 66); position: relative; z-index: 0; cursor: pointer;&quot;&gt;&lt;strong style=&quot;margin: 0px; padding: 0px; outline: 0px; border: 0px; --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; color: rgb(20, 20, 20); white-space-collapse: preserve; display: inline; background: rgb(249, 250, 251);&quot;&gt;点击前往roomGPT官网体验入口&lt;/strong&gt;&lt;/a&gt;&lt;/p&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 28px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; font-size: 16px; line-height: 32px; text-align: justify; color: rgb(59, 59, 59); word-break: break-word; font-family: &amp;quot;PingFang SC&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, Helvetica, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; letter-spacing: 0.5px;&quot;&gt;roomGPT使用控制网(ControlNet)机器学习模型，可以生成房间的不同变体，包括中式风格、欧式风格等。它提供了免费开源版本供本地部署使用，同时也有付费的SaaS服务。roomGPT适合需要家居设计、房间改造或风格迁移的人群，无论是想要为客厅寻找新的设计灵感，还是改造卧室的风格，roomGPT都能提供合适的解决方案。&lt;/p&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 28px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; font-size: 16px; line-height: 32px; text-align: justify; color: rgb(59, 59, 59); word-break: break-word; font-family: &amp;quot;PingFang SC&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, Helvetica, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; letter-spacing: 0.5px;&quot;&gt;产品的主要特色包括：&lt;/p&gt;&lt;ol style=&quot;margin-right: 0px; margin-left: 0px; padding: 0px 0px 0px 20px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; list-style: none; color: rgb(42, 42, 42); font-family: ui-sans-serif, system-ui, -apple-system, BlinkMacSystemFont, &amp;quot;Segoe UI&amp;quot;, Roboto, &amp;quot;Helvetica Neue&amp;quot;, Arial, &amp;quot;Noto Sans&amp;quot;, sans-serif, &amp;quot;Apple Color Emoji&amp;quot;, &amp;quot;Segoe UI Emoji&amp;quot;, &amp;quot;Segoe UI Symbol&amp;quot;, &amp;quot;Noto Color Emoji&amp;quot;; font-size: 16px;&quot;&gt;&lt;li style=&quot;margin: 0px 0px 0px 5px; padding: 0px 0px 0px 5px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; list-style: decimal; line-height: 2.4;&quot;&gt;上传房间照片：用户可以上传任何房间的照片。&lt;/li&gt;&lt;li style=&quot;margin: 0px 0px 0px 5px; padding: 0px 0px 0px 5px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; list-style: decimal; line-height: 2.4;&quot;&gt;AI生成房间设计：AI技术帮助创建多种房间设计。&lt;/li&gt;&lt;li style=&quot;margin: 0px 0px 0px 5px; padding: 0px 0px 0px 5px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; list-style: decimal; line-height: 2.4;&quot;&gt;提供不同房间风格：满足不同用户的个性化需求。&lt;/li&gt;&lt;li style=&quot;margin: 0px 0px 0px 5px; padding: 0px 0px 0px 5px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; list-style: decimal; line-height: 2.4;&quot;&gt;免费开源部署：适合有一定技术基础的用户自行部署。&lt;/li&gt;&lt;li style=&quot;margin: 0px 0px 0px 5px; padding: 0px 0px 0px 5px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; list-style: decimal; line-height: 2.4;&quot;&gt;付费&lt;span class=&quot;spamTxt&quot; style=&quot;margin: 0px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000;&quot;&gt;高级&lt;/span&gt;服务：为需要更多功能的用户提供&lt;span class=&quot;spamTxt&quot; style=&quot;margin: 0px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000;&quot;&gt;高级&lt;/span&gt;服务选项。&lt;/li&gt;&lt;/ol&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 28px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; font-size: 16px; line-height: 32px; text-align: justify; color: rgb(59, 59, 59); word-break: break-word; font-family: &amp;quot;PingFang SC&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, Helvetica, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; letter-spacing: 0.5px;&quot;&gt;以上就是roomGPT的全部介绍了，感兴趣的小伙伴可以点击上方链接前往体验！&lt;/p&gt;'),
                                                                      (5,	1,	4,	'&lt;p style=&quot;margin-top: 0px; margin-bottom: 28px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; font-size: 16px; line-height: 32px; text-align: justify; color: rgb(59, 59, 59); word-break: break-word; font-family: &amp;quot;PingFang SC&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, Helvetica, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; letter-spacing: 0.5px;&quot;&gt;在&lt;span class=&quot;spamTxt&quot; style=&quot;margin: 0px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000;&quot;&gt;最新&lt;/span&gt;的研究中，卡内基梅隆大学（CMU）和马克斯·普朗克智能系统研究所的研究人员共同发布了一项名为WHAM(World-grounded Humans with Accurate Motion)的创新性&lt;span style=&quot;margin: 0px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000;&quot;&gt;AI方法&lt;/span&gt;。这一方法在精准性和效率方面实现了从视频中准确估计3D人体运动的突破。&lt;/p&gt;&lt;p style=&quot;text-align: center; margin-top: 0px; margin-bottom: 28px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; font-size: 16px; line-height: 32px; color: rgb(59, 59, 59); word-break: break-word; font-family: &amp;quot;PingFang SC&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, Helvetica, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; letter-spacing: 0.5px;&quot;&gt;3D人体运动重建是一个复杂的过程，涉及准确捕捉和建模人体在三维空间中的运动。当处理由移动摄像机在现实世界环境中拍摄的视频时，这一任务变得更加具有挑战性，因为这些视频通常包含脚滑等问题。然而，CMU和马克斯·普朗克智能系统研究所的研究人员通过WHAM方法成功解决了这些挑战，实现了精准的3D人体运动重建。&lt;img  title=&quot;1&quot; alt=&quot;1&quot; src=&quot;/uploadfile/202312/b2373ea98e815fd.png&quot;&gt;&lt;/p&gt;&lt;p style=&quot;text-align: center; margin-top: 0px; margin-bottom: 28px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; font-size: 16px; line-height: 32px; color: rgb(59, 59, 59); word-break: break-word; font-family: &amp;quot;PingFang SC&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, Helvetica, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; letter-spacing: 0.5px;&quot;&gt;从图像中恢复3D人体姿势和形状的两种方法:无模型和基于模型。它强调了在基于模型的方法中使用深度学习技术来估计统计身体模型的参数。现有的基于视频的3D人体姿势估计方法通过各种神经网络体系结构引入时间信息。一些方法使用额外的传感器，如惯性传感器，但它们可能会产生侵扰。WHAM通过有效地结合3D人体运动和视频上下文，利用先验知识，并在全球坐标系中准确重建3D人体活动而脱颖而出。&lt;img  title=&quot;2&quot; alt=&quot;2&quot; src=&quot;/uploadfile/202312/ba1e1ddda3f0e58.png&quot;&gt;&lt;/p&gt;&lt;p class=&quot;article-content__img&quot; style=&quot;margin-top: 0px; margin-bottom: 28px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; font-size: 16px; line-height: 32px; text-align: center; color: rgb(59, 59, 59); word-break: break-word; font-family: &amp;quot;PingFang SC&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, Helvetica, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; letter-spacing: 0.5px; display: flex; -webkit-box-align: center; align-items: center; -webkit-box-pack: center; justify-content: center; flex-direction: column;&quot;&gt;&lt;/p&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 28px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; font-size: 16px; line-height: 32px; text-align: justify; color: rgb(59, 59, 59); word-break: break-word; font-family: &amp;quot;PingFang SC&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, Helvetica, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; letter-spacing: 0.5px;&quot;&gt;该研究解决了从单眼视频中准确估计3D人体姿势和形状的挑战，强调了全球坐标一致性、计算效率和真实足地接触。利用AMASS运动捕捉和视频数据集，WHAM结合了运动编码器-解码器网络，用于将2D关键点转换为3D姿势，具有用于时间线索的特征整合器，以及用于全局运动估计考虑足地接触的轨迹细化网络，提高了在非平面表面上的准确性。&lt;/p&gt;&lt;p style=&quot;text-align: center; margin-top: 0px; margin-bottom: 28px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; font-size: 16px; line-height: 32px; color: rgb(59, 59, 59); word-break: break-word; font-family: &amp;quot;PingFang SC&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, Helvetica, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; letter-spacing: 0.5px;&quot;&gt;WHAM采用单向RNN进行在线推断和精确的3D运动重建，具有用于上下文提取的运动编码器和用于SMPL参数、相机平移和足地接触概率的运动解码器。利用边界框归一化技术有助于运动上下文的提取。在人体网格恢复的预训练图像编码器通过特征整合器网络捕捉和整合图像特征与运动特征。轨迹解码器预测全局方向，而细化过程最小化足滑动。在合成AMASS数据上进行训练，WHAM在评估中优于现有方法。&lt;img  title=&quot;3&quot; alt=&quot;3&quot; src=&quot;/uploadfile/202312/fa680816525a1c1.png&quot;&gt;&lt;/p&gt;&lt;p class=&quot;article-content__img&quot; style=&quot;margin-top: 0px; margin-bottom: 28px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; font-size: 16px; line-height: 32px; text-align: center; color: rgb(59, 59, 59); word-break: break-word; font-family: &amp;quot;PingFang SC&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, Helvetica, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; letter-spacing: 0.5px; display: flex; -webkit-box-align: center; align-items: center; -webkit-box-pack: center; justify-content: center; flex-direction: column;&quot;&gt;&lt;/p&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 28px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; font-size: 16px; line-height: 32px; text-align: justify; color: rgb(59, 59, 59); word-break: break-word; font-family: &amp;quot;PingFang SC&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, Helvetica, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; letter-spacing: 0.5px;&quot;&gt;WHAM超越了当前的&lt;span class=&quot;spamTxt&quot; style=&quot;margin: 0px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000;&quot;&gt;最先&lt;/span&gt;进方法，在逐帧和基于视频的3D人体姿势和形状估计中表现出卓越的准确性。通过利用运动上下文和足地接触信息实现了精确的全球轨迹估计，最小化了足滑动，并提高了国际协调性。该方法整合了2D关键点和像素的特征，提高了3D人体运动重建的准确性。在野外基准测试中，WHAM在MPJPE、PA-MPJPE和PVE等指标上展现出卓越的性能。轨迹细化技术进一步提升了全局轨迹估计，并通过改善的误差指标证明了减少足滑动的效果。&lt;/p&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 28px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; font-size: 16px; line-height: 32px; text-align: justify; color: rgb(59, 59, 59); word-break: break-word; font-family: &amp;quot;PingFang SC&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, Helvetica, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; letter-spacing: 0.5px;&quot;&gt;总的来说，这项研究的主要观点可以总结为以下几点:&lt;/p&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 28px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; font-size: 16px; line-height: 32px; text-align: justify; color: rgb(59, 59, 59); word-break: break-word; font-family: &amp;quot;PingFang SC&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, Helvetica, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; letter-spacing: 0.5px;&quot;&gt;1. WHAM引入了一种结合3D人体运动和视频背景的开创性方法。&lt;/p&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 28px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; font-size: 16px; line-height: 32px; text-align: justify; color: rgb(59, 59, 59); word-break: break-word; font-family: &amp;quot;PingFang SC&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, Helvetica, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; letter-spacing: 0.5px;&quot;&gt;2. 该技术增强了3D人体姿势和形状的回归。&lt;/p&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 28px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; font-size: 16px; line-height: 32px; text-align: justify; color: rgb(59, 59, 59); word-break: break-word; font-family: &amp;quot;PingFang SC&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, Helvetica, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; letter-spacing: 0.5px;&quot;&gt;3. 该方法使用了一个全球轨迹估计框架，包括运动上下文和足地接触。&lt;/p&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 28px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; font-size: 16px; line-height: 32px; text-align: justify; color: rgb(59, 59, 59); word-break: break-word; font-family: &amp;quot;PingFang SC&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, Helvetica, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; letter-spacing: 0.5px;&quot;&gt;4. 该方法解决了足滑动的问题，并确保在非平面表面上准确跟踪3D运动。&lt;/p&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 28px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; font-size: 16px; line-height: 32px; text-align: justify; color: rgb(59, 59, 59); word-break: break-word; font-family: &amp;quot;PingFang SC&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, Helvetica, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; letter-spacing: 0.5px;&quot;&gt;5. WHAM的方法在包括3DPW、RICH和EMDB在内的多样化基准数据集上表现出色。&lt;/p&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 28px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; font-size: 16px; line-height: 32px; text-align: justify; color: rgb(59, 59, 59); word-break: break-word; font-family: &amp;quot;PingFang SC&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, Helvetica, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; letter-spacing: 0.5px;&quot;&gt;6. 该方法在全球坐标系中实现了高效的人体姿势和形状估计。&lt;/p&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 28px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; font-size: 16px; line-height: 32px; text-align: justify; color: rgb(59, 59, 59); word-break: break-word; font-family: &amp;quot;PingFang SC&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, Helvetica, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; letter-spacing: 0.5px;&quot;&gt;7. 该方法的特征整合和轨迹细化显著提高了运动和全局轨迹的准确性。&lt;/p&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 28px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; font-size: 16px; line-height: 32px; text-align: justify; color: rgb(59, 59, 59); word-break: break-word; font-family: &amp;quot;PingFang SC&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, Helvetica, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; letter-spacing: 0.5px;&quot;&gt;8. 通过深入的剖析研究，验证了该方法的准确性。&lt;/p&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 28px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; font-size: 16px; line-height: 32px; text-align: justify; color: rgb(59, 59, 59); word-break: break-word; font-family: &amp;quot;PingFang SC&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, Helvetica, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; letter-spacing: 0.5px;&quot;&gt;论文网址:https://arxiv.org/abs/2312.07531&lt;/p&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 28px; padding: 0px; outline: 0px; border-width: 0px; border-style: solid; border-color: rgb(229, 231, 235); --tw-shadow: 0 0 #0000; --tw-ring-inset: var(--tw-empty, ); --tw-ring-offset-width: 0px; --tw-ring-offset-color: #fff; --tw-ring-color: rgba(41, 110, 228, 0.5); --tw-ring-offset-shadow: 0 0 #0000; --tw-ring-shadow: 0 0 #0000; font-size: 16px; line-height: 32px; text-align: justify; color: rgb(59, 59, 59); word-break: break-word; font-family: &amp;quot;PingFang SC&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, Helvetica, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; letter-spacing: 0.5px;&quot;&gt;项目网址:https://wham.is.tue.mpg.de/&lt;/p&gt;');

DROP TABLE IF EXISTS `fhx_1_blog_draft`;
CREATE TABLE `fhx_1_blog_draft` (
                                    `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
                                    `cid` int(10) unsigned NOT NULL COMMENT '内容id',
                                    `uid` mediumint(8) unsigned NOT NULL COMMENT '作者uid',
                                    `catid` mediumint(8) unsigned NOT NULL COMMENT '栏目id',
                                    `content` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '具体内容',
                                    `inputtime` int(10) unsigned NOT NULL COMMENT '录入时间',
                                    PRIMARY KEY (`id`),
                                    KEY `uid` (`uid`),
                                    KEY `cid` (`cid`),
                                    KEY `catid` (`catid`),
                                    KEY `inputtime` (`inputtime`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='内容草稿表';


DROP TABLE IF EXISTS `fhx_1_blog_flag`;
CREATE TABLE `fhx_1_blog_flag` (
                                   `flag` tinyint(2) unsigned NOT NULL DEFAULT '1' COMMENT '文档标记id',
                                   `id` int(10) unsigned NOT NULL COMMENT '文档内容id',
                                   `uid` mediumint(8) unsigned NOT NULL COMMENT '作者uid',
                                   `catid` mediumint(8) unsigned NOT NULL COMMENT '栏目id',
                                   KEY `flag` (`flag`,`id`,`uid`),
                                   KEY `catid` (`catid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='标记表';

INSERT INTO `fhx_1_blog_flag` (`flag`, `id`, `uid`, `catid`) VALUES
                                                                 (1,	1,	1,	4),
                                                                 (1,	5,	1,	4);

DROP TABLE IF EXISTS `fhx_1_blog_hits`;
CREATE TABLE `fhx_1_blog_hits` (
                                   `id` int(10) unsigned NOT NULL COMMENT '文章id',
                                   `hits` int(10) unsigned NOT NULL COMMENT '总点击数',
                                   `day_hits` int(10) unsigned NOT NULL COMMENT '本日点击',
                                   `week_hits` int(10) unsigned NOT NULL COMMENT '本周点击',
                                   `month_hits` int(10) unsigned NOT NULL COMMENT '本月点击',
                                   `year_hits` int(10) unsigned NOT NULL COMMENT '年点击量',
                                   `day_time` int(10) unsigned NOT NULL COMMENT '本日',
                                   `week_time` int(10) unsigned NOT NULL COMMENT '本周',
                                   `month_time` int(10) unsigned NOT NULL COMMENT '本月',
                                   `year_time` int(10) unsigned NOT NULL COMMENT '年',
                                   UNIQUE KEY `id` (`id`),
                                   KEY `day_hits` (`day_hits`),
                                   KEY `week_hits` (`week_hits`),
                                   KEY `month_hits` (`month_hits`),
                                   KEY `year_hits` (`year_hits`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='时段点击量统计';

INSERT INTO `fhx_1_blog_hits` (`id`, `hits`, `day_hits`, `week_hits`, `month_hits`, `year_hits`, `day_time`, `week_time`, `month_time`, `year_time`) VALUES
                                                                                                                                                         (1,	3,	2,	2,	2,	2,	1702721185,	1702721185,	1702721185,	1702721185),
                                                                                                                                                         (2,	6,	2,	2,	2,	2,	1705216457,	1705216457,	1705216457,	1705216457),
                                                                                                                                                         (3,	9,	1,	1,	1,	1,	1705215058,	1705215058,	1705215058,	1705215058),
                                                                                                                                                         (4,	13,	4,	5,	5,	5,	1705215021,	1705150239,	1705150239,	1705150239),
                                                                                                                                                         (5,	12,	1,	1,	1,	1,	1707202868,	1707202868,	1707202868,	1707202868);

DROP TABLE IF EXISTS `fhx_1_blog_index`;
CREATE TABLE `fhx_1_blog_index` (
                                    `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
                                    `uid` mediumint(8) unsigned NOT NULL COMMENT '作者uid',
                                    `catid` mediumint(8) unsigned NOT NULL COMMENT '栏目id',
                                    `status` tinyint(2) NOT NULL COMMENT '审核状态',
                                    `inputtime` int(10) unsigned NOT NULL COMMENT '录入时间',
                                    PRIMARY KEY (`id`),
                                    KEY `uid` (`uid`),
                                    KEY `catid` (`catid`),
                                    KEY `status` (`status`),
                                    KEY `inputtime` (`inputtime`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='内容索引表';

INSERT INTO `fhx_1_blog_index` (`id`, `uid`, `catid`, `status`, `inputtime`) VALUES
                                                                                 (1,	1,	4,	9,	1702706320),
                                                                                 (2,	1,	5,	9,	1702711042),
                                                                                 (3,	1,	4,	9,	1702712624),
                                                                                 (4,	1,	4,	9,	1702733609),
                                                                                 (5,	1,	4,	9,	1702718420);

DROP TABLE IF EXISTS `fhx_1_blog_oppose`;
CREATE TABLE `fhx_1_blog_oppose` (
                                     `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
                                     `cid` int(10) unsigned NOT NULL COMMENT '文档id',
                                     `uid` mediumint(8) unsigned NOT NULL COMMENT '作者uid',
                                     `agent` varchar(100) NOT NULL COMMENT '匿名',
                                     `inputtime` int(10) unsigned NOT NULL COMMENT '操作时间',
                                     PRIMARY KEY (`id`),
                                     KEY `cid` (`cid`),
                                     KEY `agent` (`agent`),
                                     KEY `inputtime` (`inputtime`),
                                     KEY `uid` (`uid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='反对操作记录表';


DROP TABLE IF EXISTS `fhx_1_blog_recycle`;
CREATE TABLE `fhx_1_blog_recycle` (
                                      `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
                                      `cid` int(10) unsigned NOT NULL COMMENT '内容id',
                                      `uid` mediumint(8) unsigned NOT NULL COMMENT '作者uid',
                                      `catid` tinyint(3) unsigned NOT NULL COMMENT '栏目id',
                                      `content` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '具体内容',
                                      `result` text COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '删除理由',
                                      `inputtime` int(10) unsigned NOT NULL COMMENT '录入时间',
                                      PRIMARY KEY (`id`),
                                      KEY `uid` (`uid`),
                                      KEY `cid` (`cid`),
                                      KEY `catid` (`catid`),
                                      KEY `inputtime` (`inputtime`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='内容回收站表';


DROP TABLE IF EXISTS `fhx_1_blog_search`;
CREATE TABLE `fhx_1_blog_search` (
                                     `id` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
                                     `catid` mediumint(8) unsigned NOT NULL COMMENT '栏目id',
                                     `params` text COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '参数数组',
                                     `keyword` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '关键字',
                                     `contentid` int(10) unsigned NOT NULL COMMENT '字段改成了结果数量值',
                                     `inputtime` int(10) unsigned NOT NULL COMMENT '搜索时间',
                                     PRIMARY KEY (`id`),
                                     UNIQUE KEY `id` (`id`),
                                     KEY `catid` (`catid`),
                                     KEY `keyword` (`keyword`),
                                     KEY `inputtime` (`inputtime`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='搜索表';


DROP TABLE IF EXISTS `fhx_1_blog_support`;
CREATE TABLE `fhx_1_blog_support` (
                                      `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
                                      `cid` int(10) unsigned NOT NULL COMMENT '文档id',
                                      `uid` mediumint(8) unsigned NOT NULL COMMENT '作者uid',
                                      `agent` varchar(100) NOT NULL COMMENT '匿名',
                                      `inputtime` int(10) unsigned NOT NULL COMMENT '操作时间',
                                      PRIMARY KEY (`id`),
                                      KEY `cid` (`cid`),
                                      KEY `agent` (`agent`),
                                      KEY `inputtime` (`inputtime`),
                                      KEY `uid` (`uid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='支持操作记录表';

INSERT INTO `fhx_1_blog_support` (`id`, `cid`, `uid`, `agent`, `inputtime`) VALUES
    (2,	5,	1,	'a94caa2c069f17ad88f4a745de680d7f',	1702733741);

DROP TABLE IF EXISTS `fhx_1_blog_time`;
CREATE TABLE `fhx_1_blog_time` (
                                   `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
                                   `uid` mediumint(8) unsigned NOT NULL COMMENT '作者uid',
                                   `catid` mediumint(8) unsigned NOT NULL COMMENT '栏目id',
                                   `content` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '具体内容',
                                   `result` text COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '处理结果',
                                   `posttime` int(10) unsigned NOT NULL COMMENT '定时发布时间',
                                   `inputtime` int(10) unsigned NOT NULL COMMENT '录入时间',
                                   PRIMARY KEY (`id`),
                                   KEY `uid` (`uid`),
                                   KEY `catid` (`catid`),
                                   KEY `posttime` (`posttime`),
                                   KEY `inputtime` (`inputtime`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='内容定时发布表';


DROP TABLE IF EXISTS `fhx_1_blog_verify`;
CREATE TABLE `fhx_1_blog_verify` (
                                     `id` int(10) unsigned NOT NULL,
                                     `uid` mediumint(8) unsigned NOT NULL COMMENT '作者uid',
                                     `vid` tinyint(2) NOT NULL COMMENT '审核id号',
                                     `isnew` tinyint(1) unsigned NOT NULL COMMENT '是否新增',
                                     `islock` tinyint(1) unsigned NOT NULL COMMENT '是否锁定',
                                     `author` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '作者',
                                     `catid` mediumint(8) unsigned NOT NULL COMMENT '栏目id',
                                     `status` tinyint(2) NOT NULL COMMENT '审核状态',
                                     `content` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '具体内容',
                                     `backuid` mediumint(8) unsigned NOT NULL COMMENT '操作人uid',
                                     `backinfo` text COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '操作退回信息',
                                     `inputtime` int(10) unsigned NOT NULL COMMENT '录入时间',
                                     UNIQUE KEY `id` (`id`),
                                     KEY `uid` (`uid`),
                                     KEY `vid` (`vid`),
                                     KEY `catid` (`catid`),
                                     KEY `status` (`status`),
                                     KEY `inputtime` (`inputtime`),
                                     KEY `backuid` (`backuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='内容审核表';


DROP TABLE IF EXISTS `fhx_1_share_category`;
CREATE TABLE `fhx_1_share_category` (
                                        `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
                                        `tid` tinyint(1) NOT NULL COMMENT '栏目类型，0单页，1模块，2外链',
                                        `pid` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '上级id',
                                        `mid` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '模块目录',
                                        `pids` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '所有上级id',
                                        `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '栏目名称',
                                        `dirname` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '栏目目录',
                                        `pdirname` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '上级目录',
                                        `child` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否有下级',
                                        `disabled` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否禁用',
                                        `ismain` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否主栏目',
                                        `childids` text COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '下级所有id',
                                        `thumb` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '栏目图片',
                                        `show` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否显示',
                                        `content` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '单页内容',
                                        `setting` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '属性配置',
                                        `displayorder` smallint(5) NOT NULL DEFAULT '0',
                                        `title` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '标题',
                                        PRIMARY KEY (`id`),
                                        KEY `mid` (`mid`),
                                        KEY `tid` (`tid`),
                                        KEY `show` (`show`),
                                        KEY `disabled` (`disabled`),
                                        KEY `ismain` (`ismain`),
                                        KEY `dirname` (`dirname`),
                                        KEY `module` (`pid`,`displayorder`,`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='共享模块栏目表';

INSERT INTO `fhx_1_share_category` (`id`, `tid`, `pid`, `mid`, `pids`, `name`, `dirname`, `pdirname`, `child`, `disabled`, `ismain`, `childids`, `thumb`, `show`, `content`, `setting`, `displayorder`, `title`) VALUES
                                                                                                                                                                                                                     (1,	1,	0,	'blog',	'0',	'文章博客',	'blog',	'',	1,	0,	1,	'1,4,5',	'',	1,	'',	'{\"disabled\":\"0\",\"linkurl\":\"\",\"getchild\":\"0\",\"notedit\":\"0\",\"urlrule\":2,\"seo\":{\"list_title\":\"[第{page}页{join}]{name}{join}{SITE_NAME}\",\"list_keywords\":\"\",\"list_description\":\"\"},\"template\":{\"pagesize\":\"20\",\"mpagesize\":\"20\",\"page\":\"\",\"list\":\"list.html\",\"category\":\"category.html\",\"search\":\"search.html\",\"show\":\"show.html\"},\"cat_field\":null,\"module_field\":null}',	0,	NULL),
                                                                                                                                                                                                                     (2,	0,	0,	'blog',	'0',	'关于我们',	'about-us',	'',	0,	0,	1,	'2',	'',	1,	'&lt;p&gt;欢迎访问AI工具箱导航，你的一站式人工智能工具箱合网站，500+ AI 工具导航大全。&lt;/p&gt;&lt;p&gt;AI工具箱介绍&lt;/p&gt;&lt;p&gt;AI工具箱专注于收录和推荐国内外热门、创意、有趣、前沿的AI工具和网站，致力于为大家提供一个快速访问任意人工智能网站的门户和入口。我们的目标是让所有人都方便快捷地探索AI技术，让你在个人学习、生活和工作中充分利用人工智能的潜力。&lt;/p&gt;&lt;p&gt;郑重声明：https://ai-baidu.cn 是AI工具箱导航的唯一官网地址，其余皆为抄袭和仿冒网站！本站仅有官方网站，无任何QQ群、微信群、知识星球、付费课程！&lt;/p&gt;&lt;p&gt;探索AI工具箱&lt;/p&gt;&lt;p&gt;在AI工具箱网站，你可以探索到有关于AI的任意方面：&lt;/p&gt;&lt;p&gt;AI 工具和网站： 在AI工具箱，你可以查看广泛的人工智能工具和应用程序的集合，本站收录了国内外数百个不同类型的AI工具，每日更新和添加最新AI工具，包括不限于AI写作工具、AI图像生成、AI音频转换、AI视频制作、AI编程开发、AI创意设计等分类，以满足你的不同需求。&lt;/p&gt;&lt;p&gt;AI 教程和指南： 通过我们简单易懂的教程、指南、百科了解人工智能的来龙去脉，即使你是初学者或完全不懂AI，也能帮助你在不断发展的人工智能领域，开发新的技能并增加你的知识。&lt;/p&gt;&lt;p&gt;AI 新闻和快讯： AI工具箱采用每月3期的AI快讯版面，几乎每日更新AI行业的大事件，让你随时了解人工智能领域的最新趋势、突破和事件，为你带来人工智能领域最重要和最令人兴奋的更新！&lt;/p&gt;&lt;p&gt;联系我们&lt;/p&gt;&lt;p&gt;感谢你成为AI工具箱大家庭的一员，我们可以一起参与和塑造人工智能的未来！&lt;/p&gt;&lt;p&gt;若你有任何意见和建议，无论是网站排版改进、AI工具提交，还是文章投稿、观点分享和商务合作，欢迎随时联系站长的邮箱info@ai-baidu.cn进行交流和沟通。&lt;/p&gt;',	'{\"disabled\":\"0\",\"linkurl\":\"\",\"getchild\":\"0\",\"notedit\":0,\"urlrule\":2,\"seo\":{\"list_title\":\"[第{page}页{join}]{name}{join}{SITE_NAME}\",\"list_keywords\":\"\",\"list_description\":\"\"},\"template\":{\"pagesize\":\"20\",\"mpagesize\":\"20\",\"page\":\"\",\"list\":\"list.html\",\"category\":\"category.html\",\"search\":\"search.html\",\"show\":\"show.html\"},\"cat_field\":null,\"module_field\":null}',	0,	'关于AI工具箱导航'),
                                                                                                                                                                                                                     (3,	0,	0,	'',	'0',	'免责声明',	'disclaimer',	'',	0,	0,	1,	'3',	'',	1,	'&lt;p style=&quot;margin-top: 0px; margin-bottom: 1.25rem; color: rgb(29, 35, 43); font-size: 16px; line-height: 2; overflow-wrap: break-word; font-family: -apple-system, BlinkMacSystemFont, &amp;quot;Segoe UI&amp;quot;, Roboto, &amp;quot;Helvetica Neue&amp;quot;, Arial, &amp;quot;Noto Sans&amp;quot;, &amp;quot;Liberation Sans&amp;quot;, sans-serif, &amp;quot;Apple Color Emoji&amp;quot;, &amp;quot;Segoe UI Emoji&amp;quot;, &amp;quot;Segoe UI Symbol&amp;quot;, &amp;quot;Noto Color Emoji&amp;quot;; user-select: text !important;&quot;&gt;最后更新于 2023 年 6 月 21 日&lt;/p&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 1.25rem; color: rgb(29, 35, 43); font-size: 16px; line-height: 2; overflow-wrap: break-word; font-family: -apple-system, BlinkMacSystemFont, &amp;quot;Segoe UI&amp;quot;, Roboto, &amp;quot;Helvetica Neue&amp;quot;, Arial, &amp;quot;Noto Sans&amp;quot;, &amp;quot;Liberation Sans&amp;quot;, sans-serif, &amp;quot;Apple Color Emoji&amp;quot;, &amp;quot;Segoe UI Emoji&amp;quot;, &amp;quot;Segoe UI Symbol&amp;quot;, &amp;quot;Noto Color Emoji&amp;quot;; user-select: text !important;&quot;&gt;尊敬的用户，您在使用由我们运营的AI工具集导航网站之前，请仔细阅读本免责声明。&lt;/p&gt;&lt;h2 style=&quot;margin-top: 0px; margin-bottom: 1rem; line-height: 1.2; font-size: 1.25rem; -webkit-font-smoothing: antialiased; border-left: 3px solid rgb(89, 97, 249); padding: 0.25rem 0px 0.25rem 1.25rem; margin-left: -1.438rem; border-top-color: rgb(89, 97, 249); border-right-color: rgb(89, 97, 249); border-bottom-color: rgb(89, 97, 249); color: rgb(40, 42, 45); font-family: -apple-system, BlinkMacSystemFont, &amp;quot;Segoe UI&amp;quot;, Roboto, &amp;quot;Helvetica Neue&amp;quot;, Arial, &amp;quot;Noto Sans&amp;quot;, &amp;quot;Liberation Sans&amp;quot;, sans-serif, &amp;quot;Apple Color Emoji&amp;quot;, &amp;quot;Segoe UI Emoji&amp;quot;, &amp;quot;Segoe UI Symbol&amp;quot;, &amp;quot;Noto Color Emoji&amp;quot;; user-select: text !important;&quot;&gt;一般信息&lt;/h2&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 1.25rem; color: rgb(29, 35, 43); font-size: 16px; line-height: 2; overflow-wrap: break-word; font-family: -apple-system, BlinkMacSystemFont, &amp;quot;Segoe UI&amp;quot;, Roboto, &amp;quot;Helvetica Neue&amp;quot;, Arial, &amp;quot;Noto Sans&amp;quot;, &amp;quot;Liberation Sans&amp;quot;, sans-serif, &amp;quot;Apple Color Emoji&amp;quot;, &amp;quot;Segoe UI Emoji&amp;quot;, &amp;quot;Segoe UI Symbol&amp;quot;, &amp;quot;Noto Color Emoji&amp;quot;; user-select: text !important;&quot;&gt;AI工具集导航在网站上提供的信息仅用于一般信息目的。本网站上的所有信息都是善意提供的，但是，对于本网站上任何信息的准确性、充分性、有效性、可靠性、可用性或完整性，我们不作任何形式的明示或暗示的陈述或保证。&lt;/p&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 1.25rem; color: rgb(29, 35, 43); font-size: 16px; line-height: 2; overflow-wrap: break-word; font-family: -apple-system, BlinkMacSystemFont, &amp;quot;Segoe UI&amp;quot;, Roboto, &amp;quot;Helvetica Neue&amp;quot;, Arial, &amp;quot;Noto Sans&amp;quot;, &amp;quot;Liberation Sans&amp;quot;, sans-serif, &amp;quot;Apple Color Emoji&amp;quot;, &amp;quot;Segoe UI Emoji&amp;quot;, &amp;quot;Segoe UI Symbol&amp;quot;, &amp;quot;Noto Color Emoji&amp;quot;; user-select: text !important;&quot;&gt;在任何情况下，我们都不对您因使用本网站或依赖本网站提供的任何信息而产生的任何损失或损害承担责任。您对本网站的使用和对网站上任何信息的依赖完全由您自己承担风险。&lt;/p&gt;&lt;h2 style=&quot;margin-top: 0px; margin-bottom: 1rem; line-height: 1.2; font-size: 1.25rem; -webkit-font-smoothing: antialiased; border-left: 3px solid rgb(89, 97, 249); padding: 0.25rem 0px 0.25rem 1.25rem; margin-left: -1.438rem; border-top-color: rgb(89, 97, 249); border-right-color: rgb(89, 97, 249); border-bottom-color: rgb(89, 97, 249); color: rgb(40, 42, 45); font-family: -apple-system, BlinkMacSystemFont, &amp;quot;Segoe UI&amp;quot;, Roboto, &amp;quot;Helvetica Neue&amp;quot;, Arial, &amp;quot;Noto Sans&amp;quot;, &amp;quot;Liberation Sans&amp;quot;, sans-serif, &amp;quot;Apple Color Emoji&amp;quot;, &amp;quot;Segoe UI Emoji&amp;quot;, &amp;quot;Segoe UI Symbol&amp;quot;, &amp;quot;Noto Color Emoji&amp;quot;; user-select: text !important;&quot;&gt;AI工具和技术&lt;/h2&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 1.25rem; color: rgb(29, 35, 43); font-size: 16px; line-height: 2; overflow-wrap: break-word; font-family: -apple-system, BlinkMacSystemFont, &amp;quot;Segoe UI&amp;quot;, Roboto, &amp;quot;Helvetica Neue&amp;quot;, Arial, &amp;quot;Noto Sans&amp;quot;, &amp;quot;Liberation Sans&amp;quot;, sans-serif, &amp;quot;Apple Color Emoji&amp;quot;, &amp;quot;Segoe UI Emoji&amp;quot;, &amp;quot;Segoe UI Symbol&amp;quot;, &amp;quot;Noto Color Emoji&amp;quot;; user-select: text !important;&quot;&gt;AI工具集网站展示了各种AI工具和技术，这些工具和技术可能存在局限性和错误。我们不保证这些人工智能工具和技术的准确性、可靠性或有效性。网站的用户应自行承担使用这些工具的风险并自行决定。我们不对使用这些人工智能工具和技术可能产生的任何问题、损害或损失负责。&lt;/p&gt;&lt;h2 style=&quot;margin-top: 0px; margin-bottom: 1rem; line-height: 1.2; font-size: 1.25rem; -webkit-font-smoothing: antialiased; border-left: 3px solid rgb(89, 97, 249); padding: 0.25rem 0px 0.25rem 1.25rem; margin-left: -1.438rem; border-top-color: rgb(89, 97, 249); border-right-color: rgb(89, 97, 249); border-bottom-color: rgb(89, 97, 249); color: rgb(40, 42, 45); font-family: -apple-system, BlinkMacSystemFont, &amp;quot;Segoe UI&amp;quot;, Roboto, &amp;quot;Helvetica Neue&amp;quot;, Arial, &amp;quot;Noto Sans&amp;quot;, &amp;quot;Liberation Sans&amp;quot;, sans-serif, &amp;quot;Apple Color Emoji&amp;quot;, &amp;quot;Segoe UI Emoji&amp;quot;, &amp;quot;Segoe UI Symbol&amp;quot;, &amp;quot;Noto Color Emoji&amp;quot;; user-select: text !important;&quot;&gt;专业建议免责声明&lt;/h2&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 1.25rem; color: rgb(29, 35, 43); font-size: 16px; line-height: 2; overflow-wrap: break-word; font-family: -apple-system, BlinkMacSystemFont, &amp;quot;Segoe UI&amp;quot;, Roboto, &amp;quot;Helvetica Neue&amp;quot;, Arial, &amp;quot;Noto Sans&amp;quot;, &amp;quot;Liberation Sans&amp;quot;, sans-serif, &amp;quot;Apple Color Emoji&amp;quot;, &amp;quot;Segoe UI Emoji&amp;quot;, &amp;quot;Segoe UI Symbol&amp;quot;, &amp;quot;Noto Color Emoji&amp;quot;; user-select: text !important;&quot;&gt;本网站无意提供任何形式的专业建议，包括但不限于法律、财务、医疗或技术建议。本网站的内容不应视为可以替代向相关领域的合格专家寻求专业意见。对于根据本网站提供的信息采取的任何行动，我们不承担任何责任和义务。&lt;/p&gt;&lt;h2 style=&quot;margin-top: 0px; margin-bottom: 1rem; line-height: 1.2; font-size: 1.25rem; -webkit-font-smoothing: antialiased; border-left: 3px solid rgb(89, 97, 249); padding: 0.25rem 0px 0.25rem 1.25rem; margin-left: -1.438rem; border-top-color: rgb(89, 97, 249); border-right-color: rgb(89, 97, 249); border-bottom-color: rgb(89, 97, 249); color: rgb(40, 42, 45); font-family: -apple-system, BlinkMacSystemFont, &amp;quot;Segoe UI&amp;quot;, Roboto, &amp;quot;Helvetica Neue&amp;quot;, Arial, &amp;quot;Noto Sans&amp;quot;, &amp;quot;Liberation Sans&amp;quot;, sans-serif, &amp;quot;Apple Color Emoji&amp;quot;, &amp;quot;Segoe UI Emoji&amp;quot;, &amp;quot;Segoe UI Symbol&amp;quot;, &amp;quot;Noto Color Emoji&amp;quot;; user-select: text !important;&quot;&gt;外部链接&lt;/h2&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 1.25rem; color: rgb(29, 35, 43); font-size: 16px; line-height: 2; overflow-wrap: break-word; font-family: -apple-system, BlinkMacSystemFont, &amp;quot;Segoe UI&amp;quot;, Roboto, &amp;quot;Helvetica Neue&amp;quot;, Arial, &amp;quot;Noto Sans&amp;quot;, &amp;quot;Liberation Sans&amp;quot;, sans-serif, &amp;quot;Apple Color Emoji&amp;quot;, &amp;quot;Segoe UI Emoji&amp;quot;, &amp;quot;Segoe UI Symbol&amp;quot;, &amp;quot;Noto Color Emoji&amp;quot;; user-select: text !important;&quot;&gt;本网站可能包含（或通过本网站向您发送）属于或来自第三方的其他网站或内容的链接，或横幅或其他广告中的网站和功能链接。这些外部链接的准确性、充分性、有效性、可靠性、可用性或完整性没有经过我们的调查、监测或检查。&lt;/p&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 1.25rem; color: rgb(29, 35, 43); font-size: 16px; line-height: 2; overflow-wrap: break-word; font-family: -apple-system, BlinkMacSystemFont, &amp;quot;Segoe UI&amp;quot;, Roboto, &amp;quot;Helvetica Neue&amp;quot;, Arial, &amp;quot;Noto Sans&amp;quot;, &amp;quot;Liberation Sans&amp;quot;, sans-serif, &amp;quot;Apple Color Emoji&amp;quot;, &amp;quot;Segoe UI Emoji&amp;quot;, &amp;quot;Segoe UI Symbol&amp;quot;, &amp;quot;Noto Color Emoji&amp;quot;; user-select: text !important;&quot;&gt;对于通过本网站链接的第三方网站或任何横幅或其他广告中链接的任何网站或功能提供的任何信息的准确性或可靠性，我们不做任何保证、认可、担保或承担任何责任。我们不会成为您与第三方产品或服务提供者之间的任何交易的一方，也不以任何方式负责监督。&lt;/p&gt;&lt;h2 style=&quot;margin-top: 0px; margin-bottom: 1rem; line-height: 1.2; font-size: 1.25rem; -webkit-font-smoothing: antialiased; border-left: 3px solid rgb(89, 97, 249); padding: 0.25rem 0px 0.25rem 1.25rem; margin-left: -1.438rem; border-top-color: rgb(89, 97, 249); border-right-color: rgb(89, 97, 249); border-bottom-color: rgb(89, 97, 249); color: rgb(40, 42, 45); font-family: -apple-system, BlinkMacSystemFont, &amp;quot;Segoe UI&amp;quot;, Roboto, &amp;quot;Helvetica Neue&amp;quot;, Arial, &amp;quot;Noto Sans&amp;quot;, &amp;quot;Liberation Sans&amp;quot;, sans-serif, &amp;quot;Apple Color Emoji&amp;quot;, &amp;quot;Segoe UI Emoji&amp;quot;, &amp;quot;Segoe UI Symbol&amp;quot;, &amp;quot;Noto Color Emoji&amp;quot;; user-select: text !important;&quot;&gt;有限责任说明&lt;/h2&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 1.25rem; color: rgb(29, 35, 43); font-size: 16px; line-height: 2; overflow-wrap: break-word; font-family: -apple-system, BlinkMacSystemFont, &amp;quot;Segoe UI&amp;quot;, Roboto, &amp;quot;Helvetica Neue&amp;quot;, Arial, &amp;quot;Noto Sans&amp;quot;, &amp;quot;Liberation Sans&amp;quot;, sans-serif, &amp;quot;Apple Color Emoji&amp;quot;, &amp;quot;Segoe UI Emoji&amp;quot;, &amp;quot;Segoe UI Symbol&amp;quot;, &amp;quot;Noto Color Emoji&amp;quot;; user-select: text !important;&quot;&gt;在任何情况下，AI工具集及其合作伙伴、代理人、供应商或附属机构均不对任何间接、附带、特殊、后果性或惩罚性的损害负责，包括但不限于利润、数据、使用、商誉或其他无形损失的损失，这些损失是由于&lt;/p&gt;&lt;ul style=&quot;margin-bottom: 1rem; font-size: 0.875rem; color: rgb(40, 42, 45); font-family: -apple-system, BlinkMacSystemFont, &amp;quot;Segoe UI&amp;quot;, Roboto, &amp;quot;Helvetica Neue&amp;quot;, Arial, &amp;quot;Noto Sans&amp;quot;, &amp;quot;Liberation Sans&amp;quot;, sans-serif, &amp;quot;Apple Color Emoji&amp;quot;, &amp;quot;Segoe UI Emoji&amp;quot;, &amp;quot;Segoe UI Symbol&amp;quot;, &amp;quot;Noto Color Emoji&amp;quot;; user-select: text !important;&quot;&gt;&lt;li style=&quot;margin: 0.5rem 0px; user-select: text !important;&quot;&gt;(i)您访问或使用或无法访问或无法使用本网站；&lt;/li&gt;&lt;li style=&quot;margin: 0.5rem 0px; user-select: text !important;&quot;&gt;(iii)您访问或使用其他假冒抄袭网站；&lt;/li&gt;&lt;li style=&quot;margin: 0.5rem 0px; user-select: text !important;&quot;&gt;(iii)任何第三方在网站上的行为或内容；&lt;/li&gt;&lt;li style=&quot;margin: 0.5rem 0px; user-select: text !important;&quot;&gt;(iv)从网站上获得的任何内容，以及&lt;/li&gt;&lt;li style=&quot;margin: 0.5rem 0px; user-select: text !important;&quot;&gt;(vi)未经授权访问、使用或更改您的传输或内容，无论是否基于保证、合同、侵权行为（包括疏忽）或任何其他法律理论，无论我们是否已被告知此类损害的可能性，而且即使本文规定的补救措施被发现未能达到其基本目的。&lt;/li&gt;&lt;/ul&gt;&lt;h2 style=&quot;margin-top: 0px; margin-bottom: 1rem; line-height: 1.2; font-size: 1.25rem; -webkit-font-smoothing: antialiased; border-left: 3px solid rgb(89, 97, 249); padding: 0.25rem 0px 0.25rem 1.25rem; margin-left: -1.438rem; border-top-color: rgb(89, 97, 249); border-right-color: rgb(89, 97, 249); border-bottom-color: rgb(89, 97, 249); color: rgb(40, 42, 45); font-family: -apple-system, BlinkMacSystemFont, &amp;quot;Segoe UI&amp;quot;, Roboto, &amp;quot;Helvetica Neue&amp;quot;, Arial, &amp;quot;Noto Sans&amp;quot;, &amp;quot;Liberation Sans&amp;quot;, sans-serif, &amp;quot;Apple Color Emoji&amp;quot;, &amp;quot;Segoe UI Emoji&amp;quot;, &amp;quot;Segoe UI Symbol&amp;quot;, &amp;quot;Noto Color Emoji&amp;quot;; user-select: text !important;&quot;&gt;对本声明的修改&lt;/h2&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 1.25rem; color: rgb(29, 35, 43); font-size: 16px; line-height: 2; overflow-wrap: break-word; font-family: -apple-system, BlinkMacSystemFont, &amp;quot;Segoe UI&amp;quot;, Roboto, &amp;quot;Helvetica Neue&amp;quot;, Arial, &amp;quot;Noto Sans&amp;quot;, &amp;quot;Liberation Sans&amp;quot;, sans-serif, &amp;quot;Apple Color Emoji&amp;quot;, &amp;quot;Segoe UI Emoji&amp;quot;, &amp;quot;Segoe UI Symbol&amp;quot;, &amp;quot;Noto Color Emoji&amp;quot;; user-select: text !important;&quot;&gt;我们保留自行决定在任何时候修改或替换本免责声明的权利。如果修改是实质性的，我们将做出合理的努力，在任何新条款生效前至少提前30天通知。什么是实质性的修改，将由我们全权决定。&lt;/p&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 1.25rem; color: rgb(29, 35, 43); font-size: 16px; line-height: 2; overflow-wrap: break-word; font-family: -apple-system, BlinkMacSystemFont, &amp;quot;Segoe UI&amp;quot;, Roboto, &amp;quot;Helvetica Neue&amp;quot;, Arial, &amp;quot;Noto Sans&amp;quot;, &amp;quot;Liberation Sans&amp;quot;, sans-serif, &amp;quot;Apple Color Emoji&amp;quot;, &amp;quot;Segoe UI Emoji&amp;quot;, &amp;quot;Segoe UI Symbol&amp;quot;, &amp;quot;Noto Color Emoji&amp;quot;; user-select: text !important;&quot;&gt;在任何修订生效后继续访问或使用我们的网站，即表示您同意接受修订后的条款的约束。如果您不同意新的条款，您将不再被授权使用本网站。&lt;/p&gt;&lt;h2 style=&quot;margin-top: 0px; margin-bottom: 1rem; line-height: 1.2; font-size: 1.25rem; -webkit-font-smoothing: antialiased; border-left: 3px solid rgb(89, 97, 249); padding: 0.25rem 0px 0.25rem 1.25rem; margin-left: -1.438rem; border-top-color: rgb(89, 97, 249); border-right-color: rgb(89, 97, 249); border-bottom-color: rgb(89, 97, 249); color: rgb(40, 42, 45); font-family: -apple-system, BlinkMacSystemFont, &amp;quot;Segoe UI&amp;quot;, Roboto, &amp;quot;Helvetica Neue&amp;quot;, Arial, &amp;quot;Noto Sans&amp;quot;, &amp;quot;Liberation Sans&amp;quot;, sans-serif, &amp;quot;Apple Color Emoji&amp;quot;, &amp;quot;Segoe UI Emoji&amp;quot;, &amp;quot;Segoe UI Symbol&amp;quot;, &amp;quot;Noto Color Emoji&amp;quot;; user-select: text !important;&quot;&gt;联系我们&lt;/h2&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 1.25rem; color: rgb(29, 35, 43); font-size: 16px; line-height: 2; overflow-wrap: break-word; font-family: -apple-system, BlinkMacSystemFont, &amp;quot;Segoe UI&amp;quot;, Roboto, &amp;quot;Helvetica Neue&amp;quot;, Arial, &amp;quot;Noto Sans&amp;quot;, &amp;quot;Liberation Sans&amp;quot;, sans-serif, &amp;quot;Apple Color Emoji&amp;quot;, &amp;quot;Segoe UI Emoji&amp;quot;, &amp;quot;Segoe UI Symbol&amp;quot;, &amp;quot;Noto Color Emoji&amp;quot;; user-select: text !important;&quot;&gt;如果您对本声明有任何疑问，请通过电子邮件&lt;a href=&quot;mailto:info@ai-baidu.cn&quot; target=&quot;_blank&quot;&gt;info@baiud.&lt;/a&gt;com联系我们。&lt;/p&gt;',	'{\"disabled\":\"0\",\"linkurl\":\"\",\"getchild\":\"0\",\"notedit\":0,\"urlrule\":2,\"seo\":{\"list_title\":\"[第{page}页{join}]{catpname}{join}{SITE_NAME}\",\"list_keywords\":\"免责声明\",\"list_description\":\"免责声明描述\"},\"template\":{\"pagesize\":\"20\",\"mpagesize\":\"20\",\"page\":\"page.html\",\"list\":\"list.html\",\"category\":\"category.html\",\"search\":\"search.html\",\"show\":\"show.html\"},\"cat_field\":null,\"module_field\":null}',	0,	'免责声明'),
                                                                                                                                                                                                                     (4,	1,	1,	'blog',	'0,1',	'AI快讯',	'ai-express',	'blog/',	0,	0,	1,	'4',	'',	1,	'',	'{\"edit\":1,\"disabled\":0,\"template\":{\"list\":\"list.html\",\"show\":\"show.html\",\"category\":\"category.html\",\"search\":\"search.html\",\"pagesize\":20,\"mpagesize\":20},\"seo\":{\"list_title\":\"[第{page}页{join}]{name}{join}{SITE_NAME}\",\"show_title\":\"[第{page}页{join}]{title}{join}{catname}{join}{SITE_NAME}\"},\"getchild\":0,\"html\":0,\"chtml\":0,\"urlrule\":2}',	0,	NULL),
                                                                                                                                                                                                                     (5,	1,	1,	'blog',	'0,1',	'AI教程',	'ai-tutorial',	'blog/',	0,	0,	1,	'5',	'',	1,	'',	'{\"edit\":1,\"disabled\":0,\"template\":{\"list\":\"list.html\",\"show\":\"show.html\",\"category\":\"category.html\",\"search\":\"search.html\",\"pagesize\":20,\"mpagesize\":20},\"seo\":{\"list_title\":\"[第{page}页{join}]{name}{join}{SITE_NAME}\",\"show_title\":\"[第{page}页{join}]{title}{join}{catname}{join}{SITE_NAME}\"},\"getchild\":0,\"html\":0,\"chtml\":0,\"urlrule\":2}',	0,	NULL);

DROP TABLE IF EXISTS `fhx_1_share_index`;
CREATE TABLE `fhx_1_share_index` (
                                     `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
                                     `mid` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '模块目录',
                                     PRIMARY KEY (`id`),
                                     KEY `mid` (`mid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='共享模块内容索引表';

INSERT INTO `fhx_1_share_index` (`id`, `mid`) VALUES
                                                  (1,	'blog'),
                                                  (2,	'blog'),
                                                  (3,	'blog'),
                                                  (4,	'blog'),
                                                  (5,	'blog');

DROP TABLE IF EXISTS `fhx_1_tag`;
CREATE TABLE `fhx_1_tag` (
                             `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
                             `pid` int(10) DEFAULT '0' COMMENT '父级id',
                             `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '关键词名称',
                             `code` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '关键词代码',
                             `pcode` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '关键词代码',
                             `hits` int(10) unsigned NOT NULL COMMENT '点击量(废除)',
                             `childids` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '子类集合',
                             `content` text COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '关键词描述',
                             `displayorder` int(10) NOT NULL COMMENT '排序',
                             PRIMARY KEY (`id`),
                             UNIQUE KEY `name` (`name`),
                             KEY `letter` (`code`,`hits`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='关键词库表';

INSERT INTO `fhx_1_tag` (`id`, `pid`, `name`, `code`, `pcode`, `hits`, `childids`, `content`, `displayorder`) VALUES
                                                                                                                  (1,	0,	'AI编程工具',	'aibianchenggongju',	'aibianchenggongju',	0,	'',	'',	0),
                                                                                                                  (2,	0,	'AI音频工具',	'aiyinpingongju',	'aiyinpingongju',	0,	'',	'',	0),
                                                                                                                  (3,	0,	'AI设计工具',	'aishejigongju',	'aishejigongju',	0,	'',	'',	0),
                                                                                                                  (4,	0,	'AI图片优化修复',	'aitupianyouhuaxiufu',	'aitupianyouhuaxiufu',	0,	'',	'',	0),
                                                                                                                  (5,	0,	'AI训练模型',	'aixunlianmoxing',	'aixunlianmoxing',	0,	'',	'',	0),
                                                                                                                  (6,	0,	'AI写作工具',	'aixiezuogongju',	'aixiezuogongju',	0,	'',	'',	0),
                                                                                                                  (7,	0,	'AI思维导图',	'aisiweidaotu',	'aisiweidaotu',	0,	'',	'',	0),
                                                                                                                  (8,	0,	'AI表格数据处理',	'aibiaogeshujuchuli',	'aibiaogeshujuchuli',	0,	'',	'',	0),
                                                                                                                  (9,	0,	'AI效率提升',	'aixiaolutisheng',	'aixiaolutisheng',	0,	'',	'',	0),
                                                                                                                  (10,	0,	'AI会议工具',	'aihuiyigongju',	'aihuiyigongju',	0,	'',	'',	0),
                                                                                                                  (11,	0,	'AI文档工具',	'aiwendanggongju',	'aiwendanggongju',	0,	'',	'',	0),
                                                                                                                  (12,	0,	'热门AI办公工具',	'remenaibangonggongju',	'remenaibangonggongju',	0,	'',	'',	0),
                                                                                                                  (13,	0,	'AI图片无损放大',	'aitupianwusunfangda',	'aitupianwusunfangda',	0,	'',	'',	0),
                                                                                                                  (14,	0,	'常用AI图像工具',	'changyongaituxianggongju',	'changyongaituxianggongju',	0,	'',	'',	0),
                                                                                                                  (15,	0,	'AI图片背景移除',	'aitupianbeijingyichu',	'aitupianbeijingyichu',	0,	'',	'',	0),
                                                                                                                  (16,	0,	'AI图片物体抹除',	'aitupianwutimochu',	'aitupianwutimochu',	0,	'',	'',	0),
                                                                                                                  (17,	0,	'AI图片插画生成',	'aitupianchahuashengcheng',	'aitupianchahuashengcheng',	0,	'',	'',	0),
                                                                                                                  (18,	0,	'常用AI工具',	'changyongaigongju',	'changyongaigongju',	0,	'',	'',	0),
                                                                                                                  (19,	0,	'AI视频工具',	'aishipingongju',	'aishipingongju',	0,	'',	'',	0),
                                                                                                                  (20,	0,	'AI对话工具',	'aiduihuagongju',	'aiduihuagongju',	0,	'',	'',	0),
                                                                                                                  (21,	0,	'AI幻灯片和演示',	'aihuandengpianheyanshi',	'aihuandengpianheyanshi',	0,	'',	'',	0),
                                                                                                                  (22,	0,	'AI内容检测',	'aineirongjiance',	'aineirongjiance',	0,	'',	'',	0),
                                                                                                                  (23,	0,	'AI提示指令',	'aitishizhiling',	'aitishizhiling',	0,	'',	'',	0),
                                                                                                                  (24,	0,	'AI模型评测',	'aimoxingpingce',	'aimoxingpingce',	0,	'',	'',	0),
                                                                                                                  (25,	0,	'AI学习网站',	'aixuexiwangzhan',	'aixuexiwangzhan',	0,	'',	'',	0),
                                                                                                                  (26,	0,	'AI开发框架',	'aikaifakuangjia',	'aikaifakuangjia',	0,	'',	'',	0),
                                                                                                                  (27,	0,	'AI文生图软件',	'aiwenshengturuanjian',	'aiwenshengturuanjian',	0,	'',	'',	0),
                                                                                                                  (28,	0,	'AI家居设计软件',	'aijiajushejiruanjian',	'aijiajushejiruanjian',	0,	'',	'',	0),
                                                                                                                  (29,	0,	'预测',	'yuce',	'yuce',	0,	'',	'',	0),
                                                                                                                  (30,	0,	'3D运动',	'3dyundong',	'3dyundong',	0,	'',	'',	0);

DROP TABLE IF EXISTS `fhx_1_tag_blog`;
CREATE TABLE `fhx_1_tag_blog` (
                                  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
                                  `cid` int(10) unsigned NOT NULL COMMENT '内容id',
                                  `tid` int(10) unsigned NOT NULL COMMENT 'tagid',
                                  PRIMARY KEY (`id`),
                                  UNIQUE KEY `cindex` (`cid`,`tid`),
                                  KEY `tid` (`tid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='关键词库blog索引表';


DROP TABLE IF EXISTS `fhx_1_tag_webnav`;
CREATE TABLE `fhx_1_tag_webnav` (
                                    `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
                                    `cid` int(10) unsigned NOT NULL COMMENT '内容id',
                                    `tid` int(10) unsigned NOT NULL COMMENT 'tagid',
                                    PRIMARY KEY (`id`),
                                    UNIQUE KEY `cindex` (`cid`,`tid`),
                                    KEY `tid` (`tid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='关键词库webnav索引表';


DROP TABLE IF EXISTS `fhx_1_webnav`;
CREATE TABLE `fhx_1_webnav` (
                                `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
                                `catid` smallint(5) unsigned NOT NULL COMMENT '栏目id',
                                `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '主题',
                                `thumb` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '缩略图',
                                `keywords` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '关键字',
                                `description` text COLLATE utf8mb4_unicode_ci COMMENT '描述',
                                `hits` int(10) unsigned DEFAULT NULL COMMENT '浏览数',
                                `uid` int(10) unsigned NOT NULL COMMENT '作者id',
                                `author` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '笔名',
                                `status` tinyint(2) NOT NULL COMMENT '状态(已废弃)',
                                `url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '地址',
                                `link_id` int(10) NOT NULL DEFAULT '0' COMMENT '同步id',
                                `tableid` smallint(5) unsigned NOT NULL COMMENT '附表id',
                                `inputip` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '客户端ip信息',
                                `inputtime` int(10) unsigned NOT NULL COMMENT '录入时间',
                                `updatetime` int(10) unsigned NOT NULL COMMENT '更新时间',
                                `displayorder` int(10) DEFAULT '0' COMMENT '排序值',
                                `tubiao` varchar(300) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '图标',
                                `catids` text COLLATE utf8mb4_unicode_ci COMMENT '副栏目',
                                `website` varchar(600) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '网址',
                                `support` int(10) unsigned DEFAULT '0' COMMENT '支持数',
                                `oppose` int(10) unsigned DEFAULT '0' COMMENT '反对数',
                                `fankui_total` int(10) unsigned DEFAULT '0' COMMENT '表单反馈统计',
                                PRIMARY KEY (`id`),
                                KEY `uid` (`uid`),
                                KEY `catid` (`catid`),
                                KEY `link_id` (`link_id`),
                                KEY `status` (`status`),
                                KEY `updatetime` (`updatetime`),
                                KEY `hits` (`hits`),
                                KEY `category` (`catid`,`status`),
                                KEY `displayorder` (`displayorder`),
                                KEY `fankui_total` (`fankui_total`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='内容主表';

INSERT INTO `fhx_1_webnav` (`id`, `catid`, `title`, `thumb`, `keywords`, `description`, `hits`, `uid`, `author`, `status`, `url`, `link_id`, `tableid`, `inputip`, `inputtime`, `updatetime`, `displayorder`, `tubiao`, `catids`, `website`, `support`, `oppose`, `fankui_total`) VALUES
                                                                                                                                                                                                                                                                                      (3,	1,	'Writer',	'98',	'AI写作工具',	'企业级AI内容创作工具',	94,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/3.html',	0,	0,	'127.0.0.1',	1702547301,	1702547301,	0,	'99',	NULL,	'https://cn.bing.com/search?q=Writer&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (5,	1,	'Elephas',	'49',	'AI写作工具',	'与Mac、iPhone、iPad集成的个人写作助手',	38,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/5.html',	0,	0,	'127.0.0.1',	1702547304,	1702547304,	0,	'102',	NULL,	'https://cn.bing.com/search?q=Elephas&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (9,	1,	'ParagraphAI',	'47',	'AI写作工具',	'基于ChatGPT的AI写作应用',	63,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/9.html',	0,	0,	'127.0.0.1',	1702547251,	1702547251,	0,	'107',	NULL,	'https://cn.bing.com/search?q=ParagraphAI&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (10,	1,	'Hypotenuse AI',	'46',	'AI写作工具',	'人工智能写作助手和文本生成器',	39,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/10.html',	0,	0,	'127.0.0.1',	1702547247,	1702547247,	0,	'109',	NULL,	'https://cn.bing.com/search?q=Hypotenuse AI&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (11,	1,	'Mark Copy',	'83',	'AI写作工具',	'AI快速创建营销文案',	67,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/11.html',	0,	0,	'127.0.0.1',	1702547268,	1702547268,	0,	'84',	NULL,	'https://cn.bing.com/search?q=Mark Copy&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (15,	1,	'Copymatic',	'88',	'AI写作工具',	'AI文案和内容创作助手',	84,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/15.html',	0,	0,	'127.0.0.1',	1702547233,	1702547233,	0,	'89',	NULL,	'https://cn.bing.com/search?q=Copymatic&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (16,	1,	'NeuralText',	'90',	'AI写作工具',	'人工智能SEO文章写作助手',	98,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/16.html',	0,	0,	'127.0.0.1',	1702547283,	1702547283,	0,	'91',	NULL,	'https://cn.bing.com/search?q=NeuralText&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (21,	1,	'Anyword',	'110',	'AI写作工具',	'AI文案写作助手和文本生成器',	72,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/21.html',	0,	0,	'127.0.0.1',	1702547345,	1702547345,	0,	'111',	NULL,	'https://cn.bing.com/search?q=Anyword&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (22,	1,	'WPS智能写作',	'48',	'AI写作工具',	'WPS旗下在线智能写作工具',	13,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/22.html',	0,	0,	'127.0.0.1',	1702547255,	1702547255,	0,	'113',	NULL,	'https://ai-bot.cn',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (23,	1,	'ClosersCopy',	'45',	'AI写作工具',	'AI文案写作机器人',	34,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/23.html',	0,	0,	'127.0.0.1',	1702547312,	1702547312,	0,	'82',	NULL,	'https://cn.bing.com/search?q=ClosersCopy&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (24,	1,	'Sudowrite',	'44',	'AI写作工具',	'AI故事写作工具，多种风格选择',	55,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/24.html',	0,	0,	'127.0.0.1',	1702547333,	1702547333,	0,	'79',	NULL,	'https://cn.bing.com/search?q=Sudowrite&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (25,	1,	'Texta',	'41',	'AI写作工具',	'AI博客和文章一键生成',	92,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/25.html',	0,	0,	'127.0.0.1',	1702547301,	1702547301,	0,	'77',	NULL,	'https://cn.bing.com/search?q=Texta&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (26,	1,	'Compose AI',	'42',	'AI写作工具',	'免费的Chrome浏览器自动化写作扩展',	68,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/26.html',	0,	0,	'127.0.0.1',	1702547285,	1702547285,	0,	'75',	NULL,	'https://cn.bing.com/search?q=Compose AI&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (27,	1,	'Peppertype.ai',	'43',	'AI写作工具',	'高质量AI内容生成',	61,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/27.html',	0,	0,	'127.0.0.1',	1702547340,	1702547340,	0,	'73',	NULL,	'https://cn.bing.com/search?q=Peppertype.ai&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (28,	1,	'快文CopyDone',	'40',	'AI写作工具',	'AIGC原创内容创作和营销文案生成',	81,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/28.html',	0,	0,	'127.0.0.1',	1702547289,	1702547289,	0,	'71',	NULL,	'https://copyai.cn/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (29,	1,	'Bearly',	'38',	'AI写作工具',	'AI阅读总结、写作和内容生成助手',	62,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/29.html',	0,	0,	'127.0.0.1',	1702547272,	1702547272,	0,	'69',	NULL,	'https://cn.bing.com/search?q=Bearly&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (30,	1,	'ContentBot',	'39',	'AI写作工具',	'AI快速写作工具',	12,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/30.html',	0,	0,	'127.0.0.1',	1702547338,	1702547338,	0,	'67',	NULL,	'https://cn.bing.com/search?q=ContentBot&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (31,	1,	'讯飞智检',	'37',	'AI写作工具',	'讯飞推出的智能写作SaaS工具，支持智能写作后的校对与合规审核',	71,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/31.html',	0,	0,	'127.0.0.1',	1702547361,	1702547361,	0,	'65',	NULL,	'https://zj.xfyun.cn/exam/text',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (32,	1,	'字符狂飙',	'35',	'AI写作工具',	'全方位AI文档生成工具，快速生成专业文档',	60,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/32.html',	0,	0,	'127.0.0.1',	1702547307,	1702547307,	0,	'63',	NULL,	'https://vgoapp.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (33,	1,	'创作王',	'36',	'AI写作工具',	'AI一键帮助你创作营销内容',	58,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/33.html',	0,	0,	'127.0.0.1',	1702547369,	1702547369,	0,	'167',	NULL,	'https://aiapp.cc/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (34,	1,	'智搜',	'33',	'AI写作工具',	'Giiso写作机器人，内容创作AI辅助工具',	24,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/34.html',	0,	0,	'127.0.0.1',	1702547330,	1702547330,	0,	'170',	NULL,	'https://www.giiso.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (35,	1,	'易撰',	'34',	'AI写作工具',	'新媒体AI内容创作助手',	87,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/35.html',	0,	0,	'127.0.0.1',	1702547335,	1702547335,	0,	'172',	NULL,	'https://www.yizhuan5.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (36,	1,	'爱改写',	'32',	'AI写作工具',	'AI改写、纠错、润色辅助工具',	18,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/36.html',	0,	0,	'127.0.0.1',	1702547316,	1702547316,	0,	'174',	NULL,	'https://www.aigaixie.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (38,	1,	'火龙果写作',	'30',	'AI写作工具',	'AI驱动的文字生产力工具',	53,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/38.html',	0,	0,	'127.0.0.1',	1702547383,	1702547383,	0,	'177',	NULL,	'https://www.mypitaya.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (39,	1,	'文涌Effidit',	'29',	'AI写作工具',	'腾讯AI Lab开发的智能创作助手',	37,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/39.html',	0,	0,	'127.0.0.1',	1702547387,	1702547387,	0,	'60',	NULL,	'https://effidit.qq.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (41,	1,	'Typeface AI',	'28',	'AI写作工具',	'AI创意内容创作助手',	53,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/41.html',	0,	0,	'127.0.0.1',	1702547328,	1702547328,	0,	'183',	NULL,	'https://cn.bing.com/search?q=Typeface AI&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (42,	1,	'HyperWrite',	'31',	'AI写作工具',	'AI写作助手帮助你创作内容更自信',	75,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/42.html',	0,	0,	'127.0.0.1',	1702547389,	1702547389,	0,	'185',	NULL,	'https://cn.bing.com/search?q=HyperWrite&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (43,	1,	'Spell.tools',	'26',	'AI写作工具',	'高颜值AI内容营销创作工具',	26,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/43.html',	0,	0,	'127.0.0.1',	1702547342,	1702547342,	0,	'187',	NULL,	'https://cn.bing.com/search?q=Spell.tools&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (44,	1,	'NovelAI',	'25',	'AI写作工具',	'AI小说故事创作工具',	94,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/44.html',	0,	0,	'127.0.0.1',	1702547376,	1702547376,	0,	'189',	NULL,	'https://cn.bing.com/search?q=NovelAI&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (45,	1,	'Magic Write',	'24',	'AI写作工具',	'Canva旗下AI文案生成器',	63,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/45.html',	0,	0,	'127.0.0.1',	1702547367,	1702547367,	0,	'191',	NULL,	'https://cn.bing.com/search?q=Magic Write&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (46,	1,	'彩云小梦',	'23',	'AI写作工具',	'彩云科技推出的智能AI故事写作工具',	74,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/46.html',	0,	0,	'127.0.0.1',	1702547379,	1702547379,	0,	'193',	NULL,	'https://if.caiyunai.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (47,	1,	'度加创作工具',	'27',	'AI写作工具,AI视频工具',	'百度官方出品的AIGC创作平台',	20,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/47.html',	0,	0,	'127.0.0.1',	1702547391,	1702547391,	0,	'196',	NULL,	'https://aigc.baidu.com/?utm_source=ai-bot.cn',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (48,	1,	'Cohesive',	'22',	'AI写作工具',	'人工智能文案内容创作和编辑工具',	86,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/48.html',	0,	0,	'127.0.0.1',	1702547426,	1702547426,	0,	'199',	NULL,	'https://cn.bing.com/search?q=Cohesive&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (49,	1,	'Moonbeam',	'19',	'AI写作工具',	'长文章AI内容创作助手',	73,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/49.html',	0,	0,	'127.0.0.1',	1702547388,	1702547388,	0,	'201',	NULL,	'https://cn.bing.com/search?q=Moonbeam&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (50,	1,	'Verse',	'20',	'AI写作工具',	'印象笔记旗下团队推出的AI写作和文档工具',	87,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/50.html',	0,	0,	'127.0.0.1',	1702547390,	1702547390,	0,	'203',	NULL,	'https://verse.app.yinxiang.com/product/?utm_source=ai-bot.cn',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (51,	1,	'爱创作',	'11',	'AI写作工具',	'ZAKER新闻推出的AI写作工具',	99,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/51.html',	0,	0,	'127.0.0.1',	1702547370,	1702547370,	0,	'206',	NULL,	'https://ai.zaker.cn/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (52,	1,	'WriteWise',	'56',	'AI写作工具',	'喜马拉雅推出的免费网文和小说AI写作工具',	35,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/52.html',	0,	0,	'127.0.0.1',	1702547350,	1702547350,	0,	'57',	NULL,	'https://www.ximalaya.com/gatekeeper/write-wise-web',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (53,	1,	'写作蛙',	'10',	'AI写作工具',	'智谱AI推出的免费智能写作工具',	71,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/53.html',	0,	0,	'127.0.0.1',	1702547371,	1702547371,	0,	'212',	NULL,	'https://littlefrog.ai/?utm_source=ai-bot.cn',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (54,	1,	'有道写作',	'9',	'AI写作工具',	'网易有道出品的智能英文写作修改和润色工具',	41,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/54.html',	0,	0,	'127.0.0.1',	1702547387,	1702547387,	0,	'215',	NULL,	'https://write.youdao.com/#/homepage',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (55,	1,	'深言达意',	'53',	'AI写作工具',	'免费的词句查询智能写作辅助工具，输入模糊描述即可查找词句',	99,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/55.html',	0,	0,	'127.0.0.1',	1702547414,	1702547414,	0,	'54',	NULL,	'https://www.shenyandayi.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (56,	1,	'魔撰写作',	'8',	'AI写作工具',	'出门问问旗下推出的AI智能写作工具',	38,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/56.html',	0,	0,	'127.0.0.1',	1702547416,	1702547416,	0,	'220',	NULL,	'https://x.moyin.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (57,	1,	'奇妙文',	'18',	'AI写作工具',	'出门问问推出的AI写作助理',	24,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/57.html',	0,	0,	'127.0.0.1',	1702547437,	1702547437,	0,	'223',	NULL,	'https://wen.mobvoi.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (58,	1,	'星火内容运营大师',	'50',	'AI写作工具',	'基于讯飞星火的AI智能写作和内容运营工具',	69,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/58.html',	0,	0,	'127.0.0.1',	1702547404,	1702547404,	0,	'51',	NULL,	'https://turbodesk.xfyun.cn/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (59,	1,	'Jenni',	'21',	'AI写作工具',	'AI研究文章和博客写作辅助工具',	93,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/59.html',	0,	0,	'127.0.0.1',	1702547397,	1702547397,	0,	'228',	NULL,	'https://cn.bing.com/search?q=Jenni&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (60,	1,	'Coda AI',	'13',	'AI写作工具,AI文档工具',	'在线协作平台Coda推出的AI写作和文档助手，类似于Notion AI',	55,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/60.html',	0,	0,	'127.0.0.1',	1702547384,	1702547384,	0,	'232',	'[\"1\",\"23\"]',	'https://coda.io/product/ai?utm_source=ai-bot.cn',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (61,	1,	'DeepL Write',	'15',	'AI写作工具',	'DeepL推出的AI驱动的写作助手',	21,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/61.html',	0,	0,	'127.0.0.1',	1702547444,	1702547444,	0,	'235',	NULL,	'https://www.deepl.com/write',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (62,	1,	'万彩AI',	'14',	'AI写作工具',	'全能型AI内容和文案创作助手',	67,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/62.html',	0,	0,	'127.0.0.1',	1702547442,	1702547442,	0,	'238',	NULL,	'https://ai.kezhan365.com/inviteCode/FwJFxy',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (63,	1,	'Notion AI',	'16',	'AI写作工具',	'Notion推出的AI内容创作助手',	37,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/63.html',	0,	0,	'127.0.0.1',	1702547472,	1702547472,	0,	'240',	NULL,	'https://cn.bing.com/search?q=Notion AI&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (64,	1,	'QuillBot',	'12',	'AI写作工具',	'AI英/德语写作润色和改进工具',	62,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/64.html',	0,	0,	'127.0.0.1',	1702547455,	1702547455,	0,	'243',	NULL,	'https://try.quillbot.com/6eqrqpoysmlh',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (65,	1,	'晓语台',	'245',	'AI写作工具',	'智能AI写作工具，内置500+创作模板',	85,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/65.html',	0,	0,	'127.0.0.1',	1702547404,	1702547404,	0,	'246',	NULL,	'https://www.xiaoyutai.com/?share_code=XYT90931478',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (66,	1,	'Grammarly',	'7',	'AI写作工具',	'AI英语语法和拼写检查写作助手',	81,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/66.html',	0,	0,	'127.0.0.1',	1702547416,	1702547416,	0,	'249',	NULL,	'https://www.grammarly.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (67,	1,	'Rytr',	'17',	'AI写作工具',	'AI内容生成和写作助手',	88,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/67.html',	0,	0,	'127.0.0.1',	1702547501,	1702547501,	0,	'251',	NULL,	'https://cn.bing.com/search?q=Rytr&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (68,	1,	'Writesonic',	'6',	'AI写作工具',	'AI写作，文案，释义工具',	29,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/68.html',	0,	0,	'127.0.0.1',	1702547477,	1702547477,	0,	'254',	NULL,	'https://cn.bing.com/search?q=Writesonic&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (69,	1,	'Copy.ai',	'5',	'AI写作工具',	'人工智能营销文案和内容创作工具',	41,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/69.html',	0,	0,	'127.0.0.1',	1702547474,	1702547474,	0,	'257',	NULL,	'https://cn.bing.com/search?q=Copy.ai&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (70,	1,	'Jasper',	'2',	'AI写作工具',	'AI文字内容创作工具',	91,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/70.html',	0,	0,	'127.0.0.1',	1702547475,	1702547475,	0,	'261',	NULL,	'https://cn.bing.com/search?q=Jasper&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (71,	1,	'百度作家平台',	'264',	'AI写作工具',	'百度免费AI小说写作工具',	11,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/71.html',	0,	0,	'127.0.0.1',	1702547477,	1702547477,	0,	'265',	NULL,	'https://zuojia.baidu.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (72,	1,	'秘塔写作猫',	'267',	'AI写作工具',	'AI写作，文章自成',	31,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/72.html',	0,	0,	'127.0.0.1',	1702547515,	1702547515,	0,	'268',	NULL,	'https://xiezuocat.com/?s=aigj',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (73,	11,	'Leap',	'269',	'AI开发框架',	'将AI快速集成到你自己的应用中',	89,	1,	'创始人',	9,	'/webnav/ai-frameworks/show/73.html',	0,	0,	'127.0.0.1',	1702547725,	1702547725,	0,	'270',	NULL,	'https://www.tryleap.ai/?utm_source=ai-bot.cn',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (74,	11,	'Lightning AI',	'271',	'AI开发框架',	'快速训练、部署和开发人工智能产品的深度学习框架，由Pytorch Lightning团队推出',	72,	1,	'创始人',	9,	'/webnav/ai-frameworks/show/74.html',	0,	0,	'127.0.0.1',	1702547702,	1702547702,	0,	'272',	NULL,	'https://lightning.ai/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (75,	11,	'LangChain',	'273',	'AI开发框架',	'开发由语言模型驱动的应用程序的框架',	56,	1,	'创始人',	9,	'/webnav/ai-frameworks/show/75.html',	0,	0,	'127.0.0.1',	1702547709,	1702547709,	0,	'274',	NULL,	'https://docs.langchain.com/docs/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (76,	11,	'NLTK',	'275',	'AI开发框架',	'Python自然语言处理工具包',	61,	1,	'创始人',	9,	'/webnav/ai-frameworks/show/76.html',	0,	0,	'127.0.0.1',	1702547708,	1702547708,	0,	'276',	NULL,	'https://www.nltk.org/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (77,	11,	'JAX',	'277',	'AI开发框架',	'Google推出的用于变换数值函数的机器学习框架',	76,	1,	'创始人',	9,	'/webnav/ai-frameworks/show/77.html',	0,	0,	'127.0.0.1',	1702547679,	1702547679,	0,	'278',	NULL,	'https://jax.readthedocs.io/en/latest/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (78,	11,	'DL4J',	'279',	'AI开发框架',	'开源的使用JVM部署和训练深度学习模型的套件',	76,	1,	'创始人',	9,	'/webnav/ai-frameworks/show/78.html',	0,	0,	'127.0.0.1',	1702547667,	1702547667,	0,	'280',	NULL,	'https://deeplearning4j.konduit.ai/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (79,	11,	'NumPy',	'1520',	'AI开发框架',	'Python科学计算必备的包',	85,	1,	'创始人',	9,	'/webnav/ai-frameworks/show/79.html',	0,	0,	'127.0.0.1',	1702547726,	1702547726,	0,	'281',	NULL,	'https://numpy.org/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (80,	11,	'Caffe',	'1521',	'AI开发框架',	'UC伯克利研究推出的深度学习框架',	42,	1,	'创始人',	9,	'/webnav/ai-frameworks/show/80.html',	0,	0,	'127.0.0.1',	1702547714,	1702547714,	0,	'282',	NULL,	'https://caffe.berkeleyvision.org/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (81,	11,	'Keras',	'1522',	'AI开发框架',	'Python版本的TensorFlow深度学习API',	67,	1,	'创始人',	9,	'/webnav/ai-frameworks/show/81.html',	0,	0,	'127.0.0.1',	1702547709,	1702547709,	0,	'283',	NULL,	'https://keras.io/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (82,	11,	'Vercel AI SDK',	'284',	'AI开发框架',	'Vercel开源的搭建AI聊天机器人的开发套件，支持React/Svelte/Vue等框架',	45,	1,	'创始人',	9,	'/webnav/ai-frameworks/show/82.html',	0,	0,	'127.0.0.1',	1702547718,	1702547718,	0,	'285',	NULL,	'https://sdk.vercel.ai/docs?utm_source=ai-bot.cn',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (83,	11,	'Label Studio',	'286',	'AI开发框架',	'免费开源的数据标注工具',	70,	1,	'创始人',	9,	'/webnav/ai-frameworks/show/83.html',	0,	0,	'127.0.0.1',	1702547664,	1702547664,	0,	'287',	NULL,	'https://labelstud.io/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (84,	11,	'Scikit-learn',	'1523',	'AI开发框架',	'Python机器学习库',	51,	1,	'创始人',	9,	'/webnav/ai-frameworks/show/84.html',	0,	0,	'127.0.0.1',	1702547695,	1702547695,	0,	'289',	NULL,	'https://scikit-learn.org/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (85,	11,	'Apache MXNet',	'1524',	'AI开发框架',	'免费开源的深度学习框架',	43,	1,	'创始人',	9,	'/webnav/ai-frameworks/show/85.html',	0,	0,	'127.0.0.1',	1702547748,	1702547748,	0,	'290',	NULL,	'https://mxnet.apache.org/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (86,	11,	'昇思MindSpore',	'291',	'AI开发框架',	'华为开源自研AI深度学习框架',	84,	1,	'创始人',	9,	'/webnav/ai-frameworks/show/86.html',	0,	0,	'127.0.0.1',	1702547750,	1702547750,	0,	'292',	NULL,	'https://www.mindspore.cn/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (87,	11,	'飞桨PaddlePaddle',	'1525',	'AI开发框架',	'开源深度学习平台',	72,	1,	'创始人',	9,	'/webnav/ai-frameworks/show/87.html',	0,	0,	'127.0.0.1',	1702547723,	1702547723,	0,	'293',	NULL,	'https://www.paddlepaddle.org.cn/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (88,	11,	'PyTorch',	'1526',	'AI开发框架',	'开源机器学习框架',	17,	1,	'创始人',	9,	'/webnav/ai-frameworks/show/88.html',	0,	0,	'127.0.0.1',	1702547739,	1702547739,	0,	'294',	NULL,	'https://pytorch.org/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (89,	11,	'TensorFlow',	'1527',	'AI开发框架',	'Google推出的机器学习和人工智能开源库',	53,	1,	'创始人',	9,	'/webnav/ai-frameworks/show/89.html',	0,	0,	'127.0.0.1',	1702547679,	1702547679,	0,	'295',	NULL,	'https://www.tensorflow.org/?hl=zh-cn',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (90,	10,	'ShowMeAI知识社区',	'296',	'AI学习网站',	'人工智能领域的资料库和学习社区',	68,	1,	'创始人',	9,	'/webnav/websites-to-learn-ai/show/90.html',	0,	0,	'127.0.0.1',	1702547755,	1702547755,	0,	'297',	NULL,	'https://www.showmeai.tech/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (91,	10,	'Google AI',	'1528',	'AI学习网站',	'Google AI学习平台',	89,	1,	'创始人',	9,	'/webnav/websites-to-learn-ai/show/91.html',	0,	0,	'127.0.0.1',	1702547678,	1702547678,	0,	'298',	NULL,	'https://ai.google/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (92,	10,	'Udacity AI学院',	'299',	'AI学习网站',	'Udacity推出的School of AI，从入门到高级',	55,	1,	'创始人',	9,	'/webnav/websites-to-learn-ai/show/92.html',	0,	0,	'127.0.0.1',	1702547762,	1702547762,	0,	'300',	NULL,	'https://www.udacity.com/school/school-of-ai',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (93,	10,	'阿里云AI学习路线',	'301',	'AI学习网站',	'阿里云推出的人工智能学习路线（学+测）',	72,	1,	'创始人',	9,	'/webnav/websites-to-learn-ai/show/93.html',	0,	0,	'127.0.0.1',	1702547674,	1702547674,	0,	'302',	NULL,	'https://developer.aliyun.com/learning/roadmap/ai',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (94,	10,	'AI大学堂',	'303',	'AI学习网站',	'科大讯飞推出的AI大学堂，学习AI、走进未来',	96,	1,	'创始人',	9,	'/webnav/websites-to-learn-ai/show/94.html',	0,	0,	'127.0.0.1',	1702547747,	1702547747,	0,	'304',	NULL,	'https://www.aidaxue.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (95,	10,	'飞桨AI Studio',	'1529',	'AI学习网站',	'人工智能学习实训社区',	79,	1,	'创始人',	9,	'/webnav/websites-to-learn-ai/show/95.html',	0,	0,	'127.0.0.1',	1702547696,	1702547696,	0,	'293',	NULL,	'https://aistudio.baidu.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (96,	10,	'神经网络入门',	'306',	'AI学习网站',	'Brilliant推出的Introduction to Neural Networks课程',	62,	1,	'创始人',	9,	'/webnav/websites-to-learn-ai/show/96.html',	0,	0,	'127.0.0.1',	1702547690,	1702547690,	0,	'307',	NULL,	'https://brilliant.org/courses/intro-neural-networks/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (97,	10,	'Kaggle',	'1530',	'AI学习网站',	'机器学习和数据科学社区',	36,	1,	'创始人',	9,	'/webnav/websites-to-learn-ai/show/97.html',	0,	0,	'127.0.0.1',	1702547750,	1702547750,	0,	'308',	NULL,	'https://www.kaggle.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (98,	10,	'ML for Beginners',	'309',	'AI学习网站',	'微软推出的免费开源的机器学习课程，GitHub标星4万+',	75,	1,	'创始人',	9,	'/webnav/websites-to-learn-ai/show/98.html',	0,	0,	'127.0.0.1',	1702547767,	1702547767,	0,	'310',	NULL,	'https://microsoft.github.io/ML-For-Beginners/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (99,	10,	'Generative AI for Beginners',	'311',	'AI学习网站',	'微软推出的面向初学者的免费生成式人工智能课程',	11,	1,	'创始人',	9,	'/webnav/websites-to-learn-ai/show/99.html',	0,	0,	'127.0.0.1',	1702547765,	1702547765,	0,	'312',	NULL,	'https://microsoft.github.io/generative-ai-for-beginners/#/translation/cn/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (100,	10,	'MachineLearningMastery',	'1531',	'AI学习网站',	'免费在线学习机器学习，从基础到高级',	63,	1,	'创始人',	9,	'/webnav/websites-to-learn-ai/show/100.html',	0,	0,	'127.0.0.1',	1702547749,	1702547749,	0,	'314',	NULL,	'https://machinelearningmastery.com/start-here/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (101,	10,	'动手学深度学习',	'1532',	'AI学习网站',	'动手学深度学习的教材和课程',	11,	1,	'创始人',	9,	'/webnav/websites-to-learn-ai/show/101.html',	0,	0,	'127.0.0.1',	1702547753,	1702547753,	0,	'315',	NULL,	'https://zh.d2l.ai/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (102,	10,	'DeepLearning.AI',	'316',	'AI学习网站',	'深度学习和人工智能学习平台',	80,	1,	'创始人',	9,	'/webnav/websites-to-learn-ai/show/102.html',	0,	0,	'127.0.0.1',	1702547777,	1702547777,	0,	'317',	NULL,	'https://www.deeplearning.ai/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (103,	10,	'Elements of AI',	'1533',	'AI学习网站',	'免费在线AI通识学习',	19,	1,	'创始人',	9,	'/webnav/websites-to-learn-ai/show/103.html',	0,	0,	'127.0.0.1',	1702547775,	1702547775,	0,	'318',	NULL,	'https://www.elementsofai.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (104,	10,	'Coursera',	'319',	'AI学习网站',	'知名MOOC平台，众多人工智能和机器学习课程',	64,	1,	'创始人',	9,	'/webnav/websites-to-learn-ai/show/104.html',	0,	0,	'127.0.0.1',	1702547733,	1702547733,	0,	'320',	NULL,	'https://www.coursera.org/collections/best-machine-learning-ai',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (105,	10,	'fast.ai',	'321',	'AI学习网站',	'免费开源的深度学习和AI学习网站，让每个人都参与到AI！',	74,	1,	'创始人',	9,	'/webnav/websites-to-learn-ai/show/105.html',	0,	0,	'127.0.0.1',	1702547716,	1702547716,	0,	'322',	NULL,	'https://www.fast.ai/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (106,	14,	'PubMedQA',	'323',	'AI模型评测',	'生物医学研究问答数据集和模型得分排行榜',	26,	1,	'创始人',	9,	'/webnav/llm-benchmarks/show/106.html',	0,	0,	'127.0.0.1',	1702547802,	1702547802,	0,	'324',	NULL,	'https://pubmedqa.github.io/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (107,	14,	'H2O EvalGPT',	'325',	'AI模型评测',	'H2O.ai推出的基于Elo评级方法的大模型评估系统',	81,	1,	'创始人',	9,	'/webnav/llm-benchmarks/show/107.html',	0,	0,	'127.0.0.1',	1702547811,	1702547811,	0,	'326',	NULL,	'https://evalgpt.ai/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (108,	14,	'LLMEval3',	'328',	'AI模型评测',	'由复旦大学NLP实验室推出的大模型评测基准',	42,	1,	'创始人',	9,	'/webnav/llm-benchmarks/show/108.html',	0,	0,	'127.0.0.1',	1702547793,	1702547793,	0,	'329',	NULL,	'http://llmeval.com/index',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (109,	14,	'Chatbot Arena',	'330',	'AI模型评测',	'以众包方式进行匿名随机对战的LLM基准平台',	65,	1,	'创始人',	9,	'/webnav/llm-benchmarks/show/109.html',	0,	0,	'127.0.0.1',	1702547725,	1702547725,	0,	'331',	NULL,	'https://chat.lmsys.org/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (110,	14,	'HELM',	'332',	'AI模型评测',	'斯坦福大学推出的大模型评测体系',	83,	1,	'创始人',	9,	'/webnav/llm-benchmarks/show/110.html',	0,	0,	'127.0.0.1',	1702547753,	1702547753,	0,	'333',	NULL,	'https://crfm.stanford.edu/helm/latest/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (111,	14,	'MMBench',	'334',	'AI模型评测',	'全方位的多模态大模型能力评测体系',	34,	1,	'创始人',	9,	'/webnav/llm-benchmarks/show/111.html',	0,	0,	'127.0.0.1',	1702547729,	1702547729,	0,	'335',	NULL,	'https://mmbench.opencompass.org.cn/leaderboard',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (112,	14,	'CMMLU',	'336',	'AI模型评测',	'一个综合性的大模型中文评估基准',	56,	1,	'创始人',	9,	'/webnav/llm-benchmarks/show/112.html',	0,	0,	'127.0.0.1',	1702547775,	1702547775,	0,	'337',	NULL,	'https://github.com/haonan-li/CMMLU/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (113,	14,	'OpenCompass',	'338',	'AI模型评测',	'上海人工智能实验室推出的大模型开放评测体系',	20,	1,	'创始人',	9,	'/webnav/llm-benchmarks/show/113.html',	0,	0,	'127.0.0.1',	1702547775,	1702547775,	0,	'339',	NULL,	'https://opencompass.org.cn/leaderboard-llm',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (114,	14,	'SuperCLUE',	'340',	'AI模型评测',	'中文通用大模型综合性测评基准',	58,	1,	'创始人',	9,	'/webnav/llm-benchmarks/show/114.html',	0,	0,	'127.0.0.1',	1702547822,	1702547822,	0,	'341',	NULL,	'https://www.cluebenchmarks.com/static/superclue.html',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (115,	14,	'FlagEval',	'342',	'AI模型评测',	'智源研究院推出的FlagEval（天秤）大模型评测平台',	70,	1,	'创始人',	9,	'/webnav/llm-benchmarks/show/115.html',	0,	0,	'127.0.0.1',	1702547801,	1702547801,	0,	'343',	NULL,	'https://flageval.baai.ac.cn/#/trending',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (116,	14,	'C-Eval',	'344',	'AI模型评测',	'一个全面的中文基础模型评估套件',	100,	1,	'创始人',	9,	'/webnav/llm-benchmarks/show/116.html',	0,	0,	'127.0.0.1',	1702547780,	1702547780,	0,	'345',	NULL,	'https://cevalbenchmark.com/static/leaderboard_zh.html',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (117,	14,	'Open LLM Leaderboard',	'346',	'AI模型评测',	'Hugging Face推出的开源大模型排行榜单',	22,	1,	'创始人',	9,	'/webnav/llm-benchmarks/show/117.html',	0,	0,	'127.0.0.1',	1702547841,	1702547841,	0,	'347',	NULL,	'https://huggingface.co/spaces/HuggingFaceH4/open_llm_leaderboard',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (118,	14,	'MMLU',	'348',	'AI模型评测',	'大规模多任务语言理解基准',	100,	1,	'创始人',	9,	'/webnav/llm-benchmarks/show/118.html',	0,	0,	'127.0.0.1',	1702547825,	1702547825,	0,	'349',	NULL,	'https://paperswithcode.com/sota/multi-task-language-understanding-on-mmlu',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (119,	13,	'Evidently AI',	'1534',	'AI训练模型',	'开源的机器学习模型监测和测试工具',	12,	1,	'创始人',	9,	'/webnav/ai-models/show/119.html',	0,	0,	'127.0.0.1',	1702547758,	1702547758,	0,	'350',	NULL,	'https://www.evidentlyai.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (120,	13,	'Replicate',	'351',	'AI训练模型',	'在线运行开源机器学习模型',	76,	1,	'创始人',	9,	'/webnav/ai-models/show/120.html',	0,	0,	'127.0.0.1',	1702547848,	1702547848,	0,	'352',	NULL,	'https://replicate.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (121,	13,	'Scale AI',	'1535',	'AI训练模型',	'AI机器学习标注训练平台',	48,	1,	'创始人',	9,	'/webnav/ai-models/show/121.html',	0,	0,	'127.0.0.1',	1702547853,	1702547853,	0,	'353',	NULL,	'https://scale.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (122,	13,	'Lobe',	'1536',	'AI训练模型',	'简单免费的机器学习模型训练工具',	37,	1,	'创始人',	9,	'/webnav/ai-models/show/122.html',	0,	0,	'127.0.0.1',	1702547831,	1702547831,	0,	'354',	NULL,	'https://www.lobe.ai/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (123,	13,	'Watsonx.ai',	'355',	'AI训练模型',	'IBM推出的企业级生成式人工智能和机器学习平台',	52,	1,	'创始人',	9,	'/webnav/ai-models/show/123.html',	0,	0,	'127.0.0.1',	1702547841,	1702547841,	0,	'356',	NULL,	'https://www.ibm.com/products/watsonx-ai',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (124,	13,	'StableVicuna',	'357',	'AI训练模型',	'第一个通过RLHF训练的大规模开源聊天机器人',	68,	1,	'创始人',	9,	'/webnav/ai-models/show/124.html',	0,	0,	'127.0.0.1',	1702547841,	1702547841,	0,	'358',	NULL,	'https://chat.lmsys.org/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (125,	13,	'Imagen',	'1537',	'AI训练模型',	'Google AI文字到图像生成模型',	55,	1,	'创始人',	9,	'/webnav/ai-models/show/125.html',	0,	0,	'127.0.0.1',	1702547816,	1702547816,	0,	'359',	NULL,	'https://imagen.research.google/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (126,	13,	'HuggingFace',	'1538',	'AI训练模型',	'AI模型开发社区',	35,	1,	'创始人',	9,	'/webnav/ai-models/show/126.html',	0,	0,	'127.0.0.1',	1702547786,	1702547786,	0,	'347',	NULL,	'https://huggingface.co/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (127,	13,	'Segment Anything（SAM）',	'361',	'AI训练模型',	'Meta最新推出的AI图像分割模型',	86,	1,	'创始人',	9,	'/webnav/ai-models/show/127.html',	0,	0,	'127.0.0.1',	1702547850,	1702547850,	0,	'362',	NULL,	'https://segment-anything.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (128,	13,	'OpenBMB',	'1539',	'AI训练模型',	'清华团队支持发起的大规模预训练语言模型库与相关工具',	64,	1,	'创始人',	9,	'/webnav/ai-models/show/128.html',	0,	0,	'127.0.0.1',	1702547802,	1702547802,	0,	'364',	NULL,	'https://www.openbmb.org/home',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (129,	13,	'LLaMA',	'1540',	'AI训练模型',	'Meta（Facebook）推出的AI大语言模型',	85,	1,	'创始人',	9,	'/webnav/ai-models/show/129.html',	0,	0,	'127.0.0.1',	1702547789,	1702547789,	0,	'362',	NULL,	'https://github.com/facebookresearch/llama',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (130,	13,	'PaLM 2',	'366',	'AI训练模型',	'Google的下一代大语言模型，超过3400亿参数',	94,	1,	'创始人',	9,	'/webnav/ai-models/show/130.html',	0,	0,	'127.0.0.1',	1702547886,	1702547886,	0,	'367',	NULL,	'https://ai.google/discover/palm2',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (131,	13,	'DeepSpeed',	'369',	'AI训练模型',	'微软开源的低成本实现类似ChatGPT的模型训练',	37,	1,	'创始人',	9,	'/webnav/ai-models/show/131.html',	0,	0,	'127.0.0.1',	1702547855,	1702547855,	0,	'370',	NULL,	'https://www.deepspeed.ai/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (132,	5,	'天工AI助手',	'371',	'AI对话工具,AI训练模型',	'昆仑万维与奇点智源联合研发的对标ChatGPT的大语言模型',	43,	1,	'创始人',	9,	'/webnav/ai-chatbots/show/132.html',	0,	0,	'127.0.0.1',	1702547798,	1702547798,	0,	'372',	NULL,	'https://tiangong.kunlun.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (133,	5,	'商量SenseChat',	'373',	'AI对话工具,AI训练模型',	'商汤科技推出的类ChatGPT的人工智能大语言模型',	13,	1,	'创始人',	9,	'/webnav/ai-chatbots/show/133.html',	0,	0,	'127.0.0.1',	1702547846,	1702547846,	0,	'374',	NULL,	'https://chat.sensetime.com/wb/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (134,	13,	'Gen-2',	'1541',	'AI训练模型',	'Runway最新推出的AI视频生成模型',	50,	1,	'创始人',	9,	'/webnav/ai-models/show/134.html',	0,	0,	'127.0.0.1',	1702547814,	1702547814,	0,	'375',	NULL,	'https://research.runwayml.com/gen2',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (135,	13,	'StableLM',	'376',	'AI训练模型',	'Stability AI推出的开源的类ChatGPT大语言模型',	44,	1,	'创始人',	9,	'/webnav/ai-models/show/135.html',	0,	0,	'127.0.0.1',	1702547905,	1702547905,	0,	'377',	NULL,	'https://github.com/Stability-AI/StableLM',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (136,	13,	'Lamini',	'378',	'AI训练模型',	'低门槛快速定制大语言模型的引擎',	101,	1,	'创始人',	9,	'/webnav/ai-models/show/136.html',	0,	0,	'127.0.0.1',	1702547818,	1702547818,	0,	'379',	NULL,	'https://lamini.ai/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (137,	13,	'阿里巴巴M6',	'1542',	'AI训练模型',	'阿里巴巴达摩院推出的超大规模中文预训练模型(M6)',	44,	1,	'创始人',	9,	'/webnav/ai-models/show/137.html',	0,	0,	'127.0.0.1',	1702547868,	1702547868,	0,	'302',	NULL,	'https://m6.aliyun.com/#/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (138,	13,	'BLOOM',	'1543',	'AI训练模型',	'HuggingFace推出的大型语言模型（LLM）',	44,	1,	'创始人',	9,	'/webnav/ai-models/show/138.html',	0,	0,	'127.0.0.1',	1702547908,	1702547908,	0,	'381',	NULL,	'https://huggingface.co/docs/transformers/model_doc/bloom',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (139,	13,	'魔搭社区',	'382',	'AI训练模型',	'阿里达摩院推出的AI模型社区，超过300+开源AI模型',	34,	1,	'创始人',	9,	'/webnav/ai-models/show/139.html',	0,	0,	'127.0.0.1',	1702547824,	1702547824,	0,	'383',	NULL,	'https://www.modelscope.cn/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (140,	13,	'序列猴子',	'384',	'AI训练模型',	'出门问问推出的一款超大规模的语言模型',	76,	1,	'创始人',	9,	'/webnav/ai-models/show/140.html',	0,	0,	'127.0.0.1',	1702547846,	1702547846,	0,	'385',	NULL,	'https://openapi.mobvoi.com/index',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (141,	13,	'文心大模型',	'1544',	'AI训练模型',	'百度推出的产业级知识增强大模型',	31,	1,	'创始人',	9,	'/webnav/ai-models/show/141.html',	0,	0,	'127.0.0.1',	1702547852,	1702547852,	0,	'293',	NULL,	'https://wenxin.baidu.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (142,	13,	'Codex',	'1545',	'AI训练模型',	'OpenAI旗下AI代码生成训练模型',	20,	1,	'创始人',	9,	'/webnav/ai-models/show/142.html',	0,	0,	'127.0.0.1',	1702547881,	1702547881,	0,	'387',	NULL,	'https://openai.com/blog/openai-codex',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (143,	13,	'DALL·E 2',	'//s0.wp.com/mshots/v1/?w=383&h=328',	'AI训练模型',	'OpenAI旗下DALL·E 2图像生成模型',	95,	1,	'创始人',	9,	'/webnav/ai-models/show/143.html',	0,	0,	'127.0.0.1',	1702547922,	1702547922,	0,	'388',	NULL,	'https://cn.bing.com/search?q=DALL·E 2&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (144,	13,	'Cohere',	'389',	'AI训练模型',	'构建AI产品的大语言模型平台',	36,	1,	'创始人',	9,	'/webnav/ai-models/show/144.html',	0,	0,	'127.0.0.1',	1702547867,	1702547867,	0,	'390',	NULL,	'https://cohere.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (145,	13,	'DeepFloyd IF',	'391',	'AI训练模型',	'StabilityAI旗下的DeepFloyd团队推出的图片生成模型',	32,	1,	'创始人',	9,	'/webnav/ai-models/show/145.html',	0,	0,	'127.0.0.1',	1702547885,	1702547885,	0,	'392',	NULL,	'https://deepfloyd.ai/deepfloyd-if',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (146,	13,	'Gradio',	'393',	'AI训练模型',	'开源的搭建机器学习模型UI界面的Python库',	54,	1,	'创始人',	9,	'/webnav/ai-models/show/146.html',	0,	0,	'127.0.0.1',	1702547905,	1702547905,	0,	'394',	NULL,	'https://gradio.app/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (147,	13,	'腾讯混元大模型',	'396',	'AI训练模型',	'腾讯研发的大语言模型，具备强大的中文创作能力，复杂语境下的逻辑推理能力，以及可靠的任务执行能力',	55,	1,	'创始人',	9,	'/webnav/ai-models/show/147.html',	0,	0,	'127.0.0.1',	1702547938,	1702547938,	0,	'397',	NULL,	'https://hunyuan.tencent.com/?utm_source=ai-bot.cn',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (148,	13,	'悟道',	'398',	'AI训练模型',	'智源“悟道”大模型，中国首个+世界最大人工智能大模型',	40,	1,	'创始人',	9,	'/webnav/ai-models/show/148.html',	0,	0,	'127.0.0.1',	1702547858,	1702547858,	0,	'399',	NULL,	'https://www.baai.ac.cn/portal/article/index/cid/49/id/518.html',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (149,	13,	'AgentGPT',	'400',	'AI训练模型',	'在浏览器中组装、配置和部署自主人工智能的开源项目',	58,	1,	'创始人',	9,	'/webnav/ai-models/show/149.html',	0,	0,	'127.0.0.1',	1702547869,	1702547869,	0,	'401',	NULL,	'https://agentgpt.reworkd.ai/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (150,	13,	'Auto-GPT',	'402',	'AI训练模型',	'爆火的实现GPT-4完全自主的实验性开源项目，GitHub超10万星',	51,	1,	'创始人',	9,	'/webnav/ai-models/show/150.html',	0,	0,	'127.0.0.1',	1702547961,	1702547961,	0,	'403',	NULL,	'https://agpt.co/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (151,	13,	'MiracleVision奇想智能',	'404',	'AI训练模型',	'美图推出的AI视觉大模型，支持AI图像、设计和视频创作',	35,	1,	'创始人',	9,	'/webnav/ai-models/show/151.html',	0,	0,	'127.0.0.1',	1702547877,	1702547877,	0,	'405',	NULL,	'https://www.miraclevision.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (152,	12,	'词魂',	'407',	'AI提示指令',	'AIGC精品提示词库',	72,	1,	'创始人',	9,	'/webnav/ai-prompt-tools/show/152.html',	0,	0,	'127.0.0.1',	1702547971,	1702547971,	0,	'408',	NULL,	'https://icihun.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (153,	12,	'ChatGPT Shortcut',	'409',	'AI提示指令',	'开源的简单易用的ChatGPT快捷指令，让生产力加倍！',	85,	1,	'创始人',	9,	'/webnav/ai-prompt-tools/show/153.html',	0,	0,	'127.0.0.1',	1702547881,	1702547881,	0,	'410',	NULL,	'https://www.aishort.top/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (154,	12,	'Learning Prompt',	'1546',	'AI提示指令',	'免费的 Prompt Engineering 教程（中文开源）',	43,	1,	'创始人',	9,	'/webnav/ai-prompt-tools/show/154.html',	0,	0,	'127.0.0.1',	1702547907,	1702547907,	0,	'411',	NULL,	'https://learningprompt.wiki/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (155,	12,	'Awesome ChatGPT Prompts',	'1547',	'AI提示指令',	'ChatGPT Prompts集合',	86,	1,	'创始人',	9,	'/webnav/ai-prompt-tools/show/155.html',	0,	0,	'127.0.0.1',	1702547981,	1702547981,	0,	'412',	NULL,	'https://prompts.chat/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (156,	12,	'PromptVine',	'1548',	'AI提示指令',	'ChatGPT Prompts和应用',	51,	1,	'创始人',	9,	'/webnav/ai-prompt-tools/show/156.html',	0,	0,	'127.0.0.1',	1702547923,	1702547923,	0,	'413',	NULL,	'https://promptvine.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (157,	12,	'PromptBase',	'1549',	'AI提示指令',	'AI Prompts集合市场',	55,	1,	'创始人',	9,	'/webnav/ai-prompt-tools/show/157.html',	0,	0,	'127.0.0.1',	1702547900,	1702547900,	0,	'414',	NULL,	'https://promptbase.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (158,	12,	'ChatGPT Prompt Genius',	'1550',	'AI提示指令',	'免费开源的ChatGPT Prompt浏览器扩展',	53,	1,	'创始人',	9,	'/webnav/ai-prompt-tools/show/158.html',	0,	0,	'127.0.0.1',	1702547962,	1702547962,	0,	'415',	NULL,	'https://github.com/benf2004/ChatGPT-Prompt-Genius',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (159,	12,	'Visual Prompt Builder',	'1551',	'AI提示指令',	'可视化AI提示语选择和搭建',	23,	1,	'创始人',	9,	'/webnav/ai-prompt-tools/show/159.html',	0,	0,	'127.0.0.1',	1702547971,	1702547971,	0,	'416',	NULL,	'https://tools.saxifrage.xyz/prompt',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (160,	12,	'MJ Prompt Tool',	'1552',	'AI提示指令',	'Midjourney Prompt帮助工具',	53,	1,	'创始人',	9,	'/webnav/ai-prompt-tools/show/160.html',	0,	0,	'127.0.0.1',	1702547934,	1702547934,	0,	'417',	NULL,	'https://prompt.noonshot.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (161,	12,	'绘AI',	'418',	'AI提示指令',	'AI绘画提示词分享平台',	53,	1,	'创始人',	9,	'/webnav/ai-prompt-tools/show/161.html',	0,	0,	'127.0.0.1',	1702547963,	1702547963,	0,	'419',	NULL,	'https://www.ai016.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (162,	12,	'AIPRM',	'1553',	'AI提示指令',	'主要针对于SEO和SaaS文案写作的ChatGPT Prompts浏览器扩展',	48,	1,	'创始人',	9,	'/webnav/ai-prompt-tools/show/162.html',	0,	0,	'127.0.0.1',	1702547939,	1702547939,	0,	'420',	NULL,	'https://www.aiprm.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (163,	12,	'提示工程指南',	'421',	'AI提示指令',	'免费开源的提示工程指南，GitHub标星超3万',	70,	1,	'创始人',	9,	'/webnav/ai-prompt-tools/show/163.html',	0,	0,	'127.0.0.1',	1702547925,	1702547925,	0,	'422',	NULL,	'https://www.promptingguide.ai/zh',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (164,	12,	'Snack Prompt',	'423',	'AI提示指令',	'探索最新的ChatGPT语义提示词',	93,	1,	'创始人',	9,	'/webnav/ai-prompt-tools/show/164.html',	0,	0,	'127.0.0.1',	1702547927,	1702547927,	0,	'424',	NULL,	'https://snackprompt.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (165,	12,	'PublicPrompts',	'1554',	'AI提示指令',	'免费高质量的Prompts集合',	39,	1,	'创始人',	9,	'/webnav/ai-prompt-tools/show/165.html',	0,	0,	'127.0.0.1',	1702547981,	1702547981,	0,	'425',	NULL,	'https://publicprompts.art/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (166,	12,	'Generrated',	'426',	'AI提示指令',	'超过7480个基于DALL·E 2的图片生成指令语句',	46,	1,	'创始人',	9,	'/webnav/ai-prompt-tools/show/166.html',	0,	0,	'127.0.0.1',	1702547952,	1702547952,	0,	'427',	NULL,	'https://generrated.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (167,	12,	'ClickPrompt',	'1555',	'AI提示指令',	'专为 Prompt 编写者设计的工具',	81,	1,	'创始人',	9,	'/webnav/ai-prompt-tools/show/167.html',	0,	0,	'127.0.0.1',	1702547987,	1702547987,	0,	'428',	NULL,	'https://www.clickprompt.org/zh-CN/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (168,	12,	'PromptHero',	'1556',	'AI提示指令',	'发现Stable Diffusion、ChatGPT和Midjourney的提示用语',	58,	1,	'创始人',	9,	'/webnav/ai-prompt-tools/show/168.html',	0,	0,	'127.0.0.1',	1702547970,	1702547970,	0,	'429',	NULL,	'https://prompthero.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (169,	12,	'Stable Diffusion Prompt Book',	'430',	'AI提示指令',	'OpenArt推出的针对Stable Diffusion指令的手册',	79,	1,	'创始人',	9,	'/webnav/ai-prompt-tools/show/169.html',	0,	0,	'127.0.0.1',	1702548019,	1702548019,	0,	'431',	NULL,	'https://openart.ai/promptbook',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (170,	12,	'FlowGPT',	'1557',	'AI提示指令',	'ChatGPT指令大全',	89,	1,	'创始人',	9,	'/webnav/ai-prompt-tools/show/170.html',	0,	0,	'127.0.0.1',	1702548007,	1702548007,	0,	'432',	NULL,	'https://flowgpt.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (171,	12,	'PromptPerfect',	'433',	'AI提示指令',	'专业的提示词优化工具，一站式开发、优化、调试和部署提示词',	54,	1,	'创始人',	9,	'/webnav/ai-prompt-tools/show/171.html',	0,	0,	'127.0.0.1',	1702548002,	1702548002,	0,	'434',	NULL,	'https://promptperfect.jinaai.cn/?utm_source=ai-bot.cn',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (172,	9,	'CheckforAI',	'1558',	'AI内容检测',	'免费在线检测AI内容',	67,	1,	'创始人',	9,	'/webnav/ai-content-detection-tools/show/172.html',	0,	0,	'127.0.0.1',	1702548008,	1702548008,	0,	'436',	NULL,	'https://ai-bot.cn',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (173,	9,	'Winston AI',	'1559',	'AI内容检测',	'强大的AI内容检测解决方案',	33,	1,	'创始人',	9,	'/webnav/ai-content-detection-tools/show/173.html',	0,	0,	'127.0.0.1',	1702547988,	1702547988,	0,	'437',	NULL,	'https://gowinston.ai/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (174,	9,	'CopyLeaks',	'1560',	'AI内容检测',	'AI内容检测和分级',	23,	1,	'创始人',	9,	'/webnav/ai-content-detection-tools/show/174.html',	0,	0,	'127.0.0.1',	1702548025,	1702548025,	0,	'438',	NULL,	'https://copyleaks.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (175,	9,	'Originality.AI',	'1561',	'AI内容检测',	'原创度和AI内容检测',	25,	1,	'创始人',	9,	'/webnav/ai-content-detection-tools/show/175.html',	0,	0,	'127.0.0.1',	1702548017,	1702548017,	0,	'439',	NULL,	'https://originality.ai/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (176,	9,	'AI Content Detector',	'1562',	'AI内容检测',	'Writer推出的AI内容检测工具',	48,	1,	'创始人',	9,	'/webnav/ai-content-detection-tools/show/176.html',	0,	0,	'127.0.0.1',	1702547978,	1702547978,	0,	'99',	NULL,	'https://writer.com/ai-content-detector/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (177,	9,	'GPT Detector',	'1563',	'AI内容检测',	'在线检查文本是否由GPT-3或ChatGPT生成',	38,	1,	'创始人',	9,	'/webnav/ai-content-detection-tools/show/177.html',	0,	0,	'127.0.0.1',	1702547980,	1702547980,	0,	'441',	NULL,	'https://x.writefull.com/gpt-detector',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (178,	9,	'Sapling AI Content Detector',	'1564',	'AI内容检测',	'Sapling.ai推出的免费在线AI内容检测工具',	87,	1,	'创始人',	9,	'/webnav/ai-content-detection-tools/show/178.html',	0,	0,	'127.0.0.1',	1702547982,	1702547982,	0,	'442',	NULL,	'https://sapling.ai/utilities/ai-content-detector',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (179,	9,	'Smodin AI Content Detector',	'1565',	'AI内容检测',	'多语种AI内容检测工具',	75,	1,	'创始人',	9,	'/webnav/ai-content-detection-tools/show/179.html',	0,	0,	'127.0.0.1',	1702548081,	1702548081,	0,	'443',	NULL,	'https://smodin.io/ai-content-detector',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (180,	9,	'Writecream AI Content Detector',	'1566',	'AI内容检测',	'Writecream推出的AI内容检测工具',	88,	1,	'创始人',	9,	'/webnav/ai-content-detection-tools/show/180.html',	0,	0,	'127.0.0.1',	1702548004,	1702548004,	0,	'444',	NULL,	'https://www.writecream.com/ai-content-detector/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (181,	9,	'AISEO AI Content Detector',	'445',	'AI内容检测',	'AISEO推出的AI内容检测器',	78,	1,	'创始人',	9,	'/webnav/ai-content-detection-tools/show/181.html',	0,	0,	'127.0.0.1',	1702547994,	1702547994,	0,	'100',	NULL,	'https://aiseo.ai/tools/ai-content-detector.html',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (182,	9,	'StudyCorgi ChatGPT Detector',	'447',	'AI内容检测',	'免费的检测论文是否由ChatGPT生成的工具',	18,	1,	'创始人',	9,	'/webnav/ai-content-detection-tools/show/182.html',	0,	0,	'127.0.0.1',	1702548017,	1702548017,	0,	'448',	NULL,	'https://studycorgi.com/free-writing-tools/chat-gpt-detector/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (183,	9,	'GPTZero',	'450',	'AI内容检测',	'超过百万人都在用的免费AI内容检测工具',	45,	1,	'创始人',	9,	'/webnav/ai-content-detection-tools/show/183.html',	0,	0,	'127.0.0.1',	1702548017,	1702548017,	0,	'451',	NULL,	'https://gptzero.me/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (184,	6,	'Notta',	'453',	'AI音频工具',	'AI在线将语音转换成文字',	65,	1,	'创始人',	9,	'/webnav/ai-audio-tools/show/184.html',	0,	0,	'127.0.0.1',	1701957222,	1701957222,	0,	'454',	NULL,	NULL,	0,	0,	0),
                                                                                                                                                                                                                                                                                      (185,	6,	'WellSaid Labs',	'1283',	'AI音频工具',	'AI文本转语音工具',	18,	1,	'创始人',	9,	'/webnav/ai-audio-tools/show/185.html',	0,	0,	'127.0.0.1',	1701957256,	1701957256,	0,	'455',	NULL,	NULL,	0,	0,	0),
                                                                                                                                                                                                                                                                                      (186,	6,	'Voicemod',	'1567',	'AI音频工具',	'AI变声工具',	74,	1,	'创始人',	9,	'/webnav/ai-audio-tools/show/186.html',	0,	0,	'127.0.0.1',	1702548163,	1702548163,	0,	'456',	NULL,	'https://www.voicemod.net/ai-voices/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (187,	6,	'Listnr',	'1568',	'AI音频工具',	'AI文本到语音生成器',	68,	1,	'创始人',	9,	'/webnav/ai-audio-tools/show/187.html',	0,	0,	'127.0.0.1',	1702548135,	1702548135,	0,	'457',	NULL,	'https://www.listnr.tech/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (188,	6,	'Voice.ai',	'1569',	'AI音频工具',	'实时AI变声工具',	19,	1,	'创始人',	9,	'/webnav/ai-audio-tools/show/188.html',	0,	0,	'127.0.0.1',	1702548082,	1702548082,	0,	'458',	NULL,	'https://voice.ai/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (189,	6,	'Voicemaker',	'1570',	'AI音频工具',	'AI文本到语音生成工具',	94,	1,	'创始人',	9,	'/webnav/ai-audio-tools/show/189.html',	0,	0,	'127.0.0.1',	1702548114,	1702548114,	0,	'459',	NULL,	'https://voicemaker.in/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (190,	6,	'Speechify',	'1571',	'AI音频工具',	'超2000万人都在用的文字转语音朗读器',	47,	1,	'创始人',	9,	'/webnav/ai-audio-tools/show/190.html',	0,	0,	'127.0.0.1',	1702548116,	1702548116,	0,	'460',	NULL,	'https://speechify.com/zh-hans/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (191,	6,	'MetaVoice',	'1572',	'AI音频工具',	'AI实时变声工具',	30,	1,	'创始人',	9,	'/webnav/ai-audio-tools/show/191.html',	0,	0,	'127.0.0.1',	1702548181,	1702548181,	0,	'461',	NULL,	'https://themetavoice.xyz/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (192,	6,	'Clipchamp AI旁白生成器',	'1573',	'AI音频工具',	'Clipchamp的文字转语音生成器',	55,	1,	'创始人',	9,	'/webnav/ai-audio-tools/show/192.html',	0,	0,	'127.0.0.1',	1702548175,	1702548175,	0,	'462',	NULL,	'https://clipchamp.com/zh-hans/features/ai-voice-over-generator/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (193,	6,	'Veed AI Voice Generator',	'1574',	'AI音频工具',	'Veed推出的AI语音生成器',	27,	1,	'创始人',	9,	'/webnav/ai-audio-tools/show/193.html',	0,	0,	'127.0.0.1',	1702548154,	1702548154,	0,	'463',	NULL,	'https://www.veed.io/tools/text-to-speech-video/ai-voice-generator',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (194,	6,	'Typecast',	'1575',	'AI音频工具',	'在线AI文字转语音生成工具',	30,	1,	'创始人',	9,	'/webnav/ai-audio-tools/show/194.html',	0,	0,	'127.0.0.1',	1702548144,	1702548144,	0,	'464',	NULL,	'https://typecast.ai/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (195,	6,	'LOVO AI',	'1576',	'AI音频工具',	'AI人声和文本转语音生成工具',	95,	1,	'创始人',	9,	'/webnav/ai-audio-tools/show/195.html',	0,	0,	'127.0.0.1',	1702548206,	1702548206,	0,	'465',	NULL,	'https://lovo.ai/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (196,	6,	'Boomy',	'466',	'AI音频工具',	'AI快速生成原创音乐的平台',	89,	1,	'创始人',	9,	'/webnav/ai-audio-tools/show/196.html',	0,	0,	'127.0.0.1',	1702548148,	1702548148,	0,	'467',	NULL,	'https://boomy.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (197,	6,	'Soundraw',	'468',	'AI音频工具',	'AI音乐生成工具',	93,	1,	'创始人',	9,	'/webnav/ai-audio-tools/show/197.html',	0,	0,	'127.0.0.1',	1702548193,	1702548193,	0,	'469',	NULL,	'https://soundraw.io/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (198,	6,	'Lemonaid',	'1577',	'AI音频工具',	'AI音乐生成工具',	81,	1,	'创始人',	9,	'/webnav/ai-audio-tools/show/198.html',	0,	0,	'127.0.0.1',	1702548134,	1702548134,	0,	'470',	NULL,	'https://lemonaid.ai/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (199,	6,	'Murf AI',	'1578',	'AI音频工具',	'AI文本转语音生成工具',	22,	1,	'创始人',	9,	'/webnav/ai-audio-tools/show/199.html',	0,	0,	'127.0.0.1',	1702548164,	1702548164,	0,	'471',	NULL,	'https://murf.ai/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (200,	6,	'Play.ht',	'1579',	'AI音频工具',	'超真实在线AI语音生成',	29,	1,	'创始人',	9,	'/webnav/ai-audio-tools/show/200.html',	0,	0,	'127.0.0.1',	1702548154,	1702548154,	0,	'472',	NULL,	'https://play.ht/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (201,	6,	'Krisp',	'473',	'AI音频工具',	'AI噪音消除工具',	51,	1,	'创始人',	9,	'/webnav/ai-audio-tools/show/201.html',	0,	0,	'127.0.0.1',	1702548176,	1702548176,	0,	'474',	NULL,	'https://krisp.ai/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (202,	6,	'LALAL.AI',	'475',	'AI音频工具',	'AI人声乐器分离和提取',	89,	1,	'创始人',	9,	'/webnav/ai-audio-tools/show/202.html',	0,	0,	'127.0.0.1',	1702548244,	1702548244,	0,	'476',	NULL,	'https://www.lalal.ai/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (203,	6,	'AssemblyAI',	'477',	'AI音频工具',	'转录和理解语音的AI模型',	39,	1,	'创始人',	9,	'/webnav/ai-audio-tools/show/203.html',	0,	0,	'127.0.0.1',	1702548226,	1702548226,	0,	'478',	NULL,	'https://www.assemblyai.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (204,	6,	'NaturalReader',	'1580',	'AI音频工具',	'AI文本转语音工具',	84,	1,	'创始人',	9,	'/webnav/ai-audio-tools/show/204.html',	0,	0,	'127.0.0.1',	1702548219,	1702548219,	0,	'479',	NULL,	'https://www.naturalreaders.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (205,	6,	'Audo Studio',	'480',	'AI音频工具',	'AI音频清洗工具（噪音消除、声音平衡、音量调节）',	90,	1,	'创始人',	9,	'/webnav/ai-audio-tools/show/205.html',	0,	0,	'127.0.0.1',	1702548184,	1702548184,	0,	'481',	NULL,	'https://audo.ai/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (206,	6,	'BeatBot',	'1581',	'AI音频工具',	'输入文本提示快速生成歌曲和音乐',	95,	1,	'创始人',	9,	'/webnav/ai-audio-tools/show/206.html',	0,	0,	'127.0.0.1',	1702548181,	1702548181,	0,	'482',	NULL,	'https://beatbot.fm/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (207,	6,	'Beatoven.ai',	'483',	'AI音频工具',	'免版税AI音乐创建平台',	14,	1,	'创始人',	9,	'/webnav/ai-audio-tools/show/207.html',	0,	0,	'127.0.0.1',	1702548201,	1702548201,	0,	'484',	NULL,	'https://www.beatoven.ai/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (208,	6,	'Mubert',	'485',	'AI音频工具',	'AI BGM背景音乐生成工具',	45,	1,	'创始人',	9,	'/webnav/ai-audio-tools/show/208.html',	0,	0,	'127.0.0.1',	1702548212,	1702548212,	0,	'486',	NULL,	'https://mubert.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (209,	6,	'悦音配音',	'487',	'AI音频工具',	'AI智能在线配音语音合成工具',	23,	1,	'创始人',	9,	'/webnav/ai-audio-tools/show/209.html',	0,	0,	'127.0.0.1',	1702548233,	1702548233,	0,	'488',	NULL,	'https://yueyin.zhipianbang.com?utm_source=ai-bot.cn',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (210,	6,	'BGM猫',	'489',	'AI音频工具',	'灵动音科技推出的AI智能生成BGM音乐',	51,	1,	'创始人',	9,	'/webnav/ai-audio-tools/show/210.html',	0,	0,	'127.0.0.1',	1702548287,	1702548287,	0,	'490',	NULL,	'https://bgmcat.com/home',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (211,	6,	'FakeYou',	'1582',	'AI音频工具',	'Deep Fake文本转语音',	23,	1,	'创始人',	9,	'/webnav/ai-audio-tools/show/211.html',	0,	0,	'127.0.0.1',	1702548298,	1702548298,	0,	'491',	NULL,	'https://fakeyou.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (212,	6,	'IBM Watson文字转语音',	'1583',	'AI音频工具',	'IBM Watson文字转语音',	27,	1,	'创始人',	9,	'/webnav/ai-audio-tools/show/212.html',	0,	0,	'127.0.0.1',	1702548266,	1702548266,	0,	'492',	NULL,	'https://www.ibm.com/cloud/watson-text-to-speech',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (213,	6,	'Resemble.ai',	'1584',	'AI音频工具',	'AI人声生成工具',	50,	1,	'创始人',	9,	'/webnav/ai-audio-tools/show/213.html',	0,	0,	'127.0.0.1',	1702548216,	1702548216,	0,	'493',	NULL,	'https://www.resemble.ai/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (214,	6,	'ACE Studio',	'494',	'AI音频工具',	'AI歌声合成工具，输入歌词与旋律即可生成宛如真人的歌声',	90,	1,	'创始人',	9,	'/webnav/ai-audio-tools/show/214.html',	0,	0,	'127.0.0.1',	1702548282,	1702548282,	0,	'495',	NULL,	'https://ace-studio.timedomain.cn',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (215,	6,	'网易云音乐·X Studio',	'496',	'AI音频工具',	'网易云音乐与小冰智能联合推出的免费AI歌手音乐创作软件',	51,	1,	'创始人',	9,	'/webnav/ai-audio-tools/show/215.html',	0,	0,	'127.0.0.1',	1702548262,	1702548262,	0,	'497',	NULL,	'https://xstudio.music.163.com/?utm_source=ai-bot.cn',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (216,	6,	'ElevenLabs',	'499',	'AI音频工具',	'AI文本转语音，支持包含中文在内的28种语言',	28,	1,	'创始人',	9,	'/webnav/ai-audio-tools/show/216.html',	0,	0,	'127.0.0.1',	1702548275,	1702548275,	0,	'500',	NULL,	'https://elevenlabs.io/?utm_source=ai-bot.cn',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (217,	6,	'Adobe Podcast',	'503',	'AI音频工具',	'Adobe推出的在线AI音频录制和编辑工具',	80,	1,	'创始人',	9,	'/webnav/ai-audio-tools/show/217.html',	0,	0,	'127.0.0.1',	1702548245,	1702548245,	0,	'504',	NULL,	'https://podcast.adobe.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (218,	6,	'大饼AI变声',	'505',	'AI音频工具',	'免费专业的AI变声软件，一键实时语音变声',	96,	1,	'创始人',	9,	'/webnav/ai-audio-tools/show/218.html',	0,	0,	'127.0.0.1',	1702548332,	1702548332,	0,	'506',	NULL,	'https://dubbing.tech/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (219,	6,	'Uberduck',	'509',	'AI音频工具',	'开源的AI语音生成社区，5000多种不同的声音',	99,	1,	'创始人',	9,	'/webnav/ai-audio-tools/show/219.html',	0,	0,	'127.0.0.1',	1702548276,	1702548276,	0,	'510',	NULL,	'https://uberduck.ai/?via=ai-bot',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (220,	6,	'讯飞智作',	'511',	'AI音频工具',	'科大讯飞推出的AI转语音和配音工具',	75,	1,	'创始人',	9,	'/webnav/ai-audio-tools/show/220.html',	0,	0,	'127.0.0.1',	1702548286,	1702548286,	0,	'512',	NULL,	'https://peiyin.xunfei.cn/?utm_source=ai-bot.cn',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (221,	6,	'Riffusion',	'513',	'AI音频工具',	'AI生成不同风格的音乐，免费开源',	60,	1,	'创始人',	9,	'/webnav/ai-audio-tools/show/221.html',	0,	0,	'127.0.0.1',	1702548315,	1702548315,	0,	'514',	NULL,	'https://www.riffusion.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (222,	6,	'Stable Audio',	'515',	'AI音频工具',	'Stability AI最新推出的音乐生成工具',	74,	1,	'创始人',	9,	'/webnav/ai-audio-tools/show/222.html',	0,	0,	'127.0.0.1',	1702548348,	1702548348,	0,	'516',	NULL,	'https://www.stableaudio.com/?utm_source=ai-bot.cn',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (223,	6,	'TME Studio',	'519',	'AI音频工具',	'腾讯音乐推出的智能音乐创作助手',	37,	1,	'创始人',	9,	'/webnav/ai-audio-tools/show/223.html',	0,	0,	'127.0.0.1',	1702548352,	1702548352,	0,	'520',	NULL,	'https://y.qq.com/tme_studio/index.html#/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (224,	6,	'网易天音',	'521',	'AI音频工具',	'网易推出的一站式AI音乐创作工具',	53,	1,	'创始人',	9,	'/webnav/ai-audio-tools/show/224.html',	0,	0,	'127.0.0.1',	1702548323,	1702548323,	0,	'522',	NULL,	'https://tianyin.163.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (225,	7,	'HeyCLI',	'524',	'AI编程工具',	'自然语言转义为CLI命令',	97,	1,	'创始人',	9,	'/webnav/ai-programming-tools/show/225.html',	0,	0,	'127.0.0.1',	1701957405,	1701957405,	0,	'525',	NULL,	NULL,	0,	0,	0),
                                                                                                                                                                                                                                                                                      (226,	7,	'Visual Studio IntelliCode',	'1302',	'AI编程工具',	'Visual Studio AI辅助开发',	89,	1,	'创始人',	9,	'/webnav/ai-programming-tools/show/226.html',	0,	0,	'127.0.0.1',	1701957411,	1701957411,	0,	'526',	NULL,	NULL,	0,	0,	0),
                                                                                                                                                                                                                                                                                      (227,	7,	'AI Code Reviewer',	'1585',	'AI编程工具',	'AI代码检查',	91,	1,	'创始人',	9,	'/webnav/ai-programming-tools/show/227.html',	0,	0,	'127.0.0.1',	1702548358,	1702548358,	0,	'527',	NULL,	'https://ai-code-reviewer.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (228,	7,	'HTTPie AI',	'1586',	'AI编程工具',	'AI API开发工具',	12,	1,	'创始人',	9,	'/webnav/ai-programming-tools/show/228.html',	0,	0,	'127.0.0.1',	1702548310,	1702548310,	0,	'528',	NULL,	'https://httpie.io/ai',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (229,	7,	'Hocoos',	'529',	'AI编程工具',	'无代码AI智能在线快速创建网站',	84,	1,	'创始人',	9,	'/webnav/ai-programming-tools/show/229.html',	0,	0,	'127.0.0.1',	1702548382,	1702548382,	0,	'530',	NULL,	'https://hocoos.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (230,	7,	'CodeSnippets',	'1587',	'AI编程工具',	'AI代码生成、补全、分析、重构和调试',	58,	1,	'创始人',	9,	'/webnav/ai-programming-tools/show/230.html',	0,	0,	'127.0.0.1',	1702548337,	1702548337,	0,	'531',	NULL,	'https://codesnippets.ai/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (231,	7,	'Fig',	'1588',	'AI编程工具',	'下一代命令行工具（内置AI终端命令自动补全）',	48,	1,	'创始人',	9,	'/webnav/ai-programming-tools/show/231.html',	0,	0,	'127.0.0.1',	1702548352,	1702548352,	0,	'532',	NULL,	'https://fig.io/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (232,	7,	'Warp',	'1589',	'AI编程工具',	'21世纪的终端工具（内置AI命令搜索）',	92,	1,	'创始人',	9,	'/webnav/ai-programming-tools/show/232.html',	0,	0,	'127.0.0.1',	1702548354,	1702548354,	0,	'533',	NULL,	'https://www.warp.dev/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (233,	7,	'Debuild',	'534',	'AI编程工具',	'低代码快速开发网页应用',	99,	1,	'创始人',	9,	'/webnav/ai-programming-tools/show/233.html',	0,	0,	'127.0.0.1',	1702548322,	1702548322,	0,	'535',	NULL,	'https://debuild.app/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (234,	7,	'Mutable AI',	'536',	'AI编程工具',	'人工智能加速软件开发',	69,	1,	'创始人',	9,	'/webnav/ai-programming-tools/show/234.html',	0,	0,	'127.0.0.1',	1702548384,	1702548384,	0,	'537',	NULL,	'https://mutable.ai/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (235,	7,	'Tabnine',	'1590',	'AI编程工具',	'AI代码自动补全编程助手',	18,	1,	'创始人',	9,	'/webnav/ai-programming-tools/show/235.html',	0,	0,	'127.0.0.1',	1702548372,	1702548372,	0,	'538',	NULL,	'https://www.tabnine.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (236,	7,	'MarsX',	'539',	'AI编程工具',	'AI无代码软件开发',	88,	1,	'创始人',	9,	'/webnav/ai-programming-tools/show/236.html',	0,	0,	'127.0.0.1',	1702548345,	1702548345,	0,	'540',	NULL,	'https://www.marsx.dev/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (237,	7,	'Fronty',	'541',	'AI编程工具',	'AI智能将图片转换成HTML和CSS代码',	95,	1,	'创始人',	9,	'/webnav/ai-programming-tools/show/237.html',	0,	0,	'127.0.0.1',	1702548351,	1702548351,	0,	'542',	NULL,	'https://fronty.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (238,	7,	'Locofy',	'544',	'AI编程工具',	'AI无代码工具将Figma、Adobe XD和Sketch设计转换成前端代码',	31,	1,	'创始人',	9,	'/webnav/ai-programming-tools/show/238.html',	0,	0,	'127.0.0.1',	1702548379,	1702548379,	0,	'545',	NULL,	'https://www.locofy.ai/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (239,	7,	'Codiga',	'1591',	'AI编程工具',	'AI代码实时分析',	48,	1,	'创始人',	9,	'/webnav/ai-programming-tools/show/239.html',	0,	0,	'127.0.0.1',	1702548398,	1702548398,	0,	'547',	NULL,	'https://www.codiga.io/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (240,	7,	'Ghostwriter',	'548',	'AI编程工具',	'知名在线编程IDE Replit推出的AI编程助手',	18,	1,	'创始人',	9,	'/webnav/ai-programming-tools/show/240.html',	0,	0,	'127.0.0.1',	1702548430,	1702548430,	0,	'549',	NULL,	'https://replit.com/site/ghostwriter',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (241,	7,	'Deco',	'550',	'AI编程工具',	'京东推出的设计稿一键生成多端代码工具',	51,	1,	'创始人',	9,	'/webnav/ai-programming-tools/show/241.html',	0,	0,	'127.0.0.1',	1702548454,	1702548454,	0,	'551',	NULL,	'https://ling-deco.jd.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (242,	7,	'Imgcook',	'552',	'AI编程工具',	'阿里推出的免费设计稿智能生成前端代码',	84,	1,	'创始人',	9,	'/webnav/ai-programming-tools/show/242.html',	0,	0,	'127.0.0.1',	1702548430,	1702548430,	0,	'553',	NULL,	'https://www.imgcook.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (243,	7,	'AirOps',	'1592',	'AI编程工具',	'AI SQL语句生成和修改',	94,	1,	'创始人',	9,	'/webnav/ai-programming-tools/show/243.html',	0,	0,	'127.0.0.1',	1702548403,	1702548403,	0,	'554',	NULL,	'https://www.airops.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (244,	7,	'aiXcoder',	'555',	'AI编程工具',	'自然语言到代码的方法级代码生成，以及多行智能代码补全',	74,	1,	'创始人',	9,	'/webnav/ai-programming-tools/show/244.html',	0,	0,	'127.0.0.1',	1702548398,	1702548398,	0,	'556',	NULL,	'https://www.aixcoder.com',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (245,	7,	'JamGPT',	'557',	'AI编程工具',	'AI Debug调试助手',	11,	1,	'创始人',	9,	'/webnav/ai-programming-tools/show/245.html',	0,	0,	'127.0.0.1',	1702548484,	1702548484,	0,	'558',	NULL,	'https://jam.dev/jamgpt',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (246,	7,	'天工智码Skycode',	'559',	'AI编程工具',	'AI智能编程助手，轻松生成各种代码',	72,	1,	'创始人',	9,	'/webnav/ai-programming-tools/show/246.html',	0,	0,	'127.0.0.1',	1702548447,	1702548447,	0,	'560',	NULL,	'https://sky-code.singularity-ai.com/index.html#/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (247,	7,	'Quest AI',	'561',	'AI编程工具',	'AI将设计稿生成React代码，支持JavaScript和TypeScript',	79,	1,	'创始人',	9,	'/webnav/ai-programming-tools/show/247.html',	0,	0,	'127.0.0.1',	1702548488,	1702548488,	0,	'562',	NULL,	'https://www.quest.ai/?utm_source=ai-bot.cn',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (248,	7,	'Boxy',	'565',	'AI编程工具',	'CodeSandbox推出的AI编程助手',	48,	1,	'创始人',	9,	'/webnav/ai-programming-tools/show/248.html',	0,	0,	'127.0.0.1',	1702548505,	1702548505,	0,	'566',	NULL,	'https://codesandbox.io/blog/meet-boxy-ai-coding-assistant',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (249,	7,	'v0.dev',	'567',	'AI编程工具',	'AI生成前端React/UI组件，由Vercel推出',	47,	1,	'创始人',	9,	'/webnav/ai-programming-tools/show/249.html',	0,	0,	'127.0.0.1',	1702548431,	1702548431,	0,	'568',	NULL,	'https://v0.dev/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (250,	7,	'ChatDev',	'570',	'AI编程工具',	'面壁智能推出的AI智能体软件开发平台，使用自然语言即可创建软件',	59,	1,	'创始人',	9,	'/webnav/ai-programming-tools/show/250.html',	0,	0,	'127.0.0.1',	1702548451,	1702548451,	0,	'571',	NULL,	'https://chatdev.modelbest.cn/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (251,	7,	'AskCodi',	'573',	'AI编程工具',	'你的个人AI编程助手',	18,	1,	'创始人',	9,	'/webnav/ai-programming-tools/show/251.html',	0,	0,	'127.0.0.1',	1702548456,	1702548456,	0,	'574',	NULL,	'https://www.askcodi.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (252,	7,	'CodeArts Snap',	'576',	'AI编程工具',	'华为云推出的智能编程助手',	10,	1,	'创始人',	9,	'/webnav/ai-programming-tools/show/252.html',	0,	0,	'127.0.0.1',	1702548463,	1702548463,	0,	'577',	NULL,	'https://www.huaweicloud.com/lab/paas/codeartssnap.html',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (253,	7,	'Comate',	'578',	'AI编程工具',	'百度推出的AI编程助手，基于文心大模型',	39,	1,	'创始人',	9,	'/webnav/ai-programming-tools/show/253.html',	0,	0,	'127.0.0.1',	1702548450,	1702548450,	0,	'579',	NULL,	'https://comate.baidu.com/?utm_source=ai-bot.cn',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (254,	7,	'iFlyCode',	'580',	'AI编程工具',	'科大讯飞推出的智能编程助手',	83,	1,	'创始人',	9,	'/webnav/ai-programming-tools/show/254.html',	0,	0,	'127.0.0.1',	1702548513,	1702548513,	0,	'581',	NULL,	'https://iflycode.xfyun.cn/?utm_source=ai-bot.cn',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (255,	7,	'CodeFuse',	'582',	'AI编程工具',	'蚂蚁集团推出的AI代码编程助手',	43,	1,	'创始人',	9,	'/webnav/ai-programming-tools/show/255.html',	0,	0,	'127.0.0.1',	1702548521,	1702548521,	0,	'583',	NULL,	'https://codefuse.alipay.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (256,	7,	'通义灵码',	'584',	'AI编程工具',	'阿里推出的免费AI编程工具，基于通义大模型',	80,	1,	'创始人',	9,	'/webnav/ai-programming-tools/show/256.html',	0,	0,	'127.0.0.1',	1702548578,	1702548578,	0,	'1499',	NULL,	'https://tongyi.aliyun.com/lingma/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (257,	7,	'CodeGeeX',	'587',	'AI编程工具',	'智谱AI推出的免费AI编程助手',	41,	1,	'创始人',	9,	'/webnav/ai-programming-tools/show/257.html',	0,	0,	'127.0.0.1',	1702548528,	1702548528,	0,	'588',	NULL,	'https://codegeex.cn/zh-CN',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (258,	7,	'Cursor',	'1593',	'AI编程工具',	'AI编程和软件开发',	19,	1,	'创始人',	9,	'/webnav/ai-programming-tools/show/258.html',	0,	0,	'127.0.0.1',	1702548570,	1702548570,	0,	'589',	NULL,	'https://www.cursor.so/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (259,	7,	'CodiumAI',	'590',	'AI编程工具',	'免费的AI代码测试和分析工具',	82,	1,	'创始人',	9,	'/webnav/ai-programming-tools/show/259.html',	0,	0,	'127.0.0.1',	1702548511,	1702548511,	0,	'591',	NULL,	'https://www.codium.ai/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (260,	7,	'Sketch2Code',	'592',	'AI编程工具',	'微软AI Lab推出的将手绘草图转换成HTML代码工具',	68,	1,	'创始人',	9,	'/webnav/ai-programming-tools/show/260.html',	0,	0,	'127.0.0.1',	1702548578,	1702548578,	0,	'593',	NULL,	'https://sketch2code.azurewebsites.net/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (261,	7,	'Codeium',	'595',	'AI编程工具',	'免费的AI编程工具，智能生成和补全代码',	69,	1,	'创始人',	9,	'/webnav/ai-programming-tools/show/261.html',	0,	0,	'127.0.0.1',	1702548501,	1702548501,	0,	'596',	NULL,	'https://www.codeium.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (262,	7,	'BLACKBOX AI',	'597',	'AI编程工具',	'黑箱AI编程助理，快速代码生成',	22,	1,	'创始人',	9,	'/webnav/ai-programming-tools/show/262.html',	0,	0,	'127.0.0.1',	1702548570,	1702548570,	0,	'598',	NULL,	'https://www.useblackbox.io/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (263,	7,	'Cody',	'599',	'AI编程工具',	'Sourcegraph推出的免费AI编程工具',	56,	1,	'创始人',	9,	'/webnav/ai-programming-tools/show/263.html',	0,	0,	'127.0.0.1',	1702548551,	1702548551,	0,	'600',	NULL,	'https://about.sourcegraph.com/cody?utm_source=ai-bot.cn',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (264,	7,	'CodeWhisperer',	'601',	'AI编程工具',	'亚马逊推出的免费AI编程助手',	55,	1,	'创始人',	9,	'/webnav/ai-programming-tools/show/264.html',	0,	0,	'127.0.0.1',	1702548616,	1702548616,	0,	'602',	NULL,	'https://aws.amazon.com/codewhisperer/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (265,	7,	'GitHub Copilot',	'603',	'AI编程工具',	'GitHub推出的AI编程工具',	96,	1,	'创始人',	9,	'/webnav/ai-programming-tools/show/265.html',	0,	0,	'127.0.0.1',	1702548605,	1702548605,	0,	'604',	NULL,	'https://github.com/features/copilot',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (266,	5,	'讯飞星火认知大模型',	'606',	'AI对话工具,AI训练模型',	'科大讯飞推出的类ChatGPT的讯飞星火认知大模型',	95,	1,	'创始人',	9,	'/webnav/ai-chatbots/show/266.html',	0,	0,	'127.0.0.1',	1702548551,	1702548551,	0,	'607',	NULL,	'http://xinghuo.xfyun.cn/?utm_source=ai-bot.cn',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (267,	5,	'MOSS',	'609',	'AI对话工具,AI训练模型',	'复旦大学团队开发的对话式大型语言模型',	83,	1,	'创始人',	9,	'/webnav/ai-chatbots/show/267.html',	0,	0,	'127.0.0.1',	1702548592,	1702548592,	0,	'610',	NULL,	'https://moss.fastnlp.top/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (268,	8,	'Logomaster.ai',	'1312',	'AI设计工具',	'AI Logo生成工具',	58,	1,	'创始人',	9,	'/webnav/ai-design-tools/show/268.html',	0,	0,	'127.0.0.1',	1701957755,	1701957755,	0,	'611',	NULL,	NULL,	0,	0,	0),
                                                                                                                                                                                                                                                                                      (269,	8,	'ColorMagic',	'1594',	'AI设计工具',	'AI调色板生成工具',	72,	1,	'创始人',	9,	'/webnav/ai-design-tools/show/269.html',	0,	0,	'127.0.0.1',	1702548888,	1702548888,	0,	'612',	NULL,	'https://www.obviously.ai/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (270,	8,	'Huemint',	'1595',	'AI设计工具',	'AI调色生成工具',	27,	1,	'创始人',	9,	'/webnav/ai-design-tools/show/270.html',	0,	0,	'127.0.0.1',	1702548918,	1702548918,	0,	'613',	NULL,	'https://huemint.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (271,	8,	'Color Wheel',	'1596',	'AI设计工具',	'AI灰度logo或插画上色工具',	92,	1,	'创始人',	9,	'/webnav/ai-design-tools/show/271.html',	0,	0,	'127.0.0.1',	1702548928,	1702548928,	0,	'614',	NULL,	'https://brandmark.io/color-wheel/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (272,	8,	'Eva Design System',	'1597',	'AI设计工具',	'基于深度学习的色彩生成工具',	16,	1,	'创始人',	9,	'/webnav/ai-design-tools/show/272.html',	0,	0,	'127.0.0.1',	1702548864,	1702548864,	0,	'615',	NULL,	'https://colors.eva.design/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (273,	8,	'Illustroke',	'1598',	'AI设计工具',	'AI SVG矢量插画生成工具',	38,	1,	'创始人',	9,	'/webnav/ai-design-tools/show/273.html',	0,	0,	'127.0.0.1',	1702548925,	1702548925,	0,	'616',	NULL,	'https://illustroke.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (274,	8,	'Poly',	'1599',	'AI设计工具',	'AI生成3D材质',	33,	1,	'创始人',	9,	'/webnav/ai-design-tools/show/274.html',	0,	0,	'127.0.0.1',	1702548965,	1702548965,	0,	'617',	NULL,	'https://withpoly.com/browse/textures',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (275,	8,	'Fabrie AI',	'618',	'AI设计工具',	'在线白板协作平台Fabrie推出的AI设计助手，支持多种渲染模式',	87,	1,	'创始人',	9,	'/webnav/ai-design-tools/show/275.html',	0,	0,	'127.0.0.1',	1702548925,	1702548925,	0,	'619',	NULL,	'https://kebuxi.datasink.sensorsdata.cn/r/dF',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (276,	8,	'Meshy',	'621',	'AI设计工具',	'AI快速从文本或图像生成3D模型',	91,	1,	'创始人',	9,	'/webnav/ai-design-tools/show/276.html',	0,	0,	'127.0.0.1',	1702548890,	1702548890,	0,	'622',	NULL,	'https://www.meshy.ai/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (277,	8,	'美间',	'624',	'AI设计工具',	'AI软装设计、海报和提案生成工具',	93,	1,	'创始人',	9,	'/webnav/ai-design-tools/show/277.html',	0,	0,	'127.0.0.1',	1702548918,	1702548918,	0,	'625',	NULL,	'https://www.meijian.com/?utm_source=ai-bot.cn',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (278,	8,	'图宇宙',	'626',	'AI设计工具',	'高品质AI智能设计平台',	55,	1,	'创始人',	9,	'/webnav/ai-design-tools/show/278.html',	0,	0,	'127.0.0.1',	1702548921,	1702548921,	0,	'627',	NULL,	'https://www.nolibox.com/introduction',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (279,	8,	'Luma AI',	'629',	'AI设计工具',	'AI 3D捕捉、建模和渲染',	11,	1,	'创始人',	9,	'/webnav/ai-design-tools/show/279.html',	0,	0,	'127.0.0.1',	1702548985,	1702548985,	0,	'630',	NULL,	'https://lumalabs.ai/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (280,	8,	'Uizard',	'1600',	'AI设计工具',	'AI网页、App和UI设计',	98,	1,	'创始人',	9,	'/webnav/ai-design-tools/show/280.html',	0,	0,	'127.0.0.1',	1702549012,	1702549012,	0,	'631',	NULL,	'https://uizard.io/ai-design/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (281,	8,	'illostrationAI',	'1601',	'AI设计工具',	'AI插画生成，low poly、3D、矢量、logo、像素风、皮克斯等风格',	91,	1,	'创始人',	9,	'/webnav/ai-design-tools/show/281.html',	0,	0,	'127.0.0.1',	1702548947,	1702548947,	0,	'632',	NULL,	'https://www.illostration.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (282,	8,	'Spline AI',	'633',	'AI设计工具',	'Spline推出的AI生成3D物体、动画、材质',	95,	1,	'创始人',	9,	'/webnav/ai-design-tools/show/282.html',	0,	0,	'127.0.0.1',	1702548991,	1702548991,	0,	'634',	NULL,	'https://spline.design/ai',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (283,	8,	'Galileo AI',	'635',	'AI设计工具',	'AI高保真原型设计',	58,	1,	'创始人',	9,	'/webnav/ai-design-tools/show/283.html',	0,	0,	'127.0.0.1',	1702548942,	1702548942,	0,	'636',	NULL,	'https://www.usegalileo.ai/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (284,	8,	'Designs.ai',	'1602',	'AI设计工具',	'AI设计工具',	97,	1,	'创始人',	9,	'/webnav/ai-design-tools/show/284.html',	0,	0,	'127.0.0.1',	1702548975,	1702548975,	0,	'637',	NULL,	'https://designs.ai/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (285,	8,	'Dora AI',	'638',	'AI设计工具',	'AI在线生成精美3D动画的网站',	24,	1,	'创始人',	9,	'/webnav/ai-design-tools/show/285.html',	0,	0,	'127.0.0.1',	1702548978,	1702548978,	0,	'639',	NULL,	'https://www.dora.run/ai',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (286,	8,	'Vizcom',	'640',	'AI设计工具',	'AI渲染转化手绘图为产品设计图',	66,	1,	'创始人',	9,	'/webnav/ai-design-tools/show/286.html',	0,	0,	'127.0.0.1',	1702549013,	1702549013,	0,	'641',	NULL,	'https://www.vizcom.ai/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (287,	8,	'模袋云AI',	'642',	'AI设计工具',	'建筑AI创作平台，专注于大型建筑、小型住宅、室内设计、景观的出图和AI模型训练',	13,	1,	'创始人',	9,	'/webnav/ai-design-tools/show/287.html',	0,	0,	'127.0.0.1',	1702549019,	1702549019,	0,	'643',	NULL,	'https://www.modaiyun.com/mdy/ai?utm_source=ai-bot.cn',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (288,	8,	'Vectorizer.AI',	'645',	'AI设计工具',	'AI一键将位图转换为矢量图片',	23,	1,	'创始人',	9,	'/webnav/ai-design-tools/show/288.html',	0,	0,	'127.0.0.1',	1702549052,	1702549052,	0,	'646',	NULL,	'https://vectorizer.ai/?utm_source=ai-bot.cn',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (289,	8,	'Realibox AI',	'647',	'AI设计工具',	'AI免费将草图/模型生成3D渲染图',	27,	1,	'创始人',	9,	'/webnav/ai-design-tools/show/289.html',	0,	0,	'127.0.0.1',	1702549033,	1702549033,	0,	'648',	NULL,	'https://www.realibox.com/product/ai?utm_source=ai-bot.cn',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (290,	8,	'LogoliveryAI',	'650',	'AI设计工具',	'免费的AI Logo生成器，提供SVG矢量格式',	73,	1,	'创始人',	9,	'/webnav/ai-design-tools/show/290.html',	0,	0,	'127.0.0.1',	1702549071,	1702549071,	0,	'651',	NULL,	'https://logolivery.ai/?utm_source=ai-bot.cn',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (291,	8,	'Motiff',	'653',	'AI设计工具',	'猿辅导旗下公司推出的AI设计工具',	49,	1,	'创始人',	9,	'/webnav/ai-design-tools/show/291.html',	0,	0,	'127.0.0.1',	1702549041,	1702549041,	0,	'654',	NULL,	'https://motiff.com/?utm_source=ai-bot.cn',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (292,	8,	'MasterGo AI',	'656',	'AI设计工具',	'国产产品设计工具MasterGo推出的智能UI设计助手',	22,	1,	'创始人',	9,	'/webnav/ai-design-tools/show/292.html',	0,	0,	'127.0.0.1',	1702549106,	1702549106,	0,	'657',	NULL,	'https://mastergo.com/upcoming-ai/apply?utm_source=ai-bot.cn',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (293,	8,	'Framer AI',	'658',	'AI设计工具',	'Framer推出的AI网站自动设计、生成和上线',	23,	1,	'创始人',	9,	'/webnav/ai-design-tools/show/293.html',	0,	0,	'127.0.0.1',	1702549064,	1702549064,	0,	'659',	NULL,	'https://www.framer.com/ai?utm_source=ai-bot.cn',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (294,	8,	'Pixso AI',	'661',	'AI设计工具',	'国产在线设计工具Pixso的内置AI助手，支持AI文生图、AI对话、AI设计等',	94,	1,	'创始人',	9,	'/webnav/ai-design-tools/show/294.html',	0,	0,	'127.0.0.1',	1702549053,	1702549053,	0,	'662',	NULL,	'https://pixso.cn/?utm_source=ai-bot.cn',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (295,	8,	'酷家乐AI',	'664',	'AI设计工具',	'功能强大的AI家居设计软件',	11,	1,	'创始人',	9,	'/webnav/ai-design-tools/show/295.html',	0,	0,	'127.0.0.1',	1702549113,	1702549113,	0,	'665',	NULL,	'https://www.kujiale.cn/activities/AI-kujiale',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (296,	8,	'Recraft AI',	'667',	'AI设计工具',	'免费无限AI画板，生成高质量矢量艺术画、图标、3D图片和插画',	42,	1,	'创始人',	9,	'/webnav/ai-design-tools/show/296.html',	0,	0,	'127.0.0.1',	1702549077,	1702549077,	0,	'668',	NULL,	'https://www.recraft.ai/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (297,	8,	'墨刀AI',	'670',	'AI设计工具',	'墨刀推出的AI产品原型设计助手',	68,	1,	'创始人',	9,	'/webnav/ai-design-tools/show/297.html',	0,	0,	'127.0.0.1',	1702549122,	1702549122,	0,	'671',	NULL,	'https://modao.cc/feature/ai.html?utm_source=ai-bot.cn',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (298,	8,	'羚珑',	'673',	'AI设计工具',	'京东推出的商品图智能设计小工具',	27,	1,	'创始人',	9,	'/webnav/ai-design-tools/show/298.html',	0,	0,	'127.0.0.1',	1702549088,	1702549088,	0,	'674',	NULL,	'https://ling.jd.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (299,	8,	'鹿班',	'675',	'AI设计工具',	'阿里推出的智能设计商品图和海报的平台',	87,	1,	'创始人',	9,	'/webnav/ai-design-tools/show/299.html',	0,	0,	'127.0.0.1',	1702549084,	1702549084,	0,	'676',	NULL,	'https://luban.aliyun.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (300,	8,	'Looka',	'1603',	'AI设计工具',	'AI在线设计和生成logo',	68,	1,	'创始人',	9,	'/webnav/ai-design-tools/show/300.html',	0,	0,	'127.0.0.1',	1702549177,	1702549177,	0,	'677',	NULL,	'https://looka.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (301,	8,	'AIDesign',	'678',	'AI设计工具',	'腾讯推出的免费AI Logo在线设计工具',	44,	1,	'创始人',	9,	'/webnav/ai-design-tools/show/301.html',	0,	0,	'127.0.0.1',	1702549132,	1702549132,	0,	'679',	NULL,	'https://ailogo.qq.com/guide/brandname',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (302,	8,	'阿里云智能logo设计',	'680',	'AI设计工具',	'阿里云推出的智能Logo设计',	46,	1,	'创始人',	9,	'/webnav/ai-design-tools/show/302.html',	0,	0,	'127.0.0.1',	1702549129,	1702549129,	0,	'302',	NULL,	'https://ai-bot.cn',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (303,	8,	'智绘设计',	'682',	'AI设计工具',	'腾讯推出的智能设计平台，让内容更精彩',	74,	1,	'创始人',	9,	'/webnav/ai-design-tools/show/303.html',	0,	0,	'127.0.0.1',	1702549121,	1702549121,	0,	'683',	NULL,	'https://taishan.qq.com/brand/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (304,	8,	'Magic Design',	'684',	'AI设计工具',	'在线设计工具Canva推出的AI设计工具',	96,	1,	'创始人',	9,	'/webnav/ai-design-tools/show/304.html',	0,	0,	'127.0.0.1',	1702549211,	1702549211,	0,	'191',	NULL,	'https://www.canva.com/magic-design/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (305,	8,	'Microsoft Designer',	'687',	'AI设计工具',	'微软推出的在线设计海报和宣传图工具',	63,	1,	'创始人',	9,	'/webnav/ai-design-tools/show/305.html',	0,	0,	'127.0.0.1',	1702549210,	1702549210,	0,	'688',	NULL,	'https://designer.microsoft.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (306,	8,	'FigJam AI',	'691',	'AI设计工具',	'Figma推出的AI白板协作设计工具',	62,	1,	'创始人',	9,	'/webnav/ai-design-tools/show/306.html',	0,	0,	'127.0.0.1',	1702549149,	1702549149,	0,	'692',	NULL,	'https://www.figma.com/figjam/ai/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (307,	21,	'MindShow',	'694',	'AI幻灯片和演示',	'国内独立开发者开发的输入内容自动生成演示工具',	45,	1,	'创始人',	9,	'/webnav/ai-slideshow-tools/show/307.html',	0,	0,	'127.0.0.1',	1702549227,	1702549227,	0,	'695',	NULL,	'https://www.mindshow.fun/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (308,	21,	'auxi',	'696',	'AI幻灯片和演示',	'功能强大的PowerPoint AI插件',	30,	1,	'创始人',	9,	'/webnav/ai-slideshow-tools/show/308.html',	0,	0,	'127.0.0.1',	1702549181,	1702549181,	0,	'697',	NULL,	'https://www.auxi.ai/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (309,	21,	'ChatPPT',	'698',	'AI幻灯片和演示',	'必优科技推出的国内首个中文AI生成PPT的办公产品',	51,	1,	'创始人',	9,	'/webnav/ai-slideshow-tools/show/309.html',	0,	0,	'127.0.0.1',	1702549224,	1702549224,	0,	'699',	NULL,	'https://chat-ppt.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (310,	21,	'歌者AI',	'700',	'AI幻灯片和演示',	'彩漩PPT推出的AI PPT生成工具',	28,	1,	'创始人',	9,	'/webnav/ai-slideshow-tools/show/310.html',	0,	0,	'127.0.0.1',	1702549230,	1702549230,	0,	'701',	NULL,	'https://gezhe.caixuan.cc/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (311,	21,	'SlidesAI',	'702',	'AI幻灯片和演示',	'AI快速创建演示幻灯片',	20,	1,	'创始人',	9,	'/webnav/ai-slideshow-tools/show/311.html',	0,	0,	'127.0.0.1',	1702549193,	1702549193,	0,	'703',	NULL,	'https://www.slidesai.io/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (312,	21,	'Presentations.AI',	'1604',	'AI幻灯片和演示',	'演示文档版的ChatGPT',	70,	1,	'创始人',	9,	'/webnav/ai-slideshow-tools/show/312.html',	0,	0,	'127.0.0.1',	1702549237,	1702549237,	0,	'704',	NULL,	'https://www.presentations.ai/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (313,	21,	'Chronicle',	'705',	'AI幻灯片和演示',	'AI高颜值演示文稿创建',	67,	1,	'创始人',	9,	'/webnav/ai-slideshow-tools/show/313.html',	0,	0,	'127.0.0.1',	1702549266,	1702549266,	0,	'706',	NULL,	'https://chroniclehq.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (314,	21,	'beautiful.ai',	'1605',	'AI幻灯片和演示',	'AI创建展示幻灯片',	20,	1,	'创始人',	9,	'/webnav/ai-slideshow-tools/show/314.html',	0,	0,	'127.0.0.1',	1702549235,	1702549235,	0,	'707',	NULL,	'https://www.beautiful.ai/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (315,	21,	'Powerpresent AI',	'708',	'AI幻灯片和演示',	'AI创建精美的演示稿',	34,	1,	'创始人',	9,	'/webnav/ai-slideshow-tools/show/315.html',	0,	0,	'127.0.0.1',	1702549278,	1702549278,	0,	'709',	NULL,	'https://powerpresent.ai/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (316,	21,	'ChatBA',	'710',	'AI幻灯片和演示',	'AI幻灯片生成工具',	95,	1,	'创始人',	9,	'/webnav/ai-slideshow-tools/show/316.html',	0,	0,	'127.0.0.1',	1702549262,	1702549262,	0,	'711',	NULL,	'https://www.chatba.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (317,	21,	'讯飞智文',	'712',	'AI幻灯片和演示',	'科大讯飞推出的免费AI PPT生成工具',	85,	1,	'创始人',	9,	'/webnav/ai-slideshow-tools/show/317.html',	0,	0,	'127.0.0.1',	1702549256,	1702549256,	0,	'713',	NULL,	'https://zhiwen.xfyun.cn/?utm_source=ai-bot.cn',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (318,	21,	'Tome',	'716',	'AI幻灯片和演示',	'AI创作叙事性幻灯片',	48,	1,	'创始人',	9,	'/webnav/ai-slideshow-tools/show/318.html',	0,	0,	'127.0.0.1',	1702549282,	1702549282,	0,	'717',	NULL,	'https://tome.app/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (319,	21,	'Decktopus AI',	'718',	'AI幻灯片和演示',	'AI驱动的的在线演示文稿生成器',	32,	1,	'创始人',	9,	'/webnav/ai-slideshow-tools/show/319.html',	0,	0,	'127.0.0.1',	1702549273,	1702549273,	0,	'719',	NULL,	'https://www.decktopus.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (320,	21,	'Gamma App',	'720',	'AI幻灯片和演示',	'AI幻灯片演示生成工具',	14,	1,	'创始人',	9,	'/webnav/ai-slideshow-tools/show/320.html',	0,	0,	'127.0.0.1',	1702549250,	1702549250,	0,	'721',	NULL,	'https://gamma.app/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (321,	21,	'美图AI PPT',	'722',	'AI幻灯片和演示',	'美图秀秀推出的免费在线AI生成PPT设计工具',	18,	1,	'创始人',	9,	'/webnav/ai-slideshow-tools/show/321.html',	0,	0,	'127.0.0.1',	1702549332,	1702549332,	0,	'723',	NULL,	'https://www.x-design.com/ppt/?from=ai-bot.cn',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (322,	21,	'AiPPT',	'724',	'AI幻灯片和演示',	'AI快速生成高质量PPT',	74,	1,	'创始人',	9,	'/webnav/ai-slideshow-tools/show/322.html',	0,	0,	'127.0.0.1',	1702549332,	1702549332,	0,	'725',	NULL,	'https://www.aippt.cn/?utm_type=Navweb&amp;utm_source=ai-bot&amp;utm_page=aippt&amp;utm_plan=ppt&amp;utm_unit=AIPPT&amp;utm_keyword=50608',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (323,	3,	'Rask',	'727',	'AI视频工具',	'AI视频本地化解决方案',	37,	1,	'创始人',	9,	'/webnav/ai-video-tools/show/323.html',	0,	0,	'127.0.0.1',	1702549298,	1702549298,	0,	'728',	NULL,	'https://www.rask.ai/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (324,	3,	'SteveAI',	'729',	'AI视频工具',	'Animaker旗下AI在线视频制作工具',	24,	1,	'创始人',	9,	'/webnav/ai-video-tools/show/324.html',	0,	0,	'127.0.0.1',	1702549366,	1702549366,	0,	'730',	NULL,	'https://cn.bing.com/search?q=SteveAI&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (325,	3,	'Pictory',	'731',	'AI视频工具',	'AI视频制作工具',	53,	1,	'创始人',	9,	'/webnav/ai-video-tools/show/325.html',	0,	0,	'127.0.0.1',	1702549327,	1702549327,	0,	'732',	NULL,	'https://cn.bing.com/search?q=Pictory&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (326,	3,	'Elai.io',	'733',	'AI视频工具',	'AI文本到视频生成工具',	64,	1,	'创始人',	9,	'/webnav/ai-video-tools/show/326.html',	0,	0,	'127.0.0.1',	1702549328,	1702549328,	0,	'734',	NULL,	'https://cn.bing.com/search?q=Elai.io&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (327,	3,	'AVCLabs',	'735',	'AI视频工具',	'AI自动移除视频背景',	54,	1,	'创始人',	9,	'/webnav/ai-video-tools/show/327.html',	0,	0,	'127.0.0.1',	1702549360,	1702549360,	0,	'736',	NULL,	'https://app.avclabs.com/#/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (328,	3,	'Colossyan',	'737',	'AI视频工具',	'AI虚拟人出镜视频生成',	72,	1,	'创始人',	9,	'/webnav/ai-video-tools/show/328.html',	0,	0,	'127.0.0.1',	1702549318,	1702549318,	0,	'738',	NULL,	'https://cn.bing.com/search?q=Colossyan&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (329,	3,	'Synthesys',	'739',	'AI视频工具',	'AI虚拟人出镜讲解',	20,	1,	'创始人',	9,	'/webnav/ai-video-tools/show/329.html',	0,	0,	'127.0.0.1',	1702549414,	1702549414,	0,	'740',	NULL,	'https://cn.bing.com/search?q=Synthesys&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (330,	3,	'Gencraft',	'741',	'AI视频工具',	'AI艺术画视频生成工具',	63,	1,	'创始人',	9,	'/webnav/ai-video-tools/show/330.html',	0,	0,	'127.0.0.1',	1702549434,	1702549434,	0,	'742',	NULL,	'https://cn.bing.com/search?q=Gencraft&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (331,	3,	'绘影字幕',	'743',	'AI视频工具',	'一键智能在线自动为视频加字幕',	89,	1,	'创始人',	9,	'/webnav/ai-video-tools/show/331.html',	0,	0,	'127.0.0.1',	1702549465,	1702549465,	0,	'744',	NULL,	'https://huiyingzimu.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (332,	3,	'万彩微影',	'745',	'AI视频工具',	'AI智能自动生成动画短视频',	12,	1,	'创始人',	9,	'/webnav/ai-video-tools/show/332.html',	0,	0,	'127.0.0.1',	1702549401,	1702549401,	0,	'746',	NULL,	'https://www.animiz.cn/microvideo/?utm_source=ai-bot.cn',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (333,	3,	'HeyGen',	'747',	'AI视频工具',	'AIGC 视频创建平台，生成吸引人的商业视频',	53,	1,	'创始人',	9,	'/webnav/ai-video-tools/show/333.html',	0,	0,	'127.0.0.1',	1702549427,	1702549427,	0,	'748',	NULL,	'https://cn.bing.com/search?q=HeyGen&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (334,	3,	'奇妙元',	'749',	'AI视频工具',	'AI数字人视频生成平台，由出门问问推出',	75,	1,	'创始人',	9,	'/webnav/ai-video-tools/show/334.html',	0,	0,	'127.0.0.1',	1702549434,	1702549434,	0,	'750',	NULL,	'https://weta365.com/conduct',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (335,	3,	'万兴播爆',	'751',	'AI视频工具',	'万兴科技推出的AI数字人口播视频营销工具',	24,	1,	'创始人',	9,	'/webnav/ai-video-tools/show/335.html',	0,	0,	'127.0.0.1',	1702549511,	1702549511,	0,	'752',	NULL,	'https://virbo.wondershare.cn/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (336,	3,	'来画',	'753',	'AI视频工具',	'动画和数字人智能生成平台',	64,	1,	'创始人',	9,	'/webnav/ai-video-tools/show/336.html',	0,	0,	'127.0.0.1',	1702549495,	1702549495,	0,	'754',	NULL,	'https://www.laihua.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (337,	3,	'Rephrase.ai',	'755',	'AI视频工具',	'AI文字到视频生成',	21,	1,	'创始人',	9,	'/webnav/ai-video-tools/show/337.html',	0,	0,	'127.0.0.1',	1702549472,	1702549472,	0,	'756',	NULL,	'https://cn.bing.com/search?q=Rephrase.ai&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (338,	3,	'Lumen5',	'757',	'AI视频工具',	'AI将博客文章转换成视频',	52,	1,	'创始人',	9,	'/webnav/ai-video-tools/show/338.html',	0,	0,	'127.0.0.1',	1702549498,	1702549498,	0,	'758',	NULL,	'https://cn.bing.com/search?q=Lumen5&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (339,	3,	'Synthesia',	'759',	'AI视频工具',	'AI视频生成平台',	64,	1,	'创始人',	9,	'/webnav/ai-video-tools/show/339.html',	0,	0,	'127.0.0.1',	1702549543,	1702549543,	0,	'760',	NULL,	'https://cn.bing.com/search?q=Synthesia&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (340,	3,	'DeepBrain',	'761',	'AI视频工具',	'AI口播视频生成工具',	25,	1,	'创始人',	9,	'/webnav/ai-video-tools/show/340.html',	0,	0,	'127.0.0.1',	1702549486,	1702549486,	0,	'762',	NULL,	'https://cn.bing.com/search?q=DeepBrain&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (341,	3,	'Fliki',	'763',	'AI视频工具',	'AI文字转视频并配音',	66,	1,	'创始人',	9,	'/webnav/ai-video-tools/show/341.html',	0,	0,	'127.0.0.1',	1702549546,	1702549546,	0,	'764',	NULL,	'https://cn.bing.com/search?q=Fliki&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (342,	3,	'DreamFace',	'765',	'AI视频工具',	'让图片动起来的AI工具',	87,	1,	'创始人',	9,	'/webnav/ai-video-tools/show/342.html',	0,	0,	'127.0.0.1',	1702549580,	1702549580,	0,	'766',	NULL,	'https://dreamfaceapp.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (343,	3,	'Kaiber',	'767',	'AI视频工具',	'图片文字转视频的AI引擎',	25,	1,	'创始人',	9,	'/webnav/ai-video-tools/show/343.html',	0,	0,	'127.0.0.1',	1702549508,	1702549508,	0,	'768',	NULL,	'https://cn.bing.com/search?q=Kaiber&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (344,	3,	'EbSynth',	'769',	'AI视频工具',	'AI将真人视频转化为油画风动画',	86,	1,	'创始人',	9,	'/webnav/ai-video-tools/show/344.html',	0,	0,	'127.0.0.1',	1702549552,	1702549552,	0,	'770',	NULL,	'https://ebsynth.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (345,	3,	'Unscreen',	'771',	'AI视频工具',	'AI智能视频背景移除工具',	63,	1,	'创始人',	9,	'/webnav/ai-video-tools/show/345.html',	0,	0,	'127.0.0.1',	1702549541,	1702549541,	0,	'772',	NULL,	'https://www.unscreen.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (346,	3,	'Capsule',	'773',	'AI视频工具',	'AI驱动的在线视频剪辑工具，个人和小团队免费',	85,	1,	'创始人',	9,	'/webnav/ai-video-tools/show/346.html',	0,	0,	'127.0.0.1',	1702549594,	1702549594,	0,	'774',	NULL,	'https://capsule.video/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (347,	3,	'Artflow',	'776',	'AI视频工具',	'AI创建生成视频动画',	92,	1,	'创始人',	9,	'/webnav/ai-video-tools/show/347.html',	0,	0,	'127.0.0.1',	1702549589,	1702549589,	0,	'777',	NULL,	'https://cn.bing.com/search?q=Artflow&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (348,	3,	'Pika',	'778',	'AI视频工具',	'Pika Labs推出的AI视频生成和编辑工具',	26,	1,	'创始人',	9,	'/webnav/ai-video-tools/show/348.html',	0,	0,	'127.0.0.1',	1702549617,	1702549617,	0,	'779',	NULL,	'https://pika.art/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (349,	3,	'Wonder Studio',	'781',	'AI视频工具',	'AI自动为CG角色制作动画、打光并将其合成到真人场景中',	17,	1,	'创始人',	9,	'/webnav/ai-video-tools/show/349.html',	0,	0,	'127.0.0.1',	1702549584,	1702549584,	0,	'782',	NULL,	'https://wonderdynamics.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (350,	3,	'快剪辑',	'784',	'AI视频工具',	'360旗下的AI视频剪辑工具，AI成片、AI数字人、智能添加字幕、去水印等',	14,	1,	'创始人',	9,	'/webnav/ai-video-tools/show/350.html',	0,	0,	'127.0.0.1',	1702549599,	1702549599,	0,	'785',	NULL,	'https://www.kuaijianji.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (351,	3,	'腾讯智影',	'787',	'AI视频工具',	'腾讯推出的在线智能视频创作平台',	90,	1,	'创始人',	9,	'/webnav/ai-video-tools/show/351.html',	0,	0,	'127.0.0.1',	1702549667,	1702549667,	0,	'788',	NULL,	'https://zenvideo.qq.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (352,	3,	'D-ID',	'789',	'AI视频工具',	'AI真人口播视频生成工具',	21,	1,	'创始人',	9,	'/webnav/ai-video-tools/show/352.html',	0,	0,	'127.0.0.1',	1702549611,	1702549611,	0,	'790',	NULL,	'https://cn.bing.com/search?q=D-ID&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (353,	3,	'Runway',	'791',	'AI视频工具',	'强大的AI视频制作工具，绿幕抠像、视频合成等',	83,	1,	'创始人',	9,	'/webnav/ai-video-tools/show/353.html',	0,	0,	'127.0.0.1',	1702549665,	1702549665,	0,	'375',	NULL,	'https://runwayml.com/green-screen/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (354,	3,	'即创',	'793',	'AI视频工具',	'抖音推出的一站式智能创作平台，支持视频、图文和直播创作',	96,	1,	'创始人',	9,	'/webnav/ai-video-tools/show/354.html',	0,	0,	'127.0.0.1',	1702549614,	1702549614,	0,	'794',	NULL,	'https://aic.oceanengine.com/?from=ai-bot.cn',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (355,	15,	'Graviti Diffus',	'796',	'常用AI图像工具',	'开箱即用的 Stable Diffusion WebUI 在线图像生成服务',	29,	1,	'创始人',	9,	'/webnav/ai-image-tools/show/355.html',	0,	0,	'127.0.0.1',	1702549656,	1702549656,	0,	'797',	NULL,	'https://www.diffus.graviti.com/?utm_source=tool&amp;utm_medium=referral&amp;utm_campaign=aibot',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (356,	15,	'悟空图像PhotoSir',	'799',	'常用AI图像工具',	'新一代专业图像处理软件，更智能、更高效、更好用',	75,	1,	'创始人',	9,	'/webnav/ai-image-tools/show/356.html',	0,	0,	'127.0.0.1',	1702549690,	1702549690,	0,	'800',	NULL,	'https://www.photosir.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (357,	15,	'Cutout.Pro',	'802',	'常用AI图像工具',	'AI在线处理图片',	81,	1,	'创始人',	9,	'/webnav/ai-image-tools/show/357.html',	0,	0,	'127.0.0.1',	1702549705,	1702549705,	0,	'803',	NULL,	'https://www.cutout.pro/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (358,	15,	'Booltool',	'804',	'常用AI图像工具',	'在线AI图像工具箱',	14,	1,	'创始人',	9,	'/webnav/ai-image-tools/show/358.html',	0,	0,	'127.0.0.1',	1702549675,	1702549675,	0,	'805',	NULL,	'https://booltool.boolv.tech/home',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (359,	15,	'MagicStudio',	'806',	'常用AI图像工具',	'高颜值AI图像处理工具',	69,	1,	'创始人',	9,	'/webnav/ai-image-tools/show/359.html',	0,	0,	'127.0.0.1',	1702549718,	1702549718,	0,	'807',	NULL,	'https://magicstudio.com/zh',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (363,	15,	'Leonardo.ai',	'814',	'常用AI图像工具',	'AI创建精美的游戏插画资产',	63,	1,	'创始人',	9,	'/webnav/ai-image-tools/show/363.html',	0,	0,	'127.0.0.1',	1702549724,	1702549724,	0,	'815',	NULL,	'https://leonardo.ai/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (364,	15,	'ClipDrop',	'816',	'常用AI图像工具',	'Stability.ai推出的AI图片处理系列工具',	55,	1,	'创始人',	9,	'/webnav/ai-image-tools/show/364.html',	0,	0,	'127.0.0.1',	1702549746,	1702549746,	0,	'817',	NULL,	'https://clipdrop.co/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (369,	15,	'图查查',	'828',	'常用AI图像工具',	'360推出的AI作图平台，提供智能抠图、智能消除、智能放大、智能配图等功能',	56,	1,	'创始人',	9,	'/webnav/ai-image-tools/show/369.html',	0,	0,	'127.0.0.1',	1702549819,	1702549819,	0,	'829',	NULL,	'https://chacha.so.com/home?utm_source=ai-bot.cn',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (385,	15,	'ARC',	'875',	'常用AI图像工具',	'腾讯旗下ARC实验室推出的免费AI图片处理工具',	25,	1,	'创始人',	9,	'/webnav/ai-image-tools/show/385.html',	0,	0,	'127.0.0.1',	1702550023,	1702550023,	0,	'876',	NULL,	'https://arc.tencent.com/zh/ai-demos/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (387,	15,	'Ribbet.ai',	'879',	'常用AI图像工具',	'免费的多功能AI图片处理工具箱',	12,	1,	'创始人',	9,	'/webnav/ai-image-tools/show/387.html',	0,	0,	'127.0.0.1',	1702550072,	1702550072,	0,	'880',	NULL,	'https://ribbet.ai/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (390,	1,	'HeyFriday',	'1606',	'AI写作工具',	'国内团队推出的智能AI写作工具',	77,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/390.html',	0,	0,	'127.0.0.1',	1702547294,	1702547294,	0,	'175',	NULL,	'https://www.heyfriday.cn/home',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (391,	1,	'悉语',	'1607',	'AI写作工具',	'阿里旗下智能文案工具，一键生成电商营销文案',	99,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/391.html',	0,	0,	'127.0.0.1',	1702547329,	1702547329,	0,	'181',	NULL,	'https://chuangyi.taobao.com/pages/aiCopy',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (393,	23,	'星火科研助手',	'892',	'AI文档工具',	'科大讯飞联合中科院推出的AI科研文献助手',	99,	1,	'创始人',	9,	'/webnav/ai-document-tools/show/393.html',	0,	0,	'127.0.0.1',	1702562184,	1702562184,	0,	'893',	NULL,	'https://paper.iflytek.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (395,	1,	'新华妙笔',	'899',	'AI写作工具',	'新华社推出的AI公文写作平台',	55,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/395.html',	0,	0,	'127.0.0.1',	1702547411,	1702547411,	0,	'900',	NULL,	'https://miaobi.xinhuaskl.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (396,	23,	'PMAI',	'904',	'AI文档工具',	'面向产品经理的AI助手',	32,	1,	'创始人',	9,	'/webnav/ai-document-tools/show/396.html',	0,	0,	'127.0.0.1',	1701958975,	1701958975,	0,	'905',	NULL,	NULL,	0,	0,	0),
                                                                                                                                                                                                                                                                                      (397,	7,	'代码小浣熊Raccoon',	'907',	'AI编程工具',	'商汤科技推出的智能AI编程助手',	56,	1,	'创始人',	9,	'/webnav/ai-programming-tools/show/397.html',	0,	0,	'127.0.0.1',	1702548473,	1702548473,	0,	'908',	NULL,	'https://code.sensetime.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (399,	3,	'一帧秒创',	'915',	'AI视频工具',	'简单好用的AI智能视频创作平台',	82,	1,	'创始人',	9,	'/webnav/ai-video-tools/show/399.html',	0,	0,	'127.0.0.1',	1702550200,	1702550200,	0,	'916',	NULL,	'https://aigc.yizhentv.com/?_f=botrm',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (402,	5,	'文心一言',	'930',	'AI对话工具',	'百度推出的基于文心大模型的AI对话互动工具',	59,	1,	'创始人',	9,	'/webnav/ai-chatbots/show/402.html',	0,	0,	'127.0.0.1',	1702550189,	1702550189,	0,	'931',	NULL,	'https://yiyan.baidu.com/?utm_source=ai-bot.cn',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (404,	13,	'GPT-4',	'934',	'AI训练模型',	'OpenAI旗下最新的GPT-4模型',	47,	1,	'创始人',	9,	'/webnav/ai-models/show/404.html',	0,	0,	'127.0.0.1',	1702550237,	1702550237,	0,	'935',	NULL,	'https://cn.bing.com/search?q=GPT-4&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (405,	5,	'360智脑',	'936',	'AI对话工具',	'360搜索最新推出的AI对话聊天机器人',	20,	1,	'创始人',	9,	'/webnav/ai-chatbots/show/405.html',	0,	0,	'127.0.0.1',	1702548599,	1702548599,	0,	'937',	NULL,	'https://ai.360.com/?src=ai-bot.cn',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (406,	5,	'Inworld',	'939',	'AI对话工具',	'开发和创建AI虚拟角色并与其互动',	94,	1,	'创始人',	9,	'/webnav/ai-chatbots/show/406.html',	0,	0,	'127.0.0.1',	1702548632,	1702548632,	0,	'940',	NULL,	'https://cn.bing.com/search?q=Inworld&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (407,	5,	'Pi',	'941',	'AI对话工具',	'DeepMind联创新公司推出的AI聊天机器人',	68,	1,	'创始人',	9,	'/webnav/ai-chatbots/show/407.html',	0,	0,	'127.0.0.1',	1702548645,	1702548645,	0,	'942',	NULL,	'https://cn.bing.com/search?q=Pi&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (408,	5,	'Open Assistant',	'943',	'AI对话工具',	'免费开源的对话式AI，GitHub星标超3万',	87,	1,	'创始人',	9,	'/webnav/ai-chatbots/show/408.html',	0,	0,	'127.0.0.1',	1702548660,	1702548660,	0,	'944',	NULL,	'https://cn.bing.com/search?q=Open Assistant&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (409,	5,	'Whispr',	'945',	'AI对话工具',	'免费AI对话回应',	63,	1,	'创始人',	9,	'/webnav/ai-chatbots/show/409.html',	0,	0,	'127.0.0.1',	1702548678,	1702548678,	0,	'946',	NULL,	'https://cn.bing.com/search?q=Whispr&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (410,	5,	'Replika',	'947',	'AI对话工具',	'AI对话陪伴工具',	29,	1,	'创始人',	9,	'/webnav/ai-chatbots/show/410.html',	0,	0,	'127.0.0.1',	1702548636,	1702548636,	0,	'948',	NULL,	'https://cn.bing.com/search?q=Replika&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (411,	5,	'ChatSonic',	'949',	'AI对话工具',	'WriteSonic出品的ChatGPT竞品',	56,	1,	'创始人',	9,	'/webnav/ai-chatbots/show/411.html',	0,	0,	'127.0.0.1',	1702548611,	1702548611,	0,	'950',	NULL,	'https://cn.bing.com/search?q=ChatSonic&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (412,	5,	'YouChat AI',	'951',	'AI对话工具',	'AI搜索对话工具',	75,	1,	'创始人',	9,	'/webnav/ai-chatbots/show/412.html',	0,	0,	'127.0.0.1',	1702548654,	1702548654,	0,	'952',	NULL,	'https://cn.bing.com/search?q=YouChat AI&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (413,	5,	'Jasper Chat',	'953',	'AI对话工具',	'Jasper针对内容创作者出品的AI聊天工具',	24,	1,	'创始人',	9,	'/webnav/ai-chatbots/show/413.html',	0,	0,	'127.0.0.1',	1702548693,	1702548693,	0,	'261',	NULL,	'https://cn.bing.com/search?q=Jasper Chat&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (414,	5,	'Character.AI',	'955',	'AI对话工具',	'创建虚拟角色并与其对话',	11,	1,	'创始人',	9,	'/webnav/ai-chatbots/show/414.html',	0,	0,	'127.0.0.1',	1702548671,	1702548671,	0,	'956',	NULL,	'https://cn.bing.com/search?q=Character.AI&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (415,	5,	'ColossalChat',	'957',	'AI对话工具',	'Colossal-AI推出的免费开源版ChatGPT聊天机器人替代品',	65,	1,	'创始人',	9,	'/webnav/ai-chatbots/show/415.html',	0,	0,	'127.0.0.1',	1702548679,	1702548679,	0,	'958',	NULL,	'https://cn.bing.com/search?q=ColossalChat&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (416,	5,	'Stable Chat',	'959',	'AI对话工具',	'Stability AI 最新推出的免费聊天对话网站',	35,	1,	'创始人',	9,	'/webnav/ai-chatbots/show/416.html',	0,	0,	'127.0.0.1',	1702548669,	1702548669,	0,	'960',	NULL,	'https://research.stability.ai/chat',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (417,	5,	'TigerBot',	'961',	'AI对话工具',	'虎博科技推出的AI对话聊天机器人，基于TigerBot开源大模型',	73,	1,	'创始人',	9,	'/webnav/ai-chatbots/show/417.html',	0,	0,	'127.0.0.1',	1702548724,	1702548724,	0,	'962',	NULL,	'https://tigerbot.com/?utm_source=ai-bot.cn',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (418,	5,	'Poe',	'964',	'AI对话工具',	'问答社区Quora推出的问答机器人工具',	85,	1,	'创始人',	9,	'/webnav/ai-chatbots/show/418.html',	0,	0,	'127.0.0.1',	1702548674,	1702548674,	0,	'965',	NULL,	'https://cn.bing.com/search?q=Poe&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (419,	5,	'HuggingChat',	'966',	'AI对话工具',	'HuggingFace推出的在线聊天机器人，基于Open Assistant模型',	50,	1,	'创始人',	9,	'/webnav/ai-chatbots/show/419.html',	0,	0,	'127.0.0.1',	1702548682,	1702548682,	0,	'967',	NULL,	'https://cn.bing.com/search?q=HuggingChat&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (420,	5,	'Forefront',	'968',	'AI对话工具',	'提供GPT-3.5、GPT-4、Claude的AI聊天机器人',	14,	1,	'创始人',	9,	'/webnav/ai-chatbots/show/420.html',	0,	0,	'127.0.0.1',	1702548711,	1702548711,	0,	'969',	NULL,	'https://cn.bing.com/search?q=Forefront&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (421,	5,	'魔搭GPT（ModelScopeGPT）',	'970',	'AI对话工具',	'阿里达摩院推出的大小模型协同的智能助手，具备作诗、绘画、视频生成、语音播放等多模态能力',	72,	1,	'创始人',	9,	'/webnav/ai-chatbots/show/421.html',	0,	0,	'127.0.0.1',	1702548716,	1702548716,	0,	'383',	NULL,	'https://www.modelscope.cn/studios/damo/ModelScopeGPT',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (422,	5,	'DeepSeek',	'973',	'AI对话工具',	'幻方量化旗下深度求索推出的开源大模型和聊天助手',	21,	1,	'创始人',	9,	'/webnav/ai-chatbots/show/422.html',	0,	0,	'127.0.0.1',	1702548677,	1702548677,	0,	'974',	NULL,	'https://chat.deepseek.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (423,	5,	'ChitChop',	'976',	'AI对话工具',	'字节旗下面向海外用户推出的免费大模型产品和AI助手工具箱',	62,	1,	'创始人',	9,	'/webnav/ai-chatbots/show/423.html',	0,	0,	'127.0.0.1',	1702548763,	1702548763,	0,	'977',	NULL,	'https://www.chitchop.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (424,	5,	'元象XChat',	'980',	'AI对话工具',	'元象XVERSE大模型驱动的AI聊天助手',	78,	1,	'创始人',	9,	'/webnav/ai-chatbots/show/424.html',	0,	0,	'127.0.0.1',	1702548766,	1702548766,	0,	'981',	NULL,	'https://chat.xverse.cn/home/index.html',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (425,	5,	'Luca面壁露卡',	'983',	'AI对话工具',	'面壁智能推出的千亿多模态大模型免费智能对话助手',	68,	1,	'创始人',	9,	'/webnav/ai-chatbots/show/425.html',	0,	0,	'127.0.0.1',	1702548754,	1702548754,	0,	'984',	NULL,	'https://luca-beta.modelbest.cn/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (426,	5,	'MChat',	'986',	'AI对话工具',	'基于孟子GPT大模型的AI对话机器人',	71,	1,	'创始人',	9,	'/webnav/ai-chatbots/show/426.html',	0,	0,	'127.0.0.1',	1702548774,	1702548774,	0,	'987',	NULL,	'https://www.langboat.com/portal/mengzi-gpt?from=ai-bot.cn',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (427,	5,	'超级助理',	'989',	'AI对话工具',	'百度智能云发布的基于文心一言的AI原生应用和Copilot“超级助理”',	48,	1,	'创始人',	9,	'/webnav/ai-chatbots/show/427.html',	0,	0,	'127.0.0.1',	1702548716,	1702548716,	0,	'990',	NULL,	'https://cloud.baidu.com/product/infoflow.html',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (428,	5,	'百度AI伙伴',	'993',	'AI对话工具',	'百度最新上线的AI搜索对话工具',	60,	1,	'创始人',	9,	'/webnav/ai-chatbots/show/428.html',	0,	0,	'127.0.0.1',	1702548795,	1702548795,	0,	'994',	NULL,	'https://chat.baidu.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (429,	5,	'百川大模型',	'995',	'AI对话工具',	'百川智能推出的大模型助手，融合了意图理解、信息检索以及强化学习技术',	63,	1,	'创始人',	9,	'/webnav/ai-chatbots/show/429.html',	0,	0,	'127.0.0.1',	1702548786,	1702548786,	0,	'996',	NULL,	'https://chat.baichuan-ai.com/home?utm_source=ai-bot.cn',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (430,	5,	'应事AI',	'998',	'AI对话工具',	'MiniMax推出的AI对话助理，已免费开放',	29,	1,	'创始人',	9,	'/webnav/ai-chatbots/show/430.html',	0,	0,	'127.0.0.1',	1702548745,	1702548745,	0,	'999',	NULL,	'https://yingshi-ai.com/?utm_source=ai-bot.cn',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (431,	5,	'小悟空',	'1001',	'AI对话工具',	'字节跳动推出的免费AI对话助手和个人助理',	53,	1,	'创始人',	9,	'/webnav/ai-chatbots/show/431.html',	0,	0,	'127.0.0.1',	1702548801,	1702548801,	0,	'1002',	NULL,	'https://wukong.com/tool?utm_source=ai-bot.cn',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (432,	5,	'智谱清言',	'1004',	'AI对话工具',	'智谱AI推出的生成式AI助手，基于ChatGLM 2',	61,	1,	'创始人',	9,	'/webnav/ai-chatbots/show/432.html',	0,	0,	'127.0.0.1',	1702548838,	1702548838,	0,	'1005',	NULL,	'https://chatglm.cn/pureDisplay?fr=mkazb01',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (433,	5,	'豆包',	'1007',	'AI对话工具',	'字节跳动最新推出的免费AI对话助手',	26,	1,	'创始人',	9,	'/webnav/ai-chatbots/show/433.html',	0,	0,	'127.0.0.1',	1702548803,	1702548803,	0,	'1008',	NULL,	'https://www.doubao.com/?utm_source=ai-bot.cn',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (434,	5,	'通义千问',	'1010',	'AI对话工具',	'阿里巴巴推出的类ChatGPT响应人类指令的大模型，已免费开放',	81,	1,	'创始人',	9,	'/webnav/ai-chatbots/show/434.html',	0,	0,	'127.0.0.1',	1702548761,	1702548761,	0,	'872',	NULL,	'https://qianwen.aliyun.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (435,	5,	'Kimi Chat',	'1012',	'AI对话工具',	'月之暗面Moonshot AI推出的聊天机器人',	22,	1,	'创始人',	9,	'/webnav/ai-chatbots/show/435.html',	0,	0,	'127.0.0.1',	1702548772,	1702548772,	0,	'1013',	NULL,	'https://kimi.moonshot.cn/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (436,	5,	'Grok',	'1015',	'AI对话工具',	'马斯克旗下xAI推出的人工智能助手',	69,	1,	'创始人',	9,	'/webnav/ai-chatbots/show/436.html',	0,	0,	'127.0.0.1',	1702548799,	1702548799,	0,	'1016',	NULL,	'https://grok.x.ai/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (437,	5,	'紫东太初',	'1018',	'AI对话工具',	'中科院与武智院推出的千亿参数全模态大模型和助手',	82,	1,	'创始人',	9,	'/webnav/ai-chatbots/show/437.html',	0,	0,	'127.0.0.1',	1702548878,	1702548878,	0,	'1019',	NULL,	'https://taichu-web.ia.ac.cn/#/welcome',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (438,	5,	'Claude',	'1021',	'AI对话工具',	'ChatGPT的最为有力的竞争对手之一',	17,	1,	'创始人',	9,	'/webnav/ai-chatbots/show/438.html',	0,	0,	'127.0.0.1',	1702548823,	1702548823,	0,	'1022',	NULL,	'https://cn.bing.com/search?q=Claude&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (439,	5,	'Google Bard',	'1023',	'AI对话工具',	'Google推出的AI聊天对话机器人Bard',	96,	1,	'创始人',	9,	'/webnav/ai-chatbots/show/439.html',	0,	0,	'127.0.0.1',	1702548887,	1702548887,	0,	'1024',	NULL,	'https://cn.bing.com/search?q=Google Bard&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (440,	5,	'钉钉·个人版',	'1025',	'AI对话工具,热门AI办公工具',	'钉钉推出的个人版办公应用程序，内置AI智能助手，可进行AI创作、AI对话、AI绘画',	54,	1,	'创始人',	9,	'/webnav/ai-chatbots/show/440.html',	0,	0,	'127.0.0.1',	1702548857,	1702548857,	0,	'1026',	'',	'https://workspace.dingtalk.com/welcome?utm_source=ai-bot.cn',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (441,	5,	'Bing新必应',	'1028',	'AI对话工具',	'微软推出的新版结合了ChatGPT功能的必应',	23,	1,	'创始人',	9,	'/webnav/ai-chatbots/show/441.html',	0,	0,	'127.0.0.1',	1702548854,	1702548854,	0,	'884',	NULL,	'https://cn.bing.com/search?q=Bing新必应&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (442,	5,	'ChatGPT',	'1030',	'AI对话工具,常用AI工具',	'OpenAI旗下AI对话工具',	52,	1,	'创始人',	9,	'/webnav/ai-chatbots/show/442.html',	0,	0,	'127.0.0.1',	1702548898,	1702548898,	0,	'1031',	NULL,	'https://cn.bing.com/search?q=ChatGPT&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (443,	5,	'Copilot',	'1032',	'AI对话工具',	'微软推出的网页版Copilot助手',	85,	1,	'创始人',	9,	'/webnav/ai-chatbots/show/443.html',	0,	0,	'127.0.0.1',	1702548915,	1702548915,	0,	'1033',	NULL,	'https://copilot.microsoft.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (444,	3,	'Colourlab.ai',	'1608',	'AI视频工具',	'好莱坞也在用的AI视频颜色分级工具',	92,	1,	'创始人',	9,	'/webnav/ai-video-tools/show/444.html',	0,	0,	'127.0.0.1',	1702549412,	1702549412,	0,	'1035',	NULL,	'https://colourlab.ai/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (445,	3,	'BgRem',	'1036',	'AI视频工具',	'无水印AI视频背景移除',	89,	1,	'创始人',	9,	'/webnav/ai-video-tools/show/445.html',	0,	0,	'127.0.0.1',	1702549368,	1702549368,	0,	'1037',	NULL,	'https://bgrem.deelvin.com/zh/remove_video_bg/?params=start',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (446,	3,	'Hour One',	'1038',	'AI视频工具',	'人工智能文字到视频生成',	83,	1,	'创始人',	9,	'/webnav/ai-video-tools/show/446.html',	0,	0,	'127.0.0.1',	1702549373,	1702549373,	0,	'1039',	NULL,	'https://cn.bing.com/search?q=Hour One&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (447,	3,	'Veed Video Background Remover',	'1609',	'AI视频工具',	'Veed推出的AI视频背景移除工具',	32,	1,	'创始人',	9,	'/webnav/ai-video-tools/show/447.html',	0,	0,	'127.0.0.1',	1702549432,	1702549432,	0,	'463',	NULL,	'https://www.veed.io/zh-CN/tools/video-background-remover',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (485,	15,	'Canva AI图像生成',	'823',	'AI图片插画生成,常用AI图像工具',	'在线设计工具Canva推出的AI图像生成工具',	41,	1,	'创始人',	9,	'/webnav/ai-image-tools/show/485.html',	0,	0,	'127.0.0.1',	1702549754,	1702549754,	0,	'191',	'[\"16\"]',	'https://cn.bing.com/search?q=Canva AI图像生成&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (486,	15,	'Freepik AI Image Generator',	'825',	'AI图片插画生成,常用AI图像工具',	'Freepik最新推出的AI图片生成工具',	38,	1,	'创始人',	9,	'/webnav/ai-image-tools/show/486.html',	0,	0,	'127.0.0.1',	1702549810,	1702549810,	0,	'826',	'[\"16\"]',	'https://cn.bing.com/search?q=Freepik AI Image Generator&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (487,	15,	'Pic Copilot',	'830',	'AI图片插画生成,常用AI图像工具',	'阿里国际推出的AI商品营销图工具',	16,	1,	'创始人',	9,	'/webnav/ai-image-tools/show/487.html',	0,	0,	'127.0.0.1',	1702549854,	1702549854,	0,	'831',	'[\"16\"]',	'https://www.piccopilot.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (488,	15,	'画宇宙',	'833',	'AI图片插画生成,常用AI图像工具',	'人工智能AI作画网站',	82,	1,	'创始人',	9,	'/webnav/ai-image-tools/show/488.html',	0,	0,	'127.0.0.1',	1702549903,	1702549903,	0,	'834',	'[\"16\"]',	'https://creator.nolibox.com/?utm_source=ai-bot.cn',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (489,	15,	'Adobe Firefly',	'836',	'AI图片插画生成,常用AI图像工具',	'Adobe最新推出的AI图片生成工具',	86,	1,	'创始人',	9,	'/webnav/ai-image-tools/show/489.html',	0,	0,	'127.0.0.1',	1702549833,	1702549833,	0,	'837',	'[\"16\"]',	'https://cn.bing.com/search?q=Adobe Firefly&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (490,	15,	'6pen Art',	'839',	'AI图片插画生成,常用AI图像工具',	'面包多团队推出的从文本描述生成绘画艺术作品',	61,	1,	'创始人',	9,	'/webnav/ai-image-tools/show/490.html',	0,	0,	'127.0.0.1',	1702549891,	1702549891,	0,	'840',	'[\"16\"]',	'https://6pen.art/?utm_source=ai-bot.cn',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (491,	15,	'网易AI创意工坊',	'841',	'AI图片插画生成,常用AI图像工具',	'网易云课堂推出的AI作画平台，在线使用Stable Diffusion出图',	88,	1,	'创始人',	9,	'/webnav/ai-image-tools/show/491.html',	0,	0,	'127.0.0.1',	1702549849,	1702549849,	0,	'842',	'[\"16\"]',	'https://ke.study.163.com/artWorks/painting?utm_source=ai-bot.cn',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (492,	15,	'创客贴AI画匠',	'844',	'AI图片插画生成,常用AI图像工具',	'创客贴推出的AI艺术画生成工具',	41,	1,	'创始人',	9,	'/webnav/ai-image-tools/show/492.html',	0,	0,	'127.0.0.1',	1702549913,	1702549913,	0,	'845',	'[\"16\"]',	'https://aiart.chuangkit.com/landingpage',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (493,	15,	'LiblibAI·哩布哩布AI',	'846',	'AI图片插画生成,常用AI图像工具',	'国内领先的AI图像创作平台和模型分享社区',	87,	1,	'创始人',	9,	'/webnav/ai-image-tools/show/493.html',	0,	0,	'127.0.0.1',	1702549880,	1702549880,	0,	'847',	'[\"16\"]',	'https://cn.bing.com/search?q=LiblibAI·哩布哩布AI&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (494,	15,	'堆友AI反应堆',	'850',	'AI图片插画生成,常用AI图像工具',	'阿里旗下堆友推出的多风格AI绘画生成器',	25,	1,	'创始人',	9,	'/webnav/ai-image-tools/show/494.html',	0,	0,	'127.0.0.1',	1702549960,	1702549960,	0,	'851',	'[\"16\"]',	'https://d.design/?from=aibot',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (495,	15,	'WHEE',	'853',	'AI图片插画生成,常用AI图像工具',	'美图最新推出的AI图片和绘画创作生成平台',	19,	1,	'创始人',	9,	'/webnav/ai-image-tools/show/495.html',	0,	0,	'127.0.0.1',	1702549907,	1702549907,	0,	'854',	'[\"16\"]',	'https://www.whee.com/?utm_source=ai-bot.cn',	1,	0,	0),
                                                                                                                                                                                                                                                                                      (496,	15,	'简单AI',	'856',	'AI图片插画生成,常用AI图像工具',	'搜狐最新推出的AI图片生成平台',	48,	1,	'创始人',	9,	'/webnav/ai-image-tools/show/496.html',	0,	0,	'127.0.0.1',	1702549925,	1702549925,	0,	'857',	'[\"16\"]',	'https://ai.sohu.com/search?_trans_=000019_aidhlltj',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (497,	15,	'秒画',	'859',	'AI图片插画生成,常用AI图像工具',	'商汤科技推出的免费AI作画和图片生成平台',	23,	1,	'创始人',	9,	'/webnav/ai-image-tools/show/497.html',	0,	0,	'127.0.0.1',	1702549993,	1702549993,	0,	'860',	'[\"16\"]',	'https://miaohua.sensetime.com/zh-CN',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (498,	15,	'Dreamina',	'862',	'AI图片插画生成,常用AI图像工具',	'抖音旗下推出的AI图片创作工具',	91,	1,	'创始人',	9,	'/webnav/ai-image-tools/show/498.html',	0,	0,	'127.0.0.1',	1702549995,	1702549995,	0,	'863',	'[\"16\"]',	'https://www.capcut.cn/ai-tool/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (499,	15,	'美图AI文生图',	'865',	'AI图片插画生成,常用AI图像工具',	'美图推出的AI文本生成图片的工具',	77,	1,	'创始人',	9,	'/webnav/ai-image-tools/show/499.html',	0,	0,	'127.0.0.1',	1702550000,	1702550000,	0,	'866',	'[\"16\"]',	'https://design.meitu.com/aigc/text-to-image?from=ai-bot.cn',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (500,	15,	'造梦日记',	'868',	'AI图片插画生成,常用AI图像工具',	'AI一下，妙笔生画',	33,	1,	'创始人',	9,	'/webnav/ai-image-tools/show/500.html',	0,	0,	'127.0.0.1',	1702550034,	1702550034,	0,	'869',	'[\"16\"]',	'https://zmrj.art/?utm_source=ai-bot.cn',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (501,	15,	'通义万相',	'871',	'AI图片插画生成,常用AI图像工具',	'阿里最新推出的AI绘画创作模型',	44,	1,	'创始人',	9,	'/webnav/ai-image-tools/show/501.html',	0,	0,	'127.0.0.1',	1702549989,	1702549989,	0,	'872',	'[\"16\"]',	'https://wanxiang.aliyun.com/?utm_source=ai-bot.cn',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (502,	15,	'remove.bg',	'877',	'AI图片背景移除,常用AI图像工具',	'强大的AI图片背景移除工具',	43,	1,	'创始人',	9,	'/webnav/ai-image-tools/show/502.html',	0,	0,	'127.0.0.1',	1702550084,	1702550084,	0,	'878',	'[\"17\"]',	'https://www.remove.bg/zh?aid=kkgjrdhppgtrhbyn&amp;utm_campaign=affiliate+marketing&amp;utm_medium=referral&amp;utm_source=affiliate',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (503,	15,	'Upscayl',	'881',	'AI图片无损放大,常用AI图像工具',	'免费开源的AI图片无损放大工具',	21,	1,	'创始人',	9,	'/webnav/ai-image-tools/show/503.html',	0,	0,	'127.0.0.1',	1702550047,	1702550047,	0,	'882',	'[\"18\"]',	'https://www.upscayl.org/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (504,	15,	'Bing Image Creator',	'883',	'AI图片插画生成,常用AI图像工具',	'微软必应推出的基于DALL·E的AI图像生成工具',	92,	1,	'创始人',	9,	'/webnav/ai-image-tools/show/504.html',	0,	0,	'127.0.0.1',	1702550099,	1702550099,	0,	'884',	'[\"16\"]',	'https://cn.bing.com/create',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (505,	15,	'Visual Electric',	'888',	'AI图片插画生成,常用AI图像工具',	'专业的高质量AI图像创作工具',	59,	1,	'创始人',	9,	'/webnav/ai-image-tools/show/505.html',	0,	0,	'127.0.0.1',	1702549840,	1702549840,	0,	'889',	'[\"16\"]',	'https://cn.bing.com/search?q=Visual Electric&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (506,	15,	'Imagine with Meta',	'896',	'AI图片插画生成,常用AI图像工具',	'Meta最新推出的在线AI图像生成器',	53,	1,	'创始人',	9,	'/webnav/ai-image-tools/show/506.html',	0,	0,	'127.0.0.1',	1702549852,	1702549852,	0,	'897',	'[\"16\"]',	'https://cn.bing.com/search?q=Imagine with Meta&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (507,	15,	'触手AI绘画',	'911',	'AI图片插画生成,常用AI图像工具',	'免费专业的AI绘画/模型/分享平台',	52,	1,	'创始人',	9,	'/webnav/ai-image-tools/show/507.html',	0,	0,	'127.0.0.1',	1702550121,	1702550121,	0,	'912',	'[\"16\"]',	'http://douchu.ai/warehouse/styleStore?inviteCode=677102&amp;channel=channel_invite',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (508,	15,	'文心一格',	'925',	'AI图片插画生成,常用AI图像工具,常用AI工具',	'AI艺术和创意辅助平台',	41,	1,	'创始人',	9,	'/webnav/ai-image-tools/show/508.html',	0,	0,	'127.0.0.1',	1702550166,	1702550166,	0,	'293',	'[\"16\"]',	'https://yige.baidu.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (510,	15,	'Midjourney',	'932',	'AI图片插画生成,常用AI图像工具,常用AI工具',	'AI图像和插画生成工具',	77,	1,	'创始人',	9,	'/webnav/ai-image-tools/show/510.html',	0,	0,	'127.0.0.1',	1702550218,	1702550218,	0,	'933',	'[\"16\"]',	'https://cn.bing.com/search?q=Midjourney&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (511,	15,	'美图抠图',	'808',	'AI图片背景移除,常用AI图像工具',	'美图秀秀推出的AI智能抠图工具，一键移除背景',	69,	1,	'创始人',	9,	'/webnav/ai-image-tools/show/511.html',	0,	0,	'127.0.0.1',	1702549749,	1702549749,	0,	'809',	'[\"17\"]',	'https://cutout.meitu.com/?utm_source=ai-bot.cn',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (512,	15,	'PhotoRoom',	'810',	'AI图片背景移除,常用AI图像工具',	'免费的AI图片背景移除和添加',	56,	1,	'创始人',	9,	'/webnav/ai-image-tools/show/512.html',	0,	0,	'127.0.0.1',	1702549698,	1702549698,	0,	'811',	'[\"17\"]',	'https://www.photoroom.com/background-remover',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (513,	15,	'稿定抠图',	'812',	'AI图片背景移除,常用AI图像工具',	'稿定设计推出的AI自动消除背景工具',	60,	1,	'创始人',	9,	'/webnav/ai-image-tools/show/513.html',	0,	0,	'127.0.0.1',	1702549776,	1702549776,	0,	'813',	'[\"17\"]',	'https://koutu.gaoding.com/utms/e3717a090a6a42c180e2c273dcf8eed8',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (514,	15,	'Stable Doodle',	'818',	'AI图片插画生成,常用AI图像工具',	'StabilityAI最新推出的将手绘草图转换成精美图像的工具',	52,	1,	'创始人',	9,	'/webnav/ai-image-tools/show/514.html',	0,	0,	'127.0.0.1',	1702549740,	1702549740,	0,	'819',	'[\"16\"]',	'https://clipdrop.co/stable-doodle',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (515,	15,	'Stockimg AI',	'821',	'AI图片插画生成,常用AI图像工具',	'AI生成各种类型的图像和插画',	101,	1,	'创始人',	9,	'/webnav/ai-image-tools/show/515.html',	0,	0,	'127.0.0.1',	1702549769,	1702549769,	0,	'822',	'[\"16\"]',	'https://cn.bing.com/search?q=Stockimg AI&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (519,	13,	'Stable Diffusion',	'928',	'AI图片插画生成,AI训练模型,常用AI图像工具,常用AI工具',	'StabilityAI推出的文本到图像生成AI',	58,	1,	'创始人',	9,	'/webnav/ai-models/show/519.html',	0,	0,	'127.0.0.1',	1702550184,	1702550184,	0,	'929',	'[\"15\",\"16\"]',	'https://cn.bing.com/search?q=Stable Diffusion&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (520,	20,	'WatermarkRemover',	'1329',	'AI图片物体抹除',	'AI智能删除照片中的水印',	17,	1,	'创始人',	9,	'/webnav/ai-object-removal/show/520.html',	0,	0,	'127.0.0.1',	1702561335,	1702561335,	0,	'1330',	NULL,	'https://www.watermarkremover.io/zh',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (521,	20,	'Magic Eraser',	'1610',	'AI图片物体抹除',	'AI移除图片中不想要的物体',	55,	1,	'创始人',	9,	'/webnav/ai-object-removal/show/521.html',	0,	0,	'127.0.0.1',	1702561405,	1702561405,	0,	'1331',	NULL,	'https://magicstudio.com/zh/magiceraser',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (522,	20,	'Cutout.Pro Retouch',	'1611',	'AI图片物体抹除',	'Cutout.Pro推出的AI图片物体涂抹去除工具',	11,	1,	'创始人',	9,	'/webnav/ai-object-removal/show/522.html',	0,	0,	'127.0.0.1',	1702561324,	1702561324,	0,	'803',	NULL,	'https://www.cutout.pro/zh-CN/image-retouch-remove-unwanted-objects',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (523,	20,	'Cleanup.pictures',	'1612',	'AI图片物体抹除',	'智能移除图片中的物体、文本、污迹、人物或任何不想要的东西',	41,	1,	'创始人',	9,	'/webnav/ai-object-removal/show/523.html',	0,	0,	'127.0.0.1',	1702561419,	1702561419,	0,	'1333',	NULL,	'https://cleanup.pictures/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (524,	20,	'SnapEdit',	'1613',	'AI图片物体抹除',	'AI移除图片中的任何物体',	25,	1,	'创始人',	9,	'/webnav/ai-object-removal/show/524.html',	0,	0,	'127.0.0.1',	1702561418,	1702561418,	0,	'1334',	NULL,	'https://snapedit.app/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (525,	20,	'Bg Eraser',	'1614',	'AI图片物体抹除',	'图片物体抹除和清理',	94,	1,	'创始人',	9,	'/webnav/ai-object-removal/show/525.html',	0,	0,	'127.0.0.1',	1702561385,	1702561385,	0,	'1335',	NULL,	'https://bgeraser.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (526,	19,	'Playground AI',	'1615',	'AI图片优化修复',	'AI图片生成和修图',	67,	1,	'创始人',	9,	'/webnav/ai-image-enhancement-restoration/show/526.html',	0,	0,	'127.0.0.1',	1702561709,	1702561709,	0,	'1336',	NULL,	'https://playgroundai.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (527,	15,	'Facet',	'1337',	'AI图片优化修复,常用AI图像工具',	'AI图片修图和优化工具',	77,	1,	'创始人',	9,	'/webnav/ai-image-tools/show/527.html',	0,	0,	'127.0.0.1',	1702561674,	1702561674,	0,	'1338',	'[\"19\"]',	'https://facet.ai/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (528,	15,	'Relight',	'1339',	'AI图片优化修复,常用AI图像工具',	'ClipDrop推出的AI图像打光工具',	85,	1,	'创始人',	9,	'/webnav/ai-image-tools/show/528.html',	0,	0,	'127.0.0.1',	1702561753,	1702561753,	0,	'1340',	'[\"19\"]',	'https://clipdrop.co/relight',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (529,	19,	'Palette',	'1616',	'AI图片优化修复',	'AI图片调色上色',	39,	1,	'创始人',	9,	'/webnav/ai-image-enhancement-restoration/show/529.html',	0,	0,	'127.0.0.1',	1702561732,	1702561732,	0,	'1341',	NULL,	'https://palette.fm/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (530,	19,	'restorePhotos.io',	'1617',	'AI图片优化修复',	'AI老照片修复',	82,	1,	'创始人',	9,	'/webnav/ai-image-enhancement-restoration/show/530.html',	0,	0,	'127.0.0.1',	1702561766,	1702561766,	0,	'1342',	NULL,	'https://www.restorephotos.io/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (531,	19,	'Cutout.Pro老照片上色',	'1618',	'AI图片优化修复',	'Cutout.Pro推出的黑白图片上色',	45,	1,	'创始人',	9,	'/webnav/ai-image-enhancement-restoration/show/531.html',	0,	0,	'127.0.0.1',	1702561683,	1702561683,	0,	'803',	NULL,	'https://www.cutout.pro/zh-CN/photo-colorizer-black-and-white',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (532,	19,	'jpgHD',	'1344',	'AI图片优化修复',	'人工智能老照片上色和修复',	28,	1,	'创始人',	9,	'/webnav/ai-image-enhancement-restoration/show/532.html',	0,	0,	'127.0.0.1',	1702561770,	1702561770,	0,	'1345',	NULL,	'https://jpghd.com/zh',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (533,	19,	'美图云修',	'1346',	'AI图片优化修复',	'美图秀秀推出的一站式AI智能修图软件',	39,	1,	'创始人',	9,	'/webnav/ai-image-enhancement-restoration/show/533.html',	0,	0,	'127.0.0.1',	1702561722,	1702561722,	0,	'1347',	NULL,	'https://yunxiu.meitu.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (534,	19,	'transpic',	'1348',	'AI图片优化修复',	'AI图像转绘插画创作平台',	40,	1,	'创始人',	9,	'/webnav/ai-image-enhancement-restoration/show/534.html',	0,	0,	'127.0.0.1',	1702561696,	1702561696,	0,	'1349',	NULL,	'https://transpic.cn/?utm_source=ai-bot.cn',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (535,	19,	'像素蛋糕PixCake',	'1351',	'AI图片优化修复',	'简单易用的AI图像精修工具',	47,	1,	'创始人',	9,	'/webnav/ai-image-enhancement-restoration/show/535.html',	0,	0,	'127.0.0.1',	1702561683,	1702561683,	0,	'1352',	NULL,	'https://www.pixcakeai.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (536,	19,	'咻图AI',	'1354',	'AI图片优化修复',	'面向影楼的摄影后期AI修图软件',	29,	1,	'创始人',	9,	'/webnav/ai-image-enhancement-restoration/show/536.html',	0,	0,	'127.0.0.1',	1702550062,	1702550062,	0,	'1355',	NULL,	'https://www.aixtsy.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (537,	17,	'PicWish',	'1357',	'AI图片背景移除',	'AI图片编辑和背景移除',	92,	1,	'创始人',	9,	'/webnav/ai-background-removal/show/537.html',	0,	0,	'127.0.0.1',	1702561863,	1702561863,	0,	'1358',	NULL,	'https://picwish.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (538,	17,	'Pixelcut.ai',	'1619',	'AI图片背景移除',	'AI产品背景移除和替换',	28,	1,	'创始人',	9,	'/webnav/ai-background-removal/show/538.html',	0,	0,	'127.0.0.1',	1702561828,	1702561828,	0,	'1359',	NULL,	'https://www.pixelcut.ai/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (539,	17,	'Booth.ai',	'1620',	'AI图片背景移除',	'高质量AI产品展示效果图生成',	90,	1,	'创始人',	9,	'/webnav/ai-background-removal/show/539.html',	0,	0,	'127.0.0.1',	1702561840,	1702561840,	0,	'1360',	NULL,	'https://www.booth.ai/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (540,	17,	'Mokker AI',	'1621',	'AI图片背景移除',	'AI产品图添加背景',	90,	1,	'创始人',	9,	'/webnav/ai-background-removal/show/540.html',	0,	0,	'127.0.0.1',	1702561869,	1702561869,	0,	'1361',	NULL,	'https://mokker.ai/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (541,	17,	'Pebblely',	'1622',	'AI图片背景移除',	'AI产品图精美背景添加',	64,	1,	'创始人',	9,	'/webnav/ai-background-removal/show/541.html',	0,	0,	'127.0.0.1',	1702561842,	1702561842,	0,	'1362',	NULL,	'https://pebblely.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (542,	17,	'Stylized',	'1623',	'AI图片背景移除',	'AI产品图背景替换',	10,	1,	'创始人',	9,	'/webnav/ai-background-removal/show/542.html',	0,	0,	'127.0.0.1',	1702561907,	1702561907,	0,	'1363',	NULL,	'https://www.stylized.ai/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (543,	17,	'Hotpot AI Background Remover',	'1624',	'AI图片背景移除',	'Hotpot.ai推出的图片背景移除工具',	40,	1,	'创始人',	9,	'/webnav/ai-background-removal/show/543.html',	0,	0,	'127.0.0.1',	1702561932,	1702561932,	0,	'1364',	NULL,	'https://hotpot.ai/remove-background',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (544,	17,	'图可丽',	'1365',	'AI图片背景移除',	'AI图片和视频抠图，一键抠图神器',	12,	1,	'创始人',	9,	'/webnav/ai-background-removal/show/544.html',	0,	0,	'127.0.0.1',	1702561906,	1702561906,	0,	'1366',	NULL,	'https://www.tukeli.net/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (545,	17,	'ClippingMagic',	'1625',	'AI图片背景移除',	'魔术般地去除图片背景',	57,	1,	'创始人',	9,	'/webnav/ai-background-removal/show/545.html',	0,	0,	'127.0.0.1',	1702561853,	1702561853,	0,	'1367',	NULL,	'https://clippingmagic.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (546,	17,	'一键抠图',	'1626',	'AI图片背景移除',	'在线一键抠图换背景',	51,	1,	'创始人',	9,	'/webnav/ai-background-removal/show/546.html',	0,	0,	'127.0.0.1',	1702561869,	1702561869,	0,	'1368',	NULL,	'https://www.yijiankoutu.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (547,	17,	'PhotoScissors',	'1627',	'AI图片背景移除',	'免费自动图片背景去除',	43,	1,	'创始人',	9,	'/webnav/ai-background-removal/show/547.html',	0,	0,	'127.0.0.1',	1702561925,	1702561925,	0,	'1369',	NULL,	'https://photoscissors.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (548,	17,	'Zyro AI Background Remover',	'1628',	'AI图片背景移除',	'Zyro推出的AI图片背景移除工具',	91,	1,	'创始人',	9,	'/webnav/ai-background-removal/show/548.html',	0,	0,	'127.0.0.1',	1702561858,	1702561858,	0,	'1370',	NULL,	'https://zyro.com/tools/image-background-remover',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (549,	17,	'Quicktools Background Remover',	'1629',	'AI图片背景移除',	'Picsart旗下的Quicktools推出的图片背景移除工具',	20,	1,	'创始人',	9,	'/webnav/ai-background-removal/show/549.html',	0,	0,	'127.0.0.1',	1702561873,	1702561873,	0,	'1371',	NULL,	'https://tools.picsart.com/image/background-remover/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (550,	17,	'BGremover',	'1630',	'AI图片背景移除',	'Vance AI推出的图片背景移除工具',	23,	1,	'创始人',	9,	'/webnav/ai-background-removal/show/550.html',	0,	0,	'127.0.0.1',	1702561920,	1702561920,	0,	'1372',	NULL,	'https://bgremover.vanceai.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (551,	17,	'Cutout.Pro抠图',	'1631',	'AI图片背景移除',	'AI批量抠图去背景',	24,	1,	'创始人',	9,	'/webnav/ai-background-removal/show/551.html',	0,	0,	'127.0.0.1',	1702561912,	1702561912,	0,	'803',	NULL,	'https://www.cutout.pro/zh-cn/remove-background',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (552,	17,	'Slazzer',	'1632',	'AI图片背景移除',	'免费在线抠除图片背景',	34,	1,	'创始人',	9,	'/webnav/ai-background-removal/show/552.html',	0,	0,	'127.0.0.1',	1702561903,	1702561903,	0,	'1374',	NULL,	'https://www.slazzer.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (553,	17,	'Background Eraser',	'1633',	'AI图片背景移除',	'AI自动删除图片背景',	22,	1,	'创始人',	9,	'/webnav/ai-background-removal/show/553.html',	0,	0,	'127.0.0.1',	1702561913,	1702561913,	0,	'1375',	NULL,	'https://magicstudio.com/zh/backgrounderaser',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (554,	17,	'Removal.AI',	'1376',	'AI图片背景移除',	'AI图片背景移除工具',	38,	1,	'创始人',	9,	'/webnav/ai-background-removal/show/554.html',	0,	0,	'127.0.0.1',	1702561913,	1702561913,	0,	'1377',	NULL,	'https://removal.ai/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (555,	17,	'Adobe Image Background Remover',	'1634',	'AI图片背景移除',	'Adobe Express的图片背景移除工具',	77,	1,	'创始人',	9,	'/webnav/ai-background-removal/show/555.html',	0,	0,	'127.0.0.1',	1702561925,	1702561925,	0,	'1378',	NULL,	'https://www.adobe.com/express/feature/image/remove-background',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (556,	17,	'GoProd',	'1379',	'AI图片无损放大,AI图片背景移除',	'Icons8推出的智能图片背景移除和无损放大二合一Mac应用',	25,	1,	'创始人',	9,	'/webnav/ai-background-removal/show/556.html',	0,	0,	'127.0.0.1',	1702561890,	1702561890,	0,	'1380',	'[\"18\"]',	'https://icons8.com/goprod?utm_source=ai-bot.cn',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (557,	17,	'BgSub',	'1635',	'AI图片背景移除',	'免费的保护隐私的AI图片背景去除工具',	100,	1,	'创始人',	9,	'/webnav/ai-background-removal/show/557.html',	0,	0,	'127.0.0.1',	1702561945,	1702561945,	0,	'1381',	NULL,	'https://bgsub.cn/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (558,	17,	'Erase.bg',	'1636',	'AI图片背景移除',	'在线抠图和去除图片背景',	20,	1,	'创始人',	9,	'/webnav/ai-background-removal/show/558.html',	0,	0,	'127.0.0.1',	1702561869,	1702561869,	0,	'1382',	NULL,	'https://www.erase.bg/zh',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (559,	17,	'ClipDrop Remove Background',	'1637',	'AI图片背景移除',	'ClipDrop出品的AI图片背景移除工具',	42,	1,	'创始人',	9,	'/webnav/ai-background-removal/show/559.html',	0,	0,	'127.0.0.1',	1702561935,	1702561935,	0,	'817',	NULL,	'https://clipdrop.co/remove-background',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (560,	17,	'Icons8 Background Remover',	'1384',	'AI图片背景移除',	'Icons8出品的免费图片背景移除工具',	45,	1,	'创始人',	9,	'/webnav/ai-background-removal/show/560.html',	0,	0,	'127.0.0.1',	1702561936,	1702561936,	0,	'1385',	NULL,	'https://icons8.com/bgremover',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (561,	18,	'Pixelhunter',	'1638',	'AI图片无损放大',	'AI智能调整图片尺寸用于社交媒体平台发帖',	56,	1,	'创始人',	9,	'/webnav/ai-image-upscaling/show/561.html',	0,	0,	'127.0.0.1',	1702562055,	1702562055,	0,	'1386',	NULL,	'https://pixelhunter.io/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (562,	18,	'Image Enlarger',	'1639',	'AI图片无损放大',	'AI无损放大图片',	49,	1,	'创始人',	9,	'/webnav/ai-image-upscaling/show/562.html',	0,	0,	'127.0.0.1',	1702562026,	1702562026,	0,	'1387',	NULL,	'https://magicstudio.com/zh/enlarger',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (563,	18,	'Upscalepics',	'1640',	'AI图片无损放大',	'在线图片放大工具',	65,	1,	'创始人',	9,	'/webnav/ai-image-upscaling/show/563.html',	0,	0,	'127.0.0.1',	1702561986,	1702561986,	0,	'1388',	NULL,	'https://upscalepics.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (564,	18,	'PhotoAid Image Upscaler',	'1641',	'AI图片无损放大',	'PhotoAid出品的免费在线人工智能图片放大工具',	56,	1,	'创始人',	9,	'/webnav/ai-image-upscaling/show/564.html',	0,	0,	'127.0.0.1',	1702562065,	1702562065,	0,	'1389',	NULL,	'https://photoaid.com/en/tools/ai-image-enlarger',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (565,	18,	'VanceAI Image Resizer',	'1642',	'AI图片无损放大',	'VanceAI推出的在线图片尺寸调整工具',	30,	1,	'创始人',	9,	'/webnav/ai-image-upscaling/show/565.html',	0,	0,	'127.0.0.1',	1702562053,	1702562053,	0,	'1372',	NULL,	'https://vanceai.com/image-resizer/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (566,	18,	'Nero Image Upscaler',	'1643',	'AI图片无损放大',	'AI免费图片无损放大',	83,	1,	'创始人',	9,	'/webnav/ai-image-upscaling/show/566.html',	0,	0,	'127.0.0.1',	1702562046,	1702562046,	0,	'1391',	NULL,	'https://ai.nero.com/image-upscaler',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (567,	18,	'Upscale.media',	'1644',	'AI图片无损放大',	'AI图片放大和分辨率修改',	75,	1,	'创始人',	9,	'/webnav/ai-image-upscaling/show/567.html',	0,	0,	'127.0.0.1',	1702562028,	1702562028,	0,	'1392',	NULL,	'https://www.upscale.media/zh',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (568,	18,	'Media.io AI Image Upscaler',	'1645',	'AI图片无损放大',	'Media.io推出的AI图片放大工具',	84,	1,	'创始人',	9,	'/webnav/ai-image-upscaling/show/568.html',	0,	0,	'127.0.0.1',	1702562005,	1702562005,	0,	'1393',	NULL,	'https://www.media.io/image-upscaler.html',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (569,	18,	'Zyro AI Image Upscaler',	'1646',	'AI图片无损放大',	'Zyro出品的人工智能图片放大工具',	99,	1,	'创始人',	9,	'/webnav/ai-image-upscaling/show/569.html',	0,	0,	'127.0.0.1',	1702561998,	1702561998,	0,	'1370',	NULL,	'https://zyro.com/tools/image-upscaler',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (570,	18,	'Fotor AI Image Upscaler',	'1647',	'AI图片无损放大',	'Fotor推出的AI图片放大工具',	24,	1,	'创始人',	9,	'/webnav/ai-image-upscaling/show/570.html',	0,	0,	'127.0.0.1',	1702562038,	1702562038,	0,	'1395',	NULL,	'https://www.fotor.com/image-upscaler/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (571,	18,	'Img.Upscaler',	'1648',	'AI图片无损放大',	'免费的AI图片放大工具',	20,	1,	'创始人',	9,	'/webnav/ai-image-upscaling/show/571.html',	0,	0,	'127.0.0.1',	1702562018,	1702562018,	0,	'1396',	NULL,	'https://imgupscaler.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (572,	18,	'ClipDrop Image Upscaler',	'1649',	'AI图片无损放大',	'ClipDrop出品的AI图片放大工具',	85,	1,	'创始人',	9,	'/webnav/ai-image-upscaling/show/572.html',	0,	0,	'127.0.0.1',	1702562052,	1702562052,	0,	'1397',	NULL,	'https://clipdrop.co/image-upscaler',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (573,	18,	'Icons8 Smart Upscaler',	'1650',	'AI图片无损放大',	'Icons8出品的AI图片无损放大工具',	18,	1,	'创始人',	9,	'/webnav/ai-image-upscaling/show/573.html',	0,	0,	'127.0.0.1',	1702562089,	1702562089,	0,	'1398',	NULL,	'https://icons8.com/upscaler',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (574,	18,	'Let\'s Enhance',	'1399',	'AI图片无损放大',	'AI在线免费放大图片并保持图像质量',	51,	1,	'创始人',	9,	'/webnav/ai-image-upscaling/show/574.html',	0,	0,	'127.0.0.1',	1702561998,	1702561998,	0,	'1400',	NULL,	'https://letsenhance.io/?utm_source=ai-bot.cn',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (575,	15,	'BigJPG',	'1651',	'AI图片无损放大,常用AI图像工具',	'免费的在线图片无损放大工具',	37,	1,	'创始人',	9,	'/webnav/ai-image-tools/show/575.html',	0,	0,	'127.0.0.1',	1702562028,	1702562028,	0,	'1401',	'[\"18\"]',	'https://bigjpg.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (576,	23,	'Super AI',	'1402',	'AI文档工具',	'AI复杂文档自动识别处理转换',	96,	1,	'创始人',	9,	'/webnav/ai-document-tools/show/576.html',	0,	0,	'127.0.0.1',	1702562167,	1702562167,	0,	'1403',	NULL,	'https://super.ai/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (577,	23,	'Rossum.ai',	'1652',	'AI文档工具',	'现代化的AI文档处理工具',	12,	1,	'创始人',	9,	'/webnav/ai-document-tools/show/577.html',	0,	0,	'127.0.0.1',	1702562186,	1702562186,	0,	'1404',	NULL,	'https://rossum.ai/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (578,	23,	'PandaGPT',	'1653',	'AI文档工具',	'AI文档要点总结工具',	95,	1,	'创始人',	9,	'/webnav/ai-document-tools/show/578.html',	0,	0,	'127.0.0.1',	1702562183,	1702562183,	0,	'1405',	NULL,	'https://www.pandagpt.io/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (579,	23,	'ChatDOC',	'1654',	'AI文档工具',	'基于ChatGPT的文档阅读、提取、总结、摘要的工具',	85,	1,	'创始人',	9,	'/webnav/ai-document-tools/show/579.html',	0,	0,	'127.0.0.1',	1702562182,	1702562182,	0,	'1406',	NULL,	'http://chatdoc.com',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (580,	23,	'印象AI',	'1407',	'AI文档工具',	'印象笔记推出的AI知识和信息管理功能',	16,	1,	'创始人',	9,	'/webnav/ai-document-tools/show/580.html',	0,	0,	'127.0.0.1',	1702562153,	1702562153,	0,	'1408',	NULL,	'https://www.yinxiang.com/about/yxai-yxbj/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (581,	23,	'WPS AI',	'1409',	'AI文档工具,热门AI办公工具',	'WPS推出的AI办公助手，已免费开放',	36,	1,	'创始人',	9,	'/webnav/ai-document-tools/show/581.html',	0,	0,	'127.0.0.1',	1702562151,	1702562151,	0,	'1410',	NULL,	'https://ai.wps.cn/?utm_source=ai-bot.cn',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (582,	23,	'Humata',	'1412',	'AI文档工具',	'基于GPT的AI文档分析、阅读和问答工具',	68,	1,	'创始人',	9,	'/webnav/ai-document-tools/show/582.html',	0,	0,	'127.0.0.1',	1702562127,	1702562127,	0,	'1413',	NULL,	'https://www.humata.ai/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (583,	23,	'字语智能',	'1414',	'AI文档工具',	'一站式智能Office内容创作平台',	99,	1,	'创始人',	9,	'/webnav/ai-document-tools/show/583.html',	0,	0,	'127.0.0.1',	1702562184,	1702562184,	0,	'1415',	NULL,	'https://getgetai.com/?from=AIGJDH',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (584,	23,	'Craft AI Assistant',	'1416',	'AI文档工具',	'在线文档工具Craft推出的AI文档和创作助手',	77,	1,	'创始人',	9,	'/webnav/ai-document-tools/show/584.html',	0,	0,	'127.0.0.1',	1702562164,	1702562164,	0,	'1417',	NULL,	'https://www.craft.do/?utm_source=ai-bot.cn',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (585,	23,	'司马阅AI文档',	'1419',	'AI文档工具',	'AI文档阅读分析工具',	66,	1,	'创始人',	9,	'/webnav/ai-document-tools/show/585.html',	0,	0,	'127.0.0.1',	1702562129,	1702562129,	0,	'1420',	NULL,	'https://smartread.cc?utm_source=ai-bot.cn',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (586,	23,	'云一朵',	'1421',	'AI效率提升,AI文档工具',	'百度网盘最新推出的智能助理',	26,	1,	'创始人',	9,	'/webnav/ai-document-tools/show/586.html',	0,	0,	'127.0.0.1',	1702562161,	1702562161,	0,	'1422',	'[\"26\"]',	'https://pan.baidu.com/aipan/welcome',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (587,	23,	'百度文库AI助手',	'1423',	'AI文档工具',	'基于文心一言的一站式智能文档助手',	10,	1,	'创始人',	9,	'/webnav/ai-document-tools/show/587.html',	0,	0,	'127.0.0.1',	1702562124,	1702562124,	0,	'1424',	NULL,	'https://wenku.baidu.com/ndlaunch/browse/chat?utm_source=ai-bot.cn',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (588,	23,	'通义智文',	'1426',	'AI文档工具',	'基于通义大模型的AI阅读助手，可智能阅读网页、论文、图书和文档',	69,	1,	'创始人',	9,	'/webnav/ai-document-tools/show/588.html',	0,	0,	'127.0.0.1',	1702562118,	1702562118,	0,	'872',	NULL,	'https://tongyi.aliyun.com/zhiwen#/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (589,	23,	'星火文档问答',	'1429',	'AI文档工具',	'基于讯飞星火大模型的AI文档和知识库问答助手',	69,	1,	'创始人',	9,	'/webnav/ai-document-tools/show/589.html',	0,	0,	'127.0.0.1',	1702562141,	1702562141,	0,	'1430',	NULL,	'https://chatdoc.xfyun.cn/?from=ai-bot.cn',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (590,	23,	'PDF.ai',	'1432',	'AI文档工具',	'AI PDF文档阅读工具，智能文档总结摘要',	86,	1,	'创始人',	9,	'/webnav/ai-document-tools/show/590.html',	0,	0,	'127.0.0.1',	1702562134,	1702562134,	0,	'1433',	NULL,	'https://pdf.ai/?via=ai-bot',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (591,	25,	'Airgram',	'1435',	'AI会议工具',	'自动会议笔记和总结的AI助手',	65,	1,	'创始人',	9,	'/webnav/ai-meeting-tools/show/591.html',	0,	0,	'127.0.0.1',	1702562231,	1702562231,	0,	'1436',	NULL,	'https://www.airgram.io',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (592,	25,	'Noty.ai',	'1655',	'AI会议工具',	'ChatGPT驱动的AI会议转录工具',	64,	1,	'创始人',	9,	'/webnav/ai-meeting-tools/show/592.html',	0,	0,	'127.0.0.1',	1702562277,	1702562277,	0,	'1437',	NULL,	'https://noty.ai/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (593,	25,	'Otter.ai',	'1656',	'AI会议工具',	'AI会议内容生成和实时转录',	81,	1,	'创始人',	9,	'/webnav/ai-meeting-tools/show/593.html',	0,	0,	'127.0.0.1',	1702562277,	1702562277,	0,	'1438',	NULL,	'https://otter.ai/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (594,	25,	'Fireflies.ai',	'1657',	'AI会议工具',	'AI会议转录和会议纪要生成工具',	41,	1,	'创始人',	9,	'/webnav/ai-meeting-tools/show/594.html',	0,	0,	'127.0.0.1',	1702562263,	1702562263,	0,	'1439',	NULL,	'https://fireflies.ai/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (595,	25,	'麦耳会记',	'1440',	'AI会议工具',	'思必驰推出的AI会议助手，语音转文字、字幕同传、AI摘要',	87,	1,	'创始人',	9,	'/webnav/ai-meeting-tools/show/595.html',	0,	0,	'127.0.0.1',	1702562249,	1702562249,	0,	'1441',	NULL,	'https://work.duiopen.com',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (596,	25,	'讯飞听见',	'1658',	'AI会议工具',	'科大讯飞推出的AI智能会议系统，实时字幕、实时翻译、自动生成会议记录',	95,	1,	'创始人',	9,	'/webnav/ai-meeting-tools/show/596.html',	0,	0,	'127.0.0.1',	1702562260,	1702562260,	0,	'1442',	NULL,	'https://meeting.iflyrec.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (597,	25,	'飞书妙记',	'1659',	'AI会议工具',	'飞书智能会议纪要和快捷语音识别转文字',	63,	1,	'创始人',	9,	'/webnav/ai-meeting-tools/show/597.html',	0,	0,	'127.0.0.1',	1702562243,	1702562243,	0,	'1443',	NULL,	'https://www.feishu.cn/product/minutes',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (598,	26,	'职徒简历',	'1444',	'AI效率提升',	'智能简历制作软件，基于GPT的简历优化和简历代写',	89,	1,	'创始人',	9,	'/webnav/ai-productivity-enhancement/show/598.html',	0,	0,	'127.0.0.1',	1702563999,	1702563999,	0,	'1445',	NULL,	'https://www.52cv.com',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (599,	26,	'Timely',	'1660',	'AI效率提升',	'AI时间管理跟踪软件',	95,	1,	'创始人',	9,	'/webnav/ai-productivity-enhancement/show/599.html',	0,	0,	'127.0.0.1',	1702564044,	1702564044,	0,	'1446',	NULL,	'https://timelyapp.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (600,	26,	'Raycast AI',	'1661',	'AI效率提升',	'Raycast推出的Mac AI助手，智能写作、编程、回答问题等',	67,	1,	'创始人',	9,	'/webnav/ai-productivity-enhancement/show/600.html',	0,	0,	'127.0.0.1',	1702563994,	1702563994,	0,	'1447',	NULL,	'https://www.raycast.com/ai',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (601,	26,	'Merlin',	'1448',	'AI效率提升',	'基于ChatGPT的Chrome浏览器扩展，浏览任意网页时利用GPT',	22,	1,	'创始人',	9,	'/webnav/ai-productivity-enhancement/show/601.html',	0,	0,	'127.0.0.1',	1702564010,	1702564010,	0,	'1449',	NULL,	'https://merlin.foyer.work/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (602,	26,	'Monica',	'1450',	'AI效率提升',	'ChatGPT驱动的Chrome浏览器AI助手插件',	57,	1,	'创始人',	9,	'/webnav/ai-productivity-enhancement/show/602.html',	0,	0,	'127.0.0.1',	1702564073,	1702564073,	0,	'1451',	NULL,	'http://monica.im',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (603,	26,	'Zapier AI',	'1452',	'AI效率提升',	'Zapier推出的AI自动化集成功能',	61,	1,	'创始人',	9,	'/webnav/ai-productivity-enhancement/show/603.html',	0,	0,	'127.0.0.1',	1702564024,	1702564024,	0,	'1453',	NULL,	'https://zapier.com/ai?utm_source=ai-bot.cn',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (604,	22,	'Excel Formularizer',	'1662',	'AI表格数据处理',	'AI将文本输入转换为Excel公式处理',	60,	1,	'创始人',	9,	'/webnav/ai-spreadsheet-data-processing/show/604.html',	0,	0,	'127.0.0.1',	1702564135,	1702564135,	0,	'1454',	NULL,	'https://excelformularizer.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (605,	22,	'SheetGod',	'1663',	'AI表格数据处理',	'BoloForms推出的AI Excel公式生成工具',	42,	1,	'创始人',	9,	'/webnav/ai-spreadsheet-data-processing/show/605.html',	0,	0,	'127.0.0.1',	1702564153,	1702564153,	0,	'1455',	NULL,	'https://www.boloforms.com/sheetgod/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (606,	22,	'Excelly-AI',	'1664',	'AI表格数据处理',	'将文本转换成Excel或Google Sheets公式',	47,	1,	'创始人',	9,	'/webnav/ai-spreadsheet-data-processing/show/606.html',	0,	0,	'127.0.0.1',	1702564114,	1702564114,	0,	'1456',	NULL,	'https://excelly-ai.io/index.html',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (607,	22,	'Rows',	'1665',	'AI表格数据处理',	'集成了AI功能的在线表格处理工具',	55,	1,	'创始人',	9,	'/webnav/ai-spreadsheet-data-processing/show/607.html',	0,	0,	'127.0.0.1',	1702564097,	1702564097,	0,	'1457',	NULL,	'https://rows.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (608,	22,	'FormX.ai',	'1666',	'AI表格数据处理',	'AI自动从表格和文档中提取数据',	98,	1,	'创始人',	9,	'/webnav/ai-spreadsheet-data-processing/show/608.html',	0,	0,	'127.0.0.1',	1702564117,	1702564117,	0,	'1458',	NULL,	'https://www.formx.ai/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (609,	22,	'ExcelFormulaBot',	'1667',	'AI表格数据处理',	'AI将指令转换成Excel的函数公式',	64,	1,	'创始人',	9,	'/webnav/ai-spreadsheet-data-processing/show/609.html',	0,	0,	'127.0.0.1',	1702564167,	1702564167,	0,	'1459',	NULL,	'https://excelformulabot.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (610,	22,	'Sheet+',	'1668',	'AI表格数据处理',	'Excel和Google Sheets表格AI处理工具',	51,	1,	'创始人',	9,	'/webnav/ai-spreadsheet-data-processing/show/610.html',	0,	0,	'127.0.0.1',	1702564161,	1702564161,	0,	'1460',	NULL,	'https://sheetplus.ai/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (611,	22,	'Ajelix',	'1669',	'AI表格数据处理',	'处理Excel和Google Sheets表格的AI工具',	32,	1,	'创始人',	9,	'/webnav/ai-spreadsheet-data-processing/show/611.html',	0,	0,	'127.0.0.1',	1702564119,	1702564119,	0,	'1461',	NULL,	'https://ajelix.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (612,	24,	'Ayoa Ultimate',	'1670',	'AI思维导图',	'AI思维导图和头脑风暴工具',	12,	1,	'创始人',	9,	'/webnav/ai-mind-mapping/show/612.html',	0,	0,	'127.0.0.1',	1702564178,	1702564178,	0,	'1462',	NULL,	'https://www.ayoa.com/ultimate/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (613,	24,	'博思AI白板',	'1463',	'AI思维导图',	'博思AI白板，AI自动生成文字和思维导图',	73,	1,	'创始人',	9,	'/webnav/ai-mind-mapping/show/613.html',	0,	0,	'127.0.0.1',	1702564206,	1702564206,	0,	'1464',	NULL,	'https://boardmix.cn/ai-whiteboard/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (614,	24,	'Miro AI',	'1671',	'AI思维导图',	'在线白板协作工具推出的AI功能，Beta测试中',	65,	1,	'创始人',	9,	'/webnav/ai-mind-mapping/show/614.html',	0,	0,	'127.0.0.1',	1702564159,	1702564159,	0,	'1465',	NULL,	'https://miro.com/mind-map/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (615,	24,	'Taskade',	'1672',	'AI思维导图',	'高颜值AI大纲和思维导图生成',	83,	1,	'创始人',	9,	'/webnav/ai-mind-mapping/show/615.html',	0,	0,	'127.0.0.1',	1702564149,	1702564149,	0,	'1466',	NULL,	'https://www.taskade.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (616,	24,	'AmyMind',	'1467',	'AI思维导图',	'开箱即用的在线AI思维导图工具',	97,	1,	'创始人',	9,	'/webnav/ai-mind-mapping/show/616.html',	0,	0,	'127.0.0.1',	1702564222,	1702564222,	0,	'1468',	NULL,	'https://amymind.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (617,	24,	'Whimsical',	'1470',	'AI思维导图',	'Whimsical推出的AI思维导图工具',	42,	1,	'创始人',	9,	'/webnav/ai-mind-mapping/show/617.html',	0,	0,	'127.0.0.1',	1702564228,	1702564228,	0,	'1471',	NULL,	'https://whimsical.com/ai-mind-maps',	1,	0,	0),
                                                                                                                                                                                                                                                                                      (618,	24,	'ChatMind',	'1472',	'AI思维导图',	'与AI对话生成思维导图',	51,	1,	'创始人',	9,	'/webnav/ai-mind-mapping/show/618.html',	0,	0,	'127.0.0.1',	1702564203,	1702564203,	0,	'1473',	NULL,	'https://www.chatmind.tech/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (619,	24,	'GitMind思乎',	'1474',	'AI思维导图',	'AI驱动的免费思维导图工具',	74,	1,	'创始人',	9,	'/webnav/ai-mind-mapping/show/619.html',	0,	0,	'127.0.0.1',	1702564145,	1702564145,	0,	'1475',	NULL,	'https://gitmind.cn/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (620,	24,	'妙办AI画图工具',	'1476',	'AI思维导图',	'AI免费一键生成流程图、思维导图',	10,	1,	'创始人',	9,	'/webnav/ai-mind-mapping/show/620.html',	0,	0,	'127.0.0.1',	1702564179,	1702564179,	0,	'1477',	NULL,	'https://imiaoban.com/ai/mind?source=35261',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (621,	24,	'Xmind Copilot',	'1478',	'AI思维导图',	'Xmind AI思维导图助手',	64,	1,	'创始人',	9,	'/webnav/ai-mind-mapping/show/621.html',	0,	0,	'127.0.0.1',	1702564217,	1702564217,	0,	'1479',	NULL,	'https://xmind.ai/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (622,	24,	'知犀AI',	'1480',	'AI思维导图',	'知犀推出的AI思维导图生成工具',	10,	1,	'创始人',	9,	'/webnav/ai-mind-mapping/show/622.html',	0,	0,	'127.0.0.1',	1702564164,	1702564164,	0,	'1481',	NULL,	'https://www.swdt.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (623,	24,	'印象图记',	'1483',	'AI思维导图',	'印象AI加持的在线思维导图工具',	21,	1,	'创始人',	9,	'/webnav/ai-mind-mapping/show/623.html',	0,	0,	'127.0.0.1',	1702564170,	1702564170,	0,	'1484',	NULL,	'https://www.yinxiang.com/product/evermind/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (624,	24,	'ProcessOn',	'1486',	'AI思维导图',	'在线AI流程图和思维导图制作工具',	25,	1,	'创始人',	9,	'/webnav/ai-mind-mapping/show/624.html',	0,	0,	'127.0.0.1',	1702564256,	1702564256,	0,	'1487',	NULL,	'https://www.processon.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (625,	1,	'Content at Scale',	'//s0.wp.com/mshots/v1/?w=383&h=328',	'AI写作工具',	'AI SEO长内容创作',	30,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/625.html',	0,	0,	'127.0.0.1',	1702547223,	1702547223,	0,	'85',	NULL,	'https://cn.bing.com/search?q=Content at Scale&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (626,	1,	'INK',	'//s0.wp.com/mshots/v1/?w=383&h=328',	'AI写作工具',	'AI内容营销和SEO助手',	84,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/626.html',	0,	0,	'127.0.0.1',	1702547266,	1702547266,	0,	'86',	NULL,	'https://cn.bing.com/search?q=INK&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (627,	1,	'TextCortex',	'//s0.wp.com/mshots/v1/?w=383&h=328',	'AI写作工具',	'AI写作能手',	12,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/627.html',	0,	0,	'127.0.0.1',	1702547248,	1702547248,	0,	'87',	NULL,	'https://cn.bing.com/search?q=TextCortex&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (628,	1,	'Frase',	'//s0.wp.com/mshots/v1/?w=383&h=328',	'AI写作工具',	'AI SEO内容优化和写作工具',	80,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/628.html',	0,	0,	'127.0.0.1',	1702547260,	1702547260,	0,	'92',	NULL,	'https://cn.bing.com/search?q=Frase&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (629,	1,	'Copysmith',	'//s0.wp.com/mshots/v1/?w=383&h=328',	'AI写作工具',	'企业级和电商文案生成',	97,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/629.html',	0,	0,	'127.0.0.1',	1702547315,	1702547315,	0,	'93',	NULL,	'https://cn.bing.com/search?q=Copysmith&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (630,	1,	'Yaara',	'//s0.wp.com/mshots/v1/?w=383&h=328',	'AI写作工具',	'释放你的写作潜力',	92,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/630.html',	0,	0,	'127.0.0.1',	1702547297,	1702547297,	0,	'94',	NULL,	'https://cn.bing.com/search?q=Yaara&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (631,	1,	'WordTune',	'//s0.wp.com/mshots/v1/?w=383&h=328',	'AI写作工具',	'你的个人写作助手和编辑',	22,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/631.html',	0,	0,	'127.0.0.1',	1702547310,	1702547310,	0,	'95',	NULL,	'https://cn.bing.com/search?q=WordTune&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (632,	1,	'ProWritingAid',	'1675',	'AI写作工具',	'英语写作优化和修改工具',	97,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/632.html',	0,	0,	'127.0.0.1',	1702547249,	1702711685,	0,	'96',	'',	'https://prowritingaid.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (633,	1,	'SurferSEO',	'//s0.wp.com/mshots/v1/?w=383&h=328',	'AI写作工具',	'AI SEO大纲和内容优化写作工具',	47,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/633.html',	0,	0,	'127.0.0.1',	1702547259,	1702547259,	0,	'97',	NULL,	'https://cn.bing.com/search?q=SurferSEO&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (634,	1,	'AISEO',	'//s0.wp.com/mshots/v1/?w=383&h=328',	'AI写作工具',	'AI创作SEO优化友好的文案和文章',	33,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/634.html',	0,	0,	'127.0.0.1',	1702547257,	1702547257,	0,	'100',	NULL,	'https://cn.bing.com/search?q=AISEO&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (635,	1,	'Reword',	'//s0.wp.com/mshots/v1/?w=383&h=328',	'AI写作工具',	'AI文章写作',	95,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/635.html',	0,	0,	'127.0.0.1',	1702547298,	1702547298,	0,	'103',	NULL,	'https://cn.bing.com/search?q=Reword&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (636,	1,	'Jounce',	'//s0.wp.com/mshots/v1/?w=383&h=328',	'AI写作工具',	'无限制免费AI文案写作',	58,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/636.html',	0,	0,	'127.0.0.1',	1702547289,	1702547289,	0,	'104',	NULL,	'https://cn.bing.com/search?q=Jounce&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (637,	1,	'LongShot',	'//s0.wp.com/mshots/v1/?w=383&h=328',	'AI写作工具',	'AI长文章写作工具',	21,	1,	'创始人',	9,	'/webnav/ai-writing-tools/show/637.html',	0,	0,	'127.0.0.1',	1702547311,	1702547311,	0,	'105',	NULL,	'https://cn.bing.com/search?q=LongShot&ensearch=1',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (638,	6,	'快转字幕',	'1492',	'AI音频工具',	'AI语音视频转文字和字幕的工具',	94,	1,	'创始人',	9,	'/webnav/ai-audio-tools/show/638.html',	0,	0,	'127.0.0.1',	1702548263,	1702548263,	0,	'1493',	NULL,	'https://www.kzzimu.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (639,	7,	'JetBrains AI',	'1496',	'AI编程工具',	'JetBrains推出的AI编程开发助手',	42,	1,	'创始人',	9,	'/webnav/ai-programming-tools/show/639.html',	0,	0,	'127.0.0.1',	1702548461,	1702548461,	0,	'1497',	NULL,	'https://www.jetbrains.com/ai/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (640,	13,	'Ollama',	'1501',	'AI训练模型',	'本地运行Llama和其他大语言模型',	55,	1,	'创始人',	9,	'/webnav/ai-models/show/640.html',	0,	0,	'127.0.0.1',	1702550139,	1702550139,	0,	'1502',	NULL,	'https://ollama.ai/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (641,	19,	'Remini',	'1503',	'AI图片优化修复',	'AI智能将模糊照片变高清的图像修复工具',	12,	1,	'创始人',	9,	'/webnav/ai-image-enhancement-restoration/show/641.html',	0,	0,	'127.0.0.1',	1702550109,	1702550109,	0,	'1504',	NULL,	'https://remini.ai/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (642,	8,	'Logo Diffusion',	'1507',	'AI设计工具',	'AI驱动的Logo和标志生成工具',	18,	1,	'创始人',	9,	'/webnav/ai-design-tools/show/642.html',	0,	0,	'127.0.0.1',	1702550164,	1702550164,	0,	'1508',	NULL,	'https://logodiffusion.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (643,	6,	'Audiobox',	'1511',	'AI音频工具',	'Meta推出的免费开源的AI语音和声音生成模型',	73,	1,	'创始人',	9,	'/webnav/ai-audio-tools/show/643.html',	0,	0,	'127.0.0.1',	1702550167,	1702550167,	0,	'362',	NULL,	'https://audiobox.metademolab.com/',	0,	0,	0),
                                                                                                                                                                                                                                                                                      (644,	7,	'Solo',	'1513',	'AI编程工具',	'Mozilla推出的零编程无代码AI网站建设工具',	84,	1,	'创始人',	9,	'/webnav/ai-programming-tools/show/644.html',	0,	0,	'127.0.0.1',	1702550136,	1702550136,	0,	'1514',	NULL,	'https://soloist.ai/',	0,	0,	0);

DROP TABLE IF EXISTS `fhx_1_webnav_category`;
CREATE TABLE `fhx_1_webnav_category` (
                                         `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
                                         `pid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '上级id',
                                         `pids` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '所有上级id',
                                         `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '栏目名称',
                                         `dirname` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '栏目目录',
                                         `pdirname` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '上级目录',
                                         `child` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否有下级',
                                         `disabled` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否禁用',
                                         `ismain` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否主栏目',
                                         `childids` text COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '下级所有id',
                                         `thumb` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '栏目图片',
                                         `show` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否显示',
                                         `setting` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '属性配置',
                                         `displayorder` mediumint(8) NOT NULL DEFAULT '0',
                                         `tubiao` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '图标',
                                         PRIMARY KEY (`id`),
                                         KEY `show` (`show`),
                                         KEY `disabled` (`disabled`),
                                         KEY `ismain` (`ismain`),
                                         KEY `module` (`pid`,`displayorder`,`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='栏目表';

INSERT INTO `fhx_1_webnav_category` (`id`, `pid`, `pids`, `name`, `dirname`, `pdirname`, `child`, `disabled`, `ismain`, `childids`, `thumb`, `show`, `setting`, `displayorder`, `tubiao`) VALUES
                                                                                                                                                                                              (1,	0,	'0',	'AI写作工具',	'ai-writing-tools',	'',	0,	0,	1,	'1',	'',	1,	'{\"disabled\":\"0\",\"linkurl\":\"\",\"getchild\":\"0\",\"notedit\":\"0\",\"seo\":{\"list_title\":\"[第{page}页{join}]{catpname}{join}{SITE_NAME}\",\"list_keywords\":\"\",\"list_description\":\"\"},\"template\":{\"pagesize\":\"36\",\"mpagesize\":\"20\",\"list\":\"ai_list.html\",\"category\":\"ai_category.html\",\"search\":\"ai_search.html\",\"show\":\"ai_show.html\"},\"cat_field\":null,\"module_field\":null}',	0,	'fas fa-feather'),
                                                                                                                                                                                              (2,	0,	'0',	'AI图像工具',	'ai-image-tools',	'',	1,	0,	1,	'2,15,16,17,18,19,20',	'',	1,	'{\"disabled\":\"0\",\"linkurl\":\"\",\"getchild\":\"0\",\"notedit\":\"0\",\"seo\":{\"list_title\":\"[第{page}页{join}]{catpname}{join}{SITE_NAME}\",\"list_keywords\":\"\",\"list_description\":\"\"},\"template\":{\"pagesize\":\"36\",\"mpagesize\":\"20\",\"list\":\"ai_list.html\",\"category\":\"ai_category.html\",\"search\":\"ai_search.html\",\"show\":\"ai_show.html\"},\"cat_field\":null,\"module_field\":null}',	0,	'fas fa-images'),
                                                                                                                                                                                              (3,	0,	'0',	'AI视频工具',	'ai-video-tools',	'',	0,	0,	1,	'3',	'',	1,	'{\"edit\":1,\"disabled\":0,\"template\":{\"pagesize\":\"36\",\"mpagesize\":\"20\",\"list\":\"ai_list.html\",\"category\":\"ai_category.html\",\"search\":\"ai_search.html\",\"show\":\"ai_show.html\"},\"seo\":{\"list_title\":\"[第{page}页{join}]{name}{join}{SITE_NAME}\",\"show_title\":\"[第{page}页{join}]{title}{join}{catname}{join}{SITE_NAME}\"},\"getchild\":0}',	0,	'fas fa-video'),
                                                                                                                                                                                              (4,	0,	'0',	'AI办公工具',	'ai-office-tools',	'',	1,	0,	1,	'4,21,22,23,24,25,26',	'',	1,	'{\"edit\":1,\"disabled\":0,\"template\":{\"pagesize\":\"36\",\"mpagesize\":\"20\",\"list\":\"ai_list.html\",\"category\":\"ai_category.html\",\"search\":\"ai_search.html\",\"show\":\"ai_show.html\"},\"seo\":{\"list_title\":\"[第{page}页{join}]{name}{join}{SITE_NAME}\",\"show_title\":\"[第{page}页{join}]{title}{join}{catname}{join}{SITE_NAME}\"},\"getchild\":0}',	0,	'fas fa-briefcase'),
                                                                                                                                                                                              (5,	0,	'0',	'AI对话聊天',	'ai-chatbots',	'',	0,	0,	1,	'5',	'',	1,	'{\"edit\":1,\"disabled\":0,\"template\":{\"pagesize\":\"36\",\"mpagesize\":\"20\",\"list\":\"ai_list.html\",\"category\":\"ai_category.html\",\"search\":\"ai_search.html\",\"show\":\"ai_show.html\"},\"seo\":{\"list_title\":\"[第{page}页{join}]{name}{join}{SITE_NAME}\",\"show_title\":\"[第{page}页{join}]{title}{join}{catname}{join}{SITE_NAME}\"},\"getchild\":0}',	0,	'fab fa-facebook-messenger'),
                                                                                                                                                                                              (6,	0,	'0',	'AI音频工具',	'ai-audio-tools',	'',	0,	0,	1,	'6',	'',	1,	'{\"edit\":1,\"disabled\":0,\"template\":{\"pagesize\":\"36\",\"mpagesize\":\"20\",\"list\":\"ai_list.html\",\"category\":\"ai_category.html\",\"search\":\"ai_search.html\",\"show\":\"ai_show.html\"},\"seo\":{\"list_title\":\"[第{page}页{join}]{name}{join}{SITE_NAME}\",\"show_title\":\"[第{page}页{join}]{title}{join}{catname}{join}{SITE_NAME}\"},\"getchild\":0}',	0,	'fas fa-music'),
                                                                                                                                                                                              (7,	0,	'0',	'AI编程工具',	'ai-programming-tools',	'',	0,	0,	1,	'7',	'',	1,	'{\"edit\":1,\"disabled\":0,\"template\":{\"pagesize\":\"36\",\"mpagesize\":\"20\",\"list\":\"ai_list.html\",\"category\":\"ai_category.html\",\"search\":\"ai_search.html\",\"show\":\"ai_show.html\"},\"seo\":{\"list_title\":\"[第{page}页{join}]{name}{join}{SITE_NAME}\",\"show_title\":\"[第{page}页{join}]{title}{join}{catname}{join}{SITE_NAME}\"},\"getchild\":0}',	0,	'fas fa-code'),
                                                                                                                                                                                              (8,	0,	'0',	'AI设计工具',	'ai-design-tools',	'',	0,	0,	1,	'8',	'',	1,	'{\"edit\":1,\"disabled\":0,\"template\":{\"pagesize\":\"36\",\"mpagesize\":\"20\",\"list\":\"ai_list.html\",\"category\":\"ai_category.html\",\"search\":\"ai_search.html\",\"show\":\"ai_show.html\"},\"seo\":{\"list_title\":\"[第{page}页{join}]{name}{join}{SITE_NAME}\",\"show_title\":\"[第{page}页{join}]{title}{join}{catname}{join}{SITE_NAME}\"},\"getchild\":0}',	0,	'fas fa-palette'),
                                                                                                                                                                                              (9,	0,	'0',	'AI内容检测',	'ai-content-detection-tools',	'',	0,	0,	1,	'9',	'',	1,	'{\"edit\":1,\"disabled\":0,\"template\":{\"pagesize\":\"36\",\"mpagesize\":\"20\",\"list\":\"ai_list.html\",\"category\":\"ai_category.html\",\"search\":\"ai_search.html\",\"show\":\"ai_show.html\"},\"seo\":{\"list_title\":\"[第{page}页{join}]{name}{join}{SITE_NAME}\",\"show_title\":\"[第{page}页{join}]{title}{join}{catname}{join}{SITE_NAME}\"},\"getchild\":0}',	0,	'fas fa-broadcast-tower'),
                                                                                                                                                                                              (10,	0,	'0',	'AI学习网站',	'websites-to-learn-ai',	'',	0,	0,	1,	'10',	'',	1,	'{\"edit\":1,\"disabled\":0,\"template\":{\"pagesize\":\"36\",\"mpagesize\":\"20\",\"list\":\"ai_list.html\",\"category\":\"ai_category.html\",\"search\":\"ai_search.html\",\"show\":\"ai_show.html\"},\"seo\":{\"list_title\":\"[第{page}页{join}]{name}{join}{SITE_NAME}\",\"show_title\":\"[第{page}页{join}]{title}{join}{catname}{join}{SITE_NAME}\"},\"getchild\":0}',	0,	'fas fa-graduation-cap'),
                                                                                                                                                                                              (11,	0,	'0',	'AI开发框架',	'ai-frameworks',	'',	0,	0,	1,	'11',	'',	1,	'{\"edit\":1,\"disabled\":0,\"template\":{\"pagesize\":\"36\",\"mpagesize\":\"20\",\"list\":\"ai_list.html\",\"category\":\"ai_category.html\",\"search\":\"ai_search.html\",\"show\":\"ai_show.html\"},\"seo\":{\"list_title\":\"[第{page}页{join}]{name}{join}{SITE_NAME}\",\"show_title\":\"[第{page}页{join}]{title}{join}{catname}{join}{SITE_NAME}\"},\"getchild\":0}',	0,	'fab fa-codepen'),
                                                                                                                                                                                              (12,	0,	'0',	'AI提示指令',	'ai-prompt-tools',	'',	0,	0,	1,	'12',	'',	1,	'{\"edit\":1,\"disabled\":0,\"template\":{\"pagesize\":\"36\",\"mpagesize\":\"20\",\"list\":\"ai_list.html\",\"category\":\"ai_category.html\",\"search\":\"ai_search.html\",\"show\":\"ai_show.html\"},\"seo\":{\"list_title\":\"[第{page}页{join}]{name}{join}{SITE_NAME}\",\"show_title\":\"[第{page}页{join}]{title}{join}{catname}{join}{SITE_NAME}\"},\"getchild\":0}',	0,	'fas fa-lightbulb'),
                                                                                                                                                                                              (13,	0,	'0',	'AI训练模型',	'ai-models',	'',	0,	0,	1,	'13',	'',	1,	'{\"edit\":1,\"disabled\":0,\"template\":{\"pagesize\":\"36\",\"mpagesize\":\"20\",\"list\":\"ai_list.html\",\"category\":\"ai_category.html\",\"search\":\"ai_search.html\",\"show\":\"ai_show.html\"},\"seo\":{\"list_title\":\"[第{page}页{join}]{name}{join}{SITE_NAME}\",\"show_title\":\"[第{page}页{join}]{title}{join}{catname}{join}{SITE_NAME}\"},\"getchild\":0}',	0,	'fas fa-cubes'),
                                                                                                                                                                                              (14,	0,	'0',	'AI模型评测',	'llm-benchmarks',	'',	0,	0,	1,	'14',	'',	1,	'{\"edit\":1,\"disabled\":0,\"template\":{\"pagesize\":\"36\",\"mpagesize\":\"20\",\"list\":\"ai_list.html\",\"category\":\"ai_category.html\",\"search\":\"ai_search.html\",\"show\":\"ai_show.html\"},\"seo\":{\"list_title\":\"[第{page}页{join}]{name}{join}{SITE_NAME}\",\"show_title\":\"[第{page}页{join}]{title}{join}{catname}{join}{SITE_NAME}\"},\"getchild\":0}',	0,	'fas fa-rocket'),
                                                                                                                                                                                              (15,	2,	'0,2',	'常用AI图像工具',	'ai-image-tools',	'ai-image-tools/',	0,	0,	1,	'15',	'',	1,	'{\"disabled\":\"0\",\"linkurl\":\"\",\"getchild\":0,\"notedit\":\"0\",\"seo\":[],\"template\":{\"pagesize\":\"36\",\"mpagesize\":\"20\",\"list\":\"ai_list.html\",\"category\":\"ai_category.html\",\"search\":\"ai_search.html\",\"show\":\"ai_show.html\"},\"cat_field\":null,\"module_field\":null,\"html\":0,\"chtml\":0,\"urlrule\":0}',	0,	NULL),
                                                                                                                                                                                              (16,	2,	'0,2',	'AI图片插画生成',	'ai-illustration-generation',	'ai-image-tools/',	0,	0,	1,	'16',	'',	1,	'{\"disabled\":\"0\",\"linkurl\":\"\",\"getchild\":0,\"notedit\":\"0\",\"seo\":[],\"template\":{\"pagesize\":\"36\",\"mpagesize\":\"20\",\"list\":\"ai_list.html\",\"category\":\"ai_category.html\",\"search\":\"ai_search.html\",\"show\":\"ai_show.html\"},\"cat_field\":null,\"module_field\":null,\"html\":0,\"chtml\":0,\"urlrule\":0}',	0,	NULL),
                                                                                                                                                                                              (17,	2,	'0,2',	'AI图片背景移除',	'ai-background-removal',	'ai-image-tools/',	0,	0,	1,	'17',	'',	1,	'{\"disabled\":\"0\",\"linkurl\":\"\",\"getchild\":0,\"notedit\":\"0\",\"seo\":[],\"template\":{\"pagesize\":\"36\",\"mpagesize\":\"20\",\"list\":\"ai_list.html\",\"category\":\"ai_category.html\",\"search\":\"ai_search.html\",\"show\":\"ai_show.html\"},\"cat_field\":null,\"module_field\":null,\"html\":0,\"chtml\":0,\"urlrule\":0}',	0,	NULL),
                                                                                                                                                                                              (18,	2,	'0,2',	'AI图片无损放大',	'ai-image-upscaling',	'ai-image-tools/',	0,	0,	1,	'18',	'',	1,	'{\"disabled\":\"0\",\"linkurl\":\"\",\"getchild\":0,\"notedit\":\"0\",\"seo\":[],\"template\":{\"pagesize\":\"36\",\"mpagesize\":\"20\",\"list\":\"ai_list.html\",\"category\":\"ai_category.html\",\"search\":\"ai_search.html\",\"show\":\"ai_show.html\"},\"cat_field\":null,\"module_field\":null,\"html\":0,\"chtml\":0,\"urlrule\":0}',	0,	NULL),
                                                                                                                                                                                              (19,	2,	'0,2',	'AI图片优化修复',	'ai-image-enhancement-restoration',	'ai-image-tools/',	0,	0,	1,	'19',	'',	1,	'{\"disabled\":\"0\",\"linkurl\":\"\",\"getchild\":0,\"notedit\":\"0\",\"seo\":[],\"template\":{\"pagesize\":\"36\",\"mpagesize\":\"20\",\"list\":\"ai_list.html\",\"category\":\"ai_category.html\",\"search\":\"ai_search.html\",\"show\":\"ai_show.html\"},\"cat_field\":null,\"module_field\":null,\"html\":0,\"chtml\":0,\"urlrule\":0}',	0,	NULL),
                                                                                                                                                                                              (20,	2,	'0,2',	'AI图片物体抹除',	'ai-object-removal',	'ai-image-tools/',	0,	0,	1,	'20',	'',	1,	'{\"disabled\":\"0\",\"linkurl\":\"\",\"getchild\":0,\"notedit\":\"0\",\"seo\":[],\"template\":{\"pagesize\":\"36\",\"mpagesize\":\"20\",\"list\":\"ai_list.html\",\"category\":\"ai_category.html\",\"search\":\"ai_search.html\",\"show\":\"ai_show.html\"},\"cat_field\":null,\"module_field\":null,\"html\":0,\"chtml\":0,\"urlrule\":0}',	0,	NULL),
                                                                                                                                                                                              (21,	4,	'0,4',	'AI幻灯片和演示',	'ai-slideshow-tools',	'ai-office-tools/',	0,	0,	1,	'21',	'',	1,	'{\"edit\":1,\"disabled\":0,\"template\":{\"pagesize\":\"36\",\"mpagesize\":\"20\",\"list\":\"ai_list.html\",\"category\":\"ai_category.html\",\"search\":\"ai_search.html\",\"show\":\"ai_show.html\"},\"seo\":[],\"getchild\":0,\"html\":0,\"chtml\":0,\"urlrule\":0}',	0,	NULL),
                                                                                                                                                                                              (22,	4,	'0,4',	'AI表格数据处理',	'ai-spreadsheet-data-processing',	'ai-office-tools/',	0,	0,	1,	'22',	'',	1,	'{\"edit\":1,\"disabled\":0,\"template\":{\"pagesize\":\"36\",\"mpagesize\":\"20\",\"list\":\"ai_list.html\",\"category\":\"ai_category.html\",\"search\":\"ai_search.html\",\"show\":\"ai_show.html\"},\"seo\":[],\"getchild\":0,\"html\":0,\"chtml\":0,\"urlrule\":0}',	0,	NULL),
                                                                                                                                                                                              (23,	4,	'0,4',	'AI文档工具',	'ai-document-tools',	'ai-office-tools/',	0,	0,	1,	'23',	'',	1,	'{\"edit\":1,\"disabled\":0,\"template\":{\"pagesize\":\"36\",\"mpagesize\":\"20\",\"list\":\"ai_list.html\",\"category\":\"ai_category.html\",\"search\":\"ai_search.html\",\"show\":\"ai_show.html\"},\"seo\":[],\"getchild\":0,\"html\":0,\"chtml\":0,\"urlrule\":0}',	0,	NULL),
                                                                                                                                                                                              (24,	4,	'0,4',	'AI思维导图',	'ai-mind-mapping',	'ai-office-tools/',	0,	0,	1,	'24',	'',	1,	'{\"edit\":1,\"disabled\":0,\"template\":{\"pagesize\":\"36\",\"mpagesize\":\"20\",\"list\":\"ai_list.html\",\"category\":\"ai_category.html\",\"search\":\"ai_search.html\",\"show\":\"ai_show.html\"},\"seo\":[],\"getchild\":0,\"html\":0,\"chtml\":0,\"urlrule\":0}',	0,	NULL),
                                                                                                                                                                                              (25,	4,	'0,4',	'AI会议工具',	'ai-meeting-tools',	'ai-office-tools/',	0,	0,	1,	'25',	'',	1,	'{\"edit\":1,\"disabled\":0,\"template\":{\"pagesize\":\"36\",\"mpagesize\":\"20\",\"list\":\"ai_list.html\",\"category\":\"ai_category.html\",\"search\":\"ai_search.html\",\"show\":\"ai_show.html\"},\"seo\":[],\"getchild\":0,\"html\":0,\"chtml\":0,\"urlrule\":0}',	0,	NULL),
                                                                                                                                                                                              (26,	4,	'0,4',	'AI效率提升',	'ai-productivity-enhancement',	'ai-office-tools/',	0,	0,	1,	'26',	'',	1,	'{\"edit\":1,\"disabled\":0,\"template\":{\"pagesize\":\"36\",\"mpagesize\":\"20\",\"list\":\"ai_list.html\",\"category\":\"ai_category.html\",\"search\":\"ai_search.html\",\"show\":\"ai_show.html\"},\"seo\":[],\"getchild\":0,\"html\":0,\"chtml\":0,\"urlrule\":0}',	0,	NULL);

DROP TABLE IF EXISTS `fhx_1_webnav_category_data`;
CREATE TABLE `fhx_1_webnav_category_data` (
                                              `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
                                              `uid` mediumint(8) unsigned NOT NULL COMMENT '作者uid',
                                              `catid` int(3) unsigned NOT NULL COMMENT '栏目id',
                                              PRIMARY KEY (`id`),
                                              KEY `uid` (`uid`),
                                              KEY `catid` (`catid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='栏目模型表';


DROP TABLE IF EXISTS `fhx_1_webnav_data_0`;
CREATE TABLE `fhx_1_webnav_data_0` (
                                       `id` int(10) unsigned NOT NULL,
                                       `uid` mediumint(8) unsigned NOT NULL COMMENT '作者uid',
                                       `catid` smallint(5) unsigned NOT NULL COMMENT '栏目id',
                                       `content` mediumtext COLLATE utf8mb4_unicode_ci COMMENT '内容',
                                       UNIQUE KEY `id` (`id`),
                                       KEY `uid` (`uid`),
                                       KEY `catid` (`catid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='内容附表';

INSERT INTO `fhx_1_webnav_data_0` (`id`, `uid`, `catid`, `content`) VALUES
                                                                        (1,	0,	1,	'英语写作优化和修改工具'),
                                                                        (2,	0,	1,	'AI SEO大纲和内容优化写作工具'),
                                                                        (3,	0,	1,	'<p>Writer是一个企业级AI写作工具，是一款专为多人团队打造的的人工智能写作助手，支持自定义写作指南，向用户提供写作建议，并构建在线风格指南，以实现内容加速和品牌一致性。该工具适用于希望在多个团队和/或风格指南中使用 Writer 的公司，或者希望在构建术语、片段、建议或风格指南方面保持统一的公司。</p>'),
                                                                        (4,	0,	1,	'AI创作SEO优化友好的文案和文章'),
                                                                        (5,	0,	1,	'与Mac、iPhone、iPad集成的个人写作助手'),
                                                                        (6,	0,	1,	'AI文章写作'),
                                                                        (7,	0,	1,	'无限制免费AI文案写作'),
                                                                        (8,	0,	1,	'AI长文章写作工具'),
                                                                        (9,	0,	1,	'基于ChatGPT的AI写作应用'),
                                                                        (10,	0,	1,	'人工智能写作助手和文本生成器'),
                                                                        (11,	0,	1,	'<p>Mark Copy是一个人工智能技术驱动的SEO写作和营销文案工具，该工具提供了多达40个模板帮助你处理所有文案内容，如生成博客文章、产品描述和社交媒体帖子。只需输入一些文本描述，如标题、风格和主要关键词，Mark Copy就会为你快速生成SEO优化友好的内容。</p>\n<h2>Mark Copy的网站流量概况</h2>\n<h3>最新流量数据</h3>\n<div class=\"row\">\n<div class=\"col-sm-6 col-xl-3 col-lg-6\">\n<div class=\"card card-stats mb-4 mb-xl-0\">\n<div class=\"card-body\">\n<div class=\"row\">\n<div class=\"col\">\n<h5 class=\"card-title text-uppercase text-muted mb-0 text-sm\">9月流量</h5>\n<p class=\"mb-0\">\n<span class=\"h4 font-weight-bold mb-0\">59.2K</span>\n</p>\n</div>\n<div class=\"col-auto\">\n<div class=\"icon icon-shape bg-primary text-white rounded-circle d-flex justify-content-center align-items-center\" style=\"width: 48px; height: 48px;\">\n<i class=\"fas fa-chart-bar\"></i>\n</div>\n</div>\n</div>\n</div>\n</div>\n</div>\n<div class=\"col-sm-6 col-xl-3 col-lg-6\">\n<div class=\"card card-stats mb-4 mb-xl-0\">\n<div class=\"card-body\">\n<div class=\"row\">\n<div class=\"col\">\n<h5 class=\"card-title text-uppercase text-muted mb-0 text-sm\">跳出率</h5>\n<p class=\"mb-0\">\n<span class=\"h4 font-weight-bold mb-0\">44.61%</span>\n</p>\n</div>\n<div class=\"col-auto\">\n<div class=\"icon icon-shape bg-danger text-white rounded-circle d-flex justify-content-center align-items-center\" style=\"width: 48px; height: 48px;\">\n<i class=\"fas fa-chart-pie\"></i>\n</div>\n</div>\n</div>\n</div>\n</div>\n</div>\n<div class=\"col-sm-6 col-xl-3 col-lg-6\">\n<div class=\"card card-stats mb-4 mb-xl-0\">\n<div class=\"card-body\">\n<div class=\"row\">\n<div class=\"col\">\n<h5 class=\"card-title text-uppercase text-muted mb-0 text-sm\">单次访问网页数</h5>\n<p class=\"mb-0\">\n<span class=\"h4 font-weight-bold mb-0\">3.26</span>\n</p>\n</div>\n<div class=\"col-auto\">\n<div class=\"icon icon-shape bg-success text-white rounded-circle d-flex justify-content-center align-items-center\" style=\"width: 48px; height: 48px;\">\n<i class=\"fas fa-solar-panel\"></i>\n</div>\n</div>\n</div>\n</div>\n</div>\n</div>\n<div class=\"col-sm-6 col-xl-3 col-lg-6\">\n<div class=\"card card-stats mb-4 mb-xl-0\">\n<div class=\"card-body\">\n<div class=\"row\">\n<div class=\"col\">\n<h5 class=\"card-title text-uppercase text-muted mb-0 text-sm\">平均访问时长</h5>\n<p class=\"mb-0\">\n<span class=\"h4 font-weight-bold mb-0\">00:03:13</span>\n</p>\n</div>\n<div class=\"col-auto\">\n<div class=\"icon icon-shape bg-info text-white rounded-circle d-flex justify-content-center align-items-center\" style=\"width: 48px; height: 48px;\">\n<i class=\"fas fa-stopwatch\"></i>\n</div>\n</div>\n</div>\n</div>\n</div>\n</div>\n</div>\n<div class=\"row\">\n<div class=\"col-xl-8 col-12\">\n<h3 class=\"mt-4\">近几个月流量走势</h3>\n<div id=\"area-chart\" class=\"card\">\n</div>\n</div>\n<div class=\"col-xl-4 col-12\">\n<h3 class=\"mt-4\">网站流量来源</h3>\n<div>\n<div class=\"card\">\n<div class=\"table-responsive\">\n<table class=\"table align-items-center table-flush table-borderless text-sm mb-0\">\n<thead class=\"thead-light\">\n<tr>\n<th scope=\"col\">渠道来源</th>\n<th scope=\"col\">百分比</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n<th scope=\"row\">\n社交媒体\n</th>\n<td>\n<div class=\"d-flex align-items-center\">\n<span class=\"mr-2\" style=\"width:60px;\">4.35%</span>\n<div>\n<div class=\"progress\">\n<div class=\"progress-bar bg-gradient-danger\" role=\"progressbar\" aria-valuenow=\"0.01\" aria-valuemin=\"0\" aria-valuemax=\"100\" style=\"width: 4.35%;\"></div>\n</div>\n</div>\n</div>\n</td>\n</tr>\n<tr>\n<th scope=\"row\">\n付费引荐\n</th>\n<td>\n<div class=\"d-flex align-items-center\">\n<span class=\"mr-2\" style=\"width:60px;\">/</span>\n<div>\n<div class=\"progress\">\n<div class=\"progress-bar bg-gradient-success\" role=\"progressbar\" aria-valuenow=\"0\" aria-valuemin=\"0\" aria-valuemax=\"100\" style=\"width: 0%;\"></div>\n</div>\n</div>\n</div>\n</td>\n</tr>\n<tr>\n<th scope=\"row\">\n外链引荐\n</th>\n<td>\n<div class=\"d-flex align-items-center\">\n<span class=\"mr-2\" style=\"width:60px;\">3.15%</span>\n<div>\n<div class=\"progress\">\n<div class=\"progress-bar bg-gradient-primary\" role=\"progressbar\" aria-valuenow=\"3.15\" aria-valuemin=\"0\" aria-valuemax=\"100\" style=\"width: 3.15%;\"></div>\n</div>\n</div>\n</div>\n</td>\n</tr>\n<tr>\n<th scope=\"row\">\n自然搜索\n</th>\n<td>\n<div class=\"d-flex align-items-center\">\n<span class=\"mr-2\" style=\"width:60px;\">58.36%</span>\n<div>\n<div class=\"progress\">\n<div class=\"progress-bar bg-gradient-info\" role=\"progressbar\" aria-valuenow=\"58.36\" aria-valuemin=\"0\" aria-valuemax=\"100\" style=\"width: 58.36%;\"></div>\n</div>\n</div>\n</div>\n</td>\n</tr>\n<tr>\n<th scope=\"row\">\n直接访问\n</th>\n<td>\n<div class=\"d-flex align-items-center\">\n<span class=\"mr-2\" style=\"width:60px;\">34.05%</span>\n<div>\n<div class=\"progress\">\n<div class=\"progress-bar bg-gradient-warning\" role=\"progressbar\" aria-valuenow=\"34.05\" aria-valuemin=\"0\" aria-valuemax=\"100\" style=\"width: 34.05%;\"></div>\n</div>\n</div>\n</div>\n</td>\n</tr>\n</tbody>\n</table>\n</div>\n</div>\n</div>\n</div>\n</div>\n<h3 class=\"mt-4\">Top5访问国家/地区</h3>\n<div class=\"row\">\n<div class=\"col-xl-8 col-12 p-2\">\n<div id=\"map\" class=\"card p-2\" style=\"height: 300px;\"></div>\n</div>\n<div class=\"col-xl-4 col-12\">\n<div class=\"card\">\n<div class=\"table-responsive\">\n<table class=\"table align-items-center table-flush table-borderless text-sm mb-0\">\n<thead class=\"thead-light\">\n<tr>\n<th scope=\"col\">国家/地区</th>\n<th scope=\"col\">百分比</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n<th scope=\"row\">\n法国\n</th>\n<td>\n<div class=\"d-flex align-items-center\">\n<span class=\"mr-2\" style=\"width:60px;\">28.36%</span>\n<div>\n<div class=\"progress\">\n<div class=\"progress-bar bg-gradient-danger\" role=\"progressbar\" aria-valuenow=\"0.01\" aria-valuemin=\"0\" aria-valuemax=\"100\" style=\"width: 28.36%;\"></div>\n</div>\n</div>\n</div>\n</td>\n</tr>\n<tr>\n<th scope=\"row\">\n哥伦比亚\n</th>\n<td>\n<div class=\"d-flex align-items-center\">\n<span class=\"mr-2\" style=\"width:60px;\">11.54%</span>\n<div>\n<div class=\"progress\">\n<div class=\"progress-bar bg-gradient-success\" role=\"progressbar\" aria-valuenow=\"0\" aria-valuemin=\"0\" aria-valuemax=\"100\" style=\"width: 11.54%;\"></div>\n</div>\n</div>\n</div>\n</td>\n</tr>\n<tr>\n<th scope=\"row\">\n墨西哥\n</th>\n<td>\n<div class=\"d-flex align-items-center\">\n<span class=\"mr-2\" style=\"width:60px;\">8.38%</span>\n<div>\n<div class=\"progress\">\n<div class=\"progress-bar bg-gradient-primary\" role=\"progressbar\" aria-valuenow=\"3.15\" aria-valuemin=\"0\" aria-valuemax=\"100\" style=\"width: 8.38%;\"></div>\n</div>\n</div>\n</div>\n</td>\n</tr>\n<tr>\n<th scope=\"row\">\n美国\n</th>\n<td>\n<div class=\"d-flex align-items-center\">\n<span class=\"mr-2\" style=\"width:60px;\">6.80%</span>\n<div>\n<div class=\"progress\">\n<div class=\"progress-bar bg-gradient-info\" role=\"progressbar\" aria-valuenow=\"58.36\" aria-valuemin=\"0\" aria-valuemax=\"100\" style=\"width: 6.79%;\"></div>\n</div>\n</div>\n</div>\n</td>\n</tr>\n<tr>\n<th scope=\"row\">\n秘鲁\n</th>\n<td>\n<div class=\"d-flex align-items-center\">\n<span class=\"mr-2\" style=\"width:60px;\">5.99%</span>\n<div>\n<div class=\"progress\">\n<div class=\"progress-bar bg-gradient-warning\" role=\"progressbar\" aria-valuenow=\"34.05\" aria-valuemin=\"0\" aria-valuemax=\"100\" style=\"width: 5.99%;\"></div>\n</div>\n</div>\n</div>\n</td>\n</tr>\n</tbody>\n</table>\n</div>\n</div>\n</div>\n</div>\n<link rel=\"stylesheet\" href=\"https://cdn.staticfile.org/jsvectormap/1.5.3/css/jsvectormap.min.css\">\n<br>\n<br>\n<br>\n\n<style>\n.table td .progress {\n    width: 120px;\n    margin: 0;\n}\n.progress {\n    height: 8px;\n    margin-bottom: 1rem;\n    overflow: hidden;\n    border-radius: 0.25rem;\n    background-color: #e9ecef;\n    box-shadow: inset 0 1px 2px rgba(0, 0, 0, 0.1);\n}\n.progress {\n    display: flex;\n    overflow: hidden;\n    font-size: 0.75rem;\n    background-color: #e9ecef;\n    border-radius: 0.375rem;\n    box-shadow: inset 0 0.1rem 0.1rem rgba(0, 0, 0, 0.1);\n}\n.bg-gradient-primary {\n  background: linear-gradient(87deg, #5e72e4 0, #825ee4 100%) !important;\n}\n.bg-gradient-secondary {\n  background: linear-gradient(87deg, #f7fafc 0, #f7f8fc 100%) !important;\n}\n.bg-gradient-success {\n  background: linear-gradient(87deg, #2dce89 0, #2dcecc 100%) !important;\n}\n.bg-gradient-info {\n  background: linear-gradient(87deg, #11cdef 0, #1171ef 100%) !important;\n}\n.bg-gradient-warning {\n  background: linear-gradient(87deg, #fb6340 0, #fbb140 100%) !important;\n}\n.bg-gradient-danger {\n  background: linear-gradient(87deg, #f5365c 0, #f56036 100%) !important;\n}\n.bg-gradient-light {\n  background: linear-gradient(87deg, #adb5bd 0, #adaebd 100%) !important;\n}\n.bg-gradient-dark {\n  background: linear-gradient(87deg, #212529 0, #212229 100%) !important;\n}\n.bg-gradient-default {\n  background: linear-gradient(87deg, #172b4d 0, #1a174d 100%) !important;\n}\n.bg-gradient-white {\n  background: linear-gradient(87deg, #fff 0, white 100%) !important;\n}\n.bg-gradient-neutral {\n  background: linear-gradient(87deg, #fff 0, white 100%) !important;\n}\n.bg-gradient-darker {\n  background: linear-gradient(87deg, black 0, black 100%) !important;\n}\n.bg-gradient-blue {\n  background: linear-gradient(87deg, #5e72e4 0, #825ee4 100%) !important;\n}\n.bg-gradient-indigo {\n  background: linear-gradient(87deg, #5603ad 0, #9d03ad 100%) !important;\n}\n.bg-gradient-purple {\n  background: linear-gradient(87deg, #8965e0 0, #bc65e0 100%) !important;\n}\n.bg-gradient-pink {\n  background: linear-gradient(87deg, #f3a4b5 0, #f3b4a4 100%) !important;\n}\n.bg-gradient-red {\n  background: linear-gradient(87deg, #f5365c 0, #f56036 100%) !important;\n}\n.bg-gradient-orange {\n  background: linear-gradient(87deg, #fb6340 0, #fbb140 100%) !important;\n}\n.bg-gradient-yellow {\n  background: linear-gradient(87deg, #ffd600 0, #beff00 100%) !important;\n}\n.bg-gradient-green {\n  background: linear-gradient(87deg, #2dce89 0, #2dcecc 100%) !important;\n}\n</style>\n<p><br>\n</p>'),
                                                                        (12,	0,	1,	'AI SEO长内容创作'),
                                                                        (13,	0,	1,	'AI内容营销和SEO助手'),
                                                                        (14,	0,	1,	'AI写作能手'),
                                                                        (15,	0,	1,	'<p>Copymatic是一个人工智能驱动的AI文案和内容创作工具，只需输入标题，即可在几秒钟内自动生成原创、吸引读者且高质量的文案或内容。无论是长篇博客文章，还是网站着陆页或是数字营销广告文案，Copymatic都可以胜任。</p>'),
                                                                        (16,	0,	1,	'<p>Neuraltext 是一款强大的撰写SEO友好的AI写作工具，可帮助用户以事半功倍的效率编写和发布高质量的 SEO 博客内容。除开SEO文章生成外，你也可以使用该工具来创建 Facebook 广告、时事通讯电子邮件、产品宣传、网页文案或几乎任何其他内容。</p>'),
                                                                        (17,	0,	1,	'AI SEO内容优化和写作工具'),
                                                                        (18,	0,	1,	'企业级和电商文案生成'),
                                                                        (19,	0,	1,	'释放你的写作潜力'),
                                                                        (20,	0,	1,	'你的个人写作助手和编辑'),
                                                                        (21,	0,	1,	'<p>Anyword是一个广受欢迎的AI文案写作助手和文本生成器，使用人工智能为各种专业需求创造具有吸引力的内容，超过100多万营销人员和世界知名公司都在使用。只需鼠标点击几下，就可以生成专业的高质量营销、创意或广告内容。</p>'),
                                                                        (22,	0,	1,	'<p>更新：遗憾，WPS智能写作最近已下线，访问其官网显示404错误。</p>'),
                                                                        (23,	0,	1,	'<p>ClosersCopy是一款人工智能写作软件，不同于其他AI写作软件，该工具并未使用GPT-3模型。ClosersCopy网站上写到，其他的模型没有接受过专门撰写营销文案的训练，而他们的模型有这方面的专门训练，使用其人工智能可以创作出真正的营销文案，用于销售产品和服务。</p>'),
                                                                        (24,	0,	1,	'<p>Sudowrite是一个人工智能写作工具，可以帮助你生成故事内容，或者将现有的文章改写润色成新的内容。</p>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/991b64176b3ddf8.jpeg\"  alt=\"Sudowrite官网\" width=\"800\" height=\"418\">\n<p>Sudowrite的主要两大特点：</p>\n<ul>\n<li>多种写作风格。Romance浪漫、Thriller惊悚、Mystery神秘、Horror恐怖、Sci-Fi科技、Non-fiction纪实、Fantasy幻想等7种风格。</li>\n<li>多种创作方式。\n<ul>\n<li>Write创作：人工智能助手建议新写的内容</li>\n<li>Describe描述： 更详细地了解和描述某个特定领域</li>\n<li>Rewrite重写： 如果你不喜欢某个故事的结果，你可以重写</li>\n<li>Brainstomr集思广益： 当你没有写作灵感和想法的时候，可以使用头脑风暴</li>\n<li>Twist组合：不同方式的混合</li>\n<li>Characters角色： 为你构思新的故事角色</li>\n<li>Poem诗歌： 生成一首当代自由诗</li>\n</ul>\n</li>\n</ul>\n<p>Sudowrite全方位地帮助你创作故事内容，让你轻松自由地写作引人入胜的故事和小说。</p>'),
                                                                        (25,	0,	1,	'AI博客和文章一键生成'),
                                                                        (26,	0,	1,	'<p>Compose AI是一个免费的Chrome插件，基于人工智能的技术，可以加快你的写作速度，让你在任何网页使用自动完成和补全输入，减少你的打字时间。该插件可永久免费使用，还有一个高级版本，具有一些高级的个性化功能。</p>'),
                                                                        (27,	0,	1,	'高质量AI内容生成'),
                                                                        (28,	0,	1,	'<p>快文CopyDone是由必优科技推出的国内首个专注于AI营销创作的神器，该工具专注于营销内容的生成，用AI化的内容创作模式，让产品营销看得见，有效提升内容创作者的工作效率。</p>\n<p>该工具目前提供了3种模式的营销内容创作：</p>\n<ul>\n<li>AI营销文案。智能生成海量营销文案，可适应国内及海外各类营销平台风格，覆盖丰富的产品类型，一键可得海量文案及创作灵感</li>\n<li>AI营销配图。文案配图难，想要创新又担心侵权风险？使用AI营销配图，智能理解文案核心内容，实时生成文案配图，独一无二，复制即可用</li>\n<li>AI营销视频。CopyDone整合了文字、图片、音视频多模态内容智能生成能力，只需几分钟，即可在线生成短视频，适用于抖音、快手等多平台推广</li>\n</ul>'),
                                                                        (29,	0,	1,	'AI阅读总结、写作和内容生成助手'),
                                                                        (30,	0,	1,	'AI快速写作工具'),
                                                                        (31,	0,	1,	'<p>讯飞智检是科大讯飞旗下开放平台推出的一款人工智能写作、校对/合规审查的智能产品，可帮助用户进行AI智能文本纠错，支持对纯文本、Word、图片、音频、视频进行批量审查。在节省人工审核成本的同时，大大提升了总体审核效率，拦截文本中出现的拼写、语法、搭配、实体、标点、敏感用语及数字使用错误的问题。</p>'),
                                                                        (32,	0,	1,	'<p><a href=\"https://vgoapp.com/?ref=ai-bot.cn\" target=\"_blank\" rel=\"noopener nofollow\" class=\"external\">字符狂飙</a>是一款基于AI技术的全方位文档生成工具，能够帮助您快速生成各类专业文档。与传统的文档生成工具相比，字符狂飙更加快速、简便，让您节省时间和精力，专注于更重要的事情。从文案编辑到创意内容，从Email自动生成到公司运营，它都能满足您的各种需求。</p>\n<h2>字符狂飙功能介绍</h2>\n<p>字符狂飙拥有完整的内容向导，支持多种文档类型，如商业计划书、个人简历、诗词、视频脚本、blog文章、广告投放内容、演讲稿、ppt框架、新闻报道、Email自动生成等。您只需填写表单，即可快速生成各种文档。同时，它还拥有多项功能操作，包括文案编辑、翻译、内容纠错改进、摘要总结、关键词提取、内容丰富、产品起名、关键词优化、产品描述、产品评价、广告投放脚本、说明书、公司简介、招聘描述、面试问题、代码生成、改错、解读、代码文档、合同、法律顾问、作业解答、写作文、周公解梦、虚拟医生等。无论您是企业的市场部、销售部，还是个人的生活学习，它都能帮助您轻松生成专业的文档。</p>\n<h2>字符狂飙产品亮点</h2>\n<p>字符狂飙支持多用户管理，适合企业的所有员工使用。当您选中文本后，还能为您提供二次编辑操作，如翻译、纠错、摘要、丰富内容等，同时也可以生成一段新的想法。字符狂飙的强大AI技术，可以识别您的需求并帮助您生成专业、准确的文档。而且，字符狂飙使用了敏感词过滤功能，以防止用户在应用程序中发送包含色情或政治等内容的请求。无论您是商务人士、学生，还是个人，它都是您的理想选择。</p>\n<p>字符狂飙是一款多功能的AI文档生成产品，适用于各种生活和工作场景。如果您需要快速生成商业计划书、个人简历、产品说明书或公司简介等文档，字符狂飙可以为您提供完整的内容向导，从而让您省去繁琐的文档生成过程。</p>\n<p>此外，如果您是一名市场人员、销售人员或运营人员，WordFury也可以帮助您生成广告投放内容、产品描述、产品评价和电商说明书等各种内容。如果您是一名学生或教育工作者，字符狂飙可以帮助您解答作业、写作文、制作PPT或周公解梦等。</p>\n<p>如果您是一名程序员或法律从业者，字符狂飙可以帮助您生成代码文档、法律文书和合同等文档。此外，如果您需要解决电子邮件回复、开发新客户或推广邮件等工作中的问题，字符狂飙也可以帮助您生成自动化的邮件内容。</p>\n<p>无论您是在生活还是在工作中，字符狂飙都可以为您提供准确、专业和高效的文档生成服务，让您更轻松地完成各种任务。</p>\n<h2>字符狂飙产品优势</h2>\n<ul>\n<li>完整的内容向导: 字符狂飙提供了多种文档类型的生成，包括商业计划书、个人简历、广告投放脚本等等。通过结构化的表单提问，字符狂飙可以帮助您生成各种文档，让您的文档始终保持专业和准确。</li>\n<li>强大的AI技术: 字符狂飙采用最先进的AI技术，可以识别您的需求并帮助您生成专业的文档。通过支持文案编辑功能，包括翻译、内容纠错改进、摘要总结、关键词提取、内容丰富，创意内容生成等多种功能，让您的文档更加富有创意和专业性。</li>\n<li>多种使用场景: 字符狂飙可以用于多种场景，如商务文书、教育、生活、编程、法律等领域。通过支持多种文档类型和场景，字符狂飙为您的工作、学习和生活带来更多便利。</li>\n<li>支持多用户管理: 字符狂飙适合企业的所有员工使用，如市场部、销售部等。字符狂飙支持多用户管理，可以让您的团队成员快速地生成专业的文档，提高工作效率。</li>\n<li>二次编辑: 在使用字符狂飙生成文档后，您可以选中文本并进行二次编辑，如翻译、纠错、摘要、丰富内容等功能操作，同时也可以生成一段新的想法，让您的文档更加优秀。</li>\n</ul>\n<p>通过以上优势，字符狂飙为您提供了一个完整的文档生成解决方案，让您在工作、学习和生活中更加便捷和高效。</p>'),
                                                                        (33,	0,	1,	'<p><a href=\"https://aiapp.cc/?ref=ai-bot.cn\" target=\"_blank\" rel=\"noopener sponsored\" class=\"external\">创作王</a>是一款功能强大的AI智能创作软件，具有智能回答、创作、编写、翻译、写代码等多种功能，可以满足用户生活和工作的多方面需求。该应用程序采用AI技术，内置ChatGPT，具有智能化的聊天服务，能够帮助用户快速完成文字创作、翻译等任务，提高创作效率。</p>\n<a href=\"https://aiapp.cc/?ref=ai-bot.cn\" rel=\"noopener sponsored\" target=\"_blank\"><img  width=\"800\" height=\"247\" class=\"alignnone size-full\" src=\"/uploadfile/202312/120ff847c3f2c9d.jpeg\"  alt=\"AI创作王Banner\"></a>\n<p>创作王提供了许多强大的功能，包括周报生成器、邮件小助手、阅读小助手、塔罗牌预测神器、餐厅点评神器、商品点评神器、小红书创作神器、英文写作、解梦神器、SWOT分析法、节日祝福、夸夸神器、知乎问答神器等。这些功能都是根据用户的生活和工作需要而设计的，可以帮助用户更加高效地完成各种任务。 除此之外，创作王还会不断更新，增加更多实用的功能，让用户能够更好地利用AI技术提高创作效率。如果你正在寻找一款多功能、智能化的聊天软件，那么创作王绝对是你不可错过的选择。</p>'),
                                                                        (34,	0,	1,	'Giiso写作机器人，内容创作AI辅助工具'),
                                                                        (35,	0,	1,	'新媒体AI内容创作助手'),
                                                                        (36,	0,	1,	'AI改写、纠错、润色辅助工具'),
                                                                        (37,	0,	1,	'国内团队推出的智能AI写作工具'),
                                                                        (38,	0,	1,	'AI驱动的文字生产力工具'),
                                                                        (39,	0,	1,	'<p>智能创作助手「文涌 Effidit」（Efficient and Intelligent Editing）是由腾讯 AI Lab 开发的一个研究性原型系统，探索用 AI 技术提升写作者的写作效率和创作体验。该智能创作助手提供智能纠错、文本补全、文本改写、文本扩写、词语推荐、句子推荐与生成等功能，可帮助用户轻松完成中英文写作，提高写作效率。</p>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/24725c36a2aebb4.png\"  alt=\"Effidit AI写作助手\" width=\"800\" height=\"450\">\n<h2>Effidit的主要功能</h2>\n<ol>\n<li>智能纠错：支持中英文纠错，可自动检测输入文本中的错别字、拼写错误、语法错误，并提供修改建议</li>\n<li>文本补全：提供短语补全、句子补全，根据上下文内容智能检索并生成和补全逻辑通顺且完整的段落句子</li>\n<li>文本续写：可根据用户输入的前缀和选择的风格进行续写，协助创作风格鲜明、妙趣横生的新内容</li>\n<li>文本润色：选中某个词语或句子，智能推荐更加贴合语境相似候选词或换个说法智能改写句子</li>\n<li>超级网典：根据所输入的关键词，推荐近义词、反义词、同类词、修饰词、相关实体等</li>\n</ol>\n<h2>常见问题</h2>\n<div id=\"accordion\" style=\"max-width: 700px;\">\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>Effidit是免费的吗？</strong></div>\n<div class=\"card-body text-sm\">Effidit是腾讯AI Lab推出的免费AI写作助手，无需登录注册，且可以免费使用。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>Effidit支持哪些平台使用？</strong></div>\n<div class=\"card-body text-sm\">Effidit目前支持Windows客户端、网站在线访问以及微信小程序使用，Mac端即将推出。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>Effidit基于什么大模型？</strong></div>\n<div class=\"card-body text-sm\">Effidit 的实现融合了知识抽取、文本理解、文本生成、大规模预训练模型、经典语言模型、搜索等技术。其中，部分功能的实现使用「混元」系列 AI 大模型作为底层预训练模型。</div>\n</div>\n</div>'),
                                                                        (40,	0,	1,	'阿里旗下智能文案工具，一键生成电商营销文案'),
                                                                        (41,	0,	1,	'<p>Typeface（typeface.ai）是一个专注于为企业提供AI内容创作服务的平台，可以根据客户的品牌量身定制和创建个性化的内容。</p>\n<p> </p>'),
                                                                        (42,	0,	1,	'AI写作助手帮助你创作内容更自信'),
                                                                        (43,	0,	1,	'高颜值AI内容营销创作工具'),
                                                                        (44,	0,	1,	'<p>NovelAI 是一个在线AI内容和故事创作工具，提供人工智能辅助写作、讲故事、虚拟伴侣服务，或者仅仅是一个由GPT驱动的背景沙盒。</p>\n<p>Novel AI 先进的人工智能算法可以辅助内容创作者创造出类似人类的写作，使任何人（无论其写作能力如何），都能创作出高质量的文学作品。Novel AI 通过使用自研的人工智能模型，在真实的文学作品上进行训练，为其自然语言处理提供了前所未有的自由度。</p>'),
                                                                        (45,	0,	1,	'Canva旗下AI文案生成器'),
                                                                        (46,	0,	1,	'<p>彩云小梦是由彩云科技（彩云天气和彩云小译背后的团队）推出的一个智能写作AI助手，你只需提供一个开头，AI 就会帮你创作故事。你可以自由定义故事的背景和世界设定，并扮演其中的角色，与其他角色聊天。你还可以在小梦的世界广场，选择感兴趣的世界，扮演自己喜爱的角色，与此同时，你也可以把自己创作的世界贡献到小梦世界广场，与别人一起体验你创作的世界和角色。另外你可以使用其AI续写功能，让你续写你喜欢的小说和故事，提供不同版本的续写风格。目前彩云小梦提供了网页版和移动端的APP，你可以选择对应的终端访问。</p>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/132f71142921984.png\"  alt=\"彩云小梦的故事\" width=\"808\" height=\"426\">'),
                                                                        (47,	0,	1,	'<p>度加创作工具是由百度出品的、人人可用的AIGC创作工具网站。度加致力于通过AI能力降低内容生产门槛，提升创作效率，一站式聚合百度AIGC能力，引领跨时代的内容生产方式。度加的主要功能包括AI成片（图文成片/文字成片）、AI笔记（智能图文生成）、AI数字人等。</p>\n<p>自2022年3月百家号开放内测以来，一年时间共计超过45万+百度创作者使用AIGC技术能力，创作700万篇+作品，百度累计分发量超过200亿+。</p>\n<h2>度加创作工具的主要功能：</h2>\n<ol>\n<li><strong>AI 成片</strong>。创作者输入文本或者选择百家号的图文，即可由 AI 自动一键制作视频。在娱乐、科技、社会、资讯等领域，文字成片的效果几乎不逊于剪辑师创作，而且速度更快，产量更高，质量更稳定。</li>\n<li><strong>AI笔记</strong>。创作者输入文本，AI 可以对已有文案进行润色、提炼与改写；创作者输入关键词，AI 可以根据关键词为用户制作文案，包括标题和正文，满足日常分享、营销推广、博主种草、知识输出等各类创作需求。<br>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/4538e58cbd573e7.png\"  alt=\"度加创作工具AI笔记\" width=\"800\" height=\"438\"></li>\n<li><strong>AI数字人</strong>。数字人功能拥有 50+ 数字人模型，创作者可以在百度 AIGC 数字人超市中找到想要的数字人形象，并方便地应用到自己的视频创作中。未来，百度 AIGC 创作平台还将上线“声音克隆”和“数字孪生”等 AI 功能，让每个人都有能低成本拥有自己的“短视频数字人分身”。</li>\n</ol>'),
                                                                        (48,	0,	1,	'<p>Cohesive是一个人工智能文案内容创作工具，旨在帮助创建、完善、编辑和发布各种类型的文案内容。该工具为不同类型的内容提供了50多个模板，如SEO友好型博客、LinkedIn帖子、吸引人的故事、Instagram标题、Twitter推文和演示幻灯片。</p>\n<p>Cohesive在多个领域都有应用，如营销、销售、支持和个人使用，并向用户保证高质量的人工智能生成的内容。Cohesive还提供了一个人工智能编辑器，帮助用户编辑文本、图像和语言翻译，以确保内容的准确度、吸引力和转化率。</p>'),
                                                                        (49,	0,	1,	'<p>Moonbeam是一款经过专门训练的人工智能写作助手，可以帮助你撰写论文、故事、文章、博客和其他长篇内容。该工具免费版提供30,000个单词的额度，付费版Pro 15 美金每月。</p>'),
                                                                        (50,	0,	1,	'<p>Verse是印象笔记团队推出的类似于Notion的模块化文档写作工具，目前Verse已接入了「印象AI」的能力，成为即开即用、全平台覆盖的新一代AI写作工具。你可以将Verse作为你的工作台、知识库，甚至是云大脑，使用Verse灵感自动产生，文章一键生成，创作领先一步。</p>\n<h2>Verse主要的AI功能</h2>\n<ol>\n<li>使用简单，生成快速。用户只需在页面中点击「AI帮我写」，然后输入想要创作的标题即可快速生成文字内容</li>\n<li>多种场景内容智能生成。会议纪要、公文假条、小说作文、工作日报、新闻稿、广告创作等等高效产出</li>\n<li>已有内容修改和编辑。除开生成文本外，你还可以使用Verse来修复拼写和语法、简化语言、原有内容续写、翻译和解释等</li>\n</ol>\n<h2>如何使用Verse AI写作</h2>\n<ol>\n<li>访问Verse AI写作的官网，点击立即体验按钮</li>\n<li>使用微信扫描二维码登录/注册你的印象笔记账号</li>\n<li>登录成功后，Verse会自动跳转到工作台界面</li>\n<li>点击AI帮我写，选择AI写作场景并输入简要的文本描述即可</li>\n</ol>\n<img  class=\"alignnone\" src=\"/uploadfile/202312/64b1db1d66582df.png\"  alt=\"Verse AI写作\" width=\"700\" height=\"499\">\n<h2>Verse的AI功能是免费的吗</h2>\n<p>目前Verse给每位用户提供了每天免费进行20次的生成次数，支持桌面端和网页端使用，手机端App的AI功能暂未上线</p>'),
                                                                        (51,	0,	1,	'<p>爱创作是国内知名的新闻平台「ZAKER」推出的AI内容创作工具，可帮助用户一键生成文章、营销文本、配图与短视频等多类型内容。</p>\n<h2>爱创作的主要功能</h2>\n<ol>\n<li>突破AI上线文长度限制，让AI创作出你真正想要的文章。ZAKER 独创的投喂海量背景材料，让AI真正读懂你的需求，从而写出更专业、更有细节的文案；</li>\n<li>专业的写稿创作训练，通过海量的专业稿库微调，让AI更懂中文、更懂媒体。用户可在写作时进行角色的设定（如专业财经记者、新闻记者、资深汽车编辑、小红书文案高手、营销大师等）、情绪选择（中立、积极正面、消极负面）和输出语种（目前支持中文和英语）的选择；</li>\n<li>覆盖场景广，一键解决个性场景创作、营销需求，生成各行业风格文章、专业营销文案、爆品产品文案、热门推广文案、长短视频文案、电商促销文案等。</li>\n</ol>\n<h2>如何使用爱创作</h2>\n<p>爱创作的操作非常简单，用户只需要几个步骤便可以使用该AI写作工具进行内容创作：</p>\n<ol>\n<li>访问爱创作的官网然后登录/注册账号</li>\n<li>登录成功后，爱创作会自动跳转到写作的工作台</li>\n<li>在左侧的区域输入文章主题、背景材料等</li>\n<li>在右侧的区域选择角色、文风、分析理论模型、情绪、输出语言等选项</li>\n<li>设置完毕后，点击蓝色的开始按钮即可实时生成内容</li>\n</ol>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/f17c6690eaa2603.png\"  alt=\"如何使用爱创作AI\" width=\"800\" height=\"450\">\n<h2>爱创作的产品价格</h2>\n<p>目前用户可以免费使用爱创作进行AI写作，该工具提供免费20次的内容创作次数。</p>'),
                                                                        (52,	0,	1,	'<p>WriteWise是国内知名的听书和播客平台喜马拉雅旗下的团队推出的一款专业的 AI 小说和网文创作工具，可以为作者提供灵感、参考、思路，提升写作效率，赋能与提效网文小说创作的全流程。</p>\n<img  class=\"alignnone size-full rounded shadow-sm\" src=\"/uploadfile/202312/848cbc5486b6eee.png\"  alt=\"WriteWise AI写作\" width=\"800\" height=\"450\">\n<h2>WriteWise的主要功能</h2>\n<ol>\n<li>AI创作辅助：提供情节描述、内容改写和基于前置内容改写段落</li>\n<li>AI作品设定：提供故事更改和小说世界观设定的灵感指导</li>\n<li>AI修稿纠错：可智能检测文稿内容，定位文章的错别字、不通顺语句和敏感词</li>\n<li>AI快速取名：可根据长度提供人物、地点、势力、招式、装备、怪物、道具等名字的设定</li>\n<li>AI写作助手：内置AI写作对话助手，可询问任何关于创作的问题</li>\n<li>专业的编辑工具：提供稳定可靠、云同步、不丢稿的编辑器，支持丰富的格式配置</li>\n</ol>\n<h2>如何使用WriteWise</h2>\n<ol>\n<li>访问WriteWise的官网，点击体验网页版（你也可以下载对应Windows和Mac平台的客户端）</li>\n<li>登录/注册你的喜马拉雅账户，登录成功后会自动跳转到作品管理界面</li>\n<li>选择新建作品或点击示例作品，在编辑页面按下Esc键可智能唤起AI助手</li>\n<li>选择AI帮你写或者AI写作素材，然后输入相应提示词即可智能生成文章内容</li>\n</ol>\n<h2>常见问题</h2>\n<div id=\"accordion\" style=\"max-width: 700px;\">\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>WriteWise支持哪些客户端和平台？</strong></div>\n<div class=\"card-body text-sm\">WriteWise目前支持在线网页端、Windows和Mac桌面端使用。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>WriteWise基于什么大模型？</strong></div>\n<div class=\"card-body text-sm\">WriteWise使用了基于深度学习的大型语言模型来辅助创作，该模型通过训练大量的文本数据集而生成的，包括小说、文章、新闻等。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>WriteWise是免费的吗？</strong></div>\n<div class=\"card-body text-sm\">WriteWise目前处于免费测试阶段，所有用户和作家都可以免费使用该平台。</div>\n</div>\n</div>'),
                                                                        (53,	0,	1,	'<p>写作蛙是由智谱AI推出的免费智能写作工具，可帮助用户快速高效地生成AI原创的高质量内容创意和各种文本任务，如文章、报告、新闻稿、营销文案等。</p>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/0a288842bf97635.png\"  alt=\"写作蛙AI写作工具\" width=\"800\" height=\"450\">\n<h2>写作蛙的功能</h2>\n<ol>\n<li>全面的文章创作辅助功能，包括全文生成、文章摘要生成、文章润色、风格仿写、文本续写、段落生成等功能</li>\n<li>智能问答和妙问妙答，输入想要了解的问题，写作蛙即可回复你有趣又有料的答案</li>\n<li>不同用途和体裁的文章生成，如小红书文案生成、现代诗歌创作、长篇作文创作等</li>\n</ol>\n<h2>如何使用写作蛙</h2>\n<p>写作蛙提供网页版和微信小程序版，用户可访问其官网 littlefrog.ai 或微信搜索写作蛙使用其小程序，登录/注册后即可免费使用其AI创作功能。</p>'),
                                                                        (54,	0,	1,	'<p>有道写作是网易有道推出的智能英文写作修改和润色工具，该神器可以智能识别100多种错误类型，包括词组搭配、时态、主谓宾搭配等。用户可以在Web端、移动端、Windows客户端以及Word中使用有道写作产品。</p>\n<h2>有道写作的产品亮点</h2>\n<ul>\n<li>权威的批改体系，以确保语法的准确性、语言风格的得体性、造句的多样性和句意的清晰度。</li>\n<li>基于国人的英语写作习惯，面向国人的母语级润色，支持中英双语写作，助力文章一气呵成。</li>\n<li>支持手写文章，拍照上传。有道写作结合有道词典APP，手写英文习作拍照上传，图片转文字，快速批改。</li>\n<li>支持多场景写作。批改体系覆盖小初高、四六级、考研、雅思、托福、学术论文等多种写作类型，为你提供全面指导。</li>\n</ul>'),
                                                                        (55,	0,	1,	'<h2>深言达意是什么？</h2>\n<p>深言达意是一款免费的词句查询智能写作辅助工具，由清华大学自然语言处理实验室和智源研究院孵化的人工智能初创公司深言科技研发推出。这款工具融合了此前该团队推出的WantWords反向词典和WantQuotes据意查句两款神器进行了整合升级，支持据意查词、据意查句、语料查询等多种功能。基于强大的自然语言理解和机器学习算法能力，只需输入模糊描述，深言达意便能快速找到合适贴切的用词用句，助力创作者文思泉涌，妙笔生花。</p>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/117c98beac8fe97.png\"  alt=\"深言达意据意查句\" width=\"800\" height=\"414\">\n<h2>深言达意的主要功能</h2>\n<ol>\n<li>据意查词：输入想表达的意思，快速找到恰当用词</li>\n<li>词汇检索：一键查询词语的释义、近义词、反义词、联想词等</li>\n<li>据意查句：输入想表达的意思和描述，找到相关名句</li>\n<li>字符找句：输入任意字符，查看包含该字符的好句</li>\n<li>查找作者：输入作者名，找该作者的创作</li>\n<li>查找作品：输入作品名，找作品中的好句</li>\n</ol>\n<h2>深言达意的语料类别</h2>\n<ol>\n<li>查找词语支持查询词、成语、惯用语，并可根据词性如名词、动词、形容词、副词等筛选</li>\n<li>查找句子支持查询现代、古诗文、熟语、对联等类别：\n<ol>\n<li>现代文：名言、小说和散文、现代诗、网络、影视剧、综艺、动漫、歌词</li>\n<li>古诗文：诗、词、曲、文言文</li>\n<li>熟语：谚语、惯用语、歇后语</li>\n</ol>\n</li>\n</ol>\n<h2>常见问题</h2>\n<div id=\"accordion\" style=\"max-width: 700px;\">\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>深言达意是免费的吗？</strong></div>\n<div class=\"card-body text-sm\">深言达意是免费开放使用的，用户无需登录注册和付费即可使用其功能。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>深言达意支持英文吗？</strong></div>\n<div class=\"card-body text-sm\">深言达意提供双语查询，支持任意输入中文或英文。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>深言达意有APP吗？</strong></div>\n<div class=\"card-body text-sm\">深言达意目前暂未推出APP应用，只能通过其官网shenyandaiyi.com使用。</div>\n</div>\n</div>'),
                                                                        (56,	0,	1,	'<h2 class=\"invisible\">魔撰写作是什么？</h2>\n<p>魔撰写作是人工智能公司出门问问继全网爆火的AI配音软件「<a href=\"https://ai-bot.cn/sites/1924.html\">魔音工坊</a>」之后出的AI写作助手，轻松帮你遣词造句、润色文采、改写文风、提取文案、校对文案、收藏笔记、搜索字词，更有多语种翻译等众多AI创作功能。通过该AI写作平台，可以极大地解放人力，激发创作灵感，让你文采更上一层楼。</p>\n<img  class=\"alignnone size-full rounded shadow-sm\" src=\"/uploadfile/202312/98322d44eb63d28.jpeg\"  alt=\"魔撰AI写作\" width=\"800\" height=\"450\">\n<h2>魔撰写作的主要功能</h2>\n<ol>\n<li>一键智能生成高质量内容，输入文章标题，选择语气风格，简单几步即可生成专业文案内容</li>\n<li>胜任多种创作场景，可帮助用户进行新闻报道、科技文章、商业分析、学术论文等多种类型的文章</li>\n<li>改写润色智能辅助创作，支持选择文本进行智能润色、改写、校对、替换，让你遣词造句更精准</li>\n<li>音视频文案快速提取，支持将音视频文件或在线短视频转换为文本内容，准确率高</li>\n<li>内置丰富的AI写作模板，包括营销文案、短视频脚本、新媒体运营、电商产品描述等</li>\n</ol>\n<h2>魔撰写作的产品价格</h2>\n<p>魔撰写作提供免费基础版版和付费专业版本，付费版会员的价格如下：</p>\n<ol>\n<li>月会员47.6元每月（原价68元，打7折）</li>\n<li>半年会员244.8元（原价408元，打6折）</li>\n<li>年度会员326.4（原价816元，打4折）</li>\n</ol>\n<h2>魔撰写作的使用方法</h2>\n<ol>\n<li>访问魔撰写作的官网（x.moyin.com），点击立即体验或者右上角的头像登录/注册</li>\n<li>登录成功后会自动跳转到工作台界面，点击新建文档或者选择AI模板</li>\n<li>在对应模板的输入框填写你想要的内容，然后点击开始生成即可开始AI写作</li>\n<li>你也可以在文档编辑区唤起魔撰AI进行续写改写等操作</li>\n</ol>\n<h2>常见问题</h2>\n<div id=\"accordion\" style=\"max-width: 700px;\">\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>魔撰写作提供免费试用吗？</strong></div>\n<div class=\"card-body text-sm\">魔撰写作提供免费体验版，免费版拥有基础的写作辅助能力，享有字数限制下的AI写作、智能润色、实时纠错、句子修辞、文本翻译等部分功能，可满足轻量级的写作需求。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>魔撰写作基于什么大模型？</strong></div>\n<div class=\"card-body text-sm\">魔撰写作基于出门问问自研的大型语言模型“序列猴子”。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>魔撰写作支持哪些平台？</strong></div>\n<div class=\"card-body text-sm\">魔撰写作支持通过浏览器网页版和微信小程序平台使用。</div>\n</div>\n</div>'),
                                                                        (57,	0,	1,	'<p>奇妙文是由出门问问推出的一个AI写作助理，可以帮助用户快速进行市场营销、职场办公、新媒体、创意写作等类型的智能内容创作。奇妙文灵活简洁的编辑模式支持续写、改写、扩写、缩写、提炼要点、风格转换、纠错、翻译八大 AI 写作功能，用户可以在写作过程中一键唤醒 AI 帮助自己创作，并且还能在写作中让 AI 自动生成图片，真正做到图文并茂、文思泉涌。</p>\n<h2>奇妙文的主要功能</h2>\n<ol>\n<li>AI内容编辑：支持AI续写、改写、风格转换、文本翻译、纠错等能力，让创作更加得心应手</li>\n<li>语言理解和生成：理解、分析输入文本及其情感色彩，基于上下文和相关知识生成自然语言文本</li>\n<li>对话交互：具备数据安全保护、应急响应、权限管理机制，迅速做出问题应对和措施防范</li>\n<li>支持多国语言：处理多语言文本输入并生成相应输出，包括但不限于中、英、德、法、日文等语种</li>\n</ol>\n<h2>奇妙文的产品价格</h2>\n<ol>\n<li>按会员制订阅：月会员68元（折扣价40.8元），半年会员408元（折扣价204元），年度会员816元（折扣价326.4元），每月可使用15万字的AI写作字数</li>\n<li>开通会员后，若字数消耗完可购买字数补给包，价格为：5万字29元、30万字89元、100万字199元</li>\n</ol>\n<h2>常见问题</h2>\n<div id=\"accordion\" style=\"max-width: 700px;\">\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>奇妙文基于什么大模型？</strong></div>\n<div class=\"card-body text-sm\">奇妙文基于人工智能公司出门问问推出的「序列猴子」大模型，并已通过《生成式人工智能服务管理暂行办法》备案。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>奇妙文是免费的吗？</strong></div>\n<div class=\"card-body text-sm\">奇妙文提供免费体验版会员，过期后则需开通会员才可继续使用AI创作。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>奇妙文支持内容导出吗？</strong></div>\n<div class=\"card-body text-sm\">奇妙文支持将AI创作的内容以Word的格式导出和下载，方便二次编辑。</div>\n</div>\n</div>'),
                                                                        (58,	0,	1,	'<h2>星火内容运营大师是什么？</h2>\n<p>星火内容运营大师（又名“TurboDesk”）是科大讯飞推出的一款专为内容运营工作者打造的的免费AI智能写作平台，基于讯飞星火认知大模型的强大AI创作能力，星火内容运营大师支持热门选题推荐、海量选题生成、文章一键生成、一键排版、AI生成配图等功能，可结合热点、节日、文章、图片材料，一键生成运营文章，帮您释放创意，让内容创作更轻松。</p>\n<p>星火内容运营大师<span class=\"ne-text\">致力为内容运营工作者打造一个可人机协同运营的工作台，</span>辅助完成内容运营过程中的信息收集整理、运营等重复性工作，让运营能够专注高效，释放创意。</p>\n<img  src=\"/uploadfile/202312/8e8c223ec9f0bd9.png\"  alt=\"星火内容运营大师\" width=\"800\" height=\"434\" class=\"alignnone size-full rounded-lg shadow-sm\">\n<h2>星火内容运营大师的主要功能</h2>\n<ol class=\"text-md\">\n<li>AI选题推荐：AI智能生成标题，紧跟热点，激发创作灵感</li>\n<li>AI文章创作：输入主体，AI一键写稿，还支持模仿生成和选择风格生成</li>\n<li>AI审查校对：提供校对文本、审查纠错、合规风险提示等功能，让创作者能够更加专注于内容的创作</li>\n<li>AI配图排版：AI根据关键词生成图片，一键排版，图文并茂</li>\n<li>多平台内容分发：支持分发到今日头条和微信公众号，并可监测数据</li>\n</ol>\n<h2>星火内容运营大师的适用人群</h2>\n<ol class=\"text-md\">\n<li>自媒体从业者：自动生成文章大纲和初稿，并且可多渠道分发，帮助自媒体从业者节省时间和精力</li>\n<li>新闻媒体记者：紧跟热点选题，帮助媒体记者快速找到合适的素材，提高报道效率</li>\n<li>文案策划人员：为文案策划提供丰富的创意灵感来源和有针对性的优化建议</li>\n<li>文字爱好者：帮助文字爱好者提升写作技巧、找到新的写作方向和主题和丰富写作素材</li>\n</ol>\n<h2>如何使用星火内容运营大师</h2>\n<ol class=\"text-md\">\n<li>访问星火内容运营大师的官网（turbodesk.xyfun.cn），点击下载Windows/macOS版本客户端</li>\n<li>下载安装软件后，打开软件界面，使用手机号或微信扫码注册登录，填写信息，获取使用资格</li>\n<li>进入软件界面点击选题目进行内容选题、点击写内容进行AI起稿</li>\n<li>文字内容创作完毕后，还可点击AI插图、AI审查和AI排版丰富和整理文章</li>\n<li>最后可预览效果，可分发到绑定好的媒体平台</li>\n</ol>\n<h2>常见问题</h2>\n<div id=\"accordion\" style=\"max-width: 700px;\">\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>星火内容运营大师是免费的吗？</strong></div>\n<div class=\"card-body text-sm\">星火内容运营大师目前是完全免费向用户开放的，暂未推出付费版本。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>星火内容运营大师支持哪些系统？</strong></div>\n<div class=\"card-body text-sm\">星火内容运营大师支持Windows和macOS客户端。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>星火内容运营大师基于什么大模型？</strong></div>\n<div class=\"card-body text-sm\">星火内容运营大师基于科大讯飞自研的「星火认知大模型」。</div>\n</div>\n</div>'),
                                                                        (59,	0,	1,	'<p>Jenni AI 是一款功能强大的 AI 写作工具，可帮助用户创建引人入胜且信息丰富的内容。无论你是需要撰写研究论文、博客文章、社交媒体标题、产品描述还是任何其他类型的文本，Jenni AI 都可以在几分钟内生成高质量的内容，从而帮助你节省时间和精力。</p>\n<h2>Jenni AI 的主要功能</h2>\n<p>Jenni AI 写作有一些独特的功能，任何人都可以轻松学习并提高写作效率。</p>\n<ul>\n<li>AI Autocomplete：当你没有想法或创意时，Jenni 会使用人工智能为你自动完成句子。如果你一直按向右箭头，将不断生成更多信息。</li>\n<li>抄袭检查：Jenni 具有集成的抄袭检查器，你可以使用该功能检测内容是否已经在线发布。</li>\n<li>自动添加引用：激活此功能后，引用将自动出现在相关文档文本中。支持所有主要的引文风格，包括 APA、MLA、Harvard 等。</li>\n<li>修改重写：你可以使用 Jenni 的内置文本转换功能轻松扩展、解释、润色和修改文本。</li>\n</ul>\n<h2>如何使用 Jenni AI</h2>\n<p>使用 Jenni AI 非常简单，只需几个步骤便可以开始你的 AI 创作之旅：</p>\n<ol>\n<li>访问 Jenni AI 的官网。</li>\n<li>单击右上角的 Start writing for free 按钮或Log in登录开始免费试用。</li>\n<li>输入你的邮箱密码进行登录或注册账号</li>\n<li>选择你的身份（学生、内容创作者），以个性化你的用户体验。</li>\n<li>键入你要写的文章话题，点击 Start writing 按钮开始写作</li>\n<li>然后 Jenni AI 便会自动生成一个文档并跳转到该页面，通过单击右箭头，你可以继续生成有关该主题的句子。此外，你还可以使用 AskJenni 根据给定的提示生成文本。</li>\n</ol>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/a4b2a3273588565.png\"  alt=\"如何使用Jenni AI\" width=\"800\" height=\"508\">\n<h2>Jenni AI 的价格</h2>\n<p>Jenni AI 目前主要提供两种定价计划，一个是Free免费版本，一个是Unlimited付费版本：</p>\n<ul>\n<li>Free免费版本允许用户每天生成200个AI单词，使用AI自动完成、添加新闻或网络来源引用、AI编辑指令等功能。</li>\n<li>如果用户选择Unlimited付费版本则可以使用AI生成无限制版本的文字，Unlimited版本的价格是选择月付的话，20美元一个月，选择年付的话则是12美元一个月（即144美元一年）。</li>\n</ul>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/211419e420e151a.png\"  alt=\"Jenni AI的价格\" width=\"800\" height=\"450\">'),
                                                                        (60,	1,	1,	'<p>Coda AI 是在线文档协作平台 Coda （Notion的竞争对手之一）推出的 AI 写作和文档助手，类似于 <a href=\"https://ai-bot.cn/sites/189.html\">Notion AI</a>，该 AI 助手可以起草文章内容、生成表格、查找信息、分析数据、会议纪要总结等，以帮助用户自动化工作流程，提高办公效率。</p>\n<h2>Coda AI的主要功能</h2>\n<ol>\n<li>AI快速生成内容和初稿。用户可以使用Coda AI来创建博客文章、销售邮件、新闻稿、产品设计文档、列表文章、产品路线图、社交帖子、待办列表等</li>\n<li>AI创建表格样例数据。用户可以使用Coda AI来创建产品名称数据、竞争对手表格、SWOT分析、公司标语例句、邮件备选标题，用表格的形式将所有备选方案或填充样例数据</li>\n<li>AI修改原有内容。用户可以选中文档里面的已有内容，然后使用Coda AI来进行翻译、总结、缩短、改写、简化或转换成其他形式</li>\n</ol>\n<h2>如何使用Coda AI</h2>\n<ol>\n<li>访问Coda AI的官网，点击Get Access</li>\n<li>使用邮箱/Google/微软账号，登录/注册Coda</li>\n<li>登录成功后会自动跳转到Coda AI的模板库，选择一个你想要用的模板</li>\n<li>或者点击右上角的My Docs进入到个人文档中心，点击Blank doc创建全新的文档</li>\n<li>在文档的空白处，输入斜杠 <strong>/ </strong>或者使用Ctrl+空格键的快捷键，然后点击AI助手按钮</li>\n<li>选择或输入你想要让AI创建的内容主题，然后点击Create按钮即可</li>\n</ol>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/f048c3089a29c5b.png\"  alt=\"Coda AI的功能\" width=\"800\" height=\"440\">\n<h2>Coda AI的产品价格</h2>\n<p>目前Coda AI正在公测中，可以免费访问和使用其AI功能，用户可以在其官网点击Get Access后，很快就能收到一封邮件，然后就可以无限制地使用Coda AI助手了。</p>'),
                                                                        (61,	0,	1,	'<p>DeepL Write 是知名 AI 翻译工具 <a href=\"https://ai-bot.cn/sites/1384.html\">DeepL</a> 于2023年1月份推出的文章润色和智能修改工具，帮助写作者清晰、准确、从容地书写。用户可以使用 DeepL Write 一键完善写作，目前支持英语（英式）、英语（美式）、德语等语言，后续会增加支持更多语言的改写。</p>\n<h2>DeepL Write 的主要功能</h2>\n<p>DeepL Write 是一个人工智能写作工具，可以改善英语和德语的书面交流。Write 不仅仅解决语法问题——它通过提供有关措辞、语气、风格和单词选择的建议，让你掌控自己的写作。</p>\n<ul>\n<li>修改语法和标点错误</li>\n<li>选择你的翻译方式</li>\n<li>创造性地改写整个句子</li>\n<li>通过Write建议的改写方式获取准确的措辞</li>\n</ul>\n<h2>如何使用 DeepL Write？</h2>\n<p>进入DeepL Write 的界面后，用户可以在左侧文本区域中输入文本。然后 DeepL Write 将检查左侧的输入，并在右侧文本区域提供文本的改进版本。系统会自动检测你的书写语言，但你也可以通过左侧文本区域上方的语言选择器进行更改。DeepL Write 所做的更改将在右侧文本区域中以绿色标记。您还可以选择为单个单词或整个句子选择替代措辞。</p>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/d8ec73c2c27d3d3.png\"  alt=\"如何使用DeepL Write\" width=\"800\" height=\"374\">\n<p>DeepL Write 还允许你重写成另一种相同的语言，目前此功能仅支持英式英语和美式英语。只需在左侧文本区域中输入文本，通过此区域上方的语言选择器，选择你要改写成的版本，DeepL Write 将根据所选语种的惯例重写输入的文本。</p>\n<h2>DeepL Write 是免费的吗？</h2>\n<p>DeepL Write 目前处于 Beta 测试中，该 AI 写作助手是完全免费的，任何人都可以使用，免费用户一次最多可以重写 2,000 个字符。</p>'),
                                                                        (62,	0,	1,	'<p>万彩AI是广州万彩信息技术有限公司推出的一款AI文案编写工具，帮助不会写文案或没有灵感的创作者快速生成可直接使用的文案，让文案编写效率提升90%，准确率高达99%。</p>\n<h2>万彩AI的写作功能</h2>\n<ol>\n<li>商业文书写作，包括商业风险分析、商业计划书、品牌推广策划、危机公关文案、市场调研报告、多模型AI分析助手；</li>\n<li>文章博客创作，包括书写文章标题、内容大纲、文章开头段落、文案润色、短文写作、演讲稿、扩充篇幅、AI智能改写；</li>\n<li>课堂教学帮手，包括AI教案、教学随笔、说课稿、微课脚本、学生评语、英语作文写作、课题灵感、PPT课件大纲、教育论文大纲、教育论文撰写、导学案设计、课堂互动设计、设计主题班会、教学工作计划、教师工作总结、知识点解析、主题家长会、作文出题等；</li>\n<li>广告营销文案撰写，包括营销文案、产品Slogan、AI客服回复、商家回复、广告标语、卖点挖掘、产品简介、SEM竞价广告等；</li>\n<li>自媒体文章生成，包括常见的社交媒体，小红书种草文、抖音脚本、知乎风格回答、公众号文章等。</li>\n</ol>\n<h2>万彩AI的产品价格</h2>\n<p>万彩AI的付费会员可以享受无限次创作、众多AI创作、超低延迟、极速生成等好处，付费会员分为月度会员和年度会员：</p>\n<ul>\n<li>月度会员18元</li>\n<li>年度会员99元</li>\n</ul>'),
                                                                        (63,	0,	1,	'<div class=\"jsx-3245176062 body-limit\">\n<p class=\"jsx-1576722372\">Notion AI 是国外知名协作文档平台 Notion 推出的一款 AI 写作助手，可以帮助用户写作、集思广益、编辑、总结文档等。你可以将 Notion AI 视为你的创作伙伴，帮助你节省时间或更明智地利用时间，更专注于内容创作和创意表达。</p>\n<h2>Notion AI 可以做什么？</h2>\n</div>\n<div class=\"jsx-1464425908 rt-spacing-s\">\n<div class=\"jsx-3245176062 body-limit\">\n<div class=\"jsx-b595010cd94ccee9 jsx-2839710170 video-container\">\n<div class=\"jsx-b595010cd94ccee9 jsx-2839710170 video-poster\">\n<div class=\"jsx-b595010cd94ccee9 jsx-2839710170 play-button-circle\">\n<div class=\"jsx-69ace1a2760481d9 play-button size-l\"><span style=\"font-size: 1rem;\">以下是团队和个人如何使用 Notion AI 的一些示例：</span></div>\n</div>\n</div>\n</div>\n</div>\n</div>\n<div class=\"jsx-3245176062 body-limit\">\n<div class=\"jsx-3245176062 body-limit\">\n<ul>\n<li class=\"jsx-1576722372\">处理初稿：第一个词往往是最难写的，Notion AI 可以帮助你处理关于某个主题的初稿，并为你提供一些想法开始创作。</li>\n<li class=\"jsx-1576722372\">激发想法和创造力：在AI的帮助下，快速获得关于任何事情的想法列表，这可以帮助用户更有创意，将想法作为起点（或一些您甚至不会想到的想法）。</li>\n<li class=\"jsx-1576722372\">作为您的编辑检查：无论是拼写、语法，还是翻译，Notion AI 都会发现错误或翻译整篇文章，以帮助确保写作准确且可操作。</li>\n<li class=\"jsx-1576722372\">总结会议或文档：对于一个冗长的会议或文件，Notion AI 可以快速总结要点，用户无需筛选一堆乱七八糟的会议记录，让 Notion AI 自动提取最重要的要点和行动项目。</li>\n</ul>\n</div>\n</div>\n<div class=\"jsx-3245176062 body-limit\">\n<p class=\"jsx-1576722372\">总之，Notion AI 可以帮助你清除创作道路上的阻碍，让你专注于更有影响力的工作。虽然它不能做所有事情，但可以帮助你提高工作效率。</p>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/284342bcb7f09a0.png\"  alt=\"Notion AI的使用\" width=\"707\" height=\"347\">\n<h2>Notion AI 是免费的吗？</h2>\n<p>每个人都可以免费使用 Notion AI，所以你可以在购买附加订阅之前测试其功能。赠送的AI使用的数量随着你拥有的成员越多而增加，并在整个工作区中共享。一旦你用完了所有免费的人工智能次数，你会看到一条信息，即需要订阅 Notion AI 附加组件才能继续使用人工智能功能。</p>\n<p>Notion AI的付费计划取决于用户的订阅类型，如果你选择一个付费计划并按年支付，Notion AI 每月为8美元。但如果你改成按月支付，你将每月支付10美元。</p>\n</div>'),
                                                                        (64,	0,	1,	'<p>QuillBot是由人工智能驱动的英语/德语写作润色修改工具，帮助学生和专业人士改写、编辑和改变他们文本的语气，以提高文章的清晰度和可读性。</p>\n<h2>QuillBot的主要功能</h2>\n<p>QuillBot 不仅仅是一个润色改写工具（Paraphraser），它还可以协助用户完成许多写作任务。你可以免费使用 Quillbot 的 Grammer Checker、Citation Generator、Summarizer 和多合一工具 Co-writer。</p>\n<p>如果用户升级到高级版本，还可以访问 Quillbot 的抄袭检查器（Plagiarism Checker）以及更快的处理速度和更高级的语法重写。</p>\n<h2>如何使用QuillBot</h2>\n<p>使用 QuillBot 非常简单，只需访问 QuillBot 的网站，在左侧的输入框中键入或粘贴你要改写的文本，然后点击“Paraphrase”按钮即可开始。除开网页版外，QuillBot 还提供适用于 Word 和 Chrome 的专用扩展程序，方便你在应用程序和网页中进行改写。</p>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/7c5f830a7dbaa47.png\"  alt=\"如何使用QuillBot\" width=\"800\" height=\"418\">'),
                                                                        (65,	0,	1,	'<h2>晓语台是什么</h2>\n<p>晓语台是北京字里心间科技推出的一款智能AI写作工具，用户可以通过点击操作，命令AI进行各种主题的文案创作。晓语台内置了多种风格和主题的AI创作模板，覆盖20余类行业与职业，近30个海内外社交平台，共计500+创作场景，能够快速生成各类高质量的文案。除文本内容生成外，平台还提供了对话创作、自由扩写、文本润色、续写改写、内容翻译、文章校验、广告法检测等辅助创作功能。</p>\n<img  class=\"alignnone size-full rounded-lg shadow-sm\" src=\"/uploadfile/202312/0c456015ec38258.png\"  alt=\"晓语台AI写作\" width=\"800\" height=\"400\">\n<h2>晓语台的主要功能</h2>\n<ol class=\"text-md\">\n<li>开箱即用的创作模板：平台上预置500+开箱即用的AI创作模板，操作简单，只需点击你要创作的题材，输入描述或关键词，即可快速生成专业文章</li>\n<li>创作不同行业和场景的内容：一键创作包括品牌宣传、市场调查、社交媒体、SEO文章、广告营销、职场办公、新媒体运营等各个领域的文本和文案</li>\n<li>支持流行的平台文案生成：如微信朋友圈、淘宝商品文案、小红书种草笔记、知乎回答、美团探店点评、抖音短视频脚本、Facebook帖子等</li>\n<li>满足不同行业类别的内容需求：可智能生成教育培训、金融投资、游戏娱乐、生活服务、健康医疗、社交通讯、新闻资讯、政务公益、商业服务等行业的文案</li>\n<li>提供时事热点话题追踪：提供百度、百度贴吧、抖音热榜、微博热搜、哔哩哔哩和知乎热榜等平台的实时热点关键词，辅助内容创作人员创建热点文章</li>\n<li>内置专属智能创作对话助手：提供对话式创作聊天机器人，可以根据用户的个性化需求，通过交流对话获取创作建议并寻求专属决策推荐</li>\n</ol>\n<h2>如何使用晓语台</h2>\n<ol class=\"text-md\">\n<li>访问晓语台的官网（<a href=\"https://www.xiaoyutai.com/?share_code=XYT90931478\" target=\"_blank\" rel=\"noopener\" class=\"external\">www.xiaoyutai.com</a>），点击登录/注册按钮</li>\n<li>使用微信或手机号码登录/注册账号，登录成功后会自动跳转到创作台界面</li>\n<li>选择创作分类（通用/行业/职业/平台）</li>\n<li>选择创作模板，如公众号文章创作，然后输入对应的主题或关键词</li>\n<li>最后点击立即生成按钮，晓语台将自动为您创建文案</li>\n</ol>\n<h2>晓语台的产品价格</h2>\n<ol class=\"text-md\">\n<li>免费版：用户注册后即可免费获得3000字的创作字数，</li>\n<li>付费版 - 7天体验会员：9.9元，支持AI文本创作1.5万字</li>\n<li>付费版 - 月度会员：连续包月28元，单月购买59.9元，支持AI创作10万字</li>\n<li>付费版- 年度会员：599元，支持AI文本创作120万字</li>\n</ol>\n<h2>常见问题</h2>\n<div id=\"accordion\" style=\"max-width: 700px;\">\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>晓语台是免费的吗？</strong></div>\n<div class=\"card-body text-sm\">晓语台为新用户提供免费3000字的创作字数，每日签到可获得500字的免费字数，邀请好友注册后还可获得免费2000字的字数。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>晓语台基于什么大模型？</strong></div>\n<div class=\"card-body text-sm\">晓语台的AI创作能力基于百度的大语言模型和混合大模型及AIGC技术研发而成。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>晓语台支持哪些平台？</strong></div>\n<div class=\"card-body text-sm\">晓语台目前支持在PC端和移动端的浏览器网页中使用。</div>\n</div>\n</div>'),
                                                                        (66,	0,	1,	'<p>Grammarly是一款AI驱动的英语语法纠正和校对工具，支持Windows、Mac、iOS和Android等多个平台。它能够检查单词拼写、纠正标点符号、修正语法错误、调整语气以及给出风格建议等。Grammarly可以帮助用户在写作和沟通中更加准确、流畅地表达自己的意思，提高英语写作和沟通的能力。</p>\n<h2>Grammarly的主要功能</h2>\n<ol>\n<li>语法检查。检查错误拼写、遗漏的标点符号、常见的混淆词、动词使用时态等，确保你的英文写作正确无误。</li>\n<li>语气建议。Grammarly可以提供专业的写作语气建议，以调整你文章表达出的情绪和态度，而不会改变原有的意思。</li>\n<li>原创度检测。Grammarly内置了剽窃检查器，可以帮助检测用户文本中的重复度，并检查其他写作问题。</li>\n<li>支持多个平台和网站应用。Grammarly支持500,000 多个移动、Web 和桌面应用程序，可以帮助用户在创作、工作、学习和生活聊天中使用完美的用词。</li>\n<li>提供生成式AI写作助手。今年3月Gramamrly推出了基于生成式AI技术的GrammarlyGO，可为用户提供快速撰写、重写、构思和回复的能力。</li>\n</ol>\n<h2>Grammarly的产品价格</h2>\n<p>Grammarly提供免费增值的定价模式，包含Free免费版、Premium高级版和Business团队版三个不同的定价计划。</p>\n<ol>\n<li>Free免费版 - 0美元/月，提供基本的文本生成、基本写作建议和语调检测等功能，每个月可使用GrammarlyGO进行100次的生成式AI写作。</li>\n<li>Premium高级版 - 12美元/月，免费版的所有功能，加上完整的句子改写、词汇想法、语气建议等，每个月可使用GrammarlyGO进行1000次的生成式AI写作。</li>\n<li>Business团队版 - 15美元/月，高级版所有功能，加上团队的功能，如统一付费管理和自定义写作风格指南，每个团队成员每个月可使用GrammarlyGO进行1000次的生成式AI写作。</li>\n</ol>'),
                                                                        (67,	0,	1,	'<p>Rytr是一个于2021年4月发布的人工智能驱动的AI写作工具，该人工智能写作助手可以帮助用户自动撰写和创建电子邮件、博文文章、广告文案和社交媒体帖子等内容。只需几秒钟Rytr便可以为用户创造原创的、有吸引力的文案，成本只有人工的几分之一。</p>\n<h2>Rytr支持哪些语言？</h2>\n<p>Rytr目前支持30多种语言进行AI创作，包括：🇨🇳 中文、🇺🇸 英语、🇦🇪 阿拉伯语、🇨🇿 捷克语、🇩🇰 丹麦语、🇳🇱 荷兰语、🇫🇮 芬兰语、🇫🇷 法语、🇩🇪 德语、🇬🇷 希腊语、🇮🇱 希伯来语、🇮🇳 印地语、🇮🇩 印尼语、🇮🇹 意大利语、🇯🇵 日语、🇰🇷 韩语、🇳🇴 挪威语、🇵🇱 波兰语、🇵🇹 葡萄牙语、🇷🇴 罗马尼亚语、🇷🇺 俄语、🇪🇸 西班牙语、🇸🇪 瑞典语、🇹🇭 泰语、🇹🇷 土耳其语等。</p>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/73e8aed5ee1c308.jpeg\"  alt=\"Rytr支持的语言\" width=\"640\" height=\"364\">'),
                                                                        (68,	0,	1,	'<p>Writesonic是一个由人工智能驱动的内容自动化平台，用户可以使用该AI写作工具输入文本提示，生成无限的内容以节省时间和精力。该平台内置了65个以上的文章模板和功能，如文章写作、Facebook广告、着陆页文案、Quora回答、Twitter推文和Instagram标题等，帮助你高效率创作不同类型的内容。</p>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/b8b7718ff7dc067.png\"  alt=\"Writesonic的功能\" width=\"800\" height=\"441\">\n<h2>Writesonic支持哪些语言？</h2>\n<p>Writesonic目前的版本支持24种常用的不同语言来进行写作，包括英语、中文、法语、西班牙、意大利语、德语、波兰语、葡萄牙语、荷兰语、日语、俄语、保加利亚语、捷克语、丹麦语、希腊语、匈牙利语、立陶宛语、拉脱维亚语、罗马尼亚语、斯洛伐克语、斯洛文尼亚语、瑞典语、芬兰语、爱沙尼亚语。</p>\n<h2>Writesonic可以做什么？</h2>\n<p>Writesonic提供65种以上的人工智能写作功能，可以帮助用户：</p>\n<ul>\n<li>生成特定行业的内容，和品牌的写作风格和语气保持一致。</li>\n<li>获得SEO优化的内容，以获得更好的排名和更高的转换率。</li>\n<li>在几秒钟内创建长篇博客和文章（1500字以上）。</li>\n<li>文章润色和改进，通过重新措辞或改变风格来改进你现有的内容，使其有一个全新的面貌。</li>\n<li>想出有趣的想法和概念来制作独特的内容。</li>\n<li>通过创造故事和歌曲来提高你的创造力。</li>\n<li>使用着陆页文案生成器或CTA生成器等功能，用令人印象深刻的文案来提高你的转换率。</li>\n<li>通过批量上传功能，批量制作超过50种内容。</li>\n<li>通过Zapier的整合，直接从Writesonic向5000多个平台发布，发布和更新你生成的内容。</li>\n<li>为论文等学术内容撰写初稿。</li>\n</ul>\n<h2>Writesonic是免费的吗？</h2>\n<p>Writesonic提供不同的计划，包括免费试用，用户注册后可以使用10,000个免费字数。然后，每个月享受2500个免费字数；长篇计划（按月计费）： 起价19美元/月，每月可创作60,000字；长篇计划（按年计费）：从12.67美元/月起，每月可创作60,000字。</p>'),
                                                                        (69,	0,	1,	'<p>Copy.ai由经验丰富的撰稿人和软件开发人员组成的团队于 2020 年创建，旨在帮助各行各业的撰稿人、营销人员和企业快速高效地创建高质量的内容。</p>\n<p>Copy.ai的主要特点之一是其先进的 AI 技术，该技术使用自然语言处理和机器学习算法来生成根据你的特定需求量身定制的高质量内容。无论你需要帮助制作吸引人的标题、撰写产品说明，还是起草整篇博文或文章，Copy.ai 都可以提供帮助。2023年3月8日，Copy.ai推出了Chat功能，类似于ChatGPT但内置提供了很多开箱即用的prompts提示供用户使用。</p>\n<h2>Copy.ai支持哪些语言？</h2>\n<p>Copy.ai目前支持29+的语言进行AI写作，包括🇨🇳 中文、🇺🇸 英语、🇫🇷 法语、🇪🇸 西班牙语、🇧🇷 葡萄牙语、🇩🇪 德语、🇮🇹 意大利语、🇳🇱 荷兰语、🇷🇺 俄语、🇵🇱 波兰语、🇩🇰 丹麦语、🇵🇹 葡萄牙语、🇧🇬 保加利亚语、🇨🇿 捷克语、🇬🇷 希腊语、🇪🇪 爱沙尼亚语、🇫🇮 芬兰语、🇭🇺 匈牙利语、🇯🇵 日语、🇱🇹 立陶宛语、🇱🇻 拉脱维亚语、🇷🇴 罗马尼亚语、🇸🇰 斯洛伐克语、🇸🇮 斯洛文尼亚语、🇸🇪 瑞典语。</p>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/b2d27d1f16c68.png\"  alt=\"Copy.ai支持的语言\" width=\"800\" height=\"452\">\n<h2>Copy.ai是免费的吗？</h2>\n<p>Copy.ai提供一系列定价计划以满足用户不同的需求和预算。</p>\n<ul>\n<li>基本计划是完全免费的，包括访问平台的所有基本功能，包括基本语言模型和数量有限的免费撰写，每月可以免费撰写2000个单词。</li>\n<li>付费计划年版为每月36美元，并提供更高级的功能，包括访问更高级的语言模型、无限制输出文字数量、25个种类的语言输出。</li>\n</ul>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/44382766f3fa83b.png\"  alt=\"Copy.ai的价格\" width=\"800\" height=\"421\">'),
                                                                        (70,	0,	1,	'<p>Jasper（原Jarvis）是国外最受欢迎的AI写作软件工具之一，因其丰富的的模板和强大的智能写作功能而广受欢迎。你可以使用 Jasper 创建博客、文章、书、剧本、帖子和任何其他内容。只需选择一个话题，填写关键词和细节，Jasper将为你自动写作内容。</p>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/45ced1dba947409.png\"  alt=\"Jasper的后台界面\" width=\"800\" height=\"441\">\n<h2>Jasper的主要功能：</h2>\n<ul>\n<li>长篇文章编辑器。Jasper称之为Boss Mode，可以让你用AI输出写作完整的文档</li>\n<li>原创度检测器。写作时不必担心被指责为剽窃别人的内容</li>\n<li>快速写作。点击开始，Jasper会在几分钟内为你的博客文章或文章创造出一个杰作</li>\n<li>集成SEO Surfer。帮助你分析关键词和优化你的内容，让你的文章更加对搜索引擎友好</li>\n<li>自动文章写作。如果你给它足够的参数，Jasper AI几乎可以为你写作任意文章</li>\n</ul>\n<h2>Jasper支持的语言：</h2>\n<p>Jasper支持30+的语言和方言进行AI写作，包括中文、英语（美式）、英语（英式）、保加利亚语、捷克语、丹麦语、荷兰语、<span style=\"font-size: 1rem;\">爱沙尼亚语、</span>芬兰语、法语、德语、希腊语、匈牙利语、印尼语、意大利语、日语、韩语、拉脱维亚语、立陶宛语、挪威语、波兰语、葡萄牙语、葡萄牙语（巴西）、罗马尼亚语、俄罗斯语、斯洛伐克语、斯洛文尼亚语、西班牙语、瑞典语、土耳其语、乌克兰语等。</p>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/e1ad9b61fcff462.png\"  alt=\"Jasper支持的语言\" width=\"800\" height=\"293\">\n<h2>Jasper是免费的吗？</h2>\n<p>Jasper提供三个付费计划，Creators（起价39美元/月）、Teams（起价为99美元/月）、Business（需询价）。用户可以选择在Creator或Teams计划上进行7天的免费试用，以无风险地体验Jasper。</p>\n<p>你也可以通过我们的<a href=\"https://jasper.ai?utm_source=partner&amp;fpr=ai-bot\" target=\"_blank\" rel=\"noopener nofollow\" class=\"external\">引荐链接</a>进入Jasper官网，注册后便能拥有10,000的写作额度积分。</p>'),
                                                                        (71,	0,	1,	'<p>百度作家平台是百度官方推出的一站式AI辅助创作平台，提供丰富多样的AI创作功能，帮助内容创作者写出更多好作品。</p>\n<h2>百度作家平台的功能</h2>\n<ol>\n<li>AI助手。智能对话帮你解决创作中的问题，文笔、书写、剧情、知识都不在话下</li>\n<li>AI续写。提供自由续写、情节指令、故事大纲多种模式，帮助你续写得到满意的结果</li>\n<li>AI工具箱。内置扩写、描写、润色、小说设定、角色起名等辅助写作功能</li>\n<li>智能校阅。文字输入，实时纠正，拒绝错别字和敏感词</li>\n</ol>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/ecd0cb8f72ad.png\"  alt=\"百度作家平台AI写作\" width=\"800\" height=\"446\">\n<h2>如何使用百度作家平台</h2>\n<ol>\n<li>访问百度作家平台的官网（zuojia.baidu.com），登录你的百度账号</li>\n<li>进入工作台后点击开始创作，选择你要创作的类型（故事或小说）</li>\n<li>在创作界面，选择你要使用的AI功能进行创作即可</li>\n</ol>'),
                                                                        (72,	0,	1,	'<p>秘塔写作猫是一款新一代的交互式中英文AI写作辅助平台，它集智能文本纠错、改写润色、自动续写、智能配图等功能为一体。该软件基于AI技术的中英文纠错校对和创作工具，拥有网页版、Chrome扩展、小程序、Word插件等多种版本。</p>\n<h2>秘塔写作猫的主要功能</h2>\n<ul>\n<li>AI写作。通过结合标题和开头部分来自动续写文字，为用户提供创作灵感和文本内容。</li>\n<li>句子改写。可以对句子进行改写，使表达更准确、更生动。</li>\n<li>文章纠错。快速发现文章中的各种错别字、错误标点、语法、搭配等问题，并将错误用不同颜色标示出来。</li>\n<li>智能降重。对于需要修改的文章，可以提供改错和降重的建议。</li>\n<li>多人协作。平台支持多人协作，方便团队共同完成写作任务。</li>\n<li>智能配图。为文章提供合适的图片，增加视觉效果。</li>\n<li>中英翻译。支持中英互译，方便用户进行跨语言写作。</li>\n</ul>\n<h2>秘塔写作猫的产品价格</h2>\n<ul>\n<li>免费版0元每月，可免费体验你说我改功能，可使用中英文纠错基本模型8000字/天，中英翻译2000字/天，朗读字数1000字/天</li>\n<li>基础版24元每月，可使用你说我改功能5000字/月，可使用中英文纠错高级模型30000字/天，中英翻译8000字/天，朗读字数8000字/天</li>\n<li>高级版48元每月，可使用你说我改功能20000字/月，可使用中英文纠错高级模型60000字/天，中英翻译20000字/天，朗读字数20000字/天</li>\n</ul>\n<h2>关于秘塔写作猫的常见问题</h2>\n<div id=\"accordion\" style=\"max-width: 700px;\">\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>秘塔写作猫基于什么大模型？</strong></div>\n<div class=\"card-body text-sm\">秘塔写作猫背后的秘塔科技创始技术团队均是NLP领域的技术专家，团队在Transfomer的基本框架上进行了多项自主模型创新，利用积累的算法与工程优化经验进行自研 MetaLLM 大模型训练。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>秘塔写作猫可以写作哪些类型的文章？</strong></div>\n<div class=\"card-body text-sm\">秘塔写作猫不仅可以用于写作论文、方案报告、作文等，还可以用于创作小说，甚至能帮你头脑风暴，生成意想不到的广告语。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>秘塔写作猫是否收费？</strong></div>\n<div class=\"card-body text-sm\">秘塔写作猫的大部分功能都是免费的，但如果要使用更多字数额度或体验高级功能则需要付费使用。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>秘塔写作猫支持哪些平台和系统？</strong></div>\n<div class=\"card-body text-sm\">秘塔写作猫支持移动端App、微信小程序、Word插件、WPS插件、Chrome浏览器插件、Edge浏览器插件、搜狗浏览器插件、QQ浏览器插件、360浏览器插件、Windows桌面系统插件等各个平台和系统。</div>\n</div>\n</div>'),
                                                                        (73,	0,	0,	'<p>Leap 提供简单易用的API和SDK，帮助开发人员在几分钟内将人工智能添加到自己的应用程序中，如生成图像、编辑图像、微调模型、检索文本上下文等。</p>\n<p>Leap 可以在不编写/少量编写代码的情况下与5000多个应用程序集成。该工具提供Javascript、Python和cURL的API，用户可以通过注册免费试用帐户来试用Leap的功能。</p>\n<h2>Leap的特色功能</h2>\n<ol>\n<li>多合一AI功能的API。一个平台的API，用于图像、文本、视频等AI功能实现，无需在单个API之间切换。</li>\n<li>内置测试和试玩工作台。在浏览器中使用Leap提供的人工智能模型，然后再将其集成到自己的应用程序中。</li>\n<li>与任何应用程序集成。通过提供的Zapier集成，无需编程，便可以将Leap连接到3000多个应用程序。</li>\n<li>微调训练自定义模型。使用其Dreambooth微调仪表板和API，可训练自定义的模型，无论是人、宠物、对象或自定义风格。</li>\n</ol>\n<h2>Leap的产品价格</h2>\n<p>Leap 的产品定价很简单，提供免费的基础套餐和付费套餐允许用户访问其他高级功能、无限制使用和访问高级队列。</p>\n<ul>\n<li class=\"heading-text\">免费套餐\n<ul>\n<li>图像生成：在标准队列中生成 100 张图像。</li>\n</ul>\n</li>\n<li class=\"heading-text\">付费套餐\n<ul>\n<li>图像生成：每张图像支付 0.005 美元（高级队列）。</li>\n<li>模型微调：为每个经过训练的模型版本支付 2 美元（高级队列）</li>\n<li>混合图像：每张图片支付 0.01 美元（高级队列）</li>\n</ul>\n</li>\n</ul>'),
                                                                        (74,	0,	0,	'<p>Lightning AI是一个构建模型和构建/发布Lightning Apps（ML工作流模板）的平台，由Pytorch Lightning团队推出——一个快速训练、部署和开发人工智能产品的深度学习框架。</p>'),
                                                                        (75,	0,	0,	'<p>大语言模型（LLM）正在成为一种变革性技术，使开发人员能够构建以前无法构建的应用程序。但是，单独使用这些LLM通常不足以创建一个真正强大的应用程序——当你可以将它们与其他计算或知识来源相结合时，便可能实现其真正的能力。</p>\n<p>LangChain是一个用于开发由语言模型驱动的应用程序的框架，允许开发人员将语言模型连接到其他数据源并与其环境相交互。LangChain旨在帮助开发者在以下六个主要领域，按照复杂性递增的顺序：</p>\n<ul>\n<li>📃 LLMs and Prompts: 这包括提示管理、提示优化、适用于所有 LLM 的通用界面以及用于处理 LLM 的通用实用程序。</li>\n<li>🔗 Chains: 链不仅仅是单个 LLM 调用，而是调用序列（无论是对 LLM 还是对不同的实用程序）。 LangChain 为链提供标准接口、与其他工具的大量集成以及用于常见应用程序的端到端链。</li>\n<li>📚 Data Augmented Generation: 数据增强生成涉及特定类型的链，这些链首先与外部数据源交互以获取数据以用于生成步骤。 这方面的例子包括对长文本的总结和对特定数据源的问答。</li>\n<li>🤖 Agents: 代理涉及 LLM 做出关于采取哪些行动的决定，采取该行动，看到一个观察，并重复直到完成。LangChain 为代理提供了一个标准接口，可供选择的代理选择，以及端到端代理的示例。</li>\n<li>🧠 Memory: 内存是链/代理调用之间持久状态的概念。 LangChain 提供了内存的标准接口、内存实现的集合以及使用内存的链/代理的示例。</li>\n<li>🧐 Evaluation: [BETA] 众所周知，生成模型很难用传统指标进行评估。 评估它们的一种新方法是使用语言模型本身进行评估，LangChain 提供了一些提示/链来协助这一点。</li>\n</ul>'),
                                                                        (76,	0,	0,	'<p>NLTK（Natural Language Toolkit）自然语言工具包——是一套开源Python模块、数据集和教程，支持自然语言处理的研究和开发。NLTK需要Python版本3.7、3.8、3.9、3.10或3.11。</p>'),
                                                                        (77,	0,	0,	'<p>GoogleJAX是一个用于变换数值函数的机器学习框架，Google称其为为结合了修改版本的Autograd（通过函数微分自动获得梯度函数）和TensorFlow的XLA（加速线性代数）。该框架的设计尽可能遵循NumPy的结构和工作流程，并与TensorFlow和PyTorch等各种现有框架协同工作。</p>\n<p>JAX的主要功能是包括：</p>\n<ul>\n<li>grad：自动微分</li>\n<li>jit：编译</li>\n<li>vmap：自动矢量化</li>\n<li>pmap：SPMD编程</li>\n</ul>'),
                                                                        (78,	0,	0,	'<p>Deeplearning4j是为数不多的以Java虚拟机（JVM）为目标，以Java原生编写的机器学习框架之一。该框架由位于旧金山的一组机器学习开发人员开发，并由初创公司Skymind提供商业支持。Deeplearning4j于2017年10月捐赠给了Eclipse基金会。该库与Clojure和Scala兼容。</p>\n<p>对于集群和分布式训练，Deeplearning4j与Apache Spark和Apache Hadoop集成。它还与NVIDIA CUDA运行时集成，可在多个GPU之间执行GPU操作和分布式训练。</p>\n<p>Deeplearning4j包括一个使用ND4J的n维数组类，该类允许在Java和Scala中进行科学计算，与NumPy提供给Python的函数类似。它可以有效地用作执行线性代数和矩阵操作的库，用于训练和推理。</p>\n<p>Deeplearning4j可以用于训练模型，这些模型可以执行图像分类、对象检测、图像分割、自然语言处理和时间序列预测。</p>'),
                                                                        (79,	0,	0,	'Python科学计算必备的包'),
                                                                        (80,	0,	0,	'<p>Caffe（Convolutional Architecture for Fast Feature Embedding）(快速特征嵌入的卷积架构)是一个开源的深度学习框架，最初由加州大学伯克利分校的Yangqing Jia开发。</p>\n<p>2017年4月，Facebook发布了Caffe2，其中包含了递归神经网络（RNN）等新功能。2018年3月底，Caffe2被并入PyTorch。</p>'),
                                                                        (81,	0,	0,	'Python版本的TensorFlow深度学习API'),
                                                                        (82,	0,	0,	'<p>Vercel AI SDK是前端网站开发和托管平台及Next.js开发团队「Vercel」推出的，用于快速构建AI聊天机器人网站应用程序的开发套件，可以帮助开发人员使用JavaScript和TypeScript构建对话式的AI用户界面。</p>\n<h2>Vercel AI SDK的特性</h2>\n<ol>\n<li>支持React/Next.js、Svelte/SvelteKit和Vue/Nuxt等前端框架，以及Node.js、Serverless和Edge Runtime</li>\n<li>内置各种AI模型的适配器，支持LangChain、OpenAI、Anthropic和Hugging Face等提供的大语言模型</li>\n<li>提供交互式在线提示playground（sdk.vercel.ai），其中包含20个开源和云LLM。可以实时展示不同对话模型的聊天界面，并且可以快速生成代码。</li>\n<li>提供多个AI聊天机器人的模板和示例，你可以克隆/复制Vercel提供的基于不同框架和模型开发的AI聊天机器人的初始模板</li>\n</ol>\n<h2>如何使用Vercel AI SDK</h2>\n<ol>\n<li>前提条件需要在电脑上安装Node.js 18+版本，如果要开发基于OpenAI的GPT聊天机器人，需要获得OpenAI API密钥</li>\n<li>使用Next.js（<code>pnpm dlx create-next-app my-ai-app</code>）或者Svelte（<code>pnpm create svelte@latest my-ai-app</code>）等框架创建一个全新的项目，并定位到创建好的目录（<code>cd my-ai-app</code>）</li>\n<li>安装依赖项，<code>pnpm install ai openai-edge</code></li>\n<li>配置 OpenAI API 密钥，<code>.env.local</code>在项目根目录中创建一个文件并添加您的 OpenAI API 密钥</li>\n<li>创建API路由并连接UI，完成后使用<code>pnpm run dev</code>运行启动应用程序</li>\n</ol>'),
                                                                        (83,	0,	0,	'<p>Label Studio 是 Human Signal（原Heartex）推出的一个免费开源的数据标注工具，GitHub 上该项目标星近1.4万，可帮助开发人员微调大语言模型、准备训练数据或验证 AI 模型。</p>\n<h2>Label Studio的功能特色</h2>\n<ol>\n<li>支持标记各种类型的数据，包括图片、声音、文本、时间序列、多域、视频等</li>\n<li>灵活且可配置，可配置的布局和模板以结合自己的数据集和工作流</li>\n<li>机器学习辅助标记，通过 ML 后端集成使用预测来协助标记流程，从而节省时间</li>\n<li>多个项目和用户，在一个平台上支持多个项目、用例和数据类型</li>\n<li>与您的 ML/AI pipeline 集成，可使用 Webhooks、Python SDK 和 API 进行身份验证、创建项目、导入任务、管理模型预测等。</li>\n</ol>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/86c5533a04ce.png\"  alt=\"Label Studio\" width=\"800\" height=\"458\">\n<h2>如何开始使用 Label Studio</h2>\n<ol>\n<li>首先确认在电脑上已安装好<code>libq-dev</code>和<code>python3-dev</code>依赖项</li>\n<li>然后使用<code>pip install label-studio</code>命令安装 Label Studio</li>\n<li>在终端/命令行使用<code>label-studio start</code>启动 Label Studio</li>\n<li>通过 <strong>http://localhost:8080</strong> 打开 Label Studio UI</li>\n<li>使用自己创建的电子邮件地址和密码进行注册</li>\n<li>单击 <strong>Create</strong> 创建项目并开始标记数据</li>\n<li>为项目命名，可输入项目描述并选择颜色</li>\n<li>单击 <strong>Data Import</strong> 并上传你要使用的数据文件。如果你想使用本地目录、云存储或数据库中的数据，可暂时跳过此步骤</li>\n<li>单击 <strong>Labeling Setup</strong> 设置并选择一个模板并根据你的用例自定义标注名称</li>\n<li>单击 <strong>Save</strong> 以保存您的项目</li>\n</ol>\n<p>更多的设置和相关操作，请查看官方的文档https://labelstud.io/guide/get_started.html</p>'),
                                                                        (84,	0,	0,	'Python机器学习库'),
                                                                        (85,	0,	0,	'免费开源的深度学习框架'),
                                                                        (86,	0,	0,	'<p>昇思MindSpore是由华为自研的一种适用于端边云场景的新型开源深度学习训练/推理框架，MindSpore提供了友好的设计和高效的执行，旨在提升数据科学家和算法工程师的开发体验，并为Ascend AI处理器提供原生支持，以及软硬件协同优化。</p>'),
                                                                        (87,	0,	0,	'开源深度学习平台'),
                                                                        (88,	0,	0,	'开源机器学习框架'),
                                                                        (89,	0,	0,	'Google推出的机器学习和人工智能开源库'),
                                                                        (90,	0,	0,	'<p>ShowMeAI是一个人工智能领域的资料库和学习社区，覆盖Python、数据科学、机器学习、深度学习、自然语言处理、计算机视觉等方向。为AI学习、求职、项目落地、业务探索等场景，提供了结构化路径和全套资料库。构建AI解决方案，用知识加速每一次技术成长！</p>'),
                                                                        (91,	0,	0,	'Google AI学习平台'),
                                                                        (92,	0,	0,	'Udacity推出的School of AI，从入门到高级'),
                                                                        (93,	0,	0,	'<p>阿里云作为国内领先的云服务，其开发者社区提供了一条完整的人工智能学习路线，旨在帮助用户从入门到进阶掌握人工智能领域的知识和技能。该路线包含了30门在线课程和22个实战案例，分为以下5大学习阶段：</p>\n<ol>\n<li>机器学习入门：学习人工智能的基本概念、算法原理、编程语言等知识。</li>\n<li>TensorFlow框架及常用库：介绍TensorFlow深度学习框架以及常用Python数据科学库的使用</li>\n<li>机器学习实战：通过实践项目，学习机器学习的基本原理和实现方法，例如数据分析、特征工程、模型构建等。</li>\n<li>自然语言处理实战：了解机器学习和深度学习技术在自然语言处理领域的实战应用。</li>\n<li>图像识别实战：了解机器学习和深度学习技术在图像识别处理领域的实战应用。</li>\n</ol>'),
                                                                        (94,	0,	0,	'<p>AI大学堂是由讯飞开放平台打造的人工智能专业学习、交流和培训的AI学习平台。作为开发者专属的AI学习平台，旨在为 AI 领域开发者、爱好者提供丰富的资源、专业的课程以及共享的服务。AI大学堂提供专业、有趣、实用的AI课程，让你找到丰富优质的AI学习教程。网站上也会定期开展未来课栈、精品课堂、AI创学社等众多线下活动，并举办AI开发者大赛，开放讯飞专业技术能力，玩转百变算法。</p>'),
                                                                        (95,	0,	0,	'人工智能学习实训社区'),
                                                                        (96,	0,	0,	'Brilliant推出的Introduction to Neural Networks课程'),
                                                                        (97,	0,	0,	'机器学习和数据科学社区'),
                                                                        (98,	0,	0,	'<p><em>Machine Learning for Beginners</em>是由Microsoft 的 Azure Cloud Advocates 提供的为期 12 周、26 节课的课程，所有课程都是关于机器学习的。 在本课程中，你将了解经典机器学习的内容，主要使用Scikit-learn库来进行讲解。每节课都包括课前和课后测验、完成课程的书面说明、解决方案、作业等。</p>'),
                                                                        (99,	0,	0,	'<p>Generative AI for Beginners 是微软 Cloud Advocates 团队推出的十二章生成式AI入门的系列课程，介绍了构建生成式 AI 应用程序的基础知识，在GitHub上已超过1.7万人星标。每章都涵盖了生成式人工智能原理和应用程序开发的一个关键知识点，提供导学视频、书面材料、代码示例和进阶的学习资源推荐。通过整个课程的学习，你将拥有建立自己的生成式人工智能产品和工具的能力，实现应用AIGC技术的想法。</p>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/be87b3402777263.jpeg\"  alt=\"Generative AI for Beginners\" width=\"800\" height=\"490\">\n<h2>Generative AI for Beginners的课程目录</h2>\n<table class=\"table table-striped\">\n<thead>\n<tr>\n<th></th>\n<th>课程章节</th>\n<th>相关教学内容</th>\n<th>学习目标</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n<td>00</td>\n<td>课程介绍和学习环境设置</td>\n<td>学习环境配置和课程结构</td>\n<td>在学习本课程的同时帮助您取得成功</td>\n</tr>\n<tr>\n<td>01</td>\n<td>生成式人工智能和 LLMs 介绍</td>\n<td><strong>知识点</strong>: 生成式人工智能以及我们如何适应当前的技术格局</td>\n<td>了解什么是生成式人工智能 以及 LLMs 的工作原理。</td>\n</tr>\n<tr>\n<td>02</td>\n<td>探索和比较不同的 LLMs</td>\n<td><strong>知识点</strong>: 测试、迭代和比较不同的 LLMs 模型</td>\n<td>为您的应用场景选择正确的模型</td>\n</tr>\n<tr>\n<td>03</td>\n<td>负责任地使用生成式人工智能</td>\n<td><strong>知识点:</strong> 了解基础模型的局限性和人工智能背后的风险</td>\n<td>了解如何负责任地构建生成式人工智能应用程序</td>\n</tr>\n<tr>\n<td>04</td>\n<td>提示工程基础</td>\n<td><strong>代码/知识点:</strong> 提示工程最佳实践</td>\n<td>了解提示结构和用法</td>\n</tr>\n<tr>\n<td>05</td>\n<td>创建高级的提示工程技巧</td>\n<td><strong>代码/知识点:</strong> 通过在提示中应用不同的技术来扩展您的提示工程知识</td>\n<td>应用提示工程技术来改善提示结果。</td>\n</tr>\n<tr>\n<td>06</td>\n<td>创建文本生成应用</td>\n<td><strong>代码:</strong> 使用 Azure OpenAI 构建文本生成应用程序</td>\n<td>了解如何有效地使用令牌和温度来改变模型的输出</td>\n</tr>\n<tr>\n<td>07</td>\n<td>创建聊天应用</td>\n<td><strong>代码</strong>: 有效构建和集成聊天应用程序的技术。</td>\n<td>确定关键指标和注意事项，以有效监控和维护人工智能聊天应用程序的质量</td>\n</tr>\n<tr>\n<td>08</td>\n<td>创建搜索应用</td>\n<td><strong>代码</strong>: 语义搜索与关键字搜索。 什么是文本嵌入以及它们如何应用于搜索</td>\n<td>创建一个使用嵌入来搜索数据的应用程序。</td>\n</tr>\n<tr>\n<td>09</td>\n<td>创建图像生成应用</td>\n<td><strong>代码:</strong> 图像生成及其在构建应用程序中的作用</td>\n<td>构建图像生成应用程序</td>\n</tr>\n<tr>\n<td>10</td>\n<td>创建低代码的人工智能应用</td>\n<td><strong>低代码:</strong> Power Platform 中的生成式 AI 简介</td>\n<td>使用低代码为我们的教育初创公司构建学生作业跟踪应用程序</td>\n</tr>\n<tr>\n<td>11</td>\n<td>为生成式 AI 添加 function calling</td>\n<td><strong>代码:</strong> 什么是 Function Calling 及其在应用程序中的使用示例</td>\n<td>设置 Function Calling 以从外部 API 检索数据</td>\n</tr>\n<tr>\n<td>12</td>\n<td>为人工智能应用程序添加用户体验</td>\n<td><strong>知识点:</strong> 设计人工智能应用程序以实现信任和透明度</td>\n<td>开发生成式人工智能应用时用户体验设计的相关原则</td>\n</tr>\n<tr>\n<td>xx</td>\n<td>拓展学习</td>\n<td>包含每章内容的的拓展链接！</td>\n<td>掌握生成式人工智能相关技能</td>\n</tr>\n</tbody>\n</table>'),
                                                                        (100,	0,	0,	'免费在线学习机器学习，从基础到高级'),
                                                                        (101,	0,	0,	'动手学深度学习的教材和课程'),
                                                                        (102,	0,	0,	'深度学习和人工智能学习平台'),
                                                                        (103,	0,	0,	'免费在线AI通识学习'),
                                                                        (104,	0,	0,	'知名MOOC平台，众多人工智能和机器学习课程'),
                                                                        (105,	0,	0,	'<p>深度学习正在改变世界，而fast.ai项目便致力于让深度学习更容易使用。该深度学习和AI学习网站提供了一系列免费的AI学习资源和课程：</p>\n<ul>\n<li>针对程序员的免费AI课程</li>\n<li>软件库</li>\n<li>前沿研究</li>\n<li>以及AI社区</li>\n</ul>\n<p>fast.ai的口号是，“世界需要所有人参与到人工智能，无论你的背景多么不可能”（The world needs everyone involved with AI, no matter how unlikely your background.）。</p>\n<p>Making neural nets uncool again。酷就是要有排他性，这与fast.ai想要的恰恰相反。他们希望让深度学习变得尽可能容易——包括那些使用C#等没那么酷的语言、Windows等没那么酷的操作系统（世界上大多数人都在使用）、没那么酷的数据集（比谷歌的任何东西都小得多，而且在你认为晦涩难懂的领域）和没那么酷的背景的人（即使你没上斯坦福大学之类的一流名校）。</p>'),
                                                                        (106,	0,	0,	'<p>PubMedQA是一个生物医学研究问答数据集，包含了1K专家标注，61.2K 个未标注和 211.3K 个人工生成的QA实例，该排行榜目前已收录18个模型的医学测试得分。</p>'),
                                                                        (107,	0,	0,	'<p>H2O EvalGPT 是 H2O.ai 用于评估和比较 LLM 大模型的开放工具，它提供了一个平台来了解模型在大量任务和基准测试中的性能。无论你是想使用大模型自动化工作流程或任务，H2O EvalGPT 都可以提供流行、开源、高性能大模型的详细排行榜，帮助你为项目选择最有效的模型完成具体任务。</p>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/52333882e4f7a17.png\"  alt=\"H2O LLM Eval Leaderboard\" width=\"800\" height=\"450\">\n<h2>H2O EvalGPT 的主要特点</h2>\n<ul>\n<li><strong>相关性：</strong> H2O EvalGPT 根据行业特定数据评估流行的大语言模型，从而了解其在实际场景中的表现。</li>\n<li><strong>透明度：</strong> H2O EvalGPT 通过开放的排行榜显示顶级模型评级和详细的评估指标，确保完全可重复性。</li>\n<li><strong>速度和更新：</strong>全自动和响应式平台每周更新排行榜，显着减少评估模型提交所需的时间。</li>\n<li><strong>范围：</strong>评估各种任务的模型，并随着时间的推移添加新的指标和基准，以全面了解模型的功能。</li>\n<li><strong>交互性和人工一致性：</strong> H2O EvalGPT 提供手动运行 A/B 测试的能力，提供对模型评估的进一步见解，并确保自动评估和人工评估之间的一致性。</li>\n</ul>'),
                                                                        (108,	0,	0,	'<p>LLMEval是由复旦大学NLP实验室推出的大模型评测基准，最新的LLMEval-3聚焦于专业知识能力评测，涵盖哲学、经济学、法学、教育学、文学、历史学、理学、工学、农学、医学、军事学、管理学、艺术学等教育部划定的13个学科门类、50余个二级学科，共计约20W道标准生成式问答题目。</p>'),
                                                                        (109,	0,	0,	'<p>Chatbot Arena是一个大型语言模型 (LLM) 的基准平台，以众包方式进行匿名随机对战，该项目方LMSYS Org是由加州大学伯克利分校、加州大学圣地亚哥分校和卡内基梅隆大学合作创立的研究组织。</p>\n<p>通过demo体验地址进入对战平台，输入自己感兴趣的问题，提交问题后，匿名模型会两两对战，分别生成相关答案，需要用户对答案做出评判，从4个评判选项中选择一个：模型A更好、模型B更好、平手、都很差。支持多轮对话。最终使用Elo评分系统对大模型的能力进行综合评估。(可以自己指定模型看效果，但不计入最终排名情况)。</p>'),
                                                                        (110,	0,	0,	'<p>HELM全称Holistic Evaluation of Language Models（语言模型整体评估）是由斯坦福大学推出的大模型评测体系，该评测方法主要包括场景、适配、指标三个模块，每次评测的运行都需要指定一个场景，一个适配模型的提示，以及一个或多个指标。它评测主要覆盖的是英语，有7个指标，包括准确率、不确定性/校准、鲁棒性、公平性、偏差、毒性、推断效率；任务包括问答、信息检索、摘要、文本分类等。</p>'),
                                                                        (111,	0,	0,	'<p>MMBench是一个多模态基准测试，由上海人工智能实验室、南洋理工大学、香港中文大学、新加坡国立大学和浙江大学的研究人员推出。该体系开发了一个综合评估流程，从感知到认知能力逐级细分评估，覆盖20项细粒度能力，从互联网与权威基准数据集采集约3000道单项选择题。打破常规一问一答基于规则匹配提取选项进行评测，循环打乱选项验证输出结果的一致性，基于ChatGPT精准匹配模型回复至选项。</p>\n<h2>MMBench的特点和优势</h2>\n<ol>\n<li>基于感知与推理，将评估维度逐级细分。约 3000 道单项选择题，覆盖目标检测、文字识别、动作识别、图像<br>\n理解、关系推理等 20 个细粒度评估维度</li>\n<li>更具鲁棒性的评估方式。相同单选问题循环选项提问，模型输出全部指向同一答案认定为通过，相比传统1次性通过评估 top-1 准确率平均下降 10% ~ 20%。最大程度减少各种噪声因素对评测结果的影响，保证了结果的可复现性。</li>\n<li>更可靠的模型输出提取方法。基于 ChatGPT 匹配模型输出与选项，即使模型未按照指令输出也可准确匹配至最合理选项</li>\n</ol>\n<p> </p>'),
                                                                        (112,	0,	0,	'<p>CMMLU是一个综合性的中文评估基准，专门用于评估语言模型在中文语境下的知识和推理能力，涵盖了从基础学科到高级专业水平的67个主题。它包括：需要计算和推理的自然科学，需要知识的人文科学和社会科学，以及需要生活常识的中国驾驶规则等。此外，CMMLU中的许多任务具有中国特定的答案，可能在其他地区或语言中并不普遍适用。因此是一个完全中国化的中文测试基准。</p>'),
                                                                        (113,	0,	0,	'<p>OpenCompass是由上海人工智能实验室（上海AI实验室）于2023年8月正式推出的大模型开放评测体系，通过完整开源可复现的评测框架，支持大语言模型、多模态模型各类模型的一站式评测，并定期公布评测结果榜单。</p>'),
                                                                        (114,	0,	0,	'<p>SuperCLUE 是一个中文通用大模型综合性评测基准，从三个不同的维度评价模型的能力：基础能力、专业能力和中文特性能力。</p>\n<p>其中基础能力能力包括: 语义理解、对话、逻辑推理、角色模拟、代码、生成与创作等10项能力。</p>\n<p>专业能力包括: 包括了中学、大学与专业考试，涵盖了从数学、物理、地理到社会科学等50多项能力。</p>\n<p>中文特性能力: 针对有中文特点的任务，包括了中文成语、诗歌、文学、字形等10项多种能力。</p>'),
                                                                        (115,	0,	0,	'<p>FlagEval（天秤）由智源研究院将联合多个高校团队打造，是一种采用“能力—任务—指标”三维评测框架的大模型评测平台，旨在提供全面、细致的评测结果。该平台已提供了 30 多种能力、5 种任务和 4 大类指标，共 600 多个维度的全面评测，任务维度包括 22 个主客观评测数据集和 84433 道题目。</p>'),
                                                                        (116,	0,	0,	'<p>C-Eval是一个适用于大语言模型的多层次多学科中文评估套件，由上海交通大学、清华大学和爱丁堡大学研究人员在2023年5月份联合推出，包含了13948个多项选择题，涵盖了52个不同的学科和四个难度级别，用以评测大模型中文理解能力。</p>'),
                                                                        (117,	0,	0,	'<p>Open LLM Leaderboard 是最大的大模型和数据集社区 HuggingFace 推出的开源大模型排行榜单，基于 Eleuther AI Language Model Evaluation Harness（Eleuther AI语言模型评估框架）封装。</p>\n<p>由于社区在发布了大量的大型语言模型（LLM）和聊天机器人之后，往往伴随着对其性能的夸大宣传，很难过滤出开源社区取得的真正进展以及目前的最先进模型。因此，Hugging Face 使用 Eleuther AI语言模型评估框架对模型进行四个关键基准测试评估。这是一个统一的框架，用于在大量不同的评估任务上测试生成式语言模型。</p>\n<h2>Open LLM Leaderboard 的评估基准</h2>\n<ul>\n<li>AI2 推理挑战（25-shot）：一组小学科学问题</li>\n<li>HellaSwag（10-shot）：一个测试常识推理的任务，对人类来说很容易（大约95%），但对SOTA模型来说具有挑战性。</li>\n<li>MMLU（5-shot）- 用于测量文本模型的多任务准确性。测试涵盖57个任务，包括基本数学、美国历史、计算机科学、法律等等。</li>\n<li>TruthfulQA（0-shot）- 用于测量模型复制在在线常见虚假信息中的倾向性。</li>\n</ul>'),
                                                                        (118,	0,	0,	'<p>MMLU 全称 Massive Multitask Language Understanding，是一种针对大模型的语言理解能力的测评，是目前最著名的大模型语义理解测评之一，由UC Berkeley大学的研究人员在2020年9月推出。该测试涵盖57项任务，包括初等数学、美国历史、计算机科学、法律等。任务涵盖的知识很广泛，语言是英文，用以评测大模型基本的知识覆盖范围和理解能力。</p>'),
                                                                        (119,	0,	0,	'开源的机器学习模型监测和测试工具'),
                                                                        (120,	0,	0,	'在线运行开源机器学习模型'),
                                                                        (121,	0,	0,	'AI机器学习标注训练平台'),
                                                                        (122,	0,	0,	'简单免费的机器学习模型训练工具'),
                                                                        (123,	0,	0,	'<p>Watsonx.ai是IBM于5月9日发布的新一代企业级生成式人工智能和机器学习平台，Watsonx.ai将由基础模型驱动的新的生成性人工智能和传统的机器学习结合起来，成为一个跨越人工智能生命周期的强大平台。使用Watsonx.ai，开发人员可以轻松地训练、验证、调整和部署模型，只需用一小部分数据在短期时间内快速建立人工智能应用。预计Watsonx.ai将在7月全面上市。</p>'),
                                                                        (124,	0,	0,	'<p>StableVicuna 是由 Stable Diffusion 背后的 StabilityAI 推出的第一个通过基于人类反馈的强化学习（RLHF）训练的大规模开源聊天机器人。StableVicuna是Vicuna v0 13b的进一步指令微调和RLHF训练版本，它是一个指令微调的 LLaMA 130亿模型。</p>'),
                                                                        (125,	0,	0,	'Google AI文字到图像生成模型'),
                                                                        (126,	0,	0,	'AI模型开发社区'),
                                                                        (127,	0,	0,	'<p>Segment Anything Model（SAM）是Meta AI研究院最新推出的图像分割模型，该模型通过点或框等输入提示生成高质量的物体遮罩，并且可以用于为图像中的所有物体和对象生成遮罩。SAM模型在超过1100万张图像和11亿张掩模的数据集上进行了训练，并且在各种图像分割任务上具有强大的零样本性能。</p>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/cd19d73a6667a6c.jpeg\"  alt=\"Segment Anything图像\" width=\"800\" height=\"346\">'),
                                                                        (128,	0,	0,	'<p>OpenBMB全称为Open Lab for Big Model Base，旨在打造大规模预训练语言模型库与相关工具， 加速百亿级以上大模型的训练、微调与推理，降低大模型使用门槛，与国内外开发者共同努力形成大模型开源社区， 推动大模型生态发展，实现大模型的标准化、普及化和实用化，让大模型飞入千家万户。</p>\n<p>OpenBMB开源社区由清华大学自然语言处理实验室和智源研究院语言大模型加速技术创新中心共同支持发起。 发起团队拥有深厚的自然语言处理和预训练模型研究基础，近年来围绕模型预训练、提示微调、模型压缩技术等方面在顶级国际会议上发表了数十篇高水平论文。</p>'),
                                                                        (129,	0,	0,	'Meta（Facebook）推出的AI大语言模型'),
                                                                        (130,	0,	0,	'<div class=\"duet--article--article-body-component\">\n<p class=\"duet--article--dangerously-set-cms-markup duet--article--standard-paragraph mb-20 font-fkroman text-18 leading-160 -tracking-1 selection:bg-franklin-20 dark:text-white dark:selection:bg-blurple [&amp;_a]:shadow-underline-black dark:[&amp;_a]:shadow-underline-white [&amp;_a:hover]:shadow-highlight-franklin dark:[&amp;_a:hover]:shadow-highlight-blurple\">PaLM（Pathways Language Model） 是一种大型语言模型，即 LLM，类似于OpenAI 创建的 GPT 系列或Meta 的 LLaMA 系列模型。谷歌于 2022 年 4 月首次宣布推出 PaLM，超过了5400亿个训练参数。与其他 LLM 一样，PaLM 是一个灵活的系统，可以执行各种文本生成和编辑任务。例如，你可以将 PaLM 训练成像 ChatGPT 这样的对话式聊天机器人，或者你可以将它用于诸如总结文本甚至编写代码等任务。（这类似于谷歌今天也为其 Workspace 应用程序（如 Google Docs 和 Gmail）宣布的功能。）</p>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/9b46ee5da77b51e.webp\"  alt=\"PaLM 2 模型\" width=\"1600\" height=\"900\">\n<p>在 2023 谷歌 I/O 大会上，谷歌 CEO 皮查伊宣布推出对标 GPT-4 的大模型 PaLM 2，并正式发布预览版本，改进了数学、代码、推理、多语言翻译和自然语言生成能力。</p>\n<p>谷歌将为 PaLM 2 提供四种不同大小的版本，从最小到最大：Gecko、Otter、Bison 和 Unicorn。Gecko 非常轻巧，可以在移动设备上工作，并且速度足够快，即使在离线时也能在设备上运行出色的交互式应用程序。这种多功能性意味着可以对 PaLM 2 进行微调，以更多方式支持整个类别的产品，从而帮助更多人。</p>\n<h2>PaLM 2的特性</h2>\n<p>PaLM 2 是谷歌的下一代大语言模型，具有改进的多语言、推理和编码能力。</p>\n<ul>\n<li>多语言性： PaLM 2 在多语言文本方面接受了更多的训练，涵盖 100 多种语言。这显著提高了它在多种语言中理解、生成和翻译细微差别文本（包括成语、诗歌和谜语）的能力，这是一个很难解决的问题。PaLM 2 还通过了“精通”级别的高级语言能力考试。</li>\n<li>推理： PaLM 2 的广泛数据集包括科学论文和包含数学表达式的网页。因此，它展示了逻辑、常识推理和数学方面的改进能力。</li>\n<li>编程： PaLM 2 在大量公开可用的源代码数据集上进行了预训练。这意味着它擅长 Python 和 JavaScript 等流行的编程语言，但也可以生成 Prolog、Fortran 和 Verilog 等语言的专用代码。</li>\n</ul>\n</div>'),
                                                                        (131,	0,	0,	'微软开源的低成本实现类似ChatGPT的模型训练'),
                                                                        (132,	0,	0,	'<p>天工作为一款大型语言模型，拥有强大的自然语言处理和智能交互能力，能够实现智能问答、聊天互动、文本生成等多种应用场景，并且具有丰富的知识储备，涵盖科学、技术、文化、艺术、历史等领域。该模型由昆仑万维与奇点智源联合研发，是国内首个对标 ChatGPT 的双千亿大语言模型。</p>'),
                                                                        (133,	0,	0,	'<p>商量SenseChat是由商汤科技研发的一款基于自然语言处理技术的人工智能大语言模型，具备超凡的语言理解、生成能力，将科技与人文相互交融。类似于ChatGPT，作为高效聊天助手，它能秒解复杂问题，提供定制化建议，还能辅助创作一流文本，具备不断学习进化的特性。</p>'),
                                                                        (134,	0,	0,	'Runway最新推出的AI视频生成模型'),
                                                                        (135,	0,	0,	'<p>StableLM是由Stable Diffusion背后的团队Stability AI最新推出的开源的类ChatGPT大语言模型，该模型目前处于Alpha版本，拥有的参数量分别为30亿和70亿，后续还将推出150亿到650亿参数模型。</p>'),
                                                                        (136,	0,	0,	'<p>Lamini是一个LLM引擎，可以让不仅仅是机器学习专家的任何开发人员，都能在大型数据集中，把高性能的LLM训练得像ChatGPT一样好。</p>'),
                                                                        (137,	0,	0,	'<p>M6是阿里巴巴达摩院推出的，中文社区最大的跨模态预训练模型，模型参数达到十万亿以上，具有强大的多模态表征能力。M6通过将不同模态的信息经过统一加工处理，沉淀成知识表征，为各个行业场景提供语言理解、图像处理、知识表征等智能服务</p>'),
                                                                        (138,	0,	0,	'<p>HuggingFace推出的大型语言模型（LLM）</p>'),
                                                                        (139,	0,	0,	'阿里达摩院推出的AI模型社区，超过300+开源AI模型'),
                                                                        (140,	0,	0,	'<p>序列猴子是出门问问推出的一款超大规模的语言模型，具有长序列、多模态、单模型、大数据等特点。利用其通用的表示能力与推理能力，用户能够进行多轮交互，从而在使用中获得更加便捷流畅的体验。</p>'),
                                                                        (141,	0,	0,	'百度推出的产业级知识增强大模型'),
                                                                        (142,	0,	0,	'OpenAI旗下AI代码生成训练模型'),
                                                                        (143,	0,	0,	'OpenAI旗下DALL·E 2图像生成模型'),
                                                                        (144,	0,	0,	'<p>Cohere是一个提供大语言模型的平台，帮助开发人员和企业构建高性能的AI产品。该平台主要提供AI驱动的搜索文本（多语言嵌入、神经搜索、搜索排名）、分类文本和生成文本等服务，可帮助企业快速部署对话式AI聊天机器人、生成式搜索引擎、文本摘要总结、增强向量检索等。</p>\n<p>5月3日，Cohere公司获2.5亿美元融资，目前估值约20亿美元，投资者包括Saleforce、Nvidia、Index Ventures等。该公司的联合创始人 Aidan Gomez 是《Attention Is All You Need》论文的作者之一，此论文提出了 GPT 等大语言模型的采用的 Transformer 架构。</p>\n<p>Cohere提供了一个Playground供用户试玩，如果你感兴趣的话可以访问试试看。另外Cohere还推出了LLM University，一个学习大语言模型的课程，可帮助你了解大型语言模型及其体系结构的基础知识。</p>'),
                                                                        (145,	0,	0,	'<p>DeepFloyd IF是由StabilityAI旗下的DeepFloyd研究团队推出的开源的文本到图像生成模型，IF是一个基于级联方法的模块化神经网络。</p>\n<ul>\n<li>IF是由多个神经模块（处理特定任务的独立神经网络）构建的，在一个架构内联合起来产生协同效应。</li>\n<li>IF以级联方式生成高分辨率图像：从产生低分辨率样本的基础模型开始，然后由一系列的升级模型提升，以创造令人惊叹的高分辨率图像。</li>\n<li>IF的基础和超分辨率模型采用扩散模型，利用马尔可夫链步骤将随机噪声引入数据中，然后再反转过程，从噪声中生成新的数据样本。</li>\n<li>IF在像素空间内操作，而不是依赖潜伏图像表征的潜伏扩散（如稳定扩散）。</li>\n</ul>'),
                                                                        (146,	0,	0,	'<p>Gradio是一个开源的Python库，用于构建演示机器学习或数据科学，以及web应用程序。你可以使用Gradio基于自己的机器学习模型或数据科学工作流快速创建一个漂亮的用户界面，让用户可以尝试拖放他们自己的图像、输入文本、录制他们自己的声音，并通过浏览器与你的演示程序进行交互。Google、HuggingFace、亚马逊、Meta、思科、VMware等公司都在使用。</p>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/beb9fce2493d094.png\"  alt=\"Gradio宣传图\" width=\"800\" height=\"415\">\n<p>Gradio适用于:</p>\n<ul>\n<li>向客户/合伙人/用户/学生演示您的机器学习模型。</li>\n<li>通过自动共享链接快速部署您的模型，并获得模型性能反馈。</li>\n<li>在开发过程中使用内置的操作和解释工具交互式地调试模型。</li>\n</ul>'),
                                                                        (147,	0,	0,	'<p>腾讯混元大模型是由腾讯自主研发的大语言模型，拥有超千亿参数规模，预训练语料超2万亿tokens，具有强大的中文理解与创作能力、逻辑推理能力，以及可靠的任务执行能力。</p>\n<h2>腾讯混元的产品功能</h2>\n<ol>\n<li>多轮对话。具备上下文理解和长文记忆能力，流畅完成各专业领域的多轮问答；</li>\n<li>内容创作。支持文学创作、文本摘要、角色扮演能力，流畅、规范、中立、客观；</li>\n<li>逻辑推理。准确理解用户意图，基于输入数据或信息进行推理、分析；</li>\n<li>知识增强。有效解决事实性、时效性问题，提升内容生成效果；</li>\n<li>多模态。支持文字生成图像能力，输入指令即可将奇思妙想变成图画。</li>\n</ol>\n<h2>腾讯混元的应用场景</h2>\n<ol>\n<li>文档场景。可提供文档创作、文本润色、文本校阅、表格公式及图表生成等能力，提高创作效率，提升创作体验；</li>\n<li>会议场景。可提供会中问答、会议总结、会议待办项整理等能力，简化会议操作并提高会议效率；</li>\n<li>广告场景。可提供智能化的广告素材创作，提供AI多模态生成能力，提升营销内容创作工作效率；</li>\n<li>营销场景。构建智能导购，帮助商家提升服务质量和服务效率。</li>\n</ol>\n<h2>腾讯混元的官网入口</h2>\n<p>用户可通过hunyuan.tencent.com访问腾讯混元大模型的网页，或者微信小程序搜索「腾讯混元助手」，然后申请内测体验即可。</p>'),
                                                                        (148,	0,	0,	'<p>2021年6月，北京智源研究院（BAAI）推出了悟道1.0的后续版本悟道2.0，作为中国第一个超大规模智能模型系统。悟道是一个语言模型，旨在在人类层面的思维上超越 OpenAI 的 GPT-3 和谷歌的 LaMDA。经过4.9TB的图像和文本训练，并在9个基准上超过了最先进（SOTA）水平，悟道比任何同行都更接近于实现通用人工智能（AGI）和人类水平的思维。</p>\n<p>悟道接受了4.9 TB高质量英文和中文图像和文本的训练：</p>\n<ul>\n<li>1.2TB中文文本数据</li>\n<li>2.5TB中文图形数据</li>\n<li>1.2TB英文文本数据</li>\n</ul>\n<p>悟道是基于开源的 MoE 系统 FastMoE 进行训练的。MoE是一种机器学习技术，其工作原理如下：</p>\n<p>将预测建模任务划分为子任务，针对每个子任务训练专家（学习者）模型，开发门控模型，该门控模型基于要预测的输入来学习咨询哪个专家，并组合预测。FastMoE使悟道能够并行咨询不同的专家模型，并切换到预测结果最好的模型。例如，如果输入是英文文本，悟道将使用预测模型，该模型可以在英文文本中生成回应。</p>'),
                                                                        (149,	0,	0,	'在浏览器中组装、配置和部署自主人工智能的开源项目'),
                                                                        (150,	0,	0,	'<p>Auto-GPT是一个实验性开源应用程序，展示了GPT-4语言模型的真正潜力，GitHub上超10万人星标。该程序由 GPT-4 驱动，将LLM大语言模型思维链接在一起，以自主实现你设定的任何目标。作为GPT-4完全自主运行的首批例子之一，Auto-GPT突破了人工智能的极限，距离AGI通用人工智能又近了一步。<strong>大家注意甄别autogpt.net不是其官方网站，agpt.co才是。</strong></p>'),
                                                                        (151,	0,	0,	'<h2>MiracleVision奇想智能是什么</h2>\n<p>MiracleVision奇想智能是由美图秀秀公司推出的自研AI视觉大模型，不仅具备高度的美学导向和图像处理能力，还能够广泛地应用于多个行业，提高工作流效率。同时，它还提供了简单易用的AI视觉创作工具，使用户能够快速进行图像的创作和编辑。最新的MiracleVision 4.0支持AI图片生成、AI设计排版和AI视频生成等能力。</p>\n<img  class=\"alignnone size-full rounded-lg shadow-sm border-0\" src=\"/uploadfile/202312/0bfc30ab803d9f5.png\"  alt=\"MiracleVision奇想智能\" width=\"800\" height=\"450\">\n<h2>MiracleVision奇想智能的主要能力</h2>\n<ol class=\"text-md\">\n<li>AI图片生成，支持文生图和图生图，输入文字或上传图像即可创作图片，提供多种风格、参数调整、图片尺寸、精准画面控制等</li>\n<li>AI智能设计，包括矢量图形、文字特效、智能分层和智能排版，可以满足AI设计的基础需求</li>\n<li>AI视频生成，提供文生视频、图生视频、视频运镜、视频生视频四大功能，让奇思妙想动起来</li>\n<li>视觉模型商店，平台提供丰富的视觉模型，从经典复古到现代潮流、从超现实幻想到极简抽象，用户可以任意选择创造惊艳的视觉效果</li>\n</ol>\n<h2>MiracleVision奇想智能的适用行业</h2>\n<ol class=\"text-md\">\n<li>电商行业：从涂鸦生成线稿、线稿上色、商品图、模特试穿图，再到电商物料输出，全程可通过MiracleVision实现。</li>\n<li>游戏制作：包揽场景设计、角色设计、道具设计、UI图标、宣发物料等流程，拓宽设计师想象空间的同时助力游戏行业降本。</li>\n<li>影视行业：充分满足概念场景设计、分镜设计、人物造型、道具设计、宣发物料的效果要求，极大提升影视行业设计环节的效率。</li>\n<li>广告设计：覆盖创意脑暴、创意深化、平面排版、多尺寸延展、线下投放预览的全工作流，助力客户在广告物料制作环节提效。</li>\n<li>动漫卡通：打通了概念设计、故事板生成、线稿上色、动漫补帧、视频转动漫等流程，支持创意到物料成品的快速落地。</li>\n</ol>'),
                                                                        (152,	0,	0,	'<p>词魂是一个AIGC精品提示词库，你可以在这里找到各类用于AI绘画的提示词和咒语，帮助你更好的使用AI工具，快速得到想要的效果，提升工作效率。如果你是一位优秀的提示词创作者，你还可以在这里销售自己的提示词。</p>'),
                                                                        (153,	0,	0,	'<p>ChatGPT Shortcut是国内开发者推出的ChatGPT提示指令的开源项目，GitHub目前星标3.5K，让你使用ChatGPT的生产力加倍，按照领域和功能分区，可对提示词进行标签筛选、关键词搜索和一键复制。</p>\n<ul dir=\"auto\">\n<li>🚀 <strong>简化流程</strong>：ChatGPT Shortcut 提供了快捷指令表，可以快速筛选和搜索适用于不同场景的提示词，帮助用户简化使用流程。</li>\n<li>💻 <strong>提高生产力</strong>：通过使用优化过的提示词，用户可以获得更加准确、有用的回复，从而提高生产力。</li>\n<li>🎓 <strong>适合初学者</strong>：即使是初学者，只需复制提示词，稍加修改后发送给 ChatGPT，就能获得指定输出。</li>\n<li>🆕 <strong>定期更新</strong>：ChatGPT Shortcut 的提示词来自网络精选、投稿和 Awesome ChatGPT Prompts，定期进行更新，为用户提供新的提示词和思路。</li>\n<li>🇨🇳 <strong>中文优化</strong>：虽然提示词仍然使用英文，但提供了中文翻译，支持默认中文回复，方便中文用户理解和使用。</li>\n</ul>'),
                                                                        (154,	0,	0,	'免费的 Prompt Engineering 教程（中文开源）'),
                                                                        (155,	0,	0,	'ChatGPT Prompts集合'),
                                                                        (156,	0,	0,	'ChatGPT Prompts和应用'),
                                                                        (157,	0,	0,	'AI Prompts集合市场'),
                                                                        (158,	0,	0,	'免费开源的ChatGPT Prompt浏览器扩展'),
                                                                        (159,	0,	0,	'可视化AI提示语选择和搭建'),
                                                                        (160,	0,	0,	'Midjourney Prompt帮助工具'),
                                                                        (161,	0,	0,	'<p>绘AI致力于探索和创造一种全新的AI提示词创作成果展示和赚取收益的方式，以AI画师上传的优秀AI绘画提示词作为核心内容，为全国AI画师用户搭建共享共赢的提示词分享交流平台，让热爱AI绘画的画师们聚集在一起，创造更多的价值。</p>'),
                                                                        (162,	0,	0,	'主要针对于SEO和SaaS文案写作的ChatGPT Prompts浏览器扩展'),
                                                                        (163,	0,	0,	'<p>提示工程指南（Prompt Engineering Guide）是由 DAIR.AI 发起的项目，旨在帮助研发和行业内相关人员了解提示工程。以传播 AI 技术和研究成果为目标，DAIR.AI 的愿景是赋能新一代 AI 领域的创新者。该免费开源的提示工程项目在GitHub上已超过3万个人标星，包含了与 LLM 提示工程相关的所有最新论文、学习指南、讲座、参考资料和工具。</p>\n<h2>提示工程指南（Prompt Engineering Guide）的目录</h2>\n<p>一、提示工程简介</p>\n<ul>\n<li>大语言模型设置</li>\n<li>基本概念</li>\n<li>提示词要素</li>\n<li>设计提示的通用技巧</li>\n<li>提示词示例</li>\n</ul>\n<p>二、提示技术</p>\n<ul>\n<li>零样本提示</li>\n<li>少样本提示</li>\n<li>链式思考（CoT）提示</li>\n<li>自我一致性</li>\n<li>生成知识提示</li>\n<li>思维树Tree of Thoughts</li>\n<li>检索增强生成</li>\n<li>自动推理和工具使用</li>\n<li>自动提示工程师</li>\n<li>Active-Prompt</li>\n<li>方向性刺激提示</li>\n<li>ReAct框架</li>\n<li>多模态思维链提示方法</li>\n<li>基于图的提示</li>\n</ul>\n<p>三、提示应用</p>\n<ul>\n<li>程序辅助语言模型</li>\n<li>生成数据</li>\n<li>Generating Code</li>\n<li>毕业生工作分类案例研究</li>\n<li>Prompt Function</li>\n</ul>\n<p>四、模型</p>\n<ul>\n<li>Flan</li>\n<li>ChatGPT</li>\n<li>LLaMA</li>\n<li>GPT-4</li>\n<li>Model Collection</li>\n</ul>\n<p>五、风险和误用</p>\n<ul>\n<li>对抗性提示</li>\n<li>真实性</li>\n<li>偏见</li>\n</ul>\n<p> </p>'),
                                                                        (164,	0,	0,	'<p>输入正确的提示词，可以让ChatGPT生成更好的结果，使用Snack Prompt可以帮助你解锁人工智能的潜力，优化你的ChatGPT体验。在Snack Prompt社区，用户可以访问每天新鲜出炉的大量热门提示词库：</p>\n<ul>\n<li>⚡ 一键提示：只需单击一次，即可立即访问一系列专业策划的提示prompts。</li>\n<li>🏆 每日最佳提示：随时掌握最佳和最受欢迎的提示。</li>\n<li>🗳️ 社区投票系统：就像产品搜索或Reddit一样，该社区驱动的平台将最热门的提示显示在顶部。</li>\n<li>💾 保存提示：轻松组织和管理你喜欢的提示，以备将来使用。</li>\n<li>🔍 搜索和发现提示：快速定位到满足你需求的完美提示。</li>\n</ul>'),
                                                                        (165,	0,	0,	'免费高质量的Prompts集合'),
                                                                        (166,	0,	0,	'<p>当你第一次开始使用DALL•E 2时，可能会感觉有点无从下手，而Generrated便提供了一个让你进行图像生成前的参考和灵感工具。只需在Generrated官网上单击你喜欢的图像，便可以查看用于生成该图像的提示用语。</p>'),
                                                                        (167,	0,	0,	'专为 Prompt 编写者设计的工具'),
                                                                        (168,	0,	0,	'发现Stable Diffusion、ChatGPT和Midjourney的提示用语'),
                                                                        (169,	0,	0,	'OpenArt推出的针对Stable Diffusion指令的手册'),
                                                                        (170,	0,	0,	'ChatGPT指令大全'),
                                                                        (171,	0,	0,	'<p>PromptPerfect 是一款专业好用的提示词优化工具，可帮助用户一站式设计、开发、优化和部署提示词，支持优化 GPT-4、ChatGPT、文心一言、Claude、Llama、Midjourney、Stable Diffusion 等各大主流文本和图像模型的提示词。</p>\n<h2>PromptPerfect 的产品功能</h2>\n<ol>\n<li>自动优化大模型提示词。只需输入初步简单的提示词，PrompPerfect便会自动为你优化为更加专业详细全面的提示，让生成的效果更好。</li>\n<li>批量优化提示词。支持上传 CSV 文件并优化该文件中的所有提示词，接受 .csv 或 .tsv 文件。</li>\n<li>API 部署和集成。PromptPerfect 提供易于使用的 API，可以一次性优化大量提示词。适合将该功能集成到应用程序、网站或服务中的商业用户。</li>\n</ol>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/a1c8028dd74c9.png\"  alt=\"PromptPerfect\" width=\"800\" height=\"450\">\n<h2>PromptPerfect 支持的 AI 模型</h2>\n<ol>\n<li>文本模型：支持ChatGPT、GPT-4、StableLM 7b、Claude、Claude 2、文心一言、Llama 2（70b、13b、7b）、Cohere Command、JinaChat、GPT-3</li>\n<li>图像模型：DALL-E 2、Stable Diffusion、Midjourney、Stable Diffusion XL、Kandinsky 2.2、DreamShaper、AbsoluteReality、万象熔炉 Anything、Deliberate、Lexica</li>\n</ol>'),
                                                                        (172,	0,	0,	'免费在线检测AI内容'),
                                                                        (173,	0,	0,	'强大的AI内容检测解决方案'),
                                                                        (174,	0,	0,	'AI内容检测和分级'),
                                                                        (175,	0,	0,	'原创度和AI内容检测'),
                                                                        (176,	0,	0,	'Writer推出的AI内容检测工具'),
                                                                        (177,	0,	0,	'在线检查文本是否由GPT-3或ChatGPT生成'),
                                                                        (178,	0,	0,	'Sapling.ai推出的免费在线AI内容检测工具'),
                                                                        (179,	0,	0,	'多语种AI内容检测工具'),
                                                                        (180,	0,	0,	'Writecream推出的AI内容检测工具'),
                                                                        (181,	0,	0,	'<p>AISEO AI Content Detector 是由人工智能 SEO 文章工具 AISEO 推出的 AI 内容检测器，通过先进的算法来分析文本中的模式和结构并识别是由机器还是人类生成内容。该工具可以快速检测人工智能生成的内容，帮助文章创作者保持内容的质量和真实性。</p>'),
                                                                        (182,	0,	0,	'<p>StudyCorgi ChatGPT Detector 是由在线论文数据库和平台 StudyCorgi 推出的免费的检测论文是否由 ChatGPT 生成的工具，该款 AI 论文检测器对学生和教师都是完全免费使用的。只需添加或输入要检测的文本内容，点击检查文字按钮即可获得关于文章是否由 AI 创建的可能性比例分析。<br>\n<img  src=\"/uploadfile/202312/3271e76c0988289.png\"  alt=\"StudyCrogi ChatGPT Detector检测结果\" width=\"800\" height=\"450\" class=\"alignnone size-full rounded shadow-sm\"></p>\n<h2>StudyCorgi ChatGPT Detector的功能</h2>\n<ol>\n<li>免费学术文章检测，无需登录注册即可免费在线检测学术论文或任何文本是否是由ChatGPT生成的。</li>\n<li>不同颜色进行分类标记，使用绿色、黄色、红色、紫色等颜色突出显示标记AI最可能使用的单词。</li>\n<li>单词由AI生成的概率比例高亮，直方图显示单词比例越大，论文由人工智能生成的概率越高。</li>\n<li>详细单词统计分析，单击每个单词，可以看到AI聊天机器人使用该单词的概率。</li>\n</ol>\n<h2>如何使用StudyCorgi ChatGPT Detector</h2>\n<ol>\n<li>访问StudyCorgi ChatGPT Detector的官网，在文本框输入或添加相关内容（最多4500个字符）</li>\n<li>可选择性地输入主题、标题或简短描述</li>\n<li>点击Check the text按钮即可免费获得详细的分析</li>\n</ol>'),
                                                                        (183,	0,	0,	'<h2 class=\"d-none\">GPTZero是什么？</h2>\n<p>GPTZero是一款检测人工智能生成内容的工具，旨在识别和分析输入的文本是否是由AI创建的，区分人类创作和人工智能生成的内容。该工具支持句子、段落和文档级别的AI内容检测，由普林斯顿大学的Edaward Tian开发并于2023年1月上线，以回应业界对AI生成内容原创度和抄袭的担忧，一经上线便获得了各大媒体如纽约时报、华盛顿时报、福布斯、连线杂志等的关注和报道。GPTZero 累计已为全球超过 250 万用户提供服务，并与 100 多个教育、招聘、出版、法律等领域的组织合作。</p>\n<img  class=\"alignnone size-full rounded shadow-sm\" src=\"/uploadfile/202312/73f9b66383a156e.png\"  alt=\"GPTZero检测器\" width=\"800\" height=\"450\">\n<h2>GPTZero的主要功能</h2>\n<ol>\n<li>支持检测多个大模型，可用于ChatGPT、GPT4、Bard、LLaMa和其他人工智能模型生成的内容</li>\n<li>支持多种文本格式，可直接在线输入文本，或者上传.pdf、.doc、.docs、.txt等格式的文件进行检测</li>\n<li>浏览器扩展实时检测，提供Chrome浏览器插件，可检测和分析浏览互联网查内容是否是由AI生成的</li>\n<li>批量文件扫描，支持一次性上传多个文件以进行 AI 内容检测，节省重复上传的时间</li>\n</ol>\n<h2>GPTZero的产品价格</h2>\n<ol>\n<li>免费基础版，支持每月检测和扫描1万字，批量扫描10个文件</li>\n<li>付费起步版10美元每月，支持每月检测和扫描15万字，批量扫描10个文件</li>\n<li>付费高级版16美元每月，支持每月检测和扫描30万字，无限批量文件扫描</li>\n</ol>\n<h2>常见问题</h2>\n<div id=\"accordion\" style=\"max-width: 700px;\">\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>GPTZero是免费的吗？</strong></div>\n<div class=\"card-body text-sm\">GPTZero提供免费版本，免费用户每月可检测和扫描1万个单词，支持批量扫描10个文件。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>GPTZero的检测原理是什么？</strong></div>\n<div class=\"card-body text-sm\">GPTZero利用机器学习技术和自然语言处理算法对一个大型的文本语料库（同时含有人类书写的和AI生成的）进行训练，然后将用户输入的文本进行比对和预测原创度。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>GPTZero只支持检测ChatGPT吗？</strong></div>\n<div class=\"card-body text-sm\">GPTZero不限于 ChatGPT，还支持 GPT-4、GPT-3、GPT-2、LLaMA 以及基于这些模型的 AI 服务。</div>\n</div>\n</div>'),
                                                                        (184,	0,	0,	'<p>Notta是一个基于人工智能的语音转文本转录工具，可以帮助你以98%的准确率将104种语言的任何音频转换为文本。Notta适用于任何现代设备，如PC、智能手机和平板电脑，无论你是想从麦克风转录在线会议、网页音频、音频文件还是现场录音，Notta都可以处理。如果你正在寻找一种可靠且专业的工具来将音频在线转录为文本，试试用Notta来制作会议记录和撰写采访文章吧，让你的工作更轻松。</p>'),
                                                                        (185,	0,	0,	'AI文本转语音工具'),
                                                                        (186,	0,	0,	'AI变声工具'),
                                                                        (187,	0,	0,	'AI文本到语音生成器'),
                                                                        (188,	0,	0,	'实时AI变声工具'),
                                                                        (189,	0,	0,	'AI文本到语音生成工具'),
                                                                        (190,	0,	0,	'<p>Speechify是一个知名度很高的AI文字转语音的工具，累计已超过2000万人使用，该工具使用用智能的文本转语音技术，可以轻松朗读任何文档、文章、书籍、PDF和电子邮件。只需输入你想听到的文字，选择语音和收听速度，点击生成，即可快速将文字转换成语音。</p>'),
                                                                        (191,	0,	0,	'AI实时变声工具'),
                                                                        (192,	0,	0,	'Clipchamp的文字转语音生成器'),
                                                                        (193,	0,	0,	'Veed推出的AI语音生成器'),
                                                                        (194,	0,	0,	'在线AI文字转语音生成工具'),
                                                                        (195,	0,	0,	'AI人声和文本转语音生成工具'),
                                                                        (196,	0,	0,	'<p>Boomy是一个帮助用户释放创意快速生成原创音乐的平台，该AI音乐生成工具累计已生成超过1600万首音乐。Boomy创作的音乐还可以分发到如Spotify等的流媒体平台，以使创作者从版税中获利分成。Boomy的免费版允许用户创建和编辑并保存25首音乐。</p>'),
                                                                        (197,	0,	0,	'<p>Soundraw是一个专为创作者打造的AI音乐生成器，无需任何音乐创作知识，几分钟内便可以创作出与你的内容完美匹配的歌曲。用户只需访问Soundraw，点击Create Music选项，然后选择相关标签生成音乐即可。</p>'),
                                                                        (198,	0,	0,	'AI音乐生成工具'),
                                                                        (199,	0,	0,	'<p>Murf是一个多功能的AI语音生成器，可以帮助用户在几分钟内制作录音室级别品质的配音。利用其提供的在线AI文本转语音，可以生成逼真的AI声音，用于播客、视频和任何专业的音频演示需求。</p>'),
                                                                        (200,	0,	0,	'<p>PlayHT是一个人工智能驱动的语音生成网站，提供逼真的AI文本转语音工具，可以快速将文本转换为自然的、类似人类的音频，跨越任何语言和口音。你可以将其用于视频编辑、在线学习和培训、AI语音应答、创建音频文章朗读、自媒体视频旁白等各种应用场景。</p>'),
                                                                        (201,	0,	0,	'AI噪音消除工具'),
                                                                        (202,	0,	0,	'AI人声乐器分离和提取'),
                                                                        (203,	0,	0,	'转录和理解语音的AI模型'),
                                                                        (204,	0,	0,	'AI文本转语音工具'),
                                                                        (205,	0,	0,	'AI音频清洗工具（噪音消除、声音平衡、音量调节）'),
                                                                        (206,	0,	0,	'<p>BeatBot是一个AI歌曲和音乐生成工具，用户只需输入文本描述，点击Generate按钮便可以快速生成不同风格的音乐。</p>'),
                                                                        (207,	0,	0,	'<p>Beatoven.ai使用先进的人工智能音乐生成技术来创作独特的基于情绪的音乐，以适合内容创作者视频或播客的每一部分，生成符合创作者叙事的独特免版税音乐。</p>'),
                                                                        (208,	0,	0,	'<p>Mubert是一个简单好用的人工智能生成音乐的在线网站，可以帮助创作者将AI生成的音乐应用于视频内容、播客和应用程序等。用户只需在Mubert Render网页上，可以输入任何文本描述内容，如风格、流派或情绪的名称，该AI音乐生成器将生成一条持续时间长达 25 分钟的合适曲目。</p>'),
                                                                        (209,	0,	0,	'<p>悦音配音是制片帮旗下推出的一款AI智能在线配音语音合成工具，可以帮助用户在线将文字输入快速轻松转换成语音。该AI配音工具提供男声、女声、童声、普通话、方言、英文等多种真人声音，在你输入文字后便可以直接智能生成音频。</p>\n<h2>悦音配音的特色功能</h2>\n<ol>\n<li>媲美真人的AI智能配音，海量音色库提供不同风格的男声（如磁性浑厚、真实自然、新闻主播等风格）、女声（如温柔甜美、客服女声、电台新闻女声等风格）和童音（如稚嫩可爱、萝莉女声、阳光青春等风格）</li>\n<li>支持多种语种和方言的配音，包括普通话、英文、方言（如东北话、四川话、粤语、台湾话、湖南口音等）和其他多语言（如日语、葡萄牙语、韩语、西班牙语等）</li>\n<li>AI智能违禁词检测，提供行业内最新广告法，各平台敏感词，通用、新闻等违禁词在线查询检测。</li>\n<li>适用于短视频、政企宣传、教育培训、动漫、有声读物、影视广告、产品介绍、情感电台等数百个行业场景。</li>\n</ol>\n<h2>悦音配音的产品价格</h2>\n<p>悦音配音目前为用户提供了三个等级的定价</p>\n<ol>\n<li>免费会员 - 注册后便可以免费使用，单条合成300字，每月可合成1000字</li>\n<li>VIP尊贵会员 - 99元一年，单条合成10000字，每月可合成30万字</li>\n<li>SVIP超级会员 - 399元一年，单条合成20000字，每月可合成70万字+解锁情绪主播等</li>\n</ol>\n<h2>常见问题</h2>\n<p><strong>Q：悦音配音支持哪些系统和平台？</strong></p>\n<p>A：除在线网页端外，还支持iOS和Android手机端使用，随身随时随地高效创作。</p>\n<p><strong>Q：悦音配音生成的配音是否可以商用？</strong></p>\n<p>A：会员购买后可在线生成商用授权书，可以商用</p>\n<p><strong>Q：悦音配音支持哪些音频下载格式？</strong></p>\n<p>A：目前悦音配音的音频支持MP3及无损WAV格式下载</p>'),
                                                                        (210,	0,	0,	'<p>BGM猫是由北京灵动音科技有限公司推出的一款AI智能生成BGM音乐的工具，用户只需选择音乐时长和对应标签便能自动生成BGM。该AI音乐生成器允许用户选择30秒到5分钟的音乐时长，根据用户选择的场景、风格和心情标签来生成视频配乐或片头音乐。BGM猫支持生成以下不同类型的音乐：</p>\n<ul>\n<li>场景：时尚/美妆/穿搭、数码科技、旅行、搞笑/恶搞、知识/科普、运动/健身、庆祝/节日、萌宠、美食、vlog等</li>\n<li>风格：古风、电子、R&amp;B、爵士、轻音乐/钢琴、节奏感/卡点、摇滚</li>\n<li>心情：慵懒、欢快、燃/励志、治愈/感动、俏皮、浪漫、紧张/恐怖/悬疑、伤感煽情催泪、大气/磅礴</li>\n</ul>'),
                                                                        (211,	0,	0,	'Deep Fake文本转语音'),
                                                                        (212,	0,	0,	'IBM Watson文字转语音'),
                                                                        (213,	0,	0,	'AI人声生成工具'),
                                                                        (214,	0,	0,	'<p>ACE Studio是时域科技推出的免费AI音乐合成工具，支持Windows和Mac系统，可实时AI歌声合成，虚拟歌姬演唱真实度无限接近人类，纵享美妙丝滑的听觉体验。支持导出多种形式的音频文件，方便后期深度加工。</p>\n<h2>ACE Studio的特色功能</h2>\n<ol>\n<li>创造不同凡响的声线。使用声线混合，从丰富的声线种子中混合制造全新的理想声线，让不可能变得轻而易举。</li>\n<li>性能强劲的新一代AI人声合成引擎。使用先进的全流程AI技术，在不断追求提升声线自然度与演唱表现力的同时，也将合成速度不断推向极致。</li>\n<li>众多高水平的AI歌手。从流行到民歌、童声到摇滚...数十位精通中日英三语的高水平AI歌手为您尽其所能，满足全场景音乐制作需求。</li>\n<li>细节参数调整，尽情表达每一处细腻的情感。歌声不是只有歌词和音高，您还可以把控呼吸、气声、假声、张力、力度等多维度AI演唱参数，让情感时刻掌控。</li>\n</ol>\n<h2>ACE Studio的产品价格</h2>\n<p>ACE Studio目前在免费公测当中，所有的用户使用手机号登录/注册后，便可以免费使用。</p>'),
                                                                        (215,	0,	0,	'<p>“网易云音乐·X Studio”是由网易云音乐与小冰公司最新联合推出的AI歌手音乐创作软件，面向广大音乐人和音乐爱好者免费使用。该AI音乐生成器可帮助音乐人轻松创作高质量的AI新世代音乐作品，是全球主流音乐平台与人工智能公司联手打造的首个同类产品。</p>\n<h2>网易云音乐·X Studio的主要功能</h2>\n<ol>\n<li>支持Windows与macOS双平台，搭载了丰富的前沿性人工智能小冰黑科技，并经过双方深度合作定制调校。</li>\n<li>技术方面，包括小冰歌唱模型、一致性超级自然语音、流式渲染歌声合成和视觉神经网络渲染等技术。</li>\n<li>在演唱方面，可在3秒内生成专业歌手水准的AI演唱干声，还能通过参数实现AI歌手的滑音、转音、颤音、咬字、节奏、音色或强弱变化等，细腻演绎作品效果。</li>\n<li>性能强大，支持合并AI音轨数量高达30轨，这意味着让每个音乐人都拥有一支“30人”合唱团。</li>\n<li>软件首发12名AI歌手，并将不断推新。AI歌手阵营具备高度拟人及多样化的声线风格，可适配流行、民谣、国风、电子、摇滚等各种曲风。</li>\n</ol>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/5120054adc36920.png\"  alt=\"网易云音乐·X Studio的界面\" width=\"800\" height=\"452\">\n<h2>如何使用网易云音乐·X Studio</h2>\n<ol>\n<li>访问网易云音乐·X Studio官网，下载对应的Windows或Mac客户端应用程序</li>\n<li>安装完毕后，打开软件，使用网易云音乐扫码登录软件</li>\n<li>点击开始创作，进入到软件主操作界面，导入MIDI和伴奏音频</li>\n<li>鼠标右键点击任意音符，编辑全部歌词，输入歌词，点击确定</li>\n<li>点击播放键，加载后便可以听到AI歌手的演唱效果了</li>\n<li>确认效果后，鼠标点击右上角的导出按钮，即可导出音频</li>\n</ol>\n<h2>网易云音乐·X Studio是免费的吗</h2>\n<p>目前网易云音乐·X Studio软件是完全免费提供给广大音乐人和音乐爱好者使用的，无需付费，只用在官网下载对应的客户端登录账号使用即可。</p>'),
                                                                        (216,	0,	0,	'<p>ElevenLabs 是国外一个火爆的AI文字转语音平台，目前已完成测试阶段并推出了正式版。借助先进的多语言人工智能技术，ElevenLabs 可以自动识别包括中文在内的28种语言，并将其转换为逼真的语音。免费版提供每月10000个字符的转换和创建3个自定义声音。</p>\n<h2>ElevenLabs的产品功能</h2>\n<ol>\n<li>AI语音合成，提供文本转语音工具，支持多种类型的声音、风格和语言生成高质量的口语音频。</li>\n<li>AI语音克隆，提供声音克隆工具，无需输入文本便可以快速克隆自己的声音</li>\n<li>高质量语音库，ElevenLabs提供了一个高品质人工智能语音库社区，用户可选择加入Discord交流和分享</li>\n<li>音频编辑工具，提供调整节奏、分割声音的工作台以完全控制创作过程</li>\n</ol>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/f886f5b3e4e05d8.png\"  alt=\"ElevenLabs语音合成\" width=\"800\" height=\"450\">\n<h2>ElevenLabs支持的语言和口音</h2>\n<p>ElevenLabs 支持包括中文、英文、德语、日语、法语等在内的28种语言的文本转语音，实测欧美国家的语言效果更好，中文的效果还有待提升。</p>\n<img  class=\"alignnone\" src=\"/uploadfile/202312/dfe657ab1fe1cd9.jpeg\"  alt=\"ElevenLabs支持的语言和语音\" width=\"800\" height=\"517\">\n<h2>ElevenLabs的产品价格</h2>\n<p>ElevenLabs提供免费增值的定价体系，免费版提供每月10000个字符的转换和创建3个自定义声音。付费版价格如下：</p>\n<ul>\n<li>Starter版本，5美元/月，提供每月30000个字符和创建10个自定义声音</li>\n<li>Creator版本，22美元/月，提供每月100000个字符和创建30个自定义声音</li>\n<li>Independent Publisher版本，99美元/月，提供每月500000个字符和创建160个自定义声音</li>\n</ul>'),
                                                                        (217,	0,	0,	'Adobe推出的在线AI音频录制和编辑工具'),
                                                                        (218,	0,	0,	'<h2>大饼AI变声是什么</h2>\n<p>大饼AI变声（Dubbing.tech）是一款功能强大、免费专业的实时语音变声软件，是国内首款基于AI深度学习的声音引擎，并且支持全场景切入，兼容和支持多种游戏以及语音客户端。该AI变声软件的音色丰富多样，有数百种音色可供选择，并且每期提供免费的变声音色。除了实时变声，大饼声音引擎SaaS版还提供了文字转语音、声音克隆、声音定制、声音转换等功能，全方位地满足对多元声音的需求。</p>\n<img  class=\"alignnone size-full rounded shadow-sm\" src=\"/uploadfile/202312/7791005d658e3eb.png\"  alt=\"大饼AI变声\" width=\"800\" height=\"450\">\n<h2>大饼AI变声的主要功能</h2>\n<ol class=\"text-md\">\n<li>上百种优质音色随心选择：大饼AI变声提供丰富多样的音色，无论是萝莉音还是青叔音，你都可以随时随地更换自己的声音皮肤</li>\n<li>支持海量的应用和游戏：支持快手、斗鱼、虎牙、Steam、Discord、CS GO、刀塔、绝地求生、微信、Zoom等热门的平台和游戏内变声</li>\n<li>个性化声音定制：提供音频样本素材与具体需求，大饼声音引擎在10个工作日内交付专属于你的个性化克隆声音</li>\n<li>文字转语音：输入文字即可一键合成饱满、自然的音色，效果接近人声，支持中英文发音（该功能需在大饼声音引擎SaaS版中使用）</li>\n</ol>\n<img  class=\"alignnone size-full rounded shadow-sm\" src=\"/uploadfile/202312/2e7f39d4a73dca0.png\"  alt=\"大饼AI变声Mac端\" width=\"800\" height=\"460\">\n<h2>大饼AI变声的应用场景</h2>\n<ol class=\"text-md\">\n<li>游戏开黑：局内多人游戏开黑整活，节目效果拉满</li>\n<li>社交直播：告别社恐，不再担心真声开口的尴尬</li>\n<li>元宇宙/虚拟人：给虚拟人/数字人创造符合人设的任何声音</li>\n<li>广告营销：自由选择符合目标群体偏好的广告音色，达到更好的广告效果</li>\n<li>影视动画：灵活调整角色的音色、台词、情绪，用声音让影视角色丰满起来</li>\n</ol>\n<h2>如何使用大饼AI变声</h2>\n<ol class=\"text-md\">\n<li>访问大饼AI变声的官网（dubbing.tech），点击下载软件并进行安装</li>\n<li>安装完成后打开软件然后登录/注册，进入软件提示步骤</li>\n<li>连接并选择要使用的耳机/麦克风，待创建好虚拟麦克风即可使用</li>\n<li>在声音库中选择你要使用的变声音色</li>\n<li>若要在不同的应用程序中变声，则可在该应用的音频设置中选择 Dubbing Virtual Device 作为输入设备</li>\n</ol>\n<h2>大饼AI变声的产品价格</h2>\n<p>大饼AI变声的产品模式很有意思，不像其他的声音工具按照付费解锁时长或更多声音，大饼AI变声采用的是每期提供免费使用的音色，倒计时结束后轮换新的一批音色，若想永久解锁保留某个音色才需要付费。不同的音色永久解锁的价格不同，基本上在1900~5900猫饼（兑换比例为1元等于100猫饼），也就是永久解锁一个音色的价格为19元～59元。充值猫饼需在软件内充值：</p>\n<ul>\n<li>50元为5000猫饼</li>\n<li>100元为10000猫饼</li>\n<li>200元为20000猫饼</li>\n<li>可自定义充值金额，但需为100的倍数</li>\n</ul>\n<h2>常见问题</h2>\n<div id=\"accordion\" style=\"max-width: 700px;\">\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>大饼AI变声是免费的吗？</strong></div>\n<div class=\"card-body text-sm\">目前大饼AI变声客户端处于免费阶段，下载后安装注册即可使用。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>大饼AI变声支持哪些操作系统？</strong></div>\n<div class=\"card-body text-sm\">大饼AI变声支持Windows和macOS桌面端，iOS和Android移动端即将推出。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>大饼AI变声支持哪些语言？</strong></div>\n<div class=\"card-body text-sm\">目前大饼AI变声支持中文、英文、日语等40+种语言，同时也支持上海话、广东话等各地方言。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>大饼AI变声是否可用于商业用途？</strong></div>\n<div class=\"card-body text-sm\">可以，大饼AI变声通过收集公开开源的声音数据，使用自研算法建立音色模型。</div>\n</div>\n</div>'),
                                                                        (219,	0,	0,	'<p>Uberduck是一个开源的AI语音生成和合成的社区，该平台提供了超过5000多种声音帮助用户制作AI配音和语音，甚至你还可以使用自己的自定义语音克隆进行合成。</p>'),
                                                                        (220,	0,	0,	'<p>讯飞智作是科大讯飞推出的一站式智能配音服务平台，提供AI文字转语音、语音合成、智能配音、AI虚拟主播等工具，赋能内容生产者高效创作，让音视频创作更快、更省、更独特。</p>\n<h2>讯飞智作的主要功能</h2>\n<ol>\n<li>AI配音朗读/转换。用户只需输入文字立刻变声，并且可以调整和修改换气、连续、停顿、音量、音调、读速等参数，一键生成专业音频</li>\n<li>AI真人配音合成。选择真人配音，效果更加真实逼真，多种场景覆盖，如广告配音、课件配音、彩铃配音、纪录片、新闻播报等</li>\n<li>AI虚拟主播。AI虚拟主播专业形象出镜讲解，让AI视频更加具有情感和亲和力，适用于教育培训、日常分享、财经评论、情感鸡汤等场景。</li>\n<li>AIGC工具箱。提供AI文案、AI绘图、让照片说话、虚拟数字分身、专属AI声音等AIGC工具，全面帮助用户释放AI生成的能力。</li>\n</ol>'),
                                                                        (221,	0,	0,	'<p>Riffusion 是一个免费开源的具有稳定扩散的实时音乐和音频生成库，用户只需输入音乐描述，AI便可以生成对应风格的音乐。该开源项目由Seth Forsgren 和 Hayk Martiros推出，Riffusion的背后原理是基于Stable Diffusion（文本生成图像模型）微调频谱图，频谱图是音频的视觉表示，显示不同频率随时间的振幅，而后再将高保真度的频谱图图像转换为音频。</p>'),
                                                                        (222,	0,	0,	'<p>Stable Audio 是 Stability AI （Stable Diffusion 背后的公司）最新推出的AI音乐生成工具，允许用户通过简单的 Web 界面使用 AI 技术生成原创音乐和音效。用户只需输入文本描述想要的音乐和音效（提示语可以包括流派、乐器、情绪、节拍数等细节），便能自动生成音频。网站的设计、颜色和几何形状的搭配，提供了很舒适的用户观感和体验。</p>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/a70bdd0ff703b.png\"  alt=\"Stable Audio官网\" width=\"800\" height=\"450\">\n<h2>如何使用Stable Audio</h2>\n<ol>\n<li>访问 Stable Audio 的官网 stableaudio.com，可以播放提供的样例音乐，或者点击Try it out开始生成</li>\n<li>然后注册/登录你的账号（可使用邮箱或Google账号登录），登录成功后会跳转到后台的生成界面</li>\n<li>在text prompt输入框中输入提示语和描述，也可以在duration处调节生成的音乐长度</li>\n<li>最后点击圆形黑色的箭头按钮便可以生成音乐了，等待生成完后右侧可以播放和下载</li>\n</ol>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/619c19aec51091d.png\"  alt=\"Stable Audio音乐生成\" width=\"800\" height=\"450\">\n<h2>Stable Audio的价格</h2>\n<p>Stable Audio 提供免费和付费订阅的计划，都支持提供描述音乐流派、乐器、情绪、节奏和其他参数的文本提示。</p>\n<ul>\n<li>免费版本允许用户每月生成 20 个 45 秒的音频</li>\n<li>“Pro”付费版11.99美元/月。每月可以生成用于商用的更高质量的 500 个不超过 90 秒的音频</li>\n</ul>\n<h2>Stable Audio生成的音乐的许可</h2>\n<ul>\n<li>免费用户可以使用通过 Stable Audio 生成的音频作为您自己的音乐作品（即音乐曲目）中的 sample，不能商用</li>\n<li>付费用户可以在商业媒体项目中使用：视频、游戏、播客等，包括内部项目和外部客户项目</li>\n<li>不允许在生成的音频上训练 AI 模型</li>\n</ul>'),
                                                                        (223,	0,	0,	'<p>TME Studio是由腾讯音乐娱乐公司推出的一款AI音乐生成工具，由旗下银河音效、MUSE、天琴实验室、Tencent AI Lab共同打造，助力音乐爱好者，让创作更简单。该智能音乐助手目前提供以下AI功能：</p>\n<ul>\n<li>音乐分离。基于深度学习技术，上传任意歌曲，分离、提取歌曲中的人声和鼓、贝斯、吉他、钢琴等乐器。</li>\n<li>MIR计算。通过人工智能和信号处理对音乐进行内容理解与分析，提取音乐的采样率、位深、BPM、节奏、节拍、调性、和弦进行、鼓点识别、副歌识别等信息。通过更深维度的识别与分析挖掘音乐蕴含的更多高层次信息，创造更智能的音乐工具，让机器更懂你的音乐。</li>\n<li>辅助写词。腾讯音乐人·天琴实验室推出的一款作词工具，通过分析TME全曲库歌词以及散文、诗歌等多种语料素材，依据智能推荐算法帮你找到合适的押韵词语，打开灵感空间。</li>\n<li>智能曲谱。基于深度学习神经网络算法，为海量歌曲生成智能吉他曲谱，只需上传音乐，即可弹你想弹的歌。</li>\n</ul>'),
                                                                        (224,	0,	0,	'<p>网易天音是网易云音乐推出的一站式AI音乐创作工具，无需乐理知识，一键上手。音乐爱好者或者歌手只需输入灵感，AI便可以辅助完成词、曲、编、唱，生成AI初稿后，支持词曲协同调整。</p>\n<h2>网易天音的主要功能</h2>\n<ol>\n<li>AI快速编曲。智能编曲极速生成，海量风格一键渲染。</li>\n<li>AI作词与编辑。智能创作，根据词格AI智能生成，将你的灵感具现化。</li>\n<li>一键DEMO。词曲编唱5秒搞定，快速创作一首属于你的歌曲。</li>\n<li>歌声合成，虚拟歌姬。酷似真人的专业级演唱技巧，超乎想象的歌声演绎。</li>\n</ol>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/4368963b9213eb9.png\"  alt=\"网易天音AI作曲\" width=\"800\" height=\"450\">'),
                                                                        (225,	0,	0,	'自然语言转义为CLI命令'),
                                                                        (226,	0,	0,	'Visual Studio AI辅助开发'),
                                                                        (227,	0,	0,	'AI代码检查'),
                                                                        (228,	0,	0,	'AI API开发工具'),
                                                                        (229,	0,	0,	'<p>Hocoos 是基于人工智能的网站设计领域的领导者，于4月推出了强大的 AI 网站生成器。使用最先进的算法，Hocoos 人工智能网站建设在几分钟内便可以创建个性化网站，无需用户具备编程知识。</p>\n<p>Hocoos 推出的 AI 网站生成器，可在几分钟内创建个人和商业网站。用户只需回答8个问题，即可指导Hocoos AI 为任何品牌设计一个具有引人注目的设计和内容的个性化网站。人工智能网站生成器会自动生成书面和视觉内容，可以通过简单易用的设计界面轻松编辑。</p>\n<p>凭借先进的人工智能技术，Hocoos首次允许在几分钟内创建个人和商业网站，该工具已经在各种行业中进行了测试，可以在几分钟内为美容保健、体育健身、电子商务、摄影、商业和金融等多个行业的品牌建立网站。</p>'),
                                                                        (230,	0,	0,	'AI代码生成、补全、分析、重构和调试'),
                                                                        (231,	0,	0,	'下一代命令行工具（内置AI终端命令自动补全）'),
                                                                        (232,	0,	0,	'21世纪的终端工具（内置AI命令搜索）'),
                                                                        (233,	0,	0,	'<p>Debuild的是一个AI技术驱动的低代码Web App开发平台，其目标是建立一个达到世界上最熟练工程师创建软件的水平的自主开发系统。无需专业知识，让每个人都能立即创建他们需要的任何软件工具，都能对计算机进行编程。</p>'),
                                                                        (234,	0,	0,	'<p>Mutable AI是一款更全面的GitHub Copilot替代品，具有AI自动完成、代码文档器、重构器（目前仅限Python），也可以通过提示直接向AI发出编辑代码的指令。</p>'),
                                                                        (235,	0,	0,	'AI代码自动补全编程助手'),
                                                                        (236,	0,	0,	'AI无代码软件开发'),
                                                                        (237,	0,	0,	'<p>Fronty是世界上第一个由 AI 驱动的网页设计到源代码转换服务，智能将你的网页原型设计稿转换为HTML和CSS代码。该公司的愿望是创建一系列提供干净和可访问的代码、速度优化、W3C有效、可访问、SEO 友好、移动友好的网页设计工具。</p>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/63e8ae457860b13.png\"  alt=\"Fronty将图片转换为HTML和CSS代码\" width=\"800\" height=\"418\">\n<p>Fronty基于人工智能技术，可以从图像、屏幕截图、设计或模型中生成干净的 HTML/CSS 代码。该AI图像到代码转换器具有以下优点：</p>\n<ul>\n<li dir=\"ltr\" aria-level=\"1\">\n<p dir=\"ltr\" role=\"presentation\">干净的代码。无需手动编码，所有代码基于业界知名的前端框架，经过适当定制。</p>\n</li>\n<li dir=\"ltr\" aria-level=\"1\">\n<p dir=\"ltr\" role=\"presentation\">页面速度优化。所有最终代码都被缩小，图像已优化、呈现关键 CSS 和 CRP。</p>\n</li>\n<li dir=\"ltr\" aria-level=\"1\">\n<p dir=\"ltr\" role=\"presentation\">SEO友好。搜索引擎优化最佳实践遵循前谷歌搜索引擎优化专家的指导。</p>\n</li>\n<li dir=\"ltr\" aria-level=\"1\">\n<p dir=\"ltr\" role=\"presentation\">注释良好的代码。在不清楚的情况下维护别人的代码总是很糟糕的体验。Fronty生成的代码易于维护，有着良好的注释和说明。</p>\n</li>\n<li dir=\"ltr\" aria-level=\"1\">\n<p dir=\"ltr\" role=\"presentation\">语义化HTML。提供的代码遵循编写语义标记的最佳实践，还有自动生成的结构化数据支持。</p>\n</li>\n<li dir=\"ltr\" aria-level=\"1\">\n<p dir=\"ltr\" role=\"presentation\">可访问。ARIA标识的使用另该工具生成的网站易于访问。</p>\n</li>\n<li dir=\"ltr\" aria-level=\"1\">\n<p dir=\"ltr\" role=\"presentation\">SCSS 而不是 CSS。源代码基于强大的 SCSS，你可以使用变量、嵌套和许多其他 CSS 缺少的强大功能。</p>\n</li>\n<li dir=\"ltr\" aria-level=\"1\">\n<p dir=\"ltr\" role=\"presentation\">自定义 Bootstrap 主题。提供的代码基于世界上最流行的 UI 框架 Bootstrap。此外，Fronty还提供了一个强大的库。</p>\n</li>\n<li dir=\"ltr\" aria-level=\"1\">\n<p dir=\"ltr\" role=\"presentation\">移动平板电脑友好。Fronty生成的代码保证移动优先。</p>\n</li>\n</ul>\n<p>除此之外，Fronty还可以重做现有网站的前端并提供新的/更好的代码，并准确分析清理了多少代码以及优化了多少页面加载速度。用户还可以直接在 Fronty.com 上托管网站，这意味着用户只需要网站的设计，解析好域名后便可以直接使用 Fronty 创建和托管网站。</p>'),
                                                                        (238,	0,	0,	'<p>Locofy基于人工智能技术提供了一种将设计转换为代码的服务，Locoy.ai的目标是在不增加复杂性的情况下消除工程师的琐碎工作，即从前端代码开始自动化50%或更多的当前工作流程，使团队能够将他们的设计转换为代码和交互式、响应迅速的实时原型（在代码上运行），而无需编写一行代码。</p>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/885aa7faca0264c.jpg\"  alt=\"Locofy.ai\" width=\"800\" height=\"418\">\n<p>Locofy.ai的功能：</p>\n<ul>\n<li>Figma设计稿转换成React代码</li>\n<li>Figma设计稿转换成HTML/CSS代码</li>\n<li>Figma设计稿转换成Next.js代码</li>\n<li>Figma设计稿转换成React Native代码</li>\n<li>Adobe XD设计稿转换成React代码</li>\n<li>Adobe XD设计稿转换成HTML/CSS代码</li>\n<li>Adobe XD设计稿转换成Next.js代码</li>\n<li>Adobe XD设计稿转换成React Native代码</li>\n</ul>'),
                                                                        (239,	0,	0,	'AI代码实时分析'),
                                                                        (240,	0,	0,	'知名在线编程IDE Replit推出的AI编程助手'),
                                                                        (241,	0,	0,	'<p>Deco 是京东推出的智能将设计稿一键生成多端代码（支持生成 Taro、React、Vue、HTML等）的工具， Deco 是 Design 和 Code 的两个词的合并，代表 Design To Code，即从设计稿生成代码。</p>\n<p>Deco 利用人工智能，结合各类自动化、工程化等手段，将 Sketch、PS、图片类的设计稿转换生成还原度高、可维护强的代码，致力于突破业务生产力瓶颈，为前端大规模、高效率生产提供赋能。</p>'),
                                                                        (242,	0,	0,	'<p>Imgcook（图像大厨）是由阿里巴巴-大淘宝技术-导购和营销产品团队推出的设计稿智能生成前端代码（D2C，Design to Code）的平台，专注以 Sketch、PSD、静态图片等形式的视觉稿作为输入，通过智能化技术一键生成可维护的前端代码，包含视图代码、数据字段绑定、组件代码、部分业务逻辑代码等。</p>\n<h2>Imgcook的主要功能</h2>\n<h3>一键还原视觉稿</h3>\n<p>从视觉稿中还原生成代码需要将视觉稿中的数据导出到 imgcook 可视化编辑器中还原生成代码，支持两种方式：</p>\n<ul>\n<li>第1种：打开 Sketch/PSD 文件，通过安装好的 imgcook 插件将设计稿中的图层信息导出，粘贴到可视化编辑器中。</li>\n<li>第2种：在可视化编辑器中直接上传“导入” Sketch/PSD/图片文件，imgcook 会解析图层信息直接还原到编辑器中。</li>\n</ul>\n<h3>可视化编辑</h3>\n<p>在 imgcook 可视化编辑器中，用户可以对视图编辑，比如支持动态表达式样式、设置循环、修改布局。还可以编写逻辑代码、绑定字段等。</p>\n<h3>生成代码</h3>\n<p>官方有提供常用的 DSL（React/Vue/小程序 DSL等），点击下拉列表可切换使用其他 DSL。如果有特殊诉求，你也可以自定义 DSL。</p>\n<p>代码确定后，可点击「导出」，你也可以使用 VS code imgcook 插件链路「导出」，此方式可以将整个模块代码文件生成到相应目录，直接继续使用 VS code 开发整个项目即可。导出后的代码到本地文件中，图片以相对路径的形式存放在 images 文件夹下。</p>\n<h2>Imgcook的应用场景</h2>\n<p>imgcook 目前支持各种场景的页面或模块的高度还原，您可以根据以下场景分类选择是否使用 imgcook。</p>\n<ul>\n<li>移动端细粒度模块开发场景 - 特别推荐</li>\n<li>移动端活动页 - 特别推荐</li>\n<li>移动端全页面开发 - 推荐</li>\n<li>PC 端 toC 应用 - 推荐</li>\n<li>PC 端 toB 应用</li>\n<li>PC 端富交互应用 - 不推荐</li>\n<li>游戏场景 - 不推荐</li>\n</ul>\n<h2 dir=\"auto\">如何使用imgcook插件？</h2>\n<ol dir=\"auto\">\n<li>\n<p dir=\"auto\">确保你已登录到 imgcook 帐户。</p>\n</li>\n<li>\n<p dir=\"auto\">在 Figma 中，转到 Plugins 并选择 imgcook，你应该看到一个新的导出窗口。</p>\n</li>\n<li>\n<p dir=\"auto\">选择任意文件图层组，然后点击“导出”。 imgcook 将弹出“导出成功，已复制到剪贴板！” 提示弹出层，然后单击“转到粘贴”进行还原。</p>\n</li>\n<li>\n<p dir=\"auto\">imgcook将在新的浏览器选项卡中打开编辑器。 将其粘贴并恢复到“ ctr + v”编辑器中，然后另存为模块即可。</p>\n</li>\n</ol>\n<h2>Imgcook是免费的吗？</h2>\n<p>Imgcook是完全免费的，用户可以使用其提供的Figma、Sketch、VSCode等插件来进行将设计稿免费转化为代码。</p>'),
                                                                        (243,	0,	0,	'AI SQL语句生成和修改'),
                                                                        (244,	0,	0,	'<p>aiXcoder致力于将人工智能技术应用于软件开发领域，帮助开发者快速、高效地完成软件开发任务。aiXcoder智能编程工具，能够在开发者编写代码时，自动推荐后续的代码片段，以提高编码效率和代码质量。</p>\n<p>aiXcoder代码生成与补全提供以下服务：</p>\n<ul>\n<li>Token级代码生成与补全：基于本地服务，支持自动推荐单个或多个Token的代码</li>\n<li>行级代码生成与补全：基于云端服务，支持自动生成或补全整行代码</li>\n<li>方法级代码生成与补全：基于云端服务，支持根据自然语言功能描述以及上下文，生成或补全方法级代码</li>\n</ul>\n<p>当前aiXcoder支持Java、Python、C#、C/C++、Go、JavaScript等语言，并支持IntelliJ IDE、PyCharm、Eclipse、VS Code等多种IDE。</p>'),
                                                                        (245,	0,	0,	'<p>JamGPT是Bug报告工具Jam最新推出的AI Debug助手，JamGPT可帮助开发人员分析所有的Bug报告细节，在你开始阅读之前就找到相关原因和解决方案。</p>\n<h2>JamGPT的特色功能：</h2>\n<ul>\n<li>AI驱动的Bug诊断：根据你现有的Bug报告，获得自动的源代码分析，以简化调试。</li>\n<li>代码修复建议：根据您的基础设施获得代码更新，粘贴代码片段以获得分析和建议。</li>\n<li>自适应的精确人工智能：我们的查询和学习算法随着时间的推移而改进，以获得更好的修复建议。</li>\n<li>安全的代码审查：在整个调试过程中，确保代码库的隐私和安全。</li>\n<li>集成的Jam报告：与Jam Chrome扩展一起工作使用，以提高您的错误报告工作流程。</li>\n<li>跨团队协作：从人工智能中获得好的建议，并让你的团队在对话中检查。</li>\n</ul>'),
                                                                        (246,	0,	0,	'<p>天工智码Skycode是基于昆仑万维与奇点智源研发昆仑天工模型的一款AI代码生成工具，支持各种主流编程语言，助力开发人员更快更好的编码。</p>\n<p>天工智码Skycode可以直接集成到编辑器中，无缝衔接在开发环境，在键入代码的同时，智能高效补全代码，提升工作效率，节省开发时间。天工智码目前已经集成在了 Visual Studio Code 中，未来会支持更多平台和工具，如 Neovim、JetBrains IDE、Visual Studio 等。致力于为开发者解决琐碎的、重复性的代码工作，从而专注于更高价值的研发工作。</p>'),
                                                                        (247,	0,	0,	'<p>Quest AI 可以将 Figma 设计稿或者手稿转换为 ReactJS 前端代码，帮助设计人员或开发人员比以往更快地构建全栈网站应用程序。Quest 支持构建任何 ReactJS 组件，<span data-slate-fragment=\"JTdCJTIyb2JqZWN0JTIyJTNBJTIyZG9jdW1lbnQlMjIlMkMlMjJkYXRhJTIyJTNBJTdCJTdEJTJDJTIybm9kZXMlMjIlM0ElNUIlN0IlMjJvYmplY3QlMjIlM0ElMjJibG9jayUyMiUyQyUyMnR5cGUlMjIlM0ElMjJwYXJhZ3JhcGglMjIlMkMlMjJpc1ZvaWQlMjIlM0FmYWxzZSUyQyUyMmRhdGElMjIlM0ElN0IlN0QlMkMlMjJub2RlcyUyMiUzQSU1QiU3QiUyMm9iamVjdCUyMiUzQSUyMnRleHQlMjIlMkMlMjJsZWF2ZXMlMjIlM0ElNUIlN0IlMjJvYmplY3QlMjIlM0ElMjJsZWFmJTIyJTJDJTIydGV4dCUyMiUzQSUyMiUyMGNhbiUyMGJ1aWxkJTIwYW55JTIwUmVhY3RKUyUyMGNvbXBvbmVudHMlMjB1c2luZyUyMFF1ZXN0LiUyMFlvdSUyMGNhbiUyMGJ1aWxkJTIwYSUyMHNpbmdsZSUyMGNvbXBvbmUlMjIlMkMlMjJtYXJrcyUyMiUzQSU1QiU1RCUyQyUyMnNlbGVjdGlvbnMlMjIlM0ElNUIlNUQlN0QlNUQlMkMlMjJrZXklMjIlM0ElMjJlNTAwYzc2OTcwOTQ0NWE3OTM2MGM5ZjFjYWM1ZDMwNyUyMiU3RCU1RCUyQyUyMmtleSUyMiUzQSUyMjc5NjI3NTNlMTRlMTQ0ZTk4NjliNTc0MTJhYzM3MzVjJTIyJTdEJTVEJTJDJTIya2V5JTIyJTNBJTIyMmIzYTk0ZGU1N2ZlNGNlY2JjMzNhZTE0NDNhYmIzZTMlMjIlN0Q=\">可以构建单个组件并将其添加到现有的 React 应用程序中，也可以使用 Quest 构建整个应用程序。</span></p>\n<h2>Quest AI的主要功能</h2>\n<ol>\n<li>导出Figma设计，提供Figma插件将设计稿导出到Quest</li>\n<li>同步代码到GitHub，将生成的代码推送到 GitHub 存储库，可以推送单个组件或整个应用程序</li>\n<li>实时预览编好的组件，预览模式进行测试并查看代码的工作情况</li>\n<li>响应式前端代码，按照需要放大或缩小组件，或者根据屏幕尺寸更改布局，无需编写任何代码</li>\n<li>支持NextJS，开箱即用的 NextJS 支持，并且可以选择 JS 或 TS 导出代码</li>\n<li>支持输入文本描述提示，AI自动生成对应的功能代码</li>\n</ol>\n<h2>如何使用Quest AI</h2>\n<ol>\n<li>访问Quest的官网，并登录/注册账号</li>\n<li>登录成功后会进入到Quest的工作台，点击左上角的加号➕按钮</li>\n<li>选择Figma、上传手稿截图、或者提供的模板</li>\n<li>点击对应的元素或组件进行修改，并且可以在左下角输入描述，AI自动生成功能性代码</li>\n<li>右上角可以点击Git的图标同步代码到GitHub，或者点击下载图标导出代码</li>\n</ol>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/13fed8eeea1a7b1.png\"  alt=\"如何使用Quest AI\" width=\"800\" height=\"450\">\n<h2>Quest AI的产品价格</h2>\n<p>Quest AI提供不同的定价计划以满足不同的项目需求，初创企业和教育邮箱可获得80%折扣</p>\n<ol>\n<li>Free免费版，适用于个人项目，支持20个组件、1个工作空间、1个App、3个团队成员</li>\n<li>Pro付费版，月付版每人每月58美元（年付版49美元/月），支持无限个组件、1个工作空间、2个App每工作空间、无限团队成员</li>\n<li>Business商业版，月付版每人每月93美元（年付版79美元/月），支持无限个组件、无限个工作空间、5个App每工作空间、无限团队成员</li>\n</ol>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/eef9061fe9d1121.png\"  alt=\"Quest AI 的产品价格\" width=\"800\" height=\"450\">\n<p> </p>'),
                                                                        (248,	0,	0,	'<p>Boxy 是知名在线前端代码编辑器「CodeSandbox」推出的AI编程助手，可帮助用户在优化代码、查找潜在代码错误或增强代码安全性，让你更快地编程将想法变为现实，但目前 Boxy 需要 CodeSandbox 的 Pro用户才可以使用。</p>\n<h2>Boxy的主要功能</h2>\n<ol>\n<li>直观的代码重构。无需定位特定代码，可以直接在应用预览中选择，然后让其重构其关联代码。Boxy会根据项目代码的上下文生成新代码。</li>\n<li>基于上下文生成代码。告别手动复制粘贴，只需输入描述询问，Boxy便会根据你的需要和上下文生成确切的代码。</li>\n<li>编写 Git 提交说明。编写提交消息有时可能是一项乏味的任务，Boxy可以通过分析特定分支的更改，主动建议提交消息，简化你的 Git 工作流程。</li>\n<li>提供代码解释。如果你对特定的代码或文件有疑问，可以询问Boxy，它可以帮助你加深对代码的理解和见解。</li>\n</ol>'),
                                                                        (249,	0,	0,	'<p>v0.dev 是由知名前端网站托管平台 Vercel 推出的由 AI 自动生成网页用户界面的工具，基于流行的 UI 框架 Shadcn UI 和 Tailwind CSS 生成直接可用的 React 组件代码。</p>\n<h2>v0的工作原理</h2>\n<p>v0 使用 AI 模型根据简单的文本提示生成代码，输入并提交提示语后，会提供三个人工智能生成的用户界面选择。你可以选择一个并复制粘贴其代码，或进一步完善它。如果要进行优化，你也可以选择生成的 UI 的各个部分来微调。</p>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/48464fb9ee8cc0f.png\"  alt=\"Vercel v0.dev\" width=\"800\" height=\"472\">\n<p>v0 目前可以生成 React DOM 元素和 Shadcn UI 组件。后续正式发布后，Vercel 将添加对其他 UI 库的支持，可能包括 Svelte、Vue 或纯 HTML 等。</p>\n<p>v0 目前处于内测阶段，供用户免费使用。如果你有兴趣尝试 v0，可以访问其官网加入等候名单。</p>'),
                                                                        (250,	0,	0,	'<p>ChatDev是人工智能公司面壁智能最新推出的基于“大模型+Agent”的智能软件开发平台，用户只需输入自然语言，便能生成和创建可运行的软件。通过该平台，软件开发者和没有编程经验的普通用户可以以极低的成本和门槛高效完成软件开发和创建的工作。开源版本的ChatDev已在GitHub上斩获17K Star。</p>\n<img  class=\"alignnone size-full rounded shadow-sm\" src=\"/uploadfile/202312/b300f1200485a72.png\"  alt=\"ChatDev\" width=\"800\" height=\"500\">\n<h2>ChatDev的功能特色</h2>\n<ol>\n<li>虚拟软件公司模拟现实世界运行，通过担任不同角色的各种智能体进行运营，包括首席执行官、首席产品官、首席技术官、程序员、代码评审员、测试员、美术设计师等模仿现实世界进行软件开发</li>\n<li>赋能软件开发的全流程，从需求分析、界面设计，到代码编写、软件测试和应用发布</li>\n<li>基于大型语言模型（LLM）的易于使用、高度可定制和可扩展的框架，是研究群体智能的理想场景</li>\n<li>可进行任意类型的软件的编写和开发，如红包雨、计时器、贪吃蛇、吃豆人、单位转换器等各种类型的软件</li>\n</ol>\n<h2>如何使用ChatDev</h2>\n<ol>\n<li>访问ChatDev的官网（chatdev.modelbest.cn），登录或注册账号申请试用</li>\n<li>申请成功后回到软件创建界面，填写项目名称和软件描述等项目设置</li>\n<li>等待服务器响应项目生成，ChatDev的智能体会按照需求指令模拟现实世界软件公司的运行</li>\n<li>软件生成后可直接下载和分享，若对结果不满意，也可以调整和修改</li>\n</ol>\n<p>以上是SaaS版的使用步骤，若要自己部署和运行，请访问ChatDev的GitHub库查看快速开始的说明。</p>\n<h2>常见问题</h2>\n<div id=\"accordion\" style=\"max-width: 700px;\">\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>ChatDev基于什么大模型？</strong></div>\n<div class=\"card-body text-sm\">开源版的ChatDev调用的是OpenAI的GPT大模型的能力，开发者需要自己设置API Key，可以使用GPT-3.5，也可以使用GPT-4。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>ChatDev支持Git版本控制吗？</strong></div>\n<div class=\"card-body text-sm\">支持，ChatDev已推出Git模式，扮演程序员的智能体可以利用Git进行版本控制。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>ChatDev是免费的吗？</strong></div>\n<div class=\"card-body text-sm\">ChatDev是免费开源的，开发者可以克隆GitHub库进行设置和本地运行，也可以访问面壁智能的网站申请使用SaaS版本。</div>\n</div>\n</div>'),
                                                                        (251,	0,	0,	'<p>AskCodi是一个基于AI的代码生成助手，该工具理论上可以帮助你完成任何编码工作。从生成代码到解释代码背后的逻辑，从开发WordPress网站到创建一个应用程序，甚至重构你现有的代码，Codi将是你整个编码之旅的伴侣。</p>\n<p>AskCodi是基于开发者的需求而制作的，以避免多余的任务，从而减少花在开发上的时间和更多的时间来执行程序。AskCodi通过工具帮助加快开发过程，在这些工具中，你可以要求Codi AI回答编码问题、解释代码、记录或测试代码。以及像统计分析、数据科学和许多其他的特定应用，对在网上努力寻找答案的开发者来说是大有帮助的。</p>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/99baba176b91706.jpeg\"  alt=\"AskCodi应用\" width=\"1000\" height=\"592\">'),
                                                                        (252,	0,	0,	'<p>CodeArts Snap是华为云推出的AI编程助手，可以帮助开发者将自然语言转化为规范可阅读、无开源漏洞的安全编程语言，提升开发者编程效率，助力企业快速响应市场需求。其核心技术基于华为云PaaS技术创新Lab与华为诺亚方舟实验室联合打造的PanGu-Coder代码大模型，支持Python和Java语言，支持PyCharm、IntelliJ和VSCode等代码编辑器。</p>\n<h2>CodeArts Snap的主要功能</h2>\n<ol>\n<li>函数级代码自动生成。可以通过自然语言识别做到函数级的多行代码生成，开发者仅需在定义好的函数签名末尾处敲下“回车键”，CodeArts Snap将生成符合业务逻辑的完整函数代码。</li>\n<li>行级代码生成。CodeArts Snap在已有函数上文的场景下，还可以通过理解上文的语义和逻辑，自动进行行级代码生成。</li>\n<li>光标处代码生成推荐。在编程过程中，开发者难免会遇到卡壳、停下来思考。此时CodeArts Snap在光标处会进行行中代码生成推荐，为开发者提供编程灵感。</li>\n<li>提供多个生成结果方案。每次触发代码生成，CodeArts Snap会提供多个生成结果方案，开发者可以通过快捷键快速翻阅，也可以调取侧边栏对比查看所有候选代码生成推荐结果，并对结果进行选择。</li>\n</ol>\n<h2>CodeArts Snap的产品价格</h2>\n<p>目前CodeArts Snap处于免费测试中，用户可以通过VS Code和JetBrains插件市场免费下载，并通过下方链接申请注册使用：</p>\n<p>https://devcloud.cn-north-4.huaweicloud.com/codeartssnap/apply</p>'),
                                                                        (253,	0,	0,	'<p>Comate是百度推出的AI编程工具，基于文心大模型，结合百度积累多年的编程现场大数据和外部优秀开源数据，为开发人员生成更符合实际研发场景的优质代码，现已向企业开放试用申请。</p>\n<h2>Comate的产品功能</h2>\n<p><strong>一、AI自动生成代码：</strong></p>\n<ol>\n<li>代码解释：可给出整个方法、函数的功能和完整逻辑说明，也支持选中任意代码给出解释</li>\n<li>技术问答：在对话框中输入研发中遇到的问题，第一时间获得AI助手解答</li>\n<li>实时续写：通过分析上下文逻辑关系，智能生成方法、函数、判断、循环体等完整的代码块</li>\n<li>注释生成代码：直接在注释中用自然语言描述所需功能，自动生成完整函数</li>\n<li>生成函数注释与行间注释：分析一个方法、函数、类，生成符合规范的文档注释，同时也可以识别函数中复杂逻辑逐行增加注释</li>\n<li>生成单元测试：支持对任意方法、函数一键生成单元测试，也支持对多文件进行批量生成</li>\n</ol>\n<p><strong>二、AI进行代码优化和修复：</strong></p>\n<ol>\n<li>代码优化：支持对长函数等坏味道代码进行优化</li>\n<li>代码修复：识别代码中的潜在错误，并自动进行修复</li>\n</ol>\n<p><strong>三、支持多门语言和多个IDE：</strong></p>\n<ol>\n<li>支持30多种主流语言，包括C/C++、Java、Python、Go、JavaScript、TypeScript等语言</li>\n<li>支持常用 IDE，VS Code、IntelliJ IDEA、GoLand、PyCharm、WebStorm、CLion、PhpStorm、Android Studio、Xcode、iCoding等IDE插件，一键安装，即装即用</li>\n</ol>'),
                                                                        (254,	0,	0,	'<p>iFlyCode 是科大讯飞最新推出的智能编程助手，基于讯飞星火认知大模型，可以帮助开发人员编程更轻松，创意更自由。该AI编程工具拥有代码生成、代码补齐、代码纠错、代码解释、生成单元测试等功能。</p>\n<h2>iFlyCode的产品功能</h2>\n<ol>\n<li>代码生成：智能触发，一键出“码”。可智能生成单行或函数级代码建议、根据注释、函数名自动生成代码、通过方法名、上下文等信息补齐代码</li>\n<li>选中段落：“码”上理解。类、函数及其作用逐一详解、支持逐行代码注释、学习海量范式，快速精准解读</li>\n<li>代码纠错：智能识别，便捷修正、精准定位拼写、语法、逻辑错误、提供针对性纠正建议、新老代码比较，支持一键修改</li>\n<li>单元测试：快速生成，自测无忧、选中代码，一键生成单测用例、支持多种主流单元测试框架、智能生成单元测试数据</li>\n<li>智能问答：专业知识，精准获取、支持选中代码提问、对话式自由问答、代码相关问题专业解答、IDE界面直接提问，无需切换</li>\n</ol>'),
                                                                        (255,	0,	0,	'<div class=\"lake-content\">\n<p id=\"u2cc2bb9d\" class=\"ne-p\"><span class=\"ne-text\">CodeFuse 是一款为国内开发者提供智能研发服务的AI编程工具，该产品是基于蚂蚁集团自研的基础大模型进行微调的代码大模型。CodeFuse 具备代码补全、添加注释、解释代码、生成单测，以及代码优化功能，以帮助开发者更快、更轻松地编写代码。</span></p>\n<h2>CodeFuse的产品功能</h2>\n<p>CodeFuse 提供多个 IDE 插件版，支持在 10 款 IDE 中使用，包括支付宝小程序云云端研发、Visual Studio Code，以及 JetBrains 系列的 IntelliJ IDEA、PyCharm、WebStorm、GoLand、CLion、DataGrip、PhpStorm 和 RubyMine。</p>\n<p>此外，CodeFuse 支持 40 多种编程语言，包括 C++、Java、Python、JavaScript 等，目前 CodeFuse 针对 Java 与 Python 的代码生成质量较高。CodeFuse 支持的功能如下表。</p>\n<table class=\"table table-hover\">\n<thead>\n<tr>\n<th scope=\"col\" width=\"120px\">产品功能</th>\n<th scope=\"col\">描述说明</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n<th scope=\"row\">代码补全</th>\n<td>基于海量数据提供实时地代码补全服务，包括行内补全（单行补全）和片段补全（多行补全）</td>\n</tr>\n<tr>\n<th scope=\"row\">添加注释</th>\n<td>智能为选定的代码生成注释，目前在整个函数级别的生成注释效果较好。</td>\n</tr>\n<tr>\n<th scope=\"row\">解释代码</th>\n<td>智能解析代码意图，为选定的代码生成解释，辅助阅读并理解代码。</td>\n</tr>\n<tr>\n<th scope=\"row\">生成单测</th>\n<td>在写完业务逻辑后，为选定的代码生成单测，即可智能生成具备业务语义的测试用例，从而提升问题发现的效率。</td>\n</tr>\n<tr>\n<th scope=\"row\">代码优化</th>\n<td>基于大模型的代码理解能力和静态源码分析能力，CodeFuse 支持对选定的代码片段进行分析理解并提出优化、改进建议，还能直接基于改进建议生成代码补丁。</td>\n</tr>\n</tbody>\n</table>\n</div>'),
                                                                        (256,	0,	0,	'<style>div.apd-bg {display: none;}</style>\n<p>通义灵码是阿里推出的免费AI编程工具，基于通义大模型，作为 GitHub Copilot 国内的平替产品，提供行级/函数级实时续写、自然语言生成代码、单元测试生成、代码注释生成、代码解释、研发智能问答、异常报错排查等能力，并针对阿里云 SDK/API 的使用场景调优，为开发者带来高效、流畅的编码体验。</p>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/0ce833de3e15087.png\"  alt=\"通义灵码\" width=\"900\" height=\"335\">\n<h2>通义灵码的主要功能</h2>\n<ol>\n<li><strong>行/函数级实时续写</strong>：在编码的过程中，根据上下文和当前语法，为你自动预测和生成建议代码，你只需单击 Tab 键即可采纳。</li>\n<li><strong>自然语言生成代码</strong>：在编辑器中，通过自然语言描述你想要的功能，根据你的描述和上下文，支持在编辑器区直接生成代码及相关注释，编码心流不间断。</li>\n<li><strong>代码优化生成</strong>：帮你识别代码中的问题，并提供代码优化建议</li>\n<li><strong>单元测试生成</strong>：支持根据 JUnit、Mockito、Spring Test、unit test、pytest 等框架生成单元测试以及单元测试相关代码解释。</li>\n<li><strong>代码注释生成</strong>：一键生成方法注释及行间注释，节省你写代码注释的时间，有效提升代码可读性和注释覆盖率。</li>\n<li><strong>代码解释</strong>：支持 30 多种语言的识别，选中代码后可自动识别编程语言并生成代码解释。跨越语言的边界，让你快速了解代码逻辑和功能设计。</li>\n<li><strong>研发智能问答</strong>：基于海量研发文档、产品文档、通用研发知识、阿里云的云服务文档和 SDK/OpenAPI 文档等进行问答训练，为你答疑解惑，助你轻松解决研发问题。</li>\n</ol>\n<h2>如何使用通义灵码</h2>\n<h3>一、对于 Visual Studio Code</h3>\n<ol>\n<li>已安装 Visual Studio Code 的情况下，在侧边导航上点击扩展</li>\n<li>搜索通义灵码（TONGYI Lingma），找到通义灵码后点击安装</li>\n<li>重启 Visual Studio Code，重启成功后登录阿里云账号，即刻开启智能编码之旅</li>\n</ol>\n<h3>二、对于 JetBrains IDEs</h3>\n<ol>\n<li>以 IntelliJ IDEA 为例，已安装 IntelliJ IDEA 的情况下，点击设置</li>\n<li>点击导航-插件，打开应用市场，搜索通义灵码（TONGYI Lingma），找到通义灵码后点击安装</li>\n<li>重启 IntelliJ IDEA，重启成功后登录阿里云账号，即刻开启智能编码之旅。</li>\n</ol>\n<h2>常见问题</h2>\n<div id=\"accordion\" style=\"max-width: 700px;\">\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>通义灵码是免费的吗？</strong></div>\n<div class=\"card-body text-sm\">通义灵码目前处于公测阶段，免费开放使用。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>通义灵码支持哪些语言？</strong></div>\n<div class=\"card-body text-sm\">通义灵码全面覆盖主流编程语言，在 Java、Python、Go、JavaScript、TypeScript、C/C++ 编码场景表现更优。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>通义灵码支持哪些IDE？</strong></div>\n<div class=\"card-body text-sm\">通义灵码支持和兼容JetBrains IDEs 2020.3 及以上，包含IntelliJ IDEA、PyCharm、GoLand、WebStorm 等 JetBrains IDEs，还支持和兼容 Visual Studio Code 1.75.1 及以上版本。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>通义灵码支持哪些操作系统版本？</strong></div>\n<div class=\"card-body text-sm\">JetBrains IDEs 兼容的操作系统：Windows 7 及以上、macOS、Linux。Visual Studio Code 兼容的操作系统：Windows 8.1 及以上、macOS、Linux。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>使用什么账号进行登录体验通义灵码？</strong></div>\n<div class=\"card-body text-sm\">需要使用阿里云账号登录后体验通义灵码，在 IDE 客户端的通义灵码助手窗口中单击登录按钮，即可完成阿里云登录。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>RAM 用户可以体验通义灵码吗？</strong></div>\n<div class=\"card-body text-sm\">RAM 用户也可以使用通义灵码，在 IDE 客户端中单击登录，切换到 RAM 用户登录页面，完成登录后即可体验通义灵码。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>通义灵码基于什么大模型？</strong></div>\n<div class=\"card-body text-sm\">通义灵码基于阿里自研的大模型「通义大模型」。</div>\n</div>\n</div>'),
                                                                        (257,	0,	0,	'<p>CodeGeeX是国内人工智能公司智谱AI开发的对标GitHub Copilot的免费AI编程工具，该工具基于其CodeGeeX2多语言代码生成模型，支持Python、Java、C++/C、JavaScript、Go等多种编程语言，可以实现代码的生成与补全、自动添加注释、代码翻译以及智能问答等功能，帮助开发者快速编写代码，提升开发效率。</p>\n<h2>CodeGeeX的主要功能</h2>\n<ul>\n<li><strong>代码生成与补全：</strong>CodeGeeX可以根据自然语言注释描述的功能自动生成代码，也可以根据已有的代码自动生成后续代码，补全当前行或生成后续若干行，帮助你提高编程效率。</li>\n<li><strong>注释生成：</strong>CodeGeeX可以给代码自动添加行级注释，节省大量开发时间。</li>\n<li><strong>代码翻译：</strong>基于AI大模型对代码进行语义级翻译，支持多种编程语言互译（Python、Go、Java、JavaScript、C++、C#、PHP、TypeScript等），准确率高。</li>\n<li><strong>智能问答：</strong>无需离开IDE环境，去搜索引擎寻找答案，开发中遇到的技术问题，可直接向AI助手提问。</li>\n<li><strong>支持主流IDE：</strong>提供Visual Studio Code 插件和JetBrains IDEs插件（IntelliJ IDEA, PyCharm等），让你在熟悉的开发环境中快速开发。</li>\n</ul>\n<h2>常见问题</h2>\n<div id=\"accordion\" style=\"max-width: 700px;\">\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>CodeGeeX是免费的吗？</strong></div>\n<div class=\"card-body text-sm\">CodeGeeX对于个人开发者来说是完全免费使用的。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>CodeGeeX基于什么大模型？</strong></div>\n<div class=\"card-body text-sm\">CodeGeeX基于 ChatGLM2 架构加入代码预训练实现的 CodeGeeX2 代码大模型。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>CodeGeeX支持哪些编程语言？</strong></div>\n<div class=\"card-body text-sm\">CodeGeeX支持Python、Java、C++、JavaScript、Go等数十种常见编程语言。</div>\n</div>\n</div>'),
                                                                        (258,	0,	0,	'AI编程和软件开发'),
                                                                        (259,	0,	0,	'<h2 class=\"d-none\">CodiumAI是什么？</h2>\n<p>CodiumAI是一款AI代码测试和分析工具，可以智能分析开发者编写代码、文档字符串和注释，并且可以与人聊天互动，在编程时生成测试建议和提示。借助其全面的测试套件，可以帮助开发人员在软件发布前发现Bug或错误，确保软件的可靠性和准确性。</p>\n<h2>CodiumAI的主要功能</h2>\n<ul>\n<li>智能创建全面的测试套件，包括自动生成单元测试、智能分析代码、代码修改建议、查找代码错误、自动添加文档字符串等</li>\n<li>AI编程对话助手，内置 CodiumAI 聊天功能，可以通过对话聊天命令来改进编写的代码</li>\n<li>支持所有编程语言，CodiumAI 支持几乎所有编程语言，不过，某些高级功能（例如单元测试运行和修复）仅支持 Python、JavaScript、TypeScript 和 Java。</li>\n<li>兼容的主流编辑器和IDE，CodiumAI 目前支持 VS Code 和 JetBrains 旗下的 IntelliJ、WebStore、CLion、PyCharm 等IDE。</li>\n</ul>\n<h2>CodiumAI的产品价格</h2>\n<p>对于个人开发者来说，CodiumAI无需付费，可永久免费使用<br>\n对于多人团队来说，CodiumAI需花费19美元每月每用户来订阅</p>\n<h2>常见问题</h2>\n<div id=\"accordion\" style=\"max-width: 700px;\">\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>CodiumAI是免费的吗？</strong></div>\n<div class=\"card-body text-sm\">针对个人用户，CodiumAI可永久免费使用。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>CodiumAI基于什么大模型？</strong></div>\n<div class=\"card-body text-sm\">CodiumAI基于OpenAI提供的GPT-3.5和GPT-4大模型。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>CodiumAI相比GitHub Copilot有什么优势？</strong></div>\n<div class=\"card-body text-sm\">相比GitHub Copilot，CodiumAI 更专注于代码完整性，在代码测试方面更加强大。</div>\n</div>\n</div>'),
                                                                        (260,	0,	0,	'<p>Sketch2Code由微软AI Lab于2018年推出，旨在帮助开发人员轻松地将手绘草图转化成HTML代码的开源项目。使用Sketch2Code，开发人员可以绘制线框草图并将其导出为源代码。Sketch2Code使用人工智能和自动化从线框草图中开发代码，支持基本的网页视觉元素，包括标签、文本字段、文本段落、图像和按钮等。</p>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/29838286cb5f6dc.webp\"  alt=\"Sketch2Code\" width=\"1200\" height=\"666\">\n<p>2018年发布时，该项服务背后的模型已经用数百万张图像进行了训练，可以对各种类型的物体进行物体检测。有了这些信息，该工具可以生成设计中不同元素的HTML代码片段，然后可以根据识别的元素的位置推断设计的布局，并相应地生成最终的HTML代码。</p>\n<p>而在GPT 4的演示中，也有一段将草图转换成网页的Demo演示，很可能微软已经将该技术与OpenAI合作并进行了迭代，而最新训练的图像数据也可能远超2018年。</p>'),
                                                                        (261,	0,	0,	'<p>Codeium 是一个基于人工智能技术构建的AI代码编程工具，提供代码自动补全和搜索功能，使开发人员能够快速定位和生成代码。该AI工具包可以帮助开发人员更快、更高效地编写代码，以增强开发人员的编程体验。</p>\n<h2>Codeium的主要功能</h2>\n<ol>\n<li>自动补全：自动生成代码补全建议，从而节省你在从样板代码到单元测试的时间。</li>\n<li>智能搜索：使用自然语言问题搜索代码库，无需再使用繁琐的正则表达式。</li>\n<li>AI代码助手： 提供 Codeium Chat 对话助手，可生成和重构代码、添加文档、解释代码、建议错误修复等。</li>\n<li>支持70多种语言：支持 C、C++、C#、 Java、JavaScript、Python、PHP等主流编程语言</li>\n<li>兼容40多个编辑器：支持 VSCode、JetBrains IDEs、Visual Studio、Eclipse等常用编辑器</li>\n</ol>\n<h2>Codeium的产品价格</h2>\n<ol>\n<li>对于个人开发者来说，Codeium无需付费，可免费使用</li>\n<li>对于多人团队来说，Codeium需花费15美元每月来订阅，年付的话每月只需12美元</li>\n</ol>\n<h2>常见问题</h2>\n<div id=\"accordion\" style=\"max-width: 700px;\">\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>Codeium是免费的吗？</strong></div>\n<div class=\"card-body text-sm\">针对个人用户，Codeium 可免费使用。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>Codeium基于什么模型？</strong></div>\n<div class=\"card-body text-sm\">Codeium基于其内部训练的专有模型和OpenAI提供的技术。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>Codeium相比GitHub Copilot有什么优势？</strong></div>\n<div class=\"card-body text-sm\">相比GitHub Copilot，Codeium对于个人开发者永久使用，且兼容更多编程语言和编辑器。</div>\n</div>\n</div>'),
                                                                        (262,	0,	0,	'黑箱AI编程助理，快速代码生成'),
                                                                        (263,	0,	0,	'<p>Cody是由代码搜索浏览工具「Sourcegraph」推出的一个AI代码助手，通过阅读整个代码库和代码图，帮助开发人员写代码并回答问题。Cody使用Sourcegraph的代码图和大型语言模型（LLMs）的组合，以消除人工开发中的繁琐任务并保持开发人员的工作流程。</p>\n<p>你可以把Cody当作是你的代码助手，该自动编程工具已经阅读了开源中的所有代码，StackOverflow上的所有问题，以及开发人员的整个代码库，可以回答开发过程中遇到的问题或者根据先前的知识建议一些方法。</p>\n<h2>Cody的主要功能</h2>\n<p>Cody就像代码编辑器中的 ChatGPT，可以帮助你更好更快地编程。</p>\n<ol>\n<li>人工智能生成代码。Cody 可以根据代码库的上下文和样式生成从样板代码到 API 解析器的所有内容，还可以修复代码块的错误、可读性或未处理的边缘情况。</li>\n<li>自动生成单元测试。Cody 可以编写单元测试，节省开发人员的时间以专注于构建软件。</li>\n<li>解释代码信息。Cody 可以从高层次或细节上解释代码的作用，突出显示任何代码块或整个文件，以对话语言解释发生了什么。</li>\n<li>编程语言翻译。开发人员可以将代码片段提供给 Cody，例如某个函数。Cody 可以翻译该代码，提供具有相同功能的另一种语言的代码片段。</li>\n</ol>\n<h2>如何使用Cody</h2>\n<p>使用Cody非常简单，目前Cody可以在Sourcegraph的网页和VS Code中使用。</p>\n<ol>\n<li>安装 VS Code的Cody扩展</li>\n<li>打开 Cody（从活动栏或者Alt + /或Opt + /）并登录</li>\n<li>点击Chat或者Recipes（内置的一些命令）进行使用</li>\n</ol>'),
                                                                        (264,	0,	0,	'<p>CodeWhisperer是亚马逊最新发布的AI编程软件，经过数十亿行代码的训练，可以根据开发人员的注释和现有代码实时生成从片段到完整函数的代码建议。减轻耗时的编程任务，和加快使用不熟悉的API时构建代码的速度。目前，亚马逊的CodeWhisperer针对个人用户是完全免费使用的，无限制次数的代码建议生成和每月50次的代码安全扫描！</p>\n<h2>CodeWhisperer的主要功能</h2>\n<ol>\n<li>实时生成代码建议。理解用自然语言（英语）编写的注释，可以实时生成函数级和块级代码建议以提高开发人员的工作效率。</li>\n<li>支持流行的编程语言和 IDE。 为多种编程语言提供基于AI的代码建议，包括 Python、Java、JavaScript等，并与VS Code和JetBrains旗下的系列IDE兼容。</li>\n<li>内置安全扫描。使用 CodeWhisperer，开发者可以扫描 Java、JavaScript 和 Python 项目以检测难以发现的漏洞。</li>\n<li>开源代码引用跟踪器。提供内置的引用跟踪器，用于检测代码建议是否可能与开源训练数据相似，并可以标记此类建议。</li>\n<li>可与 AWS 服务配合使用。通过提供针对 AWS API 进行优化的代码建议，让开发人员更高效地使用 AWS 服务。</li>\n</ol>\n<h2>CodeWhisperer的产品价格</h2>\n<ul>\n<li>对于个人开发人员，可以免费使用 CodeWhisperer，支持不限次数地生成代码建议并免费使用引用跟踪器，且每月可免费进行 50 次代码扫描。</li>\n<li>对于企业组织来说，专业版本的价格是每人每月19美元，提供500次代码安全扫描。</li>\n</ul>\n<h2>常见问题</h2>\n<div id=\"accordion\" style=\"max-width: 700px;\">\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>CodeWhisperer是免费的吗？</strong></div>\n<div class=\"card-body text-sm\">对于个人开发人员来说，CodeWhisperer可以免费使用，支持不限次数地生成代码建议。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>CodeWhisperer具体支持哪些编程语言？</strong></div>\n<div class=\"card-body text-sm\">CodeWhisperer 支持 15 种编程语言，包括 Java、Python、JavaScript、TypeScript、C#、Go、PHP、Rust、Kotlin、SQL、Ruby、C++、C、Shell、Scala。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>CodeWhisperer支持哪些编辑器或IDE？</strong></div>\n<div class=\"card-body text-sm\">CodeWhisperer 支持的代码编辑器或IDE包括Amazon Sagemaker Studio、JupyterLab、Visual Studio Code、JetBrains 旗下的IDEs、AWS Cloud9、AWS Lambda、AWS Glue Studio。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>CodeWhisperer基于什么大模型？</strong></div>\n<div class=\"card-body text-sm\">CodeWhisperer由基于包括 Amazon 和开源代码在内的各种数据来源训练的基础模型提供支持。</div>\n</div>\n</div>'),
                                                                        (265,	0,	0,	'<p>GitHub Copilot是由GitHub与OpenAI合作开发的一款革命性的智能代码补全和生成工具，旨在帮助开发人员更高效、更准确、更快地编写代码。这款由人工智能驱动的AI编程助手与程序员常用的代码编辑器无缝集成，超过数百万人在使用，对全球各地的开发者来说都是代码神器和得力助手。</p>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/255de3f44e0f99b.png\"  alt=\"GitHub Copilot\" width=\"800\" height=\"450\">\n<h2>GitHub Copilot的主要功能</h2>\n<ol>\n<li>代码建议和自动补全。GitHub Copilot在你输入时提供实时的代码建议和自动补全，大大减少编码时间并减少错误。</li>\n<li>自然语言理解。可以理解自然语言查询，并根据对你想要实现的内容的纯英语描述生成代码片段。</li>\n<li>支持多种编程语言。GitHub Copilot支持多种编程语言，从Python和JavaScript到C++和Ruby，确保与主流的语言兼容。</li>\n<li>上下文注释。为编写的代码生成描述性注释，帮助你和你的合作者理解代码的目的和功能。</li>\n<li>代码重构。GitHub Copilot会智能建议代码改进、重构选项和最佳实践，帮助你编写干净和优化的代码。</li>\n<li>代码示例。你可以轻松搜索并插入来自各种来源的代码示例，节省重新发明轮子的麻烦。</li>\n</ol>\n<h2>如何使用GitHub Copilot</h2>\n<ol>\n<li> 安装GitHub Copilot插件。在开始使用之前，需要在你常用的代码编辑器中安装GitHub Copilot扩展，如Visual Studio Code和JetBrain旗下的系列IDEs。</li>\n<li>登录GitHub账号。使用你的GitHub帐户登录验证，以访问GitHub Copilot的全部功能并接收定期更新。</li>\n<li>安装和验证完成后，GitHub Copilot将无缝集成到你的编程环境中，随时为你提供帮助。</li>\n<li>添加注释作为提示词生成代码，在编写代码时，你也可以实时看到GitHub Copilot提供建议、自动完成甚至整个代码块。</li>\n</ol>\n<h2>GitHub Copilot的产品价格</h2>\n<ol>\n<li>GitHub Copilot 提供免费 30 天的试用，免费试用结束后，需要付费订阅。</li>\n<li>对于个人来说，每月10美元（年付的话一年100美元）。</li>\n<li>对于商业版来说，每个用户每月19美元。</li>\n</ol>\n<h2>常见问题</h2>\n<div id=\"accordion\" style=\"max-width: 700px;\">\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>GitHub Copilot是免费的吗？</strong></div>\n<div class=\"card-body text-sm\">对于经过验证的学生、教师或流行开源项目的维护人员，GitHub Copilot 可免费使用。若非前述人员，GitHub Copilot 提供免费 30 天的试用，免费试用结束后，需要付费订阅。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>GitHub Copilot具体支持哪些编程语言？</strong></div>\n<div class=\"card-body text-sm\">GitHub Copilot 支持 C、C++、C#、Go、Java、JavaScript、PHP、Python、Ruby、Scala 和 TypeScript等编程语言。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>GitHub Copilot支持哪些编辑器或IDE？</strong></div>\n<div class=\"card-body text-sm\">GitHub Copilot 支持和兼容 Visual Studio、NeoVim、VS Code、Azure Data Studio 和 JetBrains 旗下的系列 IDEs 和代码编辑器。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>GitHub Copilot基于什么大模型？</strong></div>\n<div class=\"card-body text-sm\">GitHub Copilot 由 OpenAI 的 CodeX 大模型驱动，该模型由数十亿行开源代码构建而成。</div>\n</div>\n</div>'),
                                                                        (266,	0,	0,	'<blockquote><p>更新：9月5日起，讯飞星火认知大模型面向全民开放。在各大主流应用商店搜索“讯飞星火”App，或登录讯飞星火官网（xinghuo.xfyun.cn）均可直接注册使用。</p></blockquote>\n<p>「讯飞星火认知大模型」是科大讯飞于2023年5月6日在讯飞星火认知大模型成果发布会上发布的类ChatGPT产品。讯飞星火认知大模型是以中文为核心的新一代认知智能大模型，拥有跨领域的知识和语言理解能力，能够基于自然对话方式理解与执行任务。从海量数据和大规模知识中持续进化，实现从提出、规划到解决问题的全流程闭环。</p>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/e65de6c132c08ad.png\"  alt=\"讯飞星火认知大模型指令集\" width=\"800\" height=\"418\">\n<h2>讯飞星火可以做什么？</h2>\n<p>讯飞星火可以帮助用户：</p>\n<ul>\n<li>内容生成</li>\n<li>语言理解</li>\n<li>知识问答</li>\n<li>逻辑推理</li>\n<li>数学题解答</li>\n<li>代码理解与生成</li>\n</ul>\n<h2>由讯飞星火驱动的产品</h2>\n<ul>\n<li>讯飞智文</li>\n<li>星火内容运营大师</li>\n<li>星火文档问答</li>\n<li>星火科研助手</li>\n<li>ProcessOn AI流程图</li>\n<li>iFlyCode</li>\n</ul>'),
                                                                        (267,	0,	0,	'<p>MOSS是复旦大学团队开发的国内第一个发布的对话式大型语言模型，今年2月邀公众参与内测。它可以执行对话生成、编程、事实问答等一系列任务，打通了让生成式语言模型理解人类意图并具有对话能力的全部技术路径。4月21日，新版MOSS模型正式上线并宣布开源。</p>'),
                                                                        (268,	0,	0,	'AI Logo生成工具'),
                                                                        (269,	0,	0,	'AI调色板生成工具'),
                                                                        (270,	0,	0,	'AI调色生成工具'),
                                                                        (271,	0,	0,	'AI灰度logo或插画上色工具'),
                                                                        (272,	0,	0,	'基于深度学习的色彩生成工具'),
                                                                        (273,	0,	0,	'AI SVG矢量插画生成工具'),
                                                                        (274,	0,	0,	'AI生成3D材质'),
                                                                        (275,	0,	0,	'<p>Fabrie是一个面向全球设计团队打造的白板协作平台，该产品已推出AI设计助手Fabrie AI，可帮助设计师在白板上更便捷地获取灵感、快速渲染、迭代设计方案。只需选择预设场景模板，补充颜色、材质、背景细节即可生成不错的设计效果图。</p>\n<h2>Fabrie AI的产品特色</h2>\n<ol>\n<li>支持3种渲染模式，用户可按需选择线稿、白模、效果图等模式进行渲染</li>\n<li>支持5种渲染风格，包括照片写实、3D卡通渲染、真实人像、动漫画风、建筑写实</li>\n<li>提供海量风格模型库，包括盲盒玩偶、墨菲电器、未来机甲、蒸汽朋克、生活产品、线条速写、毛玻璃风格等近30种风格的模型</li>\n<li>适合于各行业的设计应用，包括室内设计、平面设计、服装设计、影视美术、游戏CG、建筑景观等行业</li>\n</ol>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/c0a8c952060d313.jpeg\"  alt=\"Fabrie AI设计助手\" width=\"800\" height=\"450\">\n<h2>如何使用Fabrie AI</h2>\n<ol>\n<li>访问Fabrie AI的官网，点击右上角的登录/注册</li>\n<li>登录成功后会进入白板编辑界面，点击左侧边栏顶部的AI图标</li>\n<li>微信扫描二维码填写调查问卷，然后过几分钟即可获得免费内侧的资格</li>\n<li>然后刷新当前页面，点击AI图标，选择渲染模式</li>\n<li>选择基础风格，上传参考图，输入提示词并调节其他参数</li>\n<li>最后点击开始生成按钮即可</li>\n</ol>\n<h2>Fabrie AI的产品价格</h2>\n<p>Fabrie AI目前在免费内测中，用户只需扫描微信小助手的二维码填写问卷便可以免费获得内测资格，每日有300张的免费内测额度生成。</p>'),
                                                                        (276,	0,	0,	'<h2>Meshy是什么？</h2>\n<p>Meshy 是一个 3D 生成 AI 工具箱，可轻松从文本或图像创建 3D 资源，适用于 3D 艺术家、爱好者、XR 开发者、游戏制作者和设计师加速 3D 设计的工作流程。使用 Meshy，用户只需输入一个简单的提示，便可以在几分钟内创建高质量的纹理和 3D 模型。值得一提的是，Meshy 公司的联合创始人兼CEO为计算机图形学知名学者胡渊鸣，太极图形和编程语言的创始人。</p>\n<img  class=\"alignnone size-full rounded shadow-sm\" src=\"/uploadfile/202312/62bce61b0b6d725.png\"  alt=\"Meshy AI\" width=\"800\" height=\"450\">\n<h2>Meshy的主要功能</h2>\n<ol>\n<li>AI模型纹理生成：可选择文本或图像作为输入，生成物体的纹理。 Meshy目前更适合生成道具、建筑物和武器等物体的纹理。</li>\n<li>AI文本到3D生成：即使没有 3D 经验的创作者，也能够使用文本输入在短短一分钟内快速生成 3D 模型。</li>\n<li>AI图像到3D转换：通过简单的图像输入，Meshy 可轻松将你想要的 2D 物体图像转换为 3D 立体模型。</li>\n</ol>\n<h2>Meshy的产品价格</h2>\n<ol>\n<li>Free免费版，每月200积分，一个队列可等待生成2个任务</li>\n<li>Pro专业版，每月20美元（年付每月16美元），每月可获得1000积分，一个队列可等待生成10个任务</li>\n<li>Max版本，每月60美元（年付每月48美元），每月可获得4000积分，一个队列可等待生成20个任务</li>\n</ol>\n<h2>常见问题</h2>\n<div id=\"accordion\" style=\"max-width: 700px;\">\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>Meshy是免费的吗？</strong></div>\n<div class=\"card-body text-sm\">Meshy提供免费积分，用户每月可获得200积分，分享创建的3D作品到Discord也能额外获得最高200积分。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>Meshy支持的3D文件格式？</strong></div>\n<div class=\"card-body text-sm\">Meshy目前支持.fbx、.obj、.stl、.gltf和.glb格式的3D文件。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>Meshy支持上传的文件大小？</strong></div>\n<div class=\"card-body text-sm\">Meshy目前支持上传到网页版的3D模型为50MB，上传到Discord则为25MB。</div>\n</div>\n</div>'),
                                                                        (277,	0,	0,	'<p>美间是一款AI创意内容云设计工具，由国产3D室内设计软件酷家乐所属公司推出，提供海量方案模板和快速设计工具，为平面设计创作者量身打造流畅、高效、美观的创作体验。致力于服务软装设计师，通过海量的设计素材和简单易用的编辑功能，帮助设计师高效、快速地完成软装搭配创作。</p>\n<h2>美间的AI功能</h2>\n<ol>\n<li>AI灵感库。只需选择一张图片，就能自动创造出一系列相应风格的图片素材，还能生成配套的提案PPT、海报直接使用。让你的灵感再生不设限，用一个元素玩转整个设计世界。</li>\n<li>AI软装设计。让AI帮你解放双手，解锁设计超能力，分分钟搞定高品质软装设计方案。你的每一步软装搭配都有AI帮你提升效率，只需鼠标轻轻点击，自动扣图、智能排版、素材替换都在几秒内轻松搞定！</li>\n<li>AI提案。在美间，每一份提案都与众不同，你可以直接描述你的风格需求，AI一键智能创作，就能get一份独一无二的提案PPT！甚至还贴心的帮你搭配好配套风格的提案PPT和营销海报，轻松解决设计烦恼！</li>\n<li>AI视频讲解。从图文到视频，让好设计自己说话，带来全新的视听体验。美间AI可以帮助你将提案PPT瞬间化身成一段超详细的讲解视频，根据提案内容自动生成视频文案，自定义风格语速。让AI帮你讲解设计思路，轻松拿捏方案魅力。</li>\n</ol>'),
                                                                        (278,	0,	0,	'<p>图宇宙是一款国产的智能设计工具化平台，由「Nolibox 计算美学」推出。通过自主研发的智能设计引擎，图宇宙深度整合行业经验，满足用户的设计需求和审美喜好。使用图宇宙，用户可以得到高品质、大规模、定制化、快响应、低成本的各类应用视觉设计。</p>\n<h2>图宇宙的主要功能</h2>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/df478b6481c8ee2.png\"  alt=\"图宇宙的官网展示\" width=\"800\" height=\"450\">\n<ol>\n<li>智能生成，极致体验。基于「场景需求」和「用户喜好」的智能设计引擎，图宇宙产出高品质的商品图、logo设计、智能海报设计等，提供极致的设计体验。</li>\n<li>海量素材，正版授权。图宇宙与全球多个头部设计素材供应商达成战略合作，海量正版素材为每一位用户的营销推广保驾护航。</li>\n<li>热点文案，妙笔生花。通过大数据分析和NLP技术，挖掘市场和社会热点，为你推荐优质营销语料创意。你的文案锦囊，创意快人一步。</li>\n<li>智能推荐，懂你所需。图宇宙的智能推荐系统，整合专业的设计知识，构建完善的需求理解模型，辅助您快速完成个性化设计，打造“更高情商”的推荐体验。</li>\n</ol>'),
                                                                        (279,	0,	0,	'<p>Luma AI是一个基于人工智能的三维捕捉、建模和渲染工具，旨在帮助用户创建逼真的、高质量的3D物体，你可以直接使用你的iPhone手机用AI创造令人难以置信的逼真的3D。</p>\n<p>无论你在何处，都可以使用Luma AI轻松地捕捉产品、物体、风景和场景。从你的捕捉中创造出电影般的产品视频，为TikTok创造不可能的相机动作，或者只是重温那一刻。不需要激光雷达或花哨的捕捉设备，你所需要的只是一部iPhone 11或更新版本。</p>\n<p>Luma AI的功能特色：</p>\n<ul>\n<li>捕捉具有复杂细节、反射和照明的3D场景，并与其他人分享。</li>\n<li>以3D方式捕捉产品，并在你的网站上展示它们在现实生活中的样子。</li>\n<li>高质量地捕捉3D游戏素材，并将它们导入Blender、Unity或你选择的3D引擎中。</li>\n</ul>'),
                                                                        (280,	0,	0,	'AI网页、App和UI设计'),
                                                                        (281,	0,	0,	'AI插画生成，low poly、3D、矢量、logo、像素风、皮克斯等风格'),
                                                                        (282,	0,	0,	'<p>Spline是一款基于浏览器的免费在线3D编辑器，该网站基于Stable Diffusion v2的AI生成技术，推出了Spline AI，该AI 3D设计工具允许用户输入文本自动创建和生成3D物体、动画、材质等，以加速3D设计人员的设计速度。</p>'),
                                                                        (283,	0,	0,	'AI高保真原型设计'),
                                                                        (284,	0,	0,	'AI设计工具'),
                                                                        (285,	0,	0,	'<p>Dora AI 是低代码网站设计平台「Dora」最新推出的AI网站设计工具，用户只需输入一句提示文本，便可以生成可编辑的并且带有精美3D动画的网站。Dora AI 目前处于Alpha测试中，感兴趣的用户可以在官网点击Join Waitlist进入等待列表体验。</p>\n<h2>Dora AI 的特色功能</h2>\n<ol>\n<li>从文本描述生成网站：设计人员只需输入一行描述文字便能快速生成令人惊叹、完全可编辑的网站。</li>\n<li>将静态设计转化为三维：通过Dora强大的三维互动生成器，可以将静态设计提升到全新的层面。</li>\n<li>先进的人工智能动画： 将你的动画过程自动化，无需耗费数小时的手工创作过程。</li>\n</ol>'),
                                                                        (286,	0,	0,	'<p>通常在Photoshop中用手绘出一个概念设计可能需要几个小时，而在Vizcom AI的深度学习模型帮助下，设计师可以在画图的时候快速进行高质量的渲染，并支持导入自己的图纸。Vizcom的免费版支持无限制的文件数量和渲染次数，付费版支持团队协作/管理、无限次的导出和自定义AI模型。</p>'),
                                                                        (287,	0,	0,	'<p>模袋云是一个设计、协同、可视化全链路建筑云平台，已推出建筑AI创作的模袋云AI，专注于大型建筑、小型住宅、室内设计、景观的出图和AI模型训练，注册即可免费无限量使用。</p>\n<h2>模袋云AI的产品特色</h2>\n<ol>\n<li>模袋云AI完全免费使用，海量无限出图和训练AI模型，大型建筑、小型住宅、室内设计、景观都没问题。</li>\n<li>操作简单，免部署。全界面中文版本，只需上传图片或输入描述，轻轻一点，即可出图，无需做任何环境部署。</li>\n<li>支持一键应用其他创作者精心训练的风格模型，也可以自定义训练模型，让你的出图更具目的性，无需担心AI过于天马行空。</li>\n<li>提供优秀的AI泛建筑灵感社区，包含建筑、别墅、室内、景观等各类图片。用户可以在社区中交流AI创作的参数，并且可以“生成同款”快速尝试获得不一样的图片。</li>\n</ol>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/8c25ba5366076f0.png\"  alt=\"模袋云AI\" width=\"800\" height=\"467\">\n<h2>如何使用模袋云AI</h2>\n<ol>\n<li>访问模袋云AI的官网，使用手机/微信登录注册</li>\n<li>登录成功后，点击灵感创作进入创作界面，选择需要的场景模板</li>\n<li>上传创作素材，选择调整创作设置或保持不变</li>\n<li>点击立即生成，开始创作</li>\n</ol>'),
                                                                        (288,	0,	0,	'<p>Vectorizer.AI是一个人工智能驱动的图片转换工具，可以帮助用户将JPG/PNG位图快速转换成SVG格式的矢量图，方便设计人员对图片进行二次编辑和上色。</p>\n<h2>Vectorizer.AI的产品功能</h2>\n<ul>\n<li>深度矢量引擎：基于深度学习网络、经典算法和专有数据集，从头开始训练了支撑该项服务的人工智能网络。</li>\n<li>全形状拟合：超越简单的贝塞尔曲线，Vectorizer.AI尽可能拟合复杂的整个几何形状，以获得完美的贴合和无与伦比的一致性。</li>\n<li>曲线支持：除了整个几何形状之外，还可以从直线、圆弧、椭圆弧以及二次和三次贝塞尔曲线构建矢量形状。</li>\n<li>高性能：利用最先进的 GPU 进行深度学习，并在多核 CPU 上运行精心调整的大规模并行经典算法，快速转换矢量图</li>\n<li>全彩和透明度：支持全 32-bit 颜色，包括 Alpha 通道，完全支持部分透明区域和抗锯齿。</li>\n<li>导出选择：支持 SVG、PDF、EPS、DXF 和 PNG 作为输出格式。</li>\n</ul>\n<h2>如何使用Vectorizer.AI</h2>\n<ol>\n<li>访问Vectorizer.AI的官网，上传或拖放要转换的位图</li>\n<li>等待自动处理结果，点击左上方的Download下载按钮</li>\n<li>选择导出时的参数和设置，然后点击下载图像即可</li>\n</ol>'),
                                                                        (289,	0,	0,	'<p>Realibox引力波是一个一站式在线 3D 设计与协同平台，提供一站式3D建模、3D渲染，多人同时编辑设计作品，随时在线评审，海量设计模版素材，设计一键交付等功能。Realibox最新推出AI造物功能，将生成式 AI 与产品设计融合，白模生成渲染、草图生成渲染图、文字生成材质贴图，Realibox AI 助你快速提案，用AI重塑产品设计生产力。</p>\n<h2>Realibox AI的主要功能</h2>\n<ol>\n<li>草图生成渲染图。简单手绘一张草图，上传到 Realibox AI，即可生成多种渲染方案（支持多种风格，如极简主义、自然仿生、宜家、抽象艺术等）</li>\n<li>模型生成渲染图。导入未渲染的白模，配上简单文字描述，即可生成精美渲染方案</li>\n<li>文字生成材质贴图。简单文字描述，即可生成适用于多通道的材质贴图（提供纤维、丝绸、尼龙、亚麻布、法兰等多种材质），无需四处找贴图</li>\n</ol>\n<h2>如何使用Realibox AI</h2>\n<ol>\n<li>访问Realibox的官网，点击AI造物菜单，然后点击立即体验按钮</li>\n<li>扫描二维码，登录/注册你的账号，登录成功后会自动进入到Realibox AI造物的工作台界面</li>\n<li>上传或导入你的草图/模型，或者点击内置的案例快速体验</li>\n<li>在左侧自定义调整主体名称、颜色、材质、背景、风格、细节等参数，或者使用默认参数，点击生成按钮，等待10秒左右即可出图</li>\n</ol>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/a300b82873dae2a.png\"  alt=\"Realibox AI渲染\" width=\"800\" height=\"450\">\n<h2>Realibox AI的产品价格</h2>\n<p>Realibox AI造物的功能目前在公测中，无需付费，用户登录注册后便可以不限量地免费使用AI渲染出图。</p>'),
                                                                        (290,	0,	0,	'<p>LogoliveryAI是一个免费的AI Logo生成工具，类似于Midjourney，也是在Discord中输入指令使用。不同于其他的Logo生成器免费版只提供PNG/JPEG格式，LogoliveryAI为用户提供了SVG矢量图片格式，可任意缩放和后续精细调整。AI工具集实测其生成的效果用于直接使用还有一定的距离，不过用来作为logo灵感或者娱乐项目还是可以的。</p>\n<h2>LogoliveryAI的产品特色</h2>\n<ol>\n<li>生成专业的可缩放的SVG格式的logo，无需再担心logo图片有像素化和模糊的边缘。</li>\n<li>可用于商业用途。由LogoliveryAI创建的logo所有权属于创作者，可自由用于商业目的。</li>\n<li>人工团队升级和改进Logo。如果用户对生成的logo概念不满意的话，Logolivery的设计团队还提供了付费的Logo Upgrade专业服务。</li>\n</ol>\n<h2>如何使用LogoliveryAI生成Logo</h2>\n<ol>\n<li>通过链接加入 Discord 服务器：https://discord.gg/GWxedHT3d2</li>\n<li>转到其中一个 ai-room (⁠ai-room-1、⁠ai-room-2、⁠ai-room-3) 频道</li>\n<li>输入/generate并描述您想要的logo</li>\n<li>该机器人将在60 秒内生成 SVG 格式的logo。15分钟内，所有logo下载链接都可使用</li>\n</ol>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/206bddd17ccbec9.png\"  alt=\"LogoliveryAI Discord\" width=\"800\" height=\"403\">\n<h2>LogoliveryAI是免费的吗</h2>\n<p>LogoliveryAI目前为用户提供了10次的免费生成次数，每次会生成4个不同的设计logo，也就意味着你可以免费生成40个logo。</p>'),
                                                                        (291,	0,	0,	'<p>Motiff 是国内在线教育企业「猿辅导」旗下的「看云软件」推出的AI 驱动的用户界面设计工具。设计人员可与 AI 共同协作，开启全新的设计方式和体验，让设计团队工作更高效。</p>\n<h2>Motiff 的产品功能</h2>\n<ul>\n<li>AI 设计系统，AI 扫描并识别设计稿中的组件和样式，将组件和样式分类整理，并提供查看来源功能以便回溯使用场景，助力设计团队省时提效，更好地实践设计系统。</li>\n<li>AI 魔法框，设计师通过魔法框来表达意图，AI 可以快速找到合适的组件，也可以给文本替换合适的样式，并将它们摆放在正确的位置。</li>\n<li>AI 布局，设计师无需进行繁琐的布局设置，即可轻松进行修改边距间距、移入移出子图层等结构化调整，也可以一键回归自由设计。</li>\n</ul>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/dfa729943780b63.png\"  alt=\"Motiff的网站首页\" width=\"800\" height=\"450\">'),
                                                                        (292,	0,	0,	'<p>MasterGo AI是知名国产产品设计工具「MasterGo」推出的智能UI设计助手，该工具允许用户输入文本描述后基于设计系统生成美观的界面设计图。从其宣传视频中可以看出，用户只需输入主题描述想要的界面，然后基于设计系统选择合适的组件，便可以快速搭建你想要的页面。</p>\n<p>目前MasterGo AI处于免费内测申请中，感兴趣的设计人员可以访问官网申请，提交相应的问卷信息等待通过。</p>'),
                                                                        (293,	0,	0,	'<p>Framer原是一个多合一的网页和移动端原型设计工具，后转型为无代码的网站设计和发布平台，可以帮助用户快速上线高颜值的网站页面。Framer最新推出AI功能，用户只需输入文本描述（支持中文），便可以自动设计、排版、生成和上线网站，目前是免费无限次生成。AI工具集这边测试来看，Framer AI是目前一众AI自动生成网站中效果最好的一批。</p>\n<h2>Framer AI的主要功能</h2>\n<ol>\n<li>输入你的网站想法，只需几秒钟，Framer AI便能生成精美的网页，提供的描述细节越多，输出的效果越好。生成的页面每个部分都有布局、文案和样式的独特组合，用户可以随意根据喜好调整。</li>\n<li>自定义不同主题和风格的组合，用户可以混合和匹配显示字体、文本字体和调色板，为网站构建自定义主题或选择Framer内置的搭配。</li>\n<li>提供内置AI网页文案撰写功能，只需鼠标点击一下，Framer AI便可以改进你的网站页面的文案，让其更加具有吸引力</li>\n</ol>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/3b6a1ee9fb7d2cc.png\"  alt=\"Framer AI生成网站\" width=\"1200\" height=\"606\">\n<h2>如何使用Framer AI</h2>\n<ol>\n<li>点击上方的访问官网按钮，跳转到Framer AI的官网</li>\n<li>在输入框中键入你想要的网页描述，然后点击Start with AI按钮</li>\n<li>如果你没有登录的话，Framer会要求你登录/注册</li>\n<li>登录成功后，Framer会跳转到网站编辑器页面开始自动生成网页设计</li>\n<li>Framer AI会生成3个不同端的响应式页面设计（包括Desktop、Tablet、Mobile），你可以点击对应的元素进行修改调整</li>\n<li>微调完毕后，点击右上角的Publish按钮，网页就可以上线发布了！</li>\n</ol>'),
                                                                        (294,	0,	0,	'<p>Pixso AI是国产在线设计工具Pixso的内置AI设计助手，致力于将创意想法落地，目前具备AI文生图、AI生成设计规范、AI灵感专家、AI语言大师、AI生成设计清单五大能力，<span data-font-family=\"default\">为产品设计团队提供智能化</span><span data-font-family=\"default\">设计</span><span data-font-family=\"default\">解决方案，</span><span data-font-family=\"Source Han Sans CN\">解锁未来产品设计新方式</span><span data-font-family=\"default\">。</span></p>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/770fe4d45803fd2.jpg\"  alt=\"Pixso AI助手\" width=\"567\" height=\"279\">\n<h2>Pixso AI的功能</h2>\n<ol>\n<li>AI文生图。输入文本描述，AI自动生成对应的图片，如3D图标、二次元、产品设计、人物拟真、照片写实；</li>\n<li>AI语言大师。对输入的句子或文本进行优化，目前支持包括中文、英文、西班牙语、法语、韩语等在内的9种语言；</li>\n<li>AI灵感专家。可生成论坛评论、随机人民、UI设计小知识、需求文档框架、错误文案提示、代码、用户画像绘制、用户旅程地图等；</li>\n<li>AI设计规范生成。只需输入需求和主色号，即可快速生成完整的设计规范，并保持设计的高度一致性；</li>\n<li>AI元素检查清单。输入页面名称，即可生成完整的设计元素检查清单，所有元素一目了然，确保设计的完整性和一致性。</li>\n</ol>\n<h2>如何使用Pixso AI</h2>\n<ol>\n<li>访问Pixso的官网（pixso.cn），点击在线使用或免费使用按钮</li>\n<li>登录或注册Pixso账号，登录成功后便会自动跳转到工作台</li>\n<li>选择新建设计文件，进入界面设计编辑页面</li>\n<li>点击顶部工具栏的AI助手图标，选择你要使用的AI功能或输入任何问题互动</li>\n</ol>'),
                                                                        (295,	0,	0,	'<h2>酷家乐AI是什么</h2>\n<p>酷家乐AI是一款功能强大的AI家居设计软件，由国产3D室内设计平台酷家乐推出。用户可以上传房间照片，快速生成不同风格的装修效果图，并进行局部修改。支持免费使用，没有专业设计软件能力，也能快速制作和生成北欧风、侘寂风、地中海、法式、工业风、奶油风等装修风格的AI效果图。</p>\n<img  class=\"alignnone size-full rounded-lg shadow-sm\" src=\"/uploadfile/202312/a9e57b81822d6e9.png\"  alt=\"酷家乐AI\" width=\"800\" height=\"450\">\n<h2>酷家乐AI的主要功能</h2>\n<ol class=\"text-md\">\n<li>AI生成灵感图：选择风格模型并输入画面描述关键词即可出图</li>\n<li>快速生成效果图：无需等待漫长渲染，只需10几秒即可快速生成效果图</li>\n<li>户型图转效果图：自动识别上传的户型图，布局助手和AI灵感快速绘图</li>\n<li>任意切换风格：随时切换风格，修改描述，一键轻松出图</li>\n<li>毛坯房/手绘图转效果图：小程序上传毛坯房照片/手绘图片，轻松生成意向风格装修</li>\n</ol>\n<h2>酷家乐AI的适用人群</h2>\n<ol class=\"text-md\">\n<li>室内设计师：生成多种室内设计搭配风格作为备选</li>\n<li>营销导购：快速生成家具搭配效果图，让营销更轻松</li>\n<li>个人业主：直观预览自家装修风格效果</li>\n</ol>\n<h2>酷家乐AI的产品价格</h2>\n<ol class=\"text-md\">\n<li>免费版，每天可生成标清图片25次，高清5次，超清5次</li>\n<li>基础会员年卡379元，可解锁无限次AI小图生成，</li>\n</ol>\n<h2>如何使用酷家乐AI</h2>\n<ol class=\"text-md\">\n<li>访问酷家乐AI的官网，点击立即体验按钮，然后使用微信扫描弹窗的二维码即可在手机上体验</li>\n<li>网页版也可以直接访问（ai.kujiale.com），登录/注册你的账号</li>\n<li>登录成功后便会自动跳转到酷家乐AI的后台，在灵感创作处上传参考图，然后选择风格模型并描述画面</li>\n<li>最后点击立即生成，等待效果图创建即可</li>\n</ol>\n<h2>常见问题</h2>\n<div id=\"accordion\" style=\"max-width: 700px;\">\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>酷家乐AI是免费的吗？</strong></div>\n<div class=\"card-body text-sm\">酷家乐AI提供免费生成次数，每天可生成标清图片25次，高清5次，超清5次。每天签到和分享可获得更多免费次数。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>酷家乐AI支持哪些平台？</strong></div>\n<div class=\"card-body text-sm\">酷家乐AI支持网页版、微信小程序、PC端和移动的端APP。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>酷家乐AI支持模型训练吗？</strong></div>\n<div class=\"card-body text-sm\">酷家乐AI支持免费训练用户自定专属的AI风格模型。</div>\n</div>\n</div>'),
                                                                        (296,	0,	0,	'<p>Recraft AI 是一个无限的人工智能画板，用户可以使用其生成和编辑矢量艺术画、图标、3D图像和插画等资源，提供多种样式的可选风格，适合网站、印刷品和网络营销等设计用途。Rrecraft 对所有用户都是免费的，并允许对生成的图像进行商业使用。</p>\n<h2>Recraft AI的主要功能</h2>\n<ol>\n<li>矢量艺术画生成，支持线稿图、扁平风、卡通风、涂鸦风格的矢量画创作</li>\n<li>插画元素生成，支持精细、手绘、发光、迷幻风、纹理、80年代、像素风等插画风格的生成</li>\n<li>图标生成，支持描边、填充、多色描边、多色填充、虚线描边等风格的图标生成</li>\n<li>还支持3D插图和写实风格的图片生成</li>\n<li>除开图像生成外，Recraft AI还支持图片背景移除、选定区域重绘、矢量图编辑等功能</li>\n<li>创作好的图像和设计，可以PNG、JPG、SVG、Lottie等格式导出，方便使用</li>\n</ol>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/e60c79df4f4c62f.png\"  alt=\"Recraft AI创作界面\" width=\"800\" height=\"450\">\n<h2>如何使用Recraft AI</h2>\n<ol>\n<li>访问Recraft AI的官网，有点右上角的Log in登录或点击Get Recraft free按钮注册账号（需要Google账号）</li>\n<li>登录成功后，会自动跳转到Recraft AI默认的项目界面，等待加载完毕</li>\n<li>在左上方的区域，选择你要创作的元素和风格，并输入文本描述，然后点击Recraft按钮</li>\n<li>稍等几秒，Recraft AI便能根据你的输入智能生成精美的图像</li>\n</ol>\n<h2>Recraft AI的产品价格</h2>\n<p>Rrecraft 对所有用户都是免费的，任何人都可以直接访问网站使用，并允许对生成的图像进行商业使用。</p>'),
                                                                        (297,	0,	0,	'<p>墨刀AI是国内知名产品设计协作平台「墨刀」最新推出的AI产品原型设计助手，帮助产品设计人高效实现和落地创意，激发无限创造力。墨刀AI功能的推出，极大地提高了产品设计的效率，基础性的工具或者是灵感想法，都可以交给AI，让产品设计人员可以更加聚焦业务逻辑和用户体验方面。</p>\n<h2>墨刀AI的主要功能</h2>\n<ol>\n<li>AI生成原型页面。无惧灵感枯竭，告别手动绘制，只需一个指令，墨刀AI便可以为你“智造”多种原型设计方案；</li>\n<li>AI生成原型基础组件。10s快速生成图表、表格等组件。流程图、思维导图轻松搞定。思路清晰呈现，专业超出想象；</li>\n<li>AI助手连续对话。墨刀AI能够快速理解需求，精准、清晰地答疑解惑。方案润色优化、页面布局建议，是你释放创作活力的最佳助手，让你的原型设计更快、更好；</li>\n<li>AI文字智能填充。手动输入太累？AI创作一键生成，根据语义自动填充文字，把时间还给自己，让创意不再受限；</li>\n</ol>\n<h2>如何使用墨刀AI</h2>\n<p>墨刀AI目前已在V8中上线，使用也非常简单。</p>\n<ol>\n<li>进入墨刀官网后，点击右上角的<strong>登录/注册</strong>按钮</li>\n<li>在个人空间的工作台右上角，点击蓝色的<strong>新建</strong>按钮，然后选择<strong>原型</strong></li>\n<li>在弹出的窗口中选择你想要设计的原型模板，然后点击<strong>确定</strong>按钮</li>\n<li>在最左侧的工具栏的最后一项，点击<strong>AI</strong>图标，便能唤起墨刀AI助手</li>\n<li>选择你想要的功能（墨刀内置了生成原型页面、流程图、思维导图、表格、图表等生成的按钮），你也可以输入文本与AI对话</li>\n</ol>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/53dd0f50d6344b4.png\"  alt=\"墨刀AI使用步骤\" width=\"806\" height=\"509\">\n<h2>墨刀AI的产品价格</h2>\n<p>个人用户登录/注册墨刀后，可以获得免费的2000点数用于使用墨刀AI助手，不同功能消耗的点数不一样。</p>\n<ul>\n<li>AI助手：约100点/千字, 以实际消耗点数为准</li>\n<li>生成原型页面：约400点/页面, 以实际消耗点数为准</li>\n<li>生成原型组件：约100~200点/组件, 以实际消耗点数为准</li>\n</ul>\n<p>若点数消耗完毕，你可以选择付费充值点数，价格如下：</p>\n<ul>\n<li>9.9元10,000点数</li>\n<li>39元50,000点数</li>\n<li>69元100,000点数</li>\n<li>99元150,000点数</li>\n</ul>'),
                                                                        (298,	0,	0,	'<p>京东羚珑是京东推出的营销内容创意平台，可以帮助电商运营一键抠图、免费抠图、商品打腰带、改尺寸、商品主图设计、线上广告banner设计、店铺首页设计、活动页设计、页面设计、互动营销设计、小程序设计、动图视频设计、视频广告设计、商品主图视频设计、海报设计、公众号配图设计、二维码名片设计、DM传单设计、物流面贴设计、易拉宝设计、张贴海报设计，海量精美模板，免费设计，免费素材，专区，致力于成为商家经营的设计合作伙伴。</p>'),
                                                                        (299,	0,	0,	'<p>鹿班是由阿里巴巴智能设计实验室自主研发的一款设计产品，基于图像智能生成技术 ，鹿班可以改变传统的设计模式，使其在短时间内完成大量banner图、海报图和会场图的设计，提高工作效率。</p>\n<p>用户只需任意输入想达成的风格、尺寸，鹿班就能代替人工完成素材分析、抠图、配色等耗时耗力的设计项目，实时生成多套符合要求的设计解决方案。</p>'),
                                                                        (300,	0,	0,	'<p>Looka是一款在线的AI Logo生成工具，利用人工智能和机器学习算法帮助企业和个人创建定制化的Logo。该AI生成器操作简单直观，任何人都可以轻松创建出专业精美的Logo，而不需要任何设计经验。使用Looka，用户可以从各种设计模板中选择，自定义Logo的颜色、字体和图标，并获取可用于各种用途的高分辨率图形。Looka的AI算法会分析用户输入和偏好，智能生成符合品牌个性和风格的独特的和定制化的Logo。</p>'),
                                                                        (301,	0,	0,	'<p>AIDesign是腾讯设计云推出的AI在线免费设计Logo的产品功能，该款AI Logo生成器旨在帮助个人用户和企业用户快速生成具有辨识度和独特性的Logo。只需输入品牌名称，便能在10秒内生成精美的Logo。</p>'),
                                                                        (302,	0,	0,	'<p>阿里云智能logo设计为中小企业、创业者提供了一款快捷、智能的logo设计产品。用户仅需要输入logo名称、所属行业、logo描述等关键参数，阿里云就可以为您匹配出上百种logo设计供您自主选择，包括霓虹渐变、几何现代、像素科技、线型极简、赛博朋克、抖音流行、新复古风、自然主义、圆形趣味等不同的logo风格。</p>\n<p>阿里云发布停服公告称，因产品策略调整，智能logo设计产品将从2023年6月30日起停止新购服务，并计划于2023年12月31日起完全停止相关产品的服务。</p>'),
                                                                        (303,	0,	0,	'<p>智绘设计是腾讯推出的多场景智能设计平台，提供特有的AI创意创作功能，包括智能人像与商品抠图、风格动漫化、智能消除笔、智能多尺寸、智能配色等。</p>\n<h2>智绘设计的AI特色功能：</h2>\n<ul>\n<li>秒速创作。挑选模板到编辑文案，数秒内可一键出图；百万级优质正版素材、强大出色的在线编辑体验，助你高效创作。</li>\n<li>智能封面。一键智能生成精美封面，助力新闻资讯、知识文章、短视频、直播、教学课程等内容更吸睛，提升点击转化效果。</li>\n<li>AI视频剪辑。一键智能生成影片视频，助力电商带货、小说推广、增长投放等场景批量快速生产广告视频素材。</li>\n<li>智能抠图。一键分离图像画面中的主体内容，可识别人物、动物、商品、动漫角色等，发丝级精细，从此抠图不求人。</li>\n<li>人像动漫化。一键生成个性化的二次元动漫形象，支持多种漫画风格，可萌可御</li>\n</ul>'),
                                                                        (304,	0,	0,	'<p>Magic Design (Beta) 是热门的在线设计工具Canva推出的一个免费的人工智能设计工具，它可以让你从其海量的精美模板中智能将你的设计理念可视化。只需上传你自己的媒体文件或从一个空白的区域开始，输入你的设计想法，Magic Design便会魔法般的定制好你的设计并呈现在你面前。</p>\n<p>Magic Design是一个由人工智能驱动的设计生成工具，将文本和图像变成个性化的精美设计。你可以输入任何媒体，并将其转化为符合你所需内容和背景的定制模板。通过从8个自动生成的模板中选择，你可以进一步编辑和调整尺寸，毫不费力地将你的想法可视化和细化。</p>\n<p>Magic Design建立在Canva数以百万计的模板、图像、字体和其他图形元素的基础上，并使用人工智能来制作设计，帮助你的想法变成现实。</p>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/b9b2a4c3a2c48cd.jpeg\"  alt=\"Canva Magic Design\" width=\"800\" height=\"450\">'),
                                                                        (305,	0,	0,	'<p>作为Microsoft 365的一部分，Microsoft Designer是一个用于创建任意类型的图像设计的工具，从标志和邀请函到博客横幅和社交媒体帖子。你以前可能在Canva、Fotor、Figma或者其他图形设计的软件设计过类似元素，但Microsoft Designer更加的智能。</p>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/42a7f549811197f.png\"  alt=\"Microsoft Designer\" width=\"1200\" height=\"630\">\n<p>Microsoft Designer与其他设计工具的不同之处在于，它使用了OpenAI的DALL·E 2技术。这是一种人工智能，允许你通过输入你想要的文本描述来创建图像和艺术品。该功能将帮助你为你的项目找到独特的图形，而且由于先进的技术，创建的图像非常逼真。</p>\n<p>你也可以使用你自己的图像和内置的设计工具来完全定制你的视觉效果。通过模板、形状、照片、图标、文本样式和颜色主题，你可以探索不同的外观，获得适合你的项目的精确设计。</p>\n<h2>如何获得Microsoft Designer的资格</h2>\n<p>自2022年12月上线以来，Microsoft Designer需要通过一个等待名单才能获取使用的资格。你可以将你的电子邮件地址添加到列表中，一旦你被授予访问权，将收到登录的说明邮件。</p>\n<p>目前的预览版并不包含所有计划中的功能，但微软从那些有预览权限的人那里寻求反馈，以便在它普遍可用之前改进该工具。Microsoft Designer届时将作为微软365个人和家庭用户的免费应用，可选择高级付费功能。微软还计划将Designer与Microsoft Edge整合。希望为Edge用户在设计社交媒体帖子和他们在浏览器中访问的网站的其他项目时提供帮助。</p>\n<h2>如何使用Microsoft Designer</h2>\n<p>当你登录到Microsoft Designer时，你会看到Designer Copilot。这个工具可以帮助你使用人工智能生成的图像、你自己的图像或空白画布来创建你的第一个视觉。</p>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/6d96ea257de6e93.png\"  alt=\"使用Microsoft Designer\" width=\"800\" height=\"418\">\n<p>只需在输入框中输入你想要创建的视觉元素，比如An Instagram post about my cosmetic product launch on April 1st。然后点击Generate，Microsoft Designer便会自动排版设计。你也可以点击AI Generate image生成你想要的元素。</p>'),
                                                                        (306,	0,	0,	'<p>FigJam AI 是在线设计协作平台 Figma 为其白板工具 FigJam 最新推出的 AI 套件，在此前的 Jambot 插件进化升级而来，可为常见设计和规划项目创建开箱即用的模板，帮助设计人员或团队协作激发灵感，快速进行头脑风暴和可视化想法。</p>\n<img  class=\"alignnone size-full rounded shadow-sm\" src=\"/uploadfile/202312/276f89778a1b507.png\"  alt=\"FigJam AI白板\" width=\"800\" height=\"500\">\n<h2>FigJam AI 的产品功能</h2>\n<ul>\n<li>即时生成模板。只需输入简单的提示，即可生成用于每周团队同步、头脑风暴和回顾的模板，或者使用可视化时间表和组织结构图进行规划</li>\n<li>内置预先构建的提示。FigJam AI 预置了头脑风暴、流程图、组织图、甘特图、每周团队同步等开箱即用的提示用例，启发团队协作</li>\n<li>分类和整理白板便签。快速对白板上贴的便签进行分组，节省手动整理的时间，而将更多的时间花在发掘想法上</li>\n<li>要点和摘要总结。鼠标单击即可总结在线便签内容，清晰地呈现关键要点和后续步骤，并支持获取快速链接与其他人分享摘要</li>\n<li>引入ChatGPT。借助 OpenAI ChatGPT 的强大功能，FigJam AI 可以集思广益、提出方案甚至可以直接对设计生成代码</li>\n</ul>\n<h2>如何使用 FigJam AI</h2>\n<ol>\n<li>访问 FigJam AI 的官网，点击 Try it out</li>\n<li>登录或注册你的 Figma 账号，登录成功后便会自动跳转到工作台界面</li>\n<li>输入提示词，然后点击 Generate 按钮，即可自动生成模板或图示</li>\n</ol>\n<h2>关于 FigJam AI 的常见问题</h2>\n<div id=\"accordion\" style=\"max-width: 700px;\">\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>FigJam AI 是免费的吗？</strong></div>\n<div class=\"card-body text-sm\">FigJam AI 现阶段处于Beta公开测试中，所有用户都可以免费使用。后续是否会收费，还待官方说明。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>FigJam AI 基于什么大模型？</strong></div>\n<div class=\"card-body text-sm\">Figma 的创始人 Dylan Field 在接受采访时称，当前的 FigJam AI 测试版使用 OpenAI 基础模型，并可以轻松地将其替换为其他基础 AI 模型。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>FigJam AI 与 Jambot 有什么区别？</strong></div>\n<div class=\"card-body text-sm\">Jambot 是该公司于 8 月份推出的基于 ChatGPT 的 FigJam 插件的测试版，而 FigJam AI 于 11 月 7 日推出，作为 FigJam 本身功能的一部分，更加全面和强大。</div>\n</div>\n</div>'),
                                                                        (307,	0,	0,	'<p>MindShow是国内独立开发者开发的输入内容自动生成演示工具，帮你省去排版的烦恼，让想法快速展示。</p>'),
                                                                        (308,	0,	0,	'<p>auxi是一款功能强大的微软PowerPoint的AI插件，该工具允许你输入文字来修改和编辑PPT。比如你可以输入指令，来增加间距、保存PPT、对齐、添加文本框等等。只需按下Ctrl+空格键，你便可以在输入框输入相应的指令来操作和编辑PPT。</p>\n<p>该工具基于其专有的机器学习模型可在幻灯片右侧展示PPT设计建议，单击建议后，auxi便会帮助你自动将你的内容填充到所选的设计布局中。除此之外，该工具甚至还允许你将手绘的PPT草图转换为PowerPoint幻灯片！</p>'),
                                                                        (309,	0,	0,	'<div>\n<div>\n<p>ChatPPT是必优科技旗下面向PPT使用者提供的AI生成PPT软件，产品基于ChatGPT与韦尼克模型，面向PPT用户提供可通过自然语言指令与Chat模式进行PPT文档创作的AI创作服务。</p>\n<p>产品已于3月15日进行全网公测，可申请加入公测，目前版本分为在线体验版和Office插件版：</p>\n<ul>\n<li><span class=\"color_font\"><strong>在线体验版</strong></span>，即在线体验AI生成PPT服务。</li>\n<li><span class=\"color_font\"><strong>Office插件版，</strong></span>即基于微软Office与WPS提供完整的AI生成PPT的功能，包括AI生成PPT、AI指令美化与设置PPT，包括AI绘图配图、AI图标、文字云图等各类常见PPT文档操作。</li>\n</ul>\n</div>\n</div>'),
                                                                        (310,	0,	0,	'彩漩PPT推出的AI PPT生成工具'),
                                                                        (311,	0,	0,	'<p>SlidesAI是一款用于创建专业且引人入胜的演示文稿的省时工具，可以自动化幻灯片的创建过程。只需鼠标点击几下，该AI PPT工具便可以将任何文本转换为视觉上吸引人的幻灯片，让你能够专注于真正重要的事情。</p>\n<p>该AI PPT制作工具适合任何领域，无论你是在做营销展示，还是在会议上演讲，SlidesAI都可以为你提供帮助。你可以从各种演示类型中进行选择，包括通用场景、教育、销售和会议，选择幻灯片数量，其人工智能工具便可以帮助你完成所有的PPT设计和制作工作。</p>'),
                                                                        (312,	0,	0,	'演示文档版的ChatGPT'),
                                                                        (313,	0,	0,	'AI高颜值演示文稿创建'),
                                                                        (314,	0,	0,	'AI创建展示幻灯片'),
                                                                        (315,	0,	0,	'<p>使用Powerpresent AI，快速创建具有视觉吸引力的演示文稿。不需要设计或人工智能专业知识，用户只需输入主题或文本，其余的交由人工智能技术来完成。支持导出到Google Slides或下载为PPTX文件，以方便编辑和演示。</p>'),
                                                                        (316,	0,	0,	'<p>ChatBA是一个AIGC工具，帮助你从文本智能生成PowerPoint幻灯片。</p>\n<p>ChatBA是一个强大的人工智能驱动的AI生成PPT工具，用于自动生成幻灯片。该工具使用OpenAI的API，根据用户提供的提示或主题快速生成幻灯片。你可以用该工具为不同的行业，如商业演讲到书籍和房地产市场等各种主题生成幻灯片。你还可以用ChatBA来为用户可能不了解的主题或时间紧迫的演示创建幻灯片，最终的呈现结果是专业级的简约大气设计的幻灯片。</p>'),
                                                                        (317,	0,	0,	'<h2>讯飞智文是什么？</h2>\n<p>讯飞智文是科大讯飞推出的基于星火认知大模型的人工智能PPT生成工具，只需输入一句话或者添加要演示的文稿即可一键生成PPT。无论是职场的年终工作总结PPT、新品上市PPT、试用期答辩PPT、职级评审PPT，还是学校的作业或论文答辩PPT、各科目的教学课件PPT，讯飞智文都可以快速高效生成内容精炼且设计精美的PPT。</p>\n<img  class=\"alignnone size-full rounded shadow-sm\" src=\"/uploadfile/202312/1d53d4c9c227877.jpeg\"  alt=\"讯飞智文\" width=\"800\" height=\"450\">\n<h2>讯飞智文的主要功能</h2>\n<ol class=\"text-md\">\n<li>主题创建模式：一句话式主题输入，快速把你的想法变为 PPT 文档，可根据需求进行 AI 改写，完善文档内容</li>\n<li>文本创建模式：添加一段话或者一篇文章，AI 帮你总结、拆分、提炼，最终生成高度相关的PPT文档</li>\n<li>PPT文案优化：内置SPARK AI助手，可以进行文案的润色、扩写、翻译、缩写、拆分、总结、提炼、纠错、改写等</li>\n<li>演讲备注功能：可以秒速生成备注内容，帮你将演讲内容梳理清晰，避免PPT演讲中途卡顿</li>\n<li>内置多种模板：创新的模板及图示功能设计，可一键为PPT切换主题和模板，让你的创作更出色更高效</li>\n</ol>\n<img  class=\"alignnone size-full rounded shadow-sm\" src=\"/uploadfile/202312/506c492a830cf61.jpeg\"  alt=\"讯飞智文创建的PPT\" width=\"800\" height=\"429\">\n<h2>如何使用讯飞智文</h2>\n<ol>\n<li>访问讯飞智文的官网（zhiwen.xfyun.cn），点击即刻AI生成按钮或者右上角的登录/注册按钮</li>\n<li>登录或注册你的讯飞账号，登录成功后回答几个问题即可开始使用</li>\n<li>在操作后台界面，点击AI创建按钮，选择主题创建或者文本创建模式</li>\n<li>输入主题或文本生成大纲，选择想要的模板和配色</li>\n<li>然后讯飞智文便会智能分析大纲生成PPT内容</li>\n</ol>\n<h2>讯飞智文的产品价格</h2>\n<p>讯飞智文目前是免费开放使用的，暂未推出付费订阅版，新用户注册后即可获得1000积分用于AI生成文档，每次使用AI生成一次文档，消耗 50 积分，邀请好友注册讯飞智文，双方都可额外获得300积分。</p>\n<h2>常见问题</h2>\n<div id=\"accordion\" style=\"max-width: 700px;\">\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>讯飞智文基于什么大模型？</strong></div>\n<div class=\"card-body text-sm\">讯飞智文的AI能力基于科大讯飞自研的大语言模型「讯飞星火认知大模型」。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>讯飞智文生成的PPT可以导出吗？</strong></div>\n<div class=\"card-body text-sm\">讯飞智文支持将生成的PPT以.pptx的格式导出，你可以在微软Office PowerPoint等软件中打开并编辑。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>讯飞智文支持多少字的长文本输入？</strong></div>\n<div class=\"card-body text-sm\">目前讯飞智文一次性最高支持8000字的长文本输入。</div>\n</div>\n</div>'),
                                                                        (318,	0,	0,	'<p>Tome AI是一个利用人工智能来生成引人注目的演示幻灯片的网站，通过借助OpenAI的GPT和DALL-E 2的AIGC技术，该AI PPT生成网站将文本和图像无缝结合，创造出动态的视觉故事。</p>\n<p>通过Tome AI简单直观的操作和创建过程，用户可以轻松地用任何类型的内容制作引人入胜的演示文稿。在Tome网站上注册一个账户就可以使用这一创新工具，该平台是高度可定制化的，用户能够用表格、动画、图像等功能丰富他们的演示。</p>'),
                                                                        (319,	0,	0,	'<p>Decktopus是一个AI驱动的的在线演示文稿生成器，该AI生成PPT工具易于使用、操作直观，提供自动幻灯片布局和交互式表格等功能，只需要几分钟，用户便可以创建出效果令人惊叹的演示文稿。</p>'),
                                                                        (320,	0,	0,	'<p>Gamma是一个在线网页版创建演示文稿的工具，用户可以最少的格式化和设计工作来创建和展示内容。在人工智能的支持下，Gamma允许用户仅通过输入文本和想法提示，点击按钮便可以生成设计美观和具有吸引力的幻灯片。</p>\n<p>在Gamma的帮助下，创建演示文稿制作幻灯片变得更快、更简单，而且比使用传统软件更有效率。Gamma旨在通过视觉和互动内容将想法变为现实，从而吸引任何设备上的受众，支持嵌入各种多媒体格式，包括GIF、视频、网站和图表，使观众更容易理解复杂的想法。除此之外，用户还可以借助该AI生成PPT工具的快速反馈、评论、发布和分析工具等功能实现协作和反馈。</p>\n<h2>如何使用Gamma AI创建幻灯片？</h2>\n<p>要使用Gamma AI创建演示文稿，只需以下几个简单的步骤：</p>\n<ol>\n<li>访问Gamma App的网站，然后注册一个账号。</li>\n<li>创建一个新项目或演示文稿。</li>\n<li>在提供的编辑器中输入你想要的内容，AI会自动为你格式化和设计演示文稿。</li>\n<li>从符合你审美的品牌且无需编程的可自定义模板中进行选择。</li>\n<li>通过将图像、视频和交互式元素拖到卡片上，将这些要素添加到你的演示文稿中。</li>\n<li>使用Gamma提供的编辑选项优化和自定义你的演示文稿。</li>\n<li>使用内置分析来衡量观众参与度并改进你的演示以获得更好的结果。</li>\n</ol>'),
                                                                        (321,	0,	0,	'<p>美图AI PPT是国内知名P图软件「美图秀秀」旗下的「美图设计室」推出的免费在线AI生成PPT设计工具，用户只需输入一句话，便可以轻松打造精美PPT。无论是什么类型风格的PPT，美图AI都可以帮你打造，如行业分析、工作汇报、创意设计方案、企业团建策划、部门工作总结等。</p>'),
                                                                        (322,	0,	0,	'<p>AiPPT是一款AI驱动的PPT在线生成工具，无需复杂操作，只需要输入主题，AI 即可一键生成高质量PPT。支持在线自定义编辑和文档导入生成，配置超10w+定制级PPT模板及素材，助力快速产出专业级PPT。</p>\n<h2>AiPPT的主要功能</h2>\n<ol>\n<li>AI一键智能生成。基于人工智能和自然语言处理技术，能智能分析用户输入的主题，并快速生成符合需求的PPT内容</li>\n<li>文档上传生成。支持多种文件格式上传（doc、docx、xmind、mm），一键上传，Ai智能排版配色、快速生成PPT</li>\n<li>在线自由编辑器。支持一键整体更换模板、更换配色，内置上千套定制级PPT模板及超10w+素材，只需拖拉拽即可快速修改</li>\n<li>云端存储，跨设备同步。PPT云端制作在线保存，无需下载，打开网站即随时随地开启创作和演示，跨设备不再是障碍</li>\n<li>兼容.pptx格式，支持源文件导出。支持JPG、PNG、PDF、PPT文件导出，PPT源文件格式导入导出均无格式错乱问题</li>\n</ol>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/f3394b0434c1a.jpeg\"  alt=\"AiPPT生成\" width=\"800\" height=\"450\">\n<h2>如何使用AiPPT</h2>\n<ol>\n<li>访问AiPPT的官网，点击开始智能生成按钮</li>\n<li>使用微信或手机登录/注册账号，登录成功后会自动跳转到后台</li>\n<li>在快速创建的地方选择智能生成PPT</li>\n<li>然后选择AI智能生成，输入你想要的PPT主题</li>\n<li>生成好大纲后，选择喜欢的模板，便会自动生成相应的PPT</li>\n</ol>\n<h2>AiPPT的产品价格</h2>\n<p>新用户每天有3次免费生成次数，累计9次。也可以通过邀请好友注册获取会员，每邀请一个会员即可获得1天会员。</p>\n<p>付费开通VIP可以不限次数智能生成PPT并下载，价格如下：</p>\n<ul>\n<li>单月49元</li>\n<li>1年99元</li>\n<li>2年169元</li>\n<li>终身399元</li>\n</ul>'),
                                                                        (323,	0,	0,	'AI视频本地化解决方案'),
                                                                        (324,	0,	0,	'Animaker旗下AI在线视频制作工具'),
                                                                        (325,	0,	0,	'AI视频制作工具'),
                                                                        (326,	0,	0,	'AI文本到视频生成工具'),
                                                                        (327,	0,	0,	'AI自动移除视频背景'),
                                                                        (328,	0,	0,	'AI虚拟人出镜视频生成'),
                                                                        (329,	0,	0,	'AI虚拟人出镜讲解'),
                                                                        (330,	0,	0,	'<p>Gencraft是一个强大的人工智能艺术生成器，可以将文字转换为独特的图像和视频。只需输入文本提示，从其提供的不同风格中选择，便可以创建和生成视频和高分辨率图像，或共享你的创意设计。</p>'),
                                                                        (331,	0,	0,	'<p>绘影字幕是北京蓝色脉动科技有限责任公司旗下产品，提供视频自动加字幕服务，运用先进的语音识别和自然语音理解技术，自动识别视频中的人声，转换成字幕。用户可以在网站上导入视频，在线编辑，并在线导出带字幕的视频；也可以下载绘影字幕APP，在手机上直接编辑。帮助用户提高字幕编辑效率，节省编辑时间。</p>'),
                                                                        (332,	0,	0,	'<p>万彩微影是一款全能的AI智能短视频制作软件合集，通过它的智能AI技术，企业和自媒体及个人可以高效快速智能的制作令人夺目的短视频作品，它制作的作品可以广泛用于宣传，微课，动画短片等多个领域，并适合在抖音快手等平台传播吸粉。该AI视频工具，可以帮助你轻松打造自媒体手绘/文字/图文/照片短视频，让你零基础快速制作动画短视频。</p>\n<h2>万彩微影可以做什么？</h2>\n<ul>\n<li>支持多种视频类型的创作，抖音和快手短视频、企业营销视频、知识百科视频、产品宣传视频、文字快闪视频等，是企业和自媒体营销神器</li>\n<li>操作简单易用，万彩微影的极简智能操作，可以帮助用户快速出片，提高视频制作效率</li>\n<li>常用短视频制作一键转换软件合集，提供图文视频工具、文字视频工具、手绘视频工具和相册视频工具等4个工具\n<ul>\n<li>图文视频工具可帮助用户使用AI智能一键文章转短视频或导入PPT转换</li>\n<li>文字视频工具提供文字模式、字幕模式、MV模式、视频加字幕模式，帮助用户快速制作文字动画视频，支持纯文本输入和导入音/视频和录音识别。</li>\n<li>手绘视频工具，利用生动创意的手势动画配合白板制作创意的动画短视频</li>\n<li>相册视频工具是一个免费的照片视频制作功能，只需几步，照片变身精彩的视频，轻松制作各大主题精美相册（如婚礼视频、毕业视频、企业宣传、旅行相册等）</li>\n</ul>\n</li>\n</ul>\n<h2>万彩微影有哪些功能特色？</h2>\n<ol>\n<li>60+ 2D/3D 动画人物角色，生动解说</li>\n<li>一键文字转语音，输入文字便可以转换/合成语音</li>\n<li>支持主流视频格式输出，MP4、MOV、AVI、WMV、FLV、MKV等</li>\n<li>轻松分享到各大社交/视频媒体平台，如哔哩哔哩、腾讯视频、微博、优酷、爱奇艺等</li>\n</ol>\n<h2>万彩微影的产品价格</h2>\n<p>万彩微影提供4个不同的权益，包含免费版、标准版、高级版和专业版</p>\n<ul>\n<li>免费版 - 无需付费，支持输出标清576P的视频，有水印</li>\n<li>标准版 - 399元永久使用，提供较多的动画和音效资源和其他功能模块，输出视频无水印</li>\n<li>高级版 - 499元永久使用，在标准版的基础上提供更多的资源，并赠送万彩特效大师3个月</li>\n<li>专业版 - 599元永久使用，在高级版的基础上提供最丰富的资源和功能</li>\n</ul>\n<h2>常见问题</h2>\n<p><strong>Q：万彩微影支持什么电脑系统？</strong></p>\n<p>A：万彩微影目前需要在Windows电脑上使用，支持 Windows 11/10/8/7/Vista 等系统。</p>\n<p><strong>Q：万彩微影中的素材可以商用吗？</strong></p>\n<p>A：软件中标注“商”字的素材（如模板、图片、场景、角色等）都是可以商用的，版权没问题；没有标注“商”字的素材不能用于商用用途，只供学习使用。</p>\n<p><strong>Q：万彩微影账号能否同时登录使用？</strong></p>\n<p>A：不支持同时登录。</p>'),
                                                                        (333,	0,	0,	'<p>HeyGen是一个AI视频创建平台，帮助你用生成性人工智能创建引人入胜的商业视频，就像为各种使用案例制作PowerPoint幻灯片一样容易，该工具免费版提供1分钟的时长。</p>'),
                                                                        (334,	0,	0,	'<p>奇妙元是出门问问推出的AI数字人短视频和直播解决方案，借助该数字形象创作及直播平台，用户可以创建自己的数字形象，并通过这些数字形象进行直播活动。奇妙元平台目前拥有超过100款数字人和超过1000款3D数字资产，可以为用户提供丰富的选择。</p>\n<h2>奇妙元的主要功能</h2>\n<ol>\n<li>真人形象克隆：输入文字，即可让数字人开口说话，表情神态口吻堪比真人</li>\n<li>媲美真人的声音克隆：输入一段文字，即可合成和实现逼真的声音克隆，提供多种风格选择</li>\n<li>3D数字人定制：支持多种类型的高精度3D数字人定制，可应用于多种直播和场景</li>\n<li>企业IP形象活化：帮助企业打造能说会动的IP形象，升级品牌资产，提高传播度</li>\n</ol>\n<h2>奇妙元的产品价格</h2>\n<ol>\n<li>免费版，可免费使用。支持进行30秒的视频合成，提供部分免费的数字人、声音、模板等</li>\n<li>月付版，298元每月。支持合成达30分钟的视频，所有的数字人、声音、模板、素材都无限制使用</li>\n<li>年付版，2499元每年。支持合成达360分钟的视频，所有的数字人、声音、模板、素材都无限制使用</li>\n</ol>\n<h2>关于奇妙元的常见问题</h2>\n<div id=\"accordion\" style=\"max-width: 700px;\">\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>奇妙元基于什么大模型？</strong></div>\n<div class=\"card-body text-sm\">奇妙元基于人工智能公司出门问问自研的大模型「序列猴子」，支持文字生成、图片生成、3D内容生成、语音生成和语音识别等不同任务。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>奇妙元支持哪些声音和语言克隆？</strong></div>\n<div class=\"card-body text-sm\">奇妙元支持600多种音色、16个不同国家的语言、15种地区方言以及十几种不同情绪的表达。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>奇妙元提供哪些数字人资产？</strong></div>\n<div class=\"card-body text-sm\">奇妙元提供近百个不同种族、年龄和职业风格的AI数字人，还支持3D数字人在线捏脸。</div>\n</div>\n</div>'),
                                                                        (335,	0,	0,	'万兴科技推出的AI数字人口播视频营销工具'),
                                                                        (336,	0,	0,	'<p>依托AI技术，来画平台支持1分钟生成专属数字人，极大地降低制作门槛和制作成本，无需昂贵、专业的穿戴设备，每个人都能轻松拥有自己的数字人。</p>\n<p>来画平台上线5种不同数字人风格，美式写实Q、中式写实Q、潮玩手办风、写实美型风，以及2D超写实数字人，可自由调整身高、体重、发型、脸型、五官等参数，实现精细化定制。</p>\n<p>海量丰富的素材库，也可支持多样换装，发型、配饰、衣服、道具等等随意搭配；支持不同的人物动作，不同的场景，充分展现自己的风格和个性。</p>\n<p>来画数字人可以生成各种好玩的动态表情包；可以快速生成专属数字人名片，让你的社交形象立马加分；可以给自己的数字人，领取唯一且永久的“元宇宙身份证”；还可在元宇宙舞台或者秀场，“以舞会友”。</p>'),
                                                                        (337,	0,	0,	'AI文字到视频生成'),
                                                                        (338,	0,	0,	'AI将博客文章转换成视频'),
                                                                        (339,	0,	0,	'AI视频生成平台'),
                                                                        (340,	0,	0,	'AI口播视频生成工具'),
                                                                        (341,	0,	0,	'AI文字转视频并配音'),
                                                                        (342,	0,	0,	'让图片动起来的AI工具'),
                                                                        (343,	0,	0,	'图片文字转视频的AI引擎'),
                                                                        (344,	0,	0,	'<p>EbSynth是一款强大的AI视频工具，可以帮助用户将现实场景的视频转化为丰富多彩的油画风格动画视频，目前该工具在免费Beta测试中，支持Windows和Mac平台。</p>'),
                                                                        (345,	0,	0,	'AI智能视频背景移除工具'),
                                                                        (346,	0,	0,	'<p>Capsule 是一个面向企业团队的人工智能视频编辑器（个人和小团队可免费使用），旨在通过将简单直观的操作界面与自动执行编辑任务的AI相结合，帮助内容和营销团队以高效的速度和轻松地创建视频。通过人工智能，Capsule 创新性地引入了新的视频剪辑制作界面——消除了时间线、图层或关键帧动画！</p>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/3b99cb9ffd316fb.png\"  alt=\"Capsule AI Video Editor\" width=\"800\" height=\"412\">\n<h2>Capsule的产品功能</h2>\n<ol>\n<li>AI CoProducer 智能制片人，可帮助用户快速处理切片剪辑、过渡、节拍同步、对象跟踪、生成文案和B-roll等，让用户专注于更高层次的创意选择上</li>\n<li>智能修改视频比例，CapsuleScript 响应式设计解决方案，可智能在16:9，9:16，4:5，1:1，2:3等视频比例中切换，自动裁切和匹配对应比例的画面</li>\n<li>品牌视频设计系统。创作者可创建可重复使用的品牌动效图形模板和资产使团队能够快速创建符合品牌准则的视频，并可轻松管理动画Logo、颜色、字体等库</li>\n<li>云端协作。用户可邀请成员加入工作台，多个团队成员可以同时在同一个项目中工作和编辑，满足跨不同平台高效协作的需要</li>\n</ol>\n<h2>Capsule的产品价格</h2>\n<p>Capsule目前提供Business版本和Enterprise版本，</p>\n<ol>\n<li>Business版本免费，针对小团队和个人，支持无限个协作者、创建最多3个项目、使用AI CoProducer等</li>\n<li>Enterprise版本针对大型团队和企业，支持无限个协作者、无限项目、定制动效设计系统，需联系询价</li>\n</ol>'),
                                                                        (347,	0,	0,	'<p>Artflow是一个AI动画创建工具，可以帮助你毫不费力地将创意转化为动画故事，让创意源源不断。Artflow允许你使用人工智能生成的素材，用原创角色创建自己独特的动画故事。</p>'),
                                                                        (348,	0,	0,	'<h2>Pika是什么</h2>\n<p>Pika是近期热门的人工智能初创公司Pika Labs推出的AI视频生成和编辑工具，该工具可以将任何创意转化为视频，用户只需输入文字或图像，即可快速生成3D动画、动漫、卡通、电影等风格的视频。该AI视频生成工具最早于2023年4月下旬推出测试版，累计已经超过50万名早期用户使用，每周都在生成数百万个视频。不过，目前Pika还在进一步完善中，实际使用来看离大规模投入到真正的生产环境中还有一定的距离。</p>\n<img  class=\"alignnone size-full rounded-lg\" src=\"/uploadfile/202312/9a0cb43386eaf.png\"  alt=\"Pika\" width=\"800\" height=\"452\">\n<h2>Pika的主要功能</h2>\n<ol class=\"text-md\">\n<li>文本/图像转视频：只需输入几行文本或上传图像，即可利用AI创建简短的高质量视频</li>\n<li>视频转视频：将现有视频转换为不同的风格，包括不同的角色和对象，同时保持视频的结构</li>\n<li>视频画面比例扩展：扩展视频的画布或宽高比，比如从9:16竖屏智能转换为16:9横屏，AI模型将预测超出原始视频边界的内容</li>\n<li>视频内容改变：AI编辑视频画面中的内容或物体，例如改变某人的衣服、添加另一个角色、改变环境或添加道具</li>\n</ol>\n<h2>Pika的适用人群</h2>\n<ol class=\"text-md\">\n<li>个人消费者：即使完全不懂任何视频制作的人，也可以轻松使用AI创作和编辑视频</li>\n<li>短视频创作者：快速生成病毒性传播的短视频，在TikTok上带有#pikalabs标签的短视频累计超过3000万次观看</li>\n<li>电影专业人员：AI将剧本生成分镜初稿，激发摄影灵感并辅助后期电影视频编辑</li>\n</ol>\n<h2>如何使用Pika</h2>\n<ol class=\"text-md\">\n<li>访问Pika的官网（pika.art），点击使用谷歌或Discord账号登录官网，加入等待列表</li>\n<li>你也可以直接点击Discord邀请链接（https://discord.com/invite/pika）加入其Discord社区抢先体验</li>\n<li>加入Pika的Discord社区后，选择任意一个生成频道如#generate-1，然后在输入框中输入/create+提示指令</li>\n<li>最后等待Pika将视频生成即可</li>\n</ol>\n<h2>常见问题</h2>\n<div id=\"accordion\" style=\"max-width: 700px;\">\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>Pika是免费的吗？</strong></div>\n<div class=\"card-body text-sm\">Pika目前处于免费公测中，用户可以加入Discord频道中体验，后续可能推出付费版本。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>Pika可以生成多长时间的视频？</strong></div>\n<div class=\"card-body text-sm\">Pika目前默认生成的视频长度只有3秒钟，后续更新可能支持生成更长时间。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>Pika生成的视频可以商用吗？</strong></div>\n<div class=\"card-body text-sm\">目前可以将Pika生成的视频免费商用，不过后期若Pika结束测试或推出付费版，该政策可能有变化。</div>\n</div>\n</div>'),
                                                                        (349,	0,	0,	'<p>Wonder Studio是由初创公司Wonder Dynamics推出的一款AI工具，无需复杂的 3D 软件，无需昂贵的制作硬件，便可以自动为 CG 角色制作动画、打光并将其合成到真人场景中。</p>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/fb7bebefb957e5a.jpeg\"  alt=\"Wonder Studio展示\" width=\"600\" height=\"306\">'),
                                                                        (350,	0,	0,	'<p>快剪辑是360旗下推出的支持在线视频剪辑的软件，拥有强大的云端剪辑能力，其智能工具箱提供了多种AI工具，帮助创作者更加高效快捷地剪辑视频，满足不同行业用户的使用需求。适用于电商营销、内容营销、短视频创作等场景，为有视频剪辑需求的中小机构或个人提供从端到端的一站式视频创作服务。</p>\n<h2>快剪辑的AI功能</h2>\n<ol>\n<li>文本剪视频，输入文本描述，结合视频模板一键成片，让你快速上手剪辑操作</li>\n<li>AI数字人，快剪辑提供超过20个不同风格和外观的虚拟数字人，只需输入文案，从提供的20+ AI配音中选择一个你喜欢的，便可以智能生成口播视频</li>\n<li>智能去字幕，上传视频素材，快剪辑便能帮助用户自动地去除视频中的字幕，保留素材中的主体画面，方便你的二次创作</li>\n<li>智能去水印，添加视频素材，框选水印区域，快剪辑便能快速抹除烦人的视频水印</li>\n<li>智能抠像，无需绿幕，选择设置抠像背景，快剪辑便能抠除视频人像背景</li>\n<li>视频转换，快剪辑还支持将视频智能转换和提取为文本或音频</li>\n</ol>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/19ba03727ac17d6.png\"  alt=\"快剪辑AI工具\" width=\"1000\" height=\"361\">\n<h2>快剪辑的产品价格</h2>\n<p>快剪辑提供不同权益的免费版和会员版本，以满足不同创作者的剪辑需求。</p>\n<ol>\n<li>免费版，可进行智能字幕、AI文案创作、AI朗读、AI数字人及其他AI功能的免费试用</li>\n<li>标准版，29.9元/月，提供更多AI功能、更长智能剪辑时长、更高清画质，适合个人创作者轻量编辑，</li>\n<li>专业版，199元/月，在标准版的权益上，提供更全面的功能，适合个人及中小团队使用和企业商用授权。</li>\n</ol>'),
                                                                        (351,	0,	0,	'<p>腾讯智影是由腾讯推出的一款AI智能创作工具，融合了AI数字人、AI文字配音TTS、文章转视频等多项AIGC能力。</p>'),
                                                                        (352,	0,	0,	'<p>D-ID是一个人工智能生成的视频创建平台，可以轻松快速地从文本输入中创建高质量、高性价比和引人入胜的视频。背后的AI技术是由Stable Diffusion和GPT-3提供支持，可以在没有任何技术知识的情况下输出100多种语言的视频。</p>\n<p>D-ID的实时人像功能可以从一张照片中创建视频，虚拟口播主持可以提供文本或音频。它的API在数万个视频上进行训练，以产生逼真的结果。</p>'),
                                                                        (353,	0,	0,	'<p>Runway最开始是一个供创作人员以直观的方式使用机器学习工具的平台，而不需要任何编码经验，用于视频、音频和文本等媒体。Runway的AI Magic Tools目前提供了超过了30+的AI工具，在Runway上，用户可以创建并发布预先训练好的机器学习模型，用于生成逼真的图像或视频等应用。用户还可以训练自己的模型，并直接从GitHub导入新的模型。</p>\n<p>而在3月23日，Runway发布了Gen-2模型，允许用户从文本、图像和视频片段中生成视频内容。</p>'),
                                                                        (354,	0,	0,	'<p>即创是抖音推出的一站式电商智能创作平台，提供AI视频创作、图文创作和直播创作三大功能，借助AI的能力节省短视频和直播的成本和时间，全方位满足短视频和抖音电商从业者的创作需求。</p>\n<img  class=\"alignnone size-full rounded shadow-sm\" src=\"/uploadfile/202312/38a7873a7a5d541.png\"  alt=\"即创AI数字人\" width=\"800\" height=\"450\">\n<h2>即创的主要功能</h2>\n<ul>\n<li><strong>视频创作</strong>\n<ul>\n<li>智能成片：AI生成脚本、视频、数字人、配音，快速生成可用的视频短片</li>\n<li>AI视频脚本：选择行业类别，并输入商品ID、产品名称和卖点，即可输出短视频脚本</li>\n</ul>\n</li>\n<li><strong>图文创作</strong>\n<ul>\n<li>商品卡工具：输入商品ID，智能替换商品背景和智能设计营销边框</li>\n<li>图文工具：输入商品ID或上传图片，选择音乐风格及关键卖点，智能生成图文带货</li>\n</ul>\n</li>\n<li><strong>直播创作</strong>\n<ul>\n<li>AI直播背景：输入商品ID和直播主题，一键生成直播间背景样式</li>\n<li>AI直播脚本：输入商品ID、活动优惠、直播间玩法、营销节点，智能生成直播脚本</li>\n</ul>\n</li>\n</ul>\n<h2>如何使用即创</h2>\n<ol>\n<li>访问即创的官网（aic.oceanengine.com），登录或注册巨量引擎的账号</li>\n<li>绑定公司或组织，可以选择创建或加入组织，实测输入一个组织名称即可</li>\n<li>然后回到即创的工作台（aic.oceanengine.com/workbench），选择你要使用的创作功能即可</li>\n</ol>\n<h2>常见问题</h2>\n<div id=\"accordion\" style=\"max-width: 700px;\">\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>即创是免费的吗？</strong></div>\n<div class=\"card-body text-sm\">目前即创处于免费公测的阶段，用户可以免费注册并使用其AI功能。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>即创可以通过APP使用吗？</strong></div>\n<div class=\"card-body text-sm\">目前即创还没有移动端APP，用户可以通过网页端使用该平台。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>即创基于什么大模型？</strong></div>\n<div class=\"card-body text-sm\">即创的AI功能基于字节跳动自研的抖音云雀大模型。</div>\n</div>\n</div>'),
                                                                        (355,	0,	0,	'<div data-page-id=\"GDdrdv5suoKGKvx011jcLZJ4nYg\" data-docx-has-block-data=\"true\">\n<p class=\"heading-3 ace-line old-record-id-doxcnF0sDYSQWcl6cjKrrZKR4pf\">Graviti Diffus提供热门的开源项目 Stable Diffusion WebUI 的在线服务，让你零基础快速生成图片图像。</p>\n<div class=\"zoneType-calloutBlock old-record-id-doxcnKpL1BiqlzNVM1CzWlDFiSf\">\n<div class=\"callout-container\" data-emoji-id=\"tada\">\n<div class=\"callout-block\">\n<ul class=\"list-bullet1\">\n<li class=\"ace-line ace-line old-record-id-doxcn2O23YGhp9lj0MKT2KMl4uh\" data-list=\"bullet\">\n<div>无需 GPU 与代码技能，开箱即用的 Stable Diffusion WebUI，注册即送 20 Credits</div>\n</li>\n<li class=\"ace-line ace-line old-record-id-doxcnJsLjzPUKIEGPXtiL1sYjWb\" data-list=\"bullet\">\n<div>内置几十个热门模型，Chilloutmix、Deliberate 等（社区持续贡献中）</div>\n</li>\n<li class=\"ace-line ace-line old-record-id-doxcnSJrNRLaO5RrGxokURpUfHc\" data-list=\"bullet\">\n<div>内置 ControlNet 与 OpenPose Editor 插件（更多插件陆续开放）</div>\n</li>\n</ul>\n<div data-page-id=\"GDdrdv5suoKGKvx011jcLZJ4nYg\" data-docx-has-block-data=\"true\">\n<h3 class=\"heading-3 ace-line old-record-id-doxcnNAvKxcRmqklOU6v0Xe0nFc\">AI图像生成工具对比</h3>\n<div>\n<table class=\"ace-table\" data-ace-table-col-widths=\"85;226;251;259\">\n<colgroup>\n<col width=\"85\">\n<col width=\"226\">\n<col width=\"251\">\n<col width=\"259\"></colgroup>\n<thead>\n<tr>\n<th colspan=\"1\" rowspan=\"1\">\n<div class=\"ace-line ace-line old-record-id-doxcn7QwcOwIRZSDWAaNINSW9Bh\"></div>\n</th>\n<th colspan=\"1\" rowspan=\"1\">\n<div class=\"ace-line ace-line old-record-id-doxcnV8tGAHXJXagTviVvtgBn1g\"><strong>Midjourney</strong></div>\n</th>\n<th colspan=\"1\" rowspan=\"1\">\n<div class=\"ace-line ace-line old-record-id-doxcnG6hF6UeWiZFB5xlWE3p7uY\"><strong>Stable Diffusion WebUI 本地部署</strong></div>\n</th>\n<th colspan=\"1\" rowspan=\"1\">\n<div class=\"ace-line ace-line old-record-id-doxcnDb5fz6L0cKFS8V11BBGice\"><strong>Stable Diffusion WebUI 在线服务</strong></div>\n</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n<td colspan=\"1\" rowspan=\"1\">\n<div class=\"ace-line ace-line old-record-id-doxcnnYP5qIkmk9ksJjaKbmo9Ob\"><strong>上手难度</strong></div>\n</td>\n<td colspan=\"1\" rowspan=\"1\">\n<div class=\"ace-line ace-line old-record-id-doxcnlxj73UB6nhB7ycNjKXuZYT\">★★★</div>\n</td>\n<td colspan=\"1\" rowspan=\"1\">\n<div class=\"ace-line ace-line old-record-id-doxcnZmTvlaYKBnutPYqjtEcbYe\">★★★★★</div>\n</td>\n<td colspan=\"1\" rowspan=\"1\">\n<div class=\"ace-line ace-line old-record-id-doxcnQBKOtM9hC5JBMccFMhjbxe\">★</div>\n</td>\n</tr>\n<tr>\n<td colspan=\"1\" rowspan=\"1\">\n<div class=\"ace-line ace-line old-record-id-doxcnGVJkTfQFgyg76bG9kTucLc\"><strong>出图效果</strong></div>\n</td>\n<td colspan=\"1\" rowspan=\"1\">\n<div class=\"ace-line ace-line old-record-id-doxcnILcVo5OAqCqZHIvXWp4RDh\">★★★★★</div>\n</td>\n<td colspan=\"1\" rowspan=\"1\">\n<div class=\"ace-line ace-line old-record-id-doxcn025py0djSa0NCUhhJUtH9f\">★★★★★</div>\n</td>\n<td colspan=\"1\" rowspan=\"1\">\n<div class=\"ace-line ace-line old-record-id-doxcnwhWPcaqk8uoL2ba4T2WToh\">★★★★★</div>\n</td>\n</tr>\n<tr>\n<td colspan=\"1\" rowspan=\"1\">\n<div class=\"ace-line ace-line old-record-id-doxcn45xTpMAVKb7yyZFMkaQCwd\"><strong>功能类型</strong></div>\n</td>\n<td colspan=\"1\" rowspan=\"1\">\n<div class=\"ace-line ace-line old-record-id-doxcnRh3nIA1Ydi0aAhg81zyzmc\">★★★</div>\n</td>\n<td colspan=\"1\" rowspan=\"1\">\n<div class=\"ace-line ace-line old-record-id-doxcnbQEKY1CzSrJ1d58YywZfab\">★★★★★</div>\n</td>\n<td colspan=\"1\" rowspan=\"1\">\n<div class=\"ace-line ace-line old-record-id-doxcn72bmaDdaeCw3Am6hoa0xzP\">★★★★★</div>\n</td>\n</tr>\n<tr>\n<td colspan=\"1\" rowspan=\"1\">\n<div class=\"ace-line ace-line old-record-id-doxcnXUDo81fmFGMv6rezNj3vbc\"><strong>配置要求</strong></div>\n</td>\n<td colspan=\"1\" rowspan=\"1\">\n<div class=\"ace-line ace-line old-record-id-doxcn2ytVOqPVeAasCQ2NxsZPhb\">Discord（需要梯子）</div>\n</td>\n<td colspan=\"1\" rowspan=\"1\">\n<div class=\"ace-line ace-line old-record-id-doxcnHdleORtx2PHJY6HxzcWoo2\">需要高性能 GPU</div>\n</td>\n<td colspan=\"1\" rowspan=\"1\">\n<div class=\"ace-line ace-line old-record-id-doxcnLAjTi8CpsQfT996CtnXlFg\">无</div>\n</td>\n</tr>\n<tr>\n<td colspan=\"1\" rowspan=\"1\">\n<div class=\"ace-line ace-line old-record-id-doxcnNm7VzYJrXcYWXLbeOOUzYb\"><strong>价格对比</strong></div>\n</td>\n<td colspan=\"1\" rowspan=\"1\">\n<div class=\"ace-line ace-line old-record-id-doxcn31UppuUFFxQ8Px9sYGwmFe\">10USD / 200 次</div>\n</td>\n<td colspan=\"1\" rowspan=\"1\">\n<div class=\"ace-line ace-line old-record-id-doxcnsUzPAll9DXTzvH4nkxhuxd\">免费</div>\n</td>\n<td colspan=\"1\" rowspan=\"1\">\n<div class=\"ace-line ace-line old-record-id-doxcnprBZ5sPSsYGKUghtOpfZJf\">10USD / 2500Credit</div>\n</td>\n</tr>\n</tbody>\n</table>\n<p> </p>\n<h3>Graviti Diffus生成效果</h3>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/5c5add3700dc71e.png\"  alt=\"Graviti Diffus生成效果\" width=\"800\" height=\"760\">\n</div>\n</div>\n</div>\n</div>\n</div>\n</div>'),
                                                                        (356,	0,	0,	'<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/87e75cfc25ba64a.png\"  alt=\"亦心科技公司的logo\" width=\"400\" height=\"116\">\n<p>悟空图像是一款智能好用的专业图像处理软件，是国内团队北京亦心科技有限公司开发的一款可全面替代Adobe Photoshop的图像软件。该软件采用全新的设计理念和人工智能算法，让每个用户都能快速上手、快速出图。内置AI作画、AI抠图、AI风格化等AI功能，不仅满足创意设计、图片编辑的需求，还可以赋能日常办公、元宇宙、教育科研等领域。悟空图像圆你一个“设计师”的梦，即使零基础，也能创作出专业级的效果！</p>'),
                                                                        (357,	0,	0,	'AI在线处理图片'),
                                                                        (358,	0,	0,	'在线AI图像工具箱'),
                                                                        (359,	0,	0,	'高颜值AI图像处理工具'),
                                                                        (363,	0,	0,	'AI创建精美的游戏插画资产'),
                                                                        (364,	0,	0,	'Stability.ai推出的AI图片处理系列工具'),
                                                                        (369,	0,	0,	'<p>图查查是 360 旗下推出的一站式图片服务平台，在AI技术的驱动下，可以帮助用户轻松搞定作图，提供图片版权查询、高清版权图库、图片智能抠图、图片智能消除笔、图片无损放大、文章智能配图等功能。</p>\n<h2>图查查的AI功能</h2>\n<ul>\n<li>图片智能抠图。此功能目前是免费开放的，可智能识别主体，自动删除背景，一键快速抠图。该AI抠图工具最高分辨率支持达到10000*10000，提供自动抠图和点选抠图两种模式。</li>\n<li>图片智能消除笔。在线图片去水印、去文字、去除一切无用元素。只需鼠标一划，便能智能抹除图片中不想要的物体。</li>\n<li>图片无损放大。将上传的图片成倍放大，同时基于推断出的细节保持结果图像的清晰度，最高支持上传1280*1280分辨率的图片。</li>\n<li>文章智能配图。在线文字段落智能插图，图文并茂更吸睛。只需输入文章关键词和文章正文内容，图查查便能智能给文字配图。</li>\n</ul>'),
                                                                        (385,	0,	0,	'<p>ARC是腾讯旗下ARC（Applied Research Center，应用研究中心）实验室推出的系列AI图片处理工具，目前提供了三项免费的AI图像功能：人像修复、人像抠图和动漫增强。</p>\n<h2>ARC的主要功能</h2>\n<ol>\n<li>人像修复：上传有噪点的老照片或者模糊的人脸照片，ARC便能一键修复变高清</li>\n<li>人像抠图：上传带有人物主体前景的照片，ARC可智能去除背景抠出人像</li>\n<li>动漫增强：添加模糊或低分辨率的动漫二次元人物图片，ARC可令其变清晰</li>\n</ol>'),
                                                                        (387,	0,	0,	'<p>Ribbet.ai是一个免费的综合性多功能AI图片处理工具箱，借助人工智能的力量帮助用户编辑、重新想象和微调上传的图像，并以高质量下载。目前平台上提供图片背景去除、AI照片上色、图片高清放大、免费人脸检测等工具。</p>\n<h2>Ribbet.ai的主要功能</h2>\n<ol>\n<li><strong>图片背景去除</strong>：只需上传图像或搜索并选择平台上的免费照片，人工智能便会自动在线免费移除图像中的背景</li>\n<li><strong>黑白照片着色</strong>：在线着色工具将黑白照片转换为全彩图像，非常适合修复旧照片，让老照片变得丰富多彩</li>\n<li><strong>图片放大变清晰</strong>：智能高清放大图像以放大小的图片但不损失质量和细节</li>\n<li><strong>人脸检测</strong>：免费人脸检测人工智能工具将识别照片中所有主要面部特征的坐标</li>\n</ol>'),
                                                                        (390,	0,	1,	'国内团队推出的智能AI写作工具'),
                                                                        (391,	0,	1,	'阿里旗下智能文案工具，一键生成电商营销文案'),
                                                                        (393,	0,	0,	'<h2>星火科研助手是什么</h2>\n<p>星火科研助手是科大讯飞联合中科院文献情报中心推出的一款AI科研助理，基于认知智能大模型和海量的科技文献资源，提供文献成果调研、论文研读和学术写作等科学研究助手功能，显著提升科研人员在文献调研和阅读方面的效率，大幅节约时间和精力。测试显示，使用星火科研助手可以提高论文调研效率10倍以上，论文研读有效率和学术写作采纳率均超90%。</p>\n<img  class=\"alignnone size-full rounded-lg shadow-sm border-0\" src=\"/uploadfile/202312/20d6c1a19c0d8e5.png\"  alt=\"星火科研助手官网\" width=\"800\" height=\"458\">\n<h2>星火科研助手的主要功能</h2>\n<ol class=\"text-md\">\n<li><strong>成果调研</strong>：只需输入关键词，就能检索文献库获取海量中英文论文，并获得全文下载、参考文献导出、综述生成、论文调研、论文总结等服务。</li>\n<li><strong>学术写作</strong>：提供学术翻译和英文润色能力，可以帮助用户进行中英文档互译和对英文论文进行润色修改以更加符合英文学术写作的表达。</li>\n<li><strong>论文研读</strong>：智能解读论文、快速回答研究问题，提供论文知识问答、论文外问答、片段翻译和总结，帮助研究人员更高效地阅读和理解学术论文。</li>\n</ol>\n<h2>星火科研助手的官网地址</h2>\n<ol class=\"text-md\">\n<li>官网地址1：https://paper.iflytek.com/</li>\n<li>官网地址2：https://sciai.las.ac.cn</li>\n</ol>\n<img  class=\"alignnone size-full rounded-lg shadow-sm border-0\" src=\"/uploadfile/202312/10609cea41c8.jpeg\"  alt=\"星火科研助手的登录界面\" width=\"800\" height=\"450\">\n<h2>星火科研助手的使用方法</h2>\n<ol class=\"text-md\">\n<li>访问星火科研助手的官网，在右侧登录/注册你的账号</li>\n<li>中科院用户可直接登录无需注册，其他机构用户需注册</li>\n<li>登录成功后会自动跳转到网站首页，选择成果调研、论文研读、学术写作其中一个功能即可开始使用</li>\n</ol>'),
                                                                        (395,	0,	1,	'<p>新华妙笔是一款专业的AI公文写作平台，由新华通讯社与博特智能共同研发推出，集成了案例参考、材料查找、AI写作、修改润色、审核校对、文件学习等功能，全方位地辅助公职人员提高创作效率，节省人工编写的时间和精力。新华妙笔融合了自然语言处理、知识图谱、数据挖掘以及AI深度学习四大前沿技术，并与中文创作难度较高的公文写作垂直场景进行了深度集合，提供了一体化的AI公文写作与知识赋能协作平台。</p>\n<img  class=\"alignnone size-full rounded-lg shadow-sm\" src=\"/uploadfile/202312/2a52e58dba8d569.jpeg\"  alt=\"新华妙笔的官网\" width=\"793\" height=\"450\">\n<h2>新华妙笔的主要功能</h2>\n<ol>\n<li><strong>高效AI公文写作</strong>：选择好文稿类型、写作场景、标题和关键词后即可快速生成一篇公文供写作参考，并支持一键导出和打印文稿</li>\n<li><strong>丰富的AI写作辅助功能</strong>：除开全文生成外，新华妙笔还提供AI续写、AI校对、AI润色、AI灵感等辅助功能，可帮助创作表达更加专业、纰漏更少的文章</li>\n<li><strong>平台内置多种公文模版</strong>：提供多种法定公文和规范应用模板，如常见的命令、议案、纪要、公报、通告、意见、通知、条例、规定、办法、章程等等</li>\n<li><strong>海量常见公文素材范文</strong>：提供常见的词组、材料用句、调研报告、方案总结、发言讲话、意见建议、事迹材料、对外宣传等各种主题的素材范文</li>\n<li><strong>专业权威的学习园地</strong>：内置政策学习、规划学习、评述学习、著述学习等各种学习文件，一站式探索和学习最新指示文件</li>\n</ol>\n<img  class=\"alignnone size-full rounded-lg shadow-sm\" src=\"/uploadfile/202312/60dfaf7b212344b.png\"  alt=\"新华妙笔的功能\" width=\"800\" height=\"450\">\n<h2>如何使用新华妙笔</h2>\n<ol>\n<li>访问新华妙笔的官网（miaobi.xinhuaskl.com），点击右上角的免费注册</li>\n<li>填写申请信息并提交，稍等一分钟试用审核通过，返回网站主页点击登录按钮</li>\n<li>输入刚才申请成功的手机号进行登录，即可进入后台工作界面，下面以AI公文生成为例</li>\n<li>点击左侧的AI写作，选择AI生成 -&gt; 选择文稿类型 -&gt; 选择写作场景 -&gt; 输入标题 -&gt; 输入关键词，点击下一步：生成摘要</li>\n<li>可修改、编辑或重新生成摘要，设置好后，进入下一步：生成大纲</li>\n<li>可修改、增删或重新生成大纲，设置好后，进入下一步：确认生成</li>\n<li>左侧文章编辑器区域会实时显示文章生成进度，等待几十秒全文即可生成</li>\n<li>生成完毕后，若对文章不满意，可以点击重新生成</li>\n</ol>\n<h2>新华妙笔的产品价格</h2>\n<ol>\n<li>免费试用版：新用户注册后可获得免费7天的试用，可分别进行AI生成和校对10000字，提供AI续写、AI润色、AI校对、公文模板、公文范文、专题学习、星标范文各100次。</li>\n<li>个人版收费情况：月付98元，季付258元、半年付418元、年付698元，个人版年付最高可获得AI生成、续写和校对各80字的配额，可使用AI润色1.5万次、公文模板1万次、公文范文5000次、专题学习3000次。</li>\n<li>团队版收费情况：1-5人（1200元一年）、1-10人（1999元一年），团队版年付最高可获得AI生成和续写各600万字的配额，使用AI润色、公文模板和公文范文各20万次，AI校对300万字、3万次专题学习、5万次星标范文。</li>\n</ol>\n<img  class=\"alignnone size-full rounded-lg\" src=\"/uploadfile/202312/83f887b16729c77.png\"  alt=\"新华妙笔不同价格权益对比\" width=\"800\" height=\"461\">\n<h2>常见问题</h2>\n<div id=\"accordion\" style=\"max-width: 700px;\">\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>新华妙笔的官方网站是多少？</strong></div>\n<div class=\"card-body text-sm\">新华妙笔的官方网站入口网址为https://miaobi.xinhuaskl.com/。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>新华妙笔收费吗？</strong></div>\n<div class=\"card-body text-sm\">新华妙笔提供免费7天试用，试用结束后需要付费。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>新华妙笔基于什么模型？</strong></div>\n<div class=\"card-body text-sm\">新华妙笔的AI写作能力基于博特智能推出的BOTLLM文本生成大模型。</div>\n</div>\n</div>'),
                                                                        (396,	0,	0,	'<p>PMAI是一个面向产品经理的AI助手，提供帮助产品经理一键生成PRD文档、业务问题的解决方案、业务流程图、生成SQL代码等实用功能，让产品经理节省写各种产品文档的时间，将更多的精力放在构思上，提升工作效率，让工作更轻松。</p>\n<img  class=\"alignnone size-full rounded-lg\" src=\"/uploadfile/202312/7c00e700b8f3dfd.png\"  alt=\"PMAI\" width=\"800\" height=\"422\">\n<h2>PMAI的主要功能</h2>\n<ol>\n<li>产品需求文档生成：输入产品名、原型图、功能名，一键生成PRD文档，支持PRD文档检查</li>\n<li>多种图示生成：只需粘贴文档，即可生成流程图、时序图、页面结构图</li>\n<li>测试用例生成：只需粘贴PRD，AI帮你生成测试用例，完成功能上线前验收</li>\n<li>更多生成功能：提供数据字段、SQL代码、周报生成功能</li>\n</ol>\n<h2>PMAI的产品价格</h2>\n<ol>\n<li>免费版普通用户：每天最多可免费使用5次，每月可免费使用30次</li>\n<li>付费VIP会员：新客月卡19元，半年卡59.9元，年卡118.8元，每天最多可免费使用500次，每月可免费使用500次，支持文档导出</li>\n</ol>'),
                                                                        (397,	0,	0,	'<p>代码小浣熊Raccoon是商汤科技最新推出的一个智能AI编程助手和工具，由商汤自研的大模型驱动，支持多种编程语言和多项任务能力，可为开发人员带来全新的编程体验。代码小浣熊Raccoon提供了丰富的智能代码生成和辅助功能，可应用于从软件需求分析、架构规划、代码生成到软件测试的各个开发流程中，满足程序员代码编写、数据分析以及编程学习等多样化需求。</p>\n<img  class=\"alignnone size-full rounded-lg\" src=\"/uploadfile/202312/c631aba48564e60.jpeg\"  alt=\"代码小浣熊Raccoon\" width=\"800\" height=\"450\">\n<h2>代码小浣熊Raccoon的主要功能</h2>\n<ol>\n<li><strong>代码生成和补全</strong>：根据注释生成代码或根据上下文提供智能的代码补全建议</li>\n<li><strong>代码翻译</strong>：支持不同编程语言之间的代码互译，如Python转JavaScript</li>\n<li><strong>代码重构</strong>：提高代码可读性和可维护性，优化代码结构，提高运行效率</li>\n<li><strong>代码纠错</strong>：快速识别各种代码错误并智能修正有问题的代码</li>\n<li><strong>代码问答</strong>：内置代码助手，可进行连续对话，解答编程时遇到的疑问</li>\n<li><strong>测试用例生成</strong>：自动生成测试用例，确保代码更全面地被测试</li>\n</ol>\n<h2>代码小浣熊Raccoon支持的语言和IDE</h2>\n<ul>\n<li>支持Python、C#、C/C++、Java、Go、JavaScript、SQL等30多种主流编程语言</li>\n<li>兼容Visual Studio Code、Android Studio和JetBrains旗下的系列IDE，Eclipse、Xcode等后续将开放支持</li>\n</ul>\n<h2>如何使用代码小浣熊Raccoon</h2>\n<ol>\n<li>访问代码小浣熊Raccoon的官网（code.sensetime.com），点击立即体验按钮</li>\n<li>选择下载对应的IDE插件，以VS Code为例，可进入Visual Studio Marketplace页面点击Install唤起桌面端的VS Code，或直接在软件内的扩展搜索Raccoon进行安装</li>\n<li>安装成功后，点击左侧的小浣熊图标登录注册账号，登录成功后即可开始使用</li>\n<li>在代码编辑器里面使用Alt + /可获取代码补全，也可以在侧边栏获终端面板唤起代码助手进行对话</li>\n</ol>\n<img  class=\"alignnone size-full rounded-lg\" src=\"/uploadfile/202312/cf0e36bb1cc0da0.jpeg\"  alt=\"VS Code 代码小浣熊Raccoon插件\" width=\"800\" height=\"451\">\n<h2>常见问题</h2>\n<div id=\"accordion\" style=\"max-width: 700px;\">\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>代码小浣熊Raccoon单词有什么含义？</strong></div>\n<div class=\"card-body text-sm\">Raccoon的本意是小浣熊，在这里指的是<strong>R</strong>accoon - <strong>A</strong>nother <strong>C</strong>ode <strong>CO</strong>-pil<strong>O</strong>t <strong>N</strong>avigator的缩写。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>代码小浣熊Raccoon是免费的吗？</strong></div>\n<div class=\"card-body text-sm\">代码小浣熊Raccoon目前在免费公测中，用户可免费使用。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>代码小浣熊Raccoon基于什么大模型？</strong></div>\n<div class=\"card-body text-sm\">代码小浣熊Raccoon基于商汤科技自研的大语言模型。</div>\n</div>\n</div>'),
                                                                        (399,	0,	0,	'<style>div.p-2.rounded {display: none;}</style>\n<p>一帧秒创是基于秒创AIGC引擎的智能AI内容创作平台，为200万+创作者提供包括文字续写、文字转语音、文生图、图文转视频、AI成片、数字人播报等创作服务，产品包括秒创数字人、秒创AI帮写、秒创图文转视频、秒创AI视频、秒创AI语音、秒创AI作画等。</p>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/a74471a2c4718.png\"  alt=\"一帧秒创Banner\" width=\"800\" height=\"275\">\n<h2><strong>一帧秒创可以做什么？</strong></h2>\n<h3>1、秒创数字人</h3>\n<p>智能数字人播报平台，输入文案，一键生成“真人”营销视频。AI数字人是以数字孪生等AI技术为基础，1:1还原真人形象、动作、神态、声音，无限逼近真人的数字分身。甚至还可以1:1还原真人形象+1:1还原真人音色，定制专属于您的数字人形象和声音，帮助您快速完成企业和个人IP打造，助力营销增长。</p>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/4d92fbca7ed068.png\"  alt=\"一帧秒创数字人\" width=\"800\" height=\"451\">\n<h3>2、秒创图文转视频</h3>\n<p>作为国内领先的智能内容创作平台，输入文案，智能匹配，AI将根据语意自动匹配画面，快速实现从文案到视频的制作，实现全自动文章转视频、图文转视频。画面匹配、智能配音、智能字幕等功能，AI都能完美实现。高效产出内容的同时，支持非常灵活的细节调整，文稿、音乐、配音、粗剪、LOGO、字幕、语速等功能，一应俱全。海量在线素材，可任意替换选择，一键图文成片。</p>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/b81f7ed5f246dc3.png\"  alt=\"一帧秒创图文转视频\" width=\"800\" height=\"407\">\n<h3>3、秒创AI帮写</h3>\n<p>智能文案写作平台，输入灵感，文思泉涌，出“手”成章。一帧秒创提供短视频、营销、直播、风格文案4大类型AI帮写模板，全方位满足用户需求，甚至能直接输出直播脚本，大大提升运营和主播同学的效率。短视频内容、营销文案，秒创AI帮写统统都能帮你搞定。</p>\n<img  src=\"/uploadfile/202312/db17ca87e487ac0.png\"  alt=\"一帧秒创AI帮你写\" width=\"800\" height=\"346\" class=\"alignnone size-full\">\n<h3>4、秒创AI作画</h3>\n<p>智能绘画生成平台，输入idea，灵感涌现，释放想象。只需输入作画文本关键词，描述出想要AI作画的场景画面，选择修饰词、艺术风格、艺术家风格，只需一键AI就可以自动生成精美绝伦的绘画作品。</p>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/80bca137cc421d0.png\"  alt=\"一帧秒创AI作画\" width=\"800\" height=\"330\">\n<h3>5、秒创文字转语音</h3>\n<p>一帧秒创拥有独有的AI智能配音技术，一键输入文本自动完成配音，囊括全网热门发音人，56种AI配音可供选择，中文英文任意切换，输出的内容像真人一样，为创作者提供丰富的选择空间。</p>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/f88428dea136ee1.png\"  alt=\"一帧秒创AI转语音\" width=\"800\" height=\"293\">\n<p>AIGC创作平台一帧秒创，依托强大的AI技术，识别文字语义，自动分镜头匹配素材，实现“自动化视频剪辑”，一键成片，一天轻松制作100条”高质量原创视频“。</p>\n<img  class=\"alignnone\" src=\"/uploadfile/202312/875bd1c9319b3e1.png\"  alt=\"一帧秒创二维码\" width=\"500\" height=\"241\">\n<h2>产品价格</h2>\n<p>目前一帧秒创免费使用是完全没问题的，当然会员可享受更多权益。如果您对一帧秒创有更高的使用需求，可以开通付费版，AI工具集专属渠道优惠18.8元（注册后7天内有效），截止时间2023.12.31。</p>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/6eba17fd4eab97d.png\"  alt=\"一帧秒创价格\" width=\"800\" height=\"476\">'),
                                                                        (402,	0,	0,	'<blockquote><p>8月31日凌晨更新：百度文心一言获批上线，将向全社会开放！</p></blockquote>\n<p>文心一言（英文名：ERNIE Bot）是基于百度研发的知识增强大语言模型的AI聊天机器人，能够与人对话互动，回答问题，协助创作，高效便捷地帮助人们获取信息、知识和灵感。文心一言基于飞桨深度学习平台和文心知识增强大模型，持续从海量数据和大规模知识中融合学习，具备知识增强、检索增强和对话增强的技术特色。</p>\n<h2>文心一言的主要功能</h2>\n<p>文心一言的主要功能如下：</p>\n<table class=\"table table-striped\">\n<thead>\n<tr>\n<th>功能类型</th>\n<th>描述</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n<td>回答问题</td>\n<td>根据用户的问题，提供相关的信息和答案</td>\n</tr>\n<tr>\n<td>文本创作</td>\n<td>生成各种类型的文本，包括文案、诗歌、小说、新闻、电子邮件等</td>\n</tr>\n<tr>\n<td>知识推理</td>\n<td>进行逻辑推理、常识推理、数学推理等</td>\n</tr>\n<tr>\n<td>自然语言理解</td>\n<td>理解用户的自然语言意图，提供相应的服务和内容</td>\n</tr>\n<tr>\n<td>聊天交流</td>\n<td>与用户进行自然语言聊天，提供帮助、解答问题和提供信息</td>\n</tr>\n<tr>\n<td>生成图片</td>\n<td>根据用户的文字描述，生成符合要求的图片或画作</td>\n</tr>\n<tr>\n<td>翻译</td>\n<td>将用户输入的文本翻译成多种语言，实现跨语言交流</td>\n</tr>\n<tr>\n<td>智能推荐</td>\n<td>根据用户的需求和兴趣，推荐相关的内容和资源</td>\n</tr>\n<tr>\n<td>情感分析</td>\n<td>分析用户的情感和情绪，提供相应的帮助和支持</td>\n</tr>\n<tr>\n<td>文本纠错</td>\n<td>帮助用户修改和纠正文本中的错误和瑕疵</td>\n</tr>\n<tr>\n<td>文字生成语音</td>\n<td>将用户输入的文本转换成语音，实现语音交互</td>\n</tr>\n<tr>\n<td>文档生成</td>\n<td>根据用户的需求和模板，生成各种类型的文档，如简历、报告、合同等</td>\n</tr>\n<tr>\n<td>代码生成</td>\n<td>根据用户的需求和语言，生成相应的代码</td>\n</tr>\n<tr>\n<td>语音识别</td>\n<td>将用户的语音转换成文字，实现语音文字的交互</td>\n</tr>\n<tr>\n<td>人机交互</td>\n<td>与用户进行多种形式的人机交互，如语音交互、图像交互、手势交互等</td>\n</tr>\n</tbody>\n</table>\n<h2>文心一言支持的语言</h2>\n<p>百度文心一言目前支持多种语言，包括中文、英文、日文等，其他语言还在学习中。</p>'),
                                                                        (404,	0,	0,	'<h2>GPT-4介绍</h2>\n<p>GPT-4（Generative Pre-trained Transformer）是 OpenAI 开发的自然语言处理模型 GPT 家族中的第四个版本，该模型依靠强大的神经网络来理解和生成类似人类的语言。</p>\n<div class=\"io-edit-post-card-content\"><div class=\"url-card shortcode-url site_0 mx-auto \" style=\"max-width:420px\">        <div class=\"card flex-fill mb-3\">\n            <div class=\"row no-gutters\">\n                <div class=\"col-4\">\n                    \n                <div class=\"media media-4x3 rounded-left\">\n                                        \n                                    </div>\n                </div>\n                <div class=\"col-8\">\n                    <div class=\"card-body list-content p-2\" style=\"height: 100%;\"> \n                        <div class=\"list-body\"> \n                            如何免费使用GPT-4？不开会员的6种方法\n                            <div class=\"list-desc d-none d-md-block text-sm text-secondary my-3\">\n                        <div class=\"overflowClip_2 \">目前官方版的GPT-4仅能通过ChatGPT Plus付费会员才能使用，免费版的ChatGPT无法使用最新的GPT-4，而Plus版本需要每个月花费20美元来订阅，并且国内付款非常困...</div>\n                    </div>\n                        </div>\n                        <div>\n                            <div class=\"d-flex flex-fill align-items-center text-muted text-xs\">\n                                                                <span><i class=\"iconfont icon-classification\"></i>\n                                    AI教程\n                                </span>\n                                                                <div class=\"flex-fill\"></div>\n                                <div>\n                                    <time class=\"mx-1\">6个月前</time>\n                                </div>\n                            </div>      \n                        </div>  \n                    </div>\n                </div>\n            </div>\n        </div>\n</div></div>\n<p>GPT-4 通过使用被称为「转换器（Transformer）」的特殊架构来帮助软件理解单词的含义以及它们在句子中的组合方式。通俗来讲，Transformer帮助计算机找出如何将所有的词以正确的顺序放在一起，使之有意义。</p>\n<p>之所以采用这样的方法，是因为该模型已经在一个巨大的数据集上进行了训练，其中包括来自不同来源的文本，如书籍、文章和网站。这种训练使 GPT-4 模型能够进行类似人类的对话，并产生看似有意义的回应。不过虽然 GPT-4 创造的文本和回应读起来像人，但它远远不是有意识的智能，离通用人工智能还有距离。</p>\n<h2>GPT-4的工作原理</h2>\n<p>GPT-4通过与其前身（GPT-3.5）相同的基本流程工作，但规模更大，以下是其主要的工作原理：</p>\n<ul>\n<li>Transformer架构： GPT-4是使用一种叫做「Transformer」的设计来构建的，这些转换器就像超级智能机器，能够理解一句话中哪些词是重要的，以及它们之间的关系。</li>\n<li>大规模的预训练： GPT-4从大量的文本中学习，如书籍、网站和文章，这样一来，它就能更好地理解语言模式、语法和事实。</li>\n<li>微调（Fine-tuning）： 在从大量文本中学习后，GPT-4会在特定的任务中接受训练，如回答问题或理解文本中的情感，这有助于它在处理这些任务时变得更加出色。</li>\n<li>分词（Tokenization）： GPT-4将文本分解成更小的部分，称为「tokens」，这些token可以是单词或单词的一部分，这有助于它处理不同的语言并理解词语的含义。</li>\n<li>上下文窗口（Context window）： GPT-4有一个限制，即它可以一次查看多少个token。这个限制有助于它理解语境和单词之间的关系，但这也意味着它不一定能理解很长的句子或段落。</li>\n<li>概率分布和抽样： 当GPT-4生成文本时，它根据模型认为每个词的可能性的大小来猜测下一个词。然后，它从这些猜测中挑选出一个词，使其够创造出多样化和有趣的句子。</li>\n<li>细粒度控制（Fine-grained control）： GPT-4可以通过使用特殊提示或调整其设置等技巧，引导它给出特定类型的答案或文本，以帮助从该模型中获得我们想要的结果。</li>\n</ul>\n<h2>ChatGPT和GPT-4的区别</h2>\n<p>ChatGPT 和 GPT-4 并不是同一回事，ChatGPT 是基于 GPT-3.5 和 GPT-4 模型的，专门为对话式人工智能应用而设计的，比如根据用户输入生成类似人类的文本回复。</p>\n<p>而GPT-4指的是GPT系列大语言模型的当前版本——驱动ChatGPT的引擎。</p>\n<p>ChatGPT提供的输出读起来更自然，GPT-4更强大，在输入/输出方面可以处理更多文本。</p>\n<h2>GPT-4可以免费访问吗？</h2>\n<p>这个问题的答案：是也不是。</p>\n<p>用户可以通过ChatGPT、New Bing等软件访问GPT-4，这些平台使用GPT-4来生成内容并与用户互动。然而，GPT-4只有在ChatGPT Plus付费计划下才能使用，或者作为开发者建立应用程序和服务的API。New Bing（新必应）可以每天免费有限次数使用GPT-4驱动的AI聊天，而独立用户在这些人工智能聊天机器人平台之外没有机会使用GPT-4。</p>'),
                                                                        (405,	0,	0,	'<p>360智脑是360搜索最新推出的AI对话聊天机器人，拥有独特的语言理解能力，通过实时对话，解答疑惑、探索灵感，用AI技术帮人类打开智慧的大门。</p>\n<blockquote><p>9月5日起，360 智脑大模型面向公众开放，全面接入 360“全家桶”。360 智脑将在五大平台面向公众开放，用户可以通过 360 智脑官网、各大应用商店下载“360 智脑”App。此外，官方还表示，用户也可以升级 360 安全卫士、360 安全浏览器、360 搜索至最新版本，登录即可体验大模型服务。</p></blockquote>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/8efb2671e0c1918.jpg\"  alt=\"360智脑的界面\" width=\"800\" height=\"450\">'),
                                                                        (406,	0,	0,	'<p>Inworld 为人工智能虚拟角色提供了一个完全集成的平台，它在大语言模型（LLM）的基础上开发，并拓展了可配置的安全性、知识、内存、叙事控制、多模态等特性。用户可以通过该平台塑造具有独特个性和背景意识的虚拟人物，并可以无缝集成到实时应用程序中，内置规模和性能优化功能。</p>'),
                                                                        (407,	0,	0,	'<p>Pi 是由初创 AI 公司 Infelection AI 推出的一个AI聊天机器人，该公司由 DeepMind 联合创始人 Mustafa Suleyman、LinkedIn 联合创始人 Reid Hoffman 和 前 DeepMind 研究员 Karén Simonyan 共同创立。Pi 则是 Inflection AI 推出的第一个产品，其用户可以直接通过一个应用程序，或通过文本、WhatsApp、Instagram和Facebook与聊天机器人进行个人对话。</p>\n<p>Pi 代表个人智能（personal intelligence），因为它可以根据个人的独特兴趣和需求提供无限的知识。Pi 可以是一位老师、教练、知己、创意伙伴。</p>'),
                                                                        (408,	0,	0,	'<p>Open Assistant是一个旨在让每个人都能访问基于AI聊天对话的大语言模型的开源项目，Open Assistant希望可以像Stable Diffusion帮助世界以新的方式创作艺术和图像一样，通过改进语言本身来帮助改善世界。</p>'),
                                                                        (409,	0,	0,	'免费AI对话回应'),
                                                                        (410,	0,	0,	'AI对话陪伴工具'),
                                                                        (411,	0,	0,	'WriteSonic出品的ChatGPT竞品'),
                                                                        (412,	0,	0,	'<p>YouChat 是一个由 You.com 开发的人工智能搜索助手，允许用户在不需要浏览多个网站的情况下找到问题的总结性答案。YouChat 使用自然语言处理（NLP）和机器学习算法来理解用户的查询，并以对话的方式提供相关的答复。YouChat 与 You.com 的搜索引擎集成，使其能够提供最新的信息并引用来源。</p>'),
                                                                        (413,	0,	0,	'Jasper针对内容创作者出品的AI聊天工具'),
                                                                        (414,	0,	0,	'创建虚拟角色并与其对话'),
                                                                        (415,	0,	0,	'<p>ColossalChat是由Colossal-AI推出的免费开源版ChatGPT聊天机器人替代品，目前其GitHub项目已斩获26K星标。</p>\n<p>作为当今领先的开源大型人工智能模型解决方案，Colossal AI是第一个基于LLaMA预训练模型开源完整RLHF机制的公司，该机制包括监督数据收集、监督微调、奖励模型训练和强化学习微调，并共享ColossalChat——与最初的ChatGPT技术解决方案非常相似的开源项目。</p>\n<p>该开源项目包括以下内容：</p>\n<ul>\n<li>Demo演示：一个交互式演示，无需注册或加入等待名单即可在线试用</li>\n<li>训练代码：开源完整的RLHF训练代码，包括70亿和130亿的模型。</li>\n<li>数据集：开源104K中英文双语数据集。</li>\n<li>推理：仅需要4GB GPU内存便可进行70亿参数模型的4-bit量化推理。</li>\n<li>模型权重：在单个服务器上只需少量计算能力即可实现快速复制。</li>\n</ul>'),
                                                                        (416,	0,	0,	'<p>Stable Chat 是 Stability AI 最新推出的一款类似于 ChatGPT 或 Claude 的对话式 AI 助手的研究预览版，旨在成为研究人员和 AI 爱好者评估 Stability AI 模型的功能和安全性的一种方式，该 AI 聊天机器人基于 Stable Beluga 大语言模型。</p>\n<p>用户可以创建一个免费帐户来与 LLM 聊天，测试其解决问题的能力，并标记任何有关或有偏见的回答，目标是利用人工智能社区的帮助来改进这些公开可用的模型。Stable Chat 目前运行在Stable Beluga之上，Stability AI 计划通过最新的研究迭代不断更新该网站。</p>\n<p>Stability AI 警告用户在此研究阶段避免现实世界或商业应用，该公司还明确表示，Stable Chat 中的所有输入和对话都会被记录。因此，用户应避免分享任何他们希望保密的个人信息或详细信息，目标是创建一个严格专注于基于研究的测试和反馈的环境。</p>'),
                                                                        (417,	0,	0,	'<p data-track=\"3\">TigerBot 是由国内公司虎博科技推出的AI对话聊天机器人，基于其最新推出的多模态大语言模型TigerBot，该模型包含70亿参数和1800亿参数两个版本，均对外开源。支持文章创作、表格数据统计、尝试问答等，并支持多模态，能生成图片绘画。</p>\n<h2 data-track=\"3\">TigerBot的主要功能</h2>\n<ol>\n<li>文章和文案创作。TigerBot支持场景创作文章、生成剧情概述、编写诗歌、生成标题、邮件写作、广告宣传文案创作、文章大纲生成、评论语生成等</li>\n<li>表格数据统计。列出你需要整理的数据，TigerBot可以基于你提供的数据制作表格，并作简要分析</li>\n<li>头脑风暴，灵感不枯竭。没有想法的时候，可以使用TigerBot进行列举、推荐、建议、联想，让你打开思路，扩展视界</li>\n<li>对话聊天。支持情景对话、分角色对话、规定情绪对话，创建专属于你的个人对话伙伴或个性对话场景</li>\n<li>支持多模态，可输入文本描述进行绘画</li>\n</ol>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/849e62cb02f7ece.png\"  alt=\"TigerBot聊天机器人\" width=\"800\" height=\"450\">\n<h2>TigerBot是免费的吗</h2>\n<p>TigerBot的大模型是免费开源的，你可以在GitHub或HuggingFace查看或下载其模型。在线对话AI目前在免费内测中，感兴趣的朋友可以访问其官网或微信小程序申请加入内测。</p>'),
                                                                        (418,	0,	0,	'<p>Poe是由国外知名问答社区Quora建立的一个平台，以让人们提问、获得即时答案，并与人工智能进行来回对话。该平台内置了4个不同的聊天机器人，</p>\n<ul>\n<li>Claude倾向于在许多创造性写作任务中表现得更好，但更可能拒绝回答问题。</li>\n<li>Sage和ChatGPT更擅长英语以外的语言，更擅长编程相关任务。</li>\n<li>Dragonfly的响应往往较短，在输入中给出示例时，让Dragonfly按照说明操作更容易。</li>\n</ul>\n<p>由使用大型语言模型（LLM）的第三方公司提供支持，其中Sage、ChatGPT和Dragonfly由OpenAI提供支持。Sage和ChatGPT使用GPT 3.5 Turbo模型，Dragonfly使用text-davinci-003模型，而Claude则由Anthropic提供支持。另外，用户每天可免费使用GPT-4 一次。</p>\n<p>每一个机器人都有自己独特的个性，随着时间的推移，你可以了解这些个性，所以如果你感兴趣，你可以尝试它们，并决定你最喜欢哪一个。</p>'),
                                                                        (419,	0,	0,	'<p>HuggingChat是最大的开源AI社区「HuggingFace」推出的类ChatGPT在线聊天机器人，基于开源的「Open Assistant」的300亿参数模型，该聊天机器人无需注册可直接免费使用。</p>'),
                                                                        (420,	0,	0,	'<p>Forefront是一个免费的基于GPT-4模型套壳的AI聊天机器人，提供更好的ChatGPT使用体验。用户可以在GPT-4和GPT-3.5模型间切换，注册即可免费使用GPT-4、图像生成、自定义人物角色、可共享聊天等。</p>'),
                                                                        (421,	0,	0,	'<p>ModelScopeGPT（魔搭GPT）， 是阿里巴巴达摩院最新推出的一个大小模型协同的智能助手，具备作诗、绘画、视频生成、语音播放等多模态能力，可以通过大模型做中枢（controller），来控制魔搭社区的各种多模态模型API回复用户的问题。除此之外，魔搭GPT还集成了知识库检索引擎，可以解答用户在魔搭社区使用模型遇到的问题以及模型知识相关问答。</p>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/e892d884c8e6a.jpeg\"  alt=\"魔搭GPT的demo\" width=\"800\" height=\"450\">'),
                                                                        (422,	0,	0,	'<h2>DeepSeek是什么</h2>\n<p>DeepSeek是知名私募巨头幻方量化旗下的人工智能公司深度求索（DeepSeek）自主研发的大语言模型开发的智能助手，该AI聊天助手可以进行自然语言处理、问答系统、智能对话、智能推荐、智能写作和智能客服等多种任务。DeepSeek使用了大规模数据进行训练，具有强大的语言理解和生成能力，可以回答用户提出的各种问题，包括但不限于常识问题、专业问题、历史问题、科技问题等，还可以与用户进行智能对话，理解用户的意图和情感，并给出相应的回答。</p>\n<img  class=\"alignnone size-full rounded shadow-sm\" src=\"/uploadfile/202312/9a40cc674dd0e8c.png\"  alt=\"DeepSeek Chat\" width=\"800\" height=\"450\">\n<h2>DeepSeek的主要功能</h2>\n<ol class=\"text-md\">\n<li>自然语言处理：能够理解和生成自然语言，可以进行语言翻译、文本摘要、情感分析、命名实体识别等任务。</li>\n<li>问答系统：可以回答用户提出的各种问题，包括但不限于常识问题、专业问题、历史问题、科技问题等。</li>\n<li>智能对话：能与用户进行智能对话，理解用户的意图和情感，并给出相应的回答。</li>\n<li>信息推荐：根据用户的历史行为和偏好，推荐相关的内容和信息。</li>\n<li>内容写作：根据用户提供的关键词和主题，自动生成相关的文章和内容。</li>\n<li>智能客服：代替人工客服，回答用户的咨询和问题，提高客服效率和质量。</li>\n<li>代码助手：可以帮助解答关于编程语言、算法、数据结构、机器学习、人工智能等领域的问题，包括提供代码示例、解释代码的功能、帮助调试代码等</li>\n</ol>\n<h2>常见问题</h2>\n<div id=\"accordion\" style=\"max-width: 700px;\">\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>DeepSeek Chat基于什么大模型？</strong></div>\n<div class=\"card-body text-sm\">DeepSeek Chat基于深度求索推出的 deepseek-llm-67b 大模型。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>DeepSeek是免费的吗？</strong></div>\n<div class=\"card-body text-sm\">DeepSeek的大模型是免费开源的，无需申请即可免费商用。DeepSeek Chat 聊天助手现也已全面免费开放内测。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>DeepSeek与幻方量化什么关系？</strong></div>\n<div class=\"card-body text-sm\">DeepSeek是利用人工智能技术进行量化投资的对冲基金公司及科技公司幻方量化旗下成立的探索AGI（通用人工智能）的新组织“深度求索”。</div>\n</div>\n</div>'),
                                                                        (423,	0,	0,	'<h2>ChitChop是什么？</h2>\n<p>ChitChop是字节跳动在海外上线的一款免费大模型产品和人工智能助手工具箱，可以为用户提供多达200+的智能机器人服务，通过提供创造性灵感、提高工作效率等方式来服务用户的学习、工作和生活。值得注意的是，该款产品与抖音集团旗下AI产品“小悟空”类似，都是基于云雀大语言模型创建的AI小工具合集，只是网页外观有些许改动。</p>\n<img  class=\"alignnone size-full rounded shadow-sm\" src=\"/uploadfile/202312/5c8d41554082d83.png\"  alt=\"ChitChop AI对话\" width=\"800\" height=\"450\">\n<h2>ChitChop的主要功能</h2>\n<ol class=\"text-md\">\n<li>丰富的应用场景：提供AI创作、AI绘图、娱乐休闲、学习提升、工作提效、生活助手六大场景的AI小工具</li>\n<li>简单输入提示即可互动：只需输入几个简单的提示词，你就可以把你的想法变成艺术图像或者与AI进行交流互动。</li>\n<li>文件智能分析和总结：添加上传一个文件，即可分析、总结和对文件内容发起讨论，帮助你高效地学习和分析内容</li>\n<li>实时互联网搜索：与人工智能交互进行搜索。ChitChop不仅仅是一个搜索引擎，还可以总结搜索结果，为你的问题找到最佳/最相关的答案。</li>\n<li>200+ AI 机器人：内置200多个智能机器人，帮助提高创造力，学习新话题，甚至与人工智能虚拟角色玩游戏</li>\n</ol>\n<img  class=\"alignnone size-full rounded shadow-sm\" src=\"/uploadfile/202312/08954cdb12567d9.png\"  alt=\"ChitChop AI 机器人\" width=\"800\" height=\"450\">\n<h2>如何使用ChitChop？</h2>\n<ol class=\"text-md\">\n<li>访问ChitChop的官网（chitchop.com），使用谷歌、TikTok或苹果账号登录/注册（你也可以下载ChitChop的手机端APP）</li>\n<li>登录成功后会自动跳转到AI工具界面，选择你感兴趣的小工具，在底部输入框中输入提示词即可与其对话</li>\n<li>你也可以点击左侧的新对话创建一个全新空白的聊天，点击左下角的菜单栏可以开启联网搜索功能</li>\n</ol>\n<h2>常见问题</h2>\n<div id=\"accordion\" style=\"max-width: 700px;\">\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>ChitChop支持哪些语言？</strong></div>\n<div class=\"card-body text-sm\">ChitChop目前支持英语和汉语（简体中文和繁体中文），若使用其他语言和其聊天，可能不太理解或者无法准确回答。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>ChitChop是免费的吗？</strong></div>\n<div class=\"card-body text-sm\">ChitChop目前是免费向用户开放的。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>ChitChop支持哪些平台？</strong></div>\n<div class=\"card-body text-sm\">ChitChop目前支持通过网页版、iOS和Android移动端使用。</div>\n</div>\n</div>'),
                                                                        (424,	0,	0,	'<p>XChat是基于元象科技推出的XVERSE通用大模型的人工智能聊天助手，融合了意图理解、信息检索以及强化学习技术，结合有监督微调与人类意图对齐，在知识问答、文本创作领域表现突出，可帮助用户回答问题、提供信息和执行各种任务。</p>\n<img  class=\"alignnone size-full rounded shadow-sm\" src=\"/uploadfile/202312/d604b8fbfb22cd2.png\"  alt=\"元象XChat\" width=\"800\" height=\"450\">\n<h2>元象XChat的主要功能</h2>\n<ol>\n<li>文本创作：根据给定的提示或指令生成连贯且相关的文本内容，涵盖了从撰写简短笔记到长篇文章的范围</li>\n<li>多语言翻译：支持多种语言之间的互相翻译，常见的语言包括：中文、英语、西班牙语、法语等</li>\n<li>知识问答：覆盖从日常常识到专业知识，可进行一般知识问题解答或特定主题的深入讨论</li>\n<li>编程协助：提供代码示例、代码解释、算法说明、编程概念说明、API文档等编程协助</li>\n<li>生活助手：可提供健康咨询、书籍影音娱乐推荐、旅游规划、文化习俗说明等生活娱乐建议和信息</li>\n</ol>\n<h2>元象XChat的应用场景</h2>\n<ol>\n<li>广告营销：媒体/出版/内容创作，利用模型的文本创作能力自动生成丰富多样的营销创意</li>\n<li>日常办公：会议/周月报/办公套件，适应文档总结、生成、插件适配等多样化场景</li>\n<li>智能客服：问答/智能对话，根据行业与场景定制问答，智能高效</li>\n<li>编程辅助：代码生成/数据分析/网页搭建，辅助用户进行编程过程中的代码撰写与问题发现等</li>\n<li>虚拟角色：游戏/娱乐/直播，对人设进行定制化设计，适配不同场景下的角色扮演</li>\n<li>教育科研：学习陪伴/科研助理，从学习、工作助理到科研发现多方向探索</li>\n</ol>\n<h2>常见问题</h2>\n<div id=\"accordion\" style=\"max-width: 700px;\">\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>元象XChat基于什么大模型？</strong></div>\n<div class=\"card-body text-sm\">元象XChat基于元象科技自研的XVERSE-65B大模型，该模型参数量650亿，支持16K的上下文长度。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>元象XChat是免费的吗？</strong></div>\n<div class=\"card-body text-sm\">元象XChat目前处于免费公测中，用户可以访问其官网申请免费使用。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>元象XVERSE大模型是开源的吗？</strong></div>\n<div class=\"card-body text-sm\">元象科技目前将其三个不同参数量的元象XVERSE大模型都开源了，分别是XVERSE-7B、XVERSE-13B、XVERSE-65B。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>元象XVERSE大模型通过备案了吗？</strong></div>\n<div class=\"card-body text-sm\">元象大模型已通过《生成式人工智能服务管理暂行办法》备案，将陆续向公众开放服务。</div>\n</div>\n</div>'),
                                                                        (425,	0,	0,	'<p>面壁露卡Luca是面壁智能最新推出的千亿多模态大模型免费智能对话助手，支持中文和英文进行交流互动。基于面壁智能的新一代大语言模型，能与用户进行多轮对话与互动，帮助用户了解世界知识、激发创作灵感、理解图片内容、处理数理逻辑、编写程序代码，以更好地获取信息、做出规划、解决问题。</p>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/045c0d13d2b61f9.png\"  alt=\"面壁露卡Luca\" width=\"800\" height=\"450\">\n<h2>面壁露卡Luca的功能</h2>\n<p>面壁露卡Luca可以回答很多问题，给用户提供有用的信息和建议。例如：</p>\n<ul>\n<li>对话交流：进行自然语言对话，回答用户的问题并提供相关信息。</li>\n<li>图片解读：支持上传图片对图片的内容进行提问</li>\n<li>提取摘要：对一段文本进行摘要，提取其中的关键信息。</li>\n<li>知识问答：回答各种类型的问题，涵盖了各个领域的知识。</li>\n<li>文案生成：可以根据给定的模板或要求生成相应的文本，如文章、故事、诗歌等。</li>\n<li>语言翻译：如将中英文文本进行翻译。</li>\n<li>内容推荐：可以推荐适合用户兴趣和需求的内容。</li>\n<li>趣味互动：可以与用户一起玩游戏、写故事、做任务等，增加交流的趣味性。</li>\n</ul>\n<h2>如何使用面壁露卡</h2>\n<ol>\n<li>访问面壁露卡的官网地址，点击加入体验按钮</li>\n<li>输入手机号码注册/登录，等待几秒钟后申请通过</li>\n<li>刷新页面便可直接进入Luca的聊天对话界面</li>\n<li>在底部输入框中输入你的问题，点击发送按钮即可与Luca进行互动</li>\n</ol>'),
                                                                        (426,	0,	0,	'<p>MChat 是一款基于澜舟科技自研的孟子生成式大模型技术（孟子 GPT）的 AI 对话机器人，可与用户进行多轮次场景化的对话，能够通过智能对话帮助用户完成特定场景中的多种工作任务。</p>\n<img  class=\"alignnone size-full shadow-sm rounded\" src=\"/uploadfile/202312/182ce49e29edd9b.png\"  alt=\"澜舟科技MChat\" width=\"800\" height=\"450\">\n<h2>MChat的主要功能</h2>\n<ol>\n<li><strong>知识问答</strong>：知识库包含了覆盖各领域数十亿条数据，可提供详细且权威的知识解答和说明</li>\n<li><strong>多轮对话</strong>：理解用户意图，并记住聊天背景和上下文与用户进行连续性的交互式交流</li>\n<li><strong>多语言翻译</strong>：支持多种语言的翻译，包括中文、英语、法语、德语、西班牙语、俄语、阿拉伯语等</li>\n<li><strong>通用写作</strong>：可以按照用户提供的关键词、主题和要求生成高质量的原创内容，提高创作效率</li>\n<li><strong>金融场景任务</strong>：帮助解答用户在金融市场、投资理财等相关主题的问题，同时也能编写各种金融分析文章、研究报告，以及完成各类金融信息的深度加工等任务</li>\n</ol>\n<h2>如何使用MChat</h2>\n<ol>\n<li>访问澜舟科技孟子生成式大模型的官网，点击试用体验版</li>\n<li>输入手机号登录或注册账号，然后在邀请码页面填写信息申请开通MChat</li>\n<li>审核通过后即可访问MChat的对话界面进行体验啦</li>\n<li>在底部的输入框输入想问的问题，然后点击发送，MChat即可解答你的疑问</li>\n</ol>\n<h2>常见问题</h2>\n<div id=\"accordion\" style=\"max-width: 700px;\">\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>MChat基于什么大模型？</strong></div>\n<div class=\"card-body text-sm\">MChat基于澜舟科技推出的孟子GPT大模型，目前已接入孟子GPT-通用-7B、孟子GPT-通用-40B、孟子GPT-金融-7B等模型，并可在这三个模型间切换。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>MChat必须要邀请码吗？</strong></div>\n<div class=\"card-body text-sm\">目前MChat还处于内测当中，没有邀测码的用户可以登录后点击“去申请”，审批通过后即可获得体验资格。</div>\n</div>\n</div>'),
                                                                        (427,	0,	0,	'<h2>超级助理是什么？</h2>\n<p>超级助理是百度智能云推出的一款基于文心一言的AI原生应用和伴随式Copilot助理，是一个功能强大、使用方便、面向所有人应用的智能助手，可满足日常生活和工作中的各种需求。无论是浏览网页、深入阅读长篇文档，还是高效的信息服务，超级助理都能提供无缝的体验。超级助理不仅是您的信息获取助手，更是您的创意伙伴。它能够基于您的需求生成专业、富有创意的文案，让创作变得轻而易举，提供更加智能、高效的工作和生活方式。</p>\n<img  class=\"alignnone size-full rounded-lg shadow-sm\" src=\"/uploadfile/202312/b7b25af71617c0a.png\"  alt=\"百度超级助理\" width=\"800\" height=\"431\">\n<h2>超级助理的主要功能</h2>\n<ol class=\"text-md\">\n<li><strong>划选快捷指令</strong>：划选网页内容，一键实现解释、总结、翻译、纠错、改写、扩写、续写、知识问答等AI原生应用能力</li>\n<li><strong>自定义指令</strong>：划选网页内容后可以输入自定义Prompt，将自己的想法与大模型相融合，探索AI原生的无限可能</li>\n<li><strong>网页解读</strong>：页面右下角按钮一键解读，同时可针对网页内容进行问答</li>\n<li><strong>文件解读</strong>：点击文件解读上传文件，打开网页版进行PDF沉浸阅读，即可提供沉浸式阅读，支持划选指令、摘要总结、智能问答等能力</li>\n<li><strong>全文对照式翻译</strong>：非中文网站支持对照式翻译，同时展示原文与译文，阅读外文网站不带怕的</li>\n<li><strong>图片OCR识别</strong>：当鼠标hover到图片上时，图片右下角会出现“OCR”的浮标，点击后可解析图片上的文字</li>\n<li><strong>搜索增强</strong>：用大模型增强你的企业搜索结果，探索会话式搜索新体验，让知识扑面而来</li>\n<li><strong>聊天机器人</strong>：在如流端外也能与超级助理畅快交流，享受与端内一致的聊天体验；可调用各类插件，还能结合网页全文进行总结和问答</li>\n</ol>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/dec81dea4054611.png\"  alt=\"超级助理快捷指令\" width=\"800\" height=\"400\">\n<h2>超级助理的应用场景</h2>\n<ol class=\"text-md\">\n<li><strong>知识查询与学习</strong>：公司政策与文档解读、行业知识的精准获取、智能推荐，拓展学习、专业术语解释，拓展边界</li>\n<li><strong>科研论文深度解读</strong>：沉浸式论文阅读、互动式知识点探讨、观点批注功能、名词定义快速查阅、段落精读与总结</li>\n<li><strong>市场洞察与分析</strong>：行业报告解读、市场深度分析、市场知识点精准探讨</li>\n<li><strong>掌握全球视野</strong>：无障碍英文阅读，支持全页深度翻译和互动式即时翻译</li>\n<li><strong>文案创作</strong>：简历优化、内容创作、爆款文案生成</li>\n<li><strong>AI聊天</strong>：机器人聊天、多模态交互、网络访问</li>\n<li><strong>任务调度</strong>：创建日程、创建会议、查找文档</li>\n</ol>\n<h2>如何使用超级助理</h2>\n<ol class=\"text-md\">\n<li>访问超级助理的官网，点击下载插件</li>\n<li>将下载到本地的压缩包进行解压</li>\n<li>点击浏览器扩展程序-&gt;管理扩展程序</li>\n<li>点击加载已解压的扩展程序，上传解压后的压缩包</li>\n<li>上传成功后即可看到超级助理插件，打开插件</li>\n<li>在浏览器右上角点击安装好的超级助理，登录百度账号后即可使用</li>\n<li>浏览器打开任意网页或文件，点击右下角超级助理的悬浮图标便可使用其功能</li>\n</ol>\n<h2>常见问题</h2>\n<div id=\"accordion\" style=\"max-width: 700px;\">\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>超级助理是免费的吗？</strong></div>\n<div class=\"card-body text-sm\">超级助理目前处于免费公测中，所有用户都可以免费使用。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>超级助理支持哪些平台？</strong></div>\n<div class=\"card-body text-sm\">超级助理目前提供浏览器插件版，后续会推出独立的PC端和移动端应用。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>超级助理的插件支持哪些浏览器？</strong></div>\n<div class=\"card-body text-sm\">超级助理目前的插件支持以Chromium内核的浏览器，如常见的Chrome浏览器、Edge浏览器、QQ浏览器等。</div>\n</div>\n</div>'),
                                                                        (428,	0,	0,	'<p>百度上线的搜索AI伙伴，用户可免费进行对话、AI绘画和其他内容创作，百度搜索AI伙伴是百度最新上线的基于文心大模型的AI搜索对话工具，目前已免费对公众开放。用户可在桌面端百度网站或移动端的百度APP点击右上角的AI图标，即可进入AI聊天界面，或直接访问chat.baidu.com。</p>'),
                                                                        (429,	0,	0,	'<p>百川大模型是由原搜狗CEO王小川成立的大模型公司百川智能创造的大语言模型，可以和人类进行自然交流、解答问题、协助创作，帮助大众轻松、普惠的获得世界知识和专业服务。目前，百川大模型已获批向全社会开放服务，用户可访问其官网体验其在线AI对话功能。</p>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/ed56c7a968cc00e.png\"  alt=\"百川大模型AI对话聊天\" width=\"800\" height=\"450\">\n<h2>百川大模型的功能</h2>\n<p>百川大模型具有以下功能：</p>\n<ul>\n<li>自然交流：理解用户问题，并提供相应的回答。像与真人聊天一样与其沟通，无需担心语言障碍。</li>\n<li>解答问题：无论是常识性的问题还是专业领域的问题，都可以为你提供准确的信息和答案。</li>\n<li>协助创作：可以帮助你撰写文章、创作诗歌、编写故事等，激发你的创意灵感。</li>\n<li>知识百科：掌握大量的科学、文化、艺术等领域的知识，可以为你提供丰富的信息和深入的见解。</li>\n<li>个性化推荐：根据你的兴趣和需求，可以为你推荐相关的内容、产品和服务。</li>\n<li>教育辅导：可以帮助你学习新知识，解答你在学习过程中遇到的问题，提高你的学习效果。</li>\n<li>生活助手：可以帮助你管理日常生活中的琐事，提醒你的重要事项，让你的生活更加有序。</li>\n</ul>\n<p>以上只是部分功能，实际上还有更多能力，等待你来发现和体验。</p>\n<h2>如何使用百川大模型</h2>\n<ol>\n<li>访问百川大模型的官网（chat.baichuan-ai.com），点击加入体验按钮</li>\n<li>登录/注册账号，登录成功通过后点击开始体验自动跳转到对话界面</li>\n<li>在输入框中输入你想要询问的问题，即可开始进行对话互动</li>\n</ol>'),
                                                                        (430,	0,	0,	'<p>应事AI是基于MiniMax最新一代中文大语言模型的AI聊天机器人，产品前身是Inspo，现已通过备案并向社会开放。应事是您值得信赖的AI智能助理，可帮助高效写作、激发灵感、获取知识、做出决策。</p>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/a9e8aa8e91989d0.png\"  alt=\"应事AI聊天机器人\" width=\"800\" height=\"450\">\n<h2>应事AI的功能</h2>\n<ul>\n<li>高效写作，工作和学习的效率工具。应事可以根据给定的指引和需求描述，针对性的生成结构化的文字内容。比如一份周报、个人简历、请假邮件、或是新闻稿件、论文大纲、公文写作、读后感框架，当您在工作和学习中面临这些写作场景时，不妨让应事来帮帮您。</li>\n<li>创意辅助，内容生产的提效服务。应事可以基于特定的选题或场景，为创意性的内容生产提供服务。比如一篇社交媒体的发布文案，一个巧思构建的故事剧本，一个产品或一种服务的品牌营销文案，乃至于一篇稿件的相关选题。应事助力内容创造者的创意想象力飞得更高更远。</li>\n<li>知识百科，更加精准高效的信息求解。应事可以对问题提供有价值的附加信息，并且擅长解释复杂的概念。包括但不限于科学知识，人文地理，实用信息，哲学历史等。您可以询问大理最受欢迎的景区是什么，也可以和应事探讨波粒二象性，或者向它要求一份麻婆豆腐的菜谱。有记忆的连续对话可以让应事对您的问题深入分析信息细节，更好的给出答案。</li>\n<li>决策辅脑，24小时待命的智能助理。应事可以调校，分析和提炼大量数据，为您的决策生成有价值的见解或解决方案。比如您可以在给出一定的背景信息后，请应事为您撰写一份产品设计方案，市场分析报告或活动策划。应事可以帮助您整理思路，做出更好的决策。</li>\n</ul>\n<h2>如何使用应事AI</h2>\n<ol>\n<li>用户可通过网页版（yingshi-ai.com）在线使用，或前往App Store和各大安卓应用商店下载应事的移动应用</li>\n<li>使用手机号注册/登录账号，登录成功后即可跳转到聊天对话界面</li>\n<li>然后在底部的输入框中输入文字/语音，然后发送便可进行对话</li>\n</ol>'),
                                                                        (431,	0,	0,	'<p><span class=\"accentTextColor\">小悟空原是字节跳动推出的综合类搜索引擎“悟空搜索”，现已更名并转型为 AI对话助手和个人助理。</span>通过与小悟空对话，可以看出其内核是与字节此前推出的 豆包 AI聊天机器人同款<span class=\"accentTextColor\" style=\"font-size: 1rem;\">，但相比豆包提供了更多开箱即用的预设工具，支持智能对话和多种内容创作功能。</span></p>\n<h2>小悟空的产品功能</h2>\n<p><span style=\"font-size: 1rem;\">从其官网的展示来看小悟空除提供免费AI对话外，还提供了10余项分类的数十种智能工具，包括创作助手、创意生成、实用写作、学习帮手、语言翻译、职场助手、效率办公、广告营销、生活助手、AI专家、儿童成长、虚拟人物、趣味测试、书籍电影推荐等功能，以满足用户的工作、生活娱乐诉求。</span></p>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/753532f542df814.png\"  alt=\"悟空AI助手\" width=\"800\" height=\"450\">\n<h2>小悟空的支持平台</h2>\n<p>目前小悟空支持网页端直接访问使用，也可以从App Store和各大安卓应用商店下载移动程序使用。</p>\n<ul>\n<li>网页版地址：https://wukong.com/tool</li>\n<li>苹果App Store：https://apps.apple.com/cn/app/小悟空-你的专属ai工具库/id1607244485</li>\n<li>Android（腾讯应用宝）：https://sj.qq.com/appdetail/com.wukong.search</li>\n</ul>\n<h2>如何使用小悟空网页版</h2>\n<ol>\n<li>访问小悟空的官网，点击左下角的立即登录</li>\n<li>使用手机号/抖音号登录或注册，登录成功后就可以开始使用啦</li>\n<li>可以点击内置的工具进行特定的任务，或者直接与小悟空进行对话</li>\n</ol>'),
                                                                        (432,	0,	0,	'<p>8 月 31 日，智谱 AI 正式上线首款生成式AI 助手 —— 「<strong>智谱清言</strong>」。该助手基于智谱 AI 自主研发的中英双语对话模型 ChatGLM2，经过万亿字符的文本与代码预训练，并采用有监督微调技术，以通用对话的形式为用户提供智能化服务。</p>\n<p>「智谱清言」作为用户的智能对话助手，可在工作、学习和日常生活中为用户解答各类问题，完成各种任务。目前，智谱清言已具备“通用问答、多轮对话、创意写作、代码生成以及虚拟对话”等丰富能力，未来还将开放多模态等生成能力。</p>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/e6eb41dbd4fc880.png\"  alt=\"智谱清言AI对话\" width=\"800\" height=\"455\">\n<p>「智谱清言」已在各大应用商店上线，用户可通过苹果商店 App Store、安卓主流商店（包括华为、OPPO、vivo 及小米等）进行下载，或在微信小程序中搜索「智谱清言」体验其功能。</p>\n<p>在「智谱清言」上，用户可随时随地享受更智能、更便捷、更高效的个性化内容获取。智谱 AI 将继续以用户为核心，持续完善产品与服务，为广大用户带来更丰富的人工智能产品体验。</p>'),
                                                                        (433,	0,	0,	'<p>豆包是字节跳动最新推出的免费AI对话工具，提供网页端、iOS和Android端应用程序，可使用手机号和抖音账号登录。据悉，豆包 APP 也就是此前字节内部代号为“Grace”的 AI 对话项目，用户可访问官网免费注册体验。目前测试期的豆包还存在局限，生成的内容也可能不准确。</p>\n<h2>如何使用豆包</h2>\n<ol>\n<li>访问豆包的官网，点击开始聊天或者下载应用</li>\n<li>输入手机号或使用抖音账号注册登录，无需等待</li>\n<li>登录成功之后便会自动跳转到对话界面</li>\n<li>在左侧选择对应的角色，然后在输入框进行对话即可</li>\n</ol>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/3cd8da82d48163b.png\"  alt=\"豆包的官网\" width=\"800\" height=\"450\">\n<h2>豆包的产品功能</h2>\n<p>豆包目前提供四个不同的AI聊天机器人：</p>\n<ul>\n<li>豆包。豆包的主要功能是回答用户的问题，提供有用的信息和帮助。其训练数据来自互联网上的大量文本，包括新闻、博客、小说、论文等。通过对这些数据的学习和分析，豆包可以理解自然语言并回答各种问题，包括历史、科学、技术、文化、娱乐等方面的问题。</li>\n<li>超爱聊天的小宁。小宁同样是是由字节跳动开发的人工智能，和豆包是两个不同的团队开发的。虽然他们的功能和应用场景可能会有所不同，但都致力于为用户提供高质量的服务和体验。</li>\n<li>英语学习助手。AI 英语学习助理，可以和用户一起练习英语，如学习日常生活中常见的英语短语、英语俚语、使用英语扮演一个客户服务场景。</li>\n<li>全能写作助手。文案创作助手，可以进行如歌词、诗歌、餐厅评价、代码示例的生成和撰写。</li>\n</ul>'),
                                                                        (434,	0,	0,	'<blockquote><p>9月13日更新：今天，阿里云宣布通义千问大模型已首批通过备案，并正式向公众开放，广大用户可登录通义千问官网体验，企业用户可以通过阿里云调用通义千问API。</p></blockquote>\n<p>4月7日，阿里在AI大模型领域的研究成果终于亮相，阿里云宣布自研大模型“通义千问”开始邀请用户测试体验，这也是继百度的文心一言之后国内又一家巨头启动AI大模型邀测。</p>\n<p>通义千问的官网是qianwen.aliyun.com，打开网址后，可以看到它的自我介绍：“我是通义千问，一个专门响应人类指令的大模型。我服务于人类，致力于让生活更美好。我是效率助手，也是点子生成机”。</p>'),
                                                                        (435,	0,	0,	'<p>Kimi Chat是国内人工智能初创公司Moonshot AI（月之暗面）推出的智能对话助手，支持输入长达20万汉字的上下文。Kimi Chat擅长中文和英文的对话，可以帮助用户解决各类生活和工作中的问题、提供实用的信息和参考建议。</p>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/18b40f87e056a.png\"  alt=\"Moonshot Kimi Chat助手\" width=\"800\" height=\"500\">\n<h2>Kimi Chat的主要功能</h2>\n<ol>\n<li>回答问题：回答各种问题，包括日常生活、科技、教育、娱乐等领域的问题</li>\n<li>提供建议：提供关于各种主题的建议，例如旅行、购物、饮食等</li>\n<li>语言翻译：翻译中文和英文之间的文本</li>\n<li>知识查询：提供有关历史、地理、科学等主题的知识</li>\n<li>计算和数学问题：解决数学问题，例如计算、单位换算等</li>\n<li>日程安排和提醒：安排日程、设置提醒和提醒您即将到来的事件</li>\n<li>网址和文件阅读：用户可以发送网址或文件，AI会阅读相关内容并回复问题</li>\n</ol>\n<h2>常见问题</h2>\n<div id=\"accordion\" style=\"max-width: 650px;\">\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i>Kimi Chat 基于什么大模型？</div>\n<div class=\"card-body text-sm\">Kimi Chat 基于 Moonshot AI 自研的千亿参数大模型，支持高达20万汉字的上下文窗口。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i>Kimi Chat 支持阅读文件吗？</div>\n<div class=\"card-body text-sm\">Kimi Chat 支持上传 pdf、doc、xlsx、ppt、txt 等格式的文件，并允许用户就文件内容提问。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i>Kimi Chat 是免费的吗？</div>\n<div class=\"card-body text-sm\">Kimi Chat 目前是免费向用户开放的，暂未推出付费版本。</div>\n</div>\n</div>'),
                                                                        (436,	0,	0,	'<p>Grok 是马斯克旗下的xAI公司最新推出的人工智能助手，一个与 ChatGPT 类似的聊天机器人，关键的区别之处在于 Grok 可以实时访问 𝕏（原Twitter）数据，可以为用户提供最新且独特的信息。</p>\n<h2>Grok 的功能和特色</h2>\n<ul>\n<li>回答任何问题，解决用户疑问并生成创造性的文本格式，如诗歌、代码、脚本和邮件</li>\n<li>独特个性，相比于其他的聊天机器人，Grok的回复更具“幽默感”</li>\n<li>与 𝕏 （原Twitter）平台对接，可实时获取该社交平台最新状态</li>\n<li>充当强大的研究助手，帮助用户快速访问相关信息、处理数据并提出新想法</li>\n</ul>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/02ea5651d95566d.png\"  alt=\"Grok AI聊天机器人\" width=\"800\" height=\"478\">\n<h2>关于 Grok 的常见问题</h2>\n<div id=\"accordion\" style=\"max-width: 700px;\">\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>Grok 单词的含义？</strong></div>\n<div class=\"card-body text-sm\">“Grok”一词源于罗伯特·海因莱因的科幻小说《异乡异客》，意思是深入、直观地理解某事物。在技​​术和极客文化中，“Grok”通常用来描述对某个主题或系统的直观理解或同理心。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>Grok 基于什么大模型？</strong></div>\n<div class=\"card-body text-sm\">Grok 的对话能力基于 xAI 团队自研四个月的名为 Grok-1 大模型，初始版本的 Grok-1 可以处理 8192 个 token 的上下文长度。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>Grok 支持多模态吗？</strong></div>\n<div class=\"card-body text-sm\">目前 Grok 还只能处理文本，不能识别视觉和听觉等其他模态。后期，xAI 将会为 Grok 配备不同的模态，以实现更广泛的应用，包括实时交互和帮助。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>如何使用 Grok？</strong></div>\n<div class=\"card-body text-sm\">Grok 暂时还是一个处于早期的测试版本，xAI 正在邀请数量有限的美国地区用户来测试 Grok AI 原型。马斯克称将把它作为 𝕏 Premium+ 会员的一部分提供。未来几个月，Grok 还会推出新的功能和特性，开放使用还需等待。</div>\n</div>\n</div>'),
                                                                        (437,	0,	0,	'<p>紫东太初是由中科院自动化所和武汉人工智能研究院联合推出的一个全模态大模型，它是在千亿参数多模态大模型“紫东太初1.0”基础上升级打造的2.0版本。紫东太初大模型支持多轮问答、文本创作、图像生成、3D理解、信号分析等全面问答任务，具有强大的认知、理解、创作能力，能够带来全新的互动体验。</p>\n<img  class=\"alignnone size-full rounded shadow-sm\" src=\"/uploadfile/202312/5ccc969a5386a79.png\"  alt=\"紫东太初\" width=\"800\" height=\"450\">\n<h2>紫东太初的主要功能</h2>\n<h4>一、图像能力</h4>\n<ol>\n<li>图像描述：基于用户上传的图片素材，准确理解并回答图片识别类问题</li>\n<li>目标检测：支持丰富品类的目标检测任务，能够判定目标类型、数量和对应的位置信息</li>\n<li>图像检索：基于海量的高质图片素材库，能为用户搜索出关联度高的精致图片素材</li>\n<li>图像生成：针对用户指令诉求，生成对应的精致图片，并可以修改描述微调图片内容</li>\n<li>文字识别：基于图片内容，支持多场景、多语种、高精度的文字检测与识别服务</li>\n</ol>\n<h4>二、语言能力</h4>\n<ol>\n<li>中文问答：准确理解用户输入的问题语境，并能做出准确的知识性问答</li>\n<li>文本续写：基于用户输入的故事引导自动续写丰富故事内容</li>\n<li>文本创作：准确理解用户输入意图,并生成语意连贯、逻辑通顺的文本内容</li>\n<li>标题生成：基于对文章或者长文本的理解，快速聚合生成精简且概括的标题文案</li>\n<li>语法分析：准确理解并分析中英文句子的语法，提醒语法错误并修改等</li>\n<li>机器翻译：帮助用户翻译各类型文本素材，包括中英文互译、文言文和白话文互译等</li>\n<li>古诗创作：基于用户给到的主题或引导内容即兴创作诗歌、绝句等</li>\n<li>代码理解：理解C语言、Python、JAVA等绝大部分编程语言、算法和数据结构，快速给出所需的解答</li>\n<li>代码编写：能帮助用户快速编写简单的代码片段，例如函数、类或循环等</li>\n<li>数学计算：既能处理常规数学计算问题，也能处理如《孙子算经》上记录的鸡兔同笼数学应用问题等</li>\n<li>逻辑推理：支持处理复杂的逻辑推理类问题，包括科学推理、常识推理、时空推理等</li>\n</ol>\n<h4>三、视频能力</h4>\n<ol>\n<li>视频描述：基于用户上传的视频素材，准确理解并回答视频识别、视频描述类问题</li>\n<li>视频检索：基于海量的高质视频素材库，能为用户搜索出关联度高的精致视频素材</li>\n<li>视频问答：基于用户上传的视频素材，准确理解并回答视频相关的问题，同时支持上下文信息理解和多轮问答</li>\n</ol>\n<h4>四、音乐能力</h4>\n<ol>\n<li>音乐生成：通过给定的文本提示可控生成高保真的音乐，并支持即兴创作多种风格类型和多种乐器演奏的音乐</li>\n<li>音乐多模问答：基于对用户上传的音乐素材的理解，可完成相关多模态问答任务</li>\n</ol>\n<h4>五、音频能力</h4>\n<ol>\n<li>音频鉴伪：紫东太初能判断当前音频是真人说话还是机器合成</li>\n<li>音频事件分类：可检测当前音频中所包含的声音事件类型，目前支持11种单一声音事件和混合声音事件</li>\n<li>语音识别：可将语音快速准确识别为文字，支持手机应用语音交互、语音内容分析多个场景</li>\n<li>语音合成：提供高度拟人、流畅自然的语音合成服务，满足文本阅读、语音播报等各类型场景需求</li>\n</ol>\n<h4>六、3D能力</h4>\n<ol>\n<li>3D场景描述：紫东太初2.0具备基于点云数据的3D场景理解和物体感知能力</li>\n</ol>\n<h4>七、信号类能力</h4>\n<ol>\n<li>信号识别：支持雷达信号鉴别与知识交互，可借助模型快速掌握信号基本来源及参数等</li>\n</ol>\n<h2>如何使用紫东太初</h2>\n<ol>\n<li>访问紫东太初的官网（taichu-web.ia.ac.cn），点击对话体验</li>\n<li>登录/注册你的账号，申请使用登录成功后便会自动跳转到对话界面</li>\n<li>输入你的问题或者输入斜杠选择推荐提示指令（你也可以选择内置的示例查看），然后点击发送</li>\n<li>紫东太初便会智能回答你的问题</li>\n</ol>\n<h2>常见问题</h2>\n<div id=\"accordion\" style=\"max-width: 700px;\">\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>紫东太初如何申请试用？</strong></div>\n<div class=\"card-body text-sm\">访问紫东太初的官网，在登录界面点击注册，输入“用户名”、“昵称”、“密码”、“手机号”等信息提交注册账号申请，等待后台审核通过后便可以免费使用体验。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>紫东太初支持上传文件吗？</strong></div>\n<div class=\"card-body text-sm\">紫东太初支持用户上传图片、视频、点云、音频、音乐、信号的文件，并可进行针对性对话问答。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>紫东太初通过生成式AI备案了吗？</strong></div>\n<div class=\"card-body text-sm\">紫东太初大模型已于2023年8月首批通过《生成式人工智能服务管理暂行办法》备案，可正式上线面向公众提供服务。</div>\n</div>\n</div>'),
                                                                        (438,	0,	0,	'<p>Claude是ChatGPT最为有力的竞争对手之一，目前可以通过Anthropic官网加入等候列表，但是等待时间较长，站长这边申请大概两周左右通过的，如果你迫不及待的想试试Claude，可以通过Slack版Claude应用或Poe集成的Claude聊天机器人使用Claude。</p>'),
                                                                        (439,	0,	0,	'<p>2月6日，谷歌宣布了名为Bard的AI聊天机器人，作为ChatGPT的对手，旨在模拟与人类的对话，并结合使用自然语言处理和机器学习来对你可能提出的问题提供真实而有用的回答。</p>\n<p>3月21日，谷歌推出了Bard聊天机器人试验版本，作为一个通用聊天机器人，目前Google暂未将Bard与搜索引擎结合，而是独立于 Google 的常规搜索界面，该聊天机器人可以为每个查询提供三个答案。你可以通过bard.google.com访问，点击Join Waitlist按钮加入等待列表。</p>\n<p>5月11日，Google I/O 大会召开，会上Google宣布对Bard进行一系列的更新，包括</p>\n<ul>\n<li>迁移到功能更强大的大语言模型 PalM2</li>\n<li>取消等候名单，向 180 多个国家和地区开放；</li>\n<li>新增图片问答，对话更加直观；</li>\n<li>整合 Adobe Firefly，快速生成图片；</li>\n<li>来源引用、深色模式、代码导出按钮等</li>\n</ul>'),
                                                                        (440,	1,	5,	'<p>钉钉·个人版正式启动内测，所有用户皆可在钉钉官网申请加入测试，实测申请速度只需几分钟，其个人空间是基于钉钉收购的「wolai我来」在线协同文档并结合阿里的AI大模型打造而来。据介绍，钉钉个人版以AI为核心，提供“贾维斯”文生文AI和“缪斯”文生图AI。用户可通过自然语言对话，解答各种问题、制定策划方案或者绘画。</p>\n<h2>钉钉·个人版的AI功能</h2>\n<ol>\n<li>AI文档创作助手：在个人文档空间中，输入/ai即可召唤出AI助手，进行AI写作、文章大纲撰写、内容简介创作、小红书种草笔记、短视频脚本、电子邮件、广告文案、短篇故事、周会汇报、职位描述、待办清单等。</li>\n<li>贾维斯AI对话助手：基于通义千问大模型，贾维斯智能助手可以随时为你解答各种问题，并内置了常用指令，支持创建自定义指令。</li>\n<li>缪斯AI绘图：基于通义万相图像生成大模型，缪斯AI可以进行人像、摄影、游戏、插画、科幻、建筑、中国风等风格的AI图片生成，同样支持创建自定义指令</li>\n</ol>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/e3deba63fca42e6.png\"  alt=\"钉钉个人版AI功能\" width=\"801\" height=\"501\">\n<h2>如何使用钉钉·个人版</h2>\n<ol>\n<li>访问钉钉·个人版的官网，点击申请体验按钮</li>\n<li>使用手机版钉钉扫描二维码即可申请，等待几分钟，刷新网站，若右上角显示已获取资格便说明可以使用</li>\n<li>申请通过后可以在官网下载Mac/Windows桌面端软件，或直接访问workspace.dingtalk.com在线使用AI文档功能</li>\n<li>若要使用贾维斯和缪斯，则需要在桌面端软件使用，点击左侧的AI按钮，然后选择对应功能即可</li>\n</ol>'),
                                                                        (441,	0,	0,	'<p>微软必应（Bing）是一款由微软公司推出的搜索引擎应用，能够为用户提供快速、准确的搜索体验。New Bing（新必应）采用 Open AI 的 GPT-4 大语言模型技术驱动，为用户提供对话生成式的全新AI搜索体验。与旧版必应相比，新版必应更加智能化和人性化，采用了先进的自然语言处理和机器学习技术，能够更好地理解用户的搜索意图和需求，并返回更加方便、准确、相关的结果。</p>'),
                                                                        (442,	0,	0,	'<h2>ChatGPT是什么</h2>\n<p>ChatGPT是由OpenAI公司推出的火爆全球的聊天对话机器人，该AI聊天对话工具建立在OpenAI开发的GPT-4语言模型上，它可以执行各种自然语言处理（NLP）任务，如总结、分类、提问和回答，以及类似人类反应的错误纠正。ChatGPT是一项革命性的技术，通过将人们的工作效率提高到一个新的水平，使人们的生活更加轻松。</p>\n<h2>ChatGPT由谁开发</h2>\n<p>ChatGPT人工智能聊天机器人是由OpenAI开发和拥有的，Elon Musk和Sam Altman在2015年将其作为一家非营利性公司创立。2018年，马斯克从OpenAI中撤出，不再拥有OpenAI的股份。起初，该公司从硅谷风险资本家那里获得了10亿美元，以启动构建神经网络。</p>\n<p>2019年，OpenAI从微软那里筹集了10亿美元的第二轮资金。他们开始使用Azure超级计算机来构建这些大型语言模型。快进到2023年，微软向OpenAI投资了100亿美元，使其总股份达到49%。其他投资者，包括Khosla Ventures，又占了49%，而OpenAI只保留了2%的股权。</p>\n<h2>ChatGPT是如何工作的</h2>\n<p>在ChatGPT之前，人工智能聊天机器人就已经出现了，但由于它们不是对话式的，所以并未引起人们的普遍关注。而在2017年，谷歌在他们的论文《Attention is All You Need》中介绍了一个名为The Transformer的神经网络架构，这创造了一个训练大型语言模型（LLM）的范式转变。</p>\n<p>与其他神经网络相比，循环神经网络（RNN）和长短期记忆网络（LSTM）都比不上Transformer网络。RNN在长期依赖性方面存在问题，而LSTM无法专注于长句中的正确单词以获得正确的输出。</p>\n<p>而Transformer网络改变了语言模型的训练方式，Transformer不像RNN那样一次处理一个词，而是可以一次注入整个输入。此外，Transformer允许平行运行多个输入，减少计算成本，训练速度更快。</p>\n<p>意识到Transformer的潜力后，OpenAI决定利用Transformer网络，并按照其架构进行数据训练。这些模型的训练过程主要包括三个步骤：生成式预训练（Generative pre-training）、监督微调（Supervised fine-tuning）、基于人类反馈的强化学习（RLHF）。</p>\n<h2>如何使用ChatGPT</h2>\n<p>ChatGPT有一个基础版本，可以免费使用，要使用ChatGPT，你只需要访问他们的官方网站（<strong>https://chat.openai.com/chat</strong>），无需下载，去ChatGPT页面登录即可，你可以选择邮箱注册或用你的谷歌或微软账户登录。</p>\n<p>ChatGPT的网页界面对所有用户来说都很容易使用，显示界面包括一个供用户输入查询的文本框和一个显示结果的区域。输入你的文字提示后，然后你就会收到ChatGPT返回的回应信息。</p>'),
                                                                        (443,	0,	0,	'<p>网页版 Copilot 是微软在 2023 Ignite 技术大会上最新推出的在线使用 Microsoft Copilot 助手和聊天机器人的版本，不再只限定在微软的Bing、Skype或其他Office软件应用中才能体验，以便于电脑桌面端用户直接在浏览器中体验 Copilot 的 AI 聊天服务。</p>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/34bb95d30251f49.png\"  alt=\"Copilot网页版\" width=\"800\" height=\"450\">\n<h2>Copilot的主要功能</h2>\n<ol>\n<li>搜索信息：查找网络上的信息，无论是关于新闻事件、科学事实、历史事件，或是其他任何主题。</li>\n<li>回答问题：回答各种问题，包括但不限于一般知识问题、数学问题、地理问题等。</li>\n<li>内容创作：可以生成各种创新和富有想象力的内容，如故事、诗歌、代码、歌曲、名人模仿等。</li>\n<li>写作帮助：可以帮助撰写、重写、改进或优化文章内容。</li>\n<li>生成图像：根据输入的提示描述生成各种类型的图片和图形艺术作品。</li>\n<li>错误反馈：无论用户是否明确反馈，Copilot可以识别对话中的错误并通过向用户道歉且提供准确信息来纠正错误。</li>\n</ol>\n<h2>常见问题</h2>\n<div id=\"accordion\" style=\"max-width: 700px;\">\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>Copilot支持哪些浏览器？</strong></div>\n<div class=\"card-body text-sm\">Copilot目前只支持基于Chromium内核的浏览器，如谷歌Chrome浏览器、微软Edge浏览器，暂不支持Firefox火狐浏览器，也不支持Safari浏览器，后续可能会开放更多浏览器支持。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>Copilot可以在移动端使用吗？</strong></div>\n<div class=\"card-body text-sm\">Copilot目前没有移动端APP，也无法在移动端的浏览器使用，若想要在移动端体验Copilot的能力，推荐使用Bing版移动端。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>Copilot与Bing Chat有区别吗？</strong></div>\n<div class=\"card-body text-sm\">事实上Copilot与Bing Chat没有什么不同，只是名字和网站外表不同。与其对话，Copilot的回应还自称自己是Bing Chat。</div>\n</div>\n</div>'),
                                                                        (444,	0,	0,	'好莱坞也在用的AI视频颜色分级工具'),
                                                                        (445,	0,	0,	'无水印AI视频背景移除'),
                                                                        (446,	0,	0,	'人工智能文字到视频生成'),
                                                                        (447,	0,	0,	'Veed推出的AI视频背景移除工具'),
                                                                        (485,	0,	0,	'在线设计工具Canva推出的AI图像生成工具'),
                                                                        (486,	0,	0,	'<p>Freepik AI Image Generator是由知名创意素材（视频、照片、插画等）网站Freepik最新推出的在线AI图片生成工具，该AI图片生成器允许用户使用文字创建独特的图像，只需要在输入框中输入文本描述，就可以得到对应艺术风格的令人惊叹的图像。</p>\n<h2>Freepik AI Image Generator的主要功能</h2>\n<ol>\n<li>操作简单，任何人都可以输入想法释放创造独特图像的无限潜力，为艺术、设计和创造力开辟新的可能性</li>\n<li>灵感参考，主页提供了系列不同风格的AI生成的图片，并附带相应的prompt提示词参考，帮助用户快速生成想要的图片</li>\n<li>内置4种不同风格，写实照片、数字艺术、插画和3D风格的图片生成，都不在话下</li>\n<li>图片二次编辑和加工，AI生成好的图片，可点击Edit Online对其进行在线编辑，如裁剪、翻转、旋转、添加文本/元素、修改对比度/亮度/饱和度等</li>\n</ol>\n<h2>如何使用Freepik AI Image Generator</h2>\n<ol>\n<li>访问Freepik AI Image Generator的官网</li>\n<li>在输入框中输入你想要生成的图片描述，选择风格，点击Generate按钮</li>\n<li>若没有登录注册会自动跳转到Freepik的登录界面</li>\n<li>登录注册成功后，会自动进入到图片生成的界面，Freepik会默认生成4张备选的图片</li>\n</ol>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/34f5b5054f801.png\"  alt=\"Freepik AI Image Generator\" width=\"800\" height=\"450\">\n<h2>Freepik AI Image Generator的产品价格</h2>\n<p>Freepik AI Image Generator允许用户每日免费进行3次的图片生成，每次的生成会提供4张的备选图片方案。若你想要更多次数的图片生成，需要付费升级到Premium计划，按月付费每月8.99欧元，按年付费每年107.88欧元。Premium计划每天可进行10次的图片生成，除开AI图片生成外，还可以无限次数的下载Freepik平台上的资源素材。</p>'),
                                                                        (487,	0,	0,	'<h2>Pic Copilot是什么</h2>\n<p>Pic Copilot是阿里巴巴国际站团队推出的AIGC商品营销图制作工具，该AI电商作图工具是为跨境电商量身定做的神器，基于阿里巴巴国际站的海量外贸商品信息数据库，训练出了能凸显商品独特竞争力和卖点的图像模型，只需上传卖家自己的商品图，即可快速生成满足各个场景且高点击率的商品营销图，帮助跨境电商和海外商家提升商品点击率。</p>\n<img  class=\"alignnone size-full rounded shadow-sm\" src=\"/uploadfile/202312/44c9ae6d121f201.png\"  alt=\"Pic Copilot\" width=\"794\" height=\"450\">\n<h2>Pic Copilot的主要功能</h2>\n<ol class=\"text-md\">\n<li>AI生成商品营销图：提供多种营销风格、不同行业类目和尺寸的模板，点击一键即可生成商品营销图</li>\n<li>AI一键抠图：上传商品图，AI一键帮你智能抠图，保留产品主体，去除杂乱的背景，方便二次编辑</li>\n<li>AI图片翻译：上传图片，AI智能识别图片内容并保持原有图片版式并将文字翻译成想要的目标语言</li>\n<li>AI背景图生成：只需上传产品图，Pic Copilot即可将商品背景更换为带有光影和质感的专业背景</li>\n<li>AI模特换肤：使用有版权的专属模特替换原始图片中的模特，轻松更换模特服装和造型（即将上线）</li>\n</ol>\n<h2>Pic Copilot的适用人群</h2>\n<ol class=\"text-md\">\n<li>跨境电商设计：适合跨境电商企业平面设计师生成商品营销图概念和初稿，提升效率</li>\n<li>中小外贸商家：对于预算有效的中小外贸商家，Pic Copilot可节省预算</li>\n<li>外贸SOHO：对于在家办公的独立外贸人，Pic Copilot可帮助独立卖家快速专业进行图片处理</li>\n</ol>\n<h2>常见问题</h2>\n<div id=\"accordion\" style=\"max-width: 700px;\">\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>Pic Copilot是免费的吗？</strong></div>\n<div class=\"card-body text-sm\">Pic Copilot是向用户完全免费开放的，无需付费，注册即可使用。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>Pic Copilot支持生成什么尺寸的营销图？</strong></div>\n<div class=\"card-body text-sm\">Pic Copilot支持生成1080*1080、1200*628、750*1000等尺寸的营销图。</div>\n</div>\n</div>'),
                                                                        (488,	0,	0,	'<p>画宇宙是由「Nolibox 计算美学」推出的人工智能AI作画网站，该平台集成全球新兴的 AIGC 技术，赋予用户随心所欲、自然流畅、高能硬核的AI创作力量，致力于——让每个人都能享受无限的 AIGC 创作乐趣与创作成就。</p>\n<h2>画宇宙的特色功能</h2>\n<ol>\n<li>支持多源图像生成模型，包括画宇宙系列模型、百度文心 AI 绘画大模型、Draft、社区大模型等多种模型</li>\n<li>支持文本描述生成图像和图像生成图像（垫图生成和相似图生成）</li>\n<li>图片智能编辑和操作，可以允许用户一键智能抠图、物体抹除和替换</li>\n<li>提供海量的高质量prompt词库，不同类型的艺术家、艺术风格、细节词和负面词等</li>\n</ol>\n<h2>如何使用画宇宙进行AI作画</h2>\n<p>画宇宙的使用很简单，只需在电脑或手机中访问其官网，然后按照下面的操作步骤即可：</p>\n<ol>\n<li>在网站主页点击<strong>开始创作</strong>按钮</li>\n<li>微信扫码关注弹出的公众号即可注册/登录</li>\n<li>系统会检测是否已绑定手机号，在电脑上输入手机号，获取验证码，完成手机验证</li>\n<li>开始进行创作，点击左侧的<strong>生成</strong>菜单，然后选择对应的模型、输入文本描述、选择风格艺术家和尺寸后，点击<strong>生成并添加</strong>按钮即可。</li>\n</ol>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/031e14240af090b.png\"  alt=\"如何使用画宇宙\" width=\"800\" height=\"466\">\n<h2>画宇宙的产品价格</h2>\n<p>画宇宙的用户可以免费获得100个画力星，用户注册后首次登录可以获得画宇宙额外免费赠送的30个画力星。如果你想要更快的生成速度，可以考虑开通付费会员，付费会员可以进行不限次数的海量生成，并且算力加速不排队。</p>\n<ol>\n<li>当日会员试用，2.8元一天24小时内无限生成</li>\n<li>单月会员，58元一个月</li>\n<li>全年会员，599元一年。</li>\n</ol>'),
                                                                        (489,	0,	0,	'<p>Adobe于3月21日推出了名为Adobe Firefly的创意生成AI模型，类似于DALL-E或Midjourney，可以仅使用文本提示即可AI生成图像。Adobe 表示，该模型仅针对获得许可或不受版权保护的内容进行训练，而不是来自互联网艺术家的作品。</p>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/882466bcbc0d373.jpeg\"  alt=\"Adobe Firefly宣布\" width=\"400\" height=\"400\">\n<p>在其官方推特中，Adobe声称其使命是更好地帮助各种创意人士改变他们想象、创造和工作的方式，于是推出了Adobe Firefly：</p>\n<ul>\n<li>Adobe Firefly是全新的系列创意生成 AI 模型，它提供了构思、创作和交流的新方法，同时显著改进了创意工作流程。</li>\n<li>作为也是创作者的Adobe，其将Adobe Firefly视为一种通过基于文本的图像生成和编辑来补充他们的创作过程的方式。</li>\n<li>虽然Adobe Firefly最终将由多个模型组成，但它的第一个模型是在Adobe Stock，以及版权已过期的公开许可和公共领域的内容上训练的。</li>\n<li>Adobe Firefly目前将作为独立测试版提供以获得用户反馈。根据后续的反馈，Adobe接下来打算将Firefly引入 Adobe Express和AEM，并推出更多创意应用程序。</li>\n</ul>'),
                                                                        (490,	0,	0,	'<p>6pen Art 是一个基于 AI 驱动的技术，利用文本生成绘画作品的AI图像生成工具。用户可以通过文字描述画面内容和风格，就可以得到和生成天马行空，令人惊艳的作品和画面（最高支持4K分辨率）。用户可以通过在线网站、iOS或Android应用程序访问并使用6pen Art。</p>\n<h2>6pen Art 的主要功能</h2>\n<ul>\n<li>不同风格的图像生成。6pen Art 支持用户通过纯文字输入或参考图生成不同风格的艺术画图像，如人像、CG渲染、赛博朋克、动画动漫、肖像画、简笔画等等任何风格和题材。</li>\n<li>易于使用。任何人都可轻易使用的 6pen Art 的 AI技术，将你的绝妙想法快速转化成看得见的图像，并在6pen社区中获得展示，点赞和更多潜在收益</li>\n<li>提供多种模型。DiscoDiffusion, StableDiffusion，以及6pen自研小模型，未来还将支持更多模型，为用户提供丰富的生成选择</li>\n<li>支持中文。支持中文提示和描述（prompt），上手更容易，当然英文也没问题</li>\n<li>不保留版权。6pen 不保留版权，由你用户成出的作品，如无特殊情况，版权都归属于生成者或CC0协议。自用，商用，当头像用，随意怎么用。</li>\n</ul>\n<h2>如何使用 6pen Art 生成AI图像</h2>\n<p>登录/注册 6pen Art 后，自动会进入工具台，点击页面下方的圆形<strong>+</strong>按钮，进入任务创建页面，填写：</p>\n<ul>\n<li>画面描述</li>\n<li>画面类型</li>\n<li>风格修饰/艺术家</li>\n<li>模型选择</li>\n<li>通道选择</li>\n</ul>\n<p>如果你选择西瓜模型，则还可以配置分辨率和参考图的选项。</p>\n<p>根据以上的选择，6pen Art 会自动计算出消耗的点数，点击「生成」按钮，即可创建一个AI图像生成任务。</p>\n<h2>6pen Art 的产品价格</h2>\n<p>6pen Art 在充分满足用户的使用需求的同时，提供了两种明确清晰且透明的定价计划，以更好的为 AI 艺术家们提供服务，即「免费通道」和「Pro通道」。</p>\n<ul>\n<li>对于免费通道，用户可以每天免费使用西瓜模型(无论大小)5次，南瓜模型和Stable Diffusion模型次数无限制，其中大西瓜模型因过于耗时而限制了生成图片的尺寸，小西瓜不受影响。</li>\n<li>对于Pro付费通道，用户的等待时间较短，每次生成图片则会消耗对应的点数（5 元 20点数，30 元 200点数，100 元 800点数，500 元 5000 点数），不同模型和不同分辨率的图片会消耗不同的点数，\n<ul>\n<li>南瓜模型：2点数</li>\n<li>西瓜模型：8点数</li>\n<li>西瓜模型(大模型版)：12点数</li>\n<li>西瓜模型(人像优化版)：6点数</li>\n<li>Stable Diffusion 模型：2点数</li>\n</ul>\n</li>\n</ul>\n<h2>常见问题</h2>\n<p>6pen Art 由哪家公司开发？</p>\n<p>6pen Art 是由北京毛线球科技有限公司（面包多背后的团队）于 2022 年 4 月推出的一个在线的AI图片生成工具，累计已经为超过 100 万用户生成过上亿张好看的图片。</p>\n<p>6pen Art 是免费的吗？</p>\n<p>6pen Art 的免费通道可供用户每日生成有限次数的AI图片，等待时间在20秒到12分钟之间，用户通过成为认证创作者和邀请其他用户，可以获得免费赠送的额外点数。</p>\n<p>6pen Art 生成的图片版权归属？</p>\n<div data-page-id=\"doxcnmWzSJih4xKZwePFuOGfqke\" data-docx-has-block-data=\"false\">\n<div class=\"ace-line ace-line old-record-id-doxcna4uUYWWKECiAvfKCd8Uvbt\">6pen Art 使用的 南瓜、西瓜模型，都采用 MIT 协议开源，在此基础上进行了深度定制，并将生成出来的图片版权，完全授权给生成者本人，这意味着，由你生成的图片，如无意外情况，版权都归属于你。</div>\n</div>'),
                                                                        (491,	0,	0,	'<p>AI创意工坊是网易云课堂官方推出的AI作画平台，基于Stable Diffusion，提供网页版的原生SD界面，无需本地安装配置环境，并提供丰富的模型和插件，帮助用户快速出图。</p>\n<h2>AI创意工坊的功能</h2>\n<ul>\n<li>在线一键使用Stable Diffusion，AI创作无压力。避免搭建环境的繁琐流程和算力配置的制约，原生SD使用页面， 更快出图，更多插件，让您把精力全部投放在AI绘画中。</li>\n<li>提供丰富的创作模型，轻松创作多种图片风格。如精致写实人像模型、游戏图标、服装模特、游戏动漫角色、景观设计、个性二维码、室内精准修等众多模型。</li>\n</ul>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/4c81232c877c688.png\"  alt=\"网易AI创意工坊\" width=\"800\" height=\"450\">\n<h2>如何使用AI创意工坊</h2>\n<ol>\n<li>访问网易云课堂AI创意工坊的官网</li>\n<li>点击开始创作，登录/注册你的网易账号</li>\n<li>然后再次点击开始创作或专业工坊，便会进入创作界面</li>\n<li>选择对应的模型、图片创作模式，并输入提示词</li>\n<li>调整相关的参数，然后点击生成按钮即可</li>\n</ol>\n<h2>AI创意工坊的价格</h2>\n<p>AI创意工坊提供免费和付费的版本，并提供不同的权限。</p>\n<ol>\n<li>体验权限，0元/月，可进行20次/日的绘画创作权限</li>\n<li>创作工匠，79元/月，专业工坊不限次数创作，400枚/月创作Studio水晶</li>\n<li>创作专家，249元/月，专业工坊不限次数创作，1200枚/月创作Studio水晶</li>\n<li>创作大师，499元/月，专业工坊不限次数创作，2400枚/月创作Studio水晶</li>\n</ol>'),
                                                                        (492,	0,	0,	'<p>创客贴AI画匠是在线平面设计创作神器「创客贴」推出的在线AI艺术画生成工具，用户只需输入关键词，便可以生成精美的插画，CG、彩绘、国画，油画等多样的画面风格自由生成，灵活多变。</p>\n<p>只需要输入一段带有画面描述特征的的文本并选择想要的尺寸，就可以一键生成图片。模型生成的图统一遵循 CC0 1.0 规则，用户可用作素材、海报、头像、壁纸等。</p>'),
                                                                        (493,	0,	0,	'<h2>LiblibAI·哩布哩布AI是什么</h2>\n<p>LiblibAI·哩布哩布AI是由北京奇点星宇科技推出的一个国内领先的AI图像创作绘画平台和模型分享社区，该平台提供在线Stable Diffusion图片生成功能和海量的模型素材库，旨在激发原创AI模型、图像素材的创作，为AI绘画探索更多可能。用户可以在LiblibAI上创作、分享、学习、交流关于AI绘画的模型和素材。</p>\n<img  class=\"alignnone size-full rounded-lg shadow-sm\" src=\"/uploadfile/202312/767f2a852451ba6.jpeg\"  alt=\"LiblibAI哩布哩布AI\" width=\"800\" height=\"450\">\n<h2>LiblibAI·哩布哩布AI的主要功能</h2>\n<ol class=\"text-md\">\n<li>在线Stable Diffusion WebUI图片生成：提供基于开源SD WebUI的在线网页版，支持文生图、图生图、图像后期处理等AI创作功能</li>\n<li>丰富的作品灵感和模型社区：平台上有用户分享的10万+AI模型和创作作品，包括摄影、写实、动漫、游戏、科幻、插画、平面设计、建筑、工业设计、时尚服装等不同风格和领域</li>\n<li>个人专属自定义LoRA模型训练：提供SDXL、人像、ACG、画风四个预设模式，用户只需上传对应数量的图片即可训练专属于自己的LoRA模型</li>\n</ol>\n<h2>如何使用LiblibAI生成图片</h2>\n<ol class=\"text-md\">\n<li>访问LiblibAI的官网（liblib.art），点击左侧的在线生图，然后登录/注册账号</li>\n<li>进入在线生图页面后，选择文生图/图生图，以文生图为例，输入提示词</li>\n<li>选择模型，调整图片宽高尺寸、生成数量等</li>\n<li>最后点击开始生图按钮，等待图片生成即可</li>\n</ol>\n<h2>LiblibAI的产品价格</h2>\n<ol class=\"text-md\">\n<li>免费版普通用户：每日上限300点算力，每日可免费生成约300张图片</li>\n<li>基础版VIP用户：35元连续包月，每月15000点算力，可生成约15000张图片，20GB云端存储，300次加速生图特权</li>\n<li>专业版VIP用户：70元连续包月，每月35000点算力，可生成约35000张图片，50GB云端存储，2000次加速生图特权</li>\n</ol>\n<img  class=\"alignnone size-full rounded-lg shadow-sm\" src=\"/uploadfile/202312/f27cce652ec8.jpeg\"  alt=\"LiblibAI的价格\" width=\"800\" height=\"430\">\n<h2>LiblibAI的适用人群</h2>\n<ol class=\"text-md\">\n<li>设计师：输入简单的文本提示，即可快速可视化设计概念</li>\n<li>画师：生成多种艺术风格的插画和角色设计，辅助视觉构思</li>\n<li>建筑师：创建建筑设计草图和初稿，探索项目的初步方向</li>\n<li>AI爱好者：了解如何更好的使用SD WebUI来创作图像绘画</li>\n</ol>\n<h2>常见问题</h2>\n<div id=\"accordion\" style=\"max-width: 700px;\">\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>LiblibAI是免费的吗？</strong></div>\n<div class=\"card-body text-sm\">LiblibAI提供免费版本，每日可免费生成约300张图片，对于普通用户来说基本已经够用了。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>LiblibAI基于什么模型？</strong></div>\n<div class=\"card-body text-sm\">LiblibAI基于Stable Diffusion模型，提供在线版的Stable Diffusion WebUI。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>LiblibAI生成的图片可以商用吗？</strong></div>\n<div class=\"card-body text-sm\">LiblibAI生成的图片可以商用，但要注意是使用该平台上有版权的模型和素材生成的图片。</div>\n</div>\n</div>'),
                                                                        (494,	0,	0,	'<p>堆友是阿里巴巴设计师团队原创的一个免费可商用3D头像、3D场景、3D元素等的资源网站和在线编辑神器，近期堆友上线了「AI反应堆」功能，帮助设计师、画手、大学生、兴趣爱好者快速生成高质量绘画，支持文生图、图生图和创作社区同款。</p>\n<h2>堆友AI反应堆的特色功能</h2>\n<ul>\n<li>大厂匠心出品：阿里设计师和开发团队精心打造的多风格AI绘画生成器</li>\n<li>零门槛可创作：无需绘画技能，也能轻松创作出与众不同的艺术作品</li>\n<li>免费轻松生成：只需一键操作，即可免费生成惊艳绘画作品</li>\n<li>风格多元供需：从抽象到写实，多款风格任你选择，满足不同创作需求</li>\n<li>AIGC大佬力荐 ：靠谱的轩轩、DynamicWang等AIGC行业大咖强烈推荐的AI绘画工具，让你的创意无限释放</li>\n</ul>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/ac3cb116927cbc9.jpeg\"  alt=\"堆友AI反应堆生成绘画\" width=\"800\" height=\"450\">\n<h2>如何使用堆友AI反应堆？</h2>\n<ol>\n<li>访问堆友AI反应堆的官网，点击开始创作按钮</li>\n<li>进入到作图界面后，选择模型风格、输入画面描述</li>\n<li>调节画面、图片比例、生成张数等参数</li>\n<li>然后点击立即生成按钮即可</li>\n</ol>\n<h2>堆友AI反应堆是免费的吗？</h2>\n<p>堆友AI反应堆目前来说是免费有限使用的，暂没有推出充值选项。堆友AI反应堆每次生成图片需要消耗一定数量的堆豆，标准尺寸的单张绘画生成，需要消耗5堆豆。通过堆友赠送的堆豆，已经够免费生成几十张图片了。</p>\n<ul>\n<li>新用户首次登录/注册后堆友会免费赠送50堆豆</li>\n<li>每日登录会赠送50堆豆</li>\n<li>关注公众号会赠送20堆豆</li>\n<li>邀请好友每邀请一位赠送50堆豆</li>\n<li>收藏网址到书签栏赠送50堆豆</li>\n<li>完善个人信息可获得20堆豆。</li>\n</ul>\n<h2>堆友可以生成哪些风格的绘画？</h2>\n<p>堆友AI反应堆目前支持生成怀旧日漫、厚涂插画、等距景观、赛博朋克、场景插画、风光摄影、清新写真、CG人物、水彩等风格的绘画，也会根据你输入的画面描述智能推荐和匹配。</p>'),
                                                                        (495,	0,	0,	'<p>WHEE是美图基于其视觉大模型MiracleVision最新推出的AI图片和绘画创作平台，该AI图片生成工具支持多种模式的图片创作，包括文生图、图生图、风格模型训练和创作提示词库。用户仅需输入简单的文字描述，即可将创意快速变为高质量的优秀画作。</p>\n<h2>WHEE的主要功能</h2>\n<ol>\n<li>AI文生图。用户只需输入提示词，AI便会帮你生成想要的画面。用户还可以选择和调整画面风格、画面尺寸、生成数量等参数。</li>\n<li>AI图生图。用户可以导入照片，在AI的帮助下将上传的图片转换成不同的风格。</li>\n<li>风格模型训练。WHEE还支持用户上传图片自定义训练自己的专属风格模型。</li>\n<li>AI创作词库。WHEE提供了一个中英文的提示词助手，帮助你精准匹配风格词，更加精确地生成满足自己需求的画面。</li>\n<li>局部修改。用户可以上传图片，使用画笔涂抹想要修改的区域，即可一键替换内容。</li>\n<li>画面扩展。上传图片即可扩展画面画幅尺寸，AI智能延伸创意空间</li>\n</ol>\n<h2>如何使用WHEE生成图片</h2>\n<ol>\n<li>访问WHEE的官网whee.com，选择文生图或者图生图（注意：请使用国内的网络访问，否则WHEE的网页可能会显示空白）</li>\n<li>登录/注册你的美图账号，登录成功后会自动跳转到AI创作界面</li>\n<li>在左边输入你的创意描述，并调整相应的选项和参数</li>\n<li>最后点击立即生成的按钮，等待生成完毕即可</li>\n</ol>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/a9423fca401829e.png\"  alt=\"WHEE生成图片\" width=\"800\" height=\"491\">\n<h2>WHEE的产品价格</h2>\n<ol>\n<li>免费版：新用户登录注册后即可获得20美豆用于生成图片，单张图片生成消耗约2美豆</li>\n<li>付费版WHEE VIP会员：连续包月：58元、连续包季：158元、连续包年：518元，每月可获1800美豆</li>\n<li>美豆充值：你也可以选择单独付费充值美豆换取生成次数，6元60美豆、18元180美豆、68元680美豆、128元1280美豆</li>\n</ol>\n<h2>常见问题</h2>\n<div id=\"accordion\" style=\"max-width: 700px;\">\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>WHEE是免费的吗？</strong></div>\n<div class=\"card-body text-sm\">WHEE提供免费的积分美豆，新用户登录即送20美豆，每日分享作品可获得额外美豆奖励用于免费图像创作。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>WHEE基于什么大模型？</strong></div>\n<div class=\"card-body text-sm\">WHEE基于美图自研的MiracleVision奇想智能视觉大模型，最新版为MiracleVision 4.0。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>WHEE支持哪些平台？</strong></div>\n<div class=\"card-body text-sm\">WHEE目前提供浏览器网页端和移动端APP。</div>\n</div>\n</div>'),
                                                                        (496,	0,	0,	'<p>简单AI是搜狐最新推出的智能图片生成平台和社区，是一个适合小白直接上手的AI图片生成工具，提供文生图和图生图两种模式，上手简单，且生成质量较好。目前，用户可以通过简单AI每日免费生成 10 张图片。同时，该平台还提供用户作品分享社区、创作同款、提示词参考等功能。</p>\n<h2>简单AI的产品功能</h2>\n<ol>\n<li>内置多个主体对象的模板，包括人物头像、美女帅哥、艺术流派、动物、风景等</li>\n<li>提供多种画风生成渲染，包括迪士尼、二次元、手绘、水彩、古风、毕加索、赛博朋克等</li>\n<li>支持中英文描述，使用短的词语、英文描述效果更佳</li>\n<li>灵活多样的设置选项，可以设置尺寸比例、参考图、数量等</li>\n</ol>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/63e123fb7add572.png\"  alt=\"搜狐简单AI\" width=\"800\" height=\"450\">\n<h2>如何使用简单AI生成图片</h2>\n<ol>\n<li>访问简单AI的官网，点击顶部菜单栏的生成图片选项</li>\n<li>进入操作界面，选择内置的模板，输入图片描述</li>\n<li>可选择上传参考图、尺寸比例和图片数量</li>\n<li>设置完毕后点击蓝色的生成图片按钮即可</li>\n</ol>'),
                                                                        (497,	0,	0,	'<p>秒画是商汤科技基于70亿参数的自研Artist作画大模型而推出的免费AI绘画创作平台，简单易上手即可轻松定制生成图片。商汤秒画支持文生图和图生图的提示方式，结合精准控制和风格模型，可随时随地生成高质量画作内容。</p>\n<h2>商汤秒画的产品功能</h2>\n<ul>\n<li>文本生成图像。只需给定提示词，秒画即可生成相应图像，最高可实现6K高清图。</li>\n<li>图片生成图片。用户可提供图像，转换生成相似的其他风格的图片。</li>\n<li>ControlNet精准控制。支持姿势控制、线稿上色、深度检测等多种玩法。</li>\n<li>自定义训练LoRA模型。秒画还支持用户上传本地图像，结合商汤自研作画模型或者开源模型来训练定制化LoRA模型，来高效地生成个性化内容。</li>\n</ul>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/062e547de3320c4.png\"  alt=\"商汤秒画AI图片生成\" width=\"800\" height=\"450\">\n<h2>如何使用商汤秒画</h2>\n<ol>\n<li>访问秒画的官网（miaohua.sensetime.com），点击登录按钮</li>\n<li>使用邮箱登录/注册秒画账号，登录成功后会自动返回到网站首页，点击开始创作</li>\n<li>在创作界面的左侧选择生成数量、分辨率、基模型、LoRA风格等，右侧输入文本描述</li>\n<li>最后点击立即生成按钮，秒画便能智能生成你想要的图片啦</li>\n</ol>'),
                                                                        (498,	0,	0,	'<h2>Dreamina是什么</h2>\n<p>Dreamina是由字节跳动抖音旗下的剪映推出的一款AI图片创作和绘画工具，旨在帮助抖音的图文和短视频创作者进行内容创作，用户只需输入提示描述，即可快速将创意和想法转化为图像。该工具是一个多风格的AI绘画神器，可以进行动漫、写实、摄影、插画等不同风格的图像生成。目前处于免费测试中，感兴趣的AI爱好者可以访问试试。</p>\n<img  class=\"alignnone size-full rounded-lg shadow-sm\" src=\"/uploadfile/202312/122b598200008.png\"  alt=\"Dreamina\" width=\"800\" height=\"425\">\n<h2>Dreamina的主要功能</h2>\n<ol class=\"text-md\">\n<li>简单好用的文本生成图片：输入对画面的文本描述，即可生成对应的场景图</li>\n<li>图片参数设置调整：支持选择模型、图片尺寸比例、画面精细度等进行调整</li>\n<li>丰富的做同款提示模板：提供摄影、写实、插画、设计等提示词模板，一键生成同款图片</li>\n<li>图片变超清：支持将生成的低分辨率模糊图像变4K、8K分辨率的超清图片</li>\n<li>局部重绘：提供画笔和橡皮擦对生成后的图片进行局部重绘</li>\n<li>画面扩图：可对生成后的图片进行画面画幅扩展，支持更改比例和扩图1.5~3倍</li>\n</ol>\n<h2>如何使用Dreamina</h2>\n<ol class=\"text-md\">\n<li>访问Dreamina的官网（www.capcut.cn/ai-tool/），点击登录按钮</li>\n<li>使用你的抖音账号登录，登录成功后会跳转到创作界面</li>\n<li>在底部的输入框中输入提示描述或采用Dreamina默认提供的文本描述</li>\n<li>点击立即生成，稍等片刻，Dreamina即可返回生成的图片</li>\n</ol>\n<h2>常见问题</h2>\n<div id=\"accordion\" style=\"max-width: 700px;\">\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>Dreamina是免费的吗？</strong></div>\n<div class=\"card-body text-sm\">Dreamina目前在免费内测中，用户可以免费使用该工具生成AI图片。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>Dreamina基于什么大模型？</strong></div>\n<div class=\"card-body text-sm\">Dreamina基于字节跳动开发的多模态大模型「云雀大模型」。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>Dreamina单次可以生成多少张图片？</strong></div>\n<div class=\"card-body text-sm\">Dreamina单次可以生成4张图片。</div>\n</div>\n</div>'),
                                                                        (499,	0,	0,	'<p>美图AI文生图原是由美图创意平台推出的AI图像创作工具，现已集成到美图设计室中，用户只需输入文字创意描述，并选择自己喜欢的模型风格，点击立即生成即可获得由美图AI创作的一幅画作。</p>\n<h2>美图AI文生图的主要功能</h2>\n<ol>\n<li>通过文本描述快速生成高质量图片和插画，无需复杂的语句，用户只需用简明扼要的词语组合对所要展示的创意进行描绘，如：“中国山水画，群山耸立，云雾缭绕”。</li>\n<li>内置多种模型风格，满足不同画风的需求，包括万物二次元、至臻风光、游戏CG、国风少年、古早海报、概念设计、质感游戏、写实真人、精美动漫、音画视觉、冰与火、灵瞳、童趣3D、平涂日漫等风格。</li>\n<li>灵活的参数设定，用户可选择图片的尺寸和比例（常见的如1:1、2:3、3:4、9:16、3:2、4:3、16:9等），也可以自定义像素宽高和生成的张数。</li>\n</ol>\n<h2>如何使用美图AI文生图</h2>\n<ol>\n<li>点击上方的访问官网按钮，或者在「美图设计室」的首页点击AI文生图（注意：请使用国内的网络访问，否则网页可能会显示空白）</li>\n<li>登录或注册你的美图账号</li>\n<li>在左侧的区域描述你的创意、选择你感兴趣的模型风格（如二次元、游戏CG、国风、动漫、写实真人等风格）</li>\n<li>设定画面尺寸比例和像素大小，并输入生成的图片张数</li>\n<li>最后点击蓝色的立即生成按钮即可</li>\n</ol>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/04071a83404acff.png\"  alt=\"如何使用美图AI文生图\" width=\"800\" height=\"400\">'),
                                                                        (500,	0,	0,	'<p>造梦日记是一款基于AI算法、输入文字或图片即可生成高质量图片的平台，由西湖大学深度学习实验室和西湖心辰（Friday AI 写作助手背后的团队）联合出品，超强算力，超快出图，目前支持微信小程序和网页端等。</p>\n<h2>造梦日记的主要功能</h2>\n<ol>\n<li>生成不同风格的图像和插画，包括油画、水彩、哑光画、儿童画、素描、中国风、电影感、摄影、动漫风、游戏场景、吉卜力、低聚艺术、像素艺术、CG渲染、赛博朋克、蒸汽波、虚幻引擎、印象主义、未来主义、超现实主义、浮世绘、室内设计等海量风格。</li>\n<li>模仿艺术大师的创作风格，如毕加索、梵高、莫奈、丰子恺、永井博、保罗·塞尚、托马斯·科尔、约翰·哈利斯、马克·西莫内蒂、托马斯·金凯德、西尔文·塞瑞尔等。</li>\n<li>支持不同尺寸和分辨率的图像生成，造梦日记目前支持多种尺寸，分别是1:1，16:9 、9:16、3:4、4:3，你可以根据画面内容选择相应的尺寸。人像类推荐使用1:1的尺寸，以避免出现人像重叠；宏大场景和风景推荐使用16:9 和 9:16，这样的梦境更加逼真也更有冲击力；当然尺寸的选择不是绝对的，你可以根据画面的内容选择相应尺寸。</li>\n<li>定制专属于自己的模型，用户可上传对应要求的图像后训练生成限定款图片或自推理生成图片，定制模型的训练时间与上传的训练图片数量相关，一般情况下，大约需要30分钟。</li>\n</ol>\n<h2>如何使用造梦日记</h2>\n<p>造梦日记的使用操作简单，生成图像快，支持中英文输入提示词。</p>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/dc225c9c80cc9c9.png\"  alt=\"如何使用造梦日记\" width=\"800\" height=\"450\">\n<ol>\n<li>访问造梦日记的官网，点击开始创作按钮</li>\n<li>进入到生成页面，选择画板（造梦画板或ControlNet画板）</li>\n<li>描述你想生成的画面场景，你可以输入任何梦中的画面，比如一段文字描述（一个实物，一个场景）、一首诗、一句歌词、甚至是一个emoji</li>\n<li>选择你感兴趣的风格，如写真、流光、摄影、动漫风等，你还可以添加参考图</li>\n<li>选择图像尺寸和你想生成的图像数量</li>\n<li>最后点击生成按钮即可</li>\n</ol>\n<h2>造梦日记的产品价格</h2>\n<p>造梦日记采用免费与付费结合的方式，「造梦星」用于兑换造梦日记平台上的各种虚拟产品和增值服务，用户在造梦日记平台上使用图片生成服务需消耗一定数量的造梦星。</p>\n<p>新用户注册造梦日记后可免费获得平台赠送的100颗造梦星，每日签到同样可以领取一定数量的星星。造梦日记的付费VIP会员可以享受更快速度和更多尺寸的出图，VIP分为月卡会员、季卡会员和年卡会员三个等级：</p>\n<ul>\n<li>月卡会员，每月50元，可以获得600颗造梦星</li>\n<li>季卡会员，3个月128元，可以获得2000颗造梦星</li>\n<li>年卡会员，12个月388元，可以获得8000颗造梦星</li>\n</ul>\n<p>如果你想按造梦星的数量来购买，造梦日记提供了一个「摘星套餐」：</p>\n<ul>\n<li>12元，150颗造梦星</li>\n<li>40元，600颗造梦星</li>\n<li>148元，2500颗造梦星</li>\n</ul>'),
                                                                        (501,	0,	0,	'<p>2023 世界人工智能大会期间，阿里云宣布推出通义大模型家族新成员「通义万相」，寓意“刻削生千变，丹青图万相”。通义万相是一款不断进化的 AI 绘画模型，首批上线三大功能：基础文生图功能、相似图片生成功能、图像风格迁移功能，仅需一个模型即可支持多类图像生成类任务能力。</p>\n<p>目前，通义万相已经上线，并正式面向公众展开邀测。</p>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/8b61b845fbcbc47.jpg\"  alt=\"通义万相作画\" width=\"800\" height=\"377\">\n<h2>如何使用通义万相</h2>\n<ol>\n<li>访问通义万相的官网，点击申请体验，然后登录/注册你的阿里云账号，填写申请表格</li>\n<li>申请通过后，通义万相会发一封获得测试体验资格邮件到你的电子邮箱</li>\n<li>然后再次登录通义万相，点击立即体验，进入到作画的界面</li>\n<li>在左侧选择作画方式，然后输入文本描述或上传参考图片，并调整或修改参数</li>\n<li>最后点击生成创意画作按钮即可</li>\n</ol>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/da7c85d6fc029.png\"  alt=\"通义万相AI插画生成\" width=\"800\" height=\"450\">\n<h2>通义万相是免费的吗？</h2>\n<p>目前通义万相属于免费内测中，用户可以在官网申请体验，登录后可免费获得50灵感值，单次生成绘画成功后会扣除1灵感值，每日登录可获得50灵感值。</p>'),
                                                                        (502,	1,	15,	'<p>remove.bg是最早和最火的AI图片背景去除工具之一，无论是人像、产品、动物，还是汽车、图形、Logo，轻点一下上传图片，便可在几秒钟内自动去除背景。Remove.bg还支持魔法笔刷功能，鼠标一涂抹便可以帮助用户精准地移除或还原图片中的物体。</p>\n<h2>remove.bg的功能特色</h2>\n<ol>\n<li>操作简单，快速去除图片背景。用户只需上传图片，轻点一下，remove.bg便能自动去除图片的背景，抠出图片主体</li>\n<li>全面的生态和平台集成。remove.bg除提供在线网页版，还提供Windows、Mac、Linux、Android、命令行界面、PS插件、Figma插件、Sketch插件、GIMP插件等版本</li>\n<li>满足各行各业人员的需求。无论是个人用户、摄影师、营销人员、开发人员，还是电子商务平台、媒体和企业，remove.bg都能短时间内处理多张图片背景移除</li>\n</ol>\n<h2>remove.bg的产品定价</h2>\n<ol>\n<li>免费版：Remove.bg提供免费去除1张图片的背景，但可以无限次免费去除后低辨率预览</li>\n<li>按时间订阅计费的话：59元一个月，每月40张抠图；259元一个月，每月200张抠图；599元一个月，每月500张抠图；1290元一个月，每月1200张抠图。若年付的话，以上价格还有10%的优惠</li>\n<li>按张数计费的话：10张抠图，59元；75张抠图，329元；200张抠图，669元；500张抠图，1350元</li>\n</ol>\n<h2>常见问题</h2>\n<div id=\"accordion\" style=\"max-width: 700px;\">\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>remove.bg提供免费试用吗？</strong></div>\n<div class=\"card-body text-sm\">remove.bg提供免费去除1张图片的背景和高清导出，试用后虽然可以继续免费去除背景但是只能以低分辨率查看。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>remove.bg支持哪些图像？</strong></div>\n<div class=\"card-body text-sm\">remove.bg允许用户上传任何最大不超过 12 MB 的 JPG 或 PNG 图像，图像必须具有可明确作为前景的对象，例如人、动物、产品或汽车。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>remove.bg的工作原理是什么？</strong></div>\n<div class=\"card-body text-sm\">remove.bg 基于 python、ruby 和深度学习构建，使用各种先进的自定义算法来处理图像。</div>\n</div>\n</div>'),
                                                                        (503,	0,	0,	'<p>Upscayl是一个精美的免费开源的AI图片无损放大工具，同时支持Windows、Mac、Linux等桌面系统，超过百万用户都在使用。借助最先进的人工智能，Upscayl 可以帮助你将低分辨率图像转换为高分辨率。</p>\n<h2>Upscayl的主要功能</h2>\n<ol>\n<li>AI驱动的图像放大：利用尖端人工智能的技术提高图像的分辨率，同时保持图像的原始细节。</li>\n<li>用户友好的直观界面：通过简单的控制和直观的导航，享受无缝的用户体验，任何人都可以快速上手。</li>\n<li>支持批量图像放大功能：一次性高效处理多个图像，在保持最佳放大质量的同时节省时间和精力。</li>\n<li>添加自定义模型：集成和利用自定义人工智能模型，为用户提供灵活性，以利用特定算法满足其个性化放大需求。</li>\n<li>并排比较视图：通过方便的并排比较视图，可视化放大前后的效果，使用户可以准确评估放大的结果。</li>\n</ol>\n<h2>Upscayl的使用方法</h2>\n<ol>\n<li>访问Upscayl的官网，点击右上角的Download按钮下载对应操作系统的安装包</li>\n<li>安装完毕打开软件，点击Select Image添加和选择要放大的图片</li>\n<li>选择图片放大模型并选择图片导出的文件夹</li>\n<li>最后点击Upscayl按钮即可开始放大</li>\n</ol>\n<h2>常见问题</h2>\n<div id=\"accordion\" style=\"max-width: 700px;\">\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>Upscayl的工作原理是什么？</strong></div>\n<div class=\"card-body text-sm\">Upscayl 使用 AI 模型通过猜测细节来增强图像，该工具借助图像超分辨率模型 Real-ESRGAN 来实现这一目标。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>Upscayl支持哪些平台运行？</strong></div>\n<div class=\"card-body text-sm\">Upscayl支持跨平台的桌面系统运行，包括Windows、Mac、Linux等操作系统，云端在线运行即将推出。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>Upscayl最高支持放大图片多少倍？</strong></div>\n<div class=\"card-body text-sm\">Upscayl支持放大图片2～4倍，默认最高支持4倍的分辨率放大，但是还提供Double Upscayl进行多次放大，理论上能达到16倍的放大效果。</div>\n</div>\n</div>'),
                                                                        (504,	1,	15,	'<p>3月21日微软宣布将把DALL·E文本到图像生成引入其必应搜索引擎中。你可以在最新的Bing对话中输入对应的指令让其直接在聊天上下文中AI生成图片，也可以访问其独立的网页页面创建图片和艺术画。</p>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/c50eb3e46fb821c.jpeg\"  alt=\"Bing图像生成\" width=\"800\" height=\"450\">'),
                                                                        (505,	0,	0,	'<h2>Visual Electric是什么</h2>\n<p>Visual Electric是一个面向创意人员和设计师的专业的AI图像创作工具，由来自苹果、微软、Facebook、Dropbox等知名公司的前员工创立，该工具可以帮助用户将脑海中的想法和愿景转换为高质量图像。相较于其他的AI图片和绘画工具，Visual Electric提供了一个更加简洁直观易上手的操作界面和更多个性化调整的功能。</p>\n<img  class=\"alignnone size-full rounded-lg border-0\" src=\"/uploadfile/202312/e5d38d8ab54dd09.jpeg\"  alt=\"Visual Electric\" width=\"800\" height=\"450\">\n<h2>Visual Electric的主要功能</h2>\n<ol class=\"text-md\">\n<li><strong>智能自动提示词建议</strong>：基于GPT-3.5 Turbo，Visual Electric根据用户的实时输入提供提示词描述的建议</li>\n<li><strong>多种风格的图片创作</strong>：支持摄影、插画、抽象、美术、工艺等多样风格的图像创作，随意发挥你的想象力</li>\n<li><strong>不同比例的图片生成</strong>：支持生成9:16、4:5、1:1、5:4、16:9、21:9等比例的图片，满足不同平台的尺寸要求</li>\n<li><strong>高质量的灵感社区</strong>：平台上的Inspo灵感社区里有众多艺术家分享的高质量图像，可一键创作同款</li>\n<li><strong>丰富的图片调整功能</strong>：内置颜色选择、画面重绘、图片变体、图片高清放大、背景移除等小工具</li>\n</ol>\n<img  class=\"alignnone size-full rounded-lg\" src=\"/uploadfile/202312/c0426b187b30f43.png\"  alt=\"Visual Electric\" width=\"800\" height=\"443\">\n<h2>Visual Electric的使用方法</h2>\n<ol class=\"text-md\">\n<li>访问Visual Electric的官网（visualelectric.com），点击右上角的Get Started按钮进行登录/注册</li>\n<li>登录成功后选择你的职业，然后点击Continue继续，进入到后台界面</li>\n<li>点击New Canvas创建新的画布，在顶部输入提示词，然后选择风格、图片比例</li>\n<li>最后点击闪电标志的生成按钮，稍等片刻即可生成4张AI图片</li>\n</ol>\n<h2>Visual Electric的适用人群</h2>\n<ol class=\"text-md\">\n<li><strong>平面设计师</strong>：创作品牌标识、色彩搭配、图像元素等平面设计资源</li>\n<li><strong>概念艺术家</strong>：探索和实现各种创意概念，获取灵感和探索不同艺术风格和技巧</li>\n<li><strong>产品设计人员</strong>：辅助产品初步构思，快速生成产品的视觉概念以提高效率</li>\n<li><strong>美术画家</strong>：为画家提供新的灵感和创意点，并可以模拟不同的美术风格</li>\n<li><strong>AI爱好者</strong>：将艺术创意与技术结合，探索AI生成图像的各种可能性</li>\n</ol>\n<h2>Visual Electric的产品价格</h2>\n<ol class=\"text-md\">\n<li>免费版：每天可生成40次图片，作品与社区共享，生成的作品仅可用于个人用途</li>\n<li>标准版：16美元每月，不限生成次数，作品与社区共享，更快的生成速度和商用许可</li>\n<li>专业版：48美元每月，不限生成次数，作品可仅个人可见、更快的生成速度和商用许可</li>\n</ol>\n<h2>常见问题</h2>\n<div id=\"accordion\" style=\"max-width: 700px;\">\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>Visual Electric是免费的吗？</strong></div>\n<div class=\"card-body text-sm\">Visual Electric提供免费版本，用户每天可以进行40次图片生成。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>Visual Electric基于什么模型？</strong></div>\n<div class=\"card-body text-sm\">Visual Electric的图片生成能力基于Stable Diffusion，提示词建议基于GPT-3.5 Turbo。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>Visual Electric支持哪些平台？</strong></div>\n<div class=\"card-body text-sm\">Visual Electric目前只提供了网页版，后续将会推出桌面端和移动端APP。</div>\n</div>\n</div>'),
                                                                        (506,	0,	0,	'<p>Imagine with Meta是由Meta公司（原Facebook）推出的一款全新的可独立使用的AI图像生成器，用户只需使用自然语言进行描述即可创建和生成图像。Imagine with Meta的能力由其增强文本到图像生成模型Emu驱动，基于 11 亿张公开的 Facebook 和 Instagram 图片来训练。除开在线版外，用户也可以通过 Meta 旗下的社交通讯平台 Messenger 和 Instagram 体验该功能，可以在群聊中即时创建和共享图像。</p>\n<img  class=\"alignnone size-full rounded-lg shadow-sm\" src=\"/uploadfile/202312/8a0a3476510032e.jpeg\"  alt=\"Imagine with Meta\" width=\"800\" height=\"450\">'),
                                                                        (507,	0,	0,	'<p>触手AI是为插画、漫画、设计等用户打造的国产AI绘画创作平台，支持文生图、图生图、参考生图、lora在线模型训练、海量模型可使用，并已通过国内第二批深度合成服务算法备案。</p>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/9641023e4e75af3.jpeg\"  alt=\"触手AI官网\" width=\"800\" height=\"406\">\n<h2>触手AI的产品特色</h2>\n<ol>\n<li>一体化专业工作台，插件整合，无需多模式切换，即可完成专业创作</li>\n<li>独创工作流功能，一键复原繁琐的流程与参数，提高工作效率</li>\n<li>优化的SD插件操作，上手方便，更友好</li>\n<li>在线极简Lora模型训练</li>\n</ol>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/12a4f0c1cb02b83.png\"  alt=\"触手AI图像生成\" width=\"800\" height=\"418\">\n<h2>触手AI的平台优势</h2>\n<ol>\n<li>SD免费作图（领取积分）</li>\n<li>SD免费Lora模型训练</li>\n<li>友好的工具，告别SD WebUI的复杂操作</li>\n<li>Controlnet/hires/adetailer/inpainting等丰富的插件不断更新</li>\n<li>丰富的作品/模型，均可使用</li>\n<li>4090极速出图/训练</li>\n<li>AI功能实验室，抠图/高清/动态壁纸/AI视频</li>\n<li>漫画专区，快速分镜脚本、分镜绘制、批量任务，还有AI漫画专业培训课程</li>\n</ol>'),
                                                                        (508,	0,	0,	'<p>文心一格是由百度推出的依托其文心大模型和飞桨技术的文本生成图片的 AI 艺术和创意辅助平台，于2022年8月正式发布。作为国内第一梯队的AI图片生成的工具和平台，文心一格可以进行国风、油画、水彩、水粉、动漫、写实等十余种不同风格高清画作的生成。</p>\n<p>文心一格面向的用户人群非常广泛，既能启发画师、设计师、艺术家等专业视觉内容创作者的灵感，辅助其进行艺术创作，还能为媒体、作者等文字内容创作者提供高质量、高效率的配图。</p>\n<img  class=\"alignnone size-medium\" src=\"/uploadfile/202312/0f11f2693c04558.png\"  width=\"800\" height=\"450\">\n<h5><strong>💵 产品价格</strong></h5>\n<p>目前文心一格是采用的免费增值模式，新用户注册登录后可以获得 50 的电量用以生成图像，签到、分享和公开自己的画作可以获得额外免费的电量。你也可以采用付费充值电量，9.9 元 80 个电量、15.9 元 200 个电量、49.9 元 800 个电量、599 元 1 万个电量。</p>'),
                                                                        (510,	0,	0,	'<p>Midjourney 是由人工智能研究实验室 Midjourney, Inc. 开发的AI图像生成工具，可以根据输入的文本提示生成图像。该程序最早于2022年7月12日进入公开测试阶段，用户可以通过 Discord 的机器人指令进行操作，创作出许多不同风格的图像作品。</p>\n<p>类似于 OpenAI 的 DALL·E 和 Stability AI 的 Stable Diffusion，该AI绘画工具只需用户输入想到的文字，就能通过人工智能创建相对应的图片，耗时只有大约一分钟。不同之处在于，Midjourney目前尚需通过Discord社区来进行AI图片的生成。</p>\n<h2>Midjourney的主要功能</h2>\n<ol>\n<li>文本到图像生成：在Discord中使用/imagine命令后，输入文本提示词，即可生成对应描述的图片</li>\n<li>图像混合创意叠图：使用/blend命令，可以将多张图片合并以创建融合型风格的全新图片，激发独特创意</li>\n<li>图像扩展和平移：Midjourney支持在上下左右四个方向平移图像扩展画面内容，还支持zoom out外绘缩放画面主体</li>\n<li>图像高清放大：Midjourney默认生成1024*1024像素的图片，支持最高放大图像4倍</li>\n</ol>\n<h2>Midjourney的产品定价</h2>\n<p>Midjourney 目前提供有四个订阅级别，按年支付可享受 20% 的折扣。每个订阅计划都包括访问 Midjourney 会员图库、官方 Discord、一般商业使用等。</p>\n<ol>\n<li>Basic Plan 基础版：10美元每月（年付96美元）</li>\n<li>Standard Plan 标准版：30美元每月（年付288美元）</li>\n<li>Pro Plan 专业版：60美元每月（年付576美元）</li>\n<li>Mega Plan 大型版：120美元每月（年付1152美元）</li>\n</ol>\n<h2>Midjourney的使用方法</h2>\n<ol>\n<li>登录或注册Discord账号：由于Midjourney目前需要通过Discord社区来生成图片，所以首先需要Discord账户</li>\n<li>选择一个付费版本订阅：访问midjourney.com/account，使用 Discord 帐户登录，选择一个订阅计划</li>\n<li>在 Discord 上加入 Midjourney 服务器：访问 https://discord.com/invite/midjourney 点击接受邀请加入该服务器</li>\n<li>切换到#General 或 #Newbie 频道：在 Discord 上找到并选择标有 general 或 newbie 的任何频道</li>\n<li>使用/imagine命令生成图片：在输入框键入/imagine指令，然后输入提示词描述，即可生成图片</li>\n</ol>\n<h2>Midjourney的常见问题</h2>\n<div id=\"accordion\" style=\"max-width: 700px;\">\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>Midjourney提供免费试用吗？</strong></div>\n<div class=\"card-body text-sm\">Midjourney在上线初期，有为用户提供免费试用生成25张图片的额度，但由于用户量的激增，服务器费用增加，取消了免费试用的计划，需要付费订阅才能使用。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>Midjourney只能通过Discord使用吗？</strong></div>\n<div class=\"card-body text-sm\">目前Midjourney暂时只能通过Discord服务器使用，但Midjourney的在线网站处于建设中，预计将很快上线在线网页生成图片的功能。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>Midjourney有国内版本吗？</strong></div>\n<div class=\"card-body text-sm\">Midjourney虽然一直有进军中国市场的打算，但至今未官方推出过任何国内版本，许多声称国内版的基本都是假冒。</div>\n</div>\n</div>'),
                                                                        (511,	0,	0,	'<p>美图抠图是由美图秀秀推出的智能AI抠图工具，用户只需上传图片，便能一键快速去除图片背景。该工具支持全品类 AI 智能抠图，如人像、宠物、商品、图标等。除开抠图外，该工具还支持换背景、滤镜、改尺寸、边缘优化、投影、描边、画质修复等图片编辑功能。</p>'),
                                                                        (512,	0,	0,	'免费的AI图片背景移除和添加'),
                                                                        (513,	0,	0,	'<p>稿定抠图是由稿定设计推出的在线AI抠图平台，利用人工智能技术，可以快速消除图片背景。无需下载，就可以实现在线一键自动智能ps抠图。用户上传图片之后，便能一键进行人物头像和电商商品的高效抠图。</p>'),
                                                                        (514,	0,	0,	'<p>Stable Doodle 是Stability AI（Stable Diffusion背后的公司）最新推出的将手绘草图转换成精美图像的工具，无论你是专业人士，还是绘画爱好者，都可以借助 Stable Doodle 快速将简单的手绘稿变为现实，让你从灵魂画手变身艺术大师。</p>\n<p>通过 Stable Doodle 任何具有基本绘图技能和访问在线网站的人都可以在几秒钟内生成高质量的原始图像，设计师、插画师和其他专业人士能够腾出宝贵的时间并最大限度地提高效率，以草图形式绘制的想法可以立即落地到作品中，为客户创建设计、为展示平台和网站创建物料、甚至创建LOGO标志。</p>\n<p>目前 Stable Doodle与最新的 Stable Diffusion 模型 SDXL 0.9 一起都可以在Stability AI 旗下的 Clipdrop 网站上免费试用。</p>\n<p>AI工具集编辑随意画了3栋楼的轮廓，然后输入简单的skyscraper buildings提示词，下面生成的3张效果图还是不错的。</p>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/89ce39b61ed89da.png\"  alt=\"Stable Doodle测试效果\" width=\"800\" height=\"418\">'),
                                                                        (515,	0,	0,	'AI生成各种类型的图像和插画'),
                                                                        (519,	0,	0,	'<p>Stable Diffusion 是于2022年发布的一个基于深度学习的AI文本到图像生成模型，该模型主要用于生成以文本描述为条件的详细图像和插画，由初创公司 StabilityAI 与一些学术研究人员和非营利组织合作开发的。</p>\n<div class=\"io-edit-post-card-content\"><div class=\"url-card shortcode-url site_0 mx-auto \" style=\"max-width:420px\">        <div class=\"card flex-fill mb-3\">\n            <div class=\"row no-gutters\">\n                <div class=\"col-4\">\n                    \n                <div class=\"media media-4x3 rounded-left\">\n                                        \n                                    </div>\n                </div>\n                <div class=\"col-8\">\n                    <div class=\"card-body list-content p-2\" style=\"height: 100%;\"> \n                        <div class=\"list-body\"> \n                            如何运行Stable Diffusion？在线和本地运行的5种方法\n                            <div class=\"list-desc d-none d-md-block text-sm text-secondary my-3\">\n                        <div class=\"overflowClip_2 \">Stable Diffusion是由初创公司Stability AI和来自慕尼黑大学以及Runway的研究人员在2022年发布的文本到图像的生成模型，本篇文章将讲解如何在线和本地运行Sta...</div>\n                    </div>\n                        </div>\n                        <div>\n                            <div class=\"d-flex flex-fill align-items-center text-muted text-xs\">\n                                                                <span><i class=\"iconfont icon-classification\"></i>\n                                    AI教程\n                                </span>\n                                                                <div class=\"flex-fill\"></div>\n                                <div>\n                                    <time class=\"mx-1\">6个月前</time>\n                                </div>\n                            </div>      \n                        </div>  \n                    </div>\n                </div>\n            </div>\n        </div>\n</div></div>\n<p>Stable Diffusion是一个潜在扩散模型（ Latent Diffusion Model）——深度生成性神经网络的一种。Stable Diffusion的代码和模型权重已公开发布，可以在大多数配备有适度GPU的电脑硬件上运行，而在此之前的专有文生图模型（如DALL-E和Midjourney）只能通过云计算服务访问。</p>\n<p>Stable Diffusion在线版本主要可通过以下官方网站访问：</p>\n<ol>\n<li>DreamStudio版（StabilityAI官方推出）</li>\n<li>Stable Diffusion XL （StabilityAI旗下的ClipDrop推出）</li>\n</ol>'),
                                                                        (520,	0,	0,	'AI智能删除照片中的水印'),
                                                                        (521,	0,	0,	'AI移除图片中不想要的物体'),
                                                                        (522,	0,	0,	'Cutout.Pro推出的AI图片物体涂抹去除工具'),
                                                                        (523,	0,	0,	'智能移除图片中的物体、文本、污迹、人物或任何不想要的东西'),
                                                                        (524,	0,	0,	'AI移除图片中的任何物体'),
                                                                        (525,	0,	0,	'图片物体抹除和清理'),
                                                                        (526,	0,	0,	'AI图片生成和修图'),
                                                                        (527,	0,	0,	'<p>Facet由Joe Reisinger和Matt Stanton创立，是一个照片和视频编辑器，使用人工智能技术提供加速编辑图像的各项信息。该技术可以学习整个照片拍摄的图像属性，并进行批量编辑，如删除所有图像的背景。</p>\n<p>Facet是以品牌为客户而设计的，它的出现是为了让数字营销团队成员能够实时协作项目，并利用API随时在其他软件工具之间切换。</p>'),
                                                                        (528,	0,	0,	'ClipDrop推出的AI图像打光工具'),
                                                                        (529,	0,	0,	'AI图片调色上色'),
                                                                        (530,	0,	0,	'AI老照片修复'),
                                                                        (531,	0,	0,	'Cutout.Pro推出的黑白图片上色'),
                                                                        (532,	0,	0,	'人工智能老照片上色和修复'),
                                                                        (533,	0,	0,	'<p>美图云修是美图公司专为商业摄影行业打造的一站式AI修图解决方案，是一款可以批量对商业人像摄影图片进行一键精修的AI智能电脑端软件，轻松易用，只需简单操作即可完成高品质人像精修，是商业修图人像后期提效利器，助您高质量稳定批量出片。</p>\n<p>与传统Photoshop修图的效率对比，它可以每日输出上万张基础精修图片，而修图师使用ps进行单张修图每日仅可以完成百张左右的精修图片。</p>\n<p>美图云修拥有保留皮肤质感的磨皮功能，一键即可完成复杂的中性灰磨皮和高低频磨皮。美图云修还支持AI修复、牙齿美化、五官脸型调整、肤色调整、全身美型、妆容调整、一键仿妆、纯色背景祛瑕疵等功能，支持Raw格式文件导入，提供多种一键预设和滤镜，让所有人都能轻松上手AI修大片。</p>'),
                                                                        (534,	0,	0,	'<p>transpic是一个AI图像转绘插画创作平台，方便设计师寻找素材/灵感后进行转绘创作参考，普通用户也可以使用该工具来转绘头像。使用非常简单，用户只需上传图片，然后借助AI便可以将该图片转绘成其他风格。</p>\n<h2>transpic支持的转绘类型</h2>\n<p>transpic支持将图片转绘成19种不同的风格，</p>\n<ol>\n<li>场景/速涂类，概念场景、迪士尼风格、概念人物、二次元场景、现实质感、环境艺术等转绘风格出图效果更佳</li>\n<li>人物/角色类，二次元人物、迪士尼风格、人物设计、概念场景、概念人物、现实质感等转绘风格出图效果更佳</li>\n<li>照片/摄影类，环境艺术、人物设计、概念场景、二次元人物、概念人物、油画质感等转绘风格出图效果更佳</li>\n</ol>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/bb1dfa6d5903817.png\"  alt=\"transpic ai\" width=\"800\" height=\"450\">\n<h2>如何使用transpic</h2>\n<ol>\n<li>访问transpic的官网，在左侧上传图片</li>\n<li>调整出图相似度（相似度越低，效果越天马行空）</li>\n<li>选择出图模型</li>\n<li>最后点击转绘按钮即可</li>\n</ol>\n<h2>transpic的产品价格</h2>\n<p>用户登录注册transpic后，可获得30积分用于进行图片转绘，出图张数消耗相同数量的积分。另外，每邀请好友注册一次可获得30积分。也可以选择充值获得更多的积分，充值比例为1元=10积分，充值也会获得官方额外赠送的积分。</p>'),
                                                                        (535,	0,	0,	'<h2>像素蛋糕是什么？</h2>\n<p>像素蛋糕PixCake是一款简单易用的像素级AI图片精修软件，致力于为商业摄影提供智能影像解决方案，智能分析每一张照片，以达到商业级后期处理效果。该AI修图软件内置了丰富的一键调整和修复优化功能，借助先进的AI处理技术，提供专业的像素级细节精修能力，如祛痘祛斑、中性灰磨皮、面部重塑、妆容调整、瘦身美型等修图功能。</p>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/216d6e7db3540e9.png\"  alt=\"像素蛋糕软件\" width=\"800\" height=\"458\">\n<h2>像素蛋糕的主要功能</h2>\n<ol class=\"text-md\">\n<li>一键自动均匀肤色：提供肤色统一、中性灰磨皮、祛除瑕疵、祛红血丝、妆容调整等智能调节肤色功能</li>\n<li>智能面部头部调整：提供一键头发调整、面部重塑、全身美型、笑容管理、牙齿修复、面部比例调整</li>\n<li>图片背景修复和更换：提供一键修复图片背景瑕疵、证件照底色背景更换、风景照天空更改</li>\n<li>魔法衣服平整祛褶：告别繁复操作，秒速进行衣服祛褶皱，粗纹细纹，即刻祛除，迅速还原衣服细腻质感</li>\n<li>Raw实时调色转档：提供Raw实时调色、色彩调整、海量滤镜、降噪锐化等功能</li>\n</ol>\n<h2>像素蛋糕的产品价格</h2>\n<ol class=\"text-md\">\n<li>体验套餐：800张图片精修，299元</li>\n<li>基础套餐：1万张图片精修（另赠2000张），3680元</li>\n<li>专享套餐：3万张图片精修（另赠6000张），9980元</li>\n<li>豪华套餐：8万张图片精修（另赠1万张），18800元</li>\n</ol>\n<h2>常见问题</h2>\n<div id=\"accordion\" style=\"max-width: 700px;\">\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>像素蛋糕是免费的吗？</strong></div>\n<div class=\"card-body text-sm\">像素蛋糕提供免费3张图片的精修，完善信息可额外获得10张免费修图。若需要更多的张数，则需开通会员套餐。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>像素蛋糕支持的操作系统？</strong></div>\n<div class=\"card-body text-sm\">像素蛋糕目前提供Windows、Mac和iPad客户端，用户可选择对应版本的软件进行安装。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>像素蛋糕支持哪些图片导入？</strong></div>\n<div class=\"card-body text-sm\">像素蛋糕目前支持Raw格式、JPG、PNG 、Tiff格式，支持的文件像素不能超过12000*12000。</div>\n</div>\n</div>'),
                                                                        (536,	0,	0,	'<p>咻图AI是海南星图速云科技推出的一款面向影楼的摄影后期AI修图软件，借助AI人脸识别和先进的图像算法，简化修图过程中的繁琐操作，辅助影楼摄影师快速高效地进行图片处理和批量精修。用户只需导入图片文件夹，即可一键完成转档、美肤、液化等功能，轻松完成图片的初修，相较于人工修图效率提高了数十倍，最快可实现当天选片。</p>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/4647983d9afdb9b.png\"  alt=\"咻图AI软件\" width=\"800\" height=\"445\">\n<h2>咻图AI的主要功能</h2>\n<ol>\n<li><strong>面部五官微调重塑</strong>：AI 模拟资深修图师的技巧，在保留自然肌理的同时进行美肤处理。还可以进行眼睛和鼻子等细微调整，以使五官看起来更精致和立体。</li>\n<li><strong>优化脸部和身体比例</strong>：系统会智能自然地判断人物的性别和年龄，并个性化完成面部和全身的精准液化处理，以优化脸部轮廓和身体比例。</li>\n<li><strong>内置多款热门滤镜</strong>：软件提供了一系列热门风格滤镜，迎合当下摄影趋势。还支持用户自定义模板，可以根据个人喜好和多样的调色需求创建自己的滤镜效果。</li>\n<li><strong>一键智能转档功能</strong>：支持导入RAW文件和JPG图片，无需手动操作，转档和调色都将自动化完成，使用户的工作流程更加高效和便捷。</li>\n<li><strong>多人协同共享作图</strong>：支持套餐共享，帮助影楼形成统一的修图标准。此外，还可以轻松查看成员作图情况，帮助影楼进行数字化管理，确保工作流程的协调和高效。</li>\n</ol>\n<h2>咻图AI的产品价格</h2>\n<ol>\n<li>咻图AI为新用户免费提供试片50张的配额，付费版本按照修图张数计费，收费套餐如下：</li>\n<li>标准版：云修图2980元/42000张、8800元/132000张、19800元/420000张</li>\n<li>专业版A：云修图298元/1500张、9900元/45600张、16800元/112800张</li>\n<li>专业版B：咻图管家9900元/39600张、16800元/117000张、30000元/252000张</li>\n<li>白金版：咻图管家9900元/27600张、16800元/69600张、30000元/168000张</li>\n</ol>\n<h2>如何使用咻图AI</h2>\n<ol>\n<li>访问咻图AI的官网（www.aixtsy.com），点击免费下载，选择下载对应自己的操作系统版本</li>\n<li>下载安装完毕后，打开软件界面，拖动或者点击选择图片文件夹</li>\n<li>然后点击修图按钮选择批量修图预设，若导入的多个文件夹则点击批量修图按钮选择预设</li>\n<li>可选择自定义调整参数，设置好后点击开始修图，待修图完成后，成片会自动导出到原片文件夹目录下</li>\n</ol>\n<h2>常见问题</h2>\n<div id=\"accordion\" style=\"max-width: 700px;\">\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>咻图AI提供免费修图吗？</strong></div>\n<div class=\"card-body text-sm\">咻图AI为新用户提供免费试片50张的配额。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>咻图AI支持哪些操作系统？</strong></div>\n<div class=\"card-body text-sm\">咻图AI同时支持macOS和Windows桌面端运行。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>咻图AI支持哪些格式的图片？</strong></div>\n<div class=\"card-body text-sm\">咻图AI支持多种图片格式导入，包括JPG/JPEG/PNG/CR2/NEF/ARW/CR3/RAF等格式。</div>\n</div>\n</div>'),
                                                                        (537,	0,	0,	'AI图片编辑和背景移除'),
                                                                        (538,	0,	0,	'AI产品背景移除和替换'),
                                                                        (539,	0,	0,	'高质量AI产品展示效果图生成'),
                                                                        (540,	0,	0,	'AI产品图添加背景'),
                                                                        (541,	0,	0,	'AI产品图精美背景添加'),
                                                                        (542,	0,	0,	'AI产品图背景替换'),
                                                                        (543,	0,	0,	'Hotpot.ai推出的图片背景移除工具'),
                                                                        (544,	0,	0,	'<p>图可丽是一款集图片&amp;视频处理的在线网站，可提供批量抠图、去水印、视频抠图、一键生成漫画、视频转漫画、图像修复、模糊视频变高清、AI绘画、AI更换背景等功能。</p>'),
                                                                        (545,	0,	0,	'魔术般地去除图片背景'),
                                                                        (546,	0,	0,	'在线一键抠图换背景'),
                                                                        (547,	0,	0,	'免费自动图片背景去除'),
                                                                        (548,	0,	0,	'Zyro推出的AI图片背景移除工具'),
                                                                        (549,	0,	0,	'Picsart旗下的Quicktools推出的图片背景移除工具'),
                                                                        (550,	0,	0,	'Vance AI推出的图片背景移除工具'),
                                                                        (551,	0,	0,	'AI批量抠图去背景'),
                                                                        (552,	0,	0,	'免费在线抠除图片背景'),
                                                                        (553,	0,	0,	'AI自动删除图片背景'),
                                                                        (554,	0,	0,	'AI图片背景移除工具'),
                                                                        (555,	0,	0,	'Adobe Express的图片背景移除工具'),
                                                                        (556,	0,	0,	'<p>GoProd 是 Icons8 推出的一款集AI图像无损放大和背景移除于一体的Mac应用程序，在人工智能的支持下，用户只需简单的操作，把想要编辑的图像拖放到应用窗口，片刻后就能得到所需的图像。</p>\n<h2>GoProd的主要功能</h2>\n<ul>\n<li>从照片和插图中剪切出人物和物体</li>\n<li>将图像最高放大到64MP</li>\n<li>增强低分辨率的产品图像、插图或文件照片</li>\n<li>恢复家庭相册中的老旧照片</li>\n<li>去除图片背景</li>\n<li>支持批量处理</li>\n</ul>\n<h2>GoProd的适用人群</h2>\n<ul>\n<li>电商运营人员</li>\n<li>图形和网页设计师</li>\n<li>营销人员</li>\n<li>内容制作者</li>\n</ul>'),
                                                                        (557,	0,	0,	'<p>BgSub是一个完全免费的在线AI抠图工具，使用先进的人工智能技术，自动替换图像的背景。不仅可以自动去除图像背景，而且无需上传你的图像数据，从根本上保护用户隐私。BgSub拥有着丰富的抠图功能，支持去除图像背景、替换图像背景、AI调色、自由调整、艺术滤镜等。最高支持4096*4096分辨率，处理后的图片一样可以免费商用。</p>'),
                                                                        (558,	0,	0,	'<p>Erase.bg是一款优质的在线AI抠图工具，利用人工智能的技术自动消除图像背景，让从图像中删除分散注意力或杂乱的背景变得更加容易。Erase.bg 只需几秒钟就可以识别前景对象并擦除周围的背景，省去了使用复杂图片编辑软件的麻烦，最高支持5000*5000分辨率。</p>'),
                                                                        (559,	0,	0,	'ClipDrop出品的AI图片背景移除工具'),
                                                                        (560,	0,	0,	'Icons8出品的免费图片背景移除工具'),
                                                                        (561,	0,	0,	'AI智能调整图片尺寸用于社交媒体平台发帖'),
                                                                        (562,	0,	0,	'AI无损放大图片'),
                                                                        (563,	0,	0,	'在线图片放大工具'),
                                                                        (564,	0,	0,	'PhotoAid出品的免费在线人工智能图片放大工具'),
                                                                        (565,	0,	0,	'VanceAI推出的在线图片尺寸调整工具'),
                                                                        (566,	0,	0,	'AI免费图片无损放大'),
                                                                        (567,	0,	0,	'<p>Upscale.media是由 Pixel Bin 推出的一个人工智能图片放大网站，可以将低分辨率图像其转换为清晰、高清的版本。该AI图片放大工具使用先进的深度学习算法，可以为像素化图像添加逼真的细节和纹理，在保持自然外观的同时有效提高分辨率。无论你是想改善旧照片，提高打印或网络图像的分辨率，还是减少图像噪声和压缩伪影，Upscale.media都提供了一种简单而强大的方式。</p>'),
                                                                        (568,	0,	0,	'Media.io推出的AI图片放大工具'),
                                                                        (569,	0,	0,	'Zyro出品的人工智能图片放大工具'),
                                                                        (570,	0,	0,	'Fotor推出的AI图片放大工具'),
                                                                        (571,	0,	0,	'<p>Img.Upscaler是一个在线的智能 JPG/PNG 图片放大器，利用最新的人工智能和超分辨率技术，只需要几秒钟，便可以将低分辨率图像变得高清。该工具还集成了图像编辑器工具，用于在图像放大之前或之后进行裁剪、滤镜、微调、注释等。</p>'),
                                                                        (572,	0,	0,	'<p>ClipDrop Image Upscaler是知名开源AI图像生成模型 Stable Diffusion 背后的公司 Stability AI 推出的一项AI图片无损放大服务，最高支持将图片放大到6000×6000像素。用户可以使用ClipDrop Image Upscaler用提高压缩图像的质量、去除图像噪点、锐化图片等以提高图片清晰度。</p>'),
                                                                        (573,	0,	0,	'<p>Icons8 Smart Upscaler是图标和设计资源平台 Icons8 推出的 AI 图片放大网站，该工具利用先进的人工智能技术，可以增加任何的数字图像的大小和分辨率，同时保留和增强自然纹理和细节。无论是小尺寸的社交媒体图像，还是手机相册里的模糊老照片，Icons 8 Smart Upscaler基于人工智能的算法可以研究你的图像，并以高达原始分辨率 8 倍的分辨率智能地重新创建它们。</p>'),
                                                                        (574,	0,	0,	'<p>Let\'s Enhance 是一个由人工智能驱动的在线AI图片放大工具，可以在不降低质量的情况下改善图像和缩放图像。该工具使用了机器学习的超分辨率技术，在大量真实照片基础上训练的神经网络，依靠其对现实世界中存在的典型物体和纹理的了解，学习恢复细节并保持清晰的线条和轮廓。</p>\n<p>除开无损放大功能外，Let\'s Enhance 还推出了 AI 图片生成功能，可以帮助用户从文本快速生成高质量的艺术插画和数字资产。</p>\n<h2>Let\'s Enhance的主要功能</h2>\n<p><strong>1. 对于创意人员</strong></p>\n<ul>\n<li>调整图片大小，使其清晰明了，并可用于任何网络和印刷格式；</li>\n<li>使用AI在几秒钟内增强低质量的图片，为创意任务节省时间；</li>\n<li>提升任何照片的质量，包括老照片、数字艺术、肖像、风景、标志和产品图片等。</li>\n</ul>\n<p><strong>2. 对于印刷需求</strong></p>\n<ul>\n<li>提高打印质量： 利用人工智能在打印中获得更高的分辨率、色彩和清晰度。</li>\n<li>获得 300+ DPI： 任何图像都能达到专业级的、清晰的、细致的打印效果。</li>\n<li>按需打印的API： 利用人工智能驱动的升级API，增强POD工作流程。</li>\n</ul>\n<p><strong>3. 对于AIGC艺术画</strong></p>\n<ul>\n<li>高分辨率的人工智能艺术： 增强人工智能生成的图像，创造出视觉上令人惊叹的杰作。</li>\n<li>将人工智能生成的艺术提升到所需的分辨率，包括高清、4K或更大的分辨率。</li>\n<li>提供文本到图像生成器： 在几秒钟内将文字变成吸引人的、独特的艺术作品。</li>\n</ul>\n<h2>Let\'s Ehance的产品价格</h2>\n<p>Let\'s Enhance 针对不同的用户群体和需求，提供了3种不同的产品定价模式：</p>\n<ol>\n<li> 针对个人订阅，免费版可以免费无损放大10张图片，年付版9美元/月可每月处理100张图片，年付版24美元/月可每月处理300张图片、年付版34美元/月可每月处理500张图片</li>\n<li>针对商务和企业订阅，月付版72美元每月可处理1000张图片，月付版160美元可处理2500张图片，月付版290美元可处理5000张图片。</li>\n<li>针对偶尔使用的用户提供按数量计费的一次性付费模式，一次性付9美元可处理20张图片，19美元可处理50张图片，39美元可处理120张图片。</li>\n</ol>\n<h2>常见问题</h2>\n<p>Let\'s Enhance 最高可以把图像放大到什么分辨率？</p>\n<p>免费用户可以将图片放大到6400万像素，付费用户的上限是256MP像素，商业计划有500MP像素的限制。</p>\n<p>如何使用 Let\'s Enhance 提高图像清晰度</p>\n<p>只需访问 Let\'s Enhance 的官网，然后登录/注册你的账号，然后上传你的图片，打开 Light AI 的开关，以改善颜色和照明，点击开始处理即可。</p>\n<p>Let\'s Enhance 是免费的吗？</p>\n<p>每个新用户可获得10个免费点数，你可以测试 Let\'s Enhance 的照片增强和图像放大软件，如果你对其结果满意的画，可以购买他们的付费计划。</p>'),
                                                                        (575,	0,	0,	'<p>BigJPG AI图片放大工具，使用最新的人工智能深度学习技术——深度卷积神经网络，将噪点和锯齿的部分进行补充，以实现图片的无损放大。BigJPG 通过神经网络，针对放大图片的线条、颜色、网点等特点，做特殊的算法调整，所以放大效果非常出色，色彩保留较好，图片边缘也不会有毛刺和重影。</p>'),
                                                                        (576,	0,	0,	'AI复杂文档自动识别处理转换'),
                                                                        (577,	0,	0,	'现代化的AI文档处理工具'),
                                                                        (578,	0,	0,	'AI文档要点总结工具'),
                                                                        (579,	0,	0,	'基于ChatGPT的文档阅读、提取、总结、摘要的工具'),
                                                                        (580,	0,	0,	'<p>印象AI的功能不仅限于开放式写作助理，而是将深入到知识管理的各个环节，辅助实现完善信息记录、高效信息整理、智能多模态信息关联与创作内容的润色和升华，成为由GPT驱动的多模态、全能知识管理助理。用户可在「印象笔记」桌面端、「Verse」、「印象图记」、「印象时间」、「收藏家」和「扫描宝」等应用中体验印象AI的功能。</p>'),
                                                                        (581,	0,	0,	'<p>金山办公4月宣布即将推出WPS AI（基于大语言模型下的生成式人工智能应用），将最先应用于其新一代在线内容写作编辑工具「轻文档」，以帮助用户处理工作、生活场景，提高内容生产力。</p>\n<p data-tool=\"mdnice编辑器\">9月5日，WPS AI 正式面向社会开放，率先应用在WPS智能文档，更多WPS AI能力将在其他组件开放，敬请关注ai.wps.cn。用户可在最新版<em>WPS客户端/APP</em>、<em>金山文档小程序/官网</em>体验WPS智能文档。</p>\n<h2>WPS AI的特色功能</h2>\n<ol>\n<li>对于WPS文字，可以帮助用户一键获取灵感，高效生成文章。</li>\n<li>对于WPS演示，可以一键生成和美化PPT，兼顾美观和效率</li>\n<li>对于Excel表格，可以智能处理表格数据，生成函数公式</li>\n<li>对于WPS PDF，可以快速提取文档信息，高效阅读PDF文件</li>\n<li>对于表单问卷，可以通过对话或拍照创建表单，自动生成数据报告</li>\n</ol>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/81edbce553db2b5.jpg\"  alt=\"WPS AI写作\" width=\"800\" height=\"552\">'),
                                                                        (582,	0,	0,	'<p>Humata是由GPT驱动的一个AI文档文件分析、阅读、问答工具，该工具可以帮助用户：</p>\n<ul>\n<li>总结长篇问答，让你学习更快，把复杂的技术论文变成简单解释的摘要。</li>\n<li>即时问答，回答与你的文档相关的难题，立即获得易于理解的答案。</li>\n<li>提高写论文速度，可根据您的文件自动创建新的paper，快速为报告、论文和各种任务生成详细的见解。</li>\n</ul>'),
                                                                        (583,	0,	0,	'<p>字语智能是国内最早一批在AIGC领域扎根的产品，一站式智能Office内容创作平台。</p>\n<p>字语智能倡导以人机协作的方式，提高办公生产效率为目标，在多场景多模态下用AI重塑未来新办公方式！字语智能可以快速生成文章、报告、新媒体爆文、种草文等各类办公场景办公文案；同时提供海量优质模板，覆盖各领域。支持AI一键填充内容，支持文档富文本编辑，使办公更加简单高效；AI工具箱中智能摘要、智能改写、智能纠错、质量检测等，可快速高效提升文档的质量和效果。</p>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/f27897e7120807b.png\"  alt=\"字语智能工作台\" width=\"1280\" height=\"615\">\n<h2>字语智能的主要功能：</h2>\n<p><strong><b>【</b></strong><strong><b>AI创作</b></strong><strong><b>】</b></strong><strong><b>：最佳答案AI问答，精准AI创作，体验智能办公</b></strong></p>\n<p>AI提供最佳答案，解决各类日常生产生活问题。一键生成提纲，智能填充内容，准确传达信息，增强创作者创新性思路，可以节省大量时间精力，提高写作效率。</p>\n<p><strong><b>【</b></strong><strong><b>灵感推荐</b></strong><strong><b>】</b></strong><strong><b>：全面智能的灵感推荐，让你不用为创作发愁</b></strong></p>\n<p>智能筛选各大媒体平台内容整合分析，算法推荐相关领域优质文章与素材内容，一键为您节省80%时间。</p>\n<p><strong><b>【</b></strong><strong><b>AI配图</b></strong><strong><b>】</b></strong><strong><b>直击主题的AI配图，让文章配图一气呵成</b></strong></p>\n<p>文章配图，再也不怕侵权，简单几个文字描述，自动生成想要图片，一键引入文章，节省大量时间寻找素材，高质量配图让好文事半功倍。</p>\n<p><strong><b>【</b></strong><strong><b>创作模板</b></strong><strong><b>】</b></strong><strong><b>多办公场景创作模板，让你的创作更加高效</b></strong></p>\n<p>持续更新的创作模块，覆盖各类日常办公场景，包含种草、娱乐、旅游、科技等，选定创作方向，填充关键词，一键完成文本创作，实现效率和效果的最大化。</p>'),
                                                                        (584,	0,	0,	'<p>Craft AI Assistant 是高颜值文档和笔记工具 Craft 推出的 AI文档助手，可以激发用户创造力，快速优化和生成内容，以提高创作效率。任何用户都可以使用其创意写作、生成想法、校对作品、将文本翻译成任何语言和总结文档。</p>\n<h2>Craft AI Assistant的主要功能</h2>\n<ol>\n<li>更好更快地创作，只需几秒钟便可以生成内容，输入提示，即可生成新闻稿、文章大纲、电子邮件、产品描述等</li>\n<li>总结提炼文档要点，快速生成长篇文档的简短摘要、从笔记中提炼要点、或用简单的语言重写复杂的报告</li>\n<li>修改、重写和翻译文档，一键修复文章拼写和语法、以任何风格重写内容或翻译成任何目标语言</li>\n<li>即时解答，询问AI助手，Craft 便会立即查找相关信息，为你做出解答</li>\n</ol>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/a7a6396dcf38889.png\"  alt=\"使用Craft AI Assistant\" width=\"800\" height=\"450\">\n<h2>如何使用Craft AI Assistant</h2>\n<ol>\n<li>访问Craft的官网，点击右上角的 Try Craft Free 按钮进行免费注册</li>\n<li>登录成功后会自动跳转到Craft的文档空间中，点击New Document创建一个新的文档或者选择一个你感兴趣的模板开始</li>\n<li>在编辑区域输入斜杠/，便可唤起Craft AI Assistant，然后输入提示或者选择预置的指令即可</li>\n</ol>\n<h2>Craft AI Assistant的产品价格</h2>\n<p>Craft AI Assistant 可供所有用户免费使用，不同的订阅计划有以下限制：</p>\n<ul>\n<li>入门免费版：每 30 天 50 次请求</li>\n<li>个人专业版：每 30 天 250 次请求</li>\n<li>商业计划版：每 30 天 1000 次请求</li>\n</ul>'),
                                                                        (585,	0,	0,	'<p>司马阅(SmartRead)，是一款AI文档阅读分析工具，基于AI人工智能技术、智能文档技术，快速从复杂文档提取信息。 通过聊天互动形式，精准、灵活地获取关键信息及灵感，极大节省文档阅读和信息检索时间，高效应用于工作、学习场景，如读行业市场报告、产品手册、法律文档、论文文献、电子书等。</p>\n<h2>应用场景：</h2>\n<ol>\n<li>帮律师/商务人士分析合同的风险保护倾向</li>\n<li>帮市场/研究人员总结行业报告的发展趋势</li>\n<li>帮HR/团队管理者判断专业简历的技能水平</li>\n<li>帮营销/产品人员提炼产品手册的关键卖点</li>\n<li>帮学生/教师群体概括研究论文的核心要点</li>\n</ol>\n<h2>产品特点：</h2>\n<ol>\n<li>支持复杂图表文档分析总结，可分析文档中的图表。</li>\n<li>支持万字超长文本分析，如粘贴公号文章、工作汇报等提炼总结。</li>\n<li>支持100多种语言。跨语言提问、对话，例如用中文与英文报告对话。</li>\n<li>支持多文档、跨文档分析，智能提炼不同文档之间的关联性和共同点。</li>\n</ol>'),
                                                                        (586,	0,	0,	'<p>云一朵是百度网盘最新推出的可以和用户对话的智能网盘助理，旨在为用户提供最便捷的网盘使用体验，提高用户的生活、学习和办公效率。</p>\n<h2>云一朵的功能</h2>\n<p>百度网盘云一朵能支持很多智能能力，包括：视频智能配字幕、音视频智能转文稿、视频转课件、智能扫描、描述特征搜索网盘图片等。此外，全新版百度网盘云一朵还可以：</p>\n<ol>\n<li>问答：基于盘内文档，帮你答疑解惑</li>\n<li>总结：选择一篇文档，帮你写一段摘要</li>\n<li>创作：帮你写文章、写故事、还能帮你写诗</li>\n<li>翻译：学英语的时候，就是你的英语小助手</li>\n</ol>'),
                                                                        (587,	0,	0,	'<h2>百度文库AI助手是什么</h2>\n<p>百度文库AI助手是百度基于文心一言重构的一站式智能文档助手，可帮助用户高效解答问题，辅助进行内容创作、内容总结、PPT编辑等，并且助力激发灵感和想象。在大模型的加持下，百度文库AI助手为用户提供更加智能和个性化的文档服务，支持学习、工作、生活多个场景，覆盖文档处理全流程，让文档创作更加高效和专业。</p>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/461b5ef35fb8ef7.png\"  alt=\"百度文库AI助手\" width=\"800\" height=\"479\">\n<h2>百度文库AI助手的主要功能</h2>\n<ol>\n<li>智能生成PPT：用户只需要输入主题或上传文档，甚至“动动嘴”发送一条语音指令，即可快速生成PPT</li>\n<li>智能文章创作：通过多轮对话交互，百度文库可以进行头脑风暴、模版写作、大纲写作、文章润色、缩写扩写等</li>\n<li>智能文档总结：一键总结长达万字复杂文档，帮助用户进行更高效的文档学习</li>\n<li>智能文档问答：解决文档疑点，只需轻松一点唤醒百度文库AI，根据文章内容回答相关问题</li>\n<li>智能图表生成：提取关键数据，轻松生成图表，并提供专业的数据分析</li>\n</ol>'),
                                                                        (588,	0,	0,	'<p>通义智文是阿里云推出的基于通义大模型的免费AI阅读助手，可智能阅读网页、论文、图书和文档，帮助用户在更短的时间内精读文章内容，获取提要和概述，快速掌握要点，提高阅读效率。同时支持自由提问，可解答用户关于文章的问题或其他不解之处。</p>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/cbe2ae1ebd41615.png\"  alt=\"通义智文阅读助手\" width=\"800\" height=\"450\">\n<h2>通义智文的产品功能</h2>\n<ol>\n<li>网页阅读。输入网页链接，即可快速总结网页内容和主要观点</li>\n<li>论文阅读。上传学术论文，快速提炼论文的精华知识，让你速读论文</li>\n<li>图书阅读。导入电子书籍，即可分章节整理书籍内容和大纲，轻松阅读</li>\n<li>自由阅读。添加各类文档，辅助分析长文档关键内容</li>\n</ol>\n<h2>如何使用通义智文</h2>\n<ol>\n<li>访问通义智文的官网，点击立即使用</li>\n<li>输入手机号登录/注册账号</li>\n<li>登录成功后便会自动进入通义智文的后台界面</li>\n<li>选择你感兴趣的智能阅读方式，上传你的文档或选择示例文章</li>\n<li>通义智文便会自动为你生成文章导读，也可以输入对话询问</li>\n</ol>'),
                                                                        (589,	0,	0,	'<p>星火文档问答是科大讯飞推出的基于讯飞星火认知大模型的AI文档问答和知识库方案，提供Al分析、阅读、问答工具，可帮助用户高效检索文档信息，准确回答专业问题，让大模型助你高效解读文档内容。</p>\n<img  class=\"alignnone size-full rounded shadow-sm\" src=\"/uploadfile/202312/c9e0b44088c7f5e.png\"  alt=\"讯飞星火文档问答\" width=\"800\" height=\"436\">\n<h2>星火文档问答的主要功能</h2>\n<ol>\n<li>知识库问答：让大模型根据文档内容回答问题，更可创建知识库聚合多文档，一次提问遍历领域知识。</li>\n<li>原文定位：面对海量技术文档和规章制度，使用文档问答， 快速检索所需知识，便捷定位内容出处。</li>\n<li>文档总结：文档太多难以通读，快用文档总结，自动总结文档概要，快速了解文档内容。</li>\n<li>多模式问答：预设多种问答模式，可精炼可详细，自主编排回答语气，服务各种场景需要。</li>\n<li>自定义切分：根据文档结构自主选择切分方法，优化分段结果，提升问答效果。</li>\n</ol>\n<h2>如何使用星火文档问答</h2>\n<ol>\n<li>访问星火文档问答的官网（chatdoc.xfyun.cn），点击立即体验按钮，进入问答界面</li>\n<li>选择上传文件或者点击右上角的登录，然后登录/注册讯飞账号，登录成功后会自动返回工作台</li>\n<li>上传你的文档，然后便可以与星火对话提起关于文档内容的问题</li>\n<li>你还可以切换标准模式、严格模式、客服模式或自定义模式来进行对话</li>\n</ol>\n<h2>常见问题</h2>\n<div id=\"accordion\" style=\"max-width: 700px;\">\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>星火文档问答是免费的吗？</strong></div>\n<div class=\"card-body text-sm\">星火文档问答目前可供用户免费使用，暂未推出付费计划。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>星火文档问答支持一次上传多个文件吗？</strong></div>\n<div class=\"card-body text-sm\">星火文档问答允许用户一次性上传多个文件进行问答，并且还可以对上传后的文件进行管理。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>星火文档问答支持上传哪些格式的文件？</strong></div>\n<div class=\"card-body text-sm\">星火文档问答支持常见的文档和文本格式，如pdf、doc、txt、md等。</div>\n</div>\n</div>'),
                                                                        (590,	0,	0,	'<h2>PDF.ai是什么</h2>\n<p>PDF.ai是一个人工智能PDF文档阅读工具，支持上传PDF文件与文档内容进行聊天交流，用户可就PDF文件提出问题、获取摘要、查找信息等。PDF.ai利用GPT技术从PDF文档中提取和解释数据，使处理长篇文档内容变得更容易、更高效。无论是电子书籍、研究论文，还是法律协议、财务报告，PDF.ai都能轻松智能阅读，并会高亮定位你提问回复的文件段落来源。</p>\n<img  class=\"alignnone size-full rounded shadow-sm\" src=\"/uploadfile/202312/2302d6bbc819cc1.png\"  alt=\"PDF.ai\" width=\"794\" height=\"450\">\n<h2>PDF.ai的主要功能</h2>\n<ol class=\"text-md\">\n<li>PDF文件提问总结：用户可上传PDF文件就文件内容进行提问，获取文件信息</li>\n<li>AI简历扫描：获取简历概览和问题以评估面试候选人</li>\n<li>AI发票扫描：识别发票文件和数据转换成JSON格式的数据</li>\n<li>AI测验生成：将上传的PDF文档生成教学测验问题</li>\n</ol>\n<h2>PDF.ai的应用场景</h2>\n<ol class=\"text-md\">\n<li>书籍阅览：沉浸式阅读体验，与你喜欢的书籍聊天</li>\n<li>论文快读：快速获取研究论文重点和主要内容</li>\n<li>财务报告：像专业人士一样快速了解财报研报</li>\n<li>产品手册：直接与产品手册对话，解决使用疑问</li>\n<li>法律文件：解释令人头痛的法律术语</li>\n<li>培训文档：互动式轻松搞定员工培训文档</li>\n</ol>\n<h2>PDF.ai的产品价格</h2>\n<ol class=\"text-md\">\n<li>免费版，支持上传1个文件，每月可提问500次，单个支持10MB最大文件</li>\n<li>专业版10美元每月，支持上传100个文件，每月可提问5000次，单个支持50MB最大文件</li>\n<li>旗舰版20美元每月，支持上传无限个文件和无限次提问，单个支持50MB最大文件</li>\n<li>企业版30美元每月，支持上传无限个文件和无限次提问，单个支持100MB最大文件</li>\n</ol>\n<h2>如何使用PDF.ai</h2>\n<ol class=\"text-md\">\n<li>访问PDF.ai的官网，点击Get started for free登录注册，或着你也可以点击Try the demo查看示例文件</li>\n<li>登录后，点击Upload按钮上传你的PDF文件（支持从URL导入和OCR）</li>\n<li>上传文件后，左侧是文档预览区，右侧可以对PDF.ai发起提问</li>\n<li>在输入框中输入你感兴趣的问题，如果不知道问什么，也可以点击PDF.ai根据文档内容整理的一些问题</li>\n<li>PDF.ai回答问题后，还会在左侧高亮和定位其回复的段落来源</li>\n</ol>\n<h2>常见问题</h2>\n<div id=\"accordion\" style=\"max-width: 700px;\">\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>PDF.ai是免费的吗？</strong></div>\n<div class=\"card-body text-sm\">PDF.ai提供免费试用的版本，用户可免费上传1个PDF文件进行提问。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>PDF.ai基于什么大模型？</strong></div>\n<div class=\"card-body text-sm\">PDF.ai的智能阅读能力基于OpenAI的GPT大模型，免费版基于GPT-3.5，付费版支持GPT-4。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>PDF.ai支持哪些语言？</strong></div>\n<div class=\"card-body text-sm\">理论上PDF.ai支持所有语言，只要GPT能识别的，PDF.ai都可以阅读，并且支持以一种语言提问另一种语言的文件，比如使用中文对英语文件内容进行提问。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>PDF.ai支持哪些格式的文件？</strong></div>\n<div class=\"card-body text-sm\">目前PDF.ai只支持上传.pdf格式的文件，后续会支持更多格式的文件。</div>\n</div>\n</div>'),
                                                                        (591,	0,	0,	'<p>AI语音转写文字，有助于记录、转录、总结和共享会议对话，最大限度提高内部会议和面向客户会议价值。</p>'),
                                                                        (592,	0,	0,	'ChatGPT驱动的AI会议转录工具'),
                                                                        (593,	0,	0,	'AI会议内容生成和实时转录'),
                                                                        (594,	0,	0,	'AI会议转录和会议纪要生成工具'),
                                                                        (595,	0,	0,	'<p><span data-font-family=\"default\">麦耳会记是思必驰旗下一款集实时语音转写，实时翻译、AI摘要分析等功能为一体的应用软件，主要应用于办公会议、学生网课、客户访谈录音等场景。软件支持边录音、边转写，录音结束后，音频、文本实时同步至PC端、手机端。</span></p>\n<ul>\n<li><span data-font-family=\"default\">在线会议录音，同步转文字，重点信息随时记录</span></li>\n<li><span data-font-family=\"default\">音视频文件转写文字，区分说话人，一键生成AI摘要</span></li>\n<li><span data-font-family=\"default\">双语字幕同传，提升会议效率</span></li>\n</ul>'),
                                                                        (596,	0,	0,	'科大讯飞推出的AI智能会议系统，实时字幕、实时翻译、自动生成会议记录'),
                                                                        (597,	0,	0,	'飞书智能会议纪要和快捷语音识别转文字'),
                                                                        (598,	0,	0,	'<p>职徒简历（52cv.com）是一款智能的专业简历制作平台，支持在电脑，小程序，APP同步进行简历创建，一键排版，简历智能评测，基于GPT的一键简历优化和简历代写，一键简历翻译，拥有海量模板和专业的案例，上百位各行业的大咖导师在线进行简历和职业辅导，提升你的就业综合竞争力。职徒简历上线一年多以来，帮助数百万求职者成功优化个人简历，提升职场竞争力。</p>'),
                                                                        (599,	0,	0,	'AI时间管理跟踪软件'),
                                                                        (600,	0,	0,	'Raycast推出的Mac AI助手，智能写作、编程、回答问题等'),
                                                                        (601,	0,	0,	'基于ChatGPT的Chrome浏览器扩展，浏览任意网页时利用GPT'),
                                                                        (602,	0,	0,	'ChatGPT驱动的Chrome浏览器AI助手插件'),
                                                                        (603,	0,	0,	'<p>Zapier是国外最为知名和流行的自动化集成平台，该平台提供各种基于网络应用的流程自动化集成服务，用户或者开发人员无需阅读复杂的API文档和对接API，便可以将不同的在线应用相互集成，在满足设定的条件下触发某个特定的任务。比如你可以将Slack和Salesforce集成、Gmail与Google Sheets、Mailchimp集成等。</p>\n<p>而在Zapier AI 的帮助下，构建自动化任务将更加简单，用户只需描述想要自动化的内容，其 AI 工具便会自动创建步骤、编写代码并构建 Zaps 应用。比如你想要当 Google Sheets 表格里面添加了一行数据时在Slack协作办公沟通平台上发一条消息，那么你只需输入「I want to create an automation that sends a Slack message when a new row is added in Google Sheets」，Zapier AI 便能帮助你将这两个应用和任务自动化集成。</p>\n<p>通过 Zapier，将 AI 引入你日常使用的应用程序，例如 Slack、Notion、HubSpot 和 Webflow。借助 Zapier 的 30 多个 AI 应用程序合作伙伴，你可以将其与 5,000 多个应用程序的生态系统联系起来，为你的业务关键流程提供支持。</p>'),
                                                                        (604,	0,	0,	'AI将文本输入转换为Excel公式处理'),
                                                                        (605,	0,	0,	'BoloForms推出的AI Excel公式生成工具'),
                                                                        (606,	0,	0,	'将文本转换成Excel或Google Sheets公式'),
                                                                        (607,	0,	0,	'集成了AI功能的在线表格处理工具'),
                                                                        (608,	0,	0,	'AI自动从表格和文档中提取数据'),
                                                                        (609,	0,	0,	'AI将指令转换成Excel的函数公式'),
                                                                        (610,	0,	0,	'Excel和Google Sheets表格AI处理工具'),
                                                                        (611,	0,	0,	'处理Excel和Google Sheets表格的AI工具'),
                                                                        (612,	0,	0,	'AI思维导图和头脑风暴工具'),
                                                                        (613,	0,	0,	'<p>国内知名在线白板工具博思Boardmix推出AI白板功能，生成式AIGC创作模式，实现AI智能问答、AI智能写作、AI绘制思维导图等内容生成能力，释放无尽可能。</p>'),
                                                                        (614,	0,	0,	'在线白板协作工具推出的AI功能，Beta测试中'),
                                                                        (615,	0,	0,	'高颜值AI大纲和思维导图生成'),
                                                                        (616,	0,	0,	'<p>AmyMind是一个轻量小巧的在线AI思维导图工具，无需登录、注册、下载安装，在线打开即用，选中相应节点后鼠标右键便可AI自动生成同级节点或子节点。AmyMind支持多种文件格式，导入freemind格式、markdown文件，导出为Word、PNG、freemind和markdown文件。</p>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/0b59bfdd002a002.png\"  alt=\"\" width=\"800\" height=\"418\">'),
                                                                        (617,	0,	0,	'Whimsical推出的AI思维导图工具'),
                                                                        (618,	0,	0,	'<p>ChatMind是国内的开发者团队推出的AI思维导图工具，可以应用于笔记、日程安排、项目管理、头脑风暴、框架等多种场景。该工具不仅可以帮助用户快速总结和分析，还可以持续提供创意灵感。</p>'),
                                                                        (619,	0,	0,	'<p>作为一个思维导图的工具，GitMind最想要的不是简单的给大家介绍ChatGPT到底有什么用，而是能够直接的让大家无障碍的体验到AI的魅力。</p>\n<p>当GitMind应用与AI深度融合后，能发光发热的场景就多啦！和思乎AI机器人对话，促进创造性和创新性思维，让你的思想流淌起来。GitMind的网页端、手机端和iPad端均可体验</p>\n<h2>GitMind思乎AI可以做什么？</h2>\n<ol>\n<li>轻松制作读书笔记：思维导图最常用的场景就是制作读书笔记了，思乎AI高效提升制作读书笔记的方法！确定你想要制作读书笔记的内容，接着只需要向它提问：“请以大纲形式生成XX书籍的思维导图”</li>\n<li>提升信息检索效率：演讲报告、工作总结，问题分析只要你想到了你的主题内容，直接提问思乎AI机器人，它就会进行思考然后给你答案。</li>\n<li>头脑风暴，激发灵感：每次头脑风暴的时候，没有灵感没有思路的情形在每个会议室不停复现，AI+GitMind就可以解决这个问题了！确定头脑风暴的主题后，先交给AI，让它给出几个解决方案参考，再通过协作模式，大家共创脑图，相互补充，激发灵感，激发创意，思维流淌。</li>\n<li>分析问题，拓宽思路：遇到问题觉得自己想的答案不全面？思乎AI可以回答各种问题，提供信息和建议，从而能够帮助你获得不同的观点和见解，考虑更多的可能性。</li>\n<li>智能算法，协助选择：当你做旅行攻略的时候，不知道去哪问，可以咨询它一下；当你列购买清单，多个产品不知如何选择，也可以问问思乎AI的建议，礼物推荐。AI能够轻松帮你提炼关键点，做出智能决策。</li>\n<li>辅助分析，省时省力：思乎AI可以用于各种文本分析任务，为你提供有关问题的深入理解和见解，例如：“针对办公SaaS软件做一个商业分析”、“帮我做一份思维导图软件的SWOT分析”</li>\n</ol>\n<p> </p>'),
                                                                        (620,	0,	0,	'<div class=\"IntroduceBox_h2__jED80\">\n<div>妙办是一个小白秒会的专业级办公画图工具，无需掌握复杂操作，便可以让你零基础轻松绘制海量绘图类型。最新推出的妙办AI流程图，可以只需输入主题，便智能自动生成各种类型的流程图，如旅游攻略流程图、组织架构流程图、教资报名流程图、教学思路流程图等。</div>\n</div>'),
                                                                        (621,	0,	0,	'<p>Xmind Copilot是国内知名的思维导图软件Xmind推出的基于GPT的AI思维导图助手，可帮助用户一键拓展思路，基于思维导图结构高效生成文章，让你的文章创作更高效、更流畅、更具无限想象。</p>\n<p>Xmind Copilot主要拥有四大功能：</p>\n<ul>\n<li>One-liner：一句话生成思维导图</li>\n<li>Inspire Me：一键提供灵感和思路</li>\n<li>Outliner：一键总结文章思路</li>\n<li>Ghostwriter：一键帮你高效成文</li>\n</ul>'),
                                                                        (622,	0,	0,	'<p>知犀AI是知犀思维导图和AI技术结合推出的AI思维导图生成工具，只需输入主题或关键词，即可自动创建结构清晰的脑图。用户可以利用知犀的AI思维导图功能更加高效地整理思路、管理内容、激发灵感，如生成读书笔记、计划方案、项目策划、旅游攻略、故事框架等。使用知犀AI很简单，只需访问知犀AI的官网（swdt.com），输入内容主题，点击AI生成，然后登录注册账号，等待片刻便能生成思维导图框架。</p>\n<img  class=\"alignnone size-full rounded-lg\" src=\"/uploadfile/202312/3b7f6d9a70be4a5.jpeg\"  alt=\"知犀AI思维导图\" width=\"800\" height=\"450\">\n<h2>知犀AI的产品价格</h2>\n<ol>\n<li>免费版：用户注册后可获得500能量值，1能量值可以生成约10个字</li>\n<li>付费版：9.9元1万能量值、25.9元5万能量值、45.9元10万能量值、199.9元50万能量值</li>\n</ol>'),
                                                                        (623,	0,	0,	'<div class=\"_3ygOc lg-fl \">\n<p>作为深受印象笔记用户喜爱的产品之一，「印象图记」在「印象AI」能力的加持下，现已具备了自动生成思维导图的能力，帮助用户理清思路、拓展思维。用户每天可免费使用 20 次 印象AI 体验生成思维导图和大纲笔记。</p>\n</div>\n<div class=\"_3ygOc lg-fl \">\n<p>在「印象图记」桌面端中，点击左侧「印象AI」的图标即可唤醒AI助手，在对话框中输入想发散的内容主题，点击应用至导图，即可将内容以思维导图形式呈现。此外，选择某一节点,点击工具栏的「印象AI」图标，用户还可以对节点的内容进行智能扩写，令思绪无限延伸。</p>\n<img  class=\"alignnone size-full\" src=\"/uploadfile/202312/f14b271bda0cd94.png\"  alt=\"印象图记AI\" width=\"800\" height=\"446\">\n</div>'),
                                                                        (624,	0,	0,	'<h2>ProcessOn是什么</h2>\n<p>ProcessOn是一款专业的在线流程图和思维导图制作工具，今年 3 月 ProcessOn 联合科大讯飞星火认知大模型，成为国内首发AIGC+流程图的平台，可输入主题借助AI快速生成流程图、思维导图，降低创作成本，提质增效。无论是流程图梳理、活动方案、工作计划、知识总结、学习书单，还是读书笔记、头脑风暴、旅游攻略、生活小提醒，ProcessOn的AI创作助理都可以搞定，让流程图和思维导图的创作更便捷。</p>\n<img  class=\"alignnone size-full rounded shadow-sm\" src=\"/uploadfile/202312/664456f64d5ab2f.png\"  alt=\"ProcessOn AI流程图\" width=\"800\" height=\"452\">\n<h2>ProcessOn的AI功能</h2>\n<ol class=\"text-md\">\n<li>一键创作流程图：输入主题关键词，只需一键，围绕主题的流程图会跃然纸上，内容简洁清晰，逻辑直观严谨，简化了绘制流程，降低了创作门槛，提高了创作速度，革新了创作模式，又尽可能保证了内容的客观性和通用性。</li>\n<li>一键创作思维导图：输入主题关键词，只需一键，3秒完成辞简义赅的思维导图内容大纲，如脑机交互，突破灵感边界，收获优质答卷，享受极致体验。</li>\n<li>一键创作更多图形：输入主题，选择你想要生成的图形类型，时序图、组织结构图、类图统统不在话下，一键AI进行图形内容绘制。</li>\n<li>与讯飞星火无缝融合：支持在讯飞星火认知大模型的聊天窗口中，直接调用ProcessOn进行流程图的绘制，进一步解放了生产力和释放了想象力。</li>\n</ol>\n<h2>如何使用ProcessOn的AI功能</h2>\n<ol class=\"text-md\">\n<li>访问ProcessOn的官网（processon.com），点击【免费使用】</li>\n<li>登录/注册账号，登录成功后会自动跳转到后台界面，下面以AI生成流程图为例</li>\n<li>点击新建，选择流程图，然后点击工具栏右侧【AI】按钮</li>\n<li>在流程图、时序图、组织结构图、时间轴和类图5种图形中选择一种你要生成的图形类型</li>\n<li>在提问框中输入你要绘制的内容，点击【AI创作】，等待内容生成</li>\n</ol>\n<h2>常见问题</h2>\n<div id=\"accordion\" style=\"max-width: 700px;\">\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>ProcessOn的AI功能是免费的吗？</strong></div>\n<div class=\"card-body text-sm\">目前，ProcessOn的AI创作能力限时免费向所有用户开放。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>ProcessOn的AI功能基于什么大模型？</strong></div>\n<div class=\"card-body text-sm\">ProcessOn的AI生成能力基于科大讯飞的「星火认知大模型」。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>ProcessOn的AI功能支持哪些系统？</strong></div>\n<div class=\"card-body text-sm\">ProcessOn的AI功能支持在网页端和微信小程序上使用，移动端APP即将支持。</div>\n</div>\n</div>'),
                                                                        (625,	0,	1,	'AI SEO长内容创作'),
                                                                        (626,	0,	1,	'AI内容营销和SEO助手'),
                                                                        (627,	0,	1,	'AI写作能手'),
                                                                        (628,	0,	1,	'AI SEO内容优化和写作工具'),
                                                                        (629,	0,	1,	'企业级和电商文案生成'),
                                                                        (630,	0,	1,	'释放你的写作潜力'),
                                                                        (631,	0,	1,	'你的个人写作助手和编辑'),
                                                                        (632,	1,	1,	'英语写作优化和修改工具'),
                                                                        (633,	0,	1,	'AI SEO大纲和内容优化写作工具'),
                                                                        (634,	0,	1,	'AI创作SEO优化友好的文案和文章'),
                                                                        (635,	0,	1,	'AI文章写作'),
                                                                        (636,	0,	1,	'无限制免费AI文案写作'),
                                                                        (637,	0,	1,	'AI长文章写作工具'),
                                                                        (638,	0,	0,	'<p>快转字幕是由广州比高网络科技推出的一款语音视频转文字字幕的平台，可智能识别音视频内容，将其转录为文字版本。该工具通过先进的语音识别技术，高效省时地为无字幕音视频添加高准确率的字幕，避免了传统手工打字或使用低质量转录工具后所需的繁琐手动校正，提升了自媒体工作者在视频制作中的工作效率。此外，快转字幕不仅提供快速、准确的字幕服务，还支持多种语言和字幕翻译功能，使内容创作者能够更容易地触及全球观众。</p>\n<h2>快转字幕的主要功能</h2>\n<ol>\n<li><strong>智能语音视频转字幕</strong>：上传音视频文件或复制URL，即可快速生成文字字幕</li>\n<li><strong>支持多种语言和方言</strong>：可识别和转录超过99种语言、方言</li>\n<li><strong>AI自动识别简介</strong>：智能识别音视频内容，自动生成摘要和亮点</li>\n<li><strong>字幕翻译</strong>：提供谷歌翻译和AI大模型翻译，一键将字幕翻译为目标语种</li>\n<li><strong>提供多种字幕格式下载</strong>：可导出转录结果，支持SRT、ASS、LRC、TXT、VTT、MD等格式</li>\n</ol>\n<h2>如何使用快转字幕</h2>\n<ol>\n<li>访问快转字幕的官网（kzzimu.com），点击右上角的注册/登录按钮</li>\n<li>登录成功后，在首页上传你要转录的音视频文件或者粘贴音视频URL，然后点击开始转录</li>\n<li>稍等一会儿，便能智能生成字幕，具体等待时间视音视频大小和长度</li>\n<li>生成的字幕可以翻译和下载</li>\n</ol>\n<img  class=\"alignnone size-full rounded-lg shadow-sm\" src=\"/uploadfile/202312/697a7ab27194804.png\"  alt=\"快转字幕\" width=\"600\">\n<h2>快转字幕的产品价格</h2>\n<ol>\n<li>免费版：新用户注册后即可获得60积分用于转录/翻译音视频或转录稿</li>\n<li>12元60积分，可以转录/翻译60分钟音视频/音视频转录稿，有效期180天</li>\n<li>48元300积分，可以转录/翻译300分钟音视频/音视频转录稿，有效期180天</li>\n<li>136元1000积分，可以转录/翻译1000分钟音视频/音视频转录稿，有效期360天</li>\n</ol>\n<img  class=\"alignnone size-full rounded-lg\" src=\"/uploadfile/202312/57f0cf6713e1f41.png\"  alt=\"快转字幕价格\" width=\"600\">\n<h2>快转字幕的应用场景</h2>\n<ol>\n<li>视频制作者：一键操作即可给视频添加精确字幕，优化观众的观看体验</li>\n<li>音频增强：再也不用担心听不清的音频，智能识别并清晰化音频内容</li>\n<li>学习资源：轻松访问并转录冷门资源的音视频内容，快速提高学习效率</li>\n<li>会议记录：为商务会议或团队讨论生成详细的文字记录，确保不遗漏任何关键信息</li>\n</ol>'),
                                                                        (639,	0,	0,	'<p>JetBrains AI是编程软件开发公司JetBrains最新为其旗下系列IDE推出的类似于GitHub Copilot的AI编程助手，可与IntelliJ IDEA、PyCharm、PhpStorm、ReSharper、Fleet等集成开发环境工具深度整合，提供代码聊天、代码生成、上下文代码分析、代码解释、代码翻译等功能，帮助开发人员提高开发效率和代码质量。</p>\n<img  class=\"alignnone size-full rounded-lg\" src=\"/uploadfile/202312/f183fad6b3d77e6.jpeg\"  alt=\"JetBrains AI\" width=\"700\">\n<h2>JetBrains AI的主要功能</h2>\n<ol>\n<li>回答代码问题：内置AI编程助手聊天工具，可与大模型提问对话</li>\n<li>解释代码：可在代码编辑器中选择代码，向AI询问特定的代码片段</li>\n<li>生成Git提交消息：可使用AI助手生成Git版本控制更改消息</li>\n<li>生成声明文档：可生成Java、Kotlin、Python等编程语言的文档</li>\n<li>代码翻译转换：可以将代码从一种编程语言转换为另一种编程语言</li>\n<li>AI生成测试：智能分析代码和文档，为代码片段生成单元测试</li>\n</ol>\n<h2>JetBrains AI的产品价格</h2>\n<p>JetBrains AI需要用户先购买了其旗下任一IDE的许可证后，激活许可证后才可以免费试用JetBrains AI。AI功能付费订阅价格为个人专业版8.33美元一个月。</p>'),
                                                                        (640,	0,	0,	'<p>Ollama是一个用于在本地计算机上运行大型语言模型的命令行工具，允许用户下载并本地运行像Llama 2、Code Llama和其他模型，并支持自定义和创建自己的模型。该免费开源的项目，目前支持macOS和Linux操作系统，未来还将支持Windows系统​​​​。</p>\n<p>此外，Ollama还提供了官方的Docker镜像，由此使用Docker容器部署大型语言模型变得更加简单，确保所有与这些模型的交互都在本地进行，无需将私有数据发送到第三方服务。Ollama在macOS和Linux上支持GPU加速，并提供了简单的命令行界面（CLI）以及用于与应用程序交互的REST API​​。</p>\n<p>该工具对于需要在本地机器上运行和实验大语言模型的开发人员或研究人员来说特别有用，无需依赖外部云服务。</p>\n<h2>Ollama支持的模型</h2>\n<p>Ollma提供一个模型库，用户可以自行选择安装想要运行的模型，目前支持40+的模型，还在持续增加中，以下是可以下载的开源模型示例：</p>\n<table>\n<thead>\n<tr>\n<th>模型</th>\n<th>参数大小</th>\n<th>文件大小</th>\n<th>下载运行命令</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n<td>Neural Chat</td>\n<td>7B</td>\n<td>4.1GB</td>\n<td><code>ollama run neural-chat</code></td>\n</tr>\n<tr>\n<td>Starling</td>\n<td>7B</td>\n<td>4.1GB</td>\n<td><code>ollama run starling-lm</code></td>\n</tr>\n<tr>\n<td>Mistral</td>\n<td>7B</td>\n<td>4.1GB</td>\n<td><code>ollama run mistral</code></td>\n</tr>\n<tr>\n<td>Llama 2</td>\n<td>7B</td>\n<td>3.8GB</td>\n<td><code>ollama run llama2</code></td>\n</tr>\n<tr>\n<td>Code Llama</td>\n<td>7B</td>\n<td>3.8GB</td>\n<td><code>ollama run codellama</code></td>\n</tr>\n<tr>\n<td>Llama 2 Uncensored</td>\n<td>7B</td>\n<td>3.8GB</td>\n<td><code>ollama run llama2-uncensored</code></td>\n</tr>\n<tr>\n<td>Llama 2 13B</td>\n<td>13B</td>\n<td>7.3GB</td>\n<td><code>ollama run llama2:13b</code></td>\n</tr>\n<tr>\n<td>Llama 2 70B</td>\n<td>70B</td>\n<td>39GB</td>\n<td><code>ollama run llama2:70b</code></td>\n</tr>\n<tr>\n<td>Orca Mini</td>\n<td>3B</td>\n<td>1.9GB</td>\n<td><code>ollama run orca-mini</code></td>\n</tr>\n<tr>\n<td>Vicuna</td>\n<td>7B</td>\n<td>3.8GB</td>\n<td><code>ollama run vicuna</code></td>\n</tr>\n</tbody>\n</table>'),
                                                                        (641,	0,	0,	'<p>Remini是一个借助AI技术将模糊照片变高清和老照片修复的工具，该AI修图工具在全球累计已超过数百万人使用。Remini利用先进的AI算法，分析照片中的现有元素并智能填补缺失的图像细节，如增强纹理、校正颜色和平滑边缘等，以使照片中的主体和对象更加清晰，从而提升图像的画质和清晰度。该工具支持移动端APP和网页版使用，适用于修复家庭旧照片、提高低分辨率相机拍摄的图像质量、从网络下载的模糊图片、修复因年久失修或保存不当而损坏的照片。</p>\n<img  class=\"alignnone size-full rounded-lg\" src=\"/uploadfile/202312/5a4e6b5aa89ede4.jpeg\"  alt=\"Remini网页版\" width=\"650\">\n<h2>Remini的主要功能</h2>\n<ol>\n<li><strong>模糊照片变高清</strong>：只需点击一下，即可把上传的模糊低质量照片变得清晰高质量</li>\n<li><strong>去除照片噪点</strong>：清除照片中的颗粒和噪点，让图像变得更加清晰、流畅、锐利</li>\n<li><strong>老照片修复</strong>：利用AI技术快速修复褪色、退化或损坏的老旧照片，让其看起来和新的一样</li>\n<li><strong>放大图片尺寸</strong>：支持将图片放大到原来的2倍，在放大尺寸的同时提高质量不丢失图像细节</li>\n<li><strong>智能色彩增强</strong>：自动色彩改进功能可增强、平衡图像的色调、色彩、曝光度、饱和度和鲜艳度</li>\n<li><strong>面部细节美化</strong>：智能优化人物面部细节，提供去除皮肤瑕疵、自动调整打光和颜色、提亮五官等</li>\n<li><strong>视频画质变高清</strong>：将视频的质量和尺寸放大2倍，让视频画面告别模糊、陈旧或低质量的镜头</li>\n</ol>\n<img  class=\"alignnone size-full rounded-lg\" src=\"/uploadfile/202312/bd68a327924317b.png\"  alt=\"Remini AI照片修复\" width=\"650\">\n<h2>Remini的产品价格</h2>\n<ol>\n<li>个人版：周付6.99美元、月付17.99美元、年付179.99美元，每周可提升20张照片的画质，下载照片无水印</li>\n<li>商业版：周付9.99美元、月付24.99美元、年付249.99美元，不限制照片处理张数，支持批量上传和商业使用</li>\n</ol>\n<h2>Remini的应用场景</h2>\n<ol>\n<li>社交媒体：改善和提升社交媒体平台的个人资料和摄影照片</li>\n<li>家庭照片：恢复旧的、褪色的或损坏的家庭照片，帮助保留珍贵的记忆</li>\n<li>印刷服务：增强低分辨率图像质量，确保打印版本的清晰度</li>\n<li>电子商务：提高产品营销图的画质，进一步吸引用户注意力</li>\n<li>杂志文章：为文章添加更加高清的图片，增加读者兴趣</li>\n</ol>\n<h2>常见问题</h2>\n<div id=\"accordion\" style=\"max-width: 700px;\">\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>Remini提供免费版本吗？</strong></div>\n<div class=\"card-body text-sm\">Remini提供免费试用体验的版本，用户可上传照片查看修复的效果，但只能预览且带有水印。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>Remini支持哪些平台？</strong></div>\n<div class=\"card-body text-sm\">Remini支持Android和iOS移动端以及在线网页版使用，还提供Photoshop插件。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>Remini APP版和网页版有什么区别？</strong></div>\n<div class=\"card-body text-sm\">Remini网页版相比移动端APP提供更多专业灵活的图像编辑功能。</div>\n</div>\n</div>'),
                                                                        (642,	0,	0,	'<p>Logo Diffusion是一个利用生成式AI智能生成和创建Logo标志的工具，无需掌握专业的设计能力，输入文本提示词后即可生成多种风格的Logo和标志，如卡通、绘画、抽象、徽标、水彩、像素画等。生成的Logo还支持将图像文件导出为透明背景的PNG或矢量文件，以便后续修改或在线直接使用。</p>\n<img  class=\"alignnone size-full rounded-lg\" src=\"/uploadfile/202312/828f2484ebf8d7d.jpeg\"  alt=\"Logo Diffusion\" width=\"650\">\n<h2>Logo Diffusion的主要功能</h2>\n<ol>\n<li>文本生成Logo：只需输入简单的文本提示词即可快速创建漂亮的Logo标志</li>\n<li>Logo重新设计：将现有的Logo标志智能转换成新的设计风格</li>\n<li>草图转Logo：上传基本的草图轮廓，AI可智能将其转换成专业的Logo</li>\n<li>2D图转3D：将任何平面的2D Logo图像转换成精美的3D风格</li>\n<li>图像转2D：将任何图像或照片转换为简化的Logo或插图</li>\n</ol>\n<h2>如何使用Logo Diffusion</h2>\n<ol>\n<li>访问Logo Diffusion的官网（logodiffusion.com），点击Get Started Free进行注册</li>\n<li>注册登录后会自动跳转到后台工作台界面，选择Start with a text</li>\n<li>在底部输入框中输入文本提示词，可选择Logo风格，然后点击Generate即可</li>\n</ol>\n<h2>Logo Diffusion的产品价格</h2>\n<ol>\n<li>免费版：每月40个积分、2次矢量化、创建的logo需公开、仅个人使用</li>\n<li>基础版：20美元每月，每月1000个积分、75次矢量化、logo无需公开、商业许可</li>\n<li>专业版：40美元每月，每月2500个积分、250次矢量化、logo无需公开、商业许可</li>\n<li>精英版：124美元每月，每月10000个积分、1000次矢量化、logo无需公开、商业许可</li>\n</ol>\n<img  class=\"alignnone size-full rounded-lg\" src=\"/uploadfile/202312/f07ba88542db.jpeg\"  alt=\"Logo Diffusion价格\" width=\"650\">\n<h2>Logo Diffusion的适用人群</h2>\n<ol>\n<li>平面设计师：提供Logo设计灵感和风格参考，加快Logo设计过程</li>\n<li>营销机构：快速创建Logo原型，以便在演示和提案中使用，节省时间和资源</li>\n<li>初创公司/个人企业家：节省设计成本，快速建立品牌/公司Logo开始业务</li>\n</ol>'),
                                                                        (643,	0,	0,	'<p>Audiobox是Meta于2023年11月30日推出的免费开源的AI语音和声音生成模型，12月11日上线在线网页版本，用户可免费体验该模型的能力。Audiobox是Meta继Voicebox后推出的最新一代的音频生成模型，可以结合使用语音输入和自然语言文本提示来生成语音和音效，从而可以轻松地为各种用例创建逼真的自定义音频。</p>\n<img  class=\"alignnone size-full rounded-lg shadow-sm\" src=\"/uploadfile/202312/0720ad690097b1a.jpeg\"  alt=\"Meta Audiobox\" width=\"650\">\n<h2>Audiobox的主要功能</h2>\n<ol>\n<li>克隆用户声音：录制声音按照用户的声音风格或以任意音频样本的风格生成语音</li>\n<li>文本描述生成人声：使用文本描述声音风格的特征以及声学环境生成人声</li>\n<li>更改声音风格：可结合声音和文本描述更改现有的声音风格</li>\n<li>本文描述生成音效：根据输入的声音特征文本描述生成声音效果</li>\n<li>噪音消除：提供Magic Eraser功能消除录音中的瞬态噪声</li>\n<li>声音填充：根据文本描述用新的声音替换音频中的一部分</li>\n<li>音频故事制作器：结合以上功能，利用Audiobox Maker制作原创有趣的音频故事</li>\n</ol>'),
                                                                        (644,	0,	0,	'<p>Solo（Solo AI Website Composer）是火狐浏览器的母公司Mozilla最新推出的一个创新项目——面向个人企业家、自由职业者的一个人工智能网站创建工具。借助AI的能力，用户无需具有编程经验和代码知识，输入文本提示、可视化添加内容块、图像、布局、主题即可创建精美视觉效果的网页和网站。</p>\n<h2>Solo的主要功能</h2>\n<ol>\n<li>无代码创建网站：只需通过一些简单的输入即可快速生成网页</li>\n<li>搜索引擎优化：智能建议网站SEO Meta关键字、描述等</li>\n<li>响应式设计：自动进行桌面端和移动端响应式网页设计</li>\n<li>评论导入：从社交媒体中获取帖子文本和评论并展示最佳内容</li>\n<li>公司名称生成器：描述公司的主营业务即可生成企业名称</li>\n<li>创业想法生成器：随机为你生成不同行业的创业想法，激发灵感</li>\n</ol>\n<img  class=\"alignnone size-full rounded-lg shadow-sm\" src=\"/uploadfile/202312/6a8fc9f5a099bf3.png\"  alt=\"Solo AI Website Composer\" width=\"700\">\n<h2>如何使用Solo创建网站</h2>\n<ol>\n<li>访问Solo的官网（soloist.ai），点击Build Your Website开始创建网站</li>\n<li>填写初步信息，如业务介绍、企业名称、经营地点等</li>\n<li>进入下一步选择网站字体样式--&gt;选择网站颜色主题</li>\n<li>选择要添加的网站内容版块，如头部、服务介绍、Banner、联系框、底部等</li>\n<li>然后点击Compose your site，等待Mozilla自动生成网页，稍等片刻即可生成完毕</li>\n<li>生成后的网站可以自由修改，也可以点击右上角的Publish进行发布</li>\n</ol>\n<p>AI工具集使用该工具实测了一下，生成的网页还算是简洁大气，若需要快速上线一个网站着陆页，是个还不错的选择。不过，相比于之前介绍的Framer AI建站工具，效果略逊一筹。</p>\n<img  class=\"alignnone size-full rounded-lg shadow-sm\" src=\"/uploadfile/202312/13559b91bff0e28.png\"  alt=\"Solo AI Website Composer\" width=\"700\">\n<h2>常见问题</h2>\n<div id=\"accordion\" style=\"max-width: 700px;\">\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>Solo是免费的吗？</strong></div>\n<div class=\"card-body text-sm\">Solo目前处于免费公测中，所有用户都可以免费使用，后续可能会推出付费版本。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>Solo支持自定义域名吗？</strong></div>\n<div class=\"card-body text-sm\">Solo目前初版暂不支持添加自定义域名，后续会增加该功能。</div>\n</div>\n<div class=\"card\">\n<div class=\"card-header\"><i class=\"fas fa-question-circle mr-2\"></i><strong>Solo生成的网页代码可以导出吗？</strong></div>\n<div class=\"card-body text-sm\">Solo创建好的网页不支持导出代码。</div>\n</div>\n</div>');

DROP TABLE IF EXISTS `fhx_1_webnav_draft`;
CREATE TABLE `fhx_1_webnav_draft` (
                                      `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
                                      `cid` int(10) unsigned NOT NULL COMMENT '内容id',
                                      `uid` mediumint(8) unsigned NOT NULL COMMENT '作者uid',
                                      `catid` mediumint(8) unsigned NOT NULL COMMENT '栏目id',
                                      `content` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '具体内容',
                                      `inputtime` int(10) unsigned NOT NULL COMMENT '录入时间',
                                      PRIMARY KEY (`id`),
                                      KEY `uid` (`uid`),
                                      KEY `cid` (`cid`),
                                      KEY `catid` (`catid`),
                                      KEY `inputtime` (`inputtime`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='内容草稿表';


DROP TABLE IF EXISTS `fhx_1_webnav_flag`;
CREATE TABLE `fhx_1_webnav_flag` (
                                     `flag` tinyint(2) unsigned NOT NULL DEFAULT '1' COMMENT '文档标记id',
                                     `id` int(10) unsigned NOT NULL COMMENT '文档内容id',
                                     `uid` mediumint(8) unsigned NOT NULL COMMENT '作者uid',
                                     `catid` mediumint(8) unsigned NOT NULL COMMENT '栏目id',
                                     KEY `flag` (`flag`,`id`,`uid`),
                                     KEY `catid` (`catid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='标记表';

INSERT INTO `fhx_1_webnav_flag` (`flag`, `id`, `uid`, `catid`) VALUES
                                                                   (1,	442,	1,	5),
                                                                   (1,	404,	1,	13),
                                                                   (1,	510,	1,	15),
                                                                   (1,	402,	1,	5),
                                                                   (1,	519,	1,	13),
                                                                   (1,	508,	1,	15),
                                                                   (1,	494,	1,	15),
                                                                   (1,	399,	1,	3),
                                                                   (1,	139,	1,	13),
                                                                   (1,	28,	1,	1),
                                                                   (1,	491,	1,	15),
                                                                   (1,	497,	1,	15),
                                                                   (1,	500,	1,	15),
                                                                   (1,	513,	1,	15),
                                                                   (1,	428,	1,	5),
                                                                   (1,	431,	1,	5);

DROP TABLE IF EXISTS `fhx_1_webnav_form_fankui`;
CREATE TABLE `fhx_1_webnav_form_fankui` (
                                            `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
                                            `cid` int(10) unsigned NOT NULL COMMENT '内容id',
                                            `catid` mediumint(8) unsigned NOT NULL COMMENT '栏目id',
                                            `uid` mediumint(8) unsigned NOT NULL COMMENT '作者id',
                                            `author` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '作者名称',
                                            `inputip` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '录入者ip',
                                            `inputtime` int(10) unsigned NOT NULL COMMENT '录入时间',
                                            `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '表单主题',
                                            `status` tinyint(1) DEFAULT NULL COMMENT '状态值',
                                            `tableid` smallint(5) unsigned NOT NULL COMMENT '附表id',
                                            `displayorder` int(10) DEFAULT NULL COMMENT '排序值',
                                            `fknr` text COLLATE utf8mb4_unicode_ci COMMENT '反馈内容',
                                            PRIMARY KEY (`id`),
                                            KEY `cid` (`cid`),
                                            KEY `uid` (`uid`),
                                            KEY `catid` (`catid`),
                                            KEY `author` (`author`),
                                            KEY `status` (`status`),
                                            KEY `displayorder` (`displayorder`),
                                            KEY `inputtime` (`inputtime`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='模块表单反馈表';

INSERT INTO `fhx_1_webnav_form_fankui` (`id`, `cid`, `catid`, `uid`, `author`, `inputip`, `inputtime`, `title`, `status`, `tableid`, `displayorder`, `fknr`) VALUES
                                                                                                                                                                 (1,	510,	15,	1,	'',	'127.0.0.1-53175',	1702572876,	'已失效',	0,	0,	0,	'已失效'),
                                                                                                                                                                 (2,	617,	24,	1,	'',	'127.0.0.1-53269',	1702572939,	'重定向&amp;变更',	0,	0,	0,	'重定向&amp;变更'),
                                                                                                                                                                 (3,	617,	24,	1,	'',	'127.0.0.1-53433',	1702573050,	'已失效',	0,	0,	0,	''),
                                                                                                                                                                 (4,	617,	24,	1,	'',	'127.0.0.1-53505',	1702573100,	'重定向&amp;变更',	0,	0,	0,	'url');

DROP TABLE IF EXISTS `fhx_1_webnav_form_fankui_data_0`;
CREATE TABLE `fhx_1_webnav_form_fankui_data_0` (
                                                   `id` int(10) unsigned NOT NULL,
                                                   `cid` int(10) unsigned NOT NULL COMMENT '内容id',
                                                   `catid` mediumint(8) unsigned NOT NULL COMMENT '栏目id',
                                                   `uid` mediumint(8) unsigned NOT NULL COMMENT '作者id',
                                                   UNIQUE KEY `id` (`id`),
                                                   KEY `cid` (`cid`),
                                                   KEY `catid` (`catid`),
                                                   KEY `uid` (`uid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='模块表单反馈附表';

INSERT INTO `fhx_1_webnav_form_fankui_data_0` (`id`, `cid`, `catid`, `uid`) VALUES
                                                                                (1,	510,	15,	1),
                                                                                (2,	617,	24,	1),
                                                                                (3,	617,	24,	1),
                                                                                (4,	617,	24,	1);

DROP TABLE IF EXISTS `fhx_1_webnav_hits`;
CREATE TABLE `fhx_1_webnav_hits` (
                                     `id` int(10) unsigned NOT NULL COMMENT '文章id',
                                     `hits` int(10) unsigned NOT NULL COMMENT '总点击数',
                                     `day_hits` int(10) unsigned NOT NULL COMMENT '本日点击',
                                     `week_hits` int(10) unsigned NOT NULL COMMENT '本周点击',
                                     `month_hits` int(10) unsigned NOT NULL COMMENT '本月点击',
                                     `year_hits` int(10) unsigned NOT NULL COMMENT '年点击量',
                                     `day_time` int(10) unsigned NOT NULL COMMENT '本日',
                                     `week_time` int(10) unsigned NOT NULL COMMENT '本周',
                                     `month_time` int(10) unsigned NOT NULL COMMENT '本月',
                                     `year_time` int(10) unsigned NOT NULL COMMENT '年',
                                     UNIQUE KEY `id` (`id`),
                                     KEY `day_hits` (`day_hits`),
                                     KEY `week_hits` (`week_hits`),
                                     KEY `month_hits` (`month_hits`),
                                     KEY `year_hits` (`year_hits`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='时段点击量统计';

INSERT INTO `fhx_1_webnav_hits` (`id`, `hits`, `day_hits`, `week_hits`, `month_hits`, `year_hits`, `day_time`, `week_time`, `month_time`, `year_time`) VALUES
                                                                                                                                                           (9,	27,	1,	1,	2,	2,	1702390601,	1702390601,	1701873045,	1701873045),
                                                                                                                                                           (47,	20,	1,	1,	1,	1,	1702635428,	1702635428,	1702635428,	1702635428),
                                                                                                                                                           (62,	67,	1,	1,	1,	1,	1702635443,	1702635443,	1702635443,	1702635443),
                                                                                                                                                           (63,	37,	1,	1,	1,	1,	1702738485,	1702738485,	1702738485,	1702738485),
                                                                                                                                                           (69,	33,	1,	1,	2,	2,	1702478012,	1702478012,	1701873129,	1701873129),
                                                                                                                                                           (71,	11,	1,	1,	1,	1,	1702661591,	1702661591,	1702661591,	1702661591),
                                                                                                                                                           (72,	51,	1,	1,	1,	1,	1701873051,	1701873051,	1701873051,	1701873051),
                                                                                                                                                           (76,	61,	3,	3,	3,	3,	1702547656,	1702547656,	1702547656,	1702547656),
                                                                                                                                                           (97,	36,	1,	1,	1,	1,	1703432870,	1703432870,	1703432870,	1703432870),
                                                                                                                                                           (101,	11,	1,	2,	2,	2,	1702567815,	1702475430,	1702475430,	1702475430),
                                                                                                                                                           (136,	101,	1,	1,	1,	1,	1705215078,	1705215078,	1705215078,	1705215078),
                                                                                                                                                           (159,	23,	1,	1,	1,	1,	1703479339,	1703479339,	1703479339,	1703479339),
                                                                                                                                                           (179,	75,	1,	1,	1,	1,	1702741934,	1702741934,	1702741934,	1702741934),
                                                                                                                                                           (181,	78,	1,	1,	1,	1,	1702741959,	1702741959,	1702741959,	1702741959),
                                                                                                                                                           (183,	45,	1,	1,	1,	1,	1702741953,	1702741953,	1702741953,	1702741953),
                                                                                                                                                           (211,	23,	1,	1,	1,	1,	1702567807,	1702567807,	1702567807,	1702567807),
                                                                                                                                                           (223,	37,	1,	1,	1,	1,	1702634829,	1702634829,	1702634829,	1702634829),
                                                                                                                                                           (265,	96,	1,	1,	1,	1,	1702630065,	1702630065,	1702630065,	1702630065),
                                                                                                                                                           (305,	63,	1,	1,	1,	1,	1702741671,	1702741671,	1702741671,	1702741671),
                                                                                                                                                           (313,	67,	1,	1,	1,	1,	1703513931,	1703513931,	1703513931,	1703513931),
                                                                                                                                                           (315,	34,	1,	1,	1,	1,	1703513928,	1703513928,	1703513928,	1703513928),
                                                                                                                                                           (321,	18,	1,	1,	1,	1,	1705219018,	1705219018,	1705219018,	1705219018),
                                                                                                                                                           (322,	74,	1,	1,	1,	1,	1702629985,	1702629985,	1702629985,	1702629985),
                                                                                                                                                           (346,	85,	1,	1,	1,	1,	1705219042,	1705219042,	1705219042,	1705219042),
                                                                                                                                                           (349,	17,	1,	1,	1,	1,	1703513977,	1703513977,	1703513977,	1703513977),
                                                                                                                                                           (350,	14,	3,	3,	3,	3,	1705202653,	1705202653,	1705202653,	1705202653),
                                                                                                                                                           (351,	90,	1,	1,	2,	2,	1703513980,	1703513980,	1702635402,	1702635402),
                                                                                                                                                           (353,	83,	1,	1,	1,	1,	1703513975,	1703513975,	1703513975,	1703513975),
                                                                                                                                                           (354,	96,	1,	1,	1,	1,	1703513982,	1703513982,	1703513982,	1703513982),
                                                                                                                                                           (393,	99,	1,	1,	1,	1,	1703514020,	1703514020,	1703514020,	1703514020),
                                                                                                                                                           (399,	82,	1,	1,	1,	1,	1703432110,	1703432110,	1703432110,	1703432110),
                                                                                                                                                           (404,	31,	1,	1,	1,	1,	1702390273,	1702390273,	1702390273,	1702390273),
                                                                                                                                                           (423,	62,	1,	1,	1,	1,	1703514615,	1703514615,	1703514615,	1703514615),
                                                                                                                                                           (440,	87,	1,	1,	1,	1,	1702475126,	1702475126,	1702475126,	1702475126),
                                                                                                                                                           (443,	85,	2,	2,	2,	2,	1703513942,	1703513942,	1703513942,	1703513942),
                                                                                                                                                           (485,	41,	1,	1,	1,	1,	1702654552,	1702654552,	1702654552,	1702654552),
                                                                                                                                                           (491,	88,	1,	1,	1,	1,	1702647862,	1702647862,	1702647862,	1702647862),
                                                                                                                                                           (495,	19,	1,	1,	1,	1,	1703432729,	1703432729,	1703432729,	1703432729),
                                                                                                                                                           (497,	23,	1,	1,	1,	1,	1702629910,	1702629910,	1702629910,	1702629910),
                                                                                                                                                           (501,	44,	1,	1,	1,	1,	1704984374,	1704984374,	1704984374,	1704984374),
                                                                                                                                                           (503,	21,	5,	5,	5,	5,	1702636477,	1702636477,	1702636477,	1702636477),
                                                                                                                                                           (504,	92,	1,	1,	1,	1,	1702723962,	1702723962,	1702723962,	1702723962),
                                                                                                                                                           (507,	52,	1,	1,	1,	1,	1703512962,	1703512962,	1703512962,	1703512962),
                                                                                                                                                           (510,	77,	1,	1,	1,	8,	1707197712,	1707197712,	1707197712,	1705144564),
                                                                                                                                                           (512,	81,	1,	1,	1,	1,	1701966591,	1701966591,	1701966591,	1701966591),
                                                                                                                                                           (513,	43,	1,	1,	1,	1,	1701966575,	1701966575,	1701966575,	1701966575),
                                                                                                                                                           (514,	52,	1,	1,	2,	2,	1702654281,	1702654281,	1701966597,	1701966597),
                                                                                                                                                           (515,	101,	1,	1,	1,	1,	1702739658,	1702739658,	1702739658,	1702739658),
                                                                                                                                                           (519,	58,	1,	1,	4,	4,	1703512982,	1703512982,	1702309921,	1702309921),
                                                                                                                                                           (521,	93,	1,	1,	1,	1,	1702477875,	1702477875,	1702477875,	1702477875),
                                                                                                                                                           (523,	33,	1,	1,	1,	1,	1702478042,	1702478042,	1702478042,	1702478042),
                                                                                                                                                           (527,	77,	1,	1,	2,	2,	1703512988,	1703512988,	1702656779,	1702656779),
                                                                                                                                                           (528,	85,	1,	1,	1,	1,	1703390027,	1703390027,	1703390027,	1703390027),
                                                                                                                                                           (533,	39,	1,	1,	1,	1,	1703512993,	1703512993,	1703512993,	1703512993),
                                                                                                                                                           (557,	100,	1,	1,	1,	1,	1703481270,	1703481270,	1703481270,	1703481270),
                                                                                                                                                           (561,	56,	1,	1,	1,	1,	1703512929,	1703512929,	1703512929,	1703512929),
                                                                                                                                                           (562,	49,	1,	1,	1,	1,	1702635319,	1702635319,	1702635319,	1702635319),
                                                                                                                                                           (564,	56,	1,	1,	1,	1,	1703512908,	1703512908,	1703512908,	1703512908),
                                                                                                                                                           (573,	18,	1,	1,	1,	1,	1703512392,	1703512392,	1703512392,	1703512392),
                                                                                                                                                           (575,	37,	1,	1,	1,	1,	1705214511,	1705214511,	1705214511,	1705214511),
                                                                                                                                                           (583,	99,	1,	1,	1,	1,	1703514015,	1703514015,	1703514015,	1703514015),
                                                                                                                                                           (607,	55,	2,	2,	2,	2,	1703514043,	1703514043,	1703514043,	1703514043),
                                                                                                                                                           (616,	97,	1,	1,	1,	1,	1702657411,	1702657411,	1702657411,	1702657411),
                                                                                                                                                           (617,	42,	6,	24,	24,	24,	1702569738,	1702533812,	1702533812,	1702533812),
                                                                                                                                                           (624,	25,	1,	4,	4,	4,	1702657365,	1702531793,	1702531793,	1702531793),
                                                                                                                                                           (632,	97,	1,	1,	1,	1,	1708692998,	1708692998,	1708692998,	1708692998),
                                                                                                                                                           (638,	94,	1,	1,	1,	1,	1708693028,	1708693028,	1708693028,	1708693028),
                                                                                                                                                           (640,	55,	1,	1,	1,	1,	1703514460,	1703514460,	1703514460,	1703514460),
                                                                                                                                                           (642,	18,	2,	2,	2,	2,	1705207180,	1705207180,	1705207180,	1705207180),
                                                                                                                                                           (643,	73,	1,	1,	1,	1,	1702573144,	1702573144,	1702573144,	1702573144),
                                                                                                                                                           (644,	84,	6,	6,	6,	6,	1702607136,	1702607136,	1702607136,	1702607136);

DROP TABLE IF EXISTS `fhx_1_webnav_index`;
CREATE TABLE `fhx_1_webnav_index` (
                                      `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
                                      `uid` mediumint(8) unsigned NOT NULL COMMENT '作者uid',
                                      `catid` mediumint(8) unsigned NOT NULL COMMENT '栏目id',
                                      `status` tinyint(2) NOT NULL COMMENT '审核状态',
                                      `inputtime` int(10) unsigned NOT NULL COMMENT '录入时间',
                                      PRIMARY KEY (`id`),
                                      KEY `uid` (`uid`),
                                      KEY `catid` (`catid`),
                                      KEY `status` (`status`),
                                      KEY `inputtime` (`inputtime`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='内容索引表';

INSERT INTO `fhx_1_webnav_index` (`id`, `uid`, `catid`, `status`, `inputtime`) VALUES
                                                                                   (1,	1,	1,	9,	1701871999),
                                                                                   (2,	1,	1,	9,	1701872030),
                                                                                   (3,	1,	1,	9,	1702547301),
                                                                                   (4,	1,	1,	9,	1701872044),
                                                                                   (5,	1,	1,	9,	1702547304),
                                                                                   (6,	1,	1,	9,	1701872081),
                                                                                   (7,	1,	1,	9,	1701872044),
                                                                                   (8,	1,	1,	9,	1701872028),
                                                                                   (9,	1,	1,	9,	1702547251),
                                                                                   (10,	1,	1,	9,	1702547247),
                                                                                   (11,	1,	1,	9,	1702547268),
                                                                                   (12,	1,	1,	9,	1701872546),
                                                                                   (13,	1,	1,	9,	1701872541),
                                                                                   (14,	1,	1,	9,	1701872586),
                                                                                   (15,	1,	1,	9,	1702547233),
                                                                                   (16,	1,	1,	9,	1702547283),
                                                                                   (17,	1,	1,	9,	1701872544),
                                                                                   (18,	1,	1,	9,	1701872627),
                                                                                   (19,	1,	1,	9,	1701872623),
                                                                                   (20,	1,	1,	9,	1701872554),
                                                                                   (21,	1,	1,	9,	1702547345),
                                                                                   (22,	1,	1,	9,	1702547255),
                                                                                   (23,	1,	1,	9,	1702547312),
                                                                                   (24,	1,	1,	9,	1702547333),
                                                                                   (25,	1,	1,	9,	1702547301),
                                                                                   (26,	1,	1,	9,	1702547285),
                                                                                   (27,	1,	1,	9,	1702547340),
                                                                                   (28,	1,	1,	9,	1702547289),
                                                                                   (29,	1,	1,	9,	1702547272),
                                                                                   (30,	1,	1,	9,	1702547338),
                                                                                   (31,	1,	1,	9,	1702547361),
                                                                                   (32,	1,	1,	9,	1702547307),
                                                                                   (33,	1,	1,	9,	1702547369),
                                                                                   (34,	1,	1,	9,	1702547330),
                                                                                   (35,	1,	1,	9,	1702547335),
                                                                                   (36,	1,	1,	9,	1702547316),
                                                                                   (37,	1,	1,	9,	1701872993),
                                                                                   (38,	1,	1,	9,	1702547383),
                                                                                   (39,	1,	1,	9,	1702547387),
                                                                                   (40,	1,	1,	9,	1701873055),
                                                                                   (41,	1,	1,	9,	1702547328),
                                                                                   (42,	1,	1,	9,	1702547389),
                                                                                   (43,	1,	1,	9,	1702547342),
                                                                                   (44,	1,	1,	9,	1702547376),
                                                                                   (45,	1,	1,	9,	1702547367),
                                                                                   (46,	1,	1,	9,	1702547379),
                                                                                   (47,	1,	1,	9,	1702547391),
                                                                                   (48,	1,	1,	9,	1702547426),
                                                                                   (49,	1,	1,	9,	1702547388),
                                                                                   (50,	1,	1,	9,	1702547390),
                                                                                   (51,	1,	1,	9,	1702547370),
                                                                                   (52,	1,	1,	9,	1702547350),
                                                                                   (53,	1,	1,	9,	1702547371),
                                                                                   (54,	1,	1,	9,	1702547387),
                                                                                   (55,	1,	1,	9,	1702547414),
                                                                                   (56,	1,	1,	9,	1702547416),
                                                                                   (57,	1,	1,	9,	1702547437),
                                                                                   (58,	1,	1,	9,	1702547404),
                                                                                   (59,	1,	1,	9,	1702547397),
                                                                                   (60,	1,	1,	9,	1702547384),
                                                                                   (61,	1,	1,	9,	1702547444),
                                                                                   (62,	1,	1,	9,	1702547442),
                                                                                   (63,	1,	1,	9,	1702547472),
                                                                                   (64,	1,	1,	9,	1702547455),
                                                                                   (65,	1,	1,	9,	1702547404),
                                                                                   (66,	1,	1,	9,	1702547416),
                                                                                   (67,	1,	1,	9,	1702547501),
                                                                                   (68,	1,	1,	9,	1702547477),
                                                                                   (69,	1,	1,	9,	1702547474),
                                                                                   (70,	1,	1,	9,	1702547475),
                                                                                   (71,	1,	1,	9,	1702547477),
                                                                                   (72,	1,	1,	9,	1702547515),
                                                                                   (73,	1,	11,	9,	1702547725),
                                                                                   (74,	1,	11,	9,	1702547702),
                                                                                   (75,	1,	11,	9,	1702547709),
                                                                                   (76,	1,	11,	9,	1702547708),
                                                                                   (77,	1,	11,	9,	1702547679),
                                                                                   (78,	1,	11,	9,	1702547667),
                                                                                   (79,	1,	11,	9,	1702547726),
                                                                                   (80,	1,	11,	9,	1702547714),
                                                                                   (81,	1,	11,	9,	1702547709),
                                                                                   (82,	1,	11,	9,	1702547718),
                                                                                   (83,	1,	11,	9,	1702547664),
                                                                                   (84,	1,	11,	9,	1702547695),
                                                                                   (85,	1,	11,	9,	1702547748),
                                                                                   (86,	1,	11,	9,	1702547750),
                                                                                   (87,	1,	11,	9,	1702547723),
                                                                                   (88,	1,	11,	9,	1702547739),
                                                                                   (89,	1,	11,	9,	1702547679),
                                                                                   (90,	1,	10,	9,	1702547755),
                                                                                   (91,	1,	10,	9,	1702547678),
                                                                                   (92,	1,	10,	9,	1702547762),
                                                                                   (93,	1,	10,	9,	1702547674),
                                                                                   (94,	1,	10,	9,	1702547747),
                                                                                   (95,	1,	10,	9,	1702547696),
                                                                                   (96,	1,	10,	9,	1702547690),
                                                                                   (97,	1,	10,	9,	1702547750),
                                                                                   (98,	1,	10,	9,	1702547767),
                                                                                   (99,	1,	10,	9,	1702547765),
                                                                                   (100,	1,	10,	9,	1702547749),
                                                                                   (101,	1,	10,	9,	1702547753),
                                                                                   (102,	1,	10,	9,	1702547777),
                                                                                   (103,	1,	10,	9,	1702547775),
                                                                                   (104,	1,	10,	9,	1702547733),
                                                                                   (105,	1,	10,	9,	1702547716),
                                                                                   (106,	1,	14,	9,	1702547802),
                                                                                   (107,	1,	14,	9,	1702547811),
                                                                                   (108,	1,	14,	9,	1702547793),
                                                                                   (109,	1,	14,	9,	1702547725),
                                                                                   (110,	1,	14,	9,	1702547753),
                                                                                   (111,	1,	14,	9,	1702547729),
                                                                                   (112,	1,	14,	9,	1702547775),
                                                                                   (113,	1,	14,	9,	1702547775),
                                                                                   (114,	1,	14,	9,	1702547822),
                                                                                   (115,	1,	14,	9,	1702547801),
                                                                                   (116,	1,	14,	9,	1702547780),
                                                                                   (117,	1,	14,	9,	1702547841),
                                                                                   (118,	1,	14,	9,	1702547825),
                                                                                   (119,	1,	13,	9,	1702547758),
                                                                                   (120,	1,	13,	9,	1702547848),
                                                                                   (121,	1,	13,	9,	1702547853),
                                                                                   (122,	1,	13,	9,	1702547831),
                                                                                   (123,	1,	13,	9,	1702547841),
                                                                                   (124,	1,	13,	9,	1702547841),
                                                                                   (125,	1,	13,	9,	1702547816),
                                                                                   (126,	1,	13,	9,	1702547786),
                                                                                   (127,	1,	13,	9,	1702547850),
                                                                                   (128,	1,	13,	9,	1702547802),
                                                                                   (129,	1,	13,	9,	1702547789),
                                                                                   (130,	1,	13,	9,	1702547886),
                                                                                   (131,	1,	13,	9,	1702547855),
                                                                                   (132,	1,	5,	9,	1702547798),
                                                                                   (133,	1,	5,	9,	1702547846),
                                                                                   (134,	1,	13,	9,	1702547814),
                                                                                   (135,	1,	13,	9,	1702547905),
                                                                                   (136,	1,	13,	9,	1702547818),
                                                                                   (137,	1,	13,	9,	1702547868),
                                                                                   (138,	1,	13,	9,	1702547908),
                                                                                   (139,	1,	13,	9,	1702547824),
                                                                                   (140,	1,	13,	9,	1702547846),
                                                                                   (141,	1,	13,	9,	1702547852),
                                                                                   (142,	1,	13,	9,	1702547881),
                                                                                   (143,	1,	13,	9,	1702547922),
                                                                                   (144,	1,	13,	9,	1702547867),
                                                                                   (145,	1,	13,	9,	1702547885),
                                                                                   (146,	1,	13,	9,	1702547905),
                                                                                   (147,	1,	13,	9,	1702547938),
                                                                                   (148,	1,	13,	9,	1702547858),
                                                                                   (149,	1,	13,	9,	1702547869),
                                                                                   (150,	1,	13,	9,	1702547961),
                                                                                   (151,	1,	13,	9,	1702547877),
                                                                                   (152,	1,	12,	9,	1702547971),
                                                                                   (153,	1,	12,	9,	1702547881),
                                                                                   (154,	1,	12,	9,	1702547907),
                                                                                   (155,	1,	12,	9,	1702547981),
                                                                                   (156,	1,	12,	9,	1702547923),
                                                                                   (157,	1,	12,	9,	1702547900),
                                                                                   (158,	1,	12,	9,	1702547962),
                                                                                   (159,	1,	12,	9,	1702547971),
                                                                                   (160,	1,	12,	9,	1702547934),
                                                                                   (161,	1,	12,	9,	1702547963),
                                                                                   (162,	1,	12,	9,	1702547939),
                                                                                   (163,	1,	12,	9,	1702547925),
                                                                                   (164,	1,	12,	9,	1702547927),
                                                                                   (165,	1,	12,	9,	1702547981),
                                                                                   (166,	1,	12,	9,	1702547952),
                                                                                   (167,	1,	12,	9,	1702547987),
                                                                                   (168,	1,	12,	9,	1702547970),
                                                                                   (169,	1,	12,	9,	1702548019),
                                                                                   (170,	1,	12,	9,	1702548007),
                                                                                   (171,	1,	12,	9,	1702548002),
                                                                                   (172,	1,	9,	9,	1702548008),
                                                                                   (173,	1,	9,	9,	1702547988),
                                                                                   (174,	1,	9,	9,	1702548025),
                                                                                   (175,	1,	9,	9,	1702548017),
                                                                                   (176,	1,	9,	9,	1702547978),
                                                                                   (177,	1,	9,	9,	1702547980),
                                                                                   (178,	1,	9,	9,	1702547982),
                                                                                   (179,	1,	9,	9,	1702548081),
                                                                                   (180,	1,	9,	9,	1702548004),
                                                                                   (181,	1,	9,	9,	1702547994),
                                                                                   (182,	1,	9,	9,	1702548017),
                                                                                   (183,	1,	9,	9,	1702548017),
                                                                                   (184,	1,	6,	9,	1701957222),
                                                                                   (185,	1,	6,	9,	1701957256),
                                                                                   (186,	1,	6,	9,	1702548163),
                                                                                   (187,	1,	6,	9,	1702548135),
                                                                                   (188,	1,	6,	9,	1702548082),
                                                                                   (189,	1,	6,	9,	1702548114),
                                                                                   (190,	1,	6,	9,	1702548116),
                                                                                   (191,	1,	6,	9,	1702548181),
                                                                                   (192,	1,	6,	9,	1702548175),
                                                                                   (193,	1,	6,	9,	1702548154),
                                                                                   (194,	1,	6,	9,	1702548144),
                                                                                   (195,	1,	6,	9,	1702548206),
                                                                                   (196,	1,	6,	9,	1702548148),
                                                                                   (197,	1,	6,	9,	1702548193),
                                                                                   (198,	1,	6,	9,	1702548134),
                                                                                   (199,	1,	6,	9,	1702548164),
                                                                                   (200,	1,	6,	9,	1702548154),
                                                                                   (201,	1,	6,	9,	1702548176),
                                                                                   (202,	1,	6,	9,	1702548244),
                                                                                   (203,	1,	6,	9,	1702548226),
                                                                                   (204,	1,	6,	9,	1702548219),
                                                                                   (205,	1,	6,	9,	1702548184),
                                                                                   (206,	1,	6,	9,	1702548181),
                                                                                   (207,	1,	6,	9,	1702548201),
                                                                                   (208,	1,	6,	9,	1702548212),
                                                                                   (209,	1,	6,	9,	1702548233),
                                                                                   (210,	1,	6,	9,	1702548287),
                                                                                   (211,	1,	6,	9,	1702548298),
                                                                                   (212,	1,	6,	9,	1702548266),
                                                                                   (213,	1,	6,	9,	1702548216),
                                                                                   (214,	1,	6,	9,	1702548282),
                                                                                   (215,	1,	6,	9,	1702548262),
                                                                                   (216,	1,	6,	9,	1702548275),
                                                                                   (217,	1,	6,	9,	1702548245),
                                                                                   (218,	1,	6,	9,	1702548332),
                                                                                   (219,	1,	6,	9,	1702548276),
                                                                                   (220,	1,	6,	9,	1702548286),
                                                                                   (221,	1,	6,	9,	1702548315),
                                                                                   (222,	1,	6,	9,	1702548348),
                                                                                   (223,	1,	6,	9,	1702548352),
                                                                                   (224,	1,	6,	9,	1702548323),
                                                                                   (225,	1,	7,	9,	1701957405),
                                                                                   (226,	1,	7,	9,	1701957411),
                                                                                   (227,	1,	7,	9,	1702548358),
                                                                                   (228,	1,	7,	9,	1702548310),
                                                                                   (229,	1,	7,	9,	1702548382),
                                                                                   (230,	1,	7,	9,	1702548337),
                                                                                   (231,	1,	7,	9,	1702548352),
                                                                                   (232,	1,	7,	9,	1702548354),
                                                                                   (233,	1,	7,	9,	1702548322),
                                                                                   (234,	1,	7,	9,	1702548384),
                                                                                   (235,	1,	7,	9,	1702548372),
                                                                                   (236,	1,	7,	9,	1702548345),
                                                                                   (237,	1,	7,	9,	1702548351),
                                                                                   (238,	1,	7,	9,	1702548379),
                                                                                   (239,	1,	7,	9,	1702548398),
                                                                                   (240,	1,	7,	9,	1702548430),
                                                                                   (241,	1,	7,	9,	1702548454),
                                                                                   (242,	1,	7,	9,	1702548430),
                                                                                   (243,	1,	7,	9,	1702548403),
                                                                                   (244,	1,	7,	9,	1702548398),
                                                                                   (245,	1,	7,	9,	1702548484),
                                                                                   (246,	1,	7,	9,	1702548447),
                                                                                   (247,	1,	7,	9,	1702548488),
                                                                                   (248,	1,	7,	9,	1702548505),
                                                                                   (249,	1,	7,	9,	1702548431),
                                                                                   (250,	1,	7,	9,	1702548451),
                                                                                   (251,	1,	7,	9,	1702548456),
                                                                                   (252,	1,	7,	9,	1702548463),
                                                                                   (253,	1,	7,	9,	1702548450),
                                                                                   (254,	1,	7,	9,	1702548513),
                                                                                   (255,	1,	7,	9,	1702548521),
                                                                                   (256,	1,	7,	9,	1702548578),
                                                                                   (257,	1,	7,	9,	1702548528),
                                                                                   (258,	1,	7,	9,	1702548570),
                                                                                   (259,	1,	7,	9,	1702548511),
                                                                                   (260,	1,	7,	9,	1702548578),
                                                                                   (261,	1,	7,	9,	1702548501),
                                                                                   (262,	1,	7,	9,	1702548570),
                                                                                   (263,	1,	7,	9,	1702548551),
                                                                                   (264,	1,	7,	9,	1702548616),
                                                                                   (265,	1,	7,	9,	1702548605),
                                                                                   (266,	1,	5,	9,	1702548551),
                                                                                   (267,	1,	5,	9,	1702548592),
                                                                                   (268,	1,	8,	9,	1701957755),
                                                                                   (269,	1,	8,	9,	1702548888),
                                                                                   (270,	1,	8,	9,	1702548918),
                                                                                   (271,	1,	8,	9,	1702548928),
                                                                                   (272,	1,	8,	9,	1702548864),
                                                                                   (273,	1,	8,	9,	1702548925),
                                                                                   (274,	1,	8,	9,	1702548965),
                                                                                   (275,	1,	8,	9,	1702548925),
                                                                                   (276,	1,	8,	9,	1702548890),
                                                                                   (277,	1,	8,	9,	1702548918),
                                                                                   (278,	1,	8,	9,	1702548921),
                                                                                   (279,	1,	8,	9,	1702548985),
                                                                                   (280,	1,	8,	9,	1702549012),
                                                                                   (281,	1,	8,	9,	1702548947),
                                                                                   (282,	1,	8,	9,	1702548991),
                                                                                   (283,	1,	8,	9,	1702548942),
                                                                                   (284,	1,	8,	9,	1702548975),
                                                                                   (285,	1,	8,	9,	1702548978),
                                                                                   (286,	1,	8,	9,	1702549013),
                                                                                   (287,	1,	8,	9,	1702549019),
                                                                                   (288,	1,	8,	9,	1702549052),
                                                                                   (289,	1,	8,	9,	1702549033),
                                                                                   (290,	1,	8,	9,	1702549071),
                                                                                   (291,	1,	8,	9,	1702549041),
                                                                                   (292,	1,	8,	9,	1702549106),
                                                                                   (293,	1,	8,	9,	1702549064),
                                                                                   (294,	1,	8,	9,	1702549053),
                                                                                   (295,	1,	8,	9,	1702549113),
                                                                                   (296,	1,	8,	9,	1702549077),
                                                                                   (297,	1,	8,	9,	1702549122),
                                                                                   (298,	1,	8,	9,	1702549088),
                                                                                   (299,	1,	8,	9,	1702549084),
                                                                                   (300,	1,	8,	9,	1702549177),
                                                                                   (301,	1,	8,	9,	1702549132),
                                                                                   (302,	1,	8,	9,	1702549129),
                                                                                   (303,	1,	8,	9,	1702549121),
                                                                                   (304,	1,	8,	9,	1702549211),
                                                                                   (305,	1,	8,	9,	1702549210),
                                                                                   (306,	1,	8,	9,	1702549149),
                                                                                   (307,	1,	21,	9,	1702549227),
                                                                                   (308,	1,	21,	9,	1702549181),
                                                                                   (309,	1,	21,	9,	1702549224),
                                                                                   (310,	1,	21,	9,	1702549230),
                                                                                   (311,	1,	21,	9,	1702549193),
                                                                                   (312,	1,	21,	9,	1702549237),
                                                                                   (313,	1,	21,	9,	1702549266),
                                                                                   (314,	1,	21,	9,	1702549235),
                                                                                   (315,	1,	21,	9,	1702549278),
                                                                                   (316,	1,	21,	9,	1702549262),
                                                                                   (317,	1,	21,	9,	1702549256),
                                                                                   (318,	1,	21,	9,	1702549282),
                                                                                   (319,	1,	21,	9,	1702549273),
                                                                                   (320,	1,	21,	9,	1702549250),
                                                                                   (321,	1,	21,	9,	1702549332),
                                                                                   (322,	1,	21,	9,	1702549332),
                                                                                   (323,	1,	3,	9,	1702549298),
                                                                                   (324,	1,	3,	9,	1702549366),
                                                                                   (325,	1,	3,	9,	1702549327),
                                                                                   (326,	1,	3,	9,	1702549328),
                                                                                   (327,	1,	3,	9,	1702549360),
                                                                                   (328,	1,	3,	9,	1702549318),
                                                                                   (329,	1,	3,	9,	1702549414),
                                                                                   (330,	1,	3,	9,	1702549434),
                                                                                   (331,	1,	3,	9,	1702549465),
                                                                                   (332,	1,	3,	9,	1702549401),
                                                                                   (333,	1,	3,	9,	1702549427),
                                                                                   (334,	1,	3,	9,	1702549434),
                                                                                   (335,	1,	3,	9,	1702549511),
                                                                                   (336,	1,	3,	9,	1702549495),
                                                                                   (337,	1,	3,	9,	1702549472),
                                                                                   (338,	1,	3,	9,	1702549498),
                                                                                   (339,	1,	3,	9,	1702549543),
                                                                                   (340,	1,	3,	9,	1702549486),
                                                                                   (341,	1,	3,	9,	1702549546),
                                                                                   (342,	1,	3,	9,	1702549580),
                                                                                   (343,	1,	3,	9,	1702549508),
                                                                                   (344,	1,	3,	9,	1702549552),
                                                                                   (345,	1,	3,	9,	1702549541),
                                                                                   (346,	1,	3,	9,	1702549594),
                                                                                   (347,	1,	3,	9,	1702549589),
                                                                                   (348,	1,	3,	9,	1702549617),
                                                                                   (349,	1,	3,	9,	1702549584),
                                                                                   (350,	1,	3,	9,	1702549599),
                                                                                   (351,	1,	3,	9,	1702549667),
                                                                                   (352,	1,	3,	9,	1702549611),
                                                                                   (353,	1,	3,	9,	1702549665),
                                                                                   (354,	1,	3,	9,	1702549614),
                                                                                   (355,	1,	15,	9,	1702549656),
                                                                                   (356,	1,	15,	9,	1702549690),
                                                                                   (357,	1,	15,	9,	1702549705),
                                                                                   (358,	1,	15,	9,	1702549675),
                                                                                   (359,	1,	15,	9,	1702549718),
                                                                                   (360,	1,	15,	9,	1701958427),
                                                                                   (361,	1,	15,	9,	1701958430),
                                                                                   (362,	1,	15,	9,	1701958383),
                                                                                   (363,	1,	15,	9,	1702549724),
                                                                                   (364,	1,	15,	9,	1702549746),
                                                                                   (365,	1,	15,	9,	1701958404),
                                                                                   (366,	1,	15,	9,	1701958448),
                                                                                   (367,	1,	15,	9,	1701958442),
                                                                                   (368,	1,	15,	9,	1701958466),
                                                                                   (369,	1,	15,	9,	1702549819),
                                                                                   (370,	1,	15,	9,	1701958455),
                                                                                   (371,	1,	15,	9,	1701958453),
                                                                                   (372,	1,	15,	9,	1701958527),
                                                                                   (373,	1,	15,	9,	1701958517),
                                                                                   (374,	1,	15,	9,	1701958506),
                                                                                   (375,	1,	15,	9,	1701958515),
                                                                                   (376,	1,	15,	9,	1701958517),
                                                                                   (377,	1,	15,	9,	1701958544),
                                                                                   (378,	1,	15,	9,	1701958592),
                                                                                   (379,	1,	15,	9,	1701958564),
                                                                                   (380,	1,	15,	9,	1701958608),
                                                                                   (381,	1,	15,	9,	1701958602),
                                                                                   (382,	1,	15,	9,	1701958575),
                                                                                   (383,	1,	15,	9,	1701958573),
                                                                                   (384,	1,	15,	9,	1701958599),
                                                                                   (385,	1,	15,	9,	1702550023),
                                                                                   (386,	1,	15,	9,	1701958583),
                                                                                   (387,	1,	15,	9,	1702550072),
                                                                                   (388,	1,	15,	9,	1701958650),
                                                                                   (389,	1,	15,	9,	1701958601),
                                                                                   (390,	1,	1,	9,	1702547294),
                                                                                   (391,	1,	1,	9,	1702547329),
                                                                                   (392,	1,	15,	9,	1701958959),
                                                                                   (393,	1,	23,	9,	1702562184),
                                                                                   (394,	1,	15,	9,	1701958995),
                                                                                   (395,	1,	1,	9,	1702547411),
                                                                                   (396,	1,	23,	9,	1701958975),
                                                                                   (397,	1,	7,	9,	1702548473),
                                                                                   (398,	1,	15,	9,	1701958978),
                                                                                   (399,	1,	3,	9,	1702550200),
                                                                                   (400,	1,	15,	9,	1701959013),
                                                                                   (401,	1,	13,	9,	1701959030),
                                                                                   (402,	1,	5,	9,	1702550189),
                                                                                   (403,	1,	15,	9,	1701959035),
                                                                                   (404,	1,	13,	9,	1702550237),
                                                                                   (405,	1,	5,	9,	1702548599),
                                                                                   (406,	1,	5,	9,	1702548632),
                                                                                   (407,	1,	5,	9,	1702548645),
                                                                                   (408,	1,	5,	9,	1702548660),
                                                                                   (409,	1,	5,	9,	1702548678),
                                                                                   (410,	1,	5,	9,	1702548636),
                                                                                   (411,	1,	5,	9,	1702548611),
                                                                                   (412,	1,	5,	9,	1702548654),
                                                                                   (413,	1,	5,	9,	1702548693),
                                                                                   (414,	1,	5,	9,	1702548671),
                                                                                   (415,	1,	5,	9,	1702548679),
                                                                                   (416,	1,	5,	9,	1702548669),
                                                                                   (417,	1,	5,	9,	1702548724),
                                                                                   (418,	1,	5,	9,	1702548674),
                                                                                   (419,	1,	5,	9,	1702548682),
                                                                                   (420,	1,	5,	9,	1702548711),
                                                                                   (421,	1,	5,	9,	1702548716),
                                                                                   (422,	1,	5,	9,	1702548677),
                                                                                   (423,	1,	5,	9,	1702548763),
                                                                                   (424,	1,	5,	9,	1702548766),
                                                                                   (425,	1,	5,	9,	1702548754),
                                                                                   (426,	1,	5,	9,	1702548774),
                                                                                   (427,	1,	5,	9,	1702548716),
                                                                                   (428,	1,	5,	9,	1702548795),
                                                                                   (429,	1,	5,	9,	1702548786),
                                                                                   (430,	1,	5,	9,	1702548745),
                                                                                   (431,	1,	5,	9,	1702548801),
                                                                                   (432,	1,	5,	9,	1702548838),
                                                                                   (433,	1,	5,	9,	1702548803),
                                                                                   (434,	1,	5,	9,	1702548761),
                                                                                   (435,	1,	5,	9,	1702548772),
                                                                                   (436,	1,	5,	9,	1702548799),
                                                                                   (437,	1,	5,	9,	1702548878),
                                                                                   (438,	1,	5,	9,	1702548823),
                                                                                   (439,	1,	5,	9,	1702548887),
                                                                                   (440,	1,	5,	9,	1702548857),
                                                                                   (441,	1,	5,	9,	1702548854),
                                                                                   (442,	1,	5,	9,	1702548898),
                                                                                   (443,	1,	5,	9,	1702548915),
                                                                                   (444,	1,	3,	9,	1702549412),
                                                                                   (445,	1,	3,	9,	1702549368),
                                                                                   (446,	1,	3,	9,	1702549373),
                                                                                   (447,	1,	3,	9,	1702549432),
                                                                                   (448,	1,	15,	9,	1701960592),
                                                                                   (449,	1,	15,	9,	1701960653),
                                                                                   (450,	1,	15,	9,	1701960664),
                                                                                   (451,	1,	15,	9,	1701960612),
                                                                                   (452,	1,	15,	9,	1701960636),
                                                                                   (453,	1,	15,	9,	1701960621),
                                                                                   (454,	1,	15,	9,	1701960670),
                                                                                   (455,	1,	15,	9,	1701960610),
                                                                                   (456,	1,	15,	9,	1701960689),
                                                                                   (457,	1,	15,	9,	1701960701),
                                                                                   (458,	1,	15,	9,	1701960684),
                                                                                   (459,	1,	15,	9,	1701960686),
                                                                                   (460,	1,	15,	9,	1701960627),
                                                                                   (461,	1,	15,	9,	1701960679),
                                                                                   (462,	1,	15,	9,	1701960693),
                                                                                   (463,	1,	15,	9,	1701960719),
                                                                                   (464,	1,	15,	9,	1701960716),
                                                                                   (465,	1,	15,	9,	1701960740),
                                                                                   (466,	1,	15,	9,	1701960728),
                                                                                   (467,	1,	15,	9,	1701960709),
                                                                                   (468,	1,	15,	9,	1701960689),
                                                                                   (469,	1,	15,	9,	1701960760),
                                                                                   (470,	1,	15,	9,	1701960671),
                                                                                   (471,	1,	15,	9,	1701960672),
                                                                                   (472,	1,	15,	9,	1701960763),
                                                                                   (473,	1,	15,	9,	1701960847),
                                                                                   (474,	1,	15,	9,	1701960866),
                                                                                   (475,	1,	15,	9,	1701960858),
                                                                                   (476,	1,	15,	9,	1701960936),
                                                                                   (477,	1,	13,	9,	1701960919),
                                                                                   (478,	1,	15,	9,	1701960906),
                                                                                   (479,	1,	15,	9,	1701963201),
                                                                                   (480,	1,	15,	9,	1701963194),
                                                                                   (481,	1,	15,	9,	1701963155),
                                                                                   (482,	1,	15,	9,	1701963162),
                                                                                   (483,	1,	15,	9,	1701963185),
                                                                                   (484,	1,	15,	9,	1701963194),
                                                                                   (485,	1,	15,	9,	1702549754),
                                                                                   (486,	1,	15,	9,	1702549810),
                                                                                   (487,	1,	15,	9,	1702549854),
                                                                                   (488,	1,	15,	9,	1702549903),
                                                                                   (489,	1,	15,	9,	1702549833),
                                                                                   (490,	1,	15,	9,	1702549891),
                                                                                   (491,	1,	15,	9,	1702549849),
                                                                                   (492,	1,	15,	9,	1702549913),
                                                                                   (493,	1,	15,	9,	1702549880),
                                                                                   (494,	1,	15,	9,	1702549960),
                                                                                   (495,	1,	15,	9,	1702549907),
                                                                                   (496,	1,	15,	9,	1702549925),
                                                                                   (497,	1,	15,	9,	1702549993),
                                                                                   (498,	1,	15,	9,	1702549995),
                                                                                   (499,	1,	15,	9,	1702550000),
                                                                                   (500,	1,	15,	9,	1702550034),
                                                                                   (501,	1,	15,	9,	1702549989),
                                                                                   (502,	1,	15,	9,	1702550084),
                                                                                   (503,	1,	15,	9,	1702550047),
                                                                                   (504,	1,	15,	9,	1702550099),
                                                                                   (505,	1,	15,	9,	1702549840),
                                                                                   (506,	1,	15,	9,	1702549852),
                                                                                   (507,	1,	15,	9,	1702550121),
                                                                                   (508,	1,	15,	9,	1702550166),
                                                                                   (509,	1,	13,	9,	1701964284),
                                                                                   (510,	1,	15,	9,	1702550218),
                                                                                   (511,	1,	15,	9,	1702549749),
                                                                                   (512,	1,	15,	9,	1702549698),
                                                                                   (513,	1,	15,	9,	1702549776),
                                                                                   (514,	1,	15,	9,	1702549740),
                                                                                   (515,	1,	15,	9,	1702549769),
                                                                                   (516,	1,	13,	9,	1701964717),
                                                                                   (517,	1,	13,	9,	1701964746),
                                                                                   (518,	1,	13,	9,	1701964961),
                                                                                   (519,	1,	13,	9,	1702550184),
                                                                                   (520,	1,	20,	9,	1702561335),
                                                                                   (521,	1,	20,	9,	1702561405),
                                                                                   (522,	1,	20,	9,	1702561324),
                                                                                   (523,	1,	20,	9,	1702561419),
                                                                                   (524,	1,	20,	9,	1702561418),
                                                                                   (525,	1,	20,	9,	1702561385),
                                                                                   (526,	1,	19,	9,	1702561709),
                                                                                   (527,	1,	15,	9,	1702561674),
                                                                                   (528,	1,	15,	9,	1702561753),
                                                                                   (529,	1,	19,	9,	1702561732),
                                                                                   (530,	1,	19,	9,	1702561766),
                                                                                   (531,	1,	19,	9,	1702561683),
                                                                                   (532,	1,	19,	9,	1702561770),
                                                                                   (533,	1,	19,	9,	1702561722),
                                                                                   (534,	1,	19,	9,	1702561696),
                                                                                   (535,	1,	19,	9,	1702561683),
                                                                                   (536,	1,	19,	9,	1702550062),
                                                                                   (537,	1,	17,	9,	1702561863),
                                                                                   (538,	1,	17,	9,	1702561828),
                                                                                   (539,	1,	17,	9,	1702561840),
                                                                                   (540,	1,	17,	9,	1702561869),
                                                                                   (541,	1,	17,	9,	1702561842),
                                                                                   (542,	1,	17,	9,	1702561907),
                                                                                   (543,	1,	17,	9,	1702561932),
                                                                                   (544,	1,	17,	9,	1702561906),
                                                                                   (545,	1,	17,	9,	1702561853),
                                                                                   (546,	1,	17,	9,	1702561869),
                                                                                   (547,	1,	17,	9,	1702561925),
                                                                                   (548,	1,	17,	9,	1702561858),
                                                                                   (549,	1,	17,	9,	1702561873),
                                                                                   (550,	1,	17,	9,	1702561920),
                                                                                   (551,	1,	17,	9,	1702561912),
                                                                                   (552,	1,	17,	9,	1702561903),
                                                                                   (553,	1,	17,	9,	1702561913),
                                                                                   (554,	1,	17,	9,	1702561913),
                                                                                   (555,	1,	17,	9,	1702561925),
                                                                                   (556,	1,	17,	9,	1702561890),
                                                                                   (557,	1,	17,	9,	1702561945),
                                                                                   (558,	1,	17,	9,	1702561869),
                                                                                   (559,	1,	17,	9,	1702561935),
                                                                                   (560,	1,	17,	9,	1702561936),
                                                                                   (561,	1,	18,	9,	1702562055),
                                                                                   (562,	1,	18,	9,	1702562026),
                                                                                   (563,	1,	18,	9,	1702561986),
                                                                                   (564,	1,	18,	9,	1702562065),
                                                                                   (565,	1,	18,	9,	1702562053),
                                                                                   (566,	1,	18,	9,	1702562046),
                                                                                   (567,	1,	18,	9,	1702562028),
                                                                                   (568,	1,	18,	9,	1702562005),
                                                                                   (569,	1,	18,	9,	1702561998),
                                                                                   (570,	1,	18,	9,	1702562038),
                                                                                   (571,	1,	18,	9,	1702562018),
                                                                                   (572,	1,	18,	9,	1702562052),
                                                                                   (573,	1,	18,	9,	1702562089),
                                                                                   (574,	1,	18,	9,	1702561998),
                                                                                   (575,	1,	15,	9,	1702562028),
                                                                                   (576,	1,	23,	9,	1702562167),
                                                                                   (577,	1,	23,	9,	1702562186),
                                                                                   (578,	1,	23,	9,	1702562183),
                                                                                   (579,	1,	23,	9,	1702562182),
                                                                                   (580,	1,	23,	9,	1702562153),
                                                                                   (581,	1,	23,	9,	1702562151),
                                                                                   (582,	1,	23,	9,	1702562127),
                                                                                   (583,	1,	23,	9,	1702562184),
                                                                                   (584,	1,	23,	9,	1702562164),
                                                                                   (585,	1,	23,	9,	1702562129),
                                                                                   (586,	1,	23,	9,	1702562161),
                                                                                   (587,	1,	23,	9,	1702562124),
                                                                                   (588,	1,	23,	9,	1702562118),
                                                                                   (589,	1,	23,	9,	1702562141),
                                                                                   (590,	1,	23,	9,	1702562134),
                                                                                   (591,	1,	25,	9,	1702562231),
                                                                                   (592,	1,	25,	9,	1702562277),
                                                                                   (593,	1,	25,	9,	1702562277),
                                                                                   (594,	1,	25,	9,	1702562263),
                                                                                   (595,	1,	25,	9,	1702562249),
                                                                                   (596,	1,	25,	9,	1702562260),
                                                                                   (597,	1,	25,	9,	1702562243),
                                                                                   (598,	1,	26,	9,	1702563999),
                                                                                   (599,	1,	26,	9,	1702564044),
                                                                                   (600,	1,	26,	9,	1702563994),
                                                                                   (601,	1,	26,	9,	1702564010),
                                                                                   (602,	1,	26,	9,	1702564073),
                                                                                   (603,	1,	26,	9,	1702564024),
                                                                                   (604,	1,	22,	9,	1702564135),
                                                                                   (605,	1,	22,	9,	1702564153),
                                                                                   (606,	1,	22,	9,	1702564114),
                                                                                   (607,	1,	22,	9,	1702564097),
                                                                                   (608,	1,	22,	9,	1702564117),
                                                                                   (609,	1,	22,	9,	1702564167),
                                                                                   (610,	1,	22,	9,	1702564161),
                                                                                   (611,	1,	22,	9,	1702564119),
                                                                                   (612,	1,	24,	9,	1702564178),
                                                                                   (613,	1,	24,	9,	1702564206),
                                                                                   (614,	1,	24,	9,	1702564159),
                                                                                   (615,	1,	24,	9,	1702564149),
                                                                                   (616,	1,	24,	9,	1702564222),
                                                                                   (617,	1,	24,	9,	1702564228),
                                                                                   (618,	1,	24,	9,	1702564203),
                                                                                   (619,	1,	24,	9,	1702564145),
                                                                                   (620,	1,	24,	9,	1702564179),
                                                                                   (621,	1,	24,	9,	1702564217),
                                                                                   (622,	1,	24,	9,	1702564164),
                                                                                   (623,	1,	24,	9,	1702564170),
                                                                                   (624,	1,	24,	9,	1702564256),
                                                                                   (625,	1,	1,	9,	1702547223),
                                                                                   (626,	1,	1,	9,	1702547266),
                                                                                   (627,	1,	1,	9,	1702547248),
                                                                                   (628,	1,	1,	9,	1702547260),
                                                                                   (629,	1,	1,	9,	1702547315),
                                                                                   (630,	1,	1,	9,	1702547297),
                                                                                   (631,	1,	1,	9,	1702547310),
                                                                                   (632,	1,	1,	9,	1702711685),
                                                                                   (633,	1,	1,	9,	1702547259),
                                                                                   (634,	1,	1,	9,	1702547257),
                                                                                   (635,	1,	1,	9,	1702547298),
                                                                                   (636,	1,	1,	9,	1702547289),
                                                                                   (637,	1,	1,	9,	1702547311),
                                                                                   (638,	1,	6,	9,	1702548263),
                                                                                   (639,	1,	7,	9,	1702548461),
                                                                                   (640,	1,	13,	9,	1702550139),
                                                                                   (641,	1,	19,	9,	1702550109),
                                                                                   (642,	1,	8,	9,	1702550164),
                                                                                   (643,	1,	6,	9,	1702550167),
                                                                                   (644,	1,	7,	9,	1702550136);

DROP TABLE IF EXISTS `fhx_1_webnav_oppose`;
CREATE TABLE `fhx_1_webnav_oppose` (
                                       `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
                                       `cid` int(10) unsigned NOT NULL COMMENT '文档id',
                                       `uid` mediumint(8) unsigned NOT NULL COMMENT '作者uid',
                                       `agent` varchar(100) NOT NULL COMMENT '匿名',
                                       `inputtime` int(10) unsigned NOT NULL COMMENT '操作时间',
                                       PRIMARY KEY (`id`),
                                       KEY `cid` (`cid`),
                                       KEY `agent` (`agent`),
                                       KEY `inputtime` (`inputtime`),
                                       KEY `uid` (`uid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='反对操作记录表';


DROP TABLE IF EXISTS `fhx_1_webnav_recycle`;
CREATE TABLE `fhx_1_webnav_recycle` (
                                        `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
                                        `cid` int(10) unsigned NOT NULL COMMENT '内容id',
                                        `uid` mediumint(8) unsigned NOT NULL COMMENT '作者uid',
                                        `catid` tinyint(3) unsigned NOT NULL COMMENT '栏目id',
                                        `content` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '具体内容',
                                        `result` text COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '删除理由',
                                        `inputtime` int(10) unsigned NOT NULL COMMENT '录入时间',
                                        PRIMARY KEY (`id`),
                                        KEY `uid` (`uid`),
                                        KEY `cid` (`cid`),
                                        KEY `catid` (`catid`),
                                        KEY `inputtime` (`inputtime`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='内容回收站表';


DROP TABLE IF EXISTS `fhx_1_webnav_search`;
CREATE TABLE `fhx_1_webnav_search` (
                                       `id` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
                                       `catid` mediumint(8) unsigned NOT NULL COMMENT '栏目id',
                                       `params` text COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '参数数组',
                                       `keyword` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '关键字',
                                       `contentid` int(10) unsigned NOT NULL COMMENT '字段改成了结果数量值',
                                       `inputtime` int(10) unsigned NOT NULL COMMENT '搜索时间',
                                       PRIMARY KEY (`id`),
                                       UNIQUE KEY `id` (`id`),
                                       KEY `catid` (`catid`),
                                       KEY `keyword` (`keyword`),
                                       KEY `inputtime` (`inputtime`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='搜索表';


DROP TABLE IF EXISTS `fhx_1_webnav_support`;
CREATE TABLE `fhx_1_webnav_support` (
                                        `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
                                        `cid` int(10) unsigned NOT NULL COMMENT '文档id',
                                        `uid` mediumint(8) unsigned NOT NULL COMMENT '作者uid',
                                        `agent` varchar(100) NOT NULL COMMENT '匿名',
                                        `inputtime` int(10) unsigned NOT NULL COMMENT '操作时间',
                                        PRIMARY KEY (`id`),
                                        KEY `cid` (`cid`),
                                        KEY `agent` (`agent`),
                                        KEY `inputtime` (`inputtime`),
                                        KEY `uid` (`uid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='支持操作记录表';

INSERT INTO `fhx_1_webnav_support` (`id`, `cid`, `uid`, `agent`, `inputtime`) VALUES
                                                                                  (2,	617,	1,	'a94caa2c069f17ad88f4a745de680d7f',	1702545422),
                                                                                  (3,	495,	0,	'a94caa2c069f17ad88f4a745de680d7f',	1703432732);

DROP TABLE IF EXISTS `fhx_1_webnav_time`;
CREATE TABLE `fhx_1_webnav_time` (
                                     `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
                                     `uid` mediumint(8) unsigned NOT NULL COMMENT '作者uid',
                                     `catid` mediumint(8) unsigned NOT NULL COMMENT '栏目id',
                                     `content` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '具体内容',
                                     `result` text COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '处理结果',
                                     `posttime` int(10) unsigned NOT NULL COMMENT '定时发布时间',
                                     `inputtime` int(10) unsigned NOT NULL COMMENT '录入时间',
                                     PRIMARY KEY (`id`),
                                     KEY `uid` (`uid`),
                                     KEY `catid` (`catid`),
                                     KEY `posttime` (`posttime`),
                                     KEY `inputtime` (`inputtime`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='内容定时发布表';


DROP TABLE IF EXISTS `fhx_1_webnav_verify`;
CREATE TABLE `fhx_1_webnav_verify` (
                                       `id` int(10) unsigned NOT NULL,
                                       `uid` mediumint(8) unsigned NOT NULL COMMENT '作者uid',
                                       `vid` tinyint(2) NOT NULL COMMENT '审核id号',
                                       `isnew` tinyint(1) unsigned NOT NULL COMMENT '是否新增',
                                       `islock` tinyint(1) unsigned NOT NULL COMMENT '是否锁定',
                                       `author` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '作者',
                                       `catid` mediumint(8) unsigned NOT NULL COMMENT '栏目id',
                                       `status` tinyint(2) NOT NULL COMMENT '审核状态',
                                       `content` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '具体内容',
                                       `backuid` mediumint(8) unsigned NOT NULL COMMENT '操作人uid',
                                       `backinfo` text COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '操作退回信息',
                                       `inputtime` int(10) unsigned NOT NULL COMMENT '录入时间',
                                       UNIQUE KEY `id` (`id`),
                                       KEY `uid` (`uid`),
                                       KEY `vid` (`vid`),
                                       KEY `catid` (`catid`),
                                       KEY `status` (`status`),
                                       KEY `inputtime` (`inputtime`),
                                       KEY `backuid` (`backuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='内容审核表';


DROP TABLE IF EXISTS `fhx_admin`;
CREATE TABLE `fhx_admin` (
                             `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
                             `uid` int(10) unsigned NOT NULL COMMENT '管理员uid',
                             `setting` mediumtext COLLATE utf8mb4_unicode_ci COMMENT '相关配置',
                             `usermenu` text COLLATE utf8mb4_unicode_ci COMMENT '自定义面板菜单，序列化数组格式',
                             `history` text COLLATE utf8mb4_unicode_ci COMMENT '历史菜单，序列化数组格式',
                             PRIMARY KEY (`id`),
                             UNIQUE KEY `uid` (`uid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='管理员表';

INSERT INTO `fhx_admin` (`id`, `uid`, `setting`, `usermenu`, `history`) VALUES
    (1,	1,	'{\"admin_min\":0}',	'',	NULL);

DROP TABLE IF EXISTS `fhx_admin_login`;
CREATE TABLE `fhx_admin_login` (
                                   `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
                                   `uid` mediumint(8) unsigned DEFAULT NULL COMMENT '会员uid',
                                   `loginip` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '登录Ip',
                                   `logintime` int(10) unsigned NOT NULL COMMENT '登录时间',
                                   `useragent` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '客户端信息',
                                   PRIMARY KEY (`id`),
                                   KEY `uid` (`uid`),
                                   KEY `loginip` (`loginip`),
                                   KEY `logintime` (`logintime`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='登录日志记录';

INSERT INTO `fhx_admin_login` (`id`, `uid`, `loginip`, `logintime`, `useragent`) VALUES
                                                                                     (1,	1,	'127.0.0.1',	1707197258,	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/121.0.0.0 Safari/537.36'),
                                                                                     (2,	1,	'127.0.0.1',	1708688834,	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/121.0.0.0 Safari/537.36');

DROP TABLE IF EXISTS `fhx_admin_menu`;
CREATE TABLE `fhx_admin_menu` (
                                  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
                                  `pid` smallint(5) unsigned NOT NULL COMMENT '上级菜单id',
                                  `name` text COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '菜单语言名称',
                                  `site` text COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '站点归属',
                                  `uri` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'uri字符串',
                                  `url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '外链地址',
                                  `mark` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '菜单标识',
                                  `hidden` tinyint(1) unsigned DEFAULT NULL COMMENT '是否隐藏',
                                  `icon` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '图标标示',
                                  `displayorder` int(5) DEFAULT NULL COMMENT '排序值',
                                  PRIMARY KEY (`id`),
                                  KEY `list` (`pid`),
                                  KEY `displayorder` (`displayorder`),
                                  KEY `mark` (`mark`),
                                  KEY `hidden` (`hidden`),
                                  KEY `uri` (`uri`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='后台菜单表';

INSERT INTO `fhx_admin_menu` (`id`, `pid`, `name`, `site`, `uri`, `url`, `mark`, `hidden`, `icon`, `displayorder`) VALUES
                                                                                                                       (1,	0,	'首页',	'',	'',	'',	'home',	0,	'fa fa-home',	-2),
                                                                                                                       (2,	1,	'我的面板',	'',	'',	'',	'home-my',	0,	'fa fa-home',	0),
                                                                                                                       (3,	2,	'后台首页',	'',	'home/main',	'',	'',	0,	'fa fa-home',	0),
                                                                                                                       (4,	2,	'资料修改',	'',	'api/my',	'',	'',	0,	'fa fa-user',	0),
                                                                                                                       (5,	2,	'系统更新',	'',	'cache/index',	'',	'',	0,	'fa fa-refresh',	0),
                                                                                                                       (6,	2,	'应用市场',	'',	'api/app',	'',	'',	0,	'fa fa-puzzle-piece',	0),
                                                                                                                       (7,	0,	'系统',	'',	'',	'',	'system',	0,	'fa fa-globe',	-2),
                                                                                                                       (8,	7,	'系统维护',	'',	'',	'',	'system-wh',	0,	'fa fa-cog',	0),
                                                                                                                       (9,	8,	'系统参数',	'',	'system/index',	'',	'',	0,	'fa fa-cog',	0),
                                                                                                                       (10,	8,	'系统缓存',	'',	'system_cache/index',	'',	'',	0,	'fa fa-clock-o',	0),
                                                                                                                       (11,	8,	'附件设置',	'',	'attachment/index',	'',	'',	0,	'fa fa-folder',	0),
                                                                                                                       (12,	8,	'存储策略',	'',	'attachment/remote_index',	'',	'',	0,	'fa fa-cloud',	0),
                                                                                                                       (13,	8,	'短信设置',	'',	'sms/index',	'',	'',	0,	'fa fa-envelope',	0),
                                                                                                                       (14,	8,	'邮件设置',	'',	'email/index',	'',	'',	0,	'fa fa-envelope-open',	0),
                                                                                                                       (15,	8,	'系统提醒',	'',	'notice/index',	'',	'',	0,	'fa fa-bell',	0),
                                                                                                                       (16,	8,	'系统体检',	'',	'check/index',	'',	'',	0,	'fa fa-wrench',	0),
                                                                                                                       (17,	7,	'日志管理',	'',	'',	'',	'system-log',	0,	'fa fa-calendar',	0),
                                                                                                                       (18,	17,	'系统日志',	'',	'error/index',	'',	'',	0,	'fa fa-shield',	0),
                                                                                                                       (19,	17,	'操作记录',	'',	'system_log/index',	'',	'',	0,	'fa fa-calendar',	0),
                                                                                                                       (20,	17,	'密码错误',	'',	'password_log/index',	'',	'',	0,	'fa fa-unlock-alt',	0),
                                                                                                                       (21,	17,	'短信错误',	'',	'sms_log/index',	'',	'',	0,	'fa fa-envelope',	0),
                                                                                                                       (22,	17,	'邮件错误',	'',	'email_log/index',	'',	'',	0,	'fa fa-envelope-open',	0),
                                                                                                                       (23,	17,	'慢查询日志',	'',	'sql_log/index',	'',	'',	0,	'fa fa-database',	0),
                                                                                                                       (24,	0,	'设置',	'',	'',	'',	'config',	0,	'fa fa-cogs',	-2),
                                                                                                                       (26,	0,	'权限',	'',	'',	'',	'auth',	0,	'fa fa-user-circle',	0),
                                                                                                                       (27,	26,	'后台权限',	'',	'',	'',	'auth-admin',	0,	'fa fa-cog',	0),
                                                                                                                       (28,	27,	'后台菜单',	'',	'menu/index',	'',	'',	0,	'fa fa-list-alt',	0),
                                                                                                                       (29,	27,	'简化菜单',	'',	'min_menu/index',	'',	'',	0,	'fa fa-list',	0),
                                                                                                                       (30,	27,	'角色权限',	'',	'role/index',	'',	'',	0,	'fa fa-users',	0),
                                                                                                                       (31,	27,	'角色账号',	'',	'root/index',	'',	'',	0,	'fa fa-user',	0),
                                                                                                                       (32,	0,	'应用',	'',	'',	'',	'app',	0,	'fa fa-puzzle-piece',	0),
                                                                                                                       (33,	32,	'应用插件',	'',	'',	'',	'app-plugin',	0,	'fa fa-puzzle-piece',	0),
                                                                                                                       (34,	33,	'应用管理',	'',	'cloud/local',	'',	'',	0,	'fa fa-folder',	0),
                                                                                                                       (35,	33,	'联动菜单',	'',	'linkage/index',	'',	'',	0,	'fa fa-columns',	0),
                                                                                                                       (36,	33,	'任务队列',	'',	'cron/index',	'',	'',	0,	'fa fa-indent',	0),
                                                                                                                       (37,	33,	'附件管理',	'',	'attachments/index',	'',	'',	0,	'fa fa-folder',	0),
                                                                                                                       (38,	32,	'模板调用工具',	'',	'',	'',	'app-mbdy',	0,	'fa fa-tag',	0),
                                                                                                                       (39,	38,	'字段调用标签',	'',	'mbdy/home/index',	'',	'',	0,	'fa fa-list',	0),
                                                                                                                       (40,	38,	'页面标签调用',	'',	'mbdy/page/index',	'',	'',	0,	'fa fa-list',	0),
                                                                                                                       (41,	38,	'循环标签调用',	'',	'mbdy/loop/index',	'',	'',	0,	'fa fa-list',	0),
                                                                                                                       (42,	38,	'内容搜索条件',	'',	'mbdy/search/index',	'',	'',	0,	'fa fa-search',	0),
                                                                                                                       (43,	0,	'服务',	'',	'',	'',	'cloud',	0,	'fa fa-cloud',	99),
                                                                                                                       (44,	43,	'项目服务',	'',	'',	'',	'cloud-dayrui',	0,	'fa fa-cloud',	0),
                                                                                                                       (45,	44,	'我的项目',	'',	'cloud/index',	'',	'',	0,	'fa fa-cog',	0),
                                                                                                                       (46,	44,	'服务工单',	'',	'cloud/service',	'',	'',	0,	'fa fa-user-md',	0),
                                                                                                                       (47,	44,	'应用商城',	'',	'cloud/app',	'',	'',	0,	'fa fa-puzzle-piece',	0),
                                                                                                                       (48,	44,	'模板商城',	'',	'cloud/template',	'',	'',	0,	'fa fa-html5',	0),
                                                                                                                       (49,	44,	'版本升级',	'',	'cloud/update',	'',	'',	0,	'fa fa-refresh',	0),
                                                                                                                       (50,	44,	'文件对比',	'',	'cloud/bf',	'',	'',	0,	'fa fa-code',	0),
                                                                                                                       (51,	24,	'网站设置',	'',	'',	'',	'config-web',	0,	'fa fa-cog',	-1),
                                                                                                                       (52,	51,	'网站设置',	'',	'module/site_config/index',	'',	'app-module-52',	0,	'fa fa-cog',	0),
                                                                                                                       (53,	51,	'网站信息',	'',	'module/site_param/index',	'',	'app-module-53',	0,	'fa fa-edit',	0),
                                                                                                                       (54,	51,	'手机设置',	'',	'module/site_mobile/index',	'',	'app-module-54',	0,	'fa fa-mobile',	0),
                                                                                                                       (55,	51,	'域名绑定',	'',	'module/site_domain/index',	'',	'app-module-55',	0,	'fa fa-globe',	0),
                                                                                                                       (56,	51,	'图片设置',	'',	'module/site_image/index',	'',	'app-module-56',	0,	'fa fa-photo',	0),
                                                                                                                       (57,	24,	'内容设置',	'',	'',	'',	'config-content',	0,	'fa fa-navicon',	0),
                                                                                                                       (58,	57,	'创建模块',	'',	'module/module_create/index',	'',	'app-module-58',	0,	'fa fa-plus',	-1),
                                                                                                                       (59,	57,	'模块管理',	'',	'module/module/index',	'',	'app-module-59',	0,	'fa fa-gears',	-1),
                                                                                                                       (60,	57,	'模块搜索',	'',	'module/module_search/index',	'',	'app-module-60',	0,	'fa fa-search',	-1),
                                                                                                                       (61,	24,	'SEO设置',	'',	'',	'',	'config-seo',	0,	'fa fa-internet-explorer',	0),
                                                                                                                       (62,	61,	'站点SEO',	'',	'module/seo_site/index',	'',	'app-module-62',	0,	'fa fa-cog',	0),
                                                                                                                       (63,	61,	'模块SEO',	'',	'module/seo_module/index',	'',	'app-module-63',	0,	'fa fa-th-large',	0),
                                                                                                                       (64,	61,	'栏目SEO',	'',	'module/seo_category/index',	'',	'app-module-64',	0,	'fa fa-reorder',	0),
                                                                                                                       (65,	61,	'URL规则',	'',	'module/urlrule/index',	'',	'app-module-65',	0,	'fa fa-link',	0),
                                                                                                                       (66,	61,	'伪静态解析',	'',	'module/urlrule/rewrite_index',	'',	'app-module-66',	0,	'bi bi-code-square',	0),
                                                                                                                       (67,	0,	'内容',	'',	'',	'',	'content',	0,	'fa fa-th-large',	-1),
                                                                                                                       (68,	67,	'内容管理',	'',	'',	'',	'content-module',	0,	'fa fa-th-large',	0),
                                                                                                                       (69,	68,	'共享栏目',	'',	'category/index',	'',	'app-module-69',	0,	'fa fa-reorder',	0),
                                                                                                                       (70,	67,	'内容审核',	'',	'',	'',	'content-verify',	0,	'fa fa-edit',	0),
                                                                                                                       (71,	68,	'网页导航管理',	'',	'webnav/home/index',	'',	'module-webnav',	0,	'fa fa-navicon',	-1),
                                                                                                                       (72,	70,	'网页导航审核',	'',	'webnav/verify/index',	'',	'verify-module-webnav',	0,	'fa fa-navicon',	-1),
                                                                                                                       (77,	33,	'模块内容点赞',	'',	'zan/home/index',	'',	'app-zan-77',	0,	'fa fa-thumbs-o-up',	0),
                                                                                                                       (78,	68,	'博客管理',	'',	'blog/home/index',	'',	'module-blog',	0,	'bi bi-file-earmark-text-fill',	-1),
                                                                                                                       (79,	70,	'博客审核',	'',	'blog/verify/index',	'',	'verify-module-blog',	0,	'bi bi-file-earmark-text-fill',	-1),
                                                                                                                       (80,	57,	'模块内容表单',	'',	'mform/module/index',	'',	'app-mform-80',	0,	'fa fa-list-alt',	0),
                                                                                                                       (82,	70,	'网页导航反馈',	'',	'webnav/fankui_verify/index',	'',	'app-mform-verify-webnav-fankui',	0,	'fa fa-table',	-1),
                                                                                                                       (83,	32,	'关键词库',	'',	'',	'',	'app-tag',	0,	'fa fa-tags',	0),
                                                                                                                       (84,	83,	'词库管理',	'',	'tag/home/index',	'',	'app-tag-84',	0,	'fa fa-tags',	0),
                                                                                                                       (85,	83,	'插件设置',	'',	'tag/config/index',	'',	'app-tag-85',	0,	'fa fa-cog',	0),
                                                                                                                       (86,	33,	'广告投放管理',	'',	'diygg/home/index',	'',	'app-jmsad-86',	0,	'fa fa-wrench',	0);

DROP TABLE IF EXISTS `fhx_admin_min_menu`;
CREATE TABLE `fhx_admin_min_menu` (
                                      `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
                                      `pid` smallint(5) unsigned NOT NULL COMMENT '上级菜单id',
                                      `name` text COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '菜单语言名称',
                                      `site` text COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '站点归属',
                                      `uri` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'uri字符串',
                                      `url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '外链地址',
                                      `mark` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '菜单标识',
                                      `hidden` tinyint(1) unsigned DEFAULT NULL COMMENT '是否隐藏',
                                      `icon` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '图标标示',
                                      `displayorder` int(5) DEFAULT NULL COMMENT '排序值',
                                      PRIMARY KEY (`id`),
                                      KEY `list` (`pid`),
                                      KEY `displayorder` (`displayorder`),
                                      KEY `mark` (`mark`),
                                      KEY `hidden` (`hidden`),
                                      KEY `uri` (`uri`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='后台简化菜单表';

INSERT INTO `fhx_admin_min_menu` (`id`, `pid`, `name`, `site`, `uri`, `url`, `mark`, `hidden`, `icon`, `displayorder`) VALUES
                                                                                                                           (1,	0,	'我的面板',	'',	'',	'',	'home',	0,	'fa fa-home',	0),
                                                                                                                           (2,	1,	'后台首页',	'',	'home/main',	'',	'1-0',	0,	'fa fa-home',	0),
                                                                                                                           (3,	1,	'资料修改',	'',	'api/my',	'',	'1-1',	0,	'fa fa-user',	0),
                                                                                                                           (4,	0,	'应用插件',	'',	'',	'',	'app-plugin',	0,	'fa fa-puzzle-piece',	0),
                                                                                                                           (5,	4,	'联动菜单',	'',	'linkage/index',	'',	'4-0',	0,	'fa fa-columns',	0),
                                                                                                                           (6,	4,	'附件管理',	'',	'attachments/index',	'',	'4-1',	0,	'fa fa-folder',	0),
                                                                                                                           (7,	1,	'网站设置',	'',	'module/site_param/index',	'',	'',	0,	'fa fa-cog',	0),
                                                                                                                           (8,	1,	'图片设置',	'',	'module/site_image/index',	'',	'',	0,	'fa fa-photo',	0),
                                                                                                                           (9,	0,	'SEO设置',	'',	'',	'',	'config-seo',	0,	'fa fa-internet-explorer',	0),
                                                                                                                           (10,	9,	'站点SEO',	'',	'module/seo_site/index',	'',	'',	0,	'fa fa-cog',	0),
                                                                                                                           (11,	9,	'模块SEO',	'',	'module/seo_module/index',	'',	'',	0,	'fa fa-gears',	0),
                                                                                                                           (12,	9,	'栏目SEO',	'',	'module/seo_category/index',	'',	'',	0,	'fa fa-reorder',	0),
                                                                                                                           (13,	9,	'URL规则',	'',	'module/urlrule/index',	'',	'',	0,	'fa fa-link',	0),
                                                                                                                           (14,	0,	'内容管理',	'',	'',	'',	'content-module',	0,	'fa fa-th-large',	0),
                                                                                                                           (15,	14,	'共享栏目',	'',	'category/index',	'',	'',	0,	'fa fa-reorder',	0),
                                                                                                                           (16,	14,	'网页导航管理',	'',	'webnav/home/index',	'',	'module-webnav',	0,	'fa fa-navicon',	-1),
                                                                                                                           (17,	14,	'博客管理',	'',	'blog/home/index',	'',	'module-blog',	0,	'bi bi-file-earmark-text-fill',	-1);

DROP TABLE IF EXISTS `fhx_admin_notice`;
CREATE TABLE `fhx_admin_notice` (
                                    `id` int(10) NOT NULL AUTO_INCREMENT COMMENT 'id',
                                    `site` int(5) NOT NULL COMMENT '站点id',
                                    `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '提醒类型：系统、内容、会员、应用',
                                    `msg` text COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '提醒内容说明',
                                    `uri` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '对应的URI',
                                    `to_rid` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '指定角色组',
                                    `to_uid` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '指定管理员',
                                    `status` tinyint(1) NOT NULL COMMENT '未处理0，1已查看，2处理中，3处理完成',
                                    `uid` int(10) NOT NULL COMMENT '申请人',
                                    `username` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '申请人',
                                    `op_uid` int(10) NOT NULL COMMENT '处理人',
                                    `op_username` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '处理人',
                                    `updatetime` int(10) NOT NULL COMMENT '处理时间',
                                    `inputtime` int(10) NOT NULL COMMENT '提醒时间',
                                    PRIMARY KEY (`id`),
                                    KEY `uri` (`uri`),
                                    KEY `site` (`site`),
                                    KEY `status` (`status`),
                                    KEY `uid` (`uid`),
                                    KEY `op_uid` (`op_uid`),
                                    KEY `to_uid` (`to_uid`),
                                    KEY `to_rid` (`to_rid`),
                                    KEY `updatetime` (`updatetime`),
                                    KEY `inputtime` (`inputtime`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='后台提醒表';

INSERT INTO `fhx_admin_notice` (`id`, `site`, `type`, `msg`, `uri`, `to_rid`, `to_uid`, `status`, `uid`, `username`, `op_uid`, `op_username`, `updatetime`, `inputtime`) VALUES
                                                                                                                                                                             (1,	1,	'content',	'网页导航[Midjourney]: 反馈提交内容审核',	'webnav/fankui_verify/edit:cid/510/id/1',	'0',	'0',	1,	1,	'admin',	1,	'admin',	0,	1702572876),
                                                                                                                                                                             (2,	1,	'content',	'网页导航[Whimsical]: 反馈提交内容审核',	'webnav/fankui_verify/edit:cid/617/id/2',	'0',	'0',	1,	1,	'admin',	1,	'admin',	0,	1702572939),
                                                                                                                                                                             (3,	1,	'content',	'网页导航[Whimsical]: 反馈提交内容审核',	'webnav/fankui_verify/edit:cid/617/id/3',	'0',	'0',	1,	1,	'admin',	1,	'admin',	0,	1702573050),
                                                                                                                                                                             (4,	1,	'content',	'网页导航[Whimsical]: 反馈提交内容审核',	'webnav/fankui_verify/edit:cid/617/id/4',	'0',	'0',	1,	1,	'admin',	1,	'admin',	0,	1702573100);

DROP TABLE IF EXISTS `fhx_admin_role`;
CREATE TABLE `fhx_admin_role` (
                                  `id` smallint(5) NOT NULL AUTO_INCREMENT,
                                  `site` text COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '允许管理的站点，序列化数组格式',
                                  `name` text COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '角色组语言名称',
                                  `system` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '系统权限',
                                  `module` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '模块权限',
                                  `application` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '应用权限',
                                  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='后台角色权限表';

INSERT INTO `fhx_admin_role` (`id`, `site`, `name`, `system`, `module`, `application`) VALUES
                                                                                           (1,	'',	'超级管理员',	'',	'',	''),
                                                                                           (2,	'',	'编辑员',	'',	'',	'');

DROP TABLE IF EXISTS `fhx_admin_role_index`;
CREATE TABLE `fhx_admin_role_index` (
                                        `id` smallint(5) NOT NULL AUTO_INCREMENT,
                                        `uid` mediumint(8) unsigned DEFAULT NULL COMMENT '会员uid',
                                        `roleid` mediumint(8) unsigned DEFAULT NULL COMMENT '角色组id',
                                        PRIMARY KEY (`id`),
                                        KEY `uid` (`uid`),
                                        KEY `roleid` (`roleid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='后台角色组分配表';

INSERT INTO `fhx_admin_role_index` (`id`, `uid`, `roleid`) VALUES
    (1,	1,	1);

DROP TABLE IF EXISTS `fhx_admin_setting`;
CREATE TABLE `fhx_admin_setting` (
                                     `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
                                     `value` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
                                     PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='系统属性参数表';


DROP TABLE IF EXISTS `fhx_attachment`;
CREATE TABLE `fhx_attachment` (
                                  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
                                  `uid` mediumint(8) unsigned NOT NULL COMMENT '会员id',
                                  `author` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '会员',
                                  `siteid` mediumint(5) unsigned NOT NULL COMMENT '站点id',
                                  `related` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '相关表标识',
                                  `tableid` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '附件副表id',
                                  `download` mediumint(8) NOT NULL DEFAULT '0' COMMENT '无用保留',
                                  `filesize` int(10) unsigned NOT NULL COMMENT '文件大小',
                                  `fileext` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '文件扩展名',
                                  `filemd5` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '文件md5值',
                                  PRIMARY KEY (`id`),
                                  KEY `uid` (`uid`),
                                  KEY `author` (`author`),
                                  KEY `relatedtid` (`related`),
                                  KEY `fileext` (`fileext`),
                                  KEY `filemd5` (`filemd5`),
                                  KEY `siteid` (`siteid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='附件表';

INSERT INTO `fhx_attachment` (`id`, `uid`, `author`, `siteid`, `related`, `tableid`, `download`, `filesize`, `fileext`, `filemd5`) VALUES
                                                                                                                                       (1,	1,	'',	1,	'rand',	1,	0,	22382,	'jpeg',	'550e1c173c0b73ffa0335a9844ed2030'),
                                                                                                                                       (2,	0,	'',	1,	'fhx_1_webnav-70',	0,	0,	37968,	'png',	'a2fcb89e87f01cbd6b7a3426f2df7cf8'),
                                                                                                                                       (3,	1,	'',	1,	'ueditor:39e6c1737eaca01f1668dcc23d480a82',	1,	0,	74700,	'png',	'51bde152e6cd6e25bc2975714b6a3d45'),
                                                                                                                                       (4,	1,	'',	1,	'ueditor:39e6c1737eaca01f1668dcc23d480a82',	1,	0,	56683,	'png',	'd2730d370f2988acedf676851e11ae80'),
                                                                                                                                       (5,	0,	'',	1,	'fhx_1_webnav-69',	0,	0,	34133,	'png',	'4a3c82810a6507a10f90b347006280bc'),
                                                                                                                                       (6,	0,	'',	1,	'fhx_1_webnav-68',	0,	0,	25552,	'png',	'73b4d04013a2cc17f6cfd49129062b4b'),
                                                                                                                                       (7,	0,	'',	1,	'fhx_1_webnav-66',	0,	0,	42962,	'jpeg',	'7ed8137869e11386b4a253cb056ce865'),
                                                                                                                                       (8,	0,	'',	1,	'fhx_1_webnav-56',	0,	0,	48457,	'png',	'23accc30a4746e73205ac28c20470a12'),
                                                                                                                                       (9,	0,	'',	1,	'fhx_1_webnav-54',	0,	0,	40919,	'png',	'286d82691353ee02db8d3e7eb530764f'),
                                                                                                                                       (10,	0,	'',	1,	'fhx_1_webnav-53',	0,	0,	52482,	'png',	'ed6d626b4b27b34e05e6efbf7bb6517d'),
                                                                                                                                       (11,	0,	'',	1,	'fhx_1_webnav-51',	0,	0,	44759,	'jpeg',	'e136f33819690b4106743396575ef02f'),
                                                                                                                                       (12,	0,	'',	1,	'fhx_1_webnav-64',	0,	0,	41129,	'jpeg',	'fbfd488aee67d8f62c555a9b6089c619'),
                                                                                                                                       (13,	0,	'',	1,	'fhx_1_webnav-60',	0,	0,	48977,	'png',	'fbc53c26d02441ec49d354837ab0b80f'),
                                                                                                                                       (14,	0,	'',	1,	'fhx_1_webnav-62',	0,	0,	68479,	'png',	'f95bd9ff46f6440af3c37e4da7df426d'),
                                                                                                                                       (15,	0,	'',	1,	'fhx_1_webnav-61',	0,	0,	32948,	'png',	'dae7b7a626a5288243bcec61bd8291a2'),
                                                                                                                                       (16,	0,	'',	1,	'fhx_1_webnav-63',	0,	0,	46247,	'png',	'adff2af2d5c30035e8544df1389c42af'),
                                                                                                                                       (17,	0,	'',	1,	'fhx_1_webnav-67',	0,	0,	33563,	'png',	'4a6db631b9d35135f9560ddef4be8885'),
                                                                                                                                       (18,	0,	'',	1,	'fhx_1_webnav-57',	0,	0,	39337,	'png',	'0865a2aa1f72b9d6505b1bfc7da8f704'),
                                                                                                                                       (19,	0,	'',	1,	'fhx_1_webnav-49',	0,	0,	13550,	'jpeg',	'4e69cbd54b9cc6b6de2352a340902971'),
                                                                                                                                       (20,	0,	'',	1,	'fhx_1_webnav-50',	0,	0,	41789,	'png',	'3b961ceabc2a297c8e1a651311e83c36'),
                                                                                                                                       (21,	0,	'',	1,	'fhx_1_webnav-59',	0,	0,	42848,	'png',	'45fe33f1d3e5a8f27578ab89055b2b54'),
                                                                                                                                       (22,	0,	'',	1,	'fhx_1_webnav-48',	0,	0,	52957,	'png',	'1ed8db184e7f89021b20f121300ce68f'),
                                                                                                                                       (23,	0,	'',	1,	'fhx_1_webnav-46',	0,	0,	45381,	'png',	'14d761af46f0136e3269a778052c2b46'),
                                                                                                                                       (24,	0,	'',	1,	'fhx_1_webnav-45',	0,	0,	45188,	'png',	'54f4b12c1fe0221ee00d6ea215afe763'),
                                                                                                                                       (25,	0,	'',	1,	'fhx_1_webnav-44',	0,	0,	64770,	'jpeg',	'76e36e859857512494a624aad809ae7b'),
                                                                                                                                       (26,	0,	'',	1,	'fhx_1_webnav-43',	0,	0,	70195,	'png',	'0d960d1009e868125a69467dee1d984c'),
                                                                                                                                       (27,	0,	'',	1,	'fhx_1_webnav-47',	0,	0,	49976,	'png',	'e7409134a984bd0d64747e518372cd38'),
                                                                                                                                       (28,	0,	'',	1,	'fhx_1_webnav-41',	0,	0,	37522,	'png',	'5472f3298bb71ee706d6e336f33f98c9'),
                                                                                                                                       (29,	0,	'',	1,	'fhx_1_webnav-39',	0,	0,	25510,	'png',	'ca7573f86494c814e98f6a5bc9e7685b'),
                                                                                                                                       (30,	0,	'',	1,	'fhx_1_webnav-38',	0,	0,	30314,	'png',	'8262e4fdcee924ed48440863c83b68d4'),
                                                                                                                                       (31,	0,	'',	1,	'fhx_1_webnav-42',	0,	0,	59056,	'png',	'524b51b1566eb4d3e3178557ba1da627'),
                                                                                                                                       (32,	0,	'',	1,	'fhx_1_webnav-36',	0,	0,	46500,	'png',	'6eb26bdce7e48655babae94a33762540'),
                                                                                                                                       (33,	0,	'',	1,	'fhx_1_webnav-34',	0,	0,	29392,	'png',	'6caccbd80069a0d527ee74f4d164994d'),
                                                                                                                                       (34,	0,	'',	1,	'fhx_1_webnav-35',	0,	0,	60897,	'png',	'5b8a6e829c09a536fd39621d13f07a6b'),
                                                                                                                                       (35,	0,	'',	1,	'fhx_1_webnav-32',	0,	0,	26735,	'jpeg',	'095d805630f2105f49f4c74d47643013'),
                                                                                                                                       (36,	0,	'',	1,	'fhx_1_webnav-33',	0,	0,	15756,	'jpeg',	'329d59cef74fa9c911f71a529a2ecbb6'),
                                                                                                                                       (37,	0,	'',	1,	'fhx_1_webnav-31',	0,	0,	53922,	'jpeg',	'35f0babf1680a004584b259fdb502d30'),
                                                                                                                                       (38,	0,	'',	1,	'fhx_1_webnav-29',	0,	0,	43609,	'jpeg',	'df5fdddd80f190aebd5eec69562bec18'),
                                                                                                                                       (39,	0,	'',	1,	'fhx_1_webnav-30',	0,	0,	47092,	'png',	'61ce86e50286cd2eadd432477fd39b87'),
                                                                                                                                       (40,	0,	'',	1,	'fhx_1_webnav-28',	0,	0,	20622,	'jpeg',	'f5c236048560afe2ae56dbd173dee470'),
                                                                                                                                       (41,	0,	'',	1,	'fhx_1_webnav-25',	0,	0,	34027,	'png',	'ae4e37d37abfa6287a1fcc574d674e31'),
                                                                                                                                       (42,	0,	'',	1,	'fhx_1_webnav-26',	0,	0,	38234,	'jpeg',	'4f88f60b033853fe295dc95321c76db3'),
                                                                                                                                       (43,	0,	'',	1,	'fhx_1_webnav-27',	0,	0,	46555,	'png',	'67ca94ed5f5a4009d052f5c865281303'),
                                                                                                                                       (44,	0,	'',	1,	'fhx_1_webnav-24',	0,	0,	50661,	'jpeg',	'2218dcc42cb95d72dff8b1cb11e78731'),
                                                                                                                                       (45,	0,	'',	1,	'fhx_1_webnav-23',	0,	0,	64882,	'jpeg',	'5dae4d139cb7f0f9c8efa5841a0c5355'),
                                                                                                                                       (46,	0,	'',	1,	'fhx_1_webnav-10',	0,	0,	67565,	'png',	'cae78fbcc949265de54b0ff95a3c9cb1'),
                                                                                                                                       (47,	0,	'',	1,	'fhx_1_webnav-9',	0,	0,	67208,	'jpeg',	'9bfb815ac3118854a284f5237b0f0923'),
                                                                                                                                       (48,	0,	'',	1,	'fhx_1_webnav-22',	0,	0,	34508,	'png',	'177fd1d835173f2676217bddeaeebaa8'),
                                                                                                                                       (49,	0,	'',	1,	'fhx_1_webnav-5',	0,	0,	96651,	'png',	'246468c0840718ea9da7cb689562af7d'),
                                                                                                                                       (50,	0,	'',	1,	'rand',	0,	0,	22089,	'jpeg',	'a2a2f92b2a6e7baa4c44273bdcf54976'),
                                                                                                                                       (51,	0,	'',	1,	'rand',	0,	0,	5524,	'png',	'9e53aaced7927b3e96a4d0344aadc618'),
                                                                                                                                       (52,	0,	'',	1,	'rand',	0,	0,	51824,	'png',	'02d2da8784ffb9acbc646e9495b62125'),
                                                                                                                                       (53,	0,	'',	1,	'rand',	0,	0,	10292,	'jpeg',	'03e92373de960a1146860dbda5b48c3c'),
                                                                                                                                       (54,	0,	'',	1,	'rand',	0,	0,	5006,	'png',	'b32c6d128bbecff4dd2625f4874b3dad'),
                                                                                                                                       (55,	0,	'',	1,	'rand',	0,	0,	83988,	'png',	'e01c4d34c9038f2db9f9e049c8924796'),
                                                                                                                                       (56,	0,	'',	1,	'rand',	0,	0,	42917,	'png',	'8f664297495bfe9ea76d22eece47dc91'),
                                                                                                                                       (57,	0,	'',	1,	'rand',	0,	0,	9389,	'png',	'4cb2acaa0aa89c5cc5d0851119b83106'),
                                                                                                                                       (58,	0,	'',	1,	'rand',	0,	0,	29120,	'png',	'1988dc37fa8929380f4626d9eb9eb48f'),
                                                                                                                                       (59,	0,	'',	1,	'rand_collapi',	0,	0,	25510,	'png',	'ca7573f86494c814e98f6a5bc9e7685b'),
                                                                                                                                       (60,	0,	'',	1,	'rand',	0,	0,	3720,	'png',	'ff2bbbd7952dacf257f6e41e896457d1'),
                                                                                                                                       (61,	0,	'',	1,	'rand',	0,	0,	82277,	'png',	'db319d6d48d299752efc0ebf056c508d'),
                                                                                                                                       (62,	0,	'',	1,	'rand_collapi',	0,	0,	26735,	'jpeg',	'095d805630f2105f49f4c74d47643013'),
                                                                                                                                       (63,	0,	'',	1,	'rand',	0,	0,	4242,	'png',	'04bd3bae1cace7ea84d04528b6260d22'),
                                                                                                                                       (64,	0,	'',	1,	'rand_collapi',	0,	0,	53922,	'jpeg',	'35f0babf1680a004584b259fdb502d30'),
                                                                                                                                       (65,	0,	'',	1,	'rand',	0,	0,	9682,	'png',	'5a226943c024bf0bbf1cbaf02578c4d9'),
                                                                                                                                       (66,	0,	'',	1,	'rand_collapi',	0,	0,	47092,	'png',	'61ce86e50286cd2eadd432477fd39b87'),
                                                                                                                                       (67,	0,	'',	1,	'rand',	0,	0,	6420,	'png',	'fa58ddcd727616c53fbe7735e359f61e'),
                                                                                                                                       (68,	0,	'',	1,	'rand_collapi',	0,	0,	43609,	'jpeg',	'df5fdddd80f190aebd5eec69562bec18'),
                                                                                                                                       (69,	0,	'',	1,	'rand',	0,	0,	19466,	'png',	'ac34d3b5ae4bdead9c7b0cf2febb08ba'),
                                                                                                                                       (70,	0,	'',	1,	'rand_collapi',	0,	0,	20622,	'jpeg',	'f5c236048560afe2ae56dbd173dee470'),
                                                                                                                                       (71,	0,	'',	1,	'rand',	0,	0,	3072,	'png',	'a361a3e697bfaca88bffade5c5bb1009'),
                                                                                                                                       (72,	0,	'',	1,	'rand_collapi',	0,	0,	46555,	'png',	'67ca94ed5f5a4009d052f5c865281303'),
                                                                                                                                       (73,	0,	'',	1,	'rand',	0,	0,	2857,	'png',	'dcce5f947f7c6e7175acc0b327746dfd'),
                                                                                                                                       (74,	0,	'',	1,	'rand_collapi',	0,	0,	38234,	'jpeg',	'4f88f60b033853fe295dc95321c76db3'),
                                                                                                                                       (75,	0,	'',	1,	'rand',	0,	0,	7771,	'png',	'84751b639b59db216c8309194ac15897'),
                                                                                                                                       (76,	0,	'',	1,	'rand_collapi',	0,	0,	34027,	'png',	'ae4e37d37abfa6287a1fcc574d674e31'),
                                                                                                                                       (77,	0,	'',	1,	'rand',	0,	0,	7904,	'png',	'db1f35bc2c73951a6724795ec63e2f60'),
                                                                                                                                       (78,	0,	'',	1,	'rand_collapi',	0,	0,	50661,	'jpeg',	'2218dcc42cb95d72dff8b1cb11e78731'),
                                                                                                                                       (79,	0,	'',	1,	'rand',	0,	0,	10035,	'png',	'f33612144fee4318f963b51d67ce98d8'),
                                                                                                                                       (80,	0,	'',	1,	'rand',	0,	0,	45284,	'jpeg',	'2ba34d5f2210535ecb2cd787256f9be9'),
                                                                                                                                       (81,	0,	'',	1,	'rand_collapi',	0,	0,	64882,	'jpeg',	'5dae4d139cb7f0f9c8efa5841a0c5355'),
                                                                                                                                       (82,	0,	'',	1,	'rand',	0,	0,	8001,	'png',	'5769cb38371ede091b9687fab13039aa'),
                                                                                                                                       (83,	0,	'',	1,	'rand',	0,	0,	22382,	'jpeg',	'550e1c173c0b73ffa0335a9844ed2030'),
                                                                                                                                       (84,	0,	'',	1,	'rand',	0,	0,	6748,	'png',	'bf48a03a4b4894d84830633dcc67ef03'),
                                                                                                                                       (85,	0,	'',	1,	'rand',	0,	0,	7949,	'png',	'86a7c6bbf5733fee9bb348c4d2b97149'),
                                                                                                                                       (86,	0,	'',	1,	'rand',	0,	0,	2211,	'png',	'9dda6cd2c6975a5c8e42fab99f13321e'),
                                                                                                                                       (87,	0,	'',	1,	'rand',	0,	0,	12498,	'png',	'c465d838f0275228321449ef6be17266'),
                                                                                                                                       (88,	0,	'',	1,	'rand',	0,	0,	27847,	'jpeg',	'747c72892ee3564144afc47669f37b7b'),
                                                                                                                                       (89,	0,	'',	1,	'rand',	0,	0,	4520,	'png',	'f9e09fe406488754818679c0aaf0fb52'),
                                                                                                                                       (90,	0,	'',	1,	'rand',	0,	0,	29880,	'jpeg',	'845e0d8a57e7b40c1b730a69b84f2cc6'),
                                                                                                                                       (91,	0,	'',	1,	'rand',	0,	0,	7361,	'png',	'6ceb523bb03dfde667582b83e213bc7a'),
                                                                                                                                       (92,	0,	'',	1,	'rand',	0,	0,	6363,	'png',	'c6bb28a4f120537ded082e182b7f9ae2'),
                                                                                                                                       (93,	0,	'',	1,	'rand',	0,	0,	5776,	'png',	'5d8f1120b3aee74223177510aac1e032'),
                                                                                                                                       (94,	0,	'',	1,	'rand',	0,	0,	5375,	'png',	'e0c6edbd24aa8dd927992ad7f499432c'),
                                                                                                                                       (95,	0,	'',	1,	'rand',	0,	0,	9158,	'png',	'1927727dadb3135cc33a7435caf60973'),
                                                                                                                                       (96,	0,	'',	1,	'rand',	0,	0,	4885,	'png',	'2919ed9864c3b765a60a263809907c89'),
                                                                                                                                       (97,	0,	'',	1,	'rand',	0,	0,	9430,	'png',	'72e86bffae1c05df167abc9aabd203e6'),
                                                                                                                                       (98,	0,	'',	1,	'rand',	0,	0,	31093,	'jpeg',	'090e6329f203508d42ec4a282e0d9bb6'),
                                                                                                                                       (99,	0,	'',	1,	'rand',	0,	0,	3452,	'png',	'1c9ab084bce46e8feaeff2367adeab4a'),
                                                                                                                                       (100,	0,	'',	1,	'rand',	0,	0,	7247,	'png',	'8ff92182bcecd707dc4d6816366422fe'),
                                                                                                                                       (101,	0,	'',	1,	'rand_collapi',	0,	0,	96651,	'png',	'246468c0840718ea9da7cb689562af7d'),
                                                                                                                                       (102,	0,	'',	1,	'rand',	0,	0,	9178,	'png',	'385eb185b6aa1ceb3c681bcacba09050'),
                                                                                                                                       (103,	0,	'',	1,	'rand',	0,	0,	2912,	'png',	'c42e09f1ea2e32048db411aaa2b7a6c4'),
                                                                                                                                       (104,	0,	'',	1,	'rand',	0,	0,	1945,	'png',	'7b93290674b5c22beee21a81d093263b'),
                                                                                                                                       (105,	0,	'',	1,	'rand',	0,	0,	3457,	'png',	'59f702e33e86fa064192022076c70aa1'),
                                                                                                                                       (106,	0,	'',	1,	'rand_collapi',	0,	0,	67208,	'jpeg',	'9bfb815ac3118854a284f5237b0f0923'),
                                                                                                                                       (107,	0,	'',	1,	'rand',	0,	0,	3359,	'png',	'73c89926cb326853266ef778f8e7c20e'),
                                                                                                                                       (108,	0,	'',	1,	'rand_collapi',	0,	0,	67565,	'png',	'cae78fbcc949265de54b0ff95a3c9cb1'),
                                                                                                                                       (109,	0,	'',	1,	'rand',	0,	0,	7108,	'png',	'cf82163e941c2bb6df1aaaf0069b6156'),
                                                                                                                                       (110,	0,	'',	1,	'rand',	0,	0,	24034,	'jpeg',	'8e5deb68b625f319270b29b418c43cfe'),
                                                                                                                                       (111,	0,	'',	1,	'rand',	0,	0,	4029,	'png',	'770adc687879d177b92af6640d7ee262'),
                                                                                                                                       (112,	0,	'',	1,	'rand_collapi',	0,	0,	34508,	'png',	'177fd1d835173f2676217bddeaeebaa8'),
                                                                                                                                       (113,	0,	'',	1,	'rand',	0,	0,	2856,	'png',	'cb77a60042209d2ba77d0661f019bb65'),
                                                                                                                                       (114,	0,	'',	1,	'rand_collapi',	0,	0,	4885,	'png',	'2919ed9864c3b765a60a263809907c89'),
                                                                                                                                       (115,	0,	'',	1,	'rand_collapi',	0,	0,	9430,	'png',	'72e86bffae1c05df167abc9aabd203e6'),
                                                                                                                                       (116,	0,	'',	1,	'rand_collapi',	0,	0,	31093,	'jpeg',	'090e6329f203508d42ec4a282e0d9bb6'),
                                                                                                                                       (117,	0,	'',	1,	'rand_collapi',	0,	0,	3452,	'png',	'1c9ab084bce46e8feaeff2367adeab4a'),
                                                                                                                                       (118,	0,	'',	1,	'rand_collapi',	0,	0,	7247,	'png',	'8ff92182bcecd707dc4d6816366422fe'),
                                                                                                                                       (119,	0,	'',	1,	'rand_collapi',	0,	0,	96651,	'png',	'246468c0840718ea9da7cb689562af7d'),
                                                                                                                                       (120,	0,	'',	1,	'rand_collapi',	0,	0,	9178,	'png',	'385eb185b6aa1ceb3c681bcacba09050'),
                                                                                                                                       (121,	0,	'',	1,	'rand_collapi',	0,	0,	2912,	'png',	'c42e09f1ea2e32048db411aaa2b7a6c4'),
                                                                                                                                       (122,	0,	'',	1,	'rand_collapi',	0,	0,	1945,	'png',	'7b93290674b5c22beee21a81d093263b'),
                                                                                                                                       (123,	0,	'',	1,	'rand_collapi',	0,	0,	3457,	'png',	'59f702e33e86fa064192022076c70aa1'),
                                                                                                                                       (124,	0,	'',	1,	'rand_collapi',	0,	0,	67208,	'jpeg',	'9bfb815ac3118854a284f5237b0f0923'),
                                                                                                                                       (125,	0,	'',	1,	'rand_collapi',	0,	0,	3359,	'png',	'73c89926cb326853266ef778f8e7c20e'),
                                                                                                                                       (126,	0,	'',	1,	'rand_collapi',	0,	0,	67565,	'png',	'cae78fbcc949265de54b0ff95a3c9cb1'),
                                                                                                                                       (127,	0,	'',	1,	'rand_collapi',	0,	0,	7108,	'png',	'cf82163e941c2bb6df1aaaf0069b6156'),
                                                                                                                                       (128,	0,	'',	1,	'rand_collapi',	0,	0,	22382,	'jpeg',	'550e1c173c0b73ffa0335a9844ed2030'),
                                                                                                                                       (129,	0,	'',	1,	'rand_collapi',	0,	0,	6748,	'png',	'bf48a03a4b4894d84830633dcc67ef03'),
                                                                                                                                       (130,	0,	'',	1,	'rand_collapi',	0,	0,	7949,	'png',	'86a7c6bbf5733fee9bb348c4d2b97149'),
                                                                                                                                       (131,	0,	'',	1,	'rand_collapi',	0,	0,	2211,	'png',	'9dda6cd2c6975a5c8e42fab99f13321e'),
                                                                                                                                       (132,	0,	'',	1,	'rand_collapi',	0,	0,	12498,	'png',	'c465d838f0275228321449ef6be17266'),
                                                                                                                                       (133,	0,	'',	1,	'rand_collapi',	0,	0,	27847,	'jpeg',	'747c72892ee3564144afc47669f37b7b'),
                                                                                                                                       (134,	0,	'',	1,	'rand_collapi',	0,	0,	4520,	'png',	'f9e09fe406488754818679c0aaf0fb52'),
                                                                                                                                       (135,	0,	'',	1,	'rand_collapi',	0,	0,	29880,	'jpeg',	'845e0d8a57e7b40c1b730a69b84f2cc6'),
                                                                                                                                       (136,	0,	'',	1,	'rand_collapi',	0,	0,	7361,	'png',	'6ceb523bb03dfde667582b83e213bc7a'),
                                                                                                                                       (137,	0,	'',	1,	'rand_collapi',	0,	0,	6363,	'png',	'c6bb28a4f120537ded082e182b7f9ae2'),
                                                                                                                                       (138,	0,	'',	1,	'rand_collapi',	0,	0,	5776,	'png',	'5d8f1120b3aee74223177510aac1e032'),
                                                                                                                                       (139,	0,	'',	1,	'rand_collapi',	0,	0,	5375,	'png',	'e0c6edbd24aa8dd927992ad7f499432c'),
                                                                                                                                       (140,	0,	'',	1,	'rand_collapi',	0,	0,	9158,	'png',	'1927727dadb3135cc33a7435caf60973'),
                                                                                                                                       (141,	0,	'',	1,	'rand_collapi',	0,	0,	24034,	'jpeg',	'8e5deb68b625f319270b29b418c43cfe'),
                                                                                                                                       (142,	0,	'',	1,	'rand_collapi',	0,	0,	4029,	'png',	'770adc687879d177b92af6640d7ee262'),
                                                                                                                                       (143,	0,	'',	1,	'rand_collapi',	0,	0,	34508,	'png',	'177fd1d835173f2676217bddeaeebaa8'),
                                                                                                                                       (144,	0,	'',	1,	'rand_collapi',	0,	0,	2856,	'png',	'cb77a60042209d2ba77d0661f019bb65'),
                                                                                                                                       (145,	0,	'',	1,	'rand_collapi',	0,	0,	64882,	'jpeg',	'5dae4d139cb7f0f9c8efa5841a0c5355'),
                                                                                                                                       (146,	0,	'',	1,	'rand_collapi',	0,	0,	8001,	'png',	'5769cb38371ede091b9687fab13039aa'),
                                                                                                                                       (147,	0,	'',	1,	'rand_collapi',	0,	0,	50661,	'jpeg',	'2218dcc42cb95d72dff8b1cb11e78731'),
                                                                                                                                       (148,	0,	'',	1,	'rand_collapi',	0,	0,	10035,	'png',	'f33612144fee4318f963b51d67ce98d8'),
                                                                                                                                       (149,	0,	'',	1,	'rand_collapi',	0,	0,	45284,	'jpeg',	'2ba34d5f2210535ecb2cd787256f9be9'),
                                                                                                                                       (150,	0,	'',	1,	'rand_collapi',	0,	0,	34027,	'png',	'ae4e37d37abfa6287a1fcc574d674e31'),
                                                                                                                                       (151,	0,	'',	1,	'rand_collapi',	0,	0,	7904,	'png',	'db1f35bc2c73951a6724795ec63e2f60'),
                                                                                                                                       (152,	0,	'',	1,	'rand_collapi',	0,	0,	38234,	'jpeg',	'4f88f60b033853fe295dc95321c76db3'),
                                                                                                                                       (153,	0,	'',	1,	'rand_collapi',	0,	0,	7771,	'png',	'84751b639b59db216c8309194ac15897'),
                                                                                                                                       (154,	0,	'',	1,	'rand_collapi',	0,	0,	46555,	'png',	'67ca94ed5f5a4009d052f5c865281303'),
                                                                                                                                       (155,	0,	'',	1,	'rand_collapi',	0,	0,	2857,	'png',	'dcce5f947f7c6e7175acc0b327746dfd'),
                                                                                                                                       (156,	0,	'',	1,	'rand_collapi',	0,	0,	20622,	'jpeg',	'f5c236048560afe2ae56dbd173dee470'),
                                                                                                                                       (157,	0,	'',	1,	'rand_collapi',	0,	0,	3072,	'png',	'a361a3e697bfaca88bffade5c5bb1009'),
                                                                                                                                       (158,	0,	'',	1,	'rand_collapi',	0,	0,	43609,	'jpeg',	'df5fdddd80f190aebd5eec69562bec18'),
                                                                                                                                       (159,	0,	'',	1,	'rand_collapi',	0,	0,	19466,	'png',	'ac34d3b5ae4bdead9c7b0cf2febb08ba'),
                                                                                                                                       (160,	0,	'',	1,	'rand_collapi',	0,	0,	47092,	'png',	'61ce86e50286cd2eadd432477fd39b87'),
                                                                                                                                       (161,	0,	'',	1,	'rand_collapi',	0,	0,	6420,	'png',	'fa58ddcd727616c53fbe7735e359f61e'),
                                                                                                                                       (162,	0,	'',	1,	'rand_collapi',	0,	0,	53922,	'jpeg',	'35f0babf1680a004584b259fdb502d30'),
                                                                                                                                       (163,	0,	'',	1,	'rand_collapi',	0,	0,	9682,	'png',	'5a226943c024bf0bbf1cbaf02578c4d9'),
                                                                                                                                       (164,	0,	'',	1,	'rand_collapi',	0,	0,	26735,	'jpeg',	'095d805630f2105f49f4c74d47643013'),
                                                                                                                                       (165,	0,	'',	1,	'rand_collapi',	0,	0,	4242,	'png',	'04bd3bae1cace7ea84d04528b6260d22'),
                                                                                                                                       (166,	0,	'',	1,	'rand_collapi',	0,	0,	15756,	'jpeg',	'329d59cef74fa9c911f71a529a2ecbb6'),
                                                                                                                                       (167,	0,	'',	1,	'rand',	0,	0,	9146,	'png',	'e3b9d6aa6ba8e6b04199a47862bb6ba4'),
                                                                                                                                       (168,	0,	'',	1,	'rand',	0,	0,	19907,	'jpeg',	'7559f72050a4528929532a20884ce018'),
                                                                                                                                       (169,	0,	'',	1,	'rand_collapi',	0,	0,	29392,	'png',	'6caccbd80069a0d527ee74f4d164994d'),
                                                                                                                                       (170,	0,	'',	1,	'rand',	0,	0,	3823,	'png',	'acdcf78cc33f6d77cd0b5f1dcbf07b31'),
                                                                                                                                       (171,	0,	'',	1,	'rand_collapi',	0,	0,	60897,	'png',	'5b8a6e829c09a536fd39621d13f07a6b'),
                                                                                                                                       (172,	0,	'',	1,	'rand',	0,	0,	3118,	'png',	'1a9b4eefdcef5292c5824ec010d965e9'),
                                                                                                                                       (173,	0,	'',	1,	'rand_collapi',	0,	0,	46500,	'png',	'6eb26bdce7e48655babae94a33762540'),
                                                                                                                                       (174,	0,	'',	1,	'rand',	0,	0,	9091,	'png',	'31ca88a9b5515fd502f8487938c3e855'),
                                                                                                                                       (175,	0,	'',	1,	'rand',	0,	0,	6548,	'png',	'ad830b406efc0f607ad1a5b90de421df'),
                                                                                                                                       (176,	0,	'',	1,	'rand_collapi',	0,	0,	30314,	'png',	'8262e4fdcee924ed48440863c83b68d4'),
                                                                                                                                       (177,	0,	'',	1,	'rand',	0,	0,	3072,	'png',	'f48b24feb99dd0b5d72283ac98c8ba7b'),
                                                                                                                                       (178,	0,	'',	1,	'rand_collapi',	0,	0,	25510,	'png',	'ca7573f86494c814e98f6a5bc9e7685b'),
                                                                                                                                       (179,	0,	'',	1,	'rand_collapi',	0,	0,	3720,	'png',	'ff2bbbd7952dacf257f6e41e896457d1'),
                                                                                                                                       (180,	0,	'',	1,	'rand_collapi',	0,	0,	82277,	'png',	'db319d6d48d299752efc0ebf056c508d'),
                                                                                                                                       (181,	0,	'',	1,	'rand',	0,	0,	6495,	'png',	'c3113e5e8d1091139590205b4bfb9781'),
                                                                                                                                       (182,	0,	'',	1,	'rand_collapi',	0,	0,	37522,	'png',	'5472f3298bb71ee706d6e336f33f98c9'),
                                                                                                                                       (183,	0,	'',	1,	'rand',	0,	0,	1538,	'png',	'b274fa2b351cf7dc3a896ae90a569bea'),
                                                                                                                                       (184,	0,	'',	1,	'rand_collapi',	0,	0,	59056,	'png',	'524b51b1566eb4d3e3178557ba1da627'),
                                                                                                                                       (185,	0,	'',	1,	'rand',	0,	0,	16045,	'png',	'21b843b958b23a946158cf89876dbd37'),
                                                                                                                                       (186,	0,	'',	1,	'rand_collapi',	0,	0,	70195,	'png',	'0d960d1009e868125a69467dee1d984c'),
                                                                                                                                       (187,	0,	'',	1,	'rand',	0,	0,	7489,	'png',	'74438f65ec26da7e68c81e0de30b4179'),
                                                                                                                                       (188,	0,	'',	1,	'rand_collapi',	0,	0,	64770,	'jpeg',	'76e36e859857512494a624aad809ae7b'),
                                                                                                                                       (189,	0,	'',	1,	'rand',	0,	0,	7419,	'png',	'005114a633d9204b3b5dea588e04fcd8'),
                                                                                                                                       (190,	0,	'',	1,	'rand_collapi',	0,	0,	45188,	'png',	'54f4b12c1fe0221ee00d6ea215afe763'),
                                                                                                                                       (191,	0,	'',	1,	'rand',	0,	0,	9740,	'png',	'5f7d57eac9ae18d41836a6e849c0b6a5'),
                                                                                                                                       (192,	0,	'',	1,	'rand_collapi',	0,	0,	45381,	'png',	'14d761af46f0136e3269a778052c2b46'),
                                                                                                                                       (193,	0,	'',	1,	'rand',	0,	0,	4683,	'png',	'8cccb22834f7ae186145e45416cc6d14'),
                                                                                                                                       (194,	0,	'',	1,	'rand',	0,	0,	65360,	'png',	'17599c9f35d1dc07c2da51b628d780ef'),
                                                                                                                                       (195,	0,	'',	1,	'rand_collapi',	0,	0,	49976,	'png',	'e7409134a984bd0d64747e518372cd38'),
                                                                                                                                       (196,	0,	'',	1,	'rand',	0,	0,	3358,	'png',	'865cd00827af95f9485b323f9701b352'),
                                                                                                                                       (197,	0,	'',	1,	'rand',	0,	0,	78458,	'png',	'7b6908c26de6403f6a207af21219779d'),
                                                                                                                                       (198,	0,	'',	1,	'rand_collapi',	0,	0,	52957,	'png',	'1ed8db184e7f89021b20f121300ce68f'),
                                                                                                                                       (199,	0,	'',	1,	'rand',	0,	0,	11177,	'png',	'324840b8226785720f70445cf9591acf'),
                                                                                                                                       (200,	0,	'',	1,	'rand_collapi',	0,	0,	13550,	'jpeg',	'4e69cbd54b9cc6b6de2352a340902971'),
                                                                                                                                       (201,	0,	'',	1,	'rand',	0,	0,	4637,	'png',	'4d69276dc3d5c0ba0962ac2ab5ff9e1c'),
                                                                                                                                       (202,	0,	'',	1,	'rand_collapi',	0,	0,	41789,	'png',	'3b961ceabc2a297c8e1a651311e83c36'),
                                                                                                                                       (203,	0,	'',	1,	'rand',	0,	0,	1823,	'png',	'0da584ebc2c69cf8db9c5b7ef94d8c49'),
                                                                                                                                       (204,	0,	'',	1,	'rand',	0,	0,	100356,	'png',	'f488de9d0e3514791e79656bbf2bf0ed'),
                                                                                                                                       (205,	0,	'',	1,	'rand_collapi',	0,	0,	44759,	'jpeg',	'e136f33819690b4106743396575ef02f'),
                                                                                                                                       (206,	0,	'',	1,	'rand',	0,	0,	3348,	'png',	'15d8087799f71e708dec15ec7d73f88c'),
                                                                                                                                       (207,	0,	'',	1,	'rand',	0,	0,	82402,	'png',	'301280f59d80b120e5cdc9965284a3da'),
                                                                                                                                       (208,	0,	'',	1,	'rand_collapi',	0,	0,	42917,	'png',	'8f664297495bfe9ea76d22eece47dc91'),
                                                                                                                                       (209,	0,	'',	1,	'rand_collapi',	0,	0,	9389,	'png',	'4cb2acaa0aa89c5cc5d0851119b83106'),
                                                                                                                                       (210,	0,	'',	1,	'rand_collapi',	0,	0,	29120,	'png',	'1988dc37fa8929380f4626d9eb9eb48f'),
                                                                                                                                       (211,	0,	'',	1,	'rand_collapi',	0,	0,	52482,	'png',	'ed6d626b4b27b34e05e6efbf7bb6517d'),
                                                                                                                                       (212,	0,	'',	1,	'rand',	0,	0,	10154,	'png',	'92e33b706b42017d9f61079267f85272'),
                                                                                                                                       (213,	0,	'',	1,	'rand',	0,	0,	55338,	'png',	'45b7ce8ec3987961102db34f550b48f1'),
                                                                                                                                       (214,	0,	'',	1,	'rand_collapi',	0,	0,	40919,	'png',	'286d82691353ee02db8d3e7eb530764f'),
                                                                                                                                       (215,	0,	'',	1,	'rand',	0,	0,	3602,	'png',	'a1cc935519712e6f94b7e23518d66d65'),
                                                                                                                                       (216,	0,	'',	1,	'rand_collapi',	0,	0,	10292,	'jpeg',	'03e92373de960a1146860dbda5b48c3c'),
                                                                                                                                       (217,	0,	'',	1,	'rand_collapi',	0,	0,	5006,	'png',	'b32c6d128bbecff4dd2625f4874b3dad'),
                                                                                                                                       (218,	0,	'',	1,	'rand_collapi',	0,	0,	83988,	'png',	'e01c4d34c9038f2db9f9e049c8924796'),
                                                                                                                                       (219,	0,	'',	1,	'rand_collapi',	0,	0,	48457,	'png',	'23accc30a4746e73205ac28c20470a12'),
                                                                                                                                       (220,	0,	'',	1,	'rand',	0,	0,	4484,	'png',	'b0721322f1f30b92639438dae6f1fdc0'),
                                                                                                                                       (221,	0,	'',	1,	'rand',	0,	0,	20135,	'jpeg',	'e1e91d185d5e654b2667774f43ae0f3e'),
                                                                                                                                       (222,	0,	'',	1,	'rand_collapi',	0,	0,	39337,	'png',	'0865a2aa1f72b9d6505b1bfc7da8f704'),
                                                                                                                                       (223,	0,	'',	1,	'rand',	0,	0,	3324,	'png',	'501b2ba1bd5d05dc4a6978b8b1c7a127'),
                                                                                                                                       (224,	0,	'',	1,	'rand_collapi',	0,	0,	22089,	'jpeg',	'a2a2f92b2a6e7baa4c44273bdcf54976'),
                                                                                                                                       (225,	0,	'',	1,	'rand_collapi',	0,	0,	5524,	'png',	'9e53aaced7927b3e96a4d0344aadc618'),
                                                                                                                                       (226,	0,	'',	1,	'rand_collapi',	0,	0,	51824,	'png',	'02d2da8784ffb9acbc646e9495b62125'),
                                                                                                                                       (227,	0,	'',	1,	'rand_collapi',	0,	0,	42848,	'png',	'45fe33f1d3e5a8f27578ab89055b2b54'),
                                                                                                                                       (228,	0,	'',	1,	'rand',	0,	0,	6901,	'png',	'78d93114eb92efc0636721b62c84c9d7'),
                                                                                                                                       (229,	0,	'',	1,	'rand',	0,	0,	59589,	'png',	'e48d036610e1a0fb4acd5a088b61dd93'),
                                                                                                                                       (230,	0,	'',	1,	'rand',	0,	0,	28411,	'png',	'9d688ab322b8e654ccaa975b00074ca7'),
                                                                                                                                       (231,	0,	'',	1,	'rand_collapi',	0,	0,	48977,	'png',	'fbc53c26d02441ec49d354837ab0b80f'),
                                                                                                                                       (232,	0,	'',	1,	'rand',	0,	0,	2227,	'png',	'9f2f9c356641126f540d8e7710c1efd6'),
                                                                                                                                       (233,	0,	'',	1,	'rand',	0,	0,	88312,	'png',	'55af0a6cfda614da83fd2aee4465569a'),
                                                                                                                                       (234,	0,	'',	1,	'rand_collapi',	0,	0,	32948,	'png',	'dae7b7a626a5288243bcec61bd8291a2'),
                                                                                                                                       (235,	0,	'',	1,	'rand',	0,	0,	4395,	'png',	'0c3f5678deda6689b837bc65a7f99f0c'),
                                                                                                                                       (236,	0,	'',	1,	'rand',	0,	0,	61835,	'png',	'9ac7308133538960cb02a61b9835c11f'),
                                                                                                                                       (237,	0,	'',	1,	'rand_collapi',	0,	0,	68479,	'png',	'f95bd9ff46f6440af3c37e4da7df426d'),
                                                                                                                                       (238,	0,	'',	1,	'rand',	0,	0,	7455,	'png',	'4ef4710488f8555badf3d2b0693c0450'),
                                                                                                                                       (239,	0,	'',	1,	'rand_collapi',	0,	0,	46247,	'png',	'adff2af2d5c30035e8544df1389c42af'),
                                                                                                                                       (240,	0,	'',	1,	'rand',	0,	0,	5802,	'png',	'51c78e324c12ec6ef1c6f14031fcaea2'),
                                                                                                                                       (241,	0,	'',	1,	'rand',	0,	0,	22741,	'png',	'99e670e2636d3ab4d7d466b7417755e9'),
                                                                                                                                       (242,	0,	'',	1,	'rand_collapi',	0,	0,	41129,	'jpeg',	'fbfd488aee67d8f62c555a9b6089c619'),
                                                                                                                                       (243,	0,	'',	1,	'rand',	0,	0,	4998,	'png',	'99c604f614f221580513f563691467a0'),
                                                                                                                                       (244,	0,	'',	1,	'rand',	0,	0,	39092,	'png',	'8a1f1f4679c48527562000279ebd810a'),
                                                                                                                                       (245,	0,	'',	1,	'rand',	0,	0,	34912,	'jpeg',	'33f4c8aad99ce73d7dc044e55011e4e6'),
                                                                                                                                       (246,	0,	'',	1,	'rand',	0,	0,	3184,	'png',	'0647c1fa4a4cc523778f439bea7f49a4'),
                                                                                                                                       (247,	0,	'',	1,	'rand',	0,	0,	50141,	'png',	'8b083305aaea0c26378f59411bbee214'),
                                                                                                                                       (248,	0,	'',	1,	'rand_collapi',	0,	0,	42962,	'jpeg',	'7ed8137869e11386b4a253cb056ce865'),
                                                                                                                                       (249,	0,	'',	1,	'rand',	0,	0,	4724,	'png',	'a4380668190ef5917e01a240fa59b77e'),
                                                                                                                                       (250,	0,	'',	1,	'rand_collapi',	0,	0,	33563,	'png',	'4a6db631b9d35135f9560ddef4be8885'),
                                                                                                                                       (251,	0,	'',	1,	'rand',	0,	0,	4233,	'png',	'52f88eca61191000804a44789e1a0349'),
                                                                                                                                       (252,	0,	'',	1,	'rand',	0,	0,	27693,	'jpeg',	'624e421ab42329968f64fb6f99f27787'),
                                                                                                                                       (253,	0,	'',	1,	'rand_collapi',	0,	0,	25552,	'png',	'73b4d04013a2cc17f6cfd49129062b4b'),
                                                                                                                                       (254,	0,	'',	1,	'rand',	0,	0,	10437,	'png',	'b119c77eb7bc7ec59ae0ed7735e4ef43'),
                                                                                                                                       (255,	0,	'',	1,	'rand',	0,	0,	39555,	'png',	'1cec4b69741bec95b712827880645c0e'),
                                                                                                                                       (256,	0,	'',	1,	'rand_collapi',	0,	0,	34133,	'png',	'4a3c82810a6507a10f90b347006280bc'),
                                                                                                                                       (257,	0,	'',	1,	'rand',	0,	0,	3800,	'png',	'93f57716d4484dadab2734507bd7f438'),
                                                                                                                                       (258,	0,	'',	1,	'rand',	0,	0,	83628,	'png',	'42aedea25d48c9bd747bb8d413b8674c'),
                                                                                                                                       (259,	0,	'',	1,	'rand',	0,	0,	48465,	'png',	'346b52f04116eba72d0964461db6400d'),
                                                                                                                                       (260,	0,	'',	1,	'rand_collapi',	0,	0,	37968,	'png',	'a2fcb89e87f01cbd6b7a3426f2df7cf8'),
                                                                                                                                       (261,	0,	'',	1,	'rand',	0,	0,	6306,	'png',	'c89e3a5d6673b1a34d621a07573e83a7'),
                                                                                                                                       (262,	0,	'',	1,	'rand',	0,	0,	74700,	'png',	'51bde152e6cd6e25bc2975714b6a3d45'),
                                                                                                                                       (263,	0,	'',	1,	'rand',	0,	0,	56683,	'png',	'd2730d370f2988acedf676851e11ae80'),
                                                                                                                                       (264,	0,	'',	1,	'rand',	0,	0,	73558,	'png',	'a6fbf8b8b6d7e75157a729fbc4e8c943'),
                                                                                                                                       (265,	0,	'',	1,	'rand',	0,	0,	8901,	'png',	'9632ba31790a4eab61ab504f7fde9fe4'),
                                                                                                                                       (266,	0,	'',	1,	'rand',	0,	0,	89272,	'png',	'ae7f6347a3bd031ec8b21cd1577b5e92'),
                                                                                                                                       (267,	0,	'',	1,	'rand',	0,	0,	14530,	'png',	'910e08053de4ada4703d18f193767c67'),
                                                                                                                                       (268,	0,	'',	1,	'rand',	0,	0,	4181,	'png',	'6fb30d6dcb9ab0d4b625c7bc0c8888a0'),
                                                                                                                                       (269,	0,	'',	1,	'rand',	0,	0,	46359,	'png',	'afb260ccfcbfffe1d4b89aadc95189db'),
                                                                                                                                       (270,	0,	'',	1,	'rand',	0,	0,	8902,	'png',	'223eae1e6fa46d93d7882b835afd6ff2'),
                                                                                                                                       (271,	0,	'',	1,	'rand',	0,	0,	51850,	'jpeg',	'0e41526c7f6fd58cac9ad19853600894'),
                                                                                                                                       (272,	0,	'',	1,	'rand',	0,	0,	6064,	'png',	'8fc4e699dce46c5d5b6251cdabb05407'),
                                                                                                                                       (273,	0,	'',	1,	'rand',	0,	0,	30798,	'jpeg',	'c92e0659b0a75b52800bfc17dc09678a'),
                                                                                                                                       (274,	0,	'',	1,	'rand',	0,	0,	7151,	'png',	'bc18d7d195a4dc16c38cae9246768719'),
                                                                                                                                       (275,	0,	'',	1,	'rand',	0,	0,	78569,	'jpeg',	'ec257f20330bdfe4b5c5f5626bf19c36'),
                                                                                                                                       (276,	0,	'',	1,	'rand',	0,	0,	2649,	'png',	'70cbbc8793e577ec6ee0ad96f9c5d07e'),
                                                                                                                                       (277,	0,	'',	1,	'rand',	0,	0,	26635,	'jpeg',	'986bd259a8492f47707b9058f9af8e1a'),
                                                                                                                                       (278,	0,	'',	1,	'rand',	0,	0,	5825,	'png',	'4cac9c487ddaec7abc4a16788024b4a8'),
                                                                                                                                       (279,	0,	'',	1,	'rand',	0,	0,	29006,	'jpeg',	'ea58f246056054f885d51f8aedefe17f'),
                                                                                                                                       (280,	0,	'',	1,	'rand',	0,	0,	9199,	'png',	'430ddbc2bad50d73ef1979cb3188b052'),
                                                                                                                                       (281,	0,	'',	1,	'rand',	0,	0,	5536,	'png',	'd18e15d7592b91e23c04f44ec6b1babd'),
                                                                                                                                       (282,	0,	'',	1,	'rand',	0,	0,	4471,	'png',	'56e09326826ade35311e48f60c4a91e9'),
                                                                                                                                       (283,	0,	'',	1,	'rand',	0,	0,	5551,	'png',	'78f2ed43fb1b0f87c203bd5d598b093a'),
                                                                                                                                       (284,	0,	'',	1,	'rand',	0,	0,	65638,	'png',	'9f9dd42007c4280fae79bb86fe5e565a'),
                                                                                                                                       (285,	0,	'',	1,	'rand',	0,	0,	2129,	'png',	'bd4e7245b8c04b12894e59024f4b6222'),
                                                                                                                                       (286,	0,	'',	1,	'rand',	0,	0,	26438,	'jpeg',	'a7bb7664ba302d048a7598c9d62fd52d'),
                                                                                                                                       (287,	0,	'',	1,	'rand',	0,	0,	2088,	'png',	'b85e9c0e2bc33c1f5981ec06ad4c21d7'),
                                                                                                                                       (288,	0,	'',	1,	'rand',	0,	0,	84731,	'png',	'71e99bbf3f3e9fdd391bb116829736c0'),
                                                                                                                                       (289,	0,	'',	1,	'rand',	0,	0,	4396,	'png',	'd6ea90203f7b59e2169e0a5791025717'),
                                                                                                                                       (290,	0,	'',	1,	'rand',	0,	0,	9153,	'png',	'302c8ce5dacf98e5a504dabe62dfc10f'),
                                                                                                                                       (291,	0,	'',	1,	'rand',	0,	0,	55806,	'png',	'54d4bc4415b70324d2a6df13eced6618'),
                                                                                                                                       (292,	0,	'',	1,	'rand',	0,	0,	3780,	'png',	'8d55703211b7654a6aca95c6437620e6'),
                                                                                                                                       (293,	0,	'',	1,	'rand',	0,	0,	4751,	'png',	'0b48d4e64a8ec1c08d0d8a8ffd002913'),
                                                                                                                                       (294,	0,	'',	1,	'rand',	0,	0,	3436,	'png',	'4f1489178c44fa4b394c3e005c8aa628'),
                                                                                                                                       (295,	0,	'',	1,	'rand',	0,	0,	3054,	'png',	'7ee216aa316c324f4f77bd724f327fa3'),
                                                                                                                                       (296,	0,	'',	1,	'rand',	0,	0,	70636,	'jpeg',	'40217b97734b7af67b86e5c8f19d7b98'),
                                                                                                                                       (297,	0,	'',	1,	'rand',	0,	0,	4518,	'png',	'79fe55c6c61f027255d1aa33ffe905c4'),
                                                                                                                                       (298,	0,	'',	1,	'rand',	0,	0,	10080,	'png',	'8829886ba9205eaa851604f03bcd37a8'),
                                                                                                                                       (299,	0,	'',	1,	'rand',	0,	0,	129878,	'png',	'd8c77b5746986adde3b42ca9cd9d2409'),
                                                                                                                                       (300,	0,	'',	1,	'rand',	0,	0,	3104,	'png',	'b43eecbfd1cb528214db06902bbb3fc2'),
                                                                                                                                       (301,	0,	'',	1,	'rand',	0,	0,	128056,	'png',	'aa244769c85f22d36dd4bd9a78b22038'),
                                                                                                                                       (302,	0,	'',	1,	'rand',	0,	0,	2884,	'png',	'96df6aa956ad3cbeca22e5ce154ec1fd'),
                                                                                                                                       (303,	0,	'',	1,	'rand',	0,	0,	39899,	'jpeg',	'6c8b3a18d3214ac00c23fd0de8a4bf5d'),
                                                                                                                                       (304,	0,	'',	1,	'rand',	0,	0,	5966,	'png',	'72d6e3dbb63e93e62f0b43fe2c2b0607'),
                                                                                                                                       (305,	0,	'',	1,	'rand_collapi',	0,	0,	4751,	'png',	'0b48d4e64a8ec1c08d0d8a8ffd002913'),
                                                                                                                                       (306,	0,	'',	1,	'rand',	0,	0,	57057,	'jpg',	'65af8240d4a4ebb3148e0157ec4727a2'),
                                                                                                                                       (307,	0,	'',	1,	'rand',	0,	0,	5141,	'png',	'9d8d66611f0360e1a49fd9da401eba2d'),
                                                                                                                                       (308,	0,	'',	1,	'rand',	0,	0,	2209,	'png',	'1d6ca81c81d4d2bf2399f5637defe880'),
                                                                                                                                       (309,	0,	'',	1,	'rand',	0,	0,	24841,	'jpeg',	'29fbaa41c2e36edb1f82ef83d14df4e4'),
                                                                                                                                       (310,	0,	'',	1,	'rand',	0,	0,	8387,	'png',	'9aadc2038324bb84871ace977bf405c7'),
                                                                                                                                       (311,	0,	'',	1,	'rand',	0,	0,	43903,	'jpeg',	'9c1c397dc1680d88492740b1d48ee3a6'),
                                                                                                                                       (312,	0,	'',	1,	'rand',	0,	0,	9322,	'png',	'7d017a3fc48cfc7b695695101b5fddc4'),
                                                                                                                                       (313,	0,	'',	1,	'rand_collapi',	0,	0,	43903,	'jpeg',	'9c1c397dc1680d88492740b1d48ee3a6'),
                                                                                                                                       (314,	0,	'',	1,	'rand',	0,	0,	8798,	'png',	'a6a9e5aaedbeb7033136b54cf56eca83'),
                                                                                                                                       (315,	0,	'',	1,	'rand',	0,	0,	3885,	'png',	'7aae7654d3666f6234b4c9e0f12753dd'),
                                                                                                                                       (316,	0,	'',	1,	'rand',	0,	0,	22346,	'jpeg',	'abf988e3391a047545daf712e5083c28'),
                                                                                                                                       (317,	0,	'',	1,	'rand',	0,	0,	7267,	'png',	'712ceb0bbdfed14c70e58070dc97be39'),
                                                                                                                                       (318,	0,	'',	1,	'rand',	0,	0,	3241,	'png',	'4b9084bf7f87fdafcbac7a5f70b8f270'),
                                                                                                                                       (319,	0,	'',	1,	'rand',	0,	0,	33639,	'jpg',	'24d5d572a89b21e35788cb180b7d1a0c'),
                                                                                                                                       (320,	0,	'',	1,	'rand',	0,	0,	5192,	'png',	'9cd80825d2f0c6d2b9a64d71b871bfd2'),
                                                                                                                                       (321,	0,	'',	1,	'rand',	0,	0,	20465,	'jpeg',	'942ea805cbe688ce47d40e27872a3c3e'),
                                                                                                                                       (322,	0,	'',	1,	'rand',	0,	0,	2688,	'png',	'ff6f82d164592443f044fd4d883bb38e'),
                                                                                                                                       (323,	0,	'',	1,	'rand',	0,	0,	41764,	'png',	'a8d435e80bdb3da6643ae56c678d23b1'),
                                                                                                                                       (324,	0,	'',	1,	'rand',	0,	0,	4057,	'png',	'a29ce9cd9a8b73ed2d8dcefae169933e'),
                                                                                                                                       (325,	0,	'',	1,	'rand',	0,	0,	78649,	'png',	'1c0c1c4196f6881b4eae5c69c8ae6529'),
                                                                                                                                       (326,	0,	'',	1,	'rand',	0,	0,	2491,	'png',	'bb0da2037aa9e524c24dd80d807b7720'),
                                                                                                                                       (327,	0,	'',	1,	'rand',	0,	0,	82025,	'png',	'a052c5ee535144491ac3dc57d53db897'),
                                                                                                                                       (328,	0,	'',	1,	'rand',	0,	0,	54756,	'png',	'35c34683c1162e200b7a42b867d8d8f2'),
                                                                                                                                       (329,	0,	'',	1,	'rand',	0,	0,	11684,	'png',	'9222ad91192050448777fd68a1fddf2a'),
                                                                                                                                       (330,	0,	'',	1,	'rand',	0,	0,	51216,	'png',	'94fa6ee7d20a85056943d0aa2e7a0540'),
                                                                                                                                       (331,	0,	'',	1,	'rand',	0,	0,	12550,	'png',	'53f2b8c87cdce3843338975313fa3464'),
                                                                                                                                       (332,	0,	'',	1,	'rand',	0,	0,	42437,	'png',	'923456339e585fbfe569ee40433bcee0'),
                                                                                                                                       (333,	0,	'',	1,	'rand',	0,	0,	3510,	'png',	'f160d075772762993163a63fbea39b41'),
                                                                                                                                       (334,	0,	'',	1,	'rand',	0,	0,	86651,	'png',	'86cc7b76e58e81fb1b245b4eedc40c27'),
                                                                                                                                       (335,	0,	'',	1,	'rand',	0,	0,	3116,	'png',	'b808d908405bfb4db6490a32a23583f9'),
                                                                                                                                       (336,	0,	'',	1,	'rand',	0,	0,	187313,	'png',	'03a32ffb38102ae9bc10f3d9610338f2'),
                                                                                                                                       (337,	0,	'',	1,	'rand',	0,	0,	8417,	'png',	'ad82737b422cbb2157819ce5ea5f4e5a'),
                                                                                                                                       (338,	0,	'',	1,	'rand',	0,	0,	37585,	'png',	'e42a86a3e223950222df24558858bae8'),
                                                                                                                                       (339,	0,	'',	1,	'rand',	0,	0,	5163,	'png',	'e1cdf5fb2e60128ab637a524af13fe0a'),
                                                                                                                                       (340,	0,	'',	1,	'rand',	0,	0,	33467,	'png',	'56e715de3d55785bea6872cdb339c70d'),
                                                                                                                                       (341,	0,	'',	1,	'rand',	0,	0,	4831,	'png',	'b34c6fb44d1ae3ba8561b21ab07f2a3b'),
                                                                                                                                       (342,	0,	'',	1,	'rand',	0,	0,	72276,	'png',	'540539e40bebf90cbee0200005eb0cea'),
                                                                                                                                       (343,	0,	'',	1,	'rand',	0,	0,	5670,	'png',	'ef3036359e08724946a584d795491541'),
                                                                                                                                       (344,	0,	'',	1,	'rand',	0,	0,	68025,	'jpeg',	'1c6dcb393752019e5f9b8f0644f8637a'),
                                                                                                                                       (345,	0,	'',	1,	'rand',	0,	0,	15736,	'png',	'483644dc293495a7138d651a68beafe1'),
                                                                                                                                       (346,	0,	'',	1,	'rand',	0,	0,	54342,	'png',	'107d1b2ecb557803350223790fcd0471'),
                                                                                                                                       (347,	0,	'',	1,	'rand',	0,	0,	5754,	'png',	'4d2c4c80c1c90e79ce16c939d783cb1b'),
                                                                                                                                       (348,	0,	'',	1,	'rand',	0,	0,	76976,	'png',	'5d1314dcb7e609b86e0f9be734286c89'),
                                                                                                                                       (349,	0,	'',	1,	'rand',	0,	0,	3832,	'png',	'4f15d6a86eafbecad158e37fd5190d45'),
                                                                                                                                       (350,	0,	'',	1,	'rand',	0,	0,	1873,	'png',	'ff27ee81f99b68c2b8808a778bfb2c0d'),
                                                                                                                                       (351,	0,	'',	1,	'rand',	0,	0,	23694,	'png',	'7f39a8664cc5e347007eebfa86b6c1d2'),
                                                                                                                                       (352,	0,	'',	1,	'rand',	0,	0,	1328,	'png',	'a32c22566c17f67be9d3381008970737'),
                                                                                                                                       (353,	0,	'',	1,	'rand',	0,	0,	2908,	'png',	'470434e4f168a75bc7a9762874078a97'),
                                                                                                                                       (354,	0,	'',	1,	'rand',	0,	0,	2460,	'png',	'4e0ceed8a5f58ab3b70225c0831db7b2'),
                                                                                                                                       (355,	0,	'',	1,	'rand',	0,	0,	60300,	'png',	'3759c1614a23a9cd271e47294728eb78'),
                                                                                                                                       (356,	0,	'',	1,	'rand',	0,	0,	11864,	'png',	'dca66b40de5afa8954f760e71687579d'),
                                                                                                                                       (357,	0,	'',	1,	'rand',	0,	0,	41395,	'png',	'e29b51cd74d6a32922885259728c7225'),
                                                                                                                                       (358,	0,	'',	1,	'rand',	0,	0,	11711,	'png',	'5335450a11a9c28efc0384464cae35b1'),
                                                                                                                                       (359,	0,	'',	1,	'rand',	0,	0,	3676,	'png',	'494e9b9622633927ca25afc485429a27'),
                                                                                                                                       (360,	0,	'',	1,	'rand_collapi',	0,	0,	5754,	'png',	'4d2c4c80c1c90e79ce16c939d783cb1b'),
                                                                                                                                       (361,	0,	'',	1,	'rand',	0,	0,	25667,	'jpeg',	'8dfc9be41107245bd89bf560e87830e1'),
                                                                                                                                       (362,	0,	'',	1,	'rand',	0,	0,	4939,	'png',	'57bd5747dc17848c5baec6aec4ab97f5'),
                                                                                                                                       (363,	0,	'',	1,	'rand',	0,	0,	131739,	'jpeg',	'2b70f922cb5fdef39f72bd58a7b539ce'),
                                                                                                                                       (364,	0,	'',	1,	'rand',	0,	0,	1779,	'png',	'92297ddce28f9c06dd6977bc2b305e84'),
                                                                                                                                       (365,	0,	'',	1,	'rand_collapi',	0,	0,	4939,	'png',	'57bd5747dc17848c5baec6aec4ab97f5'),
                                                                                                                                       (366,	0,	'',	1,	'rand',	0,	0,	38456,	'png',	'62aaabb5e9fe9941d99b0fec5192e95a'),
                                                                                                                                       (367,	0,	'',	1,	'rand',	0,	0,	7861,	'png',	'571bca5fd05ba34bfe203d32b018c872'),
                                                                                                                                       (368,	0,	'',	1,	'rand',	0,	0,	31176,	'webp',	'750cc99f36d388960e148a1378251a44'),
                                                                                                                                       (369,	0,	'',	1,	'rand',	0,	0,	27013,	'jpeg',	'e4f847237aa48a10a0b7653e3e22cfb4'),
                                                                                                                                       (370,	0,	'',	1,	'rand',	0,	0,	3214,	'png',	'3130a55b22b97dd8406ad4676f7c87d2'),
                                                                                                                                       (371,	0,	'',	1,	'rand',	0,	0,	31641,	'jpeg',	'ec62ab1b6257178a08c48383102d7827'),
                                                                                                                                       (372,	0,	'',	1,	'rand',	0,	0,	5762,	'png',	'01894a637714b0cdbc8d1a725de3b611'),
                                                                                                                                       (373,	0,	'',	1,	'rand',	0,	0,	18093,	'jpeg',	'f4af0c5c2c23c583e92cce7aca146a69'),
                                                                                                                                       (374,	0,	'',	1,	'rand',	0,	0,	11099,	'png',	'f418435aa7fb33a39945f7eab26b6eca'),
                                                                                                                                       (375,	0,	'',	1,	'rand',	0,	0,	3706,	'png',	'53c50cc7def036b8282d77b384d05b0b'),
                                                                                                                                       (376,	0,	'',	1,	'rand',	0,	0,	56510,	'png',	'41ae5627085c2513975ec232138c6d13'),
                                                                                                                                       (377,	0,	'',	1,	'rand',	0,	0,	12225,	'png',	'7cadaeffea11a6d43a4d19ebb5f69f0f'),
                                                                                                                                       (378,	0,	'',	1,	'rand',	0,	0,	82148,	'png',	'b228a2c7b51bc597c0f92c0c92a9e61a'),
                                                                                                                                       (379,	0,	'',	1,	'rand',	0,	0,	2873,	'png',	'5a051d053238c436c5130949fe6e0d09'),
                                                                                                                                       (380,	0,	'',	1,	'rand_collapi',	0,	0,	2884,	'png',	'96df6aa956ad3cbeca22e5ce154ec1fd'),
                                                                                                                                       (381,	0,	'',	1,	'rand',	0,	0,	4780,	'png',	'21ae8a4fb958160c5184ee780e13fd14'),
                                                                                                                                       (382,	0,	'',	1,	'rand',	0,	0,	115477,	'jpg',	'64d4792856eae73f000e59323b4cadd0'),
                                                                                                                                       (383,	0,	'',	1,	'rand',	0,	0,	4134,	'png',	'11a75465dacd454f9b1e0c3dd013dc5b'),
                                                                                                                                       (384,	0,	'',	1,	'rand',	0,	0,	57065,	'png',	'66f1d6a91075231d8661fc05b6f11c10'),
                                                                                                                                       (385,	0,	'',	1,	'rand',	0,	0,	3488,	'png',	'96496b0d7262eafaee4d626386bb4ce2'),
                                                                                                                                       (386,	0,	'',	1,	'rand_collapi',	0,	0,	4751,	'png',	'0b48d4e64a8ec1c08d0d8a8ffd002913'),
                                                                                                                                       (387,	0,	'',	1,	'rand',	0,	0,	7181,	'png',	'1688f06a6f6d8f39cc993260d857adc8'),
                                                                                                                                       (388,	0,	'',	1,	'rand',	0,	0,	13416,	'png',	'928e1802417fc3205720d2df51f97dd6'),
                                                                                                                                       (389,	0,	'',	1,	'rand',	0,	0,	50937,	'png',	'dc8b04c006fd66b29993fc9ae04581e6'),
                                                                                                                                       (390,	0,	'',	1,	'rand',	0,	0,	3764,	'png',	'55f8c487090de85e324d254f32e71442'),
                                                                                                                                       (391,	0,	'',	1,	'rand',	0,	0,	39642,	'png',	'997a52649b7aafb93624d779fd72d68c'),
                                                                                                                                       (392,	0,	'',	1,	'rand',	0,	0,	7853,	'png',	'21a3673a708debed976390439916ae8a'),
                                                                                                                                       (393,	0,	'',	1,	'rand',	0,	0,	63415,	'jpeg',	'6b5217de34e9e62705c9d6eb42bf13b9'),
                                                                                                                                       (394,	0,	'',	1,	'rand',	0,	0,	4383,	'png',	'07343e98a5f23caaed642f5ae9938944'),
                                                                                                                                       (395,	0,	'',	1,	'rand',	0,	0,	61554,	'png',	'889b654016887df4407c52638bf02972'),
                                                                                                                                       (396,	0,	'',	1,	'rand',	0,	0,	94993,	'png',	'9eeef75dfc47ec33d575d06e6e5ed9fc'),
                                                                                                                                       (397,	0,	'',	1,	'rand',	0,	0,	12559,	'png',	'699f1719680f12f7522e675431a89a02'),
                                                                                                                                       (398,	0,	'',	1,	'rand',	0,	0,	112834,	'jpeg',	'eab18430148e3a9ed57c158f81e5c37c'),
                                                                                                                                       (399,	0,	'',	1,	'rand',	0,	0,	10047,	'png',	'61da0d7f5b1bef90a02be0e846a44ae6'),
                                                                                                                                       (400,	0,	'',	1,	'rand',	0,	0,	25899,	'jpeg',	'93ff4c4b8d9e8866c0e9db0c5e8672cb'),
                                                                                                                                       (401,	0,	'',	1,	'rand',	0,	0,	4541,	'png',	'bf2ade61a9121b46584c9f8623e7e9cb'),
                                                                                                                                       (402,	0,	'',	1,	'rand',	0,	0,	207375,	'png',	'3e8b5458dca9a30c995b9ee9009887fa'),
                                                                                                                                       (403,	0,	'',	1,	'rand',	0,	0,	4720,	'png',	'48804362fad49bc4c5b3f564fc1b7694'),
                                                                                                                                       (404,	0,	'',	1,	'rand',	0,	0,	34375,	'jpeg',	'388e78a83c4c9be076416709fd0182f1'),
                                                                                                                                       (405,	0,	'',	1,	'rand',	0,	0,	5257,	'png',	'c5f45c4ebcc88beff7f135cb00def411'),
                                                                                                                                       (406,	0,	'',	1,	'rand',	0,	0,	110137,	'png',	'c8b959669b4cb20c71d57fcf7378b9f7'),
                                                                                                                                       (407,	0,	'',	1,	'rand',	0,	0,	73687,	'png',	'd0d0baa1eeb413535fa4163e990a39f5'),
                                                                                                                                       (408,	0,	'',	1,	'rand',	0,	0,	5249,	'png',	'a4068e9bb64ba7a30bc248f4b8096ed9'),
                                                                                                                                       (409,	0,	'',	1,	'rand',	0,	0,	76011,	'jpeg',	'aa4a30c153322a76ed977507c49862c6'),
                                                                                                                                       (410,	0,	'',	1,	'rand',	0,	0,	5061,	'png',	'b1c6b92174b6474bf82243490f1ec20f'),
                                                                                                                                       (411,	0,	'',	1,	'rand',	0,	0,	18326,	'png',	'd1c883116e2635b6c9cd3ae59666a39b'),
                                                                                                                                       (412,	0,	'',	1,	'rand',	0,	0,	5526,	'png',	'e09bc6d3575b0e8fd8fb079efac2c970'),
                                                                                                                                       (413,	0,	'',	1,	'rand',	0,	0,	4307,	'png',	'f6cf8ba0316e00b78796121d8f0a7ff8'),
                                                                                                                                       (414,	0,	'',	1,	'rand',	0,	0,	8056,	'png',	'ffb9d64de6a8ae2b92ec31dec1079135'),
                                                                                                                                       (415,	0,	'',	1,	'rand',	0,	0,	10630,	'png',	'c0bebb1e42d48b977fa8c43e8c50f04d'),
                                                                                                                                       (416,	0,	'',	1,	'rand',	0,	0,	5247,	'png',	'ec8994030159e2bf5af105ecfc79c155'),
                                                                                                                                       (417,	0,	'',	1,	'rand',	0,	0,	6127,	'png',	'4557cebfcba15ac31300b23b39fdd12c'),
                                                                                                                                       (418,	0,	'',	1,	'rand',	0,	0,	92884,	'png',	'386036532514f8d9ea5427e656343fb7'),
                                                                                                                                       (419,	0,	'',	1,	'rand',	0,	0,	8212,	'png',	'f64cd666d4434acf3e8d46eed4ed4b83'),
                                                                                                                                       (420,	0,	'',	1,	'rand',	0,	0,	4592,	'png',	'eaa6e1a300c47cb7c11d0d2c32835e80'),
                                                                                                                                       (421,	0,	'',	1,	'rand',	0,	0,	53189,	'png',	'fd7b9945ae9748e4b6f5966455f71062'),
                                                                                                                                       (422,	0,	'',	1,	'rand',	0,	0,	1880,	'png',	'73824ffac8cd83aa57c586bc086dbf32'),
                                                                                                                                       (423,	0,	'',	1,	'rand',	0,	0,	51932,	'jpeg',	'2b8c4d8d31d61bbbf378f5c0050c5c20'),
                                                                                                                                       (424,	0,	'',	1,	'rand',	0,	0,	6170,	'png',	'b81f88487682ff236e768548525e1b91'),
                                                                                                                                       (425,	0,	'',	1,	'rand',	0,	0,	5360,	'png',	'5328cbb00739474e48eb8e5b63ccc303'),
                                                                                                                                       (426,	0,	'',	1,	'rand',	0,	0,	54348,	'jpeg',	'725fee97b8f9742369b2d690dbf3a700'),
                                                                                                                                       (427,	0,	'',	1,	'rand',	0,	0,	3437,	'png',	'9faba4727053f89338a4533224bfd0bc'),
                                                                                                                                       (428,	0,	'',	1,	'rand',	0,	0,	3054,	'png',	'9b95c8fa9b2aba22c2595ac87715de63'),
                                                                                                                                       (429,	0,	'',	1,	'rand',	0,	0,	18233,	'png',	'ddbca1c381adce4dafe1270f9ca41564'),
                                                                                                                                       (430,	0,	'',	1,	'rand',	0,	0,	31102,	'jpeg',	'6132e724458531e9355fbe0bff66d959'),
                                                                                                                                       (431,	0,	'',	1,	'rand',	0,	0,	4304,	'png',	'd206c3d5fb85be407de05b1bcea3abe3'),
                                                                                                                                       (432,	0,	'',	1,	'rand',	0,	0,	3216,	'png',	'5e952deee50e7458a2eb6af5f36101d3'),
                                                                                                                                       (433,	0,	'',	1,	'rand',	0,	0,	76993,	'png',	'108cc2c7d8d78acb8e435f01d6fb21d0'),
                                                                                                                                       (434,	0,	'',	1,	'rand',	0,	0,	2092,	'png',	'a8b8ef0769b5c04085de4ff7f69a2e82'),
                                                                                                                                       (435,	0,	'',	1,	'rand',	0,	0,	63122,	'png',	'0f1579ca4cb939caf0e39f08de452218'),
                                                                                                                                       (436,	0,	'',	1,	'rand',	0,	0,	9685,	'png',	'bda700855f1db015bd7f20f61c9b8e6f'),
                                                                                                                                       (437,	0,	'',	1,	'rand',	0,	0,	8614,	'png',	'ab3eacc300a63297f6d83c3a42029356'),
                                                                                                                                       (438,	0,	'',	1,	'rand',	0,	0,	6908,	'png',	'242f4653583c795a5df39c65a62669ee'),
                                                                                                                                       (439,	0,	'',	1,	'rand',	0,	0,	7494,	'png',	'064f0ecab824fc5ab6289362038ccc58'),
                                                                                                                                       (440,	0,	'',	1,	'rand_collapi',	0,	0,	3452,	'png',	'1c9ab084bce46e8feaeff2367adeab4a'),
                                                                                                                                       (441,	0,	'',	1,	'rand',	0,	0,	3804,	'png',	'7c8ac6368f5538df18a2e35048e249fc'),
                                                                                                                                       (442,	0,	'',	1,	'rand',	0,	0,	9538,	'png',	'd37d09cdb1daf9a2bf6701fad2d164aa'),
                                                                                                                                       (443,	0,	'',	1,	'rand',	0,	0,	8826,	'png',	'308f97e68908cf394bd20d91125d5ac8'),
                                                                                                                                       (444,	0,	'',	1,	'rand',	0,	0,	4923,	'png',	'db57ed28f2c3c1b29670f8a8bec7eae0'),
                                                                                                                                       (445,	0,	'',	1,	'rand',	0,	0,	33027,	'jpeg',	'c7ae32bed7f54868419b24baa087cd3d'),
                                                                                                                                       (446,	0,	'',	1,	'rand_collapi',	0,	0,	7247,	'png',	'8ff92182bcecd707dc4d6816366422fe'),
                                                                                                                                       (447,	0,	'',	1,	'rand',	0,	0,	17977,	'jpeg',	'dd228e71a617a707b64c937daf4d5147'),
                                                                                                                                       (448,	0,	'',	1,	'rand',	0,	0,	6620,	'png',	'12eb11b8b51b9d5a5754b23eb7bcfa6f'),
                                                                                                                                       (449,	0,	'',	1,	'rand',	0,	0,	32455,	'png',	'79beab90fabe5eec14308c36b4f17536'),
                                                                                                                                       (450,	0,	'',	1,	'rand',	0,	0,	21349,	'jpeg',	'1f95dec249f40e830db89415880c4008'),
                                                                                                                                       (451,	0,	'',	1,	'rand',	0,	0,	11415,