/*!
 * Vditor v3.8.5 - A markdown editor written in TypeScript.
 *
 * MIT License
 *
 * Copyright (c) 2018-present B3log 开源, b3log.org
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */
!function(e,t){"object"==typeof exports&&"object"==typeof module?module.exports=t():"function"==typeof define&&define.amd?define([],t):"object"==typeof exports?exports.Vditor=t():e.Vditor=t()}(this,function(){return(()=>{var n={694:e=>{function T(){this.Diff_Timeout=1,this.Diff_EditCost=4,this.Match_Threshold=.5,this.Match_Distance=1e3,this.Patch_DeleteThreshold=.5,this.Patch_Margin=4,this.Match_MaxBits=32}var M=-1;T.Diff=function(e,t){return[e,t]},T.prototype.diff_main=function(e,t,n,r){var i=r=void 0===r?this.Diff_Timeout<=0?Number.MAX_VALUE:(new Date).getTime()+1e3*this.Diff_Timeout:r;if(null==e||null==t)throw new Error("Null input. (diff_main)");if(e==t)return e?[new T.Diff(0,e)]:[];var o=n=void 0===n?!0:n,a=this.diff_commonPrefix(e,t),r=e.substring(0,a);e=e.substring(a),t=t.substring(a);a=this.diff_commonSuffix(e,t),n=e.substring(e.length-a);e=e.substring(0,e.length-a),t=t.substring(0,t.length-a);i=this.diff_compute_(e,t,o,i);return r&&i.unshift(new T.Diff(0,r)),n&&i.push(new T.Diff(0,n)),this.diff_cleanupMerge(i),i},T.prototype.diff_compute_=function(e,t,n,r){if(!e)return[new T.Diff(1,t)];if(!t)return[new T.Diff(M,e)];var i=e.length>t.length?e:t,o=e.length>t.length?t:e,a=i.indexOf(o);if(-1!=a)return s=[new T.Diff(1,i.substring(0,a)),new T.Diff(0,o),new T.Diff(1,i.substring(a+o.length))],e.length>t.length&&(s[0][0]=s[2][0]=M),s;if(1==o.length)return[new T.Diff(M,e),new T.Diff(1,t)];var l=this.diff_halfMatch_(e,t);if(l){var i=l[0],a=l[1],s=l[2],o=l[3],l=l[4],s=this.diff_main(i,s,n,r),o=this.diff_main(a,o,n,r);return s.concat([new T.Diff(0,l)],o)}return n&&100<e.length&&100<t.length?this.diff_lineMode_(e,t,r):this.diff_bisect_(e,t,r)},T.prototype.diff_lineMode_=function(e,t,n){var r=this.diff_linesToChars_(e,t);e=r.chars1,t=r.chars2;var r=r.lineArray,i=this.diff_main(e,t,!1,n);this.diff_charsToLines_(i,r),this.diff_cleanupSemantic(i),i.push(new T.Diff(0,""));for(var o=0,a=0,l=0,s="",d="";o<i.length;){switch(i[o][0]){case 1:l++,d+=i[o][1];break;case M:a++,s+=i[o][1];break;case 0:if(1<=a&&1<=l){i.splice(o-a-l,a+l);for(var o=o-a-l,c=this.diff_main(s,d,!1,n),u=c.length-1;0<=u;u--)i.splice(o,0,c[u]);o+=c.length}a=l=0,d=s=""}o++}return i.pop(),i},T.prototype.diff_bisect_=function(e,t,n){for(var r=e.length,i=t.length,o=Math.ceil((r+i)/2),a=o,l=2*o,s=new Array(l),d=new Array(l),c=0;c<l;c++)s[c]=-1,d[c]=-1;s[a+1]=0;for(var u=r-i,p=u%2!=(d[a+1]=0),m=0,f=0,h=0,v=0,g=0;g<o&&!((new Date).getTime()>n);g++){for(var y=-g+m;y<=g-f;y+=2){for(var b=a+y,w=(L=y==-g||y!=g&&s[b-1]<s[b+1]?s[b+1]:s[b-1]+1)-y;L<r&&w<i&&e.charAt(L)==t.charAt(w);)L++,w++;if(r<(s[b]=L))f+=2;else if(i<w)m+=2;else if(p){var E=a+u-y;if(0<=E&&E<l&&-1!=d[E])if((S=r-d[E])<=L)return this.diff_bisectSplit_(e,t,L,w,n)}}for(var k=-g+h;k<=g-v;k+=2){for(var S,E=a+k,C=(S=k==-g||k!=g&&d[E-1]<d[E+1]?d[E+1]:d[E-1]+1)-k;S<r&&C<i&&e.charAt(r-S-1)==t.charAt(i-C-1);)S++,C++;if(r<(d[E]=S))v+=2;else if(i<C)h+=2;else if(!p)if(0<=(b=a+u-k)&&b<l&&-1!=s[b]){var L,w=a+(L=s[b])-b;if((S=r-S)<=L)return this.diff_bisectSplit_(e,t,L,w,n)}}}return[new T.Diff(M,e),new T.Diff(1,t)]},T.prototype.diff_bisectSplit_=function(e,t,n,r,i){var o=e.substring(0,n),a=t.substring(0,r),n=e.substring(n),r=t.substring(r),a=this.diff_main(o,a,!1,i),i=this.diff_main(n,r,!1,i);return a.concat(i)},T.prototype.diff_linesToChars_=function(e,t){var a=[],l={};function n(e){for(var t="",n=0,r=-1,i=a.length;r<e.length-1;){-1==(r=e.indexOf("\n",n))&&(r=e.length-1);var o=e.substring(n,r+1);(l.hasOwnProperty?l.hasOwnProperty(o):void 0!==l[o])?t+=String.fromCharCode(l[o]):(i==s&&(o=e.substring(n),r=e.length),t+=String.fromCharCode(i),l[o]=i,a[i++]=o),n=r+1}return t}a[0]="";var s=4e4,e=n(e),s=65535;return{chars1:e,chars2:n(t),lineArray:a}},T.prototype.diff_charsToLines_=function(e,t){for(var n=0;n<e.length;n++){for(var r=e[n][1],i=[],o=0;o<r.length;o++)i[o]=t[r.charCodeAt(o)];e[n][1]=i.join("")}},T.prototype.diff_commonPrefix=function(e,t){if(!e||!t||e.charAt(0)!=t.charAt(0))return 0;for(var n=0,r=Math.min(e.length,t.length),i=r,o=0;n<i;)e.substring(o,i)==t.substring(o,i)?o=n=i:r=i,i=Math.floor((r-n)/2+n);return i},T.prototype.diff_commonSuffix=function(e,t){if(!e||!t||e.charAt(e.length-1)!=t.charAt(t.length-1))return 0;for(var n=0,r=Math.min(e.length,t.length),i=r,o=0;n<i;)e.substring(e.length-i,e.length-o)==t.substring(t.length-i,t.length-o)?o=n=i:r=i,i=Math.floor((r-n)/2+n);return i},T.prototype.diff_commonOverlap_=function(e,t){var n=e.length,r=t.length;if(0==n||0==r)return 0;r<n?e=e.substring(n-r):n<r&&(t=t.substring(0,n));var i=Math.min(n,r);if(e==t)return i;for(var o=0,a=1;;){var l=e.substring(i-a),l=t.indexOf(l);if(-1==l)return o;a+=l,0!=l&&e.substring(i-a)!=t.substring(0,a)||(o=a,a++)}},T.prototype.diff_halfMatch_=function(e,t){if(this.Diff_Timeout<=0)return null;var n=e.length>t.length?e:t,r=e.length>t.length?t:e;if(n.length<4||2*r.length<n.length)return null;var p=this;function i(e,t,n){for(var r,i,o,a,l=e.substring(n,n+Math.floor(e.length/4)),s=-1,d="";-1!=(s=t.indexOf(l,s+1));){var c=p.diff_commonPrefix(e.substring(n),t.substring(s)),u=p.diff_commonSuffix(e.substring(0,n),t.substring(0,s));d.length<u+c&&(d=t.substring(s-u,s)+t.substring(s,s+c),r=e.substring(0,n-u),i=e.substring(n+c),o=t.substring(0,s-u),a=t.substring(s+c))}return 2*d.length>=e.length?[r,i,o,a,d]:null}var o,a,l,s,d=i(n,r,Math.ceil(n.length/4)),n=i(n,r,Math.ceil(n.length/2));return d||n?(n=!n||d&&d[4].length>n[4].length?d:n,e.length>t.length?(o=n[0],a=n[1],l=n[2],s=n[3]):(l=n[0],s=n[1],o=n[2],a=n[3]),[o,a,l,s,n[4]]):null},T.prototype.diff_cleanupSemantic=function(e){for(var t,n,r,i,o=!1,a=[],l=0,s=null,d=0,c=0,u=0,p=0,m=0;d<e.length;)0==e[d][0]?(c=p,u=m,m=p=0,s=e[a[l++]=d][1]):(1==e[d][0]?p+=e[d][1].length:m+=e[d][1].length,s&&s.length<=Math.max(c,u)&&s.length<=Math.max(p,m)&&(e.splice(a[l-1],0,new T.Diff(M,s)),e[a[l-1]+1][0]=1,l--,d=0<--l?a[l-1]:-1,m=p=u=c=0,o=!(s=null))),d++;for(o&&this.diff_cleanupMerge(e),this.diff_cleanupSemanticLossless(e),d=1;d<e.length;)e[d-1][0]==M&&1==e[d][0]&&(t=e[d-1][1],n=e[d][1],r=this.diff_commonOverlap_(t,n),(i=this.diff_commonOverlap_(n,t))<=r?(r>=t.length/2||r>=n.length/2)&&(e.splice(d,0,new T.Diff(0,n.substring(0,r))),e[d-1][1]=t.substring(0,t.length-r),e[d+1][1]=n.substring(r),d++):(i>=t.length/2||i>=n.length/2)&&(e.splice(d,0,new T.Diff(0,t.substring(0,i))),e[d-1][0]=1,e[d-1][1]=n.substring(0,n.length-i),e[d+1][0]=M,e[d+1][1]=t.substring(i),d++),d++),d++},T.prototype.diff_cleanupSemanticLossless=function(e){function t(e,t){if(!e||!t)return 6;var n=e.charAt(e.length-1),r=t.charAt(0),i=n.match(T.nonAlphaNumericRegex_),o=r.match(T.nonAlphaNumericRegex_),a=i&&n.match(T.whitespaceRegex_),l=o&&r.match(T.whitespaceRegex_),n=a&&n.match(T.linebreakRegex_),r=l&&r.match(T.linebreakRegex_),e=n&&e.match(T.blanklineEndRegex_),t=r&&t.match(T.blanklineStartRegex_);return e||t?5:n||r?4:i&&!a&&l?3:a||l?2:i||o?1:0}for(var n=1;n<e.length-1;){if(0==e[n-1][0]&&0==e[n+1][0]){var r,i=e[n-1][1],o=e[n][1],a=e[n+1][1],l=this.diff_commonSuffix(i,o);l&&(r=o.substring(o.length-l),i=i.substring(0,i.length-l),o=r+o.substring(0,o.length-l),a=r+a);for(var s=i,d=o,c=a,u=t(i,o)+t(o,a);o.charAt(0)===a.charAt(0);){i+=o.charAt(0),o=o.substring(1)+a.charAt(0),a=a.substring(1);var p=t(i,o)+t(o,a);u<=p&&(u=p,s=i,d=o,c=a)}e[n-1][1]!=s&&(s?e[n-1][1]=s:(e.splice(n-1,1),n--),e[n][1]=d,c?e[n+1][1]=c:(e.splice(n+1,1),n--))}n++}},T.nonAlphaNumericRegex_=/[^a-zA-Z0-9]/,T.whitespaceRegex_=/\s/,T.linebreakRegex_=/[\r\n]/,T.blanklineEndRegex_=/\n\r?\n$/,T.blanklineStartRegex_=/^\r?\n\r?\n/,T.prototype.diff_cleanupEfficiency=function(e){for(var t=!1,n=[],r=0,i=null,o=0,a=!1,l=!1,s=!1,d=!1;o<e.length;)0==e[o][0]?(i=e[o][1].length<this.Diff_EditCost&&(s||d)?(a=s,l=d,e[n[r++]=o][1]):(r=0,null),s=d=!1):(e[o][0]==M?d=!0:s=!0,i&&(a&&l&&s&&d||i.length<this.Diff_EditCost/2&&a+l+s+d==3)&&(e.splice(n[r-1],0,new T.Diff(M,i)),e[n[r-1]+1][0]=1,r--,a&&l?(s=d=!0,r=0):(o=0<--r?n[r-1]:-1,s=d=!1),t=!(i=null))),o++;t&&this.diff_cleanupMerge(e)},T.prototype.diff_cleanupMerge=function(e){e.push(new T.Diff(0,""));for(var t,n=0,r=0,i=0,o="",a="";n<e.length;)switch(e[n][0]){case 1:i++,a+=e[n][1],n++;break;case M:r++,o+=e[n][1],n++;break;case 0:1<r+i?(0!==r&&0!==i&&(0!==(t=this.diff_commonPrefix(a,o))&&(0<n-r-i&&0==e[n-r-i-1][0]?e[n-r-i-1][1]+=a.substring(0,t):(e.splice(0,0,new T.Diff(0,a.substring(0,t))),n++),a=a.substring(t),o=o.substring(t)),0!==(t=this.diff_commonSuffix(a,o))&&(e[n][1]=a.substring(a.length-t)+e[n][1],a=a.substring(0,a.length-t),o=o.substring(0,o.length-t))),n-=r+i,e.splice(n,r+i),o.length&&(e.splice(n,0,new T.Diff(M,o)),n++),a.length&&(e.splice(n,0,new T.Diff(1,a)),n++),n++):0!==n&&0==e[n-1][0]?(e[n-1][1]+=e[n][1],e.splice(n,1)):n++,r=i=0,a=o=""}""===e[e.length-1][1]&&e.pop();for(var l=!1,n=1;n<e.length-1;)0==e[n-1][0]&&0==e[n+1][0]&&(e[n][1].substring(e[n][1].length-e[n-1][1].length)==e[n-1][1]?(e[n][1]=e[n-1][1]+e[n][1].substring(0,e[n][1].length-e[n-1][1].length),e[n+1][1]=e[n-1][1]+e[n+1][1],e.splice(n-1,1),l=!0):e[n][1].substring(0,e[n+1][1].length)==e[n+1][1]&&(e[n-1][1]+=e[n+1][1],e[n][1]=e[n][1].substring(e[n+1][1].length)+e[n+1][1],e.splice(n+1,1),l=!0)),n++;l&&this.diff_cleanupMerge(e)},T.prototype.diff_xIndex=function(e,t){for(var n=0,r=0,i=0,o=0,a=0;a<e.length&&(1!==e[a][0]&&(n+=e[a][1].length),e[a][0]!==M&&(r+=e[a][1].length),!(t<n));a++)i=n,o=r;return e.length!=a&&e[a][0]===M?o:o+(t-i)},T.prototype.diff_prettyHtml=function(e){for(var t=[],n=/&/g,r=/</g,i=/>/g,o=/\n/g,a=0;a<e.length;a++){var l=e[a][0],s=e[a][1].replace(n,"&amp;").replace(r,"&lt;").replace(i,"&gt;").replace(o,"&para;<br>");switch(l){case 1:t[a]='<ins style="background:#e6ffe6;">'+s+"</ins>";break;case M:t[a]='<del style="background:#ffe6e6;">'+s+"</del>";break;case 0:t[a]="<span>"+s+"</span>"}}return t.join("")},T.prototype.diff_text1=function(e){for(var t=[],n=0;n<e.length;n++)1!==e[n][0]&&(t[n]=e[n][1]);return t.join("")},T.prototype.diff_text2=function(e){for(var t=[],n=0;n<e.length;n++)e[n][0]!==M&&(t[n]=e[n][1]);return t.join("")},T.prototype.diff_levenshtein=function(e){for(var t=0,n=0,r=0,i=0;i<e.length;i++){var o=e[i][0],a=e[i][1];switch(o){case 1:n+=a.length;break;case M:r+=a.length;break;case 0:t+=Math.max(n,r),r=n=0}}return t+=Math.max(n,r)},T.prototype.diff_toDelta=function(e){for(var t=[],n=0;n<e.length;n++)switch(e[n][0]){case 1:t[n]="+"+encodeURI(e[n][1]);break;case M:t[n]="-"+e[n][1].length;break;case 0:t[n]="="+e[n][1].length}return t.join("\t").replace(/%20/g," ")},T.prototype.diff_fromDelta=function(e,t){for(var n=[],r=0,i=0,o=t.split(/\t/g),a=0;a<o.length;a++){var l=o[a].substring(1);switch(o[a].charAt(0)){case"+":try{n[r++]=new T.Diff(1,decodeURI(l))}catch(e){throw new Error("Illegal escape in diff_fromDelta: "+l)}break;case"-":case"=":var s=parseInt(l,10);if(isNaN(s)||s<0)throw new Error("Invalid number in diff_fromDelta: "+l);s=e.substring(i,i+=s);"="==o[a].charAt(0)?n[r++]=new T.Diff(0,s):n[r++]=new T.Diff(M,s);break;default:if(o[a])throw new Error("Invalid diff operation in diff_fromDelta: "+o[a])}}if(i!=e.length)throw new Error("Delta length ("+i+") does not equal source text length ("+e.length+").");return n},T.prototype.match_main=function(e,t,n){if(null==e||null==t||null==n)throw new Error("Null input. (match_main)");return n=Math.max(0,Math.min(n,e.length)),e==t?0:e.length?e.substring(n,n+t.length)==t?n:this.match_bitap_(e,t,n):-1},T.prototype.match_bitap_=function(e,n,r){if(n.length>this.Match_MaxBits)throw new Error("Pattern too long for this browser.");var t=this.match_alphabet_(n),i=this;function o(e,t){e/=n.length,t=Math.abs(r-t);return i.Match_Distance?e+t/i.Match_Distance:t?1:e}var a=this.Match_Threshold;-1!=(u=e.indexOf(n,r))&&(a=Math.min(o(0,u),a),-1!=(u=e.lastIndexOf(n,r+n.length))&&(a=Math.min(o(0,u),a)));for(var l,s,d,c=1<<n.length-1,u=-1,p=n.length+e.length,m=0;m<n.length;m++){for(l=0,s=p;l<s;)o(m,r+s)<=a?l=s:p=s,s=Math.floor((p-l)/2+l);var p=s,f=Math.max(1,r-s+1),h=Math.min(r+s,e.length)+n.length,v=Array(h+2);v[h+1]=(1<<m)-1;for(var g=h;f<=g;g--){var y=t[e.charAt(g-1)];if(v[g]=0===m?(v[g+1]<<1|1)&y:(v[g+1]<<1|1)&y|(d[g+1]|d[g])<<1|1|d[g+1],v[g]&c){y=o(m,g-1);if(y<=a){if(a=y,!(r<(u=g-1)))break;f=Math.max(1,2*r-u)}}}if(o(m+1,r)>a)break;d=v}return u},T.prototype.match_alphabet_=function(e){for(var t={},n=0;n<e.length;n++)t[e.charAt(n)]=0;for(n=0;n<e.length;n++)t[e.charAt(n)]|=1<<e.length-n-1;return t},T.prototype.patch_addContext_=function(e,t){if(0!=t.length){if(null===e.start2)throw Error("patch not initialized");for(var n=t.substring(e.start2,e.start2+e.length1),r=0;t.indexOf(n)!=t.lastIndexOf(n)&&n.length<this.Match_MaxBits-this.Patch_Margin-this.Patch_Margin;)r+=this.Patch_Margin,n=t.substring(e.start2-r,e.start2+e.length1+r);r+=this.Patch_Margin;var i=t.substring(e.start2-r,e.start2);i&&e.diffs.unshift(new T.Diff(0,i));var o=t.substring(e.start2+e.length1,e.start2+e.length1+r);o&&e.diffs.push(new T.Diff(0,o)),e.start1-=i.length,e.start2-=i.length,e.length1+=i.length+o.length,e.length2+=i.length+o.length}},T.prototype.patch_make=function(e,t,n){var r,i;if("string"==typeof e&&"string"==typeof t&&void 0===n)2<(i=this.diff_main(r=e,t,!0)).length&&(this.diff_cleanupSemantic(i),this.diff_cleanupEfficiency(i));else if(e&&"object"==typeof e&&void 0===t&&void 0===n)r=this.diff_text1(i=e);else if("string"==typeof e&&t&&"object"==typeof t&&void 0===n)r=e,i=t;else{if("string"!=typeof e||"string"!=typeof t||!n||"object"!=typeof n)throw new Error("Unknown call format to patch_make.");r=e,i=n}if(0===i.length)return[];for(var o=[],a=new T.patch_obj,l=0,s=0,d=0,c=r,u=r,p=0;p<i.length;p++){var m=i[p][0],f=i[p][1];switch(l||0===m||(a.start1=s,a.start2=d),m){case 1:a.diffs[l++]=i[p],a.length2+=f.length,u=u.substring(0,d)+f+u.substring(d);break;case M:a.length1+=f.length,a.diffs[l++]=i[p],u=u.substring(0,d)+u.substring(d+f.length);break;case 0:f.length<=2*this.Patch_Margin&&l&&i.length!=p+1?(a.diffs[l++]=i[p],a.length1+=f.length,a.length2+=f.length):f.length>=2*this.Patch_Margin&&l&&(this.patch_addContext_(a,c),o.push(a),a=new T.patch_obj,l=0,c=u,s=d)}1!==m&&(s+=f.length),m!==M&&(d+=f.length)}return l&&(this.patch_addContext_(a,c),o.push(a)),o},T.prototype.patch_deepCopy=function(e){for(var t=[],n=0;n<e.length;n++){var r=e[n],i=new T.patch_obj;i.diffs=[];for(var o=0;o<r.diffs.length;o++)i.diffs[o]=new T.Diff(r.diffs[o][0],r.diffs[o][1]);i.start1=r.start1,i.start2=r.start2,i.length1=r.length1,i.length2=r.length2,t[n]=i}return t},T.prototype.patch_apply=function(e,t){if(0==e.length)return[t,[]];e=this.patch_deepCopy(e);var n=this.patch_addPadding(e);t=n+t+n,this.patch_splitMax(e);for(var r=0,i=[],o=0;o<e.length;o++){var a,l=e[o].start2+r,s=this.diff_text1(e[o].diffs),d=-1;if(s.length>this.Match_MaxBits?-1!=(a=this.match_main(t,s.substring(0,this.Match_MaxBits),l))&&(-1==(d=this.match_main(t,s.substring(s.length-this.Match_MaxBits),l+s.length-this.Match_MaxBits))||d<=a)&&(a=-1):a=this.match_main(t,s,l),-1==a)i[o]=!1,r-=e[o].length2-e[o].length1;else if(i[o]=!0,r=a-l,s==(d=-1==d?t.substring(a,a+s.length):t.substring(a,d+this.Match_MaxBits)))t=t.substring(0,a)+this.diff_text2(e[o].diffs)+t.substring(a+s.length);else{var c=this.diff_main(s,d,!1);if(s.length>this.Match_MaxBits&&this.diff_levenshtein(c)/s.length>this.Patch_DeleteThreshold)i[o]=!1;else{this.diff_cleanupSemanticLossless(c);for(var u,p=0,m=0;m<e[o].diffs.length;m++){var f=e[o].diffs[m];0!==f[0]&&(u=this.diff_xIndex(c,p)),1===f[0]?t=t.substring(0,a+u)+f[1]+t.substring(a+u):f[0]===M&&(t=t.substring(0,a+u)+t.substring(a+this.diff_xIndex(c,p+f[1].length))),f[0]!==M&&(p+=f[1].length)}}}}return[t=t.substring(n.length,t.length-n.length),i]},T.prototype.patch_addPadding=function(e){for(var t=this.Patch_Margin,n="",r=1;r<=t;r++)n+=String.fromCharCode(r);for(r=0;r<e.length;r++)e[r].start1+=t,e[r].start2+=t;var i,o=e[0],a=o.diffs;return 0==a.length||0!=a[0][0]?(a.unshift(new T.Diff(0,n)),o.start1-=t,o.start2-=t,o.length1+=t,o.length2+=t):t>a[0][1].length&&(i=t-a[0][1].length,a[0][1]=n.substring(a[0][1].length)+a[0][1],o.start1-=i,o.start2-=i,o.length1+=i,o.length2+=i),0==(a=(o=e[e.length-1]).diffs).length||0!=a[a.length-1][0]?(a.push(new T.Diff(0,n)),o.length1+=t,o.length2+=t):t>a[a.length-1][1].length&&(i=t-a[a.length-1][1].length,a[a.length-1][1]+=n.substring(0,i),o.length1+=i,o.length2+=i),n},T.prototype.patch_splitMax=function(e){for(var t=this.Match_MaxBits,n=0;n<e.length;n++)if(!(e[n].length1<=t)){var r=e[n];e.splice(n--,1);for(var i=r.start1,o=r.start2,a="";0!==r.diffs.length;){var l=new T.patch_obj,s=!0;for(l.start1=i-a.length,l.start2=o-a.length,""!==a&&(l.length1=l.length2=a.length,l.diffs.push(new T.Diff(0,a)));0!==r.diffs.length&&l.length1<t-this.Patch_Margin;){var d=r.diffs[0][0],c=r.diffs[0][1];1===d?(l.length2+=c.length,o+=c.length,l.diffs.push(r.diffs.shift()),s=!1):d===M&&1==l.diffs.length&&0==l.diffs[0][0]&&c.length>2*t?(l.length1+=c.length,i+=c.length,s=!1,l.diffs.push(new T.Diff(d,c)),r.diffs.shift()):(c=c.substring(0,t-l.length1-this.Patch_Margin),l.length1+=c.length,i+=c.length,0===d?(l.length2+=c.length,o+=c.length):s=!1,l.diffs.push(new T.Diff(d,c)),c==r.diffs[0][1]?r.diffs.shift():r.diffs[0][1]=r.diffs[0][1].substring(c.length))}var a=(a=this.diff_text2(l.diffs)).substring(a.length-this.Patch_Margin),u=this.diff_text1(r.diffs).substring(0,this.Patch_Margin);""!==u&&(l.length1+=u.length,l.length2+=u.length,0!==l.diffs.length&&0===l.diffs[l.diffs.length-1][0]?l.diffs[l.diffs.length-1][1]+=u:l.diffs.push(new T.Diff(0,u))),s||e.splice(++n,0,l)}}},T.prototype.patch_toText=function(e){for(var t=[],n=0;n<e.length;n++)t[n]=e[n];return t.join("")},T.prototype.patch_fromText=function(e){var t=[];if(!e)return t;for(var n=e.split("\n"),r=0,i=/^@@ -(\d+),?(\d*) \+(\d+),?(\d*) @@$/;r<n.length;){var o=n[r].match(i);if(!o)throw new Error("Invalid patch string: "+n[r]);var a=new T.patch_obj;for(t.push(a),a.start1=parseInt(o[1],10),""===o[2]?(a.start1--,a.length1=1):"0"==o[2]?a.length1=0:(a.start1--,a.length1=parseInt(o[2],10)),a.start2=parseInt(o[3],10),""===o[4]?(a.start2--,a.length2=1):"0"==o[4]?a.length2=0:(a.start2--,a.length2=parseInt(o[4],10)),r++;r<n.length;){var l=n[r].charAt(0);try{var s=decodeURI(n[r].substring(1))}catch(e){throw new Error("Illegal escape in patch_fromText: "+s)}if("-"==l)a.diffs.push(new T.Diff(M,s));else if("+"==l)a.diffs.push(new T.Diff(1,s));else if(" "==l)a.diffs.push(new T.Diff(0,s));else{if("@"==l)break;if(""!==l)throw new Error('Invalid patch mode "'+l+'" in: '+s)}r++}}return t},(T.patch_obj=function(){this.diffs=[],this.start1=null,this.start2=null,this.length1=0,this.length2=0}).prototype.toString=function(){for(var e,t=0===this.length1?this.start1+",0":1==this.length1?this.start1+1:this.start1+1+","+this.length1,n=0===this.length2?this.start2+",0":1==this.length2?this.start2+1:this.start2+1+","+this.length2,r=["@@ -"+t+" +"+n+" @@\n"],i=0;i<this.diffs.length;i++){switch(this.diffs[i][0]){case 1:e="+";break;case M:e="-";break;case 0:e=" "}r[i+1]=e+encodeURI(this.diffs[i][1])+"\n"}return r.join("").replace(/%20/g," ")},e.exports=T,e.exports.diff_match_patch=T,e.exports.DIFF_DELETE=M,e.exports.DIFF_INSERT=1,e.exports.DIFF_EQUAL=0},157:()=>{},857:(e,t,n)=>{"use strict";n.d(t,{default:()=>H});function l(e){function t(e){var t=document.createElement("img");t.src=e.getAttribute("data-src"),t.addEventListener("load",function(){e.getAttribute("style")||e.getAttribute("class")||e.getAttribute("width")||e.getAttribute("height")||t.naturalHeight>t.naturalWidth&&t.naturalWidth/t.naturalHeight<document.querySelector(".vditor-reset").clientWidth/(window.innerHeight-40)&&t.naturalHeight>window.innerHeight-40&&(e.style.height=window.innerHeight-40+"px"),e.src=t.src}),e.removeAttribute("data-src")}if(void 0===e&&(e=document),!("IntersectionObserver"in window))return e.querySelectorAll("img").forEach(function(e){e.getAttribute("data-src")&&t(e)}),!1;window.vditorImageIntersectionObserver?(window.vditorImageIntersectionObserver.disconnect(),e.querySelectorAll("img").forEach(function(e){window.vditorImageIntersectionObserver.observe(e)})):(window.vditorImageIntersectionObserver=new IntersectionObserver(function(e){e.forEach(function(e){(void 0===e.isIntersecting?0!==e.intersectionRatio:e.isIntersecting)&&e.target.getAttribute("data-src")&&t(e.target)})}),e.querySelectorAll("img").forEach(function(e){window.vditorImageIntersectionObserver.observe(e)}))}function s(e,r){var i,t,o,n,a;void 0===r&&(r="zh_CN"),"undefined"!=typeof speechSynthesis&&"undefined"!=typeof SpeechSynthesisUtterance&&(i='<svg><use xlink:href="#vditor-icon-play"></use></svg>',t='<svg><use xlink:href="#vditor-icon-pause"></use></svg>',(o=document.querySelector(".vditor-speech"))||((o=document.createElement("div")).className="vditor-speech",document.body.insertAdjacentElement("beforeend",o),n=function(){var t,n;return speechSynthesis.getVoices().forEach(function(e){e.lang===r.replace("_","-")&&(t=e),e.default&&(n=e)}),t=t||n},void 0!==speechSynthesis.onvoiceschanged&&(speechSynthesis.onvoiceschanged=n),a=n(),o.onclick=function(){var e;"vditor-speech"===o.className?((e=new SpeechSynthesisUtterance(o.getAttribute("data-text"))).voice=a,e.onend=function(){o.className="vditor-speech",speechSynthesis.cancel(),o.innerHTML=i},speechSynthesis.speak(e),o.className="vditor-speech vditor-speech--current",o.innerHTML=t):speechSynthesis.speaking&&(speechSynthesis.paused?(speechSynthesis.resume(),o.innerHTML=t):(speechSynthesis.pause(),o.innerHTML=i)),(0,M.Hc)(window.vditorSpeechRange)},document.body.addEventListener("click",function(){""===getSelection().toString().trim()&&"block"===o.style.display&&(o.className="vditor-speech",speechSynthesis.cancel(),o.style.display="none")})),e.addEventListener("mouseup",function(e){var t,n=getSelection().toString().trim();speechSynthesis.cancel(),""!==getSelection().toString().trim()?(window.vditorSpeechRange=getSelection().getRangeAt(0).cloneRange(),t=getSelection().getRangeAt(0).getBoundingClientRect(),o.innerHTML=i,o.style.display="block",o.style.top=t.top+t.height+document.querySelector("html").scrollTop-20+"px",o.style.left=e.screenX+2+"px",o.setAttribute("data-text",n)):"block"===o.style.display&&(o.className="vditor-speech",o.style.display="none")}))}function d(e){var t={anchor:0,cdn:a.g.CDN,customEmoji:{},emojiPath:(e&&e.emojiPath||a.g.CDN)+"/images/emoji",hljs:a.g.HLJS_OPTIONS,icon:"ant",lang:"zh_CN",markdown:a.g.MARKDOWN_OPTIONS,math:a.g.MATH_OPTIONS,mode:"light",speech:{enable:!1},theme:a.g.THEME_OPTIONS};return(0,L.T)(t,e)}function c(t,n){var r=d(n);return(0,S.G)(r.cdn+"/js/lute/lute.min.js","vditorLuteScript").then(function(){var e=(0,T.X)({autoSpace:r.markdown.autoSpace,codeBlockPreview:r.markdown.codeBlockPreview,emojiSite:r.emojiPath,emojis:r.customEmoji,fixTermTypo:r.markdown.fixTermTypo,footnotes:r.markdown.footnotes,headingAnchor:0!==r.anchor,inlineMathDigit:r.math.inlineDigit,lazyLoadImage:r.lazyLoadImage,linkBase:r.markdown.linkBase,linkPrefix:r.markdown.linkPrefix,listStyle:r.markdown.listStyle,mark:r.markdown.mark,mathBlockPreview:r.markdown.mathBlockPreview,paragraphBeginningSpace:r.markdown.paragraphBeginningSpace,sanitize:r.markdown.sanitize,toc:r.markdown.toc});return null!=n&&n.renderers&&e.SetJSRenderers({renderers:{Md2HTML:n.renderers}}),e.SetHeadingID(!0),e.Md2HTML(t)})}function r(i,o,a){return _(void 0,void 0,void 0,function(){var t,r;return A(this,function(e){switch(e.label){case 0:return t=d(a),[4,c(o,t)];case 1:if(r=e.sent(),t.transform&&(r=t.transform(r)),i.innerHTML=r,i.classList.add("vditor-reset"),t.i18n)window.VditorI18n=t.i18n;else{if(!["en_US","ja_JP","ko_KR","ru_RU","zh_CN","zh_TW"].includes(t.lang))throw new Error("options.lang error, see https://ld246.com/article/1549638745630#options");(0,S.J)(t.cdn+"/js/i18n/"+t.lang+".js","vditorI18nScript")}return(0,k.Z)(t.theme.current,t.theme.path),1===t.anchor&&i.classList.add("vditor-reset--anchor"),(0,m.O)(i),(0,v.s)(t.hljs,i,t.cdn),(0,g.H)(i,{cdn:t.cdn,math:t.math}),(0,b.i)(i,t.cdn,t.mode),(0,f.P)(i,t.cdn),(0,h.v)(i,t.cdn),(0,p.p)(i,t.cdn,t.mode),(0,w.P)(i,t.cdn,t.mode),(0,E.B)(i,t.cdn),(0,u.Q)(i,t.cdn),(0,y.Y)(i),t.speech.enable&&s(i),0!==t.anchor&&(n=t.anchor,document.querySelectorAll(".vditor-anchor").forEach(function(t){1===n&&t.classList.add("vditor-anchor--left"),t.onclick=function(){var e=t.getAttribute("href").substr(1),e=document.getElementById("vditorAnchor-"+e).offsetTop;document.querySelector("html").scrollTop=e}}),window.onhashchange=function(){var e=document.getElementById("vditorAnchor-"+decodeURIComponent(window.location.hash.substr(1)));e&&(document.querySelector("html").scrollTop=e.offsetTop)}),t.after&&t.after(),t.lazyLoadImage&&l(i),t.icon&&(0,S.G)(t.cdn+"/js/icons/"+t.icon+".js","vditorIconScript"),i.addEventListener("click",function(e){e=(0,C.lG)(e.target,"SPAN");e&&(0,C.fb)(e,"vditor-toc")&&((e=i.querySelector("#"+e.getAttribute("data-target-id")))&&window.scrollTo(window.scrollX,e.offsetTop))}),[2]}var n})})}var u=n(369),i=n(46),p=n(726),m=n(23),f=n(383),h=n(890),v=n(93),g=n(323),y=n(207),b=n(765),w=n(894),o=n(198),E=n(583),a=n(260),k=n(958),S=n(228),C=n(713),L=n(224),T=n(792),M=n(187),_=function(e,a,l,s){return new(l=l||Promise)(function(n,t){function r(e){try{o(s.next(e))}catch(e){t(e)}}function i(e){try{o(s.throw(e))}catch(e){t(e)}}function o(e){var t;e.done?n(e.value):((t=e.value)instanceof l?t:new l(function(e){e(t)})).then(r,i)}o((s=s.apply(e,a||[])).next())})},A=function(n,r){var i,o,a,l={label:0,sent:function(){if(1&a[0])throw a[1];return a[1]},trys:[],ops:[]},e={next:t(0),throw:t(1),return:t(2)};return"function"==typeof Symbol&&(e[Symbol.iterator]=function(){return this}),e;function t(t){return function(e){return function(t){if(i)throw new TypeError("Generator is already executing.");for(;l;)try{if(i=1,o&&(a=2&t[0]?o.return:t[0]?o.throw||((a=o.return)&&a.call(o),0):o.next)&&!(a=a.call(o,t[1])).done)return a;switch(o=0,(t=a?[2&t[0],a.value]:t)[0]){case 0:case 1:a=t;break;case 4:return l.label++,{value:t[1],done:!1};case 5:l.label++,o=t[1],t=[0];continue;case 7:t=l.ops.pop(),l.trys.pop();continue;default:if(!(a=0<(a=l.trys).length&&a[a.length-1])&&(6===t[0]||2===t[0])){l=0;continue}if(3===t[0]&&(!a||t[1]>a[0]&&t[1]<a[3])){l.label=t[1];break}if(6===t[0]&&l.label<a[1]){l.label=a[1],a=t;break}if(a&&l.label<a[2]){l.label=a[2],l.ops.push(t);break}a[2]&&l.ops.pop(),l.trys.pop();continue}t=r.call(n,l)}catch(e){t=[6,e],o=0}finally{i=a=0}if(5&t[0])throw t[1];return{value:t[0]?t[1]:void 0,done:!0}}([t,e])}}},t=n(264),n=n(968);function x(){}const H=(x.adapterRender=i,x.previewImage=t.E,x.codeRender=m.O,x.graphvizRender=h.v,x.highlightRender=v.s,x.mathRender=g.H,x.mermaidRender=b.i,x.flowchartRender=f.P,x.chartRender=p.p,x.abcRender=u.Q,x.mindmapRender=w.P,x.plantumlRender=E.B,x.outlineRender=o.k,x.mediaRender=y.Y,x.speechRender=s,x.lazyLoadImageRender=l,x.md2html=c,x.preview=r,x.setCodeTheme=n.Y,x.setContentTheme=k.Z,x)},260:(e,t,n)=>{"use strict";n.d(t,{H:()=>r,g:()=>i});var r="3.8.5",i=(o.ZWSP="​",o.DROP_EDITOR="application/editor",o.MOBILE_WIDTH=520,o.CLASS_MENU_DISABLED="vditor-menu--disabled",o.EDIT_TOOLBARS=["emoji","headings","bold","italic","strike","link","list","ordered-list","outdent","indent","check","line","quote","code","inline-code","insert-after","insert-before","upload","record","table"],o.CODE_THEME=["abap","algol","algol_nu","arduino","autumn","borland","bw","colorful","dracula","emacs","friendly","fruity","github","igor","lovelace","manni","monokai","monokailight","murphy","native","paraiso-dark","paraiso-light","pastie","perldoc","pygments","rainbow_dash","rrt","solarized-dark","solarized-dark256","solarized-light","swapoff","tango","trac","vim","vs","xcode","ant-design"],o.CODE_LANGUAGES=["mermaid","echarts","mindmap","plantuml","abc","graphviz","flowchart","apache","js","ts","html","properties","apache","bash","c","csharp","cpp","css","coffeescript","diff","go","xml","http","json","java","javascript","kotlin","less","lua","makefile","markdown","nginx","objectivec","php","php-template","perl","plaintext","python","python-repl","r","ruby","rust","scss","sql","shell","swift","ini","typescript","vbnet","yaml","ada","clojure","dart","erb","fortran","gradle","haskell","julia","julia-repl","lisp","matlab","pgsql","powershell","sql_more","stata","cmake","mathematica"],o.CDN="/Theme/assets",o.MARKDOWN_OPTIONS={autoSpace:!1,codeBlockPreview:!0,fixTermTypo:!1,footnotes:!0,linkBase:"",linkPrefix:"",listStyle:!1,mark:!1,mathBlockPreview:!0,paragraphBeginningSpace:!1,sanitize:!0,toc:!1},o.HLJS_OPTIONS={enable:!0,lineNumber:!1,style:"github"},o.MATH_OPTIONS={engine:"KaTeX",inlineDigit:!1,macros:{}},o.THEME_OPTIONS={current:"light",list:{"ant-design":"Ant Design",dark:"Dark",light:"Light",wechat:"WeChat"},path:o.CDN+"/css/content-theme"},o);function o(){}},369:(e,t,n)=>{"use strict";n.d(t,{Q:()=>a});var r=n(260),i=n(228),o=n(46),a=function(e,t){void 0===e&&(e=document),void 0===t&&(t=r.g.CDN);var n=o.abcRenderAdapter.getElements(e);0<n.length&&(0,i.G)(t+"/js/abcjs/abcjs_basic.min.js","vditorAbcjsScript").then(function(){n.forEach(function(e){e.parentElement.classList.contains("vditor-wysiwyg__pre")||e.parentElement.classList.contains("vditor-ir__marker--pre")||"true"!==e.getAttribute("data-processed")&&(ABCJS.renderAbc(e,o.abcRenderAdapter.getCode(e).trim()),e.style.overflowX="auto",e.setAttribute("data-processed","true"))})})}},46:(e,t,n)=>{"use strict";n.r(t),n.d(t,{mathRenderAdapter:()=>r,mermaidRenderAdapter:()=>i,mindmapRenderAdapter:()=>o,chartRenderAdapter:()=>a,abcRenderAdapter:()=>l,graphvizRenderAdapter:()=>s,flowchartRenderAdapter:()=>d,plantumlRenderAdapter:()=>c});var r={getCode:function(e){return e.textContent},getElements:function(e){return e.querySelectorAll(".language-math")}},i={getCode:function(e){return e.textContent},getElements:function(e){return e.querySelectorAll(".language-mermaid")}},o={getCode:function(e){return e.getAttribute("data-code")},getElements:function(e){return e.querySelectorAll(".language-mindmap")}},a={getCode:function(e){return e.innerText},getElements:function(e){return e.querySelectorAll(".language-echarts")}},l={getCode:function(e){return e.textContent},getElements:function(e){return e.querySelectorAll(".language-abc")}},s={getCode:function(e){return e.textContent},getElements:function(e){return e.querySelectorAll(".language-graphviz")}},d={getCode:function(e){return e.textContent},getElements:function(e){return e.querySelectorAll(".language-flowchart")}},c={getCode:function(e){return e.textContent},getElements:function(e){return e.querySelectorAll(".language-plantuml")}}},726:(e,t,n)=>{"use strict";n.d(t,{p:()=>r});var i=n(260),o=n(228),a=n(46),r=function(e,t,r){void 0===e&&(e=document),void 0===t&&(t=i.g.CDN);var n=a.chartRenderAdapter.getElements(e);0<n.length&&(0,o.G)(t+"/js/echarts/echarts.min.js","vditorEchartsScript").then(function(){n.forEach(function(t){if(!t.parentElement.classList.contains("vditor-wysiwyg__pre")&&!t.parentElement.classList.contains("vditor-ir__marker--pre")){var e=a.chartRenderAdapter.getCode(t).trim();if(e)try{if("true"===t.getAttribute("data-processed"))return;var n=JSON.parse(e);echarts.init(t,"dark"===r?"dark":void 0).setOption(n),t.setAttribute("data-processed","true")}catch(e){t.className="vditor-reset--error",t.innerHTML="echarts render error: <br>"+e}}})})}},23:(e,t,n)=>{"use strict";n.d(t,{O:()=>r});var o=n(769),r=function(i){i.querySelectorAll("pre > code").forEach(function(e,t){var n,r;e.parentElement.classList.contains("vditor-wysiwyg__pre")||e.parentElement.classList.contains("vditor-ir__marker--pre")||e.classList.contains("language-mermaid")||e.classList.contains("language-flowchart")||e.classList.contains("language-echarts")||e.classList.contains("language-mindmap")||e.classList.contains("language-plantuml")||e.classList.contains("language-abc")||e.classList.contains("language-graphviz")||e.classList.contains("language-math")||-1<e.style.maxHeight.indexOf("px")||i.classList.contains("vditor-preview")&&5<t||(n=e.innerText,e.classList.contains("highlight-chroma")&&((r=document.createElement("code")).innerHTML=e.innerHTML,r.querySelectorAll(".highlight-ln").forEach(function(e){e.remove()}),n=r.innerText),(t=document.createElement("div")).className="vditor-copy",t.innerHTML='<span aria-label="'+window.VditorI18n.copy+"\"\nonmouseover=\"this.setAttribute('aria-label', '"+window.VditorI18n.copy+"')\"\nclass=\"vditor-tooltipped vditor-tooltipped__w\"\nonclick=\"this.previousElementSibling.select();document.execCommand('copy');this.setAttribute('aria-label', '"+window.VditorI18n.copied+'\')"><svg><use xlink:href="#vditor-icon-copy"></use></svg></span>',(r=document.createElement("textarea")).value=(0,o.X)(n),t.insertAdjacentElement("afterbegin",r),e.before(t),e.style.maxHeight=window.outerHeight-40+"px")})}},383:(e,t,n)=>{"use strict";n.d(t,{P:()=>a});var r=n(260),i=n(228),o=n(46),a=function(e,t){void 0===t&&(t=r.g.CDN);var n=o.flowchartRenderAdapter.getElements(e);0!==n.length&&(0,i.G)(t+"/js/flowchart.js/flowchart.min.js","vditorFlowchartScript").then(function(){n.forEach(function(e){var t;"true"!==e.getAttribute("data-processed")&&(t=flowchart.parse(o.flowchartRenderAdapter.getCode(e)),e.innerHTML="",t.drawSVG(e),e.setAttribute("data-processed","true"))})})}},890:(e,t,n)=>{"use strict";n.d(t,{v:()=>a});var r=n(260),i=n(228),o=n(46),a=function(e,t){void 0===t&&(t=r.g.CDN);var n=o.graphvizRenderAdapter.getElements(e);0!==n.length&&(0,i.G)(t+"/js/graphviz/viz.js","vditorGraphVizScript").then(function(){n.forEach(function(t){var e=o.graphvizRenderAdapter.getCode(t);if(!t.parentElement.classList.contains("vditor-wysiwyg__pre")&&!t.parentElement.classList.contains("vditor-ir__marker--pre")&&"true"!==t.getAttribute("data-processed")&&""!==e.trim()){try{var n=new Blob(["importScripts('"+document.getElementById("vditorGraphVizScript").src.replace("viz.js","full.render.js")+"');"],{type:"application/javascript"}),r=(window.URL||window.webkitURL).createObjectURL(n),i=new Worker(r);new Viz({worker:i}).renderSVGElement(e).then(function(e){t.innerHTML=e.outerHTML}).catch(function(e){t.innerHTML="graphviz render error: <br>"+e,t.className="vditor-reset--error"})}catch(t){console.error("graphviz error",t)}t.setAttribute("data-processed","true")}})})}},93:(e,t,n)=>{"use strict";n.d(t,{s:()=>r});var i=n(260),a=n(228),l=n(946),r=function(o,e,t){void 0===e&&(e=document),void 0===t&&(t=i.g.CDN);var n=o.style;i.g.CODE_THEME.includes(n)||(n="github");var r=document.getElementById("vditorHljsStyle");r&&r.href!==t+"/js/highlight.js/styles/"+n+".css"&&r.remove(),(0,l.c)(t+"/js/highlight.js/styles/"+n+".css","vditorHljsStyle"),!1!==o.enable&&0!==e.querySelectorAll("pre > code").length&&(0,a.G)(t+"/js/highlight.js/highlight.pack.js","vditorHljsScript").then(function(){e.querySelectorAll("pre > code").forEach(function(e){var n,r,i,t;e.parentElement.classList.contains("vditor-ir__marker--pre")||e.parentElement.classList.contains("vditor-wysiwyg__pre")||e.classList.contains("language-mermaid")||e.classList.contains("language-flowchart")||e.classList.contains("language-echarts")||e.classList.contains("language-mindmap")||e.classList.contains("language-plantuml")||e.classList.contains("language-abc")||e.classList.contains("language-graphviz")||e.classList.contains("language-math")||(hljs.highlightElement(e),o.lineNumber&&(e.classList.add("vditor-linenumber"),(n=e.querySelector(".vditor-linenumber__temp"))||((n=document.createElement("div")).className="vditor-linenumber__temp",e.insertAdjacentElement("beforeend",n)),t=getComputedStyle(e).whiteSpace,r="pre-wrap"!==t&&"pre-line"!==t?!1:!0,i="",(t=e.textContent.split(/\r\n|\r|\n/g)).pop(),t.map(function(e){var t="";r&&(n.textContent=e||"\n",t=' style="height:'+n.getBoundingClientRect().height+'px"'),i+="<span"+t+"></span>"}),n.style.display="none",i='<span class="vditor-linenumber__rows">'+i+"</span>",e.insertAdjacentHTML("beforeend",i)))})})}},323:(e,t,n)=>{"use strict";n.d(t,{H:()=>a});var r=n(260),i=n(228),o=n(946),s=n(769),d=n(46),a=function(e,t){var a,l=d.mathRenderAdapter.getElements(e);0!==l.length&&(e={cdn:r.g.CDN,math:{engine:"KaTeX",inlineDigit:!1,macros:{}}},t&&t.math&&(t.math=Object.assign({},e.math,t.math)),"KaTeX"===(t=Object.assign({},e,t)).math.engine?((0,o.c)(t.cdn+"/js/katex/katex.min.css","vditorKatexStyle"),(0,i.G)(t.cdn+"/js/katex/katex.min.js","vditorKatexScript").then(function(){l.forEach(function(t){if(!t.parentElement.classList.contains("vditor-wysiwyg__pre")&&!t.parentElement.classList.contains("vditor-ir__marker--pre")&&!t.getAttribute("data-math")){var e=(0,s.X)(d.mathRenderAdapter.getCode(t));t.setAttribute("data-math",e);try{t.innerHTML=katex.renderToString(e,{displayMode:"DIV"===t.tagName,output:"html"})}catch(e){t.innerHTML=e.message,t.className="language-math vditor-reset--error"}t.addEventListener("copy",function(e){e.stopPropagation(),e.preventDefault();var t=e.currentTarget.closest(".language-math");e.clipboardData.setData("text/html",t.innerHTML),e.clipboardData.setData("text/plain",t.getAttribute("data-math"))})}})})):"MathJax"===t.math.engine&&(window.MathJax||(window.MathJax={loader:{paths:{mathjax:t.cdn+"/js/mathjax"}},startup:{typeset:!1},tex:{macros:t.math.macros}}),(0,i.J)(t.cdn+"/js/mathjax/tex-svg-full.js","protyleMathJaxScript"),a=function(t,n){var r=(0,s.X)(t.textContent).trim(),e=window.MathJax.getMetricsFor(t);e.display="DIV"===t.tagName,window.MathJax.tex2svgPromise(r,e).then(function(e){t.innerHTML="",t.setAttribute("data-math",r),t.append(e),window.MathJax.startup.document.clear(),window.MathJax.startup.document.updateDocument();e=e.querySelector('[data-mml-node="merror"]');e&&""!==e.textContent.trim()&&(t.innerHTML=e.textContent.trim(),t.className="vditor-reset--error"),n&&n()})},window.MathJax.startup.promise.then(function(){for(var t,n,r,i,e=[],o=0;o<l.length;o++)!function(t){var n=l[t];n.parentElement.classList.contains("vditor-wysiwyg__pre")||n.parentElement.classList.contains("vditor-ir__marker--pre")||n.getAttribute("data-math")||!(0,s.X)(n.textContent).trim()||e.push(function(e){t===l.length-1?a(n):a(n,e)})}(o);0!==(t=e).length&&(n=0,r=t[t.length-1],(i=function(){var e=t[n++];e===r?e():e(i)})())})))}},207:(e,t,n)=>{"use strict";n.d(t,{Y:()=>r});var r=function(e){e&&e.querySelectorAll("a").forEach(function(e){var t,n,r,i,o,a,l,s=e.getAttribute("href");s&&(s.match(/^.+.(mp4|m4v|ogg|ogv|webm)$/)?((l=e).insertAdjacentHTML("afterend",'<video controls="controls" src="'+s+'"></video>'),l.remove()):s.match(/^.+.(mp3|wav|flac)$/)?((a=e).insertAdjacentHTML("afterend",'<audio controls="controls" src="'+s+'"></audio>'),a.remove()):(t=e,r=(n=s).match(/\/\/(?:www\.)?(?:youtu\.be\/|youtube\.com\/(?:embed\/|v\/|watch\?v=|watch\?.+&v=))([\w|-]{11})(?:(?:[\?&]t=)(\S+))?/),i=n.match(/\/\/v\.youku\.com\/v_show\/id_(\w+)=*\.html/),o=n.match(/\/\/v\.qq\.com\/x\/cover\/.*\/([^\/]+)\.html\??.*/),l=n.match(/(?:www\.|\/\/)coub\.com\/view\/(\w+)/),a=n.match(/(?:www\.|\/\/)facebook\.com\/([^\/]+)\/videos\/([0-9]+)/),e=n.match(/.+dailymotion.com\/(video|hub)\/(\w+)\?/),s=n.match(/(?:www\.|\/\/)bilibili\.com\/video\/(\w+)/),n=n.match(/(?:www\.|\/\/)ted\.com\/talks\/(\w+)/),r&&11===r[1].length?(t.insertAdjacentHTML("afterend",'<iframe class="iframe__video" src="//www.youtube.com/embed/'+r[1]+(r[2]?"?start="+r[2]:"")+'"></iframe>'),t.remove()):i&&i[1]?(t.insertAdjacentHTML("afterend",'<iframe class="iframe__video" src="//player.youku.com/embed/'+i[1]+'"></iframe>'),t.remove()):o&&o[1]?(t.insertAdjacentHTML("afterend",'<iframe class="iframe__video" src="https://v.qq.com/txp/iframe/player.html?vid='+o[1]+'"></iframe>'),t.remove()):l&&l[1]?(t.insertAdjacentHTML("afterend",'<iframe class="iframe__video"\n src="//coub.com/embed/'+l[1]+'?muted=false&autostart=false&originalSize=true&startWithHD=true"></iframe>'),t.remove()):a&&a[0]?(t.insertAdjacentHTML("afterend",'<iframe class="iframe__video"\n src="https://www.facebook.com/plugins/video.php?href='+encodeURIComponent(a[0])+'"></iframe>'),t.remove()):e&&e[2]?(t.insertAdjacentHTML("afterend",'<iframe class="iframe__video"\n src="https://www.dailymotion.com/embed/video/'+e[2]+'"></iframe>'),t.remove()):s&&s[1]?(t.insertAdjacentHTML("afterend",'<iframe class="iframe__video"\n src="//player.bilibili.com/player.html?bvid='+s[1]+'"></iframe>'),t.remove()):n&&n[1]&&(t.insertAdjacentHTML("afterend",'<iframe class="iframe__video" src="//embed.ted.com/talks/'+n[1]+'"></iframe>'),t.remove())))})}},765:(e,t,n)=>{"use strict";n.d(t,{i:()=>r});var i=n(260),o=n(228),a=n(46),r=function(e,t,n){void 0===t&&(t=i.g.CDN);var r=a.mermaidRenderAdapter.getElements(e);0!==r.length&&(0,o.G)(t+"/js/mermaid/mermaid.min.js","vditorMermaidScript").then(function(){var e={altFontFamily:"sans-serif",flowchart:{htmlLabels:!0,useMaxWidth:!0},fontFamily:"sans-serif",gantt:{leftPadding:75,rightPadding:20},securityLevel:"loose",sequence:{boxMargin:8,diagramMarginX:8,diagramMarginY:8,useMaxWidth:!0},startOnLoad:!1};"dark"===n&&(e.theme="dark",e.themeVariables={activationBkgColor:"hsl(180, 1.5873015873%, 28.3529411765%)",activationBorderColor:"#81B1DB",activeTaskBkgColor:"#81B1DB",activeTaskBorderColor:"#ffffff",actorBkg:"#1f2020",actorBorder:"#81B1DB",actorLineColor:"lightgrey",actorTextColor:"lightgrey",altBackground:"hsl(0, 0%, 40%)",altSectionBkgColor:"#333",arrowheadColor:"lightgrey",background:"#333",border1:"#81B1DB",border2:"rgba(255, 255, 255, 0.25)",classText:"#e0dfdf",clusterBkg:"hsl(180, 1.5873015873%, 28.3529411765%)",clusterBorder:"rgba(255, 255, 255, 0.25)",critBkgColor:"#E83737",critBorderColor:"#E83737",darkTextColor:"hsl(28.5714285714, 17.3553719008%, 86.2745098039%)",defaultLinkColor:"lightgrey",doneTaskBkgColor:"lightgrey",doneTaskBorderColor:"grey",edgeLabelBackground:"hsl(0, 0%, 34.4117647059%)",errorBkgColor:"#a44141",errorTextColor:"#ddd",fillType0:"#1f2020",fillType1:"hsl(180, 1.5873015873%, 28.3529411765%)",fillType2:"hsl(244, 1.5873015873%, 12.3529411765%)",fillType3:"hsl(244, 1.5873015873%, 28.3529411765%)",fillType4:"hsl(116, 1.5873015873%, 12.3529411765%)",fillType5:"hsl(116, 1.5873015873%, 28.3529411765%)",fillType6:"hsl(308, 1.5873015873%, 12.3529411765%)",fillType7:"hsl(308, 1.5873015873%, 28.3529411765%)",fontFamily:'"trebuchet ms", verdana, arial',fontSize:"16px",gridColor:"lightgrey",labelBackground:"#181818",labelBoxBkgColor:"#1f2020",labelBoxBorderColor:"#81B1DB",labelColor:"#ccc",labelTextColor:"lightgrey",lineColor:"lightgrey",loopTextColor:"lightgrey",mainBkg:"#1f2020",mainContrastColor:"lightgrey",nodeBkg:"#1f2020",nodeBorder:"#81B1DB",noteBkgColor:"#fff5ad",noteBorderColor:"rgba(255, 255, 255, 0.25)",noteTextColor:"#1f2020",primaryBorderColor:"hsl(180, 0%, 2.3529411765%)",primaryColor:"#1f2020",primaryTextColor:"#e0dfdf",secondBkg:"hsl(180, 1.5873015873%, 28.3529411765%)",secondaryBorderColor:"hsl(180, 0%, 18.3529411765%)",secondaryColor:"hsl(180, 1.5873015873%, 28.3529411765%)",secondaryTextColor:"rgb(183.8476190475, 181.5523809523, 181.5523809523)",sectionBkgColor:"hsl(52.9411764706, 28.813559322%, 58.431372549%)",sectionBkgColor2:"#EAE8D9",sequenceNumberColor:"black",signalColor:"lightgrey",signalTextColor:"lightgrey",taskBkgColor:"hsl(180, 1.5873015873%, 35.3529411765%)",taskBorderColor:"#ffffff",taskTextClickableColor:"#003163",taskTextColor:"hsl(28.5714285714, 17.3553719008%, 86.2745098039%)",taskTextDarkColor:"hsl(28.5714285714, 17.3553719008%, 86.2745098039%)",taskTextLightColor:"lightgrey",taskTextOutsideColor:"lightgrey",tertiaryBorderColor:"hsl(20, 0%, 2.3529411765%)",tertiaryColor:"hsl(20, 1.5873015873%, 12.3529411765%)",tertiaryTextColor:"rgb(222.9999999999, 223.6666666666, 223.9999999999)",textColor:"#ccc",titleColor:"#F9FFFE",todayLineColor:"#DB5757"}),mermaid.initialize(e),r.forEach(function(e){var t=a.mermaidRenderAdapter.getCode(e);"true"!==e.getAttribute("data-processed")&&""!==t.trim()&&(mermaid.init(void 0,e),e.setAttribute("data-processed","true"))})})}},894:(e,t,n)=>{"use strict";n.d(t,{P:()=>r});var i=n(260),o=n(228),a=n(46),r=function(e,t,n){void 0===e&&(e=document),void 0===t&&(t=i.g.CDN);var r=a.mindmapRenderAdapter.getElements(e);0<r.length&&(0,o.G)(t+"/js/echarts/echarts.min.js","vditorEchartsScript").then(function(){r.forEach(function(t){if(!t.parentElement.classList.contains("vditor-wysiwyg__pre")&&!t.parentElement.classList.contains("vditor-ir__marker--pre")){var e=a.mindmapRenderAdapter.getCode(t);if(e)try{if("true"===t.getAttribute("data-processed"))return;echarts.init(t,"dark"===n?"dark":void 0).setOption({series:[{data:[JSON.parse(decodeURIComponent(e))],initialTreeDepth:-1,itemStyle:{borderWidth:0,color:"#4285f4"},label:{backgroundColor:"#f6f8fa",borderColor:"#d1d5da",borderRadius:5,borderWidth:.5,color:"#586069",lineHeight:20,offset:[-5,0],padding:[0,5],position:"insideRight"},lineStyle:{color:"#d1d5da",width:1},roam:!0,symbol:function(e,t){return null!==(t=null==t?void 0:t.data)&&void 0!==t&&t.children?"circle":"path://"},type:"tree"}],tooltip:{trigger:"item",triggerOn:"mousemove"}}),t.setAttribute("data-processed","true")}catch(e){t.className="vditor-reset--error",t.innerHTML="mindmap render error: <br>"+e}}})})}},198:(e,t,n)=>{"use strict";n.d(t,{k:()=>r});var s=n(615),d=n(323),r=function(i,o,a){var r="",l=[];if(Array.from(i.children).forEach(function(e,t){var n;(0,s.W)(e)&&(a&&(n=e.id.lastIndexOf("_"),e.id=e.id.substring(0,-1===n?void 0:n)+"_"+t),l.push(e.id),r+=e.outerHTML.replace("<wbr>",""))}),""===r)return o.innerHTML="";var e=document.createElement("div");a?(a.lute.SetToC(!0),"wysiwyg"!==a.currentMode||a.preview.element.contains(i)?"ir"!==a.currentMode||a.preview.element.contains(i)?e.innerHTML=a.lute.HTML2VditorDOM("<p>[ToC]</p>"+r):e.innerHTML=a.lute.SpinVditorIRDOM("<p>[ToC]</p>"+r):e.innerHTML=a.lute.SpinVditorDOM("<p>[ToC]</p>"+r),a.lute.SetToC(a.options.preview.markdown.toc)):(o.classList.add("vditor-outline"),(t=Lute.New()).SetToC(!0),e.innerHTML=t.HTML2VditorDOM("<p>[ToC]</p>"+r));var t=e.firstElementChild.querySelectorAll("li > span[data-target-id]");return t.forEach(function(e,t){e.nextElementSibling&&"UL"===e.nextElementSibling.tagName?e.innerHTML="<svg class='vditor-outline__action'><use xlink:href='#vditor-icon-down'></use></svg><span>"+e.innerHTML+"</span>":e.innerHTML="<svg></svg><span>"+e.innerHTML+"</span>",e.setAttribute("data-target-id",l[t])}),r=e.firstElementChild.innerHTML,0===t.length?o.innerHTML="":(o.innerHTML=r,a&&(0,d.H)(o,{cdn:a.options.cdn,math:a.options.preview.math}),o.firstElementChild.addEventListener("click",function(e){for(var t=e.target;t&&!t.isEqualNode(o);){if(t.classList.contains("vditor-outline__action")){t.classList.contains("vditor-outline__action--close")?(t.classList.remove("vditor-outline__action--close"),t.parentElement.nextElementSibling.setAttribute("style","display:block")):(t.classList.add("vditor-outline__action--close"),t.parentElement.nextElementSibling.setAttribute("style","display:none")),e.preventDefault(),e.stopPropagation();break}if(t.getAttribute("data-target-id")){e.preventDefault(),e.stopPropagation();var n,r=document.getElementById(t.getAttribute("data-target-id"));if(!r)return;a?"auto"===a.options.height?(n=r.offsetTop+a.element.offsetTop,a.options.toolbarConfig.pin||(n+=a.toolbar.element.offsetHeight),window.scrollTo(window.scrollX,n)):(a.element.offsetTop<window.scrollY&&window.scrollTo(window.scrollX,a.element.offsetTop),a.preview.element.contains(i)?i.parentElement.scrollTop=r.offsetTop:i.scrollTop=r.offsetTop):window.scrollTo(window.scrollX,r.offsetTop);break}t=t.parentElement}})),r}},583:(e,t,n)=>{"use strict";n.d(t,{B:()=>a});var r=n(260),i=n(228),o=n(46),a=function(e,t){void 0===e&&(e=document),void 0===t&&(t=r.g.CDN);var n=o.plantumlRenderAdapter.getElements(e);0!==n.length&&(0,i.G)(t+"/js/plantuml/plantuml-encoder.min.js","vditorPlantumlScript").then(function(){n.forEach(function(t){if(!t.parentElement.classList.contains("vditor-wysiwyg__pre")&&!t.parentElement.classList.contains("vditor-ir__marker--pre")){var e=o.plantumlRenderAdapter.getCode(t).trim();if(e)try{t.innerHTML='<img src="http://www.plantuml.com/plantuml/svg/~1'+plantumlEncoder.encode(e)+'">'}catch(e){t.className="vditor-reset--error",t.innerHTML="plantuml render error: <br>"+e}}})})}},792:(e,t,n)=>{"use strict";n.d(t,{X:()=>r});var r=function(e){var t=Lute.New();return t.PutEmojis(e.emojis),t.SetEmojiSite(e.emojiSite),t.SetHeadingAnchor(e.headingAnchor),t.SetInlineMathAllowDigitAfterOpenMarker(e.inlineMathDigit),t.SetAutoSpace(e.autoSpace),t.SetToC(e.toc),t.SetFootnotes(e.footnotes),t.SetFixTermTypo(e.fixTermTypo),t.SetVditorCodeBlockPreview(e.codeBlockPreview),t.SetVditorMathBlockPreview(e.mathBlockPreview),t.SetSanitize(e.sanitize),t.SetChineseParagraphBeginningSpace(e.paragraphBeginningSpace),t.SetRenderListStyle(e.listStyle),t.SetLinkBase(e.linkBase),t.SetLinkPrefix(e.linkPrefix),t.SetMark(e.mark),e.lazyLoadImage&&t.SetImageLazyLoading(e.lazyLoadImage),t}},264:(e,t,n)=>{"use strict";n.d(t,{E:()=>r});var r=function(t,e,n){void 0===e&&(e="zh_CN"),void 0===n&&(n="classic");e=t.getBoundingClientRect();document.body.insertAdjacentHTML("beforeend",'<div class="vditor vditor-img'+("dark"===n?" vditor--dark":"")+'">\n    <div class="vditor-img__bar">\n      <span class="vditor-img__btn" data-deg="0">\n        <svg><use xlink:href="#vditor-icon-redo"></use></svg>\n        '+window.VditorI18n.spin+"\n      </span>\n      <span class=\"vditor-img__btn\"  onclick=\"this.parentElement.parentElement.outerHTML = '';document.body.style.overflow = ''\">\n        X &nbsp;"+window.VditorI18n.close+'\n      </span>\n    </div>\n    <div class="vditor-img__img" onclick="this.parentElement.outerHTML = \'\';document.body.style.overflow = \'\'">\n      <img style="width: '+t.width+"px;height:"+t.height+"px;transform: translate3d("+e.left+"px, "+(e.top-36)+'px, 0)" src="'+t.getAttribute("src")+'">\n    </div>\n</div>'),document.body.style.overflow="hidden";var r=document.querySelector(".vditor-img img"),i="translate3d("+Math.max(0,window.innerWidth-t.naturalWidth)/2+"px, "+Math.max(0,window.innerHeight-36-t.naturalHeight)/2+"px, 0)";setTimeout(function(){r.setAttribute("style","transition: transform .3s ease-in-out;transform: "+i),setTimeout(function(){r.parentElement.scrollTo((r.parentElement.scrollWidth-r.parentElement.clientWidth)/2,(r.parentElement.scrollHeight-r.parentElement.clientHeight)/2)},400)});var o=document.querySelector(".vditor-img__btn");o.addEventListener("click",function(){var e=parseInt(o.getAttribute("data-deg"),10)+90;e/90%2==1&&t.naturalWidth>r.parentElement.clientHeight?r.style.transform="translate3d("+Math.max(0,window.innerWidth-t.naturalWidth)/2+"px, "+(t.naturalWidth/2-t.naturalHeight/2)+"px, 0) rotateZ("+e+"deg)":r.style.transform=i+" rotateZ("+e+"deg)",o.setAttribute("data-deg",e.toString()),setTimeout(function(){r.parentElement.scrollTo((r.parentElement.scrollWidth-r.parentElement.clientWidth)/2,(r.parentElement.scrollHeight-r.parentElement.clientHeight)/2)},400)})}},968:(e,t,n)=>{"use strict";n.d(t,{Y:()=>o});var r=n(260),i=n(946),o=function(e,t){void 0===t&&(t=r.g.CDN),r.g.CODE_THEME.includes(e)||(e="github");var n=document.getElementById("vditorHljsStyle"),e=t+"/js/highlight.js/styles/"+e+".css";n?n.href!==e&&(n.remove(),(0,i.c)(e,"vditorHljsStyle")):(0,i.c)(e,"vditorHljsStyle")}},958:(e,t,n)=>{"use strict";n.d(t,{Z:()=>i});var r=n(946),i=function(e,t){e&&t&&(t=t+"/"+e+".css",(e=document.getElementById("vditorContentTheme"))?e.href!==t&&(e.remove(),(0,r.c)(t,"vditorContentTheme")):(0,r.c)(t,"vditorContentTheme"))}},228:(e,t,n)=>{"use strict";n.d(t,{J:()=>r,G:()=>i});var r=function(e,t){if(document.getElementById(t))return!1;var n=new XMLHttpRequest;n.open("GET",e,!1),n.setRequestHeader("Accept","text/javascript, application/javascript, application/ecmascript, application/x-ecmascript, */*; q=0.01"),n.send("");e=document.createElement("script");e.type="text/javascript",e.text=n.responseText,e.id=t,document.head.appendChild(e)},i=function(r,i){return new Promise(function(e,t){if(document.getElementById(i))return e(),!1;var n=document.createElement("script");n.src=r,n.async=!0,document.head.appendChild(n),n.onload=function(){if(document.getElementById(i))return n.remove(),e(),!1;n.id=i,e()}})}},946:(e,t,n)=>{"use strict";n.d(t,{c:()=>r});var r=function(e,t){var n;document.getElementById(t)||((n=document.createElement("link")).id=t,n.rel="stylesheet",n.type="text/css",n.href=e,document.getElementsByTagName("head")[0].appendChild(n))}},769:(e,t,n)=>{"use strict";n.d(t,{X:()=>r});var r=function(e){return e.replace(/\u00a0/g," ")}},931:(e,t,n)=>{"use strict";n.d(t,{G6:()=>r,vU:()=>i,pK:()=>o,Le:()=>a,yl:()=>l,ns:()=>s,i7:()=>d});var r=function(){return-1<navigator.userAgent.indexOf("Safari")&&-1===navigator.userAgent.indexOf("Chrome")},i=function(){return-1<navigator.userAgent.toLowerCase().indexOf("firefox")},o=function(){try{return"undefined"!=typeof localStorage}catch(e){return!1}},a=function(){return-1<navigator.userAgent.indexOf("iPhone")?"touchstart":"click"},l=function(e){return 0<=navigator.platform.toUpperCase().indexOf("MAC")?!(!e.metaKey||e.ctrlKey):!(e.metaKey||!e.ctrlKey)},s=function(e){return/Mac/.test(navigator.platform)||"iPhone"===navigator.platform?-1<e.indexOf("⇧")&&i()&&(e=e.replace(";",":").replace("=","+").replace("-","_")):-1<(e=(e=e.startsWith("⌘")?e.replace("⌘","⌘+"):e.startsWith("⌥")&&"⌘"!==e.substr(1,1)?e.replace("⌥","⌥+"):e.replace("⇧⌘","⌘+⇧+").replace("⌥⌘","⌥+⌘+")).replace("⌘","Ctrl").replace("⇧","Shift").replace("⌥","Alt")).indexOf("Shift")&&(e=e.replace(";",":").replace("=","+").replace("-","_")),e},d=function(){return/Chrome/.test(navigator.userAgent)&&/Google Inc/.test(navigator.vendor)}},713:(e,t,n)=>{"use strict";n.d(t,{JQ:()=>r,E2:()=>i,O9:()=>a,a1:()=>l,F9:()=>s,lG:()=>d,fb:()=>c,DX:()=>u});var o=n(615),r=function(e,t){for(var n,r=c(e,t),i=!1;r&&!r.classList.contains("vditor-reset")&&!i;)(n=c(r.parentElement,t))?r=n:i=!0;return r||!1},i=function(e,t){for(var n,r=(0,o.S)(e,t),i=!1;r&&!r.classList.contains("vditor-reset")&&!i;)(n=(0,o.S)(r.parentElement,t))?r=n:i=!0;return r||!1},a=function(e){var t=i(e,"UL"),n=i(e,"OL"),e=t;return e=n&&(!t||n.contains(t))?n:e},l=function(e,t,n){if(!e)return!1;for(var r=e=3===e.nodeType?e.parentElement:e,i=!1;r&&!i&&!r.classList.contains("vditor-reset");)r.getAttribute(t)===n?i=!0:r=r.parentElement;return i&&r},s=function(e){if(!e)return!1;var t=e=3===e.nodeType?e.parentElement:e,n=!1,e=l(e,"data-block","0");if(e)return e;for(;t&&!n&&!t.classList.contains("vditor-reset");)"H1"===t.tagName||"H2"===t.tagName||"H3"===t.tagName||"H4"===t.tagName||"H5"===t.tagName||"H6"===t.tagName||"P"===t.tagName||"BLOCKQUOTE"===t.tagName||"OL"===t.tagName||"UL"===t.tagName?n=!0:t=t.parentElement;return n&&t},d=function(e,t){if(!e)return!1;for(var n=e=3===e.nodeType?e.parentElement:e,r=!1;n&&!r&&!n.classList.contains("vditor-reset");)n.nodeName===t?r=!0:n=n.parentElement;return r&&n},c=function(e,t){if(!e)return!1;for(var n=e=3===e.nodeType?e.parentElement:e,r=!1;n&&!r&&!n.classList.contains("vditor-reset");)n.classList.contains(t)?r=!0:n=n.parentElement;return r&&n},u=function(e){for(;e&&e.lastChild;)e=e.lastChild;return e}},615:(e,t,n)=>{"use strict";n.d(t,{S:()=>r,W:()=>i});var r=function(e,t){if(!e)return!1;for(var n=e=3===e.nodeType?e.parentElement:e,r=!1;n&&!r&&!n.classList.contains("vditor-reset");)0===n.nodeName.indexOf(t)?r=!0:n=n.parentElement;return r&&n},i=function(e){e=r(e,"H");return!(!e||2!==e.tagName.length||"HR"===e.tagName)&&e}},224:(e,t,n)=>{"use strict";n.d(t,{T:()=>i});var i=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];for(var n={},r=0;r<e.length;r++)!function(e){for(var t in e)e.hasOwnProperty(t)&&("[object Object]"===Object.prototype.toString.call(e[t])?n[t]=i(n[t],e[t]):n[t]=e[t])}(e[r]);return n}},187:(e,t,n)=>{"use strict";n.d(t,{zh:()=>a,Ny:()=>l,Gb:()=>s,Hc:()=>c,im:()=>d,$j:()=>u,ib:()=>p,oC:()=>m});var r=n(260),i=n(931),o=n(713),a=function(e){var t,n=e[e.currentMode].element;return 0<getSelection().rangeCount&&(t=getSelection().getRangeAt(0),n.isEqualNode(t.startContainer)||n.contains(t.startContainer))?t:e[e.currentMode].range||(n.focus(),(t=n.ownerDocument.createRange()).setStart(n,0),t.collapse(!0),t)},l=function(e){var t=window.getSelection().getRangeAt(0);if(!e.contains(t.startContainer)&&!(0,o.fb)(t.startContainer,"vditor-panel--none"))return{left:0,top:0};var n,e=e.parentElement.getBoundingClientRect();if(0===t.getClientRects().length)if(3===t.startContainer.nodeType){var r=t.startContainer.parentElement;if(!(r&&0<r.getClientRects().length))return{left:0,top:0};n=r.getClientRects()[0]}else{r=t.startContainer.children;if(r[t.startOffset]&&0<r[t.startOffset].getClientRects().length?n=r[t.startOffset].getClientRects()[0]:0<t.startContainer.childNodes.length?(r=t.cloneRange(),t.selectNode(t.startContainer.childNodes[Math.max(0,t.startOffset-1)]),n=t.getClientRects()[0],t.setEnd(r.endContainer,r.endOffset),t.setStart(r.startContainer,r.startOffset)):n=t.startContainer.getClientRects()[0],!n){for(var i=t.startContainer.childNodes[t.startOffset];!i.getClientRects||i.getClientRects&&0===i.getClientRects().length;)i=i.parentElement;n=i.getClientRects()[0]}}else n=t.getClientRects()[0];return{left:n.left-e.left,top:n.top-e.top}},s=function(e,t){if(!t){if(0===getSelection().rangeCount)return!1;t=getSelection().getRangeAt(0)}t=t.commonAncestorContainer;return e.isEqualNode(t)||e.contains(t)},c=function(e){var t=window.getSelection();t.removeAllRanges(),t.addRange(e)},d=function(e,t,n){var r={end:0,start:0};if(!n){if(0===getSelection().rangeCount)return r;n=window.getSelection().getRangeAt(0)}return s(t,n)&&(t=n.cloneRange(),e.childNodes[0]&&e.childNodes[0].childNodes[0]?t.setStart(e.childNodes[0].childNodes[0],0):t.selectNodeContents(e),t.setEnd(n.startContainer,n.startOffset),r.start=t.toString().length,r.end=r.start+n.toString().length),r},u=function(e,t,n){var r=0,i=0,o=n.childNodes[i],a=!1,l=!1;e=Math.max(0,e),t=Math.max(0,t);var s=n.ownerDocument.createRange();for(s.setStart(o||n,0),s.collapse(!0);!l&&o;){var d=r+o.textContent.length;if(!a&&r<=e&&e<=d&&(0===e?s.setStart(o,0):3===o.childNodes[0].nodeType?s.setStart(o.childNodes[0],e-r):o.nextSibling?s.setStartBefore(o.nextSibling):s.setStartAfter(o),a=!0,e===t)){l=!0;break}a&&r<=t&&t<=d&&(0===t?s.setEnd(o,0):3===o.childNodes[0].nodeType?s.setEnd(o.childNodes[0],t-r):o.nextSibling?s.setEndBefore(o.nextSibling):s.setEndAfter(o),l=!0),r=d,o=n.childNodes[++i]}return!l&&n.childNodes[i-1]&&s.setStartBefore(n.childNodes[i-1]),c(s),s},p=function(e,t){e=e.querySelector("wbr");if(e){if(e.previousElementSibling)if(e.previousElementSibling.isSameNode(e.previousSibling)){if(e.previousElementSibling.lastChild)return t.setStartBefore(e),t.collapse(!0),c(t),!(0,i.i7)()||"EM"!==e.previousElementSibling.tagName&&"STRONG"!==e.previousElementSibling.tagName&&"S"!==e.previousElementSibling.tagName||(t.insertNode(document.createTextNode(r.g.ZWSP)),t.collapse(!1)),void e.remove();t.setStartAfter(e.previousElementSibling)}else t.setStart(e.previousSibling,e.previousSibling.textContent.length);else e.previousSibling?t.setStart(e.previousSibling,e.previousSibling.textContent.length):e.nextSibling?3===e.nextSibling.nodeType?t.setStart(e.nextSibling,0):t.setStartBefore(e.nextSibling):t.setStart(e.parentElement,0);t.collapse(!0),e.remove(),c(t)}},m=function(e,t){var n=document.createElement("div");n.innerHTML=e;var r=n.querySelectorAll("p");1===r.length&&!r[0].previousSibling&&!r[0].nextSibling&&0<t[t.currentMode].element.children.length&&"P"===n.firstElementChild.tagName&&(e=r[0].innerHTML.trim());var i=document.createElement("div");i.innerHTML=e;n=a(t);""!==n.toString()&&(t[t.currentMode].preventInput=!0,document.execCommand("delete",!1,"")),i.firstElementChild&&"0"===i.firstElementChild.getAttribute("data-block")?(i.lastElementChild.insertAdjacentHTML("beforeend","<wbr>"),(r=(0,o.F9)(n.startContainer))?r.insertAdjacentHTML("afterend",i.innerHTML):t[t.currentMode].element.insertAdjacentHTML("beforeend",i.innerHTML),p(t[t.currentMode].element,n)):((t=document.createElement("template")).innerHTML=e,n.insertNode(t.content.cloneNode(!0)),n.collapse(!1),c(n))}}},r={};function Zr(e){var t=r[e];if(void 0!==t)return t.exports;t=r[e]={exports:{}};return n[e](t,t.exports,Zr),t.exports}Zr.d=(e,t)=>{for(var n in t)Zr.o(t,n)&&!Zr.o(e,n)&&Object.defineProperty(e,n,{enumerable:!0,get:t[n]})},Zr.o=(e,t)=>Object.prototype.hasOwnProperty.call(e,t),Zr.r=e=>{"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})};var Jr={};return(()=>{"use strict";Zr.d(Jr,{default:()=>Fr});Zr(157);var e=Zr(857),D=Zr(260),o=Zr(769),a=function(e){return"sv"===e.currentMode?(0,o.X)((e.sv.element.textContent+"\n").replace(/\n\n$/,"\n")):"wysiwyg"===e.currentMode?e.lute.VditorDOM2Md(e.wysiwyg.element.innerHTML):"ir"===e.currentMode?e.lute.VditorIRDOM2Md(e.ir.element.innerHTML):""},i=Zr(228),r=(t.prototype.renderEchart=function(e){var t=this;"block"===e.devtools.element.style.display&&(0,i.G)(e.options.cdn+"/js/echarts/echarts.min.js","vditorEchartsScript").then(function(){t.ASTChart||(t.ASTChart=echarts.init(e.devtools.element.lastElementChild));try{t.element.lastElementChild.style.display="block",t.element.firstElementChild.innerHTML="",t.ASTChart.setOption({series:[{data:JSON.parse(e.lute.RenderEChartsJSON(a(e))),initialTreeDepth:-1,label:{align:"left",backgroundColor:"rgba(68, 77, 86, .68)",borderRadius:3,color:"#d1d5da",fontSize:12,lineHeight:12,offset:[9,12],padding:[2,4,2,4],position:"top",verticalAlign:"middle"},lineStyle:{color:"#4285f4",type:"curve",width:1},orient:"vertical",roam:!0,type:"tree"}],toolbox:{bottom:25,emphasis:{iconStyle:{color:"#4285f4"}},feature:{restore:{show:!0},saveAsImage:{show:!0}},right:15,show:!0}}),t.ASTChart.resize()}catch(e){t.element.lastElementChild.style.display="none",t.element.firstElementChild.innerHTML=e}})},t);function t(){this.element=document.createElement("div"),this.element.className="vditor-devtools",this.element.innerHTML='<div class="vditor-reset--error"></div><div style="height: 100%;"></div>'}function O(t,e){e.forEach(function(e){!t[e]||(e=t[e].children[0])&&e.classList.contains(D.g.CLASS_MENU_DISABLED)&&e.classList.remove(D.g.CLASS_MENU_DISABLED)})}function I(t,e){e.forEach(function(e){!t[e]||(e=t[e].children[0])&&!e.classList.contains(D.g.CLASS_MENU_DISABLED)&&e.classList.add(D.g.CLASS_MENU_DISABLED)})}function l(t,e){e.forEach(function(e){t[e]&&t[e]&&(t[e].style.display="none")})}function s(t,e){e.forEach(function(e){t[e]&&t[e]&&(t[e].style.display="block")})}function d(t,n,r,e){r.addEventListener((0,B.Le)(),function(e){e.preventDefault(),e.stopPropagation(),r.classList.contains(D.g.CLASS_MENU_DISABLED)||(t.toolbar.element.querySelectorAll(".vditor-hint--current").forEach(function(e){e.classList.remove("vditor-hint--current")}),"block"===n.style.display?n.style.display="none":(L(t,["subToolbar","hint","popover"],r.parentElement.parentElement),r.classList.contains("vditor-tooltipped")||r.classList.add("vditor-hint--current"),n.style.display="block",t.toolbar.element.getBoundingClientRect().right-r.getBoundingClientRect().right<250?n.classList.add("vditor-panel--left"):n.classList.remove("vditor-panel--left")))})}function v(e,t,n,r){r&&console.log(e+" - "+n+": "+t)}function g(t){var e,n;"sv"!==t.currentMode&&(e=t[t.currentMode].element,""===(n=t.outline.render(t))&&(n="[ToC]"),e.querySelectorAll('[data-type="toc-block"]').forEach(function(e){e.innerHTML=n,(0,N.H)(e,{cdn:t.options.cdn,math:t.options.preview.math})}))}function c(e,t){var n=(0,U.lG)(e.target,"SPAN");n&&(0,U.fb)(n,"vditor-toc")&&((e=t[t.currentMode].element.querySelector("#"+n.getAttribute("data-target-id")))&&("auto"===t.options.height?(n=e.offsetTop+t.element.offsetTop,t.options.toolbarConfig.pin||(n+=t.toolbar.element.offsetHeight),window.scrollTo(window.scrollX,n)):(t.element.offsetTop<window.scrollY&&window.scrollTo(window.scrollX,t.element.offsetTop),t[t.currentMode].element.scrollTop=e.offsetTop)))}function m(e,t,n,r){if(e.previousElementSibling&&e.previousElementSibling.classList.contains("vditor-toc")){if("Backspace"===n.key&&0===(0,Z.im)(e,t[t.currentMode].element,r).start)return e.previousElementSibling.remove(),wt(t),1;if(mt(t,n,r,e,e.previousElementSibling))return 1}if(e.nextElementSibling&&e.nextElementSibling.classList.contains("vditor-toc")){if("Delete"===n.key&&(0,Z.im)(e,t[t.currentMode].element,r).start>=e.textContent.trimRight().length)return e.nextElementSibling.remove(),wt(t),1;if(pt(t,n,r,e,e.nextElementSibling))return 1}if("Backspace"===n.key||"Delete"===n.key){r=(0,U.fb)(r.startContainer,"vditor-toc");if(r)return r.remove(),wt(t),1}}function u(e,t){t.ir.element.querySelectorAll(".vditor-ir__node--expand").forEach(function(e){e.classList.remove("vditor-ir__node--expand")});var n=(0,U.JQ)(e.startContainer,"vditor-ir__node"),t=!e.collapsed&&(0,U.JQ)(e.endContainer,"vditor-ir__node");if(e.collapsed||n&&n===t){n&&(n.classList.add("vditor-ir__node--expand"),n.classList.remove("vditor-ir__node--hidden"),(0,Z.Hc)(e));t=function(e){var t=e.startContainer;if(3===t.nodeType&&t.nodeValue.length!==e.startOffset)return!1;for(var n=t.nextSibling;n&&""===n.textContent;)n=n.nextSibling;if(n)return!(3===n.nodeType||!n.classList.contains("vditor-ir__node")||n.getAttribute("data-block"))&&n;e=(0,U.fb)(t,"vditor-ir__marker");if(e&&!e.nextSibling){t=t.parentElement.parentElement.nextSibling;if(t&&3!==t.nodeType&&t.classList.contains("vditor-ir__node"))return t}return!1}(e);if(t)return t.classList.add("vditor-ir__node--expand"),t.classList.remove("vditor-ir__node--hidden"),0;e=(t=(n=e).startContainer,e=t.previousSibling,!(3!==t.nodeType||0!==n.startOffset||!e||3===e.nodeType||!e.classList.contains("vditor-ir__node")||e.getAttribute("data-block"))&&e);e&&(e.classList.add("vditor-ir__node--expand"),e.classList.remove("vditor-ir__node--hidden"))}}function p(e,t){var n=getSelection().getRangeAt(0).cloneRange(),r=n.startContainer;3!==n.startContainer.nodeType&&"DIV"===n.startContainer.tagName&&(r=n.startContainer.childNodes[n.startOffset-1]);var i,o,a,l=(0,U.a1)(r,"data-block","0");if(l&&t&&("deleteContentBackward"===t.inputType||" "===t.data)){for(var s=(0,Z.im)(l,e.sv.element,n).start,d=!0,c=s-1;c>l.textContent.substr(0,s).lastIndexOf("\n");c--)if(" "!==l.textContent.charAt(c)&&"\t"!==l.textContent.charAt(c)){d=!1;break}if(d=0===s?!1:d)return Xe(e),0;if("deleteContentBackward"===t.inputType){var u,p=(0,U.a1)(r,"data-type","code-block-open-marker")||(0,U.a1)(r,"data-type","code-block-close-marker");if(p){if("code-block-close-marker"===p.getAttribute("data-type"))if(u=Ze(r,"code-block-open-marker"))return u.textContent=p.textContent,Xe(e),0;if("code-block-open-marker"===p.getAttribute("data-type"))if(u=Ze(r,"code-block-close-marker",!1))return u.textContent=p.textContent,Xe(e),0}p=(0,U.a1)(r,"data-type","math-block-open-marker");if(p){var m=p.nextElementSibling.nextElementSibling;return m&&"math-block-close-marker"===m.getAttribute("data-type")&&(m.remove(),Xe(e)),0}l.querySelectorAll('[data-type="code-block-open-marker"]').forEach(function(e){1===e.textContent.length&&e.remove()}),l.querySelectorAll('[data-type="code-block-close-marker"]').forEach(function(e){1===e.textContent.length&&e.remove()});m=(0,U.a1)(r,"data-type","heading-marker");if(m&&-1===m.textContent.indexOf("#"))return Xe(e),0}if((" "===t.data||"deleteContentBackward"===t.inputType)&&((0,U.a1)(r,"data-type","padding")||(0,U.a1)(r,"data-type","li-marker")||(0,U.a1)(r,"data-type","task-marker")||(0,U.a1)(r,"data-type","blockquote-marker")))return Xe(e),0}l&&"$$"===l.textContent.trimRight()?Xe(e):("link-ref-defs-block"===(null===(t=(l=l||e.sv.element).firstElementChild)||void 0===t?void 0:t.getAttribute("data-type"))&&(l=e.sv.element),-1===(l=(0,U.a1)(r,"data-type","footnotes-link")?e.sv.element:l).textContent.indexOf(Lute.Caret)&&n.insertNode(document.createTextNode(Lute.Caret)),l.querySelectorAll("[style]").forEach(function(e){e.removeAttribute("style")}),l.querySelectorAll("font").forEach(function(e){e.outerHTML=e.innerHTML}),i=l.textContent,(r=l.isEqualNode(e.sv.element))?i=l.textContent:(l.previousElementSibling&&(i=l.previousElementSibling.textContent+i,l.previousElementSibling.remove()),l.previousElementSibling&&0===i.indexOf("---\n")&&(i=l.previousElementSibling.textContent+i,l.previousElementSibling.remove()),e.sv.element.querySelectorAll("[data-type='link-ref-defs-block']").forEach(function(e,t){0===t&&e&&!l.isEqualNode(e.parentElement)&&(i+="\n"+e.parentElement.textContent,e.parentElement.remove())}),e.sv.element.querySelectorAll("[data-type='footnotes-link']").forEach(function(e,t){0===t&&e&&!l.isEqualNode(e.parentElement)&&(i+="\n"+e.parentElement.textContent,e.parentElement.remove())})),i=Je(i,e),r?l.innerHTML=i:l.outerHTML=i,(r=e.sv.element.querySelectorAll("[data-type='link-ref-defs-block']")).forEach(function(e,t){0===t?o=e.parentElement:(o.lastElementChild.remove(),o.insertAdjacentHTML("beforeend",""+e.parentElement.innerHTML),e.parentElement.remove())}),0<r.length&&e.sv.element.insertAdjacentElement("beforeend",o),(r=e.sv.element.querySelectorAll("[data-type='footnotes-link']")).forEach(function(e,t){0===t?a=e.parentElement:(a.lastElementChild.remove(),a.insertAdjacentHTML("beforeend",""+e.parentElement.innerHTML),e.parentElement.remove())}),0<r.length&&e.sv.element.insertAdjacentElement("beforeend",a),(0,Z.ib)(e.sv.element,n),Fe(e),Xe(e,{enableAddUndoStack:!0,enableHint:!0,enableInput:!0}))}function f(e){"dark"===e.options.theme?e.element.classList.add("vditor--dark"):e.element.classList.remove("vditor--dark")}function h(t){t.element.innerHTML="",t.element.classList.add("vditor"),f(t),(0,ee.Z)(t.options.preview.theme.current,t.options.preview.theme.path),"number"==typeof t.options.height&&(t.element.style.height=t.options.height+"px"),"number"==typeof t.options.minHeight&&(t.element.style.minHeight=t.options.minHeight+"px"),"number"==typeof t.options.width?t.element.style.width=t.options.width+"px":t.element.style.width=t.options.width,t.element.appendChild(t.toolbar.element);var n,e=document.createElement("div");e.className="vditor-content","left"===t.options.outline.position&&e.appendChild(t.outline.element),e.appendChild(t.wysiwyg.element.parentElement),e.appendChild(t.sv.element),e.appendChild(t.ir.element.parentElement),e.appendChild(t.preview.element),t.toolbar.elements.devtools&&e.appendChild(t.devtools.element),"right"===t.options.outline.position&&(t.outline.element.classList.add("vditor-outline--right"),e.appendChild(t.outline.element)),t.upload&&e.appendChild(t.upload.element),t.options.resize.enable&&e.appendChild(t.resize.element),e.appendChild(t.hint.element),e.appendChild(t.tip.element),t.element.appendChild(e),t.toolbar.elements.export&&t.element.insertAdjacentHTML("beforeend",'<iframe style="width: 100%;height: 0;border: 0"></iframe>'),ge(t,t.options.mode,function(e){ne(e),window.addEventListener("resize",function(){te(e);ne(e)});var t=(0,B.pK)()&&localStorage.getItem(e.options.cache.id);if(!e.options.cache.enable||!t)if(e.options.value)t=e.options.value;else if(e.originalInnerHTML)t=e.lute.HTML2Md(e.originalInnerHTML);else if(!e.options.cache.enable)t="";return t||""}(t)),document.execCommand("DefaultParagraphSeparator",!1,"p"),-1<navigator.userAgent.indexOf("iPhone")&&void 0!==window.visualViewport&&(n=!1,e=function(e){n||(n=!0,requestAnimationFrame(function(){n=!1;var e=t.toolbar.element;e.style.transform="none",e.getBoundingClientRect().top<0&&(e.style.transform="translate(0, "+-e.getBoundingClientRect().top+"px)")}))},window.visualViewport.addEventListener("scroll",e),window.visualViewport.addEventListener("resize",e))}function b(e){for(var t="",n=e.nextSibling;n;)3===n.nodeType?t+=n.textContent:t+=n.outerHTML,n=n.nextSibling;return t}function w(e){for(var t="",n=e.previousSibling;n;)t=3===n.nodeType?n.textContent+t:n.outerHTML+t,n=n.previousSibling;return t}function y(r,i){Array.from(r.wysiwyg.element.childNodes).find(function(e){if(3===e.nodeType){var t=document.createElement("p");t.setAttribute("data-block","0"),t.textContent=e.textContent;var n=3===i.startContainer.nodeType?i.startOffset:e.textContent.length;return e.parentNode.insertBefore(t,e),e.remove(),i.setStart(t.firstChild,Math.min(t.firstChild.textContent.length,n)),i.collapse(!0),(0,Z.Hc)(i),!0}if(!e.getAttribute("data-block"))return"P"===e.tagName?e.remove():("DIV"===e.tagName?(i.insertNode(document.createElement("wbr")),e.outerHTML='<p data-block="0">'+e.innerHTML+"</p>"):"BR"===e.tagName?e.outerHTML='<p data-block="0">'+e.outerHTML+"<wbr></p>":(i.insertNode(document.createElement("wbr")),e.outerHTML='<p data-block="0">'+e.outerHTML+"</p>"),(0,Z.ib)(r.wysiwyg.element,i),i=getSelection().getRangeAt(0)),!0})}function E(e,t,n){void 0===n&&(n=!0);var r=e.previousElementSibling,i=r.ownerDocument.createRange();"CODE"===r.tagName?(r.style.display="inline-block",n?i.setStart(r.firstChild,1):i.selectNodeContents(r)):(r.style.display="block",r.firstChild.firstChild||r.firstChild.appendChild(document.createTextNode("")),i.selectNodeContents(r.firstChild)),n?i.collapse(!0):i.collapse(!1),(0,Z.Hc)(i),e.firstElementChild.classList.contains("language-mindmap")||Fe(t)}function j(t,n){function e(){""!==i.value.trim()&&("IMG"===n.tagName?n.setAttribute("alt",i.value):n.textContent=i.value),""!==a.value.trim()&&n.setAttribute("data-link-label",a.value)}t.wysiwyg.popover.innerHTML="";var r=document.createElement("span");r.setAttribute("aria-label",window.VditorI18n.textIsNotEmpty),r.className="vditor-tooltipped vditor-tooltipped__n";var i=document.createElement("input");r.appendChild(i),i.className="vditor-input",i.setAttribute("placeholder",window.VditorI18n.textIsNotEmpty),i.style.width="120px",i.value=n.getAttribute("alt")||n.textContent,i.oninput=function(){e()},i.onkeydown=function(e){se(t,e)||pe(t,n,e,a)};var o=document.createElement("span");o.setAttribute("aria-label",window.VditorI18n.linkRef),o.className="vditor-tooltipped vditor-tooltipped__n";var a=document.createElement("input");o.appendChild(a),a.className="vditor-input",a.setAttribute("placeholder",window.VditorI18n.linkRef),a.value=n.getAttribute("data-link-label"),a.oninput=function(){e()},a.onkeydown=function(e){se(t,e)||pe(t,n,e,i)},ue(n,t),t.wysiwyg.popover.insertAdjacentElement("beforeend",r),t.wysiwyg.popover.insertAdjacentElement("beforeend",o),ce(t,n)}function R(e,t,n){var r,i=t.previousElementSibling;i&&(t.parentElement.isEqualNode(n.wysiwyg.element)||"LI"===t.tagName)&&((r=document.createElement("button")).setAttribute("type","button"),r.setAttribute("data-type","up"),r.setAttribute("aria-label",window.VditorI18n.up+"<"+(0,B.ns)("⇧⌘U")+">"),r.innerHTML='<svg><use xlink:href="#vditor-icon-up"></use></svg>',r.className="vditor-icon vditor-tooltipped vditor-tooltipped__n",r.onclick=function(){e.insertNode(document.createElement("wbr")),i.insertAdjacentElement("beforebegin",t),(0,Z.ib)(n.wysiwyg.element,e),ie(n),de(n),Fe(n)},n.wysiwyg.popover.insertAdjacentElement("beforeend",r))}function P(e,t,n){var r,i=t.nextElementSibling;i&&(t.parentElement.isEqualNode(n.wysiwyg.element)||"LI"===t.tagName)&&((r=document.createElement("button")).setAttribute("type","button"),r.setAttribute("data-type","down"),r.setAttribute("aria-label",window.VditorI18n.down+"<"+(0,B.ns)("⇧⌘D")+">"),r.innerHTML='<svg><use xlink:href="#vditor-icon-down"></use></svg>',r.className="vditor-icon vditor-tooltipped vditor-tooltipped__n",r.onclick=function(){e.insertNode(document.createElement("wbr")),i.insertAdjacentElement("afterend",t),(0,Z.ib)(n.wysiwyg.element,e),ie(n),de(n),Fe(n)},n.wysiwyg.popover.insertAdjacentElement("beforeend",r))}function k(t,e,n){void 0===n&&(n={enableAddUndoStack:!0,enableHint:!1,enableInput:!0});var r=t.wysiwyg.element;r.innerHTML=t.lute.Md2VditorDOM(e),r.querySelectorAll(".vditor-wysiwyg__preview[data-render='2']").forEach(function(e){F(e,t),e.previousElementSibling.setAttribute("style","display:none")}),ie(t,n)}var S,C,B=Zr(931),q=function(t,e){e.forEach(function(e){!t[e]||(e=t[e].children[0])&&e.classList.contains("vditor-menu--current")&&e.classList.remove("vditor-menu--current")})},V=function(t,e){e.forEach(function(e){!t[e]||(e=t[e].children[0])&&!e.classList.contains("vditor-menu--current")&&e.classList.add("vditor-menu--current")})},L=function(e,t,n){t.includes("subToolbar")&&(e.toolbar.element.querySelectorAll(".vditor-hint").forEach(function(e){n&&e.isEqualNode(n)||(e.style.display="none")}),e.toolbar.elements.emoji&&(e.toolbar.elements.emoji.lastElementChild.style.display="none")),t.includes("hint")&&(e.hint.element.style.display="none"),e.wysiwyg.popover&&t.includes("popover")&&(e.wysiwyg.popover.style.display="none")},U=Zr(713),W=Zr(615),T=Zr(369),M=Zr(726),_=Zr(23),A=Zr(383),x=Zr(890),H=Zr(93),N=Zr(323),K=Zr(765),G=Zr(894),z=Zr(583),F=function(e,t){var n;e&&("html-block"!==e.parentElement.getAttribute("data-type")?(n=e.firstElementChild.className.replace("language-",""))&&("abc"===n?(0,T.Q)(e,t.options.cdn):"mermaid"===n?(0,K.i)(e,t.options.cdn,t.options.theme):"flowchart"===n?(0,A.P)(e,t.options.cdn):"echarts"===n?(0,M.p)(e,t.options.cdn,t.options.theme):"mindmap"===n?(0,G.P)(e,t.options.cdn,t.options.theme):"plantuml"===n?(0,z.B)(e,t.options.cdn):"graphviz"===n?(0,x.v)(e,t.options.cdn):"math"===n?(0,N.H)(e,{cdn:t.options.cdn,math:t.options.preview.math}):((0,H.s)(Object.assign({},t.options.preview.hljs),e,t.options.cdn),(0,_.O)(e)),e.setAttribute("data-render","1")):e.setAttribute("data-render","1"))},Z=Zr(187),J=function(t,e,n,r){void 0===n&&(n=!1);var i=(0,U.F9)(e.startContainer);if(i&&!n&&"code-block"!==i.getAttribute("data-type")){if(yt(i.innerHTML)&&i.previousElementSibling||bt(i.innerHTML))return;for(var o=(0,Z.im)(i,t.ir.element,e).start,a=!0,l=o-1;l>i.textContent.substr(0,o).lastIndexOf("\n");l--)if(" "!==i.textContent.charAt(l)&&"\t"!==i.textContent.charAt(l)){a=!1;break}0===o&&(a=!1);for(var s=!0,l=o-1;l<i.textContent.length;l++)if(" "!==i.textContent.charAt(l)&&"\n"!==i.textContent.charAt(l)){s=!1;break}if(a)return;if(s){var d=(0,U.fb)(e.startContainer,"vditor-ir__marker");if(!d){var c=e.startContainer.previousSibling;return void(c&&3!==c.nodeType&&c.classList.contains("vditor-ir__node--expand")&&c.classList.remove("vditor-ir__node--expand"))}}}t.ir.element.querySelectorAll(".vditor-ir__node--expand").forEach(function(e){e.classList.remove("vditor-ir__node--expand")}),(i=i||t.ir.element).querySelector("wbr")||((u=(0,U.fb)(e.startContainer,"vditor-ir__preview"))?u.previousElementSibling.insertAdjacentHTML("beforeend","<wbr>"):e.insertNode(document.createElement("wbr"))),i.querySelectorAll("[style]").forEach(function(e){e.removeAttribute("style")});var u,p,n=(i="link-ref-defs-block"===i.getAttribute("data-type")?t.ir.element:i).isEqualNode(t.ir.element),d=(0,U.a1)(i,"data-type","footnotes-block"),m="";n?m=i.innerHTML:(c=(0,W.S)(e.startContainer,"BLOCKQUOTE"),(u=(0,U.O9)(e.startContainer))&&(i=u),!c||u&&c.contains(u)||(i=c),m=(i=d?d:i).outerHTML,"UL"===i.tagName||"OL"===i.tagName?(u=i.previousElementSibling,c=i.nextElementSibling,!u||"UL"!==u.tagName&&"OL"!==u.tagName||(m=u.outerHTML+m,u.remove()),!c||"UL"!==c.tagName&&"OL"!==c.tagName||(m+=c.outerHTML,c.remove()),m=m.replace("<div><wbr><br></div>","<li><p><wbr><br></p></li>")):i.previousElementSibling&&""!==i.previousElementSibling.textContent.replace(D.g.ZWSP,"")&&r&&"insertParagraph"===r.inputType&&(m=i.previousElementSibling.outerHTML+m,i.previousElementSibling.remove()),t.ir.element.querySelectorAll("[data-type='link-ref-defs-block']").forEach(function(e){e&&!i.isEqualNode(e)&&(m+=e.outerHTML,e.remove())}),t.ir.element.querySelectorAll("[data-type='footnotes-block']").forEach(function(e){e&&!i.isEqualNode(e)&&(m+=e.outerHTML,e.remove())})),v("SpinVditorIRDOM",m,"argument",t.options.debugger),m=t.lute.SpinVditorIRDOM(m),v("SpinVditorIRDOM",m,"result",t.options.debugger),n?i.innerHTML=m:(i.outerHTML=m,!d||(n=(0,U.a1)(t.ir.element.querySelector("wbr"),"data-type","footnotes-def"))&&(h=(d=n.textContent).substring(1,d.indexOf("]:")),(n=t.ir.element.querySelector('sup[data-type="footnotes-ref"][data-footnotes-label="'+h+'"]'))&&n.setAttribute("aria-label",d.substr(h.length+3).trim().substr(0,24))));var f,h=t.ir.element.querySelectorAll("[data-type='link-ref-defs-block']");h.forEach(function(e,t){0===t?p=e:(p.insertAdjacentHTML("beforeend",e.innerHTML),e.remove())}),0<h.length&&t.ir.element.insertAdjacentElement("beforeend",h[0]);h=t.ir.element.querySelectorAll("[data-type='footnotes-block']");h.forEach(function(e,t){0===t?f=e:(f.insertAdjacentHTML("beforeend",e.innerHTML),e.remove())}),0<h.length&&t.ir.element.insertAdjacentElement("beforeend",h[0]),(0,Z.ib)(t.ir.element,e),t.ir.element.querySelectorAll(".vditor-ir__preview[data-render='2']").forEach(function(e){F(e,t)}),g(t),Mt(t,{enableAddUndoStack:!0,enableHint:!0,enableInput:!0})},X=function(e,t){if(""===e)return!1;if(-1===e.indexOf("⇧")&&-1===e.indexOf("⌘")&&-1===e.indexOf("⌥"))return!((0,B.yl)(t)||t.altKey||t.shiftKey||t.code!==e);if("⇧Tab"===e)return!((0,B.yl)(t)||t.altKey||!t.shiftKey||"Tab"!==t.code);var n=e.split("");if(e.startsWith("⌥")){var r=3===n.length?n[2]:n[1];return(3===n.length?(0,B.yl)(t):!(0,B.yl)(t))&&t.altKey&&!t.shiftKey&&t.code===(/^[0-9]$/.test(r)?"Digit":"Key")+r?!0:!1}e=2<(n="⌘Enter"===e?["⌘","Enter"]:n).length&&"⇧"===n[0],n=e?n[2]:n[1];return!e||!(0,B.vU)()&&/Mac/.test(navigator.platform)||("-"===n?n="_":"="===n&&(n="+")),!(!(0,B.yl)(t)||t.key.toLowerCase()!==n.toLowerCase()||t.altKey||!(!e&&!t.shiftKey||e&&t.shiftKey))},Y=function(e,t){if(e.ir.composingLock=t.isComposing,t.isComposing)return!1;-1!==t.key.indexOf("Arrow")||"Meta"===t.key||"Control"===t.key||"Alt"===t.key||"Shift"===t.key||"CapsLock"===t.key||"Escape"===t.key||/^F\d{1,2}$/.test(t.key)||e.undo.recordFirstPosition(e,t);var n=(0,Z.zh)(e),r=n.startContainer;if(!xe(t,e,r))return!1;if(He(n,e,t),Ve(n),"Enter"!==t.key&&"Tab"!==t.key&&"Backspace"!==t.key&&-1===t.key.indexOf("Arrow")&&!(0,B.yl)(t)&&"Escape"!==t.key&&"Delete"!==t.key)return!1;var i=(0,U.a1)(r,"data-newline","1");!(0,B.yl)(t)&&!t.altKey&&!t.shiftKey&&"Enter"===t.key&&i&&n.startOffset<i.textContent.length&&((o=i.previousElementSibling)&&(n.insertNode(document.createTextNode(o.textContent)),n.collapse(!1)),(o=i.nextSibling)&&(n.insertNode(document.createTextNode(o.textContent)),n.collapse(!0)));i=(0,U.lG)(r,"P");if(Ie(t,e,i,n))return!0;if(De(n,e,i,t))return!0;if(Pe(e,n,t,i))return!0;var o=(0,U.fb)(r,"vditor-ir__marker--pre");if(o&&"PRE"===o.tagName){var a=o.firstChild;if(Re(e,t,o,n))return!0;if(("math-block"===a.getAttribute("data-type")||"html-block"===a.getAttribute("data-type"))&&mt(e,t,n,a,o.parentElement))return!0;if(pt(e,t,n,a,o.parentElement))return!0}a=(0,U.a1)(r,"data-type","code-block-info");if(a){if("Enter"===t.key||"Tab"===t.key)return n.selectNodeContents(a.nextElementSibling.firstChild),n.collapse(!0),t.preventDefault(),L(e,["hint"]),!0;if("Backspace"===t.key&&(1===(o=(0,Z.im)(a,e.ir.element).start)&&n.setStart(r,0),2===o&&(e.hint.recentLanguage="")),mt(e,t,n,a,a.parentElement))return L(e,["hint"]),!0}a=(0,U.lG)(r,"TD")||(0,U.lG)(r,"TH");if(-1<t.key.indexOf("Arrow")&&a){var l=function(e){var t=(0,U.lG)(e,"TABLE");if(t&&t.rows[0].cells[0].isSameNode(e))return t;return false}(a);if(l&&mt(e,t,n,a,l))return!0;l=function(e){var t=(0,U.lG)(e,"TABLE");if(t&&t.lastElementChild.lastElementChild.lastElementChild.isSameNode(e))return t;return false}(a);if(l&&pt(e,t,n,a,l))return!0}if(je(e,t,n))return!0;if(Be(e,n,t))return!0;if(Oe(e,n,t))return!0;l=(0,W.W)(r);if(l){if(X("⌘=",t))return(s=l.querySelector(".vditor-ir__marker--heading"))&&1<s.textContent.trim().length&&_t(e,s.textContent.substr(1)),t.preventDefault(),!0;if(X("⌘-",t))return(s=l.querySelector(".vditor-ir__marker--heading"))&&s.textContent.trim().length<6&&_t(e,s.textContent.trim()+"# "),t.preventDefault(),!0}var s=(0,U.F9)(r);if("Backspace"===t.key&&!(0,B.yl)(t)&&!t.shiftKey&&!t.altKey&&""===n.toString()){if(qe(e,n,t,i))return!0;if(s&&s.previousElementSibling&&"UL"!==s.tagName&&"OL"!==s.tagName&&("code-block"===s.previousElementSibling.getAttribute("data-type")||"math-block"===s.previousElementSibling.getAttribute("data-type"))){var d=(0,Z.im)(s,e.ir.element,n).start;if(0===d||1===d&&s.innerText.startsWith(D.g.ZWSP))return n.selectNodeContents(s.previousElementSibling.querySelector(".vditor-ir__marker--pre code")),n.collapse(!1),u(n,e),""===s.textContent.trim().replace(D.g.ZWSP,"")&&(s.remove(),Mt(e)),t.preventDefault(),!0}l&&(d=l.firstElementChild.textContent.length,(0,Z.im)(l,e.ir.element).start===d&&(n.setStart(l.firstElementChild.firstChild,d-1),n.collapse(!0),(0,Z.Hc)(n)))}return!("ArrowUp"!==t.key&&"ArrowDown"!==t.key||!s||(s.querySelectorAll(".vditor-ir__node").forEach(function(e){e.contains(r)||e.classList.add("vditor-ir__node--hidden")}),!Ue(t,s,n)))||(Ne(n,t.key),!(!s||!m(s,e,t,n))&&(t.preventDefault(),!0))},Q=Zr(264),$=function(e,t){if(e.sv.composingLock=t.isComposing,t.isComposing)return!1;if(-1!==t.key.indexOf("Arrow")||"Meta"===t.key||"Control"===t.key||"Alt"===t.key||"Shift"===t.key||"CapsLock"===t.key||"Escape"===t.key||/^F\d{1,2}$/.test(t.key)||e.undo.recordFirstPosition(e,t),"Enter"!==t.key&&"Tab"!==t.key&&"Backspace"!==t.key&&-1===t.key.indexOf("Arrow")&&!(0,B.yl)(t)&&"Escape"!==t.key)return!1;var n=(0,Z.zh)(e),r=n.startContainer;3!==n.startContainer.nodeType&&"DIV"===n.startContainer.tagName&&(r=n.startContainer.childNodes[n.startOffset-1]);var i=(0,U.a1)(r,"data-type","text"),o=(0,U.a1)(r,"data-type","blockquote-marker");if((o=!o&&0===n.startOffset&&i&&i.previousElementSibling&&"blockquote-marker"===i.previousElementSibling.getAttribute("data-type")?i.previousElementSibling:o)&&"Enter"===t.key&&!(0,B.yl)(t)&&!t.altKey&&""===o.nextElementSibling.textContent.trim()&&(0,Z.im)(o,e.sv.element,n).start===o.textContent.length)return"padding"===(null===(a=o.previousElementSibling)||void 0===a?void 0:a.getAttribute("data-type"))&&o.previousElementSibling.setAttribute("data-action","enter-remove"),o.remove(),Xe(e),t.preventDefault(),!0;var a=(0,U.a1)(r,"data-type","li-marker"),o=(0,U.a1)(r,"data-type","task-marker"),a=a;if(a||o&&"task-marker"!==o.nextElementSibling.getAttribute("data-type")&&(a=o),a=!a&&0===n.startOffset&&i&&i.previousElementSibling&&("li-marker"===i.previousElementSibling.getAttribute("data-type")||"task-marker"===i.previousElementSibling.getAttribute("data-type"))?i.previousElementSibling:a){var i=(0,Z.im)(a,e.sv.element,n).start,l="task-marker"===a.getAttribute("data-type"),s=a;if(l&&(s=a.previousElementSibling.previousElementSibling.previousElementSibling),i===a.textContent.length){if("Enter"===t.key&&!(0,B.yl)(t)&&!t.altKey&&!t.shiftKey&&""===a.nextElementSibling.textContent.trim())return"padding"===(null===(i=s.previousElementSibling)||void 0===i?void 0:i.getAttribute("data-type"))?(s.previousElementSibling.remove(),p(e)):(l&&(s.remove(),a.previousElementSibling.previousElementSibling.remove(),a.previousElementSibling.remove()),a.nextElementSibling.remove(),a.remove(),Xe(e)),t.preventDefault(),!0;if("Tab"===t.key)return s.insertAdjacentHTML("beforebegin",'<span data-type="padding">'+s.textContent.replace(/\S/g," ")+"</span>"),/^\d/.test(s.textContent)&&(s.textContent=s.textContent.replace(/^\d{1,}/,"1"),n.selectNodeContents(a.firstChild),n.collapse(!1)),p(e),t.preventDefault(),!0}}if(Oe(e,n,t))return!0;var l=(0,U.a1)(r,"data-block","0"),s=(0,W.S)(r,"SPAN");if("Enter"===t.key&&!(0,B.yl)(t)&&!t.altKey&&!t.shiftKey&&l){var d=!1,a=l.textContent.match(/^\n+/);(0,Z.im)(l,e.sv.element).start<=(a?a[0].length:0)&&(d=!0);r="\n";if(s){if("enter-remove"===(null===(a=s.previousElementSibling)||void 0===a?void 0:a.getAttribute("data-action")))return s.previousElementSibling.remove(),Xe(e),t.preventDefault(),!0;r+=function(e){var t=e.getAttribute("data-type"),n=e.previousElementSibling,r=t&&t!=="text"&&t!=="table"&&t!=="heading-marker"&&t!=="newline"&&t!=="yaml-front-matter-open-marker"&&t!=="yaml-front-matter-close-marker"&&t!=="code-block-info"&&t!=="code-block-close-marker"&&t!=="code-block-open-marker"?e.textContent:"",i=false;if(t==="newline")i=true;while(n&&!i){var o=n.getAttribute("data-type");if(o==="li-marker"||o==="blockquote-marker"||o==="task-marker"||o==="padding"){var a=n.textContent;if(o==="li-marker"&&(t==="code-block-open-marker"||t==="code-block-info"))r=a.replace(/\S/g," ")+r;else if(t==="code-block-close-marker"&&n.nextElementSibling.isSameNode(e)){var l=Ze(e,"code-block-open-marker");if(l&&l.previousElementSibling){n=l.previousElementSibling;r=a+r}}else r=a+r}else if(o==="newline")i=true;n=n.previousElementSibling}return r}(s)}return n.insertNode(document.createTextNode(r)),n.collapse(!1),(l&&""!==l.textContent.trim()&&!d?p:Xe)(e),t.preventDefault(),!0}if("Backspace"===t.key&&!(0,B.yl)(t)&&!t.altKey&&!t.shiftKey){if(s&&"newline"===(null===(d=s.previousElementSibling)||void 0===d?void 0:d.getAttribute("data-type"))&&1===(0,Z.im)(s,e.sv.element,n).start&&-1===s.getAttribute("data-type").indexOf("code-block-"))return n.setStart(s,0),n.extractContents(),(""!==s.textContent.trim()?p:Xe)(e),t.preventDefault(),!0;if(l&&0===(0,Z.im)(l,e.sv.element,n).start&&l.previousElementSibling){n.extractContents();s=l.previousElementSibling.lastElementChild;return"newline"===s.getAttribute("data-type")&&(s.remove(),s=l.previousElementSibling.lastElementChild),"newline"!==s.getAttribute("data-type")&&(s.insertAdjacentHTML("afterend",l.innerHTML),l.remove()),""===l.textContent.trim()||null!==(l=l.previousElementSibling)&&void 0!==l&&l.querySelector('[data-type="code-block-open-marker"]')?("newline"!==s.getAttribute("data-type")&&(n.selectNodeContents(s.lastChild),n.collapse(!1)),Xe(e)):p(e),t.preventDefault(),!0}}return!1},ee=Zr(958),te=function(e){var t,n=window.innerWidth<=D.g.MOBILE_WIDTH?10:35;"none"!==e.wysiwyg.element.parentElement.style.display&&(t=(e.wysiwyg.element.parentElement.clientWidth-e.options.preview.maxWidth)/2,e.wysiwyg.element.style.padding="10px "+Math.max(n,t)+"px"),"none"!==e.ir.element.parentElement.style.display&&(t=(e.ir.element.parentElement.clientWidth-e.options.preview.maxWidth)/2,e.ir.element.style.padding="10px "+Math.max(n,t)+"px"),"block"===e.preview.element.style.display&&"sv"!==e.currentMode||(e.toolbar.element.style.paddingLeft=Math.max(5,parseInt(e[e.currentMode].element.style.paddingLeft||"0",10)+("left"===e.options.outline.position?e.outline.element.offsetWidth:0))+"px")},ne=function(e){var t;e.options.typewriterMode&&(t=window.innerHeight,"number"==typeof e.options.height&&(t=e.options.height,"number"==typeof e.options.minHeight&&(t=Math.max(t,e.options.minHeight)),t=Math.min(window.innerHeight,t)),e.element.classList.contains("vditor--fullscreen")&&(t=window.innerHeight),e[e.currentMode].element.style.setProperty("--editor-bottom",(t-e.toolbar.element.offsetHeight)/2+"px"))},re=function(n){clearTimeout(n[n.currentMode].hlToolbarTimeoutId),n[n.currentMode].hlToolbarTimeoutId=window.setTimeout(function(){var e,t;"false"!==n[n.currentMode].element.getAttribute("contenteditable")&&(0,Z.Gb)(n[n.currentMode].element)&&(q(n.toolbar.elements,D.g.EDIT_TOOLBARS),O(n.toolbar.elements,D.g.EDIT_TOOLBARS),e=(t=(0,Z.zh)(n)).startContainer,(e=3===t.startContainer.nodeType?t.startContainer.parentElement:e).classList.contains("vditor-reset")&&(e=e.childNodes[t.startOffset]),("sv"===n.currentMode?(0,U.a1)(e,"data-type","heading"):(0,W.W)(e))&&V(n.toolbar.elements,["headings"]),("sv"===n.currentMode?(0,U.a1)(e,"data-type","blockquote"):(0,U.lG)(e,"BLOCKQUOTE"))&&V(n.toolbar.elements,["quote"]),(0,U.a1)(e,"data-type","strong")&&V(n.toolbar.elements,["bold"]),(0,U.a1)(e,"data-type","em")&&V(n.toolbar.elements,["italic"]),(0,U.a1)(e,"data-type","s")&&V(n.toolbar.elements,["strike"]),(0,U.a1)(e,"data-type","a")&&V(n.toolbar.elements,["link"]),(t=(0,U.lG)(e,"LI"))?(t.classList.contains("vditor-task")?V(n.toolbar.elements,["check"]):"OL"===t.parentElement.tagName?V(n.toolbar.elements,["ordered-list"]):"UL"===t.parentElement.tagName&&V(n.toolbar.elements,["list"]),O(n.toolbar.elements,["outdent","indent"])):I(n.toolbar.elements,["outdent","indent"]),(0,U.a1)(e,"data-type","code-block")&&(I(n.toolbar.elements,["headings","bold","italic","strike","line","quote","list","ordered-list","check","code","inline-code","upload","link","table","record"]),V(n.toolbar.elements,["code"])),(0,U.a1)(e,"data-type","code")&&(I(n.toolbar.elements,["headings","bold","italic","strike","line","quote","list","ordered-list","check","code","upload","link","table","record"]),V(n.toolbar.elements,["inline-code"])),(0,U.a1)(e,"data-type","table")&&I(n.toolbar.elements,["headings","list","ordered-list","check","line","quote","code","table"]))},200)},ie=function(t,n){(n=void 0===n?{enableAddUndoStack:!0,enableHint:!1,enableInput:!0}:n).enableHint&&t.hint.render(t),clearTimeout(t.wysiwyg.afterRenderTimeoutId),t.wysiwyg.afterRenderTimeoutId=window.setTimeout(function(){var e;t.wysiwyg.composingLock||(e=a(t),"function"==typeof t.options.input&&n.enableInput&&t.options.input(e),t.options.counter.enable&&t.counter.render(t,e),t.options.cache.enable&&(0,B.pK)()&&(localStorage.setItem(t.options.cache.id,e),t.options.cache.after&&t.options.cache.after(e)),t.devtools&&t.devtools.renderEchart(t),n.enableAddUndoStack&&t.undo.addToUndoStack(t))},t.options.undoDelay)},oe=function(e,t){var n=(0,Z.zh)(e),r=(0,U.F9)(n.startContainer);(r=!(r=r||n.startContainer.childNodes[n.startOffset])&&0===e.wysiwyg.element.children.length?e.wysiwyg.element:r)&&!r.classList.contains("vditor-wysiwyg__block")&&(n.insertNode(document.createElement("wbr")),"<wbr>"===r.innerHTML.trim()&&(r.innerHTML="<wbr><br>"),"BLOCKQUOTE"===r.tagName||r.classList.contains("vditor-reset")?r.innerHTML="<"+t+' data-block="0">'+r.innerHTML.trim()+"</"+t+">":r.outerHTML="<"+t+' data-block="0">'+r.innerHTML.trim()+"</"+t+">",(0,Z.ib)(e.wysiwyg.element,n),g(e))},ae=function(e){var t=getSelection().getRangeAt(0),n=(0,U.F9)(t.startContainer);(n=n||t.startContainer.childNodes[t.startOffset])&&(t.insertNode(document.createElement("wbr")),n.outerHTML='<p data-block="0">'+n.innerHTML+"</p>",(0,Z.ib)(e.wysiwyg.element,t)),e.wysiwyg.popover.style.display="none"},le=function(e,t){if(e.wysiwyg.composingLock=t.isComposing,t.isComposing)return!1;-1!==t.key.indexOf("Arrow")||"Meta"===t.key||"Control"===t.key||"Alt"===t.key||"Shift"===t.key||"CapsLock"===t.key||"Escape"===t.key||/^F\d{1,2}$/.test(t.key)||e.undo.recordFirstPosition(e,t);var n=(0,Z.zh)(e),r=n.startContainer;if(!xe(t,e,r))return!1;if(He(n,e,t),Ve(n),"Enter"!==t.key&&"Tab"!==t.key&&"Backspace"!==t.key&&-1===t.key.indexOf("Arrow")&&!(0,B.yl)(t)&&"Escape"!==t.key&&"Delete"!==t.key)return!1;var i=(0,U.F9)(r),o=(0,U.lG)(r,"P");if(Ie(t,e,o,n))return!0;if(De(n,e,o,t))return!0;if(je(e,t,n))return!0;var a=(0,U.fb)(r,"vditor-wysiwyg__block");if(a){if("Escape"===t.key&&2===a.children.length)return e.wysiwyg.popover.style.display="none",a.firstElementChild.style.display="none",e.wysiwyg.element.blur(),t.preventDefault(),!0;if(!(0,B.yl)(t)&&!t.shiftKey&&t.altKey&&"Enter"===t.key&&"code-block"===a.getAttribute("data-type")){var l=e.wysiwyg.popover.querySelector(".vditor-input");return l.focus(),l.select(),t.preventDefault(),!0}if("0"===a.getAttribute("data-block")){if(Re(e,t,a.firstElementChild,n))return!0;if(pt(e,t,n,a.firstElementChild,a))return!0;if("yaml-front-matter"!==a.getAttribute("data-type")&&mt(e,t,n,a.firstElementChild,a))return!0}}if(Pe(e,n,t,o))return!0;a=(0,U.E2)(r,"BLOCKQUOTE");if(a&&!t.shiftKey&&t.altKey&&"Enter"===t.key){(0,B.yl)(t)?n.setStartBefore(a):n.setStartAfter(a),(0,Z.Hc)(n);var s=document.createElement("p");return s.setAttribute("data-block","0"),s.innerHTML="\n",n.insertNode(s),n.collapse(!0),(0,Z.Hc)(n),ie(e),Fe(e),t.preventDefault(),!0}var d,c,a=(0,W.W)(r);if(a){if("H6"===a.tagName&&r.textContent.length===n.startOffset&&!(0,B.yl)(t)&&!t.shiftKey&&!t.altKey&&"Enter"===t.key){var u=document.createElement("p");return u.textContent="\n",u.setAttribute("data-block","0"),r.parentElement.insertAdjacentElement("afterend",u),n.setStart(u,0),(0,Z.Hc)(n),ie(e),Fe(e),t.preventDefault(),!0}if(X("⌘=",t))return 0<(d=parseInt(a.tagName.substr(1),10)-1)&&(oe(e,"h"+d),ie(e)),t.preventDefault(),!0;if(X("⌘-",t))return(d=parseInt(a.tagName.substr(1),10)+1)<7&&(oe(e,"h"+d),ie(e)),t.preventDefault(),!0;"Backspace"!==t.key||(0,B.yl)(t)||t.shiftKey||t.altKey||1!==a.textContent.length||ae(e)}if(Be(e,n,t))return!0;if(!t.altKey||"Enter"!==t.key||(0,B.yl)(t)||t.shiftKey||(s=(0,U.lG)(r,"A"),u=(0,U.a1)(r,"data-type","link-ref"),d=(0,U.a1)(r,"data-type","footnotes-ref"),(s||u||d||a&&2===a.tagName.length)&&((a=e.wysiwyg.popover.querySelector("input")).focus(),a.select())),se(e,t))return!0;if(X("⇧⌘U",t)&&(c=e.wysiwyg.popover.querySelector('[data-type="up"]')))return c.click(),t.preventDefault(),!0;if(X("⇧⌘D",t)&&(c=e.wysiwyg.popover.querySelector('[data-type="down"]')))return c.click(),t.preventDefault(),!0;if(Oe(e,n,t))return!0;if(!(0,B.yl)(t)&&t.shiftKey&&!t.altKey&&"Enter"===t.key&&"LI"!==r.parentElement.tagName&&"P"!==r.parentElement.tagName)return["STRONG","STRIKE","S","I","EM","B"].includes(r.parentElement.tagName)?n.insertNode(document.createTextNode("\n"+D.g.ZWSP)):n.insertNode(document.createTextNode("\n")),n.collapse(!1),(0,Z.Hc)(n),ie(e),Fe(e),t.preventDefault(),!0;if("Backspace"===t.key&&!(0,B.yl)(t)&&!t.shiftKey&&!t.altKey&&""===n.toString()){if(qe(e,n,t,o))return!0;if(i){if(i.previousElementSibling&&i.previousElementSibling.classList.contains("vditor-wysiwyg__block")&&"0"===i.previousElementSibling.getAttribute("data-block")&&"UL"!==i.tagName&&"OL"!==i.tagName){var p=(0,Z.im)(i,e.wysiwyg.element,n).start;if(0===p&&0===n.startOffset||1===p&&i.innerText.startsWith(D.g.ZWSP))return E(i.previousElementSibling.lastElementChild,e,!1),""===i.innerHTML.trim().replace(D.g.ZWSP,"")&&(i.remove(),ie(e)),t.preventDefault(),!0}p=n.startOffset;if(""===n.toString()&&3===r.nodeType&&"\n"===r.textContent.charAt(p-2)&&r.textContent.charAt(p-1)!==D.g.ZWSP&&["STRONG","STRIKE","S","I","EM","B"].includes(r.parentElement.tagName))return r.textContent=r.textContent.substring(0,p-1)+D.g.ZWSP,n.setStart(r,p),n.collapse(!0),ie(e),t.preventDefault(),!0;r.textContent===D.g.ZWSP&&1===n.startOffset&&!r.previousSibling&&function(e){for(var t=e.startContainer.nextSibling;t&&""===t.textContent;)t=t.nextSibling;return!(!t||3===t.nodeType||"CODE"!==t.tagName&&"math-inline"!==t.getAttribute("data-type")&&"html-entity"!==t.getAttribute("data-type")&&"html-inline"!==t.getAttribute("data-type"))}(n)&&(r.textContent=""),i.querySelectorAll("span.vditor-wysiwyg__block[data-type='math-inline']").forEach(function(e){e.firstElementChild.style.display="inline",e.lastElementChild.style.display="none"}),i.querySelectorAll("span.vditor-wysiwyg__block[data-type='html-entity']").forEach(function(e){e.firstElementChild.style.display="inline",e.lastElementChild.style.display="none"})}}return(0,B.vU)()&&1===n.startOffset&&-1<r.textContent.indexOf(D.g.ZWSP)&&r.previousSibling&&3!==r.previousSibling.nodeType&&"CODE"===r.previousSibling.tagName&&("Backspace"===t.key||"ArrowLeft"===t.key)?(n.selectNodeContents(r.previousSibling),n.collapse(!1),t.preventDefault(),!0):Ue(t,i,n)?(t.preventDefault(),!0):(Ne(n,t.key),"ArrowDown"!==t.key||(r=r.nextSibling)&&3!==r.nodeType&&"math-inline"===r.getAttribute("data-type")&&n.setStartAfter(r),!(!i||!m(i,e,t,n))&&(t.preventDefault(),!0))},se=function(e,t){if(X("⇧⌘X",t)){e=e.wysiwyg.popover.querySelector('[data-type="remove"]');if(e)return e.click(),t.preventDefault(),!0}},de=function(N){clearTimeout(N.wysiwyg.hlToolbarTimeoutId),N.wysiwyg.hlToolbarTimeoutId=window.setTimeout(function(){if("false"!==N.wysiwyg.element.getAttribute("contenteditable")&&(0,Z.Gb)(N.wysiwyg.element)){q(N.toolbar.elements,D.g.EDIT_TOOLBARS),O(N.toolbar.elements,D.g.EDIT_TOOLBARS);var t=getSelection().getRangeAt(0),e=t.startContainer,e=3===t.startContainer.nodeType?t.startContainer.parentElement:e.childNodes[t.startOffset>=e.childNodes.length?e.childNodes.length-1:t.startOffset],n=(0,U.a1)(e,"data-type","footnotes-block");if(n)return N.wysiwyg.popover.innerHTML="",ue(n,N),void ce(N,n);var r=(0,U.lG)(e,"LI");r?(r.classList.contains("vditor-task")?V(N.toolbar.elements,["check"]):"OL"===r.parentElement.tagName?V(N.toolbar.elements,["ordered-list"]):"UL"===r.parentElement.tagName&&V(N.toolbar.elements,["list"]),O(N.toolbar.elements,["outdent","indent"])):I(N.toolbar.elements,["outdent","indent"]),(0,U.lG)(e,"BLOCKQUOTE")&&V(N.toolbar.elements,["quote"]),((0,U.lG)(e,"B")||(0,U.lG)(e,"STRONG"))&&V(N.toolbar.elements,["bold"]),((0,U.lG)(e,"I")||(0,U.lG)(e,"EM"))&&V(N.toolbar.elements,["italic"]),((0,U.lG)(e,"STRIKE")||(0,U.lG)(e,"S"))&&V(N.toolbar.elements,["strike"]),N.wysiwyg.element.querySelectorAll(".vditor-comment--focus").forEach(function(e){e.classList.remove("vditor-comment--focus")});var i,o,a=(0,U.fb)(e,"vditor-comment");a&&(1<(i=a.getAttribute("data-cmtids").split(" ")).length&&a.nextSibling.isSameNode(a.nextElementSibling)&&(o=a.nextElementSibling.getAttribute("data-cmtids").split(" "),i.find(function(e){if(o.includes(e))return i=[e],!0})),N.wysiwyg.element.querySelectorAll(".vditor-comment").forEach(function(e){-1<e.getAttribute("data-cmtids").indexOf(i[0])&&e.classList.add("vditor-comment--focus")}));var l=(0,U.lG)(e,"A");l&&V(N.toolbar.elements,["link"]);var p=(0,U.lG)(e,"TABLE"),s=(0,W.W)(e);(0,U.lG)(e,"CODE")?(0,U.lG)(e,"PRE")?(I(N.toolbar.elements,["headings","bold","italic","strike","line","quote","list","ordered-list","check","code","inline-code","upload","link","table","record"]),V(N.toolbar.elements,["code"])):(I(N.toolbar.elements,["headings","bold","italic","strike","line","quote","list","ordered-list","check","code","upload","link","table","record"]),V(N.toolbar.elements,["inline-code"])):s?(I(N.toolbar.elements,["bold"]),V(N.toolbar.elements,["headings"])):p&&I(N.toolbar.elements,["table"]);var d=(0,U.fb)(e,"vditor-toc");if(d)return N.wysiwyg.popover.innerHTML="",ue(d,N),void ce(N,d);var c,u,m,f,h,v,g,y,b,w,E=(0,W.S)(e,"BLOCKQUOTE");E&&(N.wysiwyg.popover.innerHTML="",R(t,E,N),P(t,E,N),ue(E,N),ce(N,E)),r&&(N.wysiwyg.popover.innerHTML="",R(t,r,N),P(t,r,N),ue(r,N),ce(N,r)),p&&(N.options.lang,N.options,N.wysiwyg.popover.innerHTML="",c=function(){var e=p.rows.length,t=p.rows[0].cells.length,n=parseInt(b.value,10)||e,r=parseInt(w.value,10)||t;if(n!==e||t!==r){if(t!==r)for(var i=r-t,o=0;o<p.rows.length;o++)if(0<i)for(var a=0;a<i;a++)0===o?p.rows[o].lastElementChild.insertAdjacentHTML("afterend","<th> </th>"):p.rows[o].lastElementChild.insertAdjacentHTML("afterend","<td> </td>");else for(var l=t-1;r<=l;l--)p.rows[o].cells[l].remove();if(e!==n){var s=n-e;if(0<s){for(var d="<tr>",c=0;c<r;c++)d+="<td> </td>";for(var u=0;u<s;u++)p.querySelector("tbody")?p.querySelector("tbody").insertAdjacentHTML("beforeend",d):p.querySelector("thead").insertAdjacentHTML("afterend",d+"</tr>")}else for(c=e-1;n<=c;c--)p.rows[c].remove(),1===p.rows.length&&p.querySelector("tbody").remove()}}},u=function(e){gt(p,e),"right"===e?(m.classList.remove("vditor-icon--current"),f.classList.remove("vditor-icon--current"),h.classList.add("vditor-icon--current")):"center"===e?(m.classList.remove("vditor-icon--current"),h.classList.remove("vditor-icon--current"),f.classList.add("vditor-icon--current")):(f.classList.remove("vditor-icon--current"),h.classList.remove("vditor-icon--current"),m.classList.add("vditor-icon--current")),(0,Z.Hc)(t),ie(N)},k=(0,U.lG)(e,"TD"),_=(0,U.lG)(e,"TH"),L="left",k?L=k.getAttribute("align")||"left":_&&(L=_.getAttribute("align")||"center"),(m=document.createElement("button")).setAttribute("type","button"),m.setAttribute("aria-label",window.VditorI18n.alignLeft+"<"+(0,B.ns)("⇧⌘L")+">"),m.setAttribute("data-type","left"),m.innerHTML='<svg><use xlink:href="#vditor-icon-align-left"></use></svg>',m.className="vditor-icon vditor-tooltipped vditor-tooltipped__n"+("left"===L?" vditor-icon--current":""),m.onclick=function(){u("left")},(f=document.createElement("button")).setAttribute("type","button"),f.setAttribute("aria-label",window.VditorI18n.alignCenter+"<"+(0,B.ns)("⇧⌘C")+">"),f.setAttribute("data-type","center"),f.innerHTML='<svg><use xlink:href="#vditor-icon-align-center"></use></svg>',f.className="vditor-icon vditor-tooltipped vditor-tooltipped__n"+("center"===L?" vditor-icon--current":""),f.onclick=function(){u("center")},(h=document.createElement("button")).setAttribute("type","button"),h.setAttribute("aria-label",window.VditorI18n.alignRight+"<"+(0,B.ns)("⇧⌘R")+">"),h.setAttribute("data-type","right"),h.innerHTML='<svg><use xlink:href="#vditor-icon-align-right"></use></svg>',h.className="vditor-icon vditor-tooltipped vditor-tooltipped__n"+("right"===L?" vditor-icon--current":""),h.onclick=function(){u("right")},(v=document.createElement("button")).setAttribute("type","button"),v.setAttribute("aria-label",window.VditorI18n.insertRowBelow+"<"+(0,B.ns)("⌘=")+">"),v.setAttribute("data-type","insertRow"),v.innerHTML='<svg><use xlink:href="#vditor-icon-insert-row"></use></svg>',v.className="vditor-icon vditor-tooltipped vditor-tooltipped__n",v.onclick=function(){var e=getSelection().getRangeAt(0).startContainer,e=(0,U.lG)(e,"TD")||(0,U.lG)(e,"TH");e&&Et(N,t,e)},(g=document.createElement("button")).setAttribute("type","button"),g.setAttribute("aria-label",window.VditorI18n.insertRowAbove+"<"+(0,B.ns)("⇧⌘F")+">"),g.setAttribute("data-type","insertRow"),g.innerHTML='<svg><use xlink:href="#vditor-icon-insert-rowb"></use></svg>',g.className="vditor-icon vditor-tooltipped vditor-tooltipped__n",g.onclick=function(){var e=getSelection().getRangeAt(0).startContainer,e=(0,U.lG)(e,"TD")||(0,U.lG)(e,"TH");e&&kt(N,t,e)},(y=document.createElement("button")).setAttribute("type","button"),y.setAttribute("aria-label",window.VditorI18n.insertColumnRight+"<"+(0,B.ns)("⇧⌘=")+">"),y.setAttribute("data-type","insertColumn"),y.innerHTML='<svg><use xlink:href="#vditor-icon-insert-column"></use></svg>',y.className="vditor-icon vditor-tooltipped vditor-tooltipped__n",y.onclick=function(){var e=getSelection().getRangeAt(0).startContainer,e=(0,U.lG)(e,"TD")||(0,U.lG)(e,"TH");e&&St(N,p,e)},(n=document.createElement("button")).setAttribute("type","button"),n.setAttribute("aria-label",window.VditorI18n.insertColumnLeft+"<"+(0,B.ns)("⇧⌘G")+">"),n.setAttribute("data-type","insertColumn"),n.innerHTML='<svg><use xlink:href="#vditor-icon-insert-columnb"></use></svg>',n.className="vditor-icon vditor-tooltipped vditor-tooltipped__n",n.onclick=function(){var e=getSelection().getRangeAt(0).startContainer,e=(0,U.lG)(e,"TD")||(0,U.lG)(e,"TH");e&&St(N,p,e,"beforebegin")},(a=document.createElement("button")).setAttribute("type","button"),a.setAttribute("aria-label",window.VditorI18n["delete-row"]+"<"+(0,B.ns)("⌘-")+">"),a.setAttribute("data-type","deleteRow"),a.innerHTML='<svg><use xlink:href="#vditor-icon-delete-row"></use></svg>',a.className="vditor-icon vditor-tooltipped vditor-tooltipped__n",a.onclick=function(){var e=getSelection().getRangeAt(0).startContainer,e=(0,U.lG)(e,"TD")||(0,U.lG)(e,"TH");e&&Ct(N,t,e)},(k=document.createElement("button")).setAttribute("type","button"),k.setAttribute("aria-label",window.VditorI18n["delete-column"]+"<"+(0,B.ns)("⇧⌘-")+">"),k.setAttribute("data-type","deleteColumn"),k.innerHTML='<svg><use xlink:href="#vditor-icon-delete-column"></use></svg>',k.className="vditor-icon vditor-tooltipped vditor-tooltipped__n",k.onclick=function(){var e=getSelection().getRangeAt(0).startContainer,e=(0,U.lG)(e,"TD")||(0,U.lG)(e,"TH");e&&Lt(N,t,p,e)},(_=document.createElement("span")).setAttribute("aria-label",window.VditorI18n.row),_.className="vditor-tooltipped vditor-tooltipped__n",b=document.createElement("input"),_.appendChild(b),b.type="number",b.min="1",b.className="vditor-input",b.style.width="42px",b.style.textAlign="center",b.setAttribute("placeholder",window.VditorI18n.row),b.value=p.rows.length.toString(),b.oninput=function(){c()},b.onkeydown=function(e){if(!e.isComposing)return"Tab"===e.key?(w.focus(),w.select(),void e.preventDefault()):void se(N,e)},(L=document.createElement("span")).setAttribute("aria-label",window.VditorI18n.column),L.className="vditor-tooltipped vditor-tooltipped__n",w=document.createElement("input"),L.appendChild(w),w.type="number",w.min="1",w.className="vditor-input",w.style.width="42px",w.style.textAlign="center",w.setAttribute("placeholder",window.VditorI18n.column),w.value=p.rows[0].cells.length.toString(),w.oninput=function(){c()},w.onkeydown=function(e){if(!e.isComposing)return"Tab"===e.key?(b.focus(),b.select(),void e.preventDefault()):void se(N,e)},R(t,p,N),P(t,p,N),ue(p,N),N.wysiwyg.popover.insertAdjacentElement("beforeend",m),N.wysiwyg.popover.insertAdjacentElement("beforeend",f),N.wysiwyg.popover.insertAdjacentElement("beforeend",h),N.wysiwyg.popover.insertAdjacentElement("beforeend",g),N.wysiwyg.popover.insertAdjacentElement("beforeend",v),N.wysiwyg.popover.insertAdjacentElement("beforeend",n),N.wysiwyg.popover.insertAdjacentElement("beforeend",y),N.wysiwyg.popover.insertAdjacentElement("beforeend",a),N.wysiwyg.popover.insertAdjacentElement("beforeend",k),N.wysiwyg.popover.insertAdjacentElement("beforeend",_),N.wysiwyg.popover.insertAdjacentHTML("beforeend"," x "),N.wysiwyg.popover.insertAdjacentElement("beforeend",L),ce(N,p));var k=(0,U.a1)(e,"data-type","link-ref");k&&j(N,k);var S,C=(0,U.a1)(e,"data-type","footnotes-ref");C&&(N.options.lang,N.options,N.wysiwyg.popover.innerHTML="",(_=document.createElement("span")).setAttribute("aria-label",window.VditorI18n.footnoteRef+"<"+(0,B.ns)("⌥Enter")+">"),_.className="vditor-tooltipped vditor-tooltipped__n",S=document.createElement("input"),_.appendChild(S),S.className="vditor-input",S.setAttribute("placeholder",window.VditorI18n.footnoteRef+"<"+(0,B.ns)("⌥Enter")+">"),S.style.width="120px",S.value=C.getAttribute("data-footnotes-label"),S.oninput=function(){""!==S.value.trim()&&C.setAttribute("data-footnotes-label",S.value)},S.onkeydown=function(e){if(!e.isComposing)return(0,B.yl)(e)||e.shiftKey||!e.altKey||"Enter"!==e.key?void se(N,e):(t.selectNodeContents(C),t.collapse(!1),(0,Z.Hc)(t),void e.preventDefault())},ue(C,N),N.wysiwyg.popover.insertAdjacentElement("beforeend",_),ce(N,C));var L,T,M,_,A,x=(0,U.fb)(e,"vditor-wysiwyg__block");x&&-1<x.getAttribute("data-type").indexOf("block")?(N.options.lang,N.options,N.wysiwyg.popover.innerHTML="",R(t,x,N),P(t,x,N),ue(x,N),"code-block"===x.getAttribute("data-type")&&((L=document.createElement("span")).setAttribute("aria-label",window.VditorI18n.language+"<"+(0,B.ns)("⌥Enter")+">"),L.className="vditor-tooltipped vditor-tooltipped__n",T=document.createElement("input"),L.appendChild(T),M=x.firstElementChild.firstElementChild,T.className="vditor-input",T.setAttribute("placeholder",window.VditorI18n.language+"<"+(0,B.ns)("⌥Enter")+">"),T.value=-1<M.className.indexOf("language-")?M.className.split("-")[1].split(" ")[0]:"",T.oninput=function(){""!==T.value.trim()?M.className="language-"+T.value:(M.className="",N.hint.recentLanguage=""),x.lastElementChild.classList.contains("vditor-wysiwyg__preview")&&(x.lastElementChild.innerHTML=x.firstElementChild.innerHTML,F(x.lastElementChild,N)),ie(N)},T.onkeydown=function(e){if(!e.isComposing&&!se(N,e)){if("Escape"===e.key&&"block"===N.hint.element.style.display)return N.hint.element.style.display="none",void e.preventDefault();(0,B.yl)(e)||e.shiftKey||!e.altKey||"Enter"!==e.key||(t.setStart(M.firstChild,0),t.collapse(!0),(0,Z.Hc)(t)),N.hint.select(e,N)}},T.onkeyup=function(e){var t,n;e.isComposing||"Enter"===e.key||"ArrowUp"===e.key||"Escape"===e.key||"ArrowDown"===e.key||(t=[],n=T.value.substring(0,T.selectionStart),D.g.CODE_LANGUAGES.forEach(function(e){-1<e.indexOf(n.toLowerCase())&&t.push({html:e,value:e})}),N.hint.genHTML(t,n,N),e.preventDefault())},N.wysiwyg.popover.insertAdjacentElement("beforeend",L)),ce(N,x)):(x||N.wysiwyg.element.querySelectorAll(".vditor-wysiwyg__preview").forEach(function(e){e.previousElementSibling.style.display="none"}),x=void 0),s&&(N.wysiwyg.popover.innerHTML="",(_=document.createElement("span")).setAttribute("aria-label","ID<"+(0,B.ns)("⌥Enter")+">"),_.className="vditor-tooltipped vditor-tooltipped__n",A=document.createElement("input"),_.appendChild(A),A.className="vditor-input",A.setAttribute("placeholder","ID<"+(0,B.ns)("⌥Enter")+">"),A.style.width="120px",A.value=s.getAttribute("data-id")||"",A.oninput=function(){s.setAttribute("data-id",A.value)},A.onkeydown=function(e){if(!e.isComposing)return(0,B.yl)(e)||e.shiftKey||!e.altKey||"Enter"!==e.key?void se(N,e):(t.selectNodeContents(s),t.collapse(!1),(0,Z.Hc)(t),void e.preventDefault())},R(t,s,N),P(t,s,N),ue(s,N),N.wysiwyg.popover.insertAdjacentElement("beforeend",_),ce(N,s)),l&&me(N,l),E||r||p||x||l||k||C||s||d||((H=(0,U.a1)(e,"data-block","0"))&&H.parentElement.isEqualNode(N.wysiwyg.element)?(N.wysiwyg.popover.innerHTML="",R(t,H,N),P(t,H,N),ue(H,N),ce(N,H)):N.wysiwyg.popover.style.display="none"),N.wysiwyg.element.querySelectorAll('span[data-type="backslash"] > span').forEach(function(e){e.style.display="none"});var H=(0,U.a1)(t.startContainer,"data-type","backslash");H&&(H.querySelector("span").style.display="inline")}},200)},ce=function(e,t){var n=t,t=(0,U.lG)(t,"TABLE");t&&(n=t),e.wysiwyg.popover.style.left="0",e.wysiwyg.popover.style.display="block",e.wysiwyg.popover.style.top=Math.max(-8,n.offsetTop-21-e.wysiwyg.element.scrollTop)+"px",e.wysiwyg.popover.style.left=Math.min(n.offsetLeft,e.wysiwyg.element.clientWidth-e.wysiwyg.popover.clientWidth)+"px",e.wysiwyg.popover.setAttribute("data-top",(n.offsetTop-21).toString())},ue=function(t,n){var e=document.createElement("button");e.setAttribute("type","button"),e.setAttribute("data-type","remove"),e.setAttribute("aria-label",window.VditorI18n.remove+"<"+(0,B.ns)("⇧⌘X")+">"),e.innerHTML='<svg><use xlink:href="#vditor-icon-trashcan"></use></svg>',e.className="vditor-icon vditor-tooltipped vditor-tooltipped__n",e.onclick=function(){var e=(0,Z.zh)(n);e.setStartAfter(t),(0,Z.Hc)(e),t.remove(),ie(n),de(n)},n.wysiwyg.popover.insertAdjacentElement("beforeend",e)},pe=function(e,t,n,r){if(!n.isComposing)return"Tab"===n.key?(r.focus(),r.select(),void n.preventDefault()):void((0,B.yl)(n)||n.shiftKey||!n.altKey||"Enter"!==n.key||(e=(0,Z.zh)(e),t.insertAdjacentHTML("afterend",D.g.ZWSP),e.setStartAfter(t.nextSibling),e.collapse(!0),(0,Z.Hc)(e),n.preventDefault()))},me=function(t,n){t.options.lang,t.options;t.wysiwyg.popover.innerHTML="";function e(){""!==i.value.trim()&&(n.innerHTML=i.value),n.setAttribute("href",a.value),n.setAttribute("title",s.value)}n.querySelectorAll("[data-marker]").forEach(function(e){e.removeAttribute("data-marker")});var r=document.createElement("span");r.setAttribute("aria-label",window.VditorI18n.textIsNotEmpty),r.className="vditor-tooltipped vditor-tooltipped__n";var i=document.createElement("input");r.appendChild(i),i.className="vditor-input",i.setAttribute("placeholder",window.VditorI18n.textIsNotEmpty),i.style.width="120px",i.value=n.innerHTML||"",i.oninput=function(){e()},i.onkeydown=function(e){se(t,e)||pe(t,n,e,a)};var o=document.createElement("span");o.setAttribute("aria-label",window.VditorI18n.link),o.className="vditor-tooltipped vditor-tooltipped__n";var a=document.createElement("input");o.appendChild(a),a.className="vditor-input",a.setAttribute("placeholder",window.VditorI18n.link),a.value=n.getAttribute("href")||"",a.oninput=function(){e()},a.onkeydown=function(e){se(t,e)||pe(t,n,e,s)};var l=document.createElement("span");l.setAttribute("aria-label",window.VditorI18n.tooltipText),l.className="vditor-tooltipped vditor-tooltipped__n";var s=document.createElement("input");l.appendChild(s),s.className="vditor-input",s.setAttribute("placeholder",window.VditorI18n.tooltipText),s.style.width="60px",s.value=n.getAttribute("title")||"",s.oninput=function(){e()},s.onkeydown=function(e){se(t,e)||pe(t,n,e,i)},ue(n,t),t.wysiwyg.popover.insertAdjacentElement("beforeend",r),t.wysiwyg.popover.insertAdjacentElement("beforeend",o),t.wysiwyg.popover.insertAdjacentElement("beforeend",l),ce(t,n)},fe=function(e){"wysiwyg"===e.currentMode?de(e):"ir"===e.currentMode&&re(e)},he=function(e,t,n){for(var r,i,o,a,l,s,d=e.startContainer.parentElement,c=!1,u="",p="",s=(i=w((r=e).startContainer),o=b(r.startContainer),a=r.startContainer.textContent,l=r.startOffset,((r=s="")!==a.substr(0,l)&&a.substr(0,l)!==D.g.ZWSP||i)&&(s=""+i+a.substr(0,l)),{afterHTML:r=""!==a.substr(l)&&a.substr(l)!==D.g.ZWSP||o?""+a.substr(l)+o:r,beforeHTML:s}),m=s.beforeHTML,f=s.afterHTML;d&&!c;){var h,v,g,y=d.tagName;"S"===(y="B"===(y="I"===(y="STRIKE"===y?"S":y)?"EM":y)?"STRONG":y)||"STRONG"===y||"EM"===y?(g=v=h="","0"!==d.parentElement.getAttribute("data-block")&&(v=w(d),g=b(d)),(m||v)&&(m=h=v+"<"+y+">"+m+"</"+y+">"),("bold"===n&&"STRONG"===y||"italic"===n&&"EM"===y||"strikeThrough"===n&&"S"===y)&&(h+=""+u+D.g.ZWSP+"<wbr>"+p,c=!0),(f||g)&&(h+=f="<"+y+">"+f+"</"+y+">"+g),"0"!==d.parentElement.getAttribute("data-block")?(d=d.parentElement).innerHTML=h:(d.outerHTML=h,d=d.parentElement),u="<"+y+">"+u,p="</"+y+">"+p):c=!0}(0,Z.ib)(t.wysiwyg.element,e)},ve=function(m,f){var h=this;this.element=document.createElement("div"),f.className&&(t=this.element.classList).add.apply(t,f.className.split(" "));var e=f.hotkey?" <"+(0,B.ns)(f.hotkey)+">":"";2===f.level&&(e=f.hotkey?" &lt;"+(0,B.ns)(f.hotkey)+"&gt;":"");var t=f.tip?f.tip+e:""+window.VditorI18n[f.name]+e,e="upload"===f.name?"div":"button";2===f.level?this.element.innerHTML="<"+e+' data-type="'+f.name+'">'+t+"</"+e+">":(this.element.classList.add("vditor-toolbar__item"),(e=document.createElement(e)).setAttribute("data-type",f.name),e.className="vditor-tooltipped vditor-tooltipped__"+f.tipPosition,e.setAttribute("aria-label",t),e.innerHTML=f.icon,this.element.appendChild(e)),f.prefix&&this.element.children[0].addEventListener((0,B.Le)(),function(e){var t,n,r,i,o,a,l,s,d,c,u,p;e.preventDefault(),h.element.firstElementChild.classList.contains(D.g.CLASS_MENU_DISABLED)||("wysiwyg"===m.currentMode?(t=m,n=h.element.children[0],r=e,t.wysiwyg.composingLock&&r instanceof CustomEvent||(i=p=!0,t.wysiwyg.element.querySelector("wbr")&&t.wysiwyg.element.querySelector("wbr").remove(),e=(0,Z.zh)(t),r=n.getAttribute("data-type"),n.classList.contains("vditor-menu--current")?"quote"===(r="strike"===r?"strikeThrough":r)?(a=(a=(0,U.lG)(e.startContainer,"BLOCKQUOTE"))||e.startContainer.childNodes[e.startOffset])&&(p=!1,n.classList.remove("vditor-menu--current"),e.insertNode(document.createElement("wbr")),a.outerHTML=""===a.innerHTML.trim()?'<p data-block="0">'+a.innerHTML+"</p>":a.innerHTML,(0,Z.ib)(t.wysiwyg.element,e)):"inline-code"===r?(o=(o=(0,U.lG)(e.startContainer,"CODE"))||e.startContainer.childNodes[e.startOffset])&&(o.outerHTML=o.innerHTML.replace(D.g.ZWSP,"")+"<wbr>",(0,Z.ib)(t.wysiwyg.element,e)):"link"===r?(e.collapsed&&e.selectNode(e.startContainer.parentElement),document.execCommand("unlink",!1,"")):"check"===r||"list"===r||"ordered-list"===r?(ft(t,e,r),(0,Z.ib)(t.wysiwyg.element,e),p=!1,n.classList.remove("vditor-menu--current")):(p=!1,n.classList.remove("vditor-menu--current"),""===e.toString()?he(e,t,r):document.execCommand(r,!1,"")):(0===t.wysiwyg.element.childNodes.length&&(t.wysiwyg.element.innerHTML='<p data-block="0"><wbr></p>',(0,Z.ib)(t.wysiwyg.element,e)),a=(0,U.F9)(e.startContainer),"quote"===r?(a=a||e.startContainer.childNodes[e.startOffset])&&(p=!1,n.classList.add("vditor-menu--current"),e.insertNode(document.createElement("wbr")),(o=(0,U.lG)(e.startContainer,"LI"))&&a.contains(o)?o.innerHTML='<blockquote data-block="0">'+o.innerHTML+"</blockquote>":a.outerHTML='<blockquote data-block="0">'+a.outerHTML+"</blockquote>",(0,Z.ib)(t.wysiwyg.element,e)):"check"===r||"list"===r||"ordered-list"===r?(ft(t,e,r,!1),(0,Z.ib)(t.wysiwyg.element,e),p=!1,q(t.toolbar.elements,["check","list","ordered-list"]),n.classList.add("vditor-menu--current")):"inline-code"===r?(""===e.toString()?((u=document.createElement("code")).textContent=D.g.ZWSP,e.insertNode(u),e.setStart(u.firstChild,1),e.collapse(!0),(0,Z.Hc)(e)):3===e.startContainer.nodeType&&(u=document.createElement("code"),e.surroundContents(u),e.insertNode(u),(0,Z.Hc)(e)),n.classList.add("vditor-menu--current")):"code"===r?((u=document.createElement("div")).className="vditor-wysiwyg__block",u.setAttribute("data-type","code-block"),u.setAttribute("data-block","0"),u.setAttribute("data-marker","```"),""===e.toString()?u.innerHTML="<pre><code><wbr>\n</code></pre>":(u.innerHTML="<pre><code>"+e.toString()+"<wbr></code></pre>",e.deleteContents()),e.insertNode(u),a&&(a.outerHTML=t.lute.SpinVditorDOM(a.outerHTML)),(0,Z.ib)(t.wysiwyg.element,e),t.wysiwyg.element.querySelectorAll(".vditor-wysiwyg__preview[data-render='2']").forEach(function(e){F(e,t)}),n.classList.add("vditor-menu--disabled")):"link"===r?(""===e.toString()?((l=document.createElement("a")).innerText=D.g.ZWSP,e.insertNode(l),e.setStart(l.firstChild,1),e.collapse(!0),me(t,l),(l=t.wysiwyg.popover.querySelector("input")).value="",l.focus(),i=!1):((u=document.createElement("a")).setAttribute("href",""),u.innerHTML=e.toString(),e.surroundContents(u),e.insertNode(u),(0,Z.Hc)(e),me(t,u),(l=t.wysiwyg.popover.querySelectorAll("input"))[0].value=u.innerText,l[1].focus()),p=!1,n.classList.add("vditor-menu--current")):"table"===r?(s='<table data-block="0"><thead><tr><th>col1<wbr></th><th>col2</th><th>col3</th></tr></thead><tbody><tr><td> </td><td> </td><td> </td></tr><tr><td> </td><td> </td><td> </td></tr></tbody></table>',""===e.toString().trim()?(a&&""===a.innerHTML.trim().replace(D.g.ZWSP,"")?a.outerHTML=s:document.execCommand("insertHTML",!1,s),e.selectNode(t.wysiwyg.element.querySelector("wbr").previousSibling),t.wysiwyg.element.querySelector("wbr").remove(),(0,Z.Hc)(e)):(s='<table data-block="0"><thead><tr>',c=e.toString().split("\n"),d=c[0].split(",").length>c[0].split("\t").length?",":"\t",c.forEach(function(e,t){0===t?(e.split(d).forEach(function(e,t){s+=0===t?"<th>"+e+"<wbr></th>":"<th>"+e+"</th>"}),s+="</tr></thead>"):(s+=1===t?"<tbody><tr>":"<tr>",e.split(d).forEach(function(e){s+="<td>"+e+"</td>"}),s+="</tr>")}),s+="</tbody></table>",document.execCommand("insertHTML",!1,s),(0,Z.ib)(t.wysiwyg.element,e)),p=!1,n.classList.add("vditor-menu--disabled")):"line"===r?a&&(c='<hr data-block="0"><p data-block="0"><wbr>\n</p>',""===a.innerHTML.trim()?a.outerHTML=c:a.insertAdjacentHTML("afterend",c),(0,Z.ib)(t.wysiwyg.element,e)):(p=!1,n.classList.add("vditor-menu--current"),"strike"===r&&(r="strikeThrough"),""!==e.toString()||"bold"!==r&&"italic"!==r&&"strikeThrough"!==r?document.execCommand(r,!1,""):(n="strong","italic"===r?n="em":"strikeThrough"===r&&(n="s"),(u=document.createElement(n)).textContent=D.g.ZWSP,e.insertNode(u),u.previousSibling&&u.previousSibling.textContent===D.g.ZWSP&&(u.previousSibling.textContent=""),e.setStart(u.firstChild,1),e.collapse(!0),(0,Z.Hc)(e)))),p&&de(t),i&&ie(t))):("ir"===m.currentMode?At:Qe)(m,h.element.children[0],f.prefix||"",f.suffix||""))})},n=(S=function(e,t){return(S=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])})(e,t)},function(e,t){function n(){this.constructor=e}S(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)}),ge=function(t,e,n){var r="string"!=typeof n?(L(t,["subToolbar","hint"]),n.preventDefault(),a(t)):n;t.currentMode===e&&"string"!=typeof n||(t.devtools&&t.devtools.renderEchart(t),"both"===t.options.preview.mode&&"sv"===e?t.preview.element.style.display="block":t.preview.element.style.display="none",O(t.toolbar.elements,D.g.EDIT_TOOLBARS),q(t.toolbar.elements,D.g.EDIT_TOOLBARS),I(t.toolbar.elements,["outdent","indent"]),"ir"===e?(l(t.toolbar.elements,["both"]),s(t.toolbar.elements,["outdent","indent","outline","insert-before","insert-after"]),t.sv.element.style.display="none",t.wysiwyg.element.parentElement.style.display="none",t.ir.element.parentElement.style.display="block",t.lute.SetVditorIR(!0),t.lute.SetVditorWYSIWYG(!1),t.lute.SetVditorSV(!1),t.currentMode="ir",t.ir.element.innerHTML=t.lute.Md2VditorIRDOM(r),Mt(t,{enableAddUndoStack:!0,enableHint:!1,enableInput:!1}),te(t),t.ir.element.querySelectorAll(".vditor-ir__preview[data-render='2']").forEach(function(e){F(e,t)}),t.ir.element.querySelectorAll(".vditor-toc").forEach(function(e){(0,N.H)(e,{cdn:t.options.cdn,math:t.options.preview.math})})):"wysiwyg"===e?(l(t.toolbar.elements,["both"]),s(t.toolbar.elements,["outdent","indent","outline","insert-before","insert-after"]),t.sv.element.style.display="none",t.wysiwyg.element.parentElement.style.display="block",t.ir.element.parentElement.style.display="none",t.lute.SetVditorIR(!1),t.lute.SetVditorWYSIWYG(!0),t.lute.SetVditorSV(!1),t.currentMode="wysiwyg",te(t),k(t,r,{enableAddUndoStack:!0,enableHint:!1,enableInput:!1}),t.wysiwyg.element.querySelectorAll(".vditor-toc").forEach(function(e){(0,N.H)(e,{cdn:t.options.cdn,math:t.options.preview.math})}),t.wysiwyg.popover.style.display="none"):"sv"===e&&(s(t.toolbar.elements,["both"]),l(t.toolbar.elements,["outdent","indent","outline","insert-before","insert-after"]),t.wysiwyg.element.parentElement.style.display="none",t.ir.element.parentElement.style.display="none","both"!==t.options.preview.mode&&"editor"!==t.options.preview.mode||(t.sv.element.style.display="block"),t.lute.SetVditorIR(!1),t.lute.SetVditorWYSIWYG(!1),t.lute.SetVditorSV(!0),t.currentMode="sv",r=Je(r,t),t.sv.element.innerHTML=r="<div data-block='0'></div>"===r?"":r,Xe(t,{enableAddUndoStack:!0,enableHint:!1,enableInput:!1}),te(t)),t.undo.resetIcon(t),"string"!=typeof n&&(t[t.currentMode].element.focus(),fe(t)),g(t),ne(t),t.toolbar.elements["edit-mode"]&&(t.toolbar.elements["edit-mode"].querySelectorAll("button").forEach(function(e){e.classList.remove("vditor-menu--current")}),t.toolbar.elements["edit-mode"].querySelector('button[data-mode="'+t.currentMode+'"]').classList.add("vditor-menu--current")),t.outline.toggle(t,"sv"!==t.currentMode&&t.options.outline.enable))},ye=(n(be,C=ve),be.prototype._bindEvent=function(t,e,n){var r=this.element.children[0];d(t,e,r,n.level),e.children.item(0).addEventListener((0,B.Le)(),function(e){ge(t,"wysiwyg",e),e.preventDefault(),e.stopPropagation()}),e.children.item(1).addEventListener((0,B.Le)(),function(e){ge(t,"ir",e),e.preventDefault(),e.stopPropagation()}),e.children.item(2).addEventListener((0,B.Le)(),function(e){ge(t,"sv",e),e.preventDefault(),e.stopPropagation()})},be);function be(e,t){var n=C.call(this,e,t)||this,r=document.createElement("div");return r.className="vditor-hint"+(2===t.level?"":" vditor-panel--arrow"),r.innerHTML='<button data-mode="wysiwyg">'+window.VditorI18n.wysiwyg+" &lt;"+(0,B.ns)("⌥⌘7")+'></button>\n<button data-mode="ir">'+window.VditorI18n.instantRendering+" &lt;"+(0,B.ns)("⌥⌘8")+'></button>\n<button data-mode="sv">'+window.VditorI18n.splitView+" &lt;"+(0,B.ns)("⌥⌘9")+"></button>",n.element.appendChild(r),n._bindEvent(e,r,t),n}function we(e,t){t.addEventListener("focus",function(){e.options.focus&&e.options.focus(a(e)),L(e,["subToolbar"])})}function Ee(t,e){e.addEventListener("dblclick",function(e){"IMG"===e.target.tagName&&(0,Q.E)(e.target,t.options.lang,t.options.theme)})}function ke(n,e){e.addEventListener("blur",function(e){var t;"ir"===n.currentMode?(t=n.ir.element.querySelector(".vditor-ir__node--expand"))&&t.classList.remove("vditor-ir__node--expand"):"wysiwyg"!==n.currentMode||n.wysiwyg.selectPopover.contains(e.relatedTarget)||n.wysiwyg.hideComment(),n[n.currentMode].range=(0,Z.zh)(n),n.options.blur&&n.options.blur(a(n))})}function Se(t,e){e.addEventListener("dragstart",function(e){e.dataTransfer.setData(D.g.DROP_EDITOR,D.g.DROP_EDITOR)}),e.addEventListener("drop",function(e){e.dataTransfer.getData(D.g.DROP_EDITOR)?wt(t):"Files"!==e.dataTransfer.types[0]&&!e.dataTransfer.types.includes("text/html")||Tt(t,e,{pasteCode:function(e){document.execCommand("insertHTML",!1,e)}})})}function Ce(t,e,n){e.addEventListener("copy",function(e){return n(e,t)})}function Le(t,e,n){e.addEventListener("cut",function(e){n(e,t),t.options.comment.enable&&"wysiwyg"===t.currentMode&&t.wysiwyg.getComments(t),document.execCommand("delete")})}function Te(n,e){e.addEventListener("keydown",function(t){if(!(1<n.options.hint.extend.length||n.toolbar.elements.emoji)||!n.hint.select(t,n)){if(n.options.comment.enable&&"wysiwyg"===n.currentMode&&("Backspace"===t.key||X("⌘X",t))&&n.wysiwyg.getComments(n),"sv"===n.currentMode){if($(n,t))return}else if("wysiwyg"===n.currentMode){if(le(n,t))return}else if("ir"===n.currentMode&&Y(n,t))return;return n.options.ctrlEnter&&X("⌘Enter",t)?(n.options.ctrlEnter(a(n)),void t.preventDefault()):X("⌘Z",t)&&!n.toolbar.elements.undo?(n.undo.undo(n),void t.preventDefault()):X("⌘Y",t)&&!n.toolbar.elements.redo?(n.undo.redo(n),void t.preventDefault()):"Escape"===t.key?("block"===n.hint.element.style.display?n.hint.element.style.display="none":n.options.esc&&!t.isComposing&&n.options.esc(a(n)),void t.preventDefault()):(0,B.yl)(t)&&t.altKey&&!t.shiftKey&&/^Digit[1-6]$/.test(t.code)?("wysiwyg"===n.currentMode?(e=t.code.replace("Digit","H"),(0,U.lG)(getSelection().getRangeAt(0).startContainer,e)?ae(n):oe(n,e),ie(n)):"sv"===n.currentMode?Ye(n,"#".repeat(parseInt(t.code.replace("Digit",""),10))+" "):"ir"===n.currentMode&&_t(n,"#".repeat(parseInt(t.code.replace("Digit",""),10))+" "),t.preventDefault(),!0):(0,B.yl)(t)&&t.altKey&&!t.shiftKey&&/^Digit[7-9]$/.test(t.code)?("Digit7"===t.code?ge(n,"wysiwyg",t):"Digit8"===t.code?ge(n,"ir",t):"Digit9"===t.code&&ge(n,"sv",t),!0):void n.options.toolbar.find(function(e){return!e.hotkey||e.toolbar?!!e.toolbar&&!!e.toolbar.find(function(e){return!!e.hotkey&&(X(e.hotkey,t)?(n.toolbar.elements[e.name].children[0].dispatchEvent(new CustomEvent((0,B.Le)())),t.preventDefault(),!0):void 0)}):X(e.hotkey,t)?(n.toolbar.elements[e.name].children[0].dispatchEvent(new CustomEvent((0,B.Le)())),t.preventDefault(),!0):void 0});var e}})}function Me(n,e){e.addEventListener("selectstart",function(t){e.onmouseup=function(){setTimeout(function(){var e=ze(n[n.currentMode].element);e.trim()?("wysiwyg"===n.currentMode&&n.options.comment.enable&&((0,U.a1)(t.target,"data-type","footnotes-block")||(0,U.a1)(t.target,"data-type","link-ref-defs-block")?n.wysiwyg.hideComment():n.wysiwyg.showComment()),n.options.select&&n.options.select(e)):"wysiwyg"===n.currentMode&&n.options.comment.enable&&n.wysiwyg.hideComment()})}})}function _e(e,t){var n=(0,Z.zh)(e);n.extractContents(),n.insertNode(document.createTextNode(Lute.Caret)),n.insertNode(document.createTextNode(t));var r=(r=(0,U.a1)(n.startContainer,"data-block","0"))||e.sv.element,t="<div data-block='0'>"+e.lute.Md2VditorSVDOM(r.textContent).replace(/<span data-type="newline"><br \/><span style="display: none">\n<\/span><\/span><span data-type="newline"><br \/><span style="display: none">\n<\/span><\/span></g,'<span data-type="newline"><br /><span style="display: none">\n</span></span><span data-type="newline"><br /><span style="display: none">\n</span></span></div><div data-block="0"><')+"</div>";r.isEqualNode(e.sv.element)?r.innerHTML=t:r.outerHTML=t,(0,Z.ib)(e.sv.element,n),Fe(e)}function Ae(h,v,g){return tt(void 0,void 0,void 0,function(){var t,n,r,i,o,a,l,s,d,c,u,p,m,f;return nt(this,function(e){switch(e.label){case 0:for(t=[],n=!0===h.options.upload.multiple?v.length:1,p=0;p<n;p++)(r=v[p])instanceof DataTransferItem&&(r=r.getAsFile()),t.push(r);return h.options.upload.handler?("string"==typeof(i=h.options.upload.handler(t))&&h.tip.show(i),[2]):h.options.upload.url&&h.upload?h.options.upload.file?[4,h.options.upload.file(t)]:[3,2]:(g&&(g.value=""),h.tip.show("please config: options.upload.url"),[2]);case 1:t=e.sent(),e.label=2;case 2:if(h.options.upload.validate&&"string"==typeof(i=h.options.upload.validate(t)))return h.tip.show(i),[2];if(o=$e(h),h.upload.range=(0,Z.zh)(h),0===(a=it(h,t)).length)return g&&(g.value=""),[2];for(l=new FormData,s=h.options.upload.extraData,d=0,c=Object.keys(s);d<c.length;d++)u=c[d],l.append(u,s[u]);for(p=0,m=a.length;p<m;p++)l.append(h.options.upload.fieldName,a[p]);return(f=new XMLHttpRequest).open("POST",h.options.upload.url),h.options.upload.token&&f.setRequestHeader("X-Upload-Token",h.options.upload.token),h.options.upload.withCredentials&&(f.withCredentials=!0),et(h,f),h.upload.isUploading=!0,o.setAttribute("contenteditable","false"),f.onreadystatechange=function(){var e;f.readyState===XMLHttpRequest.DONE&&(h.upload.isUploading=!1,o.setAttribute("contenteditable","true"),200<=f.status&&f.status<300?h.options.upload.success?h.options.upload.success(o,f.responseText):(e=f.responseText,h.options.upload.format&&(e=h.options.upload.format(v,f.responseText)),ot(e,h)):h.options.upload.error?h.options.upload.error(f.responseText):h.tip.show(f.responseText),g&&(g.value=""),h.upload.element.style.display="none")},f.upload.onprogress=function(e){e.lengthComputable&&(e=e.loaded/e.total*100,h.upload.element.style.display="block",h.upload.element.style.width=e+"%")},f.send(l),[2]}})})}function xe(e,t,n){if(229===e.keyCode&&""===e.code&&"Unidentified"===e.key&&"sv"!==t.currentMode){n=(0,U.F9)(n);if(n&&""===n.textContent.trim())return t[t.currentMode].composingLock=!0,0}return 1}function He(e,t,n){"Enter"===n.key||"Tab"===n.key||"Backspace"===n.key||-1<n.key.indexOf("Arrow")||(0,B.yl)(n)||"Escape"===n.key||n.shiftKey||n.altKey||(n=(0,U.lG)(e.startContainer,"P")||(0,U.lG)(e.startContainer,"LI"))&&0===(0,Z.im)(n,t[t.currentMode].element,e).start&&(t=document.createTextNode(D.g.ZWSP),e.insertNode(t),e.setStartAfter(t))}function Ne(e,t){var n;"ArrowDown"!==t&&"ArrowUp"!==t||(n=(0,U.a1)(e.startContainer,"data-type","math-inline")||(0,U.a1)(e.startContainer,"data-type","html-entity")||(0,U.a1)(e.startContainer,"data-type","html-inline"))&&("ArrowDown"===t&&e.setStartAfter(n.parentElement),"ArrowUp"===t&&e.setStartBefore(n.parentElement))}function De(e,t,n,r){var i=e.startContainer,o=(0,U.lG)(i,"LI");if(o){if(!(0,B.yl)(r)&&!r.altKey&&"Enter"===r.key&&!r.shiftKey&&n&&o.contains(n)&&n.nextElementSibling)return o&&!o.textContent.endsWith("\n")&&o.insertAdjacentText("beforeend","\n"),e.insertNode(document.createTextNode("\n\n")),e.collapse(!1),wt(t),r.preventDefault(),1;if(!((0,B.yl)(r)||r.shiftKey||r.altKey||"Backspace"!==r.key||o.previousElementSibling||""!==e.toString()||0!==(0,Z.im)(o,t[t.currentMode].element,e).start))return o.nextElementSibling?(o.parentElement.insertAdjacentHTML("beforebegin",'<p data-block="0"><wbr>'+o.innerHTML+"</p>"),o.remove()):o.parentElement.outerHTML='<p data-block="0"><wbr>'+o.innerHTML+"</p>",(0,Z.ib)(t[t.currentMode].element,e),wt(t),r.preventDefault(),1;if(!(0,B.yl)(r)&&!r.shiftKey&&!r.altKey&&"Backspace"===r.key&&""===o.textContent.trim().replace(D.g.ZWSP,"")&&""===e.toString()&&"LI"===(null===(a=o.previousElementSibling)||void 0===a?void 0:a.tagName))return o.previousElementSibling.insertAdjacentText("beforeend","\n\n"),e.selectNodeContents(o.previousElementSibling),e.collapse(!1),o.remove(),(0,Z.ib)(t[t.currentMode].element,e),wt(t),r.preventDefault(),1;if(!(0,B.yl)(r)&&!r.altKey&&"Tab"===r.key){var a=!1;if((a=0===e.startOffset&&(3===i.nodeType&&!i.previousSibling||3!==i.nodeType&&"LI"===i.nodeName)||o.classList.contains("vditor-task")&&1===e.startOffset&&3!==i.previousSibling.nodeType&&"INPUT"===i.previousSibling.tagName?!0:a)||""!==e.toString())return r.shiftKey?vt(t,o,e,o.parentElement):ht(t,o,e),r.preventDefault(),1}}}function Oe(e,t,n){return e.options.tab&&"Tab"===n.key&&(n.shiftKey||(""===t.toString()||t.extractContents(),t.insertNode(document.createTextNode(e.options.tab)),t.collapse(!1)),(0,Z.Hc)(t),wt(e),n.preventDefault(),1)}function Ie(e,t,n,r){if(n){if(!(0,B.yl)(e)&&!e.altKey&&"Enter"===e.key){var i=String.raw(Ge=Ge||lt(["",""],["",""]),n.textContent).replace(/\\\|/g,"").trim(),o=i.split("|");if(i.startsWith("|")&&i.endsWith("|")&&3<o.length){var a=o.map(function(){return"---"}).join("|"),a=n.textContent+"\n"+a.substring(3,a.length-3)+"\n|<wbr>";return n.outerHTML=t.lute.SpinVditorDOM(a),(0,Z.ib)(t[t.currentMode].element,r),wt(t),Fe(t),e.preventDefault(),1}if(yt(n.innerHTML)&&n.previousElementSibling){o="",a=n.innerHTML.trimRight().split("\n");return 1<a.length&&(a.pop(),o='<p data-block="0">'+a.join("\n")+"</p>"),n.insertAdjacentHTML("afterend",o+'<hr data-block="0"><p data-block="0"><wbr>\n</p>'),n.remove(),(0,Z.ib)(t[t.currentMode].element,r),wt(t),Fe(t),e.preventDefault(),1}if(bt(n.innerHTML))return"wysiwyg"===t.currentMode?n.outerHTML=t.lute.SpinVditorDOM(n.innerHTML+'<p data-block="0"><wbr>\n</p>'):n.outerHTML=t.lute.SpinVditorIRDOM(n.innerHTML+'<p data-block="0"><wbr>\n</p>'),(0,Z.ib)(t[t.currentMode].element,r),wt(t),Fe(t),e.preventDefault(),1}if(r.collapsed&&n.previousElementSibling&&"Backspace"===e.key&&!(0,B.yl)(e)&&!e.altKey&&!e.shiftKey&&1<n.textContent.trimRight().split("\n").length&&0===(0,Z.im)(n,t[t.currentMode].element,r).start){e=(0,U.DX)(n.previousElementSibling);return e.textContent.endsWith("\n")||(e.textContent=e.textContent+"\n"),e.parentElement.insertAdjacentHTML("beforeend","<wbr>"+n.innerHTML),n.remove(),(0,Z.ib)(t[t.currentMode].element,r),0}}else;}function je(e,t,n){var r=n.startContainer,i=(0,U.lG)(r,"TD")||(0,U.lG)(r,"TH");if(i){if(!(0,B.yl)(t)&&!t.altKey&&"Enter"===t.key){i.lastElementChild&&(!i.lastElementChild||i.lastElementChild.isSameNode(i.lastChild)&&"BR"===i.lastElementChild.tagName)||i.insertAdjacentHTML("beforeend","<br>");var o=document.createElement("br");return n.insertNode(o),n.setStartAfter(o),wt(e),Fe(e),t.preventDefault(),1}if("Tab"===t.key)return t.shiftKey?(ut(i,n),t.preventDefault(),!0):((d=(d=i.nextElementSibling)||(i.parentElement.nextElementSibling?i.parentElement.nextElementSibling.firstElementChild:"THEAD"===i.parentElement.parentElement.tagName&&i.parentElement.parentElement.nextElementSibling?i.parentElement.parentElement.nextElementSibling.firstElementChild.firstElementChild:null))&&(n.selectNodeContents(d),(0,Z.Hc)(n)),t.preventDefault(),!0);var a,r=i.parentElement.parentElement.parentElement;if("ArrowUp"===t.key){if(t.preventDefault(),"TH"===i.tagName)return r.previousElementSibling?(n.selectNodeContents(r.previousElementSibling),n.collapse(!1),(0,Z.Hc)(n)):ct(e,"beforebegin"),1;for(var l=0,s=i.parentElement;l<s.cells.length&&!s.cells[l].isSameNode(i);l++);o=(o=s.previousElementSibling)||s.parentElement.previousElementSibling.firstChild;return n.selectNodeContents(o.cells[l]),n.collapse(!1),(0,Z.Hc)(n),1}if("ArrowDown"===t.key){if(t.preventDefault(),!(s=i.parentElement).nextElementSibling&&"TD"===i.tagName)return r.nextElementSibling?(n.selectNodeContents(r.nextElementSibling),n.collapse(!0),(0,Z.Hc)(n)):ct(e,"afterend"),1;for(l=0;l<s.cells.length&&!s.cells[l].isSameNode(i);l++);return d=(d=s.nextElementSibling)||s.parentElement.nextElementSibling.firstChild,n.selectNodeContents(d.cells[l]),n.collapse(!0),(0,Z.Hc)(n),1}if("wysiwyg"===e.currentMode&&!(0,B.yl)(t)&&"Enter"===t.key&&!t.shiftKey&&t.altKey){var d=e.wysiwyg.popover.querySelector(".vditor-input");return d.focus(),d.select(),t.preventDefault(),1}if(!(0,B.yl)(t)&&!t.shiftKey&&!t.altKey&&"Backspace"===t.key&&0===n.startOffset&&""===n.toString())return!ut(i,n,!1)&&r&&(""===r.textContent.trim()?(r.outerHTML='<p data-block="0"><wbr>\n</p>',(0,Z.ib)(e[e.currentMode].element,n)):(n.setStartBefore(r),n.collapse(!0)),wt(e)),t.preventDefault(),1;if(X("⇧⌘F",t))return kt(e,n,i),t.preventDefault(),1;if(X("⌘=",t))return Et(e,n,i),t.preventDefault(),1;if(X("⇧⌘G",t))return St(e,r,i,"beforebegin"),t.preventDefault(),1;if(X("⇧⌘=",t))return St(e,r,i),t.preventDefault(),1;if(X("⌘-",t))return Ct(e,n,i),t.preventDefault(),1;if(X("⇧⌘-",t))return Lt(e,n,r,i),t.preventDefault(),1;if(X("⇧⌘L",t)){if("ir"===e.currentMode)return gt(r,"left"),wt(e),t.preventDefault(),1;if(a=e.wysiwyg.popover.querySelector('[data-type="left"]'))return a.click(),t.preventDefault(),1}if(X("⇧⌘C",t)){if("ir"===e.currentMode)return gt(r,"center"),wt(e),t.preventDefault(),1;if(a=e.wysiwyg.popover.querySelector('[data-type="center"]'))return a.click(),t.preventDefault(),1}if(X("⇧⌘R",t)){if("ir"===e.currentMode)return gt(r,"right"),wt(e),t.preventDefault(),1;if(a=e.wysiwyg.popover.querySelector('[data-type="right"]'))return a.click(),t.preventDefault(),1}}}function Re(e,t,n,r){if("PRE"===n.tagName&&X("⌘A",t))return r.selectNodeContents(n.firstElementChild),t.preventDefault(),1;if(e.options.tab&&"Tab"===t.key&&!t.shiftKey&&""===r.toString())return r.insertNode(document.createTextNode(e.options.tab)),r.collapse(!1),wt(e),t.preventDefault(),1;if("Backspace"===t.key&&!(0,B.yl)(t)&&!t.shiftKey&&!t.altKey){var i=(0,Z.im)(n,e[e.currentMode].element,r);if((0===i.start||1===i.start&&"\n"===n.innerText)&&""===r.toString())return n.parentElement.outerHTML='<p data-block="0"><wbr>'+n.firstElementChild.innerHTML+"</p>",(0,Z.ib)(e[e.currentMode].element,r),wt(e),t.preventDefault(),1}return!(0,B.yl)(t)&&!t.altKey&&"Enter"===t.key&&(n.firstElementChild.textContent.endsWith("\n")||n.firstElementChild.insertAdjacentText("beforeend","\n"),r.extractContents(),r.insertNode(document.createTextNode("\n")),r.collapse(!1),(0,Z.Hc)(r),(0,B.vU)()||("wysiwyg"===e.currentMode?at:J)(e,r),Fe(e),t.preventDefault(),!0)}function Pe(e,t,n,r){var i=t.startContainer,o=(0,U.lG)(i,"BLOCKQUOTE");if(o&&""===t.toString()){if("Backspace"===n.key&&!(0,B.yl)(n)&&!n.shiftKey&&!n.altKey&&0===(0,Z.im)(o,e[e.currentMode].element,t).start)return t.insertNode(document.createElement("wbr")),o.outerHTML=o.innerHTML,(0,Z.ib)(e[e.currentMode].element,t),wt(e),n.preventDefault(),1;if(r&&"Enter"===n.key&&!(0,B.yl)(n)&&!n.shiftKey&&!n.altKey&&"BLOCKQUOTE"===r.parentElement.tagName){var a=!1;if("\n"===r.innerHTML.replace(D.g.ZWSP,"")||""===r.innerHTML.replace(D.g.ZWSP,"")?(a=!0,r.remove()):r.innerHTML.endsWith("\n\n")&&(0,Z.im)(r,e[e.currentMode].element,t).start===r.textContent.length-1&&(r.innerHTML=r.innerHTML.substr(0,r.innerHTML.length-2),a=!0),a)return o.insertAdjacentHTML("afterend",'<p data-block="0">'+D.g.ZWSP+"<wbr>\n</p>"),(0,Z.ib)(e[e.currentMode].element,t),wt(e),n.preventDefault(),1}i=(0,U.F9)(i);if("wysiwyg"===e.currentMode&&i&&X("⇧⌘;",n))return t.insertNode(document.createElement("wbr")),i.outerHTML='<blockquote data-block="0">'+i.outerHTML+"</blockquote>",(0,Z.ib)(e.wysiwyg.element,t),ie(e),n.preventDefault(),1;if(pt(e,n,t,o,o))return 1;if(mt(e,n,t,o,o))return 1}}function Be(e,t,n){var r,i,o,a,l=t.startContainer,s=(0,U.fb)(l,"vditor-task");if(s){if(X("⇧⌘J",n)){var d=s.firstElementChild;return d.checked?d.removeAttribute("checked"):d.setAttribute("checked","checked"),wt(e),n.preventDefault(),1}if("Backspace"===n.key&&!(0,B.yl)(n)&&!n.shiftKey&&!n.altKey&&""===t.toString()&&1===t.startOffset&&(3===l.nodeType&&l.previousSibling&&"INPUT"===l.previousSibling.tagName||3!==l.nodeType)){var c=s.previousElementSibling;return s.querySelector("input").remove(),c?((0,U.DX)(c).parentElement.insertAdjacentHTML("beforeend","<wbr>"+s.innerHTML.trim()),s.remove()):(s.parentElement.insertAdjacentHTML("beforebegin",'<p data-block="0"><wbr>'+(s.innerHTML.trim()||"\n")+"</p>"),(s.nextElementSibling?s:s.parentElement).remove()),(0,Z.ib)(e[e.currentMode].element,t),wt(e),n.preventDefault(),1}if("Enter"===n.key&&!(0,B.yl)(n)&&!n.shiftKey&&!n.altKey)return""===s.textContent.trim()?(0,U.fb)(s.parentElement,"vditor-task")?(a=(0,U.O9)(l))&&vt(e,s,t,a):s.nextElementSibling?(i=r="",o=!1,Array.from(s.parentElement.children).forEach(function(e){s.isSameNode(e)?o=!0:o?r+=e.outerHTML:i+=e.outerHTML}),d=s.parentElement.tagName,c="OL"===s.parentElement.tagName?"":' data-marker="'+s.parentElement.getAttribute("data-marker")+'"',a="",i&&(a="UL"===s.parentElement.tagName?"":' start="1"',i="<"+d+' data-tight="true"'+c+' data-block="0">'+i+"</"+d+">"),s.parentElement.outerHTML=i+'<p data-block="0"><wbr>\n</p><'+d+'\n data-tight="true"'+c+' data-block="0"'+a+">"+r+"</"+d+">"):(s.parentElement.insertAdjacentHTML("afterend",'<p data-block="0"><wbr>\n</p>'),(1===s.parentElement.querySelectorAll("li").length?s.parentElement:s).remove()):3!==l.nodeType&&0===t.startOffset&&"INPUT"===l.firstChild.tagName?t.setStart(l.childNodes[1],1):(t.setEndAfter(s.lastChild),s.insertAdjacentHTML("afterend",'<li class="vditor-task" data-marker="'+s.getAttribute("data-marker")+'"><input type="checkbox"> <wbr></li>'),document.querySelector("wbr").after(t.extractContents())),(0,Z.ib)(e[e.currentMode].element,t),wt(e),Fe(e),n.preventDefault(),1}}function qe(e,t,n,r){if(3!==t.startContainer.nodeType){var i=t.startContainer.children[t.startOffset];if(i&&"HR"===i.tagName)return t.selectNodeContents(i.previousElementSibling),t.collapse(!1),n.preventDefault(),1}if(r){var o=r.previousElementSibling;if(o&&0===(0,Z.im)(r,e[e.currentMode].element,t).start&&((0,B.vU)()&&"HR"===o.tagName||"TABLE"===o.tagName))return"TABLE"===o.tagName?((i=o.lastElementChild.lastElementChild.lastElementChild).innerHTML=i.innerHTML.trimLeft()+"<wbr>"+r.textContent.trim(),r.remove()):o.remove(),(0,Z.ib)(e[e.currentMode].element,t),wt(e),n.preventDefault(),1}}function Ve(e){(0,B.vU)()&&3!==e.startContainer.nodeType&&"HR"===e.startContainer.tagName&&e.setStartBefore(e.startContainer)}function Ue(e,t,n){var r;if((0,B.vU)()){if("ArrowUp"===e.key&&t&&"TABLE"===(null===(r=t.previousElementSibling)||void 0===r?void 0:r.tagName)){var i=t.previousElementSibling;return n.selectNodeContents(i.rows[i.rows.length-1].lastElementChild),n.collapse(!1),e.preventDefault(),1}return!("ArrowDown"!==e.key||!t||"TABLE"!==(null===(i=t.nextElementSibling)||void 0===i?void 0:i.tagName))&&(n.selectNodeContents(t.nextElementSibling.rows[0].cells[0]),n.collapse(!0),e.preventDefault(),!0)}}function We(e){e.hint.render(e);var t,n,r=(0,Z.zh)(e).startContainer;(r=(0,U.a1)(r,"data-type","code-block-info"))&&(""===r.textContent.replace(D.g.ZWSP,"")&&e.hint.recentLanguage?(r.textContent=D.g.ZWSP+e.hint.recentLanguage,(0,Z.zh)(e).selectNodeContents(r)):(t=[],n=r.textContent.substring(0,(0,Z.im)(r,e.ir.element).start).replace(D.g.ZWSP,""),D.g.CODE_LANGUAGES.forEach(function(e){-1<e.indexOf(n.toLowerCase())&&t.push({html:e,value:e})}),e.hint.genHTML(t,n,e)))}function Ke(e,t,n){(n=(0,U.a1)(e.startContainer,"data-type",n))&&(n.firstElementChild.remove(),n.lastElementChild.remove(),e.insertNode(document.createElement("wbr")),(e=document.createElement("div")).innerHTML=t.lute.SpinVditorIRDOM(n.outerHTML),n.outerHTML=e.firstElementChild.innerHTML.trim())}var Ge,ze=function(e,t){return(0,Z.Gb)(e,t)?getSelection().toString():""},Fe=function(e){var t,n;"wysiwyg"===e.currentMode&&e.options.comment.enable&&e.options.comment.adjustTop(e.wysiwyg.getComments(e,!0)),e.options.typewriterMode&&(t=e[e.currentMode].element,n=(0,Z.Ny)(t).top,"string"!=typeof e.options.height||e.element.classList.contains("vditor--fullscreen")||window.scrollTo(window.scrollX,n+e.element.offsetTop+e.toolbar.element.offsetHeight-window.innerHeight/2+10),"number"!=typeof e.options.height&&!e.element.classList.contains("vditor--fullscreen")||(t.scrollTop=n+t.scrollTop-t.clientHeight/2+10))},Ze=function(e,t,n){void 0===n&&(n=!0);var r=e;for(3===r.nodeType&&(r=r.parentElement);r;){if(r.getAttribute("data-type")===t)return r;r=n?r.previousElementSibling:r.nextElementSibling}return!1},Je=function(e,t){return v("SpinVditorSVDOM",e,"argument",t.options.debugger),e="<div data-block='0'>"+t.lute.SpinVditorSVDOM(e).replace(/<span data-type="newline"><br \/><span style="display: none">\n<\/span><\/span><span data-type="newline"><br \/><span style="display: none">\n<\/span><\/span></g,'<span data-type="newline"><br /><span style="display: none">\n</span></span><span data-type="newline"><br /><span style="display: none">\n</span></span></div><div data-block="0"><')+"</div>",v("SpinVditorSVDOM",e,"result",t.options.debugger),e},Xe=function(e,t){(t=void 0===t?{enableAddUndoStack:!0,enableHint:!1,enableInput:!0}:t).enableHint&&e.hint.render(e),e.preview.render(e);var n=a(e);"function"==typeof e.options.input&&t.enableInput&&e.options.input(n),e.options.counter.enable&&e.counter.render(e,n),e.options.cache.enable&&(0,B.pK)()&&(localStorage.setItem(e.options.cache.id,n),e.options.cache.after&&e.options.cache.after(n)),e.devtools&&e.devtools.renderEchart(e),clearTimeout(e.sv.processTimeoutId),e.sv.processTimeoutId=window.setTimeout(function(){t.enableAddUndoStack&&!e.sv.composingLock&&e.undo.addToUndoStack(e)},e.options.undoDelay)},Ye=function(e,t){var n=(0,Z.zh)(e),e=(0,W.S)(n.startContainer,"SPAN");e&&""!==e.textContent.trim()&&(t="\n"+t),n.collapse(!0),document.execCommand("insertHTML",!1,t)},Qe=function(e,t,n,r){var i=(0,Z.zh)(e),o=t.getAttribute("data-type");0===e.sv.element.childNodes.length&&(e.sv.element.innerHTML='<span data-type="p" data-block="0"><span data-type="text"><wbr></span></span><span data-type="newline"><br><span style="display: none">\n</span></span>',(0,Z.ib)(e.sv.element,i));var a=(0,U.F9)(i.startContainer),t=(0,W.S)(i.startContainer,"SPAN");if(a){if("link"===o){var l=void 0;return l=""===i.toString()?""+n+Lute.Caret+r:""+n+i.toString()+r.replace(")",Lute.Caret+")"),void document.execCommand("insertHTML",!1,l)}if("italic"===o||"bold"===o||"strike"===o||"inline-code"===o||"code"===o||"table"===o||"line"===o){l=void 0;return l=""===i.toString()?""+n+Lute.Caret+("code"===o?"":r):""+n+i.toString()+Lute.Caret+("code"===o?"":r),"table"===o||"code"===o&&t&&""!==t.textContent?l="\n\n"+l:"line"===o&&(l="\n\n"+n+"\n"+Lute.Caret),void document.execCommand("insertHTML",!1,l)}if(("check"===o||"list"===o||"ordered-list"===o||"quote"===o)&&t){l="* ";"check"===o?l="* [ ] ":"ordered-list"===o?l="1. ":"quote"===o&&(l="> ");t=Ze(t,"newline");return t?t.insertAdjacentText("afterend",l):a.insertAdjacentText("afterbegin",l),void p(e)}(0,Z.ib)(e.sv.element,i),Xe(e)}},$e=function(e){switch(e.currentMode){case"ir":return e.ir.element;case"wysiwyg":return e.wysiwyg.element;case"sv":return e.sv.element}},et=function(t,n){t.options.upload.setHeaders&&(t.options.upload.headers=t.options.upload.setHeaders()),t.options.upload.headers&&Object.keys(t.options.upload.headers).forEach(function(e){n.setRequestHeader(e,t.options.upload.headers[e])})},tt=function(e,a,l,s){return new(l=l||Promise)(function(n,t){function r(e){try{o(s.next(e))}catch(e){t(e)}}function i(e){try{o(s.throw(e))}catch(e){t(e)}}function o(e){var t;e.done?n(e.value):((t=e.value)instanceof l?t:new l(function(e){e(t)})).then(r,i)}o((s=s.apply(e,a||[])).next())})},nt=function(n,r){var i,o,a,l={label:0,sent:function(){if(1&a[0])throw a[1];return a[1]},trys:[],ops:[]},e={next:t(0),throw:t(1),return:t(2)};return"function"==typeof Symbol&&(e[Symbol.iterator]=function(){return this}),e;function t(t){return function(e){return function(t){if(i)throw new TypeError("Generator is already executing.");for(;l;)try{if(i=1,o&&(a=2&t[0]?o.return:t[0]?o.throw||((a=o.return)&&a.call(o),0):o.next)&&!(a=a.call(o,t[1])).done)return a;switch(o=0,(t=a?[2&t[0],a.value]:t)[0]){case 0:case 1:a=t;break;case 4:return l.label++,{value:t[1],done:!1};case 5:l.label++,o=t[1],t=[0];continue;case 7:t=l.ops.pop(),l.trys.pop();continue;default:if(!(a=0<(a=l.trys).length&&a[a.length-1])&&(6===t[0]||2===t[0])){l=0;continue}if(3===t[0]&&(!a||t[1]>a[0]&&t[1]<a[3])){l.label=t[1];break}if(6===t[0]&&l.label<a[1]){l.label=a[1],a=t;break}if(a&&l.label<a[2]){l.label=a[2],l.ops.push(t);break}a[2]&&l.ops.pop(),l.trys.pop();continue}t=r.call(n,l)}catch(e){t=[6,e],o=0}finally{i=a=0}if(5&t[0])throw t[1];return{value:t[0]?t[1]:void 0,done:!0}}([t,e])}}},rt=function(){this.isUploading=!1,this.element=document.createElement("div"),this.element.className="vditor-upload"},it=function(i,o){i.tip.hide();for(var a=[],l="",s="",e=(i.options.lang,i.options,o.length),t=0;t<e;t++)!function(e){var t=o[e],n=!0;t.name||(l+="<li>"+window.VditorI18n.nameEmpty+"</li>",n=!1),t.size>i.options.upload.max&&(l+="<li>"+t.name+" "+window.VditorI18n.over+" "+i.options.upload.max/1024/1024+"M</li>",n=!1);var e=t.name.lastIndexOf("."),r=t.name.substr(e),e=i.options.upload.filename(t.name.substr(0,e))+r;i.options.upload.accept&&(i.options.upload.accept.split(",").some(function(e){e=e.trim();if(0===e.indexOf(".")){if(r.toLowerCase()===e.toLowerCase())return!0}else if(t.type.split("/")[0]===e.split("/")[0])return!0;return!1})||(l+="<li>"+t.name+" "+window.VditorI18n.fileTypeError+"</li>",n=!1)),n&&(a.push(t),s+="<li>"+e+" "+window.VditorI18n.uploading+"</li>")}(t);return i.tip.show("<ul>"+l+s+"</ul>"),a},ot=function(e,i){$e(i).focus();var o=JSON.parse(e),n="";1===o.code&&(n=""+o.msg),o.data.errFiles&&0<o.data.errFiles.length&&(n="<ul><li>"+n+"</li>",o.data.errFiles.forEach(function(e){var t=e.lastIndexOf("."),t=i.options.upload.filename(e.substr(0,t))+e.substr(t);n+="<li>"+t+" "+window.VditorI18n.uploadError+"</li>"}),n+="</ul>"),n?i.tip.show(n):i.tip.hide();var a="";Object.keys(o.data.succMap).forEach(function(e){var t=o.data.succMap[e],n=e.lastIndexOf("."),r=e.substr(n),n=i.options.upload.filename(e.substr(0,n))+r;0===(r=r.toLowerCase()).indexOf(".wav")||0===r.indexOf(".mp3")||0===r.indexOf(".ogg")?"wysiwyg"===i.currentMode?a+='<div class="vditor-wysiwyg__block" data-type="html-block"\n data-block="0"><pre><code>&lt;audio controls="controls" src="'+t+'"&gt;&lt;/audio&gt;</code></pre>':"ir"===i.currentMode?a+='<audio controls="controls" src="'+t+'"></audio>\n':a+="["+n+"]("+t+")\n":0===r.indexOf(".apng")||0===r.indexOf(".bmp")||0===r.indexOf(".gif")||0===r.indexOf(".ico")||0===r.indexOf(".cur")||0===r.indexOf(".jpg")||0===r.indexOf(".jpeg")||0===r.indexOf(".jfif")||0===r.indexOf(".pjp")||0===r.indexOf(".pjpeg")||0===r.indexOf(".png")||0===r.indexOf(".svg")||0===r.indexOf(".webp")?"wysiwyg"===i.currentMode?a+='<img alt="'+n+'" src="'+t+'">':a+="!["+n+"]("+t+")\n":"wysiwyg"===i.currentMode?a+='<a href="'+t+'">'+n+"</a>":a+="["+n+"]("+t+")\n"}),(0,Z.Hc)(i.upload.range),document.execCommand("insertHTML",!1,a),i.upload.range=getSelection().getRangeAt(0).cloneRange()},at=function(t,e,n){var r,i,o,a,l,s,d,c,u=(0,U.F9)(e.startContainer);u=u||t.wysiwyg.element,(n&&"formatItalic"!==n.inputType&&"deleteByDrag"!==n.inputType&&"insertFromDrop"!==n.inputType&&"formatBold"!==n.inputType&&"formatRemove"!==n.inputType&&"formatStrikeThrough"!==n.inputType&&"insertUnorderedList"!==n.inputType&&"insertOrderedList"!==n.inputType&&"formatOutdent"!==n.inputType&&"formatIndent"!==n.inputType&&""!==n.inputType||!n)&&((a=function(e){for(var t=e.previousSibling;t;){if(3!==t.nodeType&&"A"===t.tagName&&!t.previousSibling&&""===t.innerHTML.replace(D.g.ZWSP,"")&&t.nextSibling)return t;t=t.previousSibling}return!1}(e.startContainer))&&a.remove(),t.wysiwyg.element.querySelectorAll("wbr").forEach(function(e){e.remove()}),e.insertNode(document.createElement("wbr")),u.querySelectorAll("[style]").forEach(function(e){e.removeAttribute("style")}),u.querySelectorAll(".vditor-comment").forEach(function(e){""===e.textContent.trim()&&(e.classList.remove("vditor-comment","vditor-comment--focus"),e.removeAttribute("data-cmtids"))}),null!==(o=u.previousElementSibling)&&void 0!==o&&o.querySelectorAll(".vditor-comment").forEach(function(e){""===e.textContent.trim()&&(e.classList.remove("vditor-comment","vditor-comment--focus"),e.removeAttribute("data-cmtids"))}),r="",i=(u="link-ref-defs-block"===u.getAttribute("data-type")?t.wysiwyg.element:u).isEqualNode(t.wysiwyg.element),l=(0,U.a1)(u,"data-type","footnotes-block"),i?r=u.innerHTML:((a=(0,U.O9)(e.startContainer))&&!l&&(u=(0,W.S)(e.startContainer,"BLOCKQUOTE")?(0,U.F9)(e.startContainer)||u:a),r=(u=l?l:u).outerHTML,"UL"!==u.tagName&&"OL"!==u.tagName||(o=u.previousElementSibling,a=u.nextElementSibling,!o||"UL"!==o.tagName&&"OL"!==o.tagName||(r=o.outerHTML+r,o.remove()),!a||"UL"!==a.tagName&&"OL"!==a.tagName||(r+=a.outerHTML,a.remove()),r=r.replace("<div><wbr><br></div>","<li><p><wbr><br></p></li>")),t.wysiwyg.element.querySelectorAll("[data-type='link-ref-defs-block']").forEach(function(e){e&&!u.isEqualNode(e)&&(r+=e.outerHTML,e.remove())}),t.wysiwyg.element.querySelectorAll("[data-type='footnotes-block']").forEach(function(e){e&&!u.isEqualNode(e)&&(r+=e.outerHTML,e.remove())})),'<p data-block="0">```<wbr></p>'===(r=r.replace(/<\/(strong|b)><strong data-marker="\W{2}">/g,"").replace(/<\/(em|i)><em data-marker="\W{1}">/g,"").replace(/<\/(s|strike)><s data-marker="~{1,2}">/g,""))&&t.hint.recentLanguage&&(r='<p data-block="0">```<wbr></p>'.replace("```","```"+t.hint.recentLanguage)),v("SpinVditorDOM",r,"argument",t.options.debugger),r=t.lute.SpinVditorDOM(r),v("SpinVditorDOM",r,"result",t.options.debugger),i?u.innerHTML=r:(u.outerHTML=r,l&&(!(c=(0,U.E2)(t.wysiwyg.element.querySelector("wbr"),"LI"))||(l=t.wysiwyg.element.querySelector('sup[data-type="footnotes-ref"][data-footnotes-label="'+c.getAttribute("data-marker")+'"]'))&&l.setAttribute("aria-label",c.textContent.trim().substr(0,24)))),(c=t.wysiwyg.element.querySelectorAll("[data-type='link-ref-defs-block']")).forEach(function(e,t){0===t?s=e:(s.insertAdjacentHTML("beforeend",e.innerHTML),e.remove())}),0<c.length&&t.wysiwyg.element.insertAdjacentElement("beforeend",c[0]),(c=t.wysiwyg.element.querySelectorAll("[data-type='footnotes-block']")).forEach(function(e,t){0===t?d=e:(d.insertAdjacentHTML("beforeend",e.innerHTML),e.remove())}),0<c.length&&t.wysiwyg.element.insertAdjacentElement("beforeend",c[0]),(0,Z.ib)(t.wysiwyg.element,e),t.wysiwyg.element.querySelectorAll(".vditor-wysiwyg__preview[data-render='2']").forEach(function(e){F(e,t)}),n&&("deleteContentBackward"===n.inputType||"deleteContentForward"===n.inputType)&&t.options.comment.enable&&(t.wysiwyg.triggerRemoveComment(t),t.options.comment.adjustTop(t.wysiwyg.getComments(t,!0)))),g(t),ie(t,{enableAddUndoStack:!0,enableHint:!0,enableInput:!0})},lt=function(e,t){return Object.defineProperty?Object.defineProperty(e,"raw",{value:t}):e.raw=t,e},st=function(e,a,l,s){return new(l=l||Promise)(function(n,t){function r(e){try{o(s.next(e))}catch(e){t(e)}}function i(e){try{o(s.throw(e))}catch(e){t(e)}}function o(e){var t;e.done?n(e.value):((t=e.value)instanceof l?t:new l(function(e){e(t)})).then(r,i)}o((s=s.apply(e,a||[])).next())})},dt=function(n,r){var i,o,a,l={label:0,sent:function(){if(1&a[0])throw a[1];return a[1]},trys:[],ops:[]},e={next:t(0),throw:t(1),return:t(2)};return"function"==typeof Symbol&&(e[Symbol.iterator]=function(){return this}),e;function t(t){return function(e){return function(t){if(i)throw new TypeError("Generator is already executing.");for(;l;)try{if(i=1,o&&(a=2&t[0]?o.return:t[0]?o.throw||((a=o.return)&&a.call(o),0):o.next)&&!(a=a.call(o,t[1])).done)return a;switch(o=0,(t=a?[2&t[0],a.value]:t)[0]){case 0:case 1:a=t;break;case 4:return l.label++,{value:t[1],done:!1};case 5:l.label++,o=t[1],t=[0];continue;case 7:t=l.ops.pop(),l.trys.pop();continue;default:if(!(a=0<(a=l.trys).length&&a[a.length-1])&&(6===t[0]||2===t[0])){l=0;continue}if(3===t[0]&&(!a||t[1]>a[0]&&t[1]<a[3])){l.label=t[1];break}if(6===t[0]&&l.label<a[1]){l.label=a[1],a=t;break}if(a&&l.label<a[2]){l.label=a[2],l.ops.push(t);break}a[2]&&l.ops.pop(),l.trys.pop();continue}t=r.call(n,l)}catch(e){t=[6,e],o=0}finally{i=a=0}if(5&t[0])throw t[1];return{value:t[0]?t[1]:void 0,done:!0}}([t,e])}}},ct=function(e,t){var n=(0,Z.zh)(e),r=(0,U.F9)(n.startContainer);r&&(r.insertAdjacentHTML(t,'<p data-block="0">'+D.g.ZWSP+"<wbr>\n</p>"),(0,Z.ib)(e[e.currentMode].element,n),fe(e),wt(e))},ut=function(e,t,n){void 0===n&&(n=!0);var r=e.previousElementSibling;return(r=r||(e.parentElement.previousElementSibling?e.parentElement.previousElementSibling.lastElementChild:"TBODY"===e.parentElement.parentElement.tagName&&e.parentElement.parentElement.previousElementSibling?e.parentElement.parentElement.previousElementSibling.lastElementChild.lastElementChild:null))&&(t.selectNodeContents(r),n||t.collapse(!1),(0,Z.Hc)(t)),r},pt=function(e,t,n,r,i){var o=(0,Z.im)(r,e[e.currentMode].element,n);if("ArrowDown"===t.key&&-1===r.textContent.trimRight().substr(o.start).indexOf("\n")||"ArrowRight"===t.key&&o.start>=r.textContent.trimRight().length){r=i.nextElementSibling;return!r||"TABLE"===r.tagName||r.getAttribute("data-type")?(i.insertAdjacentHTML("afterend",'<p data-block="0">'+D.g.ZWSP+"<wbr></p>"),(0,Z.ib)(e[e.currentMode].element,n)):(n.selectNodeContents(r),n.collapse(!0),(0,Z.Hc)(n)),t.preventDefault(),!0}return!1},mt=function(e,t,n,r,i){var o=(0,Z.im)(r,e[e.currentMode].element,n);if("ArrowUp"===t.key&&-1===r.textContent.substr(0,o.start).indexOf("\n")||("ArrowLeft"===t.key||"Backspace"===t.key&&""===n.toString())&&0===o.start){o=i.previousElementSibling;return!o||"TABLE"===o.tagName||o.getAttribute("data-type")?(i.insertAdjacentHTML("beforebegin",'<p data-block="0">'+D.g.ZWSP+"<wbr></p>"),(0,Z.ib)(e[e.currentMode].element,n)):(n.selectNodeContents(o),n.collapse(!1),(0,Z.Hc)(n)),t.preventDefault(),!0}return!1},ft=function(e,t,n,r){void 0===r&&(r=!0);var i=(0,U.lG)(t.startContainer,"LI");if(e[e.currentMode].element.querySelectorAll("wbr").forEach(function(e){e.remove()}),t.insertNode(document.createElement("wbr")),r&&i){for(var o="",a=0;a<i.parentElement.childElementCount;a++){var l=i.parentElement.children[a].querySelector("input");l&&l.remove(),o+='<p data-block="0">'+i.parentElement.children[a].innerHTML.trimLeft()+"</p>"}i.parentElement.insertAdjacentHTML("beforebegin",o),i.parentElement.remove()}else i?"check"===n?i.parentElement.querySelectorAll("li").forEach(function(e){e.insertAdjacentHTML("afterbegin",'<input type="checkbox" />'+(0===e.textContent.indexOf(" ")?"":" ")),e.classList.add("vditor-task")}):(i.querySelector("input")&&i.parentElement.querySelectorAll("li").forEach(function(e){e.querySelector("input").remove(),e.classList.remove("vditor-task")}),r=void 0,(r="list"===n?document.createElement("ul"):document.createElement("ol")).innerHTML=i.parentElement.innerHTML,i.parentElement.parentNode.replaceChild(r,i.parentElement)):((t=(0,U.a1)(t.startContainer,"data-block","0"))||(e[e.currentMode].element.querySelector("wbr").remove(),(t=e[e.currentMode].element.querySelector("p")).innerHTML="<wbr>"),"check"===n?(t.insertAdjacentHTML("beforebegin",'<ul data-block="0"><li class="vditor-task"><input type="checkbox" /> '+t.innerHTML+"</li></ul>"),t.remove()):"list"===n?(t.insertAdjacentHTML("beforebegin",'<ul data-block="0"><li>'+t.innerHTML+"</li></ul>"),t.remove()):"ordered-list"===n&&(t.insertAdjacentHTML("beforebegin",'<ol data-block="0"><li>'+t.innerHTML+"</li></ol>"),t.remove()))},ht=function(t,n,e){var r,i,o,a=n.previousElementSibling;n&&a?(r=[n],Array.from(e.cloneContents().children).forEach(function(e,t){3!==e.nodeType&&n&&""!==e.textContent.trim()&&n.getAttribute("data-node-id")===e.getAttribute("data-node-id")&&(0!==t&&r.push(n),n=n.nextElementSibling)}),t[t.currentMode].element.querySelectorAll("wbr").forEach(function(e){e.remove()}),e.insertNode(document.createElement("wbr")),i=a.parentElement,o="",r.forEach(function(e){var t=e.getAttribute("data-marker");1!==t.length&&(t="1"+t.slice(-1)),o+='<li data-node-id="'+e.getAttribute("data-node-id")+'" data-marker="'+t+'">'+e.innerHTML+"</li>",e.remove()}),a.insertAdjacentHTML("beforeend","<"+i.tagName+' data-block="0">'+o+"</"+i.tagName+">"),"wysiwyg"===t.currentMode?i.outerHTML=t.lute.SpinVditorDOM(i.outerHTML):i.outerHTML=t.lute.SpinVditorIRDOM(i.outerHTML),(0,Z.ib)(t[t.currentMode].element,e),(e=(0,U.O9)(e.startContainer))&&e.querySelectorAll(".vditor-"+t.currentMode+"__preview[data-render='2']").forEach(function(e){F(e,t),"wysiwyg"===t.currentMode&&e.previousElementSibling.setAttribute("style","display:none")}),wt(t),fe(t)):t[t.currentMode].element.focus()},vt=function(t,n,e,r){var i,o,a,l,s,d=(0,U.lG)(n.parentElement,"LI");d?(t[t.currentMode].element.querySelectorAll("wbr").forEach(function(e){e.remove()}),e.insertNode(document.createElement("wbr")),o=(i=n.parentElement).cloneNode(),a=[n],Array.from(e.cloneContents().children).forEach(function(e,t){3!==e.nodeType&&n&&""!==e.textContent.trim()&&n.getAttribute("data-node-id")===e.getAttribute("data-node-id")&&(0!==t&&a.push(n),n=n.nextElementSibling)}),l=!1,s="",i.querySelectorAll("li").forEach(function(e){l&&(s+=e.outerHTML,(e.nextElementSibling||e.previousElementSibling?e:e.parentElement).remove()),e.isSameNode(a[a.length-1])&&(l=!0)}),a.reverse().forEach(function(e){d.insertAdjacentElement("afterend",e)}),s&&(o.innerHTML=s,a[0].insertAdjacentElement("beforeend",o)),"wysiwyg"===t.currentMode?r.outerHTML=t.lute.SpinVditorDOM(r.outerHTML):r.outerHTML=t.lute.SpinVditorIRDOM(r.outerHTML),(0,Z.ib)(t[t.currentMode].element,e),(e=(0,U.O9)(e.startContainer))&&e.querySelectorAll(".vditor-"+t.currentMode+"__preview[data-render='2']").forEach(function(e){F(e,t),"wysiwyg"===t.currentMode&&e.previousElementSibling.setAttribute("style","display:none")}),wt(t),fe(t)):t[t.currentMode].element.focus()},gt=function(e,t){for(var n=getSelection().getRangeAt(0).startContainer.parentElement,r=e.rows[0].cells.length,i=e.rows.length,o=0,a=0;a<i;a++)for(var l=0;l<r;l++)if(e.rows[a].cells[l].isSameNode(n)){o=l;break}for(var s=0;s<i;s++)e.rows[s].cells[o].setAttribute("align",t)},yt=function(e){var t=e.trimRight().split("\n").pop();return""!==t&&((""===t.replace(/ |-/g,"")||""===t.replace(/ |_/g,"")||""===t.replace(/ |\*/g,""))&&(2<t.replace(/ /g,"").length&&(!(-1<t.indexOf("-")&&-1===t.trimLeft().indexOf(" ")&&1<e.trimRight().split("\n").length)&&(0!==t.indexOf("    ")&&0!==t.indexOf("\t")))))},bt=function(e){var t=e.trimRight().split("\n");return 0!==(e=t.pop()).indexOf("    ")&&0!==e.indexOf("\t")&&(""!==(e=e.trimLeft())&&0!==t.length&&(""===e.replace(/-/g,"")||""===e.replace(/=/g,"")))},wt=function(e,t){void 0===t&&(t={enableAddUndoStack:!0,enableHint:!1,enableInput:!0}),"wysiwyg"===e.currentMode?ie(e,t):"ir"===e.currentMode?Mt(e,t):"sv"===e.currentMode&&Xe(e,t)},Et=function(e,t,n){for(var r="",i=0;i<n.parentElement.childElementCount;i++)r+='<td align="'+n.parentElement.children[i].getAttribute("align")+'"> </td>';"TH"===n.tagName?n.parentElement.parentElement.insertAdjacentHTML("afterend","<tbody><tr>"+r+"</tr></tbody>"):n.parentElement.insertAdjacentHTML("afterend","<tr>"+r+"</tr>"),wt(e)},kt=function(e,t,n){for(var r,i="",o=0;o<n.parentElement.childElementCount;o++)"TH"===n.tagName?i+='<th align="'+n.parentElement.children[o].getAttribute("align")+'"> </th>':i+='<td align="'+n.parentElement.children[o].getAttribute("align")+'"> </td>';"TH"===n.tagName?(n.parentElement.parentElement.insertAdjacentHTML("beforebegin","<thead><tr>"+i+"</tr></thead>"),t.insertNode(document.createElement("wbr")),r=n.parentElement.innerHTML.replace(/<th>/g,"<td>").replace(/<\/th>/g,"</td>"),n.parentElement.parentElement.nextElementSibling.insertAdjacentHTML("afterbegin",r),n.parentElement.parentElement.remove(),(0,Z.ib)(e.ir.element,t)):n.parentElement.insertAdjacentHTML("beforebegin","<tr>"+i+"</tr>"),wt(e)},St=function(e,t,n,r){void 0===r&&(r="afterend");for(var i=0,o=n.previousElementSibling;o;)i++,o=o.previousElementSibling;for(var a=0;a<t.rows.length;a++)0===a?t.rows[a].cells[i].insertAdjacentHTML(r,"<th> </th>"):t.rows[a].cells[i].insertAdjacentHTML(r,"<td> </td>");wt(e)},Ct=function(e,t,n){var r;"TD"===n.tagName&&(r=n.parentElement.parentElement,n.parentElement.previousElementSibling?t.selectNodeContents(n.parentElement.previousElementSibling.lastElementChild):t.selectNodeContents(r.previousElementSibling.lastElementChild.lastElementChild),(1===r.childElementCount?r:n.parentElement).remove(),t.collapse(!1),(0,Z.Hc)(t),wt(e))},Lt=function(e,t,n,r){for(var i=0,o=r.previousElementSibling;o;)i++,o=o.previousElementSibling;(r.previousElementSibling||r.nextElementSibling)&&(t.selectNodeContents(r.previousElementSibling||r.nextElementSibling),t.collapse(!0));for(var a=0;a<n.rows.length;a++){var l=n.rows[a].cells;if(1===l.length){n.remove(),fe(e);break}l[i].remove()}(0,Z.Hc)(t),wt(e)},Tt=function(u,p,m){return st(void 0,void 0,void 0,function(){var t,n,r,i,o,a,l,s,d,c;return dt(this,function(e){switch(e.label){case 0:return(p.stopPropagation(),p.preventDefault(),"clipboardData"in p?(t=p.clipboardData.getData("text/html"),n=p.clipboardData.getData("text/plain"),r=p.clipboardData.files):(t=p.dataTransfer.getData("text/html"),n=p.dataTransfer.getData("text/plain"),"Files"===p.dataTransfer.types[0]&&(r=p.dataTransfer.items)),i={},o=function(e,t){if(!t)return["",Lute.WalkContinue];var r,t=e.TokensStr();return 34===e.__internal_object__.Parent.Type&&t&&-1===t.indexOf("file://")&&u.options.upload.linkToImgUrl&&((r=new XMLHttpRequest).open("POST",u.options.upload.linkToImgUrl),u.options.upload.token&&r.setRequestHeader("X-Upload-Token",u.options.upload.token),u.options.upload.withCredentials&&(r.withCredentials=!0),et(u,r),r.setRequestHeader("Content-Type","application/json; charset=utf-8"),r.onreadystatechange=function(){if(r.readyState===XMLHttpRequest.DONE){if(200===r.status){var e=r.responseText;u.options.upload.linkToImgFormat&&(e=u.options.upload.linkToImgFormat(r.responseText));var t=JSON.parse(e);if(0!==t.code)return void u.tip.show(t.msg);var n=t.data.originalURL;"sv"===u.currentMode?u.sv.element.querySelectorAll(".vditor-sv__marker--link").forEach(function(e){e.textContent===n&&(e.textContent=t.data.url)}):((e=u[u.currentMode].element.querySelector('img[src="'+n+'"]')).src=t.data.url,"ir"===u.currentMode&&(e.previousElementSibling.previousElementSibling.innerHTML=t.data.url)),wt(u)}else u.tip.show(r.responseText);u.options.upload.linkToImgCallback&&u.options.upload.linkToImgCallback(r.responseText)}},r.send(JSON.stringify({url:t}))),"ir"===u.currentMode?['<span class="vditor-ir__marker vditor-ir__marker--link">'+t+"</span>",Lute.WalkContinue]:"wysiwyg"===u.currentMode?["",Lute.WalkContinue]:['<span class="vditor-sv__marker--link">'+t+"</span>",Lute.WalkContinue]},t.replace(/&amp;/g,"&").replace(/<(|\/)(html|body|meta)[^>]*?>/gi,"").trim()!=='<a href="'+n+'">'+n+"</a>"&&t.replace(/&amp;/g,"&").replace(/<(|\/)(html|body|meta)[^>]*?>/gi,"").trim()!=='\x3c!--StartFragment--\x3e<a href="'+n+'">'+n+"</a>\x3c!--EndFragment--\x3e"||(t=""),(c=(new DOMParser).parseFromString(t,"text/html")).body&&(t=c.body.innerHTML),u.wysiwyg.getComments(u),a=u[u.currentMode].element.scrollHeight,l=function(e,t,n){void 0===n&&(n="sv");var r=document.createElement("div");r.innerHTML=e;var i=!1;1===r.childElementCount&&-1<r.lastElementChild.style.fontFamily.indexOf("monospace")&&(i=!0);var o=r.querySelectorAll("pre");if(1===r.childElementCount&&1===o.length&&"vditor-wysiwyg"!==o[0].className&&"vditor-sv"!==o[0].className&&(i=!0),0===e.indexOf('\n<p class="p1">')&&(i=!0),i=1===r.childElementCount&&"TABLE"===r.firstElementChild.tagName&&r.querySelector(".line-number")&&r.querySelector(".line-content")?!0:i){e=t||e;return/\n/.test(e)||1===o.length?"wysiwyg"===n?'<div class="vditor-wysiwyg__block" data-block="0" data-type="code-block"><pre><code>'+e.replace(/&/g,"&amp;").replace(/</g,"&lt;")+"<wbr></code></pre></div>":"\n```\n"+e.replace(/&/g,"&amp;").replace(/</g,"&lt;")+"\n```":"wysiwyg"===n?"<code>"+e.replace(/&/g,"&amp;").replace(/</g,"&lt;")+"</code><wbr>":"`"+e+"`"}return!1}(t,n,u.currentMode),s="sv"===u.currentMode?(0,U.a1)(p.target,"data-type","code-block"):(0,U.lG)(p.target,"CODE"))?("sv"===u.currentMode?document.execCommand("insertHTML",!1,n.replace(/&/g,"&amp;").replace(/</g,"&lt;")):(c=(0,Z.im)(p.target,u[u.currentMode].element),"PRE"!==s.parentElement.tagName&&(n+=D.g.ZWSP),s.textContent=s.textContent.substring(0,c.start)+n+s.textContent.substring(c.end),(0,Z.$j)(c.start+n.length,c.start+n.length,s.parentElement),null!==(c=s.parentElement)&&void 0!==c&&c.nextElementSibling.classList.contains("vditor-"+u.currentMode+"__preview")&&(s.parentElement.nextElementSibling.innerHTML=s.outerHTML,F(s.parentElement.nextElementSibling,u))),[3,6]):[3,1];case 1:return l?(m.pasteCode(l),[3,6]):[3,2];case 2:return""===t.trim()?[3,3]:((d=document.createElement("div")).innerHTML=t,d.querySelectorAll("[style]").forEach(function(e){e.removeAttribute("style")}),d.querySelectorAll(".vditor-copy").forEach(function(e){e.remove()}),"ir"===u.currentMode?(i.HTML2VditorIRDOM={renderLinkDest:o},u.lute.SetJSRenderers({renderers:i}),(0,Z.oC)(u.lute.HTML2VditorIRDOM(d.innerHTML),u)):"wysiwyg"===u.currentMode?(i.HTML2VditorDOM={renderLinkDest:o},u.lute.SetJSRenderers({renderers:i}),(0,Z.oC)(u.lute.HTML2VditorDOM(d.innerHTML),u)):(i.Md2VditorSVDOM={renderLinkDest:o},u.lute.SetJSRenderers({renderers:i}),_e(u,u.lute.HTML2Md(d.innerHTML).trimRight())),u.outline.render(u),[3,6]);case 3:return 0<r.length&&u.options.upload.url?[4,Ae(u,r)]:[3,5];case 4:return e.sent(),[3,6];case 5:""!==n.trim()&&0===r.length&&("ir"===u.currentMode?(i.Md2VditorIRDOM={renderLinkDest:o},u.lute.SetJSRenderers({renderers:i}),(0,Z.oC)(u.lute.Md2VditorIRDOM(n),u)):"wysiwyg"===u.currentMode?(i.Md2VditorDOM={renderLinkDest:o},u.lute.SetJSRenderers({renderers:i}),(0,Z.oC)(u.lute.Md2VditorDOM(n),u)):(i.Md2VditorSVDOM={renderLinkDest:o},u.lute.SetJSRenderers({renderers:i}),_e(u,n)),u.outline.render(u)),e.label=6;case 6:return"sv"!==u.currentMode&&((s=(0,U.F9)((0,Z.zh)(u).startContainer))&&(d=(0,Z.zh)(u),u[u.currentMode].element.querySelectorAll("wbr").forEach(function(e){e.remove()}),d.insertNode(document.createElement("wbr")),"wysiwyg"===u.currentMode?s.outerHTML=u.lute.SpinVditorDOM(s.outerHTML):s.outerHTML=u.lute.SpinVditorIRDOM(s.outerHTML),(0,Z.ib)(u[u.currentMode].element,d)),u[u.currentMode].element.querySelectorAll(".vditor-"+u.currentMode+"__preview[data-render='2']").forEach(function(e){F(e,u)})),u.wysiwyg.triggerRemoveComment(u),wt(u),u[u.currentMode].element.scrollHeight-a>Math.min(u[u.currentMode].element.clientHeight,window.innerHeight)/2&&Fe(u),[2]}})})},Mt=function(t,n){(n=void 0===n?{enableAddUndoStack:!0,enableHint:!1,enableInput:!0}:n).enableHint&&We(t),clearTimeout(t.ir.processTimeoutId),t.ir.processTimeoutId=window.setTimeout(function(){var e;t.ir.composingLock||(e=a(t),"function"==typeof t.options.input&&n.enableInput&&t.options.input(e),t.options.counter.enable&&t.counter.render(t,e),t.options.cache.enable&&(0,B.pK)()&&(localStorage.setItem(t.options.cache.id,e),t.options.cache.after&&t.options.cache.after(e)),t.devtools&&t.devtools.renderEchart(t),n.enableAddUndoStack&&t.undo.addToUndoStack(t))},t.options.undoDelay)},_t=function(e,t){var n,r=(0,Z.zh)(e),i=(0,U.F9)(r.startContainer)||r.startContainer;i&&((n=i.querySelector(".vditor-ir__marker--heading"))?n.innerHTML=t:(i.insertAdjacentText("afterbegin",t),r.selectNodeContents(i),r.collapse(!1)),J(e,r.cloneRange()),re(e))},At=function(e,t,n,r){var i=(0,Z.zh)(e),o=t.getAttribute("data-type"),a=i.startContainer;3===a.nodeType&&(a=a.parentElement);var l,s,d,c=!0;t.classList.contains("vditor-menu--current")?"quote"===o?(a=(0,U.lG)(a,"BLOCKQUOTE"))&&(i.insertNode(document.createElement("wbr")),a.outerHTML=""===a.innerHTML.trim()?'<p data-block="0">'+a.innerHTML+"</p>":a.innerHTML):"link"===o?(s=(0,U.a1)(i.startContainer,"data-type","a"))&&((l=(0,U.fb)(i.startContainer,"vditor-ir__link"))?(i.insertNode(document.createElement("wbr")),s.outerHTML=l.innerHTML):s.outerHTML=s.querySelector(".vditor-ir__link").innerHTML+"<wbr>"):"italic"===o?Ke(i,e,"em"):"bold"===o?Ke(i,e,"strong"):"strike"===o?Ke(i,e,"s"):"inline-code"===o?Ke(i,e,"code"):"check"!==o&&"list"!==o&&"ordered-list"!==o||(ft(e,i,o),c=!1,t.classList.remove("vditor-menu--current")):(0===e.ir.element.childNodes.length&&(e.ir.element.innerHTML='<p data-block="0"><wbr></p>',(0,Z.ib)(e.ir.element,i)),l=(0,U.F9)(i.startContainer),"line"===o?l&&(s='<hr data-block="0"><p data-block="0"><wbr>\n</p>',""===l.innerHTML.trim()?l.outerHTML=s:l.insertAdjacentHTML("afterend",s)):"quote"===o?l&&(i.insertNode(document.createElement("wbr")),l.outerHTML='<blockquote data-block="0">'+l.outerHTML+"</blockquote>",c=!1,t.classList.add("vditor-menu--current")):"link"===o?(d=void 0,d=""===i.toString()?n+"<wbr>"+r:""+n+i.toString()+r.replace(")","<wbr>)"),document.execCommand("insertHTML",!1,d),c=!1,t.classList.add("vditor-menu--current")):"italic"===o||"bold"===o||"strike"===o||"inline-code"===o||"code"===o||"table"===o?(d=void 0,""===i.toString()?d=n+"<wbr>"+r:(d="code"===o||"table"===o?""+n+i.toString()+"<wbr>"+r:""+n+i.toString()+r+"<wbr>",i.deleteContents()),"table"!==o&&"code"!==o||(d="\n"+d+"\n\n"),(r=document.createElement("span")).innerHTML=d,i.insertNode(r),J(e,i),"table"===o&&(i.selectNodeContents(getSelection().getRangeAt(0).startContainer.parentElement),(0,Z.Hc)(i))):"check"!==o&&"list"!==o&&"ordered-list"!==o||(ft(e,i,o,!1),c=!1,q(e.toolbar.elements,["check","list","ordered-list"]),t.classList.add("vditor-menu--current"))),(0,Z.ib)(e.ir.element,i),Mt(e),c&&re(e)},xt=(Ht.prototype.render=function(t){var e,n,r,i,o=this;window.getSelection().focusNode&&(e=(e=getSelection().getRangeAt(0)).startContainer.textContent.substring(0,e.startOffset)||"",void 0===(n=this.getKey(e,t.options.hint.extend))?(this.element.style.display="none",clearTimeout(this.timeId)):":"===this.splitChar?(r=""===n?t.options.hint.emoji:t.lute.GetEmojis(),i=[],Object.keys(r).forEach(function(e){0===e.indexOf(n.toLowerCase())&&(-1<r[e].indexOf(".")?i.push({html:'<img src="'+r[e]+'" title=":'+e+':"/> :'+e+":",value:":"+e+":"}):i.push({html:'<span class="vditor-hint__emoji">'+r[e]+"</span>"+e,value:r[e]}))}),this.genHTML(i,n,t)):t.options.hint.extend.forEach(function(e){e.key===o.splitChar&&(clearTimeout(o.timeId),o.timeId=window.setTimeout(function(){o.genHTML(e.hint(n),n,t)},t.options.hint.delay))}))},Ht.prototype.genHTML=function(e,a,n){var t,r,l,i,o=this;0!==e.length?(i=n[n.currentMode].element,t=(r=(0,Z.Ny)(i)).left+("left"===n.options.outline.position?n.outline.element.offsetWidth:0),r=r.top,l="",e.forEach(function(e,t){var n,r,i,o;7<t||(n=e.html,""!==a&&(r=n.lastIndexOf(">")+1,-1<(o=(i=n.substr(r)).toLowerCase().indexOf(a.toLowerCase()))&&(i=i.substring(0,o)+"<b>"+i.substring(o,o+a.length)+"</b>"+i.substring(o+a.length),n=n.substr(0,r)+i)),l+='<button data-value="'+encodeURIComponent(e.value)+' "\n'+(0===t?"class='vditor-hint--current'":"")+"> "+n+"</button>")}),this.element.innerHTML=l,i=parseInt(document.defaultView.getComputedStyle(i,null).getPropertyValue("line-height"),10),this.element.style.top=r+(i||22)+"px",this.element.style.left=t+"px",this.element.style.display="block",this.element.style.right="auto",this.element.querySelectorAll("button").forEach(function(t){t.addEventListener("click",function(e){o.fillEmoji(t,n),e.preventDefault()})}),this.element.getBoundingClientRect().bottom>window.innerHeight&&(this.element.style.top=r-this.element.offsetHeight+"px"),this.element.getBoundingClientRect().right>window.innerWidth&&(this.element.style.left="auto",this.element.style.right="0")):this.element.style.display="none"},Ht.prototype.select=function(e,t){if(0===this.element.querySelectorAll("button").length||"none"===this.element.style.display)return!1;var n,r=this.element.querySelector(".vditor-hint--current");return"ArrowDown"===e.key?(e.preventDefault(),e.stopPropagation(),r.removeAttribute("class"),r.nextElementSibling?r.nextElementSibling.className="vditor-hint--current":this.element.children[0].className="vditor-hint--current",!0):"ArrowUp"===e.key?(e.preventDefault(),e.stopPropagation(),r.removeAttribute("class"),r.previousElementSibling?r.previousElementSibling.className="vditor-hint--current":(n=this.element.children.length,this.element.children[n-1].className="vditor-hint--current"),!0):!((0,B.yl)(e)||e.shiftKey||e.altKey||"Enter"!==e.key||e.isComposing)&&(e.preventDefault(),e.stopPropagation(),this.fillEmoji(r,t),!0)},Ht.prototype.getKey=function(n,e){var t,r=this;if(this.lastIndex=-1,this.splitChar="",e.forEach(function(e){var t=n.lastIndexOf(e.key);r.lastIndex<t&&(r.splitChar=e.key,r.lastIndex=t)}),-1===this.lastIndex)return t;var i=n.split(this.splitChar),e=i[i.length-1];return 1<i.length&&e.trim()===e&&(2===i.length&&""===i[0]&&i[1].length<32?t=i[1]:(i=i[i.length-2].slice(-1)," "===(0,o.X)(i)&&e.length<32&&(t=e))),t},Ht);function Ht(e){var o=this;this.splitChar="",this.lastIndex=-1,this.fillEmoji=function(e,t){o.element.style.display="none";var n,r=decodeURIComponent(e.getAttribute("data-value")),e=window.getSelection().getRangeAt(0);if("ir"===t.currentMode){var i=(0,U.a1)(e.startContainer,"data-type","code-block-info");if(i)return i.textContent=D.g.ZWSP+r.trimRight(),e.selectNodeContents(i),e.collapse(!1),Mt(t),i.parentElement.querySelectorAll("code").forEach(function(e){e.className="language-"+r.trimRight()}),F(i.parentElement.querySelector(".vditor-ir__preview"),t),void(o.recentLanguage=r.trimRight())}if("wysiwyg"===t.currentMode&&3!==e.startContainer.nodeType&&e.startContainer.firstElementChild.classList.contains("vditor-input")){i=e.startContainer.firstElementChild;return i.value=r.trimRight(),e.selectNodeContents(i),e.collapse(!1),i.dispatchEvent(new CustomEvent("input")),void(o.recentLanguage=r.trimRight())}e.setStart(e.startContainer,o.lastIndex),e.deleteContents(),t.options.hint.parse?"sv"===t.currentMode?(0,Z.oC)(t.lute.SpinVditorSVDOM(r),t):"wysiwyg"===t.currentMode?(0,Z.oC)(t.lute.SpinVditorDOM(r),t):(0,Z.oC)(t.lute.SpinVditorIRDOM(r),t):(0,Z.oC)(r,t),":"===o.splitChar&&-1<r.indexOf(":")&&"sv"!==t.currentMode&&e.insertNode(document.createTextNode(" ")),e.collapse(!1),(0,Z.Hc)(e),"wysiwyg"===t.currentMode?(n=(0,U.fb)(e.startContainer,"vditor-wysiwyg__block"))&&n.lastElementChild.classList.contains("vditor-wysiwyg__preview")&&(n.lastElementChild.innerHTML=n.firstElementChild.innerHTML,F(n.lastElementChild,t)):"ir"===t.currentMode&&(n=(0,U.fb)(e.startContainer,"vditor-ir__marker--pre"))&&n.nextElementSibling.classList.contains("vditor-ir__preview")&&(n.nextElementSibling.innerHTML=n.innerHTML,F(n.nextElementSibling,t)),wt(t)},this.timeId=-1,this.element=document.createElement("div"),this.element.className="vditor-hint",this.recentLanguage="",e.push({key:":"})}var Nt=(Dt.prototype.copy=function(e,t){var n,r=getSelection().getRangeAt(0);""!==r.toString()&&(e.stopPropagation(),e.preventDefault(),(n=document.createElement("div")).appendChild(r.cloneContents()),e.clipboardData.setData("text/plain",t.lute.VditorIRDOM2Md(n.innerHTML).trim()),e.clipboardData.setData("text/html",""))},Dt.prototype.bindEvent=function(i){var o=this;this.element.addEventListener("paste",function(e){Tt(i,e,{pasteCode:function(e){document.execCommand("insertHTML",!1,e)}})}),this.element.addEventListener("compositionstart",function(e){o.composingLock=!0}),this.element.addEventListener("compositionend",function(e){(0,B.vU)()||J(i,getSelection().getRangeAt(0).cloneRange()),o.composingLock=!1}),this.element.addEventListener("input",function(e){"deleteByDrag"!==e.inputType&&"insertFromDrop"!==e.inputType&&(o.preventInput?o.preventInput=!1:o.composingLock||"‘"===e.data||"“"===e.data||"《"===e.data||J(i,getSelection().getRangeAt(0).cloneRange(),!1,e))}),this.element.addEventListener("click",function(e){if("INPUT"===e.target.tagName)return e.target.checked?e.target.setAttribute("checked","checked"):e.target.removeAttribute("checked"),o.preventInput=!0,void Mt(i);var t=(0,Z.zh)(i),n=(0,U.fb)(e.target,"vditor-ir__preview");(n=n||(0,U.fb)(t.startContainer,"vditor-ir__preview"))&&(n.previousElementSibling.firstElementChild?t.selectNodeContents(n.previousElementSibling.firstElementChild):t.selectNodeContents(n.previousElementSibling),t.collapse(!0),(0,Z.Hc)(t),Fe(i)),"IMG"!==e.target.tagName||(r=e.target.parentElement.querySelector(".vditor-ir__marker--link"))&&(t.selectNode(r),(0,Z.Hc)(t));var r,n=(0,U.a1)(e.target,"data-type","a");!n||n.classList.contains("vditor-ir__node--expand")?(e.target.isEqualNode(o.element)&&o.element.lastElementChild&&t.collapsed&&(r=o.element.lastElementChild.getBoundingClientRect(),e.y>r.top+r.height&&("P"===o.element.lastElementChild.tagName&&""===o.element.lastElementChild.textContent.trim().replace(D.g.ZWSP,"")?(t.selectNodeContents(o.element.lastElementChild),t.collapse(!1)):(o.element.insertAdjacentHTML("beforeend",'<p data-block="0">'+D.g.ZWSP+"<wbr></p>"),(0,Z.ib)(o.element,t)))),""===t.toString()?u(t,i):setTimeout(function(){u((0,Z.zh)(i),i)}),c(e,i),re(i)):window.open(n.querySelector(":scope > .vditor-ir__marker--link").textContent)}),this.element.addEventListener("keyup",function(e){if(!e.isComposing&&!(0,B.yl)(e)){if("Enter"===e.key&&Fe(i),re(i),"Backspace"!==e.key&&"Delete"!==e.key||""===i.ir.element.innerHTML||1!==i.ir.element.childNodes.length||!i.ir.element.firstElementChild||"P"!==i.ir.element.firstElementChild.tagName||0!==i.ir.element.firstElementChild.childElementCount||""!==i.ir.element.textContent&&"\n"!==i.ir.element.textContent){var t=(0,Z.zh)(i);"Backspace"===e.key?((0,B.vU)()&&"\n"===t.startContainer.textContent&&1===t.startOffset&&(t.startContainer.textContent="",u(t,i)),o.element.querySelectorAll(".language-math").forEach(function(e){e=e.querySelector("br");e&&e.remove()})):-1<e.key.indexOf("Arrow")?("ArrowLeft"!==e.key&&"ArrowRight"!==e.key||We(i),u(t,i)):229===e.keyCode&&""===e.code&&"Unidentified"===e.key&&u(t,i);var n=(0,U.fb)(t.startContainer,"vditor-ir__preview");return n?"ArrowUp"===e.key||"ArrowLeft"===e.key?(n.previousElementSibling.firstElementChild?t.selectNodeContents(n.previousElementSibling.firstElementChild):t.selectNodeContents(n.previousElementSibling),t.collapse(!1),e.preventDefault(),!0):"SPAN"!==n.tagName||"ArrowDown"!==e.key&&"ArrowRight"!==e.key?void 0:("html-entity"===n.parentElement.getAttribute("data-type")?(n.parentElement.insertAdjacentText("afterend",D.g.ZWSP),t.setStart(n.parentElement.nextSibling,1)):t.selectNodeContents(n.parentElement.lastElementChild),t.collapse(!1),e.preventDefault(),!0):void 0}i.ir.element.innerHTML=""}})},Dt);function Dt(e){this.composingLock=!1;var t=document.createElement("div");t.className="vditor-ir",t.innerHTML='<pre class="vditor-reset" placeholder="'+e.options.placeholder+'"\n contenteditable="true" spellcheck="false"></pre>',this.element=t.firstElementChild,this.bindEvent(e),we(e,this.element),Ee(e,this.element),ke(e,this.element),Te(e,this.element),Me(e,this.element),Se(e,this.element),Ce(e,this.element,this.copy),Le(e,this.element,this.copy)}var Ot=function(e){return"sv"===e.currentMode?e.lute.Md2HTML(a(e)):"wysiwyg"===e.currentMode?e.lute.VditorDOM2HTML(e.wysiwyg.element.innerHTML):"ir"===e.currentMode?e.lute.VditorIRDOM2HTML(e.ir.element.innerHTML):void 0},It=Zr(792),jt=Zr(198),Rt=(Pt.prototype.render=function(e){return"block"===e.preview.element.style.display?(0,jt.k)(e.preview.element.lastElementChild,this.element.lastElementChild,e):(0,jt.k)(e[e.currentMode].element,this.element.lastElementChild,e)},Pt.prototype.toggle=function(e,t){var n=null===(n=e.toolbar.elements.outline)||void 0===n?void 0:n.firstElementChild;(t=void 0===t?!0:t)&&window.innerWidth>=D.g.MOBILE_WIDTH?(this.element.style.display="block",this.render(e),null!=n&&n.classList.add("vditor-menu--current")):(this.element.style.display="none",null!=n&&n.classList.remove("vditor-menu--current")),0<getSelection().rangeCount&&(n=getSelection().getRangeAt(0),e[e.currentMode].element.contains(n.startContainer)?(0,Z.Hc)(n):e[e.currentMode].element.focus()),te(e)},Pt);function Pt(e){this.element=document.createElement("div"),this.element.className="vditor-outline",this.element.innerHTML='<div class="vditor-outline__title">'+e+'</div>\n<div class="vditor-outline__content"></div>'}var Bt=Zr(207),qt=(Vt.prototype.render=function(n,e){var r,i,o=this;clearTimeout(this.mdTimeoutId),"none"!==this.element.style.display?e?this.element.lastElementChild.innerHTML=e:""!==a(n).replace(/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g,"")?(r=(new Date).getTime(),i=a(n),this.mdTimeoutId=window.setTimeout(function(){var t,e;n.options.preview.url?((t=new XMLHttpRequest).open("POST",n.options.preview.url),t.setRequestHeader("Content-Type","application/json;charset=UTF-8"),t.onreadystatechange=function(){var e;t.readyState===XMLHttpRequest.DONE&&(200===t.status?0===(e=JSON.parse(t.responseText)).code?(n.options.preview.transform&&(e.data=n.options.preview.transform(e.data)),o.element.lastElementChild.innerHTML=e.data,o.afterRender(n,r)):n.tip.show(e.msg):(e=n.lute.Md2HTML(i),n.options.preview.transform&&(e=n.options.preview.transform(e)),o.element.lastElementChild.innerHTML=e,o.afterRender(n,r)))},t.send(JSON.stringify({markdownText:i}))):(e=n.lute.Md2HTML(i),n.options.preview.transform&&(e=n.options.preview.transform(e)),o.element.lastElementChild.innerHTML=e,o.afterRender(n,r))},n.options.preview.delay)):this.element.lastElementChild.innerHTML="":"renderPerformance"===this.element.getAttribute("data-type")&&n.tip.hide()},Vt.prototype.afterRender=function(t,e){t.options.preview.parse&&t.options.preview.parse(this.element);var n=(new Date).getTime()-e;2600<(new Date).getTime()-e?(t.tip.show(window.VditorI18n.performanceTip.replace("${x}",n.toString())),t.preview.element.setAttribute("data-type","renderPerformance")):"renderPerformance"===t.preview.element.getAttribute("data-type")&&(t.tip.hide(),t.preview.element.removeAttribute("data-type"));n=t.preview.element.querySelector(".vditor-comment--focus");n&&n.classList.remove("vditor-comment--focus"),(0,_.O)(t.preview.element.lastElementChild),(0,H.s)(t.options.preview.hljs,t.preview.element.lastElementChild,t.options.cdn),(0,K.i)(t.preview.element.lastElementChild,t.options.cdn,t.options.theme),(0,A.P)(t.preview.element.lastElementChild,t.options.cdn),(0,x.v)(t.preview.element.lastElementChild,t.options.cdn),(0,M.p)(t.preview.element.lastElementChild,t.options.cdn,t.options.theme),(0,G.P)(t.preview.element.lastElementChild,t.options.cdn,t.options.theme),(0,z.B)(t.preview.element.lastElementChild,t.options.cdn),(0,T.Q)(t.preview.element.lastElementChild,t.options.cdn),(0,Bt.Y)(t.preview.element.lastElementChild);var n=t.preview.element,r=t.outline.render(t);""===r&&(r="[ToC]"),n.querySelectorAll('[data-type="toc-block"]').forEach(function(e){e.innerHTML=r,(0,N.H)(e,{cdn:t.options.cdn,math:t.options.preview.math})}),(0,N.H)(t.preview.element.lastElementChild,{cdn:t.options.cdn,math:t.options.preview.math})},Vt.prototype.copyToX=function(e,t,n){"zhihu"!==(n=void 0===n?"mp-wechat":n)?t.querySelectorAll(".katex-html .base").forEach(function(e){e.style.display="initial"}):t.querySelectorAll(".language-math").forEach(function(e){e.outerHTML='<img class="Formula-image" data-eeimg="true" src="//www.zhihu.com/equation?tex=" alt="'+e.getAttribute("data-math")+'\\" style="display: block; margin: 0 auto; max-width: 100%;">'}),t.style.backgroundColor="#fff",t.querySelectorAll("code").forEach(function(e){e.style.backgroundImage="none"}),this.element.append(t);var r=t.ownerDocument.createRange();r.selectNode(t),(0,Z.Hc)(r),document.execCommand("copy"),this.element.lastElementChild.remove(),e.tip.show("已复制，可到"+("zhihu"===n?"知乎":"微信公众号平台")+"进行粘贴")},Vt);function Vt(r){var i=this;this.element=document.createElement("div"),this.element.className="vditor-preview";var o=document.createElement("div");o.className="vditor-reset",r.options.classes.preview&&o.classList.add(r.options.classes.preview),o.style.maxWidth=r.options.preview.maxWidth+"px",o.addEventListener("copy",function(e){var t;"TEXTAREA"!==e.target.tagName&&((t=document.createElement("div")).className="vditor-reset",t.appendChild(getSelection().getRangeAt(0).cloneContents()),i.copyToX(r,t),e.preventDefault())}),o.addEventListener("click",function(e){var t=(0,U.lG)(e.target,"SPAN");t&&(0,U.fb)(t,"vditor-toc")?(t=o.querySelector("#"+t.getAttribute("data-target-id")))&&(i.element.scrollTop=t.offsetTop):"IMG"===e.target.tagName&&(0,Q.E)(e.target,r.options.lang,r.options.theme)});var a=r.options.preview.actions,l=document.createElement("div");l.className="vditor-preview__action";for(var e=[],t=0;t<a.length;t++){var n=a[t];if("object"!=typeof n)switch(n){case"desktop":e.push('<button type="button" class="vditor-preview__action--current" data-type="desktop">Desktop</button>');break;case"tablet":e.push('<button type="button" data-type="tablet">Tablet</button>');break;case"mobile":e.push('<button type="button" data-type="mobile">Mobile/Wechat</button>');break;case"mp-wechat":e.push('<button type="button" data-type="mp-wechat" class="vditor-tooltipped vditor-tooltipped__w" aria-label="复制到公众号"><svg><use xlink:href="#vditor-icon-mp-wechat"></use></svg></button>');break;case"zhihu":e.push('<button type="button" data-type="zhihu" class="vditor-tooltipped vditor-tooltipped__w" aria-label="复制到知乎"><svg><use xlink:href="#vditor-icon-zhihu"></use></svg></button>')}else e.push('<button type="button" data-type="'+n.key+'" class="'+n.className+'"'+(n.tooltip?' aria-label="'+n.tooltip+'"':"")+'">'+n.text+"</button>")}l.innerHTML=e.join(""),0===a.length&&(l.style.display="none"),this.element.appendChild(l),this.element.appendChild(o),l.addEventListener((0,B.Le)(),function(e){var t,n=(0,W.S)(e.target,"BUTTON");n&&(t=n.getAttribute("data-type"),(e=a.find(function(e){return(null==e?void 0:e.key)===t}))?e.click(t):"mp-wechat"!==t&&"zhihu"!==t?(o.style.width="desktop"===t?"auto":"tablet"===t?"780px":"360px",o.scrollWidth>o.parentElement.clientWidth&&(o.style.width="auto"),i.render(r),l.querySelectorAll("button").forEach(function(e){e.classList.remove("vditor-preview__action--current")}),n.classList.add("vditor-preview__action--current")):i.copyToX(r,i.element.lastElementChild.cloneNode(!0),t))})}var Ut=(Wt.prototype.bindEvent=function(o){var a=this;this.element.addEventListener("mousedown",function(e){var t=document,n=e.clientY,r=o.element.offsetHeight,i=63+o.element.querySelector(".vditor-toolbar").clientHeight;t.ondragstart=function(){return!1},window.captureEvents&&window.captureEvents(),a.element.classList.add("vditor-resize--selected"),t.onmousemove=function(e){"top"===o.options.resize.position?o.element.style.height=Math.max(i,r+(n-e.clientY))+"px":o.element.style.height=Math.max(i,r+(e.clientY-n))+"px",o.options.typewriterMode&&(o.sv.element.style.paddingBottom=o.sv.element.parentElement.offsetHeight/2+"px")},t.onmouseup=function(){o.options.resize.after&&o.options.resize.after(o.element.offsetHeight-r),window.captureEvents&&window.captureEvents(),t.onmousemove=null,t.onmouseup=null,t.ondragstart=null,t.onselectstart=null,t.onselect=null,a.element.classList.remove("vditor-resize--selected")}})},Wt);function Wt(e){this.element=document.createElement("div"),this.element.className="vditor-resize vditor-resize--"+e.options.resize.position,this.element.innerHTML='<div><svg><use xlink:href="#vditor-icon-resize"></use></svg></div>',this.bindEvent(e)}var Kt=(Gt.prototype.copy=function(e,t){e.stopPropagation(),e.preventDefault(),e.clipboardData.setData("text/plain",ze(t[t.currentMode].element))},Gt.prototype.bindEvent=function(i){var o=this;this.element.addEventListener("paste",function(e){Tt(i,e,{pasteCode:function(e){document.execCommand("insertHTML",!1,e)}})}),this.element.addEventListener("scroll",function(){var e,t,n,r;"block"===i.preview.element.style.display&&(e=o.element.scrollTop,t=o.element.clientHeight,n=o.element.scrollHeight-parseFloat(o.element.style.paddingBottom||"0"),(r=i.preview.element).scrollTop=.5<e/t?(e+t)*r.scrollHeight/n-t:e*r.scrollHeight/n)}),this.element.addEventListener("compositionstart",function(e){o.composingLock=!0}),this.element.addEventListener("compositionend",function(e){(0,B.vU)()||p(i,e),o.composingLock=!1}),this.element.addEventListener("input",function(e){"deleteByDrag"!==e.inputType&&"insertFromDrop"!==e.inputType&&(o.composingLock||"‘"===e.data||"“"===e.data||"《"===e.data||(o.preventInput?o.preventInput=!1:p(i,e)))}),this.element.addEventListener("keyup",function(e){e.isComposing||(0,B.yl)(e)||("Backspace"!==e.key&&"Delete"!==e.key||""===i.sv.element.innerHTML||1!==i.sv.element.childNodes.length||!i.sv.element.firstElementChild||"DIV"!==i.sv.element.firstElementChild.tagName||2!==i.sv.element.firstElementChild.childElementCount||""!==i.sv.element.firstElementChild.textContent&&"\n"!==i.sv.element.textContent?"Enter"===e.key&&Fe(i):i.sv.element.innerHTML="")})},Gt);function Gt(e){this.composingLock=!1,this.element=document.createElement("pre"),this.element.className="vditor-sv vditor-reset",this.element.setAttribute("placeholder",e.options.placeholder),this.element.setAttribute("contenteditable","true"),this.element.setAttribute("spellcheck","false"),this.bindEvent(e),we(e,this.element),ke(e,this.element),Te(e,this.element),Me(e,this.element),Se(e,this.element),Ce(e,this.element,this.copy),Le(e,this.element,this.copy)}var zt=(Ft.prototype.show=function(e,t){var n=this;if(void 0===t&&(t=6e3),this.element.className="vditor-tip vditor-tip--show",0===t)return this.element.innerHTML='<div class="vditor-tip__content">'+e+'\n<div class="vditor-tip__close">X</div></div>',void this.element.querySelector(".vditor-tip__close").addEventListener("click",function(){n.hide()});this.element.innerHTML='<div class="vditor-tip__content">'+e+"</div>",setTimeout(function(){n.hide()},t)},Ft.prototype.hide=function(){this.element.className="vditor-messageElementtip",this.element.innerHTML=""},Ft);function Ft(){this.element=document.createElement("div"),this.element.className="vditor-tip"}function Zt(e,t){if(t.options.preview.mode!==e){switch(t.options.preview.mode=e){case"both":t.sv.element.style.display="block",t.preview.element.style.display="block",t.preview.render(t),V(t.toolbar.elements,["both"]);break;case"editor":t.sv.element.style.display="block",t.preview.element.style.display="none",q(t.toolbar.elements,["both"])}t.devtools&&t.devtools.renderEchart(t)}}var Jt,Xt,Yt=((Jt=function(e,t){return(Jt=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])})(e,t)},function(e,t){function n(){this.constructor=e}Jt(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)})(Qt,Xt=ve),Qt);function Qt(t,e){var n=Xt.call(this,t,e)||this;return"both"===t.options.preview.mode&&n.element.children[0].classList.add("vditor-menu--current"),n.element.children[0].addEventListener((0,B.Le)(),function(e){n.element.firstElementChild.classList.contains(D.g.CLASS_MENU_DISABLED)||(e.preventDefault(),"sv"===t.currentMode&&("both"===t.options.preview.mode?Zt("editor",t):Zt("both",t)))}),n}var $t,en,tn=function(){this.element=document.createElement("div"),this.element.className="vditor-toolbar__br"},nn=Zr(968),rn=(($t=function(e,t){return($t=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])})(e,t)},function(e,t){function n(){this.constructor=e}$t(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)})(on,en=ve),on);function on(t,e){var n=en.call(this,t,e)||this,r=n.element.children[0],i=document.createElement("div");i.className="vditor-hint"+(2===e.level?"":" vditor-panel--arrow");var o="";return D.g.CODE_THEME.forEach(function(e){o+="<button>"+e+"</button>"}),i.innerHTML='<div style="overflow: auto;max-height:'+window.innerHeight/2+'px">'+o+"</div>",i.addEventListener((0,B.Le)(),function(e){"BUTTON"===e.target.tagName&&(L(t,["subToolbar"]),t.options.preview.hljs.style=e.target.textContent,(0,nn.Y)(e.target.textContent,t.options.cdn),e.preventDefault(),e.stopPropagation())}),n.element.appendChild(i),d(t,i,r,e.level),n}var an,ln,sn=((an=function(e,t){return(an=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])})(e,t)},function(e,t){function n(){this.constructor=e}an(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)})(dn,ln=ve),dn);function dn(t,e){var n=ln.call(this,t,e)||this,r=n.element.children[0],i=document.createElement("div");i.className="vditor-hint"+(2===e.level?"":" vditor-panel--arrow");var o="";return Object.keys(t.options.preview.theme.list).forEach(function(e){o+='<button data-type="'+e+'">'+t.options.preview.theme.list[e]+"</button>"}),i.innerHTML='<div style="overflow: auto;max-height:'+window.innerHeight/2+'px">'+o+"</div>",i.addEventListener((0,B.Le)(),function(e){"BUTTON"===e.target.tagName&&(L(t,["subToolbar"]),t.options.preview.theme.current=e.target.getAttribute("data-type"),(0,ee.Z)(t.options.preview.theme.current,t.options.preview.theme.path),e.preventDefault(),e.stopPropagation())}),n.element.appendChild(i),d(t,i,r,e.level),n}var cn=(un.prototype.render=function(e,t){var n=t.endsWith("\n")?t.length-1:t.length;"text"===e.options.counter.type&&e[e.currentMode]&&((t=e[e.currentMode].element.cloneNode(!0)).querySelectorAll(".vditor-wysiwyg__preview").forEach(function(e){e.remove()}),n=t.textContent.length),"number"==typeof e.options.counter.max?(n>e.options.counter.max?this.element.className="vditor-counter vditor-counter--error":this.element.className="vditor-counter",this.element.innerHTML=n+"/"+e.options.counter.max):this.element.innerHTML=""+n,this.element.setAttribute("aria-label",e.options.counter.type),e.options.counter.after&&e.options.counter.after(n,{enable:e.options.counter.enable,max:e.options.counter.max,type:e.options.counter.type})},un);function un(e){this.element=document.createElement("span"),this.element.className="vditor-counter vditor-tooltipped vditor-tooltipped__nw",this.render(e,"")}var pn,mn,fn=((pn=function(e,t){return(pn=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])})(e,t)},function(e,t){function n(){this.constructor=e}pn(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)})(hn,mn=ve),hn);function hn(t,n){var e=mn.call(this,t,n)||this;return e.element.children[0].innerHTML=n.icon,e.element.children[0].addEventListener((0,B.Le)(),function(e){e.preventDefault(),e.currentTarget.classList.contains(D.g.CLASS_MENU_DISABLED)||n.click(e,t)}),e}var vn,gn,yn=((vn=function(e,t){return(vn=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])})(e,t)},function(e,t){function n(){this.constructor=e}vn(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)})(bn,gn=ve),bn);function bn(n,e){var r=gn.call(this,n,e)||this;return r.element.firstElementChild.addEventListener((0,B.Le)(),function(e){var t=r.element.firstElementChild;t.classList.contains(D.g.CLASS_MENU_DISABLED)||(e.preventDefault(),t.classList.contains("vditor-menu--current")?(t.classList.remove("vditor-menu--current"),n.devtools.element.style.display="none",te(n)):(t.classList.add("vditor-menu--current"),n.devtools.element.style.display="block",te(n),n.devtools.renderEchart(n)))}),r}var wn,En,kn=function(){this.element=document.createElement("div"),this.element.className="vditor-toolbar__divider"},Sn=((wn=function(e,t){return(wn=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])})(e,t)},function(e,t){function n(){this.constructor=e}wn(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)})(Cn,En=ve),Cn.prototype._bindEvent=function(o,a){a.querySelectorAll(".vditor-emojis button").forEach(function(i){i.addEventListener((0,B.Le)(),function(e){e.preventDefault();var t=i.getAttribute("data-value"),n=(0,Z.zh)(o),r=t;"wysiwyg"===o.currentMode?r=o.lute.SpinVditorDOM(t):"ir"===o.currentMode&&(r=o.lute.SpinVditorIRDOM(t)),-1<t.indexOf(":")&&"sv"!==o.currentMode?((e=document.createElement("div")).innerHTML=r,r=e.firstElementChild.firstElementChild.outerHTML+" ",(0,Z.oC)(r,o)):(n.extractContents(),n.insertNode(document.createTextNode(t))),n.collapse(!1),(0,Z.Hc)(n),a.style.display="none",wt(o)}),i.addEventListener("mouseover",function(e){"BUTTON"===e.target.tagName&&(a.querySelector(".vditor-emojis__tip").innerHTML=e.target.getAttribute("data-key"))})})},Cn);function Cn(n,e){var t=En.call(this,n,e)||this,r=document.createElement("div");r.className="vditor-panel vditor-panel--arrow";var i="";Object.keys(n.options.hint.emoji).forEach(function(e){var t=n.options.hint.emoji[e];-1<t.indexOf(".")?i+='<button data-value=":'+e+': " data-key=":'+e+':"><img\ndata-value=":'+e+': " data-key=":'+e+':" class="vditor-emojis__icon" src="'+t+'"/></button>':i+='<button data-value="'+t+' "\n data-key="'+e+'"><span class="vditor-emojis__icon">'+t+"</span></button>"});var o='<div class="vditor-emojis__tail">\n    <span class="vditor-emojis__tip"></span><span>'+(n.options.hint.emojiTail||"")+"</span>\n</div>";return r.innerHTML='<div class="vditor-emojis" style="max-height: '+("auto"===n.options.height?"auto":n.options.height-80)+'px">'+i+"</div>"+o,t.element.appendChild(r),d(n,r,t.element.children[0],e.level),t._bindEvent(n,r),t}var Ln,Tn,Mn=function(e,t,n){var r=document.createElement("a");"download"in r?(r.download=n,r.style.display="none",r.href=URL.createObjectURL(new Blob([t])),document.body.appendChild(r),r.click(),r.remove()):e.tip.show(window.VditorI18n.downloadTip,0)},_n=((Ln=function(e,t){return(Ln=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])})(e,t)},function(e,t){function n(){this.constructor=e}Ln(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)})(An,Tn=ve),An);function An(o,e){var t=Tn.call(this,o,e)||this,n=t.element.children[0],r=document.createElement("div");return r.className="vditor-hint"+(2===e.level?"":" vditor-panel--arrow"),r.innerHTML='<button data-type="markdown">Markdown</button>\n<button data-type="pdf">PDF</button>\n<button data-type="html">HTML</button>',r.addEventListener((0,B.Le)(),function(e){var t,n,r,i=e.target;if("BUTTON"===i.tagName){switch(i.getAttribute("data-type")){case"markdown":r=a(n=o),Mn(n,r,r.substr(0,10)+".md");break;case"pdf":!function(e){e.tip.show(window.VditorI18n.generate,3800);var t=document.querySelector("iframe");t.contentDocument.open(),t.contentDocument.write('<link rel="stylesheet" href="'+e.options.cdn+'/index.css"/>\n<script src="'+e.options.cdn+'/method.min.js"><\/script>\n<div id="preview"></div>\n<script>\nwindow.addEventListener("message", (e) => {\n  if(!e.data) {\n    return;\n  }\n  Vditor.preview(document.getElementById(\'preview\'), e.data, {\n    markdown: {\n      theme: "'+e.options.preview.theme+'"\n    },\n    hljs: {\n      style: "'+e.options.preview.hljs.style+'"\n    }\n  });\n  setTimeout(() => {\n        window.print();\n    }, 3600);\n}, false);\n<\/script>'),t.contentDocument.close(),setTimeout(function(){t.contentWindow.postMessage(a(e),"*")},200)}(o);break;case"html":n=Ot(t=o),r='<html><head><link rel="stylesheet" type="text/css" href="'+t.options.cdn+'/index.css"/>\n<script src="'+t.options.cdn+"/js/i18n/"+t.options.lang+'.js"><\/script>\n<script src="'+t.options.cdn+'/method.min.js"><\/script></head>\n<body><div class="vditor-reset" id="preview">'+n+"</div>\n<script>\n    const previewElement = document.getElementById('preview')\n    Vditor.setContentTheme('"+t.options.preview.theme.current+"', '"+t.options.preview.theme.path+"');\n    Vditor.codeRender(previewElement);\n    Vditor.highlightRender("+JSON.stringify(t.options.preview.hljs)+", previewElement, '"+t.options.cdn+"');\n    Vditor.mathRender(previewElement, {\n        cdn: '"+t.options.cdn+"',\n        math: "+JSON.stringify(t.options.preview.math)+",\n    });\n    Vditor.mermaidRender(previewElement, '"+t.options.cdn+"', '"+t.options.theme+"');\n    Vditor.flowchartRender(previewElement, '"+t.options.cdn+"');\n    Vditor.graphvizRender(previewElement, '"+t.options.cdn+"');\n    Vditor.chartRender(previewElement, '"+t.options.cdn+"', '"+t.options.theme+"');\n    Vditor.mindmapRender(previewElement, '"+t.options.cdn+"', '"+t.options.theme+"');\n    Vditor.abcRender(previewElement, '"+t.options.cdn+"');\n    Vditor.mediaRender(previewElement);\n    Vditor.speechRender(previewElement);\n<\/script>\n<script src=\""+t.options.cdn+"/js/icons/"+t.options.icon+'.js"><\/script></body></html>',Mn(t,r,n.substr(0,10)+".html")}L(o,["subToolbar"]),e.preventDefault(),e.stopPropagation()}}),t.element.appendChild(r),d(o,r,n,e.level),t}var xn,Hn,Nn=((xn=function(e,t){return(xn=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])})(e,t)},function(e,t){function n(){this.constructor=e}xn(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)})(Dn,Hn=ve),Dn.prototype._bindEvent=function(t,n){this.element.children[0].addEventListener((0,B.Le)(),function(e){e.preventDefault(),t.element.className.includes("vditor--fullscreen")?(n.level||(this.innerHTML=n.icon),t.element.style.zIndex="",document.body.style.overflow="",t.element.classList.remove("vditor--fullscreen"),Object.keys(t.toolbar.elements).forEach(function(e){e=t.toolbar.elements[e].firstChild;e&&(e.className=e.className.replace("__s","__n"))}),t.counter&&(t.counter.element.className=t.counter.element.className.replace("__s","__n"))):(n.level||(this.innerHTML='<svg><use xlink:href="#vditor-icon-contract"></use></svg>'),t.element.style.zIndex=t.options.fullscreen.index.toString(),document.body.style.overflow="hidden",t.element.classList.add("vditor--fullscreen"),Object.keys(t.toolbar.elements).forEach(function(e){e=t.toolbar.elements[e].firstChild;e&&(e.className=e.className.replace("__n","__s"))}),t.counter&&(t.counter.element.className=t.counter.element.className.replace("__n","__s"))),t.devtools&&t.devtools.renderEchart(t),n.click&&n.click(e,t),te(t),ne(t)})},Dn);function Dn(e,t){var n=Hn.call(this,e,t)||this;return n._bindEvent(e,t),n}var On,In,jn=((On=function(e,t){return(On=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])})(e,t)},function(e,t){function n(){this.constructor=e}On(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)})(Rn,In=ve),Rn.prototype._bindEvent=function(t,n){var r=this.element.children[0];r.addEventListener((0,B.Le)(),function(e){e.preventDefault(),r.classList.contains(D.g.CLASS_MENU_DISABLED)||(r.blur(),r.classList.contains("vditor-menu--current")?("wysiwyg"===t.currentMode?(ae(t),ie(t)):"ir"===t.currentMode&&_t(t,""),r.classList.remove("vditor-menu--current")):(L(t,["subToolbar"]),n.style.display="block"))});for(var e=0;e<6;e++)n.children.item(e).addEventListener((0,B.Le)(),function(e){e.preventDefault(),"wysiwyg"===t.currentMode?(oe(t,e.target.getAttribute("data-tag")),ie(t),r.classList.add("vditor-menu--current")):"ir"===t.currentMode?(_t(t,e.target.getAttribute("data-value")),r.classList.add("vditor-menu--current")):Ye(t,e.target.getAttribute("data-value")),n.style.display="none"})},Rn);function Rn(e,t){var n=In.call(this,e,t)||this,t=document.createElement("div");return t.className="vditor-hint vditor-panel--arrow",t.innerHTML='<button data-tag="h1" data-value="# ">Heading 1 '+(0,B.ns)("&lt;⌥⌘1>")+'</button>\n<button data-tag="h2" data-value="## ">Heading 2 &lt;'+(0,B.ns)("⌥⌘2")+'></button>\n<button data-tag="h3" data-value="### ">Heading 3 &lt;'+(0,B.ns)("⌥⌘3")+'></button>\n<button data-tag="h4" data-value="#### ">Heading 4 &lt;'+(0,B.ns)("⌥⌘4")+'></button>\n<button data-tag="h5" data-value="##### ">Heading 5 &lt;'+(0,B.ns)("⌥⌘5")+'></button>\n<button data-tag="h6" data-value="###### ">Heading 6 &lt;'+(0,B.ns)("⌥⌘6")+"></button>",n.element.appendChild(t),n._bindEvent(e,t),n}var Pn,Bn,qn=((Pn=function(e,t){return(Pn=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])})(e,t)},function(e,t){function n(){this.constructor=e}Pn(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)})(Vn,Bn=ve),Vn);function Vn(t,e){e=Bn.call(this,t,e)||this;return e.element.children[0].addEventListener((0,B.Le)(),function(e){e.preventDefault(),t.tip.show('<div style="margin-bottom:14px;font-size: 14px;line-height: 22px;min-width:300px;max-width: 360px;display: flex;">\n<div style="margin-top: 14px;flex: 1">\n    <div>Markdown 使用指南</div>\n    <ul style="list-style: none">\n        <li><a href="https://ld246.com/article/1583308420519" target="_blank">语法速查手册</a></li>\n        <li><a href="https://ld246.com/article/1583129520165" target="_blank">基础语法</a></li>\n        <li><a href="https://ld246.com/article/1583305480675" target="_blank">扩展语法</a></li>\n        <li><a href="https://ld246.com/article/1582778815353" target="_blank">键盘快捷键</a></li>\n    </ul>\n</div>\n<div style="margin-top: 14px;flex: 1">\n    <div>Vditor 支持</div>\n    <ul style="list-style: none">\n        <li><a href="https://github.com/Vanessa219/vditor/issues" target="_blank">Issues</a></li>\n        <li><a href="https://ld246.com/tag/vditor" target="_blank">官方讨论区</a></li>\n        <li><a href="https://ld246.com/article/1549638745630" target="_blank">开发手册</a></li>\n        <li><a href="https://ld246.com/guide/markdown" target="_blank">演示地址</a></li>\n    </ul>\n</div></div>',0)}),e}var Un,Wn,Kn=((Un=function(e,t){return(Un=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])})(e,t)},function(e,t){function n(){this.constructor=e}Un(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)})(Gn,Wn=ve),Gn);function Gn(n,e){var r=Wn.call(this,n,e)||this;return r.element.children[0].addEventListener((0,B.Le)(),function(e){var t;e.preventDefault(),r.element.firstElementChild.classList.contains(D.g.CLASS_MENU_DISABLED)||"sv"===n.currentMode||(t=(0,Z.zh)(n),(e=(0,U.lG)(t.startContainer,"LI"))&&ht(n,e,t))}),r}var zn,Fn,Zn=((zn=function(e,t){return(zn=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])})(e,t)},function(e,t){function n(){this.constructor=e}zn(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)})(Jn,Fn=ve),Jn);function Jn(t,e){e=Fn.call(this,t,e)||this;return e.element.children[0].addEventListener((0,B.Le)(),function(e){e.preventDefault(),t.tip.show('<div style="max-width: 520px; font-size: 14px;line-height: 22px;margin-bottom: 14px;">\n<p style="text-align: center;margin: 14px 0">\n    <em>下一代的 Markdown 编辑器，为未来而构建</em>\n</p>\n<div style="display: flex;margin-bottom: 14px;flex-wrap: wrap;align-items: center">\n    <img src="https://cdn.jsdelivr.net/npm/vditor/src/assets/images/logo.png" style="margin: 0 auto;height: 68px"/>\n    <div>&nbsp;&nbsp;</div>\n    <div style="flex: 1;min-width: 250px">\n        Vditor 是一款浏览器端的 Markdown 编辑器，支持所见即所得、即时渲染（类似 Typora）和分屏预览模式。\n        它使用 TypeScript 实现，支持原生 JavaScript、Vue、React、Angular，提供<a target="_blank" href="https://b3log.org/siyuan">桌面版</a>。\n    </div>\n</div>\n<div style="display: flex;flex-wrap: wrap;">\n    <ul style="list-style: none;flex: 1;min-width:148px">\n        <li>\n        项目地址：<a href="https://b3log.org/vditor" target="_blank">b3log.org/vditor</a>\n        </li>\n        <li>\n        开源协议：MIT\n        </li>\n    </ul>\n    <ul style="list-style: none;margin-right: 18px">\n        <li>\n        组件版本：Vditor v'+D.H+" / Lute v"+Lute.Version+'\n        </li>\n        <li>\n        赞助捐赠：<a href="https://ld246.com/sponsor" target="_blank">https://ld246.com/sponsor</a>\n        </li>\n    </ul>\n</div>\n</div>',0)}),e}var Xn,Yn,Qn=((Xn=function(e,t){return(Xn=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])})(e,t)},function(e,t){function n(){this.constructor=e}Xn(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)})($n,Yn=ve),$n);function $n(t,e){var n=Yn.call(this,t,e)||this;return n.element.children[0].addEventListener((0,B.Le)(),function(e){e.preventDefault(),n.element.firstElementChild.classList.contains(D.g.CLASS_MENU_DISABLED)||"sv"===t.currentMode||ct(t,"afterend")}),n}var er,tr,nr=((er=function(e,t){return(er=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])})(e,t)},function(e,t){function n(){this.constructor=e}er(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)})(rr,tr=ve),rr);function rr(t,e){var n=tr.call(this,t,e)||this;return n.element.children[0].addEventListener((0,B.Le)(),function(e){e.preventDefault(),n.element.firstElementChild.classList.contains(D.g.CLASS_MENU_DISABLED)||"sv"===t.currentMode||ct(t,"beforebegin")}),n}var ir,or,ar=((ir=function(e,t){return(ir=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])})(e,t)},function(e,t){function n(){this.constructor=e}ir(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)})(lr,or=ve),lr);function lr(n,e){var r=or.call(this,n,e)||this;return r.element.children[0].addEventListener((0,B.Le)(),function(e){var t;e.preventDefault(),r.element.firstElementChild.classList.contains(D.g.CLASS_MENU_DISABLED)||"sv"===n.currentMode||(t=(0,Z.zh)(n),(e=(0,U.lG)(t.startContainer,"LI"))&&vt(n,e,t,e.parentElement))}),r}var sr,dr,cr=((sr=function(e,t){return(sr=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])})(e,t)},function(e,t){function n(){this.constructor=e}sr(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)})(ur,dr=ve),ur);function ur(t,e){var n=dr.call(this,t,e)||this;return t.options.outline&&n.element.firstElementChild.classList.add("vditor-menu--current"),n.element.children[0].addEventListener((0,B.Le)(),function(e){e.preventDefault(),t.toolbar.elements.outline.firstElementChild.classList.contains(D.g.CLASS_MENU_DISABLED)||(t.options.outline.enable=!n.element.firstElementChild.classList.contains("vditor-menu--current"),t.outline.toggle(t,t.options.outline.enable))}),n}var pr,mr,fr=((pr=function(e,t){return(pr=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])})(e,t)},function(e,t){function n(){this.constructor=e}pr(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)})(hr,mr=ve),hr.prototype._bindEvent=function(n){var r=this;this.element.children[0].addEventListener((0,B.Le)(),function(e){e.preventDefault();var t=r.element.firstElementChild;t.classList.contains(D.g.CLASS_MENU_DISABLED)||(e=D.g.EDIT_TOOLBARS.concat(["both","edit-mode","devtools"]),t.classList.contains("vditor-menu--current")?(t.classList.remove("vditor-menu--current"),"sv"===n.currentMode?(n.sv.element.style.display="block","both"===n.options.preview.mode?n.preview.element.style.display="block":n.preview.element.style.display="none"):(n[n.currentMode].element.parentElement.style.display="block",n.preview.element.style.display="none"),O(n.toolbar.elements,e),n.outline.render(n)):(I(n.toolbar.elements,e),n.preview.element.style.display="block","sv"===n.currentMode?n.sv.element.style.display="none":n[n.currentMode].element.parentElement.style.display="none",n.preview.render(n),t.classList.add("vditor-menu--current"),L(n,["subToolbar","hint","popover"]),setTimeout(function(){n.outline.render(n)},n.options.preview.delay+10)),te(n))})},hr);function hr(e,t){t=mr.call(this,e,t)||this;return t._bindEvent(e),t}var vr=(gr.prototype.cloneChannelData=function(e,t){this.leftChannel.push(new Float32Array(e)),this.rightChannel.push(new Float32Array(t)),this.recordingLength+=2048},gr.prototype.startRecordingNewWavFile=function(){this.readyFlag&&(this.isRecording=!0,this.leftChannel.length=this.rightChannel.length=0,this.recordingLength=0)},gr.prototype.stopRecording=function(){this.isRecording=!1},gr.prototype.buildWavFileBlob=function(){for(var e=this.mergeBuffers(this.leftChannel),t=this.mergeBuffers(this.rightChannel),n=new Float32Array(e.length),r=0;r<e.length;++r)n[r]=.5*(e[r]+t[r]);var i=44+2*(n=this.DEFAULT_SAMPLE_RATE>this.SAMPLE_RATE?this.downSampleBuffer(n,this.SAMPLE_RATE):n).length,o=new ArrayBuffer(i),a=new DataView(o);this.writeUTFBytes(a,0,"RIFF"),a.setUint32(4,i,!0),this.writeUTFBytes(a,8,"WAVE"),this.writeUTFBytes(a,12,"fmt "),a.setUint32(16,16,!0),a.setUint16(20,1,!0),a.setUint16(22,1,!0),a.setUint32(24,this.SAMPLE_RATE,!0),a.setUint32(28,2*this.SAMPLE_RATE,!0),a.setUint16(32,2,!0),a.setUint16(34,16,!0);i=2*n.length;this.writeUTFBytes(a,36,"data"),a.setUint32(40,i,!0);for(var l=n.length,s=44,d=0;d<l;d++)a.setInt16(s,32767*n[d],!0),s+=2;return new Blob([a],{type:"audio/wav"})},gr.prototype.downSampleBuffer=function(e,t){if(t===this.DEFAULT_SAMPLE_RATE)return e;if(t>this.DEFAULT_SAMPLE_RATE)return e;for(var n=this.DEFAULT_SAMPLE_RATE/t,t=Math.round(e.length/n),r=new Float32Array(t),i=0,o=0;i<r.length;){for(var a=Math.round((i+1)*n),l=0,s=0,d=o;d<a&&d<e.length;d++)l+=e[d],s++;r[i]=l/s,i++,o=a}return r},gr.prototype.mergeBuffers=function(e){for(var t=new Float32Array(this.recordingLength),n=0,r=e.length,i=0;i<r;++i){var o=e[i];t.set(o,n),n+=o.length}return t},gr.prototype.writeUTFBytes=function(e,t,n){for(var r=n.length,i=0;i<r;i++)e.setUint8(t+i,n.charCodeAt(i))},gr);function gr(e){var t;if(this.SAMPLE_RATE=5e3,this.isRecording=!1,this.readyFlag=!1,this.leftChannel=[],this.rightChannel=[],this.recordingLength=0,"undefined"!=typeof AudioContext)t=new AudioContext;else{if(!webkitAudioContext)return;t=new webkitAudioContext}this.DEFAULT_SAMPLE_RATE=t.sampleRate;var n=t.createGain();t.createMediaStreamSource(e).connect(n),this.recorder=t.createScriptProcessor(2048,2,1),this.recorder.onaudioprocess=null,n.connect(this.recorder),this.recorder.connect(t.destination),this.readyFlag=!0}var yr,br,wr=((yr=function(e,t){return(yr=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])})(e,t)},function(e,t){function n(){this.constructor=e}yr(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)})(Er,br=ve),Er.prototype._bindEvent=function(n){var r,i=this;this.element.children[0].addEventListener((0,B.Le)(),function(e){var t;e.preventDefault(),i.element.firstElementChild.classList.contains(D.g.CLASS_MENU_DISABLED)||(t=n[n.currentMode].element,r?r.isRecording?(r.stopRecording(),n.tip.hide(),e=new File([r.buildWavFileBlob()],"record"+(new Date).getTime()+".wav",{type:"video/webm"}),Ae(n,[e]),i.element.children[0].classList.remove("vditor-menu--current")):(n.tip.show(window.VditorI18n.recording),t.setAttribute("contenteditable","false"),r.startRecordingNewWavFile(),i.element.children[0].classList.add("vditor-menu--current")):navigator.mediaDevices.getUserMedia({audio:!0}).then(function(e){(r=new vr(e)).recorder.onaudioprocess=function(e){var t;r.isRecording&&(t=e.inputBuffer.getChannelData(0),e=e.inputBuffer.getChannelData(1),r.cloneChannelData(t,e))},r.startRecordingNewWavFile(),n.tip.show(window.VditorI18n.recording),t.setAttribute("contenteditable","false"),i.element.children[0].classList.add("vditor-menu--current")}).catch(function(){n.tip.show(window.VditorI18n["record-tip"])}))})},Er);function Er(e,t){t=br.call(this,e,t)||this;return t._bindEvent(e),t}var kr,Sr,Cr=((kr=function(e,t){return(kr=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])})(e,t)},function(e,t){function n(){this.constructor=e}kr(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)})(Lr,Sr=ve),Lr);function Lr(t,e){var n=Sr.call(this,t,e)||this;return I({redo:n.element},["redo"]),n.element.children[0].addEventListener((0,B.Le)(),function(e){e.preventDefault(),n.element.firstElementChild.classList.contains(D.g.CLASS_MENU_DISABLED)||t.undo.redo(t)}),n}var Tr,Mr,_r=((Tr=function(e,t){return(Tr=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])})(e,t)},function(e,t){function n(){this.constructor=e}Tr(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)})(Ar,Mr=ve),Ar);function Ar(t,e){var n=Mr.call(this,t,e)||this;return I({undo:n.element},["undo"]),n.element.children[0].addEventListener((0,B.Le)(),function(e){e.preventDefault(),n.element.firstElementChild.classList.contains(D.g.CLASS_MENU_DISABLED)||t.undo.undo(t)}),n}var xr,Hr,Nr=((xr=function(e,t){return(xr=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])})(e,t)},function(e,t){function n(){this.constructor=e}xr(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)})(Dr,Hr=ve),Dr.prototype._bindEvent=function(t){var n=this;this.element.children[0].addEventListener((0,B.Le)(),function(e){n.element.firstElementChild.classList.contains(D.g.CLASS_MENU_DISABLED)&&(e.stopPropagation(),e.preventDefault())}),this.element.querySelector("input").addEventListener("change",function(e){return n.element.firstElementChild.classList.contains(D.g.CLASS_MENU_DISABLED)?(e.stopPropagation(),void e.preventDefault()):void(0!==e.target.files.length&&Ae(t,e.target.files,e.target))})},Dr);function Dr(e,t){var n=Hr.call(this,e,t)||this,r='<input type="file"';return e.options.upload.multiple&&(r+=' multiple="multiple"'),e.options.upload.accept&&(r+=' accept="'+e.options.upload.accept+'"'),n.element.children[0].innerHTML=""+(t.icon||'<svg><use xlink:href="#vditor-icon-upload"></use></svg>')+r+">",n._bindEvent(e),n}var Or=(Ir.prototype.genItem=function(e,t,n){var r;switch(t.name){case"bold":case"italic":case"more":case"strike":case"line":case"quote":case"list":case"ordered-list":case"check":case"code":case"inline-code":case"link":case"table":r=new ve(e,t);break;case"emoji":r=new Sn(e,t);break;case"headings":r=new jn(e,t);break;case"|":r=new kn;break;case"br":r=new tn;break;case"undo":r=new _r(e,t);break;case"redo":r=new Cr(e,t);break;case"help":r=new qn(e,t);break;case"both":r=new Yt(e,t);break;case"preview":r=new fr(e,t);break;case"fullscreen":r=new Nn(e,t);break;case"upload":r=new Nr(e,t);break;case"record":r=new wr(e,t);break;case"info":r=new Zn(e,t);break;case"edit-mode":r=new ye(e,t);break;case"devtools":r=new yn(e,t);break;case"outdent":r=new ar(e,t);break;case"indent":r=new Kn(e,t);break;case"outline":r=new cr(e,t);break;case"insert-after":r=new Qn(e,t);break;case"insert-before":r=new nr(e,t);break;case"code-theme":r=new rn(e,t);break;case"content-theme":r=new sn(e,t);break;case"export":r=new _n(e,t);break;default:r=new fn(e,t)}if(r){var i=t.name;return"br"!==i&&"|"!==i||(i+=n),this.elements[i]=r.element,r.element}},Ir);function Ir(i){var o=this,e=i.options;this.elements={},this.element=document.createElement("div"),this.element.className="vditor-toolbar",e.toolbar.forEach(function(e,n){var r,t=o.genItem(i,e,n);o.element.appendChild(t),e.toolbar&&((r=document.createElement("div")).className="vditor-hint vditor-panel--arrow",r.addEventListener((0,B.Le)(),function(e){r.style.display="none"}),e.toolbar.forEach(function(e,t){e.level=2,r.appendChild(o.genItem(i,e,n+t))}),t.appendChild(r),d(i,r,t.children[0]))}),i.options.toolbarConfig.hide&&this.element.classList.add("vditor-toolbar--hide"),i.options.toolbarConfig.pin&&this.element.classList.add("vditor-toolbar--pin"),i.options.counter.enable&&(i.counter=new cn(i),this.element.appendChild(i.counter.element))}var jr=Zr(694),Rr=(Pr.prototype.clearStack=function(e){this.resetStack(),this.resetIcon(e)},Pr.prototype.resetIcon=function(e){e.toolbar&&((1<this[e.currentMode].undoStack.length?O:I)(e.toolbar.elements,["undo"]),(0!==this[e.currentMode].redoStack.length?O:I)(e.toolbar.elements,["redo"]))},Pr.prototype.undo=function(e){var t;"false"!==e[e.currentMode].element.getAttribute("contenteditable")&&(this[e.currentMode].undoStack.length<2||(t=this[e.currentMode].undoStack.pop())&&(this[e.currentMode].redoStack.push(t),this.renderDiff(t,e),this[e.currentMode].hasUndo=!0,L(e,["hint"])))},Pr.prototype.redo=function(e){var t;"false"===e[e.currentMode].element.getAttribute("contenteditable")||(t=this[e.currentMode].redoStack.pop())&&(this[e.currentMode].undoStack.push(t),this.renderDiff(t,e,!0))},Pr.prototype.recordFirstPosition=function(e,t){0!==getSelection().rangeCount&&(1!==this[e.currentMode].undoStack.length||0===this[e.currentMode].undoStack[0].length||0<this[e.currentMode].redoStack.length||(0,B.vU)()&&"Backspace"===t.key||(0,B.G6)()||(t=this.addCaret(e)).replace("<wbr>","").replace(" vditor-ir__node--expand","")===this[e.currentMode].undoStack[0][0].diffs[0][1].replace("<wbr>","")&&(this[e.currentMode].undoStack[0][0].diffs[0][1]=t,this[e.currentMode].lastText=t))},Pr.prototype.addToUndoStack=function(e){var t=this.addCaret(e,!0),n=this.dmp.diff_main(t,this[e.currentMode].lastText,!0),n=this.dmp.patch_make(t,this[e.currentMode].lastText,n);0===n.length&&0<this[e.currentMode].undoStack.length||(this[e.currentMode].lastText=t,this[e.currentMode].undoStack.push(n),this[e.currentMode].undoStack.length>this.stackSize&&this[e.currentMode].undoStack.shift(),this[e.currentMode].hasUndo&&(this[e.currentMode].redoStack=[],this[e.currentMode].hasUndo=!1,I(e.toolbar.elements,["redo"])),1<this[e.currentMode].undoStack.length&&O(e.toolbar.elements,["undo"]))},Pr.prototype.renderDiff=function(e,t,n){var e=(n=void 0===n?!1:n)?((n=this.dmp.patch_deepCopy(e).reverse()).forEach(function(e){e.diffs.forEach(function(e){e[0]=-e[0]})}),this.dmp.patch_apply(n,this[t.currentMode].lastText)[0]):this.dmp.patch_apply(e,this[t.currentMode].lastText)[0];this[t.currentMode].lastText=e,t[t.currentMode].element.innerHTML=e,"sv"!==t.currentMode&&t[t.currentMode].element.querySelectorAll(".vditor-"+t.currentMode+"__preview[data-render='2']").forEach(function(e){F(e,t)}),t[t.currentMode].element.querySelector("wbr")?((0,Z.ib)(t[t.currentMode].element,t[t.currentMode].element.ownerDocument.createRange()),Fe(t)):((e=getSelection().getRangeAt(0)).setEndBefore(t[t.currentMode].element),e.collapse(!1)),wt(t,{enableAddUndoStack:!1,enableHint:!1,enableInput:!0}),fe(t),t[t.currentMode].element.querySelectorAll(".vditor-"+t.currentMode+"__preview[data-render='2']").forEach(function(e){F(e,t)}),(1<this[t.currentMode].undoStack.length?O:I)(t.toolbar.elements,["undo"]),(0!==this[t.currentMode].redoStack.length?O:I)(t.toolbar.elements,["redo"])},Pr.prototype.resetStack=function(){this.ir={hasUndo:!1,lastText:"",redoStack:[],undoStack:[]},this.sv={hasUndo:!1,lastText:"",redoStack:[],undoStack:[]},this.wysiwyg={hasUndo:!1,lastText:"",redoStack:[],undoStack:[]}},Pr.prototype.addCaret=function(e,t){var n,r;void 0===t&&(t=!1),0===getSelection().rangeCount||e[e.currentMode].element.querySelector("wbr")||(n=getSelection().getRangeAt(0),e[e.currentMode].element.contains(n.startContainer)&&(r=n.cloneRange(),(i=document.createElement("span")).className="vditor-wbr",n.insertNode(i))),e.ir.element.cloneNode(!0).querySelectorAll(".vditor-"+e.currentMode+"__preview[data-render='1']").forEach(function(e){(e.firstElementChild.classList.contains("language-echarts")||e.firstElementChild.classList.contains("language-plantuml")||e.firstElementChild.classList.contains("language-mindmap"))&&(e.firstElementChild.removeAttribute("_echarts_instance_"),e.firstElementChild.removeAttribute("data-processed"),e.firstElementChild.innerHTML=e.previousElementSibling.firstElementChild.innerHTML,e.setAttribute("data-render","2")),e.firstElementChild.classList.contains("language-math")&&(e.setAttribute("data-render","2"),e.firstElementChild.textContent=e.firstElementChild.getAttribute("data-math"),e.firstElementChild.removeAttribute("data-math"))});var i=e[e.currentMode].element.innerHTML;return e[e.currentMode].element.querySelectorAll(".vditor-wbr").forEach(function(e){e.remove()}),t&&r&&(0,Z.Hc)(r),i.replace('<span class="vditor-wbr"></span>',"<wbr>")},Pr);function Pr(){this.stackSize=50,this.resetStack(),this.dmp=new jr}var Br=Zr(224),qr=(Vr.prototype.merge=function(){this.options&&(this.options.toolbar?this.options.toolbar=this.mergeToolbar(this.options.toolbar):this.options.toolbar=this.mergeToolbar(this.defaultOptions.toolbar),null!==(e=null===(e=this.options.preview)||void 0===e?void 0:e.theme)&&void 0!==e&&e.list&&(this.defaultOptions.preview.theme.list=this.options.preview.theme.list),null!==(e=this.options.hint)&&void 0!==e&&e.emoji&&(this.defaultOptions.hint.emoji=this.options.hint.emoji),this.options.comment&&(this.defaultOptions.comment=this.options.comment));var e=(0,Br.T)(this.defaultOptions,this.options);if(e.cache.enable&&!e.cache.id)throw new Error("need options.cache.id, see https://ld246.com/article/1549638745630#options");return e},Vr.prototype.mergeToolbar=function(e){var r=this,i=[{icon:'<svg><use xlink:href="#vditor-icon-export"></use></svg>',name:"export",tipPosition:"ne"},{hotkey:"⌘E",icon:'<svg><use xlink:href="#vditor-icon-emoji"></use></svg>',name:"emoji",tipPosition:"ne"},{hotkey:"⌘H",icon:'<svg><use xlink:href="#vditor-icon-headings"></use></svg>',name:"headings",tipPosition:"ne"},{hotkey:"⌘B",icon:'<svg><use xlink:href="#vditor-icon-bold"></use></svg>',name:"bold",prefix:"**",suffix:"**",tipPosition:"ne"},{hotkey:"⌘I",icon:'<svg><use xlink:href="#vditor-icon-italic"></use></svg>',name:"italic",prefix:"*",suffix:"*",tipPosition:"ne"},{hotkey:"⌘D",icon:'<svg><use xlink:href="#vditor-icon-strike"></use></svg>',name:"strike",prefix:"~~",suffix:"~~",tipPosition:"ne"},{hotkey:"⌘K",icon:'<svg><use xlink:href="#vditor-icon-link"></use></svg>',name:"link",prefix:"[",suffix:"](https://)",tipPosition:"n"},{name:"|"},{hotkey:"⌘L",icon:'<svg><use xlink:href="#vditor-icon-list"></use></svg>',name:"list",prefix:"* ",tipPosition:"n"},{hotkey:"⌘O",icon:'<svg><use xlink:href="#vditor-icon-ordered-list"></use></svg>',name:"ordered-list",prefix:"1. ",tipPosition:"n"},{hotkey:"⌘J",icon:'<svg><use xlink:href="#vditor-icon-check"></use></svg>',name:"check",prefix:"* [ ] ",tipPosition:"n"},{hotkey:"⇧⌘I",icon:'<svg><use xlink:href="#vditor-icon-outdent"></use></svg>',name:"outdent",tipPosition:"n"},{hotkey:"⇧⌘O",icon:'<svg><use xlink:href="#vditor-icon-indent"></use></svg>',name:"indent",tipPosition:"n"},{name:"|"},{hotkey:"⌘;",icon:'<svg><use xlink:href="#vditor-icon-quote"></use></svg>',name:"quote",prefix:"> ",tipPosition:"n"},{hotkey:"⇧⌘H",icon:'<svg><use xlink:href="#vditor-icon-line"></use></svg>',name:"line",prefix:"---",tipPosition:"n"},{hotkey:"⌘U",icon:'<svg><use xlink:href="#vditor-icon-code"></use></svg>',name:"code",prefix:"```",suffix:"\n```",tipPosition:"n"},{hotkey:"⌘G",icon:'<svg><use xlink:href="#vditor-icon-inline-code"></use></svg>',name:"inline-code",prefix:"`",suffix:"`",tipPosition:"n"},{hotkey:"⇧⌘B",icon:'<svg><use xlink:href="#vditor-icon-before"></use></svg>',name:"insert-before",tipPosition:"n"},{hotkey:"⇧⌘E",icon:'<svg><use xlink:href="#vditor-icon-after"></use></svg>',name:"insert-after",tipPosition:"n"},{name:"|"},{icon:'<svg><use xlink:href="#vditor-icon-upload"></use></svg>',name:"upload",tipPosition:"n"},{icon:'<svg><use xlink:href="#vditor-icon-record"></use></svg>',name:"record",tipPosition:"n"},{hotkey:"⌘M",icon:'<svg><use xlink:href="#vditor-icon-table"></use></svg>',name:"table",prefix:"| col1",suffix:" | col2 | col3 |\n| --- | --- | --- |\n|  |  |  |\n|  |  |  |",tipPosition:"n"},{name:"|"},{hotkey:"⌘Z",icon:'<svg><use xlink:href="#vditor-icon-undo"></use></svg>',name:"undo",tipPosition:"nw"},{hotkey:"⌘Y",icon:'<svg><use xlink:href="#vditor-icon-redo"></use></svg>',name:"redo",tipPosition:"nw"},{name:"|"},{icon:'<svg><use xlink:href="#vditor-icon-more"></use></svg>',name:"more",tipPosition:"e"},{hotkey:"⌘'",icon:'<svg><use xlink:href="#vditor-icon-fullscreen"></use></svg>',name:"fullscreen",tipPosition:"nw"},{icon:'<svg><use xlink:href="#vditor-icon-edit"></use></svg>',name:"edit-mode",tipPosition:"nw"},{hotkey:"⌘P",icon:'<svg><use xlink:href="#vditor-icon-both"></use></svg>',name:"both",tipPosition:"nw"},{icon:'<svg><use xlink:href="#vditor-icon-preview"></use></svg>',name:"preview",tipPosition:"nw"},{icon:'<svg><use xlink:href="#vditor-icon-align-center"></use></svg>',name:"outline",tipPosition:"nw"},{icon:'<svg><use xlink:href="#vditor-icon-theme"></use></svg>',name:"content-theme",tipPosition:"nw"},{icon:'<svg><use xlink:href="#vditor-icon-code-theme"></use></svg>',name:"code-theme",tipPosition:"nw"},{icon:'<svg><use xlink:href="#vditor-icon-bug"></use></svg>',name:"devtools",tipPosition:"nw"},{icon:'<svg><use xlink:href="#vditor-icon-info"></use></svg>',name:"info",tipPosition:"nw"},{icon:'<svg><use xlink:href="#vditor-icon-help"></use></svg>',name:"help",tipPosition:"nw"},{name:"br"}],o=[];return e.forEach(function(t){var n=t;i.forEach(function(e){"string"==typeof t&&e.name===t&&(n=e),"object"==typeof t&&e.name===t.name&&(n=Object.assign({},e,t))}),t.toolbar&&(n.toolbar=r.mergeToolbar(t.toolbar)),o.push(n)}),o},Vr);function Vr(e){this.defaultOptions={after:void 0,cache:{enable:!0},cdn:D.g.CDN,classes:{preview:""},comment:{enable:!1},counter:{enable:!1,type:"markdown"},debugger:!1,fullscreen:{index:90},height:"auto",hint:{delay:200,emoji:{"+1":"👍","-1":"👎",confused:"😕",eyes:"👀️",heart:"❤️",rocket:"🚀️",smile:"😄",tada:"🎉️"},emojiPath:D.g.CDN+"/images/emoji",extend:[],parse:!0},icon:"ant",lang:"zh_CN",mode:"ir",outline:{enable:!1,position:"left"},placeholder:"",preview:{actions:["desktop","tablet","mobile","mp-wechat","zhihu"],delay:1e3,hljs:D.g.HLJS_OPTIONS,markdown:D.g.MARKDOWN_OPTIONS,math:D.g.MATH_OPTIONS,maxWidth:800,mode:"both",theme:D.g.THEME_OPTIONS},resize:{enable:!1,position:"bottom"},theme:"classic",toolbar:["emoji","headings","bold","italic","strike","link","|","list","ordered-list","check","outdent","indent","|","quote","line","code","inline-code","insert-before","insert-after","|","upload","record","table","|","undo","redo","|","fullscreen","edit-mode",{name:"more",toolbar:["both","code-theme","content-theme","export","outline","preview","devtools","info","help"]}],toolbarConfig:{hide:!1,pin:!1},typewriterMode:!1,undoDelay:800,upload:{extraData:{},fieldName:"file[]",filename:function(e){return e.replace(/\W/g,"")},linkToImgUrl:"",max:10485760,multiple:!0,url:"",withCredentials:!1},value:"",width:"auto"},this.options=e}var Ur=(Wr.prototype.getComments=function(e,t){var n=this;if(void 0===t&&(t=!1),"wysiwyg"!==e.currentMode||!e.options.comment.enable)return[];this.commentIds=[],this.element.querySelectorAll(".vditor-comment").forEach(function(e){n.commentIds=n.commentIds.concat(e.getAttribute("data-cmtids").split(" "))}),this.commentIds=Array.from(new Set(this.commentIds));var r=[];return t?(this.commentIds.forEach(function(e){r.push({id:e,top:n.element.querySelector('.vditor-comment[data-cmtids="'+e+'"]').offsetTop})}),r):void 0},Wr.prototype.triggerRemoveComment=function(e){var t,n,r,i;"wysiwyg"===e.currentMode&&e.options.comment.enable&&0<e.wysiwyg.commentIds.length&&(t=JSON.parse(JSON.stringify(this.commentIds)),this.getComments(e),n=t,r=this.commentIds,i=new Set(r),0<(t=n.filter(function(e){return!i.has(e)})).length&&e.options.comment.remove(t))},Wr.prototype.showComment=function(){var e=(0,Z.Ny)(this.element);this.selectPopover.setAttribute("style","left:"+e.left+"px;display:block;top:"+Math.max(-8,e.top-21)+"px")},Wr.prototype.hideComment=function(){this.selectPopover.setAttribute("style","display:none")},Wr.prototype.copy=function(e,t){var n=getSelection().getRangeAt(0);if(""!==n.toString()){e.stopPropagation(),e.preventDefault();var r=(0,U.lG)(n.startContainer,"CODE"),i=(0,U.lG)(n.endContainer,"CODE");if(r&&i&&i.isSameNode(r)){var o="",o="PRE"===r.parentElement.tagName?n.toString():"`"+n.toString()+"`";return e.clipboardData.setData("text/plain",o),void e.clipboardData.setData("text/html","")}r=(0,U.lG)(n.startContainer,"A"),o=(0,U.lG)(n.endContainer,"A");if(r&&o&&o.isSameNode(r)){var a=(a=r.getAttribute("title")||"")&&' "'+a+'"';return e.clipboardData.setData("text/plain","["+n.toString()+"]("+r.getAttribute("href")+a+")"),void e.clipboardData.setData("text/html","")}a=document.createElement("div");a.appendChild(n.cloneContents()),e.clipboardData.setData("text/plain",t.lute.VditorDOM2Md(a.innerHTML).trim()),e.clipboardData.setData("text/html","")}},Wr.prototype.bindEvent=function(s){var d=this;window.addEventListener("scroll",function(){var e,t;L(s,["hint"]),"block"===d.popover.style.display&&"block"===d.selectPopover.style.display&&(e=parseInt(d.popover.getAttribute("data-top"),10),"auto"===s.options.height?s.options.toolbarConfig.pin&&(t=Math.max(e,window.scrollY-s.element.offsetTop-8)+"px","block"===d.popover.style.display&&(d.popover.style.top=t),"block"===d.selectPopover.style.display&&(d.selectPopover.style.top=t)):s.options.toolbarConfig.pin&&0===s.toolbar.element.getBoundingClientRect().top&&(e=Math.max(window.scrollY-s.element.offsetTop-8,Math.min(e-s.wysiwyg.element.scrollTop,d.element.clientHeight-21))+"px","block"===d.popover.style.display&&(d.popover.style.top=e),"block"===d.selectPopover.style.display&&(d.selectPopover.style.top=e)))}),this.element.addEventListener("scroll",function(){var e,t;L(s,["hint"]),s.options.comment&&s.options.comment.enable&&s.options.comment.scroll&&s.options.comment.scroll(s.wysiwyg.element.scrollTop),"block"===d.popover.style.display&&(t=parseInt(d.popover.getAttribute("data-top"),10)-s.wysiwyg.element.scrollTop,e=-8,s.options.toolbarConfig.pin&&0===s.toolbar.element.getBoundingClientRect().top&&(e=window.scrollY-s.element.offsetTop+e),t=Math.max(e,Math.min(t,d.element.clientHeight-21))+"px",d.popover.style.top=t,d.selectPopover.style.top=t)}),this.element.addEventListener("paste",function(e){Tt(s,e,{pasteCode:function(e){var t=(0,Z.zh)(s),n=document.createElement("template");n.innerHTML=e,t.insertNode(n.content.cloneNode(!0));n=(0,U.a1)(t.startContainer,"data-block","0");n?n.outerHTML=s.lute.SpinVditorDOM(n.outerHTML):s.wysiwyg.element.innerHTML=s.lute.SpinVditorDOM(s.wysiwyg.element.innerHTML),(0,Z.ib)(s.wysiwyg.element,t)}})}),this.element.addEventListener("compositionstart",function(){d.composingLock=!0}),this.element.addEventListener("compositionend",function(e){var t=(0,W.W)(getSelection().getRangeAt(0).startContainer);t&&""===t.textContent?g(s):((0,B.vU)()||at(s,getSelection().getRangeAt(0).cloneRange(),e),d.composingLock=!1)}),this.element.addEventListener("input",function(e){if("deleteByDrag"!==e.inputType&&"insertFromDrop"!==e.inputType)if(d.preventInput)d.preventInput=!1;else if(!d.composingLock&&"‘"!==e.data&&"“"!==e.data&&"《"!==e.data){var t=getSelection().getRangeAt(0),n=(0,U.F9)(t.startContainer);if(n||(y(s,t),n=(0,U.F9)(t.startContainer)),n){for(var r=(0,Z.im)(n,s.wysiwyg.element,t).start,i=!0,o=r-1;o>n.textContent.substr(0,r).lastIndexOf("\n");o--)if(" "!==n.textContent.charAt(o)&&"\t"!==n.textContent.charAt(o)){i=!1;break}0===r&&(i=!1);for(var a=!0,o=r-1;o<n.textContent.length;o++)if(" "!==n.textContent.charAt(o)&&"\n"!==n.textContent.charAt(o)){a=!1;break}var l=(0,W.W)(getSelection().getRangeAt(0).startContainer);l&&""===l.textContent&&(g(s),l.remove()),i&&"code-block"!==n.getAttribute("data-type")||a||bt(n.innerHTML)||yt(n.innerHTML)&&n.previousElementSibling||at(s,t,e)}}}),this.element.addEventListener("click",function(e){if("INPUT"===e.target.tagName){var t=e.target;return t.checked?t.setAttribute("checked","checked"):t.removeAttribute("checked"),d.preventInput=!0,void ie(s)}var n;"IMG"!==e.target.tagName||e.target.parentElement.classList.contains("vditor-wysiwyg__preview")?("A"===e.target.tagName&&window.open(e.target.getAttribute("href")),n=(0,Z.zh)(s),e.target.isEqualNode(d.element)&&d.element.lastElementChild&&n.collapsed&&(t=d.element.lastElementChild.getBoundingClientRect(),e.y>t.top+t.height&&("P"===d.element.lastElementChild.tagName&&""===d.element.lastElementChild.textContent.trim().replace(D.g.ZWSP,"")?(n.selectNodeContents(d.element.lastElementChild),n.collapse(!1)):(d.element.insertAdjacentHTML("beforeend",'<p data-block="0">'+D.g.ZWSP+"<wbr></p>"),(0,Z.ib)(d.element,n)))),de(s),(n=(n=(0,U.fb)(e.target,"vditor-wysiwyg__preview"))||(0,U.fb)((0,Z.zh)(s).startContainer,"vditor-wysiwyg__preview"))&&E(n,s),c(e,s)):"link-ref"===e.target.getAttribute("data-type")?j(s,e.target):function(e,t){var n=e.target;t.wysiwyg.popover.innerHTML="";function r(){n.setAttribute("src",o.value),n.setAttribute("alt",l.value),n.setAttribute("title",s.value)}var i=document.createElement("span");i.setAttribute("aria-label",window.VditorI18n.imageURL),i.className="vditor-tooltipped vditor-tooltipped__n";var o=document.createElement("input");i.appendChild(o),o.className="vditor-input",o.setAttribute("placeholder",window.VditorI18n.imageURL),o.value=n.getAttribute("src")||"",o.oninput=function(){r()},o.onkeydown=function(e){se(t,e)};var a=document.createElement("span");a.setAttribute("aria-label",window.VditorI18n.alternateText),a.className="vditor-tooltipped vditor-tooltipped__n";var l=document.createElement("input");a.appendChild(l),l.className="vditor-input",l.setAttribute("placeholder",window.VditorI18n.alternateText),l.style.width="52px",l.value=n.getAttribute("alt")||"",l.oninput=function(){r()},l.onkeydown=function(e){se(t,e)};e=document.createElement("span");e.setAttribute("aria-label",window.VditorI18n.title),e.className="vditor-tooltipped vditor-tooltipped__n";var s=document.createElement("input");e.appendChild(s),s.className="vditor-input",s.setAttribute("placeholder",window.VditorI18n.title),s.value=n.getAttribute("title")||"",s.oninput=function(){r()},s.onkeydown=function(e){se(t,e)},ue(n,t),t.wysiwyg.popover.insertAdjacentElement("beforeend",i),t.wysiwyg.popover.insertAdjacentElement("beforeend",a),t.wysiwyg.popover.insertAdjacentElement("beforeend",e),ce(t,n)}(e,s)}),this.element.addEventListener("keyup",function(e){if(!e.isComposing&&!(0,B.yl)(e)){"Enter"===e.key&&Fe(s),"Backspace"!==e.key&&"Delete"!==e.key||""===s.wysiwyg.element.innerHTML||1!==s.wysiwyg.element.childNodes.length||!s.wysiwyg.element.firstElementChild||"P"!==s.wysiwyg.element.firstElementChild.tagName||0!==s.wysiwyg.element.firstElementChild.childElementCount||""!==s.wysiwyg.element.textContent&&"\n"!==s.wysiwyg.element.textContent||(s.wysiwyg.element.innerHTML="");var t=(0,Z.zh)(s);if("Backspace"===e.key&&(0,B.vU)()&&"\n"===t.startContainer.textContent&&1===t.startOffset&&(t.startContainer.textContent=""),y(s,t),de(s),"ArrowDown"===e.key||"ArrowRight"===e.key||"Backspace"===e.key||"ArrowLeft"===e.key||"ArrowUp"===e.key){"ArrowLeft"!==e.key&&"ArrowRight"!==e.key||s.hint.render(s);var n=(0,U.fb)(t.startContainer,"vditor-wysiwyg__preview");if(n=!n&&3!==t.startContainer.nodeType&&0<t.startOffset&&(o=t.startContainer).classList.contains("vditor-wysiwyg__block")?o.lastElementChild:n)if("none"!==n.previousElementSibling.style.display){var r=n.previousElementSibling;if("PRE"===r.tagName&&(r=r.firstElementChild),"ArrowDown"===e.key||"ArrowRight"===e.key){var i=function(e){for(var t=e;t&&!t.nextSibling;)t=t.parentElement;return t.nextSibling}(o=n.parentElement);if(i&&3!==i.nodeType){var o=i.querySelector(".vditor-wysiwyg__preview");if(o)return void E(o,s)}if(3===i.nodeType){for(;0===i.textContent.length&&i.nextSibling;)i=i.nextSibling;t.setStart(i,1)}else t.setStart(i.firstChild,0)}else t.selectNodeContents(r),t.collapse(!1)}else"ArrowDown"===e.key||"ArrowRight"===e.key?E(n,s):E(n,s,!1)}}})},Wr);function Wr(n){var c=this;this.composingLock=!1,this.commentIds=[];var e=document.createElement("div");e.className="vditor-wysiwyg",e.innerHTML='<pre class="vditor-reset" placeholder="'+n.options.placeholder+'"\n contenteditable="true" spellcheck="false"></pre>\n<div class="vditor-panel vditor-panel--none"></div>\n<div class="vditor-panel vditor-panel--none">\n    <button type="button" aria-label="'+window.VditorI18n.comment+'" class="vditor-icon vditor-tooltipped vditor-tooltipped__n">\n        <svg><use xlink:href="#vditor-icon-comment"></use></svg>\n    </button>\n</div>',this.element=e.firstElementChild,this.popover=e.firstElementChild.nextElementSibling,this.selectPopover=e.lastElementChild,this.bindEvent(n),we(n,this.element),Ee(n,this.element),ke(n,this.element),Te(n,this.element),Me(n,this.element),Se(n,this.element),Ce(n,this.element,this.copy),Le(n,this.element,this.copy),n.options.comment.enable&&(this.selectPopover.querySelector("button").onclick=function(){var r,i,o=Lute.NewNodeID(),e=getSelection().getRangeAt(0),a=e.cloneRange(),l=e.extractContents(),s=!1,d=!1;l.childNodes.forEach(function(e,t){var n=!1;3!==e.nodeType&&e.classList.contains("vditor-comment")?e.classList.contains("vditor-comment")&&e.setAttribute("data-cmtids",e.getAttribute("data-cmtids")+" "+o):n=!0,n&&(3!==e.nodeType&&"0"===e.getAttribute("data-block")&&0===t&&0<a.startOffset?(e.innerHTML='<span class="vditor-comment" data-cmtids="'+o+'">'+e.innerHTML+"</span>",r=e):3!==e.nodeType&&"0"===e.getAttribute("data-block")&&t===l.childNodes.length-1&&a.endOffset<a.endContainer.textContent.length?(e.innerHTML='<span class="vditor-comment" data-cmtids="'+o+'">'+e.innerHTML+"</span>",i=e):3!==e.nodeType&&"0"===e.getAttribute("data-block")?(0===t?s=!0:t===l.childNodes.length-1&&(d=!0),e.innerHTML='<span class="vditor-comment" data-cmtids="'+o+'">'+e.innerHTML+"</span>"):((t=document.createElement("span")).classList.add("vditor-comment"),t.setAttribute("data-cmtids",o),e.parentNode.insertBefore(t,e),t.appendChild(e)))});var t=(0,U.F9)(a.startContainer);t&&(r?(t.insertAdjacentHTML("beforeend",r.innerHTML),r.remove()):""===t.textContent.trim().replace(D.g.ZWSP,"")&&s&&t.remove());t=(0,U.F9)(a.endContainer);t&&(i?(t.insertAdjacentHTML("afterbegin",i.innerHTML),i.remove()):""===t.textContent.trim().replace(D.g.ZWSP,"")&&d&&t.remove()),e.insertNode(l),n.options.comment.add(o,e.toString(),c.getComments(n,!0)),ie(n,{enableAddUndoStack:!0,enableHint:!1,enableInput:!1}),c.hideComment()})}var Kr,Gr,n=(Kr=function(e,t){return(Kr=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])})(e,t)},function(e,t){function n(){this.constructor=e}Kr(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)});function zr(e,t){var n=Gr.call(this)||this;n.version=D.H,"string"==typeof e&&(t?t.cache?t.cache.id||(t.cache.id="vditor"+e):t.cache={id:"vditor"+e}:t={cache:{id:"vditor"+e}},e=document.getElementById(e));var r=new qr(t).merge();if(r.i18n)window.VditorI18n=r.i18n,n.init(e,r);else{if(!["en_US","ja_JP","ko_KR","ru_RU","zh_CN","zh_TW"].includes(r.lang))throw new Error("options.lang error, see https://ld246.com/article/1549638745630#options");(0,i.G)(r.cdn+"/js/i18n/"+r.lang+".js","vditorI18nScript").then(function(){n.init(e,r)})}return n}const Fr=(Gr=e.default,n(zr,Gr),zr.prototype.setTheme=function(e,t,n,r){this.vditor.options.theme=e,f(this.vditor),t&&(this.vditor.options.preview.theme.current=t,(0,ee.Z)(t,r||this.vditor.options.preview.theme.path)),n&&(this.vditor.options.preview.hljs.style=n,(0,nn.Y)(n,this.vditor.options.cdn))},zr.prototype.getValue=function(){return a(this.vditor)},zr.prototype.getCurrentMode=function(){return this.vditor.currentMode},zr.prototype.focus=function(){"sv"===this.vditor.currentMode?this.vditor.sv.element.focus():"wysiwyg"===this.vditor.currentMode?this.vditor.wysiwyg.element.focus():"ir"===this.vditor.currentMode&&this.vditor.ir.element.focus()},zr.prototype.blur=function(){"sv"===this.vditor.currentMode?this.vditor.sv.element.blur():"wysiwyg"===this.vditor.currentMode?this.vditor.wysiwyg.element.blur():"ir"===this.vditor.currentMode&&this.vditor.ir.element.blur()},zr.prototype.disabled=function(){L(this.vditor,["subToolbar","hint","popover"]),I(this.vditor.toolbar.elements,D.g.EDIT_TOOLBARS.concat(["undo","redo","fullscreen","edit-mode"])),this.vditor[this.vditor.currentMode].element.setAttribute("contenteditable","false")},zr.prototype.enable=function(){O(this.vditor.toolbar.elements,D.g.EDIT_TOOLBARS.concat(["undo","redo","fullscreen","edit-mode"])),this.vditor.undo.resetIcon(this.vditor),this.vditor[this.vditor.currentMode].element.setAttribute("contenteditable","true")},zr.prototype.getSelection=function(){return"wysiwyg"===this.vditor.currentMode?ze(this.vditor.wysiwyg.element):"sv"===this.vditor.currentMode?ze(this.vditor.sv.element):"ir"===this.vditor.currentMode?ze(this.vditor.ir.element):void 0},zr.prototype.renderPreview=function(e){this.vditor.preview.render(this.vditor,e)},zr.prototype.getCursorPosition=function(){return(0,Z.Ny)(this.vditor[this.vditor.currentMode].element)},zr.prototype.isUploading=function(){return this.vditor.upload.isUploading},zr.prototype.clearCache=function(){localStorage.removeItem(this.vditor.options.cache.id)},zr.prototype.disabledCache=function(){this.vditor.options.cache.enable=!1},zr.prototype.enableCache=function(){if(!this.vditor.options.cache.id)throw new Error("need options.cache.id, see https://ld246.com/article/1549638745630#options");this.vditor.options.cache.enable=!0},zr.prototype.html2md=function(e){return this.vditor.lute.HTML2Md(e)},zr.prototype.exportJSON=function(e){return this.vditor.lute.RenderJSON(e)},zr.prototype.getHTML=function(){return Ot(this.vditor)},zr.prototype.tip=function(e,t){this.vditor.tip.show(e,t)},zr.prototype.setPreviewMode=function(e){Zt(e,this.vditor)},zr.prototype.deleteValue=function(){window.getSelection().isCollapsed||document.execCommand("delete",!1)},zr.prototype.updateValue=function(e){document.execCommand("insertHTML",!1,e)},zr.prototype.insertValue=function(e,t){void 0===t&&(t=!0);var n=(0,Z.zh)(this.vditor);n.collapse(!0);var r=document.createElement("template");r.innerHTML=e,n.insertNode(r.content.cloneNode(!0)),"sv"===this.vditor.currentMode?(this.vditor.sv.preventInput=!0,t&&p(this.vditor)):"wysiwyg"===this.vditor.currentMode?(this.vditor.wysiwyg.preventInput=!0,t&&at(this.vditor,getSelection().getRangeAt(0))):"ir"===this.vditor.currentMode&&(this.vditor.ir.preventInput=!0,t&&J(this.vditor,getSelection().getRangeAt(0),!0))},zr.prototype.setValue=function(e,t){var n=this;void 0===t&&(t=!1),"sv"===this.vditor.currentMode?(this.vditor.sv.element.innerHTML=this.vditor.lute.SpinVditorSVDOM(e),Xe(this.vditor,{enableAddUndoStack:!0,enableHint:!1,enableInput:!1})):"wysiwyg"===this.vditor.currentMode?k(this.vditor,e,{enableAddUndoStack:!0,enableHint:!1,enableInput:!1}):(this.vditor.ir.element.innerHTML=this.vditor.lute.Md2VditorIRDOM(e),this.vditor.ir.element.querySelectorAll(".vditor-ir__preview[data-render='2']").forEach(function(e){F(e,n.vditor)}),Mt(this.vditor,{enableAddUndoStack:!0,enableHint:!1,enableInput:!1})),this.vditor.outline.render(this.vditor),e||(L(this.vditor,["emoji","headings","submenu","hint"]),this.vditor.wysiwyg.popover&&(this.vditor.wysiwyg.popover.style.display="none"),this.clearCache()),t&&this.clearStack()},zr.prototype.clearStack=function(){this.vditor.undo.clearStack(this.vditor),this.vditor.undo.addToUndoStack(this.vditor)},zr.prototype.destroy=function(){this.vditor.element.innerHTML=this.vditor.originalInnerHTML,this.vditor.element.classList.remove("vditor"),this.vditor.element.removeAttribute("style"),document.getElementById("vditorIconScript").remove(),this.clearCache()},zr.prototype.getCommentIds=function(){return"wysiwyg"!==this.vditor.currentMode?[]:this.vditor.wysiwyg.getComments(this.vditor,!0)},zr.prototype.hlCommentIds=function(e){var t;"wysiwyg"===this.vditor.currentMode&&(t=function(t){t.classList.remove("vditor-comment--hover"),e.forEach(function(e){-1<t.getAttribute("data-cmtids").indexOf(e)&&t.classList.add("vditor-comment--hover")})},this.vditor.wysiwyg.element.querySelectorAll(".vditor-comment").forEach(function(e){t(e)}),"none"!==this.vditor.preview.element.style.display&&this.vditor.preview.element.querySelectorAll(".vditor-comment").forEach(function(e){t(e)}))},zr.prototype.unHlCommentIds=function(e){var t;"wysiwyg"===this.vditor.currentMode&&(t=function(t){e.forEach(function(e){-1<t.getAttribute("data-cmtids").indexOf(e)&&t.classList.remove("vditor-comment--hover")})},this.vditor.wysiwyg.element.querySelectorAll(".vditor-comment").forEach(function(e){t(e)}),"none"!==this.vditor.preview.element.style.display&&this.vditor.preview.element.querySelectorAll(".vditor-comment").forEach(function(e){t(e)}))},zr.prototype.removeCommentIds=function(e){var n,i=this;"wysiwyg"===this.vditor.currentMode&&(n=function(e,n){var r=e.getAttribute("data-cmtids").split(" ");r.find(function(e,t){if(e===n)return r.splice(t,1),!0}),0===r.length?(e.outerHTML=e.innerHTML,(0,Z.zh)(i.vditor).collapse(!0)):e.setAttribute("data-cmtids",r.join(" "))},e.forEach(function(t){i.vditor.wysiwyg.element.querySelectorAll(".vditor-comment").forEach(function(e){n(e,t)}),"none"!==i.vditor.preview.element.style.display&&i.vditor.preview.element.querySelectorAll(".vditor-comment").forEach(function(e){n(e,t)})}),ie(this.vditor,{enableAddUndoStack:!0,enableHint:!1,enableInput:!1}))},zr.prototype.init=function(e,t){var n=this;this.vditor={currentMode:t.mode,element:e,hint:new xt(t.hint.extend),lute:void 0,options:t,originalInnerHTML:e.innerHTML,outline:new Rt(window.VditorI18n.outline),tip:new zt},this.vditor.sv=new Kt(this.vditor),this.vditor.undo=new Rr,this.vditor.wysiwyg=new Ur(this.vditor),this.vditor.ir=new Nt(this.vditor),this.vditor.toolbar=new Or(this.vditor),t.resize.enable&&(this.vditor.resize=new Ut(this.vditor)),this.vditor.toolbar.elements.devtools&&(this.vditor.devtools=new r),(t.upload.url||t.upload.handler)&&(this.vditor.upload=new rt),(0,i.G)(t._lutePath||t.cdn+"/js/lute/lute.min.js","vditorLuteScript").then(function(){n.vditor.lute=(0,It.X)({autoSpace:n.vditor.options.preview.markdown.autoSpace,codeBlockPreview:n.vditor.options.preview.markdown.codeBlockPreview,emojiSite:n.vditor.options.hint.emojiPath,emojis:n.vditor.options.hint.emoji,fixTermTypo:n.vditor.options.preview.markdown.fixTermTypo,footnotes:n.vditor.options.preview.markdown.footnotes,headingAnchor:!1,inlineMathDigit:n.vditor.options.preview.math.inlineDigit,linkBase:n.vditor.options.preview.markdown.linkBase,linkPrefix:n.vditor.options.preview.markdown.linkPrefix,listStyle:n.vditor.options.preview.markdown.listStyle,mark:n.vditor.options.preview.markdown.mark,mathBlockPreview:n.vditor.options.preview.markdown.mathBlockPreview,paragraphBeginningSpace:n.vditor.options.preview.markdown.paragraphBeginningSpace,sanitize:n.vditor.options.preview.markdown.sanitize,toc:n.vditor.options.preview.markdown.toc}),n.vditor.preview=new qt(n.vditor),h(n.vditor),t.after&&t.after(),t.icon&&(0,i.J)(t.cdn+"/js/icons/"+t.icon+".js","vditorIconScript")})},zr)})(),Jr.default})()});