<?php
/*
'软件名称：英皇CMS（Yhcms）
'官方网站：http://www.yhcms.cc/
'--------------------------------------------------------
'Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
'遵循Apache2开源协议发布，并提供免费使用。
'--------------------------------------------------------
*/
if (!defined('FCPATH')) exit('No direct script access allowed');
Class Xzfpay{
 
    public function __construct(){
        $this->myconfig = json_decode(_SYSJSON_,1);
        //应用APPID
        $this->appid = $this->myconfig['pay']['xzfpay']['appid'];
        //支付宝公钥
        $this->appkey = $this->myconfig['pay']['xzfpay']['appkey'];
        //支付地址
        $this->payurl = $this->myconfig['pay']['xzfpay']['appurl'].'submit.php';
        //支付域名
        $payurl = $this->myconfig['payurl'] == '' ? $this->myconfig['url'] : $this->myconfig['payurl'];
        //同步地址
        $this->return_url = 'http://'.$payurl.'/index.php/h5pay/return_url';
        //异步地址
        $this->notify_url = 'http://'.$payurl.'/index.php/h5pay/notify_url/xzfpay';
        //实际支付金额
        $this->rmb = 0;
    }

    //h5支付
    public function h5($dingdan,$total_fee,$body='会员在线充值',$type='alipay'){
        //提交支付
        $params = array(
            "pid"   => $this->appid,
            "type"  => $type,
            "out_trade_no" => $dingdan,
            "money" => $total_fee,
            "return_url" => $this->return_url.'/'.$dingdan,
            "notify_url" => $this->notify_url,
            "name" => '商品交易',
        );
        $params['sign'] = $this->sign($params);
        $params['sign_type'] = 'MD5';
		//请求
		$html = '<form id="dopay" action="'.$this->payurl.'" method="post">';
		foreach ($params as $k=>$v) {
			$html.= '<input type="hidden" name="'.$k.'" value="'.$v.'"/>';
		}
		$html .= '<input type="submit" value="立即支付"></form><script>document.getElementById("dopay").submit();</script>';
		exit($html);
    }

    //生成签名
    public function sign($param) {
		ksort($param);
		reset($param);
		$signstr = '';
		foreach($param as $k => $v){
			if($k != "sign" && $k != "sign_type" && $v!=''){
				$signstr .= $k.'='.$v.'&';
			}
		}
		$signstr = substr($signstr,0,-1);
		$signstr .= $this->appkey;
		$sign = md5($signstr);
		return $sign;
    }

    //验证签名
    public function is_sign(){
        //数组转字符串
        $para = isset($_POST['sign']) ? $_POST : $_GET;
        //file_put_contents('./1.txt',json_encode($para));
        $sign = $para['sign'];
        $mysgin = $this->sign($para);
        if($mysgin == $sign) {
            if($para['trade_status'] == 'TRADE_SUCCESS'){
                $this->rmb = $para['rmb'];
                return array('dd'=>$para['out_trade_no'],'trade_no'=>$para['trade_no']);
            }
        }
        return false;
    }
    
    //实际支付金额
    public function get_rmb(){
       return $this->rmb;
    }
}