<?php
require_once '../config/database.php';
require_once '../includes/functions.php';

// 检查管理员是否登录
check_admin_auth();

// 获取统计数据
$stmt = $pdo->query("SELECT COUNT(*) as total_products FROM products WHERE status = 1");
$stats = $stmt->fetch();
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>管理后台 - 发卡系统</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bulma@0.9.4/css/bulma.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free@6.4.0/css/all.min.css">
    <style>
        .menu-label {
            color: #7a7a7a;
            font-size: 0.9em;
            letter-spacing: 0.1em;
            text-transform: uppercase;
        }
        .menu-list a {
            border-radius: 2px;
            color: #4a4a4a;
            display: block;
            padding: 0.5em 0.75em;
        }
        .menu-list a:hover {
            background-color: #f5f5f5;
            color: #363636;
        }
        .menu-list a.is-active {
            background-color: #00d1b2;
            color: #fff;
        }
    </style>
</head>
<body>
    <div class="columns is-gapless" style="min-height: 100vh;">
        <!-- 侧边栏 -->
        <div class="column is-2 has-background-light" style="padding: 1rem;">
            <aside class="menu">
                <p class="menu-label">
                    管理菜单
                </p>
                <ul class="menu-list">
                    <li><a href="index.php" class="is-active">
                        <span class="icon"><i class="fas fa-chart-bar"></i></span>
                        <span>统计概览</span>
                    </a></li>
                    <li><a href="products.php">
                        <span class="icon"><i class="fas fa-box"></i></span>
                        <span>商品管理</span>
                    </a></li>
                    <li><a href="payment.php">
                        <span class="icon"><i class="fas fa-qrcode"></i></span>
                        <span>支付设置</span>
                    </a></li>
                    <li><a href="settings.php">
                        <span class="icon"><i class="fas fa-cog"></i></span>
                        <span>网站设置</span>
                    </a></li>
                    <li><a href="password.php">
                        <span class="icon"><i class="fas fa-key"></i></span>
                        <span>修改密码</span>
                    </a></li>
                    <li><a href="logout.php">
                        <span class="icon"><i class="fas fa-sign-out-alt"></i></span>
                        <span>退出登录</span>
                    </a></li>
                </ul>
            </aside>
        </div>

        <!-- 主要内容区 -->
        <div class="column">
            <section class="section">
                <div class="container">
                    <h1 class="title">
                        统计概览
                        <span class="tag is-primary is-medium">管理后台</span>
                    </h1>
                    
                    <div class="columns is-multiline">
                        <!-- 在售商品统计 -->
                        <div class="column is-one-third">
                            <div class="box">
                                <article class="media">
                                    <div class="media-left">
                                        <span class="icon is-large has-text-primary">
                                            <i class="fas fa-box fa-2x"></i>
                                        </span>
                                    </div>
                                    <div class="media-content">
                                        <div class="content">
                                            <p class="heading">在售商品数量</p>
                                            <p class="title"><?php echo $stats['total_products']; ?></p>
                                        </div>
                                    </div>
                                </article>
                            </div>
                        </div>
                    </div>

                    <!-- 快捷操作区 -->
                    <div class="buttons are-medium mt-5">
                        <a href="products.php?action=add" class="button is-primary">
                            <span class="icon"><i class="fas fa-plus"></i></span>
                            <span>添加商品</span>
                        </a>
                        <a href="settings.php" class="button is-info">
                            <span class="icon"><i class="fas fa-cog"></i></span>
                            <span>网站设置</span>
                        </a>
                    </div>
                </div>
            </section>
        </div>
    </div>
</body>
</html>
