<?php
require_once '../config/database.php';
require_once '../includes/functions.php';

check_admin_auth();

$message = '';
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!isset($_POST['csrf_token']) || !verify_csrf_token($_POST['csrf_token'])) {
        die('CSRF token verification failed');
    }

    $current_password = $_POST['current_password'];
    $new_password = $_POST['new_password'];
    $confirm_password = $_POST['confirm_password'];

    if ($new_password !== $confirm_password) {
        $error = '新密码和确认密码不匹配！';
    } else {
        // 验证当前密码
        $stmt = $pdo->prepare("SELECT password FROM admins WHERE id = ?");
        $stmt->execute([$_SESSION['admin_id']]);
        $admin = $stmt->fetch();

        if (password_verify($current_password, $admin['password'])) {
            // 更新密码
            $hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
            $stmt = $pdo->prepare("UPDATE admins SET password = ? WHERE id = ?");
            $stmt->execute([$hashed_password, $_SESSION['admin_id']]);
            $message = '密码已成功更新！';
        } else {
            $error = '当前密码错误！';
        }
    }
}
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>修改密码 - 发卡系统</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bulma@0.9.4/css/bulma.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free@6.4.0/css/all.min.css">
</head>
<body>
    <div class="columns is-gapless" style="min-height: 100vh;">
        <!-- 侧边栏 -->
        <div class="column is-2 has-background-light" style="padding: 1rem;">
            <aside class="menu">
                <p class="menu-label">管理菜单</p>
                <ul class="menu-list">
                    <li><a href="index.php">
                        <span class="icon"><i class="fas fa-chart-bar"></i></span>
                        <span>统计概览</span>
                    </a></li>
                    <li><a href="products.php">
                        <span class="icon"><i class="fas fa-box"></i></span>
                        <span>商品管理</span>
                    </a></li>
                    <li><a href="payment.php">
                        <span class="icon"><i class="fas fa-qrcode"></i></span>
                        <span>支付设置</span>
                    </a></li>
                    <li><a href="settings.php">
                        <span class="icon"><i class="fas fa-cog"></i></span>
                        <span>网站设置</span>
                    </a></li>
                    <li><a href="password.php" class="is-active">
                        <span class="icon"><i class="fas fa-key"></i></span>
                        <span>修改密码</span>
                    </a></li>
                    <li><a href="logout.php">
                        <span class="icon"><i class="fas fa-sign-out-alt"></i></span>
                        <span>退出登录</span>
                    </a></li>
                </ul>
            </aside>
        </div>

        <!-- 主要内容区 -->
        <div class="column">
            <section class="section">
                <div class="container">
                    <h1 class="title">修改密码</h1>

                    <?php if ($message): ?>
                    <div class="notification is-success">
                        <?php echo htmlspecialchars($message); ?>
                    </div>
                    <?php endif; ?>

                    <?php if ($error): ?>
                    <div class="notification is-danger">
                        <?php echo htmlspecialchars($error); ?>
                    </div>
                    <?php endif; ?>

                    <form method="POST">
                        <input type="hidden" name="csrf_token" value="<?php echo generate_csrf_token(); ?>">

                        <div class="field">
                            <label class="label">当前密码</label>
                            <div class="control">
                                <input class="input" type="password" name="current_password" required>
                            </div>
                        </div>

                        <div class="field">
                            <label class="label">新密码</label>
                            <div class="control">
                                <input class="input" type="password" name="new_password" required>
                            </div>
                        </div>

                        <div class="field">
                            <label class="label">确认新密码</label>
                            <div class="control">
                                <input class="input" type="password" name="confirm_password" required>
                            </div>
                        </div>

                        <div class="field">
                            <div class="control">
                                <button type="submit" class="button is-primary">更新密码</button>
                            </div>
                        </div>
                    </form>
                </div>
            </section>
        </div>
    </div>
</body>
</html>
