<?php
require_once '../config/database.php';
require_once '../includes/functions.php';

check_admin_auth();

$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!isset($_POST['csrf_token']) || !verify_csrf_token($_POST['csrf_token'])) {
        die('CSRF token verification failed');
    }

    $payment_type = $_POST['payment_type'];
    $qrcode_config = '';
    $url_config = '';

    // 处理二维码设置
    if (isset($_FILES['qrcode_image']) && $_FILES['qrcode_image']['error'] === UPLOAD_ERR_OK) {
        $target_dir = "../uploads/";
        if (!file_exists($target_dir)) {
            mkdir($target_dir, 0777, true);
        }

        $file_extension = strtolower(pathinfo($_FILES['qrcode_image']['name'], PATHINFO_EXTENSION));
        $new_filename = 'payment_qrcode_' . time() . '.' . $file_extension;
        $target_file = $target_dir . $new_filename;

        if (move_uploaded_file($_FILES['qrcode_image']['tmp_name'], $target_file)) {
            $qrcode_config = $new_filename;
        }
    } elseif (isset($_POST['current_qrcode']) && !empty($_POST['current_qrcode'])) {
        $qrcode_config = $_POST['current_qrcode'];
    }

    // 处理URL设置
    if (isset($_POST['payment_url'])) {
        $url_config = sanitize_input($_POST['payment_url']);
    }

    // 保存所有设置
    $stmt = $pdo->prepare("UPDATE settings SET payment_type = ?, qrcode_config = ?, url_config = ?");
    $stmt->execute([$payment_type, $qrcode_config, $url_config]);
    $message = '支付设置已更新！';
}

// 获取当前设置
$stmt = $pdo->query("SELECT payment_type, qrcode_config, url_config FROM settings LIMIT 1");
$settings = $stmt->fetch();
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>支付设置 - 发卡系统</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bulma@0.9.4/css/bulma.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free@6.4.0/css/all.min.css">
    <style>
        .payment-section {
            margin-top: 1rem;
            padding: 1rem;
            border: 1px solid #dbdbdb;
            border-radius: 4px;
        }
        .payment-section:not(:last-child) {
            margin-bottom: 1rem;
        }
        .preview-image {
            max-width: 200px;
            margin: 1rem 0;
        }
    </style>
</head>
<body>
    <div class="columns is-gapless" style="min-height: 100vh;">
        <!-- 侧边栏 -->
        <div class="column is-2 has-background-light" style="padding: 1rem;">
            <aside class="menu">
                <p class="menu-label">管理菜单</p>
                <ul class="menu-list">
                    <li><a href="index.php">
                        <span class="icon"><i class="fas fa-chart-bar"></i></span>
                        <span>统计概览</span>
                    </a></li>
                    <li><a href="products.php">
                        <span class="icon"><i class="fas fa-box"></i></span>
                        <span>商品管理</span>
                    </a></li>
                    <li><a href="payment.php" class="is-active">
                        <span class="icon"><i class="fas fa-qrcode"></i></span>
                        <span>支付设置</span>
                    </a></li>
                    <li><a href="settings.php">
                        <span class="icon"><i class="fas fa-cog"></i></span>
                        <span>网站设置</span>
                    </a></li>
                    <li><a href="password.php">
                        <span class="icon"><i class="fas fa-key"></i></span>
                        <span>修改密码</span>
                    </a></li>
                    <li><a href="logout.php">
                        <span class="icon"><i class="fas fa-sign-out-alt"></i></span>
                        <span>退出登录</span>
                    </a></li>
                </ul>
            </aside>
        </div>

        <!-- 主要内容区 -->
        <div class="column">
            <section class="section">
                <div class="container">
                    <h1 class="title">支付设置</h1>

                    <?php if ($message): ?>
                    <div class="notification is-success">
                        <?php echo htmlspecialchars($message); ?>
                    </div>
                    <?php endif; ?>

                    <form method="POST" enctype="multipart/form-data">
                        <input type="hidden" name="csrf_token" value="<?php echo generate_csrf_token(); ?>">

                        <div class="field">
                            <label class="label">当前支付方式</label>
                            <div class="control">
                                <div class="select">
                                    <select name="payment_type" id="payment_type">
                                        <option value="qrcode" <?php echo $settings['payment_type'] === 'qrcode' ? 'selected' : ''; ?>>
                                            收款二维码
                                        </option>
                                        <option value="url" <?php echo $settings['payment_type'] === 'url' ? 'selected' : ''; ?>>
                                            跳转链接
                                        </option>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <!-- 二维码设置部分 -->
                        <div id="qrcode_section" class="payment-section" style="display: <?php echo $settings['payment_type'] === 'qrcode' ? 'block' : 'none'; ?>">
                            <h2 class="subtitle">收款二维码设置</h2>
                            <?php if (!empty($settings['qrcode_config'])): ?>
                            <div class="field">
                                <label class="label">当前二维码</label>
                                <div class="control">
                                    <img src="../uploads/<?php echo htmlspecialchars($settings['qrcode_config']); ?>" 
                                         alt="当前收款二维码" class="preview-image">
                                    <input type="hidden" name="current_qrcode" value="<?php echo htmlspecialchars($settings['qrcode_config']); ?>">
                                </div>
                            </div>
                            <?php endif; ?>
                            <div class="field">
                                <label class="label">上传新二维码</label>
                                <div class="control">
                                    <input type="file" name="qrcode_image" accept="image/*" class="input">
                                </div>
                                <p class="help">上传新的二维码图片将替换当前的二维码</p>
                            </div>
                        </div>

                        <!-- URL设置部分 -->
                        <div id="url_section" class="payment-section" style="display: <?php echo $settings['payment_type'] === 'url' ? 'block' : 'none'; ?>">
                            <h2 class="subtitle">支付链接设置</h2>
                            <div class="field">
                                <label class="label">支付链接</label>
                                <div class="control">
                                    <input type="url" name="payment_url" class="input" 
                                           value="<?php echo htmlspecialchars($settings['url_config']); ?>"
                                           placeholder="https://example.com/pay">
                                </div>
                                <p class="help">输入完整的支付链接地址</p>
                            </div>
                        </div>

                        <div class="field">
                            <div class="control">
                                <button type="submit" class="button is-primary">保存设置</button>
                            </div>
                        </div>
                    </form>
                </div>
            </section>
        </div>
    </div>

    <script>
        document.getElementById('payment_type').addEventListener('change', function() {
            const qrcodeSection = document.getElementById('qrcode_section');
            const urlSection = document.getElementById('url_section');
            
            if (this.value === 'qrcode') {
                qrcodeSection.style.display = 'block';
                urlSection.style.display = 'none';
            } else {
                qrcodeSection.style.display = 'none';
                urlSection.style.display = 'block';
            }
        });
    </script>
</body>
</html>
