<?php
require_once '../config/database.php';
require_once '../includes/functions.php';

check_admin_auth();

$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!isset($_POST['csrf_token']) || !verify_csrf_token($_POST['csrf_token'])) {
        die('CSRF token verification failed');
    }

    $site_title = sanitize_input($_POST['site_title']);
    $site_announcement = sanitize_input($_POST['site_announcement']);
    $contact_info = sanitize_input($_POST['contact_info']);
    $footer_text = sanitize_input($_POST['footer_text']);

    $stmt = $pdo->prepare("UPDATE settings SET site_title = ?, site_announcement = ?, contact_info = ?, footer_text = ?");
    $stmt->execute([$site_title, $site_announcement, $contact_info, $footer_text]);
    $message = '网站设置已更新！';
}

// 获取当前设置
$stmt = $pdo->query("SELECT site_title, site_announcement, contact_info, footer_text FROM settings LIMIT 1");
$settings = $stmt->fetch();
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>网站设置 - 发卡系统</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bulma@0.9.4/css/bulma.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free@6.4.0/css/all.min.css">
</head>
<body>
    <div class="columns is-gapless" style="min-height: 100vh;">
        <!-- 侧边栏 -->
        <div class="column is-2 has-background-light" style="padding: 1rem;">
            <aside class="menu">
                <p class="menu-label">管理菜单</p>
                <ul class="menu-list">
                    <li><a href="index.php">
                        <span class="icon"><i class="fas fa-chart-bar"></i></span>
                        <span>统计概览</span>
                    </a></li>
                    <li><a href="products.php">
                        <span class="icon"><i class="fas fa-box"></i></span>
                        <span>商品管理</span>
                    </a></li>
                    <li><a href="payment.php">
                        <span class="icon"><i class="fas fa-qrcode"></i></span>
                        <span>支付设置</span>
                    </a></li>
                    <li><a href="settings.php" class="is-active">
                        <span class="icon"><i class="fas fa-cog"></i></span>
                        <span>网站设置</span>
                    </a></li>
                    <li><a href="password.php">
                        <span class="icon"><i class="fas fa-key"></i></span>
                        <span>修改密码</span>
                    </a></li>
                    <li><a href="logout.php">
                        <span class="icon"><i class="fas fa-sign-out-alt"></i></span>
                        <span>退出登录</span>
                    </a></li>
                </ul>
            </aside>
        </div>

        <!-- 主要内容区 -->
        <div class="column">
            <section class="section">
                <div class="container">
                    <h1 class="title">网站设置</h1>

                    <?php if ($message): ?>
                    <div class="notification is-success">
                        <?php echo htmlspecialchars($message); ?>
                    </div>
                    <?php endif; ?>

                    <form method="POST">
                        <input type="hidden" name="csrf_token" value="<?php echo generate_csrf_token(); ?>">

                        <div class="field">
                            <label class="label">网站标题</label>
                            <div class="control">
                                <input class="input" type="text" name="site_title" required
                                       value="<?php echo htmlspecialchars($settings['site_title']); ?>">
                            </div>
                        </div>

                        <div class="field">
                            <label class="label">网站公告</label>
                            <div class="control">
                                <textarea class="textarea" name="site_announcement" rows="3"><?php echo htmlspecialchars($settings['site_announcement']); ?></textarea>
                            </div>
                        </div>

                        <div class="field">
                            <label class="label">联系方式</label>
                            <div class="control">
                                <textarea class="textarea" name="contact_info" rows="2"><?php echo htmlspecialchars($settings['contact_info']); ?></textarea>
                            </div>
                        </div>

                        <div class="field">
                            <label class="label">页脚文本</label>
                            <div class="control">
                                <textarea class="textarea" name="footer_text" rows="2"><?php echo htmlspecialchars($settings['footer_text']); ?></textarea>
                            </div>
                        </div>

                        <div class="field">
                            <div class="control">
                                <button type="submit" class="button is-primary">保存设置</button>
                            </div>
                        </div>
                    </form>
                </div>
            </section>
        </div>
    </div>
</body>
</html>
