<?php
require_once 'config/database.php';
require_once 'includes/functions.php';

header('Content-Type: application/json');

if (!isset($_GET['product_id'])) {
    die(json_encode(['error' => 'Missing product ID']));
}

$product_id = intval($_GET['product_id']);

// 获取商品信息
$stmt = $pdo->prepare("SELECT * FROM products WHERE id = ? AND status = 1");
$stmt->execute([$product_id]);
$product = $stmt->fetch();

if (!$product) {
    die(json_encode(['error' => 'Product not found']));
}

// 获取支付设置
$stmt = $pdo->query("SELECT payment_type, qrcode_config, url_config FROM settings LIMIT 1");
$settings = $stmt->fetch();

if (!$settings) {
    die(json_encode(['error' => '支付设置未配置']));
}

$response = [
    'type' => $settings['payment_type'],
];

if ($settings['payment_type'] === 'qrcode') {
    if (empty($settings['qrcode_config'])) {
        die(json_encode(['error' => '收款二维码未设置']));
    }
    $qrcode_path = 'uploads/' . $settings['qrcode_config'];
    if (!file_exists($qrcode_path)) {
        die(json_encode(['error' => '收款二维码文件不存在']));
    }
    $response['qrcode'] = $qrcode_path;
} else {
    if (empty($settings['url_config'])) {
        die(json_encode(['error' => '支付链接未设置']));
    }
    $response['url'] = $settings['url_config'];
}

echo json_encode($response);
?>
