<?php
require_once 'config/database.php';

// 获取网站设置
$stmt = $pdo->query("SELECT * FROM settings LIMIT 1");
$settings = $stmt->fetch();

// 获取商品列表
$stmt = $pdo->query("SELECT * FROM products WHERE status = 1 ORDER BY id DESC");
$products = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html>
<head>
    <title><?php echo htmlspecialchars($settings['site_title']); ?></title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bulma@0.9.3/css/bulma.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <style>
        body {
            display: flex;
            min-height: 100vh;
            flex-direction: column;
        }
        
        .main-content {
            flex: 1;
        }
        
        .footer {
            padding: 1.5rem;
            text-align: center;
        }

        .hero.is-primary .hero-body {
            padding: 0.5rem 1.5rem;
        }

        .section {
            padding-top: 0.3rem;  
            padding-bottom: 1rem;
        }

        .announcement-section {
            max-width: 600px;  
            margin: 0 auto;
            padding: 0.5rem;  
            margin-top: 0.2rem;  
            margin-bottom: 1.5rem;  
        }

        .announcement-card {
            background: linear-gradient(135deg, #00d1b2 0%, #00c4a7 100%);
            border-radius: 8px;
            padding: 0.8rem;  
            color: white;
            box-shadow: 0 2px 10px rgba(0, 209, 178, 0.2);
            text-align: center;
        }

        .announcement-card .title {
            color: white;
            font-size: 1rem;
            margin-bottom: 0.5rem;
        }

        .announcement-card .content {
            color: white;
            font-size: 0.9rem;
        }

        .announcement-icon {
            margin-right: 0.5rem;
        }

        .subtitle {
            margin-bottom: 1rem;  
            font-size: 1.1rem;  
        }

        .card {
            height: 100%;
            margin: 0 auto;
            transition: all 0.3s ease;
            border: none;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
        }

        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
        }

        .button.is-primary {
            transition: all 0.3s ease;
            background: #00d1b2;
            border: none;
        }

        .button.is-primary:hover {
            transform: scale(1.05);
            background: #00c4a7;
            box-shadow: 0 4px 10px rgba(0, 209, 178, 0.3);
        }

        .button.is-primary:active {
            transform: scale(0.95);
        }

        .card-content {
            padding: 0.8rem;
        }

        .card-image {
            padding: 0;
        }

        .image.is-square {
            height: 150px;
        }

        .content {
            font-size: 0.85rem;
        }

        .button.is-fullwidth {
            padding: 0.5rem;
        }

        .columns {
            margin-left: -0.2rem !important;  
            margin-right: -0.2rem !important;  
        }

        .column {
            padding-left: 0.2rem !important;  
            padding-right: 0.2rem !important;  
        }

        .columns.is-multiline {
            margin-top: -0.75rem !important;
            margin-bottom: -0.75rem !important;
        }

        .column.is-one-fifth {
            padding: 0.2rem !important;
        }

        .title.is-5 {
            font-size: 0.9rem;
            margin-bottom: 0.3rem;
        }

        .subtitle.is-6 {
            font-size: 0.8rem;
            margin-bottom: 0.3rem;
        }
    </style>
</head>
<body>
    <section class="hero is-primary">
        <div class="hero-body">
            <div class="container">
                <h1 class="title has-text-centered"><?php echo htmlspecialchars($settings['site_title']); ?></h1>
            </div>
        </div>
    </section>

    <div class="main-content">
        <section class="section">
            <div class="container">
                <div class="announcement-section">
                    <div class="announcement-card">
                        <div class="title">网站公告</div>
                        <div class="content"><?php echo nl2br(htmlspecialchars($settings['site_announcement'])); ?></div>
                    </div>
                </div>
                <div class="columns is-multiline">
                    <?php foreach ($products as $product): ?>
                    <div class="column is-one-fifth" style="margin-bottom: 15px;">
                        <div class="card">
                            <?php if ($product['image']): ?>
                            <div class="card-image">
                                <figure class="image is-square">
                                    <img src="uploads/products/<?php echo htmlspecialchars($product['image']); ?>" alt="<?php echo htmlspecialchars($product['name']); ?>" style="object-fit: cover;">
                                </figure>
                            </div>
                            <?php endif; ?>
                            <div class="card-content">
                                <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 0.5rem;">
                                    <span style="font-size: 1.1rem;"><?php echo htmlspecialchars($product['name']); ?></span>
                                    <span style="color: #ff3860; font-weight: bold; font-size: 1.3rem;">￥<?php echo number_format($product['price'], 2); ?></span>
                                </div>

                                <div class="content">
                                    <?php echo nl2br(htmlspecialchars($product['description'])); ?>
                                </div>
                                
                                <button class="button is-primary is-fullwidth buy-button"
                                        data-id="<?php echo $product['id']; ?>"
                                        data-name="<?php echo htmlspecialchars($product['name']); ?>"
                                        data-price="<?php echo $product['price']; ?>">
                                    立即购买
                                </button>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>
    </div>

    <footer class="footer">
        <div class="content has-text-centered">
            <p>联系方式：<?php echo htmlspecialchars($settings['contact_info']); ?></p>
            <p><?php echo htmlspecialchars($settings['footer_text']); ?></p>
        </div>
    </footer>

    <!-- 购买模态框 -->
    <div class="modal" id="buyModal">
        <div class="modal-background"></div>
        <div class="modal-card">
            <header class="modal-card-head">
                <p class="modal-card-title">确认购买</p>
                <button class="delete" aria-label="close"></button>
            </header>
            <section class="modal-card-body">
                <div class="content has-text-centered">
                    <h3 id="modalProductName"></h3>
                    <p>价格: ￥<span id="modalProductPrice"></span></p>
                    <div id="paymentQrCode" class="has-text-centered">
                        <!-- 这里将显示支付二维码或支付链接 -->
                    </div>
                </div>
            </section>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', () => {
            // 获取所有购买按钮
            const buyButtons = document.querySelectorAll('.buy-button');
            const modal = document.querySelector('#buyModal');
            const modalBg = modal.querySelector('.modal-background');
            const modalClose = modal.querySelector('.delete');

            // 关闭模态框的函数
            const closeModal = () => {
                modal.classList.remove('is-active');
                // 清空支付信息
                document.getElementById('paymentQrCode').innerHTML = '';
            };

            // 显示错误信息的函数
            const showError = (message) => {
                const paymentDiv = document.getElementById('paymentQrCode');
                paymentDiv.innerHTML = `
                    <div class="notification is-danger">
                        <p>${message}</p>
                        <button class="button is-info mt-3" onclick="closeModal()">确定</button>
                    </div>
                `;
            };

            // 为每个购买按钮添加点击事件
            buyButtons.forEach(button => {
                button.addEventListener('click', () => {
                    const productId = button.dataset.id;
                    const productName = button.dataset.name;
                    const productPrice = button.dataset.price;

                    // 更新模态框内容
                    document.getElementById('modalProductName').textContent = productName;
                    document.getElementById('modalProductPrice').textContent = productPrice;
                    document.getElementById('paymentQrCode').innerHTML = '<div class="has-text-centered"><div class="button is-loading is-large">加载中</div></div>';
                    modal.classList.add('is-active');

                    // 获取支付信息
                    fetch(`get_payment.php?product_id=${productId}`)
                        .then(response => response.json())
                        .then(data => {
                            if (data.error) {
                                showError(data.error);
                                return;
                            }
                            const paymentDiv = document.getElementById('paymentQrCode');
                            if (data.type === 'qrcode') {
                                paymentDiv.innerHTML = `
                                    <div class="box">
                                        <p class="subtitle is-6 mb-2">添加二维码购买源码</p>
                                        <img src="${data.qrcode}" alt="支付二维码" style="max-width: 200px;">
                                    </div>
                                `;
                            } else {
                                paymentDiv.innerHTML = `
                                    <div class="box">
                                        <p class="subtitle is-6 mb-2">点击下方按钮跳转到支付页面</p>
                                        <a href="${data.url}" class="button is-primary is-large" target="_blank">
                                            <span class="icon">
                                                <i class="fas fa-external-link-alt"></i>
                                            </span>
                                            <span>跳转到支付页面</span>
                                        </a>
                                    </div>
                                `;
                            }
                        })
                        .catch(error => {
                            console.error('Error:', error);
                            showError('获取支付信息失败，请稍后重试');
                        });
                });
            });

            // 添加关闭模态框的事件监听器
            modalBg.addEventListener('click', closeModal);
            modalClose.addEventListener('click', closeModal);
        });
    </script>
</body>
</html>
