-- ----------------------------------------
-- EyouCms MySQL Data Transfer 
-- 
-- Server         : 127.0.0.1_3306
-- Server Version : 5.7.26
-- Host           : 127.0.0.1:3306
-- Database       : e16
-- 
-- Part : #1
-- Version : #v1.6.2
-- Date : 2023-05-19 17:15:25
-- -----------------------------------------

SET FOREIGN_KEY_CHECKS = 0;


-- -----------------------------
-- Table structure for `ey_ad`
-- -----------------------------
DROP TABLE IF EXISTS `ey_ad`;
CREATE TABLE `ey_ad` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '广告id',
  `pid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '广告位置ID',
  `media_type` tinyint(1) DEFAULT '0' COMMENT '广告类型',
  `title` varchar(60) DEFAULT '' COMMENT '广告名称',
  `links` varchar(255) DEFAULT '' COMMENT '广告链接',
  `litpic` varchar(255) DEFAULT '' COMMENT '图片地址',
  `start_time` int(11) DEFAULT '0' COMMENT '投放时间',
  `end_time` int(11) DEFAULT '0' COMMENT '结束时间',
  `intro` text COMMENT '描述',
  `link_man` varchar(60) DEFAULT '' COMMENT '添加人',
  `link_email` varchar(60) DEFAULT '' COMMENT '添加人邮箱',
  `link_phone` varchar(60) DEFAULT '' COMMENT '添加人联系电话',
  `click` int(11) DEFAULT '0' COMMENT '点击量',
  `bgcolor` varchar(30) DEFAULT '' COMMENT '背景颜色',
  `status` tinyint(1) unsigned DEFAULT '1' COMMENT '1=显示，0=屏蔽',
  `sort_order` int(11) DEFAULT '0' COMMENT '排序',
  `target` varchar(50) DEFAULT '' COMMENT '是否开启浏览器新窗口',
  `admin_id` int(10) DEFAULT '0' COMMENT '管理员ID',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '伪删除，1=是，0=否',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '多语言',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `position_id` (`pid`) USING BTREE,
  KEY `status` (`status`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='广告表';

-- -----------------------------
-- Records of `ey_ad`
-- -----------------------------
INSERT INTO `ey_ad` VALUES ('1', '1', '1', '', '', '/eyou/uploads/allimg/200314/1-200314215A30-L.jpg', '0', '0', '', '', '', '', '0', '', '1', '1', '0', '1', '0', 'cn', '1641349969', '1641349969');
INSERT INTO `ey_ad` VALUES ('2', '1', '1', '', '', '/eyou/uploads/allimg/200314/1-200314215H10-L.png', '0', '0', '', '', '', '', '0', '', '1', '2', '0', '1', '0', 'cn', '1641349969', '1641349969');

-- -----------------------------
-- Table structure for `ey_ad_position`
-- -----------------------------
DROP TABLE IF EXISTS `ey_ad_position`;
CREATE TABLE `ey_ad_position` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(60) NOT NULL DEFAULT '' COMMENT '广告位置名称',
  `type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '广告展示类型，1图片类型，2媒体类型，3HTML代码',
  `width` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '广告位宽度',
  `height` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '广告位高度',
  `intro` text NOT NULL COMMENT '广告描述',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '0关闭1开启',
  `lang` varchar(50) NOT NULL DEFAULT 'cn' COMMENT '多语言',
  `admin_id` int(10) NOT NULL DEFAULT '0' COMMENT '管理员ID',
  `is_del` tinyint(1) NOT NULL DEFAULT '0' COMMENT '伪删除，1=是，0=否',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='广告位置表';

-- -----------------------------
-- Records of `ey_ad_position`
-- -----------------------------
INSERT INTO `ey_ad_position` VALUES ('1', 'PC端首页幻灯', '1', '0', '0', '', '1', 'cn', '1', '0', '1641349969', '1641349969');

-- -----------------------------
-- Table structure for `ey_addon17_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_addon17_content`;
CREATE TABLE `ey_addon17_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `logo` varchar(251) NOT NULL DEFAULT '' COMMENT 'LOGO图',
  `gsmc` varchar(251) NOT NULL DEFAULT '' COMMENT '公司名称',
  `qyjs` varchar(251) NOT NULL DEFAULT '' COMMENT '签约券商',
  `gqdm` varchar(251) NOT NULL DEFAULT '' COMMENT '股权代码',
  `sshy` enum('信息通讯','移动互联','消费服务','节能环保','文化传媒','生物制药','金融服务','工业制造','医疗器械','能源材料','军工科技','农林牧渔','其他类别') DEFAULT '信息通讯' COMMENT '所属行业',
  `szdq` varchar(251) NOT NULL DEFAULT '' COMMENT '所在地区',
  `gsfr` varchar(251) NOT NULL DEFAULT '' COMMENT '公司法人',
  `zczj` varchar(251) NOT NULL DEFAULT '' COMMENT '注册资金',
  `gsjs` longtext COMMENT '公司介绍',
  `xmjs` longtext COMMENT '项目介绍',
  `hxjzl` longtext COMMENT '核心竞争力',
  `qytd` longtext COMMENT '企业团队',
  `zycp` longtext COMMENT '主营产品',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COMMENT='附加表';

-- -----------------------------
-- Records of `ey_addon17_content`
-- -----------------------------
INSERT INTO `ey_addon17_content` VALUES ('1', '10', '1642401471', '1642401471', '/uploads/171116/1-1G116091J2M7.jpg', '双龙集团防爆电机盐城股份有限公司', '大通证券', '835133', '工业制造', '江苏', '施连忠', '5100万', '&amp;nbsp;华通线缆集团创建于一九九三年。国内厂区占地面积22万多平方米，进口国产生产设备420多台套，检验、检测设线电缆出口创汇十强企业&amp;rdquo; 、 &amp;ldquo;中国电线电缆行业最具发展潜力20强企业&amp;rdquo;、&amp;ldquo;中国电线电缆行业用户满意企业&amp;rdquo;、&amp;ldquo;中国电线电缆行业科技创新20强企业&amp;rdquo;、&amp;ldquo;电线电缆综合实力200强企业&amp;rdquo;、&amp;ldquo;河北省高新技术企业&amp;rdquo;、&amp;ldquo;河北省质量信得过企业&amp;rdquo;、&amp;ldquo;河北省诚信企业&amp;rdquo;、&amp;ldquo;河北省创新型企业&amp;rdquo;、&amp;ldquo;守合同重信用企业&amp;rdquo;等荣誉称号。企业全面贯彻GB/T 19001-2008/ISO 9001:2008质量管理体系、GB/T 24001-2004/ISO 14001：2004环境管理体系和GB/T 28001-201/OHSAS18001：2007职业健康安全管理体系，实现了与国际先进管理水平的接轨。公司主导产品有：35kV及以下交联聚乙烯绝缘电力电缆、聚氯乙烯绝缘电力电缆、矿用电缆、通用橡套软电缆、潜油泵电缆、机车车辆电缆、船用电缆、核电站电缆、预制分支电缆、架空电缆、控制电缆、特种电缆、电机绕组引接软线、铝绞线及钢芯铝绞线等15大系列上万多种规格。产品广泛应用于电力、煤炭、冶金、石油化工、铁路、国防、建筑、航天、交通等行业及国家重点工程。产品畅销全国各地，并出口到美国、荷兰、意大利、俄罗斯、英国、澳大利亚、新西兰、埃塞俄比亚、加纳、刚果、中东、东南亚等国家和地区。在国内外市场具有广泛的影响和良好的声誉。&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; 公司全体员工坚持 &amp;ldquo;质量重于生命，责任重于泰山&amp;rdquo;的企业精神，以&amp;ldquo;质量优良、价格合理、交货及时、服务周到&amp;rdquo;的华通形象，热忱欢迎新老客户惠顾。', '&amp;nbsp; &amp;nbsp; 所属行业：机械设备 &amp;mdash; 电气设备&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; 主营业务：电线电缆制造、销售；化工产品（易燃易爆危险化学品除外）、橡胶制品、五金、电子产品批发、零售；货物进出口、技术进出口（国家法律行政法规禁止项目除外；国家法律行政法规限制的项目取得许可证后方可经营）；制管及销售；普通货运***（依法须经批准的项目，经相关部门批准后方可开展经营活动）&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; 注册资金：34955.21万人民币', '&lt;div style=&quot;text-align: center;&quot;&gt;\r\n	&lt;img alt=&quot;&quot; src=&quot;/uploads/allimg/171115/1-1G1151K601219.jpg&quot; /&gt;&lt;/div&gt;\r\n', '&lt;div style=&quot;text-align: center;&quot;&gt;\r\n	&lt;img alt=&quot;&quot; src=&quot;/uploads/171115/1-1G1151K61a21.jpg&quot; /&gt;&lt;/div&gt;\r\n', '&lt;div style=&quot;text-align: center;&quot;&gt;\r\n	&lt;img alt=&quot;&quot; src=&quot;/uploads/allimg/171115/1-1G1151K63a58.jpg&quot; /&gt;&lt;/div&gt;\r\n');
INSERT INTO `ey_addon17_content` VALUES ('2', '11', '1642401471', '1642401471', '/uploads/171116/1-1G116142330J6.jpg', '丰荣航空科技股份有限公司', '平安证券', '831926', '军工科技', '北京', '韩铭', '6540万', '&amp;nbsp; 丰荣航空科技股份有限公司成立于2000年9月，位于首都机场临空经济核心区，是国家级高新技术企业。主要从事飞机零部件维修、航空支援和通用航空服务。&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; 公司获得CAAC批准维修项目1300多项，涵盖ATA21章至ATA80章各类维修项目，机型覆盖目前国内运行的波音系列、空客系列、ERJ等多种机型。&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; 公司不断完善&amp;ldquo;一点需求，多点支撑&amp;rdquo;的服务网络，致力于为客户提供航空器部件、通用飞机机体、通用发动机维修，航空器材销售、租赁，航空零部件制造及通用航空运营的全方位服务。', '&lt;div style=&quot;text-align: center;&quot;&gt;\r\n	&lt;img alt=&quot;&quot; src=&quot;/uploads/allimg/171116/1-1G116142553209.jpg&quot; /&gt;&lt;/div&gt;\r\n', '&lt;div style=&quot;text-align: center;&quot;&gt;\r\n	&lt;img alt=&quot;&quot; src=&quot;/uploads/allimg/171116/1-1G116142G5452.jpg&quot; /&gt;&lt;/div&gt;\r\n', '&lt;div style=&quot;text-align: center;&quot;&gt;\r\n	&lt;img alt=&quot;&quot; src=&quot;/uploads/allimg/171116/1-1G116142R2E1.jpg&quot; /&gt;&lt;/div&gt;\r\n', '&lt;div style=&quot;text-align: center;&quot;&gt;\r\n	&lt;img alt=&quot;&quot; src=&quot;/uploads/allimg/171116/1-1G116142U9553.jpg&quot; /&gt;&lt;/div&gt;\r\n');
INSERT INTO `ey_addon17_content` VALUES ('3', '12', '1642401471', '1642401471', '/uploads/171116/1-1G11614301S22.jpg', '众信超纤科技股份有限公司', '中泰证券', '839275', '信息通讯', '福建', '徐林英', '4284万', '众信超纤科技股份有限公司，公司简称：众信科技，股票代码：839275，公司成立于2010年3月主营超纤皮革的研发和销售。&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; 众信科技于2016年9月26日正式在全国中小企业股份转让系统挂牌公开转让。&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; 众信超纤科技股份有限公司致力于第四代超纤产品的研发，超纤作为一种已成熟应用的新材料，在国际社会各领域中得到广泛的认可。众信科技坚持品质第一，创新第二，时刻把握市场需求，不断创新持续推出超纤新产品，引领潮流。公司目前以晋江、石狮鞋服产业为核心客户群体，并逐渐渗透到沙发、箱包、汽车内饰等真皮、合成革等应用领域。公司一方面针对市场需求加快新产品研发速度，一方面充分发挥公司的资源整合能力，以自身的专业水平，挑选优质的生产厂家，帮助客户把关产品质量和推荐流行趋势新品，打造一流的超纤资源整合平台，为客户提供全方位的供应链解决方案。', '&lt;div style=&quot;text-align: center;&quot;&gt;\r\n	&lt;img alt=&quot;&quot; src=&quot;/uploads/allimg/171116/1-1G1161432192I.jpg&quot; /&gt;&lt;/div&gt;\r\n', '&lt;div style=&quot;text-align: center;&quot;&gt;\r\n	&lt;img alt=&quot;&quot; src=&quot;/uploads/allimg/171116/1-1G1161433121R.jpg&quot; /&gt;&lt;/div&gt;\r\n', '&lt;div style=&quot;text-align: center;&quot;&gt;\r\n	&lt;img alt=&quot;&quot; src=&quot;/uploads/allimg/171116/1-1G116143349252.jpg&quot; /&gt;&lt;/div&gt;\r\n', '&lt;div style=&quot;text-align: center;&quot;&gt;\r\n	&lt;img alt=&quot;&quot; src=&quot;/uploads/allimg/171116/1-1G116143414234.jpg&quot; /&gt;&lt;/div&gt;\r\n');
INSERT INTO `ey_addon17_content` VALUES ('4', '13', '1642401471', '1642401471', '/uploads/171116/1-1G116143R01A.jpg', '中盛光电能源股份有限公司', '**证券', '暂无', '工业制造', '江苏', '王兴华', '35288万', '&amp;nbsp; 中盛新能源致力于通过在全球范围内提供绿色智能化能源解决方案满足顾客日益丰富多样的能源需求。依托在可再生能源领域积累的专业知识、丰富经验和持续的创新活动，中盛新能源为全球数以吉瓦的光伏系统提供了性能卓越的系统设备，为全球数百兆瓦的中盛光伏电站定制并成功实施了一站式智能化解决方案。通过整合光伏全产业链各环节的竞争优势，中盛新能源向全球客户提供可靠、经济的光伏系统设备，以及贯穿光伏电站全生命周期的电站开发、工程设计、融资、电站建设及运营维护服务。&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; 十年磨一剑，中盛新能源始终专注于提供可靠、卓越、可持续的智能化能源解决方案，并成长为聚焦光伏下游业务的行业领先企业。迈向卓越，是中盛新能源不变的追求。', '&amp;nbsp; 所属行业：电气机械和器材制造业&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; 主营业务：太阳能发电系统的设计与研发；光伏运行和维护平台的设计与研发；研发成果的转让与销售；光伏系统相关软件的设计、研发与销售；光伏系统相关技术咨询、培训及服务；太阳能电站工程承包，太阳能电站工程设计、安装、调试；光伏产品的采购、批发、佣金代理（拍卖除外）、自营和代理各类商品及技术的进出口业务（国家限定企业经营或禁止的商品和技术除外）；售电业务。（依法须经批准的项目，经相关部门批准后方可开展经营活动）&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; 注册资金：500万元人民币', '&lt;div style=&quot;text-align: center;&quot;&gt;\r\n	&lt;img alt=&quot;&quot; src=&quot;/uploads/allimg/171116/14414R410-0.jpg&quot;/&gt;&lt;/div&gt;\r\n', '&lt;div style=&quot;text-align: center;&quot;&gt;\r\n	&lt;img alt=&quot;&quot; src=&quot;/uploads/allimg/171116/14414R219-0.jpg&quot; /&gt;&lt;/div&gt;\r\n', '&lt;div style=&quot;text-align: center;&quot;&gt;\r\n	&lt;img alt=&quot;&quot; src=&quot;/uploads/allimg/171116/144149B35-0.jpg&quot;/&gt;&lt;/div&gt;\r\n');
INSERT INTO `ey_addon17_content` VALUES ('5', '14', '1642401471', '1642401471', '/uploads/171116/1-1G1161446463c.jpg', '掌游天下信息技术股份有限公司', '中信建投证券', '836014', '文化传媒', '北京', '何鹏', '10527万', '&amp;nbsp;掌游天下信息技术股份有限公司创立于2010年，专注于手机游戏发行、研发领域和自有流量移动广告。目前主营业务收入广告占比70%，游戏占比30%；公司秉承&amp;ldquo;全球一体化，全领域发展&amp;rdquo;的理念，致力于为中小开发者提供专业的发行及运营服务，为海内外的广告运营商服务。&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; 掌游天下依托强有力的发行渠道及独特的运营方式，产品覆盖海内外30多个国家和地区，全球用户过4亿，自挂牌以来连续三年分红派息，努力发展成为国内移动游戏发行及研发行业中的领先企业和著名的移动广告服务商。', '公司全称：掌游天下信息技术股份有限公司&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; 主营业务： 移动终端游戏的代理发行与自主研发以及游戏广告业务&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; 所属行业：信息服务 &amp;mdash; 传媒&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; 法人代表： 何鹏&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; 注册资金： 1.05亿元&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; 律师所：北京市天元律师事务所&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; 主办券商：中信建投&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; 会计所：立信会计师事务所(特殊普通合伙)&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; 挂牌时间：2016-2-25&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; 总股本： 1.05亿股&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; 交易方式：协议转让&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; 分层方式：基础层&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; 毛利率：54.88%&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; 营业收入：0.89亿元&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; 净利润：0.15亿元', '&lt;div style=&quot;text-align: center;&quot;&gt;\r\n	&lt;img alt=&quot;&quot; src=&quot;/uploads/allimg/171116/1450442926-0.jpg&quot; /&gt;&lt;img alt=&quot;&quot; src=&quot;/uploads/allimg/171116/1450441Q7-1.jpg&quot; /&gt;&lt;/div&gt;\r\n', '&lt;div style=&quot;text-align: center;&quot;&gt;\r\n	&lt;img alt=&quot;&quot; src=&quot;/uploads/allimg/171116/145045N45-0.jpg&quot; /&gt;&lt;img alt=&quot;&quot; src=&quot;/uploads/allimg/171116/14504551R-1.jpg&quot; /&gt;&lt;/div&gt;\r\n', '&lt;div style=&quot;text-align: center;&quot;&gt;\r\n	&lt;img alt=&quot;&quot; src=&quot;/uploads/allimg/171116/14504642J-0.jpg&quot; /&gt;&lt;/div&gt;\r\n');
INSERT INTO `ey_addon17_content` VALUES ('6', '15', '1642401471', '1642401471', '/uploads/171116/1-1G11614512aC.jpg', '驴妈妈兴旅国际旅行社有限公司', '******', '******', '消费服务', '上海', '洪清华', '40000万', '&amp;nbsp; 驴妈妈旅游网创立于2008年，是中国知名综合性旅游网站、自助游领军品牌、中国景区门票在线预订模式的开创者，提供景区门票、度假酒店、周边游、国内游、出境游、大交通、商旅定制游等预订服务。在景区门票、周边游、邮轮等品类处于行业领先地位，荣获&amp;ldquo;国家高新技术企业&amp;rdquo;、&amp;ldquo;上海市著名商标&amp;rdquo;等称号。&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; 驴妈妈APP客户端累计下载量超7亿，合作伙伴超5万家。2016年驴妈妈覆盖景区超过1万家，5A景区覆盖率居OTA行业第一。根据易观智库《中国在线周边自助游市场专题研究报告2016 》，在线周边自助游领域驴妈妈以30.7%的市场份额居于首位。&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; 驴妈妈旅游网覆盖国内重要旅游目的地和客源地，形成全国深度布局、线上线下O2O一站式服务，致力于让游客&amp;ldquo;自由而有尊严的行走&amp;rdquo;。', '&amp;nbsp; 所属行业：商务服务业&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; 主营业务：入境旅游业务，境内旅游业务，出境旅游业务，国际航线或者香港、澳门、台湾地区航线的航空客运销售代理业务，国内航线除香港、澳门、台湾地区航线外的航空客运销售代理业务，旅游用品、工艺品（象牙及其制品除外）、日用百货、服装服饰、皮革制品、鞋帽、洗涤用品、化妆品、摄影摄像器材、玩具、音响设备、办公用品、纸制品、珠宝首饰的销售，从事旅游专业技术领域内的技术咨询、技术开发，会务服务，展览展示服务。 【依法须经批准的项目，经相关部门批准后方可开展经营活动】&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; 注册资金：40000万元人民币', '&lt;div style=&quot;text-align: center;&quot;&gt;\r\n	&lt;img alt=&quot;&quot; src=&quot;/uploads/allimg/171116/1455321202-0.jpg&quot; /&gt;&lt;/div&gt;\r\n', '&lt;div style=&quot;text-align: center;&quot;&gt;\r\n	&lt;img alt=&quot;&quot; src=&quot;/uploads/allimg/171116/14553359A-0.jpg&quot; /&gt;&lt;/div&gt;\r\n', '&lt;div style=&quot;text-align: center;&quot;&gt;\r\n	&lt;img alt=&quot;&quot; src=&quot;/uploads/allimg/171116/1455335O5-0.jpg&quot; /&gt;&lt;/div&gt;\r\n');
INSERT INTO `ey_addon17_content` VALUES ('7', '16', '1642401471', '1642401471', '/uploads/171116/1-1G1161456133H.jpg', '聚电智能科技股份有限公司', '安信证券', '870163', '移动互联', '广东', '肖彤', '1800万', '深圳聚电智能科技股份有限公司成立于2004年12月,是一家以数字电视终端接收设备及网络通讯产品的研发、设计、生产及销售为主营业务的高新技术企业。公司的主要产品包括数字电视产品、网络通讯产品、车联网产品和智慧家庭产品。&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; 公司于2016年12月20日在全国中小企业股份转让系统挂牌，股票代码：870163。公司目前拥有全资子公司深圳市聚电电源技术有限公司、控股子公司深圳市鑫乐源五金塑胶制品有限公司。&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp;公司一直致力于网通产品、车联网产品、智慧家庭产品、数字电视产品研发，凭借先进的品质管理体系和强大的技术实力，公司已逐步成为所处行业极具竞争力的企业之一。近年来，公司相继获得深圳市高新技术企业、国家高新技术企业、深圳市文化创意百强企业、宝安区民营百强企业等称号，并拥有四十多项自主核心专利技术。&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp;公司在南山高新园区深圳市软件产业基地拥有自有产权的研发中心，面积近1000平方米；在宝安福永拥有独立的工业园，厂房面积20000多平方米，拥有完善的SMT/DIP/整机装配车间，产品月生产能力超过120万台。&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; 公司所有产品均通过3C以及各行业要求的专业认证。公司视品质为生命，在产品研发、生产、服务过程中，建立了一整套完善的质量管理体系，对可能影响产品质量的所有环节进行严格而有效的控制。公司于2009年7月通过IS09001:2008版国际质量管理体系认证，于2011年10月通过ISO14001和OHSAS18001体系认证，在产品研发、定型、制造、检验、销售、服务等环节，均严格按照体系标准和流程进行管控。&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; 公司通过直销与分销相结合的模式开拓了国内外市场业务，在国内销售和国外销售中均取得了显著成绩。公司已相继成为国内多家知名企业的合作伙伴，目前主要客户有：海信集团、创维集团、长虹集团、浪潮集团、康佳集团、九洲电器、北京四达、中兴、韩国XCORE、HULEN等。&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; 公司设立了专门的原材料/半成品/成品可靠性试验室和售后服务机构，配备了专业的可靠性测试人员和售后服务人员，在出货量较大的终端市场，公司还设立了专门的售后服务点，以多种形式快速满足客户各种个性化服务需求。&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;ldquo;全员参与是起点、持续改善是方法、品质第一是准则、客户满意是目标&amp;rdquo;是公司的质量方针。公司在不断成长的过程中，凝聚了团结敬业、高效务实的决策层与管理层，形成了以人为本，严格而又和谐的管理体制，拥有一支技术精湛、敬业务实的员工队伍。我们有理由相信，通过聚电人的团结一致、锐意进取，一定会不断创造出新的辉煌！', '&amp;nbsp;公司全称：聚电智能科技股份有限公司&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; 主营业务：数字电视终端接收设备及网络通讯产品的研发、设计、生产及销售&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; 所属行业：信息设备 &amp;mdash; 通信设备&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; 法人代表： 肖彤&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; 注册资金： 4320万元&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; 律师所：广东华商律师事务所&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; 主办券商：安信证券&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; 会计所：上会会计师事务所(特殊普通合伙)&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; 挂牌时间：2016-12-20&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; 总股本： 0.43亿股&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; 交易方式：协议转让&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; 分层方式：基础层&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; 毛利率：23.63%&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; 营业收入：1.69亿元&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; 净利润：0.13亿元', '&lt;div style=&quot;text-align: center;&quot;&gt;\r\n	&lt;img alt=&quot;&quot; src=&quot;/uploads/allimg/171116/14591K003-0.jpg&quot; /&gt;&lt;img alt=&quot;&quot; src=&quot;/uploads/allimg/171116/14591M230-1.jpg&quot; /&gt;&lt;/div&gt;\r\n', '&lt;div style=&quot;text-align: center;&quot;&gt;\r\n	&lt;img alt=&quot;&quot; src=&quot;/uploads/allimg/171116/14591S249-0.jpg&quot; /&gt;&lt;img alt=&quot;&quot; src=&quot;/uploads/allimg/171116/14591W304-1.jpg&quot; /&gt;&lt;/div&gt;\r\n', '&lt;div style=&quot;text-align: center;&quot;&gt;\r\n	&lt;img alt=&quot;&quot; src=&quot;/uploads/allimg/171116/1459192c7-0.jpg&quot; /&gt;&lt;/div&gt;\r\n');
INSERT INTO `ey_addon17_content` VALUES ('8', '99', '1642401471', '1642401471', '/uploads/171125/1-1G1251453155B.jpg', '超达', '中大证券', '871346', '消费服务', '上海', '张学友', '100', '公司于2014年1月8日整体改制为股份制公司，目前注册资本为8265.17万元。公司于2014年12月8日在新三板挂牌，股票代码：831421，股票简称：天富电气。&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; 公司占地面积43,000平方米，拥有建筑面积32,000平方米的现代化厂房，配置有多种先进的数控加工设备，以及12kV、0.4kV开关柜装配检测自动化生产线，12kV断路器、0.4kV塑壳开关装配检测自动化生产线，各种高精度专项检测试验仪器。产品广泛应用于电力、冶金、矿山、石化、铁路、通讯、房产等行业的输电、供电、配电系统。&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; 企业始终坚持自主创新，设立了智能开关柜研究室，汇集了一批由高级工程师、高级技师、工程师、技师等组成的电气领域技术一流的精英团队，并与省、市多所高等院校建立了长期合作关系，拥有一大批具有自主知识产权，采用并达到GB标准和IEC标准的产品，具有标准化、系列化等特点,安全、节能、环保。&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; 天富电气成立十多年来凭借优质的产品和良好的信誉赢得了客户、合作伙伴、行业协会及各级电力部门的信任和赞誉。公司在同行业中率先通过了IS09001质量管理体系认证、3C强制性认证，以及政府监管部门、行业协会组织的评审鉴定。公司先后获得国家高新技术企业、广东省民营科技企业、连续十二年被评为广东省守合同重信用企业。&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;quot;天道酬勤，富在德馨&amp;quot;是天富企业的核心价值观。&amp;quot;将企业打造成面向国际、国内一流，具有较高专业化水准和较强的市场竞争力的，能够持续快速发展的国际化企业&amp;quot;是天富企业的愿景目标。公司始终坚持技术创新，超越自我，关爱员工，致力于营造股东、客户、合作伙伴、员工多赢共荣，共享成长的优良社会价值链。', '公司于2014年1月8日整体改制为股份制公司，目前注册资本为8265.17万元。公司于2014年12月8日在新三板挂牌，股票代码：831421，股票简称：天富电气。&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; 公司占地面积43,000平方米，拥有建筑面积32,000平方米的现代化厂房，配置有多种先进的数控加工设备，以及12kV、0.4kV开关柜装配检测自动化生产线，12kV断路器、0.4kV塑壳开关装配检测自动化生产线，各种高精度专项检测试验仪器。产品广泛应用于电力、冶金、矿山、石化、铁路、通讯、房产等行业的输电、供电、配电系统。&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; 企业始终坚持自主创新，设立了智能开关柜研究室，汇集了一批由高级工程师、高级技师、工程师、技师等组成的电气领域技术一流的精英团队，并与省、市多所高等院校建立了长期合作关系，拥有一大批具有自主知识产权，采用并达到GB标准和IEC标准的产品，具有标准化、系列化等特点,安全、节能、环保。&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; 天富电气成立十多年来凭借优质的产品和良好的信誉赢得了客户、合作伙伴、行业协会及各级电力部门的信任和赞誉。公司在同行业中率先通过了IS09001质量管理体系认证、3C强制性认证，以及政府监管部门、行业协会组织的评审鉴定。公司先后获得国家高新技术企业、广东省民营科技企业、连续十二年被评为广东省守合同重信用企业。&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;quot;天道酬勤，富在德馨&amp;quot;是天富企业的核心价值观。&amp;quot;将企业打造成面向国际、国内一流，具有较高专业化水准和较强的市场竞争力的，能够持续快速发展的国际化企业&amp;quot;是天富企业的愿景目标。公司始终坚持技术创新，超越自我，关爱员工，致力于营造股东、客户、合作伙伴、员工多赢共荣，共享成长的优良社会价值链。', '公司于2014年1月8日整体改制为股份制公司，目前注册资本为8265.17万元。公司于2014年12月8日在新三板挂牌，股票代码：831421，股票简称：天富电气。&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; 公司占地面积43,000平方米，拥有建筑面积32,000平方米的现代化厂房，配置有多种先进的数控加工设备，以及12kV、0.4kV开关柜装配检测自动化生产线，12kV断路器、0.4kV塑壳开关装配检测自动化生产线，各种高精度专项检测试验仪器。产品广泛应用于电力、冶金、矿山、石化、铁路、通讯、房产等行业的输电、供电、配电系统。&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; 企业始终坚持自主创新，设立了智能开关柜研究室，汇集了一批由高级工程师、高级技师、工程师、技师等组成的电气领域技术一流的精英团队，并与省、市多所高等院校建立了长期合作关系，拥有一大批具有自主知识产权，采用并达到GB标准和IEC标准的产品，具有标准化、系列化等特点,安全、节能、环保。&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; 天富电气成立十多年来凭借优质的产品和良好的信誉赢得了客户、合作伙伴、行业协会及各级电力部门的信任和赞誉。公司在同行业中率先通过了IS09001质量管理体系认证、3C强制性认证，以及政府监管部门、行业协会组织的评审鉴定。公司先后获得国家高新技术企业、广东省民营科技企业、连续十二年被评为广东省守合同重信用企业。&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;quot;天道酬勤，富在德馨&amp;quot;是天富企业的核心价值观。&amp;quot;将企业打造成面向国际、国内一流，具有较高专业化水准和较强的市场竞争力的，能够持续快速发展的国际化企业&amp;quot;是天富企业的愿景目标。公司始终坚持技术创新，超越自我，关爱员工，致力于营造股东、客户、合作伙伴、员工多赢共荣，共享成长的优良社会价值链。', '公司于2014年1月8日整体改制为股份制公司，目前注册资本为8265.17万元。公司于2014年12月8日在新三板挂牌，股票代码：831421，股票简称：天富电气。&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; 公司占地面积43,000平方米，拥有建筑面积32,000平方米的现代化厂房，配置有多种先进的数控加工设备，以及12kV、0.4kV开关柜装配检测自动化生产线，12kV断路器、0.4kV塑壳开关装配检测自动化生产线，各种高精度专项检测试验仪器。产品广泛应用于电力、冶金、矿山、石化、铁路、通讯、房产等行业的输电、供电、配电系统。&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; 企业始终坚持自主创新，设立了智能开关柜研究室，汇集了一批由高级工程师、高级技师、工程师、技师等组成的电气领域技术一流的精英团队，并与省、市多所高等院校建立了长期合作关系，拥有一大批具有自主知识产权，采用并达到GB标准和IEC标准的产品，具有标准化、系列化等特点,安全、节能、环保。&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; 天富电气成立十多年来凭借优质的产品和良好的信誉赢得了客户、合作伙伴、行业协会及各级电力部门的信任和赞誉。公司在同行业中率先通过了IS09001质量管理体系认证、3C强制性认证，以及政府监管部门、行业协会组织的评审鉴定。公司先后获得国家高新技术企业、广东省民营科技企业、连续十二年被评为广东省守合同重信用企业。&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;quot;天道酬勤，富在德馨&amp;quot;是天富企业的核心价值观。&amp;quot;将企业打造成面向国际、国内一流，具有较高专业化水准和较强的市场竞争力的，能够持续快速发展的国际化企业&amp;quot;是天富企业的愿景目标。公司始终坚持技术创新，超越自我，关爱员工，致力于营造股东、客户、合作伙伴、员工多赢共荣，共享成长的优良社会价值链。', '公司于2014年1月8日整体改制为股份制公司，目前注册资本为8265.17万元。公司于2014年12月8日在新三板挂牌，股票代码：831421，股票简称：天富电气。&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; 公司占地面积43,000平方米，拥有建筑面积32,000平方米的现代化厂房，配置有多种先进的数控加工设备，以及12kV、0.4kV开关柜装配检测自动化生产线，12kV断路器、0.4kV塑壳开关装配检测自动化生产线，各种高精度专项检测试验仪器。产品广泛应用于电力、冶金、矿山、石化、铁路、通讯、房产等行业的输电、供电、配电系统。&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; 企业始终坚持自主创新，设立了智能开关柜研究室，汇集了一批由高级工程师、高级技师、工程师、技师等组成的电气领域技术一流的精英团队，并与省、市多所高等院校建立了长期合作关系，拥有一大批具有自主知识产权，采用并达到GB标准和IEC标准的产品，具有标准化、系列化等特点,安全、节能、环保。&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; 天富电气成立十多年来凭借优质的产品和良好的信誉赢得了客户、合作伙伴、行业协会及各级电力部门的信任和赞誉。公司在同行业中率先通过了IS09001质量管理体系认证、3C强制性认证，以及政府监管部门、行业协会组织的评审鉴定。公司先后获得国家高新技术企业、广东省民营科技企业、连续十二年被评为广东省守合同重信用企业。&lt;br /&gt;\r\n&lt;br /&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;quot;天道酬勤，富在德馨&amp;quot;是天富企业的核心价值观。&amp;quot;将企业打造成面向国际、国内一流，具有较高专业化水准和较强的市场竞争力的，能够持续快速发展的国际化企业&amp;quot;是天富企业的愿景目标。公司始终坚持技术创新，超越自我，关爱员工，致力于营造股东、客户、合作伙伴、员工多赢共荣，共享成长的优良社会价值链。');

-- -----------------------------
-- Table structure for `ey_admin`
-- -----------------------------
DROP TABLE IF EXISTS `ey_admin`;
CREATE TABLE `ey_admin` (
  `admin_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '用户id',
  `user_name` varchar(20) NOT NULL DEFAULT '' COMMENT '用户名',
  `pen_name` varchar(50) DEFAULT '' COMMENT '笔名（发布文章后显示责任编辑的名字）',
  `true_name` varchar(20) DEFAULT '' COMMENT '真实姓名',
  `mobile` varchar(11) DEFAULT '' COMMENT '手机号码',
  `email` varchar(60) DEFAULT '' COMMENT 'email',
  `password` varchar(255) NOT NULL DEFAULT '' COMMENT '密码',
  `head_pic` varchar(255) DEFAULT '' COMMENT '头像',
  `last_login` int(11) DEFAULT '0' COMMENT '最后登录时间',
  `last_ip` varchar(15) DEFAULT '' COMMENT '最后登录ip',
  `login_cnt` int(11) DEFAULT '0' COMMENT '登录次数',
  `session_id` varchar(50) DEFAULT '' COMMENT 'session_id',
  `parent_id` int(10) DEFAULT '0' COMMENT '父管理员ID',
  `role_id` int(10) NOT NULL DEFAULT '-1' COMMENT '角色组ID（-1表示超级管理员）',
  `mark_lang` varchar(50) DEFAULT 'cn' COMMENT '当前语言标识',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态(0=屏蔽，1=正常)',
  `syn_users_id` int(10) DEFAULT '0' COMMENT '同步注册到会员表',
  `desc` varchar(500) DEFAULT '' COMMENT '工作内容',
  `add_time` int(11) DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`admin_id`),
  KEY `user_name` (`user_name`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='管理员表';

-- -----------------------------
-- Records of `ey_admin`
-- -----------------------------
INSERT INTO `ey_admin` VALUES ('1', 'admin', '', 'admin', '', '', '69a051c75d33d19ed159d28c961331fc', '', '1684485018', '127.0.0.1', '6', 'uola69skbfmohk6tlkllj03j8b', '0', '-1', 'cn', '1', '1', '', '1684114829', '1684114837');

-- -----------------------------
-- Table structure for `ey_admin_log`
-- -----------------------------
DROP TABLE IF EXISTS `ey_admin_log`;
CREATE TABLE `ey_admin_log` (
  `log_id` bigint(16) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `admin_id` int(10) NOT NULL DEFAULT '-1' COMMENT '管理员id',
  `log_info` text COMMENT '日志描述',
  `log_ip` varchar(30) DEFAULT '' COMMENT 'ip地址',
  `log_url` varchar(255) DEFAULT '' COMMENT 'url',
  `log_time` int(11) DEFAULT '0' COMMENT '日志时间',
  PRIMARY KEY (`log_id`),
  KEY `admin_id` (`admin_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=295 DEFAULT CHARSET=utf8 COMMENT='管理员操作日志表';

-- -----------------------------
-- Records of `ey_admin_log`
-- -----------------------------
INSERT INTO `ey_admin_log` VALUES ('192', '1', '后台登录', '127.0.0.1', '/login.php', '1684114837');
INSERT INTO `ey_admin_log` VALUES ('191', '-1', '访问后台', '127.0.0.1', '/login.php', '1684114832');
INSERT INTO `ey_admin_log` VALUES ('193', '-1', '访问后台', '127.0.0.1', '/login.php', '1684303757');
INSERT INTO `ey_admin_log` VALUES ('194', '1', '后台登录', '127.0.0.1', '/login.php', '1684303765');
INSERT INTO `ey_admin_log` VALUES ('195', '1', '保存自定义变量：头部文字,网站简介,邮箱,网站名', '127.0.0.1', '/login.php', '1684304082');
INSERT INTO `ey_admin_log` VALUES ('196', '1', '新增栏目：理财购物', '127.0.0.1', '/login.php', '1684305334');
INSERT INTO `ey_admin_log` VALUES ('197', '1', '移动文档-id：Array', '127.0.0.1', '/login.php', '1684305359');
INSERT INTO `ey_admin_log` VALUES ('198', '1', '编辑图集：小涵兼职', '127.0.0.1', '/login.php', '1684305764');
INSERT INTO `ey_admin_log` VALUES ('199', '1', '编辑图集：试玩赚钱入口', '127.0.0.1', '/login.php', '1684305778');
INSERT INTO `ey_admin_log` VALUES ('200', '1', '编辑图集：头号试玩', '127.0.0.1', '/login.php', '1684305786');
INSERT INTO `ey_admin_log` VALUES ('201', '1', '编辑图集：巨宝朋', '127.0.0.1', '/login.php', '1684305795');
INSERT INTO `ey_admin_log` VALUES ('202', '1', '编辑图集：赚钱吧', '127.0.0.1', '/login.php', '1684305805');
INSERT INTO `ey_admin_log` VALUES ('203', '1', '编辑图集：量次元', '127.0.0.1', '/login.php', '1684305816');
INSERT INTO `ey_admin_log` VALUES ('204', '1', '编辑图集：柚子试玩', '127.0.0.1', '/login.php', '1684305824');
INSERT INTO `ey_admin_log` VALUES ('205', '1', '编辑图集：钱派试玩', '127.0.0.1', '/login.php', '1684305840');
INSERT INTO `ey_admin_log` VALUES ('206', '1', '新增栏目：角色扮演', '127.0.0.1', '/login.php', '1684305999');
INSERT INTO `ey_admin_log` VALUES ('207', '1', '新增栏目：动作格斗', '127.0.0.1', '/login.php', '1684306010');
INSERT INTO `ey_admin_log` VALUES ('208', '1', '新增栏目：休闲益智', '127.0.0.1', '/login.php', '1684306022');
INSERT INTO `ey_admin_log` VALUES ('209', '1', '移动文档-id：Array', '127.0.0.1', '/login.php', '1684306725');
INSERT INTO `ey_admin_log` VALUES ('210', '1', '新增栏目：社交聊天', '127.0.0.1', '/login.php', '1684307645');
INSERT INTO `ey_admin_log` VALUES ('211', '1', '新增栏目：系统工具', '127.0.0.1', '/login.php', '1684307652');
INSERT INTO `ey_admin_log` VALUES ('212', '1', '新增栏目：数字金融', '127.0.0.1', '/login.php', '1684307660');
INSERT INTO `ey_admin_log` VALUES ('213', '1', '新增栏目：旅游出行', '127.0.0.1', '/login.php', '1684307664');
INSERT INTO `ey_admin_log` VALUES ('214', '1', '移动文档-id：Array', '127.0.0.1', '/login.php', '1684307674');
INSERT INTO `ey_admin_log` VALUES ('215', '1', '移动文档-id：Array', '127.0.0.1', '/login.php', '1684307701');
INSERT INTO `ey_admin_log` VALUES ('216', '1', '移动文档-id：Array', '127.0.0.1', '/login.php', '1684307718');
INSERT INTO `ey_admin_log` VALUES ('217', '1', '批量增加栏目：关于我们,帮助中心,免责声明,广告合作', '127.0.0.1', '/login.php', '1684308836');
INSERT INTO `ey_admin_log` VALUES ('218', '1', '保存自定义变量：头部文字,底部声明,邮箱,网站名', '127.0.0.1', '/login.php', '1684309049');
INSERT INTO `ey_admin_log` VALUES ('219', '1', '编辑栏目：关于我们', '127.0.0.1', '/login.php', '1684309129');
INSERT INTO `ey_admin_log` VALUES ('220', '1', '编辑栏目：帮助中心', '127.0.0.1', '/login.php', '1684309138');
INSERT INTO `ey_admin_log` VALUES ('221', '1', '编辑栏目：免责声明', '127.0.0.1', '/login.php', '1684309143');
INSERT INTO `ey_admin_log` VALUES ('222', '1', '编辑栏目：广告合作', '127.0.0.1', '/login.php', '1684309148');
INSERT INTO `ey_admin_log` VALUES ('223', '1', '编辑图集：小啄赚钱', '127.0.0.1', '/login.php', '1684310512');
INSERT INTO `ey_admin_log` VALUES ('224', '1', '编辑图集：金钱豹', '127.0.0.1', '/login.php', '1684310536');
INSERT INTO `ey_admin_log` VALUES ('225', '1', '编辑图集：小啄赚钱', '127.0.0.1', '/login.php', '1684314021');
INSERT INTO `ey_admin_log` VALUES ('226', '1', '新增栏目：游戏攻略', '127.0.0.1', '/login.php', '1684318203');
INSERT INTO `ey_admin_log` VALUES ('227', '1', '新增栏目：游戏资讯', '127.0.0.1', '/login.php', '1684318212');
INSERT INTO `ey_admin_log` VALUES ('228', '1', '移动文档-id：Array', '127.0.0.1', '/login.php', '1684318219');
INSERT INTO `ey_admin_log` VALUES ('229', '1', '删除搜索关键词：阿萨德as ,快,啊实打实,大六顺,请输入搜索的关键词,sss,asdas,发发发发发', '127.0.0.1', '/login.php', '1684319631');
INSERT INTO `ey_admin_log` VALUES ('230', '-1', '访问后台', '127.0.0.1', '/login.php', '1684370112');
INSERT INTO `ey_admin_log` VALUES ('231', '1', '后台登录', '127.0.0.1', '/login.php', '1684370119');
INSERT INTO `ey_admin_log` VALUES ('232', '1', '保存自定义变量：头部文字,底部声明,邮箱,免责声明', '127.0.0.1', '/login.php', '1684371560');
INSERT INTO `ey_admin_log` VALUES ('233', '1', '编辑栏目：排行版', '127.0.0.1', '/login.php', '1684372227');
INSERT INTO `ey_admin_log` VALUES ('234', '1', '新增栏目：人气榜', '127.0.0.1', '/login.php', '1684372240');
INSERT INTO `ey_admin_log` VALUES ('235', '1', '新增栏目：飙升榜', '127.0.0.1', '/login.php', '1684372247');
INSERT INTO `ey_admin_log` VALUES ('236', '1', '新增栏目：期待榜', '127.0.0.1', '/login.php', '1684372254');
INSERT INTO `ey_admin_log` VALUES ('237', '1', '新增栏目：热玩榜', '127.0.0.1', '/login.php', '1684372261');
INSERT INTO `ey_admin_log` VALUES ('238', '1', '新增文章：崩坏星穹铁道找到藏起来的鼹鼠党成员攻略', '127.0.0.1', '/login.php', '1684372535');
INSERT INTO `ey_admin_log` VALUES ('239', '1', '编辑栏目：人气榜', '127.0.0.1', '/login.php', '1684372825');
INSERT INTO `ey_admin_log` VALUES ('240', '1', '编辑栏目：飙升榜', '127.0.0.1', '/login.php', '1684372835');
INSERT INTO `ey_admin_log` VALUES ('241', '1', '编辑栏目：排行版', '127.0.0.1', '/login.php', '1684373231');
INSERT INTO `ey_admin_log` VALUES ('242', '1', '编辑栏目：排行版', '127.0.0.1', '/login.php', '1684373238');
INSERT INTO `ey_admin_log` VALUES ('243', '1', '编辑栏目：广告合作', '127.0.0.1', '/login.php', '1684375275');
INSERT INTO `ey_admin_log` VALUES ('244', '1', '编辑栏目：免责声明', '127.0.0.1', '/login.php', '1684375417');
INSERT INTO `ey_admin_log` VALUES ('245', '1', '编辑栏目：关于我们', '127.0.0.1', '/login.php', '1684375537');
INSERT INTO `ey_admin_log` VALUES ('246', '1', '编辑栏目：帮助中心', '127.0.0.1', '/login.php', '1684375590');
INSERT INTO `ey_admin_log` VALUES ('247', '1', '新增栏目：联系我们', '127.0.0.1', '/login.php', '1684375851');
INSERT INTO `ey_admin_log` VALUES ('248', '1', '新增栏目：家长监护', '127.0.0.1', '/login.php', '1684375860');
INSERT INTO `ey_admin_log` VALUES ('249', '1', '新增栏目：纠纷处理', '127.0.0.1', '/login.php', '1684375874');
INSERT INTO `ey_admin_log` VALUES ('250', '1', '删除文档-id：122,123,124,125,126,127,128,129', '127.0.0.1', '/login.php', '1684375933');
INSERT INTO `ey_admin_log` VALUES ('251', '1', '编辑【专题模型】的状态为：启用', '127.0.0.1', '/login.php', '1684375956');
INSERT INTO `ey_admin_log` VALUES ('252', '1', '编辑栏目：专题推荐', '127.0.0.1', '/login.php', '1684375972');
INSERT INTO `ey_admin_log` VALUES ('253', '1', '删除模型：自专题模型', '127.0.0.1', '/login.php', '1684375981');
INSERT INTO `ey_admin_log` VALUES ('254', '1', '新增栏目：专题大全', '127.0.0.1', '/login.php', '1684376012');
INSERT INTO `ey_admin_log` VALUES ('255', '1', '新增专题：有趣游戏', '127.0.0.1', '/login.php', '1684376988');
INSERT INTO `ey_admin_log` VALUES ('256', '1', '新增专题：奇迹游戏', '127.0.0.1', '/login.php', '1684377931');
INSERT INTO `ey_admin_log` VALUES ('257', '1', '编辑专题：奇迹游戏', '127.0.0.1', '/login.php', '1684378060');
INSERT INTO `ey_admin_log` VALUES ('258', '1', '新增专题：摸鱼小游戏', '127.0.0.1', '/login.php', '1684378097');
INSERT INTO `ey_admin_log` VALUES ('259', '1', '新增专题：高爆传奇', '127.0.0.1', '/login.php', '1684378118');
INSERT INTO `ey_admin_log` VALUES ('260', '1', '编辑专题：高爆传奇', '127.0.0.1', '/login.php', '1684378145');
INSERT INTO `ey_admin_log` VALUES ('261', '1', '编辑专题：高爆传奇', '127.0.0.1', '/login.php', '1684378182');
INSERT INTO `ey_admin_log` VALUES ('262', '1', '编辑专题：有趣游戏', '127.0.0.1', '/login.php', '1684378204');
INSERT INTO `ey_admin_log` VALUES ('263', '1', '编辑专题：奇迹游戏', '127.0.0.1', '/login.php', '1684378215');
INSERT INTO `ey_admin_log` VALUES ('264', '1', '编辑专题：摸鱼小游戏', '127.0.0.1', '/login.php', '1684378227');
INSERT INTO `ey_admin_log` VALUES ('265', '1', '编辑图集：玩玩赚', '127.0.0.1', '/login.php', '1684379752');
INSERT INTO `ey_admin_log` VALUES ('266', '1', '保存自定义变量：头部文字,底部声明,邮箱,免责声明', '127.0.0.1', '/login.php', '1684392687');
INSERT INTO `ey_admin_log` VALUES ('267', '1', '删除自定义变量：web_attr_4', '127.0.0.1', '/login.php', '1684396501');
INSERT INTO `ey_admin_log` VALUES ('268', '1', '移动文档-id：Array', '127.0.0.1', '/login.php', '1684397259');
INSERT INTO `ey_admin_log` VALUES ('269', '1', '编辑图集：来赚', '127.0.0.1', '/login.php', '1684397311');
INSERT INTO `ey_admin_log` VALUES ('270', '1', '编辑图集：来赚', '127.0.0.1', '/login.php', '1684397324');
INSERT INTO `ey_admin_log` VALUES ('271', '1', '编辑图集：iMoney爱盈利', '127.0.0.1', '/login.php', '1684397352');
INSERT INTO `ey_admin_log` VALUES ('272', '1', '编辑图集：火箭试玩', '127.0.0.1', '/login.php', '1684397375');
INSERT INTO `ey_admin_log` VALUES ('273', '1', '新增栏目：手游专题', '127.0.0.1', '/login.php', '1684399905');
INSERT INTO `ey_admin_log` VALUES ('274', '1', '新增栏目：应用专题', '127.0.0.1', '/login.php', '1684399911');
INSERT INTO `ey_admin_log` VALUES ('275', '1', '移动文档-id：Array', '127.0.0.1', '/login.php', '1684399918');
INSERT INTO `ey_admin_log` VALUES ('276', '-1', '访问后台', '127.0.0.1', '/login.php', '1684457687');
INSERT INTO `ey_admin_log` VALUES ('277', '1', '后台登录', '127.0.0.1', '/login.php', '1684457692');
INSERT INTO `ey_admin_log` VALUES ('278', '1', '编辑文章：哆啦赚是真的能挣钱吗？详细解读哆啦赚是不是', '127.0.0.1', '/login.php', '1684463367');
INSERT INTO `ey_admin_log` VALUES ('279', '1', '删除搜索关键词：免费', '127.0.0.1', '/login.php', '1684464239');
INSERT INTO `ey_admin_log` VALUES ('280', '1', '移动文档-id：Array', '127.0.0.1', '/login.php', '1684467677');
INSERT INTO `ey_admin_log` VALUES ('281', '1', '编辑图集：钱派试玩', '127.0.0.1', '/login.php', '1684467759');
INSERT INTO `ey_admin_log` VALUES ('282', '1', '编辑图集：柚子试玩', '127.0.0.1', '/login.php', '1684467782');
INSERT INTO `ey_admin_log` VALUES ('283', '1', '编辑图集：量次元', '127.0.0.1', '/login.php', '1684467788');
INSERT INTO `ey_admin_log` VALUES ('284', '1', '编辑图集：赚钱吧', '127.0.0.1', '/login.php', '1684467795');
INSERT INTO `ey_admin_log` VALUES ('285', '1', '编辑图集：巨宝朋', '127.0.0.1', '/login.php', '1684467801');
INSERT INTO `ey_admin_log` VALUES ('286', '1', '编辑图集：头号试玩', '127.0.0.1', '/login.php', '1684467806');
INSERT INTO `ey_admin_log` VALUES ('287', '1', '编辑图集：试玩赚钱入口', '127.0.0.1', '/login.php', '1684467816');
INSERT INTO `ey_admin_log` VALUES ('288', '1', '编辑图集：小涵兼职', '127.0.0.1', '/login.php', '1684467823');
INSERT INTO `ey_admin_log` VALUES ('289', '-1', '访问后台', '127.0.0.1', '/login.php', '1684485012');
INSERT INTO `ey_admin_log` VALUES ('290', '1', '后台登录', '127.0.0.1', '/login.php', '1684485018');
INSERT INTO `ey_admin_log` VALUES ('291', '1', '编辑图集：手赚网官方app', '127.0.0.1', '/login.php', '1684486856');
INSERT INTO `ey_admin_log` VALUES ('292', '1', '保存自定义变量：头部文字,底部声明,免责声明', '127.0.0.1', '/login.php', '1684487282');
INSERT INTO `ey_admin_log` VALUES ('293', '1', '保存自定义变量：头部文字,底部声明,免责声明', '127.0.0.1', '/login.php', '1684487312');
INSERT INTO `ey_admin_log` VALUES ('294', '1', '保存自定义变量：头部文字,底部声明,免责声明', '127.0.0.1', '/login.php', '1684487406');

-- -----------------------------
-- Table structure for `ey_admin_menu`
-- -----------------------------
DROP TABLE IF EXISTS `ey_admin_menu`;
CREATE TABLE `ey_admin_menu` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` int(11) DEFAULT '0',
  `title` varchar(100) DEFAULT '' COMMENT '导航名称',
  `controller_name` varchar(50) DEFAULT '' COMMENT '控制器',
  `action_name` varchar(50) DEFAULT '' COMMENT '方法名',
  `param` varchar(255) DEFAULT '' COMMENT '参数',
  `icon` varchar(50) DEFAULT 'iconfont e-lanmuguanli' COMMENT '图标',
  `is_menu` tinyint(1) DEFAULT '0' COMMENT '是否显示为左侧菜单',
  `is_switch` tinyint(1) DEFAULT '0' COMMENT '是否显示在switch_map页面中',
  `sort_order` int(10) DEFAULT '100' COMMENT '排序号',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态，1=显示，0=隐藏',
  `lang` varchar(20) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `menu_id` (`menu_id`)
) ENGINE=MyISAM AUTO_INCREMENT=15 DEFAULT CHARSET=utf8 COMMENT='外挂功能地图菜单表';

-- -----------------------------
-- Records of `ey_admin_menu`
-- -----------------------------
INSERT INTO `ey_admin_menu` VALUES ('1', '1005', '欢迎页', 'Index', 'welcome', '', 'fa fa-user', '0', '1', '100', '1', 'cn', '1684114838', '1684114838');
INSERT INTO `ey_admin_menu` VALUES ('2', '1001', '栏目管理', 'Arctype', 'index', '|mt20|1', 'iconfont e-lanmuguanli', '1', '1', '100', '1', 'cn', '1684114838', '1650263716');
INSERT INTO `ey_admin_menu` VALUES ('3', '1002', '内容管理', 'Archives', 'index', '', 'iconfont e-neirongwendang', '1', '1', '100', '1', 'cn', '1684114838', '1684114838');
INSERT INTO `ey_admin_menu` VALUES ('4', '1004', '待审文档', 'Archives', 'index_draft', '|menu|1', 'iconfont e-tougao', '0', '1', '100', '1', 'cn', '1684114838', '1684114838');
INSERT INTO `ey_admin_menu` VALUES ('5', '1003', '广告管理', 'AdPosition', 'index', '', 'iconfont e-guanggao', '1', '1', '100', '1', 'cn', '1684114838', '1684114838');
INSERT INTO `ey_admin_menu` VALUES ('6', '2001', '基本信息', 'System', 'web', '', 'iconfont e-shezhi', '1', '1', '100', '1', 'cn', '1684114838', '1684114838');
INSERT INTO `ey_admin_menu` VALUES ('7', '2002', '可视编辑', 'Uiset', 'ui_index', '', 'iconfont e-keshihuabianji', '0', '1', '100', '1', 'cn', '1684114838', '1684114838');
INSERT INTO `ey_admin_menu` VALUES ('8', '2003', 'SEO模块', 'Seo', 'seo', '', 'iconfont e-seo', '1', '1', '100', '1', 'cn', '1684114838', '1684114838');
INSERT INTO `ey_admin_menu` VALUES ('9', '2004', '功能地图', 'Index', 'switch_map', '', 'iconfont e-caidangongneng', '1', '0', '10000', '1', 'cn', '1684114838', '1684114838');
INSERT INTO `ey_admin_menu` VALUES ('10', '2005', '插件应用', 'Weapp', 'index', '', 'iconfont e-chajian', '0', '1', '100', '1', 'cn', '1684114838', '1684114838');
INSERT INTO `ey_admin_menu` VALUES ('11', '2006', '会员中心', 'Member', 'users_index', '', 'iconfont e-gerenzhongxin', '0', '1', '100', '1', 'cn', '1684114838', '1684114838');
INSERT INTO `ey_admin_menu` VALUES ('12', '2008', '商城中心', 'Shop', 'home', '', 'iconfont e-shangcheng', '1', '1', '100', '1', 'cn', '1684114838', '1684114839');
INSERT INTO `ey_admin_menu` VALUES ('13', '2009', '可视化小程序', 'Diyminipro', 'page_edit', '', 'fa fa-code', '0', '1', '100', '1', 'cn', '1684114838', '1684114838');
INSERT INTO `ey_admin_menu` VALUES ('14', '2004018', '留言管理', 'Form', 'index', '', 'iconfont e-biaodanguanli', '0', '1', '100', '1', 'cn', '1677037793', '1677146423');

-- -----------------------------
-- Table structure for `ey_admin_wxlogin`
-- -----------------------------
DROP TABLE IF EXISTS `ey_admin_wxlogin`;
CREATE TABLE `ey_admin_wxlogin` (
  `wx_id` int(11) NOT NULL AUTO_INCREMENT,
  `type` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '1=官方公众号，2=微信应用',
  `admin_id` int(11) NOT NULL DEFAULT '0' COMMENT '用户id',
  `openid` varchar(50) NOT NULL DEFAULT '' COMMENT 'openid',
  `nickname` varchar(100) NOT NULL DEFAULT '' COMMENT '微信昵称',
  `unionid` varchar(200) NOT NULL DEFAULT '' COMMENT 'unionid',
  `headimgurl` varchar(200) NOT NULL DEFAULT '' COMMENT '头像',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`wx_id`) USING BTREE,
  KEY `openid` (`openid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='后台微信登录记录表';


-- -----------------------------
-- Table structure for `ey_archives`
-- -----------------------------
DROP TABLE IF EXISTS `ey_archives`;
CREATE TABLE `ey_archives` (
  `aid` int(10) NOT NULL AUTO_INCREMENT,
  `typeid` int(10) NOT NULL DEFAULT '0' COMMENT '当前栏目',
  `stypeid` varchar(90) DEFAULT '' COMMENT '副栏目ID集合',
  `channel` int(10) NOT NULL DEFAULT '0' COMMENT '模型ID',
  `is_b` tinyint(1) DEFAULT '0' COMMENT '加粗',
  `title` varchar(200) DEFAULT '' COMMENT '标题',
  `subtitle` varchar(200) DEFAULT '' COMMENT '副标题',
  `litpic` varchar(250) DEFAULT '' COMMENT '缩略图',
  `is_head` tinyint(1) DEFAULT '0' COMMENT '头条（0=否，1=是）',
  `is_special` tinyint(1) DEFAULT '0' COMMENT '特荐（0=否，1=是）',
  `is_top` tinyint(1) DEFAULT '0' COMMENT '置顶（0=否，1=是）',
  `is_recom` tinyint(1) DEFAULT '0' COMMENT '推荐（0=否，1=是）',
  `is_jump` tinyint(1) DEFAULT '0' COMMENT '跳转链接（0=否，1=是）',
  `is_litpic` tinyint(1) DEFAULT '0' COMMENT '图片（0=否，1=是）',
  `is_roll` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '滚动（0=否，1=是）',
  `is_slide` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '幻灯（0=否，1=是）',
  `is_diyattr` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '自定义（0=否，1=是）',
  `origin` varchar(200) DEFAULT '' COMMENT '来源',
  `author` varchar(200) DEFAULT '' COMMENT '作者',
  `click` int(10) DEFAULT '0' COMMENT '浏览量',
  `arcrank` int(10) DEFAULT '0' COMMENT '阅读权限：0=开放浏览，-1=待审核稿件',
  `jumplinks` varchar(255) DEFAULT '' COMMENT '外链跳转',
  `ismake` tinyint(1) DEFAULT '0' COMMENT '是否静态页面（0=动态，1=静态）',
  `seo_title` varchar(200) DEFAULT '' COMMENT 'SEO标题',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT 'SEO关键词',
  `seo_description` text COMMENT 'SEO描述',
  `attrlist_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '参数列表ID',
  `merchant_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '多商家ID',
  `free_shipping` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '商品是否包邮(1包邮(免运费)  0跟随系统)',
  `users_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '会员价',
  `users_free` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否会员免费，默认0不免费，1为免费',
  `old_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '产品旧价',
  `sales_num` int(10) NOT NULL DEFAULT '0' COMMENT '总销售量',
  `virtual_sales` int(10) DEFAULT '0' COMMENT '商品虚拟销售量',
  `sales_all` int(10) DEFAULT '0' COMMENT '虚拟总销量',
  `stock_count` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '商品库存量',
  `stock_show` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '商品库存在产品详情页是否显示，1为显示，0为不显示',
  `prom_type` tinyint(1) unsigned DEFAULT '0' COMMENT '产品类型：0=普通产品，1=虚拟(默认手动发货)，2=虚拟(网盘)，3=虚拟(自定义文本)',
  `tempview` varchar(200) DEFAULT '' COMMENT '文档模板文件名',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态(0=屏蔽，1=正常)',
  `sort_order` int(10) DEFAULT '0' COMMENT '排序号',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `admin_id` int(10) DEFAULT '0' COMMENT '管理员ID',
  `users_id` int(10) DEFAULT '0' COMMENT '会员ID',
  `arc_level_id` int(10) DEFAULT '0' COMMENT '文档会员权限ID',
  `restric_type` tinyint(1) DEFAULT '0' COMMENT '限制模式，0=免费，1=付费，2=会员专享，3=会员付费',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '伪删除，1=是，0=否',
  `del_method` tinyint(1) DEFAULT '0' COMMENT '伪删除状态，1为主动删除，2为跟随上级栏目被动删除',
  `joinaid` int(10) DEFAULT '0' COMMENT '关联文档ID',
  `downcount` int(10) DEFAULT '0' COMMENT '下载次数',
  `appraise` int(10) DEFAULT '0' COMMENT '评价数',
  `collection` int(10) DEFAULT '0' COMMENT '收藏数',
  `htmlfilename` varchar(500) DEFAULT '' COMMENT '自定义文件名',
  `province_id` int(10) DEFAULT '0' COMMENT '省份',
  `city_id` int(10) DEFAULT '0' COMMENT '所在城市',
  `area_id` int(10) DEFAULT '0' COMMENT '所在区域',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `no_vip_pay` tinyint(3) DEFAULT '0' COMMENT 'restric_type = 2 时,会员专享,非会员可付费使用,0-关闭,1-开启',
  PRIMARY KEY (`aid`),
  KEY `aid` (`typeid`,`channel`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=152 DEFAULT CHARSET=utf8 COMMENT='文档主表';

-- -----------------------------
-- Records of `ey_archives`
-- -----------------------------
INSERT INTO `ey_archives` VALUES ('1', '1', '', '3', '0', '小桔试玩', '', '/uploads/allimg/c200314/15T15040T3630-103940.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584150469', '1571760000', '0');
INSERT INTO `ey_archives` VALUES ('2', '1', '', '3', '0', '小啄赚钱', '', '/uploads/allimg/c200314/15T1504123E40-1D947.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '小啄赚钱，超级赚钱兼职平台，做任务的手机赚钱APP，闲暇时间者的手机赚钱软件平台，每天都有新的任务发布，新用户专享一元提现，支付宝、微信提现实时到账、无手续费。支持苹果和安卓手机【玩法多多】1、签到红包：连续15天签到任务，直接领15元微信红包；2、天天抽奖：赢取不同的奖励红包；3、小啄赚钱：啄一下开始赚钱，每次啄取不同任务，惊喜不断；4、钻石任务：高额奖励等你来领——你喜', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584150470', '1684314021', '0');
INSERT INTO `ey_archives` VALUES ('3', '1', '', '3', '0', '金钱豹', '', '/uploads/allimg/c200314/15T150414LT0-20OJ.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '金钱豹是专为苹果用户打造的越玩越有钱的APP，合理利用你的时间碎片，打开金钱豹，看广告、看视频、做任务，轻松赚取零花钱。金钱豹任务每天更新随时做，2元起提现，提现方便到账快。联系我们客服QQ交流群：623521005，客服QQ1178331206、3024631470', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584150470', '1684310536', '0');
INSERT INTO `ey_archives` VALUES ('4', '1', '', '3', '0', '玩玩赚', '', '/uploads/allimg/c200314/15T15041O4520-255094.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '玩玩赚，是一款让每个人都能通过苹果手机兼职赚钱的神奇应用！每天下载应用、做任务、签到或看视频广告活动等，积分赚不停，按照任务要求注册帐号并完成指定的试玩任务，奖励轻松到手。别人教您花钱，我们教您赚钱！不投一分钱，试玩应用，动动手指就能赚。10分钟就能赚到10元，支付宝提现~~', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584150470', '1684379752', '0');
INSERT INTO `ey_archives` VALUES ('5', '1', '', '3', '0', '懒虫试玩', '', '/uploads/allimg/c200314/15T15042340340-59204.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584150470', '1571760000', '0');
INSERT INTO `ey_archives` VALUES ('6', '1', '', '3', '0', '钱咖', '', '/uploads/allimg/c200314/15T15042L2R0-10B23.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584150470', '1572364800', '0');
INSERT INTO `ey_archives` VALUES ('7', '1', '', '3', '0', '今日赚', '', '/uploads/allimg/c200314/15T15043054420-152b4.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584150470', '1572796800', '0');
INSERT INTO `ey_archives` VALUES ('8', '1', '', '3', '0', '掉钱眼儿', '', '/uploads/allimg/c200314/15T150435NI0-2062J.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584150470', '1572796800', '0');
INSERT INTO `ey_archives` VALUES ('9', '1', '', '3', '0', '多玩红包', '', '/uploads/allimg/c200314/15T15043952M0-2562S.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '32', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584150470', '1572796800', '0');
INSERT INTO `ey_archives` VALUES ('10', '1', '', '3', '0', '金手指', '', '/uploads/allimg/c200314/15T150325DY0-55532.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584150470', '1572796800', '0');
INSERT INTO `ey_archives` VALUES ('11', '10', '', '3', '0', '钱派试玩', '', '/uploads/allimg/c200314/15T15032N3410-1014b.png', '0', '1', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '钱派试玩是一款苹果手机试玩赚钱软件，单价8毛，满10元提现。钱派试玩让你越玩越有钱，苹果手机轻松兼职。钱派试玩为你提供超多好玩的应用，玩一玩应用就领现金奖励，赶快加入钱派试玩领奖励！', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584150470', '1684467759', '0');
INSERT INTO `ey_archives` VALUES ('12', '10', '', '3', '0', '柚子试玩', '', '/uploads/allimg/c200314/15T15033111H0-154236.png', '0', '1', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '柚子试玩，苹果手机下载APP就能赚钱的软件。登陆就送1元，下载一个应用试玩3分钟奖励8毛，10元就能提现。柚子试玩，随时随地，零成本、无分享的手机赚钱软件。好玩的手机赚钱平台，体验更有趣的APP。客服QQ：429019089柚子试玩是业内知名的移动应用媒体平台。为用户提供流行应用和游戏的资讯以及试玩服务，让每一个应用为人所用。让用户更方便的找到应用、了解应用，更有体验应用的红包奖励给你拿，让柚子试', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584150470', '1684467782', '0');
INSERT INTO `ey_archives` VALUES ('13', '10', '', '3', '0', '量次元', '', '/uploads/allimg/c200314/15T150332S530-201505.png', '0', '1', '0', '1', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '量次元是最新发布的一款苹果试玩赚钱软件，任务单价0.8-1元，满10元可支付宝提现。在量次元试玩平台，体验有趣的APP，每天还能赚到零花钱，新人注册送1元。目前仅支持苹果手机客服QQ群：672866250', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584150470', '1684467788', '0');
INSERT INTO `ey_archives` VALUES ('14', '10', '', '3', '0', '赚钱吧', '', '/uploads/allimg/c200314/15T150335K5F-254526.png', '0', '1', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '赚钱吧是一个最新苹果手机APP试玩赚钱软件，下载一个APP单价1元奖励，新用户加入就送2元，10元就能提现，赶快加入赚钱吧下载应用赚钱啦。', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584150470', '1684467795', '0');
INSERT INTO `ey_archives` VALUES ('15', '10', '', '3', '0', '巨宝朋', '', '/uploads/allimg/c200314/15T150341133Z-53N5.png', '0', '1', '0', '1', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '巨宝朋全新改版，任务多多，每个任务1元单价，10元可以提现，巨宝朋是最专业的苹果手机应用赚钱平台，每天大量任务。', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584150470', '1684467801', '0');
INSERT INTO `ey_archives` VALUES ('16', '10', '', '3', '0', '头号试玩', '', '/uploads/allimg/c200314/15T15034QO20-104304.png', '0', '1', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '头号试玩 - 你的零钱提款机，用手机免费赚钱，试玩应用获得现金奖励，10元就能提现，单价1元左右。', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584150470', '1684467806', '0');
INSERT INTO `ey_archives` VALUES ('17', '10', '', '3', '0', '试玩赚钱入口', '', '/uploads/allimg/c200314/15T15035609B0-15O03.png', '0', '1', '0', '1', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '手赚网官方苹果试玩赚钱入口是为了苹果手机试玩的玩家更方便的找到试玩平台的入口，以及助手失效后更快更方便的重新下载熟手，不用一个个去找新的助手，所有助手尽在手赚网的试玩赚钱入口。手赚网试玩赚钱入口汇聚热门苹果试玩赚钱平台，以及热门手赚资讯和试玩教程。', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584150470', '1684467816', '0');
INSERT INTO `ey_archives` VALUES ('18', '10', '', '3', '0', '小涵兼职', '', '/uploads/allimg/c200314/15T15035915A0-2091B.png', '0', '1', '0', '1', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '小涵兼职是一个苹果试玩应用赚钱平台，任务单价1元左右，快速任务无需首次，能抢就能过，10元即可提现，只要你敢提我就能秒到，分分钟搞定。', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584150470', '1684467823', '0');
INSERT INTO `ey_archives` VALUES ('19', '10', '', '3', '0', '火箭试玩', '', '/uploads/allimg/c200314/15T150363U550-252113.png', '0', '0', '0', '0', '0', '1', '0', '1', '0', '', '', '0', '0', '', '0', '', '', '火箭试玩，试玩APP就能赚现金，5元就能提现。火箭试玩是一款APP试玩体验平台，每天更新大量优质应用供大家体验。下载并完成一定任务就可以获得现金奖励，奖励金可以通过微信轻松体现。 客服QQ 2939791234', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584150470', '1684397375', '0');
INSERT INTO `ey_archives` VALUES ('20', '10', '', '3', '0', 'iMoney爱盈利', '', '/uploads/allimg/c200314/15T1503Ca50-51561.png', '0', '0', '0', '0', '0', '1', '0', '1', '0', '', '', '0', '0', '', '0', '', '', 'iMoney爱盈利是最专业的手机试客平台，多种赚钱方式让您多一份零花钱，立刻加入送1元现金奖励，每天大量任务，单价1元起，10元提现。iMoney为你提供超多好玩的应用，试玩应用还能领取丰厚的现金红包。', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584150470', '1684397352', '0');
INSERT INTO `ey_archives` VALUES ('21', '10', '', '3', '0', '来赚', '', '/uploads/allimg/c200314/15T1503GP3P-103224.png', '0', '0', '0', '0', '0', '1', '0', '1', '0', '', '', '3', '0', '', '0', '', '', '“来赚”是一款iOS赚钱的APP，安装就送0.8元，完成新手任务领红包，用户通过来赚去下载应用即可获得现金奖励。目前来赚仅针对iOS(苹果)用户开放。But，所有用户都可以通过邀请好友加入来赚，获得丰厚的邀请与提成奖励！钱包中现金可轻松提现，小伙伴们反馈都赚High了。', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584150470', '1684397324', '0');
INSERT INTO `ey_archives` VALUES ('22', '11', '', '3', '0', 'i红包', '', '/uploads/allimg/c200314/15T1503K1D40-15V31.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '19', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584150470', '1684306725', '0');
INSERT INTO `ey_archives` VALUES ('23', '11', '', '3', '0', '天天赚钱', '', '/uploads/allimg/c200314/15T1503N3OZ-1bP4.png', '0', '0', '0', '1', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584150470', '1684306725', '0');
INSERT INTO `ey_archives` VALUES ('24', '11', '', '3', '0', '应用试客', '', '/uploads/allimg/c200314/15T1503QAS0-2433G.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584150470', '1684306725', '0');
INSERT INTO `ey_archives` VALUES ('25', '11', '', '3', '0', '多多红包', '', '/uploads/allimg/c200314/15T1503VF910-54L3.png', '0', '0', '0', '1', '0', '1', '0', '0', '0', '', '', '1', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584150470', '1684306725', '0');
INSERT INTO `ey_archives` VALUES ('26', '11', '', '3', '0', '小鱼赚钱', '', '/uploads/allimg/c200314/15T150392T540-91301.png', '0', '0', '0', '1', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584150470', '1684306725', '0');
INSERT INTO `ey_archives` VALUES ('27', '11', '', '3', '0', '芒果试玩', '', '/uploads/allimg/c200314/15T1503952IP-14VD.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584150470', '1684306725', '0');
INSERT INTO `ey_archives` VALUES ('28', '11', '', '3', '0', '蝉试客', '', '/uploads/allimg/c200314/15T1503c23L0-192T3.png', '0', '0', '0', '1', '0', '1', '0', '0', '0', '', '', '4', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584150470', '1684306725', '0');
INSERT INTO `ey_archives` VALUES ('29', '11', '', '3', '0', '秒赚试玩', '', '/uploads/allimg/c200314/15T1504025L0-245054.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '13', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584150470', '1684306725', '0');
INSERT INTO `ey_archives` VALUES ('30', '11', '', '3', '0', '爱钱试玩', '', '/uploads/allimg/c200314/15T15040604a0-530Y.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '79', '0', '', '0', '', '', '爱钱试玩，一款可以赚钱的手机试玩软件，为你提供超多好玩的应用，试玩应用还能领取丰厚的现金红包，赶快加入吧~10元就能提现，多种赚钱方式让您多一份零花钱，立刻加入送1元现', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584150470', '1684306725', '0');
INSERT INTO `ey_archives` VALUES ('31', '15', '', '3', '0', '知聊', '', '/uploads/allimg/c200314/15T150U341c0-214148.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '3', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584151312', '1684307701', '0');
INSERT INTO `ey_archives` VALUES ('32', '15', '', '3', '0', '恐龙多多', '', '/uploads/allimg/c200314/15T150QH4Y0-1031Z.jpg', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '18', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584151312', '1684307701', '0');
INSERT INTO `ey_archives` VALUES ('33', '15', '', '3', '0', '玩洽', '', '/uploads/allimg/c200314/15T150R15a10-151P2.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '19', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584151312', '1684307701', '0');
INSERT INTO `ey_archives` VALUES ('34', '15', '', '3', '0', '哇咔搞笑', '', '/uploads/allimg/c200314/15T150S1WF-202514.png', '0', '0', '0', '1', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584151312', '1684307701', '0');
INSERT INTO `ey_archives` VALUES ('35', '15', '', '3', '0', '众人帮', '', '/uploads/allimg/c200314/15T150SB410-2E556.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584151312', '1684307701', '0');
INSERT INTO `ey_archives` VALUES ('36', '15', '', '3', '0', '给力赚', '', '/uploads/allimg/c200314/15T150SZV60-32328.jpg', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584151312', '1684307701', '0');
INSERT INTO `ey_archives` VALUES ('37', '15', '', '3', '0', '闲来斗地主赚金版', '', '/uploads/allimg/c200314/15T150T341210-W492.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584151312', '1684307701', '0');
INSERT INTO `ey_archives` VALUES ('38', '15', '', '3', '0', 'PC蛋蛋', '', '/uploads/allimg/c200314/15T150TT52Z-1320X.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '3', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584151312', '1684307701', '0');
INSERT INTO `ey_archives` VALUES ('39', '15', '', '3', '0', '闪电接单', '', '/uploads/allimg/c200314/15T150U15430-1A915.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584151312', '1684307701', '0');
INSERT INTO `ey_archives` VALUES ('40', '15', '', '3', '0', '牛帮', '', '/uploads/allimg/c200314/15T150F105P-5Y29.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584151312', '1684307701', '0');
INSERT INTO `ey_archives` VALUES ('41', '16', '', '3', '0', '蜂窝帮', '', '/uploads/allimg/c200314/15T150FC92P-10BC.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584151312', '1684307718', '0');
INSERT INTO `ey_archives` VALUES ('42', '16', '', '3', '0', '钱帮', '', '/uploads/allimg/c200314/15T150F921210-159124.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584151312', '1684307718', '0');
INSERT INTO `ey_archives` VALUES ('43', '16', '', '3', '0', '截图宝', '', '/uploads/allimg/c200314/15T150G259640-203564.png', '0', '0', '0', '1', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584151312', '1684307718', '0');
INSERT INTO `ey_archives` VALUES ('44', '16', '', '3', '0', '撸猫有财', '', '/uploads/allimg/c200314/15T150G523440-25MB.png', '0', '0', '0', '1', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584151312', '1684307718', '0');
INSERT INTO `ey_archives` VALUES ('45', '14', '', '3', '0', '猫咪小屋', '', '/uploads/allimg/c200314/15T150H0R2Z-KP3.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584151312', '1684307674', '0');
INSERT INTO `ey_archives` VALUES ('46', '14', '', '3', '0', '悬赏猫', '', '/uploads/allimg/c200314/15T150H5b220-129113.png', '0', '0', '0', '1', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584151312', '1684307674', '0');
INSERT INTO `ey_archives` VALUES ('47', '14', '', '3', '0', '答题夺宝', '', '/eyou/uploads/allimg/20220105/1-220105141Q1258.png', '0', '0', '0', '1', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '答题夺宝是一款答题赚钱、益智题材的学习工具，让用户在获取知识的同时，每答一题都能产生价值。登陆填写邀请码361829476即送0.5元红包，首次3毛提现秒到账，之后20元起提现。首轮答题满送1.25元，越后面开的红包越大，同时还有分红猫，答题过程有机会获得限时分红猫。功能说明：1）轻松答题用户可通过参与答题，完成选择题和成语题的挑战，获取知识的同时收获惊喜。2）欢乐闯关用户可通过参与答题，开启更多', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584151312', '1684307674', '0');
INSERT INTO `ey_archives` VALUES ('48', '14', '', '3', '0', '恐龙世界', '', '/uploads/allimg/c200314/15T150K3c5P-2530I.png', '0', '0', '0', '1', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584151312', '1684307674', '0');
INSERT INTO `ey_archives` VALUES ('49', '14', '', '3', '0', '疯狂猜成语', '', '/uploads/allimg/c200314/15T150L2F010-311322.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584151312', '1684307674', '0');
INSERT INTO `ey_archives` VALUES ('50', '14', '', '3', '0', '哆啦赚', '', '/uploads/allimg/c200314/15T150LH12P-59293.png', '1', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584151312', '1684307674', '0');
INSERT INTO `ey_archives` VALUES ('51', '14', '', '3', '0', '码力任务辅助', '', '/uploads/allimg/c200314/15T150M052640-10C61.png', '0', '0', '0', '1', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584151312', '1684307674', '0');
INSERT INTO `ey_archives` VALUES ('52', '14', '', '3', '0', 'FZ辅助平台', '', '/uploads/allimg/c200314/15T150M2W330-154030.jpg', '0', '0', '0', '1', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584151312', '1684307674', '0');
INSERT INTO `ey_archives` VALUES ('53', '14', '', '3', '0', '贪吃蛇在线', '', '/uploads/allimg/c200314/15T150MP0Y0-2055A.png', '0', '0', '0', '1', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584151312', '1684307674', '0');
INSERT INTO `ey_archives` VALUES ('54', '14', '', '3', '0', '阳光养猪场', '', '/uploads/allimg/c200314/15T150N4cH0-25X17.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584151312', '1684307674', '0');
INSERT INTO `ey_archives` VALUES ('55', '14', '', '3', '0', '小白赚钱', '', '/uploads/allimg/c200314/15T150O04N20-54H1.png', '0', '0', '0', '1', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584151312', '1684307674', '0');
INSERT INTO `ey_archives` VALUES ('56', '14', '', '3', '0', '趣闲赚', '', '/uploads/allimg/c200314/15T150O411b0-11ZM.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584151312', '1684307674', '0');
INSERT INTO `ey_archives` VALUES ('57', '14', '', '3', '0', '欢乐招财犬', '', '/uploads/allimg/c200314/15T150O923560-1GV8.png', '0', '0', '0', '1', '0', '1', '0', '0', '0', '', '', '1', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584151312', '1684307674', '0');
INSERT INTO `ey_archives` VALUES ('58', '14', '', '3', '0', '小龙虾大亨', '', '/uploads/allimg/c200314/15T150P35PZ-2322B.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584151312', '1684307674', '0');
INSERT INTO `ey_archives` VALUES ('59', '14', '', '3', '0', '恐龙有钱', '', '/uploads/allimg/c200314/15T150PRc0-294Q8.png', '0', '0', '0', '1', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584151312', '1684307674', '0');
INSERT INTO `ey_archives` VALUES ('60', '14', '', '3', '0', '全民养龙', '', '/uploads/allimg/c200314/15T150Q204550-54452.png', '0', '0', '0', '1', '0', '1', '0', '0', '0', '', '', '3', '0', '', '0', '', '', '《全民养龙》是一款0充值基于大数据的手机游戏，通过五福龙合成分红龙，每天可以领取约300元的平台奖励。填邀请【 1IJMFR 】可 领取额外奖励 ，领养一直可爱的分红龙，进度满100%，', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584151312', '1684307674', '0');
INSERT INTO `ey_archives` VALUES ('61', '3', '', '3', '0', '乐米资讯', '', '/uploads/allimg/c200314/15T1514S12510-5LK.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584151543', '1562774400', '0');
INSERT INTO `ey_archives` VALUES ('62', '3', '', '3', '0', '淘金赚', '', '/uploads/allimg/c200314/15T1514Xc150-102D7.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584151543', '1562774400', '0');
INSERT INTO `ey_archives` VALUES ('63', '3', '', '3', '0', '猫猫赚', '', '/uploads/allimg/c200314/15T1514925O40-155Q9.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '3', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584151543', '1562774400', '0');
INSERT INTO `ey_archives` VALUES ('64', '3', '', '3', '0', '每天赚点', '', '/uploads/allimg/c200314/15T15149546060-20JX.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584151543', '1562774400', '0');
INSERT INTO `ey_archives` VALUES ('65', '3', '', '3', '0', '灵猴', '', '/uploads/allimg/c200314/15T1514c42140-252A5.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '4', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584151543', '1564588800', '0');
INSERT INTO `ey_archives` VALUES ('66', '3', '', '3', '0', '小龙赚钱', '', '/uploads/allimg/c200314/15T15150403530-BC6.png', '1', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584151543', '1565366400', '0');
INSERT INTO `ey_archives` VALUES ('67', '3', '', '3', '0', '蘑菇乐园', '', '/uploads/allimg/c200314/15T151506200P-11I50.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584151543', '1565366400', '0');
INSERT INTO `ey_archives` VALUES ('68', '3', '', '3', '0', '钱大师安卓版', '', '/uploads/allimg/c200314/15T15150U41Z-1E014.png', '0', '0', '0', '1', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584151543', '1565366400', '0');
INSERT INTO `ey_archives` VALUES ('69', '3', '', '3', '0', '泡泡赚', '', '/uploads/allimg/c200314/15T15151164060-219A8.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584151543', '1565366400', '0');
INSERT INTO `ey_archives` VALUES ('70', '3', '', '3', '0', '米赚', '', '/uploads/allimg/c200314/15T15152195J0-264954.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584151543', '1565366400', '0');
INSERT INTO `ey_archives` VALUES ('71', '3', '', '3', '0', '蜜蜂试玩安卓版', '', '/uploads/allimg/c200314/15T1513S3320-55431.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584151543', '1569686400', '0');
INSERT INTO `ey_archives` VALUES ('72', '3', '', '3', '0', 'Q玩小游戏', '', '/uploads/allimg/c200314/15T1513W32O0-109E3.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584151543', '1582905600', '0');
INSERT INTO `ey_archives` VALUES ('73', '3', '', '3', '0', '葫芦赚', '', '/uploads/allimg/c200314/15T1513ZD1F-15W23.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584151543', '1582905600', '0');
INSERT INTO `ey_archives` VALUES ('74', '3', '', '3', '0', '手机蹦蹦', '', '/uploads/allimg/c200314/15T15139C1F-214N8.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584151543', '1582905600', '0');
INSERT INTO `ey_archives` VALUES ('75', '3', '', '3', '0', '聚享游', '', '/uploads/allimg/c200314/15T151402M950-2B413.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584151543', '1582905600', '0');
INSERT INTO `ey_archives` VALUES ('76', '3', '', '3', '0', '赚宝', '', '/uploads/allimg/c200314/15T1514062C60-553U.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584151543', '1582905600', '0');
INSERT INTO `ey_archives` VALUES ('77', '3', '', '3', '0', '零钱试玩', '', '/uploads/allimg/c200314/15T15141041E0-11QP.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584151543', '1582905600', '0');
INSERT INTO `ey_archives` VALUES ('78', '3', '', '3', '0', '零用钱', '', '/uploads/allimg/c200314/15T15141411160-1B458.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584151543', '1582905600', '0');
INSERT INTO `ey_archives` VALUES ('79', '3', '', '3', '0', '赚客安卓版', '', '/uploads/allimg/c200314/15T15141N140-22M95.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584151543', '1582905600', '0');
INSERT INTO `ey_archives` VALUES ('80', '3', '', '3', '0', '蛋咖赚钱', '', '/uploads/allimg/c200314/15T150TT52Z-1320X.png', '1', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584151543', '1582905600', '0');
INSERT INTO `ey_archives` VALUES ('81', '3', '', '3', '0', '每日赚点', '', '/uploads/allimg/c200314/15T151424630-5OK.png', '1', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584151543', '1582905600', '0');
INSERT INTO `ey_archives` VALUES ('82', '3', '', '3', '0', '有赚', '', '/uploads/allimg/c200314/15T15142T2250-11X17.jpg', '1', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584151543', '1582905600', '0');
INSERT INTO `ey_archives` VALUES ('83', '3', '', '3', '0', '蛋蛋赚', '', '/uploads/allimg/c200314/15T151440450P-1619D.png', '1', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584151543', '1582905600', '0');
INSERT INTO `ey_archives` VALUES ('84', '3', '', '3', '0', '麦子赚', '', '/uploads/allimg/c200314/15T151446321P-2163J.png', '1', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584151543', '1582905600', '0');
INSERT INTO `ey_archives` VALUES ('85', '3', '', '3', '0', 'iMoney试玩平台', '', '/uploads/allimg/c200314/15T15144T4220-263064.png', '1', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584151543', '1582905600', '0');
INSERT INTO `ey_archives` VALUES ('86', '3', '', '3', '0', '明明乐园', '', '/uploads/allimg/c200314/15T151452460F-5I44.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584151543', '1582905600', '0');
INSERT INTO `ey_archives` VALUES ('87', '3', '', '3', '0', '玩游赚', '', '/uploads/allimg/c200314/15T1514D12a0-15W16.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584151543', '1582905600', '0');
INSERT INTO `ey_archives` VALUES ('88', '3', '', '3', '0', '手赚网官方app', '', '/uploads/allimg/c200314/15T15035609B0-15O03.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '   手赚网APP由手赚网官方出品，支持苹果和安卓手机，提供最新最全的手机兼职赚钱软件下载，最热门苹果手机试玩赚钱平台排行，让你随时随地，轻松赚钱！', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584151543', '1684486856', '0');
INSERT INTO `ey_archives` VALUES ('89', '3', '', '3', '0', '玩赚星球', '', '/uploads/allimg/c200314/15T1514N2D50-242607.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584151543', '1582905600', '0');
INSERT INTO `ey_archives` VALUES ('90', '4', '', '3', '0', '趣头条', '', '/uploads/allimg/c200314/15T15192096450-63949.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584152036', '1572192000', '0');
INSERT INTO `ey_archives` VALUES ('91', '4', '', '3', '0', '泡泡头条', '', '/uploads/allimg/c200314/15T15192315520-113060.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584152036', '1572192000', '0');
INSERT INTO `ey_archives` VALUES ('92', '4', '', '3', '0', '麒麟网', '', '/uploads/allimg/c200314/15T15192516150-163106.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584152036', '1572192000', '0');
INSERT INTO `ey_archives` VALUES ('93', '4', '', '3', '0', '抖音极速版', '', '/uploads/allimg/c200314/15T15192MT10-21OK.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584152036', '1572796800', '0');
INSERT INTO `ey_archives` VALUES ('94', '4', '', '3', '0', '彩蛋视频', '', '/uploads/allimg/c200314/15T1519301b0-2D0a.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584152036', '1573056000', '0');
INSERT INTO `ey_archives` VALUES ('95', '4', '', '3', '0', '贝壳转', '', '/uploads/allimg/c200314/15T15193509360-5KI.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584152036', '1573056000', '0');
INSERT INTO `ey_archives` VALUES ('96', '4', '', '3', '0', '蚂蚁看点', '', '/uploads/allimg/c200314/15T151939493Z-10Z57.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584152036', '1573056000', '0');
INSERT INTO `ey_archives` VALUES ('97', '4', '', '3', '0', '闪电盒子', '', '/uploads/allimg/c200314/15T151941W940-15AH.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584152036', '1573056000', '0');
INSERT INTO `ey_archives` VALUES ('98', '4', '', '3', '0', '看点快报', '', '/uploads/allimg/c200314/15T15194440X0-2055b.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584152036', '1573056000', '0');
INSERT INTO `ey_archives` VALUES ('99', '4', '', '3', '0', '资讯随享', '', '/uploads/allimg/c200314/15T15194S9620-2D622.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584152036', '1573056000', '0');
INSERT INTO `ey_archives` VALUES ('100', '10', '', '3', '0', '99阅读', '', '/uploads/allimg/c200314/15T151TG5510-51317.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584152036', '1684467677', '0');
INSERT INTO `ey_archives` VALUES ('101', '10', '', '3', '0', '有钻石', '', '/uploads/allimg/c200314/15T151Tb1Y0-104424.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584152036', '1684467677', '0');
INSERT INTO `ey_archives` VALUES ('102', '10', '', '3', '0', '66阅读', '', '/uploads/allimg/c200314/15T151U1U340-154630.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584152036', '1684467677', '0');
INSERT INTO `ey_archives` VALUES ('103', '10', '', '3', '0', '2345星球联盟', '', '/uploads/allimg/c200314/15T151U4H1P-204D8.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584152036', '1684467677', '0');
INSERT INTO `ey_archives` VALUES ('104', '4', '', '3', '0', '趣看点', '', '/uploads/allimg/c200314/15T151UU4540-2A364.png', '0', '0', '0', '1', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584152036', '1579536000', '0');
INSERT INTO `ey_archives` VALUES ('105', '10', '', '3', '0', '番茄免费小说', '', '/uploads/allimg/c200314/15T151V3112F-B4G.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584152036', '1684467677', '0');
INSERT INTO `ey_archives` VALUES ('106', '4', '', '3', '0', '满堂福', '', '/uploads/allimg/c200314/15T151VW0H0-1155c.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584152036', '1580486400', '0');
INSERT INTO `ey_archives` VALUES ('107', '4', '', '3', '0', '火山极速版', '', '/uploads/allimg/c200314/15T151W1G5F-1B2J.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584152036', '1582819200', '0');
INSERT INTO `ey_archives` VALUES ('108', '4', '', '3', '0', '番茄小说', '', '/uploads/allimg/c200314/15T151W42110-2143H.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584152036', '1582819200', '0');
INSERT INTO `ey_archives` VALUES ('109', '4', '', '3', '0', '奇迹小说', '', '/uploads/allimg/c200314/15T151WC40Z-2C203.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584152036', '1582819200', '0');
INSERT INTO `ey_archives` VALUES ('110', '4', '', '3', '0', '喜马拉雅极速版', '', '/uploads/allimg/c200314/15T151X155G0-A014.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584152036', '1582819200', '0');
INSERT INTO `ey_archives` VALUES ('111', '4', '', '3', '0', '魔视', '', '/uploads/allimg/c200314/15T151X521V0-124T0.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '1', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584152036', '1582819200', '0');
INSERT INTO `ey_archives` VALUES ('112', '4', '', '3', '0', '大五福', '', '/uploads/allimg/c200314/15T151XM31F-1O491.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '1', '0', '', '0', '', '', '大五福是老平台抢先收旗下最新给力平台，注册送1元，每天有5个小时阅读单价高达6毛，其他时间3毛2每日阅读，永久5元起提现。诚信靠谱涨分快，分享每日热点，好看又赚零钱。还可', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584152036', '1584169631', '0');
INSERT INTO `ey_archives` VALUES ('113', '4', '', '3', '0', '中青看点', '', '/uploads/allimg/c200314/15T151Y03G0-236301.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584152036', '1582819200', '0');
INSERT INTO `ey_archives` VALUES ('114', '4', '', '3', '0', '趣看天下', '', '/uploads/allimg/c200314/15T151Y2Y20-2R130.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584152036', '1582819200', '0');
INSERT INTO `ey_archives` VALUES ('115', '4', '', '3', '0', '抢先收', '', '/uploads/allimg/c200314/15T151YM10-52093.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584152036', '1582819200', '0');
INSERT INTO `ey_archives` VALUES ('116', '4', '', '3', '0', '金刚涨', '', '/uploads/allimg/c200314/15T151Z0261P-119A5.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '1', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584152036', '1582819200', '0');
INSERT INTO `ey_archives` VALUES ('117', '4', '', '3', '0', '快音', '', '/uploads/allimg/c200314/15T151Z313050-1OO2.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584152036', '1582819200', '0');
INSERT INTO `ey_archives` VALUES ('118', '4', '', '3', '0', '西柚资讯', '', '/uploads/allimg/c200314/15T151Z601530-233R2.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '1', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584152036', '1583251200', '0');
INSERT INTO `ey_archives` VALUES ('119', '4', '', '3', '0', '大六顺', '', '/uploads/allimg/c200314/15T15191062430-294a6.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '2', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584152036', '1583942400', '0');
INSERT INTO `ey_archives` VALUES ('120', '22', '', '1', '0', '一码任务平台app是新上线的微信辅助注册赚钱平', '', '/uploads/allimg/200314/1-2003141453220-L.jpg', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', 'admin', '107', '0', '', '0', '', '一码,任务,平台,app,是,新上线,新,上线,的,', '一码任务平台是新上线的微信辅助注册赚钱平台，在一码任务辅助平台软件使用自己的微信，帮别人辅助注册微信就能轻松获得收益，并非解封类任务，操作简单，安全可靠，每天大量', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584152986', '1684318219', '0');
INSERT INTO `ey_archives` VALUES ('150', '32', '', '7', '0', '摸鱼小游戏', '', '/uploads/allimg/20230518/1-23051Q04Q1138.jpg', '0', '0', '0', '0', '0', '1', '0', '0', '0', '网络', '小编', '794', '0', '', '0', '', '', '是不是经常感觉枯燥乏味的工作让人很烦恼呢？一直工作大脑的专注度会下降，所以适当的摸鱼也是能够提升工作效率的~小编为你整理了一些非常休闲有趣的摸鱼小游戏，画风温馨治愈，并且都是很轻松的，随时都能够开始玩，随时都可以暂停，完全不用担心被领导发现，快来下载摸大鱼~', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1684378082', '1684399918', '0');
INSERT INTO `ey_archives` VALUES ('149', '32', '', '7', '0', '奇迹游戏', '', '/uploads/allimg/20230518/1-23051Q04512Z7.jpg', '0', '0', '0', '0', '0', '1', '0', '0', '0', '网络', '小编', '756', '0', '', '0', '', '', '我们为您提供第一手热门奇迹手游下载，海量华丽奇迹对战手游，重温经典奇迹MU时代战斗，感受魅力十足的奇迹对决，超多奇迹手游一网打尽，一起来我们下载吧！', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1684377907', '1684399918', '0');
INSERT INTO `ey_archives` VALUES ('148', '32', '', '7', '0', '有趣游戏', '', '/uploads/allimg/20230518/1-23051Q02946247.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '网络', '小编', '1023', '0', '', '0', '', '', '轻松的游戏模式游戏基于休闲风格游戏的主题。玩家可以体验到更多的挑战和更多等待玩家体验的有趣内容。这里有各种有趣的游戏和独立的游戏列表让你随时随地都能感受到有趣的游戏。玩家可以选择不同类型的游戏，纸牌游戏，棋盘游戏，战略游戏，射击游戏，拼图游戏等。只要你想玩，在这里都能找到，在这些游戏中，玩家可以回顾经典，回顾过去经典游戏的乐趣，让你的空闲时间更有趣。这个合集提供了一些有趣和放', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1684376967', '1684399918', '0');
INSERT INTO `ey_archives` VALUES ('130', '22', '', '1', '0', '恐龙有钱游戏每天免费送出10万只口罩 硬核回馈', '', '/uploads/allimg/200314/1-2003141112190-L.jpg', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', 'admin', '146', '0', '', '0', '', '恐龙,有钱,游戏,每天,免费,送出,万只,口罩,', '我试了下，真的领到口罩了!某公司员工小李在朋友圈发了条消息，他本来还在为复工后上下班路上的安全问题忧心忡忡，现在晒出了自己在恐龙有钱APP上免费领取的口罩，急着要把喜悦', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584170366', '1684318219', '0');
INSERT INTO `ey_archives` VALUES ('131', '22', '', '1', '0', '大六顺，抢先收金刚涨旗下实力新平台，转发单', '', '/uploads/allimg/200314/1-2003141451460-L.jpg', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', 'admin', '203', '0', '', '0', '', '大,六顺,抢先,收,金刚,涨,旗下,实力,新平台,', '大六顺，2020年3月12日周四上午上线的实力新平台， 抢先收、金刚涨旗下隆重推出的强力新平台大六顺！ 转发单价3毛2，高价时段6毛（每天早8-9点、中午13-14点、晚18-19点），其余时段', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584170424', '1684318219', '0');
INSERT INTO `ey_archives` VALUES ('132', '22', '', '1', '0', '小龙虾大亨一个类似皮皮虾传奇的养殖得分红虾', '', '/uploads/allimg/200314/1-2003141449480-L.jpg', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', 'admin', '101', '0', '', '0', '', '小,龙虾,大亨,一个,类似,皮皮,虾,传奇,的,小,', '小龙虾大亨项目（类似皮皮虾传奇和世界农场），更新稳定，收益稳定，团队稳定。加入项目，轻松赚，零风险，快钱大钱两手抓！零撸！无需实名！每升1级都可以抽奖，6级、16级、', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584170472', '1684318219', '0');
INSERT INTO `ey_archives` VALUES ('133', '22', '', '1', '0', '猫咪小屋真的能提现吗，一款轻松赚钱的养成类', '', '/uploads/allimg/200314/1-2003141446450-L.jpg', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', 'admin', '191', '0', '', '0', '', '猫咪,小屋,真的,能提,现吗,一款,轻松,赚钱,的,', '猫咪小屋红包版是一款能萌翻你的可爱模拟养猫来轻松赚钱小游戏。猫咪小屋里面的小猫有不同的品种分为不同等级，想要获得更高等级的猫咪需要将两只同等级的猫合成，支持安卓和', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584170539', '1684318219', '0');
INSERT INTO `ey_archives` VALUES ('136', '22', '', '1', '0', '哆啦赚是真的能挣钱吗？详细解读哆啦赚是不是', '', '/uploads/allimg/200314/1-2003141451460-L.jpg', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', 'admin', '152', '0', '', '0', '', '哆啦,赚,是,真的,能,挣钱,吗,详细,解读,哆啦,', '哆啦赚是一个可以在手机上做任务赚钱的软件，上线已经一段时间，目前整体上发展的还不错。不过由于是一个新出不久的悬赏任务平台。很多人对哆啦赚是真的吗，能不能赚钱还持有', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584195123', '1684463367', '0');
INSERT INTO `ey_archives` VALUES ('137', '22', '', '1', '0', '招行APP申领电子社保卡抽666元现金红包，100%有礼', '', '/uploads/allimg/200314/1-2003141453220-L.jpg', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', 'admin', '93', '0', '', '0', '', '招行,APP,申领,电子,社保,卡抽,666元,现金,红包,', '招行APP申领电子社保卡享好礼，红包送不停。活动期间，登陆招商APP - 便民服务 - 电子社保卡，按步骤完成首次申领，即可参与抽奖，最高可抽取666元现金红包，可直接提现到银行卡。', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584195161', '1684318219', '0');
INSERT INTO `ey_archives` VALUES ('138', '22', '', '1', '0', '哈灵斗地主免费新手红包1.5元，每天斗地主领元', '', '/uploads/allimg/200314/1-2003141453220-L.jpg', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', 'admin', '90', '0', '', '0', '', '哈灵,斗地主,免费,新手,红包,1.5元,每天,领元,', '哈灵斗地主，每天玩斗地主游戏领红包，每玩一局游戏都有数额不等的元宝免费领，元宝可兑换微信现金红包，上不封顶。此外还有新用户专属福利，2天赢6局赚1.5元，1元就能提现秒到', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1584195206', '1684318219', '0');
INSERT INTO `ey_archives` VALUES ('140', '18', '', '6', '0', '关于我们', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1684309129', '1684309129', '0');
INSERT INTO `ey_archives` VALUES ('141', '19', '', '6', '0', '帮助中心', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1684309138', '1684309138', '0');
INSERT INTO `ey_archives` VALUES ('142', '20', '', '6', '0', '免责声明', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1684309143', '1684309143', '0');
INSERT INTO `ey_archives` VALUES ('143', '21', '', '6', '0', '广告合作', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1684309148', '1684309148', '0');
INSERT INTO `ey_archives` VALUES ('144', '23', '', '1', '0', '崩坏星穹铁道找到藏起来的鼹鼠党成员攻略', '', '/uploads/allimg/20230518/1-23051P91521X2.jpg', '0', '0', '0', '0', '0', '1', '0', '0', '0', '网络', '小编', '582', '0', '', '0', '', '', '今天小编给大家带来的是崩坏星穹铁道找到藏起来的鼹鼠党成员攻略，很多玩家不知道这个两个藏起来的鼹鼠党成员在哪，怎样才能找到他们两个人呢？毕竟是主线任务，想知道怎么完成的玩家往下看看下面小编给大家带来的位置介绍吧。', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1684372513', '1684372513', '0');
INSERT INTO `ey_archives` VALUES ('145', '28', '', '6', '0', '联系我们', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1684375851', '0', '0');
INSERT INTO `ey_archives` VALUES ('146', '29', '', '6', '0', '家长监护', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1684375860', '0', '0');
INSERT INTO `ey_archives` VALUES ('147', '30', '', '6', '0', '纠纷处理', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1684375874', '0', '0');
INSERT INTO `ey_archives` VALUES ('151', '32', '', '7', '0', '高爆传奇', '', '/uploads/allimg/20230518/1-23051Q04SB43.jpg', '0', '0', '0', '0', '0', '1', '0', '0', '0', '网络', '小编', '760', '0', '', '0', '', '', '传奇高爆版顾名思义就是爆率比一般传奇要高出很多倍的一种传奇游戏。在这种传奇当中玩家光靠打怪就可以收获非常多的资源，包括但不仅限于金币、经验值、强化和锻造材料、各种凭证。那么，市面上好玩的高爆传奇版游戏有哪些呢？今天下载王小编芒果味的怪咖特意给大家搜集整理了相关传奇高爆版本大全游戏合集，希望大家喜欢前来下载体验！', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1684378104', '1684399918', '0');

-- -----------------------------
-- Table structure for `ey_archives_flag`
-- -----------------------------
DROP TABLE IF EXISTS `ey_archives_flag`;
CREATE TABLE `ey_archives_flag` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `flag_name` varchar(255) NOT NULL DEFAULT '' COMMENT '文档属性名称',
  `flag_attr` varchar(10) NOT NULL DEFAULT '' COMMENT '属性值',
  `flag_fieldname` varchar(255) NOT NULL DEFAULT '' COMMENT '字段名',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态， 1---显示， 0---隐藏',
  `sort_order` int(11) unsigned NOT NULL DEFAULT '0',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `flag_attr` (`flag_attr`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COMMENT='文档属性配置表';

-- -----------------------------
-- Records of `ey_archives_flag`
-- -----------------------------
INSERT INTO `ey_archives_flag` VALUES ('1', '头条', 'h', 'is_head', '1', '1', 'cn', '1606272350', '1606272350');
INSERT INTO `ey_archives_flag` VALUES ('2', '推荐', 'c', 'is_recom', '1', '2', 'cn', '1606272350', '1606272350');
INSERT INTO `ey_archives_flag` VALUES ('3', '加推', 'a', 'is_special', '1', '3', 'cn', '1606272350', '1606272350');
INSERT INTO `ey_archives_flag` VALUES ('4', '标粗', 'b', 'is_b', '1', '4', 'cn', '1606272350', '1606272350');
INSERT INTO `ey_archives_flag` VALUES ('5', '有图', 'p', 'is_litpic', '1', '5', 'cn', '1606272350', '1606272350');
INSERT INTO `ey_archives_flag` VALUES ('6', '外链', 'j', 'is_jump', '1', '6', 'cn', '1606272350', '1606272350');
INSERT INTO `ey_archives_flag` VALUES ('7', '轮播', 's', 'is_slide', '1', '7', 'cn', '1606272350', '1684397316');
INSERT INTO `ey_archives_flag` VALUES ('8', '滚动', 'r', 'is_roll', '0', '8', 'cn', '1606272350', '1606272350');
INSERT INTO `ey_archives_flag` VALUES ('9', '热文', 'd', 'is_diyattr', '0', '9', 'cn', '1606272350', '1606272350');

-- -----------------------------
-- Table structure for `ey_arcmulti`
-- -----------------------------
DROP TABLE IF EXISTS `ey_arcmulti`;
CREATE TABLE `ey_arcmulti` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `tagid` varchar(60) NOT NULL DEFAULT '' COMMENT '标签ID',
  `tagname` varchar(60) NOT NULL DEFAULT '' COMMENT '标签名',
  `innertext` text NOT NULL COMMENT '标签模板代码',
  `pagesize` int(10) NOT NULL DEFAULT '0' COMMENT '分页列表',
  `querysql` text NOT NULL COMMENT '完整SQL',
  `ordersql` varchar(200) DEFAULT '' COMMENT '排序SQL',
  `addfieldsSql` varchar(255) DEFAULT '' COMMENT '附加字段SQL',
  `addtableName` varchar(50) DEFAULT '' COMMENT '附加字段的数据表，不包含表前缀',
  `attstr` text COMMENT '属性字符串',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='多页标记存储数据表';


-- -----------------------------
-- Table structure for `ey_arcrank`
-- -----------------------------
DROP TABLE IF EXISTS `ey_arcrank`;
CREATE TABLE `ey_arcrank` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '权限ID',
  `rank` smallint(6) DEFAULT '0' COMMENT '权限值',
  `name` char(20) DEFAULT '' COMMENT '会员名称',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='文档阅读权限表';

-- -----------------------------
-- Records of `ey_arcrank`
-- -----------------------------
INSERT INTO `ey_arcrank` VALUES ('1', '0', '开放浏览', 'cn', '0', '1552376880');
INSERT INTO `ey_arcrank` VALUES ('2', '-1', '待审核稿件', 'cn', '0', '1552376880');

-- -----------------------------
-- Table structure for `ey_arctype`
-- -----------------------------
DROP TABLE IF EXISTS `ey_arctype`;
CREATE TABLE `ey_arctype` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '栏目ID',
  `channeltype` int(10) DEFAULT '0' COMMENT '栏目顶级模型ID',
  `current_channel` int(10) DEFAULT '0' COMMENT '栏目当前模型ID',
  `parent_id` int(10) DEFAULT '0' COMMENT '栏目上级ID',
  `topid` int(10) DEFAULT '0' COMMENT '顶级栏目ID',
  `typename` varchar(200) DEFAULT '' COMMENT '栏目名称',
  `dirname` varchar(200) DEFAULT '' COMMENT '目录英文名',
  `dirpath` varchar(200) DEFAULT '' COMMENT '目录存放HTML路径',
  `diy_dirpath` varchar(200) DEFAULT '' COMMENT '列表静态文件存放规则',
  `rulelist` varchar(200) DEFAULT '' COMMENT '列表静态文件存放规则',
  `ruleview` varchar(200) DEFAULT '' COMMENT '文档静态文件存放规则',
  `englist_name` varchar(200) DEFAULT '' COMMENT '栏目英文名',
  `grade` tinyint(1) DEFAULT '0' COMMENT '栏目等级',
  `typelink` varchar(200) DEFAULT '' COMMENT '栏目链接',
  `litpic` varchar(250) DEFAULT '' COMMENT '栏目图片',
  `templist` varchar(200) DEFAULT '' COMMENT '列表模板文件名',
  `tempview` varchar(200) DEFAULT '' COMMENT '文档模板文件名',
  `seo_title` varchar(200) DEFAULT '' COMMENT 'SEO标题',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT 'seo关键字',
  `seo_description` text COMMENT 'seo描述',
  `sort_order` int(10) DEFAULT '0' COMMENT '排序号',
  `is_hidden` tinyint(1) DEFAULT '0' COMMENT '是否隐藏栏目：0=显示，1=隐藏',
  `is_part` tinyint(1) DEFAULT '0' COMMENT '栏目属性：0=内容栏目，1=外部链接',
  `admin_id` int(10) DEFAULT '0' COMMENT '管理员ID',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '伪删除，1=是，0=否',
  `del_method` tinyint(1) DEFAULT '0' COMMENT '伪删除状态，1为主动删除，2为跟随上级栏目被动删除',
  `status` tinyint(1) DEFAULT '1' COMMENT '启用 (1=正常，0=屏蔽)',
  `is_release` tinyint(1) DEFAULT '0' COMMENT '栏目是否应用于会员投稿发布，1是，0否',
  `weapp_code` varchar(50) DEFAULT '' COMMENT '插件栏目唯一标识',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `target` tinyint(1) DEFAULT '0' COMMENT '新窗口打开',
  `nofollow` tinyint(1) DEFAULT '0' COMMENT '防抓取',
  `typearcrank` int(10) DEFAULT '0' COMMENT '阅读权限：0=开放浏览，-1=待审核稿件',
  `empty_logic` tinyint(1) DEFAULT '0' COMMENT '空内容逻辑',
  PRIMARY KEY (`id`),
  UNIQUE KEY `dirname` (`dirname`,`lang`) USING BTREE,
  KEY `parent_id` (`channeltype`,`parent_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=34 DEFAULT CHARSET=utf8 COMMENT='文档栏目表';

-- -----------------------------
-- Records of `ey_arctype`
-- -----------------------------
INSERT INTO `ey_arctype` VALUES ('1', '3', '3', '0', '0', '苹果赚钱', 'ios', '/ios', '/ios', '{栏目目录}/list_{tid}_{page}.html', '{栏目目录}/{aid}.html', '', '0', '', '', 'lists_images.htm', 'view_images.htm', '苹果赚钱', '', '', '1', '0', '0', '1', '0', '0', '1', '1', '', 'cn', '1641347762', '1641365163', '0', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('2', '3', '3', '0', '0', '手机兼职', 'shouji', '/shouji', '/shouji', '{栏目目录}/list_{tid}_{page}.html', '{栏目目录}/{aid}.html', '', '0', '', '', 'lists_images.htm', 'view_images.htm', '手机赚钱', '', '', '2', '0', '0', '1', '0', '0', '1', '1', '', 'cn', '1641347762', '1641365163', '0', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('3', '3', '3', '0', '0', '安卓赚钱', 'android', '/android', '/android', '{栏目目录}/list_{tid}_{page}.html', '{栏目目录}/{aid}.html', '', '0', '', '', 'lists_images.htm', 'view_images.htm', '安卓赚钱', '', '', '3', '0', '0', '1', '0', '0', '1', '1', '', 'cn', '1641347762', '1641365163', '0', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('4', '3', '3', '0', '0', '阅读赚钱', 'yuedu', '/yuedu', '/yuedu', '{栏目目录}/list_{tid}_{page}.html', '{栏目目录}/{aid}.html', '', '0', '', '', 'lists_images.htm', 'view_images.htm', '兼职赚钱', '', '', '4', '0', '0', '1', '0', '0', '1', '1', '', 'cn', '1641347762', '1641365163', '0', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('5', '1', '1', '0', '0', '手赚资讯', 'news', '/news', '/news', '{栏目目录}/list_{tid}_{page}.html', '{栏目目录}/{aid}.html', '', '0', '', '', 'lists_article.htm', 'view_article.htm', '福利线报', '', '', '5', '0', '0', '1', '0', '0', '1', '1', '', 'cn', '1641347762', '1641368343', '0', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('6', '3', '3', '0', '0', '排行版', 'paihangbang', '/paihangbang', '/update', '{栏目目录}/list_{tid}_{page}.html', '{栏目目录}/{aid}.html', '', '0', '', '', 'lists_images_zx.htm', 'view_images.htm', '最新手赚', '', '', '6', '0', '0', '1', '0', '0', '1', '1', '', 'cn', '1641347762', '1684373238', '0', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('10', '3', '3', '1', '1', '理财购物', 'licaigouwu', '/ios/licaigouwu', '/ios/licaigouwu', '{栏目目录}/list_{tid}_{page}.html', '{栏目目录}/{aid}.html', '', '1', '', '', 'lists_images.htm', 'view_images.htm', '', '', '', '100', '0', '0', '1', '0', '0', '1', '0', '', 'cn', '1684305334', '1684305334', '0', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('11', '3', '3', '1', '1', '角色扮演', 'jiaosebanyan', '/ios/jiaosebanyan', '/ios/jiaosebanyan', '{栏目目录}/list_{tid}_{page}.html', '{栏目目录}/{aid}.html', '', '1', '', '', 'lists_images.htm', 'view_images.htm', '', '', '', '100', '0', '0', '1', '0', '0', '1', '0', '', 'cn', '1684305999', '1684305999', '0', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('12', '3', '3', '1', '1', '动作格斗', 'dongzuogedou', '/ios/dongzuogedou', '/ios/dongzuogedou', '{栏目目录}/list_{tid}_{page}.html', '{栏目目录}/{aid}.html', '', '1', '', '', 'lists_images.htm', 'view_images.htm', '', '', '', '100', '0', '0', '1', '0', '0', '1', '0', '', 'cn', '1684306010', '1684306010', '0', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('13', '3', '3', '1', '1', '休闲益智', 'xiuxianyizhi', '/ios/xiuxianyizhi', '/ios/xiuxianyizhi', '{栏目目录}/list_{tid}_{page}.html', '{栏目目录}/{aid}.html', '', '1', '', '', 'lists_images.htm', 'view_images.htm', '', '', '', '100', '0', '0', '1', '0', '0', '1', '0', '', 'cn', '1684306022', '1684306022', '0', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('14', '3', '3', '2', '2', '社交聊天', 'shejiaoliaotian', '/shouji/shejiaoliaotian', '/shouji/shejiaoliaotian', '{栏目目录}/list_{tid}_{page}.html', '{栏目目录}/{aid}.html', '', '1', '', '', 'lists_images.htm', 'view_images.htm', '', '', '', '100', '0', '0', '1', '0', '0', '1', '0', '', 'cn', '1684307645', '1684307645', '0', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('15', '3', '3', '2', '2', '系统工具', 'xitonggongju', '/shouji/xitonggongju', '/shouji/xitonggongju', '{栏目目录}/list_{tid}_{page}.html', '{栏目目录}/{aid}.html', '', '1', '', '', 'lists_images.htm', 'view_images.htm', '', '', '', '100', '0', '0', '1', '0', '0', '1', '0', '', 'cn', '1684307652', '1684307652', '0', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('16', '3', '3', '2', '2', '数字金融', 'shuzijinrong', '/shouji/shuzijinrong', '/shouji/shuzijinrong', '{栏目目录}/list_{tid}_{page}.html', '{栏目目录}/{aid}.html', '', '1', '', '', 'lists_images.htm', 'view_images.htm', '', '', '', '100', '0', '0', '1', '0', '0', '1', '0', '', 'cn', '1684307660', '1684307660', '0', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('17', '3', '3', '2', '2', '旅游出行', 'lvyouchuxing', '/shouji/lvyouchuxing', '/shouji/lvyouchuxing', '{栏目目录}/list_{tid}_{page}.html', '{栏目目录}/{aid}.html', '', '1', '', '', 'lists_images.htm', 'view_images.htm', '', '', '', '100', '0', '0', '1', '0', '0', '1', '0', '', 'cn', '1684307664', '1684307664', '0', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('18', '1', '6', '0', '0', '关于我们', 'guanyuwomen', '/guanyuwomen', '/guanyuwomen', '{栏目目录}/index.html', '{栏目目录}/{aid}.html', '', '0', '', '', 'lists_single.htm', '', '', '', '', '8', '0', '0', '1', '0', '0', '1', '0', '', 'cn', '1684308836', '1684376029', '0', '0', '0', '1');
INSERT INTO `ey_arctype` VALUES ('19', '1', '6', '18', '18', '帮助中心', 'bangzhuzhongxin', '/guanyuwomen/bangzhuzhongxin', '', '{栏目目录}/index.html', '{栏目目录}/{aid}.html', '', '1', '', '', 'lists_single.htm', '', '', '', '', '100', '0', '0', '1', '0', '0', '1', '0', '', 'cn', '1684308836', '1684375590', '0', '0', '0', '1');
INSERT INTO `ey_arctype` VALUES ('20', '1', '6', '18', '18', '免责声明', 'mianzeshengming', '/guanyuwomen/mianzeshengming', '', '{栏目目录}/index.html', '{栏目目录}/{aid}.html', '', '1', '', '', 'lists_single.htm', '', '', '', '', '100', '0', '0', '1', '0', '0', '1', '0', '', 'cn', '1684308836', '1684375417', '0', '0', '0', '1');
INSERT INTO `ey_arctype` VALUES ('21', '1', '6', '18', '18', '广告合作', 'guanggaohezuo', '/guanyuwomen/guanggaohezuo', '', '{栏目目录}/index.html', '{栏目目录}/{aid}.html', '', '1', '', '', 'lists_single.htm', '', '', '', '', '100', '0', '0', '1', '0', '0', '1', '0', '', 'cn', '1684308836', '1684375275', '0', '0', '0', '1');
INSERT INTO `ey_arctype` VALUES ('22', '1', '1', '5', '5', '游戏攻略', 'youxigonglue', '/news/youxigonglue', '/news/youxigonglue', '{栏目目录}/list_{tid}_{page}.html', '{栏目目录}/{aid}.html', '', '1', '', '', 'lists_article.htm', 'view_article.htm', '', '', '', '100', '0', '0', '1', '0', '0', '1', '0', '', 'cn', '1684318203', '1684318203', '0', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('23', '1', '1', '5', '5', '游戏资讯', 'youxizixun', '/news/youxizixun', '/news/youxizixun', '{栏目目录}/list_{tid}_{page}.html', '{栏目目录}/{aid}.html', '', '1', '', '', 'lists_article.htm', 'view_article.htm', '', '', '', '100', '0', '0', '1', '0', '0', '1', '0', '', 'cn', '1684318212', '1684318212', '0', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('24', '3', '3', '6', '6', '人气榜', 'renqibang', '/paihangbang/renqibang', '/paihangbang/renqibang', '{栏目目录}/list_{tid}_{page}.html', '{栏目目录}/{aid}.html', '', '1', '', '/uploads/allimg/20230518/1-23051P92023F3.jpg', 'lists_images_bang.htm', 'view_images.htm', '', '', '', '100', '0', '0', '1', '0', '0', '1', '0', '', 'cn', '1684372239', '1684373238', '0', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('25', '3', '3', '6', '6', '飙升榜', 'biaoshengbang', '/paihangbang/biaoshengbang', '/paihangbang/biaoshengbang', '{栏目目录}/list_{tid}_{page}.html', '{栏目目录}/{aid}.html', '', '1', '', '/uploads/allimg/20230518/1-23051P92034K0.jpg', 'lists_images_bang.htm', 'view_images.htm', '', '', '', '100', '0', '0', '1', '0', '0', '1', '0', '', 'cn', '1684372247', '1684373238', '0', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('26', '3', '3', '6', '6', '期待榜', 'qidaibang', '/paihangbang/qidaibang', '/paihangbang/qidaibang', '{栏目目录}/list_{tid}_{page}.html', '{栏目目录}/{aid}.html', '', '1', '', '', 'lists_images_bang.htm', 'view_images.htm', '', '', '', '100', '0', '0', '1', '0', '0', '1', '0', '', 'cn', '1684372254', '1684373238', '0', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('27', '3', '3', '6', '6', '热玩榜', 'rewanbang', '/paihangbang/rewanbang', '/paihangbang/rewanbang', '{栏目目录}/list_{tid}_{page}.html', '{栏目目录}/{aid}.html', '', '1', '', '', 'lists_images_bang.htm', 'view_images.htm', '', '', '', '100', '0', '0', '1', '0', '0', '1', '0', '', 'cn', '1684372260', '1684373238', '0', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('28', '1', '6', '18', '18', '联系我们', 'lianxiwomen', '/guanyuwomen/lianxiwomen', '/guanyuwomen/lianxiwomen', '{栏目目录}/index.html', '{栏目目录}/{aid}.html', '', '1', '', '', 'lists_single.htm', '', '', '', '', '100', '0', '0', '1', '0', '0', '1', '0', '', 'cn', '1684375851', '1684375851', '0', '0', '0', '1');
INSERT INTO `ey_arctype` VALUES ('29', '1', '6', '18', '18', '家长监护', 'jiachangjianhu', '/guanyuwomen/jiachangjianhu', '/guanyuwomen/jiachangjianhu', '{栏目目录}/index.html', '{栏目目录}/{aid}.html', '', '1', '', '', 'lists_single.htm', '', '', '', '', '100', '0', '0', '1', '0', '0', '1', '0', '', 'cn', '1684375860', '1684375860', '0', '0', '0', '1');
INSERT INTO `ey_arctype` VALUES ('30', '1', '6', '18', '18', '纠纷处理', 'jiufenchuli', '/guanyuwomen/jiufenchuli', '/guanyuwomen/jiufenchuli', '{栏目目录}/index.html', '{栏目目录}/{aid}.html', '', '1', '', '', 'lists_single.htm', '', '', '', '', '100', '0', '0', '1', '0', '0', '1', '0', '', 'cn', '1684375874', '1684375874', '0', '0', '0', '1');
INSERT INTO `ey_arctype` VALUES ('31', '7', '7', '0', '0', '专题大全', 'zhuantidaquan', '/zhuantidaquan', '/zhuantidaquan', '{栏目目录}/list_{tid}_{page}.html', '{栏目目录}/{aid}.html', '', '0', '', '', 'lists_special.htm', 'view_special.htm', '', '', '', '7', '0', '0', '1', '0', '0', '1', '0', '', 'cn', '1684376012', '1684376027', '0', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('32', '7', '7', '31', '31', '手游专题', 'shouyouzhuanti', '/zhuantidaquan/shouyouzhuanti', '/zhuantidaquan/shouyouzhuanti', '{栏目目录}/list_{tid}_{page}.html', '{栏目目录}/{aid}.html', '', '1', '', '', 'lists_special.htm', 'view_special.htm', '', '', '', '100', '0', '0', '1', '0', '0', '1', '0', '', 'cn', '1684399904', '1684399904', '0', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('33', '7', '7', '31', '31', '应用专题', 'yingyongzhuanti', '/zhuantidaquan/yingyongzhuanti', '/zhuantidaquan/yingyongzhuanti', '{栏目目录}/list_{tid}_{page}.html', '{栏目目录}/{aid}.html', '', '1', '', '', 'lists_special.htm', 'view_special.htm', '', '', '', '100', '0', '0', '1', '0', '0', '1', '0', '', 'cn', '1684399911', '1684399911', '0', '0', '0', '0');

-- -----------------------------
-- Table structure for `ey_article17_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_article17_content`;
CREATE TABLE `ey_article17_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `content` longtext COMMENT '文章内容',
  `vrdz` varchar(251) NOT NULL DEFAULT '' COMMENT '全景地址',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COMMENT='附加表';

-- -----------------------------
-- Records of `ey_article17_content`
-- -----------------------------
INSERT INTO `ey_article17_content` VALUES ('1', '34', '1635217270', '1635217270', '富力湾海南富力湾与夏威夷、加勒比海、巴厘岛这些世界著名的旅游胜地同在一条黄金北纬18&amp;deg;上，是富力集团在海南布局的唯一一个高端热带滨海休闲度假社区，且紧邻亚洲大型海洋主题公园-富力湾海洋欢乐世界，轻松享有休闲惬意的度假生活。', 'https://720yun.com/t/83vkuwrw01w?scene_id=40544503');
INSERT INTO `ey_article17_content` VALUES ('2', '35', '1635217270', '1635217270', '合景汀澜海岸凝萃合景泰富17年国际豪宅开发经验而倾力打造的旅游地产新作，抢占国际旅游岛未来高端的珍珠海岸核心区位，荟萃众多奢侈度假配套。更携手大师团队定制一线海幕豪宅，在这里找到如塞舌尔般的私密海岸天堂。', 'https://720yun.com/t/80vkc72wdpe?scene_id=64311939');
INSERT INTO `ey_article17_content` VALUES ('3', '36', '1635217270', '1635217270', '&amp;ldquo;海棠华着&amp;rdquo;位于中国三亚海棠湾-中国国家海岸，三亚海棠湾海棠北路18号（凯宾斯基酒店旁），项目占地面积为29.3万平米，容积率0.4，绿化率62.2%，地上建筑面积约12万平米，一共分为三期开发，一期为174套别墅产品，主力户型为约300-400平米（使用面积）的院落别墅户型，是三亚一线临海别墅群，配建拥有百年历史的华尔道夫酒店，该酒店素有&amp;ldquo;总统行宫&amp;rdquo;的称号。', 'https://720yun.com/t/58vkc72l5iq?scene_id=64260374');
INSERT INTO `ey_article17_content` VALUES ('4', '37', '1635217270', '1635217270', '融创日月湾，拥有目前海南的北纬 18&amp;deg;绝品度假双岛。日月湾旅游度假区总规划面积约3.45万亩，，日月岛合计约 1492 亩，其中日岛约 840亩，总建筑面积约 76 万㎡，建筑密度 16.5%，绿化率高达 52%。从日月湾高速出口至项目1500米路程，途经滨海大道，可以一览日月湾迷人的滨海风光。经过与陆地连接的日岛跨海大桥，可以领略别样的海岛风情。&amp;nbsp;', 'https://720yun.com/t/83vkuwrw01w?scene_id=40544503');
INSERT INTO `ey_article17_content` VALUES ('5', '38', '1635217270', '1635217270', '臻园一期&amp;bull;洋房概况：前期共推出108套洋房，总高6层，一梯两户，建筑面积75平，2房2厅一厨一卫两阳台，得房率高，性价比高。板楼设计，通透户型，双阳台设计，带品质精装，满足你的度假、投资的双重需求。海南第一个温泉度假区，东南亚异域风情小镇，侨乡之城，享受成熟的商业配套和淳朴的小镇风情。', 'https://720yun.com/t/3fvkumqh5ib?scene_id=42183767');
INSERT INTO `ey_article17_content` VALUES ('6', '39', '1635217270', '1635217270', '万科海上大都会左岸项目位于三亚市城央湾区三亚湾，南临20公里椰梦长廊，步行200米即可畅享沙滩大海。三亚湾路和新城路围绕在项目南北两侧，与三亚市核心干道凤凰路、规划核心干道三横路毗邻。导航距离凤凰机场约6公里，导航距离三亚动车站约8公里。周边有多条公交及旅游线路，直达海棠湾免税城，亚龙湾，大小洞天，城市乐园等，交通四通八达，非常便利。', 'https://720yun.com/t/2fvkc7phzr9?scene_id=64241384');
INSERT INTO `ey_article17_content` VALUES ('7', '40', '1635217270', '1635217270', '梦幻不夜城，蜈支洲岛，南田温泉，水稻国家公园，海中海高尔夫，亚特兰蒂斯水上乐园等。', 'https://720yun.com/t/05vku72b7ql?scene_id=40965268');
INSERT INTO `ey_article17_content` VALUES ('8', '41', '1635217270', '1635217270', '龙栖海岸位于海南&amp;middot;大三亚&amp;middot;龙栖湾，龙栖湾滨海旅游度假区，由海南中城投开发建设。北纬18&amp;deg;以南，307亩观海大城，南北通透两梯两户。56㎡海豚大阳台，拥16公里龙栖湾首栖霞海岸，观海阅山，不负盛景。邻南中国海上文旅基地、南繁基地、万豪酒店。项目釆用两梯两户纯板式洋房设计，户型设计合理，全明格局，公摊少、采光足、南北通透，电梯入户。', 'https://720yun.com/t/5bvkcy1ygdl?scene_id=62651738');

-- -----------------------------
-- Table structure for `ey_article_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_article_content`;
CREATE TABLE `ey_article_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `content` longtext COMMENT '内容详情',
  `content_ey_m` longtext COMMENT '手机端内容详情',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `news_id` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COMMENT='资讯内容表_存储正常内容';

-- -----------------------------
-- Records of `ey_article_content`
-- -----------------------------
INSERT INTO `ey_article_content` VALUES ('1', '120', '&lt;div&gt;\r\n	一码任务平台是新上线的微信辅助注册赚钱平台，在一码任务辅助平台软件使用自己的微信，帮别人辅助注册微信就能轻松获得收益，并非解封类任务，操作简单，安全可靠，每天大量注册单等你来做，任务单价8元起，一个微信号一年最多可以做3次辅助任务！&lt;/div&gt;\r\n&lt;div&gt;\r\n	&amp;nbsp;&lt;/div&gt;\r\n&lt;div&gt;\r\n	一码任务平台奖励制度&lt;/div&gt;\r\n&lt;div&gt;\r\n	一码三月官方扶持政策，3月4号开始，一码平台接单出台史上最强代理扶持政策。&lt;/div&gt;\r\n&lt;div&gt;\r\n	1、无门槛，合伙人单单最低奖励2元&lt;/div&gt;\r\n&lt;div&gt;\r\n	2、合伙人破2500单奖励2.5元一旦，破5000单奖励3元1单&lt;/div&gt;\r\n&lt;div&gt;\r\n	3、成功率模式已完善，细节已经基本处理完毕，成功率大幅度提升&lt;/div&gt;\r\n&lt;div&gt;\r\n	4、源源不断的订单后台。&lt;/div&gt;\r\n&lt;div&gt;\r\n	&amp;nbsp;&lt;/div&gt;\r\n&lt;div&gt;\r\n	一码任务暂时还没有上线App和固定码，所以，大家注册后用网页登录即可。一码任务平台跟其他平台差不多，注册完成后登录在【任务首页】选择【国外不填】即可接单赚钱。&lt;/div&gt;\r\n&lt;div&gt;\r\n	&amp;nbsp;&lt;/div&gt;\r\n&lt;div&gt;\r\n	操作说明：&lt;/div&gt;\r\n&lt;div&gt;\r\n	&amp;nbsp;&lt;/div&gt;\r\n&lt;div&gt;\r\n	1、接单扫码辅助任务流程很简单，进入平台后，先设置好自己接单的省份，选择本省的订单，可以减少填写资料的几率，国外单基本是不填写。设置好以后，就可以接单赚钱了。接了订单以后，会显示一个二维码，然后用微信号扫码确认就行了，辅助注册的整个流程10秒搞定&lt;/div&gt;\r\n&lt;div&gt;\r\n	&amp;nbsp;&lt;/div&gt;\r\n&lt;div&gt;\r\n	2、如果你不会操作的话，可以点击【个人中心】打开【常见问题】，可以先学习一下详细的接单流程，等熟悉之后再去接单赚钱，这样就可以尽量避免失败率过高的问题。&lt;/div&gt;\r\n&lt;div&gt;\r\n	&amp;nbsp;&lt;/div&gt;\r\n&lt;div&gt;\r\n	3、需要注意的是，一个微信号一年中智能辅助三次，辅助第一次跟第二次要间隔1个月。所以，操作这类平台想要多赚钱的话，可以去地推或者在悬赏任务平台中发单，我们赚差价。如果地推的话，大家可以去批发一些小玩意回来送人，这样的话，很多人都愿意扫你的码！&lt;/div&gt;\r\n&lt;div&gt;\r\n	&amp;nbsp;&lt;/div&gt;\r\n&lt;div&gt;\r\n	4、满10元提现，秒到支付宝。&lt;/div&gt;\r\n', '', '1641347764', '1641347764');
INSERT INTO `ey_article_content` VALUES ('2', '130', '&lt;div&gt;\r\n	&amp;ldquo;我试了下，真的领到口罩了!&amp;rdquo;某公司员工小李在朋友圈发了条消息，他本来还在为复工后上下班路上的&amp;ldquo;安全问题&amp;rdquo;忧心忡忡，现在晒出了自己在&amp;ldquo;恐龙有钱&amp;rdquo;APP上免费领取的口罩，急着要把喜悦分享给更多的朋友。&lt;/div&gt;\r\n&lt;div&gt;\r\n	&amp;nbsp;&lt;/div&gt;\r\n&lt;div&gt;\r\n	日前，为抗击新型冠状病毒，同时助力非疫区的生产复工，作为国内知名游戏品牌&amp;ldquo;恐龙有钱&amp;rdquo;，经过艰难的筹措，在第一时间对平台用户组织和发起了&amp;ldquo;免费送口罩&amp;rdquo;公益活动，并且承担全部邮寄费用，为&amp;ldquo;全国抗疫&amp;rdquo;尽自己的一份力。&lt;/div&gt;\r\n&lt;div&gt;\r\n	&amp;nbsp;&lt;/div&gt;\r\n&lt;div&gt;\r\n	很多人对&amp;ldquo;恐龙有钱&amp;rdquo;这款游戏并不陌生，这款游戏面世之初就以它的&amp;ldquo;不一样&amp;rdquo;吸引了无数眼球。&amp;ldquo;没有充值入口，不需要投入一分钱，完全免费玩&amp;rdquo;，这成了很多玩家互相推荐的理由。特别是在疫情期间，越来越多的人开始喜欢上这款养成类游戏，其呆萌的恐龙形象，甚至被用来当做微信头像和表情包使用。&lt;/div&gt;\r\n&lt;div&gt;\r\n	&amp;nbsp;&lt;/div&gt;\r\n&lt;div&gt;\r\n	用户的拥趸，也让&amp;ldquo;恐龙有钱&amp;rdquo;有了更多的拓展方向，广告、电商、异业合作、融资等都展现出良好的发展势头，而正是这样的增长势头下，普惠用户、回馈社会的责任感，让他们在&amp;ldquo;抗疫时期&amp;rdquo;推出了&amp;ldquo;免费送口罩&amp;rdquo;的公益之举。&lt;/div&gt;\r\n&lt;div&gt;\r\n	&amp;nbsp;&lt;/div&gt;\r\n&lt;div&gt;\r\n	疫情发展到了关键阶段，同时面临着企业复工和学生即将开学的情形，人员流动逐步增大的情况，医用物资的供需都出现新的增长，&amp;ldquo;恐龙有钱&amp;rdquo;积极响应政府号召，投资近百万元，向工厂定制大量普通防护型口罩。&amp;ldquo;恐龙有钱&amp;rdquo;研发单位上海易慕科技有限公司先后多次紧急召开会议，研究协调物资调配、设备采购、口罩设计方案等事宜，目标只有一个：尽快拿到出合格的防护口罩，给到平台用户!&lt;/div&gt;\r\n&lt;div&gt;\r\n	&amp;nbsp;&lt;/div&gt;\r\n&lt;div&gt;\r\n	在保障防疫物资供应，复工复产稳定经济，展现企业担当作为、甘于奉献的&amp;ldquo;硬核力量&amp;rdquo;的同时，&amp;ldquo;恐龙有钱&amp;rdquo;并没有忘记新老用户的支持，公司迅速做出决定，在3月4日&amp;mdash;&amp;mdash;3月14日，对下载或升级新版的&amp;ldquo;恐龙有钱&amp;rdquo;的用户开展了&amp;ldquo;免费赠送口罩&amp;rdquo;活动。小李就是在玩游戏时知道了这个&amp;ldquo;好消息&amp;rdquo;，在玩游戏的同时不仅能有机会获取到免费口罩，还赚了不少&amp;ldquo;菜篮子钱&amp;rdquo;。&lt;/div&gt;\r\n&lt;div&gt;\r\n	&amp;nbsp;&lt;/div&gt;\r\n&lt;div&gt;\r\n	而&amp;ldquo;恐龙有钱&amp;rdquo;相关负责人表示，为了能为社会贡献更多的力量，特殊时期没有条件创造条件也要上，&amp;ldquo;疫情面前，每个人都是战&amp;lsquo;疫&amp;rsquo;者。作为一个迅速发展的互联网企业我们责无旁贷地该承担相应的社会责任，尽企业所能为用户提供所需和方便，也为疫情防控做出我们应有的贡献。我们坚信，没有什么困难是不可逾越的!&amp;rdquo;&lt;/div&gt;\r\n', '', '1641347764', '1641347764');
INSERT INTO `ey_article_content` VALUES ('3', '131', '&lt;div&gt;\r\n	大六顺，2020年3月12日周四上午上线的实力新平台， 抢先收、金刚涨旗下&amp;mdash;&amp;mdash;隆重推出的强力新平台&amp;ldquo;大六顺&amp;rdquo;！&lt;/div&gt;\r\n&lt;div&gt;\r\n	&amp;nbsp;&lt;/div&gt;\r\n&lt;div&gt;\r\n	转发单价3毛2，高价时段6毛（每天早8-9点、中午13-14点、晚18-19点），其余时段3毛2。&lt;/div&gt;\r\n&lt;div&gt;\r\n	注册送5毛，首次提现3元，秒到账，后续永久5元起提现。&lt;/div&gt;\r\n&lt;div&gt;\r\n	签到红包，连续签到越久，红包越大，连续签到7天最高1元。&lt;/div&gt;\r\n&lt;div&gt;\r\n	两级35%收益分成：徒弟25%，徒孙10%。&lt;/div&gt;\r\n&lt;div&gt;\r\n	支持上传文章，涨分更给力，门槛还更低。&lt;/div&gt;\r\n', '', '1641347764', '1641347764');
INSERT INTO `ey_article_content` VALUES ('4', '132', '&lt;div&gt;\r\n	小龙虾大亨项目（类似皮皮虾传奇和世界农场），更新稳定，收益稳定，团队稳定。加入项目，轻松赚，零风险，快钱大钱两手抓！零撸！无需实名！每升1级都可以抽奖，6级、16级、26级、36级抽奖必得现金红包！！&lt;/div&gt;\r\n&lt;div&gt;\r\n	&amp;nbsp;&lt;/div&gt;\r\n&lt;div&gt;\r\n	每天静态领取20次逆风快递，可以每天增加2%必得分红虾进度，到达100%后到37级必得分红虾，预计不邀请人玩的话50天也能得到分红虾，邀请人速度更快！&lt;/div&gt;\r\n&lt;div&gt;\r\n	&amp;nbsp;&lt;/div&gt;\r\n&lt;div&gt;\r\n	五大亮点&lt;br /&gt;\r\n	&amp;nbsp;&lt;/div&gt;\r\n&lt;div&gt;\r\n	***注册（填写邀请码123456）到6级，几分钟即领最低12元红包&lt;/div&gt;\r\n&lt;div&gt;\r\n	***每日升级看视频做任务必得红包，抽奖得现金&lt;/div&gt;\r\n&lt;div&gt;\r\n	***邀请下级9级以上返1.5元，递增分红虾进度&lt;/div&gt;\r\n&lt;div&gt;\r\n	***以后每天下级看广告享提成（提成高到徒弟可享几块钱）&lt;/div&gt;\r\n&lt;div&gt;\r\n	***升级37级神兽，抽到就是分红，没有什么五合一，只有分红，红包&lt;/div&gt;\r\n&lt;div&gt;\r\n	&amp;nbsp;&lt;/div&gt;\r\n&lt;div&gt;\r\n	快速升级技巧：&lt;br /&gt;\r\n	&amp;nbsp;&lt;/div&gt;\r\n&lt;div&gt;\r\n	把金币全部用于升级当前等级最高的动物，然后领快递，直到够解锁下一级动物，如此反复，可快速升级！大家一起共同致富！&lt;/div&gt;\r\n', '', '1641347764', '1641347764');
INSERT INTO `ey_article_content` VALUES ('5', '133', '&lt;div&gt;\r\n	猫咪小屋红包版是一款能萌翻你的可爱模拟养猫来轻松赚钱小游戏。猫咪小屋里面的小猫有不同的品种分为不同等级，想要获得更高等级的猫咪需要将两只同等级的猫合成，支持安卓和苹果手机双端使用。&lt;/div&gt;\r\n&lt;div&gt;\r\n	&amp;nbsp;&lt;/div&gt;\r\n&lt;div&gt;\r\n	用户可以通过合成灵猫来获取喵币，并可在猫咪小屋APP中兑换现金奖励并且提现。合成灵猫的等级越高赚的越多，无需投资，每天上线玩一玩，轻松月入百元。猫咪小屋同族产品还有阳光养猪场、贪吃蛇在线和答题夺宝等热门产品。&lt;/div&gt;\r\n&lt;div&gt;\r\n	&amp;nbsp;&lt;/div&gt;\r\n&lt;div&gt;\r\n	如何获得喵币？&lt;/div&gt;\r\n&lt;div&gt;\r\n	两个同等级的角色拖拽到一起即可合成更高等级的灵猫，当解锁新等级的灵猫时可以获得喵币奖励。等级越高，奖励越高。&lt;/div&gt;\r\n&lt;div&gt;\r\n	&amp;nbsp;&lt;/div&gt;\r\n&lt;div&gt;\r\n	分红猫玩法&lt;/div&gt;\r\n&lt;div&gt;\r\n	合成灵猫有机会获得分红猫，分红猫享受猫咪小屋广告收益分成。邀请好友可召唤全球分红猫，全球限量10万只全球分红猫，先到先得，领完为止。拥有分红猫，天天领工资！&lt;/div&gt;\r\n&lt;div&gt;\r\n	&amp;nbsp;&lt;/div&gt;\r\n&lt;div&gt;\r\n	团队玩法&lt;/div&gt;\r\n&lt;div&gt;\r\n	邀请好友加入我的团队，享受好友观看广告收益。邀请好友一起养猫、做任务、玩游戏，一起来赚钱！宅家里，天天领工资！&lt;/div&gt;\r\n&lt;div&gt;\r\n	&amp;nbsp;&lt;/div&gt;\r\n&lt;div&gt;\r\n	软件优势&lt;/div&gt;\r\n&lt;div&gt;\r\n	1、超萌的猫咪等你养成，跟你撒娇卖萌，让你享受云养猫带来的无限欢乐;&lt;/div&gt;\r\n&lt;div&gt;\r\n	2、百变的猫咪自由收集，完成更多的挑战任务，丰厚的奖励让你根本停不下来;&lt;/div&gt;\r\n&lt;div&gt;\r\n	3、简单的挂机玩法，跟各种猫咪多多互动，能够加速它们的成长，合并生成更高等级。&lt;/div&gt;\r\n&lt;div&gt;\r\n	4、Q萌可爱的猫咪，丰富的种类，想养什么都能在这里解锁，满足撸猫的梦想;&lt;/div&gt;\r\n&lt;div&gt;\r\n	5、从零级的小猫开始养成，解锁更多的场景，扩大你的养猫场，时刻为你带来收益;&lt;/div&gt;\r\n&lt;div&gt;\r\n	6、到了后期猫咪全部成为高级，时刻都能为你带来海量的金币，让你领到手软。&lt;/div&gt;\r\n&lt;div&gt;\r\n	&amp;nbsp;&lt;/div&gt;\r\n&lt;div&gt;\r\n	猫咪小屋红包版是一款最新上市的手机养殖赚钱的软件，使用该软件的用户们可以在线免费领取可爱的小猫咪进行喂养，这些可爱的小猫咪等级都是不同的哦，同等级的小猫咪还可以合并成更高等级的哦，等级的增加帮助用户朋友们赚取的金币将会增多的。操作十分的简单。&lt;/div&gt;\r\n', '', '1641347764', '1641347764');
INSERT INTO `ey_article_content` VALUES ('8', '136', '&lt;div&gt;\r\n	哆啦赚是一个可以在手机上做任务赚钱的软件，上线已经一段时间，目前整体上发展的还不错。不过由于是一个新出不久的悬赏任务平台。很多人对哆啦赚是真的吗，能不能赚钱还持有怀疑的态度。小编给大家简单对哆啦赚如何赚钱做一个简单的介绍。&lt;/div&gt;&lt;div&gt;\r\n	&amp;nbsp;&lt;/div&gt;&lt;div&gt;\r\n	哆啦赚模式上是靠谱的&lt;br/&gt;\r\n	&amp;nbsp;&lt;/div&gt;&lt;div&gt;\r\n	很多人问我们为什么觉得哆啦赚是真的可以赚钱的软件。我们之所以重点推荐哆啦赚这款手机赚钱app最大的原因是因为哆啦赚app的任务悬赏赚钱模式是真实、靠谱的。做任务赚钱这种模式早在PC电脑时代就是一种非常流行的网上兼职方式。我们所熟悉的猪八戒、时间财富网等威客平台本质上就属于做任务赚钱的模式。所以从哆啦赚赚钱模式上来看哆啦赚属于真实的、靠谱的赚钱模式。不是那些所谓的资金盘，是靠骗人来进行的。&lt;/div&gt;&lt;div&gt;\r\n	&amp;nbsp;&lt;p&gt;&lt;img src=&quot;/uploads/allimg/20230519/1-230519102924237.jpg&quot; alt=&quot;0fXdt1683882256_6.jpg&quot;/&gt;&lt;/p&gt;&lt;/div&gt;&lt;div&gt;\r\n	哆啦赚打款上是真实的&lt;/div&gt;&lt;div&gt;\r\n	对于我们做手机兼职的人来说，最关心的是在哆啦赚上做任务赚钱赚到的钱能提现吗。无论是什么时候提现，哆啦赚都能够准确、按时地给大家进行打款。小编已经多次提现，亲自验证。从提现的角度上来看，哆啦赚真是一款靠谱的、真实的手机赚钱软件。&lt;/div&gt;&lt;div&gt;\r\n	&amp;nbsp;&lt;/div&gt;&lt;div&gt;\r\n	哆啦赚具有一定的运营实力&lt;/div&gt;&lt;div&gt;\r\n	现在手机上做任务赚钱的软件有很多种，比较知名的有趣闲赚、钱帮和悬赏猫等。除了这些知名的平台还有一些新开的平台，比如小白赚钱、哆啦赚、全民赚和蜂窝帮等。不同的平台运营实力是不同的。对于我们来说肯定希望能够找到一个长期的、有实力的平台。&lt;/div&gt;&lt;div&gt;\r\n	&amp;nbsp;&lt;/div&gt;&lt;div&gt;\r\n	哆啦赚就是这样的一个平台，虽然目前依旧比不过老牌的趣闲赚，不过发展势头还是不错的。 另外由于哆啦赚app具有邀请好友赚钱的功能，所以很多人担心哆啦赚是传销骗局。哆啦赚虽然具有邀请好友的功能，但是本身哆啦赚是免费的手机赚钱软件，我们在哆啦赚不需要投入一分钱就可以通过自己做任务来赚钱，所以哆啦赚并不是传销骗局。 总之一句话，哆啦赚上赚钱是真实的、靠谱的。如果希望通过在手机上赚点小零钱的话，哆啦赚是一个不错的手机做任务平台。&lt;/div&gt;', '', '1684463367', '1684463367');
INSERT INTO `ey_article_content` VALUES ('9', '137', '&lt;div&gt;\r\n	招行APP申领电子社保卡享好礼，红包送不停。活动期间，登陆招商APP - 便民服务 - 电子社保卡，按步骤完成首次申领，即可参与抽奖，最高可抽取666元现金红包，可直接提现到银行卡。&lt;/div&gt;\r\n&lt;div&gt;\r\n	&amp;nbsp;&lt;/div&gt;\r\n&lt;div&gt;\r\n	活动时间 即日起至2020年3月31日 【活动对象】 登录电子社保卡小程序-成功申领电子社保卡的用户（目前已经覆盖全国所有城市）。&lt;/div&gt;\r\n&lt;div&gt;\r\n	&amp;nbsp;&lt;/div&gt;\r\n&lt;div&gt;\r\n	活动期间，客户登录招商银行App体验电子社保卡小程序，成功登录该小程序并成功签发，即可获得抽奖资格，有机会获得666元现金红包、话费抵扣券和华为Mate30 5G手机等大礼。&lt;/div&gt;\r\n', '', '1641347764', '1641347764');
INSERT INTO `ey_article_content` VALUES ('10', '138', '&lt;div&gt;\r\n	哈灵斗地主，每天玩斗地主游戏领红包，每玩一局游戏都有数额不等的元宝免费领，元宝可兑换微信现金红包，上不封顶。此外还有新用户专属福利，2天赢6局赚1.5元，1元就能提现秒到账。&lt;/div&gt;\r\n&lt;div&gt;\r\n	&amp;nbsp;&lt;/div&gt;\r\n&lt;div&gt;\r\n	新手专属红包福利&lt;br /&gt;\r\n	&amp;nbsp;&lt;/div&gt;\r\n&lt;div&gt;\r\n	微信登录免费赠送0.3元，填邀请码奖励0.2元，当天赢3局奖励0.4元，次日赢3局奖励0.6元，满1元可直接提现，所以我们需要等第二天一起提现1.5元，秒到微信零钱！&lt;/div&gt;\r\n&lt;div&gt;\r\n	&amp;nbsp;&lt;/div&gt;\r\n&lt;div&gt;\r\n	具体步骤&lt;br /&gt;\r\n	&amp;nbsp;&lt;/div&gt;\r\n&lt;div&gt;\r\n	打开哈灵斗地主点击游戏大厅右上角的【领红包】按钮就会弹出活动页面，打开会直接送0.3元，填写好友ID【123456】送0.2元。&lt;br /&gt;\r\n	&amp;nbsp;&lt;/div&gt;\r\n&lt;div&gt;\r\n	当天胜利3局斗地主送0.4体验，第二天再胜利3局斗地主送0.6元，前面几局都是好牌，第二天直接提现1.5元到微信零钱，秒到账。&lt;/div&gt;\r\n&lt;div&gt;\r\n	&amp;nbsp;&lt;/div&gt;\r\n&lt;div&gt;\r\n	友情提醒：这个活动只有新用户才会有活动入口，也就是说如果你之前注册过哈灵斗地主是不会有活动入口的。&lt;/div&gt;\r\n', '', '1641347764', '1641347764');
INSERT INTO `ey_article_content` VALUES ('11', '144', '&lt;p&gt;今天小编给大家带来的是崩坏星穹铁道找到藏起来的鼹鼠党成员攻略，很多玩家不知道这个两个藏起来的鼹鼠党成员在哪，怎样才能找到他们两个人呢？毕竟是主线任务，想知道怎么完成的玩家往下看看下面小编给大家带来的位置介绍吧。&lt;/p&gt;', '', '1684372535', '1684372535');

-- -----------------------------
-- Table structure for `ey_article_order`
-- -----------------------------
DROP TABLE IF EXISTS `ey_article_order`;
CREATE TABLE `ey_article_order` (
  `order_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '文章订单ID',
  `order_code` varchar(50) NOT NULL DEFAULT '' COMMENT '媒体订单编号',
  `users_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `order_status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '订单状态：0未付款，1已付款',
  `order_amount` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '订单应付总金额',
  `pay_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '支付时间',
  `pay_name` varchar(20) NOT NULL DEFAULT '' COMMENT '支付方式名称',
  `wechat_pay_type` varchar(20) NOT NULL DEFAULT '' COMMENT '微信支付时，标记使用的支付类型（扫码支付，微信内部，微信H5页面）',
  `pay_details` text COMMENT '支付时返回的数据，以serialize序列化后存入，用于后续查询。',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '视频文档ID',
  `product_name` varchar(100) DEFAULT '' COMMENT '视频文档名称',
  `product_litpic` varchar(500) DEFAULT '' COMMENT '视频文档封面图片',
  `lang` varchar(30) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '下单时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`order_id`),
  UNIQUE KEY `order_code` (`order_code`) USING BTREE,
  KEY `users_id` (`users_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='文章订单表';


-- -----------------------------
-- Table structure for `ey_article_pay`
-- -----------------------------
DROP TABLE IF EXISTS `ey_article_pay`;
CREATE TABLE `ey_article_pay` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `aid` int(11) DEFAULT '0',
  `part_free` tinyint(1) DEFAULT '0' COMMENT '是否试看 0-否 1-是',
  `size` float(10,2) DEFAULT '1.00' COMMENT 'KB',
  `free_content` longtext COMMENT '试看内容',
  `add_time` int(11) DEFAULT '0',
  `update_time` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='文章付费预览表';


-- -----------------------------
-- Table structure for `ey_ask`
-- -----------------------------
DROP TABLE IF EXISTS `ey_ask`;
CREATE TABLE `ey_ask` (
  `ask_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `type_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '问题栏目ID',
  `users_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `ask_title` varchar(200) NOT NULL DEFAULT '' COMMENT '问题标题',
  `is_recom` tinyint(1) NOT NULL DEFAULT '0' COMMENT '问题是否推荐',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '问题状态：0未解决，1已解决，2已关闭',
  `click` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '浏览点击量',
  `replies` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '问题回复量',
  `content` text NOT NULL COMMENT '问题内容',
  `url` varchar(255) NOT NULL DEFAULT '' COMMENT '问题网址',
  `users_ip` varchar(50) NOT NULL DEFAULT '' COMMENT '问题发布时IP地址',
  `is_review` tinyint(1) NOT NULL DEFAULT '1' COMMENT '问题是否审核，1是，0否',
  `follow` tinyint(1) NOT NULL DEFAULT '0' COMMENT '关注问题则表示有回复时发送邮件通知到问题发布人',
  `solve_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '解决时间(这个问题存在最佳答案则表示已解决)',
  `bestanswer_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '最佳答案',
  `sort_order` int(10) NOT NULL DEFAULT '100' COMMENT '排序号',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `money` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '悬赏金额',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '1-删除',
  PRIMARY KEY (`ask_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='问题表';


-- -----------------------------
-- Table structure for `ey_ask_answer`
-- -----------------------------
DROP TABLE IF EXISTS `ey_ask_answer`;
CREATE TABLE `ey_ask_answer` (
  `answer_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `ask_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '问题ID',
  `is_bestanswer` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否最佳答案，0否，1是',
  `is_review` tinyint(1) NOT NULL DEFAULT '1' COMMENT '问题是否审核，1是，0否',
  `type_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '问题栏目ID',
  `users_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户ID',
  `username` varchar(50) NOT NULL DEFAULT '' COMMENT '用户名',
  `click_like` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '点赞量',
  `users_ip` varchar(30) NOT NULL DEFAULT '' COMMENT '用户IP地址',
  `content` text NOT NULL COMMENT '内容',
  `ifcheck` tinyint(1) NOT NULL DEFAULT '1',
  `answer_pid` int(10) NOT NULL DEFAULT '0' COMMENT '子答案的父答案',
  `at_users_id` int(10) NOT NULL DEFAULT '0' COMMENT '被@的用户ID',
  `at_answer_id` int(10) NOT NULL DEFAULT '0' COMMENT '@答案ID',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `is_del` tinyint(1) NOT NULL DEFAULT '0' COMMENT '1-删除',
  PRIMARY KEY (`answer_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='答案表';


-- -----------------------------
-- Table structure for `ey_ask_answer_like`
-- -----------------------------
DROP TABLE IF EXISTS `ey_ask_answer_like`;
CREATE TABLE `ey_ask_answer_like` (
  `like_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `ask_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '问题ID',
  `answer_id` int(10) NOT NULL DEFAULT '0' COMMENT '答案ID',
  `users_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户ID',
  `click_like` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '点赞',
  `like_source` tinyint(1) unsigned NOT NULL DEFAULT '2' COMMENT '点赞来源，1=点赞提问(ask_id)，2=点赞评论(answer_id)，3=点赞回复(answer_id)，默认值为2，兼容以前的那些评论数据',
  `users_ip` varchar(30) NOT NULL DEFAULT '' COMMENT '用户IP地址',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`like_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='答案点赞表';


-- -----------------------------
-- Table structure for `ey_ask_score_level`
-- -----------------------------
DROP TABLE IF EXISTS `ey_ask_score_level`;
CREATE TABLE `ey_ask_score_level` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(55) DEFAULT '',
  `min` mediumint(8) DEFAULT '0',
  `max` mediumint(8) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='积分等级表';

-- -----------------------------
-- Records of `ey_ask_score_level`
-- -----------------------------
INSERT INTO `ey_ask_score_level` VALUES ('1', '青铜', '0', '1000');
INSERT INTO `ey_ask_score_level` VALUES ('2', '白银', '1001', '5000');
INSERT INTO `ey_ask_score_level` VALUES ('3', '黄金', '5001', '20000');
INSERT INTO `ey_ask_score_level` VALUES ('4', '王者', '20001', '0');

-- -----------------------------
-- Table structure for `ey_ask_type`
-- -----------------------------
DROP TABLE IF EXISTS `ey_ask_type`;
CREATE TABLE `ey_ask_type` (
  `type_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '栏目自增',
  `type_name` varchar(100) NOT NULL DEFAULT '' COMMENT '栏目名称',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '上级ID',
  `seo_title` varchar(200) DEFAULT '' COMMENT 'SEO标题',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT 'seo关键字',
  `seo_description` text COMMENT 'seo描述',
  `sort_order` int(10) unsigned NOT NULL DEFAULT '100' COMMENT '排序号',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`type_id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COMMENT='问题栏目分类表';

-- -----------------------------
-- Records of `ey_ask_type`
-- -----------------------------
INSERT INTO `ey_ask_type` VALUES ('1', '问题求助', '0', '', '', '', '100', '1565770890', '1611910466');
INSERT INTO `ey_ask_type` VALUES ('2', '功能建议', '0', '', '', '', '100', '1565770890', '1611910466');
INSERT INTO `ey_ask_type` VALUES ('3', 'BUG反馈', '1', '', '', '', '100', '1565771021', '1611910466');
INSERT INTO `ey_ask_type` VALUES ('4', '其他问题', '1', '', '', '', '100', '1565771021', '1611910466');
INSERT INTO `ey_ask_type` VALUES ('5', '业务咨询', '0', '', '', '', '100', '1611910466', '1611910466');

-- -----------------------------
-- Table structure for `ey_auth_role`
-- -----------------------------
DROP TABLE IF EXISTS `ey_auth_role`;
CREATE TABLE `ey_auth_role` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT '' COMMENT '角色名',
  `pid` int(10) DEFAULT '0' COMMENT '父角色ID',
  `remark` text COMMENT '备注信息',
  `grade` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '级别',
  `language` text COMMENT '多语言权限',
  `online_update` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '在线升级',
  `switch_map` tinyint(1) DEFAULT '0' COMMENT '功能地图',
  `only_oneself` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '只看自己发布',
  `check_oneself` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '发布文档自动通过审核，1--是，0--否',
  `cud` varchar(255) DEFAULT '' COMMENT '增改删',
  `permission` longtext COMMENT '已允许的权限',
  `built_in` tinyint(1) DEFAULT '0' COMMENT '内置用户组，1表示内置',
  `sort_order` int(10) DEFAULT '0' COMMENT '排序号',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态(1=正常，0=屏蔽)',
  `admin_id` int(10) DEFAULT '0' COMMENT '操作管理员ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='管理员角色表';

-- -----------------------------
-- Records of `ey_auth_role`
-- -----------------------------
INSERT INTO `ey_auth_role` VALUES ('1', '优化推广员', '0', '', '0', '', '0', '1', '1', '1', 'a:3:{i:0;s:3:\"add\";i:1;s:4:\"edit\";i:2;s:3:\"del\";}', 'a:2:{s:5:\"rules\";a:8:{i:0;s:1:\"1\";i:1;s:1:\"3\";i:2;s:1:\"4\";i:3;s:1:\"8\";i:4;s:1:\"9\";i:5;s:2:\"10\";i:6;s:2:\"14\";i:7;i:2;}s:7:\"arctype\";a:52:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";i:4;s:1:\"5\";i:5;s:1:\"6\";i:6;s:2:\"33\";i:7;s:2:\"34\";i:8;s:2:\"35\";i:9;s:1:\"8\";i:10;s:2:\"32\";i:11;s:1:\"9\";i:12;s:2:\"30\";i:13;s:2:\"31\";i:14;s:2:\"11\";i:15;s:2:\"12\";i:16;s:2:\"13\";i:17;s:2:\"23\";i:18;s:2:\"20\";i:19;s:2:\"24\";i:20;s:2:\"25\";i:21;s:2:\"21\";i:22;s:2:\"26\";i:23;s:2:\"22\";i:24;s:2:\"27\";i:25;s:2:\"28\";i:26;s:2:\"29\";i:27;s:1:\"1\";i:28;s:2:\"10\";i:29;s:2:\"11\";i:30;s:2:\"12\";i:31;s:2:\"13\";i:32;s:2:\"14\";i:33;s:2:\"15\";i:34;s:2:\"16\";i:35;s:2:\"17\";i:36;s:2:\"18\";i:37;s:2:\"19\";i:38;s:2:\"20\";i:39;s:2:\"21\";i:40;s:2:\"22\";i:41;s:2:\"23\";i:42;s:2:\"24\";i:43;s:2:\"25\";i:44;s:2:\"26\";i:45;s:2:\"27\";i:46;s:2:\"28\";i:47;s:2:\"29\";i:48;s:2:\"30\";i:49;s:2:\"31\";i:50;s:2:\"32\";i:51;s:2:\"33\";}}', '1', '100', '1', '0', '1541058693', '1541058693');
INSERT INTO `ey_auth_role` VALUES ('2', '内容管理员', '0', '', '0', '', '0', '1', '1', '1', 'a:3:{i:0;s:3:\"add\";i:1;s:4:\"edit\";i:2;s:3:\"del\";}', 'a:2:{s:5:\"rules\";a:4:{i:0;s:1:\"1\";i:1;s:2:\"10\";i:2;s:2:\"14\";i:3;i:2;}s:7:\"arctype\";a:52:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";i:4;s:1:\"5\";i:5;s:1:\"6\";i:6;s:2:\"33\";i:7;s:2:\"34\";i:8;s:2:\"35\";i:9;s:1:\"8\";i:10;s:2:\"32\";i:11;s:1:\"9\";i:12;s:2:\"30\";i:13;s:2:\"31\";i:14;s:2:\"11\";i:15;s:2:\"12\";i:16;s:2:\"13\";i:17;s:2:\"23\";i:18;s:2:\"20\";i:19;s:2:\"24\";i:20;s:2:\"25\";i:21;s:2:\"21\";i:22;s:2:\"26\";i:23;s:2:\"22\";i:24;s:2:\"27\";i:25;s:2:\"28\";i:26;s:2:\"29\";i:27;s:1:\"1\";i:28;s:2:\"10\";i:29;s:2:\"11\";i:30;s:2:\"12\";i:31;s:2:\"13\";i:32;s:2:\"14\";i:33;s:2:\"15\";i:34;s:2:\"16\";i:35;s:2:\"17\";i:36;s:2:\"18\";i:37;s:2:\"19\";i:38;s:2:\"20\";i:39;s:2:\"21\";i:40;s:2:\"22\";i:41;s:2:\"23\";i:42;s:2:\"24\";i:43;s:2:\"25\";i:44;s:2:\"26\";i:45;s:2:\"27\";i:46;s:2:\"28\";i:47;s:2:\"29\";i:48;s:2:\"30\";i:49;s:2:\"31\";i:50;s:2:\"32\";i:51;s:2:\"33\";}}', '1', '100', '1', '0', '1541059290', '1541059290');

-- -----------------------------
-- Table structure for `ey_channelfield`
-- -----------------------------
DROP TABLE IF EXISTS `ey_channelfield`;
CREATE TABLE `ey_channelfield` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `name` varchar(32) NOT NULL DEFAULT '' COMMENT '字段名称',
  `channel_id` int(10) NOT NULL DEFAULT '0' COMMENT '所属文档模型id',
  `title` varchar(250) NOT NULL DEFAULT '' COMMENT '字段标题',
  `dtype` varchar(32) NOT NULL DEFAULT '' COMMENT '字段类型',
  `define` text NOT NULL COMMENT '字段定义',
  `maxlength` int(10) NOT NULL DEFAULT '0' COMMENT '最大长度，文本数据必须填写，大于255为text类型',
  `dfvalue` text NOT NULL COMMENT '默认值',
  `dfvalue_unit` varchar(50) NOT NULL DEFAULT '' COMMENT '数值单位',
  `remark` varchar(256) NOT NULL DEFAULT '' COMMENT '提示说明',
  `is_screening` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否应用于条件筛选',
  `is_release` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否应用于会员投稿发布',
  `ifeditable` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否在编辑页显示',
  `ifrequire` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否必填',
  `ifsystem` tinyint(1) NOT NULL DEFAULT '0' COMMENT '字段分类，1=系统(不可修改)，0=自定义',
  `ifmain` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否主表字段',
  `ifcontrol` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态，控制该条数据是否允许被控制，1为不允许控制，0为允许控制',
  `sort_order` int(5) NOT NULL DEFAULT '100' COMMENT '排序',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  `set_type` tinyint(3) DEFAULT '0' COMMENT '区域选择时使用是否为三级联动,1-是',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=321 DEFAULT CHARSET=utf8 COMMENT='自定义字段表';

-- -----------------------------
-- Records of `ey_channelfield`
-- -----------------------------
INSERT INTO `ey_channelfield` VALUES ('1', 'add_time', '0', '新增时间', 'datetime', 'int(11)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533091575', '1533091575', '0');
INSERT INTO `ey_channelfield` VALUES ('2', 'update_time', '0', '更新时间', 'datetime', 'int(11)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533091601', '1533091601', '0');
INSERT INTO `ey_channelfield` VALUES ('3', 'aid', '0', '文档ID', 'int', 'int(11)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533091624', '1533091624', '0');
INSERT INTO `ey_channelfield` VALUES ('4', 'typeid', '0', '当前栏目ID', 'int', 'int(11)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533091930', '1533091930', '0');
INSERT INTO `ey_channelfield` VALUES ('5', 'channel', '0', '模型ID', 'int', 'int(11)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092214', '1533092214', '0');
INSERT INTO `ey_channelfield` VALUES ('6', 'is_b', '0', '是否加粗', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092246', '1533092246', '0');
INSERT INTO `ey_channelfield` VALUES ('7', 'title', '0', '文档标题', 'text', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092381', '1533092381', '0');
INSERT INTO `ey_channelfield` VALUES ('8', 'litpic', '0', '缩略图', 'img', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092398', '1533092398', '0');
INSERT INTO `ey_channelfield` VALUES ('9', 'is_head', '0', '是否头条', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092420', '1533092420', '0');
INSERT INTO `ey_channelfield` VALUES ('10', 'is_special', '0', '是否特荐', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092439', '1533092439', '0');
INSERT INTO `ey_channelfield` VALUES ('11', 'is_top', '0', '是否置顶', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092454', '1533092454', '0');
INSERT INTO `ey_channelfield` VALUES ('12', 'is_recom', '0', '是否推荐', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092468', '1533092468', '0');
INSERT INTO `ey_channelfield` VALUES ('13', 'is_jump', '0', '是否跳转', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092484', '1533092484', '0');
INSERT INTO `ey_channelfield` VALUES ('14', 'author', '0', '作者', 'text', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092498', '1533092498', '0');
INSERT INTO `ey_channelfield` VALUES ('15', 'click', '0', '浏览量', 'int', 'int(11)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092512', '1533092512', '0');
INSERT INTO `ey_channelfield` VALUES ('16', 'arcrank', '0', '阅读权限', 'select', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092534', '1533092534', '0');
INSERT INTO `ey_channelfield` VALUES ('17', 'jumplinks', '0', '跳转链接', 'text', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092553', '1533092553', '0');
INSERT INTO `ey_channelfield` VALUES ('18', 'ismake', '0', '是否静态页面', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092698', '1533092698', '0');
INSERT INTO `ey_channelfield` VALUES ('19', 'seo_title', '0', 'SEO标题', 'text', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092713', '1533092713', '0');
INSERT INTO `ey_channelfield` VALUES ('20', 'seo_keywords', '0', 'SEO关键词', 'text', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092725', '1533092725', '0');
INSERT INTO `ey_channelfield` VALUES ('21', 'seo_description', '0', 'SEO描述', 'text', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092739', '1533092739', '0');
INSERT INTO `ey_channelfield` VALUES ('22', 'status', '0', '状态', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092753', '1533092753', '0');
INSERT INTO `ey_channelfield` VALUES ('23', 'sort_order', '0', '排序号', 'int', 'int(11)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092766', '1533092766', '0');
INSERT INTO `ey_channelfield` VALUES ('24', 'content', '2', '内容详情', 'htmltext', 'longtext', '250', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1533359739', '1533359739', '0');
INSERT INTO `ey_channelfield` VALUES ('25', 'content', '3', '内容详情', 'htmltext', 'longtext', '250', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1533359588', '1533359588', '0');
INSERT INTO `ey_channelfield` VALUES ('26', 'content', '4', '内容详情', 'htmltext', 'longtext', '250', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1533359752', '1533359752', '0');
INSERT INTO `ey_channelfield` VALUES ('27', 'content', '6', '内容详情', 'htmltext', 'longtext', '250', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1533464715', '1533464715', '0');
INSERT INTO `ey_channelfield` VALUES ('29', 'content', '1', '内容详情', 'htmltext', 'longtext', '250', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1533464713', '1533464713', '0');
INSERT INTO `ey_channelfield` VALUES ('30', 'update_time', '-99', '更新时间', 'datetime', 'int(11)', '11', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('31', 'add_time', '-99', '新增时间', 'datetime', 'int(11)', '11', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('32', 'status', '-99', '启用 (1=正常，0=屏蔽)', 'switch', 'tinyint(1)', '1', '1', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('33', 'is_part', '-99', '栏目属性：0=内容栏目，1=外部链接', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('34', 'is_hidden', '-99', '是否隐藏栏目：0=显示，1=隐藏', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('35', 'sort_order', '-99', '排序号', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('36', 'seo_description', '-99', 'seo描述', 'multitext', 'text', '0', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('37', 'seo_keywords', '-99', 'seo关键字', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('38', 'seo_title', '-99', 'SEO标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('39', 'tempview', '-99', '文档模板文件名', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('40', 'templist', '-99', '列表模板文件名', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('41', 'litpic', '-99', '栏目图片', 'img', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('42', 'typelink', '-99', '栏目链接', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('43', 'grade', '-99', '栏目等级', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('44', 'englist_name', '-99', '栏目英文名', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('45', 'dirpath', '-99', '目录存放HTML路径', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('46', 'dirname', '-99', '目录英文名', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('47', 'typename', '-99', '栏目名称', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('48', 'parent_id', '-99', '栏目上级ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('49', 'current_channel', '-99', '栏目当前模型ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('50', 'channeltype', '-99', '栏目顶级模型ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('51', 'id', '-99', '栏目ID', 'int', 'int(10)', '10', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('52', 'del_method', '-99', '伪删除状态，1为主动删除，2为跟随上级栏目被动删除', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1547890773', '1547890773', '0');
INSERT INTO `ey_channelfield` VALUES ('53', 'is_del', '0', '伪删除，1=是，0=否', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1547890773', '1547890773', '0');
INSERT INTO `ey_channelfield` VALUES ('54', 'del_method', '0', '伪删除状态，1为主动删除，2为跟随上级栏目被动删除', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1547890773', '1547890773', '0');
INSERT INTO `ey_channelfield` VALUES ('55', 'admin_id', '0', '管理员ID', 'int', 'int(10)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1547890773', '1547890773', '0');
INSERT INTO `ey_channelfield` VALUES ('56', 'lang', '0', '语言标识', 'text', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1547890773', '1547890773', '0');
INSERT INTO `ey_channelfield` VALUES ('57', 'prom_type', '0', '产品类型：0普通产品，1虚拟产品', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('58', 'users_price', '0', '价格', 'decimal', 'decimal(10,2)', '10', '0.00', '', '', '0', '0', '1', '0', '1', '1', '0', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('59', 'prom_type', '2', '产品类型：0普通产品，1虚拟产品', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('60', 'users_price', '2', '价格', 'decimal', 'decimal(10,2)', '10', '0.00', '', '', '0', '0', '1', '0', '1', '1', '0', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('61', 'users_id', '0', '会员ID', 'int', 'int(11)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('62', 'arc_level_id', '0', '文档会员权限ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('63', 'arc_level_id', '4', '文档会员权限ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('64', 'weapp_code', '-99', '插件栏目唯一标识', 'text', 'varchar(200)', '200', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('65', 'is_release', '-99', '栏目是否应用于会员投稿发布，1是，0否', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('66', 'old_price', '0', '产品旧价', 'decimal', 'decimal(10,2)', '10', '0.00', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('67', 'stock_count', '0', '商品库存量', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('68', 'stock_show', '0', '商品库存在产品详情页是否显示，1为显示，0为不显示', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('69', 'joinaid', '0', '关联文档ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('70', 'downcount', '0', '下载次数', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('71', 'downcount', '4', '下载次数', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('72', 'htmlfilename', '0', '自定义文件名', 'text', 'varchar(50)', '50', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('73', 'htmlfilename', '1', '自定义文件名', 'text', 'varchar(50)', '50', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('74', 'htmlfilename', '2', '自定义文件名', 'text', 'varchar(50)', '50', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('75', 'htmlfilename', '3', '自定义文件名', 'text', 'varchar(50)', '50', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('76', 'htmlfilename', '4', '自定义文件名', 'text', 'varchar(50)', '50', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('77', 'htmlfilename', '6', '自定义文件名', 'text', 'varchar(50)', '50', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('78', 'attrlist_id', '0', '参数列表ID', 'int', 'int(10) unsigned', '10', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533091930', '1533091930', '0');
INSERT INTO `ey_channelfield` VALUES ('79', 'sales_num', '0', '销售量', 'int', 'int(10) unsigned', '10', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533091930', '1533091930', '0');
INSERT INTO `ey_channelfield` VALUES ('81', 'topid', '-99', '顶级栏目ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('82', 'is_slide', '0', '是否幻灯', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092420', '1533092420', '0');
INSERT INTO `ey_channelfield` VALUES ('83', 'is_roll', '0', '是否幻灯', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092420', '1533092420', '0');
INSERT INTO `ey_channelfield` VALUES ('84', 'is_diyattr', '0', '是否自定义', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092420', '1533092420', '0');
INSERT INTO `ey_channelfield` VALUES ('85', 'update_time', '5', '更新时间', 'datetime', 'int(11)', '11', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('86', 'add_time', '5', '新增时间', 'datetime', 'int(11)', '11', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('87', 'htmlfilename', '5', '自定义文件名', 'text', 'varchar(50)', '50', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('88', 'downcount', '5', '下载次数', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('89', 'joinaid', '5', '关联文档ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('90', 'del_method', '5', '伪删除状态，1为主动删除，2为跟随上级栏目被动删除', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('91', 'is_del', '5', '伪删除，1=是，0=否', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('92', 'arc_level_id', '5', '文档会员权限ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('93', 'users_id', '5', '会员ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('94', 'admin_id', '5', '管理员ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('95', 'lang', '5', '语言标识', 'text', 'varchar(50)', '50', 'cn', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('96', 'sort_order', '5', '排序号', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('97', 'status', '5', '状态(0=屏蔽，1=正常)', 'switch', 'tinyint(1)', '1', '1', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('98', 'tempview', '5', '文档模板文件名', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('99', 'prom_type', '5', '产品类型：0=普通产品，1=虚拟(默认手动发货)，2=虚拟(网盘', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('100', 'stock_show', '5', '商品库存在产品详情页是否显示，1为显示，0为不显示', 'switch', 'tinyint(1) unsigned', '1', '1', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('101', 'stock_count', '5', '商品库存量', 'int', 'int(10) unsigned', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('102', 'sales_num', '5', '销售量', 'int', 'int(10) unsigned', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('103', 'old_price', '5', '产品旧价', 'decimal', 'decimal(10,2)', '10', '0.00', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('104', 'users_free', '5', '是否会员免费，默认0不免费，1为免费', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('105', 'users_price', '5', '会员价', 'decimal', 'decimal(10,2)', '10', '0.00', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('106', 'attrlist_id', '5', '参数列表ID', 'int', 'int(10) unsigned', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('107', 'seo_description', '5', 'SEO描述', 'multitext', 'text', '0', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('108', 'seo_keywords', '5', 'SEO关键词', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('109', 'seo_title', '5', 'SEO标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('110', 'ismake', '5', '是否静态页面（0=动态，1=静态）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('111', 'jumplinks', '5', '外链跳转', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('112', 'arcrank', '5', '阅读权限：0=开放浏览，-1=待审核稿件', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('113', 'click', '5', '浏览量', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('114', 'author', '5', '作者', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('115', 'is_diyattr', '5', '自定义（0=否，1=是）', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('116', 'is_slide', '5', '幻灯（0=否，1=是）', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('117', 'is_roll', '5', '滚动（0=否，1=是）', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('118', 'is_litpic', '5', '图片（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('119', 'is_jump', '5', '跳转链接（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('120', 'is_recom', '5', '推荐（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('121', 'is_top', '5', '置顶（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('122', 'is_special', '5', '特荐（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('123', 'is_head', '5', '头条（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('124', 'litpic', '5', '缩略图', 'img', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('125', 'title', '5', '标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('126', 'is_b', '5', '加粗', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('127', 'channel', '5', '模型ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('128', 'typeid', '5', '当前栏目', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('129', 'aid', '5', 'aid', 'int', 'int(10)', '10', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('130', 'content', '5', '内容详情', 'htmltext', 'longtext', '0', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('131', 'courseware', '5', '课件地址', 'text', 'varchar(200)', '200', '', '', '', '0', '1', '0', '0', '1', '0', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('132', 'courseware_free', '5', '课件收费', 'select', 'enum(\'免费\',\'收费\')', '0', '免费,收费', '', '', '0', '1', '0', '0', '1', '0', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('133', 'total_duration', '5', '视频总时长', 'int', 'int(10)', '10', '0', '', '', '0', '1', '0', '0', '1', '0', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('134', 'total_video', '5', '视频数', 'int', 'int(10)', '10', '0', '', '', '0', '1', '0', '0', '1', '0', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('135', 'update_time', '7', '更新时间', 'datetime', 'int(11)', '11', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('136', 'add_time', '7', '新增时间', 'datetime', 'int(11)', '11', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('137', 'htmlfilename', '7', '自定义文件名', 'text', 'varchar(50)', '50', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('138', 'downcount', '7', '下载次数', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('139', 'joinaid', '7', '关联文档ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('140', 'del_method', '7', '伪删除状态，1为主动删除，2为跟随上级栏目被动删除', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('141', 'is_del', '7', '伪删除，1=是，0=否', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('142', 'arc_level_id', '7', '文档会员权限ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('143', 'users_id', '7', '会员ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('144', 'admin_id', '7', '管理员ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('145', 'lang', '7', '语言标识', 'text', 'varchar(50)', '50', 'cn', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('146', 'sort_order', '7', '排序号', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('147', 'status', '7', '状态(0=屏蔽，1=正常)', 'switch', 'tinyint(1)', '1', '1', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('148', 'tempview', '7', '文档模板文件名', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('149', 'prom_type', '7', '产品类型：0=普通产品，1=虚拟(默认手动发货)，2=虚拟(网盘', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('150', 'stock_show', '7', '商品库存在产品详情页是否显示，1为显示，0为不显示', 'switch', 'tinyint(1) unsigned', '1', '1', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('151', 'stock_count', '7', '商品库存量', 'int', 'int(10) unsigned', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('152', 'sales_num', '7', '销售量', 'int', 'int(10) unsigned', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('153', 'old_price', '7', '产品旧价', 'decimal', 'decimal(10,2)', '10', '0.00', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('154', 'users_free', '7', '是否会员免费，默认0不免费，1为免费', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('155', 'users_price', '7', '会员价', 'decimal', 'decimal(10,2)', '10', '0.00', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('156', 'attrlist_id', '7', '参数列表ID', 'int', 'int(10) unsigned', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('157', 'seo_description', '7', 'SEO描述', 'multitext', 'text', '0', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('158', 'seo_keywords', '7', 'SEO关键词', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('159', 'seo_title', '7', 'SEO标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('160', 'ismake', '7', '是否静态页面（0=动态，1=静态）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('161', 'jumplinks', '7', '外链跳转', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('162', 'arcrank', '7', '阅读权限：0=开放浏览，-1=待审核稿件', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('163', 'click', '7', '浏览量', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('164', 'author', '7', '作者', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('165', 'is_diyattr', '7', '自定义（0=否，1=是）', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('166', 'is_slide', '7', '幻灯（0=否，1=是）', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('167', 'is_roll', '7', '滚动（0=否，1=是）', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('168', 'is_litpic', '7', '图片（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('169', 'is_jump', '7', '跳转链接（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('170', 'is_recom', '7', '推荐（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('171', 'is_top', '7', '置顶（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('172', 'is_special', '7', '特荐（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('173', 'is_head', '7', '头条（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('174', 'litpic', '7', '缩略图', 'img', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('175', 'title', '7', '标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('176', 'is_b', '7', '加粗', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('177', 'channel', '7', '模型ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('178', 'typeid', '7', '当前栏目', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('179', 'aid', '7', 'aid', 'int', 'int(10)', '10', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('180', 'content', '7', '内容详情', 'htmltext', 'longtext', '0', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('181', 'restric_type', '0', '限制模式，0=免费，1=付费，2=会员专享，3=会员付费', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('182', 'diy_dirpath', '-99', '自定义HTML保存路径', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('183', 'rulelist', '-99', '列表静态文件存放规则', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('184', 'ruleview', '-99', '文档静态文件存放规则', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('185', 'subtitle', '0', '副标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1636338535', '1636338535', '0');
INSERT INTO `ey_channelfield` VALUES ('186', 'origin', '0', '来源', 'text', 'varchar(30)', '30', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1636338535', '1636338535', '0');
INSERT INTO `ey_channelfield` VALUES ('187', 'stypeid', '0', '副栏目', 'text', 'varchar(90)', '90', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1636338535', '1636338535', '0');
INSERT INTO `ey_channelfield` VALUES ('242', 'mysize', '3', '文件大小', 'text', 'varchar(251)', '251', '', '', '', '0', '0', '1', '0', '0', '0', '0', '100', '1', '1641347761', '1641347761', '0');
INSERT INTO `ey_channelfield` VALUES ('243', 'banben', '3', '最新版本', 'text', 'varchar(251)', '251', '', '', '', '0', '0', '1', '0', '0', '0', '0', '100', '1', '1641347761', '1641347761', '0');
INSERT INTO `ey_channelfield` VALUES ('244', 'xitong', '3', '适合系统', 'text', 'varchar(251)', '251', '', '', '', '0', '0', '1', '0', '0', '0', '0', '100', '1', '1641347761', '1641347761', '0');
INSERT INTO `ey_channelfield` VALUES ('245', 'kaifazhe', '3', '开发者', 'text', 'varchar(251)', '251', '', '', '', '0', '0', '1', '0', '0', '0', '0', '100', '1', '1641347761', '1641347761', '0');
INSERT INTO `ey_channelfield` VALUES ('246', 'pingfen', '3', '评分', 'text', 'varchar(251)', '251', '5', '', '', '0', '0', '1', '0', '0', '0', '0', '100', '1', '1641347761', '1641347761', '0');
INSERT INTO `ey_channelfield` VALUES ('247', 'downs', '3', '下载次数', 'text', 'varchar(251)', '251', '3256', '', '', '0', '0', '1', '0', '0', '0', '0', '100', '1', '1641347761', '1641347761', '0');
INSERT INTO `ey_channelfield` VALUES ('248', 'downloads', '3', '下载地址', 'file', 'varchar(251)', '251', '', '', '', '0', '0', '1', '0', '0', '0', '0', '100', '1', '1641347761', '1641347761', '0');
INSERT INTO `ey_channelfield` VALUES ('251', 'update_time', '3', '更新时间', 'datetime', 'int(11)', '11', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641348982', '1641348982', '0');
INSERT INTO `ey_channelfield` VALUES ('252', 'add_time', '3', '新增时间', 'datetime', 'int(11)', '11', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641348982', '1641348982', '0');
INSERT INTO `ey_channelfield` VALUES ('253', 'area_id', '3', '所在区域', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641348982', '1641348982', '0');
INSERT INTO `ey_channelfield` VALUES ('254', 'city_id', '3', '所在城市', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641348982', '1641348982', '0');
INSERT INTO `ey_channelfield` VALUES ('255', 'province_id', '3', '省份', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641348982', '1641348982', '0');
INSERT INTO `ey_channelfield` VALUES ('256', 'collection', '3', '收藏数', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641348982', '1641348982', '0');
INSERT INTO `ey_channelfield` VALUES ('257', 'appraise', '3', '评价数', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641348982', '1641348982', '0');
INSERT INTO `ey_channelfield` VALUES ('258', 'downcount', '3', '下载次数', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641348982', '1641348982', '0');
INSERT INTO `ey_channelfield` VALUES ('259', 'joinaid', '3', '关联文档ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641348982', '1641348982', '0');
INSERT INTO `ey_channelfield` VALUES ('260', 'del_method', '3', '伪删除状态，1为主动删除，2为跟随上级栏目被动删除', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641348982', '1641348982', '0');
INSERT INTO `ey_channelfield` VALUES ('261', 'is_del', '3', '伪删除，1=是，0=否', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641348982', '1641348982', '0');
INSERT INTO `ey_channelfield` VALUES ('262', 'restric_type', '3', '限制模式，0=免费，1=付费，2=会员专享，3=会员付费', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641348982', '1641348982', '0');
INSERT INTO `ey_channelfield` VALUES ('263', 'arc_level_id', '3', '文档会员权限ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641348982', '1641348982', '0');
INSERT INTO `ey_channelfield` VALUES ('264', 'users_id', '3', '会员ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641348982', '1641348982', '0');
INSERT INTO `ey_channelfield` VALUES ('265', 'admin_id', '3', '管理员ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641348982', '1641348982', '0');
INSERT INTO `ey_channelfield` VALUES ('266', 'lang', '3', '语言标识', 'text', 'varchar(50)', '50', 'cn', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641348982', '1641348982', '0');
INSERT INTO `ey_channelfield` VALUES ('267', 'sort_order', '3', '排序号', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641348982', '1641348982', '0');
INSERT INTO `ey_channelfield` VALUES ('268', 'status', '3', '状态(0=屏蔽，1=正常)', 'switch', 'tinyint(1)', '1', '1', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641348982', '1641348982', '0');
INSERT INTO `ey_channelfield` VALUES ('269', 'tempview', '3', '文档模板文件名', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641348982', '1641348982', '0');
INSERT INTO `ey_channelfield` VALUES ('270', 'prom_type', '3', '产品类型：0=普通产品，1=虚拟(默认手动发货)，2=虚拟(网盘)，3=虚拟(自定义文本)', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641348982', '1641348982', '0');
INSERT INTO `ey_channelfield` VALUES ('271', 'stock_show', '3', '商品库存在产品详情页是否显示，1为显示，0为不显示', 'switch', 'tinyint(1) unsigned', '1', '1', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641348982', '1641348982', '0');
INSERT INTO `ey_channelfield` VALUES ('272', 'stock_count', '3', '商品库存量', 'int', 'int(10) unsigned', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641348982', '1641348982', '0');
INSERT INTO `ey_channelfield` VALUES ('273', 'sales_num', '3', '销售量', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641348982', '1641348982', '0');
INSERT INTO `ey_channelfield` VALUES ('274', 'old_price', '3', '产品旧价', 'decimal', 'decimal(10,2)', '10', '0.00', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641348982', '1641348982', '0');
INSERT INTO `ey_channelfield` VALUES ('275', 'users_free', '3', '是否会员免费，默认0不免费，1为免费', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641348982', '1641348982', '0');
INSERT INTO `ey_channelfield` VALUES ('276', 'users_price', '3', '会员价', 'decimal', 'decimal(10,2)', '10', '0.00', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641348982', '1641348982', '0');
INSERT INTO `ey_channelfield` VALUES ('277', 'attrlist_id', '3', '参数列表ID', 'int', 'int(10) unsigned', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641348982', '1641348982', '0');
INSERT INTO `ey_channelfield` VALUES ('278', 'seo_description', '3', 'SEO描述', 'multitext', 'text', '0', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641348982', '1641348982', '0');
INSERT INTO `ey_channelfield` VALUES ('279', 'seo_keywords', '3', 'SEO关键词', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641348982', '1641348982', '0');
INSERT INTO `ey_channelfield` VALUES ('280', 'seo_title', '3', 'SEO标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641348982', '1641348982', '0');
INSERT INTO `ey_channelfield` VALUES ('281', 'ismake', '3', '是否静态页面（0=动态，1=静态）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641348982', '1641348982', '0');
INSERT INTO `ey_channelfield` VALUES ('282', 'jumplinks', '3', '外链跳转', 'text', 'varchar(255)', '255', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641348982', '1641348982', '0');
INSERT INTO `ey_channelfield` VALUES ('283', 'arcrank', '3', '阅读权限：0=开放浏览，-1=待审核稿件', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641348982', '1641348982', '0');
INSERT INTO `ey_channelfield` VALUES ('284', 'click', '3', '浏览量', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641348982', '1641348982', '0');
INSERT INTO `ey_channelfield` VALUES ('285', 'author', '3', '作者', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641348982', '1641348982', '0');
INSERT INTO `ey_channelfield` VALUES ('286', 'origin', '3', '来源', 'text', 'varchar(30)', '30', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641348982', '1641348982', '0');
INSERT INTO `ey_channelfield` VALUES ('287', 'is_diyattr', '3', '自定义（0=否，1=是）', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641348982', '1641348982', '0');
INSERT INTO `ey_channelfield` VALUES ('288', 'is_slide', '3', '幻灯（0=否，1=是）', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641348982', '1641348982', '0');
INSERT INTO `ey_channelfield` VALUES ('289', 'is_roll', '3', '滚动（0=否，1=是）', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641348982', '1641348982', '0');
INSERT INTO `ey_channelfield` VALUES ('290', 'is_litpic', '3', '图片（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641348982', '1641348982', '0');
INSERT INTO `ey_channelfield` VALUES ('291', 'is_jump', '3', '跳转链接（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641348982', '1641348982', '0');
INSERT INTO `ey_channelfield` VALUES ('292', 'is_recom', '3', '推荐（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641348982', '1641348982', '0');
INSERT INTO `ey_channelfield` VALUES ('293', 'is_top', '3', '置顶（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641348982', '1641348982', '0');
INSERT INTO `ey_channelfield` VALUES ('294', 'is_special', '3', '特荐（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641348982', '1641348982', '0');
INSERT INTO `ey_channelfield` VALUES ('295', 'is_head', '3', '头条（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641348982', '1641348982', '0');
INSERT INTO `ey_channelfield` VALUES ('296', 'litpic', '3', '缩略图', 'img', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641348982', '1641348982', '0');
INSERT INTO `ey_channelfield` VALUES ('297', 'subtitle', '3', '副标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641348982', '1641348982', '0');
INSERT INTO `ey_channelfield` VALUES ('298', 'title', '3', '标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641348982', '1641348982', '0');
INSERT INTO `ey_channelfield` VALUES ('299', 'is_b', '3', '加粗', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641348982', '1641348982', '0');
INSERT INTO `ey_channelfield` VALUES ('300', 'channel', '3', '模型ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641348982', '1641348982', '0');
INSERT INTO `ey_channelfield` VALUES ('301', 'stypeid', '3', '副栏目ID集合', 'text', 'varchar(90)', '90', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641348982', '1641348982', '0');
INSERT INTO `ey_channelfield` VALUES ('302', 'typeid', '3', '当前栏目', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641348982', '1641348982', '0');
INSERT INTO `ey_channelfield` VALUES ('303', 'aid', '3', 'aid', 'int', 'int(10)', '10', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641348982', '1641348982', '0');
INSERT INTO `ey_channelfield` VALUES ('304', 'target', '-99', '新窗口打开', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1547890773', '1547890773', '0');
INSERT INTO `ey_channelfield` VALUES ('305', 'nofollow', '-99', '防抓取', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1547890773', '1547890773', '0');
INSERT INTO `ey_channelfield` VALUES ('306', 'content_ey_m', '1', '手机端内容详情', 'htmltext', 'longtext', '250', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1533464713', '1623047123', '0');
INSERT INTO `ey_channelfield` VALUES ('307', 'content_ey_m', '2', '手机端内容详情', 'htmltext', 'longtext', '250', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1645086030', '1645086039', '0');
INSERT INTO `ey_channelfield` VALUES ('308', 'content_ey_m', '3', '手机端内容详情', 'htmltext', 'longtext', '250', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1533359588', '1533359588', '0');
INSERT INTO `ey_channelfield` VALUES ('309', 'content_ey_m', '4', '手机端内容详情', 'htmltext', 'longtext', '250', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1533359752', '1533359752', '0');
INSERT INTO `ey_channelfield` VALUES ('310', 'content_ey_m', '5', '手机端内容详情', 'htmltext', 'longtext', '250', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1591957363', '1591957363', '0');
INSERT INTO `ey_channelfield` VALUES ('311', 'content_ey_m', '6', '手机端内容详情', 'htmltext', 'longtext', '250', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1533464715', '1533464715', '0');
INSERT INTO `ey_channelfield` VALUES ('312', 'content_ey_m', '7', '手机端内容详情', 'htmltext', 'longtext', '250', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1602320145', '1602320145', '0');
INSERT INTO `ey_channelfield` VALUES ('313', 'typearcrank', '-99', '阅读权限：0=开放浏览，-1=待审核稿件', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1547890773', '1547890773', '0');
INSERT INTO `ey_channelfield` VALUES ('314', 'empty_logic', '-99', '空内容逻辑', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('315', 'no_vip_pay', '3', 'restric_type = 2 时,会员专享,非会员可付费使用,0-关闭,1-开启', 'switch', 'tinyint(3)', '3', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1684305369', '1684305369', '0');
INSERT INTO `ey_channelfield` VALUES ('316', 'sales_all', '3', '虚拟总销量', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1684305369', '1684305369', '0');
INSERT INTO `ey_channelfield` VALUES ('317', 'virtual_sales', '3', '商品虚拟销售量', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1684305369', '1684305369', '0');
INSERT INTO `ey_channelfield` VALUES ('318', 'free_shipping', '3', '商品是否包邮(1包邮(免运费)  0跟随系统)', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1684305369', '1684305369', '0');
INSERT INTO `ey_channelfield` VALUES ('319', 'merchant_id', '3', '多商家ID', 'datetime', 'int(11) unsigned', '11', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1684305369', '1684305369', '0');
INSERT INTO `ey_channelfield` VALUES ('320', 'bigpic', '3', '大缩略图', 'img', 'varchar(500)', '500', '', '', '', '0', '0', '1', '0', '0', '0', '0', '100', '1', '1684305423', '1684305423', '0');

-- -----------------------------
-- Table structure for `ey_channelfield_bind`
-- -----------------------------
DROP TABLE IF EXISTS `ey_channelfield_bind`;
CREATE TABLE `ey_channelfield_bind` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `typeid` int(10) DEFAULT '0' COMMENT '栏目ID',
  `field_id` int(10) DEFAULT '0' COMMENT '自定义字段ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=22 DEFAULT CHARSET=utf8 COMMENT='栏目与自定义字段绑定表';

-- -----------------------------
-- Records of `ey_channelfield_bind`
-- -----------------------------
INSERT INTO `ey_channelfield_bind` VALUES ('1', '0', '24', '1641348981', '1641348981');
INSERT INTO `ey_channelfield_bind` VALUES ('2', '0', '25', '1641348981', '1641348981');
INSERT INTO `ey_channelfield_bind` VALUES ('3', '0', '26', '1641348981', '1641348981');
INSERT INTO `ey_channelfield_bind` VALUES ('4', '0', '27', '1641348981', '1641348981');
INSERT INTO `ey_channelfield_bind` VALUES ('5', '0', '29', '1641348981', '1641348981');
INSERT INTO `ey_channelfield_bind` VALUES ('6', '0', '130', '1641348981', '1641348981');
INSERT INTO `ey_channelfield_bind` VALUES ('7', '0', '131', '1641348981', '1641348981');
INSERT INTO `ey_channelfield_bind` VALUES ('8', '0', '132', '1641348981', '1641348981');
INSERT INTO `ey_channelfield_bind` VALUES ('9', '0', '133', '1641348981', '1641348981');
INSERT INTO `ey_channelfield_bind` VALUES ('10', '0', '134', '1641348981', '1641348981');
INSERT INTO `ey_channelfield_bind` VALUES ('11', '0', '180', '1641348981', '1641348981');
INSERT INTO `ey_channelfield_bind` VALUES ('12', '0', '242', '1641348981', '1641348981');
INSERT INTO `ey_channelfield_bind` VALUES ('13', '0', '243', '1641348981', '1641348981');
INSERT INTO `ey_channelfield_bind` VALUES ('14', '0', '244', '1641348981', '1641348981');
INSERT INTO `ey_channelfield_bind` VALUES ('15', '0', '245', '1641348981', '1641348981');
INSERT INTO `ey_channelfield_bind` VALUES ('16', '0', '246', '1641348981', '1641348981');
INSERT INTO `ey_channelfield_bind` VALUES ('17', '0', '247', '1641348981', '1641348981');
INSERT INTO `ey_channelfield_bind` VALUES ('18', '0', '248', '1641348981', '1641348981');
INSERT INTO `ey_channelfield_bind` VALUES ('19', '0', '249', '1641348981', '1641348981');
INSERT INTO `ey_channelfield_bind` VALUES ('21', '10', '320', '1684305423', '1684305423');

-- -----------------------------
-- Table structure for `ey_channelfield_log`
-- -----------------------------
DROP TABLE IF EXISTS `ey_channelfield_log`;
CREATE TABLE `ey_channelfield_log` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT '' COMMENT '字段名称',
  `channel_id` int(10) DEFAULT '0' COMMENT '模型ID',
  `dtype` varchar(32) DEFAULT '' COMMENT '字段类型',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='自定义字段日志表';


-- -----------------------------
-- Table structure for `ey_channeltype`
-- -----------------------------
DROP TABLE IF EXISTS `ey_channeltype`;
CREATE TABLE `ey_channeltype` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nid` varchar(50) NOT NULL DEFAULT '' COMMENT '识别id',
  `title` varchar(30) DEFAULT '' COMMENT '名称',
  `ntitle` varchar(30) DEFAULT '' COMMENT '左侧菜单名称',
  `table` varchar(50) DEFAULT '' COMMENT '表名',
  `ctl_name` varchar(50) DEFAULT '' COMMENT '控制器名称（区分大小写）',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态(1=启用，0=屏蔽)',
  `ifsystem` tinyint(1) DEFAULT '0' COMMENT '字段分类，1=系统(不可修改)，0=自定义',
  `is_repeat_title` tinyint(1) DEFAULT '1' COMMENT '文档标题重复，1=允许，0=不允许',
  `is_release` tinyint(1) DEFAULT '0' COMMENT '模型是否允许应用于会员投稿发布，1是，0否',
  `is_litpic_users_release` tinyint(1) DEFAULT '1' COMMENT '缩略图是否应用于会员投稿，1=允许，0=不允许',
  `data` text COMMENT '额外序列化存储数据',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '伪删除，1=是，0=否',
  `sort_order` smallint(6) DEFAULT '50' COMMENT '排序',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idention` (`nid`) USING BTREE,
  UNIQUE KEY `ctl_name` (`ctl_name`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=108 DEFAULT CHARSET=utf8 COMMENT='系统模型表';

-- -----------------------------
-- Records of `ey_channeltype`
-- -----------------------------
INSERT INTO `ey_channeltype` VALUES ('1', 'article', '文章模型', '文章', 'article', 'Article', '1', '1', '1', '1', '1', '', '0', '1', '0', '1531800410');
INSERT INTO `ey_channeltype` VALUES ('4', 'download', '下载模型', '下载', 'download', 'Download', '1', '1', '1', '1', '1', '', '0', '4', '0', '1531800410');
INSERT INTO `ey_channeltype` VALUES ('2', 'product', '产品模型', '产品', 'product', 'Product', '1', '1', '1', '1', '1', '', '0', '2', '0', '1531800410');
INSERT INTO `ey_channeltype` VALUES ('8', 'guestbook', '留言模型', '留言', 'guestbook', 'Guestbook', '1', '1', '1', '1', '1', '', '0', '8', '1509197711', '1531800410');
INSERT INTO `ey_channeltype` VALUES ('6', 'single', '单页模型', '单页', 'single', 'Single', '1', '1', '1', '1', '1', '', '0', '6', '1523091961', '1531800410');
INSERT INTO `ey_channeltype` VALUES ('3', 'images', '图集模型', '图集', 'images', 'Images', '1', '1', '1', '1', '1', '', '0', '3', '1523929121', '1531800410');
INSERT INTO `ey_channeltype` VALUES ('5', 'media', '视频模型', '视频', 'media', 'Media', '0', '1', '1', '1', '1', '', '0', '5', '1509197711', '1564532747');
INSERT INTO `ey_channeltype` VALUES ('7', 'special', '专题模型', '专题', 'special', 'Special', '1', '1', '1', '1', '1', '', '0', '7', '1509197711', '1684375956');
INSERT INTO `ey_channeltype` VALUES ('51', 'ask', '问答模型', '问答', 'ask', 'Ask', '0', '1', '1', '1', '1', '', '1', '9', '1509197711', '1684487717');

-- -----------------------------
-- Table structure for `ey_citysite`
-- -----------------------------
DROP TABLE IF EXISTS `ey_citysite`;
CREATE TABLE `ey_citysite` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `name` varchar(32) DEFAULT '' COMMENT '地区名称',
  `level` tinyint(4) DEFAULT '0' COMMENT '地区等级 分省市县区',
  `parent_id` int(10) DEFAULT '0' COMMENT '父id',
  `topid` int(10) DEFAULT '0' COMMENT '顶级ID',
  `initial` varchar(5) DEFAULT '' COMMENT '首字母',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态（1：开启，0：隐藏）',
  `is_hot` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否热门',
  `domain` varchar(50) NOT NULL DEFAULT '' COMMENT '二级域名',
  `is_open` tinyint(1) DEFAULT '0' COMMENT '二级域名开启状态，0=否，1=是',
  `seoset` tinyint(1) DEFAULT '0' COMMENT 'SEO设置，0=使用主站，1=自定义',
  `seo_title` varchar(200) DEFAULT '' COMMENT 'SEO标题',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT 'SEO关键词',
  `seo_description` text COMMENT 'SEO描述',
  `sort_order` int(6) unsigned NOT NULL DEFAULT '100' COMMENT '排序',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  `showall` tinyint(3) DEFAULT '1' COMMENT '是否显示主站信息',
  PRIMARY KEY (`id`),
  KEY `domain` (`domain`) USING BTREE,
  KEY `level` (`level`,`status`) USING BTREE,
  KEY `initial` (`initial`,`sort_order`,`id`) USING BTREE,
  KEY `parent_id` (`parent_id`,`status`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='城市分站表';


-- -----------------------------
-- Table structure for `ey_common_pic`
-- -----------------------------
DROP TABLE IF EXISTS `ey_common_pic`;
CREATE TABLE `ey_common_pic` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '常用图片ID',
  `pic_path` varchar(255) NOT NULL DEFAULT '' COMMENT '图片地址',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '多语言',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=25 DEFAULT CHARSET=utf8 COMMENT='常用图片';

-- -----------------------------
-- Records of `ey_common_pic`
-- -----------------------------
INSERT INTO `ey_common_pic` VALUES ('23', '/uploads/allimg/20230518/1-23051Q609312M.jpg', 'cn', '1684397373', '1684397373');
INSERT INTO `ey_common_pic` VALUES ('24', '/uploads/allimg/20230519/1-230519102924237.jpg', 'cn', '1684463365', '1684463365');
INSERT INTO `ey_common_pic` VALUES ('4', '/eyou/uploads/allimg/20220105/1-220105141Q1258.png', 'cn', '1641363493', '1641363493');
INSERT INTO `ey_common_pic` VALUES ('5', '/uploads/allimg/20230517/1-23051G41614L4.png', 'cn', '1684304175', '1684304175');
INSERT INTO `ey_common_pic` VALUES ('6', '/uploads/allimg/20230517/1-23051G44242193.jpg', 'cn', '1684305763', '1684305763');
INSERT INTO `ey_common_pic` VALUES ('7', '/uploads/allimg/20230517/1-23051G4425B49.jpg', 'cn', '1684305776', '1684305776');
INSERT INTO `ey_common_pic` VALUES ('8', '/uploads/allimg/20230517/1-23051G44305928.jpg', 'cn', '1684305786', '1684305786');
INSERT INTO `ey_common_pic` VALUES ('9', '/uploads/allimg/20230517/1-23051G44313613.jpg', 'cn', '1684305794', '1684305794');
INSERT INTO `ey_common_pic` VALUES ('10', '/uploads/allimg/20230517/1-23051G44323229.jpg', 'cn', '1684305804', '1684305804');
INSERT INTO `ey_common_pic` VALUES ('11', '/uploads/allimg/20230517/1-23051G443349A.jpg', 'cn', '1684305815', '1684305815');
INSERT INTO `ey_common_pic` VALUES ('12', '/uploads/allimg/20230517/1-23051G44342A4.jpg', 'cn', '1684305824', '1684305824');
INSERT INTO `ey_common_pic` VALUES ('13', '/uploads/allimg/20230517/1-23051G4435XM.jpg', 'cn', '1684305840', '1684305840');
INSERT INTO `ey_common_pic` VALUES ('14', '/uploads/allimg/20230518/1-23051P91521X2.jpg', 'cn', '1684372522', '1684372522');
INSERT INTO `ey_common_pic` VALUES ('15', '/uploads/allimg/20230518/1-23051P92023F3.jpg', 'cn', '1684372824', '1684372824');
INSERT INTO `ey_common_pic` VALUES ('16', '/uploads/allimg/20230518/1-23051P92034K0.jpg', 'cn', '1684372834', '1684372834');
INSERT INTO `ey_common_pic` VALUES ('17', '/uploads/allimg/20230518/1-23051Q02946247.png', 'cn', '1684376987', '1684376987');
INSERT INTO `ey_common_pic` VALUES ('18', '/uploads/allimg/20230518/1-23051Q04512Z7.jpg', 'cn', '1684377913', '1684377913');
INSERT INTO `ey_common_pic` VALUES ('19', '/uploads/allimg/20230518/1-23051Q04Q1138.jpg', 'cn', '1684378092', '1684378092');
INSERT INTO `ey_common_pic` VALUES ('20', '/uploads/allimg/20230518/1-23051Q04SB43.jpg', 'cn', '1684378117', '1684378117');
INSERT INTO `ey_common_pic` VALUES ('21', '/uploads/allimg/20230518/1-23051Q60R5114.png', 'cn', '1684397306', '1684397306');
INSERT INTO `ey_common_pic` VALUES ('22', '/uploads/allimg/20230518/1-23051Q60ZQ64.png', 'cn', '1684397349', '1684397349');

-- -----------------------------
-- Table structure for `ey_config`
-- -----------------------------
DROP TABLE IF EXISTS `ey_config`;
CREATE TABLE `ey_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT '' COMMENT '配置的key键名',
  `value` text,
  `inc_type` varchar(64) DEFAULT '' COMMENT '配置分组',
  `desc` varchar(50) DEFAULT '' COMMENT '描述',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '是否已删除，0=否，1=是',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=192 DEFAULT CHARSET=utf8 COMMENT='系统配置表';

-- -----------------------------
-- Records of `ey_config`
-- -----------------------------
INSERT INTO `ey_config` VALUES ('1', 'is_mark', '0', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('2', 'mark_txt', '易优Cms', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('3', 'mark_img', '/public/upload/water/2018/05/08/93806077e5a4c4e12ceed30df5cde761.png', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('4', 'mark_width', '200', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('5', 'mark_height', '50', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('6', 'mark_degree', '54', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('7', 'mark_quality', '56', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('8', 'mark_sel', '9', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('9', 'sms_time_out', '120', 'sms', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('10', 'theme_style', '1', 'basic', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('11', 'file_size', '100', 'basic', '', 'cn', '0', '1641348698');
INSERT INTO `ey_config` VALUES ('12', 'image_type', 'jpg|gif|png|bmp|jpeg|ico', 'basic', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('13', 'file_type', 'zip|gz|rar|iso|doc|xsl|ppt|wps', 'basic', '', 'cn', '0', '1641347760');
INSERT INTO `ey_config` VALUES ('14', 'media_type', 'swf|mpg|mp3|rm|rmvb|wmv|wma|wav|mid|mov', 'basic', '', 'cn', '0', '1641347760');
INSERT INTO `ey_config` VALUES ('15', 'web_keywords', '', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('17', 'sms_platform', '1', 'sms', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('18', 'seo_viewtitle_format', '2', 'seo', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('19', 'smtp_server', 'smtp.qq.com', 'smtp', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('20', 'smtp_port', '25', 'smtp', '', 'cn', '0', '1641347760');
INSERT INTO `ey_config` VALUES ('21', 'smtp_user', 'desdev@vip.qq.com', 'smtp', '', 'cn', '0', '1641347760');
INSERT INTO `ey_config` VALUES ('22', 'smtp_pwd', '7260444huxiao', 'smtp', '', 'cn', '0', '1641347760');
INSERT INTO `ey_config` VALUES ('23', 'inc_type', 'smtp', 'smtp', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('24', 'mark_type', 'img', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('25', 'mark_txt_size', '30', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('26', 'mark_txt_color', '#000000', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('27', 'oss_switch', '0', 'oss', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('28', 'web_name', '游戏软件APP应用下载网站模板', 'web', '', 'cn', '0', '1684467517');
INSERT INTO `ey_config` VALUES ('29', 'web_logo', '/uploads/allimg/20230517/1-23051G41614L4.png', 'web', '', 'cn', '0', '1684304178');
INSERT INTO `ey_config` VALUES ('30', 'web_ico', '/favicon.ico', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('31', 'web_basehost', 'http://e16.eyou.hk', 'web', '', 'cn', '0', '1641347760');
INSERT INTO `ey_config` VALUES ('32', 'web_description', '', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('79', 'web_recordnum', 'ICP备xxxxxxxx号', 'web', '', 'cn', '0', '1641347760');
INSERT INTO `ey_config` VALUES ('33', 'web_copyright', 'Copyright © 2019-2023 游戏软件网 版权所有', 'web', '', 'cn', '0', '1684467517');
INSERT INTO `ey_config` VALUES ('34', 'web_thirdcode_pc', '', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('35', 'web_thirdcode_wap', '', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('39', 'seo_arcdir', '/html', 'seo', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('40', 'seo_pseudo', '1', 'seo', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('41', 'list_symbol', '>', 'basic', '', 'cn', '0', '1641347760');
INSERT INTO `ey_config` VALUES ('42', 'sitemap_auto', '1', 'sitemap', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('43', 'sitemap_not1', '0', 'sitemap', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('44', 'sitemap_not2', '1', 'sitemap', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('45', 'sitemap_xml', '1', 'sitemap', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('46', 'sitemap_txt', '0', 'sitemap', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('47', 'sitemap_zzbaidutoken', '', 'sitemap', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('48', 'seo_expires_in', '7200', 'seo', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('55', 'web_title', '游戏软件APP应用下载网站模板', 'web', '', 'cn', '0', '1684467517');
INSERT INTO `ey_config` VALUES ('56', 'smtp_test_eamil', 'xxxxxxxx@qq.com', 'smtp', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('57', 'web_authortoken', '', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('62', 'seo_inlet', '1', 'seo', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('63', 'web_cmspath', '', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('64', 'web_sqldatapath', '/data/sqldata_nuhemc8farGCkyuehQEf', 'web', '', 'cn', '0', '1684114841');
INSERT INTO `ey_config` VALUES ('65', 'web_cmsurl', '', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('66', 'web_templets_dir', '/template', 'web', '', 'cn', '0', '1641347890');
INSERT INTO `ey_config` VALUES ('67', 'web_templeturl', '/template', 'web', '', 'cn', '0', '1641347890');
INSERT INTO `ey_config` VALUES ('68', 'web_templets_pc', '/template/pc', 'web', '', 'cn', '0', '1641347890');
INSERT INTO `ey_config` VALUES ('69', 'web_templets_m', '/template/mobile', 'web', '', 'cn', '0', '1641347890');
INSERT INTO `ey_config` VALUES ('70', 'web_eyoucms', 'http://www.eyoucms.com', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('78', '_cmscopyright', 'jdFbzvsEHAAzE6PfTTropP7s', 'php', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('76', 'seo_liststitle_format', '2', 'seo', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('77', 'web_status', '0', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('80', 'web_is_authortoken', '0', 'web', '', 'cn', '0', '1684114832');
INSERT INTO `ey_config` VALUES ('81', 'web_adminbasefile', '/login.php', 'web', '', 'cn', '0', '1650871614');
INSERT INTO `ey_config` VALUES ('82', 'seo_rewrite_format', '1', 'seo', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('83', 'web_cmsmode', '2', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('84', 'web_htmlcache_expires_in', '0', 'web', '', 'cn', '0', '1641347890');
INSERT INTO `ey_config` VALUES ('85', 'web_show_popup_upgrade', '1', 'web', '', 'cn', '0', '1650871625');
INSERT INTO `ey_config` VALUES ('86', 'web_weapp_switch', '-1', 'web', '', 'cn', '0', '1641347886');
INSERT INTO `ey_config` VALUES ('88', 'seo_dynamic_format', '1', 'seo', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('89', 'system_sql_mode', 'ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION', 'system', '', 'cn', '0', '1684114831');
INSERT INTO `ey_config` VALUES ('90', 'system_home_default_lang', 'cn', 'system', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('91', 'system_langnum', '1', 'system', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('92', 'system_auth_code', '$2y$11$f282b96dc1c50dc727dd53a', 'system', '', 'cn', '0', '1611053262');
INSERT INTO `ey_config` VALUES ('93', 'system_robots_edit', '1', 'system', '', 'cn', '0', '1611053268');
INSERT INTO `ey_config` VALUES ('94', 'system_synleveldata', '1', 'system', '', 'cn', '0', '1611053268');
INSERT INTO `ey_config` VALUES ('95', 'system_upgrade_filelist', 'YXBwbGljYXRpb24vY29tbW9uL2NvbnRyb2xsZXIvQ29tbW9uLnBocDxicj5hcHBsaWNhdGlvbi9jb21tb24vbG9naWMvT3NzTG9naWMucGhwPGJyPmFwcGxpY2F0aW9uL2NvbW1vbi9sb2dpYy9TbXNMb2dpYy5waHA8YnI+YXBwbGljYXRpb24vY29tbW9uL2xvZ2ljL0Z1bmN0aW9uTG9naWMucGhwPGJyPmFwcGxpY2F0aW9uL2NvbW1vbi9sb2dpYy9CdWlsZGh0bWxMb2dpYy5waHA8YnI+YXBwbGljYXRpb24vY29tbW9uL2xvZ2ljL0VtYWlsTG9naWMucGhwPGJyPmFwcGxpY2F0aW9uL2NvbW1vbi9sb2dpYy9OYXZpZ2F0aW9uTG9naWMucGhwPGJyPmFwcGxpY2F0aW9uL2NvbW1vbi9tb2RlbC9TaG9wUHVibGljSGFuZGxlLnBocDxicj5hcHBsaWNhdGlvbi9jb21tb24vbW9kZWwvV2VhcHAucGhwPGJyPmFwcGxpY2F0aW9uL2NvbW1vbi9tb2RlbC9Bc2tTY29yZUxldmVsLnBocDxicj5hcHBsaWNhdGlvbi9jb21tb24vbW9kZWwvQXJjdHlwZS5waHA8YnI+YXBwbGljYXRpb24vY29tbW9uL21vZGVsL09yZGVyUHJlSGFuZGxlLnBocDxicj5hcHBsaWNhdGlvbi9jb21tb24vbW9kZWwvUmVnaW9uLnBocDxicj5hcHBsaWNhdGlvbi9jb21tb24vbW9kZWwvU3BlY2lhbC5waHA8YnI+YXBwbGljYXRpb24vY29tbW9uL21vZGVsL0xhbmd1YWdlQXR0ci5waHA8YnI+YXBwbGljYXRpb24vY29tbW9uL21vZGVsL1NxbENhY2hlVGFibGUucGhwPGJyPmFwcGxpY2F0aW9uL2NvbW1vbi9tb2RlbC9Vc2Vyc0xldmVsLnBocDxicj5hcHBsaWNhdGlvbi9jb21tb24vbW9kZWwvRXlvdVVzZXJzLnBocDxicj5hcHBsaWNhdGlvbi9jb21tb24vbW9kZWwvQ2hhbm5lbGZpZWxkLnBocDxicj5hcHBsaWNhdGlvbi9jb21tb24vbW9kZWwvQXNrVHlwZS5waHA8YnI+YXBwbGljYXRpb24vY29tbW9uL21vZGVsL0xhbmd1YWdlLnBocDxicj5hcHBsaWNhdGlvbi91c2VyL2NvbnRyb2xsZXIvUGF5QXBpLnBocDxicj5hcHBsaWNhdGlvbi91c2VyL2NvbnRyb2xsZXIvUGF5LnBocDxicj5hcHBsaWNhdGlvbi91c2VyL2NvbnRyb2xsZXIvTWVkaWEucGhwPGJyPmFwcGxpY2F0aW9uL3VzZXIvY29udHJvbGxlci9BcnRpY2xlLnBocDxicj5hcHBsaWNhdGlvbi91c2VyL2NvbnRyb2xsZXIvVXNlcnNSZWxlYXNlLnBocDxicj5hcHBsaWNhdGlvbi91c2VyL2NvbnRyb2xsZXIvTGV2ZWwucGhwPGJyPmFwcGxpY2F0aW9uL3VzZXIvY29udHJvbGxlci9CYXNlLnBocDxicj5hcHBsaWNhdGlvbi91c2VyL2NvbnRyb2xsZXIvTWVtZ2lmdC5waHA8YnI+YXBwbGljYXRpb24vdXNlci9jb250cm9sbGVyL0Rvd25sb2FkLnBocDxicj5hcHBsaWNhdGlvbi91c2VyL2NvbnRyb2xsZXIvU2hvcENvbW1lbnQucGhwPGJyPmFwcGxpY2F0aW9uL3VzZXIvY29udHJvbGxlci9TaG9wLnBocDxicj5hcHBsaWNhdGlvbi91c2VyL2NvbnRyb2xsZXIvU210cG1haWwucGhwPGJyPmFwcGxpY2F0aW9uL3VzZXIvY29udHJvbGxlci9Bc2sucGhwPGJyPmFwcGxpY2F0aW9uL3VzZXIvY29udHJvbGxlci9Vc2Vyc05vdGljZS5waHA8YnI+YXBwbGljYXRpb24vdXNlci9jb250cm9sbGVyL1VzZXJzLnBocDxicj5hcHBsaWNhdGlvbi91c2VyL2NvbnRyb2xsZXIvVXBsb2FkaWZ5LnBocDxicj5hcHBsaWNhdGlvbi91c2VyL2xvZ2ljL0Z1bmN0aW9uTG9naWMucGhwPGJyPmFwcGxpY2F0aW9uL3VzZXIvbG9naWMvUGF5TG9naWMucGhwPGJyPmFwcGxpY2F0aW9uL3VzZXIvbG9naWMvUGF5QXBpTG9naWMucGhwPGJyPmFwcGxpY2F0aW9uL3VzZXIvbW9kZWwvUGF5LnBocDxicj5hcHBsaWNhdGlvbi91c2VyL21vZGVsL0FyY2hpdmVzLnBocDxicj5hcHBsaWNhdGlvbi91c2VyL21vZGVsL1VzZXJzUmVsZWFzZS5waHA8YnI+YXBwbGljYXRpb24vdXNlci9tb2RlbC9Qcm9kdWN0U3BlY1ZhbHVlLnBocDxicj5hcHBsaWNhdGlvbi91c2VyL21vZGVsL01lZGlhRmlsZS5waHA8YnI+YXBwbGljYXRpb24vdXNlci9tb2RlbC9TaG9wLnBocDxicj5hcHBsaWNhdGlvbi91c2VyL21vZGVsL1VzZXJzLnBocDxicj5hcHBsaWNhdGlvbi9jb21tb24ucGhwPGJyPmFwcGxpY2F0aW9uL2Z1bmN0aW9uLnBocDxicj5hcHBsaWNhdGlvbi9oZWxwZXIucGhwPGJyPmFwcGxpY2F0aW9uL2FwaS9jb250cm9sbGVyL3YxL0FwaS5waHA8YnI+YXBwbGljYXRpb24vYXBpL2NvbnRyb2xsZXIvdjEvQmFzZS5waHA8YnI+YXBwbGljYXRpb24vYXBpL2NvbnRyb2xsZXIvdjEvVXNlcnMucGhwPGJyPmFwcGxpY2F0aW9uL2FwaS9jb250cm9sbGVyL0RpeWFqYXgucGhwPGJyPmFwcGxpY2F0aW9uL2FwaS9jb250cm9sbGVyL0FqYXgucGhw', 'system', '', 'cn', '0', '1684114882');
INSERT INTO `ey_config` VALUES ('188', 'php_websensitive', '5aix5LmQDXzljZrlvakNfOS4lueVjOadrw185aSc5bqXDXzotYzljZoNfOaequaUrw186aOO5pq0DXxib2INfOaKvOazqA18OyZhbXA7Iw==', 'php', '', 'cn', '0', '1684370112');
INSERT INTO `ey_config` VALUES ('190', 'web_status_mode', '0', 'web', '', 'cn', '0', '1684304178');
INSERT INTO `ey_config` VALUES ('189', 'php_allow_service_os', 'eyJjb2RlIjoxLCJtc2ciOiJcdTY4YzBcdTZkNGJcdTUyMzBcdTY1YjBcdTcyNDhcdTY3MmMiLCJtc2cxIjoiXHU1NTQ2XHU3NTI4XHU3MjQ4XHU2NzJjXHU2NTJmXHU2MzAxXHU1NzI4XHU3ZWJmXHU2NmY0XHU2NWIwIn0=', 'php', '', 'cn', '0', '1684114873');
INSERT INTO `ey_config` VALUES ('191', 'web_status_text', '网站暂时关闭，维护中……', 'web', '', 'cn', '0', '1684304178');
INSERT INTO `ey_config` VALUES ('150', 'seo_uphtml_after_home', '0', 'seo', '', 'cn', '0', '1641347514');
INSERT INTO `ey_config` VALUES ('151', 'seo_uphtml_after_channel', '1', 'seo', '', 'cn', '0', '1641347514');
INSERT INTO `ey_config` VALUES ('152', 'seo_uphtml_after_pernext', '1', 'seo', '', 'cn', '0', '1641347514');
INSERT INTO `ey_config` VALUES ('153', 'seo_html_templet', 'index.htm', 'seo', '', 'cn', '0', '1641347514');
INSERT INTO `ey_config` VALUES ('154', 'seo_html_position', '../index.html', 'seo', '', 'cn', '0', '1641347514');
INSERT INTO `ey_config` VALUES ('155', 'seo_showmod', '1', 'seo', '', 'cn', '0', '1641347514');
INSERT INTO `ey_config` VALUES ('156', 'seo_maxpagesize', '50', 'seo', '', 'cn', '0', '1641347514');
INSERT INTO `ey_config` VALUES ('157', 'seo_upnext', '1', 'seo', '', 'cn', '0', '1641347514');
INSERT INTO `ey_config` VALUES ('158', 'seo_pagesize', '20', 'seo', '', 'cn', '0', '1641347514');
INSERT INTO `ey_config` VALUES ('159', 'basic_img_auto_wh', '0', 'basic', '', 'cn', '0', '1641347514');
INSERT INTO `ey_config` VALUES ('160', 'basic_img_alt', '0', 'basic', '', 'cn', '0', '1641347514');
INSERT INTO `ey_config` VALUES ('161', 'basic_img_title', '0', 'basic', '', 'cn', '0', '1641347514');
INSERT INTO `ey_config` VALUES ('162', 'system_usecodelist', '9c9fBQIBB1IGBQYFAVMEUwIHAgFZBVBRDVZVAVRoEFZWAAd0ZGR/N0F7ZGBgaHYxRzAvdG4xdzJPbHN6W3ljNgQ5YmBjVnE6YHBlcmRVcSx2EiNxUz1nMQhSb3EGfWQgBCFUcXRzYCZ0VnFwAFl1PAE7PGF9CHo8bUZ2fWF2diZnCH5wc2dTOnMEZmR3a1EydhIzYmkhfiBPYHR+YWFoJVlWVG0DCXA0UXhkcmNodiEADi59VB5jFg1HYEtnAXVbHhp3BVNhURJsfntfa19hV3kEKFt1N3kRWX5/UG5nZVBHFVJYa2VgVEJ6cU9tHkIsQlUgU1QHVzZTAmB9XQtiAgEzfFBafAA1XwFbe1gHXDN0UC52exx0IXpjQFxiZgMucyZfenpaRyNwcGRlc3QOAnYNIlNrD0kxYHNEWmZEBjRwJgRjcXdPLXAFUXhiYEM3cw0pcnwOBSdvY2Z+VWFnOXMPandnZ20qbgVnDXBGDyVmUC1Qegt+U1JRY1BdekcuHipZTUR3DwZjQlJQdndTAmIwVBdl', 'system', '', 'cn', '0', '1641347879');
INSERT INTO `ey_config` VALUES ('163', 'basic_indexname', '主页', 'basic', '', 'cn', '0', '1641347760');
INSERT INTO `ey_config` VALUES ('164', 'seo_html_arcdir', 'html', 'seo', '', 'cn', '0', '1684114879');
INSERT INTO `ey_config` VALUES ('165', 'seo_force_inlet', '0', 'seo', '', 'cn', '0', '1641347760');
INSERT INTO `ey_config` VALUES ('166', 'sitemap_archives_num', '100', 'sitemap', '', 'cn', '0', '1641347760');
INSERT INTO `ey_config` VALUES ('167', 'sitemap_tags_num', '200', 'sitemap', '', 'cn', '0', '1641347760');
INSERT INTO `ey_config` VALUES ('168', 'smtp_from_eamil', 'desdev@vip.qq.com', 'smtp', '', 'cn', '0', '1641347760');
INSERT INTO `ey_config` VALUES ('96', 'smtp_syn_weapp', '1', 'smtp', '', 'cn', '0', '1611053270');
INSERT INTO `ey_config` VALUES ('111', 'syn_admin_logic_arctype_topid2', '1', 'syn', '', 'cn', '0', '1611055150');
INSERT INTO `ey_config` VALUES ('112', 'syn_admin_logic_check_oneself', '1', 'syn', '', 'cn', '0', '1611055150');
INSERT INTO `ey_config` VALUES ('113', 'syn_admin_logic_links_group', '1', 'syn', '', 'cn', '0', '1611055150');
INSERT INTO `ey_config` VALUES ('114', 'sms_type', '1', 'sms', '', 'cn', '0', '1611055150');
INSERT INTO `ey_config` VALUES ('115', 'syn_admin_logic_1608189503', '1', 'syn', '', 'cn', '0', '1611055150');
INSERT INTO `ey_config` VALUES ('116', 'download_select_servername', 'a:6:{i:0;s:12:\"立即下载\";i:1;s:15:\"本地服务器\";i:2;s:15:\"远程服务器\";i:3;s:12:\"百度网盘\";i:4;s:15:\"七牛云存储\";i:5;s:12:\"腾讯网盘\";}', 'download', '', 'cn', '0', '1611055150');
INSERT INTO `ey_config` VALUES ('117', 'syn_admin_logic_1608191377', '1', 'syn', '', 'cn', '0', '1611055150');
INSERT INTO `ey_config` VALUES ('118', 'system_paginate_pagesize', '20', 'system', '', 'cn', '0', '1611055150');
INSERT INTO `ey_config` VALUES ('119', 'web_theme_color', '#3398cc', 'web', '', 'cn', '0', '1611055150');
INSERT INTO `ey_config` VALUES ('120', 'web_assist_color', '#2189be', 'web', '', 'cn', '0', '1611055150');
INSERT INTO `ey_config` VALUES ('121', 'web_loginbgimg', '/public/static/admin/images/login-bg.jpg', 'web', '', 'cn', '0', '1611055150');
INSERT INTO `ey_config` VALUES ('122', 'syn_admin_logic_1609039608', '1', 'syn', '', 'cn', '0', '1611055150');
INSERT INTO `ey_config` VALUES ('123', 'syn_admin_logic_1609291091', '1', 'syn', '', 'cn', '0', '1611055150');
INSERT INTO `ey_config` VALUES ('124', 'admin_logic_1610086647', '1', 'syn', '', 'cn', '0', '1611055150');
INSERT INTO `ey_config` VALUES ('125', 'php_eyou_blacklist', '', 'php', '', 'cn', '0', '1611055155');
INSERT INTO `ey_config` VALUES ('126', 'php_serviceinfo', '5492VQQJBQUBA1RWVVlRAQYHDFMBUQcIUAcACwdDGkUAABYAWkpcQVhFAURfQ1ECWRoNKlpmIWlOCQ9pFFROUw4sAypnDVlAVGUOKQQFFhQBWg0HZFRQU0U9IWscV0xrHw4PP1t3U3pQVhUTBDQWFAFaDgd4eFBBRVUhax5RWgAsLAMqVXJDelBJFSdUWSsaagpaPnYALEYJWEcfRFlNRg0NFwNdVVBYQlRGXEc9EVtSBA86QgJXAgQ5EAYEAQBuEFUDUAVlQAFUAwY6EFkCVFQ+TVJSBlZtQVEAAgdkTQVXVl05QQ8GDQlvEVBSVVc/RVQNXgBrEAVRA1NvE15eAlRASUdVTEFdXkEJFQJQRlkSPk1eVVJQbUFQVwoAZE0KVQQBOUENUFYEbxFfU1RUP0VXDVIBaxAFUVQEbxMOCwpdPhBTAw0GaUQGUwIDPRFWBFJcOkJRAwEFR0kRB01MWgoQCBZTCxcPE28RXgcEUT9FVwpfUWsQCQQDAW8TDF1RUD4QXAIMBWlEBwFXVj0RV1VTWTpCAFcFDDkQBVUAAG4QVFJRB2VAAAZXAjoQVFBTVD5NAFEHVBMYRwRGElBXQAgRAlQaDBcPE28RXgcEUT9FVwpfUWsQCQQDAW8TDF1RUD4QXAIMBWlEBwFXVj0RV1VTWTpCAFcFDDkQBVUAAG4QVFJRB2VAAAZXAjoQVFBTVD5NAFEHVBMYRwRHF01dQBwQABRBXEZBEwlGAxwoEypaEg8vWmFRUnMJHGkwAQhTMlMJLF5WTXhbWFYrISATBWMVUStkflNUTS8JVi56SFEINAMBc1VBb2J6UikhOFQudCNPAGRADHxnUVR6DEgPewg0UQZzVUxvZwpUBzJQCCpaDQwoXWYSfHAnXH8lcUF7DxJSLFlvAVZ2Xx08M1hUAmdTVC9dWFF/XjQSfiJ6AVQ0X1hHGBtcURMJUkpHAxEaWQYaXBUVSRNQCghSD1YaCEcHHApBF11eEx9GBQoFAUEKQAkEAwYDV1FVBAFfXQgEBlRXA1cODAYEBQJSBFRcAVIHGkoVUh1BXRcAQDlRVhBfUklHQEtMWkRHOxIMDAFBClIURFRbCkJROhJWBBoCAklAEBVQVlhUWF07CBAMRlkAThoPWUMXXhZfRxFKGk1bAUBfVRgbQEZUQQ0CR1tGAlQPUQgVG0dTVQwBRjlbV0cLFkdfBBUXQlRSFBY6EQgWVwtWOVhHAF8WX1QfREhRVkdYV0kWUEZqXl8ARF9RSEFDFlkSQkRHCwVJR1oVZ1xXCUBfVRgbVFFVbBAPCARGWQFXDVcFD1IJBF1JERNIXFMRBzoRXVRQFwsCUlVRVlxRA1sIShVHDUFrBAlfCU9nQQAQEwxXXGpaQhFeRAAYLglSUGoKfl0KSXgmL0cFCltbKgsvBlBtbAFoSSYFATU+CH4lcgVTYzBIeR8nUAJsYQM8CCcGUG1WTH93DAUBNT1QfQ91D3t0L0VXVwZLL1JXWz0qMFR6bWQHaXsxVSs1LVdoKm1Vel00BWwtMAEoQnJYPSowV3ptf1hpezFUKBslG2gqbVd5TSwFbC0wADxvcl89KjBXelRsBWl7MVQrNi0UeQwIWxVK', 'php', '', 'cn', '0', '1684487721');
INSERT INTO `ey_config` VALUES ('127', 'php_servicecode', '1b41ffe0a29e06c62fc79356f4a58bbe', 'php', '', 'cn', '0', '1684114832');
INSERT INTO `ey_config` VALUES ('109', 'syn_admin_logic_special_addfields', '5', 'syn', '', 'cn', '0', '1616293251');
INSERT INTO `ey_config` VALUES ('110', 'syn_admin_logic_session_conf', '1', 'syn', '', 'cn', '0', '1611055054');
INSERT INTO `ey_config` VALUES ('108', 'syn_admin_logic_users_download', '1', 'syn', '', 'cn', '0', '1611054964');
INSERT INTO `ey_config` VALUES ('105', 'syn_admin_logic_video_addfields', '5', 'syn', '', 'cn', '0', '1616293251');
INSERT INTO `ey_config` VALUES ('106', 'syn_admin_logic_add_tag', '1', 'syn', '', 'cn', '0', '1611054872');
INSERT INTO `ey_config` VALUES ('107', 'syn_admin_logic_users_parameter', '1', 'syn', '', 'cn', '0', '1611054872');
INSERT INTO `ey_config` VALUES ('99', 'syn_admin_logic_sms_template', '1', 'syn', '', 'cn', '0', '1611054772');
INSERT INTO `ey_config` VALUES ('100', 'php_weapp_plugin_open', '1', 'php', '', 'cn', '0', '1684487721');
INSERT INTO `ey_config` VALUES ('101', 'syn_admin_logic_unlink', '1', 'syn', '', 'cn', '0', '1611054772');
INSERT INTO `ey_config` VALUES ('102', 'syn_admin_logic_update_basic', '1', 'syn', '', 'cn', '0', '1611054772');
INSERT INTO `ey_config` VALUES ('103', 'syn_admin_logic_update_tag', '1', 'syn', '', 'cn', '0', '1611054772');
INSERT INTO `ey_config` VALUES ('104', 'syn_admin_logic_update_arctype', '1', 'syn', '', 'cn', '0', '1611054772');
INSERT INTO `ey_config` VALUES ('98', 'system_smtp_tpl_5', '1', 'system', '', 'cn', '0', '1611054608');
INSERT INTO `ey_config` VALUES ('97', 'syn_gb_attribute_showlist', '1', 'syn', '', 'cn', '0', '1611054521');
INSERT INTO `ey_config` VALUES ('128', 'other_arcclick', '500|1000', 'other', '', 'cn', '0', '1611057171');
INSERT INTO `ey_config` VALUES ('129', 'php_servicemeal', '2', 'php', '', 'cn', '0', '1684114832');
INSERT INTO `ey_config` VALUES ('130', 'syn_admin_logic_video_addfields_2', '1', 'syn', '', 'cn', '0', '1616293251');
INSERT INTO `ey_config` VALUES ('131', 'syn_admin_logic_1608884981_2', '1', 'syn', '', 'cn', '0', '1616293251');
INSERT INTO `ey_config` VALUES ('132', 'system_version', 'v1.6.2', 'system', '', 'cn', '0', '1684114892');
INSERT INTO `ey_config` VALUES ('133', 'syn_admin_logic_arctype_topid', '2', 'syn', '', 'cn', '0', '1616293292');
INSERT INTO `ey_config` VALUES ('134', 'syn_admin_logic_balance_pay', '1', 'syn', '', 'cn', '0', '1616293292');
INSERT INTO `ey_config` VALUES ('135', 'basic_img_style_wh', '0', 'basic', '', 'cn', '0', '1616293292');
INSERT INTO `ey_config` VALUES ('136', 'syn_admin_logic_1610086648', '1', 'syn', '', 'cn', '0', '1616293292');
INSERT INTO `ey_config` VALUES ('137', 'syn_admin_logic_1614829120', '1', 'syn', '', 'cn', '0', '1616293292');
INSERT INTO `ey_config` VALUES ('138', 'syn_admin_logic_1616123192', '1', 'syn', '', 'cn', '0', '1616293292');
INSERT INTO `ey_config` VALUES ('139', 'web_adminlogo', '', 'web', '', 'cn', '0', '1623814141');
INSERT INTO `ey_config` VALUES ('140', 'web_loginlogo', '', 'web', '', 'cn', '0', '1623814141');
INSERT INTO `ey_config` VALUES ('141', 'syn_admin_logic_1608884981', '1', 'syn', '', 'cn', '0', '1623814141');
INSERT INTO `ey_config` VALUES ('142', 'syn_admin_logic_1614829121', '1', 'syn', '', 'cn', '0', '1623814141');
INSERT INTO `ey_config` VALUES ('143', 'syn_admin_logic_ask_answer_like', '1', 'syn', '', 'cn', '0', '1623814141');
INSERT INTO `ey_config` VALUES ('144', 'syn_admin_logic_archives_1618279798', '1', 'syn', '', 'cn', '0', '1623814141');
INSERT INTO `ey_config` VALUES ('145', 'syn_admin_logic_1623036205', '1', 'syn', '', 'cn', '0', '1623814141');
INSERT INTO `ey_config` VALUES ('146', 'admin_logic_1623055490', '1', 'syn', '', 'cn', '0', '1623814141');
INSERT INTO `ey_config` VALUES ('147', 'system_use_language', '0', 'system', '', 'cn', '0', '1623814141');
INSERT INTO `ey_config` VALUES ('148', 'admin_logic_1623133485', '1', 'syn', '', 'cn', '0', '1623814141');
INSERT INTO `ey_config` VALUES ('149', 'other_pcwapjs', '0', 'other', '', 'cn', '0', '1641347463');
INSERT INTO `ey_config` VALUES ('169', 'web_attr_1', '我们提供安全，免费的手游软件下载！', 'web', '', 'cn', '0', '1684487406');
INSERT INTO `ey_config` VALUES ('170', 'web_attr_2', '本网页内容、图片、视频为模板演示数据，如有涉及侵犯版权，请联系我们提供书面反馈，我们核实后会立即删除。', 'web', '', 'cn', '0', '1684487312');
INSERT INTO `ey_config` VALUES ('173', 'web_attr_5', '本站所有素材资源均来自用户分享和网络收集，仅供学习与参考，请勿用于商业用途，如果损害了您的权利，请联系网站客服，我们核实后会立即删除。', 'web', '', 'cn', '0', '1684487282');
INSERT INTO `ey_config` VALUES ('174', 'web_tpl_theme', '', 'web', '', 'cn', '0', '1641347890');
INSERT INTO `ey_config` VALUES ('175', 'web_mobile_domain_open', '0', 'web', '', 'cn', '0', '1641347890');
INSERT INTO `ey_config` VALUES ('176', 'web_is_https', '0', 'web', '', 'cn', '0', '1641347890');
INSERT INTO `ey_config` VALUES ('177', 'recycle_switch', '1', 'web', '', 'cn', '0', '1641347890');
INSERT INTO `ey_config` VALUES ('178', 'web_stypeid_open', '0', 'web', '', 'cn', '0', '1641347890');
INSERT INTO `ey_config` VALUES ('179', 'web_login_expiretime', '3600', 'web', '', 'cn', '0', '1641347890');
INSERT INTO `ey_config` VALUES ('185', 'system_correctarctypedirpath', '1', 'system', '', 'cn', '0', '1641365163');
INSERT INTO `ey_config` VALUES ('180', 'web_status_url', '', 'web', '', 'cn', '0', '1641347928');
INSERT INTO `ey_config` VALUES ('181', 'web_status_tpl', '', 'web', '', 'cn', '0', '1641347928');
INSERT INTO `ey_config` VALUES ('182', 'web_recordnum_mode', '0', 'web', '', 'cn', '0', '1641347928');
INSERT INTO `ey_config` VALUES ('183', 'web_garecordnum', '', 'web', '', 'cn', '0', '1641347928');
INSERT INTO `ey_config` VALUES ('184', 'web_garecordnum_mode', '0', 'web', '', 'cn', '0', '1641347928');
INSERT INTO `ey_config` VALUES ('186', 'system_crypt_auth_code', '$2y$11$0a636b9ac5986eaf594042e', 'system', '', 'cn', '0', '1684114832');
INSERT INTO `ey_config` VALUES ('187', 'admin_logic_1_1648775669', '1', 'syn', '', 'cn', '0', '1684114839');

-- -----------------------------
-- Table structure for `ey_config_attribute`
-- -----------------------------
DROP TABLE IF EXISTS `ey_config_attribute`;
CREATE TABLE `ey_config_attribute` (
  `attr_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '表单id',
  `inc_type` varchar(20) DEFAULT '' COMMENT '变量分组',
  `type_id` int(11) unsigned DEFAULT '1',
  `attr_name` varchar(60) DEFAULT '' COMMENT '变量标题',
  `attr_var_name` varchar(50) DEFAULT '' COMMENT '变量名',
  `attr_input_type` tinyint(1) unsigned DEFAULT '0' COMMENT ' 0=文本框，1=下拉框，2=多行文本框，3=上传图片',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`attr_id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COMMENT='自定义变量表';

-- -----------------------------
-- Records of `ey_config_attribute`
-- -----------------------------
INSERT INTO `ey_config_attribute` VALUES ('1', 'web', '1', '头部文字', 'web_attr_1', '0', 'cn', '1641347761', '1684487406');
INSERT INTO `ey_config_attribute` VALUES ('2', 'web', '1', '底部声明', 'web_attr_2', '2', 'cn', '1641347761', '1684487406');
INSERT INTO `ey_config_attribute` VALUES ('5', 'web', '1', '免责声明', 'web_attr_5', '0', 'cn', '1641347761', '1684487406');

-- -----------------------------
-- Table structure for `ey_config_type`
-- -----------------------------
DROP TABLE IF EXISTS `ey_config_type`;
CREATE TABLE `ey_config_type` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `type_name` varchar(255) DEFAULT '' COMMENT '分组名称',
  `status` tinyint(1) DEFAULT '1',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `sort_order` int(11) DEFAULT '100' COMMENT '排序',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='自定义变量分组表';

-- -----------------------------
-- Records of `ey_config_type`
-- -----------------------------
INSERT INTO `ey_config_type` VALUES ('1', '默认分组', '1', 'cn', '1650271499', '1650271499', '100');

-- -----------------------------
-- Table structure for `ey_custom_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_custom_content`;
CREATE TABLE `ey_custom_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `miaoshu` text COMMENT '文章描述',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='附加表';

-- -----------------------------
-- Records of `ey_custom_content`
-- -----------------------------
INSERT INTO `ey_custom_content` VALUES ('1', '6', '1551752806', '1551752806', '适用于大型、中型、小型以及快速成长型企业的解决方案');
INSERT INTO `ey_custom_content` VALUES ('2', '7', '1551752824', '1551752824', '适用于大型、中型、小型以及快速成长型企业的解决方案');
INSERT INTO `ey_custom_content` VALUES ('3', '8', '1551752838', '1551752838', '适用于大型、中型、小型以及快速成长型企业的解决方案');
INSERT INTO `ey_custom_content` VALUES ('4', '9', '1551752853', '1551752853', '适用于大型、中型、小型以及快速成长型企业的解决方案');

-- -----------------------------
-- Table structure for `ey_ddos_log`
-- -----------------------------
DROP TABLE IF EXISTS `ey_ddos_log`;
CREATE TABLE `ey_ddos_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `md5key` varchar(50) DEFAULT '' COMMENT 'md5值',
  `file_name` varchar(500) DEFAULT '' COMMENT '文件名',
  `file_num` int(10) DEFAULT '0' COMMENT '已扫描数',
  `file_total` int(10) DEFAULT '0' COMMENT '总文件数',
  `file_num_ky` int(10) DEFAULT '0' COMMENT '可疑恶意文件数',
  `is_suspicious` tinyint(1) DEFAULT '0' COMMENT '是否可疑',
  `html` text,
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='ddos查杀进度记录表';


-- -----------------------------
-- Table structure for `ey_discount_active`
-- -----------------------------
DROP TABLE IF EXISTS `ey_discount_active`;
CREATE TABLE `ey_discount_active` (
  `active_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '活动会场ID',
  `active_name` varchar(255) DEFAULT '' COMMENT '活动名称',
  `start_date` int(11) unsigned DEFAULT '0' COMMENT '活动开始时间',
  `end_date` int(11) DEFAULT '0' COMMENT '活动结束时间',
  `limit_type` tinyint(3) unsigned DEFAULT '1' COMMENT '限购类型 1-不限购,2-活动期内每人最多购买n件,3-活动期内每人每天最多购买n件',
  `limit` int(11) unsigned DEFAULT '0' COMMENT '限购数量',
  `preheat` tinyint(3) DEFAULT '0' COMMENT '是否开启预热 0-关闭 1-开启',
  `preheat_time` int(11) DEFAULT '0' COMMENT '预热时间,不能大于开启时间',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '活动状态(0禁用 1启用)',
  `is_del` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`active_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='限时折扣-活动会场表';


-- -----------------------------
-- Table structure for `ey_discount_active_goods`
-- -----------------------------
DROP TABLE IF EXISTS `ey_discount_active_goods`;
CREATE TABLE `ey_discount_active_goods` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `active_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '活动ID',
  `aid` int(11) NOT NULL DEFAULT '0' COMMENT '文档id',
  `discount_goods_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '秒杀商品ID',
  `sales_actual` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '实际销量',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='限时折扣-活动会场与商品关联表';


-- -----------------------------
-- Table structure for `ey_discount_goods`
-- -----------------------------
DROP TABLE IF EXISTS `ey_discount_goods`;
CREATE TABLE `ey_discount_goods` (
  `discount_gid` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '限时折扣商品ID',
  `aid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '商品ID->aid',
  `discount_stock` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '限时折扣商品库存总量',
  `discount_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '限时折扣价格',
  `sales` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '累积销量',
  `virtual_sales` int(11) NOT NULL DEFAULT '0' COMMENT '虚拟销量',
  `sort_order` int(11) unsigned NOT NULL DEFAULT '100' COMMENT '商品排序(数字越小越靠前)',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '商品状态(0下架 1上架)',
  `is_del` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除',
  `is_sku` tinyint(1) NOT NULL DEFAULT '0' COMMENT '1-多规格商品',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`discount_gid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='限时折扣-商品表';


-- -----------------------------
-- Table structure for `ey_diyminipro`
-- -----------------------------
DROP TABLE IF EXISTS `ey_diyminipro`;
CREATE TABLE `ey_diyminipro` (
  `mini_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '模板ID',
  `categoryid` int(11) NOT NULL DEFAULT '0' COMMENT '分类ID',
  `name` varchar(100) NOT NULL DEFAULT '' COMMENT '模板标题',
  `litpic` varchar(250) NOT NULL DEFAULT '' COMMENT '封面图',
  `component` text NOT NULL COMMENT '组件库',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '状态：4=审核中，5=发布',
  `cloud_id` int(10) NOT NULL DEFAULT '0' COMMENT '云ID',
  `config` text NOT NULL COMMENT '相关序列化信息',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '伪删除，1=是，0=否',
  `lang` varchar(10) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`mini_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='微信小程序记录表';


-- -----------------------------
-- Table structure for `ey_diyminipro_page`
-- -----------------------------
DROP TABLE IF EXISTS `ey_diyminipro_page`;
CREATE TABLE `ey_diyminipro_page` (
  `page_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '页面id',
  `page_type` tinyint(3) NOT NULL DEFAULT '-1' COMMENT '页面类型(1首页 -1自定义页)',
  `page_name` varchar(255) NOT NULL DEFAULT '' COMMENT '页面名称',
  `page_data` longtext NOT NULL COMMENT '页面数据',
  `mini_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '微信小程序id',
  `is_home` tinyint(1) NOT NULL DEFAULT '0' COMMENT '设为首页：0=否，1=是',
  `is_system` tinyint(1) NOT NULL DEFAULT '0' COMMENT '系统内置',
  `is_show` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否显示：1=显示，0=隐藏',
  `is_del` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '伪删除，1=是，0=否',
  `lang` varchar(10) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`page_id`),
  KEY `mini_id` (`mini_id`,`lang`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='微信小程序diy页面表';


-- -----------------------------
-- Table structure for `ey_diyminipro_setting`
-- -----------------------------
DROP TABLE IF EXISTS `ey_diyminipro_setting`;
CREATE TABLE `ey_diyminipro_setting` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) NOT NULL DEFAULT '' COMMENT '页面组',
  `value` text NOT NULL COMMENT '组装之后的值',
  `mini_id` int(11) NOT NULL DEFAULT '0' COMMENT '小程序ID',
  `lang` varchar(10) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `type` (`name`) USING BTREE,
  KEY `mini_id` (`mini_id`,`lang`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='微信小程序多功能配置表';


-- -----------------------------
-- Table structure for `ey_download_attr_field`
-- -----------------------------
DROP TABLE IF EXISTS `ey_download_attr_field`;
CREATE TABLE `ey_download_attr_field` (
  `field_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `field_name` varchar(32) DEFAULT '' COMMENT '字段名称',
  `field_title` varchar(32) DEFAULT '' COMMENT '字段标题',
  `field_use` tinyint(1) DEFAULT '0' COMMENT '字段是否使用，0未使用，1为使用',
  `sort_order` smallint(5) DEFAULT '0' COMMENT '排序',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '上传时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`field_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='上传文件属性表';

-- -----------------------------
-- Records of `ey_download_attr_field`
-- -----------------------------
INSERT INTO `ey_download_attr_field` VALUES ('1', 'extract_code', '提取码', '1', '1', 'cn', '1561001807', '1561024954');
INSERT INTO `ey_download_attr_field` VALUES ('2', 'server_name', '服务器名称', '1', '2', 'cn', '1561001807', '1561078673');

-- -----------------------------
-- Table structure for `ey_download_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_download_content`;
CREATE TABLE `ey_download_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `content` longtext COMMENT '内容详情',
  `content_ey_m` longtext COMMENT '手机端内容详情',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `news_id` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='资讯内容表_存储正常内容';


-- -----------------------------
-- Table structure for `ey_download_file`
-- -----------------------------
DROP TABLE IF EXISTS `ey_download_file`;
CREATE TABLE `ey_download_file` (
  `file_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `aid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '产品ID',
  `title` varchar(200) DEFAULT '' COMMENT '产品标题',
  `file_url` varchar(255) DEFAULT '' COMMENT '文件存储路径',
  `extract_code` varchar(20) DEFAULT '' COMMENT '文件提取码',
  `file_size` varchar(255) DEFAULT '' COMMENT '文件大小',
  `file_ext` varchar(50) DEFAULT '' COMMENT '文件后缀名',
  `file_name` varchar(200) DEFAULT '' COMMENT '文件名',
  `server_name` varchar(200) DEFAULT '' COMMENT '服务器名称',
  `file_mime` varchar(200) DEFAULT '' COMMENT '文件类型',
  `uhash` varchar(200) DEFAULT '' COMMENT '自定义的一种加密方式，用于文件下载权限验证',
  `md5file` varchar(200) DEFAULT '' COMMENT 'md5_file加密，可以检测上传/下载的文件包是否损坏',
  `is_remote` tinyint(1) DEFAULT '0' COMMENT '是否远程',
  `downcount` int(10) DEFAULT '0' COMMENT '下载次数',
  `sort_order` smallint(5) DEFAULT '0' COMMENT '排序',
  `add_time` int(10) unsigned DEFAULT '0' COMMENT '上传时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`file_id`),
  KEY `arcid` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='下载附件表';


-- -----------------------------
-- Table structure for `ey_download_log`
-- -----------------------------
DROP TABLE IF EXISTS `ey_download_log`;
CREATE TABLE `ey_download_log` (
  `log_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `users_id` int(10) DEFAULT '0' COMMENT '用户ID',
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `file_id` int(10) DEFAULT '0' COMMENT '附件ID',
  `ip` varchar(20) DEFAULT '' COMMENT 'ip',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '编辑时间',
  PRIMARY KEY (`log_id`),
  KEY `file_id` (`file_id`,`aid`,`users_id`) USING BTREE,
  KEY `aid` (`aid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='下载记录表';


-- -----------------------------
-- Table structure for `ey_download_order`
-- -----------------------------
DROP TABLE IF EXISTS `ey_download_order`;
CREATE TABLE `ey_download_order` (
  `order_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '文章订单ID',
  `order_code` varchar(50) NOT NULL DEFAULT '' COMMENT '媒体订单编号',
  `users_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `order_status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '订单状态：0未付款，1已付款',
  `order_amount` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '订单应付总金额',
  `pay_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '支付时间',
  `pay_name` varchar(20) NOT NULL DEFAULT '' COMMENT '支付方式名称',
  `wechat_pay_type` varchar(20) NOT NULL DEFAULT '' COMMENT '微信支付时，标记使用的支付类型（扫码支付，微信内部，微信H5页面）',
  `pay_details` text COMMENT '支付时返回的数据，以serialize序列化后存入，用于后续查询。',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '视频文档ID',
  `product_name` varchar(100) DEFAULT '' COMMENT '视频文档名称',
  `product_litpic` varchar(500) DEFAULT '' COMMENT '视频文档封面图片',
  `lang` varchar(30) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '下单时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`order_id`),
  UNIQUE KEY `order_code` (`order_code`) USING BTREE,
  KEY `users_id` (`users_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;


-- -----------------------------
-- Table structure for `ey_field_type`
-- -----------------------------
DROP TABLE IF EXISTS `ey_field_type`;
CREATE TABLE `ey_field_type` (
  `name` varchar(32) NOT NULL DEFAULT '' COMMENT '字段类型',
  `title` varchar(64) NOT NULL DEFAULT '' COMMENT '中文类型名',
  `ifoption` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否需要设置选项',
  `sort_order` int(10) NOT NULL DEFAULT '0' COMMENT '排序',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`name`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='字段类型表';

-- -----------------------------
-- Records of `ey_field_type`
-- -----------------------------
INSERT INTO `ey_field_type` VALUES ('text', '单行文本', '0', '1', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('checkbox', '多选项', '1', '5', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('multitext', '多行文本', '0', '2', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('radio', '单选项', '1', '4', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('switch', '开关', '0', '13', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('select', '下拉框', '1', '6', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('img', '单张图', '0', '10', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('int', '整数类型', '0', '7', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('datetime', '日期和时间', '0', '12', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('htmltext', 'HTML文本', '0', '3', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('imgs', '多张图', '0', '11', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('decimal', '金额类型', '0', '9', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('float', '小数类型', '0', '8', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('region', '区域类型', '1', '6', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('file', '附件类型', '0', '11', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('media', '多媒体类型', '0', '11', '1532485708', '1532485708');

-- -----------------------------
-- Table structure for `ey_form`
-- -----------------------------
DROP TABLE IF EXISTS `ey_form`;
CREATE TABLE `ey_form` (
  `form_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增表单ID',
  `form_name` varchar(255) NOT NULL DEFAULT '' COMMENT '表单名称',
  `intro` text NOT NULL COMMENT '表单描述，预留',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '表单状态，0关闭，1开启',
  `attr_auto` tinyint(1) DEFAULT '0' COMMENT '自动标签：0=否，1=是',
  `lang` varchar(10) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`form_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='表单管理表';


-- -----------------------------
-- Table structure for `ey_guestbook`
-- -----------------------------
DROP TABLE IF EXISTS `ey_guestbook`;
CREATE TABLE `ey_guestbook` (
  `aid` int(11) NOT NULL AUTO_INCREMENT,
  `form_type` tinyint(1) DEFAULT '0' COMMENT '数据分类：0=留言模型，1=自由表单',
  `typeid` int(11) DEFAULT '0' COMMENT '栏目ID/表单ID',
  `channel` smallint(5) DEFAULT '0' COMMENT '模型ID',
  `users_id` int(11) DEFAULT '0' COMMENT '用户id',
  `md5data` varchar(50) DEFAULT '' COMMENT '数据序列化之后的MD5加密，提交内容的唯一性',
  `ip` varchar(255) DEFAULT '' COMMENT 'ip地址',
  `is_read` tinyint(1) DEFAULT '0' COMMENT '0=未读，1=已读',
  `is_star` tinyint(1) DEFAULT '0' COMMENT '标记星号',
  `source` tinyint(1) DEFAULT '0' COMMENT '提交来源：1=电脑端，2=手机端',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`aid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='留言主表';


-- -----------------------------
-- Table structure for `ey_guestbook_attr`
-- -----------------------------
DROP TABLE IF EXISTS `ey_guestbook_attr`;
CREATE TABLE `ey_guestbook_attr` (
  `guest_attr_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '留言表单id自增',
  `aid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '留言id',
  `form_type` tinyint(1) DEFAULT '0' COMMENT '数据分类：0=留言模型，1=自由表单',
  `attr_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '表单id',
  `attr_value` text COMMENT '表单值',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`guest_attr_id`),
  KEY `attr_id` (`attr_id`) USING BTREE,
  KEY `guest_id` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='留言表单属性值';


-- -----------------------------
-- Table structure for `ey_guestbook_attribute`
-- -----------------------------
DROP TABLE IF EXISTS `ey_guestbook_attribute`;
CREATE TABLE `ey_guestbook_attribute` (
  `attr_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '表单id',
  `attr_name` varchar(60) DEFAULT '' COMMENT '表单名称',
  `typeid` int(11) unsigned DEFAULT '0' COMMENT '栏目ID/表单ID',
  `form_type` tinyint(1) DEFAULT '0' COMMENT '数据分类：0=留言模型，1=自由表单',
  `attr_input_type` tinyint(1) unsigned DEFAULT '0' COMMENT ' 0=文本框，1=下拉框，2=多行文本框',
  `attr_values` text COMMENT '可选值列表',
  `is_showlist` tinyint(1) DEFAULT '0' COMMENT '在列表显示 0=隐藏，1=显示',
  `required` tinyint(1) DEFAULT '0' COMMENT '必填 0=否，1=是',
  `validate_type` smallint(5) DEFAULT '0' COMMENT '验证格式，0=不验证，1=手机，2=Email',
  `real_validate` tinyint(1) unsigned DEFAULT '0' COMMENT '是否进行真实验证，0=不验证，1=真实验证',
  `sort_order` int(11) unsigned DEFAULT '0' COMMENT '表单排序',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '是否已删除，0=否，1=是',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`attr_id`),
  KEY `guest_id` (`typeid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='留言表单属性';


-- -----------------------------
-- Table structure for `ey_guwen_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_guwen_content`;
CREATE TABLE `ey_guwen_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `diy_cyjy` varchar(200) NOT NULL DEFAULT '' COMMENT '从业经验',
  `diy_cgal` varchar(200) NOT NULL DEFAULT '' COMMENT '成功案例',
  `diy_dh` varchar(200) NOT NULL DEFAULT '' COMMENT '电话',
  `content` longtext COMMENT '详情',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=18 DEFAULT CHARSET=utf8 COMMENT='附加表';

-- -----------------------------
-- Records of `ey_guwen_content`
-- -----------------------------
INSERT INTO `ey_guwen_content` VALUES ('1', '101', '1622787976', '1622787976', '4', '56', '13812345678', '&lt;p&gt;优秀的人，无论生活和工作给他人展示的总是一个态度，即做事踏实和用心。&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('3', '103', '1622788158', '1622788158', '5', '76', '13812345678', '&lt;p&gt;做透，揭示了“细中见精”、“小中见大”、“伟大与平凡”的真理。&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('2', '102', '1622787971', '1622787971', '3', '58', '13812345678', '&lt;p&gt;优秀的人，无论生活和工作给他人展示的总是一个态度，即做事踏实和用心&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('4', '104', '1622788475', '1622788475', '6', '67', '13812345678', '&lt;p&gt;生活和工作给他人展示的总是一个态度，即做事踏实和用心。&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('5', '105', '1622788225', '1622788225', '5', '86', '13812345678', '&lt;p&gt;无论生活和工作给他人展示的总是一个态度，即做事踏实和用心。&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('6', '106', '1622788253', '1622788253', '5', '58', '13812345678', '&lt;p&gt;无论生活和工作给他人展示的总是一个态度。&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('7', '107', '1622788281', '1622788281', '4', '46', '13812345678', '&lt;p&gt;不论做什么工作，都要重视小事、关注细节，把小事做细、做透，揭示了“细中见精”、“小中见大”、“伟大与平凡”的真理。&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('8', '108', '1622788320', '1622788320', '6', '72', '13812345678', '&lt;p&gt;公司经营范围为股权投资、债权投资、项目投资、资产管理、企业并购重组、投资管理及咨询和理财信息咨询。 金融作为联想控股成员企业，把为中小企业融资融智，推动实体经济发展。&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('9', '109', '1622788354', '1622788354', '6', '113', '13812345678', '&lt;p&gt;优秀的人，无论生活和工作给他人展示的总是一个态度，即做事踏实和用心。不论做什么工作，都要重视小事、关注细节，把小事做细、做透，揭示了“细中见精”、“小中见大”、“伟大与平凡”的真理。&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('10', '110', '1622788394', '1622788394', '6', '164', '13812345678', '&lt;p&gt;优秀的人，无论生活和工作给他人展示的总是一个态度，即做事踏实和用心。不论做什么工作，都要重视小事、关注细节，把小事做细、做透，揭示了“细中见精”、“小中见大”、“伟大与平凡”的真理。&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('11', '111', '1622788422', '1622788422', '4', '76', '13812345678', '&lt;p&gt;工作给他人展示的总是一个态度，即做事踏实和用心。不论做什么工作，都要重视小事、关注细节，把小事做细、做透，揭示了“细中见精”、“小中见大”、“伟大与平凡”的真理。&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('12', '112', '1622788459', '1622788459', '5', '96', '13812345678', '&lt;p&gt;无论生活和工作给他人展示的总是一个态度，即做事踏实和用心。不论做什么工作，都要重视小事、关注细节.&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('13', '113', '1622788664', '1622788664', '6', '135', '13812345678', '&lt;p&gt;优秀的人，无论生活和工作给他人展示的总是一个态度，即做事踏实和用心。不论做什么工作，都要重视小事、关注细节，把小事做细、做透，揭示了“细中见精”、“小中见大”、“伟大与平凡”的真理。&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('14', '114', '1622788722', '1622788722', '3', '76', '13812345678', '&lt;p&gt;优秀的人，无论生活和工作给他人展示的总是一个态度，即做事踏实和用心。不论做什么工作，都要重视小事、关注细节，把小事做细、做透，揭示了“细中见精”、“小中见大”、“伟大与平凡”的真理。&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('15', '115', '1622788750', '1622788750', '9', '352', '13812345678', '&lt;p&gt;优秀的人，无论生活和工作给他人展示的总是一个态度，即做事踏实和用心。不论做什么工作，都要重视小事、关注细节，把小事做细、做透，揭示了“细中见精”、“小中见大”、“伟大与平凡”的真理。&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('16', '116', '1622788814', '1622788814', '5', '287', '13812345678', '&lt;p&gt;无论生活和工作给他人展示的总是一个态度，即做事踏实和用心。不论做什么工作，都要重视小事、关注细节，把小事做细、做透，揭示了“细中见精”、“小中见大”、“伟大与平凡”的真理。&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('17', '117', '1622788851', '1622788851', '6', '276', '13812345678', '&lt;p&gt;不论做什么工作，都要重视小事、关注细节，把小事做细、做透，揭示了“细中见精”、“小中见大”、“伟大与平凡”的真理。&lt;/p&gt;');

-- -----------------------------
-- Table structure for `ey_hezuo_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_hezuo_content`;
CREATE TABLE `ey_hezuo_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COMMENT='附加表';

-- -----------------------------
-- Records of `ey_hezuo_content`
-- -----------------------------
INSERT INTO `ey_hezuo_content` VALUES ('1', '66', '1599636856', '1599636856');
INSERT INTO `ey_hezuo_content` VALUES ('2', '67', '1599636870', '1599636870');
INSERT INTO `ey_hezuo_content` VALUES ('3', '68', '1599636881', '1599636881');
INSERT INTO `ey_hezuo_content` VALUES ('4', '69', '1599636893', '1599636893');
INSERT INTO `ey_hezuo_content` VALUES ('5', '70', '1599636904', '1599636904');
INSERT INTO `ey_hezuo_content` VALUES ('6', '71', '1599636918', '1599636918');
INSERT INTO `ey_hezuo_content` VALUES ('7', '72', '1599636930', '1599636930');
INSERT INTO `ey_hezuo_content` VALUES ('8', '73', '1599636943', '1599636943');

-- -----------------------------
-- Table structure for `ey_hooks`
-- -----------------------------
DROP TABLE IF EXISTS `ey_hooks`;
CREATE TABLE `ey_hooks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '钩子名称',
  `description` text COMMENT '描述',
  `module` varchar(50) DEFAULT '' COMMENT '钩子挂载的插件',
  `status` tinyint(1) unsigned DEFAULT '1' COMMENT '状态：0=无效，1=有效',
  `add_time` int(10) DEFAULT NULL,
  `update_time` int(10) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `name` (`name`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='插件钩子表';


-- -----------------------------
-- Table structure for `ey_images_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_images_content`;
CREATE TABLE `ey_images_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `content` longtext COMMENT '内容详情',
  `content_ey_m` longtext COMMENT '手机端内容详情',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `mysize` varchar(251) NOT NULL DEFAULT '' COMMENT '文件大小',
  `banben` varchar(251) NOT NULL DEFAULT '' COMMENT '最新版本',
  `xitong` varchar(251) NOT NULL DEFAULT '' COMMENT '适合系统',
  `kaifazhe` varchar(251) NOT NULL DEFAULT '' COMMENT '开发者',
  `pingfen` varchar(251) NOT NULL DEFAULT '5' COMMENT '评分',
  `downs` varchar(251) NOT NULL DEFAULT '3256' COMMENT '下载次数',
  `downloads` varchar(251) NOT NULL DEFAULT '' COMMENT '下载地址',
  `bigpic` varchar(500) NOT NULL DEFAULT '' COMMENT '大缩略图',
  PRIMARY KEY (`id`),
  KEY `news_id` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=120 DEFAULT CHARSET=utf8 COMMENT='资讯内容表_存储正常内容';

-- -----------------------------
-- Records of `ey_images_content`
-- -----------------------------
INSERT INTO `ey_images_content` VALUES ('1', '1', '小桔试玩，最新苹果手机试玩应用赚钱平台，注册奖励1元，快速任务单价1元起，满5元即可提现。下载任务助手后，即刻开始试玩赚现金，做任务中请勿关闭助手，以免无法获取奖励，还可每天签到领取随机现金红包。&lt;br /&gt;\n&lt;br /&gt;\n任务更新：小桔试玩下午16：00左右，大量任务上线。&lt;br /&gt;\n&lt;br /&gt;\n小桔试玩官方客服QQ：3320921760', '', '1641347764', '1641347764', '18.60 MB', '1.1.1', '苹果', '北京蜂树无线广告有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('2', '2', '&lt;p&gt;小啄赚钱，超级赚钱兼职平台，做任务的手机赚钱APP，闲暇时间者的手机赚钱软件平台，每天都有新的任务发布，新用户专享一元提现，支付宝、微信提现实时到账、无手续费。支持苹果和安卓手机&lt;br/&gt;&lt;br/&gt;【玩法多多】&lt;br/&gt;1、签到红包：连续15天签到任务，直接领15元微信红包；&lt;br/&gt;2、天天抽奖：赢取不同的奖励红包；&lt;br/&gt;3、小啄赚钱：啄一下开始赚钱，每次啄取不同任务，惊喜不断；&lt;br/&gt;4、钻石任务：高额奖励等你来领&amp;amp;mdash;&amp;amp;mdash;你喜欢的应有尽有，更有冲顶大红包等你来冲。&lt;/p&gt;', '', '1684314021', '1684314021', '10.15 MB', '2.0.1', '苹果安卓', '杭州小啄科技有限公司', '5', '3256', '/uploads/soft/20230517/1-23051GF01O17.zip', '');
INSERT INTO `ey_images_content` VALUES ('3', '3', '&lt;p&gt;金钱豹是专为苹果用户打造的越玩越有钱的APP，合理利用你的时间碎片，打开金钱豹，看广告、看视频、做任务，轻松赚取零花钱。金钱豹任务每天更新随时做，2元起提现，提现方便到账快。&lt;br/&gt;&lt;br/&gt;联系我们&lt;br/&gt;客服QQ交流群：623521005，客服QQ1178331206、3024631470&lt;/p&gt;', '', '1684310536', '1684310536', '15.71 MB', '1.0.0', '苹果', '', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('4', '4', '玩玩赚，是一款让每个人都能通过苹果手机兼职赚钱的神奇应用！每天下载应用、做任务、签到或看视频广告活动等，积分赚不停，按照任务要求注册帐号并完成指定的试玩任务，奖励轻松到手。别人教您花钱，我们教您赚钱！不投一分钱，试玩应用，动动手指就能赚。10分钟就能赚到10元，支付宝提现~~&lt;br/&gt;&lt;br/&gt;', '', '1684379752', '1684379752', '3.29 MB', '3.1.0', '苹果', '珠海荐闻天下信息科技有限公司', '5', '3256', '/uploads/soft/20230518/1-23051Q115403P.zip', '');
INSERT INTO `ey_images_content` VALUES ('5', '5', '懒虫试玩，一款可以赚钱的手机试玩软件，懒虫试玩为您提供超多好玩的应用，试玩应用还能领取丰厚的现金奖励，任务单价0.8至1元元不等，满10元可支付宝提现，新用户注册即可获得1元现金红包，赶快加入吧。&lt;br /&gt;\n&lt;br /&gt;\n联系我们&lt;br /&gt;\n客服QQ群：818054548，客服QQ3420959071', '', '1641347764', '1641347764', '4.32 MB', '1.4.1', '苹果', '成都银象广告有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('6', '6', '钱咖最靠谱的手机任务平台，每月轻松多赚500元，收徒做任务还可获得超高提成，加入送现金红包！试玩应用&lt;span style=&quot;color:#ff0000;&quot;&gt;&lt;strong&gt;单价1.5元至4元不等&lt;/strong&gt;&lt;/span&gt;，10元就能提现。&lt;br /&gt;', '', '1641347764', '1641347764', '2.57MB', '3.0', 'iOS7.0以上', '钱咖网络科技(上海)有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('7', '7', '今日赚是国内最大的ASO搜索流量分发渠道，应用单价1元起，10元提现，是北京上榜科技科技有限公司推出的苹果iOS试玩应用赚钱平台。一部手机试玩应用就可以赚钱啦，轻松提现秒到账，快和我一起赚钱吧。', '', '1641347764', '1641347764', '20.1 MB', '2.1.2', 'iOS 8.0 以上', '北京上榜科技有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('8', '8', '掉钱眼儿一款用户激励式APP推广平台，&lt;strong&gt;&lt;span style=&quot;color:#ff0000;&quot;&gt;首次成功安装并激活，先领2元现金红包&lt;/span&gt;&lt;/strong&gt;，掉钱眼儿仅限苹果iOS平台使用。用户下载APP试玩体验，即可获得奖励，人人都是&amp;ldquo;应用体验师&amp;rdquo;。试玩一款应用1-3元，任务一般晚上9点更新。&lt;br /&gt;', '', '1641347764', '1641347764', '3.86MB', '1.2', 'iOS7.0以上', '闯奇信息科技(上海)有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('9', '9', '多玩红包（原一号红包），红包天天有，注册送1元，10元提现，单价1元左右！轻松赚钱无需投入，每日大量试玩任务上线，下载试玩后即可获得奖励。打开浏览器即可开玩，随手点一点，几块钱奖励瞬间到手，你所需要的只是一个手机。', '', '1641347764', '1641347764', '8.92MB', '1.0.2', '苹果手机', '有米科技股份有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('10', '10', '金手指，一款苹果试玩赚钱平台，可以点亮你的零花钱的APP，10元提现，单价1元左右。用户通过完成指定下载任务，从而获取丰厚的零花钱奖励。零花钱可以通过支付宝方式进行提现。', '', '1641347764', '1641347764', '14.3', '1.1.3', '苹果手机', '九晓(上海)信息技术有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('11', '11', '&lt;p&gt;钱派试玩是一款苹果手机试玩赚钱软件，单价8毛，满10元提现。钱派试玩让你越玩越有钱，苹果手机轻松兼职。钱派试玩为你提供超多好玩的应用，玩一玩应用就领现金奖励，赶快加入钱派试玩领奖励！&lt;/p&gt;', '', '1684467759', '1684467759', '3.25 MB', '1.0.1', '苹果', '南京凌晓信息科技有限公司', '5', '3256', '', '/uploads/allimg/20230517/1-23051G4435XM.jpg');
INSERT INTO `ey_images_content` VALUES ('12', '12', '&lt;p&gt;柚子试玩，苹果手机下载APP就能赚钱的软件。&lt;strong&gt;登陆就送1元，下载一个应用试玩3分钟奖励8毛，10元就能提现&lt;/strong&gt;。柚子试玩，随时随地，零成本、无分享的手机赚钱软件。好玩的手机赚钱平台，体验更有趣的APP。&lt;br/&gt;&lt;br/&gt;客服QQ：429019089&lt;br/&gt;&lt;br/&gt;柚子试玩是业内知名的移动应用媒体平台。为用户提供流行应用和游戏的资讯以及试玩服务，让每一个应用为人所用。让用户更方便的找到应用、了解应用，更有体验应用的红包奖励给你拿，让柚子试玩成为人人喜爱的应用社区。&lt;br/&gt;&lt;br/&gt;试玩应用领现金红包&lt;br/&gt;柚子试玩为你提供超多好玩的应用，试玩应用还能领取丰厚的现金红包，赶快加入柚子试玩~&lt;br/&gt;&lt;br/&gt;支持 微信/支付宝 提现&lt;br/&gt;随时提现，次工作日到账，你可以在这里享受最便捷的服务，柚子试玩还为你提供手机流量实时兑换服务。&lt;/p&gt;', '', '1684467782', '1684467782', '18.90 MB', '1.3.6', '苹果', '成都合元道科技有限公司', '5', '3256', '', '/uploads/allimg/20230517/1-23051G44342A4.jpg');
INSERT INTO `ey_images_content` VALUES ('13', '13', '&lt;p&gt;量次元是最新发布的一款苹果试玩赚钱软件，任务单价0.8-1元，满10元可支付宝提现。在量次元试玩平台，体验有趣的APP，每天还能赚到零花钱，新人注册送1元。目前仅支持苹果手机&lt;br/&gt;&lt;br/&gt;客服QQ群：672866250&lt;/p&gt;', '', '1684467788', '1684467788', '12.0 MB', '1.0.1', '苹果', '武汉领游科技有限公司', '5', '3256', '', '/uploads/allimg/20230517/1-23051G443349A.jpg');
INSERT INTO `ey_images_content` VALUES ('14', '14', '&lt;p&gt;赚钱吧是一个最新苹果手机APP试玩赚钱软件，下载一个APP单价1元奖励，新用户加入就送2元，10元就能提现，赶快加入赚钱吧下载应用赚钱啦。&lt;/p&gt;', '', '1684467795', '1684467795', '5.72 MB', '1.0.2', '苹果', '北京凡卓互动科技有限公司', '5', '3256', '', '/uploads/allimg/20230517/1-23051G44323229.jpg');
INSERT INTO `ey_images_content` VALUES ('15', '15', '&lt;p&gt;巨宝朋全新改版，任务多多，每个任务1元单价，10元可以提现，巨宝朋是最专业的苹果手机应用赚钱平台，每天大量任务。&lt;br/&gt;&lt;/p&gt;', '', '1684467801', '1684467801', '627KB', '1.0', 'iOS7.0以上', '上海聚鹏科技有限公司', '5', '3256', '', '/uploads/allimg/20230517/1-23051G44313613.jpg');
INSERT INTO `ey_images_content` VALUES ('16', '16', '&lt;p&gt;头号试玩 - 你的零钱提款机，用手机免费赚钱，试玩应用获得现金奖励，10元就能提现，单价1元左右。&lt;/p&gt;', '', '1684467806', '1684467806', '2.59MB', '1.0.1', '苹果手机', '上海仁端网络科技有限公司', '5', '3256', '', '/uploads/allimg/20230517/1-23051G44305928.jpg');
INSERT INTO `ey_images_content` VALUES ('17', '17', '&lt;div&gt;\r\n	手赚网官方苹果试玩赚钱入口是为了苹果手机试玩的玩家更方便的找到试玩平台的入口，以及助手失效后更快更方便的重新下载熟手，不用一个个去找新的助手，所有助手尽在手赚网的试玩赚钱入口。手赚网试玩赚钱入口汇聚热门苹果试玩赚钱平台，以及热门手赚资讯和试玩教程。&lt;/div&gt;', '', '1684467816', '1684467816', '0 MB', '1.0.', '苹果', '手赚网', '5', '3256', '', '/uploads/allimg/20230517/1-23051G4425B49.jpg');
INSERT INTO `ey_images_content` VALUES ('18', '18', '&lt;p&gt;小涵兼职是一个苹果试玩应用赚钱平台，任务单价1元左右，快速任务无需首次，能抢就能过，10元即可提现，只要你敢提我就能秒到，分分钟搞定。&lt;/p&gt;', '', '1684467823', '1684467823', '13.12 MB', '3.1.0', '苹果', '掌上互动广告平台', '5', '3256', '', '/uploads/allimg/20230517/1-23051G44242193.jpg');
INSERT INTO `ey_images_content` VALUES ('19', '19', '&lt;p&gt;火箭试玩，试玩APP就能赚现金，5元就能提现。火箭试玩是一款APP试玩体验平台，每天更新大量优质应用供大家体验。下载并完成一定任务就可以获得现金奖励，奖励金可以通过微信轻松体现。&amp;nbsp;&lt;br/&gt;&lt;br/&gt;客服QQ 2939791234&lt;/p&gt;', '', '1684397375', '1684397375', '2.13 MB', '1.0.1', '苹果', '北京一点触动科技有限公司', '5', '3256', '', '/uploads/allimg/20230518/1-23051Q609312M.jpg');
INSERT INTO `ey_images_content` VALUES ('20', '20', '&lt;p&gt;iMoney爱盈利是最专业的手机试客平台，多种赚钱方式让您多一份零花钱，立刻加入&lt;span style=&quot;color:#ff0000;&quot;&gt;&lt;strong&gt;送1元现金&lt;/strong&gt;&lt;/span&gt;奖励，&lt;strong&gt;&lt;span style=&quot;color:#ff0000;&quot;&gt;每天大量任务，单价1元起，10元提现&lt;/span&gt;&lt;/strong&gt;。iMoney为你提供超多好玩的应用，试玩应用还能领取丰厚的现金红包。&lt;/p&gt;', '', '1684397352', '1684397352', '3.01 MB', '1.1', '苹果手机', '北京爱普优邦科技有限公司', '5', '3256', '', '/uploads/allimg/20230518/1-23051Q60ZQ64.png');
INSERT INTO `ey_images_content` VALUES ('21', '21', '&lt;p&gt;&amp;amp;ldquo;来赚&amp;amp;rdquo;是一款iOS赚钱的APP，&lt;span style=&quot;color:#ff0000;&quot;&gt;安装就送0.8元，完成新手任务领红包&lt;/span&gt;，用户通过来赚去下载应用即可获得现金奖励。目前来赚仅针对iOS(苹果)用户开放。But，所有用户都可以通过邀请好友加入来赚，获得丰厚的邀请与提成奖励！钱包中现金可轻松提现，小伙伴们反馈都赚High了。&lt;/p&gt;', '', '1684397324', '1684397324', '4.82MB', '1.1.3', '苹果', '上海厚步网络技术有限公司', '5', '3256', '', '/uploads/allimg/20230518/1-23051Q60R5114.png');
INSERT INTO `ey_images_content` VALUES ('22', '22', 'i红包，在家躺着就能赚钱的苹果手机App，&lt;span style=&quot;color:#ff0000;&quot;&gt;&lt;strong&gt;注册送1元，10元就能提现&lt;/strong&gt;&lt;/span&gt;。每天都有大量试玩任务，赚钱后可通过支付宝提现。i红包让你开心赚钱，苹果手机下载APP并试玩轻松赚钱，提现无忧。参加现金狂欢计划，完成收徒任务，还可获得更高奖励。&lt;br /&gt;\n&lt;br /&gt;\n官方交流群：743073183', '', '1641347764', '1641347764', '14.8 MB', '1.2.0', '苹果', '玩出未来(北京)科技有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('23', '23', '天天赚钱是苹果应用试玩平台，下载应用试玩就能赚钱的软件，单价1元左右，10元提现。每天大量任务，赚钱后可通过支付宝提现或话费充值，躺着赚钱轻松提现。', '', '1641347764', '1641347764', '11.9MB', '1.1.0', '苹果手机', '武汉天天有量网络科技有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('24', '24', '应用试客是人人都喜爱的应用社区，下载试玩应用有现金奖励，&lt;span style=&quot;color:#ff0000;&quot;&gt;&lt;strong&gt;单价1-3元，8元即可提现（秒到帐）&lt;/strong&gt;&lt;/span&gt;。应用试客为你提供超多好玩的应用，试玩应用还能领取丰厚的现金红包，赶快加入应用试客~&lt;br /&gt;\n&lt;br /&gt;\n发现好玩有趣的APP，试玩应用更有现金奖励，赶快来试玩吧。仅限苹果iOS 9.0以上系统。', '', '1641347764', '1641347764', '6.78 MB', '2.0', '苹果', '北京多点科技股份有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('25', '25', '多多红包是一款能帮你赚钱的神奇软件，大家都玩的互动娱乐社区（&lt;span style=&quot;color:#ff0000;&quot;&gt;&lt;strong&gt;安装红包助手送3元&lt;/strong&gt;&lt;/span&gt;），&lt;span style=&quot;color:#ff0000;&quot;&gt;&lt;strong&gt;单价1元起，10元可提现&lt;/strong&gt;&lt;/span&gt;。你只需要每天花一点点时间去完成下载任务，就能得到现金奖励！可以直接提现或充值话费哦，参与活动获得惊喜福利，每天不间断。', '', '1641347764', '1641347764', '0.85MB', '2.4', 'iOS7.0以上', '北京多多科技有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('26', '26', '小鱼赚钱2016最新上线的手赚平台（仅限iOS平台），&lt;span style=&quot;color:#ff0000;&quot;&gt;&lt;strong&gt;安装即送2元&lt;/strong&gt;&lt;/span&gt;，最靠谱的手机赚钱平台。零投入，无需任何本金，下载APP试玩即可获得1-3元奖金，累计10元即可支付宝一键提现。&lt;br /&gt;', '', '1641347764', '1641347764', '2.68MB', '1.1', 'iOS7.0以上', '上海青墨网络科技有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('27', '27', '芒果试玩是最新出炉的苹果手机兼职试玩赚钱平台，下载应用就能赚钱，单价1元左右，加入就送3毛，可立即提现，秒到账。&lt;br /&gt;\n&lt;br /&gt;\n客服QQ：3327732314', '', '1641347764', '1641347764', '14.13 MB', '1.1.0', '苹果', '保定龙驰网络科技有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('28', '28', '蝉试客试玩有趣的APP，每月多赚500元，新用户注册送1元，10元提现，单价1元起。只要3分钟试玩体验，就能获得一次试玩奖励，利用碎片化时间，发现更多好玩应用。', '', '1641347764', '1641347764', '6.89MB', '1.2.6', '苹果手机', '厦门蝉声网络科技有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('29', '29', '秒赚大钱，下载APP试玩即可立得现金奖励，&lt;span style=&quot;color:#ff0000;&quot;&gt;&lt;strong&gt;10元起提现，试玩一个应用单价1元起，新用户送2元&lt;/strong&gt;&lt;/span&gt;。秒赚大钱，这是一款可以赚钱的手机软件，零成本，收入高，多种提现方式，极速到账，任务数量多，单价高。轻轻松松赚钱，真的躺着都会赚钱的平台！&lt;br /&gt;\n&lt;br /&gt;\n联系官方&lt;br /&gt;\n秒赚大钱官方客服QQ：3226044454，2815883901 、加qq请按要求提供秒赚id+问题', '', '1641347764', '1641347764', '2.66MB', '2.9', '苹果安卓', '北京好阿优科技有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('30', '30', '爱钱试玩，一款可以赚钱的手机试玩软件，为你提供超多好玩的应用，试玩应用还能领取丰厚的现金红包，赶快加入吧~10元就能提现，多种赚钱方式让您多一份零花钱，立刻加入送1元现金奖励。每天大量试玩任务，零投入收益远超XX宝。&lt;br /&gt;\r\n&lt;br /&gt;\r\n联系客服&lt;br /&gt;\r\n安卓客服qq:2885258924 时间：周一到周日10:00-18:00&lt;br /&gt;\r\n苹果客服qq:3004496998/3004452701 时间：周一到周日09:30-21:30', '', '1641347764', '1641347764', '2.58MB', '1.1.2', 'iOS7.0以上', '北京爱普优邦科技有限公司', '5', '3256', '/uploads/soft/200326/1-2003261R327.docx', '');
INSERT INTO `ey_images_content` VALUES ('31', '31', '知聊是一款可以通过&lt;strong&gt;聊天赚钱&lt;/strong&gt;的社交应用，一分钟赚2元，全民陪聊疯狂赚聊币。任何人都可以以视频、语音或短信的方式为他人提供聊天或答疑服务，按聊天时间向对方收费，超简单的发布一切你可提供的聊天话题，听人倾诉、给人安慰排忧、为人答疑----。&lt;br /&gt;\n&lt;br /&gt;\n下载登陆就送100聊币（价值1元），完成新手任务再送300金币。然后就可以设置价格发布陪聊了，大厅大部分都是150聊币一分钟。如果你有颜值，200聊币都有人找你聊的！平台50元起提现。', '', '1641347764', '1641347764', '17.56MB', '4.0.5', '不限', '', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('32', '32', '恐龙多多是一个类似恐龙世界养龙分红的平台，但是比恐龙世界更容易获得收益，分红龙也更容易获得，只不过现在初期收益比较低，但是获得收益更简单方便，&lt;strong&gt;0.3元就能提现秒到账&lt;/strong&gt;。&lt;br /&gt;\n&lt;br /&gt;\n人人都有分红龙，而且得到的分红龙可以连续分红7天，大大提高了普通用户的收入（基本每天可以提现）。目前我们已经上线了分红龙、至尊龙、奖品商城。&lt;br /&gt;\n&lt;br /&gt;\n恐龙多多平台理念：大咖赚大钱，小咖赚小钱。不仅赚钱，还能省钱！拒绝任何套路，客服微信：klkf2060，QQ群271874', '', '1641347764', '1641347764', '小程序', '1.0.2', '苹果安卓', '上海赐雅网络科技有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('33', '33', '&lt;div&gt;\n	玩洽，在家视频聊天就能赚钱的APP，全球年轻人的聊天赚钱的交友社区，在这里你可以通过声音卡片、快速聊天等遇见附近、国外的年轻人，并和他们开启一段新的社交体验，玩洽在200多个国家的年轻人中广泛流行。&amp;nbsp;&lt;br /&gt;\n	&amp;nbsp;', '', '1641347764', '1641347764', '39.08 MB', '3.5.2', '苹果安卓', '杭州知聊信息技术有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('34', '34', '哇咔搞笑是一款提供了丰富有趣的短视频轻松在线观看的手机软件，不仅可以看打算是娱乐打发时间，这里每日更有惊喜福利等你来领取，比如说签到就立即送现金，还有许多好玩的游戏随时畅玩，更有许多赚高收益任务方便便捷领取。&lt;br /&gt;\n&lt;br /&gt;\n&lt;div&gt;\n	功能介绍', '', '1641347764', '1641347764', '39.01 MB', '1.0.1', '安卓', '嘉兴字符律动互联网科技有限责任公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('35', '35', '众人帮赚钱,千万用户首选兼职，赚钱APP！ &lt;strong&gt;1元即可提现，秒到微信、支付宝。&lt;/strong&gt;众人帮每天一万多个悬赏让你赚个够，随时随地，躺在家里，轻松手机赚钱！ 每个悬赏的赏金都已托管到众人帮，只要您完成悬赏，众人帮立即发放赏金，再也不用担心拖欠和受骗。&amp;nbsp;&lt;br /&gt;\n&lt;br /&gt;\n轻松赚取生活费，实现&amp;rdquo;每天半小时，月赚1000元&amp;rdquo;的小目标。 生活中的棘手、为难事情，都可以在众人帮发悬赏来解决。 众人帮赚钱，一个更好的生活方式！', '', '1641347764', '1641347764', '19.45 MB', '3.6.6', '苹果安卓', '海宁酷酷信息技术服务有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('36', '36', '第一调查网旗下给力赚是一个做问卷调查赚钱的小程序，微信扫码即刻参加调查得现金，100金币=1元，5元即可提现（大概做两三个调查）。一份问卷大概需要4-5分钟的时间去完成，只要你的回答符合平台需要，那么你就会获得现金奖励。类似调查赚钱的还有集思吧旗下的赚点app和投吧网。', '', '1641347764', '1641347764', '小程序', '1.2.8', '不限', '上海库润信息技术有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('37', '37', '闲来斗地主（赚金版），隶属于上市公司昆仑万维集团（股票代码300418）北京闲徕互娱网络科技有限公司旗下，闲来斗地主不仅完全免费，更会在大家斗地主的过程中，给与一定的红包券奖励！红包券可以直接提现，&lt;span style=&quot;color:#008000;&quot;&gt;&lt;strong&gt;1元就能提现&lt;/strong&gt;&lt;/span&gt;，让您在健康的休闲娱乐过程中不仅收获了乐趣，而且还能有所收益！&lt;br /&gt;\n&lt;br /&gt;\n感谢广大闲友的支持，您有任何疑问可关注我们的官方公众号（xlddz188）咨询，我们将竭诚为您服务。', '', '1641347764', '1641347764', '35.86 MB', '2.7.5', '安卓', '北京闲徕互娱网络科技有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('38', '38', '蛋咖赚钱，让你的手机变身神奇的赚钱工具，让你赚钱赚到欲罢不能！热门手游棋牌，玩就能赚钱。海量应用，体验奖现金，海量低门槛、易上手的任务等你体验，不容错过的赚钱选择！&lt;br /&gt;\n&lt;br /&gt;\n客服QQ：800013154，周一至周五；9：30-12：00 14：00-18：00', '', '1641347764', '1641347764', '29.02 MB', '1.3.3', '苹果安卓', '杭州弈天网络技术有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('39', '39', '闪电接单是辅助任务平台码力任务平台升级而来，闪电接单就是码力任务平台，码力平台全新很好的质量更好的平台，更给力的奖励，更多的任务。码力任务平台(闪电接单)作为辅助平台界的巨头项目方，可以说在微信辅助业内实力毋庸置疑的，基本上持续全天不断单，很适合发展团队或者地推。', '', '1641347764', '1641347764', '2.01 MB', '0.0.2', '苹果安卓', '蚂蚁任务', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('40', '40', '牛帮 - 悬赏众帮平台，手机赚钱软件！是重庆网赚科技有限公司旗下的一款悬赏任务平台。为商家提供项目推广，任务分发的渠道。为用户提供赏金任务，兼职信息的平台。1元起提现，提现秒到账！&lt;br /&gt;\n&lt;br /&gt;\n*好的手机赚钱软件：&lt;br /&gt;\n商家发布任务（可以包含注册，下载，体验，分享，试用等形式）。&lt;br /&gt;\n用户完成任务，可获取赏金报酬。还有红包，各种奖励可以拿。&lt;br /&gt;&lt;br /&gt;客服QQ：2461348249、纠纷客服QQ：744680685，客服交流QQ群：604285219', '', '1641347764', '1641347764', '9.66 MB', '2.6.1', '安卓', '重庆余赚网络科技有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('41', '41', '蜂窝帮，让您的闲暇时间变得更有价值。蜂窝帮APP是一款手机悬赏任务平台，悬赏、互助，帮人忙就能赚钱！用户在这里，不仅可以通过完成悬赏任务来赚佣金，还可以发布任务供其他用户完成。海量悬赏任务，让你的业余时间变得更有价值！&lt;br /&gt;\n&lt;br /&gt;\n&lt;div&gt;\n	【平台特点】', '', '1641347764', '1641347764', '5.07 MB', '1.0.12', '安卓苹果', '重庆夭夭网络科技有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('42', '42', '钱帮是一款悬赏任务平台，平台拥有丰富的任务，用户在钱帮软件上接取任务完成任务即可获取收益，单价高，提现快，首次余额满1元即可提现，之后5元起提现。钱帮，做悬赏、来钱帮，海量悬赏任务等你来玩，每天几分钟，轻松赚现金。邀好友、享提成，躺着也能有收益，快来叫上亲朋好友一起来钱帮玩吧！&lt;br /&gt;\n&lt;br /&gt;\n&lt;div&gt;\n	平台介绍', '', '1641347764', '1641347764', '14.66 MB', '1.0.0', '安卓', '重庆光棱科技有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('43', '43', '&lt;div&gt;\n	截图宝，最火任务赚钱平台，自己做任务就能赚钱，多劳多得！大家都在玩的截图宝APP，就看视频、新闻或投票和截图日赚20元！每天最少200个任务，现在1元秒提现。完成新手任务奖励9.9元，d-y点赞能赚钱，文章自己阅读能赚钱，微信投票能赚钱。截图宝，做完任务截图提交就能赚钱，免费下载注册即刻开启任务赚钱！&lt;br /&gt;\n	&amp;nbsp;', '', '1641347764', '1641347764', '8.52 MB', '2.1.3', '安卓', '转乐旗下', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('44', '44', '撸猫有财是北京美云科技推出的一款合成赚钱的小游戏，让你玩游戏的同时也能赚零花钱，合成一只终极招财猫预计每天享受约300元左右的分红，完全0投入仅需每天动动手指头，快来一起赚钱吧。&lt;br /&gt;\n&lt;br /&gt;\n新手红包&lt;br /&gt;\n登陆就送新手大红包，猫达到指定等级还可以领大红包，0.3元就能提现，秒到账。&lt;br /&gt;\n&lt;br /&gt;\n若需要邀请码请填写：&lt;span style=&quot;color:#ff0000;&quot;&gt;&lt;strong&gt;M88NTgYH&lt;/strong&gt;&lt;/span&gt;', '', '1641347764', '1641347764', '6.67 MB', '1.0.1', '安卓', '北京美云科技有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('45', '45', '猫咪小屋（原生财喵）是阳光养猪场公司新推出的合成赚钱小游戏，登陆填写邀请码：126867789，送新手红包，首次0.3元起提现，后续30元起提现。&lt;br /&gt;\n&lt;br /&gt;\n猫咪小屋，一款在线吸猫的App，云吸猫轻松赚钱。阳光金币里面可藏了猫咪的宝藏；摇钱树，招财猫的羁绊之树，轻松赚钱1元提现马上到账。&lt;br /&gt;\n&lt;br /&gt;\n联系我们&lt;br /&gt;\n猫咪小屋官方客服QQ群：807054268，客服QQ：2881386248、2881517886', '', '1641347764', '1641347764', '13.53 MB', '1.1.5', '安卓苹果', '上海嵩沃网络科技有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('46', '46', '悬赏猫是一款小巧、好用的手机兼职赚钱软件，1元就能提现，秒到账。悬赏猫提供各种类型的任务供用户选择，空闲时间，拿出手机做做小任务，就能快速赚取零花钱。在这里你可以做悬赏赚钱，赚得佣金可随时提现。在悬赏猫app你也可以发布悬赏任务，让千万用户体验你的产品。&lt;br /&gt;\n&lt;br /&gt;\n客服QQ群：143685636', '', '1641347764', '1641347764', '7.06 MB', '1.8.1', '安卓', '合肥大头马网络科技有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('47', '47', '&lt;p&gt;答题夺宝是一款答题赚钱、益智题材的学习工具，让用户在获取知识的同时，每答一题都能产生价值。登陆填写邀请码&lt;span style=&quot;color:#ff0000;&quot;&gt;&lt;strong&gt;361829476&lt;/strong&gt;&lt;/span&gt;即送0.5元红包，首次3毛提现秒到账，之后20元起提现。首轮答题满送1.25元，越后面开的红包越大，同时还有分红猫，答题过程有机会获得限时分红猫。&lt;br/&gt;&lt;br/&gt;功能说明：&lt;br/&gt;1）轻松答题&lt;br/&gt;用户可通过参与答题，完成选择题和成语题的挑战，获取知识的同时收获惊喜。&lt;br/&gt;2）欢乐闯关&lt;br/&gt;用户可通过参与答题，开启更多地图关卡，获取更多惊喜和关卡挑战。&lt;br/&gt;3）额外惊喜&lt;br/&gt;用户可通过任务中心和活动中心，获取额外惊喜。&lt;br/&gt;4）答题道具&lt;br/&gt;参与每轮答题需消耗1点体力值，在答题过程中可使用道具辅助，让获取知识更为轻松。&lt;/p&gt;', '', '1641363495', '1641363495', '14.29 MB', '1.0.7', '安卓苹果', '海南猫扑网络科技有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('48', '48', '&lt;div&gt;\n	恐龙世界一个类似恐龙有钱的全新的通过合成升级的养成赚钱小游戏，登陆填写邀请码【&lt;span style=&quot;color:#ff0000;&quot;&gt;&lt;strong&gt;1017299840&lt;/strong&gt;&lt;/span&gt;】就送大红包，3毛就能提现秒到账，每升一级就送红包，奖励高，福利多。简单合成快乐养龙，简单的召唤与合成，娱乐从养龙开始。', '', '1641347764', '1641347764', '8.13 MB', '1.0.0', '安卓', '天津高远网络技术有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('49', '49', '疯狂猜成语是一款全中文休闲益智答题赚钱游戏，疯狂猜成语答题有奖励，边玩边赚，新人注册填写邀请码&lt;span style=&quot;color:#ff0000;&quot;&gt;&lt;strong&gt;304548024&lt;/strong&gt;&lt;/span&gt;就送0.5元，3毛就能提现，秒到账。玩玩猜成语的小游戏也能赚钱，通过猜成语、签到、抽奖、完成每日任务等获得金币，金币秒兑换提现，团队推广收益更高哦！&lt;br /&gt;\n&lt;br /&gt;\n玩疯狂猜成语，可以和好友一起体验中国古老文化-成语的魅力，上千关卡等你挑战，让你感受妙趣横生的成语接龙游戏。&lt;br /&gt;\n&lt;br /&gt;\n&lt;div&gt;\n	【产品亮点】', '', '1641347764', '1641347764', '16.39 MB', '6.0.5', '安卓苹果', '上海小鲜网络科技有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('50', '50', '哆啦赚是一个任务悬赏、互助的兼职手赚平台，最低3元起提现，悬赏主发布需求，万计乐友合力帮忙， 协助悬赏主快速实现要求目标，乐友也利用零碎时间赚取合理佣金。填写邀请码【&lt;span style=&quot;color:#ff0000;&quot;&gt;&lt;strong&gt;641570&lt;/strong&gt;&lt;/span&gt;】，&lt;strong&gt;领新手红包奖励&lt;/strong&gt;！平台担保交易公平，APP注册体验、软件试玩、转发广告、产品推广、商务推广等，欢迎您的加入！&lt;br /&gt;\n&lt;br /&gt;\n&lt;div&gt;\n	哆啦赚给你一个快乐的兼职方式！', '', '1641347764', '1641347764', '5.53 MB', '1.2.6', '安卓苹果', '徐州美美家环保科技有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('51', '51', '&lt;div&gt;\n	码力任务辅助平台全面升级为全自动任务平台（码力任务首码&lt;span style=&quot;color:#ff0000;&quot;&gt;&lt;strong&gt;eU9VaTe5&lt;/strong&gt;&lt;/span&gt;），平台对接海量商家，商家在平台发布任务的价格直接显示在接单端，平台固定抽佣10%，用来维持平台日常运营，人力成本。&lt;br /&gt;\n	&lt;br /&gt;\n	码力任务是一个最新微信辅助注册赚钱的APP，目前平台任务数量很充足、单价比起之前介绍的几个平台都要高一些，一单辅助注册6.3元左右，平台满20元起提现，秒到账。&lt;br /&gt;\n	&lt;br /&gt;\n	&lt;div&gt;\n		码力app使用方法：', '', '1641347764', '1641347764', '11.50 MB', '1.0.4', '苹果安卓', '码力任务', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('52', '52', 'FZ辅助平台是一款微信辅助app，提现秒到账，相信现在很多人都知道，注册一个微信号是需要老号辅助才能注册成功的，所以导致很多人都在找别人辅助注册微信号，慢慢的就形成了一个产业链，而FZ辅助平台就可以接单赚钱。&lt;br /&gt;\n&lt;br /&gt;\n&lt;div&gt;\n	Fz辅助平台常见问题：', '', '1641347764', '1641347764', '11.84 MB', '2.3.6', '苹果安卓', 'FZ辅助', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('53', '53', '贪吃蛇在线，超炫皮肤免费送，&lt;strong&gt;登陆就送3毛新人红包，可立即提现，秒到账&lt;/strong&gt;。邀请码【&lt;span style=&quot;color:#ff0000;&quot;&gt;&lt;strong&gt;6662585056&lt;/strong&gt;&lt;/span&gt;】贪吃蛇是一款竞技类休闲游戏，游戏中控制蛇头进行移动通过吃金币、击杀其他玩家的方式不断提升自身长度，在规定的时间结束前保持最长长度，从而获得单局胜利。&lt;br /&gt;\n&lt;br /&gt;\n&lt;div&gt;\n	四大特色新奇体验', '', '1641347764', '1641347764', '40.61 MB', '1.0.5', '安卓苹果', '海南猫扑网络科技有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('54', '54', '阳光养猪场让您成为猪场的主人，下载App后可填写邀请码&lt;span style=&quot;color:#ff0000;&quot;&gt;&lt;strong&gt;65691050&lt;/strong&gt;&lt;/span&gt;免费领取新人现金红包，&lt;strong&gt;1元就能提现，秒到账&lt;/strong&gt;。简单召唤合成，每只猪都能为您赚钱，等级越高赚钱越多，休闲赚钱两不误，养猪还送真猪肉，快来参与吧！&lt;br /&gt;\n&lt;br /&gt;\n客服QQ群：732247792', '', '1641347764', '1641347764', '8.76 MB', '1.0.7', '安卓', '上海嵩沃网络科技有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('55', '55', '小白赚钱是一个任务悬赏的兼职赚钱平台，做任务领悬赏拿现金，完成新手任务即可领7元现金，超低提现门槛，2元就能提现，提现简单，到账快。互联网小白一天也能轻松赚几十块，小白赚钱是一款让您轻松赚钱的手机兼职APP。&lt;br /&gt;\n&lt;br /&gt;\n联系我们&lt;br /&gt;\n客服QQ群：564104407、736856485、客服微信：yato_85，客服QQ：2930108140', '', '1641347764', '1641347764', '16.55 M', '3.1.0', '安卓', '山东省滕州风云文化传媒有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('56', '56', '趣闲赚是徐州华英网络科技有限公司开发出来一款学生、宝妈等在家就可以兼职赚钱的APP软件。小任务获取大报酬，动动手指就可以领取相应的报酬。注册下载（趣闲赚APP）完成新手任务即可领取新人奖励，无需手续费，1元提现秒到账，支持账微信支付宝&lt;br /&gt;\n&lt;br /&gt;\n悬赏任务多，赏金丰厚&lt;br /&gt;\n上万多个悬赏让你赚个够，每个任务奖金全部托管平台，做完任务立刻领取，支持一元提现，资金周转更方便，&lt;br /&gt;\n任务赚钱三步骤-报名承接任务-上传完成任务截图-即可领取任务赏金。&lt;br /&gt;\n&lt;br /&gt;\n邀请好友赚提成&lt;br /&gt;\n每邀请一位好友，首次提现就会奖励您1元钱，永久性赚任务佣金提成。3级邀请分红模式，一级分6%，二级分4% 三级2%。给自己定个小目标，每天邀请十个人，赚钱更容易&lt;br /&gt;\n&lt;br /&gt;\n商家发布任务&lt;br /&gt;\n发布任务审核快，0元手续费，采用体验式广告方式。完成任务，让用户可以真正体验网站的服务，达到优佳的转化效果，还可以根据效果不断的优化、过滤。&lt;br /&gt;\n&lt;br /&gt;\n官方QQ群：755403783', '', '1641347764', '1641347764', '5.16 MB', '1.3.5', '安卓', '徐州华英网络科技有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('57', '57', '欢乐招财犬，2020新出狗狗合成分红模式，全网静态收益最具竞争力！欢乐招财犬，一款带你去世界各地旅行的APP，在带上心爱 的狗狗走遍全球的同时，还可以把里程兑换成金币，边旅行边赚钱，每天收获欢乐和红包。&lt;br /&gt;\n&lt;br /&gt;\n目前暂时不能下载，只能预注册。\n&lt;div&gt;\n	3月7号&amp;nbsp; 上线h5网页锁粉功能', '', '1641347764', '1641347764', '21.16 MB', '1.1.5', '安卓苹果', '天津新趣科技有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('58', '58', '小龙虾大亨是一款全新的手机合成赚钱的软件，新人用户注册成功，会得到随机的红包奖励，可立即提现3毛，秒到账。之后只需要饲养小龙虾，不断的提升小龙虾的等级并且合成出优质的小龙虾，就可以获得大量丰富的奖励。&lt;br /&gt;\n&lt;br /&gt;\n小龙虾大亨特点&lt;br /&gt;\n&lt;div&gt;\n	注册到6级，几分钟即领最低12元红包，若需要邀请码请填【&lt;span style=&quot;color:#ff0000;&quot;&gt;&lt;strong&gt;4vv6ct&lt;/strong&gt;&lt;/span&gt;】。', '', '1641347764', '1641347764', '38.61 MB', '1.0.3', '安卓', '上海久游网络科技有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('59', '59', '&lt;div&gt;\n	恐龙有钱&lt;!--（&lt;strong style=&quot;color:#FF0000; font-size:18px&quot;&gt;垃圾死骗子平台要跑路了，不想给钱，一句作弊就给你打发了。大家千万不要做垃圾恐龙有钱，随意封号，一句作弊就不给打款，要跑路了。&lt;/strong&gt;）--&gt;是一款安全靠谱的养成游戏网赚应用软件，&lt;strong&gt;若需邀请码请&lt;/strong&gt;&lt;strong&gt;填&lt;/strong&gt;&lt;strong&gt;写&lt;/strong&gt;&lt;strong&gt;【&lt;span style=&quot;font-size:16px;&quot;&gt;&lt;span style=&quot;color:#ff0000;&quot;&gt;5752fc&lt;/span&gt;&lt;/span&gt;】&lt;/strong&gt;，采用陀螺世界模式养龙来获取收益，用户可以通过软件来合成一条分红龙，这条龙每天都会为用户带来收益，软件操作非常的简单，每天也不需要花太多的时间，就可以轻轻松松获取到可观的收益，现在邀请好友加入软件一起挣钱还可以获得额外奖励。', '', '1641347764', '1641347764', '19.73 MB', '1.0.1', '安卓苹果', '上海易慕网络科技有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('60', '60', '《全民养龙》是一款0充值基于大数据的手机游戏，通过五福龙合成分红龙，每天可以领取约300元的平台奖励。填邀请【&lt;span style=&quot;color:#ff0000;&quot;&gt;&lt;strong&gt;1IJMFR&lt;/strong&gt;&lt;/span&gt;】可&lt;strong&gt;领取额外奖励&lt;/strong&gt;，领养一直可爱的分红龙，进度满100%，两只37级龙合成将必定获得一只分红龙，分红龙每天约分红300元。&lt;br /&gt;\r\n&lt;br /&gt;\r\n全民养龙，全民创业，养一只可爱的分红龙帮你赚钱吧，每只分红约220元。没有充值入口，不需要投入一分钱，支持苹果和安卓双端。新人注册玩到3级领最高10元红包，最少3元。', '', '1641347764', '1641347764', '8.07 MB', '1.1.0', '苹果安卓', '武汉锦然网络科技有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('61', '61', '乐米资讯是贝米资讯旗下转发赚钱的新平台，注册送7毛，阅读文章单价1毛2，收益高涨分快，1元即可提现，秒到账。&lt;br /&gt;\n&lt;br /&gt;\n客服微信：duomizixunkefu', '', '1641347764', '1641347764', '3.37 MB', '1.3.1', '安卓苹果', '郓城久赢网络科技有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('62', '62', '淘金赚是有银子旗下最新转发文章赚钱平台，注册送1元，1元就能提现。转文章，赚零花，分享新闻享广告收益，每篇文章0.1元/每阅读 ，收徒享受二级共30%提成。&lt;br /&gt;\n&lt;br /&gt;\n客服微信：haokaixin89', '', '1641347764', '1641347764', '14.11 MB', '1.0.1', '安卓', '有银子', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('63', '63', '猫猫赚是懒猫试玩旗下的安卓版试玩答题赚钱平台，躺着赚钱的APP，1元可提现。一款以答题形式为主的试玩APP，用户通过完成指定任务，从而获得丰厚的现金奖励，赚取的收益可通过微信方式进行提现。&lt;br /&gt;\n&lt;br /&gt;\n怎么赚钱：填写邀请码&lt;span style=&quot;color:#ff0000;&quot;&gt;&lt;strong&gt;TGNWEW&lt;/strong&gt;&lt;/span&gt;领红包&lt;br /&gt;\n1、APP首页点&amp;ldquo;喵抓一下&amp;rdquo;，每次点击试玩不同的任务；&lt;br /&gt;\n2、完成新手任务，做任务，赚大钱，签到任务，连续签到更多奖励。', '', '1641347764', '1641347764', '8.00 MB', '1.0.1', '安卓', '杭州九吨科技有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('64', '64', '每天赚点是一个手机赚钱的应用，&lt;span style=&quot;color:#ff0000;&quot;&gt;&lt;strong&gt;安装拆红包，一元秒提&lt;/strong&gt;&lt;/span&gt;！收益最高！任务最多！红包送不停！让用户在玩手机的同时还能赚到钱，用户可以通过安装，试玩，邀请好友，签到等赚取积分，还可以把积分变现成充值卡、Q币、支付宝充值等。&lt;br /&gt;\n&lt;br /&gt;\n每天都有固定的下载任务，下载赚取财富，您的所有资金都可以打到您的支付宝上或者是进行话费充值，每日参与抽奖有机会中积分大奖。', '', '1641347764', '1641347764', '7.39 MB', '1.16', 'Android 3.3以上', '北京图田科技有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('65', '65', '灵猴app，随手旗下全新平台8月1日10点上线！ 阅读单价0.3元，涨分超快！ &lt;strong&gt;注册送0.5元，2元提现，秒到账！&lt;/strong&gt;文章、广告正规，适合所有人转发！收徒活动同步上线， 徒弟首提师傅可得4-8元奖励， 收徒奖励最高达16元，师父可得20%+10%二级转发分成！&lt;br /&gt;\n&lt;br /&gt;\n联系我们&lt;br /&gt;\n客服微信：Bengshakalaka199', '', '1641347764', '1641347764', '1.75 MB', '3.4.6', '安卓', '随手家', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('66', '66', '小龙赚钱，在家兼职赚钱首选平台，随时随地赚钱，让您的休闲时间更具有价值，1元就能提现。小龙赚钱是一款适用于广大兼职爱好者的app，里面有多种任务形式（快速任务，实名任务，绑卡赚钱，小程序赚钱，玩游戏赚钱...），让你在家轻松赚更多的零花钱。仅限安卓&lt;br /&gt;\n&lt;br /&gt;\n客服QQ：1091209640', '', '1641347764', '1641347764', '7.95 MB', '1.0.3', '安卓', '惠州市七号互动科技有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('67', '67', '蘑菇乐园，一款玩手机游戏轻松赚钱的兼职赚钱APP。在蘑菇乐园赚钱送您三大福利，新人送你7天蘑菇会员奖励加成20%，新人专享0.4元现金红包，打卡体验金1元，挑战成功瓜分奖励，1元即可提现。填写邀请码&lt;span style=&quot;color:#ff0000;&quot;&gt;&lt;strong&gt;DUCV&lt;/strong&gt;&lt;/span&gt;领现金红包！', '', '1641347764', '1641347764', '12.84 MB', '3.0.4', '安卓', '杭州嘻趣科技有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('68', '68', '钱大师是一款手机试玩兼职赚钱软件，&lt;strong&gt;填写邀请码【&lt;span style=&quot;color:#ff0000;&quot;&gt;5UYO6S&lt;/span&gt;】登录即送1.88元现金&lt;/strong&gt;。每天利用上厕所的时间动动手指就可以帮你实现天天吃猪肉包子的富豪人生，除了游戏类任务试玩外，应有尽有的各类型有趣软件任务类型供你选择，时时更新数不胜数。&lt;br /&gt;\n&lt;br /&gt;\n钱大师热门活动持续进行中，助你每天赚翻零花钱。&lt;br /&gt;\n【新手奖励】新用户注册&lt;strong&gt;登录即送1.88元现金&lt;/strong&gt;！完成3个任务即可提现一元，秒到账，不限次数哟。&lt;br /&gt;\n【打卡分钱】参与每日打卡，便可瓜分奖池现金。&lt;br /&gt;\n【签到红包】每日完成任务即可签到，签到每日奖现金1元。&lt;br /&gt;\n&lt;br /&gt;\n联系我们&lt;br /&gt;\n客服QQ：2860924261，QQ群：603471520', '', '1641347764', '1641347764', '18.01 MB', '1.7.1', '苹果安卓', '西安九点整软件科技有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('69', '69', '泡泡赚是快乐赚旗下手机体验平台，&lt;span style=&quot;color:#ff0000;&quot;&gt;&lt;strong&gt;注册即送5元，首次10元提现，之后每次5元起即可提现&lt;/strong&gt;&lt;/span&gt;。泡泡赚上不仅能玩幸运28手机竞猜，还能赚钱哟！操作简单，种类众多，奖励还高！只要通过简单的下载安装、试玩、娱乐、收徒等方式就可以赚取超多现金，并能够快速提现至支付宝或微信。&lt;br /&gt;\n&lt;br /&gt;\n&lt;div&gt;\n	泡泡赚 攻略宝典', '', '1641347764', '1641347764', '9，86MB', '2.0.1', '安卓手机', '杭州新知迅网络技术有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('70', '70', '米赚由北京米拓世纪科技有限公司研发并运营，在2011年9月正式发布，是国内第一个专注于移动威客的手机应用，拥有3000万用户，是国内外知名的手机赚钱应用。 安装后完成新手任务即可兑换1Q币！也可兑换话费、提现到支付宝和微信等等！&lt;br /&gt;', '', '1641347764', '1641347764', '3.30 MB', '2.80', 'Android 2.3以上', '北京米拓世纪科技有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('71', '71', '蜜蜂试玩安卓版是一款安卓手机赚钱的软件，任务单价0.5元到0.6元，3元就能提现，超低门槛，此外还有苹果版。&lt;br /&gt;\n&lt;br /&gt;\n官方QQ交流群：692310945', '', '1641347764', '1641347764', '2.97 MB', '1.0.1', '苹果安卓', '苏州高达尚网络科技有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('72', '72', 'Q玩小游戏是一个小游戏集合平台，每天小游戏轻松赚零花钱，新手注册就领红包。Q玩小游戏是一款集合多种小游戏的操作简单，游戏节奏快，让你在游戏里拼手速，拼脑力，填补你的无聊空闲时光。&lt;br /&gt;\n&lt;br /&gt;\n多款小游戏，定时更新，让你玩不停，享受愉悦的游戏时光！海量原创小游戏，单机对战总有一款适合你！&lt;br /&gt;\n&lt;br /&gt;\n联系我们&lt;br /&gt;\n官方客服QQ群：817171843', '', '1641347764', '1641347764', '11.65 MB', '1.0.6', '安卓', '北京淘阅文化科技有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('73', '73', '葫芦赚是一款为普通人打造的手机赚钱App，1元就能提现，秒到账。葫芦星球没有复杂的理财投资、不支付任何费用，不限时间地点，有手机就能随时随地赚点零花钱~时间就是金钱，来葫芦赚把你的碎片时间变成钱~&lt;br /&gt;\n&lt;br /&gt;\n赚钱方式：&lt;br /&gt;\n【1元提现】每天无限次，免审核 秒到账&lt;br /&gt;\n【高额赚】打麻将、斗地主等等试玩游戏就能赚钱&lt;br /&gt;\n【轻松赚】下载软件应用、试玩游戏、关注公众号等都能赚钱，每天都有新任务&lt;br /&gt;\n【邀请赚】邀请1个好友可得7元，上不封顶，还有各种活动奖上加奖&lt;br /&gt;\n【星球赚】葫芦星球每天送钱，不做任务也可以领钱&lt;br /&gt;\n&lt;br /&gt;\n客服QQ：3508392342 客服微信号：a1609170062（周一-周五每天9:30-18:30）&lt;br /&gt;\n官方QQ群：780080663', '', '1641347764', '1641347764', '9.11 MB', '1.1.3', '安卓', '杭州首享科技有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('74', '74', '蹦蹦网手机APP，手机也可以玩游戏赚钱啦！手机也可以玩游戏赚钱，蹦蹦网手机app强势来袭，手机上我们也可以玩游戏赚钱啦，模式、方法都是超级简单，手游赚钱！在人手一部智能手机的今天，能用手机玩游戏赚钱无疑是一个不错的方式。', '', '1641347764', '1641347764', '7.96MB', '2.1.2', 'Android 2.2以上', '杭州易特旺旺网络技术有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('75', '75', '聚享游是给用户提供网赚、兼职项目一个平台，利用业余时间赚钱的不二之选，1元提现秒到账。你在聚享游的所有行为都会产生收益，参与签到、匠神部落、游戏试玩、棋牌试玩、悬赏任务、邀请好友等都会获得奖励，奖励直接存入你的账户，可直接提现，10000U币=1元。只限安卓&lt;br /&gt;\n&lt;br /&gt;\n联系我们&lt;br /&gt;\n客服热线：400-8899-055&amp;nbsp; &amp;nbsp;客服QQ：800171920&amp;nbsp; &amp;nbsp; 服务时间：周一至周五9:30-18:30&lt;br /&gt;\n聚享游娱乐公告QQ群：764027823&amp;nbsp; &amp;nbsp; 聚享游官方公告群：685672220', '', '1641347764', '1641347764', '15.81 MB', '1.2.0', '安卓', '杭州淘游科技有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('76', '76', '赚宝是一款手机试玩应用就能赚钱的APP！完成简单的试玩任务即可赚钱，新人首次登陆就送3元，完成新手任务领取1-10元奖励！随时提现到帐，并支持微信、支付宝快速提现！&lt;br /&gt;\n&lt;br /&gt;\n官方QQ群：835541017', '', '1641347764', '1641347764', '5.51 MB', '1.0.1', '安卓', '广州赚宝网络科技有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('77', '77', '零钱试玩，安卓赚钱新平台！一款手机试玩几分钟就能赚钱的APP。只要有一部手机，无需出门，无需投入，轻轻松松动手指，就能每天赚取现金奖励！！！还能通过收取徒弟，赚取徒弟同等的分成奖励哦~&lt;br /&gt;\n&lt;br /&gt;\n【每日任务】每天大量任务，只需试玩几分钟，零花钱赚得根本停不下来~&lt;br /&gt;\n【收徒返现】收取徒弟，你可获得徒弟任务同等的分成现金，徒弟越多，奖金叠加，上不封顶哟~&lt;br /&gt;\n【快速提现】便捷快速的提现流程，安全保障零花钱每天到账，完全无需担忧哦~&lt;br /&gt;\n&lt;br /&gt;\n-遇到问题，联系我们&lt;br /&gt;\n官方QQ交流群：879136914&lt;br /&gt;\n客服小姐姐QQ：248973501、226986975', '', '1641347764', '1641347764', '7.69 MB', '0.2.5', '安卓', '广州有穗科技有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('78', '78', '零用钱就&lt;span style=&quot;color:#ff0000;&quot;&gt;&lt;strong&gt;送3元现金&lt;/strong&gt;&lt;/span&gt;，做任务领现金，收益&lt;span style=&quot;color:#008000;&quot;&gt;&lt;strong&gt;满1元就能提现&lt;/strong&gt;&lt;/span&gt;，可信的手机版赚钱软件。简洁的操作，尊贵的体验，只需轻松动动手指，轻松赚钱，每天一分钟安装手机软件，零用钱到手。&lt;br /&gt;', '', '1641347764', '1641347764', '2.5MB', '4.8.12', 'Android2.2及以上', '北京零用钱科技有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('79', '79', '赚客，一款让你轻松赚钱的手机APP，新用户安装&lt;strong&gt;&lt;span style=&quot;color:#ff0000;&quot;&gt;送3元现金&lt;/span&gt;&lt;/strong&gt;，任务量爆棚的平台，一个能赚8毛，15分钟赚20元，话费，&lt;strong&gt;&lt;span style=&quot;color:#008000;&quot;&gt;现金10元可提现&lt;/span&gt;&lt;/strong&gt;，&lt;strong&gt;&lt;span style=&quot;color:#008000;&quot;&gt;24小时闪电到账&lt;/span&gt;&lt;/strong&gt;！赚客每日抽奖秒领现金，实物大奖笔记本、平衡车、音响免费抽！开箱夺宝送iphone，游戏赚钱两不误！&lt;br /&gt;\n&lt;div style=&quot;text-align: center;&quot;&gt;\n	&amp;nbsp;', '', '1641347764', '1641347764', '1.2MB', '1.5', 'Android2.3以上', '珠海蜂巢网络科技有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('80', '80', '蛋咖赚钱是PC蛋蛋旗下APP，让你的手机变身神奇的赚钱工具，让你赚钱赚到欲罢不能！热门手游棋牌，玩就能赚钱。海量应用，体验奖现金，海量低门槛、易上手的任务等你体验，不容错过的赚钱选择！&lt;br /&gt;\n&lt;br /&gt;\n客服QQ：800013154，周一至周五；9：30-12：00 14：00-18：00', '', '1641347764', '1641347764', '29.02 MB', '1.3.3', '苹果安卓', '杭州弈天网络技术有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('81', '81', '每日赚点app，看广告就能赚钱，下载登陆就送3元红包，完成新手任务送1元，支持1元提现。除了看广告赚钱，每日赚点还有下载试玩赚钱、分享文章赚钱和每日红包等你来抢。', '', '1641347764', '1641347764', '12.3MB', '2.1.1', '暂时只有安卓手机', '苏州蘑菇云网络科技有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('82', '82', '有赚app是有赚网旗下手机赚钱软件，开启你的懒人模式还能快速赚钱，就来下载有赚app吧，&lt;span style=&quot;color:#ff0000;&quot;&gt;&lt;strong&gt;新人送12元福利卡，1元提现快速到账&lt;/strong&gt;&lt;/span&gt;！有赚app让您随时随地赚大钱。动动手指就能赚钱，大家都在用手机赚钱。玩手机游戏兼职做任务赚钱，给需要兼职赚钱的学生和宝妈们，带来方便快捷的兼职平台。&lt;br /&gt;\n&lt;br /&gt;\n&lt;div&gt;\n	平台特点：', '', '1641347764', '1641347764', '4.8MB', '1.3.6', 'Android2.0以上', '有赚网旗下app', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('83', '83', '蛋蛋赚是一款学生手机赚钱软件，&lt;span style=&quot;color:#ff0000;&quot;&gt;&lt;strong&gt;提现秒到账&lt;/strong&gt;&lt;/span&gt;。适合学生兼职赚零钱，宝妈兼职赚钱软件，用户可以利用闲暇时间玩游戏赚钱，答题赚钱，在玩麻将，斗地主等小游戏的同时还能分享精彩内容赚零花钱。蛋蛋赚操作简单，较现在流行的学生赚，米赚，钱咖等要更加的直观，新手引导微信红包秒提到账。&lt;br /&gt;\n&lt;br /&gt;\n用户只需按照要求体验蛋蛋赚推荐的应用和游戏，通过微信朋友圈分享文章或者是关注蛋蛋赚推荐的微信公众账号，即可获得相应的奖励，真的是10分钟赚10元，当奖励到达20元就可以提现了。你手机上还没安装蛋蛋赚你就out了！大家都在赚钱，赶紧加入吧！新人还有特享微信红包任务哦！&lt;br /&gt;\n&lt;br /&gt;\n蛋蛋赚是国内领先的手机赚钱APP, 蛋蛋赚除了可以兑换Q币，相较于惠头条，钱咖，红包头条，酷划，趣头条等新闻赚钱软件，还兑换支持中国移动、中国电信、中国联通话费，流量等丰富的奖品，支持微信，支付宝免手续费提现快速到账。&lt;br /&gt;', '', '1641347764', '1641347764', '3.21 MB', '3.0.0', 'Android 2.2以上', '杭州乐真网络科技有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('84', '84', '麦子赚是一款能够赚钱的app，&lt;span style=&quot;color:#ff0000;&quot;&gt;&lt;strong&gt;1元就能提现&lt;/strong&gt;&lt;/span&gt;。0元投入，在闲暇时刻，轻轻松松完成各种任务，简简单单赚取零花钱，收益高提现快。让麦小兜带你们飞，从此再也不用担心每天的早饭钱了。每日睁开眼，进入麦子赚，就会有满满的惊喜在等着你。。。&lt;br /&gt;\n&lt;br /&gt;\n温馨小提示：&lt;br /&gt;\n1、每日签到都有爱心红包可以领取；&lt;br /&gt;\n2、周一至周日7天连续签到并且没有领取过爱心红包的便可激活超级红包。&amp;lt;', '', '1641347764', '1641347764', '5.47 MB', '2.2.0', '安卓手机', '杭州麦子汇网络技术有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('85', '85', 'iMoney爱盈利试玩平台出安卓版啦，2元就能提现，超低门槛，通过试玩应用或做指定的小任务获得现金奖励。', '', '1641347764', '1641347764', '5.57 MB', '1.3.0', '苹果安卓', '北京爱普优邦科技有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('86', '86', '明明乐园是一款免费的线上娱乐类平台，玩游戏还能赚钱的APP，不但免费玩游戏还有金币福利！玩游戏还能挣钱？没错一切尽在明明乐园。填写邀请码【&lt;span style=&quot;font-size:16px;&quot;&gt;&lt;span style=&quot;color:#ff0000;&quot;&gt;&lt;strong&gt;8913&lt;/strong&gt;&lt;/span&gt;&lt;/span&gt;】领金币，金币可兑换现金，0.3元就能提现。支持安卓和苹果手机！&lt;br /&gt;\n&lt;br /&gt;\n【玩游戏】&lt;br /&gt;\n集合了当下流行的益智小游戏，生活的压力让你疲惫不堪？来明明乐园放松一下吧，总有一款适合你。&lt;br /&gt;\n【有福利】&lt;br /&gt;\n签到活动，金币活动，游戏活动...各种活动应有尽有，随时可以提现，只要你来玩！玩游戏还能赚钱！&lt;br /&gt;\n&lt;br /&gt;\n联系客服&lt;br /&gt;\n客服交流QQ群：526687968，客服QQ：3262184603', '', '1641347764', '1641347764', '17.77 MB', '1.0.2', '安卓', '杭州亲豆网络科技有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('87', '87', '玩游赚是一个以玩手机游戏就能赚零花钱的app，首次1元就能提现，后续5元起提现，超低提现门槛。玩的越多玩的越久，等级越高就赚的越多，记住最好不要充钱玩。对于爱玩游戏的朋友来说这个app再好不过，免费玩游戏还能兼而赚点零花钱，一举两得，仅支持安卓手机下载。', '', '1641347764', '1641347764', '2.76 MB', '1.0.0', '安卓', '多有移动', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('88', '88', '&lt;div&gt;&amp;nbsp; &amp;nbsp;\r\n	手赚网APP由手赚网官方出品，支持苹果和安卓手机，提供最新最全的手机兼职赚钱软件下载，最热门苹果手机试玩赚钱平台排行，让你随时随地，轻松赚钱！&lt;/div&gt;', '', '1684486856', '1684486856', '1.23 MB', '2.0.0', '苹果安卓', '手赚网', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('89', '89', '玩赚星球(原星球联盟)是一款日常上网就可以赚钱的APP，安装填写邀请码&lt;span style=&quot;color:#ff0000;&quot;&gt;&lt;strong&gt;XFE7N34A6&lt;/strong&gt;&lt;/span&gt;就送5元，1元就能提现。使用软件每天都有收益，用浏览器看新闻，查天气，购物等等，邀请好友还能赚更多零花钱哦。&lt;strong&gt;还能种水果，免费快递到家&lt;/strong&gt;。&lt;br /&gt;\n&lt;br /&gt;\n【每天上网持续收益】看新闻、查天气、找软件、省钱购物样样有。&lt;br /&gt;\n【邀请好友奖励多多】6元奖励轻松赚，还有额外收益。&lt;br /&gt;\n【支付宝提现更便捷】1元可提现，快速到账。&lt;br /&gt;\n&lt;br /&gt;\n如果您有任何疑问，可致电400-000-2345联系我们。', '', '1641347764', '1641347764', '14.88 MB', '2.2.1', '安卓', '上海二三四五移动科技有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('90', '90', '趣头条，看资讯赚零花，趣头条狂撒现金红包等你来，&lt;span style=&quot;color:#ff0000;&quot;&gt;&lt;strong&gt;注册送1元，1元就能提现&lt;/strong&gt;&lt;/span&gt;。让你的阅读更具价值，绿色阅读，安全认证，零投入大回报。&lt;br /&gt;\n&lt;br /&gt;\n官方客服咨询，QQ：119640492', '', '1641347764', '1641347764', '2.90 MB', '1.1.5', 'Android 3.3以上', '上海基分文化传播有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('91', '91', '泡泡头条是一款资讯阅读能赚钱的应用，&lt;span style=&quot;color:#ff0000;&quot;&gt;&lt;strong&gt;1元就能提现，秒到账&lt;/strong&gt;&lt;/span&gt;，填写邀请码【&lt;span style=&quot;color:#ff0000;&quot;&gt;&lt;strong&gt;10003366&lt;/strong&gt;&lt;/span&gt;】领新手红包。让您可以利用空闲时间，看资讯赚零花。更可以邀请好友一起看海量资讯，金币翻翻翻。每日更新海量热点内容，社会热点，历史奇闻，人生百态，爆笑段子等，足不出户即可了解社会新闻资讯时尚热点。&lt;br /&gt;\n&lt;br /&gt;\n联系官方&lt;br /&gt;\n客服QQ：2469553515', '', '1641347764', '1641347764', '6.86MB', '2.5.1', '苹果安卓', '杭州牛上科技有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('92', '92', '快转旗下新平台，麒麟网火热推出~ 注册送1元，5元就能提现。11.11万红包瓜分活动进行中，推广期间全天阅读单价0.42元，只要分享点击就有收益，收徒享受18元+50%分享提成，福利多多，快来注册参加吧~&lt;br /&gt;\n&lt;br /&gt;\n客服微信：Yimoshaonian', '', '1641347764', '1641347764', '1.59 MB', '1.2.9', '安卓苹果', '快转', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('93', '93', '抖音极速版，刷抖音、看视频赚钱的软件，&lt;span style=&quot;color:#ff0000;&quot;&gt;登陆填邀请码&lt;strong style=&quot;font-size:18px&quot;&gt;87590235&lt;/strong&gt;&lt;strong&gt;送2元&lt;/strong&gt;&lt;/span&gt;，0.3元提现秒到！看视频刷抖音赚金币自动兑换现金红包，天天0.3元就能提现，秒到账。', '', '1641347764', '1641347764', '13.1 MB', '1.8.0', '安卓', '北京微播视界科技有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('94', '94', '彩蛋视频，是一款躺着也能领奖励的短视频APP。&lt;span style=&quot;color:#ff0000;&quot;&gt;&lt;strong&gt;登陆即送1元，0.3元起提现秒到账&lt;/strong&gt;&lt;/span&gt;。在彩蛋视频你不仅可以看到有趣、好玩、好笑的短视频，还有多种趣味儿玩法，一起玩一起赚，生活从此充满乐趣~&lt;br /&gt;\n&lt;br /&gt;\n联系我们&lt;br /&gt;\n&lt;div&gt;\n	客服电话：18116096506，客服QQ：3105824758', '', '1641347764', '1641347764', '8.86 MB', '1.0.4', '安卓', '湖北青螺信息科技有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('95', '95', '&lt;div&gt;\n	贝壳转是一个微信转发赚钱平台，登陆就送3毛，转发文章被 阅读一次奖励3毛2，5元起提现。用户可通过转发产品内文章到微信群/朋友圈，微信用户点击文章，分享者即获取现金奖励，现金可以通过提现到微信。大家快快加入吧！ 添加客服公众号可以优先提现审核哦&lt;br /&gt;\n	&lt;br /&gt;\n	首码，爆力涨钱【贝壳转】最新0投资项目，转发文章就能赚钱，别人点击一次你得0.32元，一千人点击你就赚320元，遇到一篇热门文章点击量轻松过万，秒赚几千！推广收徒永久拿50%提成奖励，一级30%，二级20%，收入上不封顶！&amp;nbsp;', '', '1641347764', '1641347764', '16.25 MB', '1.0.1', '安卓苹果', '颐家计算机科技有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('96', '96', '蚂蚁看点，让你的阅读更具价值，&lt;font color=&quot;#ff0000&quot;&gt;10元就能提现&lt;/font&gt;！摆脱传统阅读模式，边阅读边赚钱，让你的阅读更具价值。满一元即可提现，当天提现当天到账，每日可赚上百元，有时候赚钱就是这么简单，北京立达方胜旗下。', '', '1641347764', '1641347764', '7.68MB', '1.2', '苹果和安卓手机', '北京立达方胜信息技术有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('97', '97', '闪电盒子是一款既可以看新闻看视频赚钱，又可以方便的使用各种应用的app，而且在闪电盒子中看新闻或使用应用都可以领到红包，让大家玩手机就可以赚钱。&lt;span style=&quot;color:#ff0000;&quot;&gt;&lt;strong&gt;注册填写红包口令&lt;span style=&quot;font-size:18px;&quot;&gt;8370280621&lt;/span&gt;送1元&lt;/strong&gt;&lt;/span&gt;，&lt;span style=&quot;color:#009966;&quot;&gt;&lt;strong&gt;提现秒到账&lt;/strong&gt;&lt;/span&gt;。&lt;br /&gt;\n&lt;br /&gt;\n闪电盒子怎么赚钱？&lt;br /&gt;\n1、首页左上角可以分时段的拆红包获得闪电币，无上限。&lt;br /&gt;\n2、可完成任务获得现金及闪电币。&lt;br /&gt;\n3、徒弟完成日常红包任务师傅将可获得徒弟进贡的闪电币除以上方式，收徒是最快收益最大的挣钱方式，每收1个徒弟，都可以获得5元现金奖励，且徒弟会给您进贡大量的闪电币。', '', '1641347764', '1641347764', '8.03MB', '3.0.8', '安卓手机', '北京流体网络科技有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('98', '98', '天天快报（已改名看点快报）是腾讯旗下的一款阅读新闻即可赚取现金红包的软件，&lt;span style=&quot;color:#ff0000;&quot;&gt;&lt;strong&gt;注册即送现金红包&lt;/strong&gt;&lt;/span&gt;，&lt;span style=&quot;color:#009933;&quot;&gt;&lt;strong&gt;1元即可提现秒到账&lt;/strong&gt;&lt;/span&gt;，&lt;span style=&quot;color:#ff0000;&quot;&gt;&lt;strong&gt;邀请码&lt;span style=&quot;font-size:18px;&quot;&gt;8458US&lt;/span&gt;&lt;/strong&gt;&lt;/span&gt;。大平台，安全靠谱，你每天只需要通过签到、阅读文章、观看视频等任务，就可以获得金币奖励，金币可以兑换现金红包哦！&lt;br /&gt;\n&lt;br /&gt;\n天天快报-腾讯看点兴趣阅读平台，快报在手，热点都有；趣闻头条，让你有天可聊。天天快报，是腾讯倾力打造的一款兴趣阅读软件。&lt;br /&gt;\n网罗了国内外热点头条、明星八卦、精彩直播、体育赛事，福利美图、养生知识、减肥宝典&amp;hellip;&amp;hellip;&lt;br /&gt;\n强大的数据分析后台，从海量资讯中找到你钟意的内容，为您的兴趣而生--让您更加享受阅读的乐趣，畅享高效的移动阅读平台。&lt;br /&gt;\n&lt;br /&gt;\n【品质保证】&lt;br /&gt;\n一周7天，一天24小时，滚动更新，让您及时获取国内外热点新闻资讯。&lt;br /&gt;\n【智能推荐】&lt;br /&gt;\n大数据平台，智能分析，给您提供私人定制的阅读看点。我们有一群技术宅，致力于通过您的每1次点击，每1次分享，算出您的兴趣所在。&lt;br /&gt;\n【清新界面】&lt;br /&gt;\n界面简洁，排版精美，化繁为简。智能搜索，热点推荐，娱乐新闻，分类一目了然。&lt;br /&gt;\n【丰富频道】&lt;br /&gt;\n热点、社会、财经、军事、视频直播&amp;hellip;我们有精细全面的频道分类，可自定义新闻模块，更有专属明星频道等你来约！&lt;br /&gt;\n【本地新闻】&lt;br /&gt;\n定位本地城市后，可收到本地重要资讯。也可添加关注北京、上海、广州等一线城市，让您走在时代前沿。&lt;br /&gt;\n&lt;br /&gt;\n虽未谋面，愿能懂你。&lt;br /&gt;\n更多精彩，等你体验。如果有任何的问题，请联系我们！&lt;br /&gt;\n&lt;br /&gt;\n天天快报用户QQ群：514621008&lt;br /&gt;\n腾讯媒体开放平台QQ群：298833261', '', '1641347764', '1641347764', '9.72MB', '1.6.1', '不限', '腾讯科技(上海)有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('99', '99', '资讯随享，实力公司老平台旗下，登陆送1元，3元就能提现，文章每次点击3毛钱。没有套路，全是真的！在家躺着赚，阅读3毛起，还有定时红包！邀请一个好友18元，还可组团玩，享万元收徒！ 看新闻也能赚钱！邀请一个好友18元，秒提现！还有定时红包，独享万元收徒！', '', '1641347764', '1641347764', '5.09 MB', '1.0.1', '安卓', '', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('100', '100', '&lt;div&gt;\n	史上最强任务平台99阅读上线啦，新用户登录平台赠送你5000积分，即5毛，免费领任务赚钱的平台&amp;lt;99阅读&amp;gt;上线了！99阅读任务多，奖励高，文章读六秒即算完成，所有任务都是免费领取！赚够积分随时提现，提现一元、五元，0门槛，秒到账！', '', '1641347764', '1641347764', '3.49 MB', '1.0.3', '安卓', '豆赚旗下', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('101', '101', '有钻石是2020年有银子旗下全新平台，注册就送1元，2元就能提现，转发被阅读每次3毛1，高单价涨分猛，支持2级徒弟分成。每天每天即可提现一次，无手续费，到账速度快。', '', '1641347764', '1641347764', '13.52 MB', '0.4.0', '安卓苹果', '有银子旗下', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('102', '102', '66看看是微信端的阅读赚钱和微任务平台，在享受阅读快乐的同时还可以赚取收益，10元提现，秒到账。66看看是北京足球头条信息技术有限公司推出的阅读平台，点击开始阅读按钮，系统会自动分配阅读文章，阅读6秒以上的才可以赚取收益点击返回，继续阅读其它文章，可以将获得的收益充值话费或者提现到支付宝账户。', '', '1641347764', '1641347764', '0MB', '1.1.2', '不限', '北京足球头条信息技术有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('103', '103', '星球联盟是一款日常上网就可以赚钱的APP，安装填写邀请码XFE7N34A6就送5元，1元就能提现。使用软件每天都有收益，用浏览器看新闻，查天气，购物等等，邀请好友还能赚更多零花钱哦。&lt;br /&gt;\n&lt;br /&gt;\n【每天上网持续收益】看新闻、查天气、找软件、省钱购物样样有。&lt;br /&gt;\n【邀请好友奖励多多】6元奖励轻松赚，还有额外收益。&lt;br /&gt;\n【支付宝提现更便捷】1元可提现，快速到账。&lt;br /&gt;\n&lt;br /&gt;\n如果您有任何疑问，可致电400-000-2345联系我们。', '', '1641347764', '1641347764', '14.13 MB', '2.5.7', '安卓', '上海二三四五移动科技有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('104', '104', '趣看点，看资讯头条，领红包，丰厚现金奖励等你来赚！&lt;span style=&quot;color:#ff0000;&quot;&gt;&lt;strong&gt;注册填邀请码&lt;/strong&gt;&lt;span style=&quot;font-size:16px;&quot;&gt;&lt;strong&gt;10090&lt;/strong&gt;&lt;/span&gt;&lt;strong&gt;送红包，1元就能提现&lt;/strong&gt;&lt;/span&gt;。看新闻，看资讯，读快报，还能轻松赚零花钱，微信小额提现秒到账，阅读红包领不完。&lt;br /&gt;\n&lt;br /&gt;\n联系我们：&lt;br /&gt;\n客服微信：qkdqzd&lt;br /&gt;\n客服qq：2780261750&lt;br /&gt;\n官方QQ群：590945623&lt;br /&gt;\n手赚网微信：yuri-le，QQ：联系右侧客服', '', '1641347764', '1641347764', '6.8MB', '1.0.1', '不限', '厦门指掌天下文化传媒', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('105', '105', '红果小说，提供正版免费小说，&lt;strong&gt;看小说还有金币福利，金币能兑换现金，&lt;span style=&quot;color:#ff0000;&quot;&gt;登陆就送1元，1元提现秒到&lt;/span&gt;。什么，看书还能挣钱？&lt;/strong&gt;签到福利，金币福利，阅读福利&amp;hellip;&amp;hellip;各种福利应有尽有，随时提现，只要你每天常来读！&lt;br /&gt;\n&lt;br /&gt;\n免费小说，尽在红果！我们提供正版免费小说，还有金币福利。什么，看书还能挣钱？&lt;br /&gt;\n【正版免费】&lt;br /&gt;\n正版小说，免费阅读。热门分类，都市爽文、言情穿越、玄幻修仙、武侠世界&amp;hellip;&amp;hellip;你想看的这里都有。&lt;br /&gt;\n【兴趣推荐】&lt;br /&gt;\n根据你的阅读爱好，个性化推荐，优质书单，书城精细化推荐，总有一款打动你！&lt;br /&gt;\n【活动福利】&lt;br /&gt;\n签到福利，金币福利，阅读福利&amp;hellip;&amp;hellip;各种福利应有尽有，随时提现，只要你每天常来读！&lt;br /&gt;\n【听书畅读】&lt;br /&gt;\n这里每一本书都能听，让你阅读的时候，眼睛也能随时休息一下。', '', '1641347764', '1641347764', '11.12 MB', '2.1.1', '安卓苹果', '北京臻鼎科技有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('106', '106', '满堂福是抢先赚旗下又一转发平台，注册送5毛，首次3元提现之后10元起提现，文章阅读单价3毛。每天打款两次，提现基本当天到账，还有签到红包，持续越久，红包越大。此外，抢先赚旗下还有个来丰收的平台。&lt;br /&gt;\n&lt;br /&gt;\n满堂福官方客服QQ群：710850612', '', '1641347764', '1641347764', '6.34 MB', '1.6.1', '安卓', '北京微转科技有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('107', '107', '火山小视频极速版，看视频拍视频能赚钱的软件。新用户&lt;span style=&quot;color:#ff0000;&quot;&gt;&lt;strong&gt;注册就送1元现金红包&lt;/strong&gt;&lt;/span&gt;，&lt;span style=&quot;color:#ff0000;&quot;&gt;&lt;strong&gt;输入邀请码【&lt;span style=&quot;font-size:16px;&quot;&gt;WVW8GXEM2J&lt;/span&gt;】再送2元现金红包&lt;/strong&gt;&lt;/span&gt;，1元即可提现，秒到账。每天看视频、签到等做任务即可赚金币，金币次日自动兑换成现金，可直接提现。', '', '1641347764', '1641347764', '11.96 MB', '5.0.1', '苹果安卓', '北京微播视界科技有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('108', '108', '番茄小说是一款主打正版、免费的小说阅读器，注册就送2元，1元提现秒到账，让你看小说看书不花钱还能赚钱，悠享阅读时光。&lt;br /&gt;\n&lt;br /&gt;\n【海量正版小说】&lt;br /&gt;\n海量正版小说免费看，现代言情、古代言情、青春校园、同人小说、唯美纯爱、现代都市、异世玄幻、武侠世界、历史穿越、军事战争、悬疑灵异、科幻末世、游戏电竞&amp;hellip;&amp;hellip;你想看的这里都有！&lt;br /&gt;\n【男女频道】&lt;br /&gt;\n特色频道划分，打造男生、女生专属的阅读空间。&lt;br /&gt;\n【私人订制】&lt;br /&gt;\n选择阅读偏好，发现属于你的私人订制小说。&lt;br /&gt;\n【阅读体验】&lt;br /&gt;\n精心选图、匠心排版，给你精品的阅读体验！', '', '1641347764', '1641347764', '9.26 MB', '1.3.2', '苹果安卓', '北京阅读无限文化传媒有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('109', '109', '&lt;div&gt;\n	奇迹小说是一款正版免费小说阅读软件，看小说听书能挣钱，登陆就送1元，1元起提现秒到账。致力于为您【免费】呈现：多品类原创小说、超高人气大神级小说、火爆话题小说、影视原著等10万余册的文学内容！分享好故事，免费读不停！&amp;nbsp;', '', '1641347764', '1641347764', '23.17 MB', '2.2.71', '安卓苹果', '北京光忆世代网络科技有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('110', '110', '免费听书，还可赚现金！5.3亿人都在用的APP，喜马拉雅极速版，更省流量更流畅，注册送1元，1元提现秒到（每次提现5毛手续费）。听节目、邀好友都能赚现金。听得越多，赚得越多，提现秒到账，邀请好友一起来听更有大额现金奖励。&lt;br /&gt;\n&lt;br /&gt;\n全场免费听，海量完本小说，悬疑、盗墓、言情、穿越...应有仅有，戴上耳机，感受声临其境般的全新&amp;ldquo;阅读&amp;rdquo;体验！&amp;nbsp;客服QQ群：745138036&lt;br /&gt;\n&lt;br /&gt;\n【6亿人都在听】&lt;br /&gt;\n「有声小说」全场免费听，海量完本，悬疑、盗墓、言情、穿越...应有仅有&lt;br /&gt;\n「相声段子」下班路上，听段郭德纲经典作品，忘掉一天的疲惫&lt;br /&gt;\n「儿童故事」宝宝哭闹不睡觉？没有播一段睡前故事解决不了的，如果有，那就两段&lt;br /&gt;\n「每日新闻」上班路上，边听新闻边玩儿手机，轻松知晓热点事件&lt;br /&gt;\n「情感治愈」心情低落？来段正能量暖心节目，瞬间治愈&lt;br /&gt;\n「健康养生」养生之道，我们知道，每天听一段，告别亚健康&lt;br /&gt;\n还有更多精彩频道哦...&lt;br /&gt;\n&lt;br /&gt;\n【省流量，畅快听】&lt;br /&gt;\n包体小，省内存，不卡顿，速度快&lt;br /&gt;\n音频优化黑科技，极度省流量&lt;br /&gt;\n&lt;br /&gt;\n【多听多赚，秒提现】&lt;br /&gt;\n「听节目赚」每听1分钟都可兑金币，金币可兑现金&lt;br /&gt;\n「邀好友赚」邀请好友，秒赚大额红包&lt;br /&gt;\n「玩游戏赚」休闲魔性小游戏，边听边玩赚金币&lt;br /&gt;\n&lt;br /&gt;\n【听友好评】&lt;br /&gt;\n@小猫锅：妈耶，还真的能领钱，喜马拉雅诚不我欺。赞赞赞&lt;br /&gt;\n@三豆芽：以前总失眠，自从下载这个app之后，别说，确实有效果，现在半小时没听完就能睡着，越听越上瘾。&lt;br /&gt;\n@教书先生：儿子让我下载了这个喜马拉雅，丰富了我的退休生活，对我们老年人来说，眼睛不好使了，能有个专门听相声评书的软件还真不错。&amp;lt;', '', '1641347764', '1641347764', '9.92 M', '1.3.3', '安卓', '喜马拉雅网络科技有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('111', '111', '魔视，一款看视频、分享视频也能赚钱的短视频APP。登陆填写邀请码&lt;span style=&quot;color: rgb(255, 0, 0);&quot;&gt;&lt;strong&gt;106195&lt;/strong&gt;&lt;/span&gt;就送3毛，可拿更多奖励，可立即提现秒到账。这里不仅有有趣好玩的短视频还有多种趣味玩法，让你在娱乐中还能收获零花钱。赚钱休闲两不误，用心为你推荐有魔力的视频，还有更多精彩活动等你参与！&lt;br /&gt;\n&lt;br /&gt;\n联系官方&lt;br /&gt;\n官方QQ群：579849990，微信客服：xiaotangyuan4568', '', '1641347764', '1641347764', '22.78 MB', '1.0.0.1', '安卓', '上海诗芮电子商务有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('112', '112', '大五福是老平台抢先收旗下最新给力平台，注册送1元，每天有5个小时阅读单价高达6毛，其他时间3毛2每日阅读，永久5元起提现。诚信靠谱涨分快，分享每日热点，好看又赚零钱。还可以自己上传文章，更好的吸引点击阅读。&lt;br /&gt;\r\n&lt;br /&gt;\r\n签到红包&lt;br /&gt;\r\n连续每日签到越久，红包越大，当天分享阅读收入满3元的，可领当天的签到红包，红包金额，连续签到7天，阶梯提升，7天一个轮回。&lt;br /&gt;\r\n&lt;br /&gt;\r\n提现到账&lt;br /&gt;\r\n提现到账时间当天9点-12点提现的，当天下午3点左右到账，当天下午12点-15点提现，当天下午18点左右到账，当天下午15点以后提现，第二天中午12点左右到账。节假日照常打款。&lt;br /&gt;\r\n&lt;br /&gt;\r\n&lt;div&gt;\r\n	平台特点&lt;br /&gt;\r\n	1、&amp;nbsp; 每天有5小时单价高至6毛（平时高单价3毛2）&lt;/div&gt;\r\n', '', '1641347764', '1641347764', '5.69 MB', '2.1.1', '安卓苹果', '抢先收旗下', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('113', '113', '中青看点是一款看新闻、涨知识还能赚零钱的APP，填写邀请码&lt;strong style=&quot;color:#FF0000&quot;&gt;35612&lt;/strong&gt;注册送1元（可直接提现 秒到）。由中国青年网潜心打造，这里有新鲜的资讯信息，涨知识的实用资讯，犀利的评论互动，丰富的任务赢礼品，来这里让您的阅读更有价值。', '', '1641347764', '1641347764', '18.52 MB', '1.0.1', '不限', '中青网新媒体科技(北京)有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('114', '114', '趣看天下是一款自阅+看新闻赚钱的软件，&lt;span style=&quot;color:#ff0000;&quot;&gt;&lt;strong&gt;注册即送1元&lt;/strong&gt;&lt;/span&gt;，完成一次签到与开宝箱和有效阅读一篇文章的新手任务即可&lt;strong&gt;&lt;span style=&quot;color:#ff0000;&quot;&gt;奖励0.5到5元&lt;/span&gt;&lt;/strong&gt;的随机现金红包，&lt;span style=&quot;color:#ff0000;&quot;&gt;&lt;strong&gt;首次满5元提现，之后10元起提现&lt;/strong&gt;&lt;/span&gt;。趣看天下支持阅读资讯和分享资讯&lt;span style=&quot;color:#ff0000;&quot;&gt;&lt;strong&gt;双重金币奖励&lt;/strong&gt;&lt;/span&gt;。', '', '1641347764', '1641347764', '6.81MB', '1.1.3', '不限', '趣增信息科技（上海）有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('115', '115', '抢先收（原抢先赚），转发文章赚钱平台（业界良心），文章分享到微信或朋友圈被阅读一次就赚1-2毛不等，每天轻松赚零花钱。首次5元提现，后续10元起提现，填写邀请码&lt;span style=&quot;color:#ff0000;&quot;&gt;&lt;strong&gt;A10320391&lt;/strong&gt;&lt;/span&gt;领新手红包。&lt;br /&gt;\n&lt;br /&gt;\n抢先在客服QQ群：967706012', '', '1641347764', '1641347764', '5.60 MB', '2.0.1', '安卓', '北京微转科技有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('116', '116', '抢先收旗下大平台&amp;mdash;&amp;mdash;《金刚涨》，&lt;span style=&quot;color:#ff0000;&quot;&gt;&lt;strong&gt;注册就送2元，5元即可提现，点击阅读3毛每次&lt;/strong&gt;&lt;/span&gt;，还有限时高单价&amp;ldquo;5毛&amp;rdquo;，涨分嗖嗖的。贺岁杯收徒大赛瓜分&amp;ldquo;18万元&amp;rdquo;大奖，参加活动0门槛，一个徒弟也能参与瓜分，除正常收徒奖金16～21元，再瓜分18万，保底&amp;ldquo;6.18元&amp;rdquo;。&lt;br /&gt;\n&lt;br /&gt;\n活动期间，收个徒弟就有几十块钱拿 ，还有徒弟徒孙分成～活动多多，奖励多多，快来一起赚钱吧！&lt;br /&gt;\n&lt;br /&gt;\n客服QQ群：912455932，客服QQ3021027739、3365143688', '', '1641347764', '1641347764', '5.62 MB', '1.6.1', '安卓苹果', '抢先收', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('117', '117', '&lt;div&gt;\n	快音，听歌还能得现金哦！登陆快音APP&lt;strong&gt;填写邀请码&lt;span style=&quot;color:#ff0000;&quot;&gt;PP2R6P&lt;/span&gt;就送0.3元现金+300金币，0.3元可立即提现&lt;/strong&gt;，真正的一款听歌赚钱的软件！&amp;nbsp;热门，海量，个性的手机铃声，分离抖音、快手神曲，短视频，音乐。快速制作铃声，自嗨原创音乐轻松上传，一键设置铃声！铃声分享与友同享！', '', '1641347764', '1641347764', '10.65 MB', '1.3.4', '安卓', '成都开心音符科技有限公司', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('118', '118', '【水果联盟】年后首推新平台：西柚资讯，上线期间阅读单价0.5元，登陆送1元，5元起提现，收徒18元+30%提成， 更有20.20万收徒奖励等你来领~&lt;br /&gt;\n&lt;br /&gt;\n客服微信：Juan2222hai', '', '1641347764', '1641347764', '1.88 MB', '1.3.7', '安卓苹果', '水果联盟', '5', '3256', '', '');
INSERT INTO `ey_images_content` VALUES ('119', '119', '&lt;div&gt;\n	大六顺，抢先收、金刚涨旗下&amp;mdash;&amp;mdash;隆重推出强力新平台，涨分更给力，门槛还更低，若需要邀请码填写&lt;span style=&quot;color:#ff0000;&quot;&gt;&lt;strong&gt;A10302678&lt;/strong&gt;&lt;/span&gt;，注册登陆就送5毛，永久5元提现。&lt;br /&gt;\n	&amp;nbsp;', '', '1641347764', '1641347764', '6.01 MB', '1.3.1', '安卓苹果', '抢先收旗下', '5', '3256', '', '');

-- -----------------------------
-- Table structure for `ey_images_upload`
-- -----------------------------
DROP TABLE IF EXISTS `ey_images_upload`;
CREATE TABLE `ey_images_upload` (
  `img_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `aid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '图集ID',
  `title` varchar(200) DEFAULT '' COMMENT '产品标题',
  `image_url` varchar(255) DEFAULT '' COMMENT '文件存储路径',
  `intro` varchar(2000) DEFAULT '' COMMENT '图集描述',
  `width` int(11) DEFAULT '0' COMMENT '图片宽度',
  `height` int(11) DEFAULT '0' COMMENT '图片高度',
  `filesize` mediumint(8) unsigned DEFAULT '0' COMMENT '文件大小',
  `mime` varchar(50) DEFAULT '' COMMENT '图片类型',
  `sort_order` smallint(5) DEFAULT '0' COMMENT '排序',
  `add_time` int(10) unsigned DEFAULT '0' COMMENT '上传时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`img_id`),
  KEY `arcid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=605 DEFAULT CHARSET=utf8 COMMENT='图集图片表';

-- -----------------------------
-- Records of `ey_images_upload`
-- -----------------------------
INSERT INTO `ey_images_upload` VALUES ('1', '1', '小桔试玩', '/uploads/allimg/c200314/15T15040E5460-62611.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('2', '1', '小桔试玩', '/uploads/allimg/c200314/15T15040GWP-K514.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('3', '1', '小桔试玩', '/uploads/allimg/c200314/15T15040JH20-VN1.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('4', '1', '小桔试玩', '/uploads/allimg/c200314/15T15040N610-95L9.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('547', '2', '小啄赚钱', '/uploads/allimg/c200314/15T15041152030-14ZT.jpg', '图 4', '300', '533', '36564', 'image/jpeg', '4', '1684314021', '0');
INSERT INTO `ey_images_upload` VALUES ('548', '2', '小啄赚钱', '/uploads/allimg/c200314/15T150411W2P-151c7.jpg', '图 5', '300', '533', '28741', 'image/jpeg', '5', '1684314021', '0');
INSERT INTO `ey_images_upload` VALUES ('545', '2', '小啄赚钱', '/uploads/allimg/c200314/15T1504105VZ-123K4.jpg', '图 2', '300', '533', '34397', 'image/jpeg', '2', '1684314021', '0');
INSERT INTO `ey_images_upload` VALUES ('546', '2', '小啄赚钱', '/uploads/allimg/c200314/15T15041115430-136347.jpg', '图 3', '300', '533', '34941', 'image/jpeg', '3', '1684314021', '0');
INSERT INTO `ey_images_upload` VALUES ('542', '3', '金钱豹', '/uploads/allimg/c200314/15T15041350060-1V1V.jpg', '图 2', '300', '533', '52903', 'image/jpeg', '2', '1684310536', '0');
INSERT INTO `ey_images_upload` VALUES ('541', '3', '金钱豹', '/uploads/allimg/c200314/15T1504130X60-1I1b.jpg', '图 1', '300', '533', '26136', 'image/jpeg', '1', '1684310536', '0');
INSERT INTO `ey_images_upload` VALUES ('551', '4', '玩玩赚', '/uploads/allimg/c200314/15T15041E3J0-2361U.jpg', '图 3', '300', '533', '34787', 'image/jpeg', '3', '1684379752', '0');
INSERT INTO `ey_images_upload` VALUES ('550', '4', '玩玩赚', '/uploads/allimg/c200314/15T15041A15P-22SN.jpg', '图 2', '300', '533', '25600', 'image/jpeg', '2', '1684379752', '0');
INSERT INTO `ey_images_upload` VALUES ('549', '4', '玩玩赚', '/uploads/allimg/c200314/15T1504160OF-211Z2.jpg', '图 1', '300', '533', '18275', 'image/jpeg', '1', '1684379752', '0');
INSERT INTO `ey_images_upload` VALUES ('17', '5', '懒虫试玩', '/uploads/allimg/c200314/15T15042034630-14N6.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('18', '5', '懒虫试玩', '/uploads/allimg/c200314/15T15042141H0-243U.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('19', '5', '懒虫试玩', '/uploads/allimg/c200314/15T1504222E20-32608.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('20', '5', '懒虫试玩', '/uploads/allimg/c200314/15T150422V960-4UQ.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('21', '6', '钱咖', '/uploads/allimg/c200314/15T150424341P-E414.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('22', '6', '钱咖', '/uploads/allimg/c200314/15T150425cG0-O246.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('23', '6', '钱咖', '/uploads/allimg/c200314/15T1504262aZ-Q3Z.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('24', '6', '钱咖', '/uploads/allimg/c200314/15T15042A9450-a4b.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('25', '7', '今日赚', '/uploads/allimg/c200314/15T15042X43P-11R27.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('26', '7', '今日赚', '/uploads/allimg/c200314/15T15042924950-1244C.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('27', '7', '今日赚', '/uploads/allimg/c200314/15T15042951T0-131Z0.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('28', '7', '今日赚', '/uploads/allimg/c200314/15T1504300O60-1459C.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('29', '8', '掉钱眼儿', '/uploads/allimg/c200314/15T150431RU0-1BS1.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('30', '8', '掉钱眼儿', '/uploads/allimg/c200314/15T15043409250-1K631.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('31', '8', '掉钱眼儿', '/uploads/allimg/c200314/15T15043455L0-1W910.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('32', '8', '掉钱眼儿', '/uploads/allimg/c200314/15T15043531W0-195921.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('33', '9', '多玩红包', '/uploads/allimg/c200314/15T15043D4Q0-215256.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('34', '9', '多玩红包', '/uploads/allimg/c200314/15T15043GB20-225239.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('35', '9', '多玩红包', '/uploads/allimg/c200314/15T15043JB0-2341A.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('36', '9', '多玩红包', '/uploads/allimg/c200314/15T15043P4340-2434Y.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('37', '10', '金手指', '/uploads/allimg/c200314/15T1503241W60-15958.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('38', '10', '金手指', '/uploads/allimg/c200314/15T15032453Y0-25P9.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('39', '10', '金手指', '/uploads/allimg/c200314/15T15032491040-3U26.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('40', '10', '金手指', '/uploads/allimg/c200314/15T15032529540-49413.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('572', '11', '钱派试玩', '/uploads/allimg/c200314/15T15032J4E0-a0E.jpg', '图 4', '300', '533', '22448', 'image/jpeg', '4', '1684467759', '0');
INSERT INTO `ey_images_upload` VALUES ('571', '11', '钱派试玩', '/uploads/allimg/c200314/15T15032GG10-S135.jpg', '图 3', '300', '533', '25374', 'image/jpeg', '3', '1684467759', '0');
INSERT INTO `ey_images_upload` VALUES ('570', '11', '钱派试玩', '/uploads/allimg/c200314/15T15032D41Z-N959.jpg', '图 2', '300', '533', '24990', 'image/jpeg', '2', '1684467759', '0');
INSERT INTO `ey_images_upload` VALUES ('574', '12', '柚子试玩', '/uploads/allimg/c200314/15T15033023340-1210V.jpg', '图 2', '300', '533', '15874', 'image/jpeg', '2', '1684467782', '0');
INSERT INTO `ey_images_upload` VALUES ('575', '12', '柚子试玩', '/uploads/allimg/c200314/15T15033053520-13NH.jpg', '图 3', '300', '533', '19007', 'image/jpeg', '3', '1684467782', '0');
INSERT INTO `ey_images_upload` VALUES ('578', '13', '量次元', '/uploads/allimg/c200314/15T1503320R10-1OU1.jpg', '图 2', '300', '533', '14940', 'image/jpeg', '2', '1684467788', '0');
INSERT INTO `ey_images_upload` VALUES ('579', '13', '量次元', '/uploads/allimg/c200314/15T15033236160-1UE5.jpg', '图 3', '300', '533', '19274', 'image/jpeg', '3', '1684467788', '0');
INSERT INTO `ey_images_upload` VALUES ('582', '14', '赚钱吧', '/uploads/allimg/c200314/15T15033422S0-22X02.jpg', '图 2', '300', '533', '24855', 'image/jpeg', '2', '1684467795', '0');
INSERT INTO `ey_images_upload` VALUES ('583', '14', '赚钱吧', '/uploads/allimg/c200314/15T150334C150-23NQ.jpg', '图 3', '300', '533', '35004', 'image/jpeg', '3', '1684467795', '0');
INSERT INTO `ey_images_upload` VALUES ('586', '15', '巨宝朋', '/uploads/allimg/c200314/15T15033941060-29416.jpg', '图 2', '300', '533', '37997', 'image/jpeg', '2', '1684467801', '0');
INSERT INTO `ey_images_upload` VALUES ('587', '15', '巨宝朋', '/uploads/allimg/c200314/15T15034002a0-32445.jpg', '图 3', '300', '533', '34280', 'image/jpeg', '3', '1684467801', '0');
INSERT INTO `ey_images_upload` VALUES ('590', '16', '头号试玩', '/uploads/allimg/c200314/15T150342Z540-NH6.jpg', '图 2', '300', '533', '23786', 'image/jpeg', '2', '1684467806', '0');
INSERT INTO `ey_images_upload` VALUES ('591', '16', '头号试玩', '/uploads/allimg/c200314/15T15034342350-W1I.jpg', '图 3', '300', '533', '27576', 'image/jpeg', '3', '1684467806', '0');
INSERT INTO `ey_images_upload` VALUES ('594', '17', '试玩赚钱入口', '/uploads/allimg/c200314/15T1503543M20-125528.jpg', '图 2', '300', '600', '35343', 'image/jpeg', '2', '1684467816', '0');
INSERT INTO `ey_images_upload` VALUES ('595', '17', '试玩赚钱入口', '/uploads/allimg/c200314/15T150354T420-13B58.jpg', '图 3', '300', '600', '31922', 'image/jpeg', '3', '1684467816', '0');
INSERT INTO `ey_images_upload` VALUES ('598', '18', '小涵兼职', '/uploads/allimg/c200314/15T15035M5910-1O120.jpg', '图 2', '300', '533', '24129', 'image/jpeg', '2', '1684467823', '0');
INSERT INTO `ey_images_upload` VALUES ('599', '18', '小涵兼职', '/uploads/allimg/c200314/15T15035Q4Q0-1R130.jpg', '图 3', '300', '533', '31746', 'image/jpeg', '3', '1684467823', '0');
INSERT INTO `ey_images_upload` VALUES ('567', '19', '火箭试玩', '/uploads/allimg/c200314/15T150362P030-23Z60.jpg', '图 3', '300', '533', '29946', 'image/jpeg', '3', '1684397375', '0');
INSERT INTO `ey_images_upload` VALUES ('566', '19', '火箭试玩', '/uploads/allimg/c200314/15T15036195110-226013.jpg', '图 2', '300', '533', '29292', 'image/jpeg', '2', '1684397375', '0');
INSERT INTO `ey_images_upload` VALUES ('565', '19', '火箭试玩', '/uploads/allimg/c200314/15T15036045320-215O1.jpg', '图 1', '300', '533', '19009', 'image/jpeg', '1', '1684397375', '0');
INSERT INTO `ey_images_upload` VALUES ('563', '20', 'iMoney爱盈利', '/uploads/allimg/c200314/15T1503C32520-3BU.jpg', '图 3', '300', '533', '33389', 'image/jpeg', '3', '1684397352', '0');
INSERT INTO `ey_images_upload` VALUES ('562', '20', 'iMoney爱盈利', '/uploads/allimg/c200314/15T1503B62P-2EA.jpg', '图 2', '300', '533', '44444', 'image/jpeg', '2', '1684397352', '0');
INSERT INTO `ey_images_upload` VALUES ('561', '20', 'iMoney爱盈利', '/uploads/allimg/c200314/15T1503AV110-1NQ.jpg', '图 1', '300', '533', '37054', 'image/jpeg', '1', '1684397352', '0');
INSERT INTO `ey_images_upload` VALUES ('558', '21', '来赚', '/uploads/allimg/c200314/15T1503E50I0-N346.jpg', '图 2', '480', '852', '60093', 'image/jpeg', '2', '1684397324', '0');
INSERT INTO `ey_images_upload` VALUES ('559', '21', '来赚', '/uploads/allimg/c200314/15T1503F535Z-Y5c.jpg', '图 3', '480', '852', '43148', 'image/jpeg', '3', '1684397324', '0');
INSERT INTO `ey_images_upload` VALUES ('85', '22', 'i红包', '/uploads/allimg/c200314/15T1503I10T0-112236.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('86', '22', 'i红包', '/uploads/allimg/c200314/15T1503I402P-12F62.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('87', '22', 'i红包', '/uploads/allimg/c200314/15T1503ISQ0-139620.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('88', '22', 'i红包', '/uploads/allimg/c200314/15T1503JW610-1435J.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('89', '23', '天天赚钱', '/uploads/allimg/c200314/15T1503L43950-164910.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('90', '23', '天天赚钱', '/uploads/allimg/c200314/15T1503M55S0-1I002.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('91', '23', '天天赚钱', '/uploads/allimg/c200314/15T1503M95210-1RU8.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('92', '24', '应用试客', '/uploads/allimg/c200314/15T1503O3C20-202434.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('93', '24', '应用试客', '/uploads/allimg/c200314/15T1503P092P-2193I.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('94', '24', '应用试客', '/uploads/allimg/c200314/15T1503PIc0-2215c.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('95', '24', '应用试客', '/uploads/allimg/c200314/15T1503Q01c0-23D94.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('96', '25', '多多红包', '/uploads/allimg/c200314/15T1503S91420-19613.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('97', '25', '多多红包', '/uploads/allimg/c200314/15T1503T22310-22V2.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('98', '25', '多多红包', '/uploads/allimg/c200314/15T1503T59350-3C37.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('99', '25', '多多红包', '/uploads/allimg/c200314/15T1503U1IF-41L8.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('100', '26', '小鱼赚钱', '/uploads/allimg/c200314/15T1503Z620P-63945.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('101', '26', '小鱼赚钱', '/uploads/allimg/c200314/15T15039153130-J042.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('102', '26', '小鱼赚钱', '/uploads/allimg/c200314/15T1503921CF-VP4.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('103', '27', '芒果试玩', '/uploads/allimg/c200314/15T15039402S0-10N11.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('104', '27', '芒果试玩', '/uploads/allimg/c200314/15T1503943540-11B35.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('105', '27', '芒果试玩', '/uploads/allimg/c200314/15T15039454950-121544.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('106', '27', '芒果试玩', '/uploads/allimg/c200314/15T150394cL0-13E32.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('107', '28', '蝉试客', '/uploads/allimg/c200314/15T1503a43450-15A21.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('108', '28', '蝉试客', '/uploads/allimg/c200314/15T1503aG5P-1B132.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('109', '28', '蝉试客', '/uploads/allimg/c200314/15T1503b43V0-1H510.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('110', '28', '蝉试客', '/uploads/allimg/c200314/15T1503bI910-1R2I.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('111', '29', '秒赚试玩', '/uploads/allimg/c200314/15T1504002T30-2062V.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('112', '29', '秒赚试玩', '/uploads/allimg/c200314/15T15040060450-212Y1.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('113', '29', '秒赚试玩', '/uploads/allimg/c200314/15T1504010GZ-224136.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('114', '29', '秒赚试玩', '/uploads/allimg/c200314/15T150401YZ-23a23.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('115', '30', '爱钱试玩', '/uploads/allimg/c200314/15T15040450150-195E.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('116', '30', '爱钱试玩', '/uploads/allimg/c200314/15T150404ZN0-221C.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('117', '30', '爱钱试玩', '/uploads/allimg/c200314/15T1504052N30-31C7.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('118', '30', '爱钱试玩', '/uploads/allimg/c200314/15T15040564310-4BQ.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('119', '31', '知聊', '/uploads/allimg/c200314/15T150U232330-1IA4.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('120', '31', '知聊', '/uploads/allimg/c200314/15T150U260440-1T1L.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('121', '31', '知聊', '/uploads/allimg/c200314/15T150U2WL0-192941.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('122', '31', '知聊', '/uploads/allimg/c200314/15T150U314230-205115.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('123', '32', '恐龙多多', '/uploads/allimg/c200314/15T150Q3b560-AN7.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('124', '32', '恐龙多多', '/uploads/allimg/c200314/15T150Q443H0-K913.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('125', '32', '恐龙多多', '/uploads/allimg/c200314/15T150Q52Z30-XO4.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('126', '32', '恐龙多多', '/uploads/allimg/c200314/15T150Q62PZ-932I.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('127', '33', '玩洽', '/uploads/allimg/c200314/15T150QY9A0-111605.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('128', '33', '玩洽', '/uploads/allimg/c200314/15T150Qb0B0-12L25.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('129', '33', '玩洽', '/uploads/allimg/c200314/15T150R04Z10-13Y14.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('130', '33', '玩洽', '/uploads/allimg/c200314/15T150R0U320-143L3.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('131', '34', '哇咔搞笑', '/uploads/allimg/c200314/15T150R545K0-1A606.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('132', '34', '哇咔搞笑', '/uploads/allimg/c200314/15T150RD4620-1J2O.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('133', '34', '哇咔搞笑', '/uploads/allimg/c200314/15T150RQ4560-1S034.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('134', '34', '哇咔搞笑', '/uploads/allimg/c200314/15T150S04C20-1b3c.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('135', '35', '众人帮', '/uploads/allimg/c200314/15T150S392350-215635.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('136', '35', '众人帮', '/uploads/allimg/c200314/15T150S4301P-22H58.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('137', '35', '众人帮', '/uploads/allimg/c200314/15T150S492120-23U96.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('138', '35', '众人帮', '/uploads/allimg/c200314/15T150S5O3Z-243406.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('139', '35', '众人帮', '/uploads/allimg/c200314/15T150S62G10-25c28.jpg', '图 5', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('140', '36', '给力赚', '/uploads/allimg/c200314/15T150ST4Q0-15E7.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('141', '36', '给力赚', '/uploads/allimg/c200314/15T150SWXP-211W.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('142', '37', '闲来斗地主赚金版', '/uploads/allimg/c200314/15T150T001920-44123.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('143', '37', '闲来斗地主赚金版', '/uploads/allimg/c200314/15T150T12360-52C2.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('144', '37', '闲来斗地主赚金版', '/uploads/allimg/c200314/15T150T195610-635R.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('145', '37', '闲来斗地主赚金版', '/uploads/allimg/c200314/15T150T250N0-G354.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('146', '38', 'PC蛋蛋', '/uploads/allimg/c200314/15T150T5093Z-91D2.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('147', '38', 'PC蛋蛋', '/uploads/allimg/c200314/15T150T5C230-105F4.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('148', '38', 'PC蛋蛋', '/uploads/allimg/c200314/15T150TF23Z-113I1.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('149', '38', 'PC蛋蛋', '/uploads/allimg/c200314/15T150TM23P-129143.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('150', '39', '闪电接单', '/uploads/allimg/c200314/15T150Ta1I0-14Y64.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('151', '39', '闪电接单', '/uploads/allimg/c200314/15T150U0V260-156136.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('152', '40', '牛帮', '/uploads/allimg/c200314/15T150ETU20-1B93.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('153', '40', '牛帮', '/uploads/allimg/c200314/15T150EY3530-239B.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('154', '40', '牛帮', '/uploads/allimg/c200314/15T150E940560-3B64.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('155', '40', '牛帮', '/uploads/allimg/c200314/15T150F053I0-41222.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('156', '41', '蜂窝帮', '/uploads/allimg/c200314/15T150F501F-C011.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('157', '41', '蜂窝帮', '/uploads/allimg/c200314/15T150F541240-NR2.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('158', '41', '蜂窝帮', '/uploads/allimg/c200314/15T150F601240-T351.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('159', '41', '蜂窝帮', '/uploads/allimg/c200314/15T150F635550-91555.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('160', '42', '钱帮', '/uploads/allimg/c200314/15T150FK2140-11cC.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('161', '42', '钱帮', '/uploads/allimg/c200314/15T150FN1Z-129457.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('162', '42', '钱帮', '/uploads/allimg/c200314/15T150FU5320-135M9.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('163', '42', '钱帮', '/uploads/allimg/c200314/15T150FY210-145630.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('164', '43', '截图宝', '/uploads/allimg/c200314/15T150G0QQ0-1E3B.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('165', '43', '截图宝', '/uploads/allimg/c200314/15T150G139310-1J627.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('166', '43', '截图宝', '/uploads/allimg/c200314/15T150G1L450-1Q195.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('167', '43', '截图宝', '/uploads/allimg/c200314/15T150G2222P-195U1.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('168', '44', '撸猫有财', '/uploads/allimg/c200314/15T150G340220-21G43.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('169', '44', '撸猫有财', '/uploads/allimg/c200314/15T150G3X160-2224F.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('170', '44', '撸猫有财', '/uploads/allimg/c200314/15T150G431440-231428.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('171', '44', '撸猫有财', '/uploads/allimg/c200314/15T150G4W020-245920.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('172', '45', '猫咪小屋', '/uploads/allimg/c200314/15T150GL24F-1b02.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('173', '45', '猫咪小屋', '/uploads/allimg/c200314/15T150GQ4610-22334.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('174', '45', '猫咪小屋', '/uploads/allimg/c200314/15T150GT3350-3MD.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('175', '45', '猫咪小屋', '/uploads/allimg/c200314/15T150G923420-49256.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('176', '45', '猫咪小屋', '/uploads/allimg/c200314/15T150Gb1940-56205.jpg', '图 5', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('177', '45', '猫咪小屋', '/uploads/allimg/c200314/15T150H044K0-62008.jpg', '图 6', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('178', '46', '悬赏猫', '/uploads/allimg/c200314/15T150H3A350-V5N.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('179', '46', '悬赏猫', '/uploads/allimg/c200314/15T150H395260-9B36.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('180', '46', '悬赏猫', '/uploads/allimg/c200314/15T150H43F40-106303.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('181', '46', '悬赏猫', '/uploads/allimg/c200314/15T150H4S110-119404.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('502', '47', '答题夺宝', '/eyou/uploads/allimg/c200314/15T150H9D440-1M227.jpg', '图 5', '0', '0', '0', '', '5', '1641363495', '0');
INSERT INTO `ey_images_upload` VALUES ('501', '47', '答题夺宝', '/eyou/uploads/allimg/c200314/15T150HZ9160-1EK7.jpg', '图 4', '0', '0', '0', '', '4', '1641363495', '0');
INSERT INTO `ey_images_upload` VALUES ('500', '47', '答题夺宝', '/eyou/uploads/allimg/c200314/15T150HU0610-1555U.jpg', '图 3', '0', '0', '0', '', '3', '1641363495', '0');
INSERT INTO `ey_images_upload` VALUES ('499', '47', '答题夺宝', '/eyou/uploads/allimg/c200314/15T150HN4610-14D30.jpg', '图 2', '0', '0', '0', '', '2', '1641363495', '0');
INSERT INTO `ey_images_upload` VALUES ('498', '47', '答题夺宝', '/eyou/uploads/allimg/c200314/15T150HH6440-1320c.jpg', '图 1', '0', '0', '0', '', '1', '1641363495', '0');
INSERT INTO `ey_images_upload` VALUES ('188', '48', '恐龙世界', '/uploads/allimg/c200314/15T150K1C360-203962.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('189', '48', '恐龙世界', '/uploads/allimg/c200314/15T150K1b930-215944.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('190', '48', '恐龙世界', '/uploads/allimg/c200314/15T150K22B0-224115.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('191', '48', '恐龙世界', '/uploads/allimg/c200314/15T150K2642P-2331G.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('192', '48', '恐龙世界', '/uploads/allimg/c200314/15T150K303120-24KJ.jpg', '图 5', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('193', '49', '疯狂猜成语', '/uploads/allimg/c200314/15T150K912540-2B352.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('194', '49', '疯狂猜成语', '/uploads/allimg/c200314/15T150Ka1b0-2I950.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('195', '49', '疯狂猜成语', '/uploads/allimg/c200314/15T150L0T350-2Y1K.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('196', '49', '疯狂猜成语', '/uploads/allimg/c200314/15T150L142350-2aY7.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('197', '49', '疯狂猜成语', '/uploads/allimg/c200314/15T150L1X240-301061.jpg', '图 5', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('198', '50', '哆啦赚', '/uploads/allimg/c200314/15T150L530F-1P52.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('199', '50', '哆啦赚', '/uploads/allimg/c200314/15T150L5I250-23A0.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('200', '50', '哆啦赚', '/uploads/allimg/c200314/15T150L643Y0-3Q96.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('201', '50', '哆啦赚', '/uploads/allimg/c200314/15T150LD3230-41O8.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('202', '51', '码力任务辅助', '/uploads/allimg/c200314/15T150LY2310-B5T.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('203', '51', '码力任务辅助', '/uploads/allimg/c200314/15T150L944b0-OJ4.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('204', '51', '码力任务辅助', '/uploads/allimg/c200314/15T150La4140-YG0.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('205', '51', '码力任务辅助', '/uploads/allimg/c200314/15T150M004630-93155.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('206', '52', 'FZ辅助平台', '/uploads/allimg/c200314/15T150M12NZ-11W94.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('207', '52', 'FZ辅助平台', '/uploads/allimg/c200314/15T150M1H440-124227.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('208', '52', 'FZ辅助平台', '/uploads/allimg/c200314/15T150M211010-1355P.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('209', '52', 'FZ辅助平台', '/uploads/allimg/c200314/15T150M25aP-145962.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('210', '53', '贪吃蛇在线', '/uploads/allimg/c200314/15T150M44020-1EU1.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('211', '53', '贪吃蛇在线', '/uploads/allimg/c200314/15T150M4P30-1GC6.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('212', '53', '贪吃蛇在线', '/uploads/allimg/c200314/15T150M5223F-1XB1.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('213', '53', '贪吃蛇在线', '/uploads/allimg/c200314/15T150M55a20-194942.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('214', '54', '阳光养猪场', '/uploads/allimg/c200314/15T150N0W420-214Z9.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('215', '54', '阳光养猪场', '/uploads/allimg/c200314/15T150N143630-226093.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('216', '54', '阳光养猪场', '/uploads/allimg/c200314/15T150N3563Z-23a07.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('217', '54', '阳光养猪场', '/uploads/allimg/c200314/15T150N4611P-2441E.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('218', '55', '小白赚钱', '/uploads/allimg/c200314/15T150NR5230-121W.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('219', '55', '小白赚钱', '/uploads/allimg/c200314/15T150NV34P-2X64.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('220', '55', '小白赚钱', '/uploads/allimg/c200314/15T150N94cF-36135.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('221', '55', '小白赚钱', '/uploads/allimg/c200314/15T150O010M0-43922.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('222', '56', '趣闲赚', '/uploads/allimg/c200314/15T150O13C30-645B.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('223', '56', '趣闲赚', '/uploads/allimg/c200314/15T150O1OH0-L356.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('224', '56', '趣闲赚', '/uploads/allimg/c200314/15T150O21F50-Y136.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('225', '56', '趣闲赚', '/uploads/allimg/c200314/15T150O25JZ-95P8.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('226', '56', '趣闲赚', '/uploads/allimg/c200314/15T150O331460-109126.jpg', '图 5', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('227', '57', '欢乐招财犬', '/uploads/allimg/c200314/15T150O6222F-12Y47.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('228', '57', '欢乐招财犬', '/uploads/allimg/c200314/15T150OD52P-13M05.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('229', '57', '欢乐招财犬', '/uploads/allimg/c200314/15T150OH1530-14C59.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('230', '57', '欢乐招财犬', '/uploads/allimg/c200314/15T150OJM40-15G02.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('231', '57', '欢乐招财犬', '/uploads/allimg/c200314/15T150OM4D0-162337.jpg', '图 5', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('232', '58', '小龙虾大亨', '/uploads/allimg/c200314/15T150P055R0-1V062.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('233', '58', '小龙虾大亨', '/uploads/allimg/c200314/15T150P0V030-1950b.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('234', '58', '小龙虾大亨', '/uploads/allimg/c200314/15T150P1642F-202637.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('235', '58', '小龙虾大亨', '/uploads/allimg/c200314/15T150P2105Z-211092.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('236', '58', '小龙虾大亨', '/uploads/allimg/c200314/15T150P300460-2210C.jpg', '图 5', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('237', '59', '恐龙有钱', '/uploads/allimg/c200314/15T150P529630-241H9.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('238', '59', '恐龙有钱', '/uploads/allimg/c200314/15T150P5H240-25R32.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('239', '59', '恐龙有钱', '/uploads/allimg/c200314/15T150PC250-2612H.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('240', '59', '恐龙有钱', '/uploads/allimg/c200314/15T150PI4950-2JF3.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('241', '59', '恐龙有钱', '/uploads/allimg/c200314/15T150PLc60-2V939.jpg', '图 5', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('242', '60', '全民养龙', '/uploads/allimg/c200314/15T150Q019310-1N08.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('243', '60', '全民养龙', '/uploads/allimg/c200314/15T150Q04U30-23005.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('244', '60', '全民养龙', '/uploads/allimg/c200314/15T150Q102050-33496.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('245', '60', '全民养龙', '/uploads/allimg/c200314/15T150Q15QP-43519.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('246', '61', '乐米资讯', '/uploads/allimg/c200314/15T1514PF0F-1O55.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('247', '61', '乐米资讯', '/uploads/allimg/c200314/15T1514Pc560-21458.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('248', '61', '乐米资讯', '/uploads/allimg/c200314/15T1514Q54Z-33543.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('249', '61', '乐米资讯', '/uploads/allimg/c200314/15T1514R01060-46429.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('250', '62', '淘金赚', '/uploads/allimg/c200314/15T1514TR360-DW3.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('251', '62', '淘金赚', '/uploads/allimg/c200314/15T1514UJ310-L0U.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('252', '62', '淘金赚', '/uploads/allimg/c200314/15T1514W4U20-X639.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('253', '62', '淘金赚', '/uploads/allimg/c200314/15T1514X15130-94L5.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('254', '63', '猫猫赚', '/uploads/allimg/c200314/15T1514Z1UF-11Z21.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('255', '63', '猫猫赚', '/uploads/allimg/c200314/15T151491621P-123262.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('256', '63', '猫猫赚', '/uploads/allimg/c200314/15T151491Z560-134133.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('257', '63', '猫猫赚', '/uploads/allimg/c200314/15T1514922PP-14SY.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('258', '64', '每天赚点', '/uploads/allimg/c200314/15T15149344H0-1BZ6.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('259', '64', '每天赚点', '/uploads/allimg/c200314/15T15149392120-1N140.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('260', '64', '每天赚点', '/uploads/allimg/c200314/15T15149454N0-1U525.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('261', '64', '每天赚点', '/uploads/allimg/c200314/15T151494ZA0-192420.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('262', '65', '灵猴', '/uploads/allimg/c200314/15T1514964a10-21O30.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('263', '65', '灵猴', '/uploads/allimg/c200314/15T1514a0WP-221491.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('264', '65', '灵猴', '/uploads/allimg/c200314/15T1514a5A10-23P30.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('265', '65', '灵猴', '/uploads/allimg/c200314/15T1514b11Q0-244953.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('266', '66', '小龙赚钱', '/uploads/allimg/c200314/15T15150164B0-13N3.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('267', '66', '小龙赚钱', '/uploads/allimg/c200314/15T1515020M0-2X94.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('268', '66', '小龙赚钱', '/uploads/allimg/c200314/15T151502A560-354I.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('269', '66', '小龙赚钱', '/uploads/allimg/c200314/15T1515031aZ-441Q.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('270', '66', '小龙赚钱', '/uploads/allimg/c200314/15T15150364U0-56010.jpg', '图 5', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('271', '67', '蘑菇乐园', '/uploads/allimg/c200314/15T151504W40-H4N.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('272', '67', '蘑菇乐园', '/uploads/allimg/c200314/15T15150520N0-Y939.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('273', '67', '蘑菇乐园', '/uploads/allimg/c200314/15T15150550460-b3D.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('274', '67', '蘑菇乐园', '/uploads/allimg/c200314/15T15150593440-109B3.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('275', '68', '钱大师安卓版', '/uploads/allimg/c200314/15T15150G2310-12HC.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('276', '68', '钱大师安卓版', '/uploads/allimg/c200314/15T15150J0920-1339C.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('277', '68', '钱大师安卓版', '/uploads/allimg/c200314/15T15150N4S0-1429D.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('278', '68', '钱大师安卓版', '/uploads/allimg/c200314/15T15150Q40P-15A54.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('279', '69', '泡泡赚', '/uploads/allimg/c200314/15T15150c2b0-1N3S.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('280', '69', '泡泡赚', '/uploads/allimg/c200314/15T1515103Q50-1QA2.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('281', '69', '泡泡赚', '/uploads/allimg/c200314/15T151510N020-192120.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('282', '69', '泡泡赚', '/uploads/allimg/c200314/15T15151115H0-20Vc.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('283', '70', '米赚', '/uploads/allimg/c200314/15T15151311320-221Q4.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('284', '70', '米赚', '/uploads/allimg/c200314/15T1515155KP-23O56.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('285', '70', '米赚', '/uploads/allimg/c200314/15T15151KDF-24FA.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('286', '70', '米赚', '/uploads/allimg/c200314/15T1515200P60-259B3.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('287', '71', '蜜蜂试玩安卓版', '/uploads/allimg/c200314/15T1513QD360-11415.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('288', '71', '蜜蜂试玩安卓版', '/uploads/allimg/c200314/15T1513R15E0-23951.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('289', '71', '蜜蜂试玩安卓版', '/uploads/allimg/c200314/15T1513R522P-343R.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('290', '71', '蜜蜂试玩安卓版', '/uploads/allimg/c200314/15T1513RW40-4E35.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('291', '72', 'Q玩小游戏', '/uploads/allimg/c200314/15T1513TJI0-C612.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('292', '72', 'Q玩小游戏', '/uploads/allimg/c200314/15T1513U30520-O237.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('293', '72', 'Q玩小游戏', '/uploads/allimg/c200314/15T1513UX460-TM2.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('294', '72', 'Q玩小游戏', '/uploads/allimg/c200314/15T1513VY230-940G.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('295', '73', '葫芦赚', '/uploads/allimg/c200314/15T1513XE640-11B48.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('296', '73', '葫芦赚', '/uploads/allimg/c200314/15T1513Xc960-129443.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('297', '73', '葫芦赚', '/uploads/allimg/c200314/15T1513Y5UP-135329.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('298', '73', '葫芦赚', '/uploads/allimg/c200314/15T1513Z11W0-141D1.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('299', '74', '手机蹦蹦', '/uploads/allimg/c200314/15T1513920c40-1A632.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('300', '74', '手机蹦蹦', '/uploads/allimg/c200314/15T15139335330-1KI3.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('301', '74', '手机蹦蹦', '/uploads/allimg/c200314/15T151393WE0-1TP5.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('302', '74', '手机蹦蹦', '/uploads/allimg/c200314/15T15139464210-194351.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('303', '74', '手机蹦蹦', '/uploads/allimg/c200314/15T151395K530-20H93.jpg', '图 5', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('304', '75', '聚享游', '/uploads/allimg/c200314/15T15140102H0-2294U.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('305', '75', '聚享游', '/uploads/allimg/c200314/15T15140124220-236428.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('306', '75', '聚享游', '/uploads/allimg/c200314/15T15140151110-244V3.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('307', '75', '聚享游', '/uploads/allimg/c200314/15T15140250330-25cb.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('308', '76', '赚宝', '/uploads/allimg/c200314/15T151404F1P-1Q61.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('309', '76', '赚宝', '/uploads/allimg/c200314/15T151405020Z-23359.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('310', '76', '赚宝', '/uploads/allimg/c200314/15T1514053X20-36102.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('311', '76', '赚宝', '/uploads/allimg/c200314/15T151405V020-4M58.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('312', '77', '零钱试玩', '/uploads/allimg/c200314/15T15140R42F-621Q.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('313', '77', '零钱试玩', '/uploads/allimg/c200314/15T15140W340-HM4.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('314', '77', '零钱试玩', '/uploads/allimg/c200314/15T1514092EF-X646.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('315', '77', '零钱试玩', '/uploads/allimg/c200314/15T151409E440-91347.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('316', '77', '零钱试玩', '/uploads/allimg/c200314/15T15141013520-104E5.jpg', '图 5', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('317', '78', '零用钱', '/uploads/allimg/c200314/15T151411a150-1220W.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('318', '78', '零用钱', '/uploads/allimg/c200314/15T1514125B0-134J6.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('319', '78', '零用钱', '/uploads/allimg/c200314/15T151412R630-14Q12.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('320', '78', '零用钱', '/uploads/allimg/c200314/15T1514130cF-151957.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('321', '79', '赚客安卓版', '/uploads/allimg/c200314/15T15141509140-1K001.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('322', '79', '赚客安卓版', '/uploads/allimg/c200314/15T151415BT0-1RJ2.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('323', '79', '赚客安卓版', '/uploads/allimg/c200314/15T15141624P-1952K.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('324', '79', '赚客安卓版', '/uploads/allimg/c200314/15T15141BRF-206451.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('325', '79', '赚客安卓版', '/uploads/allimg/c200314/15T15141H61Z-21L31.jpg', '图 5', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('326', '80', '蛋咖赚钱', '/uploads/allimg/c200314/15T15141Z00Z-234439.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('327', '80', '蛋咖赚钱', '/uploads/allimg/c200314/15T1514193DP-24W17.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('328', '80', '蛋咖赚钱', '/uploads/allimg/c200314/15T15141a5140-256216.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('329', '80', '蛋咖赚钱', '/uploads/allimg/c200314/15T15142043540-2A402.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('330', '81', '每日赚点', '/uploads/allimg/c200314/15T151422H2P-1R43.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('331', '81', '每日赚点', '/uploads/allimg/c200314/15T1514231I50-29461.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('332', '81', '每日赚点', '/uploads/allimg/c200314/15T15142350620-32Z1.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('333', '81', '每日赚点', '/uploads/allimg/c200314/15T15142409510-491D.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('334', '82', '有赚', '/uploads/allimg/c200314/15T1514264UF-64000.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('335', '82', '有赚', '/uploads/allimg/c200314/15T15142DY30-LJ9.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('336', '82', '有赚', '/uploads/allimg/c200314/15T15142HDP-X495.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('337', '82', '有赚', '/uploads/allimg/c200314/15T15142M9160-a610.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('338', '82', '有赚', '/uploads/allimg/c200314/15T15142P620-101214.jpg', '图 5', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('339', '83', '蛋蛋赚', '/uploads/allimg/c200314/15T15143091260-12IL.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('340', '83', '蛋蛋赚', '/uploads/allimg/c200314/15T151432JD0-1330O.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('341', '83', '蛋蛋赚', '/uploads/allimg/c200314/15T151434bV0-14A15.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('342', '83', '蛋蛋赚', '/uploads/allimg/c200314/15T15143ZR40-155551.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('343', '84', '麦子赚', '/uploads/allimg/c200314/15T15144430620-1M1K.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('344', '84', '麦子赚', '/uploads/allimg/c200314/15T1514450KP-1S3R.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('345', '84', '麦子赚', '/uploads/allimg/c200314/15T151445B930-194250.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('346', '84', '麦子赚', '/uploads/allimg/c200314/15T15144604230-20a02.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('347', '85', 'iMoney试玩平台', '/uploads/allimg/c200314/15T15144G9540-22AJ.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('348', '85', 'iMoney试玩平台', '/uploads/allimg/c200314/15T15144J1Z-2315J.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('349', '85', 'iMoney试玩平台', '/uploads/allimg/c200314/15T15144N1150-2462A.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('350', '85', 'iMoney试玩平台', '/uploads/allimg/c200314/15T15144Q5X0-251448.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('351', '86', '明明乐园', '/uploads/allimg/c200314/15T151450FS0-1Q40.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('352', '86', '明明乐园', '/uploads/allimg/c200314/15T1514511E50-25H2.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('353', '86', '明明乐园', '/uploads/allimg/c200314/15T151451542P-31291.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('354', '86', '明明乐园', '/uploads/allimg/c200314/15T151451QJ0-4H94.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('355', '87', '玩游赚', '/uploads/allimg/c200314/15T15146413130-11a10.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('356', '87', '玩游赚', '/uploads/allimg/c200314/15T1514A04C0-126250.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('357', '87', '玩游赚', '/uploads/allimg/c200314/15T1514BQT0-136238.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('358', '87', '玩游赚', '/uploads/allimg/c200314/15T1514C1Y50-142U2.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('603', '88', '手赚网官方app', '/uploads/allimg/c200314/15T1514GKD0-1R3E.jpg', '图 3', '300', '600', '31922', 'image/jpeg', '3', '1684486856', '0');
INSERT INTO `ey_images_upload` VALUES ('602', '88', '手赚网官方app', '/uploads/allimg/c200314/15T1514F0O20-1G936.jpg', '图 2', '300', '600', '35343', 'image/jpeg', '2', '1684486856', '0');
INSERT INTO `ey_images_upload` VALUES ('601', '88', '手赚网官方app', '/uploads/allimg/c200314/15T1514E52630-163U8.jpg', '图 1', '300', '600', '49350', 'image/jpeg', '1', '1684486856', '0');
INSERT INTO `ey_images_upload` VALUES ('363', '89', '玩赚星球', '/uploads/allimg/c200314/15T1514K14140-204392.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('364', '89', '玩赚星球', '/uploads/allimg/c200314/15T1514KY630-21L00.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('365', '89', '玩赚星球', '/uploads/allimg/c200314/15T1514LT410-22N28.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('366', '89', '玩赚星球', '/uploads/allimg/c200314/15T1514Mc550-234H0.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('367', '90', '趣头条', '/uploads/allimg/c200314/15T15191343210-12642.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('368', '90', '趣头条', '/uploads/allimg/c200314/15T15191FYZ-2L29.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('369', '90', '趣头条', '/uploads/allimg/c200314/15T15191X9D0-34127.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('370', '90', '趣头条', '/uploads/allimg/c200314/15T15192010920-420R.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('371', '90', '趣头条', '/uploads/allimg/c200314/15T15192055550-5X24.jpg', '图 5', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('372', '91', '泡泡头条', '/uploads/allimg/c200314/15T151921F220-O2Q.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('373', '91', '泡泡头条', '/uploads/allimg/c200314/15T1519220C60-W612.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('374', '91', '泡泡头条', '/uploads/allimg/c200314/15T1519224620-934C.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('375', '91', '泡泡头条', '/uploads/allimg/c200314/15T151922L2P-105916.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('376', '92', '麒麟网', '/uploads/allimg/c200314/15T151923WB0-124115.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('377', '92', '麒麟网', '/uploads/allimg/c200314/15T151924254P-135520.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('378', '92', '麒麟网', '/uploads/allimg/c200314/15T151924441F-142R3.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('379', '92', '麒麟网', '/uploads/allimg/c200314/15T151924VU0-153N9.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('380', '93', '抖音极速版', '/uploads/allimg/c200314/15T1519263EZ-1L3Z.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('381', '93', '抖音极速版', '/uploads/allimg/c200314/15T15192C4M0-1T2T.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('382', '93', '抖音极速版', '/uploads/allimg/c200314/15T15192G1450-19BA.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('383', '93', '抖音极速版', '/uploads/allimg/c200314/15T15192JaP-202a3.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('384', '94', '彩蛋视频', '/uploads/allimg/c200314/15T15192X11P-22Y20.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('385', '94', '彩蛋视频', '/uploads/allimg/c200314/15T15192Z6240-23C21.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('386', '94', '彩蛋视频', '/uploads/allimg/c200314/15T15192940450-24A17.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('387', '94', '彩蛋视频', '/uploads/allimg/c200314/15T15192a91P-256100.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('388', '95', '贝壳转', '/uploads/allimg/c200314/15T151932UL0-1M03.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('389', '95', '贝壳转', '/uploads/allimg/c200314/15T15193315630-22556.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('390', '95', '贝壳转', '/uploads/allimg/c200314/15T15193361360-34449.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('391', '95', '贝壳转', '/uploads/allimg/c200314/15T1519344020-49103.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('392', '96', '蚂蚁看点', '/uploads/allimg/c200314/15T15193C3450-B455.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('393', '96', '蚂蚁看点', '/uploads/allimg/c200314/15T15193G2530-N049.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('394', '96', '蚂蚁看点', '/uploads/allimg/c200314/15T15193P3220-X3S.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('395', '96', '蚂蚁看点', '/uploads/allimg/c200314/15T15193X4S0-923c.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('396', '97', '闪电盒子', '/uploads/allimg/c200314/15T151940L3P-119542.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('397', '97', '闪电盒子', '/uploads/allimg/c200314/15T1519410P20-1212D.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('398', '97', '闪电盒子', '/uploads/allimg/c200314/15T15194134560-136143.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('399', '97', '闪电盒子', '/uploads/allimg/c200314/15T15194161P-146363.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('400', '98', '看点快报', '/uploads/allimg/c200314/15T151942CR0-1DX1.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('401', '98', '看点快报', '/uploads/allimg/c200314/15T15194304G0-1H931.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('402', '98', '看点快报', '/uploads/allimg/c200314/15T15194341910-1V442.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('403', '98', '看点快报', '/uploads/allimg/c200314/15T151943O0P-1a347.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('404', '99', '资讯随享', '/uploads/allimg/c200314/15T15194643940-21bW.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('405', '99', '资讯随享', '/uploads/allimg/c200314/15T15194C350-225364.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('406', '99', '资讯随享', '/uploads/allimg/c200314/15T15194F1950-234326.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('407', '99', '资讯随享', '/uploads/allimg/c200314/15T15194K4120-243604.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('408', '99', '资讯随享', '/uploads/allimg/c200314/15T15194Q3350-254927.jpg', '图 5', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('409', '100', '99阅读', '/uploads/allimg/c200314/15T151T5C1Z-11609.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('410', '100', '99阅读', '/uploads/allimg/c200314/15T151T61H60-2R32.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('411', '100', '99阅读', '/uploads/allimg/c200314/15T151T644020-3a91.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('412', '100', '99阅读', '/uploads/allimg/c200314/15T151TC15F-45227.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('413', '101', '有钻石', '/uploads/allimg/c200314/15T151TO23Z-A404.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('414', '101', '有钻石', '/uploads/allimg/c200314/15T151TS9220-M040.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('415', '101', '有钻石', '/uploads/allimg/c200314/15T151TYQZ-V619.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('416', '101', '有钻石', '/uploads/allimg/c200314/15T151T94aF-92O7.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('417', '102', '66阅读', '/uploads/allimg/c200314/15T151U0DJ0-11E00.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('418', '102', '66阅读', '/uploads/allimg/c200314/15T151U0bG0-124032.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('419', '102', '66阅读', '/uploads/allimg/c200314/15T151U11W30-136043.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('420', '102', '66阅读', '/uploads/allimg/c200314/15T151U14M30-14YD.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('421', '103', '2345星球联盟', '/uploads/allimg/c200314/15T151U292230-161158.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('422', '103', '2345星球联盟', '/uploads/allimg/c200314/15T151U329630-1L049.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('423', '103', '2345星球联盟', '/uploads/allimg/c200314/15T151U3K250-1T522.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('424', '103', '2345星球联盟', '/uploads/allimg/c200314/15T151U432410-195P6.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('425', '104', '趣看点', '/uploads/allimg/c200314/15T151U5C2F-215946.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('426', '104', '趣看点', '/uploads/allimg/c200314/15T151U611060-2255a.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('427', '104', '趣看点', '/uploads/allimg/c200314/15T151UB40F-23D32.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('428', '104', '趣看点', '/uploads/allimg/c200314/15T151UG2060-24G09.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('429', '104', '趣看点', '/uploads/allimg/c200314/15T151UM410-254A3.jpg', '图 5', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('430', '105', '番茄免费小说', '/uploads/allimg/c200314/15T151V0S5F-13b7.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('431', '105', '番茄免费小说', '/uploads/allimg/c200314/15T151V115460-24106.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('432', '105', '番茄免费小说', '/uploads/allimg/c200314/15T151V152910-341Z.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('433', '105', '番茄免费小说', '/uploads/allimg/c200314/15T151V225350-4U41.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('434', '105', '番茄免费小说', '/uploads/allimg/c200314/15T151V2SH0-554R.jpg', '图 5', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('435', '106', '满堂福', '/uploads/allimg/c200314/15T151V4bC0-IU4.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('436', '106', '满堂福', '/uploads/allimg/c200314/15T151V540G0-S502.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('437', '106', '满堂福', '/uploads/allimg/c200314/15T151V633540-924R.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('438', '106', '满堂福', '/uploads/allimg/c200314/15T151VNR30-10R03.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('439', '107', '火山极速版', '/uploads/allimg/c200314/15T151Vb5P-123B7.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('440', '107', '火山极速版', '/uploads/allimg/c200314/15T151W023530-1314M.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('441', '107', '火山极速版', '/uploads/allimg/c200314/15T151W0S1Z-1433O.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('442', '107', '火山极速版', '/uploads/allimg/c200314/15T151W131C0-152251.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('443', '108', '番茄小说', '/uploads/allimg/c200314/15T151W2D50-1H459.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('444', '108', '番茄小说', '/uploads/allimg/c200314/15T151W2a040-1VA9.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('445', '108', '番茄小说', '/uploads/allimg/c200314/15T151W333Q0-1942G.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('446', '108', '番茄小说', '/uploads/allimg/c200314/15T151W3Q3F-20NV.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('447', '109', '奇迹小说', '/uploads/allimg/c200314/15T151W4942F-223144.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('448', '109', '奇迹小说', '/uploads/allimg/c200314/15T151W5514Z-2331K.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('449', '109', '奇迹小说', '/uploads/allimg/c200314/15T151W5V160-241A0.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('450', '109', '奇迹小说', '/uploads/allimg/c200314/15T151W63PP-254523.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('451', '110', '喜马拉雅极速版', '/uploads/allimg/c200314/15T151W9D50-1R27.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('452', '110', '喜马拉雅极速版', '/uploads/allimg/c200314/15T151WcB0-25A3.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('453', '110', '喜马拉雅极速版', '/uploads/allimg/c200314/15T151X031H0-35156.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('454', '110', '喜马拉雅极速版', '/uploads/allimg/c200314/15T151X0591Z-4L44.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('455', '110', '喜马拉雅极速版', '/uploads/allimg/c200314/15T151X0cN0-51537.jpg', '图 5', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('456', '111', '魔视', '/uploads/allimg/c200314/15T151X2JY0-J962.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('457', '111', '魔视', '/uploads/allimg/c200314/15T151X30FP-Y609.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('458', '111', '魔视', '/uploads/allimg/c200314/15T151X422050-95D8.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('459', '111', '魔视', '/uploads/allimg/c200314/15T151X4BS0-101W4.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('460', '111', '魔视', '/uploads/allimg/c200314/15T151X494060-11I45.jpg', '图 5', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('461', '112', '大五福', '/uploads/allimg/c200314/15T151X615510-134450.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('462', '112', '大五福', '/uploads/allimg/c200314/15T151XB3230-1429C.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('463', '112', '大五福', '/uploads/allimg/c200314/15T151XFc10-153F4.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('464', '112', '大五福', '/uploads/allimg/c200314/15T151XJ5620-161562.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('465', '113', '中青看点', '/uploads/allimg/c200314/15T151XV20F-1U043.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('466', '113', '中青看点', '/uploads/allimg/c200314/15T151XYaZ-191254.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('467', '113', '中青看点', '/uploads/allimg/c200314/15T151X92E10-20X44.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('468', '113', '中青看点', '/uploads/allimg/c200314/15T151Xa22F-21Q25.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('469', '113', '中青看点', '/uploads/allimg/c200314/15T151Y00RP-22I58.jpg', '图 5', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('470', '114', '趣看天下', '/uploads/allimg/c200314/15T151Y134140-24SL.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('471', '114', '趣看天下', '/uploads/allimg/c200314/15T151Y1645F-25D15.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('472', '114', '趣看天下', '/uploads/allimg/c200314/15T151Y20H10-261406.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('473', '114', '趣看天下', '/uploads/allimg/c200314/15T151Y244130-2K3P.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('474', '115', '抢先收', '/uploads/allimg/c200314/15T151Y5U420-123b.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('475', '115', '抢先收', '/uploads/allimg/c200314/15T151Y62Q20-22025.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('476', '115', '抢先收', '/uploads/allimg/c200314/15T151YB2250-35405.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('477', '115', '抢先收', '/uploads/allimg/c200314/15T151YH0Q0-49637.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('478', '116', '金刚涨', '/uploads/allimg/c200314/15T151YT91Z-B463.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('479', '116', '金刚涨', '/uploads/allimg/c200314/15T151YW1560-L352.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('480', '116', '金刚涨', '/uploads/allimg/c200314/15T151YZA30-S934.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('481', '116', '金刚涨', '/uploads/allimg/c200314/15T151Y94b10-96008.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('482', '116', '金刚涨', '/uploads/allimg/c200314/15T151YbR20-103F8.jpg', '图 5', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('483', '117', '快音', '/uploads/allimg/c200314/15T151Z129460-122145.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('484', '117', '快音', '/uploads/allimg/c200314/15T151Z1AG0-134T2.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('485', '117', '快音', '/uploads/allimg/c200314/15T151Z200V0-1414b.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('486', '117', '快音', '/uploads/allimg/c200314/15T151Z235360-15Z40.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('487', '117', '快音', '/uploads/allimg/c200314/15T151Z2M30-164457.jpg', '图 5', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('488', '118', '西柚资讯', '/uploads/allimg/c200314/15T151Z3X320-1Y516.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('489', '118', '西柚资讯', '/uploads/allimg/c200314/15T151Z445160-195539.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('490', '118', '西柚资讯', '/uploads/allimg/c200314/15T151Z4ZO0-20NO.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('491', '118', '西柚资讯', '/uploads/allimg/c200314/15T151Z52C20-21I07.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('492', '118', '西柚资讯', '/uploads/allimg/c200314/15T151Z553C0-22QA.jpg', '图 5', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('493', '119', '大六顺', '/uploads/allimg/c200314/15T151ZD130-24L19.jpg', '图 1', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('494', '119', '大六顺', '/uploads/allimg/c200314/15T151ZGG20-2594A.jpg', '图 2', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('495', '119', '大六顺', '/uploads/allimg/c200314/15T151ZT4230-262919.jpg', '图 3', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('496', '119', '大六顺', '/uploads/allimg/c200314/15T151ZYU10-2N234.jpg', '图 4', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('497', '119', '大六顺', '/uploads/allimg/c200314/15T15191024I0-2R4I.jpg', '图 5', '0', '0', '0', '', '100', '1641347764', '1641347764');
INSERT INTO `ey_images_upload` VALUES ('503', '47', '答题夺宝', '/eyou/uploads/allimg/c200314/15T150I013I0-1S513.jpg', '图 6', '0', '0', '0', '', '6', '1641363495', '0');
INSERT INTO `ey_images_upload` VALUES ('600', '18', '小涵兼职', '/uploads/allimg/c200314/15T15035V93F-1aU6.jpg', '图 4', '300', '533', '29384', 'image/jpeg', '4', '1684467823', '0');
INSERT INTO `ey_images_upload` VALUES ('597', '18', '小涵兼职', '/uploads/allimg/c200314/15T15035G9360-1E093.jpg', '图 1', '300', '533', '21824', 'image/jpeg', '1', '1684467823', '0');
INSERT INTO `ey_images_upload` VALUES ('596', '17', '试玩赚钱入口', '/uploads/allimg/c200314/15T15035521O0-141316.jpg', '图 4', '300', '600', '48397', 'image/jpeg', '4', '1684467816', '0');
INSERT INTO `ey_images_upload` VALUES ('593', '17', '试玩赚钱入口', '/uploads/allimg/c200314/15T150352915F-115309.jpg', '图 1', '300', '600', '49350', 'image/jpeg', '1', '1684467816', '0');
INSERT INTO `ey_images_upload` VALUES ('592', '16', '头号试玩', '/uploads/allimg/c200314/15T15034421040-91647.jpg', '图 4', '300', '533', '20691', 'image/jpeg', '4', '1684467806', '0');
INSERT INTO `ey_images_upload` VALUES ('589', '16', '头号试玩', '/uploads/allimg/c200314/15T1503425M0-63229.jpg', '图 1', '300', '533', '20036', 'image/jpeg', '1', '1684467806', '0');
INSERT INTO `ey_images_upload` VALUES ('588', '15', '巨宝朋', '/uploads/allimg/c200314/15T150340F1P-4cN.jpg', '图 4', '300', '533', '36596', 'image/jpeg', '4', '1684467801', '0');
INSERT INTO `ey_images_upload` VALUES ('585', '15', '巨宝朋', '/uploads/allimg/c200314/15T150339102F-1UM.jpg', '图 1', '300', '533', '21851', 'image/jpeg', '1', '1684467801', '0');
INSERT INTO `ey_images_upload` VALUES ('584', '14', '赚钱吧', '/uploads/allimg/c200314/15T15033525250-245152.jpg', '图 4', '300', '533', '23465', 'image/jpeg', '4', '1684467795', '0');
INSERT INTO `ey_images_upload` VALUES ('581', '14', '赚钱吧', '/uploads/allimg/c200314/15T15033360b0-211A8.jpg', '图 1', '300', '533', '34701', 'image/jpeg', '1', '1684467795', '0');
INSERT INTO `ey_images_upload` VALUES ('580', '13', '量次元', '/uploads/allimg/c200314/15T150332630P-1941S.jpg', '图 4', '300', '533', '13164', 'image/jpeg', '4', '1684467788', '0');
INSERT INTO `ey_images_upload` VALUES ('577', '13', '量次元', '/uploads/allimg/c200314/15T150331W520-1B536.jpg', '图 1', '300', '534', '12211', 'image/jpeg', '1', '1684467788', '0');
INSERT INTO `ey_images_upload` VALUES ('576', '12', '柚子试玩', '/uploads/allimg/c200314/15T150330RE0-142529.jpg', '图 4', '300', '533', '17771', 'image/jpeg', '4', '1684467782', '0');
INSERT INTO `ey_images_upload` VALUES ('573', '12', '柚子试玩', '/uploads/allimg/c200314/15T15032b32P-11IH.jpg', '图 1', '300', '533', '13824', 'image/jpeg', '1', '1684467782', '0');
INSERT INTO `ey_images_upload` VALUES ('569', '11', '钱派试玩', '/uploads/allimg/c200314/15T15032A45P-63Q0.jpg', '图 1', '300', '533', '17955', 'image/jpeg', '1', '1684467759', '0');
INSERT INTO `ey_images_upload` VALUES ('544', '2', '小啄赚钱', '/uploads/allimg/c200314/15T1504095H0-11UO.jpg', '图 1', '300', '533', '23174', 'image/jpeg', '1', '1684314021', '0');
INSERT INTO `ey_images_upload` VALUES ('543', '3', '金钱豹', '/uploads/allimg/c200314/15T150414301F-1a622.jpg', '图 3', '300', '533', '19233', 'image/jpeg', '3', '1684310536', '0');
INSERT INTO `ey_images_upload` VALUES ('552', '4', '玩玩赚', '/uploads/allimg/c200314/15T15041K40-24M05.jpg', '图 4', '300', '533', '20867', 'image/jpeg', '4', '1684379752', '0');
INSERT INTO `ey_images_upload` VALUES ('560', '21', '来赚', '/uploads/allimg/c200314/15T1503G2610-93453.jpg', '图 4', '480', '852', '31726', 'image/jpeg', '4', '1684397324', '0');
INSERT INTO `ey_images_upload` VALUES ('557', '21', '来赚', '/uploads/allimg/c200314/15T1503E02Y0-D624.jpg', '图 1', '480', '852', '55704', 'image/jpeg', '1', '1684397324', '0');
INSERT INTO `ey_images_upload` VALUES ('564', '20', 'iMoney爱盈利', '/uploads/allimg/c200314/15T1503CD620-44C7.jpg', '图 4', '300', '533', '28290', 'image/jpeg', '4', '1684397352', '0');
INSERT INTO `ey_images_upload` VALUES ('568', '19', '火箭试玩', '/uploads/allimg/c200314/15T1503634130-2493E.jpg', '图 4', '300', '533', '22790', 'image/jpeg', '4', '1684397375', '0');
INSERT INTO `ey_images_upload` VALUES ('604', '88', '手赚网官方app', '/uploads/allimg/c200314/15T1514HW940-193D5.jpg', '图 4', '300', '600', '48397', 'image/jpeg', '4', '1684486856', '0');

-- -----------------------------
-- Table structure for `ey_language`
-- -----------------------------
DROP TABLE IF EXISTS `ey_language`;
CREATE TABLE `ey_language` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '信息ID，自增',
  `title` varchar(100) NOT NULL DEFAULT '' COMMENT '语言名称',
  `mark` varchar(50) NOT NULL DEFAULT '' COMMENT '语言标识（唯一）',
  `url` varchar(200) NOT NULL DEFAULT '' COMMENT '单独域名(外部链接)',
  `target` tinyint(1) NOT NULL DEFAULT '0' COMMENT '新窗口打开，0=否，1=是',
  `is_home_default` tinyint(1) DEFAULT '0' COMMENT '默认前台语言，1=是，0=否',
  `is_admin_default` tinyint(1) DEFAULT '0' COMMENT '默认后台语言，1=是，0=否',
  `syn_pack_id` int(10) DEFAULT '0' COMMENT '最后一次同步官方语言包ID',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '语言状态，0=关闭，1=开启',
  `sort_order` int(10) DEFAULT '0' COMMENT '排序号',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='多语言主表';

-- -----------------------------
-- Records of `ey_language`
-- -----------------------------
INSERT INTO `ey_language` VALUES ('1', '简体中文', 'cn', '', '0', '1', '1', '24', '1', '100', '1541583096', '1543890743');

-- -----------------------------
-- Table structure for `ey_language_attr`
-- -----------------------------
DROP TABLE IF EXISTS `ey_language_attr`;
CREATE TABLE `ey_language_attr` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '信息ID，自增',
  `attr_name` varchar(200) NOT NULL DEFAULT '' COMMENT '来自ey_weapp_language_attr表的attr_name',
  `attr_value` text NOT NULL COMMENT '变量值',
  `attr_group` varchar(50) DEFAULT '' COMMENT '分组，以表名划分（不含表前缀）',
  `lang` varchar(50) NOT NULL DEFAULT '' COMMENT '所属语言',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `attr_value` (`attr_name`,`lang`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='多语言模板变量关联绑定表';


-- -----------------------------
-- Table structure for `ey_language_attribute`
-- -----------------------------
DROP TABLE IF EXISTS `ey_language_attribute`;
CREATE TABLE `ey_language_attribute` (
  `attr_id` int(10) NOT NULL AUTO_INCREMENT COMMENT '信息ID，自增',
  `attr_title` varchar(200) NOT NULL DEFAULT '' COMMENT '变量标题',
  `attr_name` varchar(200) NOT NULL DEFAULT '' COMMENT '变量名称',
  `attr_group` varchar(50) DEFAULT '' COMMENT '分组，以表名划分（不含表前缀）',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '伪删除，0=否，1=是',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`attr_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='多语言模板变量表';


-- -----------------------------
-- Table structure for `ey_language_mark`
-- -----------------------------
DROP TABLE IF EXISTS `ey_language_mark`;
CREATE TABLE `ey_language_mark` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '国家语言名称',
  `cn_title` varchar(50) NOT NULL DEFAULT '' COMMENT '中文名称',
  `mark` varchar(50) DEFAULT '' COMMENT '多语言标识',
  `pinyin` varchar(100) DEFAULT '' COMMENT '拼音',
  `sort_order` int(10) NOT NULL DEFAULT '0' COMMENT '排序号',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=57 DEFAULT CHARSET=utf8 COMMENT='国家语言表';

-- -----------------------------
-- Records of `ey_language_mark`
-- -----------------------------
INSERT INTO `ey_language_mark` VALUES ('1', '简体中文', '简体中文', 'cn', 'zhongwenjianti', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('2', 'Vietnamese', '越南语', 'vi', 'yuenanyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('3', '繁体中文', '繁体中文', 'zh', 'zhongwenfanti', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('4', 'English', '英语', 'en', 'yingyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('5', 'Indonesian', '印尼语', 'id', 'yinniyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('6', 'Urdu', '乌尔都语', 'ur', 'wuerduyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('7', 'Yiddish', '意第绪语', 'yi', 'yidixuyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('8', 'Italian', '意大利语', 'it', 'yidaliyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('9', 'Greek', '希腊语', 'el', 'xilayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('10', 'Spanish Basque', '西班牙的巴斯克语', 'eu', 'xibanyadebasikeyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('11', 'Spanish', '西班牙语', 'es', 'xibanyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('12', 'Hungarian', '匈牙利语', 'hu', 'xiongyaliyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('13', 'Hebrew', '希伯来语', 'iw', 'xibolaiyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('14', 'Ukrainian', '乌克兰语', 'uk', 'wukelanyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('15', 'Welsh', '威尔士语', 'cy', 'weiershiyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('16', 'Thai', '泰语', 'th', 'taiyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('17', 'Turkish', '土耳其语', 'tr', 'tuerqiyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('18', 'Swahili', '斯瓦希里语', 'sw', 'siwaxiliyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('19', 'Japanese', '日语', 'ja', 'riyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('20', 'Swedish', '瑞典语', 'sv', 'ruidianyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('21', 'Serbian', '塞尔维亚语', 'sr', 'saierweiyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('22', 'Slovak', '斯洛伐克语', 'sk', 'siluofakeyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('23', 'Slovenian', '斯洛文尼亚语', 'sl', 'siluowenniyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('24', 'Portuguese', '葡萄牙语', 'pt', 'putaoyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('25', 'Norwegian', '挪威语', 'no', 'nuoweiyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('26', 'Macedonian', '马其顿语', 'mk', 'maqidunyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('27', 'Malay', '马来语', 'ms', 'malaiyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('28', 'Maltese', '马耳他语', 'mt', 'maertayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('29', 'Romanian', '罗马尼亚语', 'ro', 'luomaniyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('30', 'Lithuanian', '立陶宛语', 'lt', 'litaowanyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('31', 'Latvian', '拉脱维亚语', 'lv', 'latuoweiyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('32', 'Latin', '拉丁语', 'la', 'ladingyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('33', 'Croatian', '克罗地亚语', 'hr', 'keluodiyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('34', 'Czech', '捷克语', 'cs', 'jiekeyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('35', 'Catalan', '加泰罗尼亚语', 'ca', 'jiatailuoniyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('36', 'Galician', '加利西亚语', 'gl', 'jialixiyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('37', 'Dutch', '荷兰语', 'nl', 'helanyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('38', 'Korean', '韩语', 'ko', 'hanyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('39', 'Haitian Creole', '海地克里奥尔语', 'ht', 'haidikeliaoeryu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('40', 'Finnish', '芬兰语', 'fi', 'fenlanyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('41', 'Filipino', '菲律宾语', 'tl', 'feilvbinyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('42', 'Russian', '俄语', 'ru', 'eyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('43', 'Boolean (Afrikaans)', '布尔语(南非荷兰语)', 'af', 'bueryunanfeihelanyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('44', 'French', '法语', 'fr', 'fayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('45', 'Danish', '丹麦语', 'da', 'danmaiyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('46', 'German', '德语', 'de', 'deyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('47', 'Azerbaijani', '阿塞拜疆语', 'az', 'asaibaijiangyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('48', 'Irish', '爱尔兰语', 'ga', 'aierlanyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('49', 'Estonian', '爱沙尼亚语', 'et', 'aishaniyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('50', 'Belarusian', '白俄罗斯语', 'be', 'baieluosiyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('51', 'Bulgarian', '保加利亚语', 'bg', 'baojialiyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('52', 'Icelandic', '冰岛语', 'is', 'bingdaoyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('53', 'Polish', '波兰语', 'pl', 'bolanyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('54', 'Persian', '波斯语', 'fa', 'bosiyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('55', 'Arabic', '阿拉伯语', 'ar', 'alaboyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('56', 'Albanian', '阿尔巴尼亚语', 'sq', 'aerbaniyayu', '100', '0', '1541583096');

-- -----------------------------
-- Table structure for `ey_language_pack`
-- -----------------------------
DROP TABLE IF EXISTS `ey_language_pack`;
CREATE TABLE `ey_language_pack` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '变量名',
  `value` text NOT NULL COMMENT '变量值',
  `is_syn` tinyint(1) DEFAULT '0' COMMENT '同步官方语言包：0=否，1=是',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `sort_order` int(10) DEFAULT '0' COMMENT '排序号',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COMMENT='模板语言包变量';

-- -----------------------------
-- Records of `ey_language_pack`
-- -----------------------------
INSERT INTO `ey_language_pack` VALUES ('1', 'sys1', '首页', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('2', 'sys2', '上一页', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('3', 'sys3', '下一页', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('4', 'sys4', '末页', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('5', 'sys5', '共<strong>%s</strong>页 <strong>%s</strong>条', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('6', 'sys6', '全部', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('7', 'sys7', '搜索', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('8', 'sys8', '查看详情', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('9', 'sys9', '网站首页', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('10', 'sys10', '暂无', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('11', 'sys11', '上一篇', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('12', 'sys12', '下一篇', '1', 'cn', '100', '1543890216', '1543890216');

-- -----------------------------
-- Table structure for `ey_links`
-- -----------------------------
DROP TABLE IF EXISTS `ey_links`;
CREATE TABLE `ey_links` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `typeid` tinyint(1) DEFAULT '1' COMMENT '类型：1=文字链接，2=图片链接',
  `groupid` int(11) unsigned NOT NULL DEFAULT '1' COMMENT '分组id， 默认分组值为1',
  `title` varchar(50) DEFAULT '' COMMENT '网站标题',
  `url` varchar(100) DEFAULT '' COMMENT '网站地址',
  `logo` varchar(255) DEFAULT '' COMMENT '网站LOGO',
  `sort_order` int(11) DEFAULT '0' COMMENT '排序号',
  `target` tinyint(1) DEFAULT '0' COMMENT '是否开启浏览器新窗口',
  `nofollow` tinyint(1) DEFAULT '0',
  `email` varchar(50) DEFAULT NULL,
  `intro` text COMMENT '网站简况',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态(1=显示，0=屏蔽)',
  `province_id` int(10) DEFAULT '0' COMMENT '省份',
  `city_id` int(10) DEFAULT '0' COMMENT '所在城市',
  `area_id` int(10) DEFAULT '0' COMMENT '所在区域',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `delete_time` int(11) DEFAULT '0' COMMENT '软删除时间',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=utf8 COMMENT='友情链接表';

-- -----------------------------
-- Records of `ey_links`
-- -----------------------------
INSERT INTO `ey_links` VALUES ('8', '1', '1', '淘宝', 'http://www.taobao.com/', '', '8', '0', '0', '', '', '1', '0', '0', '0', 'cn', '0', '1227772703', '1227772703');
INSERT INTO `ey_links` VALUES ('9', '1', '1', '百度', 'http://www.baidu.com/', '', '1', '0', '0', '', '', '1', '0', '0', '0', 'cn', '0', '1227772717', '1641365171');
INSERT INTO `ey_links` VALUES ('10', '1', '1', '优酷', 'http://www.youku.com/', '', '1', '0', '0', '', '', '1', '0', '0', '0', 'cn', '0', '1585216857', '1641365185');
INSERT INTO `ey_links` VALUES ('11', '1', '1', '微博', 'https://weibo.com/', '', '1', '0', '0', '', '', '1', '0', '0', '0', 'cn', '0', '1585216868', '1641365194');
INSERT INTO `ey_links` VALUES ('12', '1', '1', '新浪', 'https://www.sina.com.cn/', '', '1', '0', '0', '', '', '1', '0', '0', '0', 'cn', '0', '1585216877', '1641365207');
INSERT INTO `ey_links` VALUES ('13', '1', '1', '腾讯', 'http://www.qq.com/', '', '1', '0', '0', '', '', '1', '0', '0', '0', 'cn', '0', '1585216889', '1641365216');
INSERT INTO `ey_links` VALUES ('14', '1', '1', '京东', 'http://www.jd.com/', '', '1', '0', '0', '', '', '1', '0', '0', '0', 'cn', '0', '1585216899', '1641365225');

-- -----------------------------
-- Table structure for `ey_links_group`
-- -----------------------------
DROP TABLE IF EXISTS `ey_links_group`;
CREATE TABLE `ey_links_group` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `group_name` varchar(255) NOT NULL DEFAULT '' COMMENT '分组名称',
  `status` tinyint(2) unsigned NOT NULL DEFAULT '1' COMMENT '状态(1=显示，0=屏蔽)',
  `sort_order` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '排序号',
  `lang` varchar(50) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0',
  `update_time` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COMMENT='友情链接分组';

-- -----------------------------
-- Records of `ey_links_group`
-- -----------------------------
INSERT INTO `ey_links_group` VALUES ('1', '综合网站', '1', '100', 'cn', '1641347760', '1641347760');
INSERT INTO `ey_links_group` VALUES ('2', '娱乐类', '1', '100', 'cn', '1641347760', '1641347760');
INSERT INTO `ey_links_group` VALUES ('3', '教育类', '1', '100', 'cn', '1641347760', '1641347760');
INSERT INTO `ey_links_group` VALUES ('4', '计算机类', '1', '100', 'cn', '1641347760', '1641347760');
INSERT INTO `ey_links_group` VALUES ('5', '电子商务', '1', '100', 'cn', '1641347760', '1641347760');
INSERT INTO `ey_links_group` VALUES ('6', '网上信息', '1', '100', 'cn', '1641347760', '1641347760');
INSERT INTO `ey_links_group` VALUES ('7', '论坛类', '1', '100', 'cn', '1641347760', '1641347760');
INSERT INTO `ey_links_group` VALUES ('8', '其它类型', '1', '100', 'cn', '1641347760', '1641347760');

-- -----------------------------
-- Table structure for `ey_media_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_media_content`;
CREATE TABLE `ey_media_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) NOT NULL DEFAULT '0' COMMENT '文档ID',
  `content` longtext COMMENT '内容详情',
  `content_ey_m` longtext COMMENT '手机端内容详情',
  `courseware` varchar(200) NOT NULL DEFAULT '' COMMENT '课件地址',
  `courseware_free` enum('免费','收费') NOT NULL DEFAULT '免费' COMMENT '课件收费',
  `total_duration` int(10) NOT NULL DEFAULT '0' COMMENT '视频总时长',
  `total_video` int(10) NOT NULL DEFAULT '0' COMMENT '视频数',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='视频附加表';


-- -----------------------------
-- Table structure for `ey_media_file`
-- -----------------------------
DROP TABLE IF EXISTS `ey_media_file`;
CREATE TABLE `ey_media_file` (
  `file_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '视频模型文件表',
  `aid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '文档ID',
  `title` varchar(200) NOT NULL DEFAULT '' COMMENT '文档标题',
  `file_name` varchar(200) NOT NULL DEFAULT '' COMMENT '文件名称',
  `file_title` varchar(200) NOT NULL DEFAULT '' COMMENT '选集标题',
  `file_url` text NOT NULL COMMENT '存储路径',
  `file_time` int(8) NOT NULL DEFAULT '0' COMMENT '文件时长',
  `file_ext` varchar(50) NOT NULL DEFAULT '' COMMENT '文件后缀名',
  `file_size` varchar(255) NOT NULL DEFAULT '' COMMENT '文件大小',
  `file_mime` varchar(200) NOT NULL DEFAULT '' COMMENT '文件类型',
  `uhash` varchar(200) NOT NULL DEFAULT '' COMMENT '自定义的一种加密方式，用于视频播放的权限验证',
  `md5file` varchar(200) NOT NULL DEFAULT '' COMMENT 'md5_file加密，可以检测上传/播放的视频文件是否损坏',
  `is_remote` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否远程 1-远程',
  `playcount` int(10) NOT NULL DEFAULT '0' COMMENT '播放次数',
  `gratis` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否试看，0不试看，1试看',
  `sort_order` smallint(5) NOT NULL DEFAULT '0' COMMENT '排序',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '上传时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`file_id`) USING BTREE,
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='视频附件表';


-- -----------------------------
-- Table structure for `ey_media_log`
-- -----------------------------
DROP TABLE IF EXISTS `ey_media_log`;
CREATE TABLE `ey_media_log` (
  `log_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `users_id` int(10) DEFAULT '0' COMMENT '用户ID',
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `file_id` int(10) DEFAULT '0' COMMENT '视频ID',
  `ip` varchar(20) DEFAULT '' COMMENT 'ip',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '编辑时间',
  PRIMARY KEY (`log_id`),
  KEY `file_id` (`file_id`,`aid`,`users_id`) USING BTREE,
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='视频日志表';


-- -----------------------------
-- Table structure for `ey_media_order`
-- -----------------------------
DROP TABLE IF EXISTS `ey_media_order`;
CREATE TABLE `ey_media_order` (
  `order_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '媒体订单ID',
  `order_code` varchar(50) NOT NULL DEFAULT '' COMMENT '媒体订单编号',
  `users_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `mobile` varchar(20) DEFAULT '' COMMENT '手机',
  `order_status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '订单状态：0未付款，1已付款',
  `order_amount` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '订单应付总金额',
  `pay_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '支付时间',
  `pay_name` varchar(20) NOT NULL DEFAULT '' COMMENT '支付方式名称',
  `wechat_pay_type` varchar(20) NOT NULL DEFAULT '' COMMENT '微信支付时，标记使用的支付类型（扫码支付，微信内部，微信H5页面）',
  `pay_details` text COMMENT '支付时返回的数据，以serialize序列化后存入，用于后续查询。',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '视频文档ID',
  `product_name` varchar(100) DEFAULT '' COMMENT '视频文档名称',
  `product_litpic` varchar(500) DEFAULT '' COMMENT '视频文档封面图片',
  `lang` varchar(30) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '下单时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`order_id`),
  UNIQUE KEY `order_code` (`order_code`) USING BTREE,
  KEY `users_id` (`users_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='视频订单表';


-- -----------------------------
-- Table structure for `ey_media_play_record`
-- -----------------------------
DROP TABLE IF EXISTS `ey_media_play_record`;
CREATE TABLE `ey_media_play_record` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `users_id` int(10) DEFAULT '0' COMMENT '用户id',
  `aid` int(10) DEFAULT '0' COMMENT '课程id',
  `file_id` int(10) DEFAULT '0' COMMENT '文件id',
  `play_time` int(10) DEFAULT '0' COMMENT '播放时间',
  `add_time` int(10) DEFAULT '0' COMMENT '添加时间',
  `update_time` int(10) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='视频播放时长表';


-- -----------------------------
-- Table structure for `ey_memgift`
-- -----------------------------
DROP TABLE IF EXISTS `ey_memgift`;
CREATE TABLE `ey_memgift` (
  `gift_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '礼品列表',
  `type` tinyint(3) NOT NULL DEFAULT '1' COMMENT '-1-实物,2-会员产品',
  `type_id` int(10) DEFAULT '0' COMMENT '类型为会员产品时的会员产品类型(users_type_manage)type_id',
  `score` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '所需积分',
  `litpic` varchar(250) NOT NULL DEFAULT '',
  `giftname` varchar(60) NOT NULL DEFAULT '',
  `num` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '兑换次数',
  `content` longtext COMMENT '礼品详情',
  `stock` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '库存总数',
  `is_del` tinyint(3) NOT NULL DEFAULT '0' COMMENT '0-正常,1-删除',
  `status` tinyint(2) NOT NULL DEFAULT '1' COMMENT '礼品状态：1=显示，0=隐藏',
  `add_time` int(10) DEFAULT '0',
  `update_time` int(10) DEFAULT '0',
  `sort_order` int(10) DEFAULT '100' COMMENT '排序',
  PRIMARY KEY (`gift_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='礼品兑换表';


-- -----------------------------
-- Table structure for `ey_memgiftget`
-- -----------------------------
DROP TABLE IF EXISTS `ey_memgiftget`;
CREATE TABLE `ey_memgiftget` (
  `gid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `giftname` char(60) NOT NULL DEFAULT '',
  `gift_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '礼品ID',
  `score` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '积分',
  `users_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '状态,0-待发货,1-已发货,2-退回,3-重发',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '姓名',
  `mobile` varchar(55) NOT NULL DEFAULT '' COMMENT '手机',
  `address` varchar(255) NOT NULL DEFAULT '' COMMENT '地址',
  `add_time` int(10) DEFAULT '0',
  `update_time` int(10) DEFAULT '0',
  `type_id` int(11) DEFAULT '0' COMMENT '兑换会员产品时,会员产品套餐(表::users_type_manage)type_id',
  PRIMARY KEY (`gid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='礼品兑换记录表';


-- -----------------------------
-- Table structure for `ey_nav_list`
-- -----------------------------
DROP TABLE IF EXISTS `ey_nav_list`;
CREATE TABLE `ey_nav_list` (
  `nav_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '导航ID',
  `nav_name` varchar(200) NOT NULL DEFAULT '' COMMENT '导航名称',
  `parent_id` int(10) NOT NULL DEFAULT '0' COMMENT '上级菜单id',
  `topid` int(10) NOT NULL DEFAULT '0' COMMENT '顶级菜单id',
  `en_name` varchar(200) NOT NULL DEFAULT '' COMMENT '英文名称',
  `nav_url` varchar(200) NOT NULL DEFAULT '' COMMENT '导航链接',
  `position_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '导航位置',
  `arctype_sync` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否与栏目同步',
  `type_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '同步栏目的ID',
  `nav_pic` varchar(255) NOT NULL DEFAULT '' COMMENT '导航图片',
  `is_remote` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否远程图片',
  `target` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否打开新窗口，1=是，0=否',
  `nofollow` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否使用nofollow，1=是，0=否',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '启用 (1=正常，0=停用)',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '伪删除，1=是，0=否',
  `sort_order` int(10) unsigned NOT NULL DEFAULT '100' COMMENT '排序号',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`nav_id`) USING BTREE,
  KEY `position_id` (`position_id`) USING BTREE,
  KEY `type_id` (`type_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='导航列表';


-- -----------------------------
-- Table structure for `ey_nav_position`
-- -----------------------------
DROP TABLE IF EXISTS `ey_nav_position`;
CREATE TABLE `ey_nav_position` (
  `position_id` int(10) NOT NULL AUTO_INCREMENT COMMENT '导航列表ID',
  `position_name` varchar(200) DEFAULT '' COMMENT '导航列表名称',
  `sort_order` int(10) DEFAULT '0' COMMENT '排序号',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '伪删除，1=是，0=否',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`position_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COMMENT='导航位置表';

-- -----------------------------
-- Records of `ey_nav_position`
-- -----------------------------
INSERT INTO `ey_nav_position` VALUES ('1', 'PC端主导航', '100', '0', '0', '1624861478');
INSERT INTO `ey_nav_position` VALUES ('2', 'PC端顶部导航', '100', '0', '0', '1624861478');
INSERT INTO `ey_nav_position` VALUES ('3', 'PC端中部导航', '100', '0', '0', '1624861478');
INSERT INTO `ey_nav_position` VALUES ('4', 'PC端底部导航', '100', '0', '0', '1624861478');
INSERT INTO `ey_nav_position` VALUES ('5', '移动端中部导航', '100', '0', '0', '1624861478');
INSERT INTO `ey_nav_position` VALUES ('6', '移动端底部导航', '100', '0', '0', '1624861478');

-- -----------------------------
-- Table structure for `ey_nzsm_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_nzsm_content`;
CREATE TABLE `ey_nzsm_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `zdy` varchar(200) NOT NULL DEFAULT '' COMMENT '字段一',
  `zde` varchar(200) NOT NULL DEFAULT '' COMMENT '字段二',
  `zdsa` varchar(200) NOT NULL DEFAULT '' COMMENT '字段三',
  `zdsi` varchar(200) NOT NULL DEFAULT '' COMMENT '字段四',
  `zdw` varchar(200) NOT NULL DEFAULT '' COMMENT '字段五',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='附加表';

-- -----------------------------
-- Records of `ey_nzsm_content`
-- -----------------------------
INSERT INTO `ey_nzsm_content` VALUES ('1', '8', '1589159107', '1589159107', '短信接口', '企业邮局', '云服务器', '主机租用', '域名注册');
INSERT INTO `ey_nzsm_content` VALUES ('2', '9', '1589159121', '1589159121', '', '手机商城', '小程序商城', '微商城', 'B2C商城');
INSERT INTO `ey_nzsm_content` VALUES ('3', '10', '1589159131', '1589159131', '', 'APP开发', '微信公众平台开发', '手机网站', '小程序开发');
INSERT INTO `ey_nzsm_content` VALUES ('4', '11', '1589159145', '1589159145', 'B2C商城网站建设', '新闻门户网站建设', '营销网站建设', '品牌网站建设', '企业网站建设');

-- -----------------------------
-- Table structure for `ey_pay_api_config`
-- -----------------------------
DROP TABLE IF EXISTS `ey_pay_api_config`;
CREATE TABLE `ey_pay_api_config` (
  `pay_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '支付接口配置ID，自增',
  `pay_name` varchar(64) NOT NULL DEFAULT '' COMMENT '支付接口配置名称，微信支付，支付宝支付...',
  `pay_mark` varchar(64) NOT NULL DEFAULT '' COMMENT '支付接口配置标识，wechat，alipay...',
  `pay_info` text NOT NULL COMMENT '支付接口配置信息，数组以序列化存储',
  `pay_terminal` varchar(100) NOT NULL DEFAULT '' COMMENT '支付时的终端，暂时预留',
  `system_built` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否属于系统内置，0否，1是',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态(0=关闭，1=开启)',
  `lang` varchar(30) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`pay_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='支付接口配置表';

-- -----------------------------
-- Records of `ey_pay_api_config`
-- -----------------------------
INSERT INTO `ey_pay_api_config` VALUES ('1', '微信支付', 'wechat', '', 'a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}', '1', '1', 'cn', '1590111253', '1590661409');
INSERT INTO `ey_pay_api_config` VALUES ('2', '支付宝支付', 'alipay', '', 'a:2:{i:0;s:1:\"1\";i:1;s:1:\"2\";}', '1', '1', 'cn', '1590111253', '1590662059');

-- -----------------------------
-- Table structure for `ey_product_attr`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_attr`;
CREATE TABLE `ey_product_attr` (
  `product_attr_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '产品属性id自增',
  `aid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '产品id',
  `attr_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '属性id',
  `attr_value` text COMMENT '属性值',
  `attr_price` varchar(255) DEFAULT '' COMMENT '属性价格',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`product_attr_id`),
  KEY `aid` (`aid`) USING BTREE,
  KEY `attr_id` (`attr_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='产品表单属性值';


-- -----------------------------
-- Table structure for `ey_product_attribute`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_attribute`;
CREATE TABLE `ey_product_attribute` (
  `attr_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '属性id',
  `attr_name` varchar(60) DEFAULT '' COMMENT '属性名称',
  `typeid` int(11) unsigned DEFAULT '0' COMMENT '栏目id',
  `attr_index` tinyint(1) unsigned DEFAULT '0' COMMENT '0不需要检索 1关键字检索 2范围检索',
  `attr_input_type` tinyint(1) unsigned DEFAULT '0' COMMENT ' 0=文本框，1=下拉框，2=多行文本框',
  `attr_values` text COMMENT '可选值列表',
  `sort_order` int(11) unsigned DEFAULT '0' COMMENT '属性排序',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '是否已删除，0=否，1=是',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`attr_id`),
  KEY `cat_id` (`typeid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='产品表单属性表';


-- -----------------------------
-- Table structure for `ey_product_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_content`;
CREATE TABLE `ey_product_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `content` longtext COMMENT '内容详情',
  `content_ey_m` longtext COMMENT '手机端内容详情',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `news_id` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='资讯内容表_存储正常内容';


-- -----------------------------
-- Table structure for `ey_product_custom_param`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_custom_param`;
CREATE TABLE `ey_product_custom_param` (
  `param_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '参数ID',
  `aid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '参数ID',
  `param_name` varchar(60) NOT NULL DEFAULT '' COMMENT '参数名称',
  `param_value` varchar(200) NOT NULL DEFAULT '' COMMENT '参数值',
  `sort_order` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '属性排序',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`param_id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='产品自定义参数表';


-- -----------------------------
-- Table structure for `ey_product_img`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_img`;
CREATE TABLE `ey_product_img` (
  `img_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `aid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '产品ID',
  `title` varchar(200) DEFAULT '' COMMENT '产品标题',
  `image_url` varchar(255) DEFAULT '' COMMENT '文件存储路径',
  `intro` varchar(2000) DEFAULT '' COMMENT '图集描述',
  `width` int(11) DEFAULT '0' COMMENT '图片宽度',
  `height` int(11) DEFAULT '0' COMMENT '图片高度',
  `filesize` varchar(255) DEFAULT '' COMMENT '文件大小',
  `mime` varchar(50) DEFAULT '' COMMENT '图片类型',
  `sort_order` smallint(5) DEFAULT '0' COMMENT '排序',
  `add_time` int(10) unsigned DEFAULT '0' COMMENT '上传时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`img_id`),
  KEY `arcid` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='产品图片表';


-- -----------------------------
-- Table structure for `ey_product_netdisk`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_netdisk`;
CREATE TABLE `ey_product_netdisk` (
  `nd_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '网盘商品id',
  `aid` int(10) DEFAULT '0' COMMENT '产品ID',
  `netdisk_url` varchar(255) NOT NULL DEFAULT '' COMMENT '网盘地址',
  `netdisk_pwd` varchar(50) NOT NULL DEFAULT '' COMMENT '提取码',
  `unzip_pwd` varchar(50) NOT NULL DEFAULT '' COMMENT '解压密码',
  `text_content` text NOT NULL COMMENT '文本内容',
  `lang` varchar(10) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`nd_id`) USING BTREE,
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='产品虚拟表';


-- -----------------------------
-- Table structure for `ey_product_spec_data`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_spec_data`;
CREATE TABLE `ey_product_spec_data` (
  `spec_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `aid` int(10) DEFAULT '0' COMMENT '产品ID',
  `spec_mark_id` int(10) DEFAULT '0' COMMENT '规格标记ID',
  `spec_name` varchar(100) DEFAULT '' COMMENT '规格名称',
  `spec_value_id` int(10) DEFAULT '0' COMMENT '规格值ID',
  `spec_value` varchar(100) DEFAULT '' COMMENT '规格值',
  `spec_is_select` tinyint(1) DEFAULT '0' COMMENT '是否选中（0=否，1=是）',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`spec_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='产品规格数据表';


-- -----------------------------
-- Table structure for `ey_product_spec_data_handle`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_spec_data_handle`;
CREATE TABLE `ey_product_spec_data_handle` (
  `spec_id` int(10) DEFAULT '0' COMMENT '对应 product_spec_data 数据表',
  `aid` int(10) DEFAULT '0' COMMENT '对应 product_spec_data 数据表',
  `spec_mark_id` int(10) DEFAULT '0' COMMENT '对应 product_spec_data 数据表',
  `spec_name` varchar(100) DEFAULT '' COMMENT '对应 product_spec_data 数据表',
  `spec_value_id` int(10) DEFAULT '0' COMMENT '对应 product_spec_data 数据表',
  `spec_value` varchar(100) DEFAULT '' COMMENT '对应 product_spec_data 数据表',
  `spec_is_select` tinyint(1) DEFAULT '0' COMMENT '对应 product_spec_data 数据表',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '对应 product_spec_data 数据表',
  `add_time` int(11) DEFAULT '0' COMMENT '对应 product_spec_data 数据表',
  `update_time` int(11) DEFAULT '0' COMMENT '对应 product_spec_data 数据表'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='商品规格表(product_spec_data)预处理规格数据表';


-- -----------------------------
-- Table structure for `ey_product_spec_preset`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_spec_preset`;
CREATE TABLE `ey_product_spec_preset` (
  `preset_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `preset_mark_id` int(10) DEFAULT '0' COMMENT '预设参数标记ID',
  `preset_name` varchar(100) DEFAULT '' COMMENT '规格名称',
  `preset_value` varchar(100) DEFAULT '' COMMENT '规格值',
  `spec_sync` tinyint(1) unsigned DEFAULT '0' COMMENT '是否同步到已发布的商品规格：0否，1是。',
  `sort_order` int(10) DEFAULT '100' COMMENT '排序号',
  `merchant_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '多商家ID',
  `product_add` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否在商品添加或编辑页添加的规格信息，0否，1是，默认0',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`preset_id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COMMENT='产品规格预设表';

-- -----------------------------
-- Records of `ey_product_spec_preset`
-- -----------------------------
INSERT INTO `ey_product_spec_preset` VALUES ('1', '1', '产品颜色', '红', '0', '100', '0', '0', 'cn', '1565752372', '1565752623');
INSERT INTO `ey_product_spec_preset` VALUES ('2', '1', '产品颜色', '蓝', '0', '100', '0', '0', 'cn', '1565752372', '1565752623');
INSERT INTO `ey_product_spec_preset` VALUES ('3', '1', '产品颜色', '黄', '0', '100', '0', '0', 'cn', '1565752372', '1565752623');

-- -----------------------------
-- Table structure for `ey_product_spec_value`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_spec_value`;
CREATE TABLE `ey_product_spec_value` (
  `value_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `aid` int(10) NOT NULL DEFAULT '0' COMMENT '产品ID',
  `spec_value_id` varchar(100) NOT NULL DEFAULT '' COMMENT '规格值ID',
  `spec_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '规格价格',
  `spec_stock` int(10) NOT NULL DEFAULT '0' COMMENT '规格库存',
  `spec_sales_num` int(10) NOT NULL DEFAULT '0' COMMENT '销售量',
  `seckill_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '秒杀价格',
  `seckill_stock` int(10) NOT NULL DEFAULT '0' COMMENT '秒杀库存(独立库存，与spec_stock/限时折扣库存不同步)',
  `seckill_sales_num` int(10) NOT NULL DEFAULT '0' COMMENT '秒杀销售量',
  `is_seckill` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0-普通 1-秒杀',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `discount_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '限时折扣价格',
  `discount_stock` int(10) NOT NULL DEFAULT '0' COMMENT '限时折扣库存(独立库存，与spec_stock/秒杀库存不同步)',
  `discount_sales_num` int(10) NOT NULL DEFAULT '0' COMMENT '限时折扣销售量',
  `is_discount` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0-普通 1-限时折扣',
  PRIMARY KEY (`value_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='产品多规格组装表';


-- -----------------------------
-- Table structure for `ey_quickentry`
-- -----------------------------
DROP TABLE IF EXISTS `ey_quickentry`;
CREATE TABLE `ey_quickentry` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `title` varchar(20) DEFAULT '' COMMENT '名称',
  `laytext` varchar(50) DEFAULT '' COMMENT '完整标题',
  `type` smallint(5) DEFAULT '0' COMMENT '归类，1=快捷入口，2=内容统计',
  `controller` varchar(20) DEFAULT '' COMMENT '控制器名',
  `action` varchar(20) DEFAULT '' COMMENT '操作名',
  `vars` varchar(100) DEFAULT '' COMMENT 'URL参数字符串',
  `groups` smallint(5) DEFAULT '0' COMMENT '分组，1=模型',
  `checked` tinyint(4) DEFAULT '0' COMMENT '选中，0=否，1=是',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态，1=有效，0=无效',
  `sort_order` int(10) DEFAULT '0' COMMENT '排序',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `type` (`type`,`status`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=42 DEFAULT CHARSET=utf8 COMMENT='快捷入口表';

-- -----------------------------
-- Records of `ey_quickentry`
-- -----------------------------
INSERT INTO `ey_quickentry` VALUES ('1', '产品', '产品列表', '1', 'Product', 'index', 'channel=2', '1', '0', '1', '3', '1569232484', '1684487717');
INSERT INTO `ey_quickentry` VALUES ('2', '下载', '下载列表', '1', 'Download', 'index', 'channel=4', '1', '0', '1', '4', '1569232484', '1684487717');
INSERT INTO `ey_quickentry` VALUES ('3', '文章', '文章列表', '1', 'Article', 'index', 'channel=1', '1', '0', '1', '6', '1569232484', '1684487717');
INSERT INTO `ey_quickentry` VALUES ('4', '图集', '图集列表', '1', 'Images', 'index', 'channel=3', '1', '0', '1', '7', '1569232484', '1684487717');
INSERT INTO `ey_quickentry` VALUES ('5', '内容管理', '内容列表', '1', 'Archives', 'index', '', '0', '0', '1', '13', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('7', '回收站', '回收站', '1', 'RecycleBin', 'archives_index', '', '0', '1', '1', '4', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('8', '栏目管理', '栏目管理', '1', 'Arctype', 'index', '', '0', '0', '1', '5', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('9', '留言', '留言管理', '1', 'Form', 'index', '', '1', '0', '1', '6', '1569232484', '1684114882');
INSERT INTO `ey_quickentry` VALUES ('10', '网站信息', '网站信息', '1', 'System', 'web', '', '0', '0', '1', '7', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('11', '水印配置', '水印配置', '1', 'System', 'water', '', '0', '1', '1', '8', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('12', '缩略图配置', '缩略图配置', '1', 'System', 'thumb', '', '0', '1', '1', '9', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('13', '数据备份', '数据备份', '1', 'Tools', 'index', '', '0', '0', '1', '11', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('14', 'URL配置', 'URL配置', '1', 'Seo', 'seo', '', '0', '1', '1', '1', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('15', '模板管理', '模板管理', '1', 'Filemanager', 'index', '', '0', '1', '1', '6', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('16', 'SiteMap', 'SiteMap', '1', 'Sitemap', 'index', '', '0', '1', '1', '12', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('17', '频道模型', '频道模型', '1', 'Channeltype', 'index', '', '0', '1', '1', '2', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('18', '广告管理', '广告管理', '1', 'AdPosition', 'index', '', '0', '0', '1', '3', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('19', '友情链接', '友情链接', '1', 'Links', 'index', '', '0', '0', '1', '10', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('20', 'Tags管理', 'Tags管理', '1', 'Tags', 'index', '', '0', '1', '1', '14', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('21', '管理员管理', '管理员管理', '1', 'Admin', 'index', '', '0', '0', '1', '15', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('22', '接口配置', '接口配置', '1', 'System', 'api_conf', '', '0', '1', '1', '16', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('23', '文章', '文章列表', '2', 'Article', 'index', 'channel=1', '1', '1', '1', '1', '1569310798', '1684487717');
INSERT INTO `ey_quickentry` VALUES ('24', '产品', '产品列表', '2', 'Product', 'index', 'channel=2', '1', '0', '1', '2', '1569310798', '1684487717');
INSERT INTO `ey_quickentry` VALUES ('25', '下载', '下载列表', '2', 'Download', 'index', 'channel=4', '1', '0', '1', '4', '1569310798', '1684487717');
INSERT INTO `ey_quickentry` VALUES ('26', '图集', '图集列表', '2', 'Images', 'index', 'channel=3', '1', '0', '1', '3', '1569310798', '1684487717');
INSERT INTO `ey_quickentry` VALUES ('27', '留言', '留言管理', '2', 'Form', 'index', '', '1', '0', '1', '5', '1569310798', '1684114882');
INSERT INTO `ey_quickentry` VALUES ('28', '广告', '广告管理', '2', 'AdPosition', 'index', '', '0', '1', '1', '8', '1569232484', '1571898872');
INSERT INTO `ey_quickentry` VALUES ('29', '友情链接', '友情链接', '2', 'Links', 'index', '', '0', '1', '1', '9', '1569232484', '1571898872');
INSERT INTO `ey_quickentry` VALUES ('30', 'Tags标签', 'Tags管理', '2', 'Tags', 'index', '', '0', '1', '1', '10', '1569232484', '1571898872');
INSERT INTO `ey_quickentry` VALUES ('31', '会员', '会员管理', '2', 'Member', 'users_index', '', '0', '0', '0', '7', '1569232484', '1684487717');
INSERT INTO `ey_quickentry` VALUES ('32', '插件应用', '插件应用', '1', 'Weapp', 'index', '', '0', '0', '0', '17', '1569232484', '1684487717');
INSERT INTO `ey_quickentry` VALUES ('33', '会员中心', '会员中心', '1', 'Member', 'users_index', '', '0', '0', '0', '18', '1569232484', '1684487717');
INSERT INTO `ey_quickentry` VALUES ('34', '商城中心', '商城中心', '1', 'Shop', 'index', '', '0', '0', '0', '19', '1569232484', '1684487717');
INSERT INTO `ey_quickentry` VALUES ('35', '订单', '订单管理', '2', 'Shop', 'index', '', '0', '0', '0', '6', '1569232484', '1684487717');
INSERT INTO `ey_quickentry` VALUES ('37', '专题', '专题列表', '2', 'Special', 'index', 'channel=7', '1', '0', '1', '7', '1600078966', '1684487717');
INSERT INTO `ey_quickentry` VALUES ('39', '视频', '视频列表', '2', 'Media', 'index', 'channel=5', '1', '0', '0', '4', '1569310798', '1684487717');

-- -----------------------------
-- Table structure for `ey_recruit_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_recruit_content`;
CREATE TABLE `ey_recruit_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `gzdd` varchar(200) NOT NULL DEFAULT '' COMMENT '工作地点',
  `xlyq` varchar(200) NOT NULL DEFAULT '' COMMENT '学历要求',
  `xzdy` varchar(200) NOT NULL DEFAULT '' COMMENT '薪资待遇',
  `gzxz` varchar(200) NOT NULL DEFAULT '' COMMENT '工作性质',
  `gznx` varchar(200) NOT NULL DEFAULT '' COMMENT '工作年限',
  `zprs` varchar(200) NOT NULL DEFAULT '' COMMENT '招聘人数',
  `nnxq` longtext COMMENT '内容详情',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COMMENT='附加表';

-- -----------------------------
-- Records of `ey_recruit_content`
-- -----------------------------
INSERT INTO `ey_recruit_content` VALUES ('1', '82', '1563528211', '1563528211', '广州市', '中专以上学历', '5000-10000元', '全职', '1年以上', '若干', '&lt;p&gt;工作内容：&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;1、负责公司手机游戏产品的在线推广；&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;2、做好每天的推广统计，定制有效的投放策略并执行；&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;3、完成每天的业绩要求，只要你努力，月入过万不是梦&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;职位要求：&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;1学历不限，欢迎优秀应届生（优秀者可放宽）；男女不限，19~24岁&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;2.亲和力强、沟通流畅、重点突出；&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;3.个性开朗、反应敏捷，有较强的服务意识和责任心；&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;4.能熟练运用QQ及微信聊天软件，懂得电脑的基本操作，打字速度不限&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;我们期待怀揣梦想的你加入我们！&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;5、有经验者优先考虑！！！！！&lt;/p&gt;');
INSERT INTO `ey_recruit_content` VALUES ('2', '83', '1563528292', '1563528292', '广州市', '中专以上学历', '5000-8000元', '全职', '2年以上', '2位', '&lt;p&gt;&lt;span style=&quot;color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255);&quot;&gt;岗位职责：&lt;/span&gt;&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;&lt;span style=&quot;color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255);&quot;&gt;1、负责网站相关栏目、信息的搜集、编辑、发布等工作。&lt;/span&gt;&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;&lt;span style=&quot;color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255);&quot;&gt;2、完成信息内容的策划和日常信息的更新与维护。&lt;/span&gt;&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;&lt;span style=&quot;color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255);&quot;&gt;3、编写网站宣传资料及相关产品信息。&lt;/span&gt;&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;&lt;span style=&quot;color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255);&quot;&gt;4、配合部门编辑策划推广活动。&lt;/span&gt;&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;&lt;span style=&quot;color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255);&quot;&gt;5、部门总监下发的其他任务。&lt;/span&gt;&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;&lt;span style=&quot;color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255);&quot;&gt;任职资格：&lt;/span&gt;&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;&lt;span style=&quot;color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255);&quot;&gt;1、编辑、新闻、中文等相关专业优先，大专及以上学历。&lt;/span&gt;&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;&lt;span style=&quot;color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255);&quot;&gt;2、有编辑或从事相关工作经验优先。&lt;/span&gt;&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;&lt;span style=&quot;color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255);&quot;&gt;3、熟练使用网页制作软件和网络搜索工具，了解网站运行、维护相关知识。&lt;/span&gt;&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;&lt;span style=&quot;color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255);&quot;&gt;4、良好的文字功底，信息采编能力。&lt;/span&gt;&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;&lt;span style=&quot;color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255);&quot;&gt;5、欢迎应届毕业生来应聘。&lt;/span&gt;&lt;/p&gt;');
INSERT INTO `ey_recruit_content` VALUES ('3', '94', '1565225547', '1565225547', '广州市', '专科以上学历', '5000-8000元', '全职', '2年以上', '若干', '&lt;p&gt;1、负责客户开发、提供客户服务、公司服务的推广、建立与维护客户关系；&lt;/p&gt;&lt;p&gt;2、根据市场营销计划和个人销售目标，完成各阶段销售目标；&lt;/p&gt;&lt;p&gt;3、进行市场调研，确定目标市场，收集分析竞争对象信息，制订、执行销售对策；&lt;/p&gt;&lt;p&gt;4、与内部相关部门建立并维持良好的协作关系，以客户和市场为导向，协调各方面关系，确保合同的顺利执行。&lt;/p&gt;&lt;p&gt;【岗位要求】&lt;/p&gt;&lt;p&gt;1、专科学历，有一定客户服务工作经验或销售经验，有一定的客户服务知识和能力。&lt;/p&gt;&lt;p&gt;2、计算机操作熟练，office办公软件使用熟练，有一定的网络基础知识，熟练使用Photoshop等制图工具着优先考虑。&lt;/p&gt;&lt;p&gt;3、要求一定要有“客户优先”的服务精神，一切从帮助客户、满足客户角度出发。&lt;/p&gt;&lt;p&gt;4、性格要求沉稳、隐忍，善于倾听，有同理心，乐观、积极。普通话标准、流利，反应灵敏。&lt;/p&gt;&lt;p&gt;5、热爱工作，敬业、勤恳、乐于思考，具有自我发展的主观的主题愿望和自我学习能力。可适当加班者优先。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ey_recruit_content` VALUES ('4', '95', '1565225608', '1565225608', '广州市', '专科以上学历', '5000-10000元', '全职', '2年以上', '若干', '&lt;p&gt;岗位职责：1、利用网络进行公司产品的销售及推广2、了解网络销售，有信心和良好的学习能力3、完成团队目标4、通过网络进行渠道开发和业务拓展5、熟悉互联网络，熟练使用网络交流工具和各种办公软件6、有较强的沟通能力&lt;/p&gt;&lt;p&gt;任职要求：1、年龄18～25之间，有空杯心态者优先2、性格开朗，喜欢与人沟通，表达流畅，普通话标准3、具备一定的客户服务精神，准确把握客户需求4、认真细致，能接受挑战性任务5、有无销售经验均可，欢迎应届毕业生应聘&lt;/p&gt;&lt;p&gt;薪资待遇：底薪+高抽成+奖金+年底双薪+生日聚餐，不定期的聚会和旅游等&lt;/p&gt;&lt;p&gt;晋升空间：业务基础—精英业务员—销售组长—销售主管—核心主管&lt;/p&gt;&lt;p&gt;销售激励：礼品奖励、现金奖金、出单奖励、周业绩奖励、月销售前三奖励。依法享受法定节假日（带薪旅游、带薪年假、婚假。、产假、员工生日庆祝）&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ey_recruit_content` VALUES ('5', '96', '1565225638', '1565225638', '广州市', '专科以上学历', '5000-10000元', '全职', '2年以上', '若干', '&lt;p&gt;任职要求： 1、年龄25-35岁，本科及以上学历，网络安全相关专业，持网络安全证书，2年以上同岗位工作经验； 2、熟知防火墙、入侵检测、网络流量识别控制等信息安全产品相关技术；熟悉网络协议、网络编程及相关网络产品开发技术； 3、具备良好的安全意识能力、语言表达能力、逻辑思维能力、执行力、责任心、团队协作能力。 岗位职责： 1、安全设备的日常监控与维护，及时进行安全设备策略的变更与调整；安全运维的结果文档、技术资料、设备日志，配置信息等相关资料的管理及维护； 2、定期关注安全设备系统的升级补丁，合适准确性后及时更新补丁，完成安全设备系统升级； 3、安全设备的健康检查、健康检查表、基线统计、流量统计、特殊事件报告、日报、周报等日常工作； 4、参与信息安全事件的分析工作和应急处理工作；定期安全评估、扫描和加固，协助进行安全加固； 5、协助制定网络安全规范与方案，优化现有网络安全架构，定期评估网络安全风险，负责针对运行故障、安全事件开展分析和总结，定期开展运行维护、故障处理及安全事件分析； 6、完成上级领导交办的其他任务，并做好与其他部门的协调配合工作。&lt;/p&gt;');
INSERT INTO `ey_recruit_content` VALUES ('6', '97', '1565225697', '1565225697', '广州市', '专科以上学历', '5000-8000元', '全职', '1年以上', '2位', '&lt;p&gt;岗位职责1、组织参与重要项目的创意构思、文案及客户提案, 给予前期提案、设计创意说明及后期结案报告等服务；2、执行并监督所负责项目的创意构思和文案；3、稿件思路清晰，能够完成稿件写作思路规划；4、协助领导进行创意提案，保证工作的顺利推进；5、独立撰写各类稿件（新闻稿、综述稿、评论稿、专访稿等）、策划方案、报告等任职资格1、大专及以上学历；2、一年以上市场策划及文案工作经验；3、能够准确捕捉产品亮点，具备恰如其分的文字表现能力；4、熟悉专业创意方法，思维敏捷，洞察力强，文字功底扎实，语言表达能力强；福利待遇：1.公司为员工提供以市场标杆，以能力、绩效为标准，具有市场竞争力的薪资待遇；2.为员工缴纳社会保险和办理住房公积金、带薪年假、法定节假日、小暑假；3.员工享有专业持续的提升培训机制、不定期的拓展福利、稳健的晋升机制；4.生日福利、传统节日福利、年终奖、年终分红等多种特色福利；试用期工资3500职能类别：网站&lt;/p&gt;');

-- -----------------------------
-- Table structure for `ey_region`
-- -----------------------------
DROP TABLE IF EXISTS `ey_region`;
CREATE TABLE `ey_region` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `name` varchar(32) DEFAULT '' COMMENT '地区名称',
  `level` tinyint(4) DEFAULT '0' COMMENT '地区等级 分省市县区',
  `parent_id` int(10) DEFAULT '0' COMMENT '父id',
  `initial` varchar(5) DEFAULT '' COMMENT '首字母',
  PRIMARY KEY (`id`),
  KEY `parent_id` (`parent_id`) USING BTREE,
  KEY `level` (`level`) USING BTREE,
  KEY `initial` (`initial`)
) ENGINE=MyISAM AUTO_INCREMENT=47967 DEFAULT CHARSET=utf8 COMMENT='区域表';

-- -----------------------------
-- Records of `ey_region`
-- -----------------------------
INSERT INTO `ey_region` VALUES ('1', '北京市', '1', '0', 'B');
INSERT INTO `ey_region` VALUES ('2', '北京市', '2', '1', 'B');
INSERT INTO `ey_region` VALUES ('3', '东城区', '3', '2', 'D');
INSERT INTO `ey_region` VALUES ('14', '西城区', '3', '2', 'X');
INSERT INTO `ey_region` VALUES ('22', '崇文区', '3', '2', 'C');
INSERT INTO `ey_region` VALUES ('30', '宣武区', '3', '2', 'X');
INSERT INTO `ey_region` VALUES ('39', '朝阳区', '3', '2', 'C');
INSERT INTO `ey_region` VALUES ('83', '丰台区', '3', '2', 'F');
INSERT INTO `ey_region` VALUES ('105', '石景山区', '3', '2', 'S');
INSERT INTO `ey_region` VALUES ('115', '海淀区', '3', '2', 'H');
INSERT INTO `ey_region` VALUES ('145', '门头沟区', '3', '2', 'M');
INSERT INTO `ey_region` VALUES ('159', '房山区', '3', '2', 'F');
INSERT INTO `ey_region` VALUES ('188', '通州区', '3', '2', 'T');
INSERT INTO `ey_region` VALUES ('204', '顺义区', '3', '2', 'S');
INSERT INTO `ey_region` VALUES ('227', '昌平区', '3', '2', 'C');
INSERT INTO `ey_region` VALUES ('245', '大兴区', '3', '2', 'D');
INSERT INTO `ey_region` VALUES ('264', '怀柔区', '3', '2', 'H');
INSERT INTO `ey_region` VALUES ('281', '平谷区', '3', '2', 'P');
INSERT INTO `ey_region` VALUES ('301', '密云区', '3', '2', 'M');
INSERT INTO `ey_region` VALUES ('322', '延庆区', '3', '2', 'Y');
INSERT INTO `ey_region` VALUES ('338', '天津市', '1', '0', 'T');
INSERT INTO `ey_region` VALUES ('339', '天津市', '2', '338', 'T');
INSERT INTO `ey_region` VALUES ('340', '和平区', '3', '339', 'H');
INSERT INTO `ey_region` VALUES ('347', '河东区', '3', '339', 'H');
INSERT INTO `ey_region` VALUES ('361', '河西区', '3', '339', 'H');
INSERT INTO `ey_region` VALUES ('375', '南开区', '3', '339', 'N');
INSERT INTO `ey_region` VALUES ('388', '河北区', '3', '339', 'H');
INSERT INTO `ey_region` VALUES ('399', '红桥区', '3', '339', 'H');
INSERT INTO `ey_region` VALUES ('410', '塘沽区', '3', '339', 'T');
INSERT INTO `ey_region` VALUES ('425', '汉沽区', '3', '339', 'H');
INSERT INTO `ey_region` VALUES ('435', '大港区', '3', '339', 'D');
INSERT INTO `ey_region` VALUES ('445', '东丽区', '3', '339', 'D');
INSERT INTO `ey_region` VALUES ('460', '西青区', '3', '339', 'X');
INSERT INTO `ey_region` VALUES ('473', '津南区', '3', '339', 'J');
INSERT INTO `ey_region` VALUES ('488', '北辰区', '3', '339', 'B');
INSERT INTO `ey_region` VALUES ('504', '武清区', '3', '339', 'W');
INSERT INTO `ey_region` VALUES ('538', '宝坻区', '3', '339', 'B');
INSERT INTO `ey_region` VALUES ('570', '宁河区', '3', '339', 'N');
INSERT INTO `ey_region` VALUES ('586', '静海区', '3', '339', 'J');
INSERT INTO `ey_region` VALUES ('608', '蓟州区', '3', '339', 'J');
INSERT INTO `ey_region` VALUES ('636', '河北省', '1', '0', 'H');
INSERT INTO `ey_region` VALUES ('637', '石家庄市', '2', '636', 'S');
INSERT INTO `ey_region` VALUES ('638', '市辖区', '3', '637', 'S');
INSERT INTO `ey_region` VALUES ('639', '长安区', '3', '637', 'C');
INSERT INTO `ey_region` VALUES ('651', '桥东区', '3', '637', 'Q');
INSERT INTO `ey_region` VALUES ('662', '桥西区', '3', '637', 'Q');
INSERT INTO `ey_region` VALUES ('675', '新华区', '3', '637', 'X');
INSERT INTO `ey_region` VALUES ('691', '井陉矿区', '3', '637', 'J');
INSERT INTO `ey_region` VALUES ('697', '裕华区', '3', '637', 'Y');
INSERT INTO `ey_region` VALUES ('708', '井陉县', '3', '637', 'J');
INSERT INTO `ey_region` VALUES ('726', '正定县', '3', '637', 'Z');
INSERT INTO `ey_region` VALUES ('736', '栾城县', '3', '637', 'L');
INSERT INTO `ey_region` VALUES ('745', '行唐县', '3', '637', 'X');
INSERT INTO `ey_region` VALUES ('761', '灵寿县', '3', '637', 'L');
INSERT INTO `ey_region` VALUES ('777', '高邑县', '3', '637', 'G');
INSERT INTO `ey_region` VALUES ('783', '深泽县', '3', '637', 'S');
INSERT INTO `ey_region` VALUES ('790', '赞皇县', '3', '637', 'Z');
INSERT INTO `ey_region` VALUES ('802', '无极县', '3', '637', 'W');
INSERT INTO `ey_region` VALUES ('814', '平山县', '3', '637', 'P');
INSERT INTO `ey_region` VALUES ('838', '元氏县', '3', '637', 'Y');
INSERT INTO `ey_region` VALUES ('854', '赵县', '3', '637', 'Z');
INSERT INTO `ey_region` VALUES ('866', '辛集市', '3', '637', 'X');
INSERT INTO `ey_region` VALUES ('882', '藁城市', '3', '637', 'G');
INSERT INTO `ey_region` VALUES ('898', '晋州市', '3', '637', 'J');
INSERT INTO `ey_region` VALUES ('909', '新乐市', '3', '637', 'X');
INSERT INTO `ey_region` VALUES ('922', '鹿泉市', '3', '637', 'L');
INSERT INTO `ey_region` VALUES ('936', '唐山市', '2', '636', 'T');
INSERT INTO `ey_region` VALUES ('937', '市辖区', '3', '936', 'S');
INSERT INTO `ey_region` VALUES ('938', '路南区', '3', '936', 'L');
INSERT INTO `ey_region` VALUES ('952', '路北区', '3', '936', 'L');
INSERT INTO `ey_region` VALUES ('965', '古冶区', '3', '936', 'G');
INSERT INTO `ey_region` VALUES ('977', '开平区', '3', '936', 'K');
INSERT INTO `ey_region` VALUES ('989', '丰南区', '3', '936', 'F');
INSERT INTO `ey_region` VALUES ('1007', '丰润区', '3', '936', 'F');
INSERT INTO `ey_region` VALUES ('1034', '滦县', '3', '936', 'L');
INSERT INTO `ey_region` VALUES ('1048', '滦南县', '3', '936', 'L');
INSERT INTO `ey_region` VALUES ('1067', '乐亭县', '3', '936', 'L');
INSERT INTO `ey_region` VALUES ('1085', '迁西县', '3', '936', 'Q');
INSERT INTO `ey_region` VALUES ('1104', '玉田县', '3', '936', 'Y');
INSERT INTO `ey_region` VALUES ('1125', '唐海县', '3', '936', 'T');
INSERT INTO `ey_region` VALUES ('1140', '遵化市', '3', '936', 'Z');
INSERT INTO `ey_region` VALUES ('1168', '迁安市', '3', '936', 'Q');
INSERT INTO `ey_region` VALUES ('1188', '秦皇岛市', '2', '636', 'Q');
INSERT INTO `ey_region` VALUES ('1189', '市辖区', '3', '1188', 'S');
INSERT INTO `ey_region` VALUES ('1190', '海港区', '3', '1188', 'H');
INSERT INTO `ey_region` VALUES ('1208', '山海关区', '3', '1188', 'S');
INSERT INTO `ey_region` VALUES ('1218', '北戴河区', '3', '1188', 'B');
INSERT INTO `ey_region` VALUES ('1223', '青龙县', '3', '1188', 'Q');
INSERT INTO `ey_region` VALUES ('1249', '昌黎县', '3', '1188', 'C');
INSERT INTO `ey_region` VALUES ('1266', '抚宁县', '3', '1188', 'F');
INSERT INTO `ey_region` VALUES ('1278', '卢龙县', '3', '1188', 'L');
INSERT INTO `ey_region` VALUES ('1291', '邯郸市', '2', '636', 'H');
INSERT INTO `ey_region` VALUES ('1292', '市辖区', '3', '1291', 'S');
INSERT INTO `ey_region` VALUES ('1293', '邯山区', '3', '1291', 'H');
INSERT INTO `ey_region` VALUES ('1307', '丛台区', '3', '1291', 'C');
INSERT INTO `ey_region` VALUES ('1319', '复兴区', '3', '1291', 'F');
INSERT INTO `ey_region` VALUES ('1329', '峰峰矿区', '3', '1291', 'F');
INSERT INTO `ey_region` VALUES ('1339', '邯郸县', '3', '1291', 'H');
INSERT INTO `ey_region` VALUES ('1350', '临漳县', '3', '1291', 'L');
INSERT INTO `ey_region` VALUES ('1365', '成安县', '3', '1291', 'C');
INSERT INTO `ey_region` VALUES ('1375', '大名县', '3', '1291', 'D');
INSERT INTO `ey_region` VALUES ('1396', '涉县', '3', '1291', 'S');
INSERT INTO `ey_region` VALUES ('1414', '磁县', '3', '1291', 'C');
INSERT INTO `ey_region` VALUES ('1434', '肥乡县', '3', '1291', 'F');
INSERT INTO `ey_region` VALUES ('1444', '永年县', '3', '1291', 'Y');
INSERT INTO `ey_region` VALUES ('1465', '邱县', '3', '1291', 'Q');
INSERT INTO `ey_region` VALUES ('1473', '鸡泽县', '3', '1291', 'J');
INSERT INTO `ey_region` VALUES ('1481', '广平县', '3', '1291', 'G');
INSERT INTO `ey_region` VALUES ('1489', '馆陶县', '3', '1291', 'G');
INSERT INTO `ey_region` VALUES ('1498', '魏县', '3', '1291', 'W');
INSERT INTO `ey_region` VALUES ('1520', '曲周县', '3', '1291', 'Q');
INSERT INTO `ey_region` VALUES ('1531', '武安市', '3', '1291', 'W');
INSERT INTO `ey_region` VALUES ('1554', '邢台市', '2', '636', 'X');
INSERT INTO `ey_region` VALUES ('1555', '市辖区', '3', '1554', 'S');
INSERT INTO `ey_region` VALUES ('1556', '桥东区', '3', '1554', 'Q');
INSERT INTO `ey_region` VALUES ('1564', '桥西区', '3', '1554', 'Q');
INSERT INTO `ey_region` VALUES ('1572', '邢台县', '3', '1554', 'X');
INSERT INTO `ey_region` VALUES ('1593', '临城县', '3', '1554', 'L');
INSERT INTO `ey_region` VALUES ('1602', '内邱县', '3', '1554', 'N');
INSERT INTO `ey_region` VALUES ('1612', '柏乡县', '3', '1554', 'B');
INSERT INTO `ey_region` VALUES ('1619', '隆尧县', '3', '1554', 'L');
INSERT INTO `ey_region` VALUES ('1633', '任县', '3', '1554', 'R');
INSERT INTO `ey_region` VALUES ('1642', '南和县', '3', '1554', 'N');
INSERT INTO `ey_region` VALUES ('1651', '宁晋县', '3', '1554', 'N');
INSERT INTO `ey_region` VALUES ('1669', '巨鹿县', '3', '1554', 'J');
INSERT INTO `ey_region` VALUES ('1680', '新河县', '3', '1554', 'X');
INSERT INTO `ey_region` VALUES ('1687', '广宗县', '3', '1554', 'G');
INSERT INTO `ey_region` VALUES ('1696', '平乡县', '3', '1554', 'P');
INSERT INTO `ey_region` VALUES ('1704', '威县', '3', '1554', 'W');
INSERT INTO `ey_region` VALUES ('1721', '清河县', '3', '1554', 'Q');
INSERT INTO `ey_region` VALUES ('1728', '临西县', '3', '1554', 'L');
INSERT INTO `ey_region` VALUES ('1738', '南宫市', '3', '1554', 'N');
INSERT INTO `ey_region` VALUES ('1754', '沙河市', '3', '1554', 'S');
INSERT INTO `ey_region` VALUES ('1772', '保定市', '2', '636', 'B');
INSERT INTO `ey_region` VALUES ('1773', '市辖区', '3', '1772', 'S');
INSERT INTO `ey_region` VALUES ('1774', '新市区', '3', '1772', 'X');
INSERT INTO `ey_region` VALUES ('1787', '北市区', '3', '1772', 'B');
INSERT INTO `ey_region` VALUES ('1796', '南市区', '3', '1772', 'N');
INSERT INTO `ey_region` VALUES ('1806', '满城区', '3', '1772', 'M');
INSERT INTO `ey_region` VALUES ('1820', '清苑区', '3', '1772', 'Q');
INSERT INTO `ey_region` VALUES ('1839', '涞水县', '3', '1772', 'L');
INSERT INTO `ey_region` VALUES ('1856', '阜平县', '3', '1772', 'F');
INSERT INTO `ey_region` VALUES ('1870', '徐水区', '3', '1772', 'X');
INSERT INTO `ey_region` VALUES ('1885', '定兴县', '3', '1772', 'D');
INSERT INTO `ey_region` VALUES ('1902', '唐县', '3', '1772', 'T');
INSERT INTO `ey_region` VALUES ('1923', '高阳县', '3', '1772', 'G');
INSERT INTO `ey_region` VALUES ('1933', '容城县', '3', '1772', 'R');
INSERT INTO `ey_region` VALUES ('1942', '涞源县', '3', '1772', 'L');
INSERT INTO `ey_region` VALUES ('1960', '望都县', '3', '1772', 'W');
INSERT INTO `ey_region` VALUES ('1969', '安新县', '3', '1772', 'A');
INSERT INTO `ey_region` VALUES ('1982', '易县', '3', '1772', 'Y');
INSERT INTO `ey_region` VALUES ('2010', '曲阳县', '3', '1772', 'Q');
INSERT INTO `ey_region` VALUES ('2029', '蠡县', '3', '1772', 'L');
INSERT INTO `ey_region` VALUES ('2043', '顺平县', '3', '1772', 'S');
INSERT INTO `ey_region` VALUES ('2054', '博野县', '3', '1772', 'B');
INSERT INTO `ey_region` VALUES ('2062', '雄县', '3', '1772', 'X');
INSERT INTO `ey_region` VALUES ('2072', '涿州市', '3', '1772', 'Z');
INSERT INTO `ey_region` VALUES ('2088', '定州市', '3', '1772', 'D');
INSERT INTO `ey_region` VALUES ('2114', '安国市', '3', '1772', 'A');
INSERT INTO `ey_region` VALUES ('2126', '高碑店市', '3', '1772', 'G');
INSERT INTO `ey_region` VALUES ('2142', '张家口市', '2', '636', 'Z');
INSERT INTO `ey_region` VALUES ('2143', '市辖区', '3', '2142', 'S');
INSERT INTO `ey_region` VALUES ('2144', '桥东区', '3', '2142', 'Q');
INSERT INTO `ey_region` VALUES ('2154', '桥西区', '3', '2142', 'Q');
INSERT INTO `ey_region` VALUES ('2164', '宣化区', '3', '2142', 'X');
INSERT INTO `ey_region` VALUES ('2176', '下花园区', '3', '2142', 'X');
INSERT INTO `ey_region` VALUES ('2183', '宣化县', '3', '2142', 'X');
INSERT INTO `ey_region` VALUES ('2198', '张北县', '3', '2142', 'Z');
INSERT INTO `ey_region` VALUES ('2220', '康保县', '3', '2142', 'K');
INSERT INTO `ey_region` VALUES ('2237', '沽源县', '3', '2142', 'G');
INSERT INTO `ey_region` VALUES ('2256', '尚义县', '3', '2142', 'S');
INSERT INTO `ey_region` VALUES ('2271', '蔚县', '3', '2142', 'W');
INSERT INTO `ey_region` VALUES ('2294', '阳原县', '3', '2142', 'Y');
INSERT INTO `ey_region` VALUES ('2309', '怀安县', '3', '2142', 'H');
INSERT INTO `ey_region` VALUES ('2321', '万全县', '3', '2142', 'W');
INSERT INTO `ey_region` VALUES ('2333', '怀来县', '3', '2142', 'H');
INSERT INTO `ey_region` VALUES ('2351', '涿鹿县', '3', '2142', 'Z');
INSERT INTO `ey_region` VALUES ('2369', '赤城县', '3', '2142', 'C');
INSERT INTO `ey_region` VALUES ('2388', '崇礼县', '3', '2142', 'C');
INSERT INTO `ey_region` VALUES ('2400', '承德市', '2', '636', 'C');
INSERT INTO `ey_region` VALUES ('2401', '市辖区', '3', '2400', 'S');
INSERT INTO `ey_region` VALUES ('2402', '双桥区', '3', '2400', 'S');
INSERT INTO `ey_region` VALUES ('2415', '双滦区', '3', '2400', 'S');
INSERT INTO `ey_region` VALUES ('2422', '鹰手营子矿区', '3', '2400', 'Y');
INSERT INTO `ey_region` VALUES ('2427', '承德县', '3', '2400', 'C');
INSERT INTO `ey_region` VALUES ('2453', '兴隆县', '3', '2400', 'X');
INSERT INTO `ey_region` VALUES ('2474', '平泉县', '3', '2400', 'P');
INSERT INTO `ey_region` VALUES ('2494', '滦平县', '3', '2400', 'L');
INSERT INTO `ey_region` VALUES ('2517', '隆化县', '3', '2400', 'L');
INSERT INTO `ey_region` VALUES ('2543', '丰宁县', '3', '2400', 'F');
INSERT INTO `ey_region` VALUES ('2570', '宽城县', '3', '2400', 'K');
INSERT INTO `ey_region` VALUES ('2589', '围场县', '3', '2400', 'W');
INSERT INTO `ey_region` VALUES ('2629', '沧州市', '2', '636', 'C');
INSERT INTO `ey_region` VALUES ('2630', '市辖区', '3', '2629', 'S');
INSERT INTO `ey_region` VALUES ('2631', '新华区', '3', '2629', 'X');
INSERT INTO `ey_region` VALUES ('2639', '运河区', '3', '2629', 'Y');
INSERT INTO `ey_region` VALUES ('2648', '沧县', '3', '2629', 'C');
INSERT INTO `ey_region` VALUES ('2668', '青县', '3', '2629', 'Q');
INSERT INTO `ey_region` VALUES ('2680', '东光县', '3', '2629', 'D');
INSERT INTO `ey_region` VALUES ('2690', '海兴县', '3', '2629', 'H');
INSERT INTO `ey_region` VALUES ('2701', '盐山县', '3', '2629', 'Y');
INSERT INTO `ey_region` VALUES ('2714', '肃宁县', '3', '2629', 'S');
INSERT INTO `ey_region` VALUES ('2724', '南皮县', '3', '2629', 'N');
INSERT INTO `ey_region` VALUES ('2734', '吴桥县', '3', '2629', 'W');
INSERT INTO `ey_region` VALUES ('2745', '献县', '3', '2629', 'X');
INSERT INTO `ey_region` VALUES ('2765', '孟村县', '3', '2629', 'M');
INSERT INTO `ey_region` VALUES ('2772', '泊头市', '3', '2629', 'B');
INSERT INTO `ey_region` VALUES ('2788', '任邱市', '3', '2629', 'R');
INSERT INTO `ey_region` VALUES ('2809', '黄骅市', '3', '2629', 'H');
INSERT INTO `ey_region` VALUES ('2828', '河间市', '3', '2629', 'H');
INSERT INTO `ey_region` VALUES ('2849', '廊坊市', '2', '636', 'L');
INSERT INTO `ey_region` VALUES ('2850', '市辖区', '3', '2849', 'S');
INSERT INTO `ey_region` VALUES ('2851', '安次区', '3', '2849', 'A');
INSERT INTO `ey_region` VALUES ('2862', '广阳区', '3', '2849', 'G');
INSERT INTO `ey_region` VALUES ('2873', '固安县', '3', '2849', 'G');
INSERT INTO `ey_region` VALUES ('2883', '永清县', '3', '2849', 'Y');
INSERT INTO `ey_region` VALUES ('2895', '香河县', '3', '2849', 'X');
INSERT INTO `ey_region` VALUES ('2906', '大城县', '3', '2849', 'D');
INSERT INTO `ey_region` VALUES ('2918', '文安县', '3', '2849', 'W');
INSERT INTO `ey_region` VALUES ('2932', '大厂县', '3', '2849', 'D');
INSERT INTO `ey_region` VALUES ('2939', '霸州市', '3', '2849', 'B');
INSERT INTO `ey_region` VALUES ('2953', '三河市', '3', '2849', 'S');
INSERT INTO `ey_region` VALUES ('2968', '衡水市', '2', '636', 'H');
INSERT INTO `ey_region` VALUES ('2969', '市辖区', '3', '2968', 'S');
INSERT INTO `ey_region` VALUES ('2970', '桃城区', '3', '2968', 'T');
INSERT INTO `ey_region` VALUES ('2983', '枣强县', '3', '2968', 'Z');
INSERT INTO `ey_region` VALUES ('2995', '武邑县', '3', '2968', 'W');
INSERT INTO `ey_region` VALUES ('3005', '武强县', '3', '2968', 'W');
INSERT INTO `ey_region` VALUES ('3012', '饶阳县', '3', '2968', 'R');
INSERT INTO `ey_region` VALUES ('3020', '安平县', '3', '2968', 'A');
INSERT INTO `ey_region` VALUES ('3029', '故城县', '3', '2968', 'G');
INSERT INTO `ey_region` VALUES ('3043', '景县', '3', '2968', 'J');
INSERT INTO `ey_region` VALUES ('3060', '阜城县', '3', '2968', 'F');
INSERT INTO `ey_region` VALUES ('3071', '冀州市', '3', '2968', 'J');
INSERT INTO `ey_region` VALUES ('3083', '深州市', '3', '2968', 'S');
INSERT INTO `ey_region` VALUES ('3102', '山西省', '1', '0', 'S');
INSERT INTO `ey_region` VALUES ('3103', '太原市', '2', '3102', 'T');
INSERT INTO `ey_region` VALUES ('3104', '市辖区', '3', '3103', 'S');
INSERT INTO `ey_region` VALUES ('3105', '小店区(人口含高新经济区)', '3', '3103', 'X');
INSERT INTO `ey_region` VALUES ('3117', '迎泽区', '3', '3103', 'Y');
INSERT INTO `ey_region` VALUES ('3126', '杏花岭区', '3', '3103', 'X');
INSERT INTO `ey_region` VALUES ('3140', '尖草坪区', '3', '3103', 'J');
INSERT INTO `ey_region` VALUES ('3155', '万柏林区', '3', '3103', 'W');
INSERT INTO `ey_region` VALUES ('3171', '晋源区', '3', '3103', 'J');
INSERT INTO `ey_region` VALUES ('3178', '清徐县', '3', '3103', 'Q');
INSERT INTO `ey_region` VALUES ('3188', '阳曲县', '3', '3103', 'Y');
INSERT INTO `ey_region` VALUES ('3200', '娄烦县', '3', '3103', 'L');
INSERT INTO `ey_region` VALUES ('3209', '古交市', '3', '3103', 'G');
INSERT INTO `ey_region` VALUES ('3224', '大同市', '2', '3102', 'D');
INSERT INTO `ey_region` VALUES ('3225', '市辖区', '3', '3224', 'S');
INSERT INTO `ey_region` VALUES ('3226', '大同市城区', '3', '3224', 'D');
INSERT INTO `ey_region` VALUES ('3241', '矿区', '3', '3224', 'K');
INSERT INTO `ey_region` VALUES ('3266', '南郊区', '3', '3224', 'N');
INSERT INTO `ey_region` VALUES ('3277', '新荣区', '3', '3224', 'X');
INSERT INTO `ey_region` VALUES ('3286', '阳高县', '3', '3224', 'Y');
INSERT INTO `ey_region` VALUES ('3300', '天镇县', '3', '3224', 'T');
INSERT INTO `ey_region` VALUES ('3312', '广灵县', '3', '3224', 'G');
INSERT INTO `ey_region` VALUES ('3322', '灵丘县', '3', '3224', 'L');
INSERT INTO `ey_region` VALUES ('3335', '浑源县', '3', '3224', 'H');
INSERT INTO `ey_region` VALUES ('3354', '左云县', '3', '3224', 'Z');
INSERT INTO `ey_region` VALUES ('3364', '大同县', '3', '3224', 'D');
INSERT INTO `ey_region` VALUES ('3379', '阳泉市', '2', '3102', 'Y');
INSERT INTO `ey_region` VALUES ('3380', '市辖区', '3', '3379', 'S');
INSERT INTO `ey_region` VALUES ('3381', '城区', '3', '3379', 'C');
INSERT INTO `ey_region` VALUES ('3388', '矿区', '3', '3379', 'K');
INSERT INTO `ey_region` VALUES ('3395', '郊区', '3', '3379', 'J');
INSERT INTO `ey_region` VALUES ('3405', '平定县', '3', '3379', 'P');
INSERT INTO `ey_region` VALUES ('3416', '盂县', '3', '3379', 'Y');
INSERT INTO `ey_region` VALUES ('3431', '长治市', '2', '3102', 'C');
INSERT INTO `ey_region` VALUES ('3432', '市辖区', '3', '3431', 'S');
INSERT INTO `ey_region` VALUES ('3433', '长治市城区', '3', '3431', 'C');
INSERT INTO `ey_region` VALUES ('3445', '长治市郊区', '3', '3431', 'C');
INSERT INTO `ey_region` VALUES ('3454', '长治县', '3', '3431', 'C');
INSERT INTO `ey_region` VALUES ('3466', '襄垣县', '3', '3431', 'X');
INSERT INTO `ey_region` VALUES ('3478', '屯留县', '3', '3431', 'T');
INSERT INTO `ey_region` VALUES ('3493', '平顺县', '3', '3431', 'P');
INSERT INTO `ey_region` VALUES ('3506', '黎城县', '3', '3431', 'L');
INSERT INTO `ey_region` VALUES ('3516', '壶关县', '3', '3431', 'H');
INSERT INTO `ey_region` VALUES ('3530', '长子县', '3', '3431', 'C');
INSERT INTO `ey_region` VALUES ('3543', '武乡县', '3', '3431', 'W');
INSERT INTO `ey_region` VALUES ('3558', '沁县', '3', '3431', 'Q');
INSERT INTO `ey_region` VALUES ('3572', '沁源县', '3', '3431', 'Q');
INSERT INTO `ey_region` VALUES ('3587', '潞城市', '3', '3431', 'L');
INSERT INTO `ey_region` VALUES ('3597', '晋城市', '2', '3102', 'J');
INSERT INTO `ey_region` VALUES ('3598', '市辖区', '3', '3597', 'S');
INSERT INTO `ey_region` VALUES ('3599', '晋城市城区', '3', '3597', 'J');
INSERT INTO `ey_region` VALUES ('3608', '沁水县', '3', '3597', 'Q');
INSERT INTO `ey_region` VALUES ('3623', '阳城县', '3', '3597', 'Y');
INSERT INTO `ey_region` VALUES ('3642', '陵川县', '3', '3597', 'L');
INSERT INTO `ey_region` VALUES ('3655', '泽州县', '3', '3597', 'Z');
INSERT INTO `ey_region` VALUES ('3673', '高平市', '3', '3597', 'G');
INSERT INTO `ey_region` VALUES ('3690', '朔州市', '2', '3102', 'S');
INSERT INTO `ey_region` VALUES ('3691', '市辖区', '3', '3690', 'S');
INSERT INTO `ey_region` VALUES ('3692', '朔城区', '3', '3690', 'S');
INSERT INTO `ey_region` VALUES ('3709', '平鲁区', '3', '3690', 'P');
INSERT INTO `ey_region` VALUES ('3723', '山阴县', '3', '3690', 'S');
INSERT INTO `ey_region` VALUES ('3739', '应县', '3', '3690', 'Y');
INSERT INTO `ey_region` VALUES ('3752', '右玉县', '3', '3690', 'Y');
INSERT INTO `ey_region` VALUES ('3763', '怀仁县', '3', '3690', 'H');
INSERT INTO `ey_region` VALUES ('3776', '晋中市', '2', '3102', 'J');
INSERT INTO `ey_region` VALUES ('3777', '市辖区', '3', '3776', 'S');
INSERT INTO `ey_region` VALUES ('3778', '榆次区', '3', '3776', 'Y');
INSERT INTO `ey_region` VALUES ('3799', '榆社县', '3', '3776', 'Y');
INSERT INTO `ey_region` VALUES ('3810', '左权县', '3', '3776', 'Z');
INSERT INTO `ey_region` VALUES ('3822', '和顺县', '3', '3776', 'H');
INSERT INTO `ey_region` VALUES ('3833', '昔阳县', '3', '3776', 'X');
INSERT INTO `ey_region` VALUES ('3846', '寿阳县', '3', '3776', 'S');
INSERT INTO `ey_region` VALUES ('3861', '太谷县', '3', '3776', 'T');
INSERT INTO `ey_region` VALUES ('3871', '祁县', '3', '3776', 'Q');
INSERT INTO `ey_region` VALUES ('3880', '平遥县', '3', '3776', 'P');
INSERT INTO `ey_region` VALUES ('3895', '灵石县', '3', '3776', 'L');
INSERT INTO `ey_region` VALUES ('3908', '介休市', '3', '3776', 'J');
INSERT INTO `ey_region` VALUES ('3925', '运城市', '2', '3102', 'Y');
INSERT INTO `ey_region` VALUES ('3926', '市辖区', '3', '3925', 'S');
INSERT INTO `ey_region` VALUES ('3927', '盐湖区', '3', '3925', 'Y');
INSERT INTO `ey_region` VALUES ('3950', '临猗县', '3', '3925', 'L');
INSERT INTO `ey_region` VALUES ('3967', '万荣县', '3', '3925', 'W');
INSERT INTO `ey_region` VALUES ('3982', '闻喜县', '3', '3925', 'W');
INSERT INTO `ey_region` VALUES ('3996', '稷山县', '3', '3925', 'J');
INSERT INTO `ey_region` VALUES ('4004', '新绛县', '3', '3925', 'X');
INSERT INTO `ey_region` VALUES ('4013', '绛县', '3', '3925', 'J');
INSERT INTO `ey_region` VALUES ('4024', '垣曲县', '3', '3925', 'Y');
INSERT INTO `ey_region` VALUES ('4036', '夏县', '3', '3925', 'X');
INSERT INTO `ey_region` VALUES ('4048', '平陆县', '3', '3925', 'P');
INSERT INTO `ey_region` VALUES ('4059', '芮城县', '3', '3925', 'R');
INSERT INTO `ey_region` VALUES ('4070', '永济市', '3', '3925', 'Y');
INSERT INTO `ey_region` VALUES ('4082', '河津市', '3', '3925', 'H');
INSERT INTO `ey_region` VALUES ('4093', '忻州市', '2', '3102', 'X');
INSERT INTO `ey_region` VALUES ('4094', '市辖区', '3', '4093', 'S');
INSERT INTO `ey_region` VALUES ('4095', '忻府区', '3', '4093', 'X');
INSERT INTO `ey_region` VALUES ('4116', '定襄县', '3', '4093', 'D');
INSERT INTO `ey_region` VALUES ('4126', '五台县', '3', '4093', 'W');
INSERT INTO `ey_region` VALUES ('4146', '代县', '3', '4093', 'D');
INSERT INTO `ey_region` VALUES ('4158', '繁峙县', '3', '4093', 'F');
INSERT INTO `ey_region` VALUES ('4172', '宁武县', '3', '4093', 'N');
INSERT INTO `ey_region` VALUES ('4189', '静乐县', '3', '4093', 'J');
INSERT INTO `ey_region` VALUES ('4204', '神池县', '3', '4093', 'S');
INSERT INTO `ey_region` VALUES ('4215', '五寨县', '3', '4093', 'W');
INSERT INTO `ey_region` VALUES ('4228', '岢岚县', '3', '4093', 'K');
INSERT INTO `ey_region` VALUES ('4241', '河曲县', '3', '4093', 'H');
INSERT INTO `ey_region` VALUES ('4255', '保德县', '3', '4093', 'B');
INSERT INTO `ey_region` VALUES ('4269', '偏关县', '3', '4093', 'P');
INSERT INTO `ey_region` VALUES ('4280', '原平市', '3', '4093', 'Y');
INSERT INTO `ey_region` VALUES ('4304', '临汾市', '2', '3102', 'L');
INSERT INTO `ey_region` VALUES ('4305', '市辖区', '3', '4304', 'S');
INSERT INTO `ey_region` VALUES ('4306', '尧都区', '3', '4304', 'Y');
INSERT INTO `ey_region` VALUES ('4333', '曲沃县', '3', '4304', 'Q');
INSERT INTO `ey_region` VALUES ('4341', '翼城县', '3', '4304', 'Y');
INSERT INTO `ey_region` VALUES ('4352', '襄汾县', '3', '4304', 'X');
INSERT INTO `ey_region` VALUES ('4366', '洪洞县', '3', '4304', 'H');
INSERT INTO `ey_region` VALUES ('4383', '古县', '3', '4304', 'G');
INSERT INTO `ey_region` VALUES ('4391', '安泽县', '3', '4304', 'A');
INSERT INTO `ey_region` VALUES ('4399', '浮山县', '3', '4304', 'F');
INSERT INTO `ey_region` VALUES ('4409', '吉县', '3', '4304', 'J');
INSERT INTO `ey_region` VALUES ('4418', '乡宁县', '3', '4304', 'X');
INSERT INTO `ey_region` VALUES ('4429', '大宁县', '3', '4304', 'D');
INSERT INTO `ey_region` VALUES ('4436', '隰县', '3', '4304', 'X');
INSERT INTO `ey_region` VALUES ('4445', '永和县', '3', '4304', 'Y');
INSERT INTO `ey_region` VALUES ('4453', '蒲县', '3', '4304', 'P');
INSERT INTO `ey_region` VALUES ('4463', '汾西县', '3', '4304', 'F');
INSERT INTO `ey_region` VALUES ('4472', '侯马市', '3', '4304', 'H');
INSERT INTO `ey_region` VALUES ('4481', '霍州市', '3', '4304', 'H');
INSERT INTO `ey_region` VALUES ('4494', '吕梁市', '2', '3102', 'L');
INSERT INTO `ey_region` VALUES ('4495', '市辖区', '3', '4494', 'S');
INSERT INTO `ey_region` VALUES ('4496', '离石区', '3', '4494', 'L');
INSERT INTO `ey_region` VALUES ('4509', '文水县', '3', '4494', 'W');
INSERT INTO `ey_region` VALUES ('4522', '交城县', '3', '4494', 'J');
INSERT INTO `ey_region` VALUES ('4533', '兴县', '3', '4494', 'X');
INSERT INTO `ey_region` VALUES ('4551', '临县', '3', '4494', 'L');
INSERT INTO `ey_region` VALUES ('4575', '柳林县', '3', '4494', 'L');
INSERT INTO `ey_region` VALUES ('4591', '石楼县', '3', '4494', 'S');
INSERT INTO `ey_region` VALUES ('4601', '岚县', '3', '4494', 'L');
INSERT INTO `ey_region` VALUES ('4614', '方山县', '3', '4494', 'F');
INSERT INTO `ey_region` VALUES ('4622', '中阳县', '3', '4494', 'Z');
INSERT INTO `ey_region` VALUES ('4630', '交口县', '3', '4494', 'J');
INSERT INTO `ey_region` VALUES ('4638', '孝义市', '3', '4494', 'X');
INSERT INTO `ey_region` VALUES ('4655', '汾阳市', '3', '4494', 'F');
INSERT INTO `ey_region` VALUES ('4670', '内蒙古自治区', '1', '0', 'N');
INSERT INTO `ey_region` VALUES ('4671', '呼和浩特市', '2', '4670', 'H');
INSERT INTO `ey_region` VALUES ('4672', '市辖区', '3', '4671', 'S');
INSERT INTO `ey_region` VALUES ('4673', '新城区', '3', '4671', 'X');
INSERT INTO `ey_region` VALUES ('4684', '回民区', '3', '4671', 'H');
INSERT INTO `ey_region` VALUES ('4693', '玉泉区', '3', '4671', 'Y');
INSERT INTO `ey_region` VALUES ('4702', '赛罕区', '3', '4671', 'S');
INSERT INTO `ey_region` VALUES ('4715', '土左旗', '3', '4671', 'T');
INSERT INTO `ey_region` VALUES ('4727', '托克托县', '3', '4671', 'T');
INSERT INTO `ey_region` VALUES ('4733', '和林格尔县', '3', '4671', 'H');
INSERT INTO `ey_region` VALUES ('4742', '清水河县', '3', '4671', 'Q');
INSERT INTO `ey_region` VALUES ('4749', '武川县', '3', '4671', 'W');
INSERT INTO `ey_region` VALUES ('4759', '包头市', '2', '4670', 'B');
INSERT INTO `ey_region` VALUES ('4760', '市辖区', '3', '4759', 'S');
INSERT INTO `ey_region` VALUES ('4761', '东河区', '3', '4759', 'D');
INSERT INTO `ey_region` VALUES ('4775', '昆都仑区', '3', '4759', 'K');
INSERT INTO `ey_region` VALUES ('4791', '青山区', '3', '4759', 'Q');
INSERT INTO `ey_region` VALUES ('4803', '石拐区', '3', '4759', 'S');
INSERT INTO `ey_region` VALUES ('4810', '白云鄂博矿区', '3', '4759', 'B');
INSERT INTO `ey_region` VALUES ('4813', '九原区', '3', '4759', 'J');
INSERT INTO `ey_region` VALUES ('4823', '土默特右旗', '3', '4759', 'T');
INSERT INTO `ey_region` VALUES ('4833', '固阳县', '3', '4759', 'G');
INSERT INTO `ey_region` VALUES ('4840', '达茂联合旗', '3', '4759', 'D');
INSERT INTO `ey_region` VALUES ('4849', '乌海市', '2', '4670', 'W');
INSERT INTO `ey_region` VALUES ('4850', '乌海市辖区', '3', '4849', 'W');
INSERT INTO `ey_region` VALUES ('4851', '海勃湾区', '3', '4849', 'H');
INSERT INTO `ey_region` VALUES ('4859', '海南区', '3', '4849', 'H');
INSERT INTO `ey_region` VALUES ('4865', '乌达区', '3', '4849', 'W');
INSERT INTO `ey_region` VALUES ('4874', '赤峰市', '2', '4670', 'C');
INSERT INTO `ey_region` VALUES ('4875', '市辖区', '3', '4874', 'S');
INSERT INTO `ey_region` VALUES ('4876', '红山区', '3', '4874', 'H');
INSERT INTO `ey_region` VALUES ('4888', '元宝山区', '3', '4874', 'Y');
INSERT INTO `ey_region` VALUES ('4896', '松山区', '3', '4874', 'S');
INSERT INTO `ey_region` VALUES ('4919', '阿鲁科尔沁旗', '3', '4874', 'A');
INSERT INTO `ey_region` VALUES ('4932', '巴林左旗', '3', '4874', 'B');
INSERT INTO `ey_region` VALUES ('4944', '巴林右旗', '3', '4874', 'B');
INSERT INTO `ey_region` VALUES ('4953', '林西县', '3', '4874', 'L');
INSERT INTO `ey_region` VALUES ('4963', '克什克腾旗', '3', '4874', 'K');
INSERT INTO `ey_region` VALUES ('4975', '翁牛特旗', '3', '4874', 'W');
INSERT INTO `ey_region` VALUES ('4988', '喀喇沁旗', '3', '4874', 'K');
INSERT INTO `ey_region` VALUES ('4999', '宁城县', '3', '4874', 'N');
INSERT INTO `ey_region` VALUES ('5013', '敖汉旗', '3', '4874', 'A');
INSERT INTO `ey_region` VALUES ('5029', '通辽市', '2', '4670', 'T');
INSERT INTO `ey_region` VALUES ('5030', '市辖区', '3', '5029', 'S');
INSERT INTO `ey_region` VALUES ('5031', '科尔沁区', '3', '5029', 'K');
INSERT INTO `ey_region` VALUES ('5062', '科尔沁左翼中旗', '3', '5029', 'K');
INSERT INTO `ey_region` VALUES ('5079', '科左后旗', '3', '5029', 'K');
INSERT INTO `ey_region` VALUES ('5104', '开鲁县', '3', '5029', 'K');
INSERT INTO `ey_region` VALUES ('5118', '库伦旗', '3', '5029', 'K');
INSERT INTO `ey_region` VALUES ('5125', '奈曼旗', '3', '5029', 'N');
INSERT INTO `ey_region` VALUES ('5139', '扎鲁特旗', '3', '5029', 'Z');
INSERT INTO `ey_region` VALUES ('5155', '霍林郭勒市', '3', '5029', 'H');
INSERT INTO `ey_region` VALUES ('5162', '鄂尔多斯市', '2', '4670', 'E');
INSERT INTO `ey_region` VALUES ('5163', '东胜区', '3', '5162', 'D');
INSERT INTO `ey_region` VALUES ('5176', '达拉特旗', '3', '5162', 'D');
INSERT INTO `ey_region` VALUES ('5185', '准格尔旗', '3', '5162', 'Z');
INSERT INTO `ey_region` VALUES ('5195', '鄂托克前旗', '3', '5162', 'E');
INSERT INTO `ey_region` VALUES ('5201', '鄂托克旗', '3', '5162', 'E');
INSERT INTO `ey_region` VALUES ('5210', '杭锦旗', '3', '5162', 'H');
INSERT INTO `ey_region` VALUES ('5219', '乌审旗', '3', '5162', 'W');
INSERT INTO `ey_region` VALUES ('5228', '伊金霍洛旗', '3', '5162', 'Y');
INSERT INTO `ey_region` VALUES ('5236', '呼伦贝尔市', '2', '4670', 'H');
INSERT INTO `ey_region` VALUES ('5237', '市辖区', '3', '5236', 'S');
INSERT INTO `ey_region` VALUES ('5238', '海拉尔区', '3', '5236', 'H');
INSERT INTO `ey_region` VALUES ('5249', '阿荣旗', '3', '5236', 'A');
INSERT INTO `ey_region` VALUES ('5262', '莫力达瓦旗', '3', '5236', 'M');
INSERT INTO `ey_region` VALUES ('5277', '鄂伦春旗', '3', '5236', 'E');
INSERT INTO `ey_region` VALUES ('5303', '鄂温旗', '3', '5236', 'E');
INSERT INTO `ey_region` VALUES ('5314', '陈巴尔虎旗镇', '3', '5236', 'C');
INSERT INTO `ey_region` VALUES ('5323', '新巴尔虎左旗', '3', '5236', 'X');
INSERT INTO `ey_region` VALUES ('5330', '新巴尔虎右旗', '3', '5236', 'X');
INSERT INTO `ey_region` VALUES ('5337', '满洲里市', '3', '5236', 'M');
INSERT INTO `ey_region` VALUES ('5354', '牙克石市', '3', '5236', 'Y');
INSERT INTO `ey_region` VALUES ('5371', '扎兰屯市', '3', '5236', 'Z');
INSERT INTO `ey_region` VALUES ('5397', '额尔古纳市', '3', '5236', 'E');
INSERT INTO `ey_region` VALUES ('5410', '根河市', '3', '5236', 'G');
INSERT INTO `ey_region` VALUES ('5418', '巴彦淖尔市', '2', '4670', 'B');
INSERT INTO `ey_region` VALUES ('5419', '市辖区', '3', '5418', 'S');
INSERT INTO `ey_region` VALUES ('5420', '临河区', '3', '5418', 'L');
INSERT INTO `ey_region` VALUES ('5440', '五原县', '3', '5418', 'W');
INSERT INTO `ey_region` VALUES ('5450', '磴口县', '3', '5418', 'D');
INSERT INTO `ey_region` VALUES ('5461', '乌拉特前旗', '3', '5418', 'W');
INSERT INTO `ey_region` VALUES ('5477', '乌拉特中旗', '3', '5418', 'W');
INSERT INTO `ey_region` VALUES ('5489', '乌拉特后旗', '3', '5418', 'W');
INSERT INTO `ey_region` VALUES ('5495', '杭锦后旗', '3', '5418', 'H');
INSERT INTO `ey_region` VALUES ('5505', '乌兰察布市', '2', '4670', 'W');
INSERT INTO `ey_region` VALUES ('5506', '市辖区', '3', '5505', 'S');
INSERT INTO `ey_region` VALUES ('5507', '集宁区', '3', '5505', 'J');
INSERT INTO `ey_region` VALUES ('5518', '卓资县', '3', '5505', 'Z');
INSERT INTO `ey_region` VALUES ('5526', '化德县', '3', '5505', 'H');
INSERT INTO `ey_region` VALUES ('5532', '商都县', '3', '5505', 'S');
INSERT INTO `ey_region` VALUES ('5542', '兴和县', '3', '5505', 'X');
INSERT INTO `ey_region` VALUES ('5551', '凉城县', '3', '5505', 'L');
INSERT INTO `ey_region` VALUES ('5562', '察哈尔右翼前旗', '3', '5505', 'C');
INSERT INTO `ey_region` VALUES ('5571', '察右中旗', '3', '5505', 'C');
INSERT INTO `ey_region` VALUES ('5582', '察哈尔右翼后旗', '3', '5505', 'C');
INSERT INTO `ey_region` VALUES ('5590', '四子王旗', '3', '5505', 'S');
INSERT INTO `ey_region` VALUES ('5603', '丰镇市', '3', '5505', 'F');
INSERT INTO `ey_region` VALUES ('5616', '兴安盟', '2', '4670', 'X');
INSERT INTO `ey_region` VALUES ('5617', '乌兰浩特市', '3', '5616', 'W');
INSERT INTO `ey_region` VALUES ('5629', '阿尔山市', '3', '5616', 'A');
INSERT INTO `ey_region` VALUES ('5636', '科右前旗', '3', '5616', 'K');
INSERT INTO `ey_region` VALUES ('5655', '科右中旗', '3', '5616', 'K');
INSERT INTO `ey_region` VALUES ('5677', '扎赉特旗', '3', '5616', 'Z');
INSERT INTO `ey_region` VALUES ('5692', '突泉县', '3', '5616', 'T');
INSERT INTO `ey_region` VALUES ('5702', '锡林郭勒盟', '2', '4670', 'X');
INSERT INTO `ey_region` VALUES ('5703', '二连浩特市', '3', '5702', 'E');
INSERT INTO `ey_region` VALUES ('5709', '锡林浩特市', '3', '5702', 'X');
INSERT INTO `ey_region` VALUES ('5723', '阿巴嘎旗', '3', '5702', 'A');
INSERT INTO `ey_region` VALUES ('5731', '苏尼特左旗', '3', '5702', 'S');
INSERT INTO `ey_region` VALUES ('5738', '苏尼特右旗', '3', '5702', 'S');
INSERT INTO `ey_region` VALUES ('5745', '东乌珠穆沁旗', '3', '5702', 'D');
INSERT INTO `ey_region` VALUES ('5758', '西乌珠穆沁旗', '3', '5702', 'X');
INSERT INTO `ey_region` VALUES ('5766', '太仆寺旗', '3', '5702', 'T');
INSERT INTO `ey_region` VALUES ('5774', '镶黄旗', '3', '5702', 'X');
INSERT INTO `ey_region` VALUES ('5778', '正镶白旗', '3', '5702', 'Z');
INSERT INTO `ey_region` VALUES ('5785', '正蓝旗', '3', '5702', 'Z');
INSERT INTO `ey_region` VALUES ('5794', '多伦县', '3', '5702', 'D');
INSERT INTO `ey_region` VALUES ('5799', '阿拉善盟', '2', '4670', 'A');
INSERT INTO `ey_region` VALUES ('5800', '阿拉善左旗', '3', '5799', 'A');
INSERT INTO `ey_region` VALUES ('5814', '阿拉善右旗', '3', '5799', 'A');
INSERT INTO `ey_region` VALUES ('5820', '额济纳旗', '3', '5799', 'E');
INSERT INTO `ey_region` VALUES ('5827', '辽宁省', '1', '0', 'L');
INSERT INTO `ey_region` VALUES ('5828', '沈阳市', '2', '5827', 'S');
INSERT INTO `ey_region` VALUES ('5829', '市辖区', '3', '5828', 'S');
INSERT INTO `ey_region` VALUES ('5830', '和平区', '3', '5828', 'H');
INSERT INTO `ey_region` VALUES ('5848', '沈河区', '3', '5828', 'S');
INSERT INTO `ey_region` VALUES ('5859', '大东区', '3', '5828', 'D');
INSERT INTO `ey_region` VALUES ('5873', '皇姑区', '3', '5828', 'H');
INSERT INTO `ey_region` VALUES ('5894', '铁西区', '3', '5828', 'T');
INSERT INTO `ey_region` VALUES ('5909', '苏家屯区', '3', '5828', 'S');
INSERT INTO `ey_region` VALUES ('5934', '东陵区', '3', '5828', 'D');
INSERT INTO `ey_region` VALUES ('5954', '新城子区', '3', '5828', 'X');
INSERT INTO `ey_region` VALUES ('5975', '于洪区', '3', '5828', 'Y');
INSERT INTO `ey_region` VALUES ('5998', '辽中县', '3', '5828', 'L');
INSERT INTO `ey_region` VALUES ('6020', '康平县', '3', '5828', 'K');
INSERT INTO `ey_region` VALUES ('6038', '法库县', '3', '5828', 'F');
INSERT INTO `ey_region` VALUES ('6058', '新民市', '3', '5828', 'X');
INSERT INTO `ey_region` VALUES ('6088', '大连市', '2', '5827', 'D');
INSERT INTO `ey_region` VALUES ('6089', '市辖区', '3', '6088', 'S');
INSERT INTO `ey_region` VALUES ('6090', '中山区', '3', '6088', 'Z');
INSERT INTO `ey_region` VALUES ('6099', '西岗区', '3', '6088', 'X');
INSERT INTO `ey_region` VALUES ('6107', '沙河口区', '3', '6088', 'S');
INSERT INTO `ey_region` VALUES ('6117', '甘井子区', '3', '6088', 'G');
INSERT INTO `ey_region` VALUES ('6137', '旅顺口区', '3', '6088', 'L');
INSERT INTO `ey_region` VALUES ('6153', '金州区', '3', '6088', 'J');
INSERT INTO `ey_region` VALUES ('6178', '长海县', '3', '6088', 'C');
INSERT INTO `ey_region` VALUES ('6184', '瓦房店市', '3', '6088', 'W');
INSERT INTO `ey_region` VALUES ('6217', '普兰店市', '3', '6088', 'P');
INSERT INTO `ey_region` VALUES ('6239', '庄河市', '3', '6088', 'Z');
INSERT INTO `ey_region` VALUES ('6266', '鞍山市', '2', '5827', 'A');
INSERT INTO `ey_region` VALUES ('6267', '市辖区', '3', '6266', 'S');
INSERT INTO `ey_region` VALUES ('6268', '铁东区', '3', '6266', 'T');
INSERT INTO `ey_region` VALUES ('6282', '铁西区', '3', '6266', 'T');
INSERT INTO `ey_region` VALUES ('6293', '立山区', '3', '6266', 'L');
INSERT INTO `ey_region` VALUES ('6303', '千山区', '3', '6266', 'Q');
INSERT INTO `ey_region` VALUES ('6316', '台安县', '3', '6266', 'T');
INSERT INTO `ey_region` VALUES ('6331', '岫岩县', '3', '6266', 'X');
INSERT INTO `ey_region` VALUES ('6354', '海城市', '3', '6266', 'H');
INSERT INTO `ey_region` VALUES ('6384', '抚顺市', '2', '5827', 'F');
INSERT INTO `ey_region` VALUES ('6385', '市辖区', '3', '6384', 'S');
INSERT INTO `ey_region` VALUES ('6386', '新抚区', '3', '6384', 'X');
INSERT INTO `ey_region` VALUES ('6395', '东洲区', '3', '6384', 'D');
INSERT INTO `ey_region` VALUES ('6409', '望花区', '3', '6384', 'W');
INSERT INTO `ey_region` VALUES ('6422', '顺城区', '3', '6384', 'S');
INSERT INTO `ey_region` VALUES ('6432', '抚顺县', '3', '6384', 'F');
INSERT INTO `ey_region` VALUES ('6445', '新宾县', '3', '6384', 'X');
INSERT INTO `ey_region` VALUES ('6461', '清原县', '3', '6384', 'Q');
INSERT INTO `ey_region` VALUES ('6476', '本溪市', '2', '5827', 'B');
INSERT INTO `ey_region` VALUES ('6477', '市辖区', '3', '6476', 'S');
INSERT INTO `ey_region` VALUES ('6478', '平山区', '3', '6476', 'P');
INSERT INTO `ey_region` VALUES ('6488', '溪湖区', '3', '6476', 'X');
INSERT INTO `ey_region` VALUES ('6499', '明山区', '3', '6476', 'M');
INSERT INTO `ey_region` VALUES ('6509', '南芬区', '3', '6476', 'N');
INSERT INTO `ey_region` VALUES ('6515', '本溪县', '3', '6476', 'B');
INSERT INTO `ey_region` VALUES ('6528', '桓仁县', '3', '6476', 'H');
INSERT INTO `ey_region` VALUES ('6542', '丹东市', '2', '5827', 'D');
INSERT INTO `ey_region` VALUES ('6543', '市辖区', '3', '6542', 'S');
INSERT INTO `ey_region` VALUES ('6544', '元宝区', '3', '6542', 'Y');
INSERT INTO `ey_region` VALUES ('6552', '振兴区', '3', '6542', 'Z');
INSERT INTO `ey_region` VALUES ('6563', '振安区', '3', '6542', 'Z');
INSERT INTO `ey_region` VALUES ('6573', '宽甸县', '3', '6542', 'K');
INSERT INTO `ey_region` VALUES ('6596', '东港市', '3', '6542', 'D');
INSERT INTO `ey_region` VALUES ('6621', '凤城市', '3', '6542', 'F');
INSERT INTO `ey_region` VALUES ('6643', '锦州市', '2', '5827', 'J');
INSERT INTO `ey_region` VALUES ('6644', '市辖区', '3', '6643', 'S');
INSERT INTO `ey_region` VALUES ('6645', '古塔区', '3', '6643', 'G');
INSERT INTO `ey_region` VALUES ('6655', '凌河区', '3', '6643', 'L');
INSERT INTO `ey_region` VALUES ('6668', '太和区', '3', '6643', 'T');
INSERT INTO `ey_region` VALUES ('6683', '黑山县', '3', '6643', 'H');
INSERT INTO `ey_region` VALUES ('6706', '义县', '3', '6643', 'Y');
INSERT INTO `ey_region` VALUES ('6725', '凌海市', '3', '6643', 'L');
INSERT INTO `ey_region` VALUES ('6750', '北镇市', '3', '6643', 'B');
INSERT INTO `ey_region` VALUES ('6771', '营口市', '2', '5827', 'Y');
INSERT INTO `ey_region` VALUES ('6772', '市辖区', '3', '6771', 'S');
INSERT INTO `ey_region` VALUES ('6773', '站前区', '3', '6771', 'Z');
INSERT INTO `ey_region` VALUES ('6781', '西市区', '3', '6771', 'X');
INSERT INTO `ey_region` VALUES ('6789', '鲅鱼圈区', '3', '6771', 'B');
INSERT INTO `ey_region` VALUES ('6797', '老边区', '3', '6771', 'L');
INSERT INTO `ey_region` VALUES ('6804', '盖州市', '3', '6771', 'G');
INSERT INTO `ey_region` VALUES ('6832', '大石桥市', '3', '6771', 'D');
INSERT INTO `ey_region` VALUES ('6851', '阜新市', '2', '5827', 'F');
INSERT INTO `ey_region` VALUES ('6852', '市辖区', '3', '6851', 'S');
INSERT INTO `ey_region` VALUES ('6853', '海州区', '3', '6851', 'H');
INSERT INTO `ey_region` VALUES ('6865', '新邱区', '3', '6851', 'X');
INSERT INTO `ey_region` VALUES ('6871', '太平区', '3', '6851', 'T');
INSERT INTO `ey_region` VALUES ('6878', '清河门区', '3', '6851', 'Q');
INSERT INTO `ey_region` VALUES ('6885', '细河区', '3', '6851', 'X');
INSERT INTO `ey_region` VALUES ('6893', '阜新县', '3', '6851', 'F');
INSERT INTO `ey_region` VALUES ('6930', '彰武县', '3', '6851', 'Z');
INSERT INTO `ey_region` VALUES ('6955', '辽阳市', '2', '5827', 'L');
INSERT INTO `ey_region` VALUES ('6956', '市辖区', '3', '6955', 'S');
INSERT INTO `ey_region` VALUES ('6957', '白塔区', '3', '6955', 'B');
INSERT INTO `ey_region` VALUES ('6964', '文圣区', '3', '6955', 'W');
INSERT INTO `ey_region` VALUES ('6971', '宏伟区', '3', '6955', 'H');
INSERT INTO `ey_region` VALUES ('6977', '弓长岭区', '3', '6955', 'G');
INSERT INTO `ey_region` VALUES ('6983', '太子河区', '3', '6955', 'T');
INSERT INTO `ey_region` VALUES ('6989', '辽阳县', '3', '6955', 'L');
INSERT INTO `ey_region` VALUES ('7007', '灯塔市', '3', '6955', 'D');
INSERT INTO `ey_region` VALUES ('7024', '盘锦市', '2', '5827', 'P');
INSERT INTO `ey_region` VALUES ('7025', '市辖区', '3', '7024', 'S');
INSERT INTO `ey_region` VALUES ('7026', '双台子区', '3', '7024', 'S');
INSERT INTO `ey_region` VALUES ('7036', '兴隆台区', '3', '7024', 'X');
INSERT INTO `ey_region` VALUES ('7055', '大洼县', '3', '7024', 'D');
INSERT INTO `ey_region` VALUES ('7072', '盘山县', '3', '7024', 'P');
INSERT INTO `ey_region` VALUES ('7088', '铁岭市', '2', '5827', 'T');
INSERT INTO `ey_region` VALUES ('7089', '市辖区', '3', '7088', 'S');
INSERT INTO `ey_region` VALUES ('7090', '银州区', '3', '7088', 'Y');
INSERT INTO `ey_region` VALUES ('7099', '清河区', '3', '7088', 'Q');
INSERT INTO `ey_region` VALUES ('7105', '铁岭县', '3', '7088', 'T');
INSERT INTO `ey_region` VALUES ('7121', '西丰县', '3', '7088', 'X');
INSERT INTO `ey_region` VALUES ('7140', '昌图县', '3', '7088', 'C');
INSERT INTO `ey_region` VALUES ('7180', '调兵山市', '3', '7088', 'D');
INSERT INTO `ey_region` VALUES ('7186', '开原市', '3', '7088', 'K');
INSERT INTO `ey_region` VALUES ('7208', '朝阳市', '2', '5827', 'C');
INSERT INTO `ey_region` VALUES ('7209', '市辖区', '3', '7208', 'S');
INSERT INTO `ey_region` VALUES ('7210', '双塔区', '3', '7208', 'S');
INSERT INTO `ey_region` VALUES ('7225', '龙城区', '3', '7208', 'L');
INSERT INTO `ey_region` VALUES ('7238', '朝阳县', '3', '7208', 'C');
INSERT INTO `ey_region` VALUES ('7267', '建平县', '3', '7208', 'J');
INSERT INTO `ey_region` VALUES ('7299', '喀喇沁左翼县', '3', '7208', 'K');
INSERT INTO `ey_region` VALUES ('7322', '北票市', '3', '7208', 'B');
INSERT INTO `ey_region` VALUES ('7360', '凌源市', '3', '7208', 'L');
INSERT INTO `ey_region` VALUES ('7391', '葫芦岛市', '2', '5827', 'H');
INSERT INTO `ey_region` VALUES ('7392', '市辖区', '3', '7391', 'S');
INSERT INTO `ey_region` VALUES ('7393', '连山区', '3', '7391', 'L');
INSERT INTO `ey_region` VALUES ('7419', '龙港区', '3', '7391', 'L');
INSERT INTO `ey_region` VALUES ('7433', '南票区', '3', '7391', 'N');
INSERT INTO `ey_region` VALUES ('7446', '绥中县', '3', '7391', 'S');
INSERT INTO `ey_region` VALUES ('7474', '建昌县', '3', '7391', 'J');
INSERT INTO `ey_region` VALUES ('7503', '兴城市', '3', '7391', 'X');
INSERT INTO `ey_region` VALUES ('7531', '吉林省', '1', '0', 'J');
INSERT INTO `ey_region` VALUES ('7532', '长春市', '2', '7531', 'C');
INSERT INTO `ey_region` VALUES ('7533', '长春市辖区', '3', '7532', 'C');
INSERT INTO `ey_region` VALUES ('7534', '南关区', '3', '7532', 'N');
INSERT INTO `ey_region` VALUES ('7552', '宽城区', '3', '7532', 'K');
INSERT INTO `ey_region` VALUES ('7569', '朝阳区', '3', '7532', 'C');
INSERT INTO `ey_region` VALUES ('7582', '二道区', '3', '7532', 'E');
INSERT INTO `ey_region` VALUES ('7597', '绿园区', '3', '7532', 'L');
INSERT INTO `ey_region` VALUES ('7610', '双阳区', '3', '7532', 'S');
INSERT INTO `ey_region` VALUES ('7619', '农安县', '3', '7532', 'N');
INSERT INTO `ey_region` VALUES ('7642', '九台市', '3', '7532', 'J');
INSERT INTO `ey_region` VALUES ('7658', '榆树市', '3', '7532', 'Y');
INSERT INTO `ey_region` VALUES ('7687', '德惠市', '3', '7532', 'D');
INSERT INTO `ey_region` VALUES ('7706', '吉林市', '2', '7531', 'J');
INSERT INTO `ey_region` VALUES ('7707', '吉林市辖区', '3', '7706', 'J');
INSERT INTO `ey_region` VALUES ('7708', '昌邑区', '3', '7706', 'C');
INSERT INTO `ey_region` VALUES ('7731', '龙潭区', '3', '7706', 'L');
INSERT INTO `ey_region` VALUES ('7752', '船营区', '3', '7706', 'C');
INSERT INTO `ey_region` VALUES ('7768', '丰满区', '3', '7706', 'F');
INSERT INTO `ey_region` VALUES ('7781', '永吉县', '3', '7706', 'Y');
INSERT INTO `ey_region` VALUES ('7792', '蛟河市', '3', '7706', 'J');
INSERT INTO `ey_region` VALUES ('7810', '桦甸市', '3', '7706', 'H');
INSERT INTO `ey_region` VALUES ('7828', '舒兰市', '3', '7706', 'S');
INSERT INTO `ey_region` VALUES ('7849', '磐石市', '3', '7706', 'P');
INSERT INTO `ey_region` VALUES ('7868', '四平市', '2', '7531', 'S');
INSERT INTO `ey_region` VALUES ('7869', '四平市辖区', '3', '7868', 'S');
INSERT INTO `ey_region` VALUES ('7870', '铁西区', '3', '7868', 'T');
INSERT INTO `ey_region` VALUES ('7878', '铁东区', '3', '7868', 'T');
INSERT INTO `ey_region` VALUES ('7892', '梨树县', '3', '7868', 'L');
INSERT INTO `ey_region` VALUES ('7916', '伊通县', '3', '7868', 'Y');
INSERT INTO `ey_region` VALUES ('7933', '公主岭市', '3', '7868', 'G');
INSERT INTO `ey_region` VALUES ('7964', '双辽市', '3', '7868', 'S');
INSERT INTO `ey_region` VALUES ('7986', '辽源市', '2', '7531', 'L');
INSERT INTO `ey_region` VALUES ('7987', '辽源市辖区', '3', '7986', 'L');
INSERT INTO `ey_region` VALUES ('7988', '龙山区', '3', '7986', 'L');
INSERT INTO `ey_region` VALUES ('8000', '西安区', '3', '7986', 'X');
INSERT INTO `ey_region` VALUES ('8008', '东丰县', '3', '7986', 'D');
INSERT INTO `ey_region` VALUES ('8023', '东辽县', '3', '7986', 'D');
INSERT INTO `ey_region` VALUES ('8037', '通化市', '2', '7531', 'T');
INSERT INTO `ey_region` VALUES ('8038', '通化市辖区', '3', '8037', 'T');
INSERT INTO `ey_region` VALUES ('8039', '东昌区', '3', '8037', 'D');
INSERT INTO `ey_region` VALUES ('8051', '二道江区', '3', '8037', 'E');
INSERT INTO `ey_region` VALUES ('8058', '通化县', '3', '8037', 'T');
INSERT INTO `ey_region` VALUES ('8076', '辉南县', '3', '8037', 'H');
INSERT INTO `ey_region` VALUES ('8088', '柳河县', '3', '8037', 'L');
INSERT INTO `ey_region` VALUES ('8104', '梅河口市', '3', '8037', 'M');
INSERT INTO `ey_region` VALUES ('8129', '集安市', '3', '8037', 'J');
INSERT INTO `ey_region` VALUES ('8144', '白山市', '2', '7531', 'B');
INSERT INTO `ey_region` VALUES ('8145', '白山市辖区', '3', '8144', 'B');
INSERT INTO `ey_region` VALUES ('8146', '八道江区', '3', '8144', 'B');
INSERT INTO `ey_region` VALUES ('8159', '江源区', '3', '8144', 'J');
INSERT INTO `ey_region` VALUES ('8168', '抚松县', '3', '8144', 'F');
INSERT INTO `ey_region` VALUES ('8183', '靖宇县', '3', '8144', 'J');
INSERT INTO `ey_region` VALUES ('8192', '长白县', '3', '8144', 'C');
INSERT INTO `ey_region` VALUES ('8202', '临江市', '3', '8144', 'L');
INSERT INTO `ey_region` VALUES ('8216', '松原市', '2', '7531', 'S');
INSERT INTO `ey_region` VALUES ('8217', '松原市辖区', '3', '8216', 'S');
INSERT INTO `ey_region` VALUES ('8218', '宁江区', '3', '8216', 'N');
INSERT INTO `ey_region` VALUES ('8239', '前郭县', '3', '8216', 'Q');
INSERT INTO `ey_region` VALUES ('8266', '长岭县', '3', '8216', 'C');
INSERT INTO `ey_region` VALUES ('8300', '乾安县', '3', '8216', 'Q');
INSERT INTO `ey_region` VALUES ('8311', '扶余县', '3', '8216', 'F');
INSERT INTO `ey_region` VALUES ('8333', '白城市', '2', '7531', 'B');
INSERT INTO `ey_region` VALUES ('8334', '白城市辖区', '3', '8333', 'B');
INSERT INTO `ey_region` VALUES ('8335', '洮北区', '3', '8333', 'T');
INSERT INTO `ey_region` VALUES ('8362', '镇赉县', '3', '8333', 'Z');
INSERT INTO `ey_region` VALUES ('8375', '通榆县', '3', '8333', 'T');
INSERT INTO `ey_region` VALUES ('8393', '洮南市', '3', '8333', 'T');
INSERT INTO `ey_region` VALUES ('8420', '大安市', '3', '8333', 'D');
INSERT INTO `ey_region` VALUES ('8445', '延边州', '2', '7531', 'Y');
INSERT INTO `ey_region` VALUES ('8446', '延吉市', '3', '8445', 'Y');
INSERT INTO `ey_region` VALUES ('8456', '图们市', '3', '8445', 'T');
INSERT INTO `ey_region` VALUES ('8464', '敦化市', '3', '8445', 'D');
INSERT INTO `ey_region` VALUES ('8489', '珲春市', '3', '8445', 'H');
INSERT INTO `ey_region` VALUES ('8504', '龙井市', '3', '8445', 'L');
INSERT INTO `ey_region` VALUES ('8515', '和龙市', '3', '8445', 'H');
INSERT INTO `ey_region` VALUES ('8530', '汪清县', '3', '8445', 'W');
INSERT INTO `ey_region` VALUES ('8545', '安图县', '3', '8445', 'A');
INSERT INTO `ey_region` VALUES ('8558', '黑龙江省', '1', '0', 'H');
INSERT INTO `ey_region` VALUES ('8559', '哈尔滨市', '2', '8558', 'H');
INSERT INTO `ey_region` VALUES ('8560', '市辖区', '3', '8559', 'S');
INSERT INTO `ey_region` VALUES ('8561', '道里区', '3', '8559', 'D');
INSERT INTO `ey_region` VALUES ('8585', '南岗区', '3', '8559', 'N');
INSERT INTO `ey_region` VALUES ('8606', '道外区', '3', '8559', 'D');
INSERT INTO `ey_region` VALUES ('8633', '平房区', '3', '8559', 'P');
INSERT INTO `ey_region` VALUES ('8642', '松北区', '3', '8559', 'S');
INSERT INTO `ey_region` VALUES ('8650', '香坊区', '3', '8559', 'X');
INSERT INTO `ey_region` VALUES ('8676', '呼兰区', '3', '8559', 'H');
INSERT INTO `ey_region` VALUES ('8694', '阿城区', '3', '8559', 'A');
INSERT INTO `ey_region` VALUES ('8714', '依兰县', '3', '8559', 'Y');
INSERT INTO `ey_region` VALUES ('8729', '方正县', '3', '8559', 'F');
INSERT INTO `ey_region` VALUES ('8740', '宾县', '3', '8559', 'B');
INSERT INTO `ey_region` VALUES ('8758', '巴彦县', '3', '8559', 'B');
INSERT INTO `ey_region` VALUES ('8778', '木兰县', '3', '8559', 'M');
INSERT INTO `ey_region` VALUES ('8788', '通河县', '3', '8559', 'T');
INSERT INTO `ey_region` VALUES ('8800', '延寿县', '3', '8559', 'Y');
INSERT INTO `ey_region` VALUES ('8812', '双城市', '3', '8559', 'S');
INSERT INTO `ey_region` VALUES ('8838', '尚志市', '3', '8559', 'S');
INSERT INTO `ey_region` VALUES ('8858', '五常市', '3', '8559', 'W');
INSERT INTO `ey_region` VALUES ('8884', '齐齐哈尔市', '2', '8558', 'Q');
INSERT INTO `ey_region` VALUES ('8885', '市辖区', '3', '8884', 'S');
INSERT INTO `ey_region` VALUES ('8886', '龙沙区', '3', '8884', 'L');
INSERT INTO `ey_region` VALUES ('8894', '建华区', '3', '8884', 'J');
INSERT INTO `ey_region` VALUES ('8901', '铁锋区', '3', '8884', 'T');
INSERT INTO `ey_region` VALUES ('8911', '昂昂溪区', '3', '8884', 'A');
INSERT INTO `ey_region` VALUES ('8918', '富拉尔基区', '3', '8884', 'F');
INSERT INTO `ey_region` VALUES ('8928', '碾子山区', '3', '8884', 'N');
INSERT INTO `ey_region` VALUES ('8934', '梅里斯达斡尔族区', '3', '8884', 'M');
INSERT INTO `ey_region` VALUES ('8943', '龙江县', '3', '8884', 'L');
INSERT INTO `ey_region` VALUES ('8958', '依安县', '3', '8884', 'Y');
INSERT INTO `ey_region` VALUES ('8976', '泰来县', '3', '8884', 'T');
INSERT INTO `ey_region` VALUES ('8998', '甘南县', '3', '8884', 'G');
INSERT INTO `ey_region` VALUES ('9011', '富裕县', '3', '8884', 'F');
INSERT INTO `ey_region` VALUES ('9024', '克山县', '3', '8884', 'K');
INSERT INTO `ey_region` VALUES ('9048', '克东县', '3', '8884', 'K');
INSERT INTO `ey_region` VALUES ('9067', '拜泉县', '3', '8884', 'B');
INSERT INTO `ey_region` VALUES ('9084', '讷河市', '3', '8884', 'N');
INSERT INTO `ey_region` VALUES ('9117', '鸡西市', '2', '8558', 'J');
INSERT INTO `ey_region` VALUES ('9118', '市辖区', '3', '9117', 'S');
INSERT INTO `ey_region` VALUES ('9119', '鸡冠区', '3', '9117', 'J');
INSERT INTO `ey_region` VALUES ('9129', '恒山区', '3', '9117', 'H');
INSERT INTO `ey_region` VALUES ('9139', '滴道区', '3', '9117', 'D');
INSERT INTO `ey_region` VALUES ('9146', '梨树区', '3', '9117', 'L');
INSERT INTO `ey_region` VALUES ('9153', '城子河区', '3', '9117', 'C');
INSERT INTO `ey_region` VALUES ('9161', '麻山区', '3', '9117', 'M');
INSERT INTO `ey_region` VALUES ('9164', '鸡东县', '3', '9117', 'J');
INSERT INTO `ey_region` VALUES ('9178', '虎林市', '3', '9117', 'H');
INSERT INTO `ey_region` VALUES ('9199', '密山市', '3', '9117', 'M');
INSERT INTO `ey_region` VALUES ('9222', '鹤岗市', '2', '8558', 'H');
INSERT INTO `ey_region` VALUES ('9223', '市辖区', '3', '9222', 'S');
INSERT INTO `ey_region` VALUES ('9224', '向阳区', '3', '9222', 'X');
INSERT INTO `ey_region` VALUES ('9230', '工农区', '3', '9222', 'G');
INSERT INTO `ey_region` VALUES ('9237', '南山区', '3', '9222', 'N');
INSERT INTO `ey_region` VALUES ('9244', '兴安区', '3', '9222', 'X');
INSERT INTO `ey_region` VALUES ('9250', '东山区', '3', '9222', 'D');
INSERT INTO `ey_region` VALUES ('9261', '兴山区', '3', '9222', 'X');
INSERT INTO `ey_region` VALUES ('9266', '萝北县', '3', '9222', 'L');
INSERT INTO `ey_region` VALUES ('9283', '绥滨县', '3', '9222', 'S');
INSERT INTO `ey_region` VALUES ('9296', '双鸭山市', '2', '8558', 'S');
INSERT INTO `ey_region` VALUES ('9297', '市辖区', '3', '9296', 'S');
INSERT INTO `ey_region` VALUES ('9298', '尖山区', '3', '9296', 'J');
INSERT INTO `ey_region` VALUES ('9307', '岭东区', '3', '9296', 'L');
INSERT INTO `ey_region` VALUES ('9317', '四方台区', '3', '9296', 'S');
INSERT INTO `ey_region` VALUES ('9323', '宝山区', '3', '9296', 'B');
INSERT INTO `ey_region` VALUES ('9335', '集贤县', '3', '9296', 'J');
INSERT INTO `ey_region` VALUES ('9356', '友谊县', '3', '9296', 'Y');
INSERT INTO `ey_region` VALUES ('9370', '宝清县', '3', '9296', 'B');
INSERT INTO `ey_region` VALUES ('9393', '饶河县', '3', '9296', 'R');
INSERT INTO `ey_region` VALUES ('9419', '大庆市', '2', '8558', 'D');
INSERT INTO `ey_region` VALUES ('9420', '市辖区', '3', '9419', 'S');
INSERT INTO `ey_region` VALUES ('9421', '萨尔图区', '3', '9419', 'S');
INSERT INTO `ey_region` VALUES ('9431', '龙凤区', '3', '9419', 'L');
INSERT INTO `ey_region` VALUES ('9440', '让胡路区', '3', '9419', 'R');
INSERT INTO `ey_region` VALUES ('9451', '红岗区', '3', '9419', 'H');
INSERT INTO `ey_region` VALUES ('9458', '大同区', '3', '9419', 'D');
INSERT INTO `ey_region` VALUES ('9474', '肇州县', '3', '9419', 'Z');
INSERT INTO `ey_region` VALUES ('9489', '肇源县', '3', '9419', 'Z');
INSERT INTO `ey_region` VALUES ('9514', '林甸县', '3', '9419', 'L');
INSERT INTO `ey_region` VALUES ('9527', '杜尔伯特县', '3', '9419', 'D');
INSERT INTO `ey_region` VALUES ('9553', '伊春市', '2', '8558', 'Y');
INSERT INTO `ey_region` VALUES ('9554', '市辖区', '3', '9553', 'S');
INSERT INTO `ey_region` VALUES ('9555', '伊春区', '3', '9553', 'Y');
INSERT INTO `ey_region` VALUES ('9561', '南岔区', '3', '9553', 'N');
INSERT INTO `ey_region` VALUES ('9581', '友好区', '3', '9553', 'Y');
INSERT INTO `ey_region` VALUES ('9599', '西林区', '3', '9553', 'X');
INSERT INTO `ey_region` VALUES ('9603', '翠峦区', '3', '9553', 'C');
INSERT INTO `ey_region` VALUES ('9614', '新青区', '3', '9553', 'X');
INSERT INTO `ey_region` VALUES ('9631', '美溪区', '3', '9553', 'M');
INSERT INTO `ey_region` VALUES ('9647', '金山屯区', '3', '9553', 'J');
INSERT INTO `ey_region` VALUES ('9660', '五营区', '3', '9553', 'W');
INSERT INTO `ey_region` VALUES ('9671', '乌马河区', '3', '9553', 'W');
INSERT INTO `ey_region` VALUES ('9685', '汤旺河区', '3', '9553', 'T');
INSERT INTO `ey_region` VALUES ('9702', '带岭区', '3', '9553', 'D');
INSERT INTO `ey_region` VALUES ('9715', '乌伊岭区', '3', '9553', 'W');
INSERT INTO `ey_region` VALUES ('9729', '红星区', '3', '9553', 'H');
INSERT INTO `ey_region` VALUES ('9742', '上甘岭区', '3', '9553', 'S');
INSERT INTO `ey_region` VALUES ('9756', '嘉荫县', '3', '9553', 'J');
INSERT INTO `ey_region` VALUES ('9772', '铁力市', '3', '9553', 'T');
INSERT INTO `ey_region` VALUES ('9785', '佳木斯市', '2', '8558', 'J');
INSERT INTO `ey_region` VALUES ('9786', '市辖区', '3', '9785', 'S');
INSERT INTO `ey_region` VALUES ('9787', '向阳区', '3', '9785', 'X');
INSERT INTO `ey_region` VALUES ('9795', '前进区', '3', '9785', 'Q');
INSERT INTO `ey_region` VALUES ('9802', '东风区', '3', '9785', 'D');
INSERT INTO `ey_region` VALUES ('9810', '郊区', '3', '9785', 'J');
INSERT INTO `ey_region` VALUES ('9825', '桦南县', '3', '9785', 'H');
INSERT INTO `ey_region` VALUES ('9839', '桦川县', '3', '9785', 'H');
INSERT INTO `ey_region` VALUES ('9851', '汤原县', '3', '9785', 'T');
INSERT INTO `ey_region` VALUES ('9866', '抚远县', '3', '9785', 'F');
INSERT INTO `ey_region` VALUES ('9879', '同江市', '3', '9785', 'T');
INSERT INTO `ey_region` VALUES ('9907', '富锦市', '3', '9785', 'F');
INSERT INTO `ey_region` VALUES ('9930', '七台河市', '2', '8558', 'Q');
INSERT INTO `ey_region` VALUES ('9931', '市辖区', '3', '9930', 'S');
INSERT INTO `ey_region` VALUES ('9932', '新兴区', '3', '9930', 'X');
INSERT INTO `ey_region` VALUES ('9944', '桃山区', '3', '9930', 'T');
INSERT INTO `ey_region` VALUES ('9952', '茄子河区', '3', '9930', 'Q');
INSERT INTO `ey_region` VALUES ('9962', '勃利县', '3', '9930', 'B');
INSERT INTO `ey_region` VALUES ('9981', '牡丹江市', '2', '8558', 'M');
INSERT INTO `ey_region` VALUES ('9982', '市辖区', '3', '9981', 'S');
INSERT INTO `ey_region` VALUES ('9983', '东安区', '3', '9981', 'D');
INSERT INTO `ey_region` VALUES ('9989', '阳明区', '3', '9981', 'Y');
INSERT INTO `ey_region` VALUES ('9996', '爱民区', '3', '9981', 'A');
INSERT INTO `ey_region` VALUES ('10005', '西安区', '3', '9981', 'X');
INSERT INTO `ey_region` VALUES ('10014', '东宁县', '3', '9981', 'D');
INSERT INTO `ey_region` VALUES ('10022', '林口县', '3', '9981', 'L');
INSERT INTO `ey_region` VALUES ('10036', '绥芬河市', '3', '9981', 'S');
INSERT INTO `ey_region` VALUES ('10039', '海林市', '3', '9981', 'H');
INSERT INTO `ey_region` VALUES ('10056', '宁安市', '3', '9981', 'N');
INSERT INTO `ey_region` VALUES ('10072', '穆棱市', '3', '9981', 'M');
INSERT INTO `ey_region` VALUES ('10084', '黑河市', '2', '8558', 'H');
INSERT INTO `ey_region` VALUES ('10085', '市辖区', '3', '10084', 'S');
INSERT INTO `ey_region` VALUES ('10086', '爱辉区', '3', '10084', 'A');
INSERT INTO `ey_region` VALUES ('10122', '嫩江县', '3', '10084', 'N');
INSERT INTO `ey_region` VALUES ('10150', '逊克县', '3', '10084', 'X');
INSERT INTO `ey_region` VALUES ('10168', '孙吴县', '3', '10084', 'S');
INSERT INTO `ey_region` VALUES ('10192', '北安市', '3', '10084', 'B');
INSERT INTO `ey_region` VALUES ('10214', '五大连池市', '3', '10084', 'W');
INSERT INTO `ey_region` VALUES ('10252', '绥化市', '2', '8558', 'S');
INSERT INTO `ey_region` VALUES ('10253', '市辖区', '3', '10252', 'S');
INSERT INTO `ey_region` VALUES ('10254', '北林区', '3', '10252', 'B');
INSERT INTO `ey_region` VALUES ('10281', '望奎县', '3', '10252', 'W');
INSERT INTO `ey_region` VALUES ('10301', '兰西县', '3', '10252', 'L');
INSERT INTO `ey_region` VALUES ('10320', '青冈县', '3', '10252', 'Q');
INSERT INTO `ey_region` VALUES ('10342', '庆安县', '3', '10252', 'Q');
INSERT INTO `ey_region` VALUES ('10360', '明水县', '3', '10252', 'M');
INSERT INTO `ey_region` VALUES ('10380', '绥棱县', '3', '10252', 'S');
INSERT INTO `ey_region` VALUES ('10401', '安达市', '3', '10252', 'A');
INSERT INTO `ey_region` VALUES ('10425', '肇东市', '3', '10252', 'Z');
INSERT INTO `ey_region` VALUES ('10452', '海伦市', '3', '10252', 'H');
INSERT INTO `ey_region` VALUES ('10483', '大兴安岭地区', '2', '8558', 'D');
INSERT INTO `ey_region` VALUES ('10484', '加格达奇区', '3', '10483', 'J');
INSERT INTO `ey_region` VALUES ('10495', '松岭区', '3', '10483', 'S');
INSERT INTO `ey_region` VALUES ('10500', '新林区', '3', '10483', 'X');
INSERT INTO `ey_region` VALUES ('10509', '呼中区', '3', '10483', 'H');
INSERT INTO `ey_region` VALUES ('10515', '呼玛县', '3', '10483', 'H');
INSERT INTO `ey_region` VALUES ('10525', '塔河县', '3', '10483', 'T');
INSERT INTO `ey_region` VALUES ('10534', '漠河县', '3', '10483', 'M');
INSERT INTO `ey_region` VALUES ('10543', '上海市', '1', '0', 'S');
INSERT INTO `ey_region` VALUES ('10544', '上海市', '2', '10543', 'S');
INSERT INTO `ey_region` VALUES ('10545', '黄浦区', '3', '10544', 'H');
INSERT INTO `ey_region` VALUES ('10555', '卢湾区', '3', '10544', 'L');
INSERT INTO `ey_region` VALUES ('10560', '徐汇区', '3', '10544', 'X');
INSERT INTO `ey_region` VALUES ('10575', '长宁区', '3', '10544', 'C');
INSERT INTO `ey_region` VALUES ('10586', '静安区', '3', '10544', 'J');
INSERT INTO `ey_region` VALUES ('10592', '普陀区', '3', '10544', 'P');
INSERT INTO `ey_region` VALUES ('10602', '闸北区', '3', '10544', 'Z');
INSERT INTO `ey_region` VALUES ('10612', '虹口区', '3', '10544', 'H');
INSERT INTO `ey_region` VALUES ('10623', '杨浦区', '3', '10544', 'Y');
INSERT INTO `ey_region` VALUES ('10636', '闵行区', '3', '10544', 'M');
INSERT INTO `ey_region` VALUES ('10650', '宝山区', '3', '10544', 'B');
INSERT INTO `ey_region` VALUES ('10664', '嘉定区', '3', '10544', 'J');
INSERT INTO `ey_region` VALUES ('10678', '浦东新区', '3', '10544', 'P');
INSERT INTO `ey_region` VALUES ('10704', '金山区', '3', '10544', 'J');
INSERT INTO `ey_region` VALUES ('10715', '松江区', '3', '10544', 'S');
INSERT INTO `ey_region` VALUES ('10735', '青浦区', '3', '10544', 'Q');
INSERT INTO `ey_region` VALUES ('10747', '南汇区', '3', '10544', 'N');
INSERT INTO `ey_region` VALUES ('10765', '奉贤区', '3', '10544', 'F');
INSERT INTO `ey_region` VALUES ('10780', '崇明区', '3', '10544', 'C');
INSERT INTO `ey_region` VALUES ('10808', '江苏省', '1', '0', 'J');
INSERT INTO `ey_region` VALUES ('10809', '南京市', '2', '10808', 'N');
INSERT INTO `ey_region` VALUES ('10810', '市辖区', '3', '10809', 'S');
INSERT INTO `ey_region` VALUES ('10811', '玄武区', '3', '10809', 'X');
INSERT INTO `ey_region` VALUES ('10820', '白下区', '3', '10809', 'B');
INSERT INTO `ey_region` VALUES ('10831', '秦淮区', '3', '10809', 'Q');
INSERT INTO `ey_region` VALUES ('10837', '建邺区', '3', '10809', 'J');
INSERT INTO `ey_region` VALUES ('10845', '鼓楼区', '3', '10809', 'G');
INSERT INTO `ey_region` VALUES ('10853', '下关区', '3', '10809', 'X');
INSERT INTO `ey_region` VALUES ('10860', '浦口区', '3', '10809', 'P');
INSERT INTO `ey_region` VALUES ('10876', '栖霞区', '3', '10809', 'Q');
INSERT INTO `ey_region` VALUES ('10894', '雨花台区', '3', '10809', 'Y');
INSERT INTO `ey_region` VALUES ('10903', '江宁区', '3', '10809', 'J');
INSERT INTO `ey_region` VALUES ('10916', '六合区', '3', '10809', 'L');
INSERT INTO `ey_region` VALUES ('10937', '溧水县', '3', '10809', 'L');
INSERT INTO `ey_region` VALUES ('10947', '高淳县', '3', '10809', 'G');
INSERT INTO `ey_region` VALUES ('10960', '无锡市', '2', '10808', 'W');
INSERT INTO `ey_region` VALUES ('10961', '市辖区', '3', '10960', 'S');
INSERT INTO `ey_region` VALUES ('10962', '崇安区', '3', '10960', 'C');
INSERT INTO `ey_region` VALUES ('10969', '南长区', '3', '10960', 'N');
INSERT INTO `ey_region` VALUES ('10976', '北塘区', '3', '10960', 'B');
INSERT INTO `ey_region` VALUES ('10981', '锡山区', '3', '10960', 'X');
INSERT INTO `ey_region` VALUES ('10990', '惠山区', '3', '10960', 'H');
INSERT INTO `ey_region` VALUES ('10999', '滨湖区', '3', '10960', 'B');
INSERT INTO `ey_region` VALUES ('11018', '江阴市', '3', '10960', 'J');
INSERT INTO `ey_region` VALUES ('11039', '宜兴市', '3', '10960', 'Y');
INSERT INTO `ey_region` VALUES ('11067', '徐州市', '2', '10808', 'X');
INSERT INTO `ey_region` VALUES ('11068', '市辖区', '3', '11067', 'S');
INSERT INTO `ey_region` VALUES ('11069', '鼓楼区', '3', '11067', 'G');
INSERT INTO `ey_region` VALUES ('11081', '云龙区', '3', '11067', 'Y');
INSERT INTO `ey_region` VALUES ('11089', '九里区', '3', '11067', 'J');
INSERT INTO `ey_region` VALUES ('11103', '贾汪区', '3', '11067', 'J');
INSERT INTO `ey_region` VALUES ('11115', '泉山区', '3', '11067', 'Q');
INSERT INTO `ey_region` VALUES ('11126', '丰县', '3', '11067', 'F');
INSERT INTO `ey_region` VALUES ('11142', '沛县', '3', '11067', 'P');
INSERT INTO `ey_region` VALUES ('11160', '铜山县', '3', '11067', 'T');
INSERT INTO `ey_region` VALUES ('11182', '睢宁县', '3', '11067', 'S');
INSERT INTO `ey_region` VALUES ('11200', '新沂市', '3', '11067', 'X');
INSERT INTO `ey_region` VALUES ('11218', '邳州市', '3', '11067', 'P');
INSERT INTO `ey_region` VALUES ('11245', '常州市', '2', '10808', 'C');
INSERT INTO `ey_region` VALUES ('11246', '常州市区', '3', '11245', 'C');
INSERT INTO `ey_region` VALUES ('11247', '天宁区', '3', '11245', 'T');
INSERT INTO `ey_region` VALUES ('11254', '钟楼区', '3', '11245', 'Z');
INSERT INTO `ey_region` VALUES ('11262', '戚墅堰区', '3', '11245', 'Q');
INSERT INTO `ey_region` VALUES ('11266', '新北区', '3', '11245', 'X');
INSERT INTO `ey_region` VALUES ('11276', '武进区', '3', '11245', 'W');
INSERT INTO `ey_region` VALUES ('11311', '溧阳市', '3', '11245', 'L');
INSERT INTO `ey_region` VALUES ('11331', '金坛市', '3', '11245', 'J');
INSERT INTO `ey_region` VALUES ('11348', '苏州市', '2', '10808', 'S');
INSERT INTO `ey_region` VALUES ('11349', '市辖区', '3', '11348', 'S');
INSERT INTO `ey_region` VALUES ('11350', '沧浪区', '3', '11348', 'C');
INSERT INTO `ey_region` VALUES ('11357', '平江区', '3', '11348', 'P');
INSERT INTO `ey_region` VALUES ('11368', '金阊区', '3', '11348', 'J');
INSERT INTO `ey_region` VALUES ('11374', '苏州高新区虎丘区', '3', '11348', 'S');
INSERT INTO `ey_region` VALUES ('11387', '吴中区', '3', '11348', 'W');
INSERT INTO `ey_region` VALUES ('11409', '相城区', '3', '11348', 'X');
INSERT INTO `ey_region` VALUES ('11419', '常熟市', '3', '11348', 'C');
INSERT INTO `ey_region` VALUES ('11433', '张家港市', '3', '11348', 'Z');
INSERT INTO `ey_region` VALUES ('11448', '昆山市', '3', '11348', 'K');
INSERT INTO `ey_region` VALUES ('11460', '吴江市', '3', '11348', 'W');
INSERT INTO `ey_region` VALUES ('11472', '太仓市', '3', '11348', 'T');
INSERT INTO `ey_region` VALUES ('11482', '南通市', '2', '10808', 'N');
INSERT INTO `ey_region` VALUES ('11483', '市辖区', '3', '11482', 'S');
INSERT INTO `ey_region` VALUES ('11484', '崇川区', '3', '11482', 'C');
INSERT INTO `ey_region` VALUES ('11502', '港闸区', '3', '11482', 'G');
INSERT INTO `ey_region` VALUES ('11510', '海安县', '3', '11482', 'H');
INSERT INTO `ey_region` VALUES ('11526', '如东', '3', '11482', 'R');
INSERT INTO `ey_region` VALUES ('11542', '启东市', '3', '11482', 'Q');
INSERT INTO `ey_region` VALUES ('11568', '如皋市', '3', '11482', 'R');
INSERT INTO `ey_region` VALUES ('11600', '通州市', '3', '11482', 'T');
INSERT INTO `ey_region` VALUES ('11627', '海门市', '3', '11482', 'H');
INSERT INTO `ey_region` VALUES ('11663', '连云港市', '2', '10808', 'L');
INSERT INTO `ey_region` VALUES ('11664', '市辖区', '3', '11663', 'S');
INSERT INTO `ey_region` VALUES ('11665', '连云区', '3', '11663', 'L');
INSERT INTO `ey_region` VALUES ('11678', '新浦区', '3', '11663', 'X');
INSERT INTO `ey_region` VALUES ('11692', '海州区', '3', '11663', 'H');
INSERT INTO `ey_region` VALUES ('11699', '赣榆县', '3', '11663', 'G');
INSERT INTO `ey_region` VALUES ('11722', '东海县', '3', '11663', 'D');
INSERT INTO `ey_region` VALUES ('11747', '灌云县', '3', '11663', 'G');
INSERT INTO `ey_region` VALUES ('11771', '灌南县', '3', '11663', 'G');
INSERT INTO `ey_region` VALUES ('11786', '淮安市', '2', '10808', 'H');
INSERT INTO `ey_region` VALUES ('11787', '市辖区', '3', '11786', 'S');
INSERT INTO `ey_region` VALUES ('11788', '清河区', '3', '11786', 'Q');
INSERT INTO `ey_region` VALUES ('11801', '楚州区', '3', '11786', 'C');
INSERT INTO `ey_region` VALUES ('11830', '淮阴区', '3', '11786', 'H');
INSERT INTO `ey_region` VALUES ('11853', '清浦区', '3', '11786', 'Q');
INSERT INTO `ey_region` VALUES ('11863', '涟水县', '3', '11786', 'L');
INSERT INTO `ey_region` VALUES ('11896', '洪泽县', '3', '11786', 'H');
INSERT INTO `ey_region` VALUES ('11909', '盱眙县', '3', '11786', 'X');
INSERT INTO `ey_region` VALUES ('11931', '金湖县', '3', '11786', 'J');
INSERT INTO `ey_region` VALUES ('11947', '盐城市', '2', '10808', 'Y');
INSERT INTO `ey_region` VALUES ('11948', '市辖区', '3', '11947', 'S');
INSERT INTO `ey_region` VALUES ('11949', '亭湖区', '3', '11947', 'T');
INSERT INTO `ey_region` VALUES ('11967', '盐都区', '3', '11947', 'Y');
INSERT INTO `ey_region` VALUES ('11982', '响水县', '3', '11947', 'X');
INSERT INTO `ey_region` VALUES ('11998', '滨海县', '3', '11947', 'B');
INSERT INTO `ey_region` VALUES ('12017', '阜宁县', '3', '11947', 'F');
INSERT INTO `ey_region` VALUES ('12040', '射阳县', '3', '11947', 'S');
INSERT INTO `ey_region` VALUES ('12066', '建湖县', '3', '11947', 'J');
INSERT INTO `ey_region` VALUES ('12083', '东台市', '3', '11947', 'D');
INSERT INTO `ey_region` VALUES ('12117', '大丰市', '3', '11947', 'D');
INSERT INTO `ey_region` VALUES ('12135', '扬州市', '2', '10808', 'Y');
INSERT INTO `ey_region` VALUES ('12136', '市辖区', '3', '12135', 'S');
INSERT INTO `ey_region` VALUES ('12137', '广陵区', '3', '12135', 'G');
INSERT INTO `ey_region` VALUES ('12144', '邗江区', '3', '12135', 'H');
INSERT INTO `ey_region` VALUES ('12160', '维扬区', '3', '12135', 'W');
INSERT INTO `ey_region` VALUES ('12175', '宝应县', '3', '12135', 'B');
INSERT INTO `ey_region` VALUES ('12191', '仪征市', '3', '12135', 'Y');
INSERT INTO `ey_region` VALUES ('12212', '高邮市', '3', '12135', 'G');
INSERT INTO `ey_region` VALUES ('12235', '江都市', '3', '12135', 'J');
INSERT INTO `ey_region` VALUES ('12249', '镇江市', '2', '10808', 'Z');
INSERT INTO `ey_region` VALUES ('12250', '市区', '3', '12249', 'S');
INSERT INTO `ey_region` VALUES ('12251', '京口区', '3', '12249', 'J');
INSERT INTO `ey_region` VALUES ('12265', '润州区', '3', '12249', 'R');
INSERT INTO `ey_region` VALUES ('12273', '丹徒区', '3', '12249', 'D');
INSERT INTO `ey_region` VALUES ('12282', '丹阳市', '3', '12249', 'D');
INSERT INTO `ey_region` VALUES ('12300', '扬中市', '3', '12249', 'Y');
INSERT INTO `ey_region` VALUES ('12312', '句容市', '3', '12249', 'J');
INSERT INTO `ey_region` VALUES ('12343', '泰州市', '2', '10808', 'T');
INSERT INTO `ey_region` VALUES ('12344', '市辖区', '3', '12343', 'S');
INSERT INTO `ey_region` VALUES ('12345', '海陵区', '3', '12343', 'H');
INSERT INTO `ey_region` VALUES ('12362', '高港区', '3', '12343', 'G');
INSERT INTO `ey_region` VALUES ('12370', '兴化市', '3', '12343', 'X');
INSERT INTO `ey_region` VALUES ('12407', '靖江市', '3', '12343', 'J');
INSERT INTO `ey_region` VALUES ('12423', '泰兴市', '3', '12343', 'T');
INSERT INTO `ey_region` VALUES ('12450', '姜堰市', '3', '12343', 'J');
INSERT INTO `ey_region` VALUES ('12475', '宿迁市', '2', '10808', 'S');
INSERT INTO `ey_region` VALUES ('12476', '市辖区', '3', '12475', 'S');
INSERT INTO `ey_region` VALUES ('12477', '宿城区', '3', '12475', 'S');
INSERT INTO `ey_region` VALUES ('12496', '宿豫区', '3', '12475', 'S');
INSERT INTO `ey_region` VALUES ('12515', '沭阳县', '3', '12475', 'S');
INSERT INTO `ey_region` VALUES ('12551', '泗阳县', '3', '12475', 'S');
INSERT INTO `ey_region` VALUES ('12570', '泗洪县', '3', '12475', 'S');
INSERT INTO `ey_region` VALUES ('12596', '浙江省', '1', '0', 'Z');
INSERT INTO `ey_region` VALUES ('12597', '杭州市', '2', '12596', 'H');
INSERT INTO `ey_region` VALUES ('12598', '市辖区', '3', '12597', 'S');
INSERT INTO `ey_region` VALUES ('12599', '上城区', '3', '12597', 'S');
INSERT INTO `ey_region` VALUES ('12606', '下城区', '3', '12597', 'X');
INSERT INTO `ey_region` VALUES ('12615', '江干区', '3', '12597', 'J');
INSERT INTO `ey_region` VALUES ('12626', '拱墅区', '3', '12597', 'G');
INSERT INTO `ey_region` VALUES ('12637', '西湖区', '3', '12597', 'X');
INSERT INTO `ey_region` VALUES ('12652', '滨江区', '3', '12597', 'B');
INSERT INTO `ey_region` VALUES ('12656', '萧山区', '3', '12597', 'X');
INSERT INTO `ey_region` VALUES ('12685', '余杭区', '3', '12597', 'Y');
INSERT INTO `ey_region` VALUES ('12705', '桐庐县', '3', '12597', 'T');
INSERT INTO `ey_region` VALUES ('12719', '淳安县', '3', '12597', 'C');
INSERT INTO `ey_region` VALUES ('12743', '建德市', '3', '12597', 'J');
INSERT INTO `ey_region` VALUES ('12760', '富阳市', '3', '12597', 'F');
INSERT INTO `ey_region` VALUES ('12786', '临安市', '3', '12597', 'L');
INSERT INTO `ey_region` VALUES ('12813', '宁波市', '2', '12596', 'N');
INSERT INTO `ey_region` VALUES ('12814', '市辖区', '3', '12813', 'S');
INSERT INTO `ey_region` VALUES ('12815', '海曙区', '3', '12813', 'H');
INSERT INTO `ey_region` VALUES ('12824', '江东区', '3', '12813', 'J');
INSERT INTO `ey_region` VALUES ('12832', '江北区', '3', '12813', 'J');
INSERT INTO `ey_region` VALUES ('12841', '北仑区', '3', '12813', 'B');
INSERT INTO `ey_region` VALUES ('12851', '镇海区', '3', '12813', 'Z');
INSERT INTO `ey_region` VALUES ('12858', '鄞州区', '3', '12813', 'Y');
INSERT INTO `ey_region` VALUES ('12881', '象山县', '3', '12813', 'X');
INSERT INTO `ey_region` VALUES ('12900', '宁海县', '3', '12813', 'N');
INSERT INTO `ey_region` VALUES ('12919', '余姚市', '3', '12813', 'Y');
INSERT INTO `ey_region` VALUES ('12941', '慈溪市', '3', '12813', 'C');
INSERT INTO `ey_region` VALUES ('12962', '奉化市', '3', '12813', 'F');
INSERT INTO `ey_region` VALUES ('12974', '温州市', '2', '12596', 'W');
INSERT INTO `ey_region` VALUES ('12975', '市辖区', '3', '12974', 'S');
INSERT INTO `ey_region` VALUES ('12976', '鹿城区', '3', '12974', 'L');
INSERT INTO `ey_region` VALUES ('12998', '龙湾区', '3', '12974', 'L');
INSERT INTO `ey_region` VALUES ('13009', '瓯海区', '3', '12974', 'O');
INSERT INTO `ey_region` VALUES ('13023', '洞头县', '3', '12974', 'D');
INSERT INTO `ey_region` VALUES ('13030', '永嘉县', '3', '12974', 'Y');
INSERT INTO `ey_region` VALUES ('13069', '平阳县', '3', '12974', 'P');
INSERT INTO `ey_region` VALUES ('13101', '苍南县', '3', '12974', 'C');
INSERT INTO `ey_region` VALUES ('13138', '文成县', '3', '12974', 'W');
INSERT INTO `ey_region` VALUES ('13172', '泰顺县', '3', '12974', 'T');
INSERT INTO `ey_region` VALUES ('13209', '瑞安市', '3', '12974', 'R');
INSERT INTO `ey_region` VALUES ('13248', '乐清市', '3', '12974', 'L');
INSERT INTO `ey_region` VALUES ('13280', '嘉兴市', '2', '12596', 'J');
INSERT INTO `ey_region` VALUES ('13281', '市辖区', '3', '13280', 'S');
INSERT INTO `ey_region` VALUES ('13282', '南湖区', '3', '13280', 'N');
INSERT INTO `ey_region` VALUES ('13295', '秀洲区', '3', '13280', 'X');
INSERT INTO `ey_region` VALUES ('13304', '嘉善县', '3', '13280', 'J');
INSERT INTO `ey_region` VALUES ('13316', '海盐县', '3', '13280', 'H');
INSERT INTO `ey_region` VALUES ('13325', '海宁市', '3', '13280', 'H');
INSERT INTO `ey_region` VALUES ('13339', '平湖市', '3', '13280', 'P');
INSERT INTO `ey_region` VALUES ('13350', '桐乡市', '3', '13280', 'T');
INSERT INTO `ey_region` VALUES ('13364', '湖州市', '2', '12596', 'H');
INSERT INTO `ey_region` VALUES ('13365', '市辖区', '3', '13364', 'S');
INSERT INTO `ey_region` VALUES ('13366', '吴兴区', '3', '13364', 'W');
INSERT INTO `ey_region` VALUES ('13382', '南浔区', '3', '13364', 'N');
INSERT INTO `ey_region` VALUES ('13392', '德清县', '3', '13364', 'D');
INSERT INTO `ey_region` VALUES ('13404', '长兴县', '3', '13364', 'C');
INSERT INTO `ey_region` VALUES ('13421', '安吉县', '3', '13364', 'A');
INSERT INTO `ey_region` VALUES ('13437', '绍兴市', '2', '12596', 'S');
INSERT INTO `ey_region` VALUES ('13438', '市辖区', '3', '13437', 'S');
INSERT INTO `ey_region` VALUES ('13439', '越城区', '3', '13437', 'Y');
INSERT INTO `ey_region` VALUES ('13453', '绍兴县', '3', '13437', 'S');
INSERT INTO `ey_region` VALUES ('13473', '新昌县', '3', '13437', 'X');
INSERT INTO `ey_region` VALUES ('13490', '诸暨市', '3', '13437', 'Z');
INSERT INTO `ey_region` VALUES ('13518', '上虞市', '3', '13437', 'S');
INSERT INTO `ey_region` VALUES ('13542', '嵊州市', '3', '13437', 'S');
INSERT INTO `ey_region` VALUES ('13564', '金华市', '2', '12596', 'J');
INSERT INTO `ey_region` VALUES ('13565', '市辖区', '3', '13564', 'S');
INSERT INTO `ey_region` VALUES ('13566', '婺城区', '3', '13564', 'W');
INSERT INTO `ey_region` VALUES ('13594', '金东区', '3', '13564', 'J');
INSERT INTO `ey_region` VALUES ('13606', '武义县', '3', '13564', 'W');
INSERT INTO `ey_region` VALUES ('13625', '浦江县', '3', '13564', 'P');
INSERT INTO `ey_region` VALUES ('13641', '磐安县', '3', '13564', 'P');
INSERT INTO `ey_region` VALUES ('13662', '兰溪市', '3', '13564', 'L');
INSERT INTO `ey_region` VALUES ('13678', '义乌市', '3', '13564', 'Y');
INSERT INTO `ey_region` VALUES ('13692', '东阳市', '3', '13564', 'D');
INSERT INTO `ey_region` VALUES ('13711', '永康市', '3', '13564', 'Y');
INSERT INTO `ey_region` VALUES ('13726', '衢州市', '2', '12596', 'Q');
INSERT INTO `ey_region` VALUES ('13727', '市辖区', '3', '13726', 'S');
INSERT INTO `ey_region` VALUES ('13728', '柯城区', '3', '13726', 'K');
INSERT INTO `ey_region` VALUES ('13746', '衢江区', '3', '13726', 'Q');
INSERT INTO `ey_region` VALUES ('13768', '常山县', '3', '13726', 'C');
INSERT INTO `ey_region` VALUES ('13783', '开化县', '3', '13726', 'K');
INSERT INTO `ey_region` VALUES ('13802', '龙游县', '3', '13726', 'L');
INSERT INTO `ey_region` VALUES ('13818', '江山市', '3', '13726', 'J');
INSERT INTO `ey_region` VALUES ('13840', '舟山市', '2', '12596', 'Z');
INSERT INTO `ey_region` VALUES ('13841', '市辖区', '3', '13840', 'S');
INSERT INTO `ey_region` VALUES ('13842', '定海区', '3', '13840', 'D');
INSERT INTO `ey_region` VALUES ('13859', '普陀区', '3', '13840', 'P');
INSERT INTO `ey_region` VALUES ('13874', '岱山县', '3', '13840', 'D');
INSERT INTO `ey_region` VALUES ('13882', '嵊泗县', '3', '13840', 'S');
INSERT INTO `ey_region` VALUES ('13890', '台州市', '2', '12596', 'T');
INSERT INTO `ey_region` VALUES ('13891', '市辖区', '3', '13890', 'S');
INSERT INTO `ey_region` VALUES ('13892', '椒江区', '3', '13890', 'J');
INSERT INTO `ey_region` VALUES ('13903', '黄岩区', '3', '13890', 'H');
INSERT INTO `ey_region` VALUES ('13923', '路桥区', '3', '13890', 'L');
INSERT INTO `ey_region` VALUES ('13934', '玉环县', '3', '13890', 'Y');
INSERT INTO `ey_region` VALUES ('13944', '三门县', '3', '13890', 'S');
INSERT INTO `ey_region` VALUES ('13959', '天台县', '3', '13890', 'T');
INSERT INTO `ey_region` VALUES ('13975', '仙居县', '3', '13890', 'X');
INSERT INTO `ey_region` VALUES ('13996', '温岭市', '3', '13890', 'W');
INSERT INTO `ey_region` VALUES ('14013', '临海市', '3', '13890', 'L');
INSERT INTO `ey_region` VALUES ('14033', '丽水市', '2', '12596', 'L');
INSERT INTO `ey_region` VALUES ('14034', '市辖区', '3', '14033', 'S');
INSERT INTO `ey_region` VALUES ('14035', '莲都区', '3', '14033', 'L');
INSERT INTO `ey_region` VALUES ('14054', '青田县', '3', '14033', 'Q');
INSERT INTO `ey_region` VALUES ('14086', '缙云县', '3', '14033', 'J');
INSERT INTO `ey_region` VALUES ('14111', '遂昌县', '3', '14033', 'S');
INSERT INTO `ey_region` VALUES ('14132', '松阳县', '3', '14033', 'S');
INSERT INTO `ey_region` VALUES ('14153', '云和县', '3', '14033', 'Y');
INSERT INTO `ey_region` VALUES ('14168', '庆元县', '3', '14033', 'Q');
INSERT INTO `ey_region` VALUES ('14189', '景宁县', '3', '14033', 'J');
INSERT INTO `ey_region` VALUES ('14214', '龙泉市', '3', '14033', 'L');
INSERT INTO `ey_region` VALUES ('14234', '安徽省', '1', '0', 'A');
INSERT INTO `ey_region` VALUES ('14235', '合肥市', '2', '14234', 'H');
INSERT INTO `ey_region` VALUES ('14236', '市辖区', '3', '14235', 'S');
INSERT INTO `ey_region` VALUES ('14237', '瑶海区', '3', '14235', 'Y');
INSERT INTO `ey_region` VALUES ('14254', '庐阳区', '3', '14235', 'L');
INSERT INTO `ey_region` VALUES ('14269', '蜀山区', '3', '14235', 'S');
INSERT INTO `ey_region` VALUES ('14286', '包河区', '3', '14235', 'B');
INSERT INTO `ey_region` VALUES ('14297', '长丰县', '3', '14235', 'C');
INSERT INTO `ey_region` VALUES ('14314', '肥东县', '3', '14235', 'F');
INSERT INTO `ey_region` VALUES ('14334', '肥西县', '3', '14235', 'F');
INSERT INTO `ey_region` VALUES ('14351', '芜湖市', '2', '14234', 'W');
INSERT INTO `ey_region` VALUES ('14352', '市辖区', '3', '14351', 'S');
INSERT INTO `ey_region` VALUES ('14353', '镜湖区', '3', '14351', 'J');
INSERT INTO `ey_region` VALUES ('14366', '弋江区', '3', '14351', 'Y');
INSERT INTO `ey_region` VALUES ('14374', '鸠江区', '3', '14351', 'J');
INSERT INTO `ey_region` VALUES ('14382', '三山区', '3', '14351', 'S');
INSERT INTO `ey_region` VALUES ('14387', '芜湖县', '3', '14351', 'W');
INSERT INTO `ey_region` VALUES ('14394', '繁昌县', '3', '14351', 'F');
INSERT INTO `ey_region` VALUES ('14401', '南陵县', '3', '14351', 'N');
INSERT INTO `ey_region` VALUES ('14410', '蚌埠市', '2', '14234', 'B');
INSERT INTO `ey_region` VALUES ('14411', '市辖区', '3', '14410', 'S');
INSERT INTO `ey_region` VALUES ('14412', '龙子湖区', '3', '14410', 'L');
INSERT INTO `ey_region` VALUES ('14422', '蚌山区', '3', '14410', 'B');
INSERT INTO `ey_region` VALUES ('14434', '禹会区', '3', '14410', 'Y');
INSERT INTO `ey_region` VALUES ('14443', '淮上区', '3', '14410', 'H');
INSERT INTO `ey_region` VALUES ('14449', '怀远县', '3', '14410', 'H');
INSERT INTO `ey_region` VALUES ('14471', '五河县', '3', '14410', 'W');
INSERT INTO `ey_region` VALUES ('14487', '固镇县', '3', '14410', 'G');
INSERT INTO `ey_region` VALUES ('14500', '淮南市', '2', '14234', 'H');
INSERT INTO `ey_region` VALUES ('14501', '市辖区', '3', '14500', 'S');
INSERT INTO `ey_region` VALUES ('14502', '大通区', '3', '14500', 'D');
INSERT INTO `ey_region` VALUES ('14508', '田家庵区', '3', '14500', 'T');
INSERT INTO `ey_region` VALUES ('14523', '谢家集区', '3', '14500', 'X');
INSERT INTO `ey_region` VALUES ('14535', '八公山区', '3', '14500', 'B');
INSERT INTO `ey_region` VALUES ('14542', '潘集区', '3', '14500', 'P');
INSERT INTO `ey_region` VALUES ('14554', '凤台县', '3', '14500', 'F');
INSERT INTO `ey_region` VALUES ('14575', '马鞍山市', '2', '14234', 'M');
INSERT INTO `ey_region` VALUES ('14576', '市辖区', '3', '14575', 'S');
INSERT INTO `ey_region` VALUES ('14577', '金家庄区', '3', '14575', 'J');
INSERT INTO `ey_region` VALUES ('14583', '花山区', '3', '14575', 'H');
INSERT INTO `ey_region` VALUES ('14589', '雨山区', '3', '14575', 'Y');
INSERT INTO `ey_region` VALUES ('14597', '当涂县', '3', '14575', 'D');
INSERT INTO `ey_region` VALUES ('14612', '淮北市', '2', '14234', 'H');
INSERT INTO `ey_region` VALUES ('14613', '市辖区', '3', '14612', 'S');
INSERT INTO `ey_region` VALUES ('14614', '杜集区', '3', '14612', 'D');
INSERT INTO `ey_region` VALUES ('14620', '相山区', '3', '14612', 'X');
INSERT INTO `ey_region` VALUES ('14632', '烈山区', '3', '14612', 'L');
INSERT INTO `ey_region` VALUES ('14641', '濉溪县', '3', '14612', 'S');
INSERT INTO `ey_region` VALUES ('14653', '铜陵市', '2', '14234', 'T');
INSERT INTO `ey_region` VALUES ('14654', '市辖区', '3', '14653', 'S');
INSERT INTO `ey_region` VALUES ('14655', '铜官山区', '3', '14653', 'T');
INSERT INTO `ey_region` VALUES ('14663', '狮子山区', '3', '14653', 'S');
INSERT INTO `ey_region` VALUES ('14671', '铜陵市郊区', '3', '14653', 'T');
INSERT INTO `ey_region` VALUES ('14678', '铜陵县', '3', '14653', 'T');
INSERT INTO `ey_region` VALUES ('14687', '安庆市', '2', '14234', 'A');
INSERT INTO `ey_region` VALUES ('14688', '市辖区', '3', '14687', 'S');
INSERT INTO `ey_region` VALUES ('14689', '迎江区', '3', '14687', 'Y');
INSERT INTO `ey_region` VALUES ('14700', '大观区', '3', '14687', 'D');
INSERT INTO `ey_region` VALUES ('14712', '宜秀区', '3', '14687', 'Y');
INSERT INTO `ey_region` VALUES ('14720', '怀宁县', '3', '14687', 'H');
INSERT INTO `ey_region` VALUES ('14741', '枞阳县', '3', '14687', 'C');
INSERT INTO `ey_region` VALUES ('14764', '潜山县', '3', '14687', 'Q');
INSERT INTO `ey_region` VALUES ('14782', '太湖县', '3', '14687', 'T');
INSERT INTO `ey_region` VALUES ('14798', '宿松县', '3', '14687', 'S');
INSERT INTO `ey_region` VALUES ('14823', '望江县', '3', '14687', 'W');
INSERT INTO `ey_region` VALUES ('14834', '岳西县', '3', '14687', 'Y');
INSERT INTO `ey_region` VALUES ('14859', '桐城市', '3', '14687', 'T');
INSERT INTO `ey_region` VALUES ('14887', '黄山市', '2', '14234', 'H');
INSERT INTO `ey_region` VALUES ('14888', '市辖区', '3', '14887', 'S');
INSERT INTO `ey_region` VALUES ('14889', '屯溪区', '3', '14887', 'T');
INSERT INTO `ey_region` VALUES ('14900', '黄山区', '3', '14887', 'H');
INSERT INTO `ey_region` VALUES ('14917', '徽州区', '3', '14887', 'H');
INSERT INTO `ey_region` VALUES ('14926', '歙县', '3', '14887', 'S');
INSERT INTO `ey_region` VALUES ('14955', '休宁县', '3', '14887', 'X');
INSERT INTO `ey_region` VALUES ('14977', '黟县', '3', '14887', 'Y');
INSERT INTO `ey_region` VALUES ('14986', '祁门县', '3', '14887', 'Q');
INSERT INTO `ey_region` VALUES ('15005', '滁州市', '2', '14234', 'C');
INSERT INTO `ey_region` VALUES ('15006', '市辖区', '3', '15005', 'S');
INSERT INTO `ey_region` VALUES ('15007', '琅琊区', '3', '15005', 'L');
INSERT INTO `ey_region` VALUES ('15016', '南谯区', '3', '15005', 'N');
INSERT INTO `ey_region` VALUES ('15034', '来安县', '3', '15005', 'L');
INSERT INTO `ey_region` VALUES ('15053', '全椒县', '3', '15005', 'Q');
INSERT INTO `ey_region` VALUES ('15071', '定远县', '3', '15005', 'D');
INSERT INTO `ey_region` VALUES ('15109', '凤阳县', '3', '15005', 'F');
INSERT INTO `ey_region` VALUES ('15136', '天长市', '3', '15005', 'T');
INSERT INTO `ey_region` VALUES ('15166', '明光市', '3', '15005', 'M');
INSERT INTO `ey_region` VALUES ('15194', '阜阳市', '2', '14234', 'F');
INSERT INTO `ey_region` VALUES ('15195', '市辖区', '3', '15194', 'S');
INSERT INTO `ey_region` VALUES ('15196', '颍州区', '3', '15194', 'Y');
INSERT INTO `ey_region` VALUES ('15211', '颍东区', '3', '15194', 'Y');
INSERT INTO `ey_region` VALUES ('15224', '颍泉区', '3', '15194', 'Y');
INSERT INTO `ey_region` VALUES ('15231', '临泉县', '3', '15194', 'L');
INSERT INTO `ey_region` VALUES ('15264', '太和县', '3', '15194', 'T');
INSERT INTO `ey_region` VALUES ('15296', '阜南县', '3', '15194', 'F');
INSERT INTO `ey_region` VALUES ('15328', '颍上县', '3', '15194', 'Y');
INSERT INTO `ey_region` VALUES ('15359', '界首市', '3', '15194', 'J');
INSERT INTO `ey_region` VALUES ('15378', '宿州市', '2', '14234', 'S');
INSERT INTO `ey_region` VALUES ('15379', '市辖区', '3', '15378', 'S');
INSERT INTO `ey_region` VALUES ('15380', '墉桥区', '3', '15378', 'Y');
INSERT INTO `ey_region` VALUES ('15417', '砀山县', '3', '15378', 'D');
INSERT INTO `ey_region` VALUES ('15437', '萧县', '3', '15378', 'X');
INSERT INTO `ey_region` VALUES ('15461', '灵璧县', '3', '15378', 'L');
INSERT INTO `ey_region` VALUES ('15482', '泗县', '3', '15378', 'S');
INSERT INTO `ey_region` VALUES ('15499', '巢湖市', '2', '14234', 'C');
INSERT INTO `ey_region` VALUES ('15500', '市辖区', '3', '15499', 'S');
INSERT INTO `ey_region` VALUES ('15501', '居巢区', '3', '15499', 'J');
INSERT INTO `ey_region` VALUES ('15520', '庐江县', '3', '15499', 'L');
INSERT INTO `ey_region` VALUES ('15542', '无为县', '3', '15499', 'W');
INSERT INTO `ey_region` VALUES ('15566', '含山县', '3', '15499', 'H');
INSERT INTO `ey_region` VALUES ('15575', '和县', '3', '15499', 'H');
INSERT INTO `ey_region` VALUES ('15586', '六安市', '2', '14234', 'L');
INSERT INTO `ey_region` VALUES ('15587', '市辖区', '3', '15586', 'S');
INSERT INTO `ey_region` VALUES ('15588', '金安区', '3', '15586', 'J');
INSERT INTO `ey_region` VALUES ('15612', '裕安区', '3', '15586', 'Y');
INSERT INTO `ey_region` VALUES ('15635', '寿县', '3', '15586', 'S');
INSERT INTO `ey_region` VALUES ('15662', '霍邱县', '3', '15586', 'H');
INSERT INTO `ey_region` VALUES ('15698', '舒城县', '3', '15586', 'S');
INSERT INTO `ey_region` VALUES ('15720', '金寨县', '3', '15586', 'J');
INSERT INTO `ey_region` VALUES ('15747', '霍山县', '3', '15586', 'H');
INSERT INTO `ey_region` VALUES ('15764', '亳州市', '2', '14234', 'H');
INSERT INTO `ey_region` VALUES ('15765', '市辖区', '3', '15764', 'S');
INSERT INTO `ey_region` VALUES ('15766', '谯城区', '3', '15764', 'Q');
INSERT INTO `ey_region` VALUES ('15795', '涡阳县', '3', '15764', 'W');
INSERT INTO `ey_region` VALUES ('15823', '蒙城县', '3', '15764', 'M');
INSERT INTO `ey_region` VALUES ('15843', '利辛县', '3', '15764', 'L');
INSERT INTO `ey_region` VALUES ('15871', '池州市', '2', '14234', 'C');
INSERT INTO `ey_region` VALUES ('15872', '市辖区', '3', '15871', 'S');
INSERT INTO `ey_region` VALUES ('15873', '贵池区', '3', '15871', 'G');
INSERT INTO `ey_region` VALUES ('15900', '东至县', '3', '15871', 'D');
INSERT INTO `ey_region` VALUES ('15930', '石台县', '3', '15871', 'S');
INSERT INTO `ey_region` VALUES ('15944', '青阳县', '3', '15871', 'Q');
INSERT INTO `ey_region` VALUES ('15958', '宣城市', '2', '14234', 'X');
INSERT INTO `ey_region` VALUES ('15959', '市辖区', '3', '15958', 'S');
INSERT INTO `ey_region` VALUES ('15960', '宣州区', '3', '15958', 'X');
INSERT INTO `ey_region` VALUES ('15987', '郎溪县', '3', '15958', 'L');
INSERT INTO `ey_region` VALUES ('16001', '广德县', '3', '15958', 'G');
INSERT INTO `ey_region` VALUES ('16013', '泾县', '3', '15958', 'J');
INSERT INTO `ey_region` VALUES ('16025', '绩溪县', '3', '15958', 'J');
INSERT INTO `ey_region` VALUES ('16037', '旌德县', '3', '15958', 'J');
INSERT INTO `ey_region` VALUES ('16048', '宁国市', '3', '15958', 'N');
INSERT INTO `ey_region` VALUES ('16068', '福建省', '1', '0', 'F');
INSERT INTO `ey_region` VALUES ('16069', '福州市', '2', '16068', 'F');
INSERT INTO `ey_region` VALUES ('16070', '市辖区', '3', '16069', 'S');
INSERT INTO `ey_region` VALUES ('16071', '鼓楼区', '3', '16069', 'G');
INSERT INTO `ey_region` VALUES ('16082', '台江区', '3', '16069', 'T');
INSERT INTO `ey_region` VALUES ('16093', '仓山区', '3', '16069', 'C');
INSERT INTO `ey_region` VALUES ('16108', '马尾区', '3', '16069', 'M');
INSERT INTO `ey_region` VALUES ('16113', '晋安区', '3', '16069', 'J');
INSERT INTO `ey_region` VALUES ('16123', '闽侯县', '3', '16069', 'M');
INSERT INTO `ey_region` VALUES ('16140', '连江县', '3', '16069', 'L');
INSERT INTO `ey_region` VALUES ('16164', '罗源县', '3', '16069', 'L');
INSERT INTO `ey_region` VALUES ('16177', '闽清县', '3', '16069', 'M');
INSERT INTO `ey_region` VALUES ('16194', '永泰县', '3', '16069', 'Y');
INSERT INTO `ey_region` VALUES ('16216', '平潭县', '3', '16069', 'P');
INSERT INTO `ey_region` VALUES ('16232', '福清市', '3', '16069', 'F');
INSERT INTO `ey_region` VALUES ('16259', '长乐市', '3', '16069', 'C');
INSERT INTO `ey_region` VALUES ('16278', '厦门市', '2', '16068', 'X');
INSERT INTO `ey_region` VALUES ('16279', '市辖区', '3', '16278', 'S');
INSERT INTO `ey_region` VALUES ('16280', '思明区', '3', '16278', 'S');
INSERT INTO `ey_region` VALUES ('16294', '海沧区', '3', '16278', 'H');
INSERT INTO `ey_region` VALUES ('16303', '湖里区', '3', '16278', 'H');
INSERT INTO `ey_region` VALUES ('16315', '集美区', '3', '16278', 'J');
INSERT INTO `ey_region` VALUES ('16326', '同安区', '3', '16278', 'T');
INSERT INTO `ey_region` VALUES ('16341', '翔安区', '3', '16278', 'X');
INSERT INTO `ey_region` VALUES ('16348', '莆田市', '2', '16068', 'P');
INSERT INTO `ey_region` VALUES ('16349', '市辖区', '3', '16348', 'S');
INSERT INTO `ey_region` VALUES ('16350', '城厢区', '3', '16348', 'C');
INSERT INTO `ey_region` VALUES ('16358', '涵江区', '3', '16348', 'H');
INSERT INTO `ey_region` VALUES ('16372', '荔城区', '3', '16348', 'L');
INSERT INTO `ey_region` VALUES ('16379', '秀屿区', '3', '16348', 'X');
INSERT INTO `ey_region` VALUES ('16393', '仙游县', '3', '16348', 'X');
INSERT INTO `ey_region` VALUES ('16412', '三明市', '2', '16068', 'S');
INSERT INTO `ey_region` VALUES ('16413', '市辖区', '3', '16412', 'S');
INSERT INTO `ey_region` VALUES ('16414', '梅列区', '3', '16412', 'M');
INSERT INTO `ey_region` VALUES ('16421', '三元区', '3', '16412', 'S');
INSERT INTO `ey_region` VALUES ('16430', '明溪县', '3', '16412', 'M');
INSERT INTO `ey_region` VALUES ('16440', '清流县', '3', '16412', 'Q');
INSERT INTO `ey_region` VALUES ('16455', '宁化县', '3', '16412', 'N');
INSERT INTO `ey_region` VALUES ('16472', '大田县', '3', '16412', 'D');
INSERT INTO `ey_region` VALUES ('16492', '尤溪县', '3', '16412', 'Y');
INSERT INTO `ey_region` VALUES ('16508', '沙县', '3', '16412', 'S');
INSERT INTO `ey_region` VALUES ('16521', '将乐县', '3', '16412', 'J');
INSERT INTO `ey_region` VALUES ('16535', '泰宁县', '3', '16412', 'T');
INSERT INTO `ey_region` VALUES ('16545', '建宁县', '3', '16412', 'J');
INSERT INTO `ey_region` VALUES ('16556', '永安市', '3', '16412', 'Y');
INSERT INTO `ey_region` VALUES ('16572', '泉州市', '2', '16068', 'Q');
INSERT INTO `ey_region` VALUES ('16573', '市辖区', '3', '16572', 'S');
INSERT INTO `ey_region` VALUES ('16574', '鲤城区', '3', '16572', 'L');
INSERT INTO `ey_region` VALUES ('16584', '丰泽区', '3', '16572', 'F');
INSERT INTO `ey_region` VALUES ('16593', '洛江区', '3', '16572', 'L');
INSERT INTO `ey_region` VALUES ('16600', '泉港区', '3', '16572', 'Q');
INSERT INTO `ey_region` VALUES ('16608', '惠安县', '3', '16572', 'H');
INSERT INTO `ey_region` VALUES ('16625', '安溪县', '3', '16572', 'A');
INSERT INTO `ey_region` VALUES ('16650', '永春县', '3', '16572', 'Y');
INSERT INTO `ey_region` VALUES ('16673', '德化县', '3', '16572', 'D');
INSERT INTO `ey_region` VALUES ('16692', '金门县', '3', '16572', 'J');
INSERT INTO `ey_region` VALUES ('16693', '石狮市', '3', '16572', 'S');
INSERT INTO `ey_region` VALUES ('16703', '晋江市', '3', '16572', 'J');
INSERT INTO `ey_region` VALUES ('16726', '南安市', '3', '16572', 'N');
INSERT INTO `ey_region` VALUES ('16754', '漳州市', '2', '16068', 'Z');
INSERT INTO `ey_region` VALUES ('16755', '市辖区', '3', '16754', 'S');
INSERT INTO `ey_region` VALUES ('16756', '芗城区', '3', '16754', 'X');
INSERT INTO `ey_region` VALUES ('16772', '龙文区', '3', '16754', 'L');
INSERT INTO `ey_region` VALUES ('16778', '云霄县', '3', '16754', 'Y');
INSERT INTO `ey_region` VALUES ('16790', '漳浦县', '3', '16754', 'Z');
INSERT INTO `ey_region` VALUES ('16821', '诏安县', '3', '16754', 'Z');
INSERT INTO `ey_region` VALUES ('16842', '长泰县', '3', '16754', 'C');
INSERT INTO `ey_region` VALUES ('16852', '东山县', '3', '16754', 'D');
INSERT INTO `ey_region` VALUES ('16860', '南靖县', '3', '16754', 'N');
INSERT INTO `ey_region` VALUES ('16872', '平和县', '3', '16754', 'P');
INSERT INTO `ey_region` VALUES ('16889', '华安县', '3', '16754', 'H');
INSERT INTO `ey_region` VALUES ('16899', '龙海市', '3', '16754', 'L');
INSERT INTO `ey_region` VALUES ('16924', '南平市', '2', '16068', 'N');
INSERT INTO `ey_region` VALUES ('16925', '市辖区', '3', '16924', 'S');
INSERT INTO `ey_region` VALUES ('16926', '延平区', '3', '16924', 'Y');
INSERT INTO `ey_region` VALUES ('16948', '顺昌县', '3', '16924', 'S');
INSERT INTO `ey_region` VALUES ('16961', '浦城县', '3', '16924', 'P');
INSERT INTO `ey_region` VALUES ('16982', '光泽县', '3', '16924', 'G');
INSERT INTO `ey_region` VALUES ('16991', '松溪县', '3', '16924', 'S');
INSERT INTO `ey_region` VALUES ('17001', '政和县', '3', '16924', 'Z');
INSERT INTO `ey_region` VALUES ('17012', '邵武市', '3', '16924', 'S');
INSERT INTO `ey_region` VALUES ('17033', '武夷山市', '3', '16924', 'W');
INSERT INTO `ey_region` VALUES ('17044', '建瓯市', '3', '16924', 'J');
INSERT INTO `ey_region` VALUES ('17063', '建阳市', '3', '16924', 'J');
INSERT INTO `ey_region` VALUES ('17077', '龙岩市', '2', '16068', 'L');
INSERT INTO `ey_region` VALUES ('17078', '市辖区', '3', '17077', 'S');
INSERT INTO `ey_region` VALUES ('17079', '新罗区', '3', '17077', 'X');
INSERT INTO `ey_region` VALUES ('17099', '长汀县', '3', '17077', 'C');
INSERT INTO `ey_region` VALUES ('17118', '永定县', '3', '17077', 'Y');
INSERT INTO `ey_region` VALUES ('17143', '上杭县', '3', '17077', 'S');
INSERT INTO `ey_region` VALUES ('17166', '武平县', '3', '17077', 'W');
INSERT INTO `ey_region` VALUES ('17184', '连城县', '3', '17077', 'L');
INSERT INTO `ey_region` VALUES ('17202', '漳平市', '3', '17077', 'Z');
INSERT INTO `ey_region` VALUES ('17219', '宁德市　', '2', '16068', 'N');
INSERT INTO `ey_region` VALUES ('17220', '市辖区', '3', '17219', 'S');
INSERT INTO `ey_region` VALUES ('17221', '蕉城区', '3', '17219', 'J');
INSERT INTO `ey_region` VALUES ('17239', '霞浦县', '3', '17219', 'X');
INSERT INTO `ey_region` VALUES ('17254', '古田县', '3', '17219', 'G');
INSERT INTO `ey_region` VALUES ('17269', '屏南县', '3', '17219', 'P');
INSERT INTO `ey_region` VALUES ('17281', '寿宁县', '3', '17219', 'S');
INSERT INTO `ey_region` VALUES ('17296', '周宁县', '3', '17219', 'Z');
INSERT INTO `ey_region` VALUES ('17306', '柘荣县', '3', '17219', 'Z');
INSERT INTO `ey_region` VALUES ('17316', '福安市', '3', '17219', 'F');
INSERT INTO `ey_region` VALUES ('17341', '福鼎市', '3', '17219', 'F');
INSERT INTO `ey_region` VALUES ('17359', '江西省', '1', '0', 'J');
INSERT INTO `ey_region` VALUES ('17360', '南昌市', '2', '17359', 'N');
INSERT INTO `ey_region` VALUES ('17361', '市辖区', '3', '17360', 'S');
INSERT INTO `ey_region` VALUES ('17362', '东湖区', '3', '17360', 'D');
INSERT INTO `ey_region` VALUES ('17374', '西湖区', '3', '17360', 'X');
INSERT INTO `ey_region` VALUES ('17387', '青云谱区', '3', '17360', 'Q');
INSERT INTO `ey_region` VALUES ('17395', '湾里区', '3', '17360', 'W');
INSERT INTO `ey_region` VALUES ('17402', '青山湖区', '3', '17360', 'Q');
INSERT INTO `ey_region` VALUES ('17420', '南昌县', '3', '17360', 'N');
INSERT INTO `ey_region` VALUES ('17443', '新建县', '3', '17360', 'X');
INSERT INTO `ey_region` VALUES ('17471', '安义县', '3', '17360', 'A');
INSERT INTO `ey_region` VALUES ('17485', '进贤县', '3', '17360', 'J');
INSERT INTO `ey_region` VALUES ('17508', '景德镇市', '2', '17359', 'J');
INSERT INTO `ey_region` VALUES ('17509', '市辖区', '3', '17508', 'S');
INSERT INTO `ey_region` VALUES ('17510', '昌江区', '3', '17508', 'C');
INSERT INTO `ey_region` VALUES ('17534', '珠山区', '3', '17508', 'Z');
INSERT INTO `ey_region` VALUES ('17545', '浮梁县', '3', '17508', 'F');
INSERT INTO `ey_region` VALUES ('17568', '乐平市', '3', '17508', 'L');
INSERT INTO `ey_region` VALUES ('17589', '萍乡市', '2', '17359', 'P');
INSERT INTO `ey_region` VALUES ('17590', '市辖区', '3', '17589', 'S');
INSERT INTO `ey_region` VALUES ('17591', '安源区', '3', '17589', 'A');
INSERT INTO `ey_region` VALUES ('17604', '湘东区', '3', '17589', 'X');
INSERT INTO `ey_region` VALUES ('17616', '莲花县', '3', '17589', 'L');
INSERT INTO `ey_region` VALUES ('17630', '上栗县', '3', '17589', 'S');
INSERT INTO `ey_region` VALUES ('17640', '芦溪县', '3', '17589', 'L');
INSERT INTO `ey_region` VALUES ('17651', '九江市', '2', '17359', 'J');
INSERT INTO `ey_region` VALUES ('17652', '市辖区', '3', '17651', 'S');
INSERT INTO `ey_region` VALUES ('17653', '庐山区', '3', '17651', 'L');
INSERT INTO `ey_region` VALUES ('17667', '浔阳区', '3', '17651', 'X');
INSERT INTO `ey_region` VALUES ('17676', '九江县', '3', '17651', 'J');
INSERT INTO `ey_region` VALUES ('17693', '武宁县', '3', '17651', 'W');
INSERT INTO `ey_region` VALUES ('17714', '修水县', '3', '17651', 'X');
INSERT INTO `ey_region` VALUES ('17751', '永修县', '3', '17651', 'Y');
INSERT INTO `ey_region` VALUES ('17773', '德安县', '3', '17651', 'D');
INSERT INTO `ey_region` VALUES ('17792', '星子县', '3', '17651', 'X');
INSERT INTO `ey_region` VALUES ('17807', '都昌县', '3', '17651', 'D');
INSERT INTO `ey_region` VALUES ('17834', '湖口县', '3', '17651', 'H');
INSERT INTO `ey_region` VALUES ('17849', '彭泽县', '3', '17651', 'P');
INSERT INTO `ey_region` VALUES ('17872', '瑞昌市', '3', '17651', 'R');
INSERT INTO `ey_region` VALUES ('17894', '新余市', '2', '17359', 'X');
INSERT INTO `ey_region` VALUES ('17895', '市辖区', '3', '17894', 'S');
INSERT INTO `ey_region` VALUES ('17896', '渝水区', '3', '17894', 'Y');
INSERT INTO `ey_region` VALUES ('17917', '分宜县', '3', '17894', 'F');
INSERT INTO `ey_region` VALUES ('17934', '鹰潭市', '2', '17359', 'Y');
INSERT INTO `ey_region` VALUES ('17935', '市辖区', '3', '17934', 'S');
INSERT INTO `ey_region` VALUES ('17936', '月湖区', '3', '17934', 'Y');
INSERT INTO `ey_region` VALUES ('17945', '余江县', '3', '17934', 'Y');
INSERT INTO `ey_region` VALUES ('17966', '贵溪市', '3', '17934', 'G');
INSERT INTO `ey_region` VALUES ('17999', '赣州市', '2', '17359', 'G');
INSERT INTO `ey_region` VALUES ('18000', '市辖区', '3', '17999', 'S');
INSERT INTO `ey_region` VALUES ('18001', '章贡区', '3', '17999', 'Z');
INSERT INTO `ey_region` VALUES ('18016', '赣县', '3', '17999', 'G');
INSERT INTO `ey_region` VALUES ('18037', '信丰县', '3', '17999', 'X');
INSERT INTO `ey_region` VALUES ('18055', '大余县', '3', '17999', 'D');
INSERT INTO `ey_region` VALUES ('18068', '上犹县', '3', '17999', 'S');
INSERT INTO `ey_region` VALUES ('18084', '崇义县', '3', '17999', 'C');
INSERT INTO `ey_region` VALUES ('18102', '安远县', '3', '17999', 'A');
INSERT INTO `ey_region` VALUES ('18122', '龙南县', '3', '17999', 'L');
INSERT INTO `ey_region` VALUES ('18139', '定南县', '3', '17999', 'D');
INSERT INTO `ey_region` VALUES ('18148', '全南县', '3', '17999', 'Q');
INSERT INTO `ey_region` VALUES ('18161', '宁都县', '3', '17999', 'N');
INSERT INTO `ey_region` VALUES ('18187', '于都县', '3', '17999', 'Y');
INSERT INTO `ey_region` VALUES ('18212', '兴国县', '3', '17999', 'X');
INSERT INTO `ey_region` VALUES ('18239', '会昌县', '3', '17999', 'H');
INSERT INTO `ey_region` VALUES ('18260', '寻乌县', '3', '17999', 'X');
INSERT INTO `ey_region` VALUES ('18276', '石城县', '3', '17999', 'S');
INSERT INTO `ey_region` VALUES ('18287', '瑞金市', '3', '17999', 'R');
INSERT INTO `ey_region` VALUES ('18306', '南康市', '3', '17999', 'N');
INSERT INTO `ey_region` VALUES ('18330', '吉安市', '2', '17359', 'J');
INSERT INTO `ey_region` VALUES ('18331', '市辖区', '3', '18330', 'S');
INSERT INTO `ey_region` VALUES ('18332', '吉州区', '3', '18330', 'J');
INSERT INTO `ey_region` VALUES ('18345', '青原区', '3', '18330', 'Q');
INSERT INTO `ey_region` VALUES ('18356', '吉安县', '3', '18330', 'J');
INSERT INTO `ey_region` VALUES ('18378', '吉水县', '3', '18330', 'J');
INSERT INTO `ey_region` VALUES ('18398', '峡江县', '3', '18330', 'X');
INSERT INTO `ey_region` VALUES ('18411', '新干县', '3', '18330', 'X');
INSERT INTO `ey_region` VALUES ('18429', '永丰县', '3', '18330', 'Y');
INSERT INTO `ey_region` VALUES ('18454', '泰和县', '3', '18330', 'T');
INSERT INTO `ey_region` VALUES ('18483', '遂川县', '3', '18330', 'S');
INSERT INTO `ey_region` VALUES ('18510', '万安县', '3', '18330', 'W');
INSERT INTO `ey_region` VALUES ('18529', '安福县', '3', '18330', 'A');
INSERT INTO `ey_region` VALUES ('18550', '永新县', '3', '18330', 'Y');
INSERT INTO `ey_region` VALUES ('18575', '井冈山市', '3', '18330', 'J');
INSERT INTO `ey_region` VALUES ('18598', '宜春市', '2', '17359', 'Y');
INSERT INTO `ey_region` VALUES ('18599', '市辖区', '3', '18598', 'S');
INSERT INTO `ey_region` VALUES ('18600', '袁州区', '3', '18598', 'Y');
INSERT INTO `ey_region` VALUES ('18639', '奉新县', '3', '18598', 'F');
INSERT INTO `ey_region` VALUES ('18659', '万载县', '3', '18598', 'W');
INSERT INTO `ey_region` VALUES ('18678', '上高县', '3', '18598', 'S');
INSERT INTO `ey_region` VALUES ('18696', '宜丰县', '3', '18598', 'Y');
INSERT INTO `ey_region` VALUES ('18714', '靖安县', '3', '18598', 'J');
INSERT INTO `ey_region` VALUES ('18727', '铜鼓县', '3', '18598', 'T');
INSERT INTO `ey_region` VALUES ('18741', '丰城市', '3', '18598', 'F');
INSERT INTO `ey_region` VALUES ('18777', '樟树市', '3', '18598', 'Z');
INSERT INTO `ey_region` VALUES ('18799', '高安市', '3', '18598', 'G');
INSERT INTO `ey_region` VALUES ('18829', '抚州市', '2', '17359', 'F');
INSERT INTO `ey_region` VALUES ('18830', '市辖区', '3', '18829', 'S');
INSERT INTO `ey_region` VALUES ('18831', '临川区', '3', '18829', 'L');
INSERT INTO `ey_region` VALUES ('18869', '南城县', '3', '18829', 'N');
INSERT INTO `ey_region` VALUES ('18882', '黎川县', '3', '18829', 'L');
INSERT INTO `ey_region` VALUES ('18900', '南丰县', '3', '18829', 'N');
INSERT INTO `ey_region` VALUES ('18915', '崇仁县', '3', '18829', 'C');
INSERT INTO `ey_region` VALUES ('18931', '乐安县', '3', '18829', 'L');
INSERT INTO `ey_region` VALUES ('18949', '宜黄县', '3', '18829', 'Y');
INSERT INTO `ey_region` VALUES ('18965', '金溪县', '3', '18829', 'J');
INSERT INTO `ey_region` VALUES ('18980', '资溪县', '3', '18829', 'Z');
INSERT INTO `ey_region` VALUES ('18988', '东乡县', '3', '18829', 'D');
INSERT INTO `ey_region` VALUES ('19010', '广昌县', '3', '18829', 'G');
INSERT INTO `ey_region` VALUES ('19024', '上饶市', '2', '17359', 'S');
INSERT INTO `ey_region` VALUES ('19025', '市辖区', '3', '19024', 'S');
INSERT INTO `ey_region` VALUES ('19026', '信州区', '3', '19024', 'X');
INSERT INTO `ey_region` VALUES ('19038', '上饶县', '3', '19024', 'S');
INSERT INTO `ey_region` VALUES ('19062', '广丰县', '3', '19024', 'G');
INSERT INTO `ey_region` VALUES ('19088', '玉山县', '3', '19024', 'Y');
INSERT INTO `ey_region` VALUES ('19108', '铅山县', '3', '19024', 'Q');
INSERT INTO `ey_region` VALUES ('19136', '横峰县', '3', '19024', 'H');
INSERT INTO `ey_region` VALUES ('19151', '弋阳县', '3', '19024', 'Y');
INSERT INTO `ey_region` VALUES ('19171', '余干县', '3', '19024', 'Y');
INSERT INTO `ey_region` VALUES ('19202', '鄱阳县', '3', '19024', 'P');
INSERT INTO `ey_region` VALUES ('19234', '万年县', '3', '19024', 'W');
INSERT INTO `ey_region` VALUES ('19248', '婺源县', '3', '19024', 'W');
INSERT INTO `ey_region` VALUES ('19265', '德兴市', '3', '19024', 'D');
INSERT INTO `ey_region` VALUES ('19280', '山东省', '1', '0', 'S');
INSERT INTO `ey_region` VALUES ('19281', '济南市', '2', '19280', 'J');
INSERT INTO `ey_region` VALUES ('19282', '市辖区', '3', '19281', 'S');
INSERT INTO `ey_region` VALUES ('19283', '历下区', '3', '19281', 'L');
INSERT INTO `ey_region` VALUES ('19295', '市中区', '3', '19281', 'S');
INSERT INTO `ey_region` VALUES ('19311', '槐荫区', '3', '19281', 'H');
INSERT INTO `ey_region` VALUES ('19326', '天桥区', '3', '19281', 'T');
INSERT INTO `ey_region` VALUES ('19342', '历城区', '3', '19281', 'L');
INSERT INTO `ey_region` VALUES ('19359', '长清区', '3', '19281', 'C');
INSERT INTO `ey_region` VALUES ('19370', '平阴县', '3', '19281', 'P');
INSERT INTO `ey_region` VALUES ('19378', '济阳县', '3', '19281', 'J');
INSERT INTO `ey_region` VALUES ('19387', '商河县', '3', '19281', 'S');
INSERT INTO `ey_region` VALUES ('19400', '章丘市', '3', '19281', 'Z');
INSERT INTO `ey_region` VALUES ('19421', '青岛市', '2', '19280', 'Q');
INSERT INTO `ey_region` VALUES ('19422', '市辖区', '3', '19421', 'S');
INSERT INTO `ey_region` VALUES ('19423', '市南区', '3', '19421', 'S');
INSERT INTO `ey_region` VALUES ('19438', '市北区', '3', '19421', 'S');
INSERT INTO `ey_region` VALUES ('19456', '四方区', '3', '19421', 'S');
INSERT INTO `ey_region` VALUES ('19464', '黄岛区', '3', '19421', 'H');
INSERT INTO `ey_region` VALUES ('19471', '崂山区', '3', '19421', 'L');
INSERT INTO `ey_region` VALUES ('19476', '李沧区', '3', '19421', 'L');
INSERT INTO `ey_region` VALUES ('19488', '城阳区', '3', '19421', 'C');
INSERT INTO `ey_region` VALUES ('19497', '胶州市', '3', '19421', 'J');
INSERT INTO `ey_region` VALUES ('19516', '即墨市', '3', '19421', 'J');
INSERT INTO `ey_region` VALUES ('19540', '平度市', '3', '19421', 'P');
INSERT INTO `ey_region` VALUES ('19572', '胶南市', '3', '19421', 'J');
INSERT INTO `ey_region` VALUES ('19590', '莱西市', '3', '19421', 'L');
INSERT INTO `ey_region` VALUES ('19608', '淄博市', '2', '19280', 'Z');
INSERT INTO `ey_region` VALUES ('19609', '市辖区', '3', '19608', 'S');
INSERT INTO `ey_region` VALUES ('19610', '淄川区', '3', '19608', 'Z');
INSERT INTO `ey_region` VALUES ('19632', '张店区', '3', '19608', 'Z');
INSERT INTO `ey_region` VALUES ('19649', '博山区', '3', '19608', 'B');
INSERT INTO `ey_region` VALUES ('19663', '临淄区', '3', '19608', 'L');
INSERT INTO `ey_region` VALUES ('19678', '周村区', '3', '19608', 'Z');
INSERT INTO `ey_region` VALUES ('19688', '桓台县', '3', '19608', 'H');
INSERT INTO `ey_region` VALUES ('19700', '高青县', '3', '19608', 'G');
INSERT INTO `ey_region` VALUES ('19710', '沂源县', '3', '19608', 'Y');
INSERT INTO `ey_region` VALUES ('19724', '枣庄市', '2', '19280', 'Z');
INSERT INTO `ey_region` VALUES ('19725', '市辖区', '3', '19724', 'S');
INSERT INTO `ey_region` VALUES ('19726', '市中区', '3', '19724', 'S');
INSERT INTO `ey_region` VALUES ('19738', '薛城区', '3', '19724', 'X');
INSERT INTO `ey_region` VALUES ('19748', '峄城区', '3', '19724', 'Y');
INSERT INTO `ey_region` VALUES ('19756', '台儿庄区', '3', '19724', 'T');
INSERT INTO `ey_region` VALUES ('19763', '山亭区', '3', '19724', 'S');
INSERT INTO `ey_region` VALUES ('19774', '滕州市', '3', '19724', 'T');
INSERT INTO `ey_region` VALUES ('19796', '东营市', '2', '19280', 'D');
INSERT INTO `ey_region` VALUES ('19797', '市辖区', '3', '19796', 'S');
INSERT INTO `ey_region` VALUES ('19798', '东营区', '3', '19796', 'D');
INSERT INTO `ey_region` VALUES ('19809', '河口区', '3', '19796', 'H');
INSERT INTO `ey_region` VALUES ('19817', '垦利县', '3', '19796', 'K');
INSERT INTO `ey_region` VALUES ('19825', '利津县', '3', '19796', 'L');
INSERT INTO `ey_region` VALUES ('19835', '广饶县', '3', '19796', 'G');
INSERT INTO `ey_region` VALUES ('19846', '烟台市', '2', '19280', 'Y');
INSERT INTO `ey_region` VALUES ('19847', '市辖区', '3', '19846', 'S');
INSERT INTO `ey_region` VALUES ('19848', '芝罘区', '3', '19846', 'Z');
INSERT INTO `ey_region` VALUES ('19861', '福山区', '3', '19846', 'F');
INSERT INTO `ey_region` VALUES ('19873', '牟平区', '3', '19846', 'M');
INSERT INTO `ey_region` VALUES ('19887', '莱山区', '3', '19846', 'L');
INSERT INTO `ey_region` VALUES ('19893', '长岛县', '3', '19846', 'C');
INSERT INTO `ey_region` VALUES ('19902', '龙口市', '3', '19846', 'L');
INSERT INTO `ey_region` VALUES ('19916', '莱阳市', '3', '19846', 'L');
INSERT INTO `ey_region` VALUES ('19935', '莱州市', '3', '19846', 'L');
INSERT INTO `ey_region` VALUES ('19952', '蓬莱市', '3', '19846', 'P');
INSERT INTO `ey_region` VALUES ('19965', '招远市', '3', '19846', 'Z');
INSERT INTO `ey_region` VALUES ('19980', '栖霞市', '3', '19846', 'Q');
INSERT INTO `ey_region` VALUES ('19996', '海阳市', '3', '19846', 'H');
INSERT INTO `ey_region` VALUES ('20012', '潍坊市', '2', '19280', 'W');
INSERT INTO `ey_region` VALUES ('20013', '市辖区', '3', '20012', 'S');
INSERT INTO `ey_region` VALUES ('20014', '潍城区', '3', '20012', 'W');
INSERT INTO `ey_region` VALUES ('20023', '寒亭区', '3', '20012', 'H');
INSERT INTO `ey_region` VALUES ('20034', '坊子区', '3', '20012', 'F');
INSERT INTO `ey_region` VALUES ('20043', '奎文区', '3', '20012', 'K');
INSERT INTO `ey_region` VALUES ('20055', '临朐县', '3', '20012', 'L');
INSERT INTO `ey_region` VALUES ('20074', '昌乐县', '3', '20012', 'C');
INSERT INTO `ey_region` VALUES ('20091', '青州市', '3', '20012', 'Q');
INSERT INTO `ey_region` VALUES ('20113', '诸城市', '3', '20012', 'Z');
INSERT INTO `ey_region` VALUES ('20137', '寿光市', '3', '20012', 'S');
INSERT INTO `ey_region` VALUES ('20155', '安丘市', '3', '20012', 'A');
INSERT INTO `ey_region` VALUES ('20179', '高密市', '3', '20012', 'G');
INSERT INTO `ey_region` VALUES ('20200', '昌邑市', '3', '20012', 'C');
INSERT INTO `ey_region` VALUES ('20216', '济宁市', '2', '19280', 'J');
INSERT INTO `ey_region` VALUES ('20217', '市辖区', '3', '20216', 'S');
INSERT INTO `ey_region` VALUES ('20218', '市中区', '3', '20216', 'S');
INSERT INTO `ey_region` VALUES ('20227', '任城区', '3', '20216', 'R');
INSERT INTO `ey_region` VALUES ('20257', '鱼台县', '3', '20216', 'Y');
INSERT INTO `ey_region` VALUES ('20268', '金乡县', '3', '20216', 'J');
INSERT INTO `ey_region` VALUES ('20282', '嘉祥县', '3', '20216', 'J');
INSERT INTO `ey_region` VALUES ('20298', '汶上县', '3', '20216', 'W');
INSERT INTO `ey_region` VALUES ('20313', '泗水县', '3', '20216', 'S');
INSERT INTO `ey_region` VALUES ('20327', '梁山县', '3', '20216', 'L');
INSERT INTO `ey_region` VALUES ('20342', '曲阜市', '3', '20216', 'Q');
INSERT INTO `ey_region` VALUES ('20355', '兖州市', '3', '20216', 'Y');
INSERT INTO `ey_region` VALUES ('20368', '邹城市', '3', '20216', 'Z');
INSERT INTO `ey_region` VALUES ('20386', '泰安市', '2', '19280', 'T');
INSERT INTO `ey_region` VALUES ('20387', '市辖区', '3', '20386', 'S');
INSERT INTO `ey_region` VALUES ('20388', '泰山区', '3', '20386', 'T');
INSERT INTO `ey_region` VALUES ('20397', '岱岳区', '3', '20386', 'D');
INSERT INTO `ey_region` VALUES ('20416', '宁阳县', '3', '20386', 'N');
INSERT INTO `ey_region` VALUES ('20429', '东平县', '3', '20386', 'D');
INSERT INTO `ey_region` VALUES ('20444', '新泰市', '3', '20386', 'X');
INSERT INTO `ey_region` VALUES ('20465', '肥城市', '3', '20386', 'F');
INSERT INTO `ey_region` VALUES ('20480', '威海市', '2', '19280', 'W');
INSERT INTO `ey_region` VALUES ('20481', '市辖区', '3', '20480', 'S');
INSERT INTO `ey_region` VALUES ('20482', '环翠区', '3', '20480', 'H');
INSERT INTO `ey_region` VALUES ('20500', '文登市', '3', '20480', 'W');
INSERT INTO `ey_region` VALUES ('20519', '荣成市', '3', '20480', 'R');
INSERT INTO `ey_region` VALUES ('20542', '乳山市', '3', '20480', 'R');
INSERT INTO `ey_region` VALUES ('20558', '日照市', '2', '19280', 'R');
INSERT INTO `ey_region` VALUES ('20559', '市辖区', '3', '20558', 'S');
INSERT INTO `ey_region` VALUES ('20560', '东港区', '3', '20558', 'D');
INSERT INTO `ey_region` VALUES ('20573', '岚山区', '3', '20558', 'L');
INSERT INTO `ey_region` VALUES ('20583', '五莲县', '3', '20558', 'W');
INSERT INTO `ey_region` VALUES ('20596', '莒县', '3', '20558', 'J');
INSERT INTO `ey_region` VALUES ('20618', '莱芜市', '2', '19280', 'L');
INSERT INTO `ey_region` VALUES ('20619', '市辖区', '3', '20618', 'S');
INSERT INTO `ey_region` VALUES ('20620', '莱城区', '3', '20618', 'L');
INSERT INTO `ey_region` VALUES ('20636', '钢城区', '3', '20618', 'G');
INSERT INTO `ey_region` VALUES ('20642', '临沂市', '2', '19280', 'L');
INSERT INTO `ey_region` VALUES ('20643', '临沂市辖区', '3', '20642', 'L');
INSERT INTO `ey_region` VALUES ('20644', '兰山区', '3', '20642', 'L');
INSERT INTO `ey_region` VALUES ('20656', '罗庄区', '3', '20642', 'L');
INSERT INTO `ey_region` VALUES ('20665', '河东区', '3', '20642', 'H');
INSERT INTO `ey_region` VALUES ('20678', '沂南县', '3', '20642', 'Y');
INSERT INTO `ey_region` VALUES ('20696', '郯城县', '3', '20642', 'T');
INSERT INTO `ey_region` VALUES ('20714', '沂水县', '3', '20642', 'Y');
INSERT INTO `ey_region` VALUES ('20734', '苍山县', '3', '20642', 'C');
INSERT INTO `ey_region` VALUES ('20756', '费县', '3', '20642', 'F');
INSERT INTO `ey_region` VALUES ('20775', '平邑县', '3', '20642', 'P');
INSERT INTO `ey_region` VALUES ('20792', '莒南县', '3', '20642', 'J');
INSERT INTO `ey_region` VALUES ('20811', '蒙阴县', '3', '20642', 'M');
INSERT INTO `ey_region` VALUES ('20823', '临沭县', '3', '20642', 'L');
INSERT INTO `ey_region` VALUES ('20836', '德州市', '2', '19280', 'D');
INSERT INTO `ey_region` VALUES ('20837', '市辖区', '3', '20836', 'S');
INSERT INTO `ey_region` VALUES ('20838', '德城区', '3', '20836', 'D');
INSERT INTO `ey_region` VALUES ('20850', '陵县', '3', '20836', 'L');
INSERT INTO `ey_region` VALUES ('20864', '宁津县', '3', '20836', 'N');
INSERT INTO `ey_region` VALUES ('20876', '庆云县', '3', '20836', 'Q');
INSERT INTO `ey_region` VALUES ('20886', '临邑县', '3', '20836', 'L');
INSERT INTO `ey_region` VALUES ('20899', '齐河县', '3', '20836', 'Q');
INSERT INTO `ey_region` VALUES ('20914', '平原县', '3', '20836', 'P');
INSERT INTO `ey_region` VALUES ('20927', '夏津县', '3', '20836', 'X');
INSERT INTO `ey_region` VALUES ('20942', '武城县', '3', '20836', 'W');
INSERT INTO `ey_region` VALUES ('20952', '乐陵市', '3', '20836', 'L');
INSERT INTO `ey_region` VALUES ('20969', '禹城市', '3', '20836', 'Y');
INSERT INTO `ey_region` VALUES ('20981', '聊城市', '2', '19280', 'L');
INSERT INTO `ey_region` VALUES ('20982', '市辖区', '3', '20981', 'S');
INSERT INTO `ey_region` VALUES ('20983', '东昌府区', '3', '20981', 'D');
INSERT INTO `ey_region` VALUES ('21004', '阳谷县', '3', '20981', 'Y');
INSERT INTO `ey_region` VALUES ('21023', '莘县', '3', '20981', 'S');
INSERT INTO `ey_region` VALUES ('21046', '茌平县', '3', '20981', 'C');
INSERT INTO `ey_region` VALUES ('21063', '东阿县', '3', '20981', 'D');
INSERT INTO `ey_region` VALUES ('21075', '冠县', '3', '20981', 'G');
INSERT INTO `ey_region` VALUES ('21093', '高唐县', '3', '20981', 'G');
INSERT INTO `ey_region` VALUES ('21106', '临清市', '3', '20981', 'L');
INSERT INTO `ey_region` VALUES ('21123', '滨州市', '2', '19280', 'B');
INSERT INTO `ey_region` VALUES ('21124', '市辖区', '3', '21123', 'S');
INSERT INTO `ey_region` VALUES ('21125', '滨城区', '3', '21123', 'B');
INSERT INTO `ey_region` VALUES ('21141', '惠民县', '3', '21123', 'H');
INSERT INTO `ey_region` VALUES ('21156', '阳信县', '3', '21123', 'Y');
INSERT INTO `ey_region` VALUES ('21166', '无棣县', '3', '21123', 'W');
INSERT INTO `ey_region` VALUES ('21178', '沾化县', '3', '21123', 'Z');
INSERT INTO `ey_region` VALUES ('21190', '博兴县', '3', '21123', 'B');
INSERT INTO `ey_region` VALUES ('21201', '邹平县', '3', '21123', 'Z');
INSERT INTO `ey_region` VALUES ('21218', '菏泽市', '2', '19280', 'H');
INSERT INTO `ey_region` VALUES ('21219', '市辖区', '3', '21218', 'S');
INSERT INTO `ey_region` VALUES ('21220', '牡丹区', '3', '21218', 'M');
INSERT INTO `ey_region` VALUES ('21245', '曹县', '3', '21218', 'C');
INSERT INTO `ey_region` VALUES ('21271', '单县', '3', '21218', 'D');
INSERT INTO `ey_region` VALUES ('21292', '成武县', '3', '21218', 'C');
INSERT INTO `ey_region` VALUES ('21305', '巨野县', '3', '21218', 'J');
INSERT INTO `ey_region` VALUES ('21322', '郓城县', '3', '21218', 'Y');
INSERT INTO `ey_region` VALUES ('21344', '鄄城县', '3', '21218', 'J');
INSERT INTO `ey_region` VALUES ('21361', '定陶县', '3', '21218', 'D');
INSERT INTO `ey_region` VALUES ('21373', '东明县', '3', '21218', 'D');
INSERT INTO `ey_region` VALUES ('21387', '河南省', '1', '0', 'H');
INSERT INTO `ey_region` VALUES ('21388', '郑州市', '2', '21387', 'Z');
INSERT INTO `ey_region` VALUES ('21389', '市辖区', '3', '21388', 'S');
INSERT INTO `ey_region` VALUES ('21390', '中原区', '3', '21388', 'Z');
INSERT INTO `ey_region` VALUES ('21404', '二七区', '3', '21388', 'E');
INSERT INTO `ey_region` VALUES ('21420', '管城回族区', '3', '21388', 'G');
INSERT INTO `ey_region` VALUES ('21435', '金水区', '3', '21388', 'J');
INSERT INTO `ey_region` VALUES ('21453', '上街区', '3', '21388', 'S');
INSERT INTO `ey_region` VALUES ('21460', '惠济区', '3', '21388', 'H');
INSERT INTO `ey_region` VALUES ('21469', '中牟县', '3', '21388', 'Z');
INSERT INTO `ey_region` VALUES ('21487', '巩义市', '3', '21388', 'G');
INSERT INTO `ey_region` VALUES ('21508', '荥阳市', '3', '21388', 'X');
INSERT INTO `ey_region` VALUES ('21523', '新密市', '3', '21388', 'X');
INSERT INTO `ey_region` VALUES ('21542', '新郑市', '3', '21388', 'X');
INSERT INTO `ey_region` VALUES ('21558', '登封市', '3', '21388', 'D');
INSERT INTO `ey_region` VALUES ('21575', '开封市', '2', '21387', 'K');
INSERT INTO `ey_region` VALUES ('21576', '市辖区', '3', '21575', 'S');
INSERT INTO `ey_region` VALUES ('21577', '龙亭区', '3', '21575', 'L');
INSERT INTO `ey_region` VALUES ('21584', '顺河区', '3', '21575', 'S');
INSERT INTO `ey_region` VALUES ('21593', '鼓楼区', '3', '21575', 'G');
INSERT INTO `ey_region` VALUES ('21602', '禹王台区', '3', '21575', 'Y');
INSERT INTO `ey_region` VALUES ('21610', '金明区', '3', '21575', 'J');
INSERT INTO `ey_region` VALUES ('21618', '杞县', '3', '21575', 'Q');
INSERT INTO `ey_region` VALUES ('21640', '通许县', '3', '21575', 'T');
INSERT INTO `ey_region` VALUES ('21653', '尉氏县', '3', '21575', 'W');
INSERT INTO `ey_region` VALUES ('21671', '开封县', '3', '21575', 'K');
INSERT INTO `ey_region` VALUES ('21687', '兰考县', '3', '21575', 'L');
INSERT INTO `ey_region` VALUES ('21711', '洛阳市', '2', '21387', 'L');
INSERT INTO `ey_region` VALUES ('21712', '市辖区', '3', '21711', 'S');
INSERT INTO `ey_region` VALUES ('21713', '老城区', '3', '21711', 'L');
INSERT INTO `ey_region` VALUES ('21722', '西工区', '3', '21711', 'X');
INSERT INTO `ey_region` VALUES ('21733', '廛河回族区', '3', '21711', 'C');
INSERT INTO `ey_region` VALUES ('21742', '涧西区', '3', '21711', 'J');
INSERT INTO `ey_region` VALUES ('21758', '吉利区', '3', '21711', 'J');
INSERT INTO `ey_region` VALUES ('21761', '洛龙区', '3', '21711', 'L');
INSERT INTO `ey_region` VALUES ('21770', '孟津县', '3', '21711', 'M');
INSERT INTO `ey_region` VALUES ('21781', '新安县', '3', '21711', 'X');
INSERT INTO `ey_region` VALUES ('21794', '栾川县', '3', '21711', 'L');
INSERT INTO `ey_region` VALUES ('21809', '嵩县', '3', '21711', 'S');
INSERT INTO `ey_region` VALUES ('21829', '汝阳县', '3', '21711', 'R');
INSERT INTO `ey_region` VALUES ('21844', '宜阳县', '3', '21711', 'Y');
INSERT INTO `ey_region` VALUES ('21862', '洛宁县', '3', '21711', 'L');
INSERT INTO `ey_region` VALUES ('21881', '伊川县', '3', '21711', 'Y');
INSERT INTO `ey_region` VALUES ('21896', '偃师市', '3', '21711', 'Y');
INSERT INTO `ey_region` VALUES ('21913', '平顶山市', '2', '21387', 'P');
INSERT INTO `ey_region` VALUES ('21914', '市辖区', '3', '21913', 'S');
INSERT INTO `ey_region` VALUES ('21915', '新华区', '3', '21913', 'X');
INSERT INTO `ey_region` VALUES ('21928', '卫东区', '3', '21913', 'W');
INSERT INTO `ey_region` VALUES ('21940', '石龙区', '3', '21913', 'S');
INSERT INTO `ey_region` VALUES ('21945', '湛河区', '3', '21913', 'Z');
INSERT INTO `ey_region` VALUES ('21954', '宝丰县', '3', '21913', 'B');
INSERT INTO `ey_region` VALUES ('21968', '叶  县', '3', '21913', 'Y');
INSERT INTO `ey_region` VALUES ('21987', '鲁山县', '3', '21913', 'L');
INSERT INTO `ey_region` VALUES ('22009', '郏  县', '3', '21913', 'J');
INSERT INTO `ey_region` VALUES ('22024', '舞钢市', '3', '21913', 'W');
INSERT INTO `ey_region` VALUES ('22037', '汝州市', '3', '21913', 'R');
INSERT INTO `ey_region` VALUES ('22058', '安阳市', '2', '21387', 'A');
INSERT INTO `ey_region` VALUES ('22059', '市辖区', '3', '22058', 'S');
INSERT INTO `ey_region` VALUES ('22060', '文峰区', '3', '22058', 'W');
INSERT INTO `ey_region` VALUES ('22080', '北关区', '3', '22058', 'B');
INSERT INTO `ey_region` VALUES ('22090', '殷都区', '3', '22058', 'Y');
INSERT INTO `ey_region` VALUES ('22101', '龙安区', '3', '22058', 'L');
INSERT INTO `ey_region` VALUES ('22111', '安阳县', '3', '22058', 'A');
INSERT INTO `ey_region` VALUES ('22133', '汤阴县', '3', '22058', 'T');
INSERT INTO `ey_region` VALUES ('22144', '滑县', '3', '22058', 'H');
INSERT INTO `ey_region` VALUES ('22167', '内黄县', '3', '22058', 'N');
INSERT INTO `ey_region` VALUES ('22185', '林州市', '3', '22058', 'L');
INSERT INTO `ey_region` VALUES ('22206', '鹤壁市', '2', '21387', 'H');
INSERT INTO `ey_region` VALUES ('22207', '市辖区', '3', '22206', 'S');
INSERT INTO `ey_region` VALUES ('22208', '鹤山区', '3', '22206', 'H');
INSERT INTO `ey_region` VALUES ('22216', '山城区', '3', '22206', 'S');
INSERT INTO `ey_region` VALUES ('22224', '淇滨区', '3', '22206', 'Q');
INSERT INTO `ey_region` VALUES ('22232', '浚县', '3', '22206', 'J');
INSERT INTO `ey_region` VALUES ('22243', '淇县', '3', '22206', 'Q');
INSERT INTO `ey_region` VALUES ('22251', '新乡市', '2', '21387', 'X');
INSERT INTO `ey_region` VALUES ('22252', '市辖区', '3', '22251', 'S');
INSERT INTO `ey_region` VALUES ('22253', '红旗区', '3', '22251', 'H');
INSERT INTO `ey_region` VALUES ('22264', '卫滨区', '3', '22251', 'W');
INSERT INTO `ey_region` VALUES ('22273', '凤泉区', '3', '22251', 'F');
INSERT INTO `ey_region` VALUES ('22279', '牧野区', '3', '22251', 'M');
INSERT INTO `ey_region` VALUES ('22290', '新乡县', '3', '22251', 'X');
INSERT INTO `ey_region` VALUES ('22299', '获嘉县', '3', '22251', 'H');
INSERT INTO `ey_region` VALUES ('22312', '原阳县', '3', '22251', 'Y');
INSERT INTO `ey_region` VALUES ('22330', '延津县', '3', '22251', 'Y');
INSERT INTO `ey_region` VALUES ('22347', '封丘县', '3', '22251', 'F');
INSERT INTO `ey_region` VALUES ('22367', '长垣县', '3', '22251', 'C');
INSERT INTO `ey_region` VALUES ('22386', '卫辉市', '3', '22251', 'W');
INSERT INTO `ey_region` VALUES ('22400', '辉县市', '3', '22251', 'H');
INSERT INTO `ey_region` VALUES ('22423', '焦作市', '2', '21387', 'J');
INSERT INTO `ey_region` VALUES ('22424', '市辖区', '3', '22423', 'S');
INSERT INTO `ey_region` VALUES ('22425', '解放区', '3', '22423', 'J');
INSERT INTO `ey_region` VALUES ('22435', '中站区', '3', '22423', 'Z');
INSERT INTO `ey_region` VALUES ('22446', '马村区', '3', '22423', 'M');
INSERT INTO `ey_region` VALUES ('22454', '山阳区', '3', '22423', 'S');
INSERT INTO `ey_region` VALUES ('22465', '修武县', '3', '22423', 'X');
INSERT INTO `ey_region` VALUES ('22475', '博爱县', '3', '22423', 'B');
INSERT INTO `ey_region` VALUES ('22487', '武陟县', '3', '22423', 'W');
INSERT INTO `ey_region` VALUES ('22503', '温县', '3', '22423', 'W');
INSERT INTO `ey_region` VALUES ('22515', '济源市', '3', '22423', 'J');
INSERT INTO `ey_region` VALUES ('22532', '沁阳市', '3', '22423', 'Q');
INSERT INTO `ey_region` VALUES ('22546', '孟州市', '3', '22423', 'M');
INSERT INTO `ey_region` VALUES ('22558', '濮阳市', '2', '21387', 'P');
INSERT INTO `ey_region` VALUES ('22559', '市辖区', '3', '22558', 'S');
INSERT INTO `ey_region` VALUES ('22560', '华龙区', '3', '22558', 'H');
INSERT INTO `ey_region` VALUES ('22578', '清丰县', '3', '22558', 'Q');
INSERT INTO `ey_region` VALUES ('22596', '南乐县', '3', '22558', 'N');
INSERT INTO `ey_region` VALUES ('22609', '范县', '3', '22558', 'F');
INSERT INTO `ey_region` VALUES ('22622', '台前县', '3', '22558', 'T');
INSERT INTO `ey_region` VALUES ('22632', '濮阳县', '3', '22558', 'P');
INSERT INTO `ey_region` VALUES ('22655', '许昌市', '2', '21387', 'X');
INSERT INTO `ey_region` VALUES ('22656', '市辖区', '3', '22655', 'S');
INSERT INTO `ey_region` VALUES ('22657', '魏都区', '3', '22655', 'W');
INSERT INTO `ey_region` VALUES ('22671', '许昌县', '3', '22655', 'X');
INSERT INTO `ey_region` VALUES ('22688', '鄢陵县', '3', '22655', 'Y');
INSERT INTO `ey_region` VALUES ('22701', '襄城县', '3', '22655', 'X');
INSERT INTO `ey_region` VALUES ('22718', '禹州市', '3', '22655', 'Y');
INSERT INTO `ey_region` VALUES ('22745', '长葛市', '3', '22655', 'C');
INSERT INTO `ey_region` VALUES ('22762', '漯河市', '2', '21387', 'L');
INSERT INTO `ey_region` VALUES ('22763', '市辖区', '3', '22762', 'S');
INSERT INTO `ey_region` VALUES ('22764', '源汇区', '3', '22762', 'Y');
INSERT INTO `ey_region` VALUES ('22773', '郾城区', '3', '22762', 'Y');
INSERT INTO `ey_region` VALUES ('22783', '召陵区', '3', '22762', 'Z');
INSERT INTO `ey_region` VALUES ('22793', '舞阳县', '3', '22762', 'W');
INSERT INTO `ey_region` VALUES ('22808', '临颖县', '3', '22762', 'L');
INSERT INTO `ey_region` VALUES ('22824', '三门峡市', '2', '21387', 'S');
INSERT INTO `ey_region` VALUES ('22825', '市辖区', '3', '22824', 'S');
INSERT INTO `ey_region` VALUES ('22826', '湖滨区', '3', '22824', 'H');
INSERT INTO `ey_region` VALUES ('22838', '渑池县', '3', '22824', 'M');
INSERT INTO `ey_region` VALUES ('22851', '陕县', '3', '22824', 'S');
INSERT INTO `ey_region` VALUES ('22865', '卢氏县', '3', '22824', 'L');
INSERT INTO `ey_region` VALUES ('22885', '义马市', '3', '22824', 'Y');
INSERT INTO `ey_region` VALUES ('22893', '灵宝市', '3', '22824', 'L');
INSERT INTO `ey_region` VALUES ('22910', '南阳市', '2', '21387', 'N');
INSERT INTO `ey_region` VALUES ('22911', '市辖区', '3', '22910', 'S');
INSERT INTO `ey_region` VALUES ('22912', '宛城区', '3', '22910', 'W');
INSERT INTO `ey_region` VALUES ('22930', '卧龙区', '3', '22910', 'W');
INSERT INTO `ey_region` VALUES ('22951', '南召县', '3', '22910', 'N');
INSERT INTO `ey_region` VALUES ('22973', '方城县', '3', '22910', 'F');
INSERT INTO `ey_region` VALUES ('22992', '西峡县', '3', '22910', 'X');
INSERT INTO `ey_region` VALUES ('23013', '镇平县', '3', '22910', 'Z');
INSERT INTO `ey_region` VALUES ('23036', '内乡县', '3', '22910', 'N');
INSERT INTO `ey_region` VALUES ('23053', '淅川县', '3', '22910', 'X');
INSERT INTO `ey_region` VALUES ('23071', '社旗县', '3', '22910', 'S');
INSERT INTO `ey_region` VALUES ('23087', '唐河县', '3', '22910', 'T');
INSERT INTO `ey_region` VALUES ('23108', '新野县', '3', '22910', 'X');
INSERT INTO `ey_region` VALUES ('23123', '桐柏县', '3', '22910', 'T');
INSERT INTO `ey_region` VALUES ('23140', '邓州市', '3', '22910', 'D');
INSERT INTO `ey_region` VALUES ('23170', '商丘市', '2', '21387', 'S');
INSERT INTO `ey_region` VALUES ('23171', '市辖区', '3', '23170', 'S');
INSERT INTO `ey_region` VALUES ('23172', '梁园区', '3', '23170', 'L');
INSERT INTO `ey_region` VALUES ('23192', '睢阳区', '3', '23170', 'S');
INSERT INTO `ey_region` VALUES ('23211', '民权县', '3', '23170', 'M');
INSERT INTO `ey_region` VALUES ('23232', '睢县', '3', '23170', 'S');
INSERT INTO `ey_region` VALUES ('23253', '宁陵县', '3', '23170', 'N');
INSERT INTO `ey_region` VALUES ('23268', '柘城县', '3', '23170', 'Z');
INSERT INTO `ey_region` VALUES ('23290', '虞城县', '3', '23170', 'Y');
INSERT INTO `ey_region` VALUES ('23317', '夏邑县', '3', '23170', 'X');
INSERT INTO `ey_region` VALUES ('23342', '永城市', '3', '23170', 'Y');
INSERT INTO `ey_region` VALUES ('23372', '信阳市', '2', '21387', 'X');
INSERT INTO `ey_region` VALUES ('23373', '市辖区', '3', '23372', 'S');
INSERT INTO `ey_region` VALUES ('23374', '浉河区', '3', '23372', 'S');
INSERT INTO `ey_region` VALUES ('23393', '平桥区', '3', '23372', 'P');
INSERT INTO `ey_region` VALUES ('23414', '罗山县', '3', '23372', 'L');
INSERT INTO `ey_region` VALUES ('23435', '光山县', '3', '23372', 'G');
INSERT INTO `ey_region` VALUES ('23455', '新县', '3', '23372', 'X');
INSERT INTO `ey_region` VALUES ('23471', '商城县', '3', '23372', 'S');
INSERT INTO `ey_region` VALUES ('23492', '固始县', '3', '23372', 'G');
INSERT INTO `ey_region` VALUES ('23525', '潢川县', '3', '23372', 'H');
INSERT INTO `ey_region` VALUES ('23549', '淮滨县', '3', '23372', 'H');
INSERT INTO `ey_region` VALUES ('23567', '息县', '3', '23372', 'X');
INSERT INTO `ey_region` VALUES ('23589', '周口市', '2', '21387', 'Z');
INSERT INTO `ey_region` VALUES ('23590', '市辖区', '3', '23589', 'S');
INSERT INTO `ey_region` VALUES ('23591', '川汇区', '3', '23589', 'C');
INSERT INTO `ey_region` VALUES ('23604', '扶沟县', '3', '23589', 'F');
INSERT INTO `ey_region` VALUES ('23621', '西华县', '3', '23589', 'X');
INSERT INTO `ey_region` VALUES ('23647', '商水县', '3', '23589', 'S');
INSERT INTO `ey_region` VALUES ('23672', '沈丘县', '3', '23589', 'S');
INSERT INTO `ey_region` VALUES ('23695', '郸城县', '3', '23589', 'D');
INSERT INTO `ey_region` VALUES ('23716', '淮阳县', '3', '23589', 'H');
INSERT INTO `ey_region` VALUES ('23736', '太康县', '3', '23589', 'T');
INSERT INTO `ey_region` VALUES ('23766', '鹿邑县', '3', '23589', 'L');
INSERT INTO `ey_region` VALUES ('23796', '项城市', '3', '23589', 'X');
INSERT INTO `ey_region` VALUES ('23818', '驻马店市', '2', '21387', 'Z');
INSERT INTO `ey_region` VALUES ('23819', '市辖区', '3', '23818', 'S');
INSERT INTO `ey_region` VALUES ('23820', '驿城区', '3', '23818', 'Y');
INSERT INTO `ey_region` VALUES ('23840', '西平县', '3', '23818', 'X');
INSERT INTO `ey_region` VALUES ('23861', '上蔡县', '3', '23818', 'S');
INSERT INTO `ey_region` VALUES ('23886', '平舆县', '3', '23818', 'P');
INSERT INTO `ey_region` VALUES ('23905', '正阳县', '3', '23818', 'Z');
INSERT INTO `ey_region` VALUES ('23926', '确山县', '3', '23818', 'Q');
INSERT INTO `ey_region` VALUES ('23940', '泌阳县', '3', '23818', 'M');
INSERT INTO `ey_region` VALUES ('23965', '汝南县', '3', '23818', 'R');
INSERT INTO `ey_region` VALUES ('23983', '遂平县', '3', '23818', 'S');
INSERT INTO `ey_region` VALUES ('23999', '新蔡县', '3', '23818', 'X');
INSERT INTO `ey_region` VALUES ('24022', '湖北省', '1', '0', 'H');
INSERT INTO `ey_region` VALUES ('24023', '武汉市', '2', '24022', 'W');
INSERT INTO `ey_region` VALUES ('24024', '市辖区', '3', '24023', 'S');
INSERT INTO `ey_region` VALUES ('24025', '江岸区', '3', '24023', 'J');
INSERT INTO `ey_region` VALUES ('24043', '江汉区', '3', '24023', 'J');
INSERT INTO `ey_region` VALUES ('24057', '硚口区', '3', '24023', 'Q');
INSERT INTO `ey_region` VALUES ('24069', '汉阳区', '3', '24023', 'H');
INSERT INTO `ey_region` VALUES ('24082', '武昌区', '3', '24023', 'W');
INSERT INTO `ey_region` VALUES ('24098', '青山区', '3', '24023', 'Q');
INSERT INTO `ey_region` VALUES ('24111', '洪山区', '3', '24023', 'H');
INSERT INTO `ey_region` VALUES ('24129', '东西湖区', '3', '24023', 'D');
INSERT INTO `ey_region` VALUES ('24142', '汉南区', '3', '24023', 'H');
INSERT INTO `ey_region` VALUES ('24150', '蔡甸区', '3', '24023', 'C');
INSERT INTO `ey_region` VALUES ('24165', '江夏区', '3', '24023', 'J');
INSERT INTO `ey_region` VALUES ('24185', '黄陂区', '3', '24023', 'H');
INSERT INTO `ey_region` VALUES ('24205', '武汉市新洲区', '3', '24023', 'W');
INSERT INTO `ey_region` VALUES ('24224', '黄石市', '2', '24022', 'H');
INSERT INTO `ey_region` VALUES ('24225', '市辖区', '3', '24224', 'S');
INSERT INTO `ey_region` VALUES ('24226', '黄石港区', '3', '24224', 'H');
INSERT INTO `ey_region` VALUES ('24233', '西塞山区', '3', '24224', 'X');
INSERT INTO `ey_region` VALUES ('24242', '下陆区', '3', '24224', 'X');
INSERT INTO `ey_region` VALUES ('24247', '铁山区', '3', '24224', 'T');
INSERT INTO `ey_region` VALUES ('24250', '阳新县', '3', '24224', 'Y');
INSERT INTO `ey_region` VALUES ('24273', '大冶市', '3', '24224', 'D');
INSERT INTO `ey_region` VALUES ('24291', '十堰市', '2', '24022', 'S');
INSERT INTO `ey_region` VALUES ('24292', '市辖区', '3', '24291', 'S');
INSERT INTO `ey_region` VALUES ('24293', '茅箭区', '3', '24291', 'M');
INSERT INTO `ey_region` VALUES ('24302', '张湾区', '3', '24291', 'Z');
INSERT INTO `ey_region` VALUES ('24314', '郧县', '3', '24291', 'Y');
INSERT INTO `ey_region` VALUES ('24335', '郧西县', '3', '24291', 'Y');
INSERT INTO `ey_region` VALUES ('24354', '竹山县', '3', '24291', 'Z');
INSERT INTO `ey_region` VALUES ('24374', '竹溪县', '3', '24291', 'Z');
INSERT INTO `ey_region` VALUES ('24405', '房县', '3', '24291', 'F');
INSERT INTO `ey_region` VALUES ('24435', '丹江口市', '3', '24291', 'D');
INSERT INTO `ey_region` VALUES ('24453', '宜昌市', '2', '24022', 'Y');
INSERT INTO `ey_region` VALUES ('24454', '市辖区', '3', '24453', 'S');
INSERT INTO `ey_region` VALUES ('24455', '西陵区', '3', '24453', 'X');
INSERT INTO `ey_region` VALUES ('24465', '伍家岗区', '3', '24453', 'W');
INSERT INTO `ey_region` VALUES ('24471', '点军区', '3', '24453', 'D');
INSERT INTO `ey_region` VALUES ('24477', '猇亭区', '3', '24453', 'X');
INSERT INTO `ey_region` VALUES ('24481', '夷陵区', '3', '24453', 'Y');
INSERT INTO `ey_region` VALUES ('24495', '远安县', '3', '24453', 'Y');
INSERT INTO `ey_region` VALUES ('24503', '兴山县', '3', '24453', 'X');
INSERT INTO `ey_region` VALUES ('24512', '秭归县', '3', '24453', 'Z');
INSERT INTO `ey_region` VALUES ('24525', '长阳县', '3', '24453', 'C');
INSERT INTO `ey_region` VALUES ('24537', '五峰县', '3', '24453', 'W');
INSERT INTO `ey_region` VALUES ('24546', '宜都市', '3', '24453', 'Y');
INSERT INTO `ey_region` VALUES ('24559', '当阳市', '3', '24453', 'D');
INSERT INTO `ey_region` VALUES ('24570', '枝江市', '3', '24453', 'Z');
INSERT INTO `ey_region` VALUES ('24580', '襄樊市', '2', '24022', 'X');
INSERT INTO `ey_region` VALUES ('24581', '市辖区', '3', '24580', 'S');
INSERT INTO `ey_region` VALUES ('24582', '襄城区', '3', '24580', 'X');
INSERT INTO `ey_region` VALUES ('24591', '樊城区', '3', '24580', 'F');
INSERT INTO `ey_region` VALUES ('24608', '襄阳区', '3', '24580', 'X');
INSERT INTO `ey_region` VALUES ('24623', '南漳县', '3', '24580', 'N');
INSERT INTO `ey_region` VALUES ('24635', '谷城县', '3', '24580', 'G');
INSERT INTO `ey_region` VALUES ('24647', '保康县', '3', '24580', 'B');
INSERT INTO `ey_region` VALUES ('24659', '老河口市', '3', '24580', 'L');
INSERT INTO `ey_region` VALUES ('24674', '枣阳市', '3', '24580', 'Z');
INSERT INTO `ey_region` VALUES ('24692', '宜城市', '3', '24580', 'Y');
INSERT INTO `ey_region` VALUES ('24706', '鄂州市', '2', '24022', 'E');
INSERT INTO `ey_region` VALUES ('24707', '市辖区', '3', '24706', 'S');
INSERT INTO `ey_region` VALUES ('24708', '粱子湖区', '3', '24706', 'L');
INSERT INTO `ey_region` VALUES ('24714', '华容区', '3', '24706', 'H');
INSERT INTO `ey_region` VALUES ('24722', '鄂城区', '3', '24706', 'E');
INSERT INTO `ey_region` VALUES ('24737', '荆门市', '2', '24022', 'J');
INSERT INTO `ey_region` VALUES ('24738', '市辖区', '3', '24737', 'S');
INSERT INTO `ey_region` VALUES ('24739', '东宝区', '3', '24737', 'D');
INSERT INTO `ey_region` VALUES ('24749', '掇刀区', '3', '24737', 'D');
INSERT INTO `ey_region` VALUES ('24755', '京山县', '3', '24737', 'J');
INSERT INTO `ey_region` VALUES ('24778', '沙洋县', '3', '24737', 'S');
INSERT INTO `ey_region` VALUES ('24794', '钟祥市', '3', '24737', 'Z');
INSERT INTO `ey_region` VALUES ('24816', '孝感市', '2', '24022', 'X');
INSERT INTO `ey_region` VALUES ('24817', '市辖区', '3', '24816', 'S');
INSERT INTO `ey_region` VALUES ('24818', '孝南区', '3', '24816', 'X');
INSERT INTO `ey_region` VALUES ('24838', '孝昌县', '3', '24816', 'X');
INSERT INTO `ey_region` VALUES ('24853', '大悟县', '3', '24816', 'D');
INSERT INTO `ey_region` VALUES ('24871', '云梦县', '3', '24816', 'Y');
INSERT INTO `ey_region` VALUES ('24885', '应城市', '3', '24816', 'Y');
INSERT INTO `ey_region` VALUES ('24903', '安陆市', '3', '24816', 'A');
INSERT INTO `ey_region` VALUES ('24920', '汉川市', '3', '24816', 'H');
INSERT INTO `ey_region` VALUES ('24949', '荆州市', '2', '24022', 'J');
INSERT INTO `ey_region` VALUES ('24950', '市辖区', '3', '24949', 'S');
INSERT INTO `ey_region` VALUES ('24951', '沙市区', '3', '24949', 'S');
INSERT INTO `ey_region` VALUES ('24965', '荆州区', '3', '24949', 'J');
INSERT INTO `ey_region` VALUES ('24978', '公安县', '3', '24949', 'G');
INSERT INTO `ey_region` VALUES ('24995', '监利县', '3', '24949', 'J');
INSERT INTO `ey_region` VALUES ('25019', '江陵县', '3', '24949', 'J');
INSERT INTO `ey_region` VALUES ('25032', '石首市', '3', '24949', 'S');
INSERT INTO `ey_region` VALUES ('25048', '洪湖市', '3', '24949', 'H');
INSERT INTO `ey_region` VALUES ('25069', '松滋市', '3', '24949', 'S');
INSERT INTO `ey_region` VALUES ('25086', '黄冈市', '2', '24022', 'H');
INSERT INTO `ey_region` VALUES ('25087', '市辖区', '3', '25086', 'S');
INSERT INTO `ey_region` VALUES ('25088', '黄州区', '3', '25086', 'H');
INSERT INTO `ey_region` VALUES ('25099', '团风县', '3', '25086', 'T');
INSERT INTO `ey_region` VALUES ('25112', '红安县', '3', '25086', 'H');
INSERT INTO `ey_region` VALUES ('25126', '罗田县', '3', '25086', 'L');
INSERT INTO `ey_region` VALUES ('25143', '英山县', '3', '25086', 'Y');
INSERT INTO `ey_region` VALUES ('25158', '浠水县', '3', '25086', 'X');
INSERT INTO `ey_region` VALUES ('25175', '蕲春县', '3', '25086', 'Q');
INSERT INTO `ey_region` VALUES ('25192', '黄梅县', '3', '25086', 'H');
INSERT INTO `ey_region` VALUES ('25211', '麻城市', '3', '25086', 'M');
INSERT INTO `ey_region` VALUES ('25235', '武穴市', '3', '25086', 'W');
INSERT INTO `ey_region` VALUES ('25249', '咸宁市', '2', '24022', 'X');
INSERT INTO `ey_region` VALUES ('25250', '市辖区', '3', '25249', 'S');
INSERT INTO `ey_region` VALUES ('25251', '咸安区', '3', '25249', 'X');
INSERT INTO `ey_region` VALUES ('25266', '嘉鱼县', '3', '25249', 'J');
INSERT INTO `ey_region` VALUES ('25276', '通城县', '3', '25249', 'T');
INSERT INTO `ey_region` VALUES ('25290', '崇阳县', '3', '25249', 'C');
INSERT INTO `ey_region` VALUES ('25303', '通山县', '3', '25249', 'T');
INSERT INTO `ey_region` VALUES ('25317', '赤壁市', '3', '25249', 'C');
INSERT INTO `ey_region` VALUES ('25335', '随州市', '2', '24022', 'S');
INSERT INTO `ey_region` VALUES ('25336', '市辖区', '3', '25335', 'S');
INSERT INTO `ey_region` VALUES ('25337', '曾都区', '3', '25335', 'Z');
INSERT INTO `ey_region` VALUES ('25367', '广水市', '3', '25335', 'G');
INSERT INTO `ey_region` VALUES ('25388', '恩施州', '2', '24022', 'E');
INSERT INTO `ey_region` VALUES ('25389', '恩施市', '3', '25388', 'E');
INSERT INTO `ey_region` VALUES ('25406', '利川市', '3', '25388', 'L');
INSERT INTO `ey_region` VALUES ('25422', '建始县', '3', '25388', 'J');
INSERT INTO `ey_region` VALUES ('25433', '巴东县', '3', '25388', 'B');
INSERT INTO `ey_region` VALUES ('25446', '宣恩县', '3', '25388', 'X');
INSERT INTO `ey_region` VALUES ('25456', '咸丰县', '3', '25388', 'X');
INSERT INTO `ey_region` VALUES ('25467', '来凤县', '3', '25388', 'L');
INSERT INTO `ey_region` VALUES ('25476', '鹤峰县', '3', '25388', 'H');
INSERT INTO `ey_region` VALUES ('25487', '省直辖行政单位', '2', '24022', 'S');
INSERT INTO `ey_region` VALUES ('25488', '仙桃市', '3', '25487', 'X');
INSERT INTO `ey_region` VALUES ('25516', '潜江市', '3', '25487', 'Q');
INSERT INTO `ey_region` VALUES ('25541', '天门市', '3', '25487', 'T');
INSERT INTO `ey_region` VALUES ('25570', '神农架林区', '3', '25487', 'S');
INSERT INTO `ey_region` VALUES ('25579', '湖南省', '1', '0', 'H');
INSERT INTO `ey_region` VALUES ('25580', '长沙市', '2', '25579', 'C');
INSERT INTO `ey_region` VALUES ('25581', '市辖区', '3', '25580', 'S');
INSERT INTO `ey_region` VALUES ('25582', '芙蓉区', '3', '25580', 'F');
INSERT INTO `ey_region` VALUES ('25596', '天心区', '3', '25580', 'T');
INSERT INTO `ey_region` VALUES ('25607', '岳麓区', '3', '25580', 'Y');
INSERT INTO `ey_region` VALUES ('25620', '开福区', '3', '25580', 'K');
INSERT INTO `ey_region` VALUES ('25634', '雨花区', '3', '25580', 'Y');
INSERT INTO `ey_region` VALUES ('25645', '长沙县', '3', '25580', 'C');
INSERT INTO `ey_region` VALUES ('25666', '望城县', '3', '25580', 'W');
INSERT INTO `ey_region` VALUES ('25686', '宁乡县', '3', '25580', 'N');
INSERT INTO `ey_region` VALUES ('25720', '浏阳市', '3', '25580', 'L');
INSERT INTO `ey_region` VALUES ('25758', '株洲市', '2', '25579', 'Z');
INSERT INTO `ey_region` VALUES ('25759', '市辖区', '3', '25758', 'S');
INSERT INTO `ey_region` VALUES ('25760', '荷塘区', '3', '25758', 'H');
INSERT INTO `ey_region` VALUES ('25768', '芦淞区', '3', '25758', 'L');
INSERT INTO `ey_region` VALUES ('25777', '石峰区', '3', '25758', 'S');
INSERT INTO `ey_region` VALUES ('25785', '天元区', '3', '25758', 'T');
INSERT INTO `ey_region` VALUES ('25791', '株洲县', '3', '25758', 'Z');
INSERT INTO `ey_region` VALUES ('25810', '攸县', '3', '25758', 'Y');
INSERT INTO `ey_region` VALUES ('25836', '茶陵县', '3', '25758', 'C');
INSERT INTO `ey_region` VALUES ('25863', '炎陵县', '3', '25758', 'Y');
INSERT INTO `ey_region` VALUES ('25881', '醴陵市', '3', '25758', 'L');
INSERT INTO `ey_region` VALUES ('25912', '湘潭市', '2', '25579', 'X');
INSERT INTO `ey_region` VALUES ('25913', '市辖区', '3', '25912', 'S');
INSERT INTO `ey_region` VALUES ('25914', '雨湖区', '3', '25912', 'Y');
INSERT INTO `ey_region` VALUES ('25929', '岳塘区', '3', '25912', 'Y');
INSERT INTO `ey_region` VALUES ('25947', '湘潭县', '3', '25912', 'X');
INSERT INTO `ey_region` VALUES ('25970', '湘乡市', '3', '25912', 'X');
INSERT INTO `ey_region` VALUES ('25993', '韶山市', '3', '25912', 'S');
INSERT INTO `ey_region` VALUES ('26001', '衡阳市', '2', '25579', 'H');
INSERT INTO `ey_region` VALUES ('26002', '市辖区', '3', '26001', 'S');
INSERT INTO `ey_region` VALUES ('26003', '珠晖区', '3', '26001', 'Z');
INSERT INTO `ey_region` VALUES ('26019', '雁峰区', '3', '26001', 'Y');
INSERT INTO `ey_region` VALUES ('26028', '石鼓区', '3', '26001', 'S');
INSERT INTO `ey_region` VALUES ('26037', '蒸湘区', '3', '26001', 'Z');
INSERT INTO `ey_region` VALUES ('26045', '南岳区', '3', '26001', 'N');
INSERT INTO `ey_region` VALUES ('26051', '衡阳县', '3', '26001', 'H');
INSERT INTO `ey_region` VALUES ('26080', '衡南县', '3', '26001', 'H');
INSERT INTO `ey_region` VALUES ('26112', '衡山县', '3', '26001', 'H');
INSERT INTO `ey_region` VALUES ('26130', '衡东县', '3', '26001', 'H');
INSERT INTO `ey_region` VALUES ('26155', '祁东县', '3', '26001', 'Q');
INSERT INTO `ey_region` VALUES ('26179', '耒阳市', '3', '26001', 'L');
INSERT INTO `ey_region` VALUES ('26215', '常宁市', '3', '26001', 'C');
INSERT INTO `ey_region` VALUES ('26242', '邵阳市', '2', '25579', 'S');
INSERT INTO `ey_region` VALUES ('26243', '市辖区', '3', '26242', 'S');
INSERT INTO `ey_region` VALUES ('26244', '双清区', '3', '26242', 'S');
INSERT INTO `ey_region` VALUES ('26257', '大祥区', '3', '26242', 'D');
INSERT INTO `ey_region` VALUES ('26272', '北塔区', '3', '26242', 'B');
INSERT INTO `ey_region` VALUES ('26279', '邵东县', '3', '26242', 'S');
INSERT INTO `ey_region` VALUES ('26306', '新邵县', '3', '26242', 'X');
INSERT INTO `ey_region` VALUES ('26322', '邵阳县', '3', '26242', 'S');
INSERT INTO `ey_region` VALUES ('26348', '隆回县', '3', '26242', 'L');
INSERT INTO `ey_region` VALUES ('26375', '洞口县', '3', '26242', 'D');
INSERT INTO `ey_region` VALUES ('26399', '绥宁县', '3', '26242', 'S');
INSERT INTO `ey_region` VALUES ('26425', '新宁县', '3', '26242', 'X');
INSERT INTO `ey_region` VALUES ('26444', '城步县', '3', '26242', 'C');
INSERT INTO `ey_region` VALUES ('26465', '武冈市', '3', '26242', 'W');
INSERT INTO `ey_region` VALUES ('26485', '岳阳市', '2', '25579', 'Y');
INSERT INTO `ey_region` VALUES ('26486', '市辖区', '3', '26485', 'S');
INSERT INTO `ey_region` VALUES ('26487', '岳阳楼区', '3', '26485', 'Y');
INSERT INTO `ey_region` VALUES ('26511', '云溪区', '3', '26485', 'Y');
INSERT INTO `ey_region` VALUES ('26521', '君山区', '3', '26485', 'J');
INSERT INTO `ey_region` VALUES ('26529', '岳阳县', '3', '26485', 'Y');
INSERT INTO `ey_region` VALUES ('26551', '华容县', '3', '26485', 'H');
INSERT INTO `ey_region` VALUES ('26572', '湘阴县', '3', '26485', 'X');
INSERT INTO `ey_region` VALUES ('26592', '平江县', '3', '26485', 'P');
INSERT INTO `ey_region` VALUES ('26620', '汩罗市', '3', '26485', 'G');
INSERT INTO `ey_region` VALUES ('26657', '临湘市', '3', '26485', 'L');
INSERT INTO `ey_region` VALUES ('26683', '常德市', '2', '25579', 'C');
INSERT INTO `ey_region` VALUES ('26684', '市辖区', '3', '26683', 'S');
INSERT INTO `ey_region` VALUES ('26685', '武陵区', '3', '26683', 'W');
INSERT INTO `ey_region` VALUES ('26702', '鼎城区', '3', '26683', 'D');
INSERT INTO `ey_region` VALUES ('26741', '安乡县', '3', '26683', 'A');
INSERT INTO `ey_region` VALUES ('26762', '汉寿县', '3', '26683', 'H');
INSERT INTO `ey_region` VALUES ('26793', '澧县', '3', '26683', 'L');
INSERT INTO `ey_region` VALUES ('26826', '临澧县', '3', '26683', 'L');
INSERT INTO `ey_region` VALUES ('26844', '桃源县', '3', '26683', 'T');
INSERT INTO `ey_region` VALUES ('26885', '石门县', '3', '26683', 'S');
INSERT INTO `ey_region` VALUES ('26912', '津市市', '3', '26683', 'J');
INSERT INTO `ey_region` VALUES ('26925', '张家界市', '2', '25579', 'Z');
INSERT INTO `ey_region` VALUES ('26926', '市辖区', '3', '26925', 'S');
INSERT INTO `ey_region` VALUES ('26927', '永定区', '3', '26925', 'Y');
INSERT INTO `ey_region` VALUES ('26959', '武陵源区', '3', '26925', 'W');
INSERT INTO `ey_region` VALUES ('26966', '慈利县', '3', '26925', 'C');
INSERT INTO `ey_region` VALUES ('26998', '桑植县', '3', '26925', 'S');
INSERT INTO `ey_region` VALUES ('27038', '益阳市', '2', '25579', 'Y');
INSERT INTO `ey_region` VALUES ('27039', '市辖区', '3', '27038', 'S');
INSERT INTO `ey_region` VALUES ('27040', '资阳区', '3', '27038', 'Z');
INSERT INTO `ey_region` VALUES ('27049', '赫山区', '3', '27038', 'H');
INSERT INTO `ey_region` VALUES ('27069', '南县', '3', '27038', 'N');
INSERT INTO `ey_region` VALUES ('27087', '桃江县', '3', '27038', 'T');
INSERT INTO `ey_region` VALUES ('27106', '安化县', '3', '27038', 'A');
INSERT INTO `ey_region` VALUES ('27130', '沅江市', '3', '27038', 'Y');
INSERT INTO `ey_region` VALUES ('27147', '郴州市', '2', '25579', 'C');
INSERT INTO `ey_region` VALUES ('27148', '市辖区', '3', '27147', 'S');
INSERT INTO `ey_region` VALUES ('27149', '北湖区', '3', '27147', 'B');
INSERT INTO `ey_region` VALUES ('27168', '苏仙区', '3', '27147', 'S');
INSERT INTO `ey_region` VALUES ('27188', '桂阳县', '3', '27147', 'G');
INSERT INTO `ey_region` VALUES ('27228', '宜章县', '3', '27147', 'Y');
INSERT INTO `ey_region` VALUES ('27256', '永兴县', '3', '27147', 'Y');
INSERT INTO `ey_region` VALUES ('27282', '嘉禾县', '3', '27147', 'J');
INSERT INTO `ey_region` VALUES ('27300', '临武县', '3', '27147', 'L');
INSERT INTO `ey_region` VALUES ('27323', '汝城县', '3', '27147', 'R');
INSERT INTO `ey_region` VALUES ('27347', '桂东县', '3', '27147', 'G');
INSERT INTO `ey_region` VALUES ('27367', '安仁县', '3', '27147', 'A');
INSERT INTO `ey_region` VALUES ('27389', '资兴市', '3', '27147', 'Z');
INSERT INTO `ey_region` VALUES ('27418', '永州市', '2', '25579', 'Y');
INSERT INTO `ey_region` VALUES ('27419', '市辖区', '3', '27418', 'S');
INSERT INTO `ey_region` VALUES ('27420', '零陵区', '3', '27418', 'L');
INSERT INTO `ey_region` VALUES ('27437', '冷水滩区', '3', '27418', 'L');
INSERT INTO `ey_region` VALUES ('27459', '祁阳县', '3', '27418', 'Q');
INSERT INTO `ey_region` VALUES ('27492', '东安县', '3', '27418', 'D');
INSERT INTO `ey_region` VALUES ('27511', '双牌县', '3', '27418', 'S');
INSERT INTO `ey_region` VALUES ('27527', '道县', '3', '27418', 'D');
INSERT INTO `ey_region` VALUES ('27554', '江永县', '3', '27418', 'J');
INSERT INTO `ey_region` VALUES ('27567', '宁远县', '3', '27418', 'N');
INSERT INTO `ey_region` VALUES ('27585', '蓝山县', '3', '27418', 'L');
INSERT INTO `ey_region` VALUES ('27606', '新田县', '3', '27418', 'X');
INSERT INTO `ey_region` VALUES ('27626', '江华县', '3', '27418', 'J');
INSERT INTO `ey_region` VALUES ('27650', '怀化市', '2', '25579', 'H');
INSERT INTO `ey_region` VALUES ('27651', '市辖区', '3', '27650', 'S');
INSERT INTO `ey_region` VALUES ('27652', '鹤城区', '3', '27650', 'H');
INSERT INTO `ey_region` VALUES ('27667', '中方县', '3', '27650', 'Z');
INSERT INTO `ey_region` VALUES ('27690', '沅陵县', '3', '27650', 'Y');
INSERT INTO `ey_region` VALUES ('27714', '辰溪县', '3', '27650', 'C');
INSERT INTO `ey_region` VALUES ('27745', '溆浦县', '3', '27650', 'X');
INSERT INTO `ey_region` VALUES ('27789', '会同县', '3', '27650', 'H');
INSERT INTO `ey_region` VALUES ('27815', '麻阳县', '3', '27650', 'M');
INSERT INTO `ey_region` VALUES ('27839', '新晃县', '3', '27650', 'X');
INSERT INTO `ey_region` VALUES ('27863', '芷江县', '3', '27650', 'Z');
INSERT INTO `ey_region` VALUES ('27892', '靖州苗族侗族县', '3', '27650', 'J');
INSERT INTO `ey_region` VALUES ('27906', '通道县', '3', '27650', 'T');
INSERT INTO `ey_region` VALUES ('27930', '洪江市', '3', '27650', 'H');
INSERT INTO `ey_region` VALUES ('27963', '娄底市', '2', '25579', 'L');
INSERT INTO `ey_region` VALUES ('27964', '市辖区', '3', '27963', 'S');
INSERT INTO `ey_region` VALUES ('27965', '娄星区', '3', '27963', 'L');
INSERT INTO `ey_region` VALUES ('27980', '双峰县', '3', '27963', 'S');
INSERT INTO `ey_region` VALUES ('27997', '新化县', '3', '27963', 'X');
INSERT INTO `ey_region` VALUES ('28027', '冷水江市', '3', '27963', 'L');
INSERT INTO `ey_region` VALUES ('28044', '涟源市', '3', '27963', 'L');
INSERT INTO `ey_region` VALUES ('28065', '湘西州', '2', '25579', 'X');
INSERT INTO `ey_region` VALUES ('28066', '吉首市', '3', '28065', 'J');
INSERT INTO `ey_region` VALUES ('28082', '泸溪县', '3', '28065', 'L');
INSERT INTO `ey_region` VALUES ('28099', '凤凰县', '3', '28065', 'F');
INSERT INTO `ey_region` VALUES ('28124', '花垣县', '3', '28065', 'H');
INSERT INTO `ey_region` VALUES ('28143', '保靖县', '3', '28065', 'B');
INSERT INTO `ey_region` VALUES ('28161', '古丈县', '3', '28065', 'G');
INSERT INTO `ey_region` VALUES ('28174', '永顺县', '3', '28065', 'Y');
INSERT INTO `ey_region` VALUES ('28205', '龙山县', '3', '28065', 'L');
INSERT INTO `ey_region` VALUES ('28240', '广东省', '1', '0', 'G');
INSERT INTO `ey_region` VALUES ('28241', '广州市', '2', '28240', 'G');
INSERT INTO `ey_region` VALUES ('28242', '市辖区', '3', '28241', 'S');
INSERT INTO `ey_region` VALUES ('28243', '荔湾区', '3', '28241', 'L');
INSERT INTO `ey_region` VALUES ('28266', '越秀区', '3', '28241', 'Y');
INSERT INTO `ey_region` VALUES ('28289', '海珠区', '3', '28241', 'H');
INSERT INTO `ey_region` VALUES ('28308', '天河区', '3', '28241', 'T');
INSERT INTO `ey_region` VALUES ('28330', '白云区', '3', '28241', 'B');
INSERT INTO `ey_region` VALUES ('28349', '黄埔区', '3', '28241', 'H');
INSERT INTO `ey_region` VALUES ('28359', '番禺区', '3', '28241', 'F');
INSERT INTO `ey_region` VALUES ('28377', '花都区', '3', '28241', 'H');
INSERT INTO `ey_region` VALUES ('28386', '南沙区', '3', '28241', 'N');
INSERT INTO `ey_region` VALUES ('28392', '萝岗区', '3', '28241', 'L');
INSERT INTO `ey_region` VALUES ('28399', '增城市', '3', '28241', 'Z');
INSERT INTO `ey_region` VALUES ('28409', '从化市', '3', '28241', 'C');
INSERT INTO `ey_region` VALUES ('28421', '韶关市', '2', '28240', 'S');
INSERT INTO `ey_region` VALUES ('28422', '市辖区', '3', '28421', 'S');
INSERT INTO `ey_region` VALUES ('28423', '武江区', '3', '28421', 'W');
INSERT INTO `ey_region` VALUES ('28431', '浈江区', '3', '28421', 'Z');
INSERT INTO `ey_region` VALUES ('28448', '曲江区', '3', '28421', 'Q');
INSERT INTO `ey_region` VALUES ('28463', '始兴县', '3', '28421', 'S');
INSERT INTO `ey_region` VALUES ('28475', '仁化县', '3', '28421', 'R');
INSERT INTO `ey_region` VALUES ('28488', '翁源县', '3', '28421', 'W');
INSERT INTO `ey_region` VALUES ('28497', '乳源县', '3', '28421', 'R');
INSERT INTO `ey_region` VALUES ('28509', '新丰县', '3', '28421', 'X');
INSERT INTO `ey_region` VALUES ('28517', '乐昌市', '3', '28421', 'L');
INSERT INTO `ey_region` VALUES ('28539', '南雄市', '3', '28421', 'N');
INSERT INTO `ey_region` VALUES ('28558', '深圳市', '2', '28240', 'S');
INSERT INTO `ey_region` VALUES ('28559', '市辖区', '3', '28558', 'S');
INSERT INTO `ey_region` VALUES ('28560', '罗湖区', '3', '28558', 'L');
INSERT INTO `ey_region` VALUES ('28571', '福田区', '3', '28558', 'F');
INSERT INTO `ey_region` VALUES ('28581', '南山区', '3', '28558', 'N');
INSERT INTO `ey_region` VALUES ('28590', '宝安区', '3', '28558', 'B');
INSERT INTO `ey_region` VALUES ('28604', '龙岗区', '3', '28558', 'L');
INSERT INTO `ey_region` VALUES ('28619', '盐田区', '3', '28558', 'Y');
INSERT INTO `ey_region` VALUES ('28626', '珠海市', '2', '28240', 'Z');
INSERT INTO `ey_region` VALUES ('28627', '市辖区', '3', '28626', 'S');
INSERT INTO `ey_region` VALUES ('28628', '香洲区', '3', '28626', 'X');
INSERT INTO `ey_region` VALUES ('28646', '斗门区', '3', '28626', 'D');
INSERT INTO `ey_region` VALUES ('28654', '金湾区', '3', '28626', 'J');
INSERT INTO `ey_region` VALUES ('28659', '汕头市', '2', '28240', 'S');
INSERT INTO `ey_region` VALUES ('28660', '市辖区', '3', '28659', 'S');
INSERT INTO `ey_region` VALUES ('28661', '龙湖区', '3', '28659', 'L');
INSERT INTO `ey_region` VALUES ('28669', '金平区', '3', '28659', 'J');
INSERT INTO `ey_region` VALUES ('28687', '濠江区', '3', '28659', 'H');
INSERT INTO `ey_region` VALUES ('28695', '潮阳区', '3', '28659', 'C');
INSERT INTO `ey_region` VALUES ('28709', '潮南区', '3', '28659', 'C');
INSERT INTO `ey_region` VALUES ('28721', '澄海区', '3', '28659', 'C');
INSERT INTO `ey_region` VALUES ('28733', '南澳县', '3', '28659', 'N');
INSERT INTO `ey_region` VALUES ('28737', '佛山市', '2', '28240', 'F');
INSERT INTO `ey_region` VALUES ('28738', '市辖区', '3', '28737', 'S');
INSERT INTO `ey_region` VALUES ('28739', '禅城区', '3', '28737', 'C');
INSERT INTO `ey_region` VALUES ('28744', '南海区', '3', '28737', 'N');
INSERT INTO `ey_region` VALUES ('28753', '顺德区', '3', '28737', 'S');
INSERT INTO `ey_region` VALUES ('28764', '三水区', '3', '28737', 'S');
INSERT INTO `ey_region` VALUES ('28776', '高明区', '3', '28737', 'G');
INSERT INTO `ey_region` VALUES ('28785', '江门市', '2', '28240', 'J');
INSERT INTO `ey_region` VALUES ('28786', '市辖区', '3', '28785', 'S');
INSERT INTO `ey_region` VALUES ('28787', '蓬江区', '3', '28785', 'P');
INSERT INTO `ey_region` VALUES ('28797', '江海区', '3', '28785', 'J');
INSERT INTO `ey_region` VALUES ('28803', '新会区', '3', '28785', 'X');
INSERT INTO `ey_region` VALUES ('28818', '台山市', '3', '28785', 'T');
INSERT INTO `ey_region` VALUES ('28837', '开平市', '3', '28785', 'K');
INSERT INTO `ey_region` VALUES ('28853', '鹤山市', '3', '28785', 'H');
INSERT INTO `ey_region` VALUES ('28867', '恩平市', '3', '28785', 'E');
INSERT INTO `ey_region` VALUES ('28880', '湛江市', '2', '28240', 'Z');
INSERT INTO `ey_region` VALUES ('28881', '市辖区', '3', '28880', 'S');
INSERT INTO `ey_region` VALUES ('28882', '湛江市赤坎区', '3', '28880', 'Z');
INSERT INTO `ey_region` VALUES ('28891', '湛江市霞山区', '3', '28880', 'Z');
INSERT INTO `ey_region` VALUES ('28904', '湛江市坡头区', '3', '28880', 'Z');
INSERT INTO `ey_region` VALUES ('28914', '湛江市麻章区', '3', '28880', 'Z');
INSERT INTO `ey_region` VALUES ('28923', '遂溪县', '3', '28880', 'S');
INSERT INTO `ey_region` VALUES ('28941', '徐闻县', '3', '28880', 'X');
INSERT INTO `ey_region` VALUES ('28962', '廉江市', '3', '28880', 'L');
INSERT INTO `ey_region` VALUES ('28984', '雷州市', '3', '28880', 'L');
INSERT INTO `ey_region` VALUES ('29010', '吴川市', '3', '28880', 'W');
INSERT INTO `ey_region` VALUES ('29026', '茂名市', '2', '28240', 'M');
INSERT INTO `ey_region` VALUES ('29027', '市辖区', '3', '29026', 'S');
INSERT INTO `ey_region` VALUES ('29028', '茂南区', '3', '29026', 'M');
INSERT INTO `ey_region` VALUES ('29045', '茂港区', '3', '29026', 'M');
INSERT INTO `ey_region` VALUES ('29053', '电白县', '3', '29026', 'D');
INSERT INTO `ey_region` VALUES ('29075', '高州市', '3', '29026', 'G');
INSERT INTO `ey_region` VALUES ('29107', '化州市', '3', '29026', 'H');
INSERT INTO `ey_region` VALUES ('29138', '信宜市', '3', '29026', 'X');
INSERT INTO `ey_region` VALUES ('29159', '肇庆市', '2', '28240', 'Z');
INSERT INTO `ey_region` VALUES ('29160', '市辖区', '3', '29159', 'S');
INSERT INTO `ey_region` VALUES ('29161', '端州区', '3', '29159', 'D');
INSERT INTO `ey_region` VALUES ('29169', '鼎湖区', '3', '29159', 'D');
INSERT INTO `ey_region` VALUES ('29178', '广宁县', '3', '29159', 'G');
INSERT INTO `ey_region` VALUES ('29196', '怀集县', '3', '29159', 'H');
INSERT INTO `ey_region` VALUES ('29217', '封开县', '3', '29159', 'F');
INSERT INTO `ey_region` VALUES ('29234', '德庆县', '3', '29159', 'D');
INSERT INTO `ey_region` VALUES ('29248', '高要市', '3', '29159', 'G');
INSERT INTO `ey_region` VALUES ('29266', '四会市', '3', '29159', 'S');
INSERT INTO `ey_region` VALUES ('29282', '惠州市', '2', '28240', 'H');
INSERT INTO `ey_region` VALUES ('29283', '市辖区', '3', '29282', 'S');
INSERT INTO `ey_region` VALUES ('29284', '惠城区', '3', '29282', 'H');
INSERT INTO `ey_region` VALUES ('29304', '惠阳区', '3', '29282', 'H');
INSERT INTO `ey_region` VALUES ('29317', '博罗县', '3', '29282', 'B');
INSERT INTO `ey_region` VALUES ('29335', '惠东县', '3', '29282', 'H');
INSERT INTO `ey_region` VALUES ('29355', '龙门县', '3', '29282', 'L');
INSERT INTO `ey_region` VALUES ('29371', '梅州市', '2', '28240', 'M');
INSERT INTO `ey_region` VALUES ('29372', '市辖区', '3', '29371', 'S');
INSERT INTO `ey_region` VALUES ('29373', '梅江区', '3', '29371', 'M');
INSERT INTO `ey_region` VALUES ('29380', '梅县', '3', '29371', 'M');
INSERT INTO `ey_region` VALUES ('29400', '大埔县', '3', '29371', 'D');
INSERT INTO `ey_region` VALUES ('29418', '丰顺县', '3', '29371', 'F');
INSERT INTO `ey_region` VALUES ('29436', '五华县', '3', '29371', 'W');
INSERT INTO `ey_region` VALUES ('29453', '平远县', '3', '29371', 'P');
INSERT INTO `ey_region` VALUES ('29466', '蕉岭县', '3', '29371', 'J');
INSERT INTO `ey_region` VALUES ('29477', '兴宁市', '3', '29371', 'X');
INSERT INTO `ey_region` VALUES ('29498', '汕尾市', '2', '28240', 'S');
INSERT INTO `ey_region` VALUES ('29499', '市辖区', '3', '29498', 'S');
INSERT INTO `ey_region` VALUES ('29500', '城区', '3', '29498', 'C');
INSERT INTO `ey_region` VALUES ('29511', '海丰县', '3', '29498', 'H');
INSERT INTO `ey_region` VALUES ('29529', '陆河县', '3', '29498', 'L');
INSERT INTO `ey_region` VALUES ('29538', '陆丰市', '3', '29498', 'L');
INSERT INTO `ey_region` VALUES ('29568', '河源市', '2', '28240', 'H');
INSERT INTO `ey_region` VALUES ('29569', '市辖区', '3', '29568', 'S');
INSERT INTO `ey_region` VALUES ('29570', '源城区', '3', '29568', 'Y');
INSERT INTO `ey_region` VALUES ('29578', '紫金县', '3', '29568', 'Z');
INSERT INTO `ey_region` VALUES ('29599', '龙川县', '3', '29568', 'L');
INSERT INTO `ey_region` VALUES ('29625', '连平县', '3', '29568', 'L');
INSERT INTO `ey_region` VALUES ('29639', '和平县', '3', '29568', 'H');
INSERT INTO `ey_region` VALUES ('29657', '东源县', '3', '29568', 'D');
INSERT INTO `ey_region` VALUES ('29679', '阳江市', '2', '28240', 'Y');
INSERT INTO `ey_region` VALUES ('29680', '市辖区', '3', '29679', 'S');
INSERT INTO `ey_region` VALUES ('29681', '江城区', '3', '29679', 'J');
INSERT INTO `ey_region` VALUES ('29698', '阳西县', '3', '29679', 'Y');
INSERT INTO `ey_region` VALUES ('29709', '阳东县', '3', '29679', 'Y');
INSERT INTO `ey_region` VALUES ('29729', '阳春市', '3', '29679', 'Y');
INSERT INTO `ey_region` VALUES ('29755', '清远市', '2', '28240', 'Q');
INSERT INTO `ey_region` VALUES ('29756', '市辖区', '3', '29755', 'S');
INSERT INTO `ey_region` VALUES ('29757', '清城区', '3', '29755', 'Q');
INSERT INTO `ey_region` VALUES ('29766', '佛冈县', '3', '29755', 'F');
INSERT INTO `ey_region` VALUES ('29773', '阳山县', '3', '29755', 'Y');
INSERT INTO `ey_region` VALUES ('29787', '连山县', '3', '29755', 'L');
INSERT INTO `ey_region` VALUES ('29797', '连南县', '3', '29755', 'L');
INSERT INTO `ey_region` VALUES ('29805', '清新县', '3', '29755', 'Q');
INSERT INTO `ey_region` VALUES ('29816', '英德市', '3', '29755', 'Y');
INSERT INTO `ey_region` VALUES ('29842', '连州市', '3', '29755', 'L');
INSERT INTO `ey_region` VALUES ('29855', '东莞市', '2', '28240', 'D');
INSERT INTO `ey_region` VALUES ('29890', '中山市', '2', '28240', 'Z');
INSERT INTO `ey_region` VALUES ('29915', '潮州市', '2', '28240', 'C');
INSERT INTO `ey_region` VALUES ('29916', '市辖区', '3', '29915', 'S');
INSERT INTO `ey_region` VALUES ('29917', '潮州市湘桥区', '3', '29915', 'C');
INSERT INTO `ey_region` VALUES ('29930', '潮州市潮安县', '3', '29915', 'C');
INSERT INTO `ey_region` VALUES ('29954', '潮州市饶平县', '3', '29915', 'C');
INSERT INTO `ey_region` VALUES ('29977', '揭阳市', '2', '28240', 'J');
INSERT INTO `ey_region` VALUES ('29978', '市辖区', '3', '29977', 'S');
INSERT INTO `ey_region` VALUES ('29979', '榕城区', '3', '29977', 'R');
INSERT INTO `ey_region` VALUES ('29990', '揭东县', '3', '29977', 'J');
INSERT INTO `ey_region` VALUES ('30008', '揭西县', '3', '29977', 'J');
INSERT INTO `ey_region` VALUES ('30032', '惠来县', '3', '29977', 'H');
INSERT INTO `ey_region` VALUES ('30054', '普宁市', '3', '29977', 'P');
INSERT INTO `ey_region` VALUES ('30086', '云浮市', '2', '28240', 'Y');
INSERT INTO `ey_region` VALUES ('30087', '市辖区', '3', '30086', 'S');
INSERT INTO `ey_region` VALUES ('30088', '云城区', '3', '30086', 'Y');
INSERT INTO `ey_region` VALUES ('30096', '新兴县', '3', '30086', 'X');
INSERT INTO `ey_region` VALUES ('30112', '郁南县', '3', '30086', 'Y');
INSERT INTO `ey_region` VALUES ('30132', '云安县', '3', '30086', 'Y');
INSERT INTO `ey_region` VALUES ('30141', '罗定市', '3', '30086', 'L');
INSERT INTO `ey_region` VALUES ('30164', '广西壮族自治区', '1', '0', 'G');
INSERT INTO `ey_region` VALUES ('30165', '南宁市', '2', '30164', 'N');
INSERT INTO `ey_region` VALUES ('30166', '市辖区', '3', '30165', 'S');
INSERT INTO `ey_region` VALUES ('30167', '兴宁区', '3', '30165', 'X');
INSERT INTO `ey_region` VALUES ('30174', '青秀区', '3', '30165', 'Q');
INSERT INTO `ey_region` VALUES ('30186', '江南区', '3', '30165', 'J');
INSERT INTO `ey_region` VALUES ('30196', '西乡塘区', '3', '30165', 'X');
INSERT INTO `ey_region` VALUES ('30214', '良庆区', '3', '30165', 'L');
INSERT INTO `ey_region` VALUES ('30222', '邕宁区', '3', '30165', 'Y');
INSERT INTO `ey_region` VALUES ('30228', '武鸣县', '3', '30165', 'W');
INSERT INTO `ey_region` VALUES ('30245', '隆安县', '3', '30165', 'L');
INSERT INTO `ey_region` VALUES ('30257', '马山县', '3', '30165', 'M');
INSERT INTO `ey_region` VALUES ('30270', '上林县', '3', '30165', 'S');
INSERT INTO `ey_region` VALUES ('30282', '宾阳县', '3', '30165', 'B');
INSERT INTO `ey_region` VALUES ('30300', '横县', '3', '30165', 'H');
INSERT INTO `ey_region` VALUES ('30319', '柳州市', '2', '30164', 'L');
INSERT INTO `ey_region` VALUES ('30320', '市辖区', '3', '30319', 'S');
INSERT INTO `ey_region` VALUES ('30321', '城中区', '3', '30319', 'C');
INSERT INTO `ey_region` VALUES ('30329', '鱼峰区', '3', '30319', 'Y');
INSERT INTO `ey_region` VALUES ('30338', '柳南区', '3', '30319', 'L');
INSERT INTO `ey_region` VALUES ('30348', '柳北区', '3', '30319', 'L');
INSERT INTO `ey_region` VALUES ('30361', '柳江县', '3', '30319', 'L');
INSERT INTO `ey_region` VALUES ('30374', '柳城县', '3', '30319', 'L');
INSERT INTO `ey_region` VALUES ('30387', '鹿寨县', '3', '30319', 'L');
INSERT INTO `ey_region` VALUES ('30398', '融安县', '3', '30319', 'R');
INSERT INTO `ey_region` VALUES ('30411', '融水县', '3', '30319', 'R');
INSERT INTO `ey_region` VALUES ('30432', '三江县', '3', '30319', 'S');
INSERT INTO `ey_region` VALUES ('30448', '桂林市', '2', '30164', 'G');
INSERT INTO `ey_region` VALUES ('30449', '市辖区', '3', '30448', 'S');
INSERT INTO `ey_region` VALUES ('30450', '秀峰区', '3', '30448', 'X');
INSERT INTO `ey_region` VALUES ('30454', '叠彩区', '3', '30448', 'D');
INSERT INTO `ey_region` VALUES ('30458', '象山区', '3', '30448', 'X');
INSERT INTO `ey_region` VALUES ('30463', '七星区', '3', '30448', 'Q');
INSERT INTO `ey_region` VALUES ('30469', '雁山区', '3', '30448', 'Y');
INSERT INTO `ey_region` VALUES ('30475', '阳朔县', '3', '30448', 'Y');
INSERT INTO `ey_region` VALUES ('30485', '临桂县', '3', '30448', 'L');
INSERT INTO `ey_region` VALUES ('30497', '灵川县', '3', '30448', 'L');
INSERT INTO `ey_region` VALUES ('30509', '全州县', '3', '30448', 'Q');
INSERT INTO `ey_region` VALUES ('30528', '兴安县', '3', '30448', 'X');
INSERT INTO `ey_region` VALUES ('30539', '永福县', '3', '30448', 'Y');
INSERT INTO `ey_region` VALUES ('30549', '灌阳县', '3', '30448', 'G');
INSERT INTO `ey_region` VALUES ('30559', '龙胜县', '3', '30448', 'L');
INSERT INTO `ey_region` VALUES ('30570', '资源县', '3', '30448', 'Z');
INSERT INTO `ey_region` VALUES ('30578', '平乐县', '3', '30448', 'P');
INSERT INTO `ey_region` VALUES ('30589', '荔浦县', '3', '30448', 'L');
INSERT INTO `ey_region` VALUES ('30603', '恭城县', '3', '30448', 'G');
INSERT INTO `ey_region` VALUES ('30613', '梧州市', '2', '30164', 'W');
INSERT INTO `ey_region` VALUES ('30614', '市辖区', '3', '30613', 'S');
INSERT INTO `ey_region` VALUES ('30615', '万秀区', '3', '30613', 'W');
INSERT INTO `ey_region` VALUES ('30622', '蝶山区', '3', '30613', 'D');
INSERT INTO `ey_region` VALUES ('30628', '长洲区', '3', '30613', 'C');
INSERT INTO `ey_region` VALUES ('30633', '苍梧县', '3', '30613', 'C');
INSERT INTO `ey_region` VALUES ('30646', '藤县', '3', '30613', 'T');
INSERT INTO `ey_region` VALUES ('30663', '蒙山县', '3', '30613', 'M');
INSERT INTO `ey_region` VALUES ('30673', '岑溪市', '3', '30613', 'C');
INSERT INTO `ey_region` VALUES ('30688', '北海市', '2', '30164', 'B');
INSERT INTO `ey_region` VALUES ('30689', '市辖区', '3', '30688', 'S');
INSERT INTO `ey_region` VALUES ('30690', '海城区', '3', '30688', 'H');
INSERT INTO `ey_region` VALUES ('30699', '银海区', '3', '30688', 'Y');
INSERT INTO `ey_region` VALUES ('30704', '铁山港区', '3', '30688', 'T');
INSERT INTO `ey_region` VALUES ('30708', '合浦县', '3', '30688', 'H');
INSERT INTO `ey_region` VALUES ('30724', '防城港市', '2', '30164', 'F');
INSERT INTO `ey_region` VALUES ('30725', '市辖区', '3', '30724', 'S');
INSERT INTO `ey_region` VALUES ('30726', '港口区', '3', '30724', 'G');
INSERT INTO `ey_region` VALUES ('30732', '防城区', '3', '30724', 'F');
INSERT INTO `ey_region` VALUES ('30748', '上思县', '3', '30724', 'S');
INSERT INTO `ey_region` VALUES ('30758', '东兴市', '3', '30724', 'D');
INSERT INTO `ey_region` VALUES ('30762', '钦州市', '2', '30164', 'Q');
INSERT INTO `ey_region` VALUES ('30763', '市辖区', '3', '30762', 'S');
INSERT INTO `ey_region` VALUES ('30764', '钦南区', '3', '30762', 'Q');
INSERT INTO `ey_region` VALUES ('30783', '钦北区', '3', '30762', 'Q');
INSERT INTO `ey_region` VALUES ('30796', '灵山县', '3', '30762', 'L');
INSERT INTO `ey_region` VALUES ('30817', '浦北县', '3', '30762', 'P');
INSERT INTO `ey_region` VALUES ('30834', '贵港市', '2', '30164', 'G');
INSERT INTO `ey_region` VALUES ('30835', '市辖区', '3', '30834', 'S');
INSERT INTO `ey_region` VALUES ('30836', '港北区', '3', '30834', 'G');
INSERT INTO `ey_region` VALUES ('30845', '港南区', '3', '30834', 'G');
INSERT INTO `ey_region` VALUES ('30855', '覃塘区', '3', '30834', 'Q');
INSERT INTO `ey_region` VALUES ('30866', '平南县', '3', '30834', 'P');
INSERT INTO `ey_region` VALUES ('30888', '桂平市', '3', '30834', 'G');
INSERT INTO `ey_region` VALUES ('30915', '玉林市', '2', '30164', 'Y');
INSERT INTO `ey_region` VALUES ('30916', '市辖区', '3', '30915', 'S');
INSERT INTO `ey_region` VALUES ('30917', '玉州区', '3', '30915', 'Y');
INSERT INTO `ey_region` VALUES ('30933', '容县', '3', '30915', 'R');
INSERT INTO `ey_region` VALUES ('30949', '陆川县', '3', '30915', 'L');
INSERT INTO `ey_region` VALUES ('30964', '博白县', '3', '30915', 'B');
INSERT INTO `ey_region` VALUES ('30993', '兴业县', '3', '30915', 'X');
INSERT INTO `ey_region` VALUES ('31007', '北流市', '3', '30915', 'B');
INSERT INTO `ey_region` VALUES ('31033', '百色市', '2', '30164', 'B');
INSERT INTO `ey_region` VALUES ('31034', '市辖区', '3', '31033', 'S');
INSERT INTO `ey_region` VALUES ('31035', '右江区', '3', '31033', 'Y');
INSERT INTO `ey_region` VALUES ('31045', '田阳县', '3', '31033', 'T');
INSERT INTO `ey_region` VALUES ('31056', '田东县', '3', '31033', 'T');
INSERT INTO `ey_region` VALUES ('31067', '平果县', '3', '31033', 'P');
INSERT INTO `ey_region` VALUES ('31081', '德保县', '3', '31033', 'D');
INSERT INTO `ey_region` VALUES ('31095', '靖西县', '3', '31033', 'J');
INSERT INTO `ey_region` VALUES ('31115', '那坡县', '3', '31033', 'N');
INSERT INTO `ey_region` VALUES ('31125', '凌云县', '3', '31033', 'L');
INSERT INTO `ey_region` VALUES ('31134', '乐业县', '3', '31033', 'L');
INSERT INTO `ey_region` VALUES ('31143', '田林县', '3', '31033', 'T');
INSERT INTO `ey_region` VALUES ('31158', '西林县', '3', '31033', 'X');
INSERT INTO `ey_region` VALUES ('31167', '隆林县', '3', '31033', 'L');
INSERT INTO `ey_region` VALUES ('31184', '贺州市', '2', '30164', 'H');
INSERT INTO `ey_region` VALUES ('31185', '市辖区', '3', '31184', 'S');
INSERT INTO `ey_region` VALUES ('31186', '八步区', '3', '31184', 'B');
INSERT INTO `ey_region` VALUES ('31208', '昭平县', '3', '31184', 'Z');
INSERT INTO `ey_region` VALUES ('31221', '钟山县', '3', '31184', 'Z');
INSERT INTO `ey_region` VALUES ('31236', '富川县', '3', '31184', 'F');
INSERT INTO `ey_region` VALUES ('31249', '河池市', '2', '30164', 'H');
INSERT INTO `ey_region` VALUES ('31250', '市辖区', '3', '31249', 'S');
INSERT INTO `ey_region` VALUES ('31251', '金城江区', '3', '31249', 'J');
INSERT INTO `ey_region` VALUES ('31264', '南丹县', '3', '31249', 'N');
INSERT INTO `ey_region` VALUES ('31276', '天峨县', '3', '31249', 'T');
INSERT INTO `ey_region` VALUES ('31286', '凤山县', '3', '31249', 'F');
INSERT INTO `ey_region` VALUES ('31296', '东兰县', '3', '31249', 'D');
INSERT INTO `ey_region` VALUES ('31311', '罗城县', '3', '31249', 'L');
INSERT INTO `ey_region` VALUES ('31323', '环江县', '3', '31249', 'H');
INSERT INTO `ey_region` VALUES ('31336', '巴马县', '3', '31249', 'B');
INSERT INTO `ey_region` VALUES ('31347', '都安县', '3', '31249', 'D');
INSERT INTO `ey_region` VALUES ('31367', '大化县', '3', '31249', 'D');
INSERT INTO `ey_region` VALUES ('31384', '宜州市', '3', '31249', 'Y');
INSERT INTO `ey_region` VALUES ('31401', '来宾市', '2', '30164', 'L');
INSERT INTO `ey_region` VALUES ('31402', '市辖区', '3', '31401', 'S');
INSERT INTO `ey_region` VALUES ('31403', '兴宾区', '3', '31401', 'X');
INSERT INTO `ey_region` VALUES ('31427', '忻城县', '3', '31401', 'X');
INSERT INTO `ey_region` VALUES ('31440', '象州县', '3', '31401', 'X');
INSERT INTO `ey_region` VALUES ('31452', '武宣县', '3', '31401', 'W');
INSERT INTO `ey_region` VALUES ('31463', '金秀县', '3', '31401', 'J');
INSERT INTO `ey_region` VALUES ('31474', '合山市', '3', '31401', 'H');
INSERT INTO `ey_region` VALUES ('31478', '崇左市', '2', '30164', 'C');
INSERT INTO `ey_region` VALUES ('31479', '市辖区', '3', '31478', 'S');
INSERT INTO `ey_region` VALUES ('31480', '江州区', '3', '31478', 'J');
INSERT INTO `ey_region` VALUES ('31490', '扶绥县', '3', '31478', 'F');
INSERT INTO `ey_region` VALUES ('31502', '宁明县', '3', '31478', 'N');
INSERT INTO `ey_region` VALUES ('31516', '龙州县', '3', '31478', 'L');
INSERT INTO `ey_region` VALUES ('31529', '大新县', '3', '31478', 'D');
INSERT INTO `ey_region` VALUES ('31544', '天等县', '3', '31478', 'T');
INSERT INTO `ey_region` VALUES ('31558', '凭祥市', '3', '31478', 'P');
INSERT INTO `ey_region` VALUES ('31563', '海南省', '1', '0', 'H');
INSERT INTO `ey_region` VALUES ('31564', '海口市', '2', '31563', 'H');
INSERT INTO `ey_region` VALUES ('31565', '市辖区', '3', '31564', 'S');
INSERT INTO `ey_region` VALUES ('31566', '秀英区', '3', '31564', 'X');
INSERT INTO `ey_region` VALUES ('31575', '龙华区', '3', '31564', 'L');
INSERT INTO `ey_region` VALUES ('31587', '琼山区', '3', '31564', 'Q');
INSERT INTO `ey_region` VALUES ('31601', '美兰区', '3', '31564', 'M');
INSERT INTO `ey_region` VALUES ('31618', '三亚市', '2', '31563', 'S');
INSERT INTO `ey_region` VALUES ('31619', '市辖区', '3', '31618', 'S');
INSERT INTO `ey_region` VALUES ('31634', '五指山市', '2', '31563', 'W');
INSERT INTO `ey_region` VALUES ('31635', '冲山镇', '3', '31634', 'C');
INSERT INTO `ey_region` VALUES ('31636', '南圣镇', '3', '31634', 'N');
INSERT INTO `ey_region` VALUES ('31637', '毛阳镇', '3', '31634', 'M');
INSERT INTO `ey_region` VALUES ('31638', '番阳镇', '3', '31634', 'F');
INSERT INTO `ey_region` VALUES ('31639', '畅好乡', '3', '31634', 'C');
INSERT INTO `ey_region` VALUES ('31640', '毛道乡', '3', '31634', 'M');
INSERT INTO `ey_region` VALUES ('31641', '水满乡', '3', '31634', 'S');
INSERT INTO `ey_region` VALUES ('31642', '国营畅好农场', '3', '31634', 'G');
INSERT INTO `ey_region` VALUES ('31643', '琼海市', '2', '31563', 'Q');
INSERT INTO `ey_region` VALUES ('31644', '嘉积镇', '3', '31643', 'J');
INSERT INTO `ey_region` VALUES ('31645', '万泉镇', '3', '31643', 'W');
INSERT INTO `ey_region` VALUES ('31646', '石壁镇', '3', '31643', 'S');
INSERT INTO `ey_region` VALUES ('31647', '中原镇', '3', '31643', 'Z');
INSERT INTO `ey_region` VALUES ('31648', '博敖镇', '3', '31643', 'B');
INSERT INTO `ey_region` VALUES ('31649', '阳江镇', '3', '31643', 'Y');
INSERT INTO `ey_region` VALUES ('31650', '龙江镇', '3', '31643', 'L');
INSERT INTO `ey_region` VALUES ('31651', '潭门镇', '3', '31643', 'T');
INSERT INTO `ey_region` VALUES ('31652', '塔洋镇', '3', '31643', 'T');
INSERT INTO `ey_region` VALUES ('31653', '长坡镇', '3', '31643', 'C');
INSERT INTO `ey_region` VALUES ('31654', '大路镇', '3', '31643', 'D');
INSERT INTO `ey_region` VALUES ('31655', '会山镇', '3', '31643', 'H');
INSERT INTO `ey_region` VALUES ('31656', '国营东太农场', '3', '31643', 'G');
INSERT INTO `ey_region` VALUES ('31657', '国营东平农场', '3', '31643', 'G');
INSERT INTO `ey_region` VALUES ('31658', '国营东红农场', '3', '31643', 'G');
INSERT INTO `ey_region` VALUES ('31659', '国营东升农场', '3', '31643', 'G');
INSERT INTO `ey_region` VALUES ('31660', '国营南俸农场', '3', '31643', 'G');
INSERT INTO `ey_region` VALUES ('31661', '彬村山华侨农场', '3', '31643', 'B');
INSERT INTO `ey_region` VALUES ('31662', '儋州市', '2', '31563', 'D');
INSERT INTO `ey_region` VALUES ('31663', '那大镇', '3', '31662', 'N');
INSERT INTO `ey_region` VALUES ('31664', '和庆镇', '3', '31662', 'H');
INSERT INTO `ey_region` VALUES ('31665', '南丰镇', '3', '31662', 'N');
INSERT INTO `ey_region` VALUES ('31666', '大成镇', '3', '31662', 'D');
INSERT INTO `ey_region` VALUES ('31667', '雅星镇', '3', '31662', 'Y');
INSERT INTO `ey_region` VALUES ('31668', '兰洋镇', '3', '31662', 'L');
INSERT INTO `ey_region` VALUES ('31669', '光村镇', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31670', '木棠镇', '3', '31662', 'M');
INSERT INTO `ey_region` VALUES ('31671', '海头镇', '3', '31662', 'H');
INSERT INTO `ey_region` VALUES ('31672', '峨蔓镇', '3', '31662', 'E');
INSERT INTO `ey_region` VALUES ('31673', '三都镇', '3', '31662', 'S');
INSERT INTO `ey_region` VALUES ('31674', '王五镇', '3', '31662', 'W');
INSERT INTO `ey_region` VALUES ('31675', '白马井镇', '3', '31662', 'B');
INSERT INTO `ey_region` VALUES ('31676', '中和镇', '3', '31662', 'Z');
INSERT INTO `ey_region` VALUES ('31677', '排浦镇', '3', '31662', 'P');
INSERT INTO `ey_region` VALUES ('31678', '东成镇', '3', '31662', 'D');
INSERT INTO `ey_region` VALUES ('31679', '新州镇', '3', '31662', 'X');
INSERT INTO `ey_region` VALUES ('31680', '国营西培农场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31681', '国营西华农场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31682', '国营西庆农场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31683', '国营西流农场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31684', '国营西联农场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31685', '国营蓝洋农场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31686', '国营新盈农场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31687', '国营八一农场东山分场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31688', '国营八一农场金川分场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31689', '国营八一农场长岭分场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31690', '国营八一农场英岛分场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31691', '国营八一农场春江分场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31692', '国营八一农场强打管区', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31693', '国营龙山农场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31694', '国营红岭农场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31695', '洋浦经济开发区', '3', '31662', 'Y');
INSERT INTO `ey_region` VALUES ('31696', '华南热作学院', '3', '31662', 'H');
INSERT INTO `ey_region` VALUES ('31697', '文昌市', '2', '31563', 'W');
INSERT INTO `ey_region` VALUES ('31698', '文城镇', '3', '31697', 'W');
INSERT INTO `ey_region` VALUES ('31699', '重兴镇', '3', '31697', 'Z');
INSERT INTO `ey_region` VALUES ('31700', '蓬莱镇', '3', '31697', 'P');
INSERT INTO `ey_region` VALUES ('31701', '会文镇', '3', '31697', 'H');
INSERT INTO `ey_region` VALUES ('31702', '东路镇', '3', '31697', 'D');
INSERT INTO `ey_region` VALUES ('31703', '潭牛镇', '3', '31697', 'T');
INSERT INTO `ey_region` VALUES ('31704', '东阁镇', '3', '31697', 'D');
INSERT INTO `ey_region` VALUES ('31705', '文教镇', '3', '31697', 'W');
INSERT INTO `ey_region` VALUES ('31706', '东郊镇', '3', '31697', 'D');
INSERT INTO `ey_region` VALUES ('31707', '龙楼镇', '3', '31697', 'L');
INSERT INTO `ey_region` VALUES ('31708', '昌洒镇', '3', '31697', 'C');
INSERT INTO `ey_region` VALUES ('31709', '翁田镇', '3', '31697', 'W');
INSERT INTO `ey_region` VALUES ('31710', '抱罗镇', '3', '31697', 'B');
INSERT INTO `ey_region` VALUES ('31711', '冯坡镇', '3', '31697', 'F');
INSERT INTO `ey_region` VALUES ('31712', '锦山镇', '3', '31697', 'J');
INSERT INTO `ey_region` VALUES ('31713', '铺前镇', '3', '31697', 'P');
INSERT INTO `ey_region` VALUES ('31714', '国营东路农场', '3', '31697', 'G');
INSERT INTO `ey_region` VALUES ('31715', '国营南阳农场', '3', '31697', 'G');
INSERT INTO `ey_region` VALUES ('31716', '国营罗豆农场', '3', '31697', 'G');
INSERT INTO `ey_region` VALUES ('31717', '国营文昌橡胶研究所', '3', '31697', 'G');
INSERT INTO `ey_region` VALUES ('31718', '万宁市', '2', '31563', 'W');
INSERT INTO `ey_region` VALUES ('31719', '万城镇', '3', '31718', 'W');
INSERT INTO `ey_region` VALUES ('31720', '龙滚镇', '3', '31718', 'L');
INSERT INTO `ey_region` VALUES ('31721', '和乐镇', '3', '31718', 'H');
INSERT INTO `ey_region` VALUES ('31722', '后安镇', '3', '31718', 'H');
INSERT INTO `ey_region` VALUES ('31723', '大茂镇', '3', '31718', 'D');
INSERT INTO `ey_region` VALUES ('31724', '东澳镇', '3', '31718', 'D');
INSERT INTO `ey_region` VALUES ('31725', '礼纪镇', '3', '31718', 'L');
INSERT INTO `ey_region` VALUES ('31726', '长丰镇', '3', '31718', 'C');
INSERT INTO `ey_region` VALUES ('31727', '山根镇', '3', '31718', 'S');
INSERT INTO `ey_region` VALUES ('31728', '北大镇', '3', '31718', 'B');
INSERT INTO `ey_region` VALUES ('31729', '南桥镇', '3', '31718', 'N');
INSERT INTO `ey_region` VALUES ('31730', '三更罗镇', '3', '31718', 'S');
INSERT INTO `ey_region` VALUES ('31731', '国营东兴农场', '3', '31718', 'G');
INSERT INTO `ey_region` VALUES ('31732', '国营东和农场', '3', '31718', 'G');
INSERT INTO `ey_region` VALUES ('31733', '国营东岭农场', '3', '31718', 'G');
INSERT INTO `ey_region` VALUES ('31734', '国营南林农场', '3', '31718', 'G');
INSERT INTO `ey_region` VALUES ('31735', '国营新中农场', '3', '31718', 'G');
INSERT INTO `ey_region` VALUES ('31736', '兴隆华侨农场', '3', '31718', 'X');
INSERT INTO `ey_region` VALUES ('31737', '地方国营六连林场', '3', '31718', 'D');
INSERT INTO `ey_region` VALUES ('31738', '东方市', '2', '31563', 'D');
INSERT INTO `ey_region` VALUES ('31739', '八所镇', '3', '31738', 'B');
INSERT INTO `ey_region` VALUES ('31740', '东河镇', '3', '31738', 'D');
INSERT INTO `ey_region` VALUES ('31741', '大田镇', '3', '31738', 'D');
INSERT INTO `ey_region` VALUES ('31742', '感城镇', '3', '31738', 'G');
INSERT INTO `ey_region` VALUES ('31743', '板桥镇', '3', '31738', 'B');
INSERT INTO `ey_region` VALUES ('31744', '三家镇', '3', '31738', 'S');
INSERT INTO `ey_region` VALUES ('31745', '四更镇', '3', '31738', 'S');
INSERT INTO `ey_region` VALUES ('31746', '新龙镇', '3', '31738', 'X');
INSERT INTO `ey_region` VALUES ('31747', '天安乡', '3', '31738', 'T');
INSERT INTO `ey_region` VALUES ('31748', '江边乡', '3', '31738', 'J');
INSERT INTO `ey_region` VALUES ('31749', '国营广坝农场', '3', '31738', 'G');
INSERT INTO `ey_region` VALUES ('31750', '国营公爱农场', '3', '31738', 'G');
INSERT INTO `ey_region` VALUES ('31751', '国营红泉农场', '3', '31738', 'G');
INSERT INTO `ey_region` VALUES ('31752', '省国营东方华侨农场', '3', '31738', 'S');
INSERT INTO `ey_region` VALUES ('31753', '定安县', '2', '31563', 'D');
INSERT INTO `ey_region` VALUES ('31754', '定城镇', '3', '31753', 'D');
INSERT INTO `ey_region` VALUES ('31755', '新竹镇', '3', '31753', 'X');
INSERT INTO `ey_region` VALUES ('31756', '龙湖镇', '3', '31753', 'L');
INSERT INTO `ey_region` VALUES ('31757', '黄竹镇', '3', '31753', 'H');
INSERT INTO `ey_region` VALUES ('31758', '雷鸣镇', '3', '31753', 'L');
INSERT INTO `ey_region` VALUES ('31759', '龙门镇', '3', '31753', 'L');
INSERT INTO `ey_region` VALUES ('31760', '龙河镇', '3', '31753', 'L');
INSERT INTO `ey_region` VALUES ('31761', '岭口镇', '3', '31753', 'L');
INSERT INTO `ey_region` VALUES ('31762', '翰林镇', '3', '31753', 'H');
INSERT INTO `ey_region` VALUES ('31763', '富文镇', '3', '31753', 'F');
INSERT INTO `ey_region` VALUES ('31764', '国营中瑞农场', '3', '31753', 'G');
INSERT INTO `ey_region` VALUES ('31765', '国营南海农场', '3', '31753', 'G');
INSERT INTO `ey_region` VALUES ('31766', '国营金鸡岭农场', '3', '31753', 'G');
INSERT INTO `ey_region` VALUES ('31767', '定安热作研究所', '3', '31753', 'D');
INSERT INTO `ey_region` VALUES ('31768', '屯昌县', '2', '31563', 'T');
INSERT INTO `ey_region` VALUES ('31769', '屯城镇', '3', '31768', 'T');
INSERT INTO `ey_region` VALUES ('31770', '新兴镇', '3', '31768', 'X');
INSERT INTO `ey_region` VALUES ('31771', '枫木镇', '3', '31768', 'F');
INSERT INTO `ey_region` VALUES ('31772', '乌坡镇', '3', '31768', 'W');
INSERT INTO `ey_region` VALUES ('31773', '南吕镇', '3', '31768', 'N');
INSERT INTO `ey_region` VALUES ('31774', '南坤镇', '3', '31768', 'N');
INSERT INTO `ey_region` VALUES ('31775', '坡心镇', '3', '31768', 'P');
INSERT INTO `ey_region` VALUES ('31776', '西昌镇', '3', '31768', 'X');
INSERT INTO `ey_region` VALUES ('31777', '国营中建农场', '3', '31768', 'G');
INSERT INTO `ey_region` VALUES ('31778', '国营中坤农场', '3', '31768', 'G');
INSERT INTO `ey_region` VALUES ('31779', '国营黄岭农场', '3', '31768', 'G');
INSERT INTO `ey_region` VALUES ('31780', '国营南吕农场', '3', '31768', 'G');
INSERT INTO `ey_region` VALUES ('31781', '国营广青农场', '3', '31768', 'G');
INSERT INTO `ey_region` VALUES ('31782', '国营晨星农场', '3', '31768', 'G');
INSERT INTO `ey_region` VALUES ('31783', '澄迈县', '2', '31563', 'C');
INSERT INTO `ey_region` VALUES ('31784', '金江镇', '3', '31783', 'J');
INSERT INTO `ey_region` VALUES ('31785', '老城镇', '3', '31783', 'L');
INSERT INTO `ey_region` VALUES ('31786', '瑞溪镇', '3', '31783', 'R');
INSERT INTO `ey_region` VALUES ('31787', '永发镇', '3', '31783', 'Y');
INSERT INTO `ey_region` VALUES ('31788', '加乐镇', '3', '31783', 'J');
INSERT INTO `ey_region` VALUES ('31789', '文儒镇', '3', '31783', 'W');
INSERT INTO `ey_region` VALUES ('31790', '中兴镇', '3', '31783', 'Z');
INSERT INTO `ey_region` VALUES ('31791', '仁兴镇', '3', '31783', 'R');
INSERT INTO `ey_region` VALUES ('31792', '福山镇', '3', '31783', 'F');
INSERT INTO `ey_region` VALUES ('31793', '桥头镇', '3', '31783', 'Q');
INSERT INTO `ey_region` VALUES ('31794', '国营红光农场', '3', '31783', 'G');
INSERT INTO `ey_region` VALUES ('31795', '国营红岗农场', '3', '31783', 'G');
INSERT INTO `ey_region` VALUES ('31796', '国营西达农场', '3', '31783', 'G');
INSERT INTO `ey_region` VALUES ('31797', '国营昆仑农场', '3', '31783', 'G');
INSERT INTO `ey_region` VALUES ('31798', '国营和岭农场', '3', '31783', 'G');
INSERT INTO `ey_region` VALUES ('31799', '国营金安农场', '3', '31783', 'G');
INSERT INTO `ey_region` VALUES ('31800', '澄迈县华侨农场', '3', '31783', 'C');
INSERT INTO `ey_region` VALUES ('31801', '临高县', '2', '31563', 'L');
INSERT INTO `ey_region` VALUES ('31802', '临城镇', '3', '31801', 'L');
INSERT INTO `ey_region` VALUES ('31803', '波莲镇', '3', '31801', 'B');
INSERT INTO `ey_region` VALUES ('31804', '东英镇', '3', '31801', 'D');
INSERT INTO `ey_region` VALUES ('31805', '博厚镇', '3', '31801', 'B');
INSERT INTO `ey_region` VALUES ('31806', '皇桐镇', '3', '31801', 'H');
INSERT INTO `ey_region` VALUES ('31807', '多文镇', '3', '31801', 'D');
INSERT INTO `ey_region` VALUES ('31808', '和舍镇', '3', '31801', 'H');
INSERT INTO `ey_region` VALUES ('31809', '南宝镇', '3', '31801', 'N');
INSERT INTO `ey_region` VALUES ('31810', '新盈镇', '3', '31801', 'X');
INSERT INTO `ey_region` VALUES ('31811', '调楼镇', '3', '31801', 'D');
INSERT INTO `ey_region` VALUES ('31812', '国营红华农场', '3', '31801', 'G');
INSERT INTO `ey_region` VALUES ('31813', '国营加来农场', '3', '31801', 'G');
INSERT INTO `ey_region` VALUES ('31814', '白沙县', '2', '31563', 'B');
INSERT INTO `ey_region` VALUES ('31815', '牙叉镇', '3', '31814', 'Y');
INSERT INTO `ey_region` VALUES ('31816', '七坊镇', '3', '31814', 'Q');
INSERT INTO `ey_region` VALUES ('31817', '邦溪镇', '3', '31814', 'B');
INSERT INTO `ey_region` VALUES ('31818', '打安镇', '3', '31814', 'D');
INSERT INTO `ey_region` VALUES ('31819', '细水乡', '3', '31814', 'X');
INSERT INTO `ey_region` VALUES ('31820', '元门乡', '3', '31814', 'Y');
INSERT INTO `ey_region` VALUES ('31821', '南开乡', '3', '31814', 'N');
INSERT INTO `ey_region` VALUES ('31822', '阜龙乡', '3', '31814', 'F');
INSERT INTO `ey_region` VALUES ('31823', '青松乡', '3', '31814', 'Q');
INSERT INTO `ey_region` VALUES ('31824', '金波乡', '3', '31814', 'J');
INSERT INTO `ey_region` VALUES ('31825', '荣邦乡', '3', '31814', 'R');
INSERT INTO `ey_region` VALUES ('31826', '国营金波农场', '3', '31814', 'G');
INSERT INTO `ey_region` VALUES ('31827', '国营白沙农场', '3', '31814', 'G');
INSERT INTO `ey_region` VALUES ('31828', '国营牙叉农场', '3', '31814', 'G');
INSERT INTO `ey_region` VALUES ('31829', '国营卫星农场', '3', '31814', 'G');
INSERT INTO `ey_region` VALUES ('31830', '国营龙江农场', '3', '31814', 'G');
INSERT INTO `ey_region` VALUES ('31831', '国营珠碧江农场', '3', '31814', 'G');
INSERT INTO `ey_region` VALUES ('31832', '国营芙蓉田农场', '3', '31814', 'G');
INSERT INTO `ey_region` VALUES ('31833', '国营大岭农场', '3', '31814', 'G');
INSERT INTO `ey_region` VALUES ('31834', '国营邦溪农场', '3', '31814', 'G');
INSERT INTO `ey_region` VALUES ('31835', '昌江县', '2', '31563', 'C');
INSERT INTO `ey_region` VALUES ('31836', '石碌镇', '3', '31835', 'S');
INSERT INTO `ey_region` VALUES ('31837', '叉河镇', '3', '31835', 'C');
INSERT INTO `ey_region` VALUES ('31838', '十月田镇', '3', '31835', 'S');
INSERT INTO `ey_region` VALUES ('31839', '乌烈镇', '3', '31835', 'W');
INSERT INTO `ey_region` VALUES ('31840', '昌化镇', '3', '31835', 'C');
INSERT INTO `ey_region` VALUES ('31841', '海尾镇', '3', '31835', 'H');
INSERT INTO `ey_region` VALUES ('31842', '七叉镇', '3', '31835', 'Q');
INSERT INTO `ey_region` VALUES ('31843', '王下乡', '3', '31835', 'W');
INSERT INTO `ey_region` VALUES ('31844', '国营红田农场', '3', '31835', 'G');
INSERT INTO `ey_region` VALUES ('31845', '国营红林农场', '3', '31835', 'G');
INSERT INTO `ey_region` VALUES ('31846', '国营坝王岭林场', '3', '31835', 'G');
INSERT INTO `ey_region` VALUES ('31847', '海南钢铁公司', '3', '31835', 'H');
INSERT INTO `ey_region` VALUES ('31848', '乐东县', '2', '31563', 'L');
INSERT INTO `ey_region` VALUES ('31849', '抱由镇', '3', '31848', 'B');
INSERT INTO `ey_region` VALUES ('31850', '万冲镇', '3', '31848', 'W');
INSERT INTO `ey_region` VALUES ('31851', '大安镇', '3', '31848', 'D');
INSERT INTO `ey_region` VALUES ('31852', '志仲镇', '3', '31848', 'Z');
INSERT INTO `ey_region` VALUES ('31853', '千家镇', '3', '31848', 'Q');
INSERT INTO `ey_region` VALUES ('31854', '九所镇', '3', '31848', 'J');
INSERT INTO `ey_region` VALUES ('31855', '利国镇', '3', '31848', 'L');
INSERT INTO `ey_region` VALUES ('31856', '黄流镇', '3', '31848', 'H');
INSERT INTO `ey_region` VALUES ('31857', '佛罗镇', '3', '31848', 'F');
INSERT INTO `ey_region` VALUES ('31858', '尖峰镇', '3', '31848', 'J');
INSERT INTO `ey_region` VALUES ('31859', '莺歌海镇', '3', '31848', 'Y');
INSERT INTO `ey_region` VALUES ('31860', '国营乐中农场', '3', '31848', 'G');
INSERT INTO `ey_region` VALUES ('31861', '国营山荣农场', '3', '31848', 'G');
INSERT INTO `ey_region` VALUES ('31862', '国营乐光农场', '3', '31848', 'G');
INSERT INTO `ey_region` VALUES ('31863', '国营报伦农场', '3', '31848', 'G');
INSERT INTO `ey_region` VALUES ('31864', '国营福报农场', '3', '31848', 'G');
INSERT INTO `ey_region` VALUES ('31865', '国营保国农场', '3', '31848', 'G');
INSERT INTO `ey_region` VALUES ('31866', '国营保显农场', '3', '31848', 'G');
INSERT INTO `ey_region` VALUES ('31867', '国营尖峰岭林业公司', '3', '31848', 'G');
INSERT INTO `ey_region` VALUES ('31868', '国营莺歌海盐场', '3', '31848', 'G');
INSERT INTO `ey_region` VALUES ('31869', '陵水县', '2', '31563', 'L');
INSERT INTO `ey_region` VALUES ('31870', '椰林镇', '3', '31869', 'Y');
INSERT INTO `ey_region` VALUES ('31871', '光坡镇', '3', '31869', 'G');
INSERT INTO `ey_region` VALUES ('31872', '三才镇', '3', '31869', 'S');
INSERT INTO `ey_region` VALUES ('31873', '英州镇', '3', '31869', 'Y');
INSERT INTO `ey_region` VALUES ('31874', '隆广镇', '3', '31869', 'L');
INSERT INTO `ey_region` VALUES ('31875', '文罗镇', '3', '31869', 'W');
INSERT INTO `ey_region` VALUES ('31876', '本号镇', '3', '31869', 'B');
INSERT INTO `ey_region` VALUES ('31877', '新村镇', '3', '31869', 'X');
INSERT INTO `ey_region` VALUES ('31878', '黎安镇', '3', '31869', 'L');
INSERT INTO `ey_region` VALUES ('31879', '提蒙乡', '3', '31869', 'T');
INSERT INTO `ey_region` VALUES ('31880', '群英乡', '3', '31869', 'Q');
INSERT INTO `ey_region` VALUES ('31881', '国营岭门农场', '3', '31869', 'G');
INSERT INTO `ey_region` VALUES ('31882', '国营南平农场', '3', '31869', 'G');
INSERT INTO `ey_region` VALUES ('31883', '国营吊罗山林业公司', '3', '31869', 'G');
INSERT INTO `ey_region` VALUES ('31884', '保亭县', '2', '31563', 'B');
INSERT INTO `ey_region` VALUES ('31885', '保城镇', '3', '31884', 'B');
INSERT INTO `ey_region` VALUES ('31886', '什玲镇', '3', '31884', 'S');
INSERT INTO `ey_region` VALUES ('31887', '加茂镇', '3', '31884', 'J');
INSERT INTO `ey_region` VALUES ('31888', '响水镇', '3', '31884', 'X');
INSERT INTO `ey_region` VALUES ('31889', '新政镇', '3', '31884', 'X');
INSERT INTO `ey_region` VALUES ('31890', '三道镇', '3', '31884', 'S');
INSERT INTO `ey_region` VALUES ('31891', '六弓乡', '3', '31884', 'L');
INSERT INTO `ey_region` VALUES ('31892', '南林乡', '3', '31884', 'N');
INSERT INTO `ey_region` VALUES ('31893', '毛感乡', '3', '31884', 'M');
INSERT INTO `ey_region` VALUES ('31894', '国营五指山茶场', '3', '31884', 'G');
INSERT INTO `ey_region` VALUES ('31895', '国营新星农场', '3', '31884', 'G');
INSERT INTO `ey_region` VALUES ('31896', '国营保亭热作所', '3', '31884', 'G');
INSERT INTO `ey_region` VALUES ('31897', '国营金江农场', '3', '31884', 'G');
INSERT INTO `ey_region` VALUES ('31898', '国营南茂农场', '3', '31884', 'G');
INSERT INTO `ey_region` VALUES ('31899', '国营三道农场', '3', '31884', 'G');
INSERT INTO `ey_region` VALUES ('31900', '琼中县', '2', '31563', 'Q');
INSERT INTO `ey_region` VALUES ('31901', '营根镇', '3', '31900', 'Y');
INSERT INTO `ey_region` VALUES ('31902', '湾岭镇', '3', '31900', 'W');
INSERT INTO `ey_region` VALUES ('31903', '黎母山镇', '3', '31900', 'L');
INSERT INTO `ey_region` VALUES ('31904', '和平镇', '3', '31900', 'H');
INSERT INTO `ey_region` VALUES ('31905', '长征镇', '3', '31900', 'C');
INSERT INTO `ey_region` VALUES ('31906', '红毛镇', '3', '31900', 'H');
INSERT INTO `ey_region` VALUES ('31907', '中平镇', '3', '31900', 'Z');
INSERT INTO `ey_region` VALUES ('31908', '吊罗山乡', '3', '31900', 'D');
INSERT INTO `ey_region` VALUES ('31909', '上安乡', '3', '31900', 'S');
INSERT INTO `ey_region` VALUES ('31910', '什运乡', '3', '31900', 'S');
INSERT INTO `ey_region` VALUES ('31911', '国营新进农场', '3', '31900', 'G');
INSERT INTO `ey_region` VALUES ('31912', '国营大丰农场', '3', '31900', 'G');
INSERT INTO `ey_region` VALUES ('31913', '国营阳江农场', '3', '31900', 'G');
INSERT INTO `ey_region` VALUES ('31914', '国营乌石农场', '3', '31900', 'G');
INSERT INTO `ey_region` VALUES ('31915', '国营南方农场', '3', '31900', 'G');
INSERT INTO `ey_region` VALUES ('31916', '国营岭头农场', '3', '31900', 'G');
INSERT INTO `ey_region` VALUES ('31917', '国营加钗农场', '3', '31900', 'G');
INSERT INTO `ey_region` VALUES ('31918', '国营长征农场', '3', '31900', 'G');
INSERT INTO `ey_region` VALUES ('31919', '国营乘坡农场', '3', '31900', 'G');
INSERT INTO `ey_region` VALUES ('31920', '国营太平农场', '3', '31900', 'G');
INSERT INTO `ey_region` VALUES ('31921', '国营新伟农场', '3', '31900', 'G');
INSERT INTO `ey_region` VALUES ('31922', '国营黎母山林业公司', '3', '31900', 'G');
INSERT INTO `ey_region` VALUES ('31923', '西沙群岛', '3', '31924', 'X');
INSERT INTO `ey_region` VALUES ('31924', '三沙市', '2', '31563', 'S');
INSERT INTO `ey_region` VALUES ('31925', '南沙群岛', '3', '31924', 'N');
INSERT INTO `ey_region` VALUES ('47499', '香港岛', '2', '47494', 'X');
INSERT INTO `ey_region` VALUES ('31927', '中沙群岛的岛礁及其海域', '3', '31924', 'Z');
INSERT INTO `ey_region` VALUES ('47498', '九龙', '2', '47494', 'J');
INSERT INTO `ey_region` VALUES ('31929', '重庆市', '1', '0', 'Z');
INSERT INTO `ey_region` VALUES ('31930', '重庆市', '2', '31929', 'C');
INSERT INTO `ey_region` VALUES ('31931', '万州区', '3', '31930', 'W');
INSERT INTO `ey_region` VALUES ('31984', '涪陵区', '3', '31930', 'F');
INSERT INTO `ey_region` VALUES ('32031', '渝中区', '3', '31930', 'Y');
INSERT INTO `ey_region` VALUES ('32044', '大渡口区', '3', '31930', 'D');
INSERT INTO `ey_region` VALUES ('32053', '江北区', '3', '31930', 'J');
INSERT INTO `ey_region` VALUES ('32066', '沙坪坝区', '3', '31930', 'S');
INSERT INTO `ey_region` VALUES ('32093', '九龙坡区', '3', '31930', 'J');
INSERT INTO `ey_region` VALUES ('32112', '南岸区', '3', '31930', 'N');
INSERT INTO `ey_region` VALUES ('32127', '北碚区', '3', '31930', 'B');
INSERT INTO `ey_region` VALUES ('32145', '万盛区', '3', '31930', 'W');
INSERT INTO `ey_region` VALUES ('32156', '双桥区', '3', '31930', 'S');
INSERT INTO `ey_region` VALUES ('32160', '渝北区', '3', '31930', 'Y');
INSERT INTO `ey_region` VALUES ('32191', '巴南区', '3', '31930', 'B');
INSERT INTO `ey_region` VALUES ('32213', '黔江区', '3', '31930', 'Q');
INSERT INTO `ey_region` VALUES ('32244', '长寿区', '3', '31930', 'C');
INSERT INTO `ey_region` VALUES ('32263', '江津区', '3', '31930', 'J');
INSERT INTO `ey_region` VALUES ('32291', '合川区', '3', '31930', 'H');
INSERT INTO `ey_region` VALUES ('32322', '永川区', '3', '31930', 'Y');
INSERT INTO `ey_region` VALUES ('32345', '南川区', '3', '31930', 'N');
INSERT INTO `ey_region` VALUES ('32380', '县', '2', '31929', 'X');
INSERT INTO `ey_region` VALUES ('32381', '綦江县', '3', '32380', 'Q');
INSERT INTO `ey_region` VALUES ('32401', '潼南县', '3', '32380', 'T');
INSERT INTO `ey_region` VALUES ('32424', '铜梁县', '3', '32380', 'T');
INSERT INTO `ey_region` VALUES ('32453', '大足县', '3', '32380', 'D');
INSERT INTO `ey_region` VALUES ('32478', '荣昌县', '3', '32380', 'R');
INSERT INTO `ey_region` VALUES ('32499', '璧山县', '3', '32380', 'B');
INSERT INTO `ey_region` VALUES ('32513', '梁平县', '3', '32380', 'L');
INSERT INTO `ey_region` VALUES ('32549', '城口县', '3', '32380', 'C');
INSERT INTO `ey_region` VALUES ('32574', '丰都县', '3', '32380', 'F');
INSERT INTO `ey_region` VALUES ('32606', '垫江县', '3', '32380', 'D');
INSERT INTO `ey_region` VALUES ('32632', '武隆县', '3', '32380', 'W');
INSERT INTO `ey_region` VALUES ('32659', '忠县', '3', '32380', 'Z');
INSERT INTO `ey_region` VALUES ('32688', '开县', '3', '32380', 'K');
INSERT INTO `ey_region` VALUES ('32727', '云阳县', '3', '32380', 'Y');
INSERT INTO `ey_region` VALUES ('32771', '奉节县', '3', '32380', 'F');
INSERT INTO `ey_region` VALUES ('32802', '巫山县', '3', '32380', 'W');
INSERT INTO `ey_region` VALUES ('32829', '巫溪县', '3', '32380', 'W');
INSERT INTO `ey_region` VALUES ('32861', '石柱县', '3', '32380', 'S');
INSERT INTO `ey_region` VALUES ('32894', '秀山县', '3', '32380', 'X');
INSERT INTO `ey_region` VALUES ('32927', '酉阳县', '3', '32380', 'Y');
INSERT INTO `ey_region` VALUES ('32967', '彭水县', '3', '32380', 'P');
INSERT INTO `ey_region` VALUES ('33007', '四川省', '1', '0', 'S');
INSERT INTO `ey_region` VALUES ('33008', '成都市', '2', '33007', 'C');
INSERT INTO `ey_region` VALUES ('33009', '市辖区', '3', '33008', 'S');
INSERT INTO `ey_region` VALUES ('33010', '锦江区', '3', '33008', 'J');
INSERT INTO `ey_region` VALUES ('33027', '青羊区', '3', '33008', 'Q');
INSERT INTO `ey_region` VALUES ('33042', '金牛区', '3', '33008', 'J');
INSERT INTO `ey_region` VALUES ('33058', '武侯区', '3', '33008', 'W');
INSERT INTO `ey_region` VALUES ('33076', '成华区', '3', '33008', 'C');
INSERT INTO `ey_region` VALUES ('33091', '龙泉驿区', '3', '33008', 'L');
INSERT INTO `ey_region` VALUES ('33104', '青白江区', '3', '33008', 'Q');
INSERT INTO `ey_region` VALUES ('33116', '新都区', '3', '33008', 'X');
INSERT INTO `ey_region` VALUES ('33130', '温江区', '3', '33008', 'W');
INSERT INTO `ey_region` VALUES ('33141', '金堂县', '3', '33008', 'J');
INSERT INTO `ey_region` VALUES ('33163', '双流县', '3', '33008', 'S');
INSERT INTO `ey_region` VALUES ('33189', '郫县', '3', '33008', 'P');
INSERT INTO `ey_region` VALUES ('33205', '大邑县', '3', '33008', 'D');
INSERT INTO `ey_region` VALUES ('33226', '蒲江县', '3', '33008', 'P');
INSERT INTO `ey_region` VALUES ('33239', '新津县', '3', '33008', 'X');
INSERT INTO `ey_region` VALUES ('33252', '都江堰市', '3', '33008', 'D');
INSERT INTO `ey_region` VALUES ('33272', '彭州市', '3', '33008', 'P');
INSERT INTO `ey_region` VALUES ('33293', '邛崃市', '3', '33008', 'Q');
INSERT INTO `ey_region` VALUES ('33318', '崇州市', '3', '33008', 'C');
INSERT INTO `ey_region` VALUES ('33344', '自贡市', '2', '33007', 'Z');
INSERT INTO `ey_region` VALUES ('33345', '市辖区', '3', '33344', 'S');
INSERT INTO `ey_region` VALUES ('33346', '自流井区', '3', '33344', 'Z');
INSERT INTO `ey_region` VALUES ('33360', '贡井区', '3', '33344', 'G');
INSERT INTO `ey_region` VALUES ('33374', '大安区', '3', '33344', 'D');
INSERT INTO `ey_region` VALUES ('33391', '沿滩区', '3', '33344', 'Y');
INSERT INTO `ey_region` VALUES ('33405', '荣县', '3', '33344', 'R');
INSERT INTO `ey_region` VALUES ('33433', '富顺县', '3', '33344', 'F');
INSERT INTO `ey_region` VALUES ('33460', '攀枝花市', '2', '33007', 'P');
INSERT INTO `ey_region` VALUES ('33461', '市辖区', '3', '33460', 'S');
INSERT INTO `ey_region` VALUES ('33462', '攀枝花东区', '3', '33460', 'P');
INSERT INTO `ey_region` VALUES ('33473', '西区', '3', '33460', 'X');
INSERT INTO `ey_region` VALUES ('33481', '仁和区', '3', '33460', 'R');
INSERT INTO `ey_region` VALUES ('33497', '米易县', '3', '33460', 'M');
INSERT INTO `ey_region` VALUES ('33511', '盐边县', '3', '33460', 'Y');
INSERT INTO `ey_region` VALUES ('33528', '泸州市', '2', '33007', 'L');
INSERT INTO `ey_region` VALUES ('33529', '市辖区', '3', '33528', 'S');
INSERT INTO `ey_region` VALUES ('33530', '江阳区', '3', '33528', 'J');
INSERT INTO `ey_region` VALUES ('33548', '纳溪区', '3', '33528', 'N');
INSERT INTO `ey_region` VALUES ('33563', '龙马潭区', '3', '33528', 'L');
INSERT INTO `ey_region` VALUES ('33577', '泸县', '3', '33528', 'L');
INSERT INTO `ey_region` VALUES ('33597', '合江县', '3', '33528', 'H');
INSERT INTO `ey_region` VALUES ('33625', '叙永县', '3', '33528', 'X');
INSERT INTO `ey_region` VALUES ('33654', '古蔺县', '3', '33528', 'G');
INSERT INTO `ey_region` VALUES ('33681', '德阳市', '2', '33007', 'D');
INSERT INTO `ey_region` VALUES ('33682', '市辖区', '3', '33681', 'S');
INSERT INTO `ey_region` VALUES ('33683', '旌阳区', '3', '33681', 'J');
INSERT INTO `ey_region` VALUES ('33701', '中江县', '3', '33681', 'Z');
INSERT INTO `ey_region` VALUES ('33747', '罗江县', '3', '33681', 'L');
INSERT INTO `ey_region` VALUES ('33758', '广汉市', '3', '33681', 'G');
INSERT INTO `ey_region` VALUES ('33778', '什邡市', '3', '33681', 'S');
INSERT INTO `ey_region` VALUES ('33795', '绵竹市', '3', '33681', 'M');
INSERT INTO `ey_region` VALUES ('33817', '绵阳市', '2', '33007', 'M');
INSERT INTO `ey_region` VALUES ('33818', '市辖区', '3', '33817', 'S');
INSERT INTO `ey_region` VALUES ('33819', '涪城区', '3', '33817', 'F');
INSERT INTO `ey_region` VALUES ('33844', '游仙区', '3', '33817', 'Y');
INSERT INTO `ey_region` VALUES ('33873', '三台县', '3', '33817', 'S');
INSERT INTO `ey_region` VALUES ('33937', '盐亭县', '3', '33817', 'Y');
INSERT INTO `ey_region` VALUES ('33974', '安县', '3', '33817', 'A');
INSERT INTO `ey_region` VALUES ('33995', '梓潼县', '3', '33817', 'Z');
INSERT INTO `ey_region` VALUES ('34028', '北川县', '3', '33817', 'B');
INSERT INTO `ey_region` VALUES ('34049', '平武县', '3', '33817', 'P');
INSERT INTO `ey_region` VALUES ('34075', '江油市', '3', '33817', 'J');
INSERT INTO `ey_region` VALUES ('34120', '广元市', '2', '33007', 'G');
INSERT INTO `ey_region` VALUES ('34121', '市辖区', '3', '34120', 'S');
INSERT INTO `ey_region` VALUES ('34122', '市中区', '3', '34120', 'S');
INSERT INTO `ey_region` VALUES ('34143', '元坝区', '3', '34120', 'Y');
INSERT INTO `ey_region` VALUES ('34173', '朝天区', '3', '34120', 'C');
INSERT INTO `ey_region` VALUES ('34199', '旺苍县', '3', '34120', 'W');
INSERT INTO `ey_region` VALUES ('34238', '青川县', '3', '34120', 'Q');
INSERT INTO `ey_region` VALUES ('34276', '剑阁县', '3', '34120', 'J');
INSERT INTO `ey_region` VALUES ('34334', '苍溪县', '3', '34120', 'C');
INSERT INTO `ey_region` VALUES ('34376', '遂宁市', '2', '33007', 'S');
INSERT INTO `ey_region` VALUES ('34377', '市辖区', '3', '34376', 'S');
INSERT INTO `ey_region` VALUES ('34378', '船山区', '3', '34376', 'C');
INSERT INTO `ey_region` VALUES ('34404', '安居区', '3', '34376', 'A');
INSERT INTO `ey_region` VALUES ('34426', '蓬溪县', '3', '34376', 'P');
INSERT INTO `ey_region` VALUES ('34458', '射洪县', '3', '34376', 'S');
INSERT INTO `ey_region` VALUES ('34489', '大英县', '3', '34376', 'D');
INSERT INTO `ey_region` VALUES ('34501', '内江市', '2', '33007', 'N');
INSERT INTO `ey_region` VALUES ('34502', '市辖区', '3', '34501', 'S');
INSERT INTO `ey_region` VALUES ('34503', '市中区', '3', '34501', 'S');
INSERT INTO `ey_region` VALUES ('34524', '东兴区', '3', '34501', 'D');
INSERT INTO `ey_region` VALUES ('34554', '威远县', '3', '34501', 'W');
INSERT INTO `ey_region` VALUES ('34575', '资中县', '3', '34501', 'Z');
INSERT INTO `ey_region` VALUES ('34609', '隆昌县', '3', '34501', 'L');
INSERT INTO `ey_region` VALUES ('34628', '乐山市', '2', '33007', 'L');
INSERT INTO `ey_region` VALUES ('34629', '市辖区', '3', '34628', 'S');
INSERT INTO `ey_region` VALUES ('34630', '市中区', '3', '34628', 'S');
INSERT INTO `ey_region` VALUES ('34661', '沙湾区', '3', '34628', 'S');
INSERT INTO `ey_region` VALUES ('34676', '五通桥区', '3', '34628', 'W');
INSERT INTO `ey_region` VALUES ('34689', '金口河区', '3', '34628', 'J');
INSERT INTO `ey_region` VALUES ('34696', '犍为县', '3', '34628', 'Q');
INSERT INTO `ey_region` VALUES ('34727', '井研县', '3', '34628', 'J');
INSERT INTO `ey_region` VALUES ('34755', '夹江县', '3', '34628', 'J');
INSERT INTO `ey_region` VALUES ('34778', '沐川县', '3', '34628', 'M');
INSERT INTO `ey_region` VALUES ('34799', '峨边县', '3', '34628', 'E');
INSERT INTO `ey_region` VALUES ('34819', '马边县', '3', '34628', 'M');
INSERT INTO `ey_region` VALUES ('34840', '峨眉山市', '3', '34628', 'E');
INSERT INTO `ey_region` VALUES ('34859', '南充市', '2', '33007', 'N');
INSERT INTO `ey_region` VALUES ('34860', '市辖区', '3', '34859', 'S');
INSERT INTO `ey_region` VALUES ('34861', '顺庆区', '3', '34859', 'S');
INSERT INTO `ey_region` VALUES ('34890', '高坪区', '3', '34859', 'G');
INSERT INTO `ey_region` VALUES ('34923', '嘉陵区', '3', '34859', 'J');
INSERT INTO `ey_region` VALUES ('34967', '南部县', '3', '34859', 'N');
INSERT INTO `ey_region` VALUES ('35040', '营山县', '3', '34859', 'Y');
INSERT INTO `ey_region` VALUES ('35094', '蓬安县', '3', '34859', 'P');
INSERT INTO `ey_region` VALUES ('35134', '仪陇县', '3', '34859', 'Y');
INSERT INTO `ey_region` VALUES ('35193', '西充县', '3', '34859', 'X');
INSERT INTO `ey_region` VALUES ('35238', '阆中市', '3', '34859', 'L');
INSERT INTO `ey_region` VALUES ('35288', '眉山市', '2', '33007', 'M');
INSERT INTO `ey_region` VALUES ('35289', '市辖区', '3', '35288', 'S');
INSERT INTO `ey_region` VALUES ('35290', '东坡区', '3', '35288', 'D');
INSERT INTO `ey_region` VALUES ('35317', '仁寿县', '3', '35288', 'R');
INSERT INTO `ey_region` VALUES ('35378', '彭山县', '3', '35288', 'P');
INSERT INTO `ey_region` VALUES ('35392', '洪雅县', '3', '35288', 'H');
INSERT INTO `ey_region` VALUES ('35408', '丹棱县', '3', '35288', 'D');
INSERT INTO `ey_region` VALUES ('35416', '青神县', '3', '35288', 'Q');
INSERT INTO `ey_region` VALUES ('35427', '宜宾市', '2', '33007', 'Y');
INSERT INTO `ey_region` VALUES ('35428', '市辖区', '3', '35427', 'S');
INSERT INTO `ey_region` VALUES ('35429', '翠屏区', '3', '35427', 'C');
INSERT INTO `ey_region` VALUES ('35454', '宜宾县', '3', '35427', 'Y');
INSERT INTO `ey_region` VALUES ('35481', '南溪县', '3', '35427', 'N');
INSERT INTO `ey_region` VALUES ('35497', '江安县', '3', '35427', 'J');
INSERT INTO `ey_region` VALUES ('35516', '长宁县', '3', '35427', 'C');
INSERT INTO `ey_region` VALUES ('35535', '高县', '3', '35427', 'G');
INSERT INTO `ey_region` VALUES ('35555', '珙县', '3', '35427', 'G');
INSERT INTO `ey_region` VALUES ('35573', '筠连县', '3', '35427', 'J');
INSERT INTO `ey_region` VALUES ('35592', '兴文县', '3', '35427', 'X');
INSERT INTO `ey_region` VALUES ('35608', '屏山县', '3', '35427', 'P');
INSERT INTO `ey_region` VALUES ('35625', '广安市', '2', '33007', 'G');
INSERT INTO `ey_region` VALUES ('35626', '市辖区', '3', '35625', 'S');
INSERT INTO `ey_region` VALUES ('35627', '广安区', '3', '35625', 'G');
INSERT INTO `ey_region` VALUES ('35677', '岳池县', '3', '35625', 'Y');
INSERT INTO `ey_region` VALUES ('35721', '武胜县', '3', '35625', 'W');
INSERT INTO `ey_region` VALUES ('35753', '邻水县', '3', '35625', 'L');
INSERT INTO `ey_region` VALUES ('35799', '华蓥市', '3', '35625', 'H');
INSERT INTO `ey_region` VALUES ('35813', '达州市', '2', '33007', 'D');
INSERT INTO `ey_region` VALUES ('35814', '市辖区', '3', '35813', 'S');
INSERT INTO `ey_region` VALUES ('35815', '通川区', '3', '35813', 'T');
INSERT INTO `ey_region` VALUES ('35829', '达县', '3', '35813', 'D');
INSERT INTO `ey_region` VALUES ('35894', '宣汉县', '3', '35813', 'X');
INSERT INTO `ey_region` VALUES ('35949', '开江县', '3', '35813', 'K');
INSERT INTO `ey_region` VALUES ('35970', '大竹县', '3', '35813', 'D');
INSERT INTO `ey_region` VALUES ('36021', '渠县', '3', '35813', 'Q');
INSERT INTO `ey_region` VALUES ('36082', '万源市', '3', '35813', 'W');
INSERT INTO `ey_region` VALUES ('36136', '雅安市', '2', '33007', 'Y');
INSERT INTO `ey_region` VALUES ('36137', '市辖区', '3', '36136', 'S');
INSERT INTO `ey_region` VALUES ('36138', '雨城区', '3', '36136', 'Y');
INSERT INTO `ey_region` VALUES ('36161', '名山县', '3', '36136', 'M');
INSERT INTO `ey_region` VALUES ('36182', '荥经县', '3', '36136', 'Y');
INSERT INTO `ey_region` VALUES ('36204', '汉源县', '3', '36136', 'H');
INSERT INTO `ey_region` VALUES ('36245', '石棉县', '3', '36136', 'S');
INSERT INTO `ey_region` VALUES ('36263', '天全县', '3', '36136', 'T');
INSERT INTO `ey_region` VALUES ('36279', '芦山县', '3', '36136', 'L');
INSERT INTO `ey_region` VALUES ('36289', '宝兴县', '3', '36136', 'B');
INSERT INTO `ey_region` VALUES ('36299', '巴中市', '2', '33007', 'B');
INSERT INTO `ey_region` VALUES ('36300', '市辖区', '3', '36299', 'S');
INSERT INTO `ey_region` VALUES ('36301', '巴州区', '3', '36299', 'B');
INSERT INTO `ey_region` VALUES ('36354', '通江县', '3', '36299', 'T');
INSERT INTO `ey_region` VALUES ('36404', '南江县', '3', '36299', 'N');
INSERT INTO `ey_region` VALUES ('36453', '平昌县', '3', '36299', 'P');
INSERT INTO `ey_region` VALUES ('36497', '资阳市', '2', '33007', 'Z');
INSERT INTO `ey_region` VALUES ('36498', '市辖区', '3', '36497', 'S');
INSERT INTO `ey_region` VALUES ('36499', '雁江区', '3', '36497', 'Y');
INSERT INTO `ey_region` VALUES ('36527', '安岳县', '3', '36497', 'A');
INSERT INTO `ey_region` VALUES ('36597', '乐至县', '3', '36497', 'L');
INSERT INTO `ey_region` VALUES ('36623', '简阳市', '3', '36497', 'J');
INSERT INTO `ey_region` VALUES ('36679', '阿坝州', '2', '33007', 'A');
INSERT INTO `ey_region` VALUES ('36680', '汶川县', '3', '36679', 'W');
INSERT INTO `ey_region` VALUES ('36694', '理县', '3', '36679', 'L');
INSERT INTO `ey_region` VALUES ('36708', '茂县', '3', '36679', 'M');
INSERT INTO `ey_region` VALUES ('36731', '松潘县', '3', '36679', 'S');
INSERT INTO `ey_region` VALUES ('36759', '九寨沟县', '3', '36679', 'J');
INSERT INTO `ey_region` VALUES ('36778', '金川县', '3', '36679', 'J');
INSERT INTO `ey_region` VALUES ('36802', '小金县', '3', '36679', 'X');
INSERT INTO `ey_region` VALUES ('36824', '黑水县', '3', '36679', 'H');
INSERT INTO `ey_region` VALUES ('36842', '马尔康县', '3', '36679', 'M');
INSERT INTO `ey_region` VALUES ('36858', '壤塘县', '3', '36679', 'R');
INSERT INTO `ey_region` VALUES ('36871', '阿坝县', '3', '36679', 'A');
INSERT INTO `ey_region` VALUES ('36893', '若尔盖县', '3', '36679', 'R');
INSERT INTO `ey_region` VALUES ('36914', '红原县', '3', '36679', 'H');
INSERT INTO `ey_region` VALUES ('36926', '甘孜州', '2', '33007', 'G');
INSERT INTO `ey_region` VALUES ('36927', '康定县', '3', '36926', 'K');
INSERT INTO `ey_region` VALUES ('36949', '泸定县', '3', '36926', 'L');
INSERT INTO `ey_region` VALUES ('36962', '丹巴县', '3', '36926', 'D');
INSERT INTO `ey_region` VALUES ('36978', '九龙县', '3', '36926', 'J');
INSERT INTO `ey_region` VALUES ('36997', '雅江县', '3', '36926', 'Y');
INSERT INTO `ey_region` VALUES ('37015', '道孚县', '3', '36926', 'D');
INSERT INTO `ey_region` VALUES ('37038', '炉霍县', '3', '36926', 'L');
INSERT INTO `ey_region` VALUES ('37055', '甘孜县', '3', '36926', 'G');
INSERT INTO `ey_region` VALUES ('37078', '新龙县', '3', '36926', 'X');
INSERT INTO `ey_region` VALUES ('37098', '德格县', '3', '36926', 'D');
INSERT INTO `ey_region` VALUES ('37125', '白玉县', '3', '36926', 'B');
INSERT INTO `ey_region` VALUES ('37143', '石渠县', '3', '36926', 'S');
INSERT INTO `ey_region` VALUES ('37166', '色达县', '3', '36926', 'S');
INSERT INTO `ey_region` VALUES ('37184', '理塘县', '3', '36926', 'L');
INSERT INTO `ey_region` VALUES ('37209', '巴塘县', '3', '36926', 'B');
INSERT INTO `ey_region` VALUES ('37229', '乡城县', '3', '36926', 'X');
INSERT INTO `ey_region` VALUES ('37242', '稻城县', '3', '36926', 'D');
INSERT INTO `ey_region` VALUES ('37257', '得荣县', '3', '36926', 'D');
INSERT INTO `ey_region` VALUES ('37270', '凉山州', '2', '33007', 'L');
INSERT INTO `ey_region` VALUES ('37271', '西昌市', '3', '37270', 'X');
INSERT INTO `ey_region` VALUES ('37315', '木里县', '3', '37270', 'M');
INSERT INTO `ey_region` VALUES ('37345', '盐源县', '3', '37270', 'Y');
INSERT INTO `ey_region` VALUES ('37380', '德昌', '3', '37270', 'D');
INSERT INTO `ey_region` VALUES ('37404', '会理县', '3', '37270', 'H');
INSERT INTO `ey_region` VALUES ('37455', '会东县', '3', '37270', 'H');
INSERT INTO `ey_region` VALUES ('37509', '宁南县', '3', '37270', 'N');
INSERT INTO `ey_region` VALUES ('37535', '普格县', '3', '37270', 'P');
INSERT INTO `ey_region` VALUES ('37570', '布拖县', '3', '37270', 'B');
INSERT INTO `ey_region` VALUES ('37601', '金阳县', '3', '37270', 'J');
INSERT INTO `ey_region` VALUES ('37636', '昭觉县', '3', '37270', 'Z');
INSERT INTO `ey_region` VALUES ('37684', '喜德县', '3', '37270', 'X');
INSERT INTO `ey_region` VALUES ('37709', '冕宁县', '3', '37270', 'M');
INSERT INTO `ey_region` VALUES ('37748', '越西县', '3', '37270', 'Y');
INSERT INTO `ey_region` VALUES ('37790', '甘洛县', '3', '37270', 'G');
INSERT INTO `ey_region` VALUES ('37819', '美姑县', '3', '37270', 'M');
INSERT INTO `ey_region` VALUES ('37856', '雷波县', '3', '37270', 'L');
INSERT INTO `ey_region` VALUES ('37906', '贵州省', '1', '0', 'G');
INSERT INTO `ey_region` VALUES ('37907', '贵阳市', '2', '37906', 'G');
INSERT INTO `ey_region` VALUES ('37908', '市辖区', '3', '37907', 'S');
INSERT INTO `ey_region` VALUES ('37909', '南明区', '3', '37907', 'N');
INSERT INTO `ey_region` VALUES ('37927', '云岩区', '3', '37907', 'Y');
INSERT INTO `ey_region` VALUES ('37944', '花溪区', '3', '37907', 'H');
INSERT INTO `ey_region` VALUES ('37961', '乌当区', '3', '37907', 'W');
INSERT INTO `ey_region` VALUES ('37977', '白云区', '3', '37907', 'B');
INSERT INTO `ey_region` VALUES ('37987', '小河区', '3', '37907', 'X');
INSERT INTO `ey_region` VALUES ('37991', '开阳县', '3', '37907', 'K');
INSERT INTO `ey_region` VALUES ('38008', '息烽县', '3', '37907', 'X');
INSERT INTO `ey_region` VALUES ('38019', '修文县', '3', '37907', 'X');
INSERT INTO `ey_region` VALUES ('38030', '清镇市', '3', '37907', 'Q');
INSERT INTO `ey_region` VALUES ('38042', '六盘水市', '2', '37906', 'L');
INSERT INTO `ey_region` VALUES ('38043', '钟山区', '3', '38042', 'Z');
INSERT INTO `ey_region` VALUES ('38053', '六枝特区', '3', '38042', 'L');
INSERT INTO `ey_region` VALUES ('38073', '水城县', '3', '38042', 'S');
INSERT INTO `ey_region` VALUES ('38107', '盘县', '3', '38042', 'P');
INSERT INTO `ey_region` VALUES ('38145', '遵义市', '2', '37906', 'Z');
INSERT INTO `ey_region` VALUES ('38146', '市辖区', '3', '38145', 'S');
INSERT INTO `ey_region` VALUES ('38147', '红花岗区', '3', '38145', 'H');
INSERT INTO `ey_region` VALUES ('38164', '汇川区', '3', '38145', 'H');
INSERT INTO `ey_region` VALUES ('38174', '遵义县', '3', '38145', 'Z');
INSERT INTO `ey_region` VALUES ('38206', '桐梓县', '3', '38145', 'T');
INSERT INTO `ey_region` VALUES ('38231', '绥阳县', '3', '38145', 'S');
INSERT INTO `ey_region` VALUES ('38247', '正安县', '3', '38145', 'Z');
INSERT INTO `ey_region` VALUES ('38267', '道真县', '3', '38145', 'D');
INSERT INTO `ey_region` VALUES ('38282', '务川县', '3', '38145', 'W');
INSERT INTO `ey_region` VALUES ('38298', '凤冈县', '3', '38145', 'F');
INSERT INTO `ey_region` VALUES ('38313', '湄潭县', '3', '38145', 'M');
INSERT INTO `ey_region` VALUES ('38329', '余庆县', '3', '38145', 'Y');
INSERT INTO `ey_region` VALUES ('38340', '习水县', '3', '38145', 'X');
INSERT INTO `ey_region` VALUES ('38364', '赤水市', '3', '38145', 'C');
INSERT INTO `ey_region` VALUES ('38382', '仁怀市', '3', '38145', 'R');
INSERT INTO `ey_region` VALUES ('38402', '安顺市', '2', '37906', 'A');
INSERT INTO `ey_region` VALUES ('38403', '市辖区', '3', '38402', 'S');
INSERT INTO `ey_region` VALUES ('38404', '西秀区', '3', '38402', 'X');
INSERT INTO `ey_region` VALUES ('38429', '平坝县', '3', '38402', 'P');
INSERT INTO `ey_region` VALUES ('38440', '普定县', '3', '38402', 'P');
INSERT INTO `ey_region` VALUES ('38452', '镇宁县', '3', '38402', 'Z');
INSERT INTO `ey_region` VALUES ('38469', '关岭县', '3', '38402', 'G');
INSERT INTO `ey_region` VALUES ('38484', '紫云县', '3', '38402', 'Z');
INSERT INTO `ey_region` VALUES ('38497', '铜仁地区', '2', '37906', 'T');
INSERT INTO `ey_region` VALUES ('38498', '铜仁市', '3', '38497', 'T');
INSERT INTO `ey_region` VALUES ('38516', '江口县', '3', '38497', 'J');
INSERT INTO `ey_region` VALUES ('38526', '玉屏县', '3', '38497', 'Y');
INSERT INTO `ey_region` VALUES ('38533', '石阡县', '3', '38497', 'S');
INSERT INTO `ey_region` VALUES ('38552', '思南县　', '3', '38497', 'S');
INSERT INTO `ey_region` VALUES ('38580', '印江县', '3', '38497', 'Y');
INSERT INTO `ey_region` VALUES ('38598', '德江县', '3', '38497', 'D');
INSERT INTO `ey_region` VALUES ('38619', '沿河县', '3', '38497', 'Y');
INSERT INTO `ey_region` VALUES ('38642', '松桃县', '3', '38497', 'S');
INSERT INTO `ey_region` VALUES ('38671', '万山特区', '3', '38497', 'W');
INSERT INTO `ey_region` VALUES ('38677', '黔西南州', '2', '37906', 'Q');
INSERT INTO `ey_region` VALUES ('38678', '兴义市', '3', '38677', 'X');
INSERT INTO `ey_region` VALUES ('38705', '兴仁县', '3', '38677', 'X');
INSERT INTO `ey_region` VALUES ('38722', '普安县', '3', '38677', 'P');
INSERT INTO `ey_region` VALUES ('38737', '晴隆县', '3', '38677', 'Q');
INSERT INTO `ey_region` VALUES ('38752', '贞丰县', '3', '38677', 'Z');
INSERT INTO `ey_region` VALUES ('38766', '望谟县', '3', '38677', 'W');
INSERT INTO `ey_region` VALUES ('38784', '册亨县', '3', '38677', 'C');
INSERT INTO `ey_region` VALUES ('38799', '安龙县', '3', '38677', 'A');
INSERT INTO `ey_region` VALUES ('38816', '毕节地区', '2', '37906', 'B');
INSERT INTO `ey_region` VALUES ('38817', '毕节市', '3', '38816', 'B');
INSERT INTO `ey_region` VALUES ('38859', '大方县', '3', '38816', 'D');
INSERT INTO `ey_region` VALUES ('38896', '黔西县', '3', '38816', 'Q');
INSERT INTO `ey_region` VALUES ('38925', '金沙县', '3', '38816', 'J');
INSERT INTO `ey_region` VALUES ('38952', '织金县', '3', '38816', 'Z');
INSERT INTO `ey_region` VALUES ('38985', '纳雍县', '3', '38816', 'N');
INSERT INTO `ey_region` VALUES ('39011', '威宁县', '3', '38816', 'W');
INSERT INTO `ey_region` VALUES ('39047', '赫章县', '3', '38816', 'H');
INSERT INTO `ey_region` VALUES ('39075', '黔东南州', '2', '37906', 'Q');
INSERT INTO `ey_region` VALUES ('39076', '凯里市', '3', '39075', 'K');
INSERT INTO `ey_region` VALUES ('39092', '黄平县', '3', '39075', 'H');
INSERT INTO `ey_region` VALUES ('39107', '施秉县', '3', '39075', 'S');
INSERT INTO `ey_region` VALUES ('39116', '三穗县', '3', '39075', 'S');
INSERT INTO `ey_region` VALUES ('39126', '镇远县', '3', '39075', 'Z');
INSERT INTO `ey_region` VALUES ('39139', '岑巩县', '3', '39075', 'C');
INSERT INTO `ey_region` VALUES ('39151', '天柱县', '3', '39075', 'T');
INSERT INTO `ey_region` VALUES ('39168', '锦屏县', '3', '39075', 'J');
INSERT INTO `ey_region` VALUES ('39184', '剑河县', '3', '39075', 'J');
INSERT INTO `ey_region` VALUES ('39197', '台江县', '3', '39075', 'T');
INSERT INTO `ey_region` VALUES ('39206', '黎平县', '3', '39075', 'L');
INSERT INTO `ey_region` VALUES ('39232', '榕江县', '3', '39075', 'R');
INSERT INTO `ey_region` VALUES ('39252', '从江县', '3', '39075', 'C');
INSERT INTO `ey_region` VALUES ('39274', '雷山县', '3', '39075', 'L');
INSERT INTO `ey_region` VALUES ('39284', '麻江县', '3', '39075', 'M');
INSERT INTO `ey_region` VALUES ('39294', '丹寨县', '3', '39075', 'D');
INSERT INTO `ey_region` VALUES ('39302', '黔南州', '2', '37906', 'Q');
INSERT INTO `ey_region` VALUES ('39303', '都匀市', '3', '39302', 'D');
INSERT INTO `ey_region` VALUES ('39327', '福泉市', '3', '39302', 'F');
INSERT INTO `ey_region` VALUES ('39345', '荔波县', '3', '39302', 'L');
INSERT INTO `ey_region` VALUES ('39363', '贵定县', '3', '39302', 'G');
INSERT INTO `ey_region` VALUES ('39384', '瓮安县', '3', '39302', 'W');
INSERT INTO `ey_region` VALUES ('39408', '独山县', '3', '39302', 'D');
INSERT INTO `ey_region` VALUES ('39427', '平塘县', '3', '39302', 'P');
INSERT INTO `ey_region` VALUES ('39447', '罗甸县', '3', '39302', 'L');
INSERT INTO `ey_region` VALUES ('39474', '长顺县', '3', '39302', 'C');
INSERT INTO `ey_region` VALUES ('39493', '龙里县', '3', '39302', 'L');
INSERT INTO `ey_region` VALUES ('39508', '惠水县', '3', '39302', 'H');
INSERT INTO `ey_region` VALUES ('39534', '三都县', '3', '39302', 'S');
INSERT INTO `ey_region` VALUES ('39556', '云南省', '1', '0', 'Y');
INSERT INTO `ey_region` VALUES ('39557', '昆明市', '2', '39556', 'K');
INSERT INTO `ey_region` VALUES ('39558', '市辖区', '3', '39557', 'S');
INSERT INTO `ey_region` VALUES ('39559', '五华区', '3', '39557', 'W');
INSERT INTO `ey_region` VALUES ('39571', '盘龙区', '3', '39557', 'P');
INSERT INTO `ey_region` VALUES ('39582', '官渡区', '3', '39557', 'G');
INSERT INTO `ey_region` VALUES ('39594', '西山区', '3', '39557', 'X');
INSERT INTO `ey_region` VALUES ('39605', '东川区', '3', '39557', 'D');
INSERT INTO `ey_region` VALUES ('39614', '呈贡县', '3', '39557', 'C');
INSERT INTO `ey_region` VALUES ('39622', '晋宁县', '3', '39557', 'J');
INSERT INTO `ey_region` VALUES ('39632', '富民县', '3', '39557', 'F');
INSERT INTO `ey_region` VALUES ('39640', '宜良县', '3', '39557', 'Y');
INSERT INTO `ey_region` VALUES ('39650', '石林县', '3', '39557', 'S');
INSERT INTO `ey_region` VALUES ('39659', '嵩明县', '3', '39557', 'S');
INSERT INTO `ey_region` VALUES ('39667', '禄劝县', '3', '39557', 'L');
INSERT INTO `ey_region` VALUES ('39684', '寻甸县', '3', '39557', 'X');
INSERT INTO `ey_region` VALUES ('39701', '安宁市', '3', '39557', 'A');
INSERT INTO `ey_region` VALUES ('39710', '曲靖市', '2', '39556', 'Q');
INSERT INTO `ey_region` VALUES ('39711', '市辖区', '3', '39710', 'S');
INSERT INTO `ey_region` VALUES ('39712', '麒麟区', '3', '39710', 'Q');
INSERT INTO `ey_region` VALUES ('39724', '马龙县', '3', '39710', 'M');
INSERT INTO `ey_region` VALUES ('39733', '陆良县', '3', '39710', 'L');
INSERT INTO `ey_region` VALUES ('39744', '师宗县', '3', '39710', 'S');
INSERT INTO `ey_region` VALUES ('39753', '罗平县', '3', '39710', 'L');
INSERT INTO `ey_region` VALUES ('39766', '富源县', '3', '39710', 'F');
INSERT INTO `ey_region` VALUES ('39778', '会泽县', '3', '39710', 'H');
INSERT INTO `ey_region` VALUES ('39800', '沾益县', '3', '39710', 'Z');
INSERT INTO `ey_region` VALUES ('39809', '宣威市', '3', '39710', 'X');
INSERT INTO `ey_region` VALUES ('39836', '玉溪市', '2', '39556', 'Y');
INSERT INTO `ey_region` VALUES ('39837', '市辖区', '3', '39836', 'S');
INSERT INTO `ey_region` VALUES ('39838', '红塔区', '3', '39836', 'H');
INSERT INTO `ey_region` VALUES ('39850', '江川县', '3', '39836', 'J');
INSERT INTO `ey_region` VALUES ('39858', '澄江县', '3', '39836', 'C');
INSERT INTO `ey_region` VALUES ('39865', '通海县', '3', '39836', 'T');
INSERT INTO `ey_region` VALUES ('39875', '华宁县', '3', '39836', 'H');
INSERT INTO `ey_region` VALUES ('39881', '易门县', '3', '39836', 'Y');
INSERT INTO `ey_region` VALUES ('39889', '峨山县', '3', '39836', 'E');
INSERT INTO `ey_region` VALUES ('39899', '新平县', '3', '39836', 'X');
INSERT INTO `ey_region` VALUES ('39912', '元江县', '3', '39836', 'Y');
INSERT INTO `ey_region` VALUES ('39923', '保山市', '2', '39556', 'B');
INSERT INTO `ey_region` VALUES ('39924', '市辖区', '3', '39923', 'S');
INSERT INTO `ey_region` VALUES ('39925', '隆阳区', '3', '39923', 'L');
INSERT INTO `ey_region` VALUES ('39946', '施甸县', '3', '39923', 'S');
INSERT INTO `ey_region` VALUES ('39960', '腾冲县', '3', '39923', 'T');
INSERT INTO `ey_region` VALUES ('39979', '龙陵县', '3', '39923', 'L');
INSERT INTO `ey_region` VALUES ('39990', '昌宁县', '3', '39923', 'C');
INSERT INTO `ey_region` VALUES ('40004', '昭通市', '2', '39556', 'Z');
INSERT INTO `ey_region` VALUES ('40005', '市辖区', '3', '40004', 'S');
INSERT INTO `ey_region` VALUES ('40006', '昭阳区', '3', '40004', 'Z');
INSERT INTO `ey_region` VALUES ('40027', '鲁甸县', '3', '40004', 'L');
INSERT INTO `ey_region` VALUES ('40040', '巧家县', '3', '40004', 'Q');
INSERT INTO `ey_region` VALUES ('40057', '盐津县', '3', '40004', 'Y');
INSERT INTO `ey_region` VALUES ('40068', '大关县', '3', '40004', 'D');
INSERT INTO `ey_region` VALUES ('40078', '永善县', '3', '40004', 'Y');
INSERT INTO `ey_region` VALUES ('40094', '绥江县', '3', '40004', 'S');
INSERT INTO `ey_region` VALUES ('40100', '镇雄县', '3', '40004', 'Z');
INSERT INTO `ey_region` VALUES ('40129', '彝良县', '3', '40004', 'Y');
INSERT INTO `ey_region` VALUES ('40145', '威信县', '3', '40004', 'W');
INSERT INTO `ey_region` VALUES ('40156', '水富县', '3', '40004', 'S');
INSERT INTO `ey_region` VALUES ('40160', '丽江市', '2', '39556', 'L');
INSERT INTO `ey_region` VALUES ('40161', '市辖区', '3', '40160', 'S');
INSERT INTO `ey_region` VALUES ('40162', '古城区', '3', '40160', 'G');
INSERT INTO `ey_region` VALUES ('40172', '玉龙县', '3', '40160', 'Y');
INSERT INTO `ey_region` VALUES ('40189', '永胜县', '3', '40160', 'Y');
INSERT INTO `ey_region` VALUES ('40205', '华坪县', '3', '40160', 'H');
INSERT INTO `ey_region` VALUES ('40214', '宁蒗县', '3', '40160', 'N');
INSERT INTO `ey_region` VALUES ('40230', '思茅市', '2', '39556', 'S');
INSERT INTO `ey_region` VALUES ('40231', '市辖区', '3', '40230', 'S');
INSERT INTO `ey_region` VALUES ('40232', '翠云区', '3', '40230', 'C');
INSERT INTO `ey_region` VALUES ('40240', '普洱县', '3', '40230', 'P');
INSERT INTO `ey_region` VALUES ('40250', '墨江县', '3', '40230', 'M');
INSERT INTO `ey_region` VALUES ('40266', '景东县', '3', '40230', 'J');
INSERT INTO `ey_region` VALUES ('40280', '景谷县', '3', '40230', 'J');
INSERT INTO `ey_region` VALUES ('40291', '镇沅县', '3', '40230', 'Z');
INSERT INTO `ey_region` VALUES ('40301', '江城县', '3', '40230', 'J');
INSERT INTO `ey_region` VALUES ('40310', '孟连县', '3', '40230', 'M');
INSERT INTO `ey_region` VALUES ('40318', '澜沧县', '3', '40230', 'L');
INSERT INTO `ey_region` VALUES ('40340', '西盟县', '3', '40230', 'X');
INSERT INTO `ey_region` VALUES ('40348', '临沧市', '2', '39556', 'L');
INSERT INTO `ey_region` VALUES ('40349', '市辖区', '3', '40348', 'S');
INSERT INTO `ey_region` VALUES ('40350', '临翔区', '3', '40348', 'L');
INSERT INTO `ey_region` VALUES ('40361', '凤庆县', '3', '40348', 'F');
INSERT INTO `ey_region` VALUES ('40375', '云县', '3', '40348', 'Y');
INSERT INTO `ey_region` VALUES ('40388', '永德县', '3', '40348', 'Y');
INSERT INTO `ey_region` VALUES ('40400', '镇康县', '3', '40348', 'Z');
INSERT INTO `ey_region` VALUES ('40408', '双江县', '3', '40348', 'S');
INSERT INTO `ey_region` VALUES ('40417', '耿马县', '3', '40348', 'G');
INSERT INTO `ey_region` VALUES ('40429', '沧源县', '3', '40348', 'C');
INSERT INTO `ey_region` VALUES ('40441', '楚雄州', '2', '39556', 'C');
INSERT INTO `ey_region` VALUES ('40442', '楚雄市', '3', '40441', 'C');
INSERT INTO `ey_region` VALUES ('40458', '双柏县', '3', '40441', 'S');
INSERT INTO `ey_region` VALUES ('40467', '牟定县', '3', '40441', 'M');
INSERT INTO `ey_region` VALUES ('40475', '南华县', '3', '40441', 'N');
INSERT INTO `ey_region` VALUES ('40486', '姚安县', '3', '40441', 'Y');
INSERT INTO `ey_region` VALUES ('40496', '大姚县', '3', '40441', 'D');
INSERT INTO `ey_region` VALUES ('40509', '永仁县', '3', '40441', 'Y');
INSERT INTO `ey_region` VALUES ('40517', '元谋县', '3', '40441', 'Y');
INSERT INTO `ey_region` VALUES ('40528', '武定县', '3', '40441', 'W');
INSERT INTO `ey_region` VALUES ('40540', '禄丰县', '3', '40441', 'L');
INSERT INTO `ey_region` VALUES ('40555', '红河州', '2', '39556', 'H');
INSERT INTO `ey_region` VALUES ('40556', '个旧市', '3', '40555', 'G');
INSERT INTO `ey_region` VALUES ('40567', '开远市', '3', '40555', 'K');
INSERT INTO `ey_region` VALUES ('40576', '蒙自县', '3', '40555', 'M');
INSERT INTO `ey_region` VALUES ('40588', '屏边县', '3', '40555', 'P');
INSERT INTO `ey_region` VALUES ('40596', '建水县', '3', '40555', 'J');
INSERT INTO `ey_region` VALUES ('40611', '石屏县', '3', '40555', 'S');
INSERT INTO `ey_region` VALUES ('40621', '弥勒县', '3', '40555', 'M');
INSERT INTO `ey_region` VALUES ('40635', '泸西县', '3', '40555', 'L');
INSERT INTO `ey_region` VALUES ('40644', '元阳县', '3', '40555', 'Y');
INSERT INTO `ey_region` VALUES ('40659', '红河县', '3', '40555', 'H');
INSERT INTO `ey_region` VALUES ('40673', '金平县', '3', '40555', 'J');
INSERT INTO `ey_region` VALUES ('40688', '绿春县', '3', '40555', 'L');
INSERT INTO `ey_region` VALUES ('40698', '河口县', '3', '40555', 'H');
INSERT INTO `ey_region` VALUES ('40705', '文山州', '2', '39556', 'W');
INSERT INTO `ey_region` VALUES ('40706', '文山县', '3', '40705', 'W');
INSERT INTO `ey_region` VALUES ('40722', '砚山县', '3', '40705', 'Y');
INSERT INTO `ey_region` VALUES ('40734', '西畴县', '3', '40705', 'X');
INSERT INTO `ey_region` VALUES ('40744', '麻栗坡县', '3', '40705', 'M');
INSERT INTO `ey_region` VALUES ('40756', '马关县', '3', '40705', 'M');
INSERT INTO `ey_region` VALUES ('40770', '丘北县', '3', '40705', 'Q');
INSERT INTO `ey_region` VALUES ('40783', '广南县', '3', '40705', 'G');
INSERT INTO `ey_region` VALUES ('40802', '富宁县', '3', '40705', 'F');
INSERT INTO `ey_region` VALUES ('40816', '西双版纳州', '2', '39556', 'X');
INSERT INTO `ey_region` VALUES ('40817', '景洪市', '3', '40816', 'J');
INSERT INTO `ey_region` VALUES ('40829', '勐海县', '3', '40816', 'M');
INSERT INTO `ey_region` VALUES ('40841', '勐腊县', '3', '40816', 'M');
INSERT INTO `ey_region` VALUES ('40852', '大理州', '2', '39556', 'D');
INSERT INTO `ey_region` VALUES ('40853', '大理市', '3', '40852', 'D');
INSERT INTO `ey_region` VALUES ('40866', '漾濞县', '3', '40852', 'Y');
INSERT INTO `ey_region` VALUES ('40876', '祥云县', '3', '40852', 'X');
INSERT INTO `ey_region` VALUES ('40887', '宾川县', '3', '40852', 'B');
INSERT INTO `ey_region` VALUES ('40901', '弥渡县', '3', '40852', 'M');
INSERT INTO `ey_region` VALUES ('40910', '南涧县', '3', '40852', 'N');
INSERT INTO `ey_region` VALUES ('40919', '巍山县', '3', '40852', 'W');
INSERT INTO `ey_region` VALUES ('40930', '永平县', '3', '40852', 'Y');
INSERT INTO `ey_region` VALUES ('40938', '云龙县', '3', '40852', 'Y');
INSERT INTO `ey_region` VALUES ('40950', '洱源县', '3', '40852', 'E');
INSERT INTO `ey_region` VALUES ('40960', '剑川县', '3', '40852', 'J');
INSERT INTO `ey_region` VALUES ('40969', '鹤庆县', '3', '40852', 'H');
INSERT INTO `ey_region` VALUES ('40979', '德宏州', '2', '39556', 'D');
INSERT INTO `ey_region` VALUES ('40980', '瑞丽市', '3', '40979', 'R');
INSERT INTO `ey_region` VALUES ('40988', '潞西市', '3', '40979', 'L');
INSERT INTO `ey_region` VALUES ('41000', '梁河县', '3', '40979', 'L');
INSERT INTO `ey_region` VALUES ('41010', '盈江县', '3', '40979', 'Y');
INSERT INTO `ey_region` VALUES ('41026', '陇川县', '3', '40979', 'L');
INSERT INTO `ey_region` VALUES ('41036', '怒江州', '2', '39556', 'N');
INSERT INTO `ey_region` VALUES ('41037', '泸水县', '3', '41036', 'L');
INSERT INTO `ey_region` VALUES ('41047', '福贡县', '3', '41036', 'F');
INSERT INTO `ey_region` VALUES ('41055', '贡山县', '3', '41036', 'G');
INSERT INTO `ey_region` VALUES ('41061', '兰坪县', '3', '41036', 'L');
INSERT INTO `ey_region` VALUES ('41070', '迪庆州', '2', '39556', 'D');
INSERT INTO `ey_region` VALUES ('41071', '香格里拉县', '3', '41070', 'X');
INSERT INTO `ey_region` VALUES ('41083', '德钦县', '3', '41070', 'D');
INSERT INTO `ey_region` VALUES ('41092', '维西县', '3', '41070', 'W');
INSERT INTO `ey_region` VALUES ('41103', '西藏自治区', '1', '0', 'X');
INSERT INTO `ey_region` VALUES ('41104', '拉萨市', '2', '41103', 'L');
INSERT INTO `ey_region` VALUES ('41105', '市辖区', '3', '41104', 'S');
INSERT INTO `ey_region` VALUES ('41106', '城关区', '3', '41104', 'C');
INSERT INTO `ey_region` VALUES ('41118', '林周县', '3', '41104', 'L');
INSERT INTO `ey_region` VALUES ('41129', '当雄县', '3', '41104', 'D');
INSERT INTO `ey_region` VALUES ('41138', '尼木县', '3', '41104', 'N');
INSERT INTO `ey_region` VALUES ('41147', '曲水县', '3', '41104', 'Q');
INSERT INTO `ey_region` VALUES ('41154', '堆龙德庆', '3', '41104', 'D');
INSERT INTO `ey_region` VALUES ('41162', '达孜县', '3', '41104', 'D');
INSERT INTO `ey_region` VALUES ('41169', '墨竹工卡县', '3', '41104', 'M');
INSERT INTO `ey_region` VALUES ('41178', '昌都地区', '2', '41103', 'C');
INSERT INTO `ey_region` VALUES ('41179', '昌都县', '3', '41178', 'C');
INSERT INTO `ey_region` VALUES ('41195', '江达县', '3', '41178', 'J');
INSERT INTO `ey_region` VALUES ('41209', '贡觉县', '3', '41178', 'G');
INSERT INTO `ey_region` VALUES ('41222', '类乌齐县', '3', '41178', 'L');
INSERT INTO `ey_region` VALUES ('41233', '丁青县', '3', '41178', 'D');
INSERT INTO `ey_region` VALUES ('41247', '察亚县', '3', '41178', 'C');
INSERT INTO `ey_region` VALUES ('41261', '八宿县', '3', '41178', 'B');
INSERT INTO `ey_region` VALUES ('41276', '左贡县', '3', '41178', 'Z');
INSERT INTO `ey_region` VALUES ('41287', '芒康县', '3', '41178', 'M');
INSERT INTO `ey_region` VALUES ('41304', '洛隆县', '3', '41178', 'L');
INSERT INTO `ey_region` VALUES ('41316', '边坝县', '3', '41178', 'B');
INSERT INTO `ey_region` VALUES ('41328', '山南地区', '2', '41103', 'S');
INSERT INTO `ey_region` VALUES ('41329', '乃东县', '3', '41328', 'N');
INSERT INTO `ey_region` VALUES ('41337', '扎囊县', '3', '41328', 'Z');
INSERT INTO `ey_region` VALUES ('41343', '贡嘎县', '3', '41328', 'G');
INSERT INTO `ey_region` VALUES ('41352', '桑日县', '3', '41328', 'S');
INSERT INTO `ey_region` VALUES ('41357', '琼结县', '3', '41328', 'Q');
INSERT INTO `ey_region` VALUES ('41362', '曲松县', '3', '41328', 'Q');
INSERT INTO `ey_region` VALUES ('41368', '措美县', '3', '41328', 'C');
INSERT INTO `ey_region` VALUES ('41373', '洛扎县', '3', '41328', 'L');
INSERT INTO `ey_region` VALUES ('41381', '加查县', '3', '41328', 'J');
INSERT INTO `ey_region` VALUES ('41389', '隆子县', '3', '41328', 'L');
INSERT INTO `ey_region` VALUES ('41401', '错那县', '3', '41328', 'C');
INSERT INTO `ey_region` VALUES ('41412', '浪卡子县', '3', '41328', 'L');
INSERT INTO `ey_region` VALUES ('41423', '日喀则地区', '2', '41103', 'R');
INSERT INTO `ey_region` VALUES ('41424', '日喀则市', '3', '41423', 'R');
INSERT INTO `ey_region` VALUES ('41437', '南木林县', '3', '41423', 'N');
INSERT INTO `ey_region` VALUES ('41455', '江孜县', '3', '41423', 'J');
INSERT INTO `ey_region` VALUES ('41475', '定日县', '3', '41423', 'D');
INSERT INTO `ey_region` VALUES ('41489', '萨迦县', '3', '41423', 'S');
INSERT INTO `ey_region` VALUES ('41501', '拉孜县', '3', '41423', 'L');
INSERT INTO `ey_region` VALUES ('41513', '昂仁县', '3', '41423', 'A');
INSERT INTO `ey_region` VALUES ('41531', '谢通门县', '3', '41423', 'X');
INSERT INTO `ey_region` VALUES ('41551', '白朗县', '3', '41423', 'B');
INSERT INTO `ey_region` VALUES ('41563', '仁布县', '3', '41423', 'R');
INSERT INTO `ey_region` VALUES ('41573', '康马县', '3', '41423', 'K');
INSERT INTO `ey_region` VALUES ('41583', '定结县', '3', '41423', 'D');
INSERT INTO `ey_region` VALUES ('41594', '仲巴县', '3', '41423', 'Z');
INSERT INTO `ey_region` VALUES ('41608', '亚东县', '3', '41423', 'Y');
INSERT INTO `ey_region` VALUES ('41616', '吉隆县', '3', '41423', 'J');
INSERT INTO `ey_region` VALUES ('41622', '聂拉木县', '3', '41423', 'N');
INSERT INTO `ey_region` VALUES ('41630', '萨嘎县', '3', '41423', 'S');
INSERT INTO `ey_region` VALUES ('41639', '岗巴县', '3', '41423', 'G');
INSERT INTO `ey_region` VALUES ('41645', '那曲地区', '2', '41103', 'N');
INSERT INTO `ey_region` VALUES ('41646', '那曲县', '3', '41645', 'N');
INSERT INTO `ey_region` VALUES ('41659', '嘉黎县', '3', '41645', 'J');
INSERT INTO `ey_region` VALUES ('41670', '比如县', '3', '41645', 'B');
INSERT INTO `ey_region` VALUES ('41681', '聂荣县', '3', '41645', 'N');
INSERT INTO `ey_region` VALUES ('41692', '安多县', '3', '41645', 'A');
INSERT INTO `ey_region` VALUES ('41706', '申扎县', '3', '41645', 'S');
INSERT INTO `ey_region` VALUES ('41715', '索县', '3', '41645', 'S');
INSERT INTO `ey_region` VALUES ('41726', '班戈县', '3', '41645', 'B');
INSERT INTO `ey_region` VALUES ('41737', '巴青县', '3', '41645', 'B');
INSERT INTO `ey_region` VALUES ('41748', '尼玛县', '3', '41645', 'N');
INSERT INTO `ey_region` VALUES ('41770', '阿里地区', '2', '41103', 'A');
INSERT INTO `ey_region` VALUES ('41771', '普兰县', '3', '41770', 'P');
INSERT INTO `ey_region` VALUES ('41775', '札达县', '3', '41770', 'Z');
INSERT INTO `ey_region` VALUES ('41782', '噶尔县', '3', '41770', 'G');
INSERT INTO `ey_region` VALUES ('41788', '日土县', '3', '41770', 'R');
INSERT INTO `ey_region` VALUES ('41794', '革吉县', '3', '41770', 'G');
INSERT INTO `ey_region` VALUES ('41800', '改则县', '3', '41770', 'G');
INSERT INTO `ey_region` VALUES ('41808', '措勤县', '3', '41770', 'C');
INSERT INTO `ey_region` VALUES ('41814', '林芝地区', '2', '41103', 'L');
INSERT INTO `ey_region` VALUES ('41815', '林芝县', '3', '41814', 'L');
INSERT INTO `ey_region` VALUES ('41823', '工布江达县', '3', '41814', 'G');
INSERT INTO `ey_region` VALUES ('41833', '米林县', '3', '41814', 'M');
INSERT INTO `ey_region` VALUES ('41842', '墨脱县', '3', '41814', 'M');
INSERT INTO `ey_region` VALUES ('41851', '波密县', '3', '41814', 'B');
INSERT INTO `ey_region` VALUES ('41863', '察隅县', '3', '41814', 'C');
INSERT INTO `ey_region` VALUES ('41870', '朗县', '3', '41814', 'L');
INSERT INTO `ey_region` VALUES ('41877', '陕西省', '1', '0', 'S');
INSERT INTO `ey_region` VALUES ('41878', '西安市', '2', '41877', 'X');
INSERT INTO `ey_region` VALUES ('41879', '市辖区', '3', '41878', 'S');
INSERT INTO `ey_region` VALUES ('41880', '新城区', '3', '41878', 'X');
INSERT INTO `ey_region` VALUES ('41890', '碑林区', '3', '41878', 'B');
INSERT INTO `ey_region` VALUES ('41899', '莲湖区', '3', '41878', 'L');
INSERT INTO `ey_region` VALUES ('41909', '灞桥区', '3', '41878', 'B');
INSERT INTO `ey_region` VALUES ('41919', '未央区', '3', '41878', 'W');
INSERT INTO `ey_region` VALUES ('41930', '雁塔区', '3', '41878', 'Y');
INSERT INTO `ey_region` VALUES ('41939', '阎良区', '3', '41878', 'Y');
INSERT INTO `ey_region` VALUES ('41947', '临潼区', '3', '41878', 'L');
INSERT INTO `ey_region` VALUES ('41971', '长安区', '3', '41878', 'C');
INSERT INTO `ey_region` VALUES ('41997', '蓝田县', '3', '41878', 'L');
INSERT INTO `ey_region` VALUES ('42020', '周至县', '3', '41878', 'Z');
INSERT INTO `ey_region` VALUES ('42043', '户县', '3', '41878', 'H');
INSERT INTO `ey_region` VALUES ('42060', '高陵县', '3', '41878', 'G');
INSERT INTO `ey_region` VALUES ('42069', '铜川市', '2', '41877', 'T');
INSERT INTO `ey_region` VALUES ('42070', '市辖区', '3', '42069', 'S');
INSERT INTO `ey_region` VALUES ('42071', '王益区', '3', '42069', 'W');
INSERT INTO `ey_region` VALUES ('42079', '印台区', '3', '42069', 'Y');
INSERT INTO `ey_region` VALUES ('42091', '耀州区', '3', '42069', 'Y');
INSERT INTO `ey_region` VALUES ('42108', '宜君县', '3', '42069', 'Y');
INSERT INTO `ey_region` VALUES ('42119', '宝鸡市', '2', '41877', 'B');
INSERT INTO `ey_region` VALUES ('42120', '市辖区', '3', '42119', 'S');
INSERT INTO `ey_region` VALUES ('42121', '渭滨区', '3', '42119', 'W');
INSERT INTO `ey_region` VALUES ('42133', '金台区', '3', '42119', 'J');
INSERT INTO `ey_region` VALUES ('42146', '陈仓区', '3', '42119', 'C');
INSERT INTO `ey_region` VALUES ('42165', '凤翔县', '3', '42119', 'F');
INSERT INTO `ey_region` VALUES ('42183', '岐山县', '3', '42119', 'Q');
INSERT INTO `ey_region` VALUES ('42198', '扶风县', '3', '42119', 'F');
INSERT INTO `ey_region` VALUES ('42211', '眉县', '3', '42119', 'M');
INSERT INTO `ey_region` VALUES ('42224', '陇县', '3', '42119', 'L');
INSERT INTO `ey_region` VALUES ('42240', '千阳县', '3', '42119', 'Q');
INSERT INTO `ey_region` VALUES ('42252', '麟游县', '3', '42119', 'L');
INSERT INTO `ey_region` VALUES ('42263', '凤县', '3', '42119', 'F');
INSERT INTO `ey_region` VALUES ('42278', '太白县', '3', '42119', 'T');
INSERT INTO `ey_region` VALUES ('42287', '咸阳市', '2', '41877', 'X');
INSERT INTO `ey_region` VALUES ('42288', '市辖区', '3', '42287', 'S');
INSERT INTO `ey_region` VALUES ('42289', '秦都区', '3', '42287', 'Q');
INSERT INTO `ey_region` VALUES ('42302', '杨凌区', '3', '42287', 'Y');
INSERT INTO `ey_region` VALUES ('42308', '渭城区', '3', '42287', 'W');
INSERT INTO `ey_region` VALUES ('42319', '三原县', '3', '42287', 'S');
INSERT INTO `ey_region` VALUES ('42334', '泾阳县', '3', '42287', 'J');
INSERT INTO `ey_region` VALUES ('42351', '乾县', '3', '42287', 'Q');
INSERT INTO `ey_region` VALUES ('42372', '礼泉县', '3', '42287', 'L');
INSERT INTO `ey_region` VALUES ('42388', '永寿县', '3', '42287', 'Y');
INSERT INTO `ey_region` VALUES ('42402', '彬县', '3', '42287', 'B');
INSERT INTO `ey_region` VALUES ('42419', '长武县', '3', '42287', 'C');
INSERT INTO `ey_region` VALUES ('42431', '旬邑县', '3', '42287', 'X');
INSERT INTO `ey_region` VALUES ('42446', '淳化县', '3', '42287', 'C');
INSERT INTO `ey_region` VALUES ('42462', '武功县', '3', '42287', 'W');
INSERT INTO `ey_region` VALUES ('42475', '兴平市', '3', '42287', 'X');
INSERT INTO `ey_region` VALUES ('42490', '渭南市', '2', '41877', 'W');
INSERT INTO `ey_region` VALUES ('42491', '市辖区', '3', '42490', 'S');
INSERT INTO `ey_region` VALUES ('42492', '临渭区', '3', '42490', 'L');
INSERT INTO `ey_region` VALUES ('42523', '华县', '3', '42490', 'H');
INSERT INTO `ey_region` VALUES ('42538', '潼关县', '3', '42490', 'T');
INSERT INTO `ey_region` VALUES ('42547', '大荔县', '3', '42490', 'D');
INSERT INTO `ey_region` VALUES ('42577', '合阳县', '3', '42490', 'H');
INSERT INTO `ey_region` VALUES ('42594', '澄城县', '3', '42490', 'C');
INSERT INTO `ey_region` VALUES ('42609', '蒲城县', '3', '42490', 'P');
INSERT INTO `ey_region` VALUES ('42634', '白水县', '3', '42490', 'B');
INSERT INTO `ey_region` VALUES ('42649', '富平县', '3', '42490', 'F');
INSERT INTO `ey_region` VALUES ('42674', '韩城市', '3', '42490', 'H');
INSERT INTO `ey_region` VALUES ('42691', '华阴市', '3', '42490', 'H');
INSERT INTO `ey_region` VALUES ('42703', '延安市', '2', '41877', 'Y');
INSERT INTO `ey_region` VALUES ('42704', '市辖区', '3', '42703', 'S');
INSERT INTO `ey_region` VALUES ('42705', '宝塔区', '3', '42703', 'B');
INSERT INTO `ey_region` VALUES ('42729', '延长县', '3', '42703', 'Y');
INSERT INTO `ey_region` VALUES ('42742', '延川县', '3', '42703', 'Y');
INSERT INTO `ey_region` VALUES ('42757', '子长县', '3', '42703', 'Z');
INSERT INTO `ey_region` VALUES ('42771', '安塞县', '3', '42703', 'A');
INSERT INTO `ey_region` VALUES ('42784', '志丹县', '3', '42703', 'Z');
INSERT INTO `ey_region` VALUES ('42796', '吴起县', '3', '42703', 'W');
INSERT INTO `ey_region` VALUES ('42809', '甘泉县', '3', '42703', 'G');
INSERT INTO `ey_region` VALUES ('42818', '富县', '3', '42703', 'F');
INSERT INTO `ey_region` VALUES ('42833', '洛川县', '3', '42703', 'L');
INSERT INTO `ey_region` VALUES ('42850', '宜川县', '3', '42703', 'Y');
INSERT INTO `ey_region` VALUES ('42863', '黄龙县', '3', '42703', 'H');
INSERT INTO `ey_region` VALUES ('42874', '黄陵县', '3', '42703', 'H');
INSERT INTO `ey_region` VALUES ('42888', '汉中市', '2', '41877', 'H');
INSERT INTO `ey_region` VALUES ('42889', '市辖区', '3', '42888', 'S');
INSERT INTO `ey_region` VALUES ('42890', '汉台区', '3', '42888', 'H');
INSERT INTO `ey_region` VALUES ('42908', '南郑县', '3', '42888', 'N');
INSERT INTO `ey_region` VALUES ('42939', '城固县', '3', '42888', 'C');
INSERT INTO `ey_region` VALUES ('42965', '洋县', '3', '42888', 'Y');
INSERT INTO `ey_region` VALUES ('42992', '西乡县', '3', '42888', 'X');
INSERT INTO `ey_region` VALUES ('43016', '勉县', '3', '42888', 'M');
INSERT INTO `ey_region` VALUES ('43042', '宁强县', '3', '42888', 'N');
INSERT INTO `ey_region` VALUES ('43069', '略阳县', '3', '42888', 'L');
INSERT INTO `ey_region` VALUES ('43091', '镇巴县', '3', '42888', 'Z');
INSERT INTO `ey_region` VALUES ('43116', '留坝县', '3', '42888', 'L');
INSERT INTO `ey_region` VALUES ('43126', '佛坪县', '3', '42888', 'F');
INSERT INTO `ey_region` VALUES ('43136', '榆林市', '2', '41877', 'Y');
INSERT INTO `ey_region` VALUES ('43137', '市辖区', '3', '43136', 'S');
INSERT INTO `ey_region` VALUES ('43138', '榆阳区', '3', '43136', 'Y');
INSERT INTO `ey_region` VALUES ('43170', '神木县', '3', '43136', 'S');
INSERT INTO `ey_region` VALUES ('43190', '府谷县', '3', '43136', 'F');
INSERT INTO `ey_region` VALUES ('43211', '横山县', '3', '43136', 'H');
INSERT INTO `ey_region` VALUES ('43230', '靖边县', '3', '43136', 'J');
INSERT INTO `ey_region` VALUES ('43253', '定边县', '3', '43136', 'D');
INSERT INTO `ey_region` VALUES ('43279', '绥德县', '3', '43136', 'S');
INSERT INTO `ey_region` VALUES ('43300', '米脂县', '3', '43136', 'M');
INSERT INTO `ey_region` VALUES ('43314', '佳县', '3', '43136', 'J');
INSERT INTO `ey_region` VALUES ('43335', '吴堡县', '3', '43136', 'W');
INSERT INTO `ey_region` VALUES ('43344', '清涧县', '3', '43136', 'Q');
INSERT INTO `ey_region` VALUES ('43360', '子洲县', '3', '43136', 'Z');
INSERT INTO `ey_region` VALUES ('43379', '安康市', '2', '41877', 'A');
INSERT INTO `ey_region` VALUES ('43380', '市辖区', '3', '43379', 'S');
INSERT INTO `ey_region` VALUES ('43381', '汉滨区', '3', '43379', 'H');
INSERT INTO `ey_region` VALUES ('43428', '汉阴县', '3', '43379', 'H');
INSERT INTO `ey_region` VALUES ('43447', '石泉县', '3', '43379', 'S');
INSERT INTO `ey_region` VALUES ('43463', '宁陕县', '3', '43379', 'N');
INSERT INTO `ey_region` VALUES ('43478', '紫阳县', '3', '43379', 'Z');
INSERT INTO `ey_region` VALUES ('43504', '岚皋县', '3', '43379', 'L');
INSERT INTO `ey_region` VALUES ('43522', '平利县', '3', '43379', 'P');
INSERT INTO `ey_region` VALUES ('43535', '镇坪县', '3', '43379', 'Z');
INSERT INTO `ey_region` VALUES ('43546', '旬阳县', '3', '43379', 'X');
INSERT INTO `ey_region` VALUES ('43575', '白河县', '3', '43379', 'B');
INSERT INTO `ey_region` VALUES ('43592', '商洛市', '2', '41877', 'S');
INSERT INTO `ey_region` VALUES ('43593', '市辖区', '3', '43592', 'S');
INSERT INTO `ey_region` VALUES ('43594', '商州区', '3', '43592', 'S');
INSERT INTO `ey_region` VALUES ('43628', '洛南县', '3', '43592', 'L');
INSERT INTO `ey_region` VALUES ('43654', '丹凤县', '3', '43592', 'D');
INSERT INTO `ey_region` VALUES ('43676', '商南县', '3', '43592', 'S');
INSERT INTO `ey_region` VALUES ('43699', '山阳县', '3', '43592', 'S');
INSERT INTO `ey_region` VALUES ('43730', '镇安县', '3', '43592', 'Z');
INSERT INTO `ey_region` VALUES ('43759', '柞水县', '3', '43592', 'Z');
INSERT INTO `ey_region` VALUES ('43776', '甘肃省', '1', '0', 'G');
INSERT INTO `ey_region` VALUES ('43777', '兰州市', '2', '43776', 'L');
INSERT INTO `ey_region` VALUES ('43778', '市辖区', '3', '43777', 'S');
INSERT INTO `ey_region` VALUES ('43779', '城关区', '3', '43777', 'C');
INSERT INTO `ey_region` VALUES ('43804', '七里河区', '3', '43777', 'Q');
INSERT INTO `ey_region` VALUES ('43820', '兰州市西固区', '3', '43777', 'L');
INSERT INTO `ey_region` VALUES ('43836', '安宁区', '3', '43777', 'A');
INSERT INTO `ey_region` VALUES ('43845', '红古区', '3', '43777', 'H');
INSERT INTO `ey_region` VALUES ('43853', '永登县', '3', '43777', 'Y');
INSERT INTO `ey_region` VALUES ('43872', '皋兰县', '3', '43777', 'G');
INSERT INTO `ey_region` VALUES ('43880', '榆中县', '3', '43777', 'Y');
INSERT INTO `ey_region` VALUES ('43904', '嘉峪关市', '2', '43776', 'J');
INSERT INTO `ey_region` VALUES ('43905', '市辖', '3', '43904', 'S');
INSERT INTO `ey_region` VALUES ('43914', '金昌市', '2', '43776', 'J');
INSERT INTO `ey_region` VALUES ('43915', '市辖区', '3', '43914', 'S');
INSERT INTO `ey_region` VALUES ('43916', '金川区', '3', '43914', 'J');
INSERT INTO `ey_region` VALUES ('43925', '永昌县', '3', '43914', 'Y');
INSERT INTO `ey_region` VALUES ('43936', '白银市', '2', '43776', 'B');
INSERT INTO `ey_region` VALUES ('43937', '市辖区', '3', '43936', 'S');
INSERT INTO `ey_region` VALUES ('43938', '白银区', '3', '43936', 'B');
INSERT INTO `ey_region` VALUES ('43949', '平川区', '3', '43936', 'P');
INSERT INTO `ey_region` VALUES ('43961', '靖远县', '3', '43936', 'J');
INSERT INTO `ey_region` VALUES ('43980', '会宁县', '3', '43936', 'H');
INSERT INTO `ey_region` VALUES ('44009', '景泰县', '3', '43936', 'J');
INSERT INTO `ey_region` VALUES ('44022', '天水市', '2', '43776', 'T');
INSERT INTO `ey_region` VALUES ('44023', '市辖区', '3', '44022', 'S');
INSERT INTO `ey_region` VALUES ('44024', '秦州区', '3', '44022', 'Q');
INSERT INTO `ey_region` VALUES ('44048', '麦积区', '3', '44022', 'M');
INSERT INTO `ey_region` VALUES ('44069', '清水县', '3', '44022', 'Q');
INSERT INTO `ey_region` VALUES ('44088', '秦安县', '3', '44022', 'Q');
INSERT INTO `ey_region` VALUES ('44106', '甘谷县', '3', '44022', 'G');
INSERT INTO `ey_region` VALUES ('44122', '武山县', '3', '44022', 'W');
INSERT INTO `ey_region` VALUES ('44138', '张家川县', '3', '44022', 'Z');
INSERT INTO `ey_region` VALUES ('44154', '武威市', '2', '43776', 'W');
INSERT INTO `ey_region` VALUES ('44155', '市辖区', '3', '44154', 'S');
INSERT INTO `ey_region` VALUES ('44156', '凉州区', '3', '44154', 'L');
INSERT INTO `ey_region` VALUES ('44202', '民勤县', '3', '44154', 'M');
INSERT INTO `ey_region` VALUES ('44221', '古浪县', '3', '44154', 'G');
INSERT INTO `ey_region` VALUES ('44242', '天祝县', '3', '44154', 'T');
INSERT INTO `ey_region` VALUES ('44265', '张掖市', '2', '43776', 'Z');
INSERT INTO `ey_region` VALUES ('44266', '市辖区', '3', '44265', 'S');
INSERT INTO `ey_region` VALUES ('44267', '甘州区', '3', '44265', 'G');
INSERT INTO `ey_region` VALUES ('44294', '肃南县', '3', '44265', 'S');
INSERT INTO `ey_region` VALUES ('44305', '民乐县', '3', '44265', 'M');
INSERT INTO `ey_region` VALUES ('44317', '临泽县', '3', '44265', 'L');
INSERT INTO `ey_region` VALUES ('44331', '高台县', '3', '44265', 'G');
INSERT INTO `ey_region` VALUES ('44341', '山丹县', '3', '44265', 'S');
INSERT INTO `ey_region` VALUES ('44352', '平凉市', '2', '43776', 'P');
INSERT INTO `ey_region` VALUES ('44353', '市辖区', '3', '44352', 'S');
INSERT INTO `ey_region` VALUES ('44354', '崆峒区', '3', '44352', 'K');
INSERT INTO `ey_region` VALUES ('44375', '泾川县', '3', '44352', 'J');
INSERT INTO `ey_region` VALUES ('44392', '灵台县', '3', '44352', 'L');
INSERT INTO `ey_region` VALUES ('44408', '崇信县', '3', '44352', 'C');
INSERT INTO `ey_region` VALUES ('44418', '华亭县', '3', '44352', 'H');
INSERT INTO `ey_region` VALUES ('44431', '庄浪县', '3', '44352', 'Z');
INSERT INTO `ey_region` VALUES ('44451', '静宁县', '3', '44352', 'J');
INSERT INTO `ey_region` VALUES ('44477', '酒泉市', '2', '43776', 'J');
INSERT INTO `ey_region` VALUES ('44478', '市辖区', '3', '44477', 'S');
INSERT INTO `ey_region` VALUES ('44479', '肃州区', '3', '44477', 'S');
INSERT INTO `ey_region` VALUES ('44504', '金塔县', '3', '44477', 'J');
INSERT INTO `ey_region` VALUES ('44516', '瓜州县', '3', '44477', 'G');
INSERT INTO `ey_region` VALUES ('44531', '肃北县', '3', '44477', 'S');
INSERT INTO `ey_region` VALUES ('44535', '阿克塞县', '3', '44477', 'A');
INSERT INTO `ey_region` VALUES ('44539', '玉门市', '3', '44477', 'Y');
INSERT INTO `ey_region` VALUES ('44557', '敦煌市', '3', '44477', 'D');
INSERT INTO `ey_region` VALUES ('44569', '庆阳市', '2', '43776', 'Q');
INSERT INTO `ey_region` VALUES ('44570', '市辖区', '3', '44569', 'S');
INSERT INTO `ey_region` VALUES ('44571', '西峰区', '3', '44569', 'X');
INSERT INTO `ey_region` VALUES ('44582', '庆城县', '3', '44569', 'Q');
INSERT INTO `ey_region` VALUES ('44598', '环县', '3', '44569', 'H');
INSERT INTO `ey_region` VALUES ('44620', '华池县', '3', '44569', 'H');
INSERT INTO `ey_region` VALUES ('44636', '合水县', '3', '44569', 'H');
INSERT INTO `ey_region` VALUES ('44649', '正宁县', '3', '44569', 'Z');
INSERT INTO `ey_region` VALUES ('44660', '宁县', '3', '44569', 'N');
INSERT INTO `ey_region` VALUES ('44679', '镇原县', '3', '44569', 'Z');
INSERT INTO `ey_region` VALUES ('44699', '定西市', '2', '43776', 'D');
INSERT INTO `ey_region` VALUES ('44700', '市辖区', '3', '44699', 'S');
INSERT INTO `ey_region` VALUES ('44701', '安定区', '3', '44699', 'A');
INSERT INTO `ey_region` VALUES ('44723', '通渭县', '3', '44699', 'T');
INSERT INTO `ey_region` VALUES ('44742', '陇西县', '3', '44699', 'L');
INSERT INTO `ey_region` VALUES ('44760', '渭源县', '3', '44699', 'W');
INSERT INTO `ey_region` VALUES ('44777', '临洮县', '3', '44699', 'L');
INSERT INTO `ey_region` VALUES ('44796', '漳县', '3', '44699', 'Z');
INSERT INTO `ey_region` VALUES ('44810', '岷县', '3', '44699', 'M');
INSERT INTO `ey_region` VALUES ('44829', '陇南市', '2', '43776', 'L');
INSERT INTO `ey_region` VALUES ('44830', '市辖区', '3', '44829', 'S');
INSERT INTO `ey_region` VALUES ('44831', '武都区', '3', '44829', 'W');
INSERT INTO `ey_region` VALUES ('44868', '成县', '3', '44829', 'C');
INSERT INTO `ey_region` VALUES ('44886', '文县', '3', '44829', 'W');
INSERT INTO `ey_region` VALUES ('44907', '宕昌县', '3', '44829', 'D');
INSERT INTO `ey_region` VALUES ('44933', '康县', '3', '44829', 'K');
INSERT INTO `ey_region` VALUES ('44955', '西和县', '3', '44829', 'X');
INSERT INTO `ey_region` VALUES ('44976', '礼县', '3', '44829', 'L');
INSERT INTO `ey_region` VALUES ('45006', '徽县', '3', '44829', 'H');
INSERT INTO `ey_region` VALUES ('45022', '两当县', '3', '44829', 'L');
INSERT INTO `ey_region` VALUES ('45035', '临夏州', '2', '43776', 'L');
INSERT INTO `ey_region` VALUES ('45036', '临夏市', '3', '45035', 'L');
INSERT INTO `ey_region` VALUES ('45047', '临夏县', '3', '45035', 'L');
INSERT INTO `ey_region` VALUES ('45073', '康乐县', '3', '45035', 'K');
INSERT INTO `ey_region` VALUES ('45089', '永靖县', '3', '45035', 'Y');
INSERT INTO `ey_region` VALUES ('45107', '广河县', '3', '45035', 'G');
INSERT INTO `ey_region` VALUES ('45117', '和政县', '3', '45035', 'H');
INSERT INTO `ey_region` VALUES ('45131', '东乡县', '3', '45035', 'D');
INSERT INTO `ey_region` VALUES ('45156', '积石山县', '3', '45035', 'J');
INSERT INTO `ey_region` VALUES ('45174', '甘南州', '2', '43776', 'G');
INSERT INTO `ey_region` VALUES ('45175', '合作市', '3', '45174', 'H');
INSERT INTO `ey_region` VALUES ('45186', '临潭县', '3', '45174', 'L');
INSERT INTO `ey_region` VALUES ('45203', '卓尼县', '3', '45174', 'Z');
INSERT INTO `ey_region` VALUES ('45219', '舟曲县', '3', '45174', 'Z');
INSERT INTO `ey_region` VALUES ('45239', '迭部县', '3', '45174', 'D');
INSERT INTO `ey_region` VALUES ('45251', '玛曲县', '3', '45174', 'M');
INSERT INTO `ey_region` VALUES ('45263', '碌曲县', '3', '45174', 'L');
INSERT INTO `ey_region` VALUES ('45272', '夏河县', '3', '45174', 'X');
INSERT INTO `ey_region` VALUES ('45286', '青海省', '1', '0', 'Q');
INSERT INTO `ey_region` VALUES ('45287', '西宁市', '2', '45286', 'X');
INSERT INTO `ey_region` VALUES ('45288', '市辖区', '3', '45287', 'S');
INSERT INTO `ey_region` VALUES ('45289', '城东区', '3', '45287', 'C');
INSERT INTO `ey_region` VALUES ('45299', '城中区', '3', '45287', 'C');
INSERT INTO `ey_region` VALUES ('45306', '城西区', '3', '45287', 'C');
INSERT INTO `ey_region` VALUES ('45314', '城北区', '3', '45287', 'C');
INSERT INTO `ey_region` VALUES ('45320', '大通县', '3', '45287', 'D');
INSERT INTO `ey_region` VALUES ('45341', '湟中县', '3', '45287', 'H');
INSERT INTO `ey_region` VALUES ('45358', '湟源县', '3', '45287', 'H');
INSERT INTO `ey_region` VALUES ('45368', '海东地区', '2', '45286', 'H');
INSERT INTO `ey_region` VALUES ('45369', '平安县', '3', '45368', 'P');
INSERT INTO `ey_region` VALUES ('45378', '民和县', '3', '45368', 'M');
INSERT INTO `ey_region` VALUES ('45401', '乐都县', '3', '45368', 'L');
INSERT INTO `ey_region` VALUES ('45421', '互助县', '3', '45368', 'H');
INSERT INTO `ey_region` VALUES ('45441', '化隆县', '3', '45368', 'H');
INSERT INTO `ey_region` VALUES ('45461', '循化县', '3', '45368', 'X');
INSERT INTO `ey_region` VALUES ('45471', '海北州', '2', '45286', 'H');
INSERT INTO `ey_region` VALUES ('45472', '门源县', '3', '45471', 'M');
INSERT INTO `ey_region` VALUES ('45487', '祁连县', '3', '45471', 'Q');
INSERT INTO `ey_region` VALUES ('45495', '海晏县', '3', '45471', 'H');
INSERT INTO `ey_region` VALUES ('45502', '刚察县', '3', '45471', 'G');
INSERT INTO `ey_region` VALUES ('45510', '黄南州', '2', '45286', 'H');
INSERT INTO `ey_region` VALUES ('45511', '同仁县', '3', '45510', 'T');
INSERT INTO `ey_region` VALUES ('45523', '尖扎县', '3', '45510', 'J');
INSERT INTO `ey_region` VALUES ('45533', '泽库县', '3', '45510', 'Z');
INSERT INTO `ey_region` VALUES ('45542', '河南县', '3', '45510', 'H');
INSERT INTO `ey_region` VALUES ('45548', '海南州', '2', '45286', 'H');
INSERT INTO `ey_region` VALUES ('45549', '共和县', '3', '45548', 'G');
INSERT INTO `ey_region` VALUES ('45566', '同德县', '3', '45548', 'T');
INSERT INTO `ey_region` VALUES ('45573', '贵德县', '3', '45548', 'G');
INSERT INTO `ey_region` VALUES ('45581', '兴海县', '3', '45548', 'X');
INSERT INTO `ey_region` VALUES ('45589', '贵南县', '3', '45548', 'G');
INSERT INTO `ey_region` VALUES ('45597', '果洛州', '2', '45286', 'G');
INSERT INTO `ey_region` VALUES ('45598', '玛沁县', '3', '45597', 'M');
INSERT INTO `ey_region` VALUES ('45607', '班玛县', '3', '45597', 'B');
INSERT INTO `ey_region` VALUES ('45617', '甘德县', '3', '45597', 'G');
INSERT INTO `ey_region` VALUES ('45625', '达日县', '3', '45597', 'D');
INSERT INTO `ey_region` VALUES ('45636', '久治县', '3', '45597', 'J');
INSERT INTO `ey_region` VALUES ('45643', '玛多县', '3', '45597', 'M');
INSERT INTO `ey_region` VALUES ('45648', '玉树州', '2', '45286', 'Y');
INSERT INTO `ey_region` VALUES ('45649', '玉树县', '3', '45648', 'Y');
INSERT INTO `ey_region` VALUES ('45659', '杂多县', '3', '45648', 'Z');
INSERT INTO `ey_region` VALUES ('45668', '称多县', '3', '45648', 'C');
INSERT INTO `ey_region` VALUES ('45676', '治多县', '3', '45648', 'Z');
INSERT INTO `ey_region` VALUES ('45683', '囊谦县', '3', '45648', 'N');
INSERT INTO `ey_region` VALUES ('45694', '曲麻莱县', '3', '45648', 'Q');
INSERT INTO `ey_region` VALUES ('45701', '海西州', '2', '45286', 'H');
INSERT INTO `ey_region` VALUES ('45702', '格尔木市', '3', '45701', 'G');
INSERT INTO `ey_region` VALUES ('45714', '德令哈市', '3', '45701', 'D');
INSERT INTO `ey_region` VALUES ('45727', '乌兰县', '3', '45701', 'W');
INSERT INTO `ey_region` VALUES ('45733', '都兰县', '3', '45701', 'D');
INSERT INTO `ey_region` VALUES ('45742', '天峻县', '3', '45701', 'T');
INSERT INTO `ey_region` VALUES ('45753', '宁夏回族自治区', '1', '0', 'N');
INSERT INTO `ey_region` VALUES ('45754', '银川市', '2', '45753', 'Y');
INSERT INTO `ey_region` VALUES ('45755', '市辖区', '3', '45754', 'S');
INSERT INTO `ey_region` VALUES ('45756', '兴庆区', '3', '45754', 'X');
INSERT INTO `ey_region` VALUES ('45772', '西夏区', '3', '45754', 'X');
INSERT INTO `ey_region` VALUES ('45784', '金凤区', '3', '45754', 'J');
INSERT INTO `ey_region` VALUES ('45794', '永宁县', '3', '45754', 'Y');
INSERT INTO `ey_region` VALUES ('45803', '贺兰县', '3', '45754', 'H');
INSERT INTO `ey_region` VALUES ('45813', '灵武市', '3', '45754', 'L');
INSERT INTO `ey_region` VALUES ('45825', '石嘴山市', '2', '45753', 'S');
INSERT INTO `ey_region` VALUES ('45826', '市辖区', '3', '45825', 'S');
INSERT INTO `ey_region` VALUES ('45827', '大武口区', '3', '45825', 'D');
INSERT INTO `ey_region` VALUES ('45839', '惠农区', '3', '45825', 'H');
INSERT INTO `ey_region` VALUES ('45856', '平罗县', '3', '45825', 'P');
INSERT INTO `ey_region` VALUES ('45871', '吴忠市', '2', '45753', 'W');
INSERT INTO `ey_region` VALUES ('45872', '市辖区', '3', '45871', 'S');
INSERT INTO `ey_region` VALUES ('45877', '利通区', '3', '45871', 'L');
INSERT INTO `ey_region` VALUES ('45892', '盐池县', '3', '45871', 'Y');
INSERT INTO `ey_region` VALUES ('45903', '同心县', '3', '45871', 'T');
INSERT INTO `ey_region` VALUES ('45914', '青铜峡市', '3', '45871', 'Q');
INSERT INTO `ey_region` VALUES ('45926', '固原市', '2', '45753', 'G');
INSERT INTO `ey_region` VALUES ('45927', '市辖区', '3', '45926', 'S');
INSERT INTO `ey_region` VALUES ('45928', '原州区', '3', '45926', 'Y');
INSERT INTO `ey_region` VALUES ('45944', '西吉县', '3', '45926', 'X');
INSERT INTO `ey_region` VALUES ('45964', '隆德县', '3', '45926', 'L');
INSERT INTO `ey_region` VALUES ('45978', '泾源县', '3', '45926', 'J');
INSERT INTO `ey_region` VALUES ('45986', '彭阳县', '3', '45926', 'P');
INSERT INTO `ey_region` VALUES ('45999', '中卫市', '2', '45753', 'Z');
INSERT INTO `ey_region` VALUES ('46000', '市辖区', '3', '45999', 'S');
INSERT INTO `ey_region` VALUES ('46012', '沙坡头区', '3', '45999', 'S');
INSERT INTO `ey_region` VALUES ('46013', '中宁县', '3', '45999', 'Z');
INSERT INTO `ey_region` VALUES ('46026', '海原县', '3', '45999', 'H');
INSERT INTO `ey_region` VALUES ('46047', '新疆维吾尔自治区', '1', '0', 'X');
INSERT INTO `ey_region` VALUES ('46048', '乌鲁木齐市', '2', '46047', 'W');
INSERT INTO `ey_region` VALUES ('46049', '市辖区', '3', '46048', 'S');
INSERT INTO `ey_region` VALUES ('46050', '天山区', '3', '46048', 'T');
INSERT INTO `ey_region` VALUES ('46065', '沙依巴克区', '3', '46048', 'S');
INSERT INTO `ey_region` VALUES ('46079', '新市区', '3', '46048', 'X');
INSERT INTO `ey_region` VALUES ('46095', '水磨沟区', '3', '46048', 'S');
INSERT INTO `ey_region` VALUES ('46104', '头屯河区', '3', '46048', 'T');
INSERT INTO `ey_region` VALUES ('46114', '达坂城区', '3', '46048', 'D');
INSERT INTO `ey_region` VALUES ('46123', '东山区', '3', '46048', 'D');
INSERT INTO `ey_region` VALUES ('46128', '乌鲁木齐县', '3', '46048', 'W');
INSERT INTO `ey_region` VALUES ('46138', '克拉玛依市', '2', '46047', 'K');
INSERT INTO `ey_region` VALUES ('46139', '市辖区', '3', '46138', 'S');
INSERT INTO `ey_region` VALUES ('46140', '独山子区', '3', '46138', 'D');
INSERT INTO `ey_region` VALUES ('46144', '克拉玛依区', '3', '46138', 'K');
INSERT INTO `ey_region` VALUES ('46155', '白碱滩区', '3', '46138', 'B');
INSERT INTO `ey_region` VALUES ('46158', '乌尔禾区', '3', '46138', 'W');
INSERT INTO `ey_region` VALUES ('46162', '吐鲁番地区', '2', '46047', 'T');
INSERT INTO `ey_region` VALUES ('46163', '吐鲁番市', '3', '46162', 'T');
INSERT INTO `ey_region` VALUES ('46178', '鄯善县', '3', '46162', 'S');
INSERT INTO `ey_region` VALUES ('46189', '托克逊县', '3', '46162', 'T');
INSERT INTO `ey_region` VALUES ('46197', '哈密地区', '2', '46047', 'H');
INSERT INTO `ey_region` VALUES ('46198', '哈密市', '3', '46197', 'H');
INSERT INTO `ey_region` VALUES ('46230', '巴里坤县', '3', '46197', 'B');
INSERT INTO `ey_region` VALUES ('46246', '伊吾县', '3', '46197', 'Y');
INSERT INTO `ey_region` VALUES ('46255', '昌吉州', '2', '46047', 'C');
INSERT INTO `ey_region` VALUES ('46256', '昌吉市', '3', '46255', 'C');
INSERT INTO `ey_region` VALUES ('46275', '阜康市', '3', '46255', 'F');
INSERT INTO `ey_region` VALUES ('46289', '米泉市', '3', '46255', 'M');
INSERT INTO `ey_region` VALUES ('46299', '呼图壁县', '3', '46255', 'H');
INSERT INTO `ey_region` VALUES ('46316', '玛纳斯', '3', '46255', 'M');
INSERT INTO `ey_region` VALUES ('46337', '奇台县', '3', '46255', 'Q');
INSERT INTO `ey_region` VALUES ('46355', '吉木萨尔县', '3', '46255', 'J');
INSERT INTO `ey_region` VALUES ('46366', '木垒县', '3', '46255', 'M');
INSERT INTO `ey_region` VALUES ('46380', '博州', '2', '46047', 'B');
INSERT INTO `ey_region` VALUES ('46381', '博乐市', '3', '46380', 'B');
INSERT INTO `ey_region` VALUES ('46399', '精河县', '3', '46380', 'J');
INSERT INTO `ey_region` VALUES ('46410', '温泉县', '3', '46380', 'W');
INSERT INTO `ey_region` VALUES ('46422', '巴州', '2', '46047', 'B');
INSERT INTO `ey_region` VALUES ('46423', '库尔勒市', '3', '46422', 'K');
INSERT INTO `ey_region` VALUES ('46451', '轮台县', '3', '46422', 'L');
INSERT INTO `ey_region` VALUES ('46463', '尉犁县', '3', '46422', 'W');
INSERT INTO `ey_region` VALUES ('46476', '若羌县', '3', '46422', 'R');
INSERT INTO `ey_region` VALUES ('46486', '且末县', '3', '46422', 'Q');
INSERT INTO `ey_region` VALUES ('46500', '焉耆县', '3', '46422', 'Y');
INSERT INTO `ey_region` VALUES ('46512', '和静县', '3', '46422', 'H');
INSERT INTO `ey_region` VALUES ('46531', '和硕县', '3', '46422', 'H');
INSERT INTO `ey_region` VALUES ('46542', '博湖县', '3', '46422', 'B');
INSERT INTO `ey_region` VALUES ('46551', '阿克苏地区', '2', '46047', 'A');
INSERT INTO `ey_region` VALUES ('46552', '阿克苏市', '3', '46551', 'A');
INSERT INTO `ey_region` VALUES ('46571', '温宿县', '3', '46551', 'W');
INSERT INTO `ey_region` VALUES ('46592', '库车县', '3', '46551', 'K');
INSERT INTO `ey_region` VALUES ('46617', '沙雅县', '3', '46551', 'S');
INSERT INTO `ey_region` VALUES ('46630', '新和县', '3', '46551', 'X');
INSERT INTO `ey_region` VALUES ('46640', '拜城县', '3', '46551', 'B');
INSERT INTO `ey_region` VALUES ('46657', '乌什县', '3', '46551', 'W');
INSERT INTO `ey_region` VALUES ('46668', '阿瓦提县', '3', '46551', 'A');
INSERT INTO `ey_region` VALUES ('46682', '柯坪县', '3', '46551', 'K');
INSERT INTO `ey_region` VALUES ('46688', '克州', '2', '46047', 'K');
INSERT INTO `ey_region` VALUES ('46689', '阿图什市', '3', '46688', 'A');
INSERT INTO `ey_region` VALUES ('46704', '阿克陶县', '3', '46688', 'A');
INSERT INTO `ey_region` VALUES ('46723', '阿合奇县', '3', '46688', 'A');
INSERT INTO `ey_region` VALUES ('46733', '乌恰县', '3', '46688', 'W');
INSERT INTO `ey_region` VALUES ('46747', '喀什地区', '2', '46047', 'K');
INSERT INTO `ey_region` VALUES ('46748', '喀什市', '3', '46747', 'K');
INSERT INTO `ey_region` VALUES ('46761', '疏附县', '3', '46747', 'S');
INSERT INTO `ey_region` VALUES ('46780', '疏勒县', '3', '46747', 'S');
INSERT INTO `ey_region` VALUES ('46797', '英吉沙县', '3', '46747', 'Y');
INSERT INTO `ey_region` VALUES ('46813', '泽普县', '3', '46747', 'Z');
INSERT INTO `ey_region` VALUES ('46830', '莎车县', '3', '46747', 'S');
INSERT INTO `ey_region` VALUES ('46863', '叶城县', '3', '46747', 'Y');
INSERT INTO `ey_region` VALUES ('46885', '麦盖提县', '3', '46747', 'M');
INSERT INTO `ey_region` VALUES ('46902', '岳普湖县', '3', '46747', 'Y');
INSERT INTO `ey_region` VALUES ('46913', '伽师县', '3', '46747', 'Q');
INSERT INTO `ey_region` VALUES ('46928', '巴楚县', '3', '46747', 'B');
INSERT INTO `ey_region` VALUES ('46942', '塔什库尔干县', '3', '46747', 'T');
INSERT INTO `ey_region` VALUES ('46957', '和田地区', '2', '46047', 'H');
INSERT INTO `ey_region` VALUES ('46958', '和田市', '3', '46957', 'H');
INSERT INTO `ey_region` VALUES ('46971', '和田县', '3', '46957', 'H');
INSERT INTO `ey_region` VALUES ('46983', '墨玉县', '3', '46957', 'M');
INSERT INTO `ey_region` VALUES ('47002', '皮山县', '3', '46957', 'P');
INSERT INTO `ey_region` VALUES ('47020', '洛浦县', '3', '46957', 'L');
INSERT INTO `ey_region` VALUES ('47032', '策勒县', '3', '46957', 'C');
INSERT INTO `ey_region` VALUES ('47042', '于田县', '3', '46957', 'Y');
INSERT INTO `ey_region` VALUES ('47061', '民丰县', '3', '46957', 'M');
INSERT INTO `ey_region` VALUES ('47069', '伊犁州', '2', '46047', 'Y');
INSERT INTO `ey_region` VALUES ('47070', '伊宁市', '3', '47069', 'Y');
INSERT INTO `ey_region` VALUES ('47091', '奎屯市', '3', '47069', 'K');
INSERT INTO `ey_region` VALUES ('47099', '伊宁县', '3', '47069', 'Y');
INSERT INTO `ey_region` VALUES ('47121', '察布查尔县', '3', '47069', 'C');
INSERT INTO `ey_region` VALUES ('47143', '霍城县', '3', '47069', 'H');
INSERT INTO `ey_region` VALUES ('47164', '巩留县', '3', '47069', 'G');
INSERT INTO `ey_region` VALUES ('47180', '新源县', '3', '47069', 'X');
INSERT INTO `ey_region` VALUES ('47196', '昭苏县', '3', '47069', 'Z');
INSERT INTO `ey_region` VALUES ('47214', '特克斯县', '3', '47069', 'T');
INSERT INTO `ey_region` VALUES ('47226', '尼勒克县', '3', '47069', 'N');
INSERT INTO `ey_region` VALUES ('47241', '塔城地区', '2', '46047', 'T');
INSERT INTO `ey_region` VALUES ('47242', '塔城市', '3', '47241', 'T');
INSERT INTO `ey_region` VALUES ('47258', '乌苏市', '3', '47241', 'W');
INSERT INTO `ey_region` VALUES ('47291', '额敏县', '3', '47241', 'E');
INSERT INTO `ey_region` VALUES ('47315', '沙湾县', '3', '47241', 'S');
INSERT INTO `ey_region` VALUES ('47338', '托里县', '3', '47241', 'T');
INSERT INTO `ey_region` VALUES ('47351', '裕民县', '3', '47241', 'Y');
INSERT INTO `ey_region` VALUES ('47360', '和布县', '3', '47241', 'H');
INSERT INTO `ey_region` VALUES ('47374', '阿勒泰地区', '2', '46047', 'A');
INSERT INTO `ey_region` VALUES ('47375', '阿勒泰市', '3', '47374', 'A');
INSERT INTO `ey_region` VALUES ('47393', '布尔津县', '3', '47374', 'B');
INSERT INTO `ey_region` VALUES ('47401', '富蕴县', '3', '47374', 'F');
INSERT INTO `ey_region` VALUES ('47411', '福海县', '3', '47374', 'F');
INSERT INTO `ey_region` VALUES ('47424', '哈巴河县', '3', '47374', 'H');
INSERT INTO `ey_region` VALUES ('47433', '青河县', '3', '47374', 'Q');
INSERT INTO `ey_region` VALUES ('47441', '吉木乃县', '3', '47374', 'J');
INSERT INTO `ey_region` VALUES ('47450', '省直辖行政单位', '2', '46047', 'S');
INSERT INTO `ey_region` VALUES ('47451', '石河子市', '3', '47450', 'S');
INSERT INTO `ey_region` VALUES ('47460', '阿拉尔市', '3', '47450', 'A');
INSERT INTO `ey_region` VALUES ('47477', '图木舒克市', '3', '47450', 'T');
INSERT INTO `ey_region` VALUES ('47486', '五家渠市', '3', '47450', 'W');
INSERT INTO `ey_region` VALUES ('47493', '台湾省', '1', '0', 'T');
INSERT INTO `ey_region` VALUES ('47494', '香港特别行政区', '1', '0', 'X');
INSERT INTO `ey_region` VALUES ('47495', '澳门特别行政区', '1', '0', 'A');
INSERT INTO `ey_region` VALUES ('47496', '龙华新区', '3', '28558', 'L');
INSERT INTO `ey_region` VALUES ('47497', '光明新区', '3', '28558', 'G');
INSERT INTO `ey_region` VALUES ('47500', '新界', '2', '47494', 'X');
INSERT INTO `ey_region` VALUES ('47501', '观塘区', '3', '47498', 'G');
INSERT INTO `ey_region` VALUES ('47502', '黄大仙区', '3', '47498', 'H');
INSERT INTO `ey_region` VALUES ('47503', '九龙城区', '3', '47498', 'J');
INSERT INTO `ey_region` VALUES ('47504', '深水埗区', '3', '47498', 'S');
INSERT INTO `ey_region` VALUES ('47505', '油尖旺区', '3', '47498', 'Y');
INSERT INTO `ey_region` VALUES ('47506', '东区', '3', '47499', 'D');
INSERT INTO `ey_region` VALUES ('47507', '南区', '3', '47499', 'N');
INSERT INTO `ey_region` VALUES ('47508', '湾仔', '3', '47499', 'W');
INSERT INTO `ey_region` VALUES ('47509', '中西区', '3', '47499', 'Z');
INSERT INTO `ey_region` VALUES ('47510', '北区', '3', '47500', 'B');
INSERT INTO `ey_region` VALUES ('47511', '大埔区', '3', '47500', 'D');
INSERT INTO `ey_region` VALUES ('47512', '葵青区', '3', '47500', 'K');
INSERT INTO `ey_region` VALUES ('47513', '离岛区', '3', '47500', 'L');
INSERT INTO `ey_region` VALUES ('47514', '荃湾区', '3', '47500', 'Q');
INSERT INTO `ey_region` VALUES ('47515', '沙田区', '3', '47500', 'S');
INSERT INTO `ey_region` VALUES ('47516', '屯门区', '3', '47500', 'T');
INSERT INTO `ey_region` VALUES ('47517', '西贡区', '3', '47500', 'X');
INSERT INTO `ey_region` VALUES ('47518', '元朗区', '3', '47500', 'Y');
INSERT INTO `ey_region` VALUES ('47519', '澳门半岛', '2', '47495', 'A');
INSERT INTO `ey_region` VALUES ('47520', '离岛', '2', '47495', 'L');
INSERT INTO `ey_region` VALUES ('47521', '大堂区', '3', '47519', 'D');
INSERT INTO `ey_region` VALUES ('47522', '风顺堂区', '3', '47519', 'F');
INSERT INTO `ey_region` VALUES ('47523', '花地玛堂区', '3', '47519', 'H');
INSERT INTO `ey_region` VALUES ('47524', '花王堂区', '3', '47519', 'H');
INSERT INTO `ey_region` VALUES ('47525', '望德堂区', '3', '47519', 'W');
INSERT INTO `ey_region` VALUES ('47526', '嘉模堂区', '3', '47520', 'J');
INSERT INTO `ey_region` VALUES ('47527', '路氹填海区', '3', '47520', 'L');
INSERT INTO `ey_region` VALUES ('47528', '圣方济各堂区', '3', '47520', 'S');
INSERT INTO `ey_region` VALUES ('47529', '高雄市', '2', '47493', 'G');
INSERT INTO `ey_region` VALUES ('47530', '花莲县', '2', '47493', 'H');
INSERT INTO `ey_region` VALUES ('47531', '基隆市', '2', '47493', 'J');
INSERT INTO `ey_region` VALUES ('47532', '嘉义市', '2', '47493', 'J');
INSERT INTO `ey_region` VALUES ('47533', '嘉义县', '2', '47493', 'J');
INSERT INTO `ey_region` VALUES ('47534', '金门县', '2', '47493', 'J');
INSERT INTO `ey_region` VALUES ('47535', '连江县', '2', '47493', 'L');
INSERT INTO `ey_region` VALUES ('47536', '苗栗县', '2', '47493', 'M');
INSERT INTO `ey_region` VALUES ('47537', '南投县', '2', '47493', 'N');
INSERT INTO `ey_region` VALUES ('47538', '澎湖县', '2', '47493', 'P');
INSERT INTO `ey_region` VALUES ('47539', '屏东县', '2', '47493', 'P');
INSERT INTO `ey_region` VALUES ('47540', '台北市', '2', '47493', 'T');
INSERT INTO `ey_region` VALUES ('47541', '台东县', '2', '47493', 'T');
INSERT INTO `ey_region` VALUES ('47542', '台南市', '2', '47493', 'T');
INSERT INTO `ey_region` VALUES ('47543', '台中市', '2', '47493', 'T');
INSERT INTO `ey_region` VALUES ('47544', '桃园市', '2', '47493', 'T');
INSERT INTO `ey_region` VALUES ('47545', '新北市', '2', '47493', 'X');
INSERT INTO `ey_region` VALUES ('47546', '新竹市', '2', '47493', 'X');
INSERT INTO `ey_region` VALUES ('47547', '新竹县', '2', '47493', 'X');
INSERT INTO `ey_region` VALUES ('47548', '宜兰县', '2', '47493', 'Y');
INSERT INTO `ey_region` VALUES ('47549', '云林县', '2', '47493', 'Y');
INSERT INTO `ey_region` VALUES ('47550', '彰化县', '2', '47493', 'Z');
INSERT INTO `ey_region` VALUES ('47551', '阿莲区', '3', '47529', 'A');
INSERT INTO `ey_region` VALUES ('47552', '大寮区', '3', '47529', 'D');
INSERT INTO `ey_region` VALUES ('47553', '大社区', '3', '47529', 'D');
INSERT INTO `ey_region` VALUES ('47554', '大树区', '3', '47529', 'D');
INSERT INTO `ey_region` VALUES ('47555', '凤山区', '3', '47529', 'F');
INSERT INTO `ey_region` VALUES ('47556', '冈山区', '3', '47529', 'G');
INSERT INTO `ey_region` VALUES ('47557', '鼓山区', '3', '47529', 'G');
INSERT INTO `ey_region` VALUES ('47558', '湖内区', '3', '47529', 'H');
INSERT INTO `ey_region` VALUES ('47559', '甲仙区', '3', '47529', 'J');
INSERT INTO `ey_region` VALUES ('47560', '林园区', '3', '47529', 'L');
INSERT INTO `ey_region` VALUES ('47561', '苓雅区', '3', '47529', 'L');
INSERT INTO `ey_region` VALUES ('47562', '六龟区', '3', '47529', 'L');
INSERT INTO `ey_region` VALUES ('47563', '路竹区', '3', '47529', 'L');
INSERT INTO `ey_region` VALUES ('47564', '茂林区', '3', '47529', 'M');
INSERT INTO `ey_region` VALUES ('47565', '美浓区', '3', '47529', 'M');
INSERT INTO `ey_region` VALUES ('47566', '弥陀区', '3', '47529', 'M');
INSERT INTO `ey_region` VALUES ('47567', '楠梓区', '3', '47529', 'N');
INSERT INTO `ey_region` VALUES ('47568', '那玛夏区', '3', '47529', 'N');
INSERT INTO `ey_region` VALUES ('47569', '内门区', '3', '47529', 'N');
INSERT INTO `ey_region` VALUES ('47570', '鸟松区', '3', '47529', 'N');
INSERT INTO `ey_region` VALUES ('47571', '旗津区', '3', '47529', 'Q');
INSERT INTO `ey_region` VALUES ('47572', '旗门区', '3', '47529', 'Q');
INSERT INTO `ey_region` VALUES ('47573', '其它区', '3', '47529', 'Q');
INSERT INTO `ey_region` VALUES ('47574', '前金区', '3', '47529', 'Q');
INSERT INTO `ey_region` VALUES ('47575', '前镇区', '3', '47529', 'Q');
INSERT INTO `ey_region` VALUES ('47576', '桥头区', '3', '47529', 'Q');
INSERT INTO `ey_region` VALUES ('47577', '茄萣区', '3', '47529', 'Q');
INSERT INTO `ey_region` VALUES ('47578', '芩雅区', '3', '47529', 'Q');
INSERT INTO `ey_region` VALUES ('47579', '仁武区', '3', '47529', 'R');
INSERT INTO `ey_region` VALUES ('47580', '三民区', '3', '47529', 'S');
INSERT INTO `ey_region` VALUES ('47581', '杉林区', '3', '47529', 'S');
INSERT INTO `ey_region` VALUES ('47582', '桃源区', '3', '47529', 'T');
INSERT INTO `ey_region` VALUES ('47583', '田寮区', '3', '47529', 'T');
INSERT INTO `ey_region` VALUES ('47584', '小港区', '3', '47529', 'X');
INSERT INTO `ey_region` VALUES ('47585', '新兴区', '3', '47529', 'X');
INSERT INTO `ey_region` VALUES ('47586', '燕巢区', '3', '47529', 'Y');
INSERT INTO `ey_region` VALUES ('47587', '盐埕区', '3', '47529', 'Y');
INSERT INTO `ey_region` VALUES ('47588', '永安区', '3', '47529', 'Y');
INSERT INTO `ey_region` VALUES ('47589', '梓官区', '3', '47529', 'Z');
INSERT INTO `ey_region` VALUES ('47590', '左营区', '3', '47529', 'Z');
INSERT INTO `ey_region` VALUES ('47591', '丰滨乡', '3', '47530', 'F');
INSERT INTO `ey_region` VALUES ('47592', '凤林镇', '3', '47530', 'F');
INSERT INTO `ey_region` VALUES ('47593', '富里乡', '3', '47530', 'F');
INSERT INTO `ey_region` VALUES ('47594', '光复乡', '3', '47530', 'G');
INSERT INTO `ey_region` VALUES ('47595', '花莲市', '3', '47530', 'H');
INSERT INTO `ey_region` VALUES ('47596', '吉安乡', '3', '47530', 'J');
INSERT INTO `ey_region` VALUES ('47597', '瑞穗乡', '3', '47530', 'R');
INSERT INTO `ey_region` VALUES ('47598', '寿丰乡', '3', '47530', 'S');
INSERT INTO `ey_region` VALUES ('47599', '太鲁阁', '3', '47530', 'T');
INSERT INTO `ey_region` VALUES ('47600', '万荣乡', '3', '47530', 'W');
INSERT INTO `ey_region` VALUES ('47601', '新城乡', '3', '47530', 'X');
INSERT INTO `ey_region` VALUES ('47602', '秀林乡', '3', '47530', 'X');
INSERT INTO `ey_region` VALUES ('47603', '玉里镇', '3', '47530', 'Y');
INSERT INTO `ey_region` VALUES ('47604', '卓溪乡', '3', '47530', 'Z');
INSERT INTO `ey_region` VALUES ('47605', '安乐区', '3', '47531', 'A');
INSERT INTO `ey_region` VALUES ('47606', '暖暖区', '3', '47531', 'N');
INSERT INTO `ey_region` VALUES ('47607', '七堵区', '3', '47531', 'Q');
INSERT INTO `ey_region` VALUES ('47608', '其它区', '3', '47531', 'Q');
INSERT INTO `ey_region` VALUES ('47609', '仁爱区', '3', '47531', 'R');
INSERT INTO `ey_region` VALUES ('47610', '信义区', '3', '47531', 'X');
INSERT INTO `ey_region` VALUES ('47611', '中山区', '3', '47531', 'Z');
INSERT INTO `ey_region` VALUES ('47612', '中正区', '3', '47531', 'Z');
INSERT INTO `ey_region` VALUES ('47613', '东区', '3', '47532', 'D');
INSERT INTO `ey_region` VALUES ('47614', '西区', '3', '47532', 'X');
INSERT INTO `ey_region` VALUES ('47615', '其它区', '3', '47532', 'Q');
INSERT INTO `ey_region` VALUES ('47616', '阿里山乡', '3', '47533', 'A');
INSERT INTO `ey_region` VALUES ('47617', '布袋镇', '3', '47533', 'B');
INSERT INTO `ey_region` VALUES ('47618', '大林镇', '3', '47533', 'D');
INSERT INTO `ey_region` VALUES ('47619', '大埔乡', '3', '47533', 'D');
INSERT INTO `ey_region` VALUES ('47620', '东石乡', '3', '47533', 'D');
INSERT INTO `ey_region` VALUES ('47621', '番路乡', '3', '47533', 'F');
INSERT INTO `ey_region` VALUES ('47622', '六脚乡', '3', '47533', 'L');
INSERT INTO `ey_region` VALUES ('47623', '鹿草乡', '3', '47533', 'L');
INSERT INTO `ey_region` VALUES ('47624', '梅山乡', '3', '47533', 'M');
INSERT INTO `ey_region` VALUES ('47625', '民雄乡', '3', '47533', 'M');
INSERT INTO `ey_region` VALUES ('47626', '朴子市', '3', '47533', 'P');
INSERT INTO `ey_region` VALUES ('47627', '水上乡', '3', '47533', 'S');
INSERT INTO `ey_region` VALUES ('47628', '太保市', '3', '47533', 'T');
INSERT INTO `ey_region` VALUES ('47629', '溪口乡', '3', '47533', 'X');
INSERT INTO `ey_region` VALUES ('47630', '新港乡', '3', '47533', 'X');
INSERT INTO `ey_region` VALUES ('47631', '义竹乡', '3', '47533', 'Y');
INSERT INTO `ey_region` VALUES ('47632', '中埔乡', '3', '47533', 'Z');
INSERT INTO `ey_region` VALUES ('47633', '竹崎乡', '3', '47533', 'Z');
INSERT INTO `ey_region` VALUES ('47634', '金城镇', '3', '47534', 'J');
INSERT INTO `ey_region` VALUES ('47635', '金湖镇', '3', '47534', 'J');
INSERT INTO `ey_region` VALUES ('47636', '金宁乡', '3', '47534', 'J');
INSERT INTO `ey_region` VALUES ('47637', '金沙镇', '3', '47534', 'J');
INSERT INTO `ey_region` VALUES ('47638', '烈屿乡', '3', '47534', 'L');
INSERT INTO `ey_region` VALUES ('47639', '乌邱乡', '3', '47534', 'W');
INSERT INTO `ey_region` VALUES ('47640', '北竿乡', '3', '47535', 'B');
INSERT INTO `ey_region` VALUES ('47641', '东引乡', '3', '47535', 'D');
INSERT INTO `ey_region` VALUES ('47642', '莒光乡', '3', '47535', 'J');
INSERT INTO `ey_region` VALUES ('47643', '南竿乡', '3', '47535', 'N');
INSERT INTO `ey_region` VALUES ('47644', '大湖乡', '3', '47536', 'D');
INSERT INTO `ey_region` VALUES ('47645', '公馆乡', '3', '47536', 'G');
INSERT INTO `ey_region` VALUES ('47646', '后龙镇', '3', '47536', 'H');
INSERT INTO `ey_region` VALUES ('47647', '苗栗市', '3', '47536', 'M');
INSERT INTO `ey_region` VALUES ('47648', '南庄乡', '3', '47536', 'N');
INSERT INTO `ey_region` VALUES ('47649', '三湾乡', '3', '47536', 'S');
INSERT INTO `ey_region` VALUES ('47650', '三义乡', '3', '47536', 'S');
INSERT INTO `ey_region` VALUES ('47651', '狮潭乡', '3', '47536', 'S');
INSERT INTO `ey_region` VALUES ('47652', '泰安乡', '3', '47536', 'T');
INSERT INTO `ey_region` VALUES ('47653', '铜锣乡', '3', '47536', 'T');
INSERT INTO `ey_region` VALUES ('47654', '通宵镇', '3', '47536', 'T');
INSERT INTO `ey_region` VALUES ('47655', '头份镇', '3', '47536', 'T');
INSERT INTO `ey_region` VALUES ('47656', '头屋乡', '3', '47536', 'T');
INSERT INTO `ey_region` VALUES ('47657', '西湖乡', '3', '47536', 'X');
INSERT INTO `ey_region` VALUES ('47658', '苑里镇', '3', '47536', 'Y');
INSERT INTO `ey_region` VALUES ('47659', '造桥乡', '3', '47536', 'Z');
INSERT INTO `ey_region` VALUES ('47660', '竹南镇', '3', '47536', 'Z');
INSERT INTO `ey_region` VALUES ('47661', '卓兰镇', '3', '47536', 'Z');
INSERT INTO `ey_region` VALUES ('47662', '草屯镇', '3', '47537', 'C');
INSERT INTO `ey_region` VALUES ('47663', '国姓乡', '3', '47537', 'G');
INSERT INTO `ey_region` VALUES ('47664', '集集镇', '3', '47537', 'J');
INSERT INTO `ey_region` VALUES ('47665', '鹿谷乡', '3', '47537', 'L');
INSERT INTO `ey_region` VALUES ('47666', '名间乡', '3', '47537', 'M');
INSERT INTO `ey_region` VALUES ('47667', '南投市', '3', '47537', 'N');
INSERT INTO `ey_region` VALUES ('47668', '埔里镇', '3', '47537', 'P');
INSERT INTO `ey_region` VALUES ('47669', '仁爱乡', '3', '47537', 'R');
INSERT INTO `ey_region` VALUES ('47670', '水里乡', '3', '47537', 'S');
INSERT INTO `ey_region` VALUES ('47671', '信义乡', '3', '47537', 'X');
INSERT INTO `ey_region` VALUES ('47672', '鱼池乡', '3', '47537', 'Y');
INSERT INTO `ey_region` VALUES ('47673', '中寮乡', '3', '47537', 'Z');
INSERT INTO `ey_region` VALUES ('47674', '竹山镇', '3', '47537', 'Z');
INSERT INTO `ey_region` VALUES ('47675', '白沙乡', '3', '47538', 'B');
INSERT INTO `ey_region` VALUES ('47676', '湖西乡', '3', '47538', 'H');
INSERT INTO `ey_region` VALUES ('47677', '马公市', '3', '47538', 'M');
INSERT INTO `ey_region` VALUES ('47678', '七美乡', '3', '47538', 'Q');
INSERT INTO `ey_region` VALUES ('47679', '望安乡', '3', '47538', 'W');
INSERT INTO `ey_region` VALUES ('47680', '西屿乡', '3', '47538', 'X');
INSERT INTO `ey_region` VALUES ('47681', '长治乡', '3', '47539', 'C');
INSERT INTO `ey_region` VALUES ('47682', '潮州镇', '3', '47539', 'C');
INSERT INTO `ey_region` VALUES ('47683', '车城乡', '3', '47539', 'C');
INSERT INTO `ey_region` VALUES ('47684', '春日乡', '3', '47539', 'C');
INSERT INTO `ey_region` VALUES ('47685', '东港镇', '3', '47539', 'D');
INSERT INTO `ey_region` VALUES ('47686', '枋寮乡', '3', '47539', 'F');
INSERT INTO `ey_region` VALUES ('47687', '枋山乡', '3', '47539', 'F');
INSERT INTO `ey_region` VALUES ('47688', '高树乡', '3', '47539', 'G');
INSERT INTO `ey_region` VALUES ('47689', '恒春镇', '3', '47539', 'H');
INSERT INTO `ey_region` VALUES ('47690', '佳冬乡', '3', '47539', 'J');
INSERT INTO `ey_region` VALUES ('47691', '九如乡', '3', '47539', 'J');
INSERT INTO `ey_region` VALUES ('47692', '崁顶乡', '3', '47539', 'K');
INSERT INTO `ey_region` VALUES ('47693', '来义乡', '3', '47539', 'L');
INSERT INTO `ey_region` VALUES ('47694', '里港乡', '3', '47539', 'L');
INSERT INTO `ey_region` VALUES ('47695', '林边乡', '3', '47539', 'L');
INSERT INTO `ey_region` VALUES ('47696', '麟洛乡', '3', '47539', 'L');
INSERT INTO `ey_region` VALUES ('47697', '琉球乡', '3', '47539', 'L');
INSERT INTO `ey_region` VALUES ('47698', '玛家乡', '3', '47539', 'M');
INSERT INTO `ey_region` VALUES ('47699', '满州乡', '3', '47539', 'M');
INSERT INTO `ey_region` VALUES ('47700', '牡丹乡', '3', '47539', 'M');
INSERT INTO `ey_region` VALUES ('47701', '南州乡', '3', '47539', 'N');
INSERT INTO `ey_region` VALUES ('47702', '内埔乡', '3', '47539', 'N');
INSERT INTO `ey_region` VALUES ('47703', '屏东市', '3', '47539', 'P');
INSERT INTO `ey_region` VALUES ('47704', '三地门乡', '3', '47539', 'S');
INSERT INTO `ey_region` VALUES ('47705', '狮子乡', '3', '47539', 'S');
INSERT INTO `ey_region` VALUES ('47706', '泰武乡', '3', '47539', 'T');
INSERT INTO `ey_region` VALUES ('47707', '万丹乡', '3', '47539', 'W');
INSERT INTO `ey_region` VALUES ('47708', '万峦乡', '3', '47539', 'W');
INSERT INTO `ey_region` VALUES ('47709', '雾台乡', '3', '47539', 'W');
INSERT INTO `ey_region` VALUES ('47710', '新埤乡', '3', '47539', 'X');
INSERT INTO `ey_region` VALUES ('47711', '新园乡', '3', '47539', 'X');
INSERT INTO `ey_region` VALUES ('47712', '盐埔乡', '3', '47539', 'Y');
INSERT INTO `ey_region` VALUES ('47713', '竹田乡', '3', '47539', 'Z');
INSERT INTO `ey_region` VALUES ('47714', '北投区', '3', '47540', 'B');
INSERT INTO `ey_region` VALUES ('47715', '大安区', '3', '47540', 'D');
INSERT INTO `ey_region` VALUES ('47716', '大同区', '3', '47540', 'D');
INSERT INTO `ey_region` VALUES ('47717', '南港区', '3', '47540', 'N');
INSERT INTO `ey_region` VALUES ('47718', '内湖区', '3', '47540', 'N');
INSERT INTO `ey_region` VALUES ('47719', '士林区', '3', '47540', 'S');
INSERT INTO `ey_region` VALUES ('47720', '松山区', '3', '47540', 'S');
INSERT INTO `ey_region` VALUES ('47721', '万华区', '3', '47540', 'W');
INSERT INTO `ey_region` VALUES ('47722', '文山区', '3', '47540', 'W');
INSERT INTO `ey_region` VALUES ('47723', '信义区', '3', '47540', 'X');
INSERT INTO `ey_region` VALUES ('47724', '中山区', '3', '47540', 'Z');
INSERT INTO `ey_region` VALUES ('47725', '中正区', '3', '47540', 'Z');
INSERT INTO `ey_region` VALUES ('47726', '其它区', '3', '47540', 'Q');
INSERT INTO `ey_region` VALUES ('47727', '卑南乡', '3', '47541', 'B');
INSERT INTO `ey_region` VALUES ('47728', '长滨乡', '3', '47541', 'C');
INSERT INTO `ey_region` VALUES ('47729', '成功镇', '3', '47541', 'C');
INSERT INTO `ey_region` VALUES ('47730', '池上乡', '3', '47541', 'C');
INSERT INTO `ey_region` VALUES ('47731', '达仁乡', '3', '47541', 'D');
INSERT INTO `ey_region` VALUES ('47732', '大武乡', '3', '47541', 'D');
INSERT INTO `ey_region` VALUES ('47733', '东河乡', '3', '47541', 'D');
INSERT INTO `ey_region` VALUES ('47734', '关山镇', '3', '47541', 'G');
INSERT INTO `ey_region` VALUES ('47735', '海端乡', '3', '47541', 'H');
INSERT INTO `ey_region` VALUES ('47736', '金峰乡', '3', '47541', 'J');
INSERT INTO `ey_region` VALUES ('47737', '兰屿乡', '3', '47541', 'L');
INSERT INTO `ey_region` VALUES ('47738', '鹿野乡', '3', '47541', 'L');
INSERT INTO `ey_region` VALUES ('47739', '绿岛乡', '3', '47541', 'L');
INSERT INTO `ey_region` VALUES ('47740', '台东市', '3', '47541', 'T');
INSERT INTO `ey_region` VALUES ('47741', '太麻里乡', '3', '47541', 'T');
INSERT INTO `ey_region` VALUES ('47742', '延平乡', '3', '47541', 'Y');
INSERT INTO `ey_region` VALUES ('47743', '中西区', '3', '47542', 'Z');
INSERT INTO `ey_region` VALUES ('47744', '东区', '3', '47542', 'D');
INSERT INTO `ey_region` VALUES ('47745', '南区', '3', '47542', 'N');
INSERT INTO `ey_region` VALUES ('47746', '北区', '3', '47542', 'B');
INSERT INTO `ey_region` VALUES ('47747', '安平区', '3', '47542', 'A');
INSERT INTO `ey_region` VALUES ('47748', '安南区', '3', '47542', 'A');
INSERT INTO `ey_region` VALUES ('47749', '其它区', '3', '47542', 'Q');
INSERT INTO `ey_region` VALUES ('47750', '永康区', '3', '47542', 'Y');
INSERT INTO `ey_region` VALUES ('47751', '归仁区', '3', '47542', 'G');
INSERT INTO `ey_region` VALUES ('47752', '新化区', '3', '47542', 'X');
INSERT INTO `ey_region` VALUES ('47753', '左镇区', '3', '47542', 'Z');
INSERT INTO `ey_region` VALUES ('47754', '玉井区', '3', '47542', 'Y');
INSERT INTO `ey_region` VALUES ('47755', '楠西区', '3', '47542', 'N');
INSERT INTO `ey_region` VALUES ('47756', '南化区', '3', '47542', 'N');
INSERT INTO `ey_region` VALUES ('47757', '仁德区', '3', '47542', 'R');
INSERT INTO `ey_region` VALUES ('47758', '关庙区', '3', '47542', 'G');
INSERT INTO `ey_region` VALUES ('47759', '龙崎区', '3', '47542', 'L');
INSERT INTO `ey_region` VALUES ('47760', '官田区', '3', '47542', 'G');
INSERT INTO `ey_region` VALUES ('47761', '麻豆区', '3', '47542', 'M');
INSERT INTO `ey_region` VALUES ('47762', '佳里区', '3', '47542', 'J');
INSERT INTO `ey_region` VALUES ('47763', '西港区', '3', '47542', 'X');
INSERT INTO `ey_region` VALUES ('47764', '七股区', '3', '47542', 'Q');
INSERT INTO `ey_region` VALUES ('47765', '将军区', '3', '47542', 'J');
INSERT INTO `ey_region` VALUES ('47766', '学甲区', '3', '47542', 'X');
INSERT INTO `ey_region` VALUES ('47767', '北门区', '3', '47542', 'B');
INSERT INTO `ey_region` VALUES ('47768', '新营区', '3', '47542', 'X');
INSERT INTO `ey_region` VALUES ('47769', '后壁区', '3', '47542', 'H');
INSERT INTO `ey_region` VALUES ('47770', '白河区', '3', '47542', 'B');
INSERT INTO `ey_region` VALUES ('47771', '东山区', '3', '47542', 'D');
INSERT INTO `ey_region` VALUES ('47772', '六甲区', '3', '47542', 'L');
INSERT INTO `ey_region` VALUES ('47773', '下营区', '3', '47542', 'X');
INSERT INTO `ey_region` VALUES ('47774', '柳营区', '3', '47542', 'L');
INSERT INTO `ey_region` VALUES ('47775', '盐水区', '3', '47542', 'Y');
INSERT INTO `ey_region` VALUES ('47776', '善化区', '3', '47542', 'S');
INSERT INTO `ey_region` VALUES ('47777', '大内区', '3', '47542', 'D');
INSERT INTO `ey_region` VALUES ('47778', '山上区', '3', '47542', 'S');
INSERT INTO `ey_region` VALUES ('47779', '新市区', '3', '47542', 'X');
INSERT INTO `ey_region` VALUES ('47780', '安定区', '3', '47542', 'A');
INSERT INTO `ey_region` VALUES ('47781', '中区', '3', '47543', 'Z');
INSERT INTO `ey_region` VALUES ('47782', '东区', '3', '47543', 'D');
INSERT INTO `ey_region` VALUES ('47783', '南区', '3', '47543', 'N');
INSERT INTO `ey_region` VALUES ('47784', '西区', '3', '47543', 'X');
INSERT INTO `ey_region` VALUES ('47785', '北区', '3', '47543', 'B');
INSERT INTO `ey_region` VALUES ('47786', '北屯区', '3', '47543', 'B');
INSERT INTO `ey_region` VALUES ('47787', '西屯区', '3', '47543', 'X');
INSERT INTO `ey_region` VALUES ('47788', '南屯区', '3', '47543', 'N');
INSERT INTO `ey_region` VALUES ('47789', '其它区', '3', '47543', 'Q');
INSERT INTO `ey_region` VALUES ('47790', '太平区', '3', '47543', 'T');
INSERT INTO `ey_region` VALUES ('47791', '大里区', '3', '47543', 'D');
INSERT INTO `ey_region` VALUES ('47792', '雾峰区', '3', '47543', 'W');
INSERT INTO `ey_region` VALUES ('47793', '乌日区', '3', '47543', 'W');
INSERT INTO `ey_region` VALUES ('47794', '丰原区', '3', '47543', 'F');
INSERT INTO `ey_region` VALUES ('47795', '后里区', '3', '47543', 'H');
INSERT INTO `ey_region` VALUES ('47796', '石冈区', '3', '47543', 'S');
INSERT INTO `ey_region` VALUES ('47797', '东势区', '3', '47543', 'D');
INSERT INTO `ey_region` VALUES ('47798', '和平区', '3', '47543', 'H');
INSERT INTO `ey_region` VALUES ('47799', '新社区', '3', '47543', 'X');
INSERT INTO `ey_region` VALUES ('47800', '潭子区', '3', '47543', 'T');
INSERT INTO `ey_region` VALUES ('47801', '大雅区', '3', '47543', 'D');
INSERT INTO `ey_region` VALUES ('47802', '神冈区', '3', '47543', 'S');
INSERT INTO `ey_region` VALUES ('47803', '大肚区', '3', '47543', 'D');
INSERT INTO `ey_region` VALUES ('47804', '沙鹿区', '3', '47543', 'S');
INSERT INTO `ey_region` VALUES ('47805', '龙井区', '3', '47543', 'L');
INSERT INTO `ey_region` VALUES ('47806', '梧栖区', '3', '47543', 'W');
INSERT INTO `ey_region` VALUES ('47807', '清水区', '3', '47543', 'Q');
INSERT INTO `ey_region` VALUES ('47808', '大甲区', '3', '47543', 'D');
INSERT INTO `ey_region` VALUES ('47809', '外埔区', '3', '47543', 'W');
INSERT INTO `ey_region` VALUES ('47810', '大安区', '3', '47543', 'D');
INSERT INTO `ey_region` VALUES ('47811', '中坜区', '3', '47544', 'Z');
INSERT INTO `ey_region` VALUES ('47812', '平镇区', '3', '47544', 'P');
INSERT INTO `ey_region` VALUES ('47813', '龙潭区', '3', '47544', 'L');
INSERT INTO `ey_region` VALUES ('47814', '杨梅区', '3', '47544', 'Y');
INSERT INTO `ey_region` VALUES ('47815', '新屋区', '3', '47544', 'X');
INSERT INTO `ey_region` VALUES ('47816', '观音区', '3', '47544', 'G');
INSERT INTO `ey_region` VALUES ('47817', '桃园区', '3', '47544', 'T');
INSERT INTO `ey_region` VALUES ('47818', '龟山区', '3', '47544', 'G');
INSERT INTO `ey_region` VALUES ('47819', '八德区', '3', '47544', 'B');
INSERT INTO `ey_region` VALUES ('47820', '大溪区', '3', '47544', 'D');
INSERT INTO `ey_region` VALUES ('47821', '复兴区', '3', '47544', 'F');
INSERT INTO `ey_region` VALUES ('47822', '大园区', '3', '47544', 'D');
INSERT INTO `ey_region` VALUES ('47823', '芦竹区', '3', '47544', 'L');
INSERT INTO `ey_region` VALUES ('47824', '万里区', '3', '47545', 'W');
INSERT INTO `ey_region` VALUES ('47825', '金山区', '3', '47545', 'J');
INSERT INTO `ey_region` VALUES ('47826', '板桥区', '3', '47545', 'B');
INSERT INTO `ey_region` VALUES ('47827', '汐止区', '3', '47545', 'X');
INSERT INTO `ey_region` VALUES ('47828', '深坑区', '3', '47545', 'S');
INSERT INTO `ey_region` VALUES ('47829', '石碇区', '3', '47545', 'S');
INSERT INTO `ey_region` VALUES ('47830', '瑞芳区', '3', '47545', 'R');
INSERT INTO `ey_region` VALUES ('47831', '平溪区', '3', '47545', 'P');
INSERT INTO `ey_region` VALUES ('47832', '双溪区', '3', '47545', 'S');
INSERT INTO `ey_region` VALUES ('47833', '贡寮区', '3', '47545', 'G');
INSERT INTO `ey_region` VALUES ('47834', '新店区', '3', '47545', 'X');
INSERT INTO `ey_region` VALUES ('47835', '坪林区', '3', '47545', 'P');
INSERT INTO `ey_region` VALUES ('47836', '乌来区', '3', '47545', 'W');
INSERT INTO `ey_region` VALUES ('47837', '永和区', '3', '47545', 'Y');
INSERT INTO `ey_region` VALUES ('47838', '中和区', '3', '47545', 'Z');
INSERT INTO `ey_region` VALUES ('47839', '土城区', '3', '47545', 'T');
INSERT INTO `ey_region` VALUES ('47840', '三峡区', '3', '47545', 'S');
INSERT INTO `ey_region` VALUES ('47841', '树林区', '3', '47545', 'S');
INSERT INTO `ey_region` VALUES ('47842', '莺歌区', '3', '47545', 'Y');
INSERT INTO `ey_region` VALUES ('47843', '三重区', '3', '47545', 'S');
INSERT INTO `ey_region` VALUES ('47844', '新庄区', '3', '47545', 'X');
INSERT INTO `ey_region` VALUES ('47845', '泰山区', '3', '47545', 'T');
INSERT INTO `ey_region` VALUES ('47846', '林口区', '3', '47545', 'L');
INSERT INTO `ey_region` VALUES ('47847', '芦洲区', '3', '47545', 'L');
INSERT INTO `ey_region` VALUES ('47848', '五股区', '3', '47545', 'W');
INSERT INTO `ey_region` VALUES ('47849', '八里区', '3', '47545', 'B');
INSERT INTO `ey_region` VALUES ('47850', '淡水区', '3', '47545', 'D');
INSERT INTO `ey_region` VALUES ('47851', '三芝区', '3', '47545', 'S');
INSERT INTO `ey_region` VALUES ('47852', '石门区', '3', '47545', 'S');
INSERT INTO `ey_region` VALUES ('47853', '东区', '3', '47546', 'D');
INSERT INTO `ey_region` VALUES ('47854', '北区', '3', '47546', 'B');
INSERT INTO `ey_region` VALUES ('47855', '香山区', '3', '47546', 'X');
INSERT INTO `ey_region` VALUES ('47856', '其它区', '3', '47546', 'Q');
INSERT INTO `ey_region` VALUES ('47857', '竹北市', '3', '47547', 'Z');
INSERT INTO `ey_region` VALUES ('47858', '湖口乡', '3', '47547', 'H');
INSERT INTO `ey_region` VALUES ('47859', '新丰乡', '3', '47547', 'X');
INSERT INTO `ey_region` VALUES ('47860', '新埔镇', '3', '47547', 'X');
INSERT INTO `ey_region` VALUES ('47861', '关西镇', '3', '47547', 'G');
INSERT INTO `ey_region` VALUES ('47862', '芎林乡', '3', '47547', 'X');
INSERT INTO `ey_region` VALUES ('47863', '宝山乡', '3', '47547', 'B');
INSERT INTO `ey_region` VALUES ('47864', '竹东镇', '3', '47547', 'Z');
INSERT INTO `ey_region` VALUES ('47865', '五峰乡', '3', '47547', 'W');
INSERT INTO `ey_region` VALUES ('47866', '横山乡', '3', '47547', 'H');
INSERT INTO `ey_region` VALUES ('47867', '尖石乡', '3', '47547', 'J');
INSERT INTO `ey_region` VALUES ('47868', '北埔乡', '3', '47547', 'B');
INSERT INTO `ey_region` VALUES ('47869', '峨眉乡', '3', '47547', 'E');
INSERT INTO `ey_region` VALUES ('47870', '宜兰市', '3', '47548', 'Y');
INSERT INTO `ey_region` VALUES ('47871', '头城镇', '3', '47548', 'T');
INSERT INTO `ey_region` VALUES ('47872', '礁溪乡', '3', '47548', 'J');
INSERT INTO `ey_region` VALUES ('47873', '壮围乡', '3', '47548', 'Z');
INSERT INTO `ey_region` VALUES ('47874', '员山乡', '3', '47548', 'Y');
INSERT INTO `ey_region` VALUES ('47875', '罗东镇', '3', '47548', 'L');
INSERT INTO `ey_region` VALUES ('47876', '三星乡', '3', '47548', 'S');
INSERT INTO `ey_region` VALUES ('47877', '大同乡', '3', '47548', 'D');
INSERT INTO `ey_region` VALUES ('47878', '五结乡', '3', '47548', 'W');
INSERT INTO `ey_region` VALUES ('47879', '冬山乡', '3', '47548', 'D');
INSERT INTO `ey_region` VALUES ('47880', '苏澳镇', '3', '47548', 'S');
INSERT INTO `ey_region` VALUES ('47881', '南澳乡', '3', '47548', 'N');
INSERT INTO `ey_region` VALUES ('47882', '钓鱼台', '3', '47548', 'D');
INSERT INTO `ey_region` VALUES ('47883', '斗南镇', '3', '47549', 'D');
INSERT INTO `ey_region` VALUES ('47884', '大埤乡', '3', '47549', 'D');
INSERT INTO `ey_region` VALUES ('47885', '虎尾镇', '3', '47549', 'H');
INSERT INTO `ey_region` VALUES ('47886', '土库镇', '3', '47549', 'T');
INSERT INTO `ey_region` VALUES ('47887', '褒忠乡', '3', '47549', 'B');
INSERT INTO `ey_region` VALUES ('47888', '东势乡', '3', '47549', 'D');
INSERT INTO `ey_region` VALUES ('47889', '台西乡', '3', '47549', 'T');
INSERT INTO `ey_region` VALUES ('47890', '仑背乡', '3', '47549', 'L');
INSERT INTO `ey_region` VALUES ('47891', '麦寮乡', '3', '47549', 'M');
INSERT INTO `ey_region` VALUES ('47892', '斗六市', '3', '47549', 'D');
INSERT INTO `ey_region` VALUES ('47893', '林内乡', '3', '47549', 'L');
INSERT INTO `ey_region` VALUES ('47894', '古坑乡', '3', '47549', 'G');
INSERT INTO `ey_region` VALUES ('47895', '莿桐乡', '3', '47549', 'C');
INSERT INTO `ey_region` VALUES ('47896', '西螺镇', '3', '47549', 'X');
INSERT INTO `ey_region` VALUES ('47897', '二仑乡', '3', '47549', 'E');
INSERT INTO `ey_region` VALUES ('47898', '北港镇', '3', '47549', 'B');
INSERT INTO `ey_region` VALUES ('47899', '水林乡', '3', '47549', 'S');
INSERT INTO `ey_region` VALUES ('47900', '口湖乡', '3', '47549', 'K');
INSERT INTO `ey_region` VALUES ('47901', '四湖乡', '3', '47549', 'S');
INSERT INTO `ey_region` VALUES ('47902', '元长乡', '3', '47549', 'Y');
INSERT INTO `ey_region` VALUES ('47903', '彰化市', '3', '47550', 'Z');
INSERT INTO `ey_region` VALUES ('47904', '芬园乡', '3', '47550', 'F');
INSERT INTO `ey_region` VALUES ('47905', '花坛乡', '3', '47550', 'H');
INSERT INTO `ey_region` VALUES ('47906', '秀水乡', '3', '47550', 'X');
INSERT INTO `ey_region` VALUES ('47907', '鹿港镇', '3', '47550', 'L');
INSERT INTO `ey_region` VALUES ('47908', '福兴乡', '3', '47550', 'F');
INSERT INTO `ey_region` VALUES ('47909', '线西乡', '3', '47550', 'X');
INSERT INTO `ey_region` VALUES ('47910', '和美镇', '3', '47550', 'H');
INSERT INTO `ey_region` VALUES ('47911', '伸港乡', '3', '47550', 'S');
INSERT INTO `ey_region` VALUES ('47912', '员林镇', '3', '47550', 'Y');
INSERT INTO `ey_region` VALUES ('47913', '社头乡', '3', '47550', 'S');
INSERT INTO `ey_region` VALUES ('47914', '永靖乡', '3', '47550', 'Y');
INSERT INTO `ey_region` VALUES ('47915', '埔心乡', '3', '47550', 'P');
INSERT INTO `ey_region` VALUES ('47916', '溪湖镇', '3', '47550', 'X');
INSERT INTO `ey_region` VALUES ('47917', '大村乡', '3', '47550', 'D');
INSERT INTO `ey_region` VALUES ('47918', '埔盐乡', '3', '47550', 'P');
INSERT INTO `ey_region` VALUES ('47919', '田中镇', '3', '47550', 'T');
INSERT INTO `ey_region` VALUES ('47920', '北斗镇', '3', '47550', 'B');
INSERT INTO `ey_region` VALUES ('47921', '田尾乡', '3', '47550', 'T');
INSERT INTO `ey_region` VALUES ('47922', '埤头乡', '3', '47550', 'P');
INSERT INTO `ey_region` VALUES ('47923', '溪州乡', '3', '47550', 'X');
INSERT INTO `ey_region` VALUES ('47924', '竹塘乡', '3', '47550', 'Z');
INSERT INTO `ey_region` VALUES ('47925', '二林镇', '3', '47550', 'E');
INSERT INTO `ey_region` VALUES ('47926', '大城乡', '3', '47550', 'D');
INSERT INTO `ey_region` VALUES ('47927', '芳苑乡', '3', '47550', 'F');
INSERT INTO `ey_region` VALUES ('47928', '二水乡', '3', '47550', 'E');
INSERT INTO `ey_region` VALUES ('47929', '莲池区', '3', '1772', 'L');
INSERT INTO `ey_region` VALUES ('47930', '竞秀区', '3', '1772', 'J');
INSERT INTO `ey_region` VALUES ('47931', '常平镇', '3', '29855', 'C');
INSERT INTO `ey_region` VALUES ('47932', '茶山镇', '3', '29855', 'C');
INSERT INTO `ey_region` VALUES ('47933', '大朗镇', '3', '29855', 'D');
INSERT INTO `ey_region` VALUES ('47934', '大岭山镇', '3', '29855', 'D');
INSERT INTO `ey_region` VALUES ('47935', '道滘镇', '3', '29855', 'D');
INSERT INTO `ey_region` VALUES ('47936', '东城街道', '3', '29855', 'D');
INSERT INTO `ey_region` VALUES ('47937', '东坑镇', '3', '29855', 'D');
INSERT INTO `ey_region` VALUES ('47938', '凤岗镇', '3', '29855', 'F');
INSERT INTO `ey_region` VALUES ('47939', '高埗镇', '3', '29855', 'G');
INSERT INTO `ey_region` VALUES ('47940', '莞城街道', '3', '29855', 'G');
INSERT INTO `ey_region` VALUES ('47941', '横沥镇', '3', '29855', 'H');
INSERT INTO `ey_region` VALUES ('47942', '洪梅镇', '3', '29855', 'H');
INSERT INTO `ey_region` VALUES ('47943', '厚街镇', '3', '29855', 'H');
INSERT INTO `ey_region` VALUES ('47944', '黄江镇', '3', '29855', 'H');
INSERT INTO `ey_region` VALUES ('47945', '虎门镇', '3', '29855', 'H');
INSERT INTO `ey_region` VALUES ('47946', '寮步镇', '3', '29855', 'L');
INSERT INTO `ey_region` VALUES ('47947', '麻涌镇', '3', '29855', 'M');
INSERT INTO `ey_region` VALUES ('47948', '南城街道', '3', '29855', 'N');
INSERT INTO `ey_region` VALUES ('47949', '桥头镇', '3', '29855', 'Q');
INSERT INTO `ey_region` VALUES ('47950', '清溪镇', '3', '29855', 'Q');
INSERT INTO `ey_region` VALUES ('47951', '企石镇', '3', '29855', 'Q');
INSERT INTO `ey_region` VALUES ('47952', '沙田镇', '3', '29855', 'S');
INSERT INTO `ey_region` VALUES ('47953', '石碣镇', '3', '29855', 'S');
INSERT INTO `ey_region` VALUES ('47954', '石龙镇', '3', '29855', 'S');
INSERT INTO `ey_region` VALUES ('47955', '石排镇', '3', '29855', 'S');
INSERT INTO `ey_region` VALUES ('47956', '松山湖管委会', '3', '29855', 'S');
INSERT INTO `ey_region` VALUES ('47957', '塘厦镇', '3', '29855', 'T');
INSERT INTO `ey_region` VALUES ('47958', '望牛墩镇', '3', '29855', 'W');
INSERT INTO `ey_region` VALUES ('47959', '万江街道', '3', '29855', 'W');
INSERT INTO `ey_region` VALUES ('47960', '谢岗镇', '3', '29855', 'X');
INSERT INTO `ey_region` VALUES ('47961', '长安镇', '3', '29855', 'Z');
INSERT INTO `ey_region` VALUES ('47962', '樟木头镇', '3', '29855', 'Z');
INSERT INTO `ey_region` VALUES ('47963', '中堂镇', '3', '29855', 'Z');
INSERT INTO `ey_region` VALUES ('47964', '海外', '1', '0', 'H');
INSERT INTO `ey_region` VALUES ('47965', '海外', '2', '47964', 'H');
INSERT INTO `ey_region` VALUES ('47966', '海外', '3', '47965', 'H');

-- -----------------------------
-- Table structure for `ey_search_locking`
-- -----------------------------
DROP TABLE IF EXISTS `ey_search_locking`;
CREATE TABLE `ey_search_locking` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `users_id` int(10) DEFAULT '0' COMMENT '用户ID',
  `ip` varchar(20) DEFAULT '' COMMENT 'ip',
  `locking_time` int(11) DEFAULT '0' COMMENT '锁定时间',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='搜索记录锁定表';


-- -----------------------------
-- Table structure for `ey_search_word`
-- -----------------------------
DROP TABLE IF EXISTS `ey_search_word`;
CREATE TABLE `ey_search_word` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `word` varchar(255) DEFAULT '' COMMENT '关键词',
  `searchNum` int(10) DEFAULT '1' COMMENT '搜索次数',
  `resultNum` int(10) DEFAULT '0' COMMENT '搜索结果数量',
  `sort_order` int(10) DEFAULT '0' COMMENT '排序号',
  `users_id` int(11) DEFAULT '0' COMMENT '用户id',
  `ip` varchar(20) DEFAULT '' COMMENT 'ip',
  `lang` varchar(30) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `word` (`word`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COMMENT='搜索词统计表';


-- -----------------------------
-- Table structure for `ey_setting`
-- -----------------------------
DROP TABLE IF EXISTS `ey_setting`;
CREATE TABLE `ey_setting` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT '' COMMENT '配置的key键名',
  `value` text,
  `inc_type` varchar(64) DEFAULT '' COMMENT '配置分组',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `inc_type` (`inc_type`,`lang`)
) ENGINE=MyISAM AUTO_INCREMENT=49 DEFAULT CHARSET=utf8 COMMENT='系统非全局配置表';

-- -----------------------------
-- Records of `ey_setting`
-- -----------------------------
INSERT INTO `ey_setting` VALUES ('1', 'ask_ques_steps', '1、写问题标题，描述具体现象。杜绝 “求救，大佬，小白…” 等和问题无关的词汇。\r\n2、选择问题的分类，选择正确的内容分类，能更快的得到其他人的回复。\r\n3、遇到的问题比较急需解决，可以给问题悬赏一定的金额报酬，能让更多同行参与进来出谋策划，从中选择自己心仪的答案。\r\n4、写问题内容详细描述你碰到的困难，写清楚你尝试了什么方法，错误代码，软件的版本等，更容易得到答案。\r\n5、点击发布。', 'ask', 'cn', '1623814141');
INSERT INTO `ey_setting` VALUES ('2', 'system_old_product_attr', '0', 'system', 'cn', '1634095663');
INSERT INTO `ey_setting` VALUES ('3', 'syn_admin_logic_1623377269', '1', 'syn', 'cn', '1634095663');
INSERT INTO `ey_setting` VALUES ('4', 'syn_admin_logic_1625725290', '1', 'syn', 'cn', '1634095663');
INSERT INTO `ey_setting` VALUES ('5', 'syn_admin_logic_1629252424', '1', 'syn', 'cn', '1634095663');
INSERT INTO `ey_setting` VALUES ('6', 'admin_logic_1634204189', '1', 'syn', 'cn', '1641347463');
INSERT INTO `ey_setting` VALUES ('7', 'admin_logic_1634280892', '1', 'syn', 'cn', '1641347463');
INSERT INTO `ey_setting` VALUES ('8', 'admin_logic_1635326854', '1', 'syn', 'cn', '1641347463');
INSERT INTO `ey_setting` VALUES ('9', 'admin_logic_1635389623', '1', 'syn', 'cn', '1641347463');
INSERT INTO `ey_setting` VALUES ('10', 'admin_logic_1636875693', '1', 'syn', 'cn', '1641347514');
INSERT INTO `ey_setting` VALUES ('11', 'admin_logic_1637033990', '1', 'syn', 'cn', '1641347514');
INSERT INTO `ey_setting` VALUES ('12', 'admin_logic_1640918327', '1', 'syn', 'cn', '1641347514');
INSERT INTO `ey_setting` VALUES ('13', 'admin_logic_1638857408', '1', 'syn', 'cn', '1641347514');
INSERT INTO `ey_setting` VALUES ('14', 'dedetoeyou_del_all', '1', 'dedetoeyou', 'cn', '1641347759');
INSERT INTO `ey_setting` VALUES ('15', 'system_codelogic_1638857408', '9c9fBQIBB1IGBQYFAVMEUwIHAgFZBVBRDVZVAVRoEFZWAAd0ZGR/N0F7ZGBgaHYxRzAvdG4xdzJPbHN6W3ljNgQ5YmBjVnE6YHBlcmRVcSx2EiNxUz1nMQhSb3EGfWQgBCFUcXRzYCZ0VnFwAFl1PAE7PGF9CHo8bUZ2fWF2diZnCH5wc2dTOnMEZmR3a1EydhIzYmkhfiBPYHR+YWFoJVlWVG0DCXA0UXhkcmNodiEADi59VB5jFg1HYEtnAXVbHhp3BVNhURJsfntfa19hV3kEKFt1N3kRWX5/UG5nZVBHFVJYa2VgVEJ6cU9tHkIsQlUgU1QHVzZTAmB9XQtiAgEzfFBafAA1XwFbe1gHXDN0UC52exx0IXpjQFxiZgMucyZfenpaRyNwcGRlc3QOAnYNIlNrD0kxYHNEWmZEBjRwJgRjcXdPLXAFUXhiYEM3cw0pcnwOBSdvY2Z+VWFnOXMPandnZ20qbgVnDXBGDyVmUC1Qegt+U1JRY1BdekcuHipZTUR3DwZjQlJQdndTAmIwVBdl', 'system', 'cn', '1641347879');
INSERT INTO `ey_setting` VALUES ('16', 'recycle_switch', '1', 'recycle', 'cn', '1641347890');
INSERT INTO `ey_setting` VALUES ('17', 'adminlogin_427d1aac31a93d744edd637f1fbbf00c', '0', 'adminlogin', 'cn', '1684114837');
INSERT INTO `ey_setting` VALUES ('18', 'adminlogin_a62896d354440964bb1db242596917b1', '0', 'adminlogin', 'cn', '1684114837');
INSERT INTO `ey_setting` VALUES ('19', 'adminlogin_99ae1cc546e0ed202a83693c75f1afe0', '0', 'adminlogin', 'cn', '1684114837');
INSERT INTO `ey_setting` VALUES ('20', 'admin_logic_1649299958', '1', 'syn', 'cn', '1684114839');
INSERT INTO `ey_setting` VALUES ('21', 'admin_logic_1643352860', '2', 'syn', 'cn', '1684114839');
INSERT INTO `ey_setting` VALUES ('22', 'admin_logic_1643352862', '1', 'syn', 'cn', '1684114839');
INSERT INTO `ey_setting` VALUES ('23', 'admin_logic_1643352863', '1', 'syn', 'cn', '1684114839');
INSERT INTO `ey_setting` VALUES ('24', 'security_askanswer_list', '[\"\\u60a8\\u5e38\\u7528\\u7684\\u624b\\u673a\\u53f7\\u7801\\u662f\\uff1f\",\"\\u60a8\\u5e38\\u7528\\u7684\\u7535\\u5b50\\u90ae\\u7bb1\\u662f\\uff1f\",\"\\u60a8\\u771f\\u5b9e\\u7684\\u59d3\\u540d\\u662f\\uff1f\",\"\\u60a8\\u521d\\u4e2d\\u5b66\\u6821\\u540d\\u662f\\uff1f\",\"\\u60a8\\u7684\\u51fa\\u751f\\u5730\\u540d\\u662f\\uff1f\",\"\\u60a8\\u914d\\u5076\\u7684\\u59d3\\u540d\\u662f\\uff1f\",\"\\u60a8\\u7684\\u8eab\\u4efd\\u8bc1\\u53f7\\u540e\\u516b\\u4f4d\\u662f\\uff1f\",\"\\u60a8\\u9ad8\\u4e2d\\u73ed\\u4e3b\\u4efb\\u7684\\u540d\\u5b57\\u662f\\uff1f\",\"\\u60a8\\u521d\\u4e2d\\u73ed\\u4e3b\\u4efb\\u7684\\u540d\\u5b57\\u662f\\uff1f\",\"\\u60a8\\u6700\\u559c\\u6b22\\u7684\\u660e\\u661f\\u540d\\u5b57\\u662f\\uff1f\",\"\\u5bf9\\u60a8\\u5f71\\u54cd\\u6700\\u5927\\u7684\\u4eba\\u540d\\u5b57\\u662f\\uff1f\"]', 'security', 'cn', '1684114839');
INSERT INTO `ey_setting` VALUES ('25', 'admin_logic_1643352864', '1', 'syn', 'cn', '1684114839');
INSERT INTO `ey_setting` VALUES ('26', 'admin_logic_1647918733', '1', 'syn', 'cn', '1684114839');
INSERT INTO `ey_setting` VALUES ('27', 'system_originlist', '[\"\\u7f51\\u7edc\"]', 'system', 'cn', '1684114839');
INSERT INTO `ey_setting` VALUES ('28', 'admin_logic_1648435161', '1', 'syn', 'cn', '1684114839');
INSERT INTO `ey_setting` VALUES ('29', 'admin_logic_1648882158', '1', 'syn', 'cn', '1684114839');
INSERT INTO `ey_setting` VALUES ('30', 'admin_logic_1649399344', '1', 'syn', 'cn', '1684114839');
INSERT INTO `ey_setting` VALUES ('31', 'syn_admin_logic_1616123194', '1', 'syn', 'cn', '1684114839');
INSERT INTO `ey_setting` VALUES ('32', 'admin_logic_1655453263', '1', 'syn', 'cn', '1684114879');
INSERT INTO `ey_setting` VALUES ('33', 'admin_logic_1652254594', '1', 'syn', 'cn', '1684114879');
INSERT INTO `ey_setting` VALUES ('34', 'designated_column_1657069673', '1', 'syn', 'cn', '1684114879');
INSERT INTO `ey_setting` VALUES ('35', 'admin_logic_1652771782', '1', 'syn', 'cn', '1684114879');
INSERT INTO `ey_setting` VALUES ('36', 'admin_logic_1667210674', '1', 'syn', 'cn', '1684114879');
INSERT INTO `ey_setting` VALUES ('37', 'syn_admin_logic_1616123195', '1', 'syn', 'cn', '1684114880');
INSERT INTO `ey_setting` VALUES ('38', 'admin_logic_1651114275', '1', 'syn', 'cn', '1684114880');
INSERT INTO `ey_setting` VALUES ('39', 'admin_logic_1662518904', '1', 'syn', 'cn', '1684114881');
INSERT INTO `ey_setting` VALUES ('40', 'admin_logic_1667357946', '1', 'syn', 'cn', '1684114881');
INSERT INTO `ey_setting` VALUES ('41', 'admin_logic_1663290997', '1', 'syn', 'cn', '1684114881');
INSERT INTO `ey_setting` VALUES ('42', 'syn_admin_logic_1660557712', '1', 'syn', 'cn', '1684114882');
INSERT INTO `ey_setting` VALUES ('43', 'admin_logic_1673941712', '1', 'syn', 'cn', '1684114896');
INSERT INTO `ey_setting` VALUES ('44', 'admin_logic_1676854942', '1', 'syn', 'cn', '1684114896');
INSERT INTO `ey_setting` VALUES ('45', 'admin_logic_1675243579', '1', 'syn', 'cn', '1684114896');
INSERT INTO `ey_setting` VALUES ('46', 'admin_logic_1677555001', '1', 'syn', 'cn', '1684114896');
INSERT INTO `ey_setting` VALUES ('47', 'admin_logic_1678762367', '1', 'syn', 'cn', '1684114896');
INSERT INTO `ey_setting` VALUES ('48', 'admin_logic_1680749290', '1', 'syn', 'cn', '1684114897');

-- -----------------------------
-- Table structure for `ey_sharp_active`
-- -----------------------------
DROP TABLE IF EXISTS `ey_sharp_active`;
CREATE TABLE `ey_sharp_active` (
  `active_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '活动会场ID',
  `active_date` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '活动日期',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '活动状态(0禁用 1启用)',
  `is_del` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`active_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='整点秒杀-活动会场表';


-- -----------------------------
-- Table structure for `ey_sharp_active_goods`
-- -----------------------------
DROP TABLE IF EXISTS `ey_sharp_active_goods`;
CREATE TABLE `ey_sharp_active_goods` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `active_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '活动会场ID',
  `active_time_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '活动场次ID',
  `aid` int(11) NOT NULL DEFAULT '0' COMMENT '文档id',
  `sharp_goods_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '秒杀商品ID',
  `sales_actual` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '实际销量',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='整点秒杀-活动会场与商品关联表';


-- -----------------------------
-- Table structure for `ey_sharp_active_time`
-- -----------------------------
DROP TABLE IF EXISTS `ey_sharp_active_time`;
CREATE TABLE `ey_sharp_active_time` (
  `active_time_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '场次ID',
  `active_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '活动会场ID',
  `active_time` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '场次时间(0点-23点)',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '活动状态(0禁用 1启用)',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`active_time_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='整点秒杀-活动会场场次表';


-- -----------------------------
-- Table structure for `ey_sharp_goods`
-- -----------------------------
DROP TABLE IF EXISTS `ey_sharp_goods`;
CREATE TABLE `ey_sharp_goods` (
  `sharp_goods_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '秒杀商品ID',
  `aid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '商品ID->aid',
  `limit` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '限购数量',
  `seckill_stock` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '秒杀商品库存总量',
  `seckill_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '秒杀价格',
  `sales` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '累积销量',
  `virtual_sales` int(11) NOT NULL DEFAULT '0' COMMENT '虚拟销量',
  `sort_order` int(11) unsigned NOT NULL DEFAULT '100' COMMENT '商品排序(数字越小越靠前)',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '商品状态(0下架 1上架)',
  `is_del` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除',
  `is_sku` tinyint(1) NOT NULL DEFAULT '0' COMMENT '1-多规格商品',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`sharp_goods_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='整点秒杀-商品表';


-- -----------------------------
-- Table structure for `ey_sharp_setting`
-- -----------------------------
DROP TABLE IF EXISTS `ey_sharp_setting`;
CREATE TABLE `ey_sharp_setting` (
  `key` varchar(30) NOT NULL DEFAULT '' COMMENT '设置项标示',
  `describe` varchar(255) NOT NULL DEFAULT '' COMMENT '设置项描述',
  `values` mediumtext NOT NULL COMMENT '设置内容(json格式)',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  UNIQUE KEY `unique_key` (`key`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='整点秒杀设置表';


-- -----------------------------
-- Table structure for `ey_shop_address`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_address`;
CREATE TABLE `ey_shop_address` (
  `addr_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '地址id',
  `users_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '会员id',
  `consignee` varchar(60) NOT NULL DEFAULT '' COMMENT '收货人',
  `country` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '国家',
  `province` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '省份',
  `city` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '城市',
  `district` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '县区',
  `address` varchar(500) NOT NULL DEFAULT '' COMMENT '详细地址',
  `zipcode` varchar(10) NOT NULL DEFAULT '' COMMENT '邮政编码',
  `mobile` varchar(20) NOT NULL DEFAULT '' COMMENT '手机',
  `is_default` tinyint(1) DEFAULT '0' COMMENT '是否默认，0否，1是。',
  `lang` varchar(30) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`addr_id`),
  KEY `users_id` (`users_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='收货地址表';


-- -----------------------------
-- Table structure for `ey_shop_cart`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_cart`;
CREATE TABLE `ey_shop_cart` (
  `cart_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '购物车表',
  `users_id` int(10) unsigned DEFAULT '0' COMMENT '会员id',
  `product_id` int(10) unsigned DEFAULT '0' COMMENT '产品id',
  `product_num` int(10) unsigned DEFAULT '0' COMMENT '购买数量',
  `spec_value_id` varchar(100) DEFAULT '' COMMENT '规格值ID',
  `selected` tinyint(1) DEFAULT '1' COMMENT '购物车选中状态：0未选中，1选中',
  `lang` varchar(30) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '加入购物车的时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `discount_active_id` int(11) DEFAULT '0' COMMENT '限时折扣ID,用来区分购物车的商品哪些是限时折扣活动的',
  PRIMARY KEY (`cart_id`),
  KEY `users_id` (`users_id`,`product_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='购物车表';


-- -----------------------------
-- Table structure for `ey_shop_coupon`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_coupon`;
CREATE TABLE `ey_shop_coupon` (
  `coupon_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `coupon_code` varchar(100) NOT NULL DEFAULT '' COMMENT '优惠券编号',
  `coupon_name` varchar(100) NOT NULL DEFAULT '' COMMENT '优惠券名称',
  `coupon_color` varchar(25) NOT NULL DEFAULT '' COMMENT '优惠券颜色',
  `coupon_form` tinyint(1) NOT NULL DEFAULT '1' COMMENT '优惠券类型 1-满减券',
  `coupon_type` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '可使用商品(1全站通用，2指定商品，3指定商品分类)',
  `product_id` varchar(255) NOT NULL DEFAULT '' COMMENT '指定商品ID，在coupon_type=2时使用',
  `arctype_id` varchar(255) NOT NULL DEFAULT '' COMMENT '指定商品分类ID，在coupon_type=3时使用',
  `coupon_price` decimal(10,0) NOT NULL DEFAULT '0' COMMENT '优惠券金额，例如10',
  `conditions_use` decimal(10,0) NOT NULL DEFAULT '0' COMMENT '优惠券使用条件，例如300',
  `coupon_stock` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '优惠券库存，例如100',
  `redeem_points` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '兑换优惠券所需积分，为0则表示免费兑换',
  `redeem_authority` varchar(10) NOT NULL DEFAULT '' COMMENT '兑换权限，存入多个会员等级组ID',
  `valid_days` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '有效天数，例如30',
  `start_date` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '优惠券开放领取时间',
  `end_date` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '优惠券结束领取时间',
  `sort_order` int(11) unsigned NOT NULL DEFAULT '100' COMMENT '规格排序号',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '优惠券状态(0=关闭，1=开启)',
  `use_type` int(1) NOT NULL DEFAULT '1' COMMENT '使用期限 \r\n1-固定日期\r\n 2-领取后当天开始N(valid_days)天内有效\r\n 2-领取后次日开始N(valid_days)天内有效',
  `use_start_time` int(11) NOT NULL COMMENT '使用期限开始时间',
  `use_end_time` int(11) NOT NULL COMMENT '使用期限结束时间',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '0-未删除 1-已删除',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`coupon_id`),
  KEY `product_id` (`product_id`) USING BTREE,
  KEY `arctype_id` (`arctype_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='优惠券主表';


-- -----------------------------
-- Table structure for `ey_shop_coupon_use`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_coupon_use`;
CREATE TABLE `ey_shop_coupon_use` (
  `use_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `users_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `coupon_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '优惠券ID',
  `coupon_code` varchar(100) NOT NULL DEFAULT '' COMMENT '优惠券编号',
  `get_ip` varchar(15) NOT NULL DEFAULT '' COMMENT '领取时的IP地址',
  `get_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '优惠券领取时的时间',
  `use_status` tinyint(4) unsigned NOT NULL DEFAULT '1' COMMENT '优惠券使用状态(0未使用，1已使用，2已过期，3已冻结)',
  `use_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '优惠券使用时的时间',
  `start_time` int(10) NOT NULL DEFAULT '0' COMMENT '优惠券有效开始时间',
  `end_time` int(10) NOT NULL DEFAULT '0' COMMENT '优惠券有效结束时间',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`use_id`),
  KEY `coupon_id` (`coupon_id`) USING BTREE,
  KEY `coupon_code` (`coupon_code`) USING BTREE,
  KEY `users_id` (`users_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='优惠券-领取记录表';


-- -----------------------------
-- Table structure for `ey_shop_express`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_express`;
CREATE TABLE `ey_shop_express` (
  `express_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `express_code` varchar(32) NOT NULL DEFAULT '' COMMENT '物流code',
  `express_name` varchar(32) NOT NULL DEFAULT '' COMMENT '物流名称',
  `express_lnitials` varchar(5) NOT NULL DEFAULT '' COMMENT '首字母',
  `is_choose` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '快递公司是否选中(0=否，1=是)',
  `sort_order` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '排序号',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`express_id`)
) ENGINE=MyISAM AUTO_INCREMENT=599 DEFAULT CHARSET=utf8 COMMENT='快递公司表';

-- -----------------------------
-- Records of `ey_shop_express`
-- -----------------------------
INSERT INTO `ey_shop_express` VALUES ('1', 'yuantong', '圆通快递', 'Y', '1', '97', '1553911076', '1554974797');
INSERT INTO `ey_shop_express` VALUES ('2', 'shentong', '申通快递', 'S', '1', '98', '1553911076', '1554974707');
INSERT INTO `ey_shop_express` VALUES ('3', 'shunfeng', '顺丰快递', 'S', '1', '98', '1553911076', '1554974710');
INSERT INTO `ey_shop_express` VALUES ('4', 'yunda', '韵达快递', 'Y', '1', '99', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('5', 'debangwuliu', '德邦快递', 'D', '1', '99', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('6', 'zhongtong', '中通快递', 'Z', '1', '99', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('7', 'huitongkuaidi', '百世快递', 'B', '1', '99', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('8', 'youzhengguonei', '邮政包裹', 'Y', '1', '99', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('9', 'ems', 'EMS', 'E', '1', '99', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('10', 'youzhengguoji', '邮政国际', 'Y', '1', '99', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('11', 'aolau', 'AOL澳通速递', 'A', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('12', 'a2u', 'A2U速递', 'A', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('13', 'aae', 'AAE快递', 'A', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('14', 'annengwuliu', '安能物流', 'A', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('15', 'anxl', '安迅物流', 'A', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('16', 'auexpress', '澳邮中国快运', 'A', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('17', 'exfresh', '安鲜达', 'A', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('18', 'anjie88', '安捷物流', 'A', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('19', 'adodoxm', '澳多多国际速递', 'A', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('20', 'ariesfar', '艾瑞斯远', 'A', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('21', 'qdants', 'ANTS EXPRESS', 'A', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('22', 'astexpress', '安世通快递', 'A', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('23', 'gda', '安的快递', 'A', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('24', 'ausexpress', '澳世速递', 'A', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('25', 'ibuy8', '爱拜物流', 'A', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('26', 'aplusex', 'Aplus物流', 'A', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('27', 'adapost', '安达速递', 'A', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('28', 'adiexpress', '安达易国际速递', 'A', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('29', 'maxeedexpress', '澳洲迈速快递', 'A', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('30', 'onway', '昂威物流', 'A', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('31', 'bcwelt', 'BCWELT', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('32', 'balunzhi', '巴伦支快递', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('33', 'xiaohongmao', '北青小红帽', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('34', 'bfdf', '百福东方物流', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('35', 'bangsongwuliu', '邦送物流', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('36', 'lbbk', '宝凯物流', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('37', 'bqcwl', '百千诚物流', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('38', 'idada', '百成大达物流', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('39', 'baishiwuliu', '百世快运', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('40', 'baitengwuliu', '百腾物流', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('41', 'birdex', '笨鸟海淘', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('42', 'bsht', '百事亨通', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('43', 'benteng', '奔腾物流', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('44', 'cuckooexpess', '布谷鸟速递', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('45', 'bgky100', '邦工快运', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('46', 'bosind', '堡昕德速递', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('47', 'banma', '斑马物联网', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('48', 'polarisexpress', '北极星快运', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('49', 'beijingfengyue', '北京丰越供应链', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('50', 'europe8', '败欧洲', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('51', 'bmlchina', '标杆物流', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('52', 'comexpress', '邦通国际', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('53', 'baotongkd', '宝通快递', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('54', 'beckygo', '佰麒快递', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('55', 'boyol', '贝业物流', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('56', 'bdatong', '八达通快递', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('57', 'bangbangpost', '帮帮发', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('58', 'baoxianda', '报通快递', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('59', 'coe', '中国东方(COE)', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('60', 'cloudexpress', 'CE易欧通国际速递', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('61', 'city100', '城市100', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('62', 'chuanxiwuliu', '传喜物流', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('63', 'chengjisudi', '城际速递', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('64', 'lijisong', '立即送', 'L', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('65', 'chukou1', '出口易', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('66', 'nanjingshengbang', '晟邦物流', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('67', 'flyway', '程光快递', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('68', 'cbo56', '钏博物流', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('69', 'cex', '城铁速递', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('70', 'cnup', 'CNUP 中联邮', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('71', 'clsp', 'CL日中速运', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('72', 'cnair', 'CNAIR', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('73', 'cangspeed', '仓鼠快递', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('74', 'spring56', '春风物流', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('75', 'cunto', '村通快递', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('76', 'longvast', '长风物流', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('77', 'changjiang', '长江国际速递', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('78', 'cncexp', 'C&C国际速递', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('79', 'parcelchina', '诚一物流', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('80', 'chengtong', '城通物流', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('81', 'otpexpress', '承诺达', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('82', 'sfpost', '曹操到', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('83', 'changwooair', '昌宇国际', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('84', 'dhl', 'DHL快递（中国件）', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('85', 'dhlen', 'DHL（国际件）', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('86', 'dhlde', 'DHL（德国件）', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('87', 'dtwl', '大田物流', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('88', 'disifang', '递四方', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('89', 'dayangwuliu', '大洋物流', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('90', 'dechuangwuliu', '德创物流', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('91', 'dskd', 'D速物流', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('92', 'donghanwl', '东瀚物流', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('93', 'dfpost', '达方物流', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('94', 'dongjun', '东骏快捷物流', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('95', 'dindon', '叮咚澳洲转运', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('96', 'dazhong', '大众佐川急便', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('97', 'ahdf', '德方物流', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('98', 'dehaoyi', '德豪驿', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('99', 'dhlpaket', 'DHL Paket', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('100', 'ubuy', '德国优拜物流', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('101', 'adlerlogi', '德国雄鹰速递', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('102', 'yunexpress', '德国云快递', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('103', 'di5pll', '递五方云仓', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('104', 'deguo8elog', '德国八易转运', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('105', 'camekong', '到了港', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('106', 'dbstation', 'db-station', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('107', 'dadaoex', '大道物流', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('108', 'dekuncn', '德坤物流', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('109', 'twkd56', '缔惠盛合', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('110', 'gslexpress', '德尚国际速递', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('111', 'eucpost', '德国 EUC POST', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('112', 'est365', '东方汇', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('113', 'ecotransite', '东西E全运', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('114', 'euexpress', 'EU-EXPRESS', 'E', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('115', 'emsguoji', 'EMS国际快递查询', 'E', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('116', 'eshunda', '俄顺达', 'E', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('117', 'ewe', 'EWE全球快递', 'E', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('118', 'easyexpress', 'EASYEXPRESS国际速递', 'E', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('119', 'edtexpress', 'e直运', 'E', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('120', 'ecallturn', 'E跨通', 'E', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('121', 'fedex', 'FedEx快递查询', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('122', 'fedexus', 'FedEx（美国）', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('123', 'fox', 'FOX国际速递', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('124', 'rufengda', '如风达快递', 'R', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('125', 'fkd', '飞康达物流', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('126', 'feibaokuaidi', '飞豹快递', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('127', 'fandaguoji', '颿达国际', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('128', 'feiyuanvipshop', '飞远配送', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('129', 'hnfy', '飞鹰物流', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('130', 'fengxingtianxia', '风行天下', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('131', 'flysman', '飞力士物流', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('132', 'fbkd', '飞邦快递', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('133', 'sccod', '丰程物流', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('134', 'crazyexpress', '疯狂快递', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('135', 'ftlexpress', '法翔速运', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('136', 'ftd', '富腾达快递', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('137', 'arkexpress', '方舟国际速递', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('138', 'fedroad', 'FedRoad 联邦转运', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('139', 'freakyquick', 'FQ狂派速递', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('140', 'fecobv', '丰客物流', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('141', 'fyex', '飞云快递系统', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('142', 'beebird', '锋鸟物流', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('143', 'shipgce', '飞洋快递', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('144', 'koali', '番薯国际货运', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('145', 'epanex', '泛捷国际速递', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('146', 'gaticn', 'GATI快递', 'G', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('147', 'gts', 'GTS快递', 'G', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('148', 'guotongkuaidi', '国通快递', 'G', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('149', 'ndkd', '能达速递', 'N', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('150', 'gongsuda', '共速达', 'G', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('151', 'gtongsudi', '广通速递（山东）', 'G', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('152', 'suteng', '速腾物流', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('153', 'gdkd', '港快速递', 'G', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('154', 'hre', '高铁速递', 'G', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('155', 'gscq365', '哥士传奇速递', 'G', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('156', 'gjwl', '冠捷物流', 'G', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('157', 'xdshipping', '国晶物流', 'G', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('158', 'ge2d', 'GE2D跨境物流', 'G', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('159', 'gaotieex', '高铁快运', 'G', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('160', 'gansuandi', '甘肃安的快递', 'G', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('161', 'gdct56', '广东诚通物流', 'G', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('162', 'ghtexpress', 'GHT物流', 'G', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('163', 'goldjet', '高捷快运', 'G', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('164', 'gtgogo', 'GT国际快运', 'G', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('165', 'gxwl', '光线速递', 'G', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('166', 'tdhy', '华宇物流', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('167', 'hl', '恒路物流', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('168', 'hlyex', '好来运快递', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('169', 'hebeijianhua', '河北建华', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('170', 'huaqikuaiyun', '华企快运', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('171', 'haosheng', '昊盛物流', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('172', 'hutongwuliu', '户通物流', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('173', 'hzpl', '华航快递', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('174', 'huangmajia', '黄马甲快递', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('175', 'ucs', '合众速递（UCS）', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('176', 'pfcexpress', '皇家物流', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('177', 'huoban', '伙伴物流', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('178', 'nedahm', '红马速递', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('179', 'huiwen', '汇文配送', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('180', 'nmhuahe', '华赫物流', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('181', 'hjs', '猴急送', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('182', 'hangyu', '航宇快递', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('183', 'huilian', '辉联物流', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('184', 'huanqiu', '环球速运', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('185', 'htwd', '华通务达物流', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('186', 'hipito', '海派通', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('187', 'hqtd', '环球通达', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('188', 'airgtc', '航空快递', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('189', 'haoyoukuai', '好又快物流', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('190', 'ccd', '河南次晨达', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('191', 'hfwuxi', '和丰同城', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('192', 'higo', '黑狗物流', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('193', 'hyytes', '恒宇运通', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('194', 'hengrui56', '恒瑞物流', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('195', 'hangrui', '上海航瑞货运', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('196', 'ghl', '环创物流', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('197', 'hnqst', '河南全速通', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('198', 'hitaoe', 'Hi淘易快递', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('199', 'hhair56', '华瀚快递', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('200', 'haimibuy', '海米派物流', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('201', 'ht22', '海淘物流', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('202', 'hivewms', '海沧无忧', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('203', 'hnht56', '鸿泰物流', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('204', 'hsgtsd', '海硕高铁速递', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('205', 'hltop', '海联快递', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('206', 'hlkytj', '互联快运', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('207', 'haidaibao', '海带宝转运', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('208', 'flowerkd', '花瓣转运', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('209', 'heimao56', '黑猫速运', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('210', 'logistics', '華信物流WTO', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('211', 'hgy56', '环国运物流', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('212', 'iparcel', 'i-parcel', 'I', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('213', 'jjwl', '佳吉物流', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('214', 'jywl', '佳怡物流', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('215', 'jymwl', '加运美快递', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('216', 'jxd', '急先达物流', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('217', 'jgsd', '京广速递快件', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('218', 'jykd', '晋越快递', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('219', 'jd', '京东物流', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('220', 'jietekuaidi', '捷特快递', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('221', 'jiuyicn', '久易快递', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('222', 'jiuyescm', '九曳供应链', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('223', 'junfengguoji', '骏丰国际速递', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('224', 'jiajiatong56', '佳家通', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('225', 'jrypex', '吉日优派', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('226', 'jinchengwuliu', '锦程国际物流', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('227', 'jgwl', '景光物流', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('228', 'pzhjst', '急顺通', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('229', 'ruexp', '捷网俄全通', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('230', 'jialidatong', '嘉里大通', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('231', 'jmjss', '金马甲', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('232', 'jiacheng', '佳成快递', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('233', 'jsexpress', '骏绅物流', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('234', 'hrex', '锦程快递', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('235', 'jieanda', '捷安达国际速递', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('236', 'newsway', '家家通快递', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('237', 'mapleexpress', '今枫国际快运', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('238', 'jixiangyouau', '吉祥邮（澳洲）', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('239', 'jjx888', '佳捷翔物流', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('240', 'polarexpress', '极地快递', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('241', 'jiazhoumao', '加州猫速递', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('242', 'juzhongda', '聚中大', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('243', 'jieborne', '捷邦物流', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('244', 'jxfex', '集先锋速递', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('245', 'jiugong', '九宫物流', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('246', 'jiujiuwl', '久久物流', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('247', 'jintongkd', '劲通快递', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('248', 'jcsuda', '嘉诚速达', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('249', 'jingshun', '景顺物流', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('250', 'fastontime', '加拿大联通快运', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('251', 'khzto', '柬埔寨中通', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('252', 'kjkd', '快捷快递', 'K', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('253', 'kangliwuliu', '康力物流', 'K', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('254', 'kuayue', '跨越速运', 'K', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('255', 'kuaiyouda', '快优达速递', 'K', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('256', 'happylink', '开心快递', 'K', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('257', 'ksudi', '快速递', 'K', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('258', 'kyue', '跨跃国际', 'K', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('259', 'kfwnet', '快服务', 'K', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('260', 'kuai8', '快8速运', 'K', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('261', 'kuaidawuliu', '快达物流', 'K', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('262', 'lianb', '联邦快递（国内）', 'L', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('263', 'lhtwl', '联昊通物流', 'L', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('264', 'lb', '龙邦速递', 'L', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('265', 'lejiedi', '乐捷递', 'L', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('266', 'lanhukuaidi', '蓝弧快递', 'L', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('267', 'ltexp', '乐天速递', 'L', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('268', 'lutong', '鲁通快运', 'L', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('269', 'ledii', '乐递供应链', 'L', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('270', 'lundao', '论道国际物流', 'L', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('271', 'lasy56', '林安物流', 'L', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('272', 'lsexpress', '6LS EXPRESS', 'L', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('273', 'szuem', '联运通物流', 'L', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('274', 'blueskyexpress', '蓝天国际航空快递', 'L', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('275', 'lfexpress', '龙枫国际速递', 'L', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('276', 'gslhkd', '联合快递', 'L', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('277', 'longfx', '龙飞祥快递', 'L', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('278', 'luben', '陆本速递 LUBEN EXPRESS', 'L', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('279', 'unitedex', '联合速运', 'L', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('280', 'lbex', '龙邦物流', 'L', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('281', 'ltparcel', '联通快递', 'L', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('282', 'macroexpressco', 'ME物流', 'M', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('283', 'mh', '民航快递', 'M', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('284', 'meiguokuaidi', '美国快递', 'M', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('285', 'menduimen', '门对门', 'M', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('286', 'mingliangwuliu', '明亮物流', 'M', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('287', 'minbangsudi', '民邦速递', 'M', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('288', 'minshengkuaidi', '闽盛快递', 'M', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('289', 'yundaexus', '美国韵达', 'M', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('290', 'mchy', '木春货运', 'M', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('291', 'meiquick', '美快国际物流', 'M', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('292', 'valueway', '美通快递', 'M', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('293', 'cnmcpl', '马珂博逻', 'M', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('294', 'mailongdy', '迈隆递运', 'M', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('295', 'zsmhwl', '明辉物流', 'M', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('296', 'mosuda', '魔速达', 'M', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('297', 'meibang', '美邦国际快递', 'M', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('298', 'nuoyaao', '偌亚奥国际', 'N', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('299', 'nuoer', '诺尔国际物流', 'N', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('300', 'nell', '尼尔快递', 'N', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('301', 'ndwl', '南方传媒物流', 'N', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('302', 'canhold', '能装能送', 'N', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('303', 'wanjiatong', '宁夏万家通', 'N', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('304', 'nlebv', '欧亚专线', 'O', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('305', 'oborexpress', 'OBOR Express', 'O', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('306', 'pcaexpress', 'PCA Express', 'P', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('307', 'pingandatengfei', '平安达腾飞', 'P', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('308', 'peixingwuliu', '陪行物流', 'P', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('309', 'pengyuanexpress', '鹏远国际速递', 'P', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('310', 'postelbe', 'PostElbe', 'P', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('311', 'papascm', '啪啪供应链', 'P', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('312', 'bazirim', '皮牙子快递', 'P', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('313', 'qfkd', '全峰快递', 'Q', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('314', 'qy', '全一快递', 'Q', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('315', 'qrt', '全日通快递', 'Q', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('316', 'qckd', '全晨快递', 'Q', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('317', 'sevendays', '7天连锁物流', 'Q', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('318', 'qbexpress', '秦邦快运', 'Q', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('319', 'quanxintong', '全信通快递', 'Q', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('320', 'quansutong', '全速通国际快递', 'Q', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('321', 'qinyuan', '秦远物流', 'Q', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('322', 'qichen', '启辰国际物流', 'Q', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('323', 'quansu', '全速快运', 'Q', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('324', 'qzx56', '全之鑫物流', 'Q', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('325', 'qskdyxgs', '千顺快递', 'Q', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('326', 'zqlwl', '青旅物流', 'Q', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('327', 'quanchuan56', '全川物流', 'Q', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('328', 'quantwl', '全通快运', 'Q', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('329', 'yatexpress', '乾坤物流', 'Q', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('330', 'guexp', '全联速运', 'Q', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('331', 'bjqywl', '青云物流', 'Q', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('332', 'signedexpress', '签收快递', 'Q', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('333', 'express7th', '7号速递', 'Q', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('334', 'riyuwuliu', '日昱物流', 'R', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('335', 'rfsd', '瑞丰速递', 'R', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('336', 'rrs', '日日顺物流', 'R', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('337', 'rytsd', '日益通速递', 'R', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('338', 'rrskx', '日日顺快线', 'R', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('339', 'gdrz58', '容智快运', 'R', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('340', 'rrthk', '日日通国际', 'R', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('341', 'homecourier', '如家国际快递', 'R', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('342', 'sewl', '速尔快递', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('343', 'haihongwangsong', '山东海红', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('344', 'sh', '盛辉物流', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('345', 'sfwl', '盛丰物流', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('346', 'shiyunkuaidi', '世运快递', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('347', 'shangda', '上大物流', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('348', 'stsd', '三态速递', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('349', 'saiaodi', '赛澳递', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('350', 'ewl', '申通E物流', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('351', 'shenganwuliu', '圣安物流', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('352', 'sxhongmajia', '山西红马甲', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('353', 'suijiawuliu', '穗佳物流', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('354', 'syjiahuier', '沈阳佳惠尔', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('355', 'shlindao', '上海林道货运', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('356', 'sfift', '十方通物流', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('357', 'shunjiefengda', '顺捷丰达', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('358', 'subida', '速必达物流', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('359', 'stcd', '速通成达物流', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('360', 'stkd', '顺通快递', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('361', 'sendtochina', '速递中国', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('362', 'sihaiet', '四海快递', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('363', 'staky', '首通快运', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('364', 'hnssd56', '顺时达物流', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('365', 'superb', 'Superb Grace', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('366', 'sfjhd', '圣飞捷快递', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('367', 'sofast56', '嗖一下同城快递', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('368', 's2c', 'S2C', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('369', 'chinasqk', 'SQK国际速递', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('370', 'shunshid', '顺士达速运', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('371', 'synship', 'SYNSHIP快递', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('372', 'shandiantu', '闪电兔', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('373', 'sdsy888', '首达速运', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('374', 'sczpds', '速呈宅配', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('375', 'sureline', 'Sureline冠泰', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('376', 'stosolution', '申通国际', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('377', 'sycawl', '狮爱高铁物流', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('378', 'sxexpress', '三象速递', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('379', 'shangqiao56', '商桥物流', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('380', 'shd56', '商海德物流', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('381', 'shenma', '神马快递', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('382', 'sihiexpress', '四海捷运', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('383', 'superoz', '速配鸥翼', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('384', 'fastgoexpress', '速派快递', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('385', 'zjstky', '苏通快运', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('386', 'suning', '苏宁物流', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('387', 'shaoke', '捎客物流', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('388', 'sdto', '速达通跨境物流', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('389', 'sut56', '速通物流', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('390', 'sundarexpress', '顺达快递', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('391', 'sxjdfreight', '顺心捷达', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('392', 'shengtongscm', '盛通快递', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('393', 'tnt', 'TNT快递', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('394', 'tt', '天天快递', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('395', 'tianzong', '天纵物流', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('396', 'chinatzx', '同舟行物流', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('397', 'nntengda', '腾达速递', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('398', 'sd138', '泰国138', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('399', 'tongdaxing', '通达兴物流', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('400', 'tlky', '天联快运', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('401', 'ibenben', '途鲜物流', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('402', 'krtao', '淘韩国际快递', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('403', 'lntjs', '特急送', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('404', 'tny', 'TNY物流', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('405', 'djy56', '天翔东捷运', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('406', 'guoeryue', '天天快物流', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('407', 'tianma', '天马迅达', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('408', 'surpassgo', '天越物流', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('409', 'tianxiang', '天翔快递', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('410', 'tywl99', '天翼物流', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('411', 'shpost', '同城快寄', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('412', 'humpline', '驼峰国际', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('413', 'transrush', 'TransRush', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('414', 'tstexp', 'TST速运通', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('415', 'ctoexp', '泰国中通CTO', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('416', 'thaizto', '泰国中通ZTO', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('417', 'tswlcloud', '天使物流云', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('418', 'tzky', '铁中快运', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('419', 'tcxbthai', 'TCXB国际物流', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('420', 'taimek', '天美快递', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('421', 'taoplus', '淘布斯国际物流', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('422', 'ups', 'UPS快递查询', 'U', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('423', 'yskd', '优速快递', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('424', 'usps', 'USPS美国邮政', 'U', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('425', 'ueq', 'UEQ快递', 'U', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('426', 'uex', 'UEX国际物流', 'U', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('427', 'utaoscm', 'UTAO 优到', 'U', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('428', 'wxwl', '万象物流', 'W', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('429', 'weitepai', '微特派', 'W', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('430', 'wjwl', '万家物流', 'W', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('431', 'wanboex', '万博快递', 'W', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('432', 'wtdchina', '威时沛运', 'W', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('433', 'wzhaunyun', '微转运', 'W', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('434', 'gswtkd', '万通快递', 'W', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('435', 'wandougongzhu', '豌豆物流', 'W', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('436', 'wjkwl', '万家康物流', 'W', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('437', 'vps', '维普恩物流', 'W', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('438', 'wykjt', '51跨境通', 'W', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('439', 'wherexpess', '威盛快递', 'W', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('440', 'weilaimingtian', '未来明天快递', 'W', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('441', 'wdm', '万达美', 'W', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('442', 'wto56kj', '温通物流', 'W', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('443', '56kuaiyun', '五六快运', 'W', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('444', 'wowvip', '沃埃家', 'W', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('445', 'grivertek', '潍鸿', 'W', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('446', 'xbwl', '新邦物流', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('447', 'xfwl', '信丰物流', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('448', 'newegg', '新蛋物流', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('449', 'xianglongyuntong', '祥龙运通物流', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('450', 'xianchengliansudi', '西安城联速递', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('451', 'xilaikd', '喜来快递', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('452', 'xsrd', '鑫世锐达', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('453', 'xtb', '鑫通宝物流', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('454', 'xintianjie', '信天捷快递', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('455', 'xaetc', '西安胜峰', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('456', 'xianfeng', '先锋快递', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('457', 'sunspeedy', '新速航', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('458', 'xipost', '西邮寄', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('459', 'sinatone', '信联通', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('460', 'sunjex', '新杰物流', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('461', 'alog', '心怡物流', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('462', 'csxss', '新时速物流', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('463', 'xiangteng', '翔腾物流', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('464', 'westwing', '西翼物流', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('465', 'littlebearbear', '小熊物流', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('466', 'huanqiuabc', '中国香港环球快运', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('467', 'xinning', '新宁物流', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('468', 'wlwex', '星空国际', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('469', 'yyexp', '西安运逸快递', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('470', 'xiyoug', '西游寄', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('471', 'xlobo', 'xLobo', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('472', 'xunsuexpress', '迅速快递', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('473', 'whgjkd', '香港伟豪国际物流', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('474', 'xyd666', '鑫远东速运', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('475', 'xdexpress', '迅达速递', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('476', 'ytkd', '运通快递', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('477', 'ycwl', '远成物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('478', 'yfsd', '亚风速递', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('479', 'yishunhang', '亿顺航', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('480', 'yfwl', '越丰物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('481', 'yad', '源安达快递', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('482', 'yfh', '原飞航物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('483', 'yinjiesudi', '银捷速递', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('484', 'yitongfeihong', '一统飞鸿', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('485', 'yuxinwuliu', '宇鑫物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('486', 'yitongda', '易通达', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('487', 'youbijia', '邮必佳', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('488', 'yiqiguojiwuliu', '一柒物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('489', 'yinsu', '音素快运', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('490', 'yilingsuyun', '亿领速运', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('491', 'yujiawuliu', '煜嘉物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('492', 'gml', '英脉物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('493', 'leopard', '云豹国际货运', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('494', 'czwlyn', '云南中诚', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('495', 'sdyoupei', '优配速运', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('496', 'yongchang', '永昌物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('497', 'yufeng', '御风速运', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('498', 'yousutongda', '优速通达', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('499', 'yongwangda', '永旺达快递', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('500', 'yingchao', '英超物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('501', 'edlogistics', '益递物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('502', 'yjxlm', '宜家行', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('503', 'onehcang', '一号仓', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('504', 'ycgky', '远成快运', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('505', 'yunfeng56', '韵丰物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('506', 'iyoungspeed', '驿扬国际速运', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('507', 'zgyzt', '一站通快递', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('508', 'eupackage', '易优包裹', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('509', 'ydglobe', '云达通', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('510', 'el56', 'YLTD', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('511', 'yundx', '运东西', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('512', 'yangbaoguo', '洋包裹', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('513', 'uluckex', '优联吉运', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('514', 'ecmscn', '易客满', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('515', 'ubonex', '优邦速运', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('516', 'yue777', '玥玛速运', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('517', 'ywexpress', '远为快递', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('518', 'ezhuanyuan', '易转运', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('519', 'yiqisong', '一起送', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('520', 'yongbangwuliu', '永邦国际物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('521', 'yyox', '邮客全球速递', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('522', 'yihangmall', '易航物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('523', 'yiouzhou', '易欧洲国际物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('524', 'ykouan', '洋口岸', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('525', 'youyou', '优优速递', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('526', 'ytky168', '运通快运', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('527', 'sixroad', '易普递', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('528', 'yourscm', '雅澳物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('529', 'euguoji', '易邮国际', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('530', 'uscbexpress', '易境达国际物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('531', 'yfsuyun', '驭丰速运', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('532', 'yimidida', '壹米滴答', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('533', 'ugoexpress', '邮鸽速运', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('534', 'youban', '邮邦国际', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('535', 'hkems', '云邮跨境快递', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('536', 'youlai', '邮来速递', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('537', 'eta100', '易达国际速递', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('538', 'yatfai', '一辉物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('539', 'yzswuliu', '亚洲顺物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('540', 'yifankd', '艺凡快递', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('541', 'mantoo', '优能物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('542', 'vctrans', '越中国际物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('543', 'yhtlogistics', '宇航通物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('544', 'ycgglobal', 'YCG物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('545', 'yidihui', '驿递汇速递', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('546', 'yuanhhk', '远航国际快运', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('547', 'yiyou', '易邮速运', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('548', 'eusacn', '优莎速运', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('549', 'uhi', '优海国际速递', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('550', 'zjs', '宅急送', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('551', 'ztky', '中铁快运', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('552', 'ztwl', '中铁物流', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('553', 'zywl', '中邮物流', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('554', 'zhimakaimen', '芝麻开门', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('555', 'zhengzhoujianhua', '郑州建华', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('556', 'zhongsukuaidi', '中速快件', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('557', 'zhongtianwanyun', '中天万运', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('558', 'zhongruisudi', '中睿速递', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('559', 'zhongwaiyun', '中外运速递', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('560', 'zengyisudi', '增益速递', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('561', 'sujievip', '郑州速捷', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('562', 'ztong', '智通物流', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('563', 'zhichengtongda', '至诚通达快递', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('564', 'zhdwl', '众辉达物流', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('565', 'kuachangwuliu', '直邮易', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('566', 'topspeedex', '中运全速', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('567', 'otobv', '中欧快运', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('568', 'zsky123', '准实快运', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('569', 'cnws', '中国翼', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('570', 'zytdscm', '中宇天地', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('571', 'zhuanyunsifang', '转运四方', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('572', 'hrbzykd', '卓烨快递', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('573', 'zhuoshikuaiyun', '卓实快运', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('574', 'chinaicip', '卓志速运', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('575', 'ynztsy', '纵通速运', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('576', 'zdepost', '直德邮', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('577', 'chinapostcb', '中邮电商', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('578', 'chunghwa56', '中骅物流', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('579', 'cosco', '中远e环球', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('580', 'zf365', '珠峰速运', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('581', 'zhongtongkuaiyun', '中通快运', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('582', 'eucnrail', '中欧国际物流', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('583', 'chnexp', '中翼国际物流', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('584', 'cccc58', '中集冷云', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('585', 'auvanda', '中联速递', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('586', 'zyzoom', '增速跨境', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('587', 'zhpex', '众派速递', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('588', 'byht', '展勤快递', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('589', 'zhongchuan', '众川国际', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('590', 'zhonghuanus', '中环转运', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('591', 'zhonghuan', '中环快递', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('592', 'uszcn', '转运中国', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('593', 'zhitengwuliu', '志腾物流', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('594', 'zsda56', '转瞬达集运', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('595', 'zjgj56', '振捷国际货运', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('596', 'jtexpress', '极兔速递', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('598', 'fengwang', '丰网速运', 'F', '1', '100', '1553911076', '1647484768');

-- -----------------------------
-- Table structure for `ey_shop_order`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_order`;
CREATE TABLE `ey_shop_order` (
  `order_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '订单id',
  `order_code` varchar(50) NOT NULL DEFAULT '' COMMENT '订单编号',
  `users_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '会员id',
  `merchant_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '多商家ID',
  `order_status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '订单状态：0未付款(已下单)，1已付款(待发货)，2已发货(待收货)，3已完成(确认收货)，-1订单取消(已关闭)，4订单过期',
  `payment_method` tinyint(1) DEFAULT '0' COMMENT '订单支付方式，0为在线支付，1为货到付款，默认0',
  `pay_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '支付时间',
  `pay_name` varchar(20) NOT NULL DEFAULT '' COMMENT '支付方式名称',
  `wechat_pay_type` varchar(20) NOT NULL DEFAULT '' COMMENT '微信支付时，标记使用的支付类型（扫码支付，微信内部，微信H5页面）',
  `order_terminal` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '订单终端(1=电脑端、2=手机端、3微信小程序)',
  `contains_virtual` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '订单是否包含虚拟商品(1=不包含、2=包含)',
  `manual_refund` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '订单是否被手动关闭并退款',
  `refund_note` varchar(500) NOT NULL DEFAULT '' COMMENT '订单手动退款原因',
  `pay_details` text COMMENT '支付时返回的数据，以serialize序列化后存入，用于后续查询。',
  `express_order` varchar(50) DEFAULT '' COMMENT '发货物流单号',
  `express_name` varchar(32) DEFAULT '' COMMENT '发货物流名称',
  `express_code` varchar(32) DEFAULT '' COMMENT '发货物流code',
  `express_time` int(11) DEFAULT '0' COMMENT '发货时间',
  `consignee` varchar(30) NOT NULL DEFAULT '' COMMENT '收货人',
  `confirm_time` int(11) DEFAULT '0' COMMENT '收货确认时间',
  `allow_service` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '订单是否允许申请售后维权，0=允许申请维权，1=不允许申请维权',
  `obtain_scores` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '消费获得积分数',
  `is_obtain_scores` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '该订单是否已赠送积分，0=未赠送，1=已赠送',
  `shipping_fee` decimal(10,2) DEFAULT '0.00' COMMENT '订单运费',
  `order_total_amount` decimal(10,2) DEFAULT '0.00' COMMENT '订单总价',
  `order_amount` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '应付款金额',
  `order_total_num` int(10) DEFAULT '0' COMMENT '订单总数',
  `country` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '国家',
  `province` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '省份',
  `city` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '城市',
  `district` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '县区',
  `address` varchar(500) NOT NULL DEFAULT '' COMMENT '收货地址',
  `mobile` varchar(20) DEFAULT '' COMMENT '手机',
  `prom_type` tinyint(1) unsigned DEFAULT '0' COMMENT '订单类型：0普通订单，1虚拟订单',
  `virtual_delivery` text COMMENT '虚拟订单时，卖家发货给买家的回复',
  `admin_note` text COMMENT '管理员操作备注',
  `is_comment` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否已评论，0为否，1为是，默认0',
  `user_note` text COMMENT '会员备注',
  `group` varchar(50) DEFAULT '' COMMENT '订单分组',
  `order_md5` varchar(50) DEFAULT '' COMMENT '订单标识串，删除未付款的重复订单',
  `order_source` tinyint(3) DEFAULT '10' COMMENT '10-普通订单 20-秒杀订单',
  `order_source_id` int(10) DEFAULT '0' COMMENT '来源id(秒杀订单:active_time_id)',
  `lang` varchar(30) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '下单时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  `coupon_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '优惠券数据表ID',
  `use_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '会员的优惠券数据表ID',
  `coupon_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '使用的优惠券金额',
  PRIMARY KEY (`order_id`),
  UNIQUE KEY `order_code` (`order_code`),
  KEY `users_id` (`users_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='订单主表';


-- -----------------------------
-- Table structure for `ey_shop_order_comment`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_order_comment`;
CREATE TABLE `ey_shop_order_comment` (
  `comment_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `users_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `order_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '订单ID',
  `order_code` varchar(50) NOT NULL DEFAULT '' COMMENT '订单编号',
  `details_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '订单明细表ID',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '商品ID',
  `total_score` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '总评分，1：好评，2中评，3差评',
  `content` varchar(1000) NOT NULL DEFAULT '' COMMENT '评论内容',
  `upload_img` varchar(3000) NOT NULL DEFAULT '' COMMENT '晒单图片',
  `admin_reply` varchar(1000) NOT NULL DEFAULT '' COMMENT '管理员回复',
  `ip_address` varchar(15) NOT NULL DEFAULT '' COMMENT 'IP地址',
  `is_show` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否显示：0否，1是',
  `is_anonymous` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否匿名评价：0否，1是',
  `is_new_comment` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否新版评价：0否，1是',
  `lang` varchar(30) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`comment_id`),
  KEY `users_id` (`users_id`),
  KEY `order_id` (`order_id`),
  KEY `details_id` (`details_id`),
  KEY `product_id` (`product_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='商品评价表';


-- -----------------------------
-- Table structure for `ey_shop_order_details`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_order_details`;
CREATE TABLE `ey_shop_order_details` (
  `details_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `order_id` int(10) NOT NULL DEFAULT '0' COMMENT '订单ID',
  `users_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '会员id',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '产品id',
  `product_name` varchar(100) NOT NULL DEFAULT '' COMMENT '产品名称',
  `num` int(10) NOT NULL DEFAULT '0' COMMENT '单个产品数量',
  `data` text COMMENT '序列化额外数据',
  `product_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '产品单价',
  `prom_type` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '产品类型：0普通产品，1虚拟产品',
  `litpic` varchar(500) NOT NULL DEFAULT '' COMMENT '封面图片',
  `apply_service` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否申请退换货服务：0 未申请、1已申请',
  `is_comment` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否已评论，0为否，1为是，默认0',
  `lang` varchar(30) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '下单时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`details_id`),
  KEY `users_id` (`users_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='订单详情表';


-- -----------------------------
-- Table structure for `ey_shop_order_log`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_order_log`;
CREATE TABLE `ey_shop_order_log` (
  `action_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `order_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '订单ID',
  `users_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `action_user` int(10) DEFAULT '0' COMMENT '操作人；0:用户操作；1以上:管理员id',
  `order_status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '订单状态，单条记录状态',
  `express_status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '物流状态，0:未发货，1:已发货',
  `pay_status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '支付状态，0:未支付，1:已支付',
  `action_desc` varchar(255) DEFAULT '' COMMENT '状态描述',
  `action_note` varchar(255) NOT NULL DEFAULT '' COMMENT '操作备注',
  `lang` varchar(30) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  PRIMARY KEY (`action_id`),
  KEY `order_id` (`order_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='订单操作记录表';


-- -----------------------------
-- Table structure for `ey_shop_order_service`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_order_service`;
CREATE TABLE `ey_shop_order_service` (
  `service_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `service_type` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '类型：1换货，2退货，3维修',
  `users_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '会员id',
  `merchant_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '多商家ID',
  `order_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '订单ID',
  `order_code` varchar(50) NOT NULL DEFAULT '' COMMENT '订单编号',
  `details_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '订单明细表ID',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '产品ID',
  `product_name` varchar(200) NOT NULL DEFAULT '' COMMENT '产品名称',
  `product_spec` varchar(200) NOT NULL DEFAULT '' COMMENT '产品规格',
  `product_num` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '产品数量',
  `product_img` varchar(500) NOT NULL DEFAULT '' COMMENT '产品图片',
  `content` varchar(500) NOT NULL DEFAULT '' COMMENT '退换货描述',
  `upload_img` varchar(3000) NOT NULL DEFAULT '' COMMENT '上传的图片',
  `address` varchar(500) NOT NULL DEFAULT '' COMMENT '退货的收货地址',
  `consignee` varchar(30) NOT NULL DEFAULT '' COMMENT '收货人',
  `mobile` varchar(20) NOT NULL DEFAULT '' COMMENT '手机',
  `manual_refund` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '服务单是否被手动关闭并退款',
  `refund_note` varchar(500) NOT NULL DEFAULT '' COMMENT '服务单手动退款原因',
  `refund_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '退还金额',
  `refund_balance` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '退还余额',
  `refund_code` varchar(40) NOT NULL DEFAULT '' COMMENT '退款单号',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态：1审核中 2审核通过 3审核不通过 4已发货 5已收货 6换货完成 7退款完成 8服务取消',
  `users_delivery` varchar(500) NOT NULL DEFAULT '' COMMENT '会员发货信息',
  `admin_delivery` varchar(500) NOT NULL DEFAULT '' COMMENT '管理员发货信息',
  `admin_note` varchar(1000) NOT NULL DEFAULT '' COMMENT '管理员操作备注',
  `lang` varchar(30) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '申请时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`service_id`),
  KEY `users_id` (`users_id`) USING BTREE,
  KEY `order_id` (`order_id`) USING BTREE,
  KEY `order_code` (`order_code`) USING BTREE,
  KEY `product_id` (`product_id`) USING BTREE,
  KEY `details_id` (`details_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='订单退换货服务表';


-- -----------------------------
-- Table structure for `ey_shop_order_service_log`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_order_service_log`;
CREATE TABLE `ey_shop_order_service_log` (
  `log_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `service_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '服务表ID',
  `order_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '订单ID',
  `users_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `admin_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '管理员ID',
  `log_note` varchar(500) NOT NULL DEFAULT '' COMMENT '记录备注',
  `lang` varchar(30) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  PRIMARY KEY (`log_id`),
  KEY `service_id` (`service_id`) USING BTREE,
  KEY `order_id` (`order_id`) USING BTREE,
  KEY `users_id` (`users_id`) USING BTREE,
  KEY `admin_id` (`admin_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='订单退换货服务记录表';


-- -----------------------------
-- Table structure for `ey_shop_order_unified_pay`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_order_unified_pay`;
CREATE TABLE `ey_shop_order_unified_pay` (
  `unified_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '统一支付订单ID',
  `unified_number` varchar(30) NOT NULL DEFAULT '' COMMENT '统一支付订单编号',
  `unified_amount` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '统一支付订单应付款金额',
  `users_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `order_ids` text NOT NULL COMMENT '合并支付的订单ID，serialize序列化存储',
  `pay_status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '统一支付订单状态：0未付款，1已付款',
  `pay_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '统一支付订单时间',
  `pay_name` varchar(20) NOT NULL DEFAULT '' COMMENT '统一支付订单方式名称',
  `wechat_pay_type` varchar(20) NOT NULL DEFAULT '' COMMENT '微信支付时，标记使用的支付类型（扫码支付，微信内部，微信H5页面）',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '下单时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`unified_id`),
  KEY `users_id` (`users_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='订单统一支付表';


-- -----------------------------
-- Table structure for `ey_shop_product_attr`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_product_attr`;
CREATE TABLE `ey_shop_product_attr` (
  `product_attr_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '产品属性id自增',
  `aid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '产品id',
  `attr_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '属性id',
  `attr_value` text NOT NULL COMMENT '属性值',
  `attr_price` varchar(255) DEFAULT '' COMMENT '属性价格',
  `is_custom` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否自定义参数(0否 1是)',
  `sort_order` int(11) unsigned NOT NULL DEFAULT '100' COMMENT '属性排序',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`product_attr_id`),
  KEY `aid` (`aid`) USING BTREE,
  KEY `attr_id` (`attr_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `ey_shop_product_attribute`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_product_attribute`;
CREATE TABLE `ey_shop_product_attribute` (
  `attr_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '属性id',
  `attr_name` varchar(60) NOT NULL DEFAULT '' COMMENT '属性名称',
  `list_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '栏目id',
  `attr_index` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '0不需要检索 1关键字检索 2范围检索',
  `attr_input_type` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT ' 0=文本框，1=下拉框，2=多行文本框',
  `attr_values` text NOT NULL COMMENT '可选值列表',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态(0=禁用，1=启用)',
  `sort_order` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '属性排序',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `is_del` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否已删除，0=否，1=是',
  `is_custom` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否自定义参数(0否 1是)',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`attr_id`),
  KEY `cat_id` (`list_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `ey_shop_product_attrlist`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_product_attrlist`;
CREATE TABLE `ey_shop_product_attrlist` (
  `list_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '列表id',
  `list_name` varchar(60) NOT NULL DEFAULT '' COMMENT '列表名称',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态(0=禁用，1=启用)',
  `attr_count` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '参数数量',
  `desc` text NOT NULL COMMENT '描述备注',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否已删除，0=否，1=是',
  `sort_order` int(11) unsigned NOT NULL DEFAULT '100' COMMENT '列表排序',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`list_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `ey_shop_shipping_template`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_shipping_template`;
CREATE TABLE `ey_shop_shipping_template` (
  `template_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '运费模板ID',
  `template_region` varchar(255) NOT NULL DEFAULT '' COMMENT '模板运送区域',
  `template_money` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '模板运费',
  `province_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'region表id',
  `lang` varchar(30) DEFAULT 'cn' COMMENT '语言标识',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`template_id`)
) ENGINE=MyISAM AUTO_INCREMENT=36 DEFAULT CHARSET=utf8 COMMENT='运费模板表';

-- -----------------------------
-- Records of `ey_shop_shipping_template`
-- -----------------------------
INSERT INTO `ey_shop_shipping_template` VALUES ('1', '北京市', '0.00', '1', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('2', '天津市', '0.00', '338', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('3', '河北省', '0.00', '636', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('4', '山西省', '0.00', '3102', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('5', '内蒙古自治区', '0.00', '4670', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('6', '辽宁省', '0.00', '5827', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('7', '吉林省', '0.00', '7531', 'cn', '1554775921');
INSERT INTO `ey_shop_shipping_template` VALUES ('8', '黑龙江省', '0.00', '8558', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('9', '上海市', '0.00', '10543', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('10', '江苏省', '0.00', '10808', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('11', '浙江省', '0.00', '12596', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('12', '安徽省', '0.00', '14234', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('13', '福建省', '0.00', '16068', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('14', '江西省', '0.00', '17359', 'cn', '1554775962');
INSERT INTO `ey_shop_shipping_template` VALUES ('15', '山东省', '0.00', '19280', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('16', '河南省', '0.00', '21387', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('17', '湖北省', '0.00', '24022', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('18', '湖南省', '0.00', '25579', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('19', '广东省', '0.00', '28240', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('20', '广西壮族自治区', '0.00', '30164', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('21', '海南省', '0.00', '31563', 'cn', '1555483193');
INSERT INTO `ey_shop_shipping_template` VALUES ('22', '重庆市', '0.00', '31929', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('23', '四川省', '0.00', '33007', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('24', '贵州省', '0.00', '37906', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('25', '云南省', '0.00', '39556', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('26', '西藏自治区', '0.00', '41103', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('27', '陕西省', '0.00', '41877', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('28', '甘肃省', '0.00', '43776', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('29', '青海省', '0.00', '45286', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('30', '宁夏回族自治区', '0.00', '45753', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('31', '新疆维吾尔自治区', '0.00', '46047', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('32', '台湾省', '0.00', '47493', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('33', '香港特别行政区', '0.00', '47494', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('34', '澳门特别行政区', '0.00', '47495', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('35', '统一配送价格', '0.00', '100000', 'cn', '1556618311');

-- -----------------------------
-- Table structure for `ey_single_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_single_content`;
CREATE TABLE `ey_single_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '文档ID',
  `typeid` int(10) DEFAULT '0' COMMENT '栏目ID',
  `content` longtext COMMENT '内容详情',
  `content_ey_m` longtext COMMENT '手机端内容详情',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_single_content`
-- -----------------------------
INSERT INTO `ey_single_content` VALUES ('2', '140', '18', '&lt;p&gt;某某下载站限公司的游戏品牌，为用户提供手机游戏免费下载、手机游戏攻略、手机游戏资讯服务的手机游戏下载服务。每天保持更新大量游戏，是国内游戏网站中免费手机游戏更新速度较快更新数量较多的免费手机游戏专业网站。同时，我们还在不断地大力发展和完善更多终端与平台，将推出更多的优质服务和提供更好的免费手机游戏给玩家用户，同时坚定地为推动我国手机游戏的飞速发展而奋斗力。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp;移动互联网正在深刻的改变着我们的生活，我们每个人的生活必将因此变的更加精彩。某某游戏将以持续的变革和创新精神，满足不断变化的用户需求，为用户和合作伙伴创造更多价值，共同开创移动互联网和移动游戏娱乐的新时代。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '', '1684375537', '1684375537');
INSERT INTO `ey_single_content` VALUES ('3', '141', '19', '&lt;p&gt;如何安装已下载的游戏?&lt;/p&gt;&lt;p&gt;将手机与电脑通过数据线进行连接，找到已下载的游戏安装包；&amp;nbsp;&lt;/p&gt;&lt;p&gt;双击游戏安装包第三方软件会自动检测到并询问是否安装，点击安装即可。&amp;nbsp;&lt;/p&gt;&lt;p&gt;如并未安装第三方软件，需先行安装。&lt;/p&gt;&lt;p&gt;某某下载游戏是免费的吗？&lt;/p&gt;&lt;p&gt;在某某下载安装游戏是完全免费，但部分游戏在玩的过程中可能会出现收费关卡或收费道具等，此类收费都需要用户主动确认，详情请联系游戏开发商。&lt;/p&gt;&lt;p&gt;下载方式选择哪个好？&lt;/p&gt;&lt;p&gt;下载游戏时有“普通下载”“网盘下载”“高速下载”三种下载方式可供选择，普通下载使用的是某某的服务器进行下载，网盘下载使用的是百度或者华为的网盘的下载连接，高速下载使用的是某某游戏盒子客户端的下载连接，您可以根据个人需要和网络环境选择不同的下载方式，以便达到最佳的下载效果。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '', '1684375590', '1684375590');
INSERT INTO `ey_single_content` VALUES ('4', '142', '20', '&lt;ol style=&quot;outline: 0px; margin-bottom: 16px; padding-left: 2em; color: rgb(36, 41, 47); font-family: -apple-system, BlinkMacSystemFont, &amp;quot;Segoe UI&amp;quot;, &amp;quot;Noto Sans&amp;quot;, Helvetica, Arial, sans-serif, &amp;quot;Apple Color Emoji&amp;quot;, &amp;quot;Segoe UI Emoji&amp;quot;; white-space: pre-wrap;&quot; class=&quot; list-paddingleft-2&quot;&gt;&lt;li&gt;&lt;p&gt;服务范围：介绍我们提供的服务范围，让用户了解我们的服务内容和限制。&lt;/p&gt;&lt;/li&gt;&lt;li&gt;&lt;p&gt;免责声明：声明我们不对用户使用我们网站的行为承担任何法律责任，同时也提示用户在使用我们网站服务时应当遵守相关法律法规和用户协议。&lt;/p&gt;&lt;/li&gt;&lt;li&gt;&lt;p&gt;隐私政策：介绍我们的隐私政策，保障用户的个人信息安全和隐私权。&lt;/p&gt;&lt;/li&gt;&lt;li&gt;&lt;p&gt;其他条款：包括版权声明、商标声明、责任限制等内容，让用户了解我们的权利和义务。&lt;/p&gt;&lt;/li&gt;&lt;/ol&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;希望这些内容能够帮助您更好地了解我们的免责声明，保障您的权益。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '', '1684375417', '1684375417');
INSERT INTO `ey_single_content` VALUES ('5', '143', '21', '&lt;p&gt;为响应国家九部委联合开展深入整治互联网和手机媒体淫秽色情及低俗信息专项行动的号召，营造一个健康文明的网络环境，给大家一个和谐积极的家园。&lt;/p&gt;&lt;p&gt;1、不得上传任何有违国家法律法规的内容。&lt;/p&gt;&lt;p&gt;2、不得上传具有色情内容的内容。&lt;/p&gt;&lt;p&gt;3、不得上传内容低俗，格调不高的内容。&lt;/p&gt;&lt;p&gt;4、不得上传具有色情诱导性内容的内容。&lt;/p&gt;&lt;p&gt;5、不得在标题、简介和标签中出现任何具有低俗色情含义的字眼。&lt;/p&gt;&lt;p&gt;6、不得上传其他网站的精选版权作品&lt;/p&gt;&lt;p&gt;如果您上传了这些内容，我们将一律予以删除，我们希望我们最珍贵的网友们，理解并监督我们。&lt;/p&gt;&lt;p&gt;您使用我们服务上传、发布或传输内容即代表了您有权且同意在全世界范围内，永久性的、不可撤销的、免费的授予我们对该内容的存储、使用、发布、复制、发行、展览、网络传播、修改、改编、出版、翻译、据以创作衍生作品、传播、表演和展示等权利；将内容的全部或部分编入其他任何形式的作品、媒体、技术中的权利；对您的上传、发布的内容进行商业开发的权利；通过有线或无线网络向计算机终端、移动通讯终端（包括但不限于便携式通讯设备如手机和智能平板电脑等）、手持数字影音播放设备、电视接收设备（模拟信号接收设备、数字信号接收设备、数字电视、IPTV、带互联网接入功能的播放设备等）等提供信息的下载、数据传输、及其相关的宣传和推广等服务的权利；再授权给其他第三方以上述方式使用的权利；以及对作品进行单独维权的权利。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '', '1684375275', '1684375275');
INSERT INTO `ey_single_content` VALUES ('6', '145', '28', '', '', '1684375851', '1684375851');
INSERT INTO `ey_single_content` VALUES ('7', '146', '29', '', '', '1684375860', '1684375860');
INSERT INTO `ey_single_content` VALUES ('8', '147', '30', '', '', '1684375874', '1684375874');

-- -----------------------------
-- Table structure for `ey_sms_log`
-- -----------------------------
DROP TABLE IF EXISTS `ey_sms_log`;
CREATE TABLE `ey_sms_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '表id',
  `source` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '发送来源，与场景ID对应：0=注册，1=绑定，2=登录密码，3=支付密码，4=找回密码',
  `sms_type` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '短信服务商类型，1---阿里云短信， 2---腾讯云短信',
  `mobile` varchar(11) NOT NULL DEFAULT '' COMMENT '手机号',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '发送时间',
  `code` varchar(10) NOT NULL DEFAULT '' COMMENT '验证码',
  `status` int(1) unsigned NOT NULL DEFAULT '0' COMMENT '发送状态,1:成功,0:失败',
  `is_use` int(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否使用，1:是，0:否',
  `msg` varchar(255) NOT NULL DEFAULT '' COMMENT '短信内容',
  `ip` varchar(20) DEFAULT 'IP地址',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `error_msg` text NOT NULL COMMENT '发送短信异常内容',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='手机短信发送记录';


-- -----------------------------
-- Table structure for `ey_sms_template`
-- -----------------------------
DROP TABLE IF EXISTS `ey_sms_template`;
CREATE TABLE `ey_sms_template` (
  `tpl_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `sms_type` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '短信服务商类型，1---阿里云短信， 2---腾讯云短信',
  `tpl_title` varchar(128) NOT NULL DEFAULT '' COMMENT '短信标题',
  `sms_sign` varchar(50) NOT NULL DEFAULT '' COMMENT '短信签名',
  `sms_tpl_code` varchar(100) NOT NULL DEFAULT '' COMMENT '短信模板ID',
  `tpl_content` varchar(1000) NOT NULL DEFAULT '' COMMENT '发送短信内容',
  `send_scene` varchar(100) NOT NULL DEFAULT '' COMMENT '短信发送场景',
  `is_open` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否开启使用这个模板，1为是，0为否。',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) NOT NULL COMMENT '添加时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`tpl_id`)
) ENGINE=MyISAM AUTO_INCREMENT=19 DEFAULT CHARSET=utf8 COMMENT='手机短信发送模板';

-- -----------------------------
-- Records of `ey_sms_template`
-- -----------------------------
INSERT INTO `ey_sms_template` VALUES ('1', '1', '账号注册', '', '', '验证码为 ${content} ，请在30分钟内输入验证。', '0', '1', 'cn', '1611054772', '1611054772');
INSERT INTO `ey_sms_template` VALUES ('2', '1', '手机绑定', '', '', '验证码为 ${content} ，请在30分钟内输入验证。', '1', '1', 'cn', '1611054772', '1611054772');
INSERT INTO `ey_sms_template` VALUES ('3', '1', '找回密码', '', '', '验证码为 ${content} ，请在30分钟内输入验证。', '4', '1', 'cn', '1611054772', '1611054772');
INSERT INTO `ey_sms_template` VALUES ('4', '1', '订单付款', '', '', '您有新的消息：您有新的${content}订单，请注意查收！', '5', '1', 'cn', '1611054772', '1616293292');
INSERT INTO `ey_sms_template` VALUES ('5', '2', '账号注册', '', '', '验证码为 {1} ，请在30分钟内输入验证。', '0', '1', 'cn', '1611055150', '1611055150');
INSERT INTO `ey_sms_template` VALUES ('6', '2', '手机绑定', '', '', '验证码为 {1} ，请在30分钟内输入验证。', '1', '1', 'cn', '1611055150', '1611055150');
INSERT INTO `ey_sms_template` VALUES ('7', '2', '找回密码', '', '', '验证码为 {1} ，请在30分钟内输入验证。', '4', '1', 'cn', '1611055150', '1611055150');
INSERT INTO `ey_sms_template` VALUES ('8', '2', '订单付款', '', '', '您有新的消息：您有新的{1}订单，请注意查收！', '5', '1', 'cn', '1611055150', '1616293292');
INSERT INTO `ey_sms_template` VALUES ('9', '1', '订单发货', '', '', '您有新的消息：您有新的${content}订单，请注意查收！', '6', '1', 'cn', '1611054772', '1616293292');
INSERT INTO `ey_sms_template` VALUES ('10', '2', '订单发货', '', '', '您有新的消息：您有新的{1}订单，请注意查收！', '6', '1', 'cn', '1611055150', '1616293292');
INSERT INTO `ey_sms_template` VALUES ('14', '1', '留言验证', '', '', '验证码为 ${content} ，请在30分钟内输入验证。', '7', '1', 'cn', '1611054772', '1611054772');
INSERT INTO `ey_sms_template` VALUES ('13', '1', '账号登录', '', '', '验证码为 ${content} ，请在30分钟内输入验证。', '2', '1', 'cn', '1611054772', '1611054772');
INSERT INTO `ey_sms_template` VALUES ('15', '2', '账号登录', '', '', '验证码为 {1} ，请在30分钟内输入验证。', '2', '1', 'cn', '1611055150', '1611055150');
INSERT INTO `ey_sms_template` VALUES ('16', '2', '留言验证', '', '', '验证码为 {1} ，请在30分钟内输入验证。', '7', '1', 'cn', '1611055150', '1611055150');
INSERT INTO `ey_sms_template` VALUES ('17', '1', '留言表单', '', '', '您有新的留言消息，请查收！', '11', '1', 'cn', '1611054772', '1611054772');
INSERT INTO `ey_sms_template` VALUES ('18', '2', '留言表单', '', '', '您有新的留言消息，请查收！', '11', '1', 'cn', '1611055150', '1611055150');

-- -----------------------------
-- Table structure for `ey_smtp_record`
-- -----------------------------
DROP TABLE IF EXISTS `ey_smtp_record`;
CREATE TABLE `ey_smtp_record` (
  `record_id` int(10) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `source` tinyint(1) DEFAULT '0' COMMENT '来源，与场景ID对应：0=默认，2=注册，3=绑定邮箱，4=找回密码',
  `email` varchar(50) DEFAULT '' COMMENT '邮件地址',
  `users_id` int(10) DEFAULT '0' COMMENT '用户ID',
  `code` varchar(20) DEFAULT '' COMMENT '发送邮件内容',
  `status` tinyint(1) DEFAULT '0' COMMENT '是否使用，默认0，0为未使用，1为使用',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`record_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='邮件发送记录表';


-- -----------------------------
-- Table structure for `ey_smtp_tpl`
-- -----------------------------
DROP TABLE IF EXISTS `ey_smtp_tpl`;
CREATE TABLE `ey_smtp_tpl` (
  `tpl_id` int(10) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `tpl_name` varchar(200) DEFAULT '' COMMENT '模板名称',
  `tpl_title` varchar(200) DEFAULT '' COMMENT '邮件标题',
  `tpl_content` text COMMENT '发送邮件内容',
  `send_scene` tinyint(1) DEFAULT '0' COMMENT '邮件发送场景(1=留言表单）',
  `is_open` tinyint(1) DEFAULT '0' COMMENT '是否开启使用这个模板，1为是，0为否。',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`tpl_id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COMMENT='邮件模板表';

-- -----------------------------
-- Records of `ey_smtp_tpl`
-- -----------------------------
INSERT INTO `ey_smtp_tpl` VALUES ('1', '留言表单', '您有新的留言消息，请查收！', '${content}', '1', '1', 'cn', '1544763495', '1552638302');
INSERT INTO `ey_smtp_tpl` VALUES ('2', '会员注册', '验证码已发送至您的邮箱，请登录邮箱查看验证码！', '${content}', '2', '1', 'cn', '1544763495', '1552667056');
INSERT INTO `ey_smtp_tpl` VALUES ('3', '绑定邮箱', '验证码已发送至您的邮箱，请登录邮箱查看验证码！', '${content}', '3', '1', 'cn', '1544763495', '1552667400');
INSERT INTO `ey_smtp_tpl` VALUES ('4', '找回密码', '验证码已发送至您的邮箱，请登录邮箱查看验证码！', '${content}', '4', '1', 'cn', '1544763495', '1552663577');
INSERT INTO `ey_smtp_tpl` VALUES ('5', '订单付款', '您有新的待发货订单消息，请到商城订单查看！', '${content}', '5', '1', 'cn', '1611054608', '1616293292');
INSERT INTO `ey_smtp_tpl` VALUES ('6', '订单发货', '您有新的待收货订单消息，请到会员订单查看！', '${content}', '6', '1', 'cn', '1616293292', '1616293292');

-- -----------------------------
-- Table structure for `ey_special_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_special_content`;
CREATE TABLE `ey_special_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `content` longtext COMMENT '内容详情',
  `content_ey_m` longtext COMMENT '手机端内容详情',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='专题附加表';

-- -----------------------------
-- Records of `ey_special_content`
-- -----------------------------
INSERT INTO `ey_special_content` VALUES ('1', '148', '&lt;p&gt;轻松的游戏模式游戏基于休闲风格游戏的主题。玩家可以体验到更多的挑战和更多等待玩家体验的有趣内容。这里有各种有趣的游戏和独立的游戏列表让你随时随地都能感受到有趣的游戏。玩家可以选择不同类型的游戏，纸牌游戏，棋盘游戏，战略游戏，射击游戏，拼图游戏等。只要你想玩，在这里都能找到，在这些游戏中，玩家可以回顾经典，回顾过去经典游戏的乐趣，让你的空闲时间更有趣。这个合集提供了一些有趣和放&lt;/p&gt;', '', '1684378204', '1684378204');
INSERT INTO `ey_special_content` VALUES ('2', '149', '&lt;p&gt;我们为您提供第一手热门奇迹手游下载，海量华丽奇迹对战手游，重温经典奇迹MU时代战斗，感受魅力十足的奇迹对决，超多奇迹手游一网打尽，一起来我们下载吧！&lt;/p&gt;', '', '1684378215', '1684378215');
INSERT INTO `ey_special_content` VALUES ('3', '150', '&lt;p&gt;是不是经常感觉枯燥乏味的工作让人很烦恼呢？一直工作大脑的专注度会下降，所以适当的摸鱼也是能够提升工作效率的~小编为你整理了一些非常休闲有趣的摸鱼小游戏，画风温馨治愈，并且都是很轻松的，随时都能够开始玩，随时都可以暂停，完全不用担心被领导发现，快来下载摸大鱼~&lt;/p&gt;', '', '1684378227', '1684378227');
INSERT INTO `ey_special_content` VALUES ('4', '151', '&lt;p&gt;传奇高爆版顾名思义就是爆率比一般传奇要高出很多倍的一种传奇游戏。在这种传奇当中玩家光靠打怪就可以收获非常多的资源，包括但不仅限于金币、经验值、强化和锻造材料、各种凭证。那么，市面上好玩的高爆传奇版游戏有哪些呢？今天下载王小编芒果味的怪咖特意给大家搜集整理了相关传奇高爆版本大全游戏合集，希望大家喜欢前来下载体验！&lt;/p&gt;', '', '1684378182', '1684378182');

-- -----------------------------
-- Table structure for `ey_special_node`
-- -----------------------------
DROP TABLE IF EXISTS `ey_special_node`;
CREATE TABLE `ey_special_node` (
  `node_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `aid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '文档ID',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '节点名称',
  `code` varchar(50) NOT NULL DEFAULT '' COMMENT '节点标识',
  `isauto` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否自动获取文档',
  `keywords` varchar(200) NOT NULL DEFAULT '' COMMENT '关键字（多个中间用'',''分开）',
  `typeid` int(10) NOT NULL DEFAULT '0' COMMENT '栏目ID',
  `aidlist` text NOT NULL COMMENT '关联文章列表（多个中间用'',''分开）',
  `row` int(5) NOT NULL DEFAULT '10' COMMENT '文档数',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `sort_order` int(11) DEFAULT '0' COMMENT '排序',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`node_id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='专题节点表';

-- -----------------------------
-- Records of `ey_special_node`
-- -----------------------------
INSERT INTO `ey_special_node` VALUES ('1', '148', '节点1', 'default1', '1', '', '2', '', '30', '1', '0', '100', 'cn', '1684376988', '1684378204');
INSERT INTO `ey_special_node` VALUES ('2', '149', '节点1', 'default1', '1', '', '3', '', '30', '1', '0', '100', 'cn', '1684377931', '1684378215');
INSERT INTO `ey_special_node` VALUES ('3', '150', '节点1', 'default1', '1', '', '4', '', '30', '1', '0', '100', 'cn', '1684378097', '1684378227');
INSERT INTO `ey_special_node` VALUES ('4', '151', '节点1', 'default1', '1', '', '1', '', '30', '1', '0', '100', 'cn', '1684378118', '1684378182');

-- -----------------------------
-- Table structure for `ey_sql_cache_table`
-- -----------------------------
DROP TABLE IF EXISTS `ey_sql_cache_table`;
CREATE TABLE `ey_sql_cache_table` (
  `cache_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `sql_name` varchar(60) NOT NULL DEFAULT '' COMMENT 'mysql语句的标识名称，目前由模型名称+模型ID组成',
  `sql_result` text NOT NULL COMMENT 'mysql执行结果',
  `sql_md5` varchar(60) NOT NULL DEFAULT '' COMMENT 'mysql语句MD5的值',
  `sql_query` text NOT NULL COMMENT '完整mysql语句',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`cache_id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COMMENT='mysql缓存表';

-- -----------------------------
-- Records of `ey_sql_cache_table`
-- -----------------------------
INSERT INTO `ey_sql_cache_table` VALUES ('1', 'ArchivesMaxID', '151', '494a17e43cff13eeb4b9c9837c29026c', 'SELECT MAX(aid) AS tp_max FROM `ey_archives` LIMIT 1', '1684486856', '1684486856');
INSERT INTO `ey_sql_cache_table` VALUES ('2', '|arctype|all|count|', '{\"1\":{\"typeid\":1,\"num\":10},\"3\":{\"typeid\":3,\"num\":29},\"4\":{\"typeid\":4,\"num\":25},\"10\":{\"typeid\":10,\"num\":16},\"11\":{\"typeid\":11,\"num\":9},\"14\":{\"typeid\":14,\"num\":16},\"15\":{\"typeid\":15,\"num\":10},\"16\":{\"typeid\":16,\"num\":4},\"22\":{\"typeid\":22,\"num\":8},\"23\":{\"typeid\":23,\"num\":1},\"32\":{\"typeid\":32,\"num\":4}}', '177bb217bb5e0443a5ee349760a0aea7', 'SELECT typeid, count(typeid) as num FROM `ey_archives` WHERE  `channel` IN (1,2,3,4,5,7)  AND `lang` = \'cn\'  AND `is_del` = 0  AND (  (users_id = 0 OR (users_id > 0 AND arcrank >= 0)) ) GROUP BY `typeid`', '1684487715', '1684487715');
INSERT INTO `ey_sql_cache_table` VALUES ('3', '|model|all|count|', '{\"1\":{\"channel\":1,\"total\":9},\"3\":{\"channel\":3,\"total\":119},\"6\":{\"channel\":6,\"total\":7},\"7\":{\"channel\":7,\"total\":4}}', 'd5ac17fe5649c6d04f4b174c42f2d535', 'SELECT channel, count(aid) as total FROM `ey_archives` WHERE  `lang` = \'cn\'  AND `status` = 1  AND `is_del` = 0  AND (  (users_id = 0 OR (users_id > 0 AND arcrank >= 0)) ) GROUP BY `channel`', '1684487716', '1684487716');

-- -----------------------------
-- Table structure for `ey_tagindex`
-- -----------------------------
DROP TABLE IF EXISTS `ey_tagindex`;
CREATE TABLE `ey_tagindex` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'tagid',
  `tag` varchar(50) NOT NULL DEFAULT '' COMMENT 'tag内容',
  `typeid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '栏目ID',
  `litpic` varchar(250) DEFAULT '' COMMENT '封面图',
  `seo_title` varchar(200) DEFAULT '' COMMENT 'SEO标题',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT 'SEO关键词',
  `seo_description` text COMMENT 'SEO描述',
  `count` int(10) unsigned DEFAULT '0' COMMENT '点击',
  `total` int(10) unsigned DEFAULT '0' COMMENT '文档数',
  `weekcc` int(10) unsigned DEFAULT '0' COMMENT '周统计',
  `monthcc` int(10) unsigned DEFAULT '0' COMMENT '月统计',
  `weekup` int(10) unsigned DEFAULT '0' COMMENT '每周更新',
  `monthup` int(10) unsigned DEFAULT '0' COMMENT '每月更新',
  `is_common` tinyint(1) DEFAULT '0' COMMENT '是否常用标签，0=否，1=是',
  `sort_order` int(10) DEFAULT '100' COMMENT '排序号',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(10) unsigned DEFAULT '0' COMMENT '添加时间',
  `update_time` int(10) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `typeid` (`typeid`) USING BTREE,
  KEY `count` (`count`,`total`,`weekcc`,`monthcc`,`weekup`,`monthup`,`add_time`) USING BTREE,
  KEY `tag` (`tag`) USING BTREE,
  KEY `lang` (`lang`,`add_time`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COMMENT='标签索引表';

-- -----------------------------
-- Records of `ey_tagindex`
-- -----------------------------
INSERT INTO `ey_tagindex` VALUES ('1', '竞技游戏', '1', '', '', '', '', '0', '1', '0', '0', '1684310512', '1684310512', '0', '100', 'cn', '1684310512', '1684310512');
INSERT INTO `ey_tagindex` VALUES ('2', '角色游戏', '1', '', '', '', '', '0', '1', '0', '0', '1684310512', '1684310512', '0', '100', 'cn', '1684310512', '1684310512');
INSERT INTO `ey_tagindex` VALUES ('3', '冒险游戏', '1', '', '', '', '', '1', '1', '1', '1', '1684310512', '1684310512', '0', '100', 'cn', '1684310512', '1684310512');
INSERT INTO `ey_tagindex` VALUES ('4', '解谜游戏', '1', '', '', '', '', '0', '1', '0', '0', '1684310536', '1684310536', '0', '100', 'cn', '1684310536', '1684310536');
INSERT INTO `ey_tagindex` VALUES ('5', '冒险解谜', '1', '', '', '', '', '2', '1', '2', '2', '1684310536', '1684310536', '0', '100', 'cn', '1684310536', '1684310536');

-- -----------------------------
-- Table structure for `ey_taglist`
-- -----------------------------
DROP TABLE IF EXISTS `ey_taglist`;
CREATE TABLE `ey_taglist` (
  `tid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'tagid',
  `aid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '文档ID',
  `typeid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '栏目ID',
  `tag` varchar(50) DEFAULT '' COMMENT 'tag内容',
  `arcrank` tinyint(1) DEFAULT '0' COMMENT '阅读权限',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`tid`,`aid`),
  KEY `aid` (`aid`,`typeid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='文章标签表';

-- -----------------------------
-- Records of `ey_taglist`
-- -----------------------------
INSERT INTO `ey_taglist` VALUES ('1', '2', '1', '竞技游戏', '0', 'cn', '1684310512', '1684314021');
INSERT INTO `ey_taglist` VALUES ('2', '2', '1', '角色游戏', '0', 'cn', '1684310512', '1684314021');
INSERT INTO `ey_taglist` VALUES ('3', '2', '1', '冒险游戏', '0', 'cn', '1684310512', '1684314021');
INSERT INTO `ey_taglist` VALUES ('4', '3', '1', '解谜游戏', '0', 'cn', '1684310536', '1684310536');
INSERT INTO `ey_taglist` VALUES ('5', '3', '1', '冒险解谜', '0', 'cn', '1684310536', '1684310536');

-- -----------------------------
-- Table structure for `ey_tuadui_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_tuadui_content`;
CREATE TABLE `ey_tuadui_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `zhicheng1` varchar(200) NOT NULL DEFAULT '' COMMENT '职称一',
  `zhicheng2` varchar(200) NOT NULL DEFAULT '' COMMENT '职称二',
  `zhicheng3` varchar(200) NOT NULL DEFAULT '' COMMENT '职称三',
  `zhicheng4` varchar(200) NOT NULL DEFAULT '' COMMENT '职称四',
  `jianjie` longtext COMMENT '个人简介',
  `zhiwei` varchar(200) NOT NULL DEFAULT '' COMMENT '职位',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COMMENT='附加表';

-- -----------------------------
-- Records of `ey_tuadui_content`
-- -----------------------------
INSERT INTO `ey_tuadui_content` VALUES ('1', '12', '1561625442', '1561625442', '高级专业会计硕士', '中国注册资产评估师', '中国注册会计师', '', '&lt;p&gt;会计师事务所股权合伙人，具有近30年执业经验，长期从事会计、审计行业积累了丰富的执业经验，使得他十分擅长于企业财务咨询、税收筹划、重组改制等业务，对现代独立审计和企业管理有着独到见解。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;联系电话：+86 123-4567&lt;/p&gt;&lt;p&gt;电子邮箱： admin@youweb.com&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '高级合伙人');
INSERT INTO `ey_tuadui_content` VALUES ('2', '13', '1561625619', '1561625619', '中国注册会计师', '中国注册资产评估师', '中国注册税务师', '高级专业会计硕士', '&lt;p&gt;会计师事务所股权合伙人，具有近30年执业经验，长期从事会计、审计行业积累了丰富的执业经验，使得他十分擅长于企业财务咨询、税收筹划、重组改制等业务，对现代独立审计和企业管理有着独到见解。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;联系电话：+86 123-4567&lt;/p&gt;&lt;p&gt;电子邮箱： admin@youweb.com&lt;/p&gt;', '高级合伙人');
INSERT INTO `ey_tuadui_content` VALUES ('3', '14', '1561625700', '1561625700', '中国注册会计师', '澳洲会计师公会会员', '美国注册会计师', '英国特许公认会计师公会资深会员', '&lt;p&gt;拥有二十年丰富的审计及财务咨询经验，曾服务包括香港及美国上市公司在内的不同类型的客户，善长于国际准则审计、商定程序的审计及相关服务。为全国注册会计师行业领军人才、英国特许公认会计师公会资深会员、澳洲会计师公会会员、《小型企业财务报表审计工作底稿编制指南》编写组成员。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;联系电话：+86 400-123-4567&lt;/p&gt;&lt;p&gt;电子邮箱：admin@youweb.com&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '高级合伙人');
INSERT INTO `ey_tuadui_content` VALUES ('4', '15', '1561625764', '1561625764', '中国注册会计师', '中国注册资产评估师', '中国注册税务师', '', '&lt;p&gt;执业超过二十五年，多年来致力于为外商投资企业和国有企业的客户提供专业服务，涉及行业包括制造、地产、交通运输、酒店及旅游等。她在会计、审计、税务、外汇、咨询方面具备丰富的实务经验。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;联系电话：+86 400-123-4567&lt;/p&gt;&lt;p&gt;电子邮箱：admin@youweb.com&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '合伙人');
INSERT INTO `ey_tuadui_content` VALUES ('5', '45', '1561689749', '1561689749', 'CICPA', 'CCPV', 'Master of Professional Accounting', '', '&lt;p&gt;Equity partners of accounting firms, with nearly 30 years of practice experience, have accumulated rich experience in accounting and auditing industry for a long time, which makes him very good at business such as enterprise financial consultation, tax planning, restructuring and restructuring, and has unique views on modern independent auditing and enterprise management.&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;Contact number: +86 123-4567&lt;/p&gt;&lt;p&gt;E-mail: admin@youweb.com&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', 'senior partner');
INSERT INTO `ey_tuadui_content` VALUES ('6', '46', '1561689834', '1561689834', 'CICPA', 'CCPV', 'CICTA', 'Master of Professional Accounting', '&lt;p&gt;Equity partners of accounting firms, with nearly 30 years of practice experience, have accumulated rich experience in accounting and auditing industry for a long time, which makes him very good at business such as enterprise financial consultation, tax planning, restructuring and restructuring, and has unique views on modern independent auditing and enterprise management.&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;Contact number: +86 123-4567&lt;/p&gt;&lt;p&gt;E-mail: admin@youweb.com&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', 'senior partner');
INSERT INTO `ey_tuadui_content` VALUES ('7', '47', '1561689943', '1561689943', 'CICPA', 'CCPV', 'CICTA', 'Master of Professional Accounting', '&lt;p&gt;Equity partners of accounting firms, with nearly 30 years of practice experience, have accumulated rich experience in accounting and auditing industry for a long time, which makes him very good at business such as enterprise financial consultation, tax planning, restructuring and restructuring, and has unique views on modern independent auditing and enterprise management.&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;Contact number: +86 123-4567&lt;/p&gt;&lt;p&gt;E-mail: admin@youweb.com&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', 'senior partner');
INSERT INTO `ey_tuadui_content` VALUES ('8', '48', '1561689988', '1561689988', 'CICPA', 'CCPV', 'Master of Professional Accounting', '', '&lt;p&gt;Equity partners of accounting firms, with nearly 30 years of practice experience, have accumulated rich experience in accounting and auditing industry for a long time, which makes him very good at business such as enterprise financial consultation, tax planning, restructuring and restructuring, and has unique views on modern independent auditing and enterprise management.&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;Contact number: +86 123-4567&lt;/p&gt;&lt;p&gt;E-mail: admin@youweb.com&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', 'Partner');

-- -----------------------------
-- Table structure for `ey_ui_config`
-- -----------------------------
DROP TABLE IF EXISTS `ey_ui_config`;
CREATE TABLE `ey_ui_config` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `md5key` varchar(100) NOT NULL DEFAULT '' COMMENT '唯一键值（由 theme_style、page、name）组成',
  `theme_style` varchar(200) DEFAULT 'pc' COMMENT '模板风格',
  `page` varchar(64) DEFAULT '' COMMENT '页面分组',
  `type` varchar(50) DEFAULT '' COMMENT '编辑类型',
  `name` varchar(50) DEFAULT '' COMMENT '与页面的e-id对应',
  `value` text COMMENT '页面美化的val值',
  `idcode` varchar(50) DEFAULT '' COMMENT '页面唯一id标识（由 标识符+栏目id或文档id等）组成',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `md5key` (`md5key`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='可视化参数设置';


-- -----------------------------
-- Table structure for `ey_uploads`
-- -----------------------------
DROP TABLE IF EXISTS `ey_uploads`;
CREATE TABLE `ey_uploads` (
  `img_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `type_id` int(10) NOT NULL DEFAULT '0' COMMENT '分组ID',
  `aid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '文档ID',
  `title` varchar(200) DEFAULT '' COMMENT '文档标题',
  `image_url` varchar(255) DEFAULT '' COMMENT '文件存储路径',
  `intro` varchar(500) DEFAULT '' COMMENT '图集描述',
  `width` int(11) DEFAULT '0' COMMENT '图片宽度',
  `height` int(11) DEFAULT '0' COMMENT '图片高度',
  `filesize` int(11) unsigned DEFAULT '0' COMMENT '文件大小',
  `mime` varchar(50) DEFAULT '' COMMENT '图片类型',
  `users_id` int(11) DEFAULT '0' COMMENT '用户ID',
  `sort_order` smallint(5) DEFAULT '100' COMMENT '排序',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '1已删除 0未删除',
  `add_time` int(10) unsigned DEFAULT '0' COMMENT '上传时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`img_id`),
  KEY `aid` (`aid`) USING BTREE,
  KEY `add_time` (`add_time`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=23 DEFAULT CHARSET=utf8 COMMENT='上传记录表';

-- -----------------------------
-- Records of `ey_uploads`
-- -----------------------------
INSERT INTO `ey_uploads` VALUES ('1', '0', '0', 'logo2.png', '/eyou/uploads/allimg/20220105/1-220105095ZR55.png', '', '230', '45', '9749', 'image/png', '1', '100', '0', '1641347948', '1641347948');
INSERT INTO `ey_uploads` VALUES ('2', '0', '0', '5e5e048211da1.png', '/eyou/uploads/allimg/20220105/1-220105141Q1258.png', '', '96', '96', '13828', 'image/png', '1', '100', '0', '1641363491', '1641363491');
INSERT INTO `ey_uploads` VALUES ('3', '0', '0', 'logo.png', '/uploads/allimg/20230517/1-23051G41614L4.png', '', '187', '68', '9878', 'image/png', '1', '100', '0', '1684304174', '1684304174');
INSERT INTO `ey_uploads` VALUES ('4', '0', '0', '03175301rsoi.webp.jpg', '/uploads/allimg/20230517/1-23051G44242193.jpg', '', '300', '533', '82591', 'image/jpeg', '1', '100', '0', '1684305762', '1684305762');
INSERT INTO `ey_uploads` VALUES ('5', '0', '0', '03174838tl0v.jpg', '/uploads/allimg/20230517/1-23051G4425B49.jpg', '', '300', '533', '110325', 'image/jpeg', '1', '100', '0', '1684305776', '1684305776');
INSERT INTO `ey_uploads` VALUES ('6', '0', '0', '031746400q1g.jpg', '/uploads/allimg/20230517/1-23051G44305928.jpg', '', '300', '533', '62514', 'image/jpeg', '1', '100', '0', '1684305785', '1684305785');
INSERT INTO `ey_uploads` VALUES ('7', '0', '0', '031736224zbj.jpg', '/uploads/allimg/20230517/1-23051G44313613.jpg', '', '300', '533', '81400', 'image/jpeg', '1', '100', '0', '1684305793', '1684305793');
INSERT INTO `ey_uploads` VALUES ('8', '0', '0', '03173052kujj.jpg', '/uploads/allimg/20230517/1-23051G44323229.jpg', '', '300', '533', '86622', 'image/jpeg', '1', '100', '0', '1684305803', '1684305803');
INSERT INTO `ey_uploads` VALUES ('9', '0', '0', '03172316qgta.jpg', '/uploads/allimg/20230517/1-23051G443349A.jpg', '', '300', '533', '87542', 'image/jpeg', '1', '100', '0', '1684305814', '1684305814');
INSERT INTO `ey_uploads` VALUES ('10', '0', '0', '03172649ghdh.jpg', '/uploads/allimg/20230517/1-23051G44342A4.jpg', '', '300', '533', '91934', 'image/jpeg', '1', '100', '0', '1684305822', '1684305822');
INSERT INTO `ey_uploads` VALUES ('11', '0', '0', '03172827vq5b.jpg', '/uploads/allimg/20230517/1-23051G4435XM.jpg', '', '300', '533', '72495', 'image/jpeg', '1', '100', '0', '1684305838', '1684305838');
INSERT INTO `ey_uploads` VALUES ('12', '0', '0', '1683100530404787fL1Y.jpg', '/uploads/allimg/20230518/1-23051P91521X2.jpg', '', '645', '267', '77525', 'image/jpeg', '1', '100', '0', '1684372521', '1684372521');
INSERT INTO `ey_uploads` VALUES ('13', '0', '0', '26150529nuds.jpg', '/uploads/allimg/20230518/1-23051P92023F3.jpg', '', '518', '338', '38999', 'image/jpeg', '1', '100', '0', '1684372823', '1684372823');
INSERT INTO `ey_uploads` VALUES ('14', '0', '0', '26143356o9fl.jpg', '/uploads/allimg/20230518/1-23051P92034K0.jpg', '', '500', '367', '29931', 'image/jpeg', '1', '100', '0', '1684372834', '1684372834');
INSERT INTO `ey_uploads` VALUES ('15', '0', '0', '01191856j5gt.png', '/uploads/allimg/20230518/1-23051Q02946247.png', '', '600', '300', '306169', 'image/png', '1', '100', '0', '1684376986', '1684376986');
INSERT INTO `ey_uploads` VALUES ('16', '0', '0', '04130204jtar.jpg', '/uploads/allimg/20230518/1-23051Q04512Z7.jpg', '', '570', '342', '20735', 'image/jpeg', '1', '100', '0', '1684377912', '1684377912');
INSERT INTO `ey_uploads` VALUES ('17', '0', '0', '271449262ppy.jpg', '/uploads/allimg/20230518/1-23051Q04Q1138.jpg', '', '1920', '1280', '285475', 'image/jpeg', '1', '100', '0', '1684378091', '1684378091');
INSERT INTO `ey_uploads` VALUES ('18', '0', '0', '29101905wdxm.jpg', '/uploads/allimg/20230518/1-23051Q04SB43.jpg', '', '650', '275', '28666', 'image/jpeg', '1', '100', '0', '1684378116', '1684378116');
INSERT INTO `ey_uploads` VALUES ('19', '0', '0', '14173747dmf5.png', '/uploads/allimg/20230518/1-23051Q60R5114.png', '', '533', '261', '309209', 'image/png', '1', '100', '0', '1684397305', '1684397305');
INSERT INTO `ey_uploads` VALUES ('20', '0', '0', '14173728jaxl.png', '/uploads/allimg/20230518/1-23051Q60ZQ64.png', '', '533', '264', '336492', 'image/png', '1', '100', '0', '1684397348', '1684397348');
INSERT INTO `ey_uploads` VALUES ('21', '0', '0', '14174421jxud.jpg', '/uploads/allimg/20230518/1-23051Q609312M.jpg', '', '533', '276', '88468', 'image/jpeg', '1', '100', '0', '1684397371', '1684397371');
INSERT INTO `ey_uploads` VALUES ('22', '0', '0', '0fXdt1683882256_6.jpg', '/uploads/allimg/20230519/1-230519102924237.jpg', '', '500', '281', '103882', 'image/jpeg', '1', '100', '0', '1684463364', '1684463364');

-- -----------------------------
-- Table structure for `ey_uploads_type`
-- -----------------------------
DROP TABLE IF EXISTS `ey_uploads_type`;
CREATE TABLE `ey_uploads_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `upload_type` varchar(50) NOT NULL DEFAULT '' COMMENT '名称',
  `add_time` int(10) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(10) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='上传分组表';


-- -----------------------------
-- Table structure for `ey_users`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users`;
CREATE TABLE `ey_users` (
  `users_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `username` varchar(30) NOT NULL DEFAULT '' COMMENT '用户名',
  `password` varchar(255) NOT NULL DEFAULT '' COMMENT '登录密码',
  `nickname` varchar(50) NOT NULL DEFAULT '' COMMENT '昵称',
  `is_mobile` tinyint(1) DEFAULT '0' COMMENT '绑定手机号，0为不绑定，1为绑定',
  `mobile` varchar(20) NOT NULL DEFAULT '' COMMENT '手机号码（仅用于登录）',
  `is_email` tinyint(1) DEFAULT '0' COMMENT '绑定邮箱，0为不绑定，1为绑定',
  `email` varchar(60) NOT NULL DEFAULT '' COMMENT '电子邮件（仅用于登录）',
  `paypwd` varchar(255) DEFAULT '' COMMENT '支付密码，暂时未用到，可保留。',
  `users_money` decimal(10,2) DEFAULT '0.00' COMMENT '用户金额',
  `frozen_money` decimal(10,2) DEFAULT '0.00' COMMENT '冻结金额',
  `scores` int(10) DEFAULT '0' COMMENT '积分',
  `devote` int(10) DEFAULT '0' COMMENT '贡献值',
  `reg_time` int(11) unsigned DEFAULT '0' COMMENT '注册时间',
  `last_login` int(11) unsigned DEFAULT '0' COMMENT '最后登录时间',
  `last_ip` varchar(15) DEFAULT '' COMMENT '最后登录ip',
  `login_count` int(11) DEFAULT '0' COMMENT '登陆次数',
  `head_pic` varchar(255) DEFAULT '' COMMENT '头像',
  `province` int(6) DEFAULT '0' COMMENT '省份',
  `city` int(6) DEFAULT '0' COMMENT '市区',
  `district` int(6) DEFAULT '0' COMMENT '县',
  `level` smallint(5) DEFAULT '0' COMMENT '会员等级',
  `open_level_time` int(11) unsigned DEFAULT '0' COMMENT '开通会员级别时间',
  `level_maturity_days` varchar(20) DEFAULT '' COMMENT '会员级别到期天数',
  `discount` decimal(10,2) DEFAULT '1.00' COMMENT '会员折扣，默认1不享受',
  `total_amount` decimal(10,2) DEFAULT '0.00' COMMENT '消费累计额度',
  `is_activation` tinyint(1) DEFAULT '1' COMMENT '是否激活，0否，1是。\r\n后台注册默认为1激活。\r\n前台注册时，当会员功能设置选择后台审核，需后台激活才可以登陆。',
  `register_place` tinyint(1) DEFAULT '2' COMMENT '注册位置。后台注册不受注册验证影响，1为后台注册，2为前台注册。默认为2。',
  `open_id` varchar(50) NOT NULL DEFAULT '' COMMENT '第三方唯一标识openid',
  `thirdparty` tinyint(1) DEFAULT '0' COMMENT '第三方注册类型：0=普通，1=微信，2=QQ',
  `is_lock` tinyint(1) DEFAULT '0' COMMENT '是否被锁定冻结',
  `admin_id` int(10) DEFAULT '0' COMMENT '关联管理员ID',
  `lang` varchar(20) DEFAULT 'cn' COMMENT '语言标识',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '伪删除，1=是，0=否',
  `unread_notice_num` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '未读消息数量',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  `sex` varchar(10) DEFAULT '保密' COMMENT '性别- 男,女,保密',
  `coin` int(11) unsigned DEFAULT '0' COMMENT '金币',
  `union_id` varchar(50) NOT NULL DEFAULT '' COMMENT '微信用户的unionId',
  PRIMARY KEY (`users_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='会员信息表';

-- -----------------------------
-- Records of `ey_users`
-- -----------------------------
INSERT INTO `ey_users` VALUES ('1', 'admin', '794670fd96d3324127b1bee71b0ebe33', 'admin', '0', '', '0', '', '', '0.00', '0.00', '0', '0', '1650871619', '1684485018', '', '0', '/public/static/common/images/dfboy.png', '0', '0', '0', '1', '0', '', '1.00', '0.00', '1', '1', '', '0', '0', '1', 'cn', '0', '0', '1684485018', '保密', '0', '');

-- -----------------------------
-- Table structure for `ey_users_bottom_menu`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_bottom_menu`;
CREATE TABLE `ey_users_bottom_menu` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `title` varchar(30) DEFAULT '' COMMENT '导航名称',
  `mca` varchar(50) DEFAULT '' COMMENT '分组/控制器/操作名',
  `icon` varchar(255) NOT NULL DEFAULT '' COMMENT '图标',
  `sort_order` int(10) DEFAULT '100' COMMENT '排序号',
  `status` tinyint(1) DEFAULT '1' COMMENT '功能开关状态，1=开启，0=关闭',
  `display` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否显示, 1--是, 0--否',
  `lang` varchar(20) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='会员中心移动端底部菜单表';

-- -----------------------------
-- Records of `ey_users_bottom_menu`
-- -----------------------------
INSERT INTO `ey_users_bottom_menu` VALUES ('1', '首页', 'home/Index/index', 'shouye', '100', '1', '1', 'cn', '1611055150', '1611055150');
INSERT INTO `ey_users_bottom_menu` VALUES ('2', '下载', 'user/Download/index', 'xiazai', '100', '1', '1', 'cn', '1611055150', '1611055150');
INSERT INTO `ey_users_bottom_menu` VALUES ('3', '发布', 'user/UsersRelease/article_add', 'fabu', '100', '1', '1', 'cn', '1611055150', '1611055150');
INSERT INTO `ey_users_bottom_menu` VALUES ('4', '我的', 'user/Users/centre', 'geren', '100', '1', '1', 'cn', '1611055150', '1611055150');

-- -----------------------------
-- Table structure for `ey_users_collection`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_collection`;
CREATE TABLE `ey_users_collection` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `users_id` int(10) DEFAULT '0',
  `aid` int(10) DEFAULT '0' COMMENT '文档id',
  `channel` int(10) DEFAULT '0' COMMENT '模型',
  `typeid` int(10) DEFAULT '0' COMMENT '栏目',
  `title` varchar(200) DEFAULT '' COMMENT '网站标题',
  `litpic` varchar(255) DEFAULT '' COMMENT '缩略图',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='我的收藏';


-- -----------------------------
-- Table structure for `ey_users_config`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_config`;
CREATE TABLE `ey_users_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '会员功能配置表ID',
  `name` varchar(50) DEFAULT '' COMMENT '配置的key键名',
  `value` text COMMENT '配置的value值',
  `desc` varchar(100) DEFAULT '' COMMENT '键名说明',
  `inc_type` varchar(64) DEFAULT '' COMMENT '配置分组',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COMMENT='会员功能配置表';

-- -----------------------------
-- Records of `ey_users_config`
-- -----------------------------
INSERT INTO `ey_users_config` VALUES ('1', 'users_reg_notallow', 'www,bbs,ftp,mail,user,users,admin,administrator', '不允许注册的会员名', 'users', 'cn', '1641347760');
INSERT INTO `ey_users_config` VALUES ('2', 'score_signin_status', '1', '', 'score', 'cn', '1611055150');
INSERT INTO `ey_users_config` VALUES ('3', 'score_signin_score', '3', '', 'score', 'cn', '1611055150');
INSERT INTO `ey_users_config` VALUES ('4', 'pay_balance_open', '1', '', 'pay', 'cn', '1616293292');
INSERT INTO `ey_users_config` VALUES ('5', 'shop_open', '0', '', 'shop', 'cn', '1623814050');
INSERT INTO `ey_users_config` VALUES ('6', 'users_login_expiretime', '3600', '', 'users', 'cn', '1641347514');
INSERT INTO `ey_users_config` VALUES ('7', 'score_name', '积分', '', 'score', 'cn', '1684114879');
INSERT INTO `ey_users_config` VALUES ('8', 'score_intro', 'a) 积分不可兑现、不可转让,仅可在本平台使用;\r\nb) 您在本平台参加特定活动也可使用积分,详细使用规则以具体活动时的规则为准;\r\nc) 积分的数值精确到个位(小数点后全部舍弃,不进行四舍五入)\r\nd) 买家在完成该笔交易(订单状态为“已签收”)后才能得到此笔交易的相应积分,如购买商品参加店铺其他优惠,则优惠的金额部分不享受积分获取;', '', 'score', 'cn', '1684114879');
INSERT INTO `ey_users_config` VALUES ('9', 'memgift_open', '0', '', 'memgift', 'cn', '1684114881');
INSERT INTO `ey_users_config` VALUES ('10', 'order_right_protect_time', '7', '', 'order', 'cn', '1684114896');

-- -----------------------------
-- Table structure for `ey_users_footprint`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_footprint`;
CREATE TABLE `ey_users_footprint` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `channel` int(10) DEFAULT '0' COMMENT '频道模型',
  `typeid` int(10) DEFAULT '0' COMMENT '栏目id',
  `aid` int(10) DEFAULT '0' COMMENT '文档id',
  `title` varchar(100) DEFAULT '' COMMENT '网站标题',
  `litpic` varchar(255) DEFAULT '' COMMENT '缩略图',
  `users_id` int(10) DEFAULT '0',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `users_id` (`users_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='我的足迹';


-- -----------------------------
-- Table structure for `ey_users_forward`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_forward`;
CREATE TABLE `ey_users_forward` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `users_id` int(10) DEFAULT '0',
  `aid` int(10) DEFAULT '0' COMMENT '文档id',
  `channel` int(10) DEFAULT '0' COMMENT '模型',
  `typeid` int(10) DEFAULT '0' COMMENT '栏目',
  `title` varchar(200) DEFAULT '' COMMENT '网站标题',
  `litpic` varchar(255) DEFAULT '' COMMENT '缩略图',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='转发记录';


-- -----------------------------
-- Table structure for `ey_users_level`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_level`;
CREATE TABLE `ey_users_level` (
  `level_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `level_name` varchar(30) DEFAULT '' COMMENT '级别名称',
  `level_value` int(10) DEFAULT '0' COMMENT '会员等级值',
  `is_system` tinyint(1) DEFAULT '0' COMMENT '类型，1=系统，0=用户',
  `amount` decimal(10,2) DEFAULT '0.00' COMMENT '消费额度',
  `down_count` int(10) DEFAULT '0' COMMENT '每天下载次数限制',
  `discount` float(10,2) DEFAULT '100.00' COMMENT '折扣率，初始值为100即100%，无折扣',
  `posts_count` int(10) DEFAULT '5' COMMENT '会员投稿次数限制',
  `ask_is_release` tinyint(1) DEFAULT '1' COMMENT '允许在问答中发布问题，1=是，0=否',
  `ask_is_review` tinyint(1) DEFAULT '0' COMMENT '在问答中发布问题或回答是否需要审核，1=是，0=否',
  `lang` varchar(20) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`level_id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COMMENT='会员级别表';

-- -----------------------------
-- Records of `ey_users_level`
-- -----------------------------
INSERT INTO `ey_users_level` VALUES ('1', '注册会员', '10', '1', '0.00', '100', '100', '5', '1', '0', 'cn', '1641347762', '1641347762');
INSERT INTO `ey_users_level` VALUES ('2', '低级会员', '20', '0', '0.00', '100', '100', '5', '1', '0', 'cn', '1641347762', '1641347762');
INSERT INTO `ey_users_level` VALUES ('3', '中级会员', '50', '0', '0.00', '100', '100', '5', '1', '0', 'cn', '1641347762', '1641347762');
INSERT INTO `ey_users_level` VALUES ('4', '高级会员', '100', '0', '0.00', '100', '100', '5', '1', '0', 'cn', '1641347762', '1641347762');
INSERT INTO `ey_users_level` VALUES ('5', '给力会员', '150', '0', '0.00', '100', '100', '5', '1', '0', 'cn', '1641347762', '1641347762');
INSERT INTO `ey_users_level` VALUES ('6', '超能会员', '180', '0', '0.00', '100', '100', '5', '1', '0', 'cn', '1641347762', '1641347762');

-- -----------------------------
-- Table structure for `ey_users_like`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_like`;
CREATE TABLE `ey_users_like` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `users_id` int(10) DEFAULT '0',
  `aid` int(10) DEFAULT '0' COMMENT '文档id',
  `channel` int(10) DEFAULT '0' COMMENT '模型',
  `typeid` int(10) DEFAULT '0' COMMENT '栏目',
  `title` varchar(200) DEFAULT '' COMMENT '网站标题',
  `litpic` varchar(255) DEFAULT '' COMMENT '缩略图',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='我喜欢的';


-- -----------------------------
-- Table structure for `ey_users_list`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_list`;
CREATE TABLE `ey_users_list` (
  `list_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `users_id` int(10) NOT NULL DEFAULT '0' COMMENT '会员ID',
  `para_id` int(10) NOT NULL DEFAULT '0' COMMENT '属性ID',
  `info` text COMMENT '属性值',
  `lang` varchar(50) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`list_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='会员属性表(信息）';


-- -----------------------------
-- Table structure for `ey_users_login_log`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_login_log`;
CREATE TABLE `ey_users_login_log` (
  `log_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '会员日志自增ID',
  `users_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `log_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '日志时间，年月日(例:20230406)',
  `log_count` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '日志次数',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`log_id`),
  UNIQUE KEY `users_id` (`users_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='会员登录日志';


-- -----------------------------
-- Table structure for `ey_users_menu`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_menu`;
CREATE TABLE `ey_users_menu` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `title` varchar(30) DEFAULT '' COMMENT '导航名称',
  `version` varchar(10) DEFAULT 'weapp' COMMENT '分组',
  `mca` varchar(50) DEFAULT '' COMMENT '分组/控制器/操作名',
  `active_url` varchar(500) DEFAULT '' COMMENT '标记为选中的url',
  `is_userpage` tinyint(1) DEFAULT '0' COMMENT '默认会员首页',
  `sort_order` int(10) DEFAULT '0' COMMENT '排序号',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态，1=显示，0=隐藏',
  `lang` varchar(20) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COMMENT='会员菜单表';

-- -----------------------------
-- Records of `ey_users_menu`
-- -----------------------------
INSERT INTO `ey_users_menu` VALUES ('1', '个人信息', 'v1', 'user/Users/index', '', '1', '100', '1', 'cn', '1555904190', '1555917737');
INSERT INTO `ey_users_menu` VALUES ('2', '账户充值', 'v1', 'user/Pay/pay_consumer_details', '', '0', '100', '0', 'cn', '1555904190', '1555917761');
INSERT INTO `ey_users_menu` VALUES ('3', '商城中心', 'v1', 'user/Shop/shop_centre', '', '0', '100', '0', 'cn', '1555904190', '1555917761');
INSERT INTO `ey_users_menu` VALUES ('4', '会员升级', 'v1', 'user/Level/level_centre', '', '0', '100', '0', 'cn', '1555904190', '1555917761');
INSERT INTO `ey_users_menu` VALUES ('5', '会员投稿', 'v1', 'user/UsersRelease/release_centre', '', '0', '100', '0', 'cn', '1555904190', '1555917761');
INSERT INTO `ey_users_menu` VALUES ('6', '我的下载', 'v1', 'user/Download/index', '', '0', '100', '1', 'cn', '1590484667', '1611054964');
INSERT INTO `ey_users_menu` VALUES ('7', '个人中心', 'v2', 'user/Users/index', 'user/Users/index|user/Pay/pay_account_recharge|user/Users/footprint_index|user/Level/level_centre|user/Download/index|user/Users/media_index', '1', '100', '1', 'cn', '1608708057', '1609385363');
INSERT INTO `ey_users_menu` VALUES ('8', '我的信息', 'v2', 'user/Users/info', 'user/Users/info', '0', '100', '1', 'cn', '1608709100', '1609385363');
INSERT INTO `ey_users_menu` VALUES ('9', '我的收藏', 'v2', 'user/Users/collection_index', 'user/Users/collection_index', '0', '100', '1', 'cn', '1608708100', '1609385363');
INSERT INTO `ey_users_menu` VALUES ('10', '财务明细', 'v2', 'user/Pay/pay_consumer_details', 'user/Pay/pay_consumer_details|user/Users/score_index', '0', '100', '1', 'cn', '1608709000', '1609387813');
INSERT INTO `ey_users_menu` VALUES ('11', '我的收藏', 'v1', 'user/Users/collection_index', '', '0', '100', '1', 'cn', '1590484667', '1614651537');

-- -----------------------------
-- Table structure for `ey_users_money`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_money`;
CREATE TABLE `ey_users_money` (
  `moneyid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '金额明细表ID',
  `users_id` int(10) DEFAULT '0' COMMENT '会员表ID',
  `money` decimal(10,2) DEFAULT '0.00' COMMENT '金额',
  `users_money` decimal(10,2) DEFAULT '0.00' COMMENT '此条记录的账户金额',
  `cause` text COMMENT '事由，暂时在升级消费中使用到，以serialize序列化后存入，用于后续查询。',
  `cause_type` tinyint(1) DEFAULT '0' COMMENT '数据类型,0-消费,1-充值,2-退款,3-订单支付,4-管理员添加,5-管理员减少',
  `status` tinyint(1) DEFAULT '1' COMMENT '是否成功，默认1，0失败，1未付款，2已付款，3已完成，4订单取消。',
  `pay_method` varchar(50) DEFAULT '' COMMENT '支付方式，wechat为微信支付，alipay为支付宝支付，balance为余额支付',
  `wechat_pay_type` varchar(20) NOT NULL DEFAULT '' COMMENT '微信支付时，标记使用的支付类型（扫码支付，微信内部，微信H5页面）',
  `pay_details` text COMMENT '支付时返回的数据，以serialize序列化后存入，用于后续查询。',
  `order_number` varchar(30) DEFAULT '' COMMENT '订单号',
  `level_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '会员升级时所升级的会员级别ID，默认0',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `admin_id` int(10) DEFAULT '0' COMMENT '管理员表ID',
  PRIMARY KEY (`moneyid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='金额明细表';


-- -----------------------------
-- Table structure for `ey_users_notice`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_notice`;
CREATE TABLE `ey_users_notice` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) DEFAULT '' COMMENT '通知标题',
  `users_id` text NOT NULL COMMENT '用户id',
  `usernames` text NOT NULL COMMENT '用户名字符串',
  `remark` text COMMENT '通知信息',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='站内通知';


-- -----------------------------
-- Table structure for `ey_users_notice_read`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_notice_read`;
CREATE TABLE `ey_users_notice_read` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `users_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `notice_id` int(10) DEFAULT NULL COMMENT '站内信id',
  `is_read` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否已读, 1---是, 0---否',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除, 1---是, 0---否',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='用户已读站内通知';


-- -----------------------------
-- Table structure for `ey_users_notice_tpl`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_notice_tpl`;
CREATE TABLE `ey_users_notice_tpl` (
  `tpl_id` int(10) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `tpl_name` varchar(200) DEFAULT '' COMMENT '模板名称',
  `tpl_title` varchar(200) DEFAULT '' COMMENT '站内信标题',
  `tpl_content` text COMMENT '发送内容',
  `send_scene` tinyint(1) DEFAULT '0' COMMENT '站内信发送场景(1=留言表单）',
  `is_open` tinyint(1) DEFAULT '0' COMMENT '是否开启使用这个模板，1为是，0为否。',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`tpl_id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COMMENT='站内信模板表';

-- -----------------------------
-- Records of `ey_users_notice_tpl`
-- -----------------------------
INSERT INTO `ey_users_notice_tpl` VALUES ('1', '留言表单', '您有新的留言消息，请到内容管理中查看！', '${content}', '1', '1', 'cn', '1616293292', '1616293292');
INSERT INTO `ey_users_notice_tpl` VALUES ('5', '订单付款', '您有新的待发货订单消息，请到商城订单查看！', '${content}', '5', '1', 'cn', '1616293292', '1616293292');
INSERT INTO `ey_users_notice_tpl` VALUES ('6', '订单发货', '您有新的待收货订单消息，请到会员订单查看！', '${content}', '6', '1', 'cn', '1616293292', '1616293292');

-- -----------------------------
-- Table structure for `ey_users_notice_tpl_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_notice_tpl_content`;
CREATE TABLE `ey_users_notice_tpl_content` (
  `content_id` int(10) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `source` tinyint(1) DEFAULT '0' COMMENT '来源，对应 users_notice_tpl 表 send_scene 字段',
  `admin_id` int(10) DEFAULT '0' COMMENT '管理员ID，不为空则表示管理员接收信息',
  `users_id` int(10) DEFAULT '0' COMMENT '用户ID，不为空则表示会员接收信息，暂未使用',
  `content_title` varchar(200) DEFAULT '' COMMENT '通知标题',
  `content` text COMMENT '接收的通知内容',
  `is_read` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否已读，默认0，1是，0否',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`content_id`),
  KEY `admin_id` (`admin_id`) USING BTREE,
  KEY `users_id` (`users_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='站内信发送接收记录表';


-- -----------------------------
-- Table structure for `ey_users_parameter`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_parameter`;
CREATE TABLE `ey_users_parameter` (
  `para_id` int(10) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `title` varchar(100) NOT NULL DEFAULT '' COMMENT '标题',
  `name` varchar(100) NOT NULL DEFAULT '' COMMENT '名称',
  `dtype` varchar(32) NOT NULL DEFAULT '' COMMENT '字段类型',
  `dfvalue` varchar(1000) NOT NULL DEFAULT '' COMMENT '默认值',
  `is_system` tinyint(1) DEFAULT '0' COMMENT '是否为系统属性，系统属性不可删除，1为是，0为否，默认0。',
  `is_hidden` tinyint(1) DEFAULT '0' COMMENT '是否禁用属性，1为是，0为否',
  `is_required` tinyint(1) DEFAULT '0' COMMENT '是否为必填属性，1为是，0为否，默认0。',
  `is_reg` tinyint(1) DEFAULT '1' COMMENT '是否为注册表单，1为是，0为否',
  `placeholder` varchar(255) DEFAULT '' COMMENT '提示文字',
  `sort_order` smallint(5) NOT NULL DEFAULT '0' COMMENT '排序',
  `lang` varchar(50) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`para_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='会员属性表(字段)';

-- -----------------------------
-- Records of `ey_users_parameter`
-- -----------------------------
INSERT INTO `ey_users_parameter` VALUES ('1', '手机号码', 'mobile_1', 'mobile', '', '1', '0', '0', '1', '', '1', 'cn', '0', '1551238026');
INSERT INTO `ey_users_parameter` VALUES ('2', '邮箱地址', 'email_2', 'email', '', '1', '0', '1', '1', '', '1', 'cn', '0', '1551238549');

-- -----------------------------
-- Table structure for `ey_users_score`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_score`;
CREATE TABLE `ey_users_score` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '积分明细表',
  `type` tinyint(2) DEFAULT '1' COMMENT '类型:1-提问,2-回答,3-最佳答案4-悬赏退回,5-每日签到,6-管理员编辑,7-问题悬赏/获得悬赏,8-消费赠送积分,9-积分兑换/退回,10-登录赠送积分',
  `users_id` int(10) DEFAULT '0' COMMENT '用户id',
  `ask_id` int(10) DEFAULT '0' COMMENT '问题id',
  `reply_id` int(10) DEFAULT '0' COMMENT '回答id',
  `score` varchar(20) NOT NULL DEFAULT '' COMMENT '积分',
  `devote` int(10) DEFAULT '0' COMMENT '贡献值,同score',
  `money` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '余额',
  `info` varchar(255) DEFAULT '' COMMENT '说明',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(10) DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) DEFAULT '0' COMMENT '更新时间',
  `current_score` int(10) DEFAULT '0' COMMENT '当前积分',
  `current_devote` int(10) DEFAULT '0' COMMENT '当前贡献值',
  `admin_id` int(10) DEFAULT '0' COMMENT '管理员表ID',
  `remark` varchar(255) DEFAULT '' COMMENT '备注',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='积分详情表';


-- -----------------------------
-- Table structure for `ey_users_signin`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_signin`;
CREATE TABLE `ey_users_signin` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `users_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `lang` varchar(50) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '签到时间',
  PRIMARY KEY (`id`),
  KEY `users_id` (`users_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='用户签到表';


-- -----------------------------
-- Table structure for `ey_users_type_manage`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_type_manage`;
CREATE TABLE `ey_users_type_manage` (
  `type_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `type_name` varchar(30) DEFAULT '' COMMENT '类型名称',
  `level_id` int(10) DEFAULT '0' COMMENT '会员等级ID',
  `price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '价格',
  `limit_id` int(10) DEFAULT '0' COMMENT '会员期限限制，存储ID，值对应常量表的admin_member_limit_arr数组',
  `activity` varchar(30) DEFAULT '' COMMENT '活动文案',
  `sort_order` smallint(5) NOT NULL DEFAULT '0' COMMENT '排序',
  `lang` varchar(20) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`type_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='会员产品类型表';

-- -----------------------------
-- Records of `ey_users_type_manage`
-- -----------------------------
INSERT INTO `ey_users_type_manage` VALUES ('1', '升级为本站中级会员', '2', '100.00', '2', '', '100', 'cn', '1611053268', '1611053268');
INSERT INTO `ey_users_type_manage` VALUES ('2', '升级为本站高级会员', '3', '200.00', '3', '', '100', 'cn', '1611053268', '1611053268');

-- -----------------------------
-- Table structure for `ey_video_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_video_content`;
CREATE TABLE `ey_video_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `vdsrc` varchar(200) NOT NULL DEFAULT '' COMMENT '视频地址',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='附加表';

-- -----------------------------
-- Records of `ey_video_content`
-- -----------------------------
INSERT INTO `ey_video_content` VALUES ('1', '13', '1552364595', '1552364595', 'http://player.youku.com/embed/XMzU1NzU5MzM4MA==');
INSERT INTO `ey_video_content` VALUES ('2', '14', '1552364689', '1552364689', 'http://player.youku.com/embed/XMzYyOTQ2MjA5Mg==');
INSERT INTO `ey_video_content` VALUES ('3', '52', '1552382177', '1552382177', 'http://player.youku.com/embed/XMzU1NzU5MzM4MA==');
INSERT INTO `ey_video_content` VALUES ('4', '53', '1552382208', '1552382208', 'http://player.youku.com/embed/XMzYyOTQ2MjA5Mg==');

-- -----------------------------
-- Table structure for `ey_weapp`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp`;
CREATE TABLE `ey_weapp` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(50) DEFAULT '' COMMENT '插件标识',
  `name` varchar(55) DEFAULT '' COMMENT '中文名字',
  `config` text COMMENT '配置信息',
  `data` text COMMENT '额外序列化存储数据，简单插件可以不创建表，存储这里即可',
  `status` tinyint(1) DEFAULT '0' COMMENT '状态：0=未安装，1=启用，-1=禁用',
  `tag_weapp` tinyint(1) DEFAULT '1' COMMENT '1=自动绑定，2=手工调用。关联模板标签weapp，自动调用内置的show钩子方法',
  `thorough` tinyint(1) DEFAULT '0' COMMENT '彻底卸载：0=是，1=否',
  `position` varchar(30) DEFAULT 'default' COMMENT '插件位置',
  `is_buy` tinyint(1) DEFAULT '0' COMMENT '0-本地,1-线上购买 2-线上购买,但已删除,不显示在我的插件列表',
  `is_upgrade` tinyint(1) DEFAULT '1' COMMENT '是否提示升级',
  `sort_order` int(10) DEFAULT '100' COMMENT '排序号',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `code` (`code`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='插件应用表';


-- -----------------------------
-- Table structure for `ey_weapp_ask`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_ask`;
CREATE TABLE `ey_weapp_ask` (
  `ask_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `type_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '问题栏目ID',
  `users_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `ask_title` varchar(80) NOT NULL DEFAULT '' COMMENT '问题标题',
  `is_recom` tinyint(1) NOT NULL DEFAULT '0' COMMENT '问题是否推荐',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '问题状态：0未解决，1已解决，2已关闭',
  `click` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '浏览点击量',
  `replies` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '问题回复量',
  `content` text NOT NULL COMMENT '问题内容',
  `url` varchar(255) NOT NULL DEFAULT '' COMMENT '问题网址',
  `users_ip` varchar(50) NOT NULL DEFAULT '' COMMENT '问题发布时IP地址',
  `is_review` tinyint(1) NOT NULL DEFAULT '1' COMMENT '问题是否审核，1是，0否',
  `follow` tinyint(1) NOT NULL DEFAULT '0' COMMENT '关注问题则表示有回复时发送邮件通知到问题发布人',
  `solve_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '解决时间(这个问题存在最佳答案则表示已解决)',
  `bestanswer_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '最佳答案',
  `sort_order` int(10) NOT NULL DEFAULT '100' COMMENT '排序号',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`ask_id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COMMENT='问题表';


-- -----------------------------
-- Table structure for `ey_weapp_ask_answer`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_ask_answer`;
CREATE TABLE `ey_weapp_ask_answer` (
  `answer_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `ask_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '问题ID',
  `is_bestanswer` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否最佳答案，0否，1是',
  `is_review` tinyint(1) NOT NULL DEFAULT '1' COMMENT '问题是否审核，1是，0否',
  `type_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '问题栏目ID',
  `users_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户ID',
  `username` varchar(50) NOT NULL DEFAULT '' COMMENT '用户名',
  `click_like` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '点赞量',
  `users_ip` varchar(30) NOT NULL DEFAULT '' COMMENT '用户IP地址',
  `content` text NOT NULL COMMENT '内容',
  `ifcheck` tinyint(1) NOT NULL DEFAULT '1',
  `answer_pid` int(10) NOT NULL DEFAULT '0' COMMENT '子答案的父答案',
  `at_users_id` int(10) NOT NULL DEFAULT '0' COMMENT '被@的用户ID',
  `at_answer_id` int(10) NOT NULL DEFAULT '0' COMMENT '@答案ID',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`answer_id`)
) ENGINE=MyISAM AUTO_INCREMENT=19 DEFAULT CHARSET=utf8 COMMENT='答案表';


-- -----------------------------
-- Table structure for `ey_weapp_ask_answer_like`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_ask_answer_like`;
CREATE TABLE `ey_weapp_ask_answer_like` (
  `like_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `ask_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '问题ID',
  `answer_id` int(10) NOT NULL DEFAULT '0' COMMENT '答案ID',
  `users_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户ID',
  `click_like` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '点赞',
  `users_ip` varchar(30) NOT NULL DEFAULT '' COMMENT '用户IP地址',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`like_id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COMMENT='答案点赞表';


-- -----------------------------
-- Table structure for `ey_weapp_ask_type`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_ask_type`;
CREATE TABLE `ey_weapp_ask_type` (
  `type_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '栏目自增',
  `type_name` varchar(100) NOT NULL DEFAULT '' COMMENT '栏目名称',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '上级ID',
  `sort_order` int(10) unsigned NOT NULL DEFAULT '100' COMMENT '排序号',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`type_id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COMMENT='问题栏目分类表';

-- -----------------------------
-- Records of `ey_weapp_ask_type`
-- -----------------------------
INSERT INTO `ey_weapp_ask_type` VALUES ('1', '问题求助', '0', '100', '1565770890', '1648617311');
INSERT INTO `ey_weapp_ask_type` VALUES ('2', '功能建议', '0', '100', '1565770890', '1648617311');
INSERT INTO `ey_weapp_ask_type` VALUES ('3', '业务咨询', '0', '100', '1565770890', '1648617311');
INSERT INTO `ey_weapp_ask_type` VALUES ('4', 'BUG反馈', '1', '100', '1565771021', '1648617311');
INSERT INTO `ey_weapp_ask_type` VALUES ('5', '其他问题', '1', '100', '1565771021', '1648617311');

-- -----------------------------
-- Table structure for `ey_weapp_bshoucang`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_bshoucang`;
CREATE TABLE `ey_weapp_bshoucang` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) DEFAULT '' COMMENT '网站标题',
  `url` varchar(100) DEFAULT '' COMMENT '网站地址',
  `logo` varchar(255) DEFAULT '' COMMENT '网站LOGO',
  `sort_order` int(11) DEFAULT '0' COMMENT '排序号',
  `target` tinyint(1) DEFAULT '0' COMMENT '是否开启浏览器新窗口',
  `intro` text COMMENT '网站简况',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态(1=显示，0=屏蔽)',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `ey_weapp_collection`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_collection`;
CREATE TABLE `ey_weapp_collection` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `users_id` int(10) DEFAULT NULL,
  `title` varchar(50) DEFAULT '' COMMENT '网站标题',
  `url` varchar(100) DEFAULT '' COMMENT '网站地址',
  `lang` varchar(50) DEFAULT '' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_weapp_collection`
-- -----------------------------
INSERT INTO `ey_weapp_collection` VALUES ('2', '2', '袋式除尘器处理风量是怎么计算', '29', 'cn', '1609829251', '1609829251');

-- -----------------------------
-- Table structure for `ey_weapp_comment`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_comment`;
CREATE TABLE `ey_weapp_comment` (
  `comment_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `aid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '文档ID',
  `is_bestanswer` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否最佳答案，0否，1是',
  `is_review` tinyint(1) NOT NULL DEFAULT '1' COMMENT '问题是否审核，1是，0否',
  `users_id` int(10) NOT NULL DEFAULT '0' COMMENT '评论用户ID',
  `username` varchar(50) NOT NULL DEFAULT '' COMMENT '评论用户名',
  `click_like` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '点赞量',
  `users_ip` varchar(30) NOT NULL DEFAULT '' COMMENT '用户IP地址',
  `content` text NOT NULL COMMENT '内容',
  `pid` int(10) NOT NULL DEFAULT '0' COMMENT '子评论的父评论',
  `at_users_id` int(10) NOT NULL DEFAULT '0' COMMENT '被@的用户ID',
  `at_comment_id` int(10) NOT NULL DEFAULT '0' COMMENT '@答案ID',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`comment_id`),
  KEY `aid` (`aid`),
  KEY `users_id` (`users_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='文档评论回复表';

-- -----------------------------
-- Records of `ey_weapp_comment`
-- -----------------------------
INSERT INTO `ey_weapp_comment` VALUES ('1', '439', '0', '1', '1', 'admin', '1', '127.0.0.1', '&lt;p&gt;&lt;span style=&quot;font-family: &amp;quot;Microsoft YaHei&amp;quot;, Arial, Helvetica, sans-serif; font-size: 15px; background-color: rgb(255, 255, 255);&quot;&gt;网站经过优化稳定后，在网站可用数据稳定上升的前提下，可以考虑增加交换更多的高权重友情链接。此时，友情链接的交换不能是单一的关键词链接，而是可以扩展网站的权限，追求多词多页权重的平均增加，从而帮助更多的收录和原创内容再次被收录到页面的内容排名中。&lt;/span&gt;&lt;/p&gt;', '0', '0', '0', '1627893894', '1628058396');

-- -----------------------------
-- Table structure for `ey_weapp_comment_level`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_comment_level`;
CREATE TABLE `ey_weapp_comment_level` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `users_level_id` int(10) NOT NULL DEFAULT '0' COMMENT '会员级别ID',
  `is_comment` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否允许评论文档',
  `is_review` tinyint(1) NOT NULL DEFAULT '0' COMMENT '评论是否需要审核',
  `add_time` int(10) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(10) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='评论级别表';

-- -----------------------------
-- Records of `ey_weapp_comment_level`
-- -----------------------------
INSERT INTO `ey_weapp_comment_level` VALUES ('1', '0', '0', '1', '1572418214', '1572418214');
INSERT INTO `ey_weapp_comment_level` VALUES ('2', '1', '1', '0', '1626925386', '0');
INSERT INTO `ey_weapp_comment_level` VALUES ('3', '2', '1', '0', '1626925386', '0');
INSERT INTO `ey_weapp_comment_level` VALUES ('4', '3', '1', '0', '1626925386', '0');

-- -----------------------------
-- Table structure for `ey_weapp_comment_like`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_comment_like`;
CREATE TABLE `ey_weapp_comment_like` (
  `like_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `aid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '文档ID',
  `comment_id` int(10) NOT NULL DEFAULT '0' COMMENT '评论ID',
  `users_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '点赞用户ID',
  `click_like` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '点赞',
  `users_ip` varchar(20) NOT NULL DEFAULT '' COMMENT '用户IP地址',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`like_id`),
  KEY `aid` (`aid`,`comment_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='文档评论点赞表';

-- -----------------------------
-- Records of `ey_weapp_comment_like`
-- -----------------------------
INSERT INTO `ey_weapp_comment_like` VALUES ('1', '439', '1', '1', '1', '127.0.0.1', '1628058396', '1628058396');

-- -----------------------------
-- Table structure for `ey_weapp_demo`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_demo`;
CREATE TABLE `ey_weapp_demo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `typeid` tinyint(1) DEFAULT '1' COMMENT '类型：1=文字链接，2=图片链接',
  `title` varchar(50) DEFAULT '' COMMENT '网站标题',
  `url` varchar(100) DEFAULT '' COMMENT '网站地址',
  `logo` varchar(255) DEFAULT '' COMMENT '网站LOGO',
  `sort_order` int(11) DEFAULT '0' COMMENT '排序号',
  `target` tinyint(1) DEFAULT '0' COMMENT '是否开启浏览器新窗口',
  `email` varchar(50) DEFAULT NULL,
  `intro` text COMMENT '网站简况',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态(1=显示，0=屏蔽)',
  `delete_time` int(11) DEFAULT '0' COMMENT '软删除时间',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_weapp_demo`
-- -----------------------------
INSERT INTO `ey_weapp_demo` VALUES ('2', '1', '易优CMS', 'http://www.eyoucms.com', '', '100', '1', '', '', '1', '0', '1524975826', '0');
INSERT INTO `ey_weapp_demo` VALUES ('3', '2', '织梦58', 'http://www.dede58.com', 'http://www.eyoucms.dev/public/upload/system/2018/04/29/814ece093a0ba636209255dc20bd6e62.png', '100', '0', '', '', '1', '0', '1524976095', '1524976135');
INSERT INTO `ey_weapp_demo` VALUES ('4', '1', 'ThinkPHP官网', 'http://www.thinkphp.cn', '', '100', '1', '', '', '1', '0', '1525266497', '1525266608');
INSERT INTO `ey_weapp_demo` VALUES ('5', '1', '微信小程序开发教程', 'http://www.yiyongtong.com', '', '100', '1', '', '', '1', '0', '1525748425', '0');

-- -----------------------------
-- Table structure for `ey_weapp_linkkeyword`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_linkkeyword`;
CREATE TABLE `ey_weapp_linkkeyword` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '关键词',
  `url` varchar(200) NOT NULL DEFAULT '' COMMENT '链接地址',
  `target` tinyint(1) NOT NULL DEFAULT '0' COMMENT '新窗口',
  `sort_order` int(10) NOT NULL DEFAULT '0' COMMENT '排序号',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态(1=启用，0=禁用)',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;


-- -----------------------------
-- Table structure for `ey_weapp_messages`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_messages`;
CREATE TABLE `ey_weapp_messages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) DEFAULT '' COMMENT '通知标题',
  `users_id` text COMMENT '通知用户账号',
  `remark` text COMMENT '通知信息',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `ey_weapp_messages_read`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_messages_read`;
CREATE TABLE `ey_weapp_messages_read` (
  `messages_id` int(11) NOT NULL AUTO_INCREMENT,
  `users_id` varchar(50) DEFAULT NULL COMMENT '用户账号',
  `id` int(10) DEFAULT NULL COMMENT '站内信id',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`messages_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `ey_weapp_minicount`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_minicount`;
CREATE TABLE `ey_weapp_minicount` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `day` int(10) DEFAULT '0' COMMENT '今天流量',
  `total` int(10) DEFAULT '0' COMMENT '总流量',
  `dayline` int(10) DEFAULT '0',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `users_id` (`dayline`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_weapp_minicount`
-- -----------------------------
INSERT INTO `ey_weapp_minicount` VALUES ('1', '3', '3', '1', '1524975826', '1600738692');

-- -----------------------------
-- Table structure for `ey_weapp_minicount_log`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_minicount_log`;
CREATE TABLE `ey_weapp_minicount_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ip` varchar(20) DEFAULT '',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `ip` (`ip`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_weapp_minicount_log`
-- -----------------------------
INSERT INTO `ey_weapp_minicount_log` VALUES ('1', '127.0.0.1', '1600738682', '1600738692');

-- -----------------------------
-- Table structure for `ey_weapp_pushall`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_pushall`;
CREATE TABLE `ey_weapp_pushall` (
  `aid` int(100) NOT NULL COMMENT '文章ID',
  `baidupushzt` int(1) NOT NULL DEFAULT '0' COMMENT '百度推送状态',
  `shenmapushzt` int(1) NOT NULL DEFAULT '0' COMMENT '神马推送状态',
  `sogoupushzt` int(1) NOT NULL DEFAULT '0' COMMENT '搜狗推送状态',
  `toutiaopushzt` int(1) NOT NULL DEFAULT '0' COMMENT '头条推送状态',
  PRIMARY KEY (`aid`),
  UNIQUE KEY `aid` (`aid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `ey_weapp_pushalltag`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_pushalltag`;
CREATE TABLE `ey_weapp_pushalltag` (
  `aid` int(100) NOT NULL COMMENT '文章ID',
  `baidupushzt` int(1) NOT NULL DEFAULT '0' COMMENT '百度推送状态',
  `shenmapushzt` int(1) NOT NULL DEFAULT '0' COMMENT '神马推送状态',
  `sogoupushzt` int(1) NOT NULL DEFAULT '0' COMMENT '搜狗推送状态',
  `toutiaopushzt` int(1) NOT NULL DEFAULT '0' COMMENT '头条推送状态',
  PRIMARY KEY (`aid`),
  UNIQUE KEY `aid` (`aid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `ey_weapp_sitecollect`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_sitecollect`;
CREATE TABLE `ey_weapp_sitecollect` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) DEFAULT '' COMMENT '任务名称',
  `typeid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '采集栏目',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `is_desc` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否倒序采集',
  `is_status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '入库状态(1=显示，0=屏蔽(草稿))',
  `is_litpic` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否获取第一张图片为封面',
  `is_filt_repet` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否过滤重复标题',
  `is_local` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '图片是否本地保存',
  `filt_iframe` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否过滤Iframe',
  `filt_js` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `filt_a` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `filt_style` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `filt_object` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `filt_note` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `filt_table` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `filt_img` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `filt_embed` tinyint(1) NOT NULL DEFAULT '0',
  `filt_param` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `filt_div_b` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `filt_div_e` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `get_style` tinyint(1) unsigned NOT NULL DEFAULT '2' COMMENT '获取方式，1：手工输入，2：批量生成',
  `url_rule` varchar(255) NOT NULL DEFAULT '' COMMENT '网址规则',
  `min_id` int(6) unsigned NOT NULL DEFAULT '1' COMMENT '最小值页码',
  `max_id` int(6) unsigned NOT NULL DEFAULT '0' COMMENT '最大值页码',
  `list_rule` varchar(255) NOT NULL DEFAULT '' COMMENT '列表规则',
  `a_rule` varchar(255) NOT NULL DEFAULT '' COMMENT '页面链接规则',
  `a_involve` varchar(100) NOT NULL DEFAULT '' COMMENT '必须包含',
  `a_exclusive` varchar(100) NOT NULL DEFAULT '' COMMENT '不能包含',
  `is_list_litpic` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '获取列表缩略图',
  `litpic_rule` varchar(255) NOT NULL DEFAULT '' COMMENT '列表缩略图规则',
  `is_page` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否文章分页',
  `page_a_rule` varchar(255) NOT NULL DEFAULT '' COMMENT '页面正则代码',
  `page_list_rule` varchar(255) NOT NULL DEFAULT '' COMMENT '分页正则代码',
  `sort_order` int(6) unsigned NOT NULL DEFAULT '100',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态，1：启用，0：锁定',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='文章采集任务列表';

-- -----------------------------
-- Records of `ey_weapp_sitecollect`
-- -----------------------------
INSERT INTO `ey_weapp_sitecollect` VALUES ('1', '示例任务(示例网址：http://www.zzfrjt.com/nba/index_2.html)', '10', '1589179925', '1589179925', '1', '1', '1', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '2', 'http://www.zzfrjt.com/nba/index_{{id}}.html', '2', '3', '&lt;ul id=\'listNewsTimeLy\' class=&quot;listNewsTimeLy&quot;&gt;[内容]&lt;div class=&quot;pagnation&quot; id=&quot;pagnation&quot; style=&quot;padding-bottom:30px;&quot;&gt;', '&lt;a class=&quot;J-share-a&quot; href=&quot;[内容]&quot; target=&quot;_blank&quot;&gt;', '', '', '1', '&lt;img class=&quot;animation&quot; src=&quot;[内容]&quot;', '0', '', '', '100', '1');
INSERT INTO `ey_weapp_sitecollect` VALUES ('2', '电脑站模板采集', '13', '1589179954', '1589338310', '1', '0', '0', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '', '1', '0', '&lt;ul class=&quot;blocks-2 blocks-lg-3 met-pager-ajax met-grid&quot;&gt;\r\n[内容]\r\n        &lt;/ul&gt;\r\n      &lt;/div&gt;\r\n    &lt;/div&gt;\r\n  &lt;/div&gt;\r\n&lt;/div&gt;\r\n', '&lt;figure class=&quot;widget-header cover&quot;&gt; &lt;a href=&quot;[内容]&quot;', '', '', '1', '&lt;img class=&quot;cover-image&quot; data-original=&quot;[内容]&quot;', '0', '', '', '100', '1');
INSERT INTO `ey_weapp_sitecollect` VALUES ('4', '新闻采集', '24', '1589330098', '1589330918', '1', '1', '0', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', 'https://www.shwlz.com/jzzx.html?pagesize=10&amp;p=3', '1', '0', '&lt;ul class=&quot;textlist&quot;&gt;[内容]&lt;/ul&gt;', '', '', '', '0', '', '0', '', '', '100', '1');

-- -----------------------------
-- Table structure for `ey_weapp_sitecollet_record`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_sitecollet_record`;
CREATE TABLE `ey_weapp_sitecollet_record` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `collectid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '采集列表id',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '标题',
  `url_list` text NOT NULL COMMENT '执行url集合（json格式）',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `collectid` (`collectid`)
) ENGINE=MyISAM AUTO_INCREMENT=46 DEFAULT CHARSET=utf8 COMMENT='文章采集记录列表';

-- -----------------------------
-- Records of `ey_weapp_sitecollet_record`
-- -----------------------------
INSERT INTO `ey_weapp_sitecollet_record` VALUES ('37', '2', '电脑站模板采集', '[\"https:\\/\\/www.eyoucms.com\\/moban\\/\"]', '1589186342', '1589186342');
INSERT INTO `ey_weapp_sitecollet_record` VALUES ('38', '3', '案例采集', '[\"https:\\/\\/www.eyoucms.com\\/anli\\/list_4_15.html\",\"https:\\/\\/www.eyoucms.com\\/anli\\/list_4_14.html\"]', '1589188627', '1589188627');
INSERT INTO `ey_weapp_sitecollet_record` VALUES ('39', '2', '电脑站模板采集', '[\"https:\\/\\/www.eyoucms.com\\/moban\\/list_3_2.html\"]', '1589251086', '1589251086');
INSERT INTO `ey_weapp_sitecollet_record` VALUES ('40', '4', '新闻采集', '[\"https:\\/\\/www.shwlz.com\\/jzzx.html?pagesize=10&amp;p=3\"]', '1589330331', '1589330331');
INSERT INTO `ey_weapp_sitecollet_record` VALUES ('41', '4', '新闻采集', '[\"https:\\/\\/www.shwlz.com\\/seo.html?pagesize=10&amp;p=1\"]', '1589330512', '1589330512');
INSERT INTO `ey_weapp_sitecollet_record` VALUES ('42', '4', '新闻采集', '[\"https:\\/\\/www.shwlz.com\\/wxyx.html\"]', '1589330764', '1589330764');
INSERT INTO `ey_weapp_sitecollet_record` VALUES ('43', '4', '新闻采集', '[\"https:\\/\\/www.shwlz.com\\/xwdt.html\"]', '1589330842', '1589330842');
INSERT INTO `ey_weapp_sitecollet_record` VALUES ('44', '4', '新闻采集', '[\"https:\\/\\/www.shwlz.com\\/faq.html?pagesize=20&amp;p=1\"]', '1589330945', '1589330945');
INSERT INTO `ey_weapp_sitecollet_record` VALUES ('45', '2', '电脑站模板采集', '[\"https:\\/\\/www.eyoucms.com\\/moban\\/list_3_21.html\"]', '1589338349', '1589338349');

-- -----------------------------
-- Table structure for `ey_weapp_sitecollet_rule`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_sitecollet_rule`;
CREATE TABLE `ey_weapp_sitecollet_rule` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `collectid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '采集列表id',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '字段名称',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '字段别名（中文）',
  `rule` varchar(255) NOT NULL DEFAULT '' COMMENT '采集规则',
  `origin` varchar(255) NOT NULL DEFAULT '' COMMENT '初始字符串',
  `replace` varchar(255) NOT NULL DEFAULT '' COMMENT '替换字符串',
  `default` varchar(255) NOT NULL DEFAULT '' COMMENT '默认值（不采集）',
  `is_page` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否应用于分页',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `collectid` (`collectid`)
) ENGINE=MyISAM AUTO_INCREMENT=359 DEFAULT CHARSET=utf8 COMMENT='文章采集规则列表';

-- -----------------------------
-- Records of `ey_weapp_sitecollet_rule`
-- -----------------------------
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('37', '1', 'seo_description', 'SEO描述', '', '', '', '', '0', '1589179925', '1589179925');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('38', '1', 'seo_keywords', 'SEO关键词', '', '', '', '', '0', '1589179925', '1589179925');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('39', '1', 'seo_title', 'SEO标题', '', '', '', '', '0', '1589179925', '1589179925');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('40', '1', 'litpic', '缩略图', '', '', '', '', '0', '1589179925', '1589179925');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('41', '1', 'title', '标题', '&lt;h1&gt;&lt;span&gt;[内容]&lt;/span&gt;&lt;/h1&gt;', '', '', '', '0', '1589179925', '1589179925');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('42', '1', 'content', '内容详情', '&lt;div class=&quot;J-contain_detail_cnt contain_detail_cnt&quot;&gt;[内容]&lt;p&gt;上一篇', '', '', '', '1', '1589179925', '1589179925');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('43', '1', 'add_time', '新增时间', '', '', '', '', '0', '1589179925', '1589179925');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('44', '1', 'duoxuan', '多选项测试', '', '', '', '', '0', '1589179925', '1589179925');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('45', '1', 'xialakuang', '下拉框测试', '', '', '', '', '0', '1589179925', '1589179925');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('46', '1', 'danxuan', '但选项测试', '', '', '', '', '0', '1589179925', '1589179925');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('358', '2', 'users_price', '价格', '', '', '', '', '0', '1589338310', '1589338310');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('356', '2', 'diy_mbbh', '模板编号', '&lt;dd&gt;模板编号：[内容]&lt;/dd&gt;', '', '', '', '0', '1589338310', '1589338310');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('357', '2', 'diy_webewm', '网站二维码', '', '', '', '', '0', '1589338310', '1589338310');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('355', '2', 'diy_pcys', '电脑站演示地址', '&lt;a id=&quot;collect-btn&quot; class=&quot;collect-btn nonofavV3&quot; href=&quot;[内容]&quot; target=&quot;_blank&quot;  rel=&quot;nofollow&quot;&gt;模板演示&lt;/a&gt;\r\n', '/plus/', 'https://www.eyoucms.com/plus/', '', '0', '1589338310', '1589338310');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('354', '2', 'diy_mbys', '手机站演示地址', '&lt;a id=&quot;collect-btn&quot; class=&quot;collect-btn nonofavV3&quot; href=&quot;[内容]&quot; target=&quot;_blank&quot;  rel=&quot;nofollow&quot;&gt;模板演示&lt;/a&gt;\r\n', '/plus/', 'https://www.eyoucms.com/plus/', '', '0', '1589338310', '1589338310');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('349', '2', 'seo_keywords', 'SEO关键词', '', '', '', '', '0', '1589338310', '1589338310');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('352', '2', 'yanse', '颜色', '&lt;dd&gt;模板颜色：[内容]&lt;/dd&gt;', '', '', '', '0', '1589338310', '1589338310');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('353', '2', 'sshy', '所属行业', 'class=&quot;cjzy&quot;&gt;[内容]&lt;/a&gt;', '', '', '', '0', '1589338310', '1589338310');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('347', '2', 'litpic', '缩略图', '', '', '', '', '0', '1589338310', '1589338310');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('348', '2', 'seo_title', 'SEO标题', '', '', '', '', '0', '1589338310', '1589338310');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('302', '4', 'alwz', '案例网址', '', '', '', '', '0', '1589330918', '1589330918');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('299', '4', 'seo_keywords', 'SEO关键词', '', '东莞建站公司,企业网站建设,公司网站定制,企业网站优化,网络', '企业网站建设', '', '0', '1589330918', '1589330918');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('300', '4', 'seo_description', 'SEO描述', '', '', '', '', '0', '1589330918', '1589330918');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('301', '4', 'add_time', '新增时间', '', '', '', '', '0', '1589330918', '1589330918');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('297', '4', 'litpic', '缩略图', '', '', '', '', '0', '1589330918', '1589330918');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('298', '4', 'seo_title', 'SEO标题', '', '', '', '', '0', '1589330918', '1589330918');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('296', '4', 'content', '内容详情', '&lt;div class=&quot;InfoContent&quot;&gt;[内容]&lt;div class=&quot;Tag&quot;&gt;', '', '', '', '1', '1589330918', '1589330918');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('295', '4', 'title', '标题', '&lt;div class=&quot;InfoTitle&quot;&gt;&lt;h1&gt;[内容]&lt;/h1&gt;&lt;/div&gt;\r\n', '东莞', '', '', '0', '1589330918', '1589330918');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('351', '2', 'add_time', '新增时间', '', '', '', '', '0', '1589338310', '1589338310');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('350', '2', 'seo_description', 'SEO描述', '', '', '', '', '0', '1589338310', '1589338310');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('346', '2', 'content', '内容详情', '&lt;div class=&quot;clearfix&quot;&gt;[内容]&lt;/div&gt;\r\n', '', '', '', '1', '1589338310', '1589338310');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('345', '2', 'title', '标题', '&lt;h1&gt;\r\n            [内容]\r\n            &lt;/h1&gt;', '', '', '', '0', '1589338310', '1589338310');

-- -----------------------------
-- Table structure for `ey_weapp_sitecollet_urllist`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_sitecollet_urllist`;
CREATE TABLE `ey_weapp_sitecollet_urllist` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `collectid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '采集列表id',
  `url` varchar(512) NOT NULL DEFAULT '' COMMENT '文章url',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `collectid` (`collectid`)
) ENGINE=MyISAM AUTO_INCREMENT=63 DEFAULT CHARSET=utf8 COMMENT='文章采集链接列表';

-- -----------------------------
-- Records of `ey_weapp_sitecollet_urllist`
-- -----------------------------
INSERT INTO `ey_weapp_sitecollet_urllist` VALUES ('37', '1', 'http://www.zzfrjt.com/nba/index_3.html', '1589179925', '1589179925');
INSERT INTO `ey_weapp_sitecollet_urllist` VALUES ('38', '1', 'http://www.zzfrjt.com/nba/index_2.html', '1589179925', '1589179925');
INSERT INTO `ey_weapp_sitecollet_urllist` VALUES ('62', '2', 'https://www.eyoucms.com/moban/list_3_21.html', '1589338258', '1589338258');
INSERT INTO `ey_weapp_sitecollet_urllist` VALUES ('61', '4', 'https://www.shwlz.com/faq.html?pagesize=20&amp;p=1', '1589330889', '1589330889');

-- -----------------------------
-- Table structure for `ey_wx_users`
-- -----------------------------
DROP TABLE IF EXISTS `ey_wx_users`;
CREATE TABLE `ey_wx_users` (
  `wxuser_id` int(11) NOT NULL AUTO_INCREMENT,
  `users_id` int(11) NOT NULL DEFAULT '0' COMMENT '用户id',
  `openid` varchar(100) NOT NULL DEFAULT '' COMMENT 'openid',
  `nickname` varchar(100) NOT NULL DEFAULT '' COMMENT '微信昵称',
  `headimgurl` varchar(200) NOT NULL DEFAULT '' COMMENT '头像',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`wxuser_id`),
  KEY `openid` (`openid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='微信小程序用户表';

