<?php

namespace Home\Controller;
use Think\Controller;

class PublicController extends Controller {
	protected $config = array('app_type' => 'public');
	/**
	 * 後台用戶登錄
	 * @author 麥當苗兒 <zuojiazi@vip.qq.com>
	 */
	public function login() {
		
		$this -> assign("is_verify_code", get_system_config("IS_VERIFY_CODE"));
		$auth_id = session(C('USER_AUTH_KEY'));
		if (!isset($auth_id)) {
			$this -> display();
		} else {
			header('Location: ' . __APP__);
		}
	}

	// 檢測輸入的驗證碼是否正確，$code為用戶輸入的驗證碼字符串
	function check_verify($code, $id = '') {
		$verify = new \Think\Verify();
		return $verify -> check($code, $id);
	}

	// 登錄檢測
	public function check_login() {
		$is_verify_code = get_system_config("IS_VERIFY_CODE");
		if (!empty($is_verify_code)) {
			$check = $this -> check_verify($_POST['verify'], 1);
			if (!$check) {
				$this -> error('驗證碼錯誤！');
			}
		}

		if (empty($_POST['emp_no'])) {
			$this -> error('帳號必須！');
		} elseif (empty($_POST['password'])) {
			$this -> error('密碼必須！');
		}
		if ($_POST['emp_no'] == 'admin') {
			$is_admin = true;
			session(C('ADMIN_AUTH_KEY'), true);
		}

		$map = array();
		// 支持使用綁定帳號登錄
		$map['emp_no'] = $_POST['emp_no'];
		$map["is_del"] = array('eq', 0);
		$map['password'] = array('eq', md5($_POST['password']));
		$model = M("User");
		$auth_info = $model -> where($map) -> find();

		//使用用戶名、密碼和狀態的方式進行認證
		if (false == $auth_info) {
			$this -> error('帳號或密碼錯誤！');
		} else {
			session(C('USER_AUTH_KEY'), $auth_info['id']);
			session('emp_no', $auth_info['emp_no']);
			session('user_name', $auth_info['name']);
			session('user_pic', $auth_info['pic']);
			session('dept_id', $auth_info['dept_id']);

			//保存登錄信息
			$User = M('User');
			$ip = get_client_ip();
			$time = time();
			$data = array();
			$data['id'] = $auth_info['id'];
			$data['last_login_time'] = $time;
			$data['login_count'] = array('exp', 'login_count+1');
			$data['last_login_ip'] = $ip;
			$User -> save($data);
			$this -> assign('jumpUrl', U("index/index"));
			header('Location: ' . U("index/index"));
		}
	}

	/* 退出登錄 */
	public function logout() {
		$auth_id = session(C('USER_AUTH_KEY'));
		if (isset($auth_id)) {
			session(C('USER_AUTH_KEY'), null);

			session('user_pic', null);
			$this -> assign("jumpUrl", __APP__);
			$this -> success('退出成功！');
		} else {
			$this -> assign("jumpUrl", __APP__);
			$this -> error('退出成功！');
		}
	}

	public function register() {
		$this -> display();
	}

	// 登錄檢測
	public function check_register() {
		$is_verify_code = get_system_config("IS_VERIFY_CODE");
		if (!empty($is_verify_code)) {
			if (session('verify') != md5($_POST['verify'])) {
				$this -> error('驗證碼錯誤！');
			}
		}

		if (empty($_POST['emp_no'])) {
			$this -> error('帳號必須！');
		} elseif (empty($_POST['password'])) {
			$this -> error('密碼必須！');
		} elseif ($_POST['password'] !== $_POST['check_password']) {
			$this -> error('密碼不一致');
		}

		$map = array();
		// 支持使用綁定帳號登錄
		$map['emp_no'] = $_POST['emp_no'];
		$count = M("User") -> where($map) -> count();

		if ($count) {
			$this -> error('該賬戶已註冊');
		} else {
			$model = D("User");
			if (false === $model -> create()) {
				$this -> error($model -> getError());
			}
			$list = $model -> add();
			if ($list !== false) {//保存成功
				$this -> assign('jumpUrl', get_return_url());
				$this -> success('註冊成功!');
			} else {
				$this -> error('註冊失敗!');
				//失敗提示
			}

		}
	}

	public function verify() {
		$config = array('fontSize' => 15, // 驗證碼字體大小
		'length' => 4, // 驗證碼位數
		'useNoise' => false, // 關閉驗證碼雜點
		);
		$verify = new \Think\Verify($config);
		$verify -> entry(1);
	}

	public function recevie_mail(){
		//linux 
		//echo 'curl "http://192.168.10.10/index.php?m=&c=public&a=recevie_mail"'>/root/auto_recevie_mail.sh
		//echo '*/10 * * * * /root/auto_recevie_mail.sh'>> //var/spool/cron/root
		
		//windows
		//server_url="http://xiaowei.localhost/index.php?m=&c=public&a=recevie_mail"
		//set ie=createobject("internetexplorer.application") 
		//ie.visible=0 
		//ie.navigate server_url
		//wscript.sleep 10*1000 '延遲10秒
		//ie.quit
		 
		$client_ip = $_SERVER["REMOTE_ADDR"]; 
		$server_ip = gethostbyname(null);
		if ($client_ip != $server_ip) {
			session_write_close();
			set_time_limit(0);
			$where['is_del'] = array('eq', 0);
			$mail_account_list = D("MailAccountView") -> where($where) -> select();
			foreach ($mail_account_list as $account) {
				R("Mail/receve", array($account['id'], true));
				sleep(1);
			}
			sleep(1);
		}
	}

}
