<?php
/*---------------------------------------------------------------------------
 豆芽網絡OA系統 - 讓工作更輕鬆快樂

 Copyright (c) 2013 http://oa.niucms.net All rights reserved.

 Author:  jinzhu.yin<smeoa@qq.com>

 Support: https://git.oschina.net/smeoa/xiaowei
 -------------------------------------------------------------------------*/
// 用戶模型
namespace Home\Model;
use Think\Model;

class TaskModel extends CommonModel {
	// 自動驗證設置
	protected $_validate = array( array('name', 'require', '文件名必須', 1), array('content', 'require', '內容必須'), );

	function _before_insert(&$data, $options) {
		$sql = "SELECT CONCAT(year(now()),'-',LPAD(count(*)+1,4,0)) task_no FROM `" . $this -> tablePrefix . "task` WHERE 1 and year(FROM_UNIXTIME(create_time))>=year(now())";
		$rs = $this -> db -> query($sql);
		if ($rs) {
			$data['task_no'] = $rs[0]['task_no'];
		} else {
			$data['task_no'] = date('Y') . "-0001";
		}
	}

	function _after_insert($data, $options) {
		$executor_list = $data['executor'];
		$executor_list = array_filter(explode(';', $executor_list));

		if (!empty($executor_list)) {
			foreach ($executor_list as $key => $val) {
				$tmp = explode('|', $val);
				$executor_name = $tmp[0];
				$executor = $tmp[1];

				if (strpos($executor, "dept_") !== false) {
					$type = 2;
					$executor = str_replace('dept_', '', $executor);					
					$where['dept_id']=array('eq',$executor);					
					$dept_user_list=M('User')->where($where)->getField('id',true);

					foreach($dept_user_list as $val){
						$auth=D("Role")->get_auth('Task',$val);
						if($auth['admin']){
							$user_list[]=$val;
						}
					}
				} else {
					$type = 1;
					$user_list[] = $executor;
				}

				$log_data['executor'] = $executor;
				$log_data['executor_name'] = $executor_name;
				$log_data['type'] = $type;
				$log_data['assigner'] = $data['user_id'];
				$log_data['task_id'] = $data['id'];
				M("TaskLog") -> add($log_data);
			}
			
			$push_data['type'] = '任務';
			$push_data['action'] = '需要執行';
			$push_data['title'] = "來自：" . get_dept_name()."-".get_user_name();
			$push_data['content'] = "標題：" . $data['name'];
			$push_data['url'] = U("Task/read?id={$data['id']}");
			
			send_push($push_data, $user_list);
		}
		
	}

	function forword($task_id, $executor_list) {
		$executor_list = array_filter(explode(';', $executor_list));

		if (!empty($executor_list)) {
			foreach ($executor_list as $key => $val) {
				$tmp = explode('|', $val);
				$executor_name = $tmp[0];
				$executor = $tmp[1];

				if (strpos($executor, "dept_") !== false) {
					$type = 2;
					$executor = str_replace('dept_', '', $executor);
				} else {
					$type = 1;
				}

				$log_data['executor'] = $executor;
				$log_data['executor_name'] = $executor_name;
				$log_data['type'] = $type;
				$log_data['assigner'] = get_user_id();
				$log_data['task_id'] = $task_id;
				M("TaskLog") -> add($log_data);
			}
		}
	}

	function _send_mail($task_id,$executor) {
		$executor_info=M("User")->where("id=$executor")->find();
		
		$email=$executor_info['email'];
		$user_name=$executor_info['name'];
				
		$info = M("Task") -> where("id=$task_id") -> find();

		$title="您有新的任務：".$info['name'];
		
		$body="您好，{$user_name}，{$info['user_name']} 有一個任務需要您的協助！</br>";
		$body.="任務主題：{$info['name']}</br>";
		$body.="任務時間：{$info['expected_time']}</br>";
		$body.="任務發起人：{$info['user_name']}</br>";
		$body.="請與{$info['user_name']}做好溝通，盡快完成任務。</br>";
		$body.="點擊查看任務詳情：http://". $_SERVER['SERVER_NAME'].U('Task/read','id='.$info['id'])."</br>";
		$body.="霞湖世家，感謝有您！</br>";

		send_mail($email, $user_name, $title, $body);
	}

}
?>