<?php

class ThinkWechat {

	/**
	 * 微信推送過來的數據或響應數據
	 * @var array
	 */
	private $data = array();
	
	/**
	 * 主動發送的數據
	 * @var array
	 */
	private $send = array();
		
	/**
	 * 獲取微信推送的數據
	 * @return array 轉換為數組後的數據
	 */
	public function request(){
		$this->auth() || exit;
		
		if(IS_GET){
			exit($_GET['echostr']);
		} else {
			$xml = file_get_contents("php://input");
			$xml = new SimpleXMLElement($xml);
			$xml || exit;
		
			foreach ($xml as $key => $value) {
				$this->data[$key] = strval($value);
			}
		}
       	return $this->data;
	}

	/**
	 * * 被動響應微信發送的信息（自動回復）
	 * @param  string $to      接收用戶名
	 * @param  string $from    發送者用戶名
	 * @param  array  $content 回覆信息，文本信息為string類型
	 * @param  string $type    消息類型
	 * @param  string $flag    是否新標剛接受到的信息
	 * @return string          XML字符串
	 */
	public function response($content, $type = 'text', $flag = 0){
		/* 基礎數據 */
		$this->data = array(
			'ToUserName'   => $this->data['FromUserName'],
			'FromUserName' => $this->data['ToUserName'],
			'CreateTime'   => NOW_TIME,
			'MsgType'      => $type,
		);

		/* 添加類型數據 */
		$this->$type($content);

		/* 添加狀態 */
		$this->data['FuncFlag'] = $flag;

		/* 轉換數據為XML */
		$xml = new SimpleXMLElement('<xml></xml>');
		$this->data2xml($xml, $this->data);
		exit($xml->asXML());
	}

	/**
	 * * 主動發送消息
	 *
	 * @param string $content   內容
	 * @param string $openid   	發送者用戶名
	 * @param string $type   	類型
	 * @return array 返回的信息
	 */
	
	public function sendMsg($content, $openid = '', $type = 'text') {
		/* 基礎數據 */
		$this->send ['touser'] = $openid;
		$this->send ['msgtype'] = $type;
		
		/* 添加類型數據 */
		$sendtype = 'send' . $type;
		$this->$sendtype ( $content );
			
		/* 發送 */
		$sendjson = jsencode ( $this->send );
		$restr = $this->send ( $sendjson );
		return $restr;
	}
	
	/**
	 * 發送文本消息
	 * 
	 * @param string $content
	 *        	要發送的信息
	 */
	private function sendtext($content) {
		$this->send ['text'] = array (
				'content' => $content 
		);
	}
	
	/**
	 * 發送圖片消息
	 * 
	 * @param string $content
	 *        	要發送的信息
	 */
	private function sendimage($content) {
		$this->send ['image'] = array (
				'media_id' => $content 
		);
	}

	/**
	 * 發送視頻消息
	 * @param  string $content 要發送的信息
	 */
	private function sendvideo($video){
		list (
			$video ['media_id'],
			$video ['title'],
			$video ['description']
		) = $video;
		
		$this->send ['video'] = $video;
	}
	
	/**
	 * 發送語音消息
	 * 
	 * @param string $content
	 *        	要發送的信息
	 */
	private function sendvoice($content) {
		$this->send ['voice'] = array (
				'media_id' => $content 
		);
	}
	
	/**
	 * 發送音樂消息
	 * 
	 * @param string $content
	 *        	要發送的信息
	 */
	private function sendmusic($music) {
		list ( 
			$music ['title'], 
			$music ['description'], 
			$music ['musicurl'], 
			$music ['hqmusicurl'], 
			$music ['thumb_media_id']
		) = $music;
		
		$this->send ['music'] = $music;
	}
	
	/**
	 * 發送圖文消息
	 * @param  string $news 要回復的圖文內容
	 */
	private function sendnews($news){
		$articles = array();
		foreach ($news as $key => $value) {
			list(
					$articles[$key]['title'],
					$articles[$key]['description'],
					$articles[$key]['url'],
					$articles[$key]['picurl']
			) = $value;
			if($key >= 9) { break; } //最多只允許10調新聞
		}
		$this->send['articles'] = $articles;
	}
		
	/**
	 * * 獲取微信用戶的基本資料
	 * 
	 * @param string $openid   	發送者用戶名
	 * @return array 用戶資料
	 */

	public function user($openid = '') {
		if ($openid) {
			header ( "Content-type: text/html; charset=utf-8" );
			$url = 'https://api.weixin.qq.com/cgi-bin/user/info';
			$params = array ();
			$params ['access_token'] = $this->getToken ();
			$params ['openid'] = $openid;
			$httpstr = http ( $url,$params,"POST");
			$harr = json_decode ($httpstr, true );
			return $harr;
		} else {
			return false;
		}
	}
	
	public function openid($code = '') {
		if ($code) {
			header ( "Content-type: text/html; charset=utf-8" );
			$url = 'https://api.weixin.qq.com/sns/oauth2/access_token';
			$params = array ();
			$params['appid'] = C ('WECHAT_APPID');
			$params['secret']  = C ('WECHAT_APPSECRET');
			$params ['code'] = $code;
			$params ['grant_type'] = "authorization_code";
			 
			$httpstr = http ( $url, $params,'POST' );
			$harr = json_decode ( $httpstr, true );
			return $harr['openid'];
		} else {
			return false;
		}
	}

	/**
	 * 生成菜單
	 * @param  string $data 菜單的str
	 * @return string  返回的結果；
	 */
	public function setMenu($data = NULL){
		$access_token = $this->getToken();
		$url = "https://api.weixin.qq.com/cgi-bin/menu/create?access_token={$access_token}";
		$menustr = http($url, $data, 'POST', array("Content-type: text/html; charset=utf-8"), true);
		return $menustr;
	}

	/**
	 * 回覆文本信息
	 * @param  string $content 要回復的信息
	 */
	private function text($content){
		$this->data['Content'] = $content;
	}

	/**
	 * 回復音樂信息
	 * @param  string $content 要回復的音樂
	 */
	private function music($music){
		list(
			$music['Title'], 
			$music['Description'], 
			$music['MusicUrl'], 
			$music['HQMusicUrl']
		) = $music;
		$this->data['Music'] = $music;
	}

	/**
	 * 回復圖文信息
	 * @param  string $news 要回復的圖文內容
	 */
	private function news($news){
		$articles = array();
		foreach ($news as $key => $value) {
			list(
				$articles[$key]['Title'],
				$articles[$key]['Description'],
				$articles[$key]['PicUrl'],
				$articles[$key]['Url']
			) = $value;
			if($key >= 9) { break; } //最多只允許10調新聞
		}
		$this->data['ArticleCount'] = count($articles);
		$this->data['Articles'] = $articles;
	}
		
	/**
	 * 主動發送的信息
	 * @param  string $data    json數據
	 * @return string          微信返回信息
	 */
	private function send($data = NULL) {
		$access_token = $this->getToken ();
		$url = "https://api.weixin.qq.com/cgi-bin/message/custom/send?access_token={$access_token}";
		$restr = http ( $url, $data, 'POST', array ( "Content-type: text/html; charset=utf-8" ), true );
		return $restr;
	}

	/**
     * 數據XML編碼
     * @param  object $xml  XML對像
     * @param  mixed  $data 數據
     * @param  string $item 數字索引時的節點名稱
     * @return string
     */
    private function data2xml($xml, $data, $item = 'item') {
        foreach ($data as $key => $value) {
            /* 指定默認的數字key */
            is_numeric($key) && $key = $item;

            /* 添加子元素 */
            if(is_array($value) || is_object($value)){
                $child = $xml->addChild($key);
                $this->data2xml($child, $value, $item);
            } else {
            	if(is_numeric($value)){
            		$child = $xml->addChild($key, $value);
            	} else {
            		$child = $xml->addChild($key);
	                $node  = dom_import_simplexml($child);
				    $node->appendChild($node->ownerDocument->createCDATASection($value));
            	}
            }
        }
    }

    /**
	 * 對數據進行簽名認證，確保是微信發送的數據
	 * @param  string $token 微信開放平台設置的TOKEN
	 * @return boolean       true-簽名正確，false-簽名錯誤
	 */
	private function auth(){
		/* 獲取數據 */
		$data = array($_GET['timestamp'], $_GET['nonce'], C ( 'WECHAT_TOKEN' ));
		$sign = $_GET['signature'];
		
		/* 對數據進行字典排序 */
		sort($data);

		/* 生成簽名 */
		$signature = sha1(implode($data));

		return $signature === $sign;
	}
		
	/**
	 * 獲取保存的accesstoken
	 */
	private function getToken(){
		$stoken = array ();
		$stoken = S ( 'S_TOKEN'); // 從緩存獲取ACCESS_TOKEN

		if (is_array ($stoken)&&!empty($stoken['token'])) {
			$nowtime = time ();
			$difftime = $nowtime - $stoken ['tokentime']; // 判斷緩存裡面的TOKEN保存了多久；
			if ($difftime > 7000) { // TOKEN有效時間7200 判斷超過7000就重新獲取;
				$accesstoken = $this->getAcessToken(); // 去微信獲取最新ACCESS_TOKEN
				$stoken ['tokentime'] = time ();
				$stoken ['token'] = $accesstoken;
				S ( 'S_TOKEN', $stoken,300); // 放進緩存
			} else {
				$accesstoken = $stoken ['token'];
			}
		} else {
			$accesstoken = $this->getAcessToken(); // 去微信獲取最新ACCESS_TOKEN
			$stoken ['tokentime'] = time ();
			$stoken ['token'] = $accesstoken;
			S ('S_TOKEN', $stoken); // 放進緩存
		}
		
		return $accesstoken;
	}
	
	/**
	 * 重新從微信獲取accesstoken
	 */

	private function getAcessToken() {
		$token = C ( 'WECHAT_TOKEN' );
		$appid = C ( 'WECHAT_APPID' );
		$appsecret = C ( 'WECHAT_APPSECRET' );

		$url = 'https://api.weixin.qq.com/cgi-bin/token';
		$params = array ();
		$params ['grant_type'] = 'client_credential';
		$params ['appid'] = $appid;
		$params ['secret'] = $appsecret;
		$httpstr = http($url,$params);
		$harr = json_decode ( $httpstr, true );
		return $harr ['access_token'];
	}
}
