-- MySQL dump 10.13  Distrib 5.5.40, for Win32 (x86)
--
-- Host: localhost    Database: xiaoniu
-- ------------------------------------------------------
-- Server version	5.5.40

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `xiaoniu_contact`
--

DROP TABLE IF EXISTS `xiaoniu_contact`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `xiaoniu_contact` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL DEFAULT '' COMMENT '姓名',
  `letter` varchar(50) NOT NULL DEFAULT '' COMMENT '拼音',
  `company` varchar(30) NOT NULL DEFAULT '' COMMENT '公司',
  `dept` varchar(20) NOT NULL DEFAULT '' COMMENT '部門',
  `position` varchar(20) NOT NULL DEFAULT '' COMMENT '職位',
  `email` varchar(255) NOT NULL DEFAULT '' COMMENT '郵件',
  `office_tel` varchar(20) NOT NULL DEFAULT '' COMMENT '辦公電話',
  `mobile_tel` varchar(20) NOT NULL DEFAULT '' COMMENT '移動電話',
  `website` varchar(50) NOT NULL DEFAULT '' COMMENT '網站',
  `im` varchar(20) NOT NULL DEFAULT '' COMMENT '即時通訊',
  `address` varchar(50) NOT NULL DEFAULT '' COMMENT '地址',
  `user_id` int(11) NOT NULL DEFAULT '0' COMMENT '用戶ID',
  `remark` text COMMENT '備註',
  `is_del` tinyint(3) NOT NULL DEFAULT '0' COMMENT '刪除標記',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COMMENT='think_user_info';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `xiaoniu_contact`
--

LOCK TABLES `xiaoniu_contact` WRITE;
/*!40000 ALTER TABLE `xiaoniu_contact` DISABLE KEYS */;
/*!40000 ALTER TABLE `xiaoniu_contact` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `xiaoniu_customer`
--

DROP TABLE IF EXISTS `xiaoniu_customer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `xiaoniu_customer` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL DEFAULT '' COMMENT '名稱',
  `letter` varchar(50) NOT NULL DEFAULT '' COMMENT '拼音',
  `biz_license` varchar(30) NOT NULL DEFAULT '' COMMENT '營業許可',
  `short` varchar(20) NOT NULL DEFAULT '' COMMENT '簡稱',
  `contact` varchar(20) NOT NULL DEFAULT '' COMMENT '聯繫人姓名',
  `email` varchar(255) NOT NULL DEFAULT '' COMMENT '郵件地址',
  `office_tel` varchar(20) NOT NULL DEFAULT '' COMMENT '辦公電話',
  `mobile_tel` varchar(20) NOT NULL DEFAULT '' COMMENT '移動電話',
  `fax` varchar(20) NOT NULL DEFAULT '' COMMENT '傳真',
  `salesman` varchar(50) NOT NULL DEFAULT '' COMMENT '業務員',
  `im` varchar(20) NOT NULL DEFAULT '' COMMENT '即時通訊',
  `address` varchar(50) NOT NULL DEFAULT '' COMMENT '地址',
  `user_id` int(11) NOT NULL DEFAULT '0' COMMENT '用戶ID',
  `remark` text COMMENT '備註',
  `is_del` tinyint(3) NOT NULL DEFAULT '0' COMMENT '刪除標記',
  `payment` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `xiaoniu_customer`
--

LOCK TABLES `xiaoniu_customer` WRITE;
/*!40000 ALTER TABLE `xiaoniu_customer` DISABLE KEYS */;
/*!40000 ALTER TABLE `xiaoniu_customer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `xiaoniu_dept`
--

DROP TABLE IF EXISTS `xiaoniu_dept`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `xiaoniu_dept` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) NOT NULL DEFAULT '0' COMMENT '父級ID',
  `dept_no` varchar(20) NOT NULL DEFAULT '' COMMENT '部門編號',
  `dept_grade_id` int(11) NOT NULL DEFAULT '0' COMMENT '部門等級ID',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '名稱',
  `short` varchar(20) NOT NULL DEFAULT '' COMMENT '簡稱',
  `sort` varchar(20) NOT NULL DEFAULT '' COMMENT '排序',
  `remark` varchar(255) NOT NULL DEFAULT '' COMMENT '備註',
  `is_del` tinyint(3) NOT NULL DEFAULT '0' COMMENT '刪除標記',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `xiaoniu_dept`
--

LOCK TABLES `xiaoniu_dept` WRITE;
/*!40000 ALTER TABLE `xiaoniu_dept` DISABLE KEYS */;
INSERT INTO `xiaoniu_dept` VALUES (1,0,'A2',18,'豆芽網絡網絡科技','豆芽網絡','','',0),(2,1,'YYB',18,'運營部','運營','5','',0),(3,1,'XXB',18,'IT部','IT','4','',0),(5,1,'ZJB',18,'總經辦','總經','1','',0),(6,1,'GLB',18,'管理部','管理','2','',0),(7,1,'XSB',18,'銷售部','銷售','3','',0),(8,1,'CWB',18,'財務部','財務','2','',0),(21,1,'XSB',18,'採購部','採購','3','',0),(23,6,'HR',16,'人事科','人事','','',0),(24,6,'ZWK',16,'總務科','總務','','',0),(25,8,'KJK',16,'會計科','會計','','',0),(26,8,'JRK',16,'金融科','金融','','',0),(27,0,'',0,'豆芽網絡科技','豆芽網絡','','',0),(28,27,'',16,'信息部','信息','','',0);
/*!40000 ALTER TABLE `xiaoniu_dept` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `xiaoniu_dept_grade`
--

DROP TABLE IF EXISTS `xiaoniu_dept_grade`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `xiaoniu_dept_grade` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `grade_no` varchar(10) NOT NULL DEFAULT '' COMMENT '部門級別編碼',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '名稱',
  `sort` varchar(10) NOT NULL DEFAULT '' COMMENT '排序',
  `is_del` tinyint(3) NOT NULL DEFAULT '0' COMMENT '刪除標記',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `xiaoniu_dept_grade`
--

LOCK TABLES `xiaoniu_dept_grade` WRITE;
/*!40000 ALTER TABLE `xiaoniu_dept_grade` DISABLE KEYS */;
INSERT INTO `xiaoniu_dept_grade` VALUES (16,'DG1','科','1',0),(18,'DG2','部','2',0);
/*!40000 ALTER TABLE `xiaoniu_dept_grade` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `xiaoniu_doc`
--

DROP TABLE IF EXISTS `xiaoniu_doc`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `xiaoniu_doc` (
  `id` smallint(4) unsigned NOT NULL AUTO_INCREMENT,
  `doc_no` varchar(20) NOT NULL DEFAULT '' COMMENT '文檔編號',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '名稱',
  `content` text NOT NULL COMMENT '內容',
  `folder` int(11) NOT NULL DEFAULT '0' COMMENT '文件夾',
  `add_file` varchar(200) NOT NULL DEFAULT '' COMMENT '附件',
  `user_id` int(11) NOT NULL DEFAULT '0' COMMENT '用戶ID',
  `user_name` varchar(20) NOT NULL DEFAULT '' COMMENT '用戶名稱',
  `create_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '創建時間',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新時間',
  `is_del` tinyint(3) NOT NULL DEFAULT '0' COMMENT '刪除標記',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=94 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `xiaoniu_doc`
--

LOCK TABLES `xiaoniu_doc` WRITE;
/*!40000 ALTER TABLE `xiaoniu_doc` DISABLE KEYS */;
/*!40000 ALTER TABLE `xiaoniu_doc` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `xiaoniu_duty`
--

DROP TABLE IF EXISTS `xiaoniu_duty`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `xiaoniu_duty` (
  `id` smallint(3) NOT NULL AUTO_INCREMENT,
  `duty_no` varchar(20) NOT NULL DEFAULT '' COMMENT '職責編號',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '名稱',
  `sort` varchar(20) NOT NULL DEFAULT '' COMMENT '排序',
  `is_del` tinyint(3) NOT NULL DEFAULT '0' COMMENT '刪除標記',
  `remark` varchar(255) NOT NULL DEFAULT '' COMMENT '備註',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `xiaoniu_duty`
--

LOCK TABLES `xiaoniu_duty` WRITE;
/*!40000 ALTER TABLE `xiaoniu_duty` DISABLE KEYS */;
INSERT INTO `xiaoniu_duty` VALUES (14,'P001','普通員工','',0,''),(15,'S001','財務','',0,''),(16,'W001','人事','',0,'');
/*!40000 ALTER TABLE `xiaoniu_duty` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `xiaoniu_file`
--

DROP TABLE IF EXISTS `xiaoniu_file`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `xiaoniu_file` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '文件ID',
  `name` char(30) NOT NULL DEFAULT '' COMMENT '原始文件名',
  `savename` char(20) NOT NULL DEFAULT '' COMMENT '保存名稱',
  `savepath` char(30) NOT NULL DEFAULT '' COMMENT '文件保存路徑',
  `ext` char(5) NOT NULL DEFAULT '' COMMENT '文件後綴',
  `mime` char(40) NOT NULL DEFAULT '' COMMENT '文件mime類型',
  `size` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '文件大小',
  `md5` char(32) NOT NULL DEFAULT '' COMMENT '文件md5',
  `sha1` char(40) NOT NULL DEFAULT '' COMMENT '文件 sha1編碼',
  `location` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '文件保存位置',
  `url` varchar(255) NOT NULL DEFAULT '' COMMENT '遠程地址',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '上傳時間',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=81 DEFAULT CHARSET=utf8 COMMENT='文件表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `xiaoniu_file`
--

LOCK TABLES `xiaoniu_file` WRITE;
/*!40000 ALTER TABLE `xiaoniu_file` DISABLE KEYS */;
/*!40000 ALTER TABLE `xiaoniu_file` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `xiaoniu_finance`
--

DROP TABLE IF EXISTS `xiaoniu_finance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `xiaoniu_finance` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `doc_no` varchar(10) DEFAULT NULL COMMENT '單據編號',
  `remark` varchar(255) DEFAULT NULL,
  `input_date` date DEFAULT NULL COMMENT '錄入日期',
  `account_id` int(11) DEFAULT NULL COMMENT '帳號ID',
  `account_name` varchar(20) DEFAULT NULL COMMENT '帳號名',
  `income` int(11) DEFAULT NULL COMMENT '收入',
  `payment` int(11) DEFAULT NULL COMMENT '支出',
  `amount` int(11) DEFAULT NULL COMMENT '合計',
  `type` varchar(20) DEFAULT NULL COMMENT '類型',
  `partner` varchar(50) DEFAULT NULL COMMENT '來往處',
  `actor_name` varchar(10) DEFAULT NULL COMMENT '經辦人',
  `user_id` int(11) DEFAULT NULL COMMENT '登陸人',
  `user_name` varchar(10) DEFAULT NULL COMMENT '登錄名',
  `create_time` int(11) DEFAULT NULL COMMENT '創建日期',
  `update_time` int(11) DEFAULT NULL COMMENT '更新日期',
  `add_file` varchar(255) DEFAULT NULL COMMENT '附件',
  `doc_type` tinyint(3) DEFAULT NULL COMMENT '類型',
  `is_del` tinyint(3) DEFAULT '0' COMMENT '刪除標記',
  `related_account_id` int(11) DEFAULT NULL COMMENT '相關帳號ID',
  `related_account_name` varchar(20) DEFAULT NULL COMMENT '相關帳號名稱',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `xiaoniu_finance`
--

LOCK TABLES `xiaoniu_finance` WRITE;
/*!40000 ALTER TABLE `xiaoniu_finance` DISABLE KEYS */;
/*!40000 ALTER TABLE `xiaoniu_finance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `xiaoniu_finance_account`
--

DROP TABLE IF EXISTS `xiaoniu_finance_account`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `xiaoniu_finance_account` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(20) DEFAULT NULL COMMENT '帳號名稱',
  `bank` varchar(20) DEFAULT NULL COMMENT '銀行',
  `no` varchar(50) DEFAULT NULL COMMENT '銀行帳號',
  `init` int(11) DEFAULT NULL COMMENT '初始帳號',
  `balance` int(11) DEFAULT NULL COMMENT '餘額',
  `remark` varchar(200) DEFAULT NULL COMMENT '備註',
  `is_del` tinyint(3) DEFAULT '0' COMMENT '刪除標記',
  `create_time` int(11) DEFAULT NULL COMMENT '創建時間',
  `update_time` int(11) DEFAULT NULL COMMENT '更新時間',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `xiaoniu_finance_account`
--

LOCK TABLES `xiaoniu_finance_account` WRITE;
/*!40000 ALTER TABLE `xiaoniu_finance_account` DISABLE KEYS */;
INSERT INTO `xiaoniu_finance_account` VALUES (5,'農行','農行','1688',1000,NULL,'農行',0,1422690709,NULL),(6,'招商','招商','1188',1000,NULL,'招商',0,1422690709,NULL),(7,'華夏','華夏','8888',1000,NULL,'888',1,1422690709,NULL);
/*!40000 ALTER TABLE `xiaoniu_finance_account` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `xiaoniu_flow`
--

DROP TABLE IF EXISTS `xiaoniu_flow`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `xiaoniu_flow` (
  `id` smallint(4) unsigned NOT NULL AUTO_INCREMENT,
  `doc_no` varchar(20) NOT NULL DEFAULT '' COMMENT '文檔編號',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '名稱',
  `content` text NOT NULL COMMENT '內容',
  `confirm` varchar(200) NOT NULL DEFAULT '' COMMENT '裁決數據',
  `confirm_name` text NOT NULL COMMENT '裁決顯示內容',
  `consult` varchar(200) NOT NULL DEFAULT '' COMMENT '協商數據',
  `consult_name` text NOT NULL COMMENT '協商顯示內容',
  `refer` varchar(200) NOT NULL DEFAULT '' COMMENT '抄送數據',
  `refer_name` text NOT NULL COMMENT '抄送顯示內容',
  `type` varchar(20) NOT NULL DEFAULT '' COMMENT '流程類型',
  `add_file` varchar(200) NOT NULL DEFAULT '' COMMENT '附件',
  `user_id` int(11) NOT NULL DEFAULT '0' COMMENT '用戶ID',
  `emp_no` varchar(20) DEFAULT NULL COMMENT '員工編號',
  `user_name` varchar(20) NOT NULL DEFAULT '' COMMENT '用戶名稱',
  `dept_id` int(11) NOT NULL DEFAULT '0' COMMENT '部門ID',
  `dept_name` varchar(20) NOT NULL DEFAULT '' COMMENT '部門名稱',
  `create_date` varchar(10) NOT NULL DEFAULT '' COMMENT '創建日期',
  `create_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '創建時間',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新時間',
  `step` int(11) NOT NULL DEFAULT '0' COMMENT '目前階段狀態',
  `is_del` tinyint(3) NOT NULL DEFAULT '0' COMMENT '刪除標記',
  `udf_data` text COMMENT '用戶自定義數據',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=43 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `xiaoniu_flow`
--

LOCK TABLES `xiaoniu_flow` WRITE;
/*!40000 ALTER TABLE `xiaoniu_flow` DISABLE KEYS */;
/*!40000 ALTER TABLE `xiaoniu_flow` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `xiaoniu_flow_log`
--

DROP TABLE IF EXISTS `xiaoniu_flow_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `xiaoniu_flow_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `flow_id` int(11) NOT NULL DEFAULT '0' COMMENT '流程ID',
  `emp_no` varchar(20) NOT NULL DEFAULT '' COMMENT '員工編號',
  `user_id` int(11) DEFAULT NULL COMMENT '用戶ID',
  `user_name` varchar(20) DEFAULT '' COMMENT '用戶名稱',
  `step` int(11) NOT NULL DEFAULT '0' COMMENT '當前步驟',
  `result` int(11) DEFAULT NULL COMMENT '審批結果',
  `create_time` int(11) NOT NULL DEFAULT '0' COMMENT '創建時間',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新時間',
  `comment` text COMMENT '意見',
  `is_read` tinyint(3) NOT NULL DEFAULT '0' COMMENT '已讀',
  `from` varchar(20) DEFAULT NULL COMMENT '傳閱人',
  `is_del` tinyint(3) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=66 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `xiaoniu_flow_log`
--

LOCK TABLES `xiaoniu_flow_log` WRITE;
/*!40000 ALTER TABLE `xiaoniu_flow_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `xiaoniu_flow_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `xiaoniu_flow_type`
--

DROP TABLE IF EXISTS `xiaoniu_flow_type`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `xiaoniu_flow_type` (
  `id` smallint(3) unsigned NOT NULL AUTO_INCREMENT,
  `tag` varchar(20) NOT NULL DEFAULT '' COMMENT '分組',
  `doc_no_format` varchar(50) NOT NULL DEFAULT '' COMMENT '文檔編碼格式',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '名稱',
  `short` varchar(20) NOT NULL DEFAULT '' COMMENT '簡稱',
  `content` text NOT NULL COMMENT '內容',
  `confirm` varchar(100) NOT NULL DEFAULT '' COMMENT '裁決數據',
  `confirm_name` text NOT NULL COMMENT '裁決顯示內容',
  `consult` varchar(100) NOT NULL DEFAULT '' COMMENT '協商數據',
  `consult_name` text NOT NULL COMMENT '協商顯示內容',
  `refer` varchar(100) NOT NULL DEFAULT '' COMMENT '抄送數據',
  `refer_name` text NOT NULL COMMENT '抄送顯示內容',
  `create_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '創建時間',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新時間',
  `sort` smallint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `is_edit` tinyint(3) NOT NULL DEFAULT '0' COMMENT '可編輯標記',
  `is_lock` tinyint(3) NOT NULL DEFAULT '0' COMMENT '鎖定標記',
  `is_del` tinyint(3) NOT NULL DEFAULT '0' COMMENT '刪除標記',
  `request_duty` int(11) DEFAULT NULL COMMENT '申請權限',
  `report_duty` int(11) DEFAULT NULL COMMENT '報告權限',
  `udf_tpl` varchar(20) DEFAULT NULL,
  `is_show` tinyint(3) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=56 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `xiaoniu_flow_type`
--

LOCK TABLES `xiaoniu_flow_type` WRITE;
/*!40000 ALTER TABLE `xiaoniu_flow_type` DISABLE KEYS */;
/*!40000 ALTER TABLE `xiaoniu_flow_type` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `xiaoniu_form`
--

DROP TABLE IF EXISTS `xiaoniu_form`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `xiaoniu_form` (
  `id` smallint(4) unsigned NOT NULL AUTO_INCREMENT,
  `doc_no` varchar(20) NOT NULL DEFAULT '' COMMENT '文檔編號',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '名稱',
  `content` text NOT NULL COMMENT '內容',
  `folder` int(11) NOT NULL DEFAULT '0' COMMENT '文件夾',
  `add_file` varchar(200) NOT NULL DEFAULT '' COMMENT '附件',
  `user_id` int(11) NOT NULL DEFAULT '0' COMMENT '用戶ID',
  `user_name` varchar(20) NOT NULL DEFAULT '' COMMENT '用戶名稱',
  `create_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '創建時間',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新時間',
  `is_del` tinyint(3) NOT NULL DEFAULT '0' COMMENT '刪除標記',
  `udf_data` text COMMENT '自定義字段數據',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=95 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `xiaoniu_form`
--

LOCK TABLES `xiaoniu_form` WRITE;
/*!40000 ALTER TABLE `xiaoniu_form` DISABLE KEYS */;
/*!40000 ALTER TABLE `xiaoniu_form` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `xiaoniu_group`
--

DROP TABLE IF EXISTS `xiaoniu_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `xiaoniu_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '名稱',
  `is_public` tinyint(3) DEFAULT NULL COMMENT '是否公開',
  `remark` text COMMENT '備註',
  `user_id` int(11) DEFAULT NULL COMMENT '登陸人ID',
  `user_name` varchar(20) DEFAULT NULL COMMENT '登錄用戶名稱',
  `create_time` int(11) NOT NULL DEFAULT '0' COMMENT '創建時間',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新時間',
  `is_del` tinyint(3) NOT NULL DEFAULT '0' COMMENT '刪除標記',
  `sort` varchar(10) DEFAULT NULL COMMENT '排序',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `xiaoniu_group`
--

LOCK TABLES `xiaoniu_group` WRITE;
/*!40000 ALTER TABLE `xiaoniu_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `xiaoniu_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `xiaoniu_group_user`
--

DROP TABLE IF EXISTS `xiaoniu_group_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `xiaoniu_group_user` (
  `group_id` int(11) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  KEY `user_id` (`user_id`),
  KEY `group_id` (`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `xiaoniu_group_user`
--

LOCK TABLES `xiaoniu_group_user` WRITE;
/*!40000 ALTER TABLE `xiaoniu_group_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `xiaoniu_group_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `xiaoniu_info`
--

DROP TABLE IF EXISTS `xiaoniu_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `xiaoniu_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `doc_no` varchar(20) NOT NULL DEFAULT '' COMMENT '文檔編號',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '名稱',
  `content` text NOT NULL COMMENT '內容',
  `folder` int(11) NOT NULL DEFAULT '0' COMMENT '分類',
  `is_sign` tinyint(3) DEFAULT '0' COMMENT '是否需要簽收',
  `is_public` tinyint(3) DEFAULT NULL COMMENT '是否公開',
  `scope_user_id` text COMMENT '發佈範圍ID',
  `scope_user_name` text COMMENT '發佈範圍名稱',
  `add_file` varchar(200) NOT NULL DEFAULT '' COMMENT '附件',
  `user_id` int(11) NOT NULL DEFAULT '0' COMMENT '登陸人ID',
  `user_name` varchar(20) NOT NULL DEFAULT '' COMMENT '登陸人名稱',
  `dept_id` int(11) DEFAULT NULL COMMENT '部門ID',
  `dept_name` varchar(20) DEFAULT NULL COMMENT '部門名稱',
  `create_time` int(11) NOT NULL DEFAULT '0' COMMENT '創建時間',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新時間',
  `is_del` tinyint(3) NOT NULL DEFAULT '0' COMMENT '刪除標記',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=139 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `xiaoniu_info`
--

LOCK TABLES `xiaoniu_info` WRITE;
/*!40000 ALTER TABLE `xiaoniu_info` DISABLE KEYS */;
/*!40000 ALTER TABLE `xiaoniu_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `xiaoniu_info_scope`
--

DROP TABLE IF EXISTS `xiaoniu_info_scope`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `xiaoniu_info_scope` (
  `info_id` int(11) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  KEY `user_id` (`user_id`),
  KEY `info_id` (`info_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `xiaoniu_info_scope`
--

LOCK TABLES `xiaoniu_info_scope` WRITE;
/*!40000 ALTER TABLE `xiaoniu_info_scope` DISABLE KEYS */;
INSERT INTO `xiaoniu_info_scope` VALUES (109,1),(109,42),(109,43),(109,44),(109,48),(109,49),(109,50),(109,51),(109,52),(109,55),(109,56),(109,57),(109,58),(109,59),(109,60),(109,61),(109,62),(109,65),(109,66),(109,67),(116,44),(116,67),(116,48),(116,42),(116,43),(116,49),(116,50),(116,51),(116,52),(116,55),(116,57),(116,58),(116,59),(116,60),(116,61),(116,56),(116,62),(116,1),(116,65),(116,66),(124,44),(124,67),(124,48),(124,42),(124,43),(124,49),(124,50),(124,51),(124,52),(124,55),(124,57),(124,58),(124,59),(124,60),(124,61),(124,56),(124,62),(124,1),(124,65),(124,66),(125,44),(125,67),(125,48),(125,42),(125,43),(125,49),(125,50),(125,51),(125,52),(125,55),(125,57),(125,58),(125,59),(125,60),(125,61),(125,56),(125,62),(125,1),(125,65),(125,66),(126,44),(127,44),(128,44),(129,44),(130,48),(130,49),(130,50),(130,55),(130,57),(130,58),(130,59),(131,42),(131,51),(131,52),(131,56),(131,60),(131,61),(131,62),(132,48),(132,49),(132,50),(132,55),(132,57),(132,58),(132,59),(133,48),(134,44),(134,67),(134,48),(134,42),(134,43),(134,49),(134,50),(134,51),(134,52),(134,55),(134,57),(134,58),(134,59),(134,60),(134,61),(134,56),(134,62),(134,1),(134,65),(134,66),(135,48),(136,48),(137,44),(137,67),(137,48),(137,42),(137,43),(137,49),(137,50),(137,51),(137,52),(137,55),(137,57),(137,58),(137,59),(137,60),(137,61),(137,56),(137,62),(137,1),(137,65),(137,66),(138,44),(138,67),(138,48),(138,42),(138,43),(138,49),(138,50),(138,51),(138,52),(138,55),(138,57),(138,58),(138,59),(138,60),(138,61),(138,56),(138,62),(138,1),(138,65),(138,66);
/*!40000 ALTER TABLE `xiaoniu_info_scope` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `xiaoniu_info_sign`
--

DROP TABLE IF EXISTS `xiaoniu_info_sign`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `xiaoniu_info_sign` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `info_id` int(11) NOT NULL DEFAULT '0' COMMENT '信息ID',
  `user_id` int(11) NOT NULL DEFAULT '0' COMMENT '登錄用戶ID',
  `user_name` varchar(20) NOT NULL DEFAULT '' COMMENT '登錄用戶名稱',
  `is_sign` tinyint(3) NOT NULL DEFAULT '0' COMMENT '是否簽收',
  `sign_time` int(11) unsigned DEFAULT NULL COMMENT '簽收時間',
  `dept_id` int(11) DEFAULT NULL COMMENT '部門ID',
  `dept_name` varchar(20) DEFAULT NULL COMMENT '部門名稱',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=94 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `xiaoniu_info_sign`
--

LOCK TABLES `xiaoniu_info_sign` WRITE;
/*!40000 ALTER TABLE `xiaoniu_info_sign` DISABLE KEYS */;
INSERT INTO `xiaoniu_info_sign` VALUES (71,109,1,'管理員',1,1417533958,NULL,NULL),(72,124,1,'管理員',1,1422806114,1,'小微企業'),(73,124,42,'總監2001',1,1424448156,8,'財務部'),(74,130,55,'員工5001',1,1431412695,24,'總務科'),(75,130,48,'副總1003',1,1431412995,6,'管理部'),(76,130,50,'經理3002',1,1431413642,23,'人事科'),(77,130,49,'經理3001',1,1431413670,24,'總務科'),(78,130,57,'員工5002',1,1431413882,24,'總務科'),(79,131,42,'總監2001',1,1431414980,8,'財務部'),(80,132,48,'副總1003',1,1431415121,6,'管理部'),(81,132,49,'經理3001',1,1431415624,24,'總務科'),(82,133,48,'副總1003',1,1431415712,6,'管理部'),(83,133,48,'副總1003',1,1431415716,6,'管理部'),(84,133,48,'副總1003',1,1431415721,6,'管理部'),(85,133,48,'副總1003',1,1431415729,6,'管理部'),(86,133,48,'副總1003',1,1431415732,6,'管理部'),(87,133,48,'副總1003',1,1431415733,6,'管理部'),(88,133,48,'副總1003',1,1431415733,6,'管理部'),(89,134,48,'副總1003',1,1431415924,6,'管理部'),(90,136,48,'副總1003',1,1431416157,6,'管理部'),(91,134,1,'管理員',1,1431416214,1,'小微企業'),(92,137,48,'副總1003',1,1431484511,6,'管理部'),(93,138,48,'副總1003',1,1431495132,6,'管理部');
/*!40000 ALTER TABLE `xiaoniu_info_sign` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `xiaoniu_mail`
--

DROP TABLE IF EXISTS `xiaoniu_mail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `xiaoniu_mail` (
  `id` smallint(4) unsigned NOT NULL AUTO_INCREMENT,
  `folder` int(11) NOT NULL DEFAULT '0' COMMENT '文件夾',
  `mid` varchar(200) DEFAULT NULL COMMENT '郵件唯一id',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '名稱',
  `content` text NOT NULL COMMENT '內容',
  `add_file` varchar(200) DEFAULT NULL COMMENT '附件',
  `from` varchar(255) DEFAULT NULL COMMENT '發件人',
  `to` varchar(255) DEFAULT NULL COMMENT '收件人',
  `reply_to` varchar(255) DEFAULT NULL COMMENT '回復到',
  `cc` varchar(255) DEFAULT NULL COMMENT '抄送',
  `read` tinyint(1) NOT NULL DEFAULT '0' COMMENT '已讀',
  `user_id` int(11) NOT NULL DEFAULT '0' COMMENT '用戶ID',
  `user_name` varchar(20) NOT NULL DEFAULT '' COMMENT '用戶名稱',
  `create_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '創建時間',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新時間',
  `is_del` tinyint(3) NOT NULL DEFAULT '0' COMMENT '刪除標記',
  PRIMARY KEY (`id`),
  KEY `mid` (`mid`),
  KEY `create_time` (`create_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `xiaoniu_mail`
--

LOCK TABLES `xiaoniu_mail` WRITE;
/*!40000 ALTER TABLE `xiaoniu_mail` DISABLE KEYS */;
/*!40000 ALTER TABLE `xiaoniu_mail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `xiaoniu_mail_account`
--

DROP TABLE IF EXISTS `xiaoniu_mail_account`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `xiaoniu_mail_account` (
  `id` mediumint(6) NOT NULL,
  `email` varchar(50) DEFAULT NULL COMMENT '郵件地址',
  `mail_name` varchar(50) NOT NULL DEFAULT '' COMMENT '郵件顯示名稱',
  `pop3svr` varchar(50) NOT NULL DEFAULT '' COMMENT 'pop服務器',
  `smtpsvr` varchar(50) NOT NULL DEFAULT '' COMMENT 'smtp服務器',
  `mail_id` varchar(50) NOT NULL DEFAULT '' COMMENT '郵件ID',
  `mail_pwd` varchar(50) NOT NULL DEFAULT '' COMMENT '郵件密碼',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='think_user_info';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `xiaoniu_mail_account`
--

LOCK TABLES `xiaoniu_mail_account` WRITE;
/*!40000 ALTER TABLE `xiaoniu_mail_account` DISABLE KEYS */;
/*!40000 ALTER TABLE `xiaoniu_mail_account` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `xiaoniu_mail_organize`
--

DROP TABLE IF EXISTS `xiaoniu_mail_organize`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `xiaoniu_mail_organize` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL DEFAULT '0' COMMENT '用戶ID',
  `sort` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `sender_check` int(11) NOT NULL DEFAULT '0' COMMENT '是否確認發件人',
  `sender_option` int(11) NOT NULL DEFAULT '0' COMMENT '發件人選項',
  `sender_key` varchar(50) NOT NULL DEFAULT '' COMMENT '確認發件人值',
  `domain_check` int(11) NOT NULL DEFAULT '0' COMMENT '是否確認域名',
  `domain_option` int(11) NOT NULL DEFAULT '0' COMMENT '域名選項',
  `domain_key` varchar(50) NOT NULL DEFAULT '' COMMENT '確認域名值',
  `recever_check` int(11) NOT NULL DEFAULT '0' COMMENT '是否確認收件人',
  `recever_option` int(11) NOT NULL DEFAULT '0' COMMENT '收件人選項',
  `recever_key` varchar(50) NOT NULL DEFAULT '' COMMENT '確認收信人值',
  `title_check` int(11) NOT NULL DEFAULT '0' COMMENT '是否確認標題',
  `title_option` int(11) NOT NULL DEFAULT '0' COMMENT '確認標題選項',
  `title_key` varchar(50) NOT NULL DEFAULT '' COMMENT '確認標題值',
  `to` int(11) NOT NULL DEFAULT '0' COMMENT '移動到',
  `is_del` tinyint(3) NOT NULL DEFAULT '0' COMMENT '刪除標記',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `xiaoniu_mail_organize`
--

LOCK TABLES `xiaoniu_mail_organize` WRITE;
/*!40000 ALTER TABLE `xiaoniu_mail_organize` DISABLE KEYS */;
/*!40000 ALTER TABLE `xiaoniu_mail_organize` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `xiaoniu_message`
--

DROP TABLE IF EXISTS `xiaoniu_message`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `xiaoniu_message` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `content` text COMMENT '內容',
  `add_file` varchar(200) DEFAULT NULL COMMENT '附件',
  `sender_id` int(11) DEFAULT NULL COMMENT '發送人',
  `sender_name` varchar(20) DEFAULT NULL COMMENT '發送人名稱',
  `receiver_id` int(11) DEFAULT NULL COMMENT '接收人',
  `receiver_name` varchar(20) DEFAULT NULL COMMENT '接收人名稱',
  `create_time` int(11) DEFAULT NULL COMMENT '創建時間',
  `owner_id` int(11) DEFAULT NULL COMMENT '擁有者',
  `is_del` tinyint(3) DEFAULT '0' COMMENT '刪除標記',
  `is_read` tinyint(3) DEFAULT '0' COMMENT '是否已讀',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=185 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `xiaoniu_message`
--

LOCK TABLES `xiaoniu_message` WRITE;
/*!40000 ALTER TABLE `xiaoniu_message` DISABLE KEYS */;
/*!40000 ALTER TABLE `xiaoniu_message` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `xiaoniu_node`
--

DROP TABLE IF EXISTS `xiaoniu_node`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `xiaoniu_node` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL COMMENT '名稱',
  `url` varchar(200) NOT NULL DEFAULT '' COMMENT 'URL地址',
  `icon` varchar(255) DEFAULT NULL COMMENT '圖標',
  `sub_folder` varchar(20) DEFAULT NULL COMMENT '子文件夾',
  `remark` varchar(255) DEFAULT NULL COMMENT '備註',
  `sort` varchar(20) DEFAULT NULL COMMENT '排序',
  `pid` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '父ID',
  `is_del` tinyint(3) NOT NULL DEFAULT '0' COMMENT '刪除標記',
  `badge_function` varchar(50) DEFAULT NULL COMMENT '統計函數',
  PRIMARY KEY (`id`),
  KEY `pid` (`pid`),
  KEY `status` (`is_del`)
) ENGINE=InnoDB AUTO_INCREMENT=236 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `xiaoniu_node`
--

LOCK TABLES `xiaoniu_node` WRITE;
/*!40000 ALTER TABLE `xiaoniu_node` DISABLE KEYS */;
INSERT INTO `xiaoniu_node` VALUES (84,'管理','System/index','fa fa-cogs','','','999',0,0,''),(85,'郵件','Mail/index','fa fa-envelope-o bc-mail','','','1',0,0,'badge_sum'),(87,'審批','Flow/index','fa fa-pencil bc-flow','','','2',0,0,'badge_sum'),(88,'信息','Info/index##','fa fa-file-o','InfoFolder','','4',0,0,'badge_sum'),(91,'日程','Schedule/index','fa fa-calendar bc-personal-schedule','','','9',198,0,'badge_count_schedule'),(94,'職位','Position/index',NULL,NULL,'','',1,0,NULL),(100,'寫信','Mail/add',NULL,'','','1',85,0,NULL),(101,'收件箱','Mail/folder?fid=inbox','bc-mail-inbox','','','3',85,0,'badge_count_mail_inbox'),(102,'郵件設置','',NULL,NULL,NULL,'9',85,0,NULL),(104,'垃圾箱','Mail/folder?fid=spambox','','','','5',85,0,NULL),(105,'發件箱','Mail/folder?fid=outbox','','','','6',85,0,NULL),(106,'已刪除','Mail/folder?fid=delbox','','','','4',85,0,NULL),(107,'草稿箱','Mail/folder?fid=darftbox','','','','7',85,0,NULL),(108,'郵件帳戶設置','MailAccount/index',NULL,'','','1',102,0,NULL),(110,'公司信息管理','',NULL,NULL,'','1',84,0,NULL),(112,'權限管理','',NULL,NULL,'','3',84,0,NULL),(113,'系統設定','',NULL,NULL,'','4',84,0,NULL),(114,'系統參數設置','SystemConfig/index','','','','2',113,0,''),(115,'組織圖','Dept/index','','','','1',110,0,NULL),(116,'員工登記','User/index',NULL,'','','5',110,0,NULL),(118,'權限組管理','Role/index','','','','1',112,0,NULL),(119,'權限設置','Role/node','','','','2',112,0,NULL),(120,'權限分配','Role/user','','','','3',112,0,NULL),(121,'菜單管理','Node/index','','','','1',113,0,NULL),(123,'職位','Position/index',NULL,'','','2',110,0,NULL),(124,'文件夾設置','Mail/folder_manage','','','','2',102,0,''),(125,'聯繫人','Contact/index','','','','1',198,0,NULL),(126,'信息搜索','Info/index','','','','1',88,0,NULL),(143,'郵件分類','MailOrganize/index',NULL,'','','',102,0,NULL),(144,'發起','Flow/index','','','','1',87,0,NULL),(146,'流程管理','FlowType/index','','','','9',87,0,NULL),(147,'待審批','Flow/folder?fid=confirm','bc-flow-confirm','','','4',87,0,'badge_count_flow_todo'),(148,'已審批','Flow/folder?fid=finish','','','','5',87,0,''),(149,'草稿箱','Flow/folder?fid=darft','','','','2',87,0,''),(150,'已提交','Flow/folder?fid=submit','','','','3',87,0,''),(152,'待辦','Todo/index','fa fa-tasks bc-personal-todo','','','9',198,0,'badge_count_todo'),(153,'部門級別','DeptGrade/index','','','','4',110,0,NULL),(156,'客戶','Customer/index',NULL,'','','2',157,0,NULL),(157,'通訊錄','Staff/index','fa fa-group','','','7',0,0,'badge_sum'),(158,'供應商','Supplier/index',NULL,'','','3',157,0,NULL),(169,'職員','Staff/index',NULL,'','','',157,0,NULL),(177,'我的文件夾','##mail','bc-mail-myfolder','MailFolder','','8',85,0,'badge_count_mail_user_folder'),(184,'流程分組','FlowType/tag_manage','','','','8',87,0,NULL),(185,'審批報告','Flow/folder?fid=report','bc-flow-receive','','','6',87,0,'badge_count_flow_receive'),(189,'信息分類','Info/folder_manage','','','','C1',88,0,''),(190,'消息','Message/index','fa fa-inbox bc-message','','','99',198,0,'badge_count_message'),(191,'用戶設置','','','','','',198,0,NULL),(192,'用戶資料','Profile/index','','','','',191,0,NULL),(193,'修改密碼','Profile/password','','','','',191,0,NULL),(194,'用戶設置','UserConfig/index','','','','999',191,0,NULL),(198,'個人','Contact/index','fa fa-user bc-personal','','','9',0,0,'badge_sum'),(205,'業務角色管理','Duty/index','','','','4',112,0,''),(206,'業務權限分配','Role/duty','','','','5',112,0,''),(214,'記賬','Finance/index','fa fa-jpy','','','3',217,0,''),(216,'日報','WorkLog/index','fa fa-book','','','1',217,0,''),(217,'工作','WorkLog/index','fa fa-book','','','6',0,0,'badge_sum'),(219,'我的信息','Info/my_info','','','','B1',88,0,NULL),(220,'我的簽收','Info/my_sign','','','','B2',88,0,NULL),(221,'文檔','Doc/index##','fa fa-inbox','DocFolder','','4',0,0,'badge_sum'),(222,'文檔管理','Doc/folder_manage','fa fa-inbox','','','4',221,0,'badge_sum'),(224,'任務','Task/index','fa fa-book','','','2',217,0,'badge_count_task'),(226,'報表','Form/index##','fa fa-table','FormFolder','','5',0,0,'badge_sum'),(227,'報表管理','Form/folder_manage','fa fa-inbox','','','4',226,0,'badge_sum'),(228,'報表字段類型','Form/field_type','fa fa-inbox','','','4',226,0,'badge_sum'),(229,'群組','Group/index','fa fa-group','','','7',157,0,'badge_sum'),(230,'考勤查看','Sign/index','fa fa-book','','','4',235,0,'badge_sum'),(231,'考勤統計','Sign/report','fa fa-book','','','5',235,0,'badge_sum'),(232,'工單','WorkOrder/index','fa fa-book','','','60',235,0,'badge_count_work_order'),(233,'工單統計','WorkOrder/report','fa fa-book','','','61',235,0,''),(234,'參閱箱','Flow/folder?fid=receive','bc-flow-receive','','','6',87,0,'badge_count_flow_receive'),(235,'商業','','fa fa-bar-chart','','','',0,1,'');
/*!40000 ALTER TABLE `xiaoniu_node` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `xiaoniu_position`
--

DROP TABLE IF EXISTS `xiaoniu_position`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `xiaoniu_position` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `position_no` varchar(10) NOT NULL DEFAULT '' COMMENT '編號',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '名稱',
  `sort` varchar(10) NOT NULL DEFAULT '' COMMENT '排序',
  `is_del` tinyint(3) NOT NULL DEFAULT '0' COMMENT '刪除標記',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `xiaoniu_position`
--

LOCK TABLES `xiaoniu_position` WRITE;
/*!40000 ALTER TABLE `xiaoniu_position` DISABLE KEYS */;
INSERT INTO `xiaoniu_position` VALUES (1,'011','主管','5',0),(2,'04','經理','4',0),(3,'03','總監','3',0),(4,'02','副總','2',0),(5,'01','總經理','1',0),(6,'06','助理','6',0);
/*!40000 ALTER TABLE `xiaoniu_position` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `xiaoniu_push`
--

DROP TABLE IF EXISTS `xiaoniu_push`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `xiaoniu_push` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL DEFAULT '0' COMMENT '用戶ID',
  `data` text NOT NULL,
  `status` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `info` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3105 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `xiaoniu_push`
--

LOCK TABLES `xiaoniu_push` WRITE;
/*!40000 ALTER TABLE `xiaoniu_push` DISABLE KEYS */;
/*!40000 ALTER TABLE `xiaoniu_push` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `xiaoniu_role`
--

DROP TABLE IF EXISTS `xiaoniu_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `xiaoniu_role` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL DEFAULT '',
  `pid` smallint(6) DEFAULT NULL,
  `remark` varchar(255) DEFAULT NULL,
  `sort` varchar(20) DEFAULT NULL,
  `create_time` int(11) unsigned NOT NULL,
  `update_time` int(11) unsigned NOT NULL,
  `is_del` tinyint(3) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `parentId` (`pid`),
  KEY `ename` (`sort`),
  KEY `status` (`is_del`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `xiaoniu_role`
--

LOCK TABLES `xiaoniu_role` WRITE;
/*!40000 ALTER TABLE `xiaoniu_role` DISABLE KEYS */;
INSERT INTO `xiaoniu_role` VALUES (1,'公司管理員',0,'','1',1208784792,1368507168,0),(2,'基本權限',0,'','2',1215496283,1368507164,0),(7,'領導',0,'','2',1254325787,1401288337,0),(8,'測試權限',NULL,'','',1421876018,0,0),(9,'測試權限',NULL,'','',1432192986,0,0);
/*!40000 ALTER TABLE `xiaoniu_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `xiaoniu_role_duty`
--

DROP TABLE IF EXISTS `xiaoniu_role_duty`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `xiaoniu_role_duty` (
  `role_id` smallint(6) unsigned NOT NULL,
  `duty_id` smallint(6) unsigned NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `xiaoniu_role_duty`
--

LOCK TABLES `xiaoniu_role_duty` WRITE;
/*!40000 ALTER TABLE `xiaoniu_role_duty` DISABLE KEYS */;
INSERT INTO `xiaoniu_role_duty` VALUES (1,15),(7,14),(1,14),(7,15),(2,14),(2,15);
/*!40000 ALTER TABLE `xiaoniu_role_duty` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `xiaoniu_role_node`
--

DROP TABLE IF EXISTS `xiaoniu_role_node`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `xiaoniu_role_node` (
  `role_id` int(11) NOT NULL,
  `node_id` int(11) NOT NULL,
  `admin` tinyint(1) DEFAULT NULL,
  `read` tinyint(1) DEFAULT NULL,
  `write` tinyint(1) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `xiaoniu_role_node`
--

LOCK TABLES `xiaoniu_role_node` WRITE;
/*!40000 ALTER TABLE `xiaoniu_role_node` DISABLE KEYS */;
INSERT INTO `xiaoniu_role_node` VALUES (2,136,NULL,NULL,NULL),(2,135,NULL,NULL,NULL),(1,94,NULL,NULL,NULL),(1,97,NULL,NULL,NULL),(1,98,NULL,NULL,NULL),(1,99,NULL,NULL,NULL),(1,69,NULL,NULL,NULL),(1,6,NULL,NULL,NULL),(1,2,NULL,NULL,NULL),(1,7,NULL,NULL,NULL),(1,131,1,1,1),(1,130,NULL,NULL,NULL),(1,133,NULL,NULL,NULL),(1,132,NULL,NULL,NULL),(1,135,NULL,NULL,NULL),(1,136,NULL,NULL,NULL),(1,117,NULL,NULL,NULL),(1,134,NULL,NULL,NULL),(2,103,NULL,NULL,NULL),(2,133,NULL,NULL,NULL),(2,130,NULL,NULL,NULL),(7,124,NULL,NULL,NULL),(7,108,NULL,NULL,NULL),(7,104,NULL,NULL,NULL),(7,107,NULL,NULL,NULL),(7,106,NULL,NULL,NULL),(7,105,NULL,NULL,NULL),(7,101,NULL,NULL,NULL),(7,100,NULL,NULL,NULL),(7,125,NULL,NULL,NULL),(2,134,NULL,NULL,NULL),(2,132,NULL,NULL,NULL),(2,103,NULL,NULL,NULL),(2,103,NULL,NULL,NULL),(2,109,NULL,NULL,NULL),(1,117,NULL,NULL,NULL),(1,117,NULL,NULL,NULL),(1,117,NULL,NULL,NULL),(1,117,NULL,NULL,NULL),(1,103,NULL,NULL,NULL),(1,109,NULL,NULL,NULL),(1,117,NULL,NULL,NULL),(1,117,NULL,NULL,NULL),(1,163,NULL,NULL,NULL),(1,170,NULL,NULL,NULL),(1,164,NULL,NULL,NULL),(1,155,NULL,NULL,NULL),(1,154,1,1,1),(1,111,NULL,NULL,NULL),(1,168,NULL,NULL,NULL),(1,162,NULL,NULL,NULL),(1,166,NULL,NULL,NULL),(1,161,NULL,NULL,NULL),(1,171,NULL,NULL,NULL),(1,165,NULL,NULL,NULL),(1,174,NULL,NULL,NULL),(1,172,NULL,NULL,NULL),(1,173,NULL,NULL,NULL),(1,160,NULL,NULL,NULL),(1,175,NULL,NULL,NULL),(1,176,NULL,NULL,NULL),(1,167,NULL,NULL,NULL),(1,128,NULL,NULL,NULL),(8,226,1,1,1),(8,85,NULL,NULL,NULL),(8,100,NULL,NULL,NULL),(8,101,NULL,NULL,NULL),(8,106,NULL,NULL,NULL),(8,104,NULL,NULL,NULL),(8,105,NULL,NULL,NULL),(8,107,NULL,NULL,NULL),(8,177,NULL,NULL,NULL),(8,102,NULL,NULL,NULL),(8,143,NULL,NULL,NULL),(8,108,NULL,NULL,NULL),(8,124,NULL,NULL,NULL),(2,85,1,1,1),(2,100,NULL,NULL,NULL),(2,101,NULL,NULL,NULL),(2,106,NULL,NULL,NULL),(2,104,NULL,NULL,NULL),(2,105,NULL,NULL,NULL),(2,107,NULL,NULL,NULL),(2,177,1,1,1),(2,102,NULL,NULL,NULL),(2,143,1,1,1),(2,108,1,1,1),(2,124,NULL,NULL,NULL),(2,88,NULL,1,1),(2,126,NULL,1,1),(2,219,NULL,NULL,NULL),(2,220,NULL,NULL,NULL),(2,226,NULL,1,1),(2,217,NULL,1,1),(2,216,NULL,1,1),(2,224,NULL,1,1),(2,230,NULL,1,1),(2,232,NULL,1,1),(2,157,1,1,1),(2,169,1,1,1),(2,156,1,1,1),(2,158,1,1,1),(2,229,NULL,1,1),(2,198,1,1,1),(2,191,NULL,NULL,NULL),(2,193,NULL,NULL,NULL),(2,192,1,1,1),(2,194,1,1,1),(2,125,1,1,1),(2,91,1,1,1),(2,152,1,1,1),(2,190,1,1,1),(2,87,1,1,1),(2,144,1,1,1),(2,149,NULL,NULL,NULL),(2,150,NULL,NULL,NULL),(2,147,NULL,NULL,NULL),(2,148,NULL,NULL,NULL),(2,185,NULL,NULL,NULL),(2,221,NULL,1,NULL),(1,235,NULL,NULL,NULL),(1,230,1,1,1),(1,231,NULL,NULL,NULL),(1,232,1,1,1),(1,233,NULL,NULL,NULL),(1,85,1,1,1),(1,100,NULL,NULL,NULL),(1,101,NULL,NULL,NULL),(1,106,NULL,NULL,NULL),(1,104,NULL,NULL,NULL),(1,105,NULL,NULL,NULL),(1,107,NULL,NULL,NULL),(1,177,1,1,1),(1,102,NULL,NULL,NULL),(1,143,1,1,1),(1,108,1,1,1),(1,124,NULL,NULL,NULL),(1,87,1,1,1),(1,144,1,1,1),(1,149,NULL,NULL,NULL),(1,150,NULL,NULL,NULL),(1,147,NULL,NULL,NULL),(1,148,NULL,NULL,NULL),(1,234,NULL,NULL,NULL),(1,185,NULL,NULL,NULL),(1,184,NULL,NULL,NULL),(1,146,1,1,1),(1,221,1,1,1),(1,222,NULL,NULL,NULL),(1,88,1,1,1),(1,126,1,1,1),(1,219,NULL,NULL,NULL),(1,220,NULL,NULL,NULL),(1,189,NULL,NULL,NULL),(1,226,1,1,1),(1,227,NULL,NULL,NULL),(1,228,NULL,NULL,NULL),(1,217,1,1,1),(1,216,1,1,1),(1,224,1,1,1),(1,214,1,1,1),(1,157,1,1,1),(1,169,1,1,1),(1,156,1,1,1),(1,158,1,1,1),(1,229,1,1,1),(1,198,1,1,1),(1,191,NULL,NULL,NULL),(1,193,NULL,NULL,NULL),(1,192,1,1,1),(1,194,1,1,1),(1,125,1,1,1),(1,91,1,1,1),(1,152,1,1,1),(1,190,1,1,1),(1,84,1,1,1),(1,110,NULL,NULL,NULL),(1,115,1,1,1),(1,123,1,1,1),(1,153,1,1,1),(1,116,1,1,1),(1,112,NULL,NULL,NULL),(1,118,1,1,1),(1,119,NULL,NULL,NULL),(1,120,NULL,NULL,NULL),(1,205,1,1,1),(1,206,NULL,NULL,NULL),(1,113,NULL,NULL,NULL),(1,121,1,1,1),(1,114,1,1,1);
/*!40000 ALTER TABLE `xiaoniu_role_node` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `xiaoniu_role_user`
--

DROP TABLE IF EXISTS `xiaoniu_role_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `xiaoniu_role_user` (
  `role_id` mediumint(9) unsigned DEFAULT NULL,
  `user_id` char(32) DEFAULT NULL,
  KEY `group_id` (`role_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `xiaoniu_role_user`
--

LOCK TABLES `xiaoniu_role_user` WRITE;
/*!40000 ALTER TABLE `xiaoniu_role_user` DISABLE KEYS */;
INSERT INTO `xiaoniu_role_user` VALUES (4,'27'),(4,'26'),(5,'31'),(3,'22'),(1,'4'),(1,'3'),(1,'35'),(1,'36'),(1,'54'),(2,'3'),(1,'53'),(7,'36'),(1,'2'),(2,'2'),(7,'2'),(1,'63'),(1,'64'),(2,'41'),(2,'68'),(1,'44'),(2,'44'),(7,'44'),(1,'67'),(2,'67'),(7,'67'),(1,'48'),(2,'48'),(7,'48'),(1,'42'),(2,'42'),(7,'42'),(1,'43'),(2,'43'),(7,'43'),(1,'49'),(2,'49'),(7,'49'),(1,'50'),(2,'50'),(7,'50'),(1,'51'),(2,'51'),(7,'51'),(1,'52'),(2,'52'),(7,'52'),(1,'55'),(2,'55'),(7,'55'),(1,'57'),(2,'57'),(7,'57'),(1,'58'),(2,'58'),(7,'58'),(1,'59'),(2,'59'),(7,'59'),(1,'60'),(2,'60'),(7,'60'),(1,'61'),(2,'61'),(7,'61'),(1,'56'),(2,'56'),(7,'56'),(1,'62'),(2,'62'),(7,'62'),(1,'1'),(2,'1'),(7,'1'),(1,'65'),(2,'65'),(7,'65'),(1,'66'),(2,'66'),(7,'66');
/*!40000 ALTER TABLE `xiaoniu_role_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `xiaoniu_schedule`
--

DROP TABLE IF EXISTS `xiaoniu_schedule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `xiaoniu_schedule` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT '',
  `content` text,
  `location` varchar(50) DEFAULT '',
  `priority` int(11) DEFAULT NULL,
  `actor` varchar(200) DEFAULT '',
  `user_id` int(11) DEFAULT '0',
  `start_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `end_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `add_file` varchar(200) DEFAULT '',
  `is_del` tinyint(3) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=100 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `xiaoniu_schedule`
--

LOCK TABLES `xiaoniu_schedule` WRITE;
/*!40000 ALTER TABLE `xiaoniu_schedule` DISABLE KEYS */;
/*!40000 ALTER TABLE `xiaoniu_schedule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `xiaoniu_sign`
--

DROP TABLE IF EXISTS `xiaoniu_sign`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `xiaoniu_sign` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `emp_no` varchar(10) DEFAULT NULL,
  `create_time` int(11) DEFAULT NULL,
  `latitude` varchar(10) DEFAULT NULL,
  `longitude` varchar(10) DEFAULT NULL,
  `precision` varchar(10) DEFAULT NULL,
  `location` varchar(100) DEFAULT NULL,
  `type` varchar(10) DEFAULT NULL,
  `is_real_time` tinyint(3) DEFAULT NULL,
  `ip` varchar(15) DEFAULT NULL,
  `sign_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `xiaoniu_sign`
--

LOCK TABLES `xiaoniu_sign` WRITE;
/*!40000 ALTER TABLE `xiaoniu_sign` DISABLE KEYS */;
/*!40000 ALTER TABLE `xiaoniu_sign` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `xiaoniu_supplier`
--

DROP TABLE IF EXISTS `xiaoniu_supplier`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `xiaoniu_supplier` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL DEFAULT '',
  `letter` varchar(50) DEFAULT '',
  `short` varchar(30) DEFAULT '',
  `account` varchar(20) DEFAULT '',
  `tax_no` varchar(20) DEFAULT '',
  `payment` varchar(20) DEFAULT NULL,
  `contact` varchar(20) NOT NULL DEFAULT '',
  `office_tel` varchar(20) DEFAULT NULL,
  `mobile_tel` varchar(20) DEFAULT '',
  `email` varchar(50) DEFAULT '',
  `im` varchar(20) DEFAULT '',
  `address` varchar(50) DEFAULT '',
  `user_id` int(11) NOT NULL,
  `is_del` tinyint(3) NOT NULL DEFAULT '0',
  `remark` text,
  `fax` varchar(255) DEFAULT NULL,
  `user_name` varchar(21) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `xiaoniu_supplier`
--

LOCK TABLES `xiaoniu_supplier` WRITE;
/*!40000 ALTER TABLE `xiaoniu_supplier` DISABLE KEYS */;
/*!40000 ALTER TABLE `xiaoniu_supplier` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `xiaoniu_system_config`
--

DROP TABLE IF EXISTS `xiaoniu_system_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `xiaoniu_system_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(50) NOT NULL DEFAULT '',
  `name` varchar(50) NOT NULL DEFAULT '',
  `val` varchar(255) DEFAULT NULL,
  `is_del` tinyint(3) NOT NULL DEFAULT '0',
  `sort` varchar(20) DEFAULT NULL,
  `pid` int(11) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `xiaoniu_system_config`
--

LOCK TABLES `xiaoniu_system_config` WRITE;
/*!40000 ALTER TABLE `xiaoniu_system_config` DISABLE KEYS */;
INSERT INTO `xiaoniu_system_config` VALUES (1,'SYSTEM_NAME','系統名稱','豆芽網絡OA系統',0,'',0),(7,'UPLOAD_FILE_TYPE','上傳文件類型','doc,docx,xls,xlsx,ppt,pptx,pdf,gif,png,tif,zip,rar,jpg,jpeg,txt',0,NULL,0),(8,'IS_VERIFY_CODE','驗證碼','0',0,'',0),(15,'FINANCE_INCOME_TYPE','辦公費','辦公費',0,'1',28),(16,'FINANCE_INCOME_TYPE','通訊費','通訊費',0,'2',28),(17,'FINANCE_PAYMENT_TYPE','辦公費','辦公費',0,'',29),(18,'FINANCE_PAYMENT_TYPE','通訊費','通訊費',0,'',29),(19,'WEIXIN_CORP_ID','WEIXIN_CORP_ID','wx4124a601419ba115',0,'',27),(20,'WEIXIN_SECRET','WEIXIN_SECRET','TlnidZYom5z8T-pE0y_O7IXm7dSPgPDtI3nQ7RyqLQePiyUXzWo8F-qum1n4i_QM',0,'',27),(21,'WEIXIN_TOKEN','WEIXIN_TOKEN','xiaowei',0,'',27),(22,'WEIXIN_ENCODING_AES_KEY','WEIXIN_ENCODING_AES_KEY','lsBzWprOjjdbkMatbg54wwMC2H9ZXmi1aEdDmUQ2nPq',0,'',27),(23,'WEIXIN_SITE_URL','WEIXIN_SITE_URL','http://xiaowei.smeoa.com',0,'',27),(24,'FINANCE_PAYMENT_TYPE','餐費','餐費',0,'',29),(25,'OA_AGENT_ID','OA_AGENT_ID','5',0,'',27),(26,'WEIXIN_SUBSCRIBE_MSG','WEIXIN_SUBSCRIBE_MSG','歡迎使用微信辦公系統。',0,'',27),(27,'微信設置','微信設置','微信設置',0,'',0),(28,'記賬-收入','記賬-收入','記賬-收入',0,'',0),(29,'記賬-支出','記賬-支出','記賬-支出',0,'',0),(31,'WS_PUSH_CONFIG','WS_PUSH_CONFIG','消息',0,'',0);
/*!40000 ALTER TABLE `xiaoniu_system_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `xiaoniu_system_folder`
--

DROP TABLE IF EXISTS `xiaoniu_system_folder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `xiaoniu_system_folder` (
  `id` int(3) NOT NULL AUTO_INCREMENT,
  `pid` int(11) NOT NULL,
  `controller` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `admin` varchar(200) NOT NULL,
  `write` varchar(200) NOT NULL,
  `read` varchar(200) NOT NULL,
  `sort` varchar(20) NOT NULL,
  `is_del` tinyint(3) NOT NULL DEFAULT '0',
  `remark` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=77 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `xiaoniu_system_folder`
--

LOCK TABLES `xiaoniu_system_folder` WRITE;
/*!40000 ALTER TABLE `xiaoniu_system_folder` DISABLE KEYS */;
/*!40000 ALTER TABLE `xiaoniu_system_folder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `xiaoniu_system_log`
--

DROP TABLE IF EXISTS `xiaoniu_system_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `xiaoniu_system_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` tinyint(3) DEFAULT NULL,
  `time` int(11) DEFAULT NULL,
  `data` float DEFAULT NULL,
  `text` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=77 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `xiaoniu_system_log`
--

LOCK TABLES `xiaoniu_system_log` WRITE;
/*!40000 ALTER TABLE `xiaoniu_system_log` DISABLE KEYS */;
INSERT INTO `xiaoniu_system_log` VALUES (17,1,1433756245,66,NULL),(18,2,1433756245,45,NULL),(19,1,1433756245,66,NULL),(20,2,1433756245,45,NULL),(21,1,1433756246,66,NULL),(22,2,1433756246,45,NULL),(23,1,1433756246,66,NULL),(24,2,1433756246,45,NULL),(25,1,1433756246,66,NULL),(26,2,1433756246,45,NULL),(27,1,1433756247,66,NULL),(28,2,1433756247,45,NULL),(29,1,1433756255,66,NULL),(30,2,1433756255,45,NULL),(31,1,1433756255,66,NULL),(32,2,1433756255,45,NULL),(33,1,1433756255,66,NULL),(34,2,1433756255,45,NULL),(35,1,1433756256,66,NULL),(36,2,1433756256,45,NULL),(37,1,1433756271,66,NULL),(38,2,1433756271,45.0893,NULL),(39,1,1433756272,66,NULL),(40,2,1433756272,45.0893,NULL),(41,1,1433756272,66,NULL),(42,2,1433756272,45.0893,NULL),(43,1,1433756272,66,NULL),(44,2,1433756272,45.0893,NULL),(45,1,1433756277,66,NULL),(46,2,1433756277,45.0893,NULL),(47,1,1433756277,66,NULL),(48,2,1433756277,45.0893,NULL),(49,1,1433756278,66,NULL),(50,2,1433756278,45.0893,NULL),(51,1,1433756278,66,NULL),(52,2,1433756278,45.0893,NULL),(53,1,1433756292,66,NULL),(54,2,1433756292,45.0893,NULL),(55,1,1433756293,66,NULL),(56,2,1433756293,45.0893,NULL),(57,1,1433756293,66,NULL),(58,2,1433756293,45.0893,NULL),(59,1,1433756293,66,NULL),(60,2,1433756293,45.0893,NULL),(61,1,1433756295,66,NULL),(62,2,1433756295,45.0893,NULL),(63,1,1433756295,66,NULL),(64,2,1433756295,45.0893,NULL),(65,1,1433756296,66,NULL),(66,2,1433756296,45.0893,NULL),(67,1,1433756296,66,NULL),(68,2,1433756296,45.0893,NULL),(69,1,1433756297,66,NULL),(70,2,1433756297,45.0893,NULL),(71,1,1433756298,66,NULL),(72,2,1433756298,45.0893,NULL),(73,1,1433756298,66,NULL),(74,2,1433756298,45.0893,NULL),(75,1,1433756298,66,NULL),(76,2,1433756298,45.0893,NULL);
/*!40000 ALTER TABLE `xiaoniu_system_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `xiaoniu_system_tag`
--

DROP TABLE IF EXISTS `xiaoniu_system_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `xiaoniu_system_tag` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) NOT NULL DEFAULT '0',
  `controller` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `sort` varchar(20) NOT NULL,
  `remark` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=81 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `xiaoniu_system_tag`
--

LOCK TABLES `xiaoniu_system_tag` WRITE;
/*!40000 ALTER TABLE `xiaoniu_system_tag` DISABLE KEYS */;
INSERT INTO `xiaoniu_system_tag` VALUES (58,0,'Supplier','123','',''),(59,0,'Doc','123123','123123',''),(60,0,'Doc','123123','',''),(61,0,'Doc','abc','',''),(65,0,'Customer','22222','',''),(66,0,'Flow','人事','',''),(67,0,'Flow','IT','',''),(68,0,'Flow','公告','',''),(69,0,'FlowType','人事','1',''),(70,0,'FlowType','行政','2',''),(71,0,'FlowType','採購','3',''),(72,0,'FlowType','出差','4',''),(80,0,'FlowType','車輛管理','5','');
/*!40000 ALTER TABLE `xiaoniu_system_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `xiaoniu_system_tag_data`
--

DROP TABLE IF EXISTS `xiaoniu_system_tag_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `xiaoniu_system_tag_data` (
  `row_id` int(11) NOT NULL DEFAULT '0',
  `tag_id` int(11) NOT NULL DEFAULT '0',
  `controller` varchar(20) NOT NULL DEFAULT '',
  KEY `row_id` (`row_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `xiaoniu_system_tag_data`
--

LOCK TABLES `xiaoniu_system_tag_data` WRITE;
/*!40000 ALTER TABLE `xiaoniu_system_tag_data` DISABLE KEYS */;
INSERT INTO `xiaoniu_system_tag_data` VALUES (18,58,'Supplier'),(29,14,'Video'),(29,46,'Video'),(30,46,'Video'),(30,47,'Video'),(30,56,'Video'),(64,59,'Doc'),(64,60,'Doc'),(64,61,'Doc'),(65,61,'Doc'),(33,14,'Video'),(17,66,'Flow'),(18,66,'Flow'),(19,66,'Flow'),(20,66,'Flow'),(21,66,'Flow'),(22,66,'Flow'),(23,66,'Flow'),(17,66,'Flow'),(18,66,'Flow'),(19,66,'Flow'),(20,66,'Flow'),(21,66,'Flow'),(22,66,'Flow'),(23,66,'Flow'),(17,70,'FlowType'),(23,72,'FlowType'),(22,72,'FlowType'),(21,72,'FlowType'),(20,72,'FlowType'),(24,70,'FlowType'),(32,65,'Customer'),(18,71,'FlowType'),(19,71,'FlowType'),(33,71,'FlowType'),(34,71,'FlowType'),(35,71,'FlowType'),(36,71,'FlowType'),(42,70,'FlowType'),(46,70,'FlowType'),(47,70,'FlowType'),(48,70,'FlowType'),(49,70,'FlowType'),(50,70,'FlowType');
/*!40000 ALTER TABLE `xiaoniu_system_tag_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `xiaoniu_task`
--

DROP TABLE IF EXISTS `xiaoniu_task`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `xiaoniu_task` (
  `id` int(8) unsigned NOT NULL AUTO_INCREMENT,
  `task_no` varchar(20) DEFAULT NULL,
  `pid` int(11) DEFAULT NULL,
  `name` varchar(128) NOT NULL DEFAULT '' COMMENT '標題',
  `content` text COMMENT '內容',
  `executor` varchar(200) DEFAULT NULL,
  `add_file` varchar(255) DEFAULT NULL,
  `expected_time` datetime DEFAULT NULL,
  `user_id` int(11) unsigned DEFAULT '0',
  `user_name` varchar(20) DEFAULT NULL,
  `dept_id` int(11) DEFAULT NULL,
  `dept_name` varchar(20) DEFAULT NULL,
  `create_time` int(11) DEFAULT NULL,
  `update_time` int(11) DEFAULT NULL,
  `update_user_id` int(11) DEFAULT NULL,
  `update_user_name` varchar(20) DEFAULT NULL,
  `status` tinyint(3) DEFAULT '0',
  `is_del` tinyint(3) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `xiaoniu_task`
--

LOCK TABLES `xiaoniu_task` WRITE;
/*!40000 ALTER TABLE `xiaoniu_task` DISABLE KEYS */;
/*!40000 ALTER TABLE `xiaoniu_task` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `xiaoniu_task_log`
--

DROP TABLE IF EXISTS `xiaoniu_task_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `xiaoniu_task_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `task_id` int(11) DEFAULT NULL,
  `type` tinyint(3) DEFAULT NULL,
  `assigner` int(11) DEFAULT NULL COMMENT '分配任務的人',
  `executor` varchar(20) DEFAULT NULL COMMENT '執行人',
  `executor_name` varchar(20) DEFAULT NULL,
  `status` tinyint(3) DEFAULT '0',
  `plan_time` datetime DEFAULT NULL,
  `transactor_name` varchar(20) DEFAULT NULL,
  `transactor` int(11) DEFAULT NULL COMMENT '由誰處理的',
  `finish_rate` tinyint(3) DEFAULT NULL,
  `finish_time` datetime DEFAULT NULL,
  `feed_back` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `xiaoniu_task_log`
--

LOCK TABLES `xiaoniu_task_log` WRITE;
/*!40000 ALTER TABLE `xiaoniu_task_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `xiaoniu_task_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `xiaoniu_todo`
--

DROP TABLE IF EXISTS `xiaoniu_todo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `xiaoniu_todo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `content` text NOT NULL,
  `user_id` int(11) NOT NULL,
  `end_date` varchar(10) DEFAULT NULL,
  `priority` int(11) NOT NULL,
  `add_file` varchar(200) NOT NULL,
  `status` tinyint(3) NOT NULL DEFAULT '0',
  `sort` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `xiaoniu_todo`
--

LOCK TABLES `xiaoniu_todo` WRITE;
/*!40000 ALTER TABLE `xiaoniu_todo` DISABLE KEYS */;
/*!40000 ALTER TABLE `xiaoniu_todo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `xiaoniu_udf_field`
--

DROP TABLE IF EXISTS `xiaoniu_udf_field`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `xiaoniu_udf_field` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL DEFAULT '',
  `row_type` int(11) NOT NULL,
  `sort` varchar(20) NOT NULL,
  `msg` varchar(50) DEFAULT NULL,
  `type` varchar(255) DEFAULT NULL,
  `layout` varchar(255) DEFAULT NULL,
  `data` varchar(255) DEFAULT NULL,
  `validate` varchar(20) DEFAULT NULL,
  `controller` varchar(20) DEFAULT NULL,
  `is_del` tinyint(3) DEFAULT '0',
  `config` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=211 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `xiaoniu_udf_field`
--

LOCK TABLES `xiaoniu_udf_field` WRITE;
/*!40000 ALTER TABLE `xiaoniu_udf_field` DISABLE KEYS */;
INSERT INTO `xiaoniu_udf_field` VALUES (56,'A11',1,'','','text','3','','','Flow',0,NULL),(57,'A2',1,'','','select','4','','','Flow',0,NULL),(58,'呵 3 ',1,'','','select','1','','','Flow',0,NULL),(59,'姓名',33,'','','text','1','','','Flow',0,''),(60,'申請日期',33,'','','date','1','','','Flow',0,''),(61,'所屬部門',33,'','','text','1','','','Flow',0,''),(62,'所屬科室',33,'','','text','1','','','Flow',0,''),(64,'B1',76,'','','text','1','','','Flow',0,NULL),(65,'B2',76,'','','text','1','','','Flow',0,NULL),(66,'職別',76,'','','text','1','','','Form',0,'show|col-10'),(67,'姓名',76,'','','date','1','','','Form',0,'show|col-10'),(68,'最高學歷',76,'','','radio','2','1111|2222,,33333|.444444','','Form',0,''),(69,'姓名',34,'','請填寫姓名','datetime','1','','require','Flow',0,''),(71,'申請日期',34,'','請填寫聯繫電話','text','1','','require','Flow',0,''),(72,'請假開始時間',34,'','請選擇開始時間','datetime','1','','require','Flow',0,''),(73,'請假結束時間',34,'','請選擇束時間','datetime','1','','require','Flow',0,''),(74,'請假原因',34,'','請填寫請假原因','textarea','2','','require','Flow',0,''),(76,'姓名',38,'','','text','1','','','Flow',0,''),(77,'申請日期',38,'','','date','1','','','Flow',0,''),(78,'所屬部門',38,'','','text','1','','','Flow',0,''),(79,'所屬科室',38,'','','text','1','','','Flow',0,''),(80,'姓名',36,'','','text','1','','','Flow',0,''),(82,'申請日期',36,'','','date','1','','','Flow',0,''),(83,'所屬部門、科室',36,'','','text','1','','','Flow',0,''),(85,'姓名',44,'','','text','1','','','Flow',0,''),(86,'部門/科室',44,'','','text','1','','','Flow',0,''),(87,'離職申請日期',44,'','','date','2','','','Flow',0,''),(88,'離職理由',44,'','','editor','2','','','Flow',0,''),(89,'培訓申請人',54,'1','','text','1','','','Flow',0,''),(90,'部門/科室',54,'2','','text','1','','','Flow',0,''),(91,'培訓地點',54,'3','','text','1','','','Flow',0,''),(92,'培訓開始時間',54,'4','','datetime','1','','','Flow',0,''),(93,'培訓目的',54,'6','','editor','2','','','Flow',0,''),(94,'培訓內容',54,'7','','editor','2','','','Flow',0,''),(95,'姓名',41,'1','','text','1','','','Flow',0,''),(96,'部門/科室',41,'2','','text','1','','','Flow',0,''),(97,'出差地點',41,'3','','text','1','','','Flow',0,''),(98,'出差開始時間',41,'5','','datetime','1','','','Flow',0,''),(99,'預計費用',41,'4','','text','1','','','Flow',0,''),(100,'出差事由/目的',41,'7','','editor','2','','','Flow',0,''),(103,'姓名',40,'','','text','1','','','Flow',0,''),(104,'部門/科室',40,'','','text','1','','','Flow',0,''),(105,'請假開始時間',40,'','','datetime','1','','','Flow',0,''),(106,'請假結束時間',40,'','','datetime','1','','','Flow',0,''),(107,'請假事由',40,'','','editor','2','','','Flow',0,''),(108,'培訓結束時間',54,'5','','datetime','2','','','Flow',0,''),(109,'出差結束時間',41,'6','','datetime','1','','','Flow',0,''),(110,'申請人',43,'','','text','1','','','Flow',0,''),(112,'部門/科室',43,'2','','text','1','','','Flow',0,''),(114,'用途',43,'3','','editor','2','','','Flow',0,''),(115,'申請人',55,'1','','text','1','','','Flow',0,''),(116,'部門/科室',55,'2','','text','1','','','Flow',0,''),(117,'預算依據',55,'4','','editor','2','','','Flow',0,''),(118,'預算用途',55,'3','','editor','2','','','Flow',0,''),(119,'預算明細請參考附件',55,'5','','text','2','','','Flow',0,''),(120,'申請人',45,'1','','text','1','','','Flow',0,''),(121,'部門/科室',45,'2','','text','1','','','Flow',0,''),(122,'出差地點',45,'4','','text','1','','','Flow',0,''),(123,'出差開始時間',45,'5','','datetime','1','','','Flow',0,''),(124,'出差結束時間',45,'6','','datetime','1','','','Flow',0,''),(125,'住宿費用',45,'7','','text','1','','','Flow',0,''),(126,'交通費用',45,'8','','text','1','','','Flow',0,''),(127,'餐費',45,'9','','text','1','','','Flow',0,''),(128,'補貼',45,'91','','text','1','','','Flow',0,''),(129,'申請人',19,'1','','text','1','','','Flow',0,''),(130,'部門/科室',19,'2','','text','1','','','Flow',0,''),(131,'招待地點',19,'4','','text','1','','','Flow',0,''),(132,'招待時間',19,'5','','datetime','1','','','Flow',0,''),(133,'招待費用',19,'7','','text','2','','','Flow',0,''),(134,'招待目的',19,'8','','editor','2','','','Flow',0,''),(135,'招待對像',19,'3','','text','1','','','Flow',0,''),(136,'參加人員',19,'6','','text','1','','','Flow',0,''),(137,'出差目的',45,'3','','text','1','','','Flow',0,''),(138,'申請人',53,'1','','text','1','','','Flow',0,''),(139,'部門/科室',53,'2','','text','1','','','Flow',0,''),(140,'輔設備名',53,'3','','text','1','','','Flow',0,''),(141,'數量',53,'4','','text','1','','','Flow',0,''),(142,'型號規格',53,'5','','text','1','','','Flow',0,''),(143,'預計費用',53,'6','','text','1','','','Flow',0,''),(144,'申請理由',53,'7','','editor','2','','','Flow',0,''),(145,'申請人',51,'1','','text','1','','','Flow',0,''),(146,'部門/科室',51,'2','','text','1','','','Flow',0,''),(147,'設備名稱',51,'3','','text','1','','','Flow',0,''),(148,'數量',51,'4','','text','1','','','Flow',0,''),(149,'型號規格',51,'5','','text','1','','','Flow',0,''),(150,'預計費用',51,'6','','text','1','','','Flow',0,''),(151,'申請理由',51,'7','','editor','2','','','Flow',0,''),(152,'申請人',52,'1','','text','1','','','Flow',0,''),(153,'部門/科室',52,'2','','text','1','','','Flow',0,''),(154,'輔材名稱',52,'3','','text','1','','','Flow',0,''),(155,'數量',52,'4','','text','1','','','Flow',0,''),(156,'型號規格',52,'5','','text','1','','','Flow',0,''),(157,'預計費用',52,'6','','text','1','','','Flow',0,''),(158,'申請理由',52,'7','','editor','2','','','Flow',0,''),(159,'申請人',39,'1','','text','1','','','Flow',0,''),(160,'部門/科室',39,'2','','text','1','','','Flow',0,''),(161,'原材料名稱',39,'3','','text','1','','','Flow',0,''),(162,'數量',39,'4','','text','1','','','Flow',0,''),(163,'型號規格',39,'5','','text','1','','','Flow',0,''),(164,'預計費用',39,'6','','text','1','','','Flow',0,''),(165,'申請理由',39,'7','','editor','2','','','Flow',0,''),(166,'申請人',50,'1','','text','1','','','Flow',0,''),(167,'部門/科室',50,'2','','text','1','','','Flow',0,''),(168,'申請時間',50,'3','','datetime','1','','','Flow',0,''),(169,'出差地點',50,'4','','text','1','','','Flow',0,''),(170,'出差事由',50,'9','','editor','2','','','Flow',0,''),(171,'去程',50,'6','','text','1','','','Flow',0,''),(172,'回程',50,'7','','text','1','','','Flow',0,''),(173,'出差開始時間',50,'51','','datetime','1','','','Flow',0,''),(176,'出差結束時間',50,'52','','datetime','1','','','Flow',0,''),(177,'申請人',49,'1','','text','1','','','Flow',0,''),(178,'部門/科室',49,'2','','text','1','','','Flow',0,''),(179,'目的/用途',49,'3','','text','1','','','Flow',0,''),(180,'使用開始時間',49,'4','','datetime','1','','','Flow',0,''),(181,'使用結束時間',49,'5','','datetime','1','','','Flow',0,''),(182,'申請時間',49,'21','','datetime','1','','','Flow',0,''),(183,'參會人',49,'6','','text','2','','','Flow',0,''),(184,'申請人',42,'1','','text','1','','','Flow',0,''),(185,'部門/科室',42,'2','','text','1','','','Flow',0,''),(186,'申請理由',42,'3','','text','1','','','Flow',0,''),(187,'辦公用品名稱以及數量',42,'4','','editor','2','','','Flow',0,''),(189,'申請時間',42,'21','','text','1','','','Flow',0,''),(190,'申請人',46,'1','','text','1','','','Flow',0,''),(191,'部門/科室',46,'2','','text','1','','','Flow',0,''),(192,'申請時間',46,'3','','datetime','1','','','Flow',0,''),(193,'申請事由',46,'5','','text','2','','','Flow',0,''),(194,'通訊報銷金額',46,'4','','text','1','','','Flow',0,''),(195,'申請人',47,'1','','text','1','','','Flow',0,''),(196,'部門/科室',47,'2','','text','1','','','Flow',0,''),(197,'申請日期',47,'3','','datetime','1','','','Flow',0,''),(199,'出差開始時間',47,'4','','datetime','1','','','Flow',0,''),(200,'出差結束時間',47,'5','','datetime','1','','','Flow',0,''),(201,'出差事由',47,'31','','text','1','','','Flow',0,''),(202,'實際使用費用',47,'6','','text','1','','','Flow',0,''),(203,'標準費用',47,'7','','text','1','','','Flow',0,''),(204,'交通費用明細',47,'8','','editor','2','','','Flow',0,''),(205,'申請人',48,'1','','text','1','','','Flow',0,''),(206,'部門/科室',48,'2','','text','1','','','Flow',0,''),(207,'申請時間',48,'3','','datetime','1','','','Flow',0,''),(208,'實際費用',48,'4','','text','1','','','Flow',0,''),(209,'參加人員',48,'5','','text','2','','','Flow',0,''),(210,'申請事由',48,'41','','text','2','','','Flow',0,'');
/*!40000 ALTER TABLE `xiaoniu_udf_field` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `xiaoniu_user`
--

DROP TABLE IF EXISTS `xiaoniu_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `xiaoniu_user` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `emp_no` varchar(20) NOT NULL DEFAULT '',
  `name` varchar(20) NOT NULL,
  `letter` varchar(10) NOT NULL DEFAULT '',
  `password` char(32) NOT NULL,
  `dept_id` int(11) NOT NULL,
  `position_id` int(11) NOT NULL,
  `rank_id` int(11) NOT NULL,
  `sex` varchar(50) NOT NULL,
  `birthday` date DEFAULT NULL,
  `last_login_ip` varchar(40) DEFAULT NULL,
  `login_count` int(8) DEFAULT NULL,
  `pic` varchar(200) DEFAULT NULL,
  `email` varchar(50) NOT NULL,
  `duty` varchar(2000) NOT NULL,
  `office_tel` varchar(20) NOT NULL,
  `mobile_tel` varchar(20) NOT NULL,
  `create_time` int(11) unsigned NOT NULL,
  `update_time` int(11) unsigned NOT NULL,
  `is_del` tinyint(3) NOT NULL DEFAULT '0',
  `openid` varchar(50) DEFAULT NULL,
  `westatus` tinyint(3) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `account` (`emp_no`)
) ENGINE=InnoDB AUTO_INCREMENT=83 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `xiaoniu_user`
--

LOCK TABLES `xiaoniu_user` WRITE;
/*!40000 ALTER TABLE `xiaoniu_user` DISABLE KEYS */;
INSERT INTO `xiaoniu_user` VALUES (1,'admin','管理員','GLY','21232f297a57a5a743894a0e4a801fc3',1,1,2,'male','2013-09-18','127.0.0.1',3020,'Uploads/emp_pic/1.jpeg','smeoa@qq.com','1231254123123','5086-2222-2222','12123123',1222907803,1431500668,0,'',1),(41,'2002','總監2002','ZJ','4ba29b9f9e5732ed33761840f4ba6c53',6,3,1,'male','2013-10-30','0.0.0.0',NULL,'','','行政，財務','','',1376896154,1407565312,1,NULL,1),(42,'2001','總監2001','ZJ','d0fb963ff976f9c37fc81fe03c21ea7b',8,3,1,'male','2013-10-10','127.0.0.1',NULL,'emp_pic/42.jpeg','','開發','123','12312312',1380970837,1401287019,0,'12312541231251243123',1),(43,'2003','總監2003','ZJ','a591024321c5e2bdbd23ed35f0574dde',7,3,1,'male','0000-00-00','127.0.0.1',NULL,'Uploads/emp_pic/43.jpeg','','銷售','','',1381035116,1432107034,0,NULL,1),(44,'1001','總經理1001','ZJL','b8c37e33defde51cf91e1e03e51657da',1,5,5,'male','0000-00-00','127.0.0.1',NULL,'http://img.smeoa.com/popup/2015-04/552a1c4ba8627.jpg','','全面管理','','18560630025',1381502796,1432260033,0,'',1),(48,'1003','副總1003','FZ','aa68c75c4a77c87f97fb686b2f068676',6,4,1,'female','0000-00-00','192.168.1.106',NULL,'','','銷售，運營','','',1381503490,1401286413,0,NULL,1),(49,'3001','經理3001','JL','908c9a564a86426585b29f5335b619bc',24,2,2,'male','2013-10-10','127.0.0.1',NULL,'','','財務','123','12312312',1391694170,1401287097,0,NULL,1),(50,'3002','經理3002','JL','d806ca13ca3449af72a1ea5aedbed26a',23,2,2,'male','2013-10-10','192.168.1.110',NULL,'','','人事','123','12312312',1391694193,1401287121,0,NULL,NULL),(51,'3003','經理3003','JL','a4380923dd651c195b1631af7c829187',25,2,2,'male','2013-10-10','192.168.1.106',NULL,'','','銷售-南方區域','123','12312312',1391694198,1401287147,0,NULL,NULL),(52,'3004','經理3004','JL','20479c788fb27378c2c99eadcf207e7f',26,2,2,'male','2013-10-10',NULL,NULL,'','','新產品研發','123','12312312',1391694202,1401287170,0,NULL,NULL),(55,'5001','員工5001','YG','03b264c595403666634ac75d828439bc',24,1,3,'male','2013-10-10','192.168.1.106',NULL,'','','會計','123','12312312',1391694320,1401287296,0,NULL,NULL),(56,'5007','員工5007','YG','351869bde8b9d6ad1e3090bd173f600d',26,1,3,'male','2013-10-10','127.0.0.1',NULL,'','','程序員3','123','12312312',1391694335,1401287430,0,NULL,NULL),(57,'5002','員工5002','YG','415585bd389b69659223807d77a96791',24,1,3,'male','2013-10-10','192.168.1.106',NULL,'','','出納','123','12312312',1391694413,1401287322,0,NULL,NULL),(58,'5003','員工5003','YG','240ac9371ec2671ae99847c3ae2e6384',23,1,3,'male','2013-10-10','127.0.0.1',NULL,'','','招聘，薪資管理','123','12312312',1391694420,1401287339,0,NULL,NULL),(59,'5004','員工5004','YG','3202111cf90e7c816a472aaceb72b0df',23,1,3,'male','2013-10-10','127.0.0.1',NULL,'','','負責公司日常採購','123','12312312',1391694427,1401287371,0,NULL,NULL),(60,'5005','員工5005','YG','1d6408264d31d453d556c60fe7d0459e',25,1,3,'male','2013-10-10','127.0.0.1',NULL,'','','程序員1','123','12312312',1391694435,1401287390,0,NULL,NULL),(61,'5006','員工5006','YG','2c27a260f16ad3098393cc529f391f4a',25,1,3,'male','2013-10-10','127.0.0.1',NULL,'','','程序員2','123','12312312',1391694478,1401287410,0,NULL,NULL),(62,'5008','員工5008','YG','b3848d61bbbc6207c6668a8a9e2730ed',26,1,3,'male','2013-10-10','127.0.0.1',NULL,'','','網站編輯，SEO','123','12312312',1391694489,1401287450,0,NULL,NULL);
/*!40000 ALTER TABLE `xiaoniu_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `xiaoniu_user_config`
--

DROP TABLE IF EXISTS `xiaoniu_user_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `xiaoniu_user_config` (
  `id` int(11) NOT NULL DEFAULT '0',
  `home_sort` varchar(255) DEFAULT NULL,
  `list_rows` int(11) DEFAULT '20',
  `readed_info` text,
  `push_web` varchar(255) DEFAULT NULL,
  `push_wechat` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `xiaoniu_user_config`
--

LOCK TABLES `xiaoniu_user_config` WRITE;
/*!40000 ALTER TABLE `xiaoniu_user_config` DISABLE KEYS */;
INSERT INTO `xiaoniu_user_config` VALUES (1,'undefined11,12,|21,22,',10,'129,131,134,137,138','mail,flow,message','mail,flow,message'),(42,'undefined,11,12,|undefined,21,13,',20,'131',NULL,NULL),(43,'undefined,11,12,|undefined,21,13,',20,NULL,NULL,NULL),(44,'undefined12,11,|21,22,',20,NULL,NULL,NULL),(48,NULL,20,'135,136,137,138',NULL,NULL),(49,'undefined,11,12,|13,undefined,21,',20,'130,132',NULL,NULL),(50,NULL,20,'130',NULL,NULL),(51,NULL,20,'54,55,56',NULL,NULL),(52,NULL,20,'54,55,56',NULL,NULL),(53,NULL,20,'54,55,56',NULL,NULL),(54,NULL,20,'54,55,56',NULL,NULL),(55,NULL,20,'130',NULL,NULL),(56,NULL,20,'54,55,56',NULL,NULL),(57,NULL,20,'130',NULL,NULL),(58,NULL,20,'54,55,56',NULL,NULL),(59,NULL,20,'54,55,56',NULL,NULL),(60,'undefined,22,13,23,|undefined,12,21,11,',20,'54,55,56',NULL,NULL),(61,NULL,20,'54,55,56',NULL,NULL),(62,NULL,20,'54,55,56',NULL,NULL),(63,NULL,20,'54,55,56',NULL,NULL),(64,NULL,20,'54,55,56',NULL,NULL),(65,NULL,20,'54,55,56',NULL,NULL),(66,'11,12,13,|21,22,23,',20,'54,55,56',NULL,NULL),(67,NULL,20,'54,55,56',NULL,NULL),(68,'undefined,11,13,|undefined,21,12,',20,'54,55,56',NULL,NULL);
/*!40000 ALTER TABLE `xiaoniu_user_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `xiaoniu_user_folder`
--

DROP TABLE IF EXISTS `xiaoniu_user_folder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `xiaoniu_user_folder` (
  `id` int(3) NOT NULL AUTO_INCREMENT,
  `pid` int(11) NOT NULL,
  `controller` varchar(20) NOT NULL,
  `user_id` int(11) NOT NULL,
  `name` varchar(50) NOT NULL,
  `sort` varchar(20) NOT NULL,
  `is_del` tinyint(3) NOT NULL DEFAULT '0',
  `remark` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=38 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `xiaoniu_user_folder`
--

LOCK TABLES `xiaoniu_user_folder` WRITE;
/*!40000 ALTER TABLE `xiaoniu_user_folder` DISABLE KEYS */;
/*!40000 ALTER TABLE `xiaoniu_user_folder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `xiaoniu_user_tag`
--

DROP TABLE IF EXISTS `xiaoniu_user_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `xiaoniu_user_tag` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) NOT NULL DEFAULT '0',
  `controller` varchar(20) NOT NULL,
  `user_id` int(11) NOT NULL,
  `name` varchar(50) NOT NULL,
  `sort` varchar(20) NOT NULL,
  `remark` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `xiaoniu_user_tag`
--

LOCK TABLES `xiaoniu_user_tag` WRITE;
/*!40000 ALTER TABLE `xiaoniu_user_tag` DISABLE KEYS */;
INSERT INTO `xiaoniu_user_tag` VALUES (21,0,'Contact',1,'123','','');
/*!40000 ALTER TABLE `xiaoniu_user_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `xiaoniu_user_tag_data`
--

DROP TABLE IF EXISTS `xiaoniu_user_tag_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `xiaoniu_user_tag_data` (
  `row_id` int(11) NOT NULL DEFAULT '0',
  `tag_id` int(11) NOT NULL DEFAULT '0',
  `controller` varchar(20) NOT NULL DEFAULT '',
  KEY `row_id` (`row_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `xiaoniu_user_tag_data`
--

LOCK TABLES `xiaoniu_user_tag_data` WRITE;
/*!40000 ALTER TABLE `xiaoniu_user_tag_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `xiaoniu_user_tag_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `xiaoniu_work_log`
--

DROP TABLE IF EXISTS `xiaoniu_work_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `xiaoniu_work_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `user_name` varchar(20) DEFAULT NULL,
  `dept_id` int(11) DEFAULT NULL,
  `dept_name` varchar(20) DEFAULT NULL,
  `create_time` int(11) DEFAULT NULL,
  `content` text,
  `plan` text,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `is_del` tinyint(3) NOT NULL DEFAULT '0',
  `add_file` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `xiaoniu_work_log`
--

LOCK TABLES `xiaoniu_work_log` WRITE;
/*!40000 ALTER TABLE `xiaoniu_work_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `xiaoniu_work_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `xiaoniu_work_order`
--

DROP TABLE IF EXISTS `xiaoniu_work_order`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `xiaoniu_work_order` (
  `id` int(8) unsigned NOT NULL AUTO_INCREMENT,
  `task_no` varchar(20) DEFAULT NULL,
  `pid` int(11) DEFAULT NULL,
  `name` varchar(128) NOT NULL DEFAULT '' COMMENT '標題',
  `content` text COMMENT '內容',
  `executor` varchar(200) DEFAULT NULL,
  `actor` varchar(200) DEFAULT '',
  `add_file` varchar(255) DEFAULT NULL,
  `request_arrive_time` datetime DEFAULT NULL,
  `request_finish_time` datetime DEFAULT NULL,
  `user_id` int(11) unsigned DEFAULT '0',
  `user_name` varchar(20) DEFAULT NULL,
  `dept_id` int(11) DEFAULT NULL,
  `dept_name` varchar(20) DEFAULT NULL,
  `create_time` int(11) DEFAULT NULL,
  `update_time` int(11) DEFAULT NULL,
  `update_user_id` int(11) DEFAULT NULL,
  `update_user_name` varchar(20) DEFAULT NULL,
  `status` tinyint(3) DEFAULT '0',
  `is_del` tinyint(3) DEFAULT '0',
  `other` varchar(20) DEFAULT NULL,
  `arrive_time` int(11) DEFAULT NULL,
  `finish_time` int(11) DEFAULT NULL,
  `arrive_lat` varchar(10) DEFAULT NULL,
  `arrive_lng` varchar(10) DEFAULT NULL,
  `finish_lat` varchar(10) DEFAULT NULL,
  `finish_lng` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=227 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `xiaoniu_work_order`
--

LOCK TABLES `xiaoniu_work_order` WRITE;
/*!40000 ALTER TABLE `xiaoniu_work_order` DISABLE KEYS */;
/*!40000 ALTER TABLE `xiaoniu_work_order` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `xiaoniu_work_order_log`
--

DROP TABLE IF EXISTS `xiaoniu_work_order_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `xiaoniu_work_order_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `task_id` int(11) DEFAULT NULL,
  `type` tinyint(3) DEFAULT NULL,
  `assigner` int(11) DEFAULT NULL COMMENT '分配任務的人',
  `executor` varchar(20) DEFAULT NULL COMMENT '執行人',
  `executor_name` varchar(20) DEFAULT NULL,
  `status` tinyint(3) DEFAULT '0',
  `arrive_time` int(11) DEFAULT NULL,
  `transactor_name` varchar(20) DEFAULT NULL,
  `transactor` int(11) DEFAULT NULL COMMENT '由誰處理的',
  `finish_rate` tinyint(3) DEFAULT NULL,
  `finish_time` int(11) DEFAULT NULL,
  `feed_back` text,
  `arrive_lat` varchar(10) DEFAULT NULL,
  `arrive_lng` varchar(10) DEFAULT NULL,
  `finish_lat` varchar(10) DEFAULT NULL,
  `finish_lng` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=229 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `xiaoniu_work_order_log`
--

LOCK TABLES `xiaoniu_work_order_log` WRITE;
/*!40000 ALTER TABLE `xiaoniu_work_order_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `xiaoniu_work_order_log` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2015-06-14 20:54:25
