;(function($){
/**
 * jqGrid Serbian Translation
 *  (Aleksandar Milovac) aleksandar.milovac@gmail.com
 * http://trirand.com/blog/
 * Dual licensed under the MIT and GPL licenses:
 * http://www.opensource.org/licenses/mit-license.php
 * http://www.gnu.org/licenses/gpl.html
**/
$.jgrid = $.jgrid || {};
$.extend($.jgrid,{
	defaults : {
		recordtext: " {0} - {1}  {2}",
		emptyrecords: " ј ј ",
		loadtext: "њ...",
		pgtext : " {0}  {1}"
	},
	search : {
		caption: "њ...",
		Find: "",
		Reset: "ј",
		odata: [{ oper:'eq', text:"ј"},{ oper:'ne', text:"ј ј"},{ oper:'lt', text:"њ"},{ oper:'le', text:"њ  ј"},{ oper:'gt', text:"ћ"},{ oper:'ge', text:"ћ  ј"},{ oper:'bw', text:"њ "},{ oper:'bn', text:" њ "},{ oper:'in', text:"ј "},{ oper:'ni', text:"ј "},{ oper:'ew', text:" "},{ oper:'en', text:"  "},{ oper:'cn', text:""},{ oper:'nc', text:" "},{ oper:'nu', text:'is null'},{ oper:'nn', text:'is not null'}],
		groupOps: [	{ op: "", text: "" },	{ op: "",  text: "" }	],
		operandTitle : "Click to select search operation.",
		resetTitle : "Reset Search Value"
	},
	edit : {
		addCaption: "ј ",
		editCaption: " ",
		bSubmit: "љ",
		bCancel: "",
		bClose: "",
		saveData: " ј њ! ј ?",
		bYes : "",
		bNo : "",
		bExit : "",
		msg: {
			required:"љ ј ",
			number:",   ј",
			minValue:"   ћ   ј  ",
			maxValue:"   њ   ј ",
			email: "ј  ј ",
			integer: ",   ј  ",
			date: ",   ",
			url: "ј  .  ј  ('http://' or 'https://')",
			nodefined : " ј !",
			novalue : "  ј  !",
			customarray : "Custom function should return array!",
			customfcheck : "Custom function should be present in case of custom checking!"
			
		}
	},
	view : {
		caption: "ј ",
		bClose: ""
	},
	del : {
		caption: "",
		msg: " () ()?",
		bSubmit: "",
		bCancel: ""
	},
	nav : {
		edittext: "",
		edittitle: "  ",
		addtext:"",
		addtitle: "ј  ",
		deltext: "",
		deltitle: "  ",
		searchtext: "",
		searchtitle: "ђ ",
		refreshtext: "",
		refreshtitle: " ј ",
		alertcap: "њ",
		alerttext: ",  ",
		viewtext: "",
		viewtitle: "ј  "
	},
	col : {
		caption: " ",
		bSubmit: "",
		bCancel: ""
	},
	errors : {
		errcap : "",
		nourl : "ј љ URL",
		norecords: "   ",
		model : "  colNames <> colModel!"
	},
	formatter : {
		integer : {thousandsSeparator: " ", defaultValue: '0'},
		number : {decimalSeparator:".", thousandsSeparator: " ", decimalPlaces: 2, defaultValue: '0.00'},
		currency : {decimalSeparator:".", thousandsSeparator: " ", decimalPlaces: 2, prefix: "", suffix:"", defaultValue: '0.00'},
		date : {
			dayNames:   [
				"", "", "", "", "", "", "",
				"љ", "љ", "", "", "", "", ""
			],
			monthNames: [
				"Ј", "", "", "", "ј", "Ј", "Ј", "", "", "", "", "",
				"Ј", "", "", "", "ј", "Ј", "Ј", "", "", "", "", ""
			],
			AmPm : ["am","pm","AM","PM"],
			S: function (j) {return j < 11 || j > 13 ? ['st', 'nd', 'rd', 'th'][Math.min((j - 1) % 10, 3)] : 'th'},
			srcformat: 'Y-m-d',
			newformat: 'd/m/Y',
			parseRe : /[#%\\\/:_;.,\t\s-]/,
			masks : {
				ISO8601Long:"Y-m-d H:i:s",
				ISO8601Short:"Y-m-d",
				ShortDate: "n/j/Y",
				LongDate: "l, F d, Y",
				FullDateTime: "l, F d, Y g:i:s A",
				MonthDay: "F d",
				ShortTime: "g:i A",
				LongTime: "g:i:s A",
				SortableDateTime: "Y-m-d\\TH:i:s",
				UniversalSortableDateTime: "Y-m-d H:i:sO",
				YearMonth: "F, Y"
			},
			reformatAfterEdit : false
		},
		baseLinkUrl: '',
		showAction: '',
		target: '',
		checkbox : {disabled:true},
		idName : 'id'
	}
});
})(jQuery);
