<?php
// +----------------------------------------------------------------------
// | ThinkPHP [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2006-2014 http://thinkphp.cn All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: liu21st <liu21st@gmail.com>
// +----------------------------------------------------------------------

/**
 * ThinkPHP慣例配置文件
 * 該文件請不要修改，如果要覆蓋慣例配置的值，可在應用配置文件中設定和慣例不符的配置項
 * 配置名稱大小寫任意，系統會統一轉換成小寫
 * 所有配置參數都可以在生效前動態改變
 */
defined('THINK_PATH') or exit();
return  array(
    /* 應用設定 */
    'APP_USE_NAMESPACE'     =>  true,    // 應用類庫是否使用命名空間
    'APP_SUB_DOMAIN_DEPLOY' =>  false,   // 是否開啟子域名部署
    'APP_SUB_DOMAIN_RULES'  =>  array(), // 子域名部署規則
    'APP_DOMAIN_SUFFIX'     =>  '', // 域名後綴 如果是com.cn net.cn 之類的後綴必須設置    
    'ACTION_SUFFIX'         =>  '', // 操作方法後綴
    'MULTI_MODULE'          =>  true, // 是否允許多模塊 如果為false 則必須設置 DEFAULT_MODULE
    'MODULE_DENY_LIST'      =>  array('Common','Runtime'),
    'CONTROLLER_LEVEL'      =>  1,
    'APP_AUTOLOAD_LAYER'    =>  'Controller,Model', // 自動加載的應用類庫層 關閉APP_USE_NAMESPACE後有效
    'APP_AUTOLOAD_PATH'     =>  '', // 自動加載的路徑 關閉APP_USE_NAMESPACE後有效

    /* Cookie設置 */
    'COOKIE_EXPIRE'         =>  0,       // Cookie有效期
    'COOKIE_DOMAIN'         =>  '',      // Cookie有效域名
    'COOKIE_PATH'           =>  '/',     // Cookie路徑
    'COOKIE_PREFIX'         =>  '',      // Cookie前綴 避免衝突
    'COOKIE_SECURE'         =>  false,   // Cookie安全傳輸
    'COOKIE_HTTPONLY'       =>  '',      // Cookie httponly設置

    /* 默認設定 */
    'DEFAULT_M_LAYER'       =>  'Model', // 默認的模型層名稱
    'DEFAULT_C_LAYER'       =>  'Controller', // 默認的控制器層名稱
    'DEFAULT_V_LAYER'       =>  'View', // 默認的視圖層名稱
    'DEFAULT_LANG'          =>  'zh-cn', // 默認語言
    'DEFAULT_THEME'         =>  '',	// 默認模板主題名稱
    'DEFAULT_MODULE'        =>  'Home',  // 默認模塊
    'DEFAULT_CONTROLLER'    =>  'Index', // 默認控制器名稱
    'DEFAULT_ACTION'        =>  'index', // 默認操作名稱
    'DEFAULT_CHARSET'       =>  'utf-8', // 默認輸出編碼
    'DEFAULT_TIMEZONE'      =>  'PRC',	// 默認時區
    'DEFAULT_AJAX_RETURN'   =>  'JSON',  // 默認AJAX 數據返回格式,可選JSON XML ...
    'DEFAULT_JSONP_HANDLER' =>  'jsonpReturn', // 默認JSONP格式返回的處理方法
    'DEFAULT_FILTER'        =>  'htmlspecialchars', // 默認參數過濾方法 用於I函數...

    /* 數據庫設置 */
    'DB_TYPE'               =>  '',     // 數據庫類型
    'DB_HOST'               =>  '', // 服務器地址
    'DB_NAME'               =>  '',          // 數據庫名
    'DB_USER'               =>  '',      // 用戶名
    'DB_PWD'                =>  '',          // 密碼
    'DB_PORT'               =>  '',        // 端口
    'DB_PREFIX'             =>  '',    // 數據庫表前綴
    'DB_PARAMS'          	=>  array(), // 數據庫連接參數    
    'DB_DEBUG'  			=>  TRUE, // 數據庫調試模式 開啟後可以記錄SQL日誌
    'DB_FIELDS_CACHE'       =>  true,        // 啟用字段緩存
    'DB_CHARSET'            =>  'utf8',      // 數據庫編碼默認採用utf8
    'DB_DEPLOY_TYPE'        =>  0, // 數據庫部署方式:0 集中式(單一服務器),1 分佈式(主從服務器)
    'DB_RW_SEPARATE'        =>  false,       // 數據庫讀寫是否分離 主從式有效
    'DB_MASTER_NUM'         =>  1, // 讀寫分離後 主服務器數量
    'DB_SLAVE_NO'           =>  '', // 指定從服務器序號

    /* 數據緩存設置 */
    'DATA_CACHE_TIME'       =>  0,      // 數據緩存有效期 0表示永久緩存
    'DATA_CACHE_COMPRESS'   =>  false,   // 數據緩存是否壓縮緩存
    'DATA_CACHE_CHECK'      =>  false,   // 數據緩存是否校驗緩存
    'DATA_CACHE_PREFIX'     =>  '',     // 緩存前綴
    'DATA_CACHE_TYPE'       =>  'File',  // 數據緩存類型,支持:File|Db|Apc|Memcache|Shmop|Sqlite|Xcache|Apachenote|Eaccelerator
    'DATA_CACHE_PATH'       =>  TEMP_PATH,// 緩存路徑設置 (僅對File方式緩存有效)
    'DATA_CACHE_KEY'        =>  '',	// 緩存文件KEY (僅對File方式緩存有效)    
    'DATA_CACHE_SUBDIR'     =>  false,    // 使用子目錄緩存 (自動根據緩存標識的哈希創建子目錄)
    'DATA_PATH_LEVEL'       =>  1,        // 子目錄緩存級別

    /* 錯誤設置 */
    'ERROR_MESSAGE'         =>  '頁面錯誤！請稍後再試～',//錯誤顯示信息,非調試模式有效
    'ERROR_PAGE'            =>  '',	// 錯誤定向頁面
    'SHOW_ERROR_MSG'        =>  false,    // 顯示錯誤信息
    'TRACE_MAX_RECORD'      =>  100,    // 每個級別的錯誤信息 最大記錄數

    /* 日誌設置 */
    'LOG_RECORD'            =>  false,   // 默認不記錄日誌
    'LOG_TYPE'              =>  'File', // 日誌記錄類型 默認為文件方式
    'LOG_LEVEL'             =>  'EMERG,ALERT,CRIT,ERR',// 允許記錄的日誌級別
    'LOG_FILE_SIZE'         =>  2097152,	// 日誌文件大小限制
    'LOG_EXCEPTION_RECORD'  =>  false,    // 是否記錄異常信息日誌

    /* SESSION設置 */
    'SESSION_AUTO_START'    =>  true,    // 是否自動開啟Session
    'SESSION_OPTIONS'       =>  array(), // session 配置數組 支持type name id path expire domain 等參數
    'SESSION_TYPE'          =>  '', // session hander類型 默認無需設置 除非擴展了session hander驅動
    'SESSION_PREFIX'        =>  '', // session 前綴
    //'VAR_SESSION_ID'      =>  'session_id',     //sessionID的提交變量

    /* 模板引擎設置 */
    'TMPL_CONTENT_TYPE'     =>  'text/html', // 默認模板輸出類型
    'TMPL_ACTION_ERROR'     =>  THINK_PATH.'Tpl/dispatch_jump.tpl', // 默認錯誤跳轉對應的模板文件
    'TMPL_ACTION_SUCCESS'   =>  THINK_PATH.'Tpl/dispatch_jump.tpl', // 默認成功跳轉對應的模板文件
    'TMPL_EXCEPTION_FILE'   =>  THINK_PATH.'Tpl/think_exception.tpl',// 異常頁面的模板文件
    'TMPL_DETECT_THEME'     =>  false,       // 自動偵測模板主題
    'TMPL_TEMPLATE_SUFFIX'  =>  '.html',     // 默認模板文件後綴
    'TMPL_FILE_DEPR'        =>  '/', //模板文件CONTROLLER_NAME與ACTION_NAME之間的分割符
    // 佈局設置
    'TMPL_ENGINE_TYPE'      =>  'Think',     // 默認模板引擎 以下設置僅對使用Think模板引擎有效
    'TMPL_CACHFILE_SUFFIX'  =>  '.php',      // 默認模板緩存後綴
    'TMPL_DENY_FUNC_LIST'   =>  'echo,exit',    // 模板引擎禁用函數
    'TMPL_DENY_PHP'         =>  false, // 默認模板引擎是否禁用PHP原生代碼
    'TMPL_L_DELIM'          =>  '{',            // 模板引擎普通標籤開始標記
    'TMPL_R_DELIM'          =>  '}',            // 模板引擎普通標籤結束標記
    'TMPL_VAR_IDENTIFY'     =>  'array',     // 模板變量識別。留空自動判斷,參數為'obj'則表示對像
    'TMPL_STRIP_SPACE'      =>  true,       // 是否去除模板文件裡面的html空格與換行
    'TMPL_CACHE_ON'         =>  true,        // 是否開啟模板編譯緩存,設為false則每次都會重新編譯
    'TMPL_CACHE_PREFIX'     =>  '',         // 模板緩存前綴標識，可以動態改變
    'TMPL_CACHE_TIME'       =>  0,         // 模板緩存有效期 0 為永久，(以數字為值，單位:秒)
    'TMPL_LAYOUT_ITEM'      =>  '{__CONTENT__}', // 佈局模板的內容替換標識
    'LAYOUT_ON'             =>  false, // 是否啟用佈局
    'LAYOUT_NAME'           =>  'layout', // 當前佈局名稱 默認為layout

    // Think模板引擎標籤庫相關設定
    'TAGLIB_BEGIN'          =>  '<',  // 標籤庫標籤開始標記
    'TAGLIB_END'            =>  '>',  // 標籤庫標籤結束標記
    'TAGLIB_LOAD'           =>  true, // 是否使用內置標籤庫之外的其它標籤庫，默認自動檢測
    'TAGLIB_BUILD_IN'       =>  'cx', // 內置標籤庫名稱(標籤使用不必指定標籤庫名稱),以逗號分隔 注意解析順序
    'TAGLIB_PRE_LOAD'       =>  '',   // 需要額外加載的標籤庫(須指定標籤庫名稱)，多個以逗號分隔 
    
    /* URL設置 */
    'URL_CASE_INSENSITIVE'  =>  true,   // 默認false 表示URL區分大小寫 true則表示不區分大小寫
    'URL_MODEL'             =>  1,       // URL訪問模式,可選參數0、1、2、3,代表以下四種模式：
    // 0 (普通模式); 1 (PATHINFO 模式); 2 (REWRITE  模式); 3 (兼容模式)  默認為PATHINFO 模式
    'URL_PATHINFO_DEPR'     =>  '/',	// PATHINFO模式下，各參數之間的分割符號
    'URL_PATHINFO_FETCH'    =>  'ORIG_PATH_INFO,REDIRECT_PATH_INFO,REDIRECT_URL', // 用於兼容判斷PATH_INFO 參數的SERVER替代變量列表
    'URL_REQUEST_URI'       =>  'REQUEST_URI', // 獲取當前頁面地址的系統變量 默認為REQUEST_URI
    'URL_HTML_SUFFIX'       =>  'html',  // URL偽靜態後綴設置
    'URL_DENY_SUFFIX'       =>  'ico|png|gif|jpg', // URL禁止訪問的後綴設置
    'URL_PARAMS_BIND'       =>  true, // URL變量綁定到Action方法參數
    'URL_PARAMS_BIND_TYPE'  =>  0, // URL變量綁定的類型 0 按變量名綁定 1 按變量順序綁定
    'URL_PARAMS_FILTER'     =>  false, // URL變量綁定過濾
    'URL_PARAMS_FILTER_TYPE'=>  '', // URL變量綁定過濾方法 如果為空 調用DEFAULT_FILTER
    'URL_ROUTER_ON'         =>  false,   // 是否開啟URL路由
    'URL_ROUTE_RULES'       =>  array(), // 默認路由規則 針對模塊
    'URL_MAP_RULES'         =>  array(), // URL映射定義規則

    /* 系統變量名稱設置 */
    'VAR_MODULE'            =>  'm',     // 默認模塊獲取變量
    'VAR_ADDON'             =>  'addon',     // 默認的插件控制器命名空間變量
    'VAR_CONTROLLER'        =>  'c',    // 默認控制器獲取變量
    'VAR_ACTION'            =>  'a',    // 默認操作獲取變量
    'VAR_AJAX_SUBMIT'       =>  'ajax',  // 默認的AJAX提交變量
    'VAR_JSONP_HANDLER'     =>  'callback',
    'VAR_PATHINFO'          =>  's',    // 兼容模式PATHINFO獲取變量例如 ?s=/module/action/id/1 後面的參數取決於URL_PATHINFO_DEPR
    'VAR_TEMPLATE'          =>  't',    // 默認模板切換變量
    'VAR_AUTO_STRING'		=>	false,	// 輸入變量是否自動強制轉換為字符串 如果開啟則數組變量需要手動傳入變量修飾符獲取變量

    'HTTP_CACHE_CONTROL'    =>  'private',  // 網頁緩存控制
    'CHECK_APP_DIR'         =>  true,       // 是否檢查應用目錄是否創建
    'FILE_UPLOAD_TYPE'      =>  'Local',    // 文件上傳方式
    'DATA_CRYPT_TYPE'       =>  'Think',    // 數據加密方式

);
