<?php
// +----------------------------------------------------------------------
// | ThinkPHP [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2009 http://thinkphp.cn All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: liu21st <liu21st@gmail.com>
// +----------------------------------------------------------------------
namespace Behavior;
/**
 * 瀏覽器防刷新檢測
 */
class BrowserCheckBehavior {
    public function run(&$params) {
        if($_SERVER['REQUEST_METHOD'] == 'GET') {
            //	啟用頁面防刷新機制
            $guid	=	md5($_SERVER['PHP_SELF']);
            // 瀏覽器防刷新的時間間隔（秒） 默認為10
            $refleshTime    =   C('LIMIT_REFLESH_TIMES',null,10);
            // 檢查頁面刷新間隔
            if(cookie('_last_visit_time_'.$guid) && cookie('_last_visit_time_'.$guid)>time()-$refleshTime) {
                // 頁面刷新讀取瀏覽器緩存
                header('HTTP/1.1 304 Not Modified');
                exit;
            }else{
                // 緩存當前地址訪問時間
                cookie('_last_visit_time_'.$guid, $_SERVER['REQUEST_TIME']);
                //header('Last-Modified:'.(date('D,d M Y H:i:s',$_SERVER['REQUEST_TIME']-C('LIMIT_REFLESH_TIMES'))).' GMT');
            }
        }
    }
}