<?php
// +----------------------------------------------------------------------
// | ThinkPHP [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2006-2012 http://thinkphp.cn All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: liu21st <liu21st@gmail.com>
// +----------------------------------------------------------------------
namespace Behavior;
/**
 * 系統行為擴展：操作路由檢測
 */
class CheckActionRouteBehavior {

    // 行為擴展的執行入口必須是run
    public function run(&$config){
        // 優先檢測是否存在PATH_INFO
        $regx   =   trim($_SERVER['PATH_INFO'],'/');
        if(empty($regx)) return ;
        // 路由定義文件優先於config中的配置定義
        // 路由處理
        $routes =   $config['routes'];
        if(!empty($routes)) {
            $depr = C('URL_PATHINFO_DEPR');
            // 分隔符替換 確保路由定義使用統一的分隔符
            $regx = str_replace($depr,'/',$regx);
            $regx = substr_replace($regx,'',0,strlen(__URL__));
            foreach ($routes as $rule=>$route){
                if(0===strpos($rule,'/') && preg_match($rule,$regx,$matches)) { // 正則路由
                    return C('ACTION_NAME',$this->parseRegex($matches,$route,$regx));
                }else{ // 規則路由
                    $len1   =   substr_count($regx,'/');
                    $len2   =   substr_count($rule,'/');
                    if($len1>=$len2) {
                        if('$' == substr($rule,-1,1)) {// 完整匹配
                            if($len1 != $len2) {
                                continue;
                            }else{
                                $rule =  substr($rule,0,-1);
                            }
                        }
                        $match  =  $this->checkUrlMatch($regx,$rule);
                        if($match)  return C('ACTION_NAME',$this->parseRule($rule,$route,$regx));
                    }
                }
            }
        }
    }

    // 檢測URL和規則路由是否匹配
    private function checkUrlMatch($regx,$rule) {
        $m1     =   explode('/',$regx);
        $m2     =   explode('/',$rule);
        $match  =   true; // 是否匹配
        foreach ($m2 as $key=>$val){
            if(':' == substr($val,0,1)) {// 動態變量
                if(strpos($val,'\\')) {
                    $type = substr($val,-1);
                    if('d'==$type && !is_numeric($m1[$key])) {
                        $match = false;
                        break;
                    }
                }elseif(strpos($val,'^')){
                    $array   =  explode('|',substr(strstr($val,'^'),1));
                    if(in_array($m1[$key],$array)) {
                        $match = false;
                        break;
                    }
                }
            }elseif(0 !== strcasecmp($val,$m1[$key])){
                $match = false;
                break;
            }
        }
        return $match;
    }

    // 解析規範的路由地址
    // 地址格式 操作?參數1=值1&參數2=值2...
    private function parseUrl($url) {
        $var  =  array();
        if(false !== strpos($url,'?')) { // 操作?參數1=值1&參數2=值2...
            $info   =   parse_url($url);
            $path   =   $info['path'];
            parse_str($info['query'],$var);
        }else{ // 操作
            $path   =   $url;
        }
        $var[C('VAR_ACTION')] = $path;
        return $var;
    }

    // 解析規則路由
    // '路由規則'=>'操作?額外參數1=值1&額外參數2=值2...'
    // '路由規則'=>array('操作','額外參數1=值1&額外參數2=值2...')
    // '路由規則'=>'外部地址'
    // '路由規則'=>array('外部地址','重定向代碼')
    // 路由規則中 :開頭 表示動態變量
    // 外部地址中可以用動態變量 採用 :1 :2 的方式
    // 'news/:month/:day/:id'=>array('News/read?cate=1','status=1'),
    // 'new/:id'=>array('/new.php?id=:1',301), 重定向
    private function parseRule($rule,$route,$regx) {
        // 獲取路由地址規則
        $url        =   is_array($route)?$route[0]:$route;
        // 獲取URL地址中的參數
        $paths      =   explode('/',$regx);
        // 解析路由規則
        $matches    =   array();
        $rule       =   explode('/',$rule);
        foreach ($rule as $item){
            if(0===strpos($item,':')) { // 動態變量獲取
                if($pos = strpos($item,'^') ) {
                    $var  =  substr($item,1,$pos-1);
                }elseif(strpos($item,'\\')){
                    $var  =  substr($item,1,-2);
                }else{
                    $var  =  substr($item,1);
                }
                $matches[$var] = array_shift($paths);
            }else{ // 過濾URL中的靜態變量
                array_shift($paths);
            }
        }
        if(0=== strpos($url,'/') || 0===strpos($url,'http')) { // 路由重定向跳轉
            if(strpos($url,':')) { // 傳遞動態參數
                $values =   array_values($matches);
                $url    =   preg_replace('/:(\d+)/e','$values[\\1-1]',$url);
            }
            header("Location: $url", true,(is_array($route) && isset($route[1]))?$route[1]:301);
            exit;
        }else{
            // 解析路由地址
            $var        =   $this->parseUrl($url);
            // 解析路由地址裡面的動態參數
            $values     =   array_values($matches);
            foreach ($var as $key=>$val){
                if(0===strpos($val,':')) {
                    $var[$key] =  $values[substr($val,1)-1];
                }
            }
            $var        =   array_merge($matches,$var);
            // 解析剩餘的URL參數
            if($paths) {
                preg_replace('@(\w+)\/([^\/]+)@e', '$var[strtolower(\'\\1\')]=strip_tags(\'\\2\');', implode('/',$paths));
            }
            // 解析路由自動傳入參數
            if(is_array($route) && isset($route[1])) {
                parse_str($route[1],$params);
                $var   =   array_merge($var,$params);
            }
            $action =   $var[C('VAR_ACTION')];
            unset($var[C('VAR_ACTION')]);
            $_GET   =   array_merge($var,$_GET);
            return $action;
        }
    }

    // 解析正則路由
    // '路由正則'=>'[分組/模塊/操作]?參數1=值1&參數2=值2...'
    // '路由正則'=>array('[分組/模塊/操作]?參數1=值1&參數2=值2...','額外參數1=值1&額外參數2=值2...')
    // '路由正則'=>'外部地址'
    // '路由正則'=>array('外部地址','重定向代碼')
    // 參數值和外部地址中可以用動態變量 採用 :1 :2 的方式
    // '/new\/(\d+)\/(\d+)/'=>array('News/read?id=:1&page=:2&cate=1','status=1'),
    // '/new\/(\d+)/'=>array('/new.php?id=:1&page=:2&status=1','301'), 重定向
    private function parseRegex($matches,$route,$regx) {
        // 獲取路由地址規則
        $url   =  is_array($route)?$route[0]:$route;
        $url   =  preg_replace('/:(\d+)/e','$matches[\\1]',$url);
        if(0=== strpos($url,'/') || 0===strpos($url,'http')) { // 路由重定向跳轉
            header("Location: $url", true,(is_array($route) && isset($route[1]))?$route[1]:301);
            exit;
        }else{
            // 解析路由地址
            $var    =   $this->parseUrl($url);
            // 解析剩餘的URL參數
            $regx   =   substr_replace($regx,'',0,strlen($matches[0]));
            if($regx) {
                preg_replace('@(\w+)\/([^,\/]+)@e', '$var[strtolower(\'\\1\')]=strip_tags(\'\\2\');', $regx);
            }
            // 解析路由自動傳入參數
            if(is_array($route) && isset($route[1])) {
                parse_str($route[1],$params);
                $var   =   array_merge($var,$params);
            }
            $action =   $var[C('VAR_ACTION')];
            unset($var[C('VAR_ACTION')]);
            $_GET   =   array_merge($var,$_GET);
        }
        return $action;
    }
}