<?php
// +----------------------------------------------------------------------
// | ThinkPHP [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2006-2012 http://thinkphp.cn All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: liu21st <liu21st@gmail.com>
// +----------------------------------------------------------------------
namespace Behavior;
/**
 * 語言檢測 並自動加載語言包
 */
class CheckLangBehavior {

    // 行為擴展的執行入口必須是run
    public function run(&$params){
        // 檢測語言
        $this->checkLanguage();
    }

    /**
     * 語言檢查
     * 檢查瀏覽器支持語言，並自動加載語言包
     * @access private
     * @return void
     */
    private function checkLanguage() {
        // 不開啟語言包功能，僅僅加載框架語言文件直接返回
        if (!C('LANG_SWITCH_ON',null,false)){
            return;
        }
        $langSet = C('DEFAULT_LANG');
        $varLang =  C('VAR_LANGUAGE',null,'l');
        $langList = C('LANG_LIST',null,'zh-cn');
        // 啟用了語言包功能
        // 根據是否啟用自動偵測設置獲取語言選擇
        if (C('LANG_AUTO_DETECT',null,true)){
            if(isset($_GET[$varLang])){
                $langSet = $_GET[$varLang];// url中設置了語言變量
                cookie('think_language',$langSet,3600);
            }elseif(cookie('think_language')){// 獲取上次用戶的選擇
                $langSet = cookie('think_language');
            }elseif(isset($_SERVER['HTTP_ACCEPT_LANGUAGE'])){// 自動偵測瀏覽器語言
                preg_match('/^([a-z\d\-]+)/i', $_SERVER['HTTP_ACCEPT_LANGUAGE'], $matches);
                $langSet = $matches[1];
                cookie('think_language',$langSet,3600);
            }
            if(false === stripos($langList,$langSet)) { // 非法語言參數
                $langSet = C('DEFAULT_LANG');
            }
        }
        // 定義當前語言
        define('LANG_SET',strtolower($langSet));

        // 讀取框架語言包
        $file   =   THINK_PATH.'Lang/'.LANG_SET.'.php';
        if(LANG_SET != C('DEFAULT_LANG') && is_file($file))
            L(include $file);

        // 讀取應用公共語言包
        $file   =  LANG_PATH.LANG_SET.'.php';
        if(is_file($file))
            L(include $file);
        
        // 讀取模塊語言包
        $file   =   MODULE_PATH.'Lang/'.LANG_SET.'.php';
        if(is_file($file))
            L(include $file);

        // 讀取當前控制器語言包
        $file   =   MODULE_PATH.'Lang/'.LANG_SET.'/'.strtolower(CONTROLLER_NAME).'.php';
        if (is_file($file))
            L(include $file);
    }
}
