<?php
// +----------------------------------------------------------------------
// | ThinkPHP [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2006-2014 http://thinkphp.cn All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: liu21st <liu21st@gmail.com>
// +----------------------------------------------------------------------
namespace Behavior;
/**
 * 系統行為擴展：模板內容輸出替換
 */
class ContentReplaceBehavior {

    // 行為擴展的執行入口必須是run
    public function run(&$content){
        $content = $this->templateContentReplace($content);
    }

    /**
     * 模板內容替換
     * @access protected
     * @param string $content 模板內容
     * @return string
     */
    protected function templateContentReplace($content) {
        // 系統默認的特殊變量替換
        $replace =  array(
            '__ROOT__'      =>  __ROOT__,       // 當前網站地址
            '__APP__'       =>  __APP__,        // 當前應用地址
            '__MODULE__'    =>  __MODULE__,
            '__ACTION__'    =>  __ACTION__,     // 當前操作地址
            '__SELF__'      =>  __SELF__,       // 當前頁面地址
            '__CONTROLLER__'=>  __CONTROLLER__,
            '__URL__'       =>  __CONTROLLER__,
            '__PUBLIC__'    =>  __ROOT__.'/Public',// 站點公共目錄
        );
        // 允許用戶自定義模板的字符串替換
        if(is_array(C('TMPL_PARSE_STRING')) )
            $replace =  array_merge($replace,C('TMPL_PARSE_STRING'));
        $content = str_replace(array_keys($replace),array_values($replace),$content);
        return $content;
    }

}