<?php
// +----------------------------------------------------------------------
// | ThinkPHP [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2006-2014 http://thinkphp.cn All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: liu21st <liu21st@gmail.com>
// +----------------------------------------------------------------------
namespace Behavior;
use Think\Storage;
/**
 * 系統行為擴展：靜態緩存讀取
 */
class ReadHtmlCacheBehavior {
    // 行為擴展的執行入口必須是run
    public function run(&$params){
        // 開啟靜態緩存
        if(IS_GET && C('HTML_CACHE_ON'))  {
            $cacheTime = $this->requireHtmlCache();
            if( false !== $cacheTime && $this->checkHTMLCache(HTML_FILE_NAME,$cacheTime)) { //靜態頁面有效
                // 讀取靜態頁面輸出
                echo Storage::read(HTML_FILE_NAME,'html');
                exit();
            }
        }
    }

    // 判斷是否需要靜態緩存
    static private function requireHtmlCache() {
        // 分析當前的靜態規則
         $htmls = C('HTML_CACHE_RULES'); // 讀取靜態規則
         if(!empty($htmls)) {
            $htmls = array_change_key_case($htmls);
            // 靜態規則文件定義格式 actionName=>array('靜態規則','緩存時間','附加規則')
            // 'read'=>array('{id},{name}',60,'md5') 必須保證靜態規則的唯一性 和 可判斷性
            // 檢測靜態規則
            $controllerName = strtolower(CONTROLLER_NAME);
            $actionName     = strtolower(ACTION_NAME);
            if(isset($htmls[$controllerName.':'.$actionName])) {
                $html   =   $htmls[$controllerName.':'.$actionName];   // 某個控制器的操作的靜態規則
            }elseif(isset($htmls[$controllerName.':'])){// 某個控制器的靜態規則
                $html   =   $htmls[$controllerName.':'];
            }elseif(isset($htmls[$actionName])){
                $html   =   $htmls[$actionName]; // 所有操作的靜態規則
            }elseif(isset($htmls['*'])){
                $html   =   $htmls['*']; // 全局靜態規則
            }
            if(!empty($html)) {
                // 解讀靜態規則
                $rule   = is_array($html)?$html[0]:$html;
                // 以$_開頭的系統變量
                $callback = function($match){ 
                    switch($match[1]){
                        case '_GET':        $var = $_GET[$match[2]]; break;
                        case '_POST':       $var = $_POST[$match[2]]; break;
                        case '_REQUEST':    $var = $_REQUEST[$match[2]]; break;
                        case '_SERVER':     $var = $_SERVER[$match[2]]; break;
                        case '_SESSION':    $var = $_SESSION[$match[2]]; break;
                        case '_COOKIE':     $var = $_COOKIE[$match[2]]; break;
                    }
                    return (count($match) == 4) ? $match[3]($var) : $var;
                };
                $rule     = preg_replace_callback('/{\$(_\w+)\.(\w+)(?:\|(\w+))?}/', $callback, $rule);
                // {ID|FUN} GET變量的簡寫
                $rule     = preg_replace_callback('/{(\w+)\|(\w+)}/', function($match){return $match[2]($_GET[$match[1]]);}, $rule);
                $rule     = preg_replace_callback('/{(\w+)}/', function($match){return $_GET[$match[1]];}, $rule);
                // 特殊系統變量
                $rule   = str_ireplace(
                    array('{:controller}','{:action}','{:module}'),
                    array(CONTROLLER_NAME,ACTION_NAME,MODULE_NAME),
                    $rule);
                // {|FUN} 單獨使用函數
                $rule  = preg_replace_callback('/{|(\w+)}/', function($match){return $match[1]();},$rule);
                $cacheTime  =   C('HTML_CACHE_TIME',null,60);
                if(is_array($html)){
                    if(!empty($html[2])) $rule    =   $html[2]($rule); // 應用附加函數
                    $cacheTime  =   isset($html[1])?$html[1]:$cacheTime; // 緩存有效期
                }else{
                    $cacheTime  =   $cacheTime;
                }
                
                // 當前緩存文件
                define('HTML_FILE_NAME',HTML_PATH . $rule.C('HTML_FILE_SUFFIX',null,'.html'));
                return $cacheTime;
            }
        }
        // 無需緩存
        return false;
    }

    /**
     * 檢查靜態HTML文件是否有效
     * 如果無效需要重新更新
     * @access public
     * @param string $cacheFile  靜態文件名
     * @param integer $cacheTime  緩存有效期
     * @return boolean
     */
    static public function checkHTMLCache($cacheFile='',$cacheTime='') {
        if(!is_file($cacheFile) && 'sae' != APP_MODE ){
            return false;
        }elseif (filemtime(\Think\Think::instance('Think\View')->parseTemplate()) > Storage::get($cacheFile,'mtime','html')) {
            // 模板文件如果更新靜態文件需要更新
            return false;
        }elseif(!is_numeric($cacheTime) && function_exists($cacheTime)){
            return $cacheTime($cacheFile);
        }elseif ($cacheTime != 0 && NOW_TIME > Storage::get($cacheFile,'mtime','html')+$cacheTime) {
            // 文件是否在有效期
            return false;
        }
        //靜態文件有效
        return true;
    }

}