<?php
// | ThinkPHP [ WE CAN DO IT JUST THINK IT ]
// | Copyright (c) 2006-2012 http://thinkphp.cn All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: luofei614<www.3g4k.com>
// +----------------------------------------------------------------------
namespace Behavior;
/**
 * 升級短信通知， 如果有ThinkPHP新版升級，或者重要的更新，會發送短信通知你。
 * 需要使用SAE的短信服務。請先找一個SAE的應用開通短信服務。
 * 使用步驟如下：
 * 1，在項目的Conf目錄下建立tags.php配置文件，內容如下：
 * <code>
 * <?php
 * return array(
 *   'app_init' =>  array('UpgradeNotice')
 * );
 * </code>
 *
 * 2，將此文件放在應用的Lib/Behavior文件夾下。
 *註：在SAE上面使用時，以上兩步可以省略 
 * 3，在config.php中配置：
 *  'UPGRADE_NOTICE_ON'=>true,//開啟短信升級提醒功能 
 * 'UPGRADE_NOTICE_AKEY'=>'your akey',//SAE應用的AKEY，如果在SAE上使用可以不填
 * 'UPGRADE_NOTICE_SKEY'=>'your skey',//SAE應用的SKEY，如果在SAE上使用可以不填
 *'UPGRADE_NOTICE_MOBILE'=>'136456789',//接受短信的手機號
 *'UPGRADE_NOTICE_CHECK_INTERVAL' => 604800,//檢測頻率,單位秒,默認是一周
 *'UPGRADE_CURRENT_VERSION'=>'0',//升級後的版本號，會在短信中告訴你填寫什麼
 *UPGRADE_NOTICE_DEBUG=>true, //調試默認，如果為true，UPGRADE_NOTICE_CHECK_INTERVAL配置不起作用，每次都會進行版本檢查，此時用於調試，調試完畢後請設置次配置為false
 *
 */

class UpgradeNoticeBehavior {

    protected $header_ = '';
    protected $httpCode_;
    protected $httpDesc_;
    protected $accesskey_;
    protected $secretkey_;
    public function run(&$params) {
        if (C('UPGRADE_NOTICE_ON') && (!S('think_upgrade_interval') || C('UPGRADE_NOTICE_DEBUG'))) {
            if(IS_SAE && C('UPGRADE_NOTICE_QUEUE') && !isset($_POST['think_upgrade_queque'])){
                $queue=new SaeTaskQueue(C('UPGRADE_NOTICE_QUEUE'));
                $queue->addTask('http://'.$_SERVER['HTTP_HOST'].__APP__,'think_upgrade_queque=1');
                if(!$queue->push()){
                    trace('升級提醒隊列執行失敗,錯誤原因：'.$queue->errmsg(), '升級通知出錯', 'NOTIC', true);
                }
                return ;
            }
            $akey = C('UPGRADE_NOTICE_AKEY',null,'');
            $skey = C('UPGRADE_NOTICE_SKEY',null,'');
            $this->accesskey_ = $akey ? $akey : (defined('SAE_ACCESSKEY') ? SAE_ACCESSKEY : '');
            $this->secretkey_ = $skey ? $skey : (defined('SAE_SECRETKEY') ? SAE_SECRETKEY : '');
            $current_version = C('UPGRADE_CURRENT_VERSION',null,0);
            //讀取接口
            $info = $this->send('http://sinaclouds.sinaapp.com/thinkapi/upgrade.php?v=' . $current_version);
             if ($info['version'] != $current_version) {
                    if($this->send_sms($info['msg']))  trace($info['msg'], '升級通知成功', 'NOTIC', true); //發送升級短信
            }
            S('think_upgrade_interval', true, C('UPGRADE_NOTICE_CHECK_INTERVAL',null,604800));
        }
    }
    private function send_sms($msg) {
        $timestamp=time();
        $url = 'http://inno.smsinter.sina.com.cn/sae_sms_service/sendsms.php'; //發送短信的接口地址
        $content = "FetchUrl" . $url . "TimeStamp" . $timestamp . "AccessKey" . $this->accesskey_;
        $signature = (base64_encode(hash_hmac('sha256', $content, $this->secretkey_, true)));
        $headers = array(
            "FetchUrl: $url",
            "AccessKey: ".$this->accesskey_,
            "TimeStamp: " . $timestamp,
            "Signature: $signature"
        );
        $data = array(
            'mobile' => C('UPGRADE_NOTICE_MOBILE',null,'') ,
            'msg' => $msg,
            'encoding' => 'UTF-8'
        );
        if(!$ret = $this->send('http://g.apibus.io', $data, $headers)){
            return false;
        }
        if (isset($ret['ApiBusError'])) {
            trace('errno:' . $ret['ApiBusError']['errcode'] . ',errmsg:' . $ret['ApiBusError']['errdesc'], '升級通知出錯', 'NOTIC', true);
            
            return false;
        }
        
        return true;
    }
    private function send($url, $params = array() , $headers = array()) {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        if (!empty($params)) {
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $params);
        }
        if (!empty($headers)) curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $txt = curl_exec($ch);
        if (curl_errno($ch)) {
            trace(curl_error($ch) , '升級通知出錯', 'NOTIC', true);
            
            return false;
        }
        curl_close($ch);
        $ret = json_decode($txt, true);
        if (!$ret) {
            trace('接口[' . $url . ']返回格式不正確', '升級通知出錯', 'NOTIC', true);
            
            return false;
        }
        
        return $ret;
    }
}
