<?php
// +----------------------------------------------------------------------
// 文件及文件夾處理類
// +----------------------------------------------------------------------

namespace OT;

class File{

	/**
	 * 創建目錄
	 * @param $dir  目錄名
	 * @return boolean true 成功， false 失敗
	 */
	static public function mk_dir($dir){
		$dir = rtrim($dir,'/').'/';
		if(!is_dir($dir))
		{
			if(mkdir($dir, 0700)==false)
			{
				return false;
			}
			return true;
		}
		return true;
	}

	/**
	 * 讀取文件內容
	 * @param $filename  文件名
	 * @return string 文件內容
	 */
	static public function read_file($filename){
		$content = '';
		if(function_exists('file_get_contents'))
		{
			@$content = file_get_contents($filename);
		}
		else
		{
			if(@$fp = fopen($filename, 'r'))
			{
				@$content = fread($fp, filesize($filename));
				@fclose($fp);
			}
		}
		return $content;
	}

	/**
	 * 寫文件
	 * @param $filename  文件名
	 * @param $writetext 文件內容
	 * @param $openmod 	打開方式
	 * @return boolean true 成功, false 失敗
	 */
	static function write_file($filename, $writetext, $openmod='w'){
		if(@$fp = fopen($filename, $openmod))
		{
			flock($fp, 2);
			fwrite($fp, $writetext);
			fclose($fp);
			return true;
		}
		else
		{
			return false;
		}
	}

	/**
	 * 刪除目錄
	 * @param $dirName  	原目錄
	 * @return boolean true 成功, false 失敗
	 */
	static function del_dir($dirName){
		if (!file_exists($dirName))
		{
			return false;
		}

		$dir = opendir($dirName);
		while ($fileName = readdir($dir))
		{
			$file = $dirName . '/' . $fileName;
			if ($fileName != '.' && $fileName != '..')
			{
				if (is_dir($file))
				{
					self::del_dir($file);
				}
				else
				{
					unlink($file);
				}
			}
		}
		closedir($dir);
		return rmdir($dirName);
	}

	/**
	 * 複製目錄
	 * @param $surDir  	原目錄
	 * @param $toDir  	目標目錄
	 * @return boolean true 成功, false 失敗
	 */
	static function copy_dir($surDir,$toDir){
		$surDir = rtrim($surDir,'/').'/';
		$toDir = rtrim($toDir,'/').'/';
		if (!file_exists($surDir))
		{
			return  false;
		}

		if (!file_exists($toDir))
		{
			self::mk_dir($toDir);
		}
		$file = opendir($surDir);
		while ($fileName = readdir($file))
		{
			$file1 = $surDir .'/'.$fileName;
			$file2 = $toDir .'/'.$fileName;
			if ($fileName != '.' && $fileName != '..')
			{
				if (is_dir($file1))
				{
					self::copy_dir($file1, $file2);
				}
				else
				{
					copy($file1, $file2);
				}
			}
		}
		closedir($file);
		return true;
	}

	/**
	 * 列出目錄
	 * @param $dir  目錄名
	 * @return 目錄數組。列出文件夾下內容，返回數組 $dirArray['dir']:存文件夾；$dirArray['file']：存文件
	 */
	static function get_dirs($dir){
		$dir = rtrim($dir,'/').'/';
		$dirArray [][] = NULL;
		if (false != ($handle = opendir ( $dir )))
		{
			$i = 0;
			$j = 0;
			while ( false !== ($file = readdir ( $handle )) )
			{
				if (is_dir ( $dir . $file ))
				{ //判斷是否文件夾
					$dirArray ['dir'] [$i] = $file;
					$i ++;
				}
				else
				{
					$dirArray ['file'] [$j] = $file;
					$j ++;
				}
			}
			closedir ($handle);
		}
		return $dirArray;
	}

	/**
	 * 統計文件夾大小
	 * @param $dir  目錄名
	 * @return number 文件夾大小(單位 B)
	 */
	static function get_size($dir){
		$dirlist = opendir($dir);
		$dirsize = 0;
		while (false !==  ($folderorfile = readdir($dirlist)))
		{
			if($folderorfile != "." && $folderorfile != "..")
			{
				if (is_dir("$dir/$folderorfile"))
				{
					$dirsize += self::get_size("$dir/$folderorfile");
				}
				else
				{
					$dirsize += filesize("$dir/$folderorfile");
				}
			}
		}
		closedir($dirlist);
		return $dirsize;
	}

	/**
	 * 檢測是否為空文件夾
	 * @param $dir  目錄名
	 * @return boolean true 空， fasle 不為空
	 */
	static function empty_dir($dir){
		return (($files = @scandir($dir)) && count($files) <= 2);
	}

	/**
	 * 文件緩存與文件讀取
	 * @param $name  文件名
	 * @param $value  文件內容,為空則獲取緩存
	 * @param $path   文件所在目錄,默認是當前應用的DATA目錄
	 * @param $cached  是否緩存結果,默認緩存
	 * @return 返回緩存內容
	 */
	function cache($name, $value='', $path=DATA_PATH,$cached=true){
		static $_cache  = array();
		$filename       = $path . $name . '.php';
		if ('' !== $value) {
			if (is_null($value)) {
				// 刪除緩存
				return false !== strpos($name,'*')?array_map("unlink", glob($filename)):unlink($filename);
			} else {
				// 緩存數據
				$dir            =   dirname($filename);
				// 目錄不存在則創建
				if (!is_dir($dir))
					mkdir($dir,0755,true);
				$_cache[$name]  =   $value;
				return file_put_contents($filename, strip_whitespace("<?php\treturn " . var_export($value, true) . ";?>"));
			}
		}
		if (isset($_cache[$name]) && $cached==true) return $_cache[$name];
		// 獲取緩存數據
		if (is_file($filename)) {
			$value          =   include $filename;
			$_cache[$name]  =   $value;
		} else {
			$value          =   false;
		}
		return $value;
	}

}