<?php
/*---------------------------------------------------------------------------
  小牛OA系統 - 讓工作更輕鬆快樂 

  Copyright (c) 2013 http://oa.niucms.net All rights reserved.                                             

  Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )  

  Author:  jinzhu.yin<smeoa@qq.com>                         

  Support: https://git.oschina.net/smeoa/smeoa               
 -------------------------------------------------------------------------*/
namespace Org\Util;
class Page {
    
    // 分頁欄每頁顯示的頁數
    public $rollPage = 5;

    // 頁數跳轉時要帶的參數
    public $parameter  ;

    // 分頁URL地址
    public $url     =   '';

    // 默認列表每頁顯示行數
    public $listRows = 20;

    // 起始行數
    public $firstRow    ;

    // 分頁總頁面數
    protected $totalPages  ;

    // 總行數
    protected $totalRows  ;

    // 當前頁數
    protected $nowPage    ;

    // 分頁的欄的總頁數
    protected $coolPages   ;

    // 分頁顯示定制
    protected $config  = array('header'=>'條記錄','prev'=>'上一頁','next'=>'下一頁','first'=>'第一頁','last'=>'最後一頁','all'=>'全部','page'=>'分頁','export'=>'導出','theme'=>' %totalRow% %header% %nowPage%/%totalPage% 頁 %upPage% %downPage% %first%  %prePage%  %linkPage%  %nextPage% %end% %allPage% %exportPage%');

    // 默認分頁變量名
    protected $varPage;

    /**
     * 架構函數
     * @access public
     * @param array $totalRows  總的記錄數
     * @param array $listRows  每頁顯示記錄數
     * @param array $parameter  分頁跳轉的參數
     */

    public function __construct($totalRows,$listRows='',$parameter=''){
        $this->totalRows    =   $totalRows;
        $this->parameter    =   $parameter;
        $this->varPage      =   C('VAR_PAGE') ? C('VAR_PAGE') : 'p' ;
        if(!empty($listRows)) {
            $this->listRows =   intval($listRows);
        }
        $this->totalPages   =   ceil($this->totalRows/$this->listRows);     //總頁數
        $this->coolPages    =   ceil($this->totalPages/$this->rollPage);
        $this->nowPage      =   !empty($_POST[$this->varPage])?intval($_POST[$this->varPage]):1;
        if($this->nowPage<1){
            $this->nowPage  =   1;
        }elseif(!empty($this->totalPages) && $this->nowPage>$this->totalPages) {
            $this->nowPage  =   $this->totalPages;
        }
        $this->firstRow     =   $this->listRows*($this->nowPage-1);
    }

    public function setConfig($name,$value) {
        if(isset($this->config[$name])) {
            $this->config[$name]    =   $value;
        }
    }

    /**
     * 分頁顯示輸出
     * @access public
     */
    public function show() {
        if(0 == $this->totalRows) return '';
        $p              =   $this->varPage;
        $nowCoolPage    =   ceil($this->nowPage/$this->rollPage);

        // 分析分頁參數
        if($this->url){
            $depr     =   C('URL_PATHINFO_DEPR');
            $url        =   rtrim(U('/'.$this->url,'',false),$depr).$depr.'__PAGE__';
        }else{
			
			$request = array_filter(array_keys(array_filter($_REQUEST)), "filter_search_field");
			if(!empty($request)){
				$request=array_combine($request,$request);
				$parameter=array_intersect_key($_REQUEST,$request);
			}
			
			$html=" <form id=\"page_search\" method=\"post\">%input%%pageStr%</form>";
			$input="<input type=\"hidden\" name=\"$p\" >";
			$input.="<input type=\"hidden\" name=\"list_rows\" value=\"\">";
			$input.="<input type=\"hidden\" name=\"mode\" value=\"\">";
			if(!empty($request)){
				foreach($parameter as $key=>$val){
					if(is_string($val)){
						$input.="<input type=\"hidden\" name=\"$key\" value=\"$val\">";
					}elseif(is_array($val)){
						if($val[0]=="like"){
							$input.="<input type=\"hidden\" name=\"$key\" value=\"$val[1]\">";
						}else{
							$input.="<input type=\"hidden\" name=\"$key\" value=\"$val[1]\">";
						}
					}
				}
			}
			$html=str_replace("%input%",$input,$html);  
        }

        //上下翻頁字符串
        $upRow          =   $this->nowPage-1;
        $downRow        =   $this->nowPage+1;
        if ($upRow>0){
			$upPage="<input type=\"button\" value=\"".$this->config['prev']."\" onclick=\"this.form.mode.value='';this.form.$p.value=$upRow;this.form.submit();\">";
        }else{
            $upPage     =   '';
        }

        if ($downRow <= $this->totalPages){
			$downPage="<input type=\"button\" value=\"".$this->config['next']."\" onclick=\"this.form.mode.value='';this.form.$p.value=$downRow;this.form.submit();\">";           
        }else{
            $downPage   =   '';
        }
        // << < > >>
        if($nowCoolPage == 1){
            $theFirst   =   '';
            $prePage    =   '';
        }else{
            $preRow     =   $this->nowPage-$this->rollPage;
			$prePage="<input type=\"button\" value=\"上".$this->rollPage."頁\" onclick=\"this.form.$p.value=$preRow;this.form.submit();\">"; 
			$theFirst="<input type=\"button\" value=\"".$this->config['first']."\" onclick=\"this.form.mode.value='';this.form.$p.value=1;this.form.submit();\">";	
        }
        if($nowCoolPage == $this->coolPages){
            $nextPage   =   '';
            $theEnd     =   '';
        }else{
            $nextRow    =   $this->nowPage+$this->rollPage;
            $theEndRow  =   $this->totalPages;
			$nextPage="<input type=\"button\" value=\"下".$this->rollPage."頁\" onclick=\"this.form.$p.value=$nextRow;this.form.submit();\">"; 
			$theEnd="<input type=\"button\" value=\"".$this->config['last']."\" onclick=\"this.form.mode.value='';this.form.$p.value=$theEndRow;this.form.submit();\">"; 
        }
        // 1 2 3 4 5
        $linkPage = "";
        for($i=1;$i<=$this->rollPage;$i++){
            $page       =   ($nowCoolPage-1)*$this->rollPage+$i;
            if($page!=$this->nowPage){
                if($page<=$this->totalPages){
				$linkPage.="<input type=\"button\" value=\"$page\" onclick=\"this.form.mode.value='';this.form.$p.value=$page;this.form.submit();\">";                     
                }else{
                    break;
                }
            }else{
                if($this->totalPages != 1){
					$linkPage.="<input class='current' type=\"button\" value=\"$page\">";                     
                }
            }
        }
		if($this->totalRows==$this->listRows){
			$allPage="<input type=\"button\" value=\"".$this->config['page']."\" onclick=\"this.form.mode.value='';this.form.$p.value=1;this.form.list_rows.value='';this.form.submit();\">";
		}else{
			$allPage="<input type=\"button\" value=\"".$this->config['all']."\" onclick=\"this.form.mode.value='';this.form.$p.value=1;this.form.list_rows.value=".$this->totalRows.";this.form.submit();\">";	
		}	
		if(method_exists(A(MODULE_NAME),'_'.ACTION_NAME.'_export')){			
			$exportPage="<input type=\"button\" value=\"".$this->config['export']."\" onclick=\"this.form.mode.value='export';this.form.list_rows.value=".$this->totalRows.";this.form.submit();\">";			
		}
		 		
        $pageStr     =   str_replace(array('%header%','%nowPage%','%totalRow%','%totalPage%','%upPage%','%downPage%','%first%','%prePage%','%linkPage%','%nextPage%','%end%','%allPage%','%exportPage%'),
            array($this->config['header'],$this->nowPage,$this->totalRows,$this->totalPages,$upPage,$downPage,$theFirst,$prePage,$linkPage,$nextPage,$theEnd,$allPage,$exportPage),$this->config['theme']);
		$pageStr=str_replace("%pageStr%",$pageStr,$html);
        return $pageStr;
    }
}