<?php
// +----------------------------------------------------------------------
// | ThinkPHP [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2009 http://thinkphp.cn All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: liu21st <liu21st@gmail.com>
// +----------------------------------------------------------------------
namespace Org\Util;

/**
 * Stack實現類
 * @category   ORG
 * @package  ORG
 * @subpackage  Util
 * @author    liu21st <liu21st@gmail.com>
 */
class Stack extends ArrayList {

    /**
     * 架構函數
     * @access public
     * @param array $values  初始化數組元素
     */
    public function __construct($values = array()) {
        parent::__construct($values);
    }

    /**
     * 將堆棧的內部指針指向第一個單元
     * @access public
     * @return mixed
     */
    public function peek() {
        return reset($this->toArray());
    }

    /**
     * 元素進棧
     * @access public
     * @param mixed $value
     * @return mixed
     */
    public function push($value) {
        $this->add($value);
        return $value;
    }

}
