<?php
// +----------------------------------------------------------------------
// | ThinkPHP [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2006-2014 http://thinkphp.cn All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: liu21st <liu21st@gmail.com>
// +----------------------------------------------------------------------
namespace Think\Cache\Driver;
use Think\Cache;
defined('THINK_PATH') or exit();
/**
 * Apachenote緩存驅動
 */
class Apachenote extends Cache {

    /**
     * 架構函數
     * @param array $options 緩存參數
     * @access public
     */
    public function __construct($options=array()) {
        if(!empty($options)) {
            $this->options =  $options;
        }
        if(empty($options)) {
            $options = array (
                'host'        =>  '127.0.0.1',
                'port'        =>  1042,
                'timeout'     =>  10,
            );
        }
        $this->options  =   $options;
        $this->options['prefix']    =   isset($options['prefix'])?  $options['prefix']  :   C('DATA_CACHE_PREFIX');
        $this->options['length']    =   isset($options['length'])?  $options['length']  :   0;
        $this->handler = null;
        $this->open();
    }

    /**
     * 讀取緩存
     * @access public
     * @param string $name 緩存變量名
     * @return mixed
     */
     public function get($name) {
         $this->open();
         $name  =   $this->options['prefix'].$name;
         $s     =   'F' . pack('N', strlen($name)) . $name;
         fwrite($this->handler, $s);

         for ($data = ''; !feof($this->handler);) {
             $data .= fread($this->handler, 4096);
         }
        N('cache_read',1);
         $this->close();
         return $data === '' ? '' : unserialize($data);
     }

    /**
     * 寫入緩存
     * @access public
     * @param string $name 緩存變量名
     * @param mixed $value  存儲數據
     * @return boolean
     */
    public function set($name, $value) {
        N('cache_write',1);
        $this->open();
        $value  =   serialize($value);
        $name   =   $this->options['prefix'].$name;        
        $s      =   'S' . pack('NN', strlen($name), strlen($value)) . $name . $value;

        fwrite($this->handler, $s);
        $ret = fgets($this->handler);
        $this->close();
        if($ret === "OK\n") {
            if($this->options['length']>0) {
                // 記錄緩存隊列
                $this->queue($name);
            }
            return true;
        }
        return false;
    }

    /**
     * 刪除緩存
     * @access public
     * @param string $name 緩存變量名
     * @return boolean
     */
     public function rm($name) {
        $this->open();
        $name   =   $this->options['prefix'].$name;         
        $s      =   'D' . pack('N', strlen($name)) . $name;
        fwrite($this->handler, $s);
        $ret    = fgets($this->handler);
        $this->close();
        return $ret === "OK\n";
     }

    /**
     * 關閉緩存
     * @access private
     */
     private function close() {
         fclose($this->handler);
         $this->handler = false;
     }

    /**
     * 打開緩存
     * @access private
     */
     private function open() {
         if (!is_resource($this->handler)) {
             $this->handler = fsockopen($this->options['host'], $this->options['port'], $_, $_, $this->options['timeout']);
         }
     }

}