<?php
// +----------------------------------------------------------------------
// | ThinkPHP [ WE CAN DO IT JUST THINK ]
// +----------------------------------------------------------------------
// | Copyright (c) 2006-2014 http://thinkphp.cn All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: liu21st <liu21st@gmail.com>
// +----------------------------------------------------------------------
namespace Think\Cache\Driver;
use Think\Cache;
defined('THINK_PATH') or exit();
/**
 * Wincache緩存驅動
 */
class Wincache extends Cache {

    /**
     * 架構函數
     * @param array $options 緩存參數
     * @access public
     */
    public function __construct($options=array()) {
        if ( !function_exists('wincache_ucache_info') ) {
            E(L('_NOT_SUPPORT_').':WinCache');
        }
        $this->options['expire']    =   isset($options['expire'])?  $options['expire']  :   C('DATA_CACHE_TIME');
        $this->options['prefix']    =   isset($options['prefix'])?  $options['prefix']  :   C('DATA_CACHE_PREFIX');
        $this->options['length']    =   isset($options['length'])?  $options['length']  :   0;
    }

    /**
     * 讀取緩存
     * @access public
     * @param string $name 緩存變量名
     * @return mixed
     */
    public function get($name) {
        N('cache_read',1);
        $name   =   $this->options['prefix'].$name;
        return wincache_ucache_exists($name)? wincache_ucache_get($name) : false;
    }

    /**
     * 寫入緩存
     * @access public
     * @param string $name 緩存變量名
     * @param mixed $value  存儲數據
     * @param integer $expire  有效時間（秒）
     * @return boolean
     */
    public function set($name, $value,$expire=null) {
        N('cache_write',1);
        if(is_null($expire)) {
            $expire  =  $this->options['expire'];
        }
        $name   =   $this->options['prefix'].$name;
        if(wincache_ucache_set($name, $value, $expire)) {
            if($this->options['length']>0) {
                // 記錄緩存隊列
                $this->queue($name);
            }
            return true;
        }
        return false;
    }

    /**
     * 刪除緩存
     * @access public
     * @param string $name 緩存變量名
     * @return boolean
     */
    public function rm($name) {
        return wincache_ucache_delete($this->options['prefix'].$name);
    }

    /**
     * 清除緩存
     * @access public
     * @return boolean
     */
    public function clear() {
        return wincache_ucache_clear();
    }    

}
