<?php
// +----------------------------------------------------------------------
// | ThinkPHP [ WE CAN DO IT JUST THINK ]
// +----------------------------------------------------------------------
// | Copyright (c) 2006-2014 http://thinkphp.cn All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: liu21st <liu21st@gmail.com>
// +----------------------------------------------------------------------
namespace Think\Cache\Driver;
use Think\Cache;
defined('THINK_PATH') or exit();
/**
 * Xcache緩存驅動
 */
class Xcache extends Cache {

    /**
     * 架構函數
     * @param array $options 緩存參數
     * @access public
     */
    public function __construct($options=array()) {
        if ( !function_exists('xcache_info') ) {
            E(L('_NOT_SUPPORT_').':Xcache');
        }
        $this->options['expire']    =   isset($options['expire'])?$options['expire']:C('DATA_CACHE_TIME');
        $this->options['prefix']    =   isset($options['prefix'])?$options['prefix']:C('DATA_CACHE_PREFIX');
        $this->options['length']    =   isset($options['length'])?$options['length']:0;
    }

    /**
     * 讀取緩存
     * @access public
     * @param string $name 緩存變量名
     * @return mixed
     */
    public function get($name) {
        N('cache_read',1);
        $name   =   $this->options['prefix'].$name;
        if (xcache_isset($name)) {
            return xcache_get($name);
        }
        return false;
    }

    /**
     * 寫入緩存
     * @access public
     * @param string $name 緩存變量名
     * @param mixed $value  存儲數據
     * @param integer $expire  有效時間（秒）
     * @return boolean
     */
    public function set($name, $value,$expire=null) {
        N('cache_write',1);
        if(is_null($expire)) {
            $expire = $this->options['expire'] ;
        }
        $name   =   $this->options['prefix'].$name;
        if(xcache_set($name, $value, $expire)) {
            if($this->options['length']>0) {
                // 記錄緩存隊列
                $this->queue($name);
            }
            return true;
        }
        return false;
    }

    /**
     * 刪除緩存
     * @access public
     * @param string $name 緩存變量名
     * @return boolean
     */
    public function rm($name) {
        return xcache_unset($this->options['prefix'].$name);
    }

    /**
     * 清除緩存
     * @access public
     * @return boolean
     */
    public function clear() {
        return xcache_clear_cache(1, -1);
    }
}
