<?php
// +----------------------------------------------------------------------
// | ThinkPHP [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2006-2014 http://thinkphp.cn All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: liu21st <liu21st@gmail.com>
// +----------------------------------------------------------------------
namespace Think\Controller;
/**
 * ThinkPHP Hprose控制器類
 */
class HproseController {

    protected $allowMethodList  =   '';
    protected $crossDomain      =   false;
    protected $P3P              =   false;
    protected $get              =   true;
    protected $debug            =   false;

   /**
     * 架構函數
     * @access public
     */
    public function __construct() {
        //控制器初始化
        if(method_exists($this,'_initialize'))
            $this->_initialize();
        //導入類庫
        Vendor('Hprose.HproseHttpServer');
        //實例化HproseHttpServer
        $server     =   new \HproseHttpServer();
        if($this->allowMethodList){
            $methods    =   $this->allowMethodList;
        }else{
            $methods    =   get_class_methods($this);
            $methods    =   array_diff($methods,array('__construct','__call','_initialize'));   
        }
        $server->addMethods($methods,$this);
        if(APP_DEBUG || $this->debug ) {
            $server->setDebugEnabled(true);
        }
        // Hprose設置
        $server->setCrossDomainEnabled($this->crossDomain);
        $server->setP3PEnabled($this->P3P);
        $server->setGetEnabled($this->get);
        // 啟動server
        $server->start();
    }

    /**
     * 魔術方法 有不存在的操作的時候執行
     * @access public
     * @param string $method 方法名
     * @param array $args 參數
     * @return mixed
     */
    public function __call($method,$args){}
}
