<?php
// +----------------------------------------------------------------------
// | ThinkPHP [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2006-2014 http://thinkphp.cn All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: liu21st <liu21st@gmail.com>
// +----------------------------------------------------------------------
namespace Think;
/**
 * 日誌處理類
 */
class Log {

    // 日誌級別 從上到下，由低到高
    const EMERG     = 'EMERG';  // 嚴重錯誤: 導致系統崩潰無法使用
    const ALERT     = 'ALERT';  // 警戒性錯誤: 必須被立即修改的錯誤
    const CRIT      = 'CRIT';  // 臨界值錯誤: 超過臨界值的錯誤，例如一天24小時，而輸入的是25小時這樣
    const ERR       = 'ERR';  // 一般錯誤: 一般性錯誤
    const WARN      = 'WARN';  // 警告性錯誤: 需要發出警告的錯誤
    const NOTICE    = 'NOTIC';  // 通知: 程序可以運行但是還不夠完美的錯誤
    const INFO      = 'INFO';  // 信息: 程序輸出信息
    const DEBUG     = 'DEBUG';  // 調試: 調試信息
    const SQL       = 'SQL';  // SQL：SQL語句 注意只在調試模式開啟時有效

    // 日誌信息
    static protected $log       =  array();

    // 日誌存儲
    static protected $storage   =   null;

    // 日誌初始化
    static public function init($config=array()){
        $type   =   isset($config['type'])?$config['type']:'File';
        $class  =   strpos($type,'\\')? $type: 'Think\\Log\\Driver\\'. ucwords(strtolower($type));           
        unset($config['type']);
        self::$storage = new $class($config);
    }

    /**
     * 記錄日誌 並且會過濾未經設置的級別
     * @static
     * @access public
     * @param string $message 日誌信息
     * @param string $level  日誌級別
     * @param boolean $record  是否強制記錄
     * @return void
     */
    static function record($message,$level=self::ERR,$record=false) {
        if($record || false !== strpos(C('LOG_LEVEL'),$level)) {
            self::$log[] =   "{$level}: {$message}\r\n";
        }
    }

    /**
     * 日誌保存
     * @static
     * @access public
     * @param integer $type 日誌記錄方式
     * @param string $destination  寫入目標
     * @return void
     */
    static function save($type='',$destination='') {
        if(empty(self::$log)) return ;

        if(empty($destination))
            $destination = C('LOG_PATH').date('y_m_d').'.log';
        if(!self::$storage){
            $type = $type?:C('LOG_TYPE');
            $class  =   'Think\\Log\\Driver\\'. ucwords($type);
            self::$storage = new $class();            
        }
        $message    =   implode('',self::$log);
        self::$storage->write($message,$destination);
        // 保存後清空日誌緩存
        self::$log = array();
    }

    /**
     * 日誌直接寫入
     * @static
     * @access public
     * @param string $message 日誌信息
     * @param string $level  日誌級別
     * @param integer $type 日誌記錄方式
     * @param string $destination  寫入目標
     * @return void
     */
    static function write($message,$level=self::ERR,$type='',$destination='') {
        if(!self::$storage){
            $type = $type?:C('LOG_TYPE');
            $class  =   'Think\\Log\\Driver\\'. ucwords($type);
            self::$storage = new $class();            
        }
        if(empty($destination))
            $destination = C('LOG_PATH').date('y_m_d').'.log';        
        self::$storage->write("{$level}: {$message}", $destination);
    }
}