<?php
// +----------------------------------------------------------------------
// | ThinkPHP [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2006-2014 http://thinkphp.cn All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: liu21st <liu21st@gmail.com>
// +----------------------------------------------------------------------
namespace Think\Model;
use Think\Model;
/**
 * ThinkPHP關聯模型擴展 
 */
class RelationModel extends Model {

    const   HAS_ONE     =   1;
    const   BELONGS_TO  =   2;
    const   HAS_MANY    =   3;
    const   MANY_TO_MANY=   4;

    // 關聯定義
    protected    $_link = array();

    /**
     * 動態方法實現
     * @access public
     * @param string $method 方法名稱
     * @param array $args 調用參數
     * @return mixed
     */
    public function __call($method,$args) {
        if(strtolower(substr($method,0,8))=='relation'){
            $type    =   strtoupper(substr($method,8));
            if(in_array($type,array('ADD','SAVE','DEL'),true)) {
                array_unshift($args,$type);
                return call_user_func_array(array(&$this, 'opRelation'), $args);
            }
        }else{
            return parent::__call($method,$args);
        }
    }

    /**
     * 得到關聯的數據表名
     * @access public
     * @return string
     */
    public function getRelationTableName($relation) {
        $relationTable  = !empty($this->tablePrefix) ? $this->tablePrefix : '';
        $relationTable .= $this->tableName?$this->tableName:$this->name;
        $relationTable .= '_'.$relation->getModelName();
        return strtolower($relationTable);
    }

    // 查詢成功後的回調方法
    protected function _after_find(&$result,$options) {
        // 獲取關聯數據 並附加到結果中
        if(!empty($options['link']))
            $this->getRelation($result,$options['link']);
    }

    // 查詢數據集成功後的回調方法
    protected function _after_select(&$result,$options) {
        // 獲取關聯數據 並附加到結果中
        if(!empty($options['link']))
            $this->getRelations($result,$options['link']);
    }

    // 寫入成功後的回調方法
    protected function _after_insert($data,$options) {
        // 關聯寫入
        if(!empty($options['link']))
            $this->opRelation('ADD',$data,$options['link']);
    }

    // 更新成功後的回調方法
    protected function _after_update($data,$options) {
        // 關聯更新
        if(!empty($options['link']))
            $this->opRelation('SAVE',$data,$options['link']);
    }

    // 刪除成功後的回調方法
    protected function _after_delete($data,$options) {
        // 關聯刪除
        if(!empty($options['link']))
            $this->opRelation('DEL',$data,$options['link']);
    }

    /**
     * 對保存到數據庫的數據進行處理
     * @access protected
     * @param mixed $data 要操作的數據
     * @return boolean
     */
     protected function _facade($data) {
        $this->_before_write($data);
        return $data;
     }

    /**
     * 獲取返回數據集的關聯記錄
     * @access protected
     * @param array $resultSet  返回數據
     * @param string|array $name  關聯名稱
     * @return array
     */
    protected function getRelations(&$resultSet,$name='') {
        // 獲取記錄集的主鍵列表
        foreach($resultSet as $key=>$val) {
            $val  = $this->getRelation($val,$name);
            $resultSet[$key]    =   $val;
        }
        return $resultSet;
    }

    /**
     * 獲取返回數據的關聯記錄
     * @access protected
     * @param mixed $result  返回數據
     * @param string|array $name  關聯名稱
     * @param boolean $return 是否返回關聯數據本身
     * @return array
     */
    protected function getRelation(&$result,$name='',$return=false) {
        if(!empty($this->_link)) {
            foreach($this->_link as $key=>$val) {
                    $mappingName =  !empty($val['mapping_name'])?$val['mapping_name']:$key; // 映射名稱
                    if(empty($name) || true === $name || $mappingName == $name || (is_array($name) && in_array($mappingName,$name))) {
                        $mappingType = !empty($val['mapping_type'])?$val['mapping_type']:$val;  //  關聯類型
                        $mappingClass  = !empty($val['class_name'])?$val['class_name']:$key;            //  關聯類名
                        $mappingFields = !empty($val['mapping_fields'])?$val['mapping_fields']:'*';     // 映射字段
                        $mappingCondition = !empty($val['condition'])?$val['condition']:'1=1';          // 關聯條件
                        $mappingKey =!empty($val['mapping_key'])? $val['mapping_key'] : $this->getPk(); // 關聯鍵名
                        if(strtoupper($mappingClass)==strtoupper($this->name)) {
                            // 自引用關聯 獲取父鍵名
                            $mappingFk   =   !empty($val['parent_key'])? $val['parent_key'] : 'parent_id';
                        }else{
                            $mappingFk   =   !empty($val['foreign_key'])?$val['foreign_key']:strtolower($this->name).'_id';     //  關聯外鍵
                        }
                        // 獲取關聯模型對像
                        $model = D($mappingClass);
                        switch($mappingType) {
                            case self::HAS_ONE:
                                $pk   =  $result[$mappingKey];
                                $mappingCondition .= " AND {$mappingFk}='{$pk}'";
                                $relationData   =  $model->where($mappingCondition)->field($mappingFields)->find();
                                if (!empty($val['relation_deep'])){
                                    $model->getRelation($relationData,$val['relation_deep']);
                                }                                
                                break;
                            case self::BELONGS_TO:
                                if(strtoupper($mappingClass)==strtoupper($this->name)) {
                                    // 自引用關聯 獲取父鍵名
                                    $mappingFk   =   !empty($val['parent_key'])? $val['parent_key'] : 'parent_id';
                                }else{
                                    $mappingFk   =   !empty($val['foreign_key'])?$val['foreign_key']:strtolower($model->getModelName()).'_id';     //  關聯外鍵
                                }
                                $fk   =  $result[$mappingFk];
                                $mappingCondition .= " AND {$model->getPk()}='{$fk}'";
                                $relationData   =  $model->where($mappingCondition)->field($mappingFields)->find();
                                if (!empty($val['relation_deep'])){
                                    $model->getRelation($relationData,$val['relation_deep']);
                                }                                
                                break;
                            case self::HAS_MANY:
                                $pk   =  $result[$mappingKey];
                                $mappingCondition .= " AND {$mappingFk}='{$pk}'";
                                $mappingOrder =  !empty($val['mapping_order'])?$val['mapping_order']:'';
                                $mappingLimit =  !empty($val['mapping_limit'])?$val['mapping_limit']:'';
                                // 延時獲取關聯記錄
                                $relationData   =  $model->where($mappingCondition)->field($mappingFields)->order($mappingOrder)->limit($mappingLimit)->select();
                                if (!empty($val['relation_deep'])){
                                    foreach($relationData as $key=>$data){                                    
                                        $model->getRelation($data,$val['relation_deep']);
                                        $relationData[$key]     =   $data;
                                    }                                      
                                }
                                break;
                            case self::MANY_TO_MANY:
                                $pk     =   $result[$mappingKey];
                                $prefix =   $this->tablePrefix;
                                $mappingCondition = " {$mappingFk}='{$pk}'";
                                $mappingOrder =  $val['mapping_order'];
                                $mappingLimit =  $val['mapping_limit'];
                                $mappingRelationFk = $val['relation_foreign_key']?$val['relation_foreign_key']:$model->getModelName().'_id';
                                if(isset($val['relation_table'])){
                                    $mappingRelationTable   =   preg_replace_callback("/__([A-Z_-]+)__/sU", function($match) use($prefix){ return $prefix.strtolower($match[1]);}, $val['relation_table']);
                                }else{
                                    $mappingRelationTable   =   $this->getRelationTableName($model);
                                }
                                $sql = "SELECT b.{$mappingFields} FROM {$mappingRelationTable} AS a, ".$model->getTableName()." AS b WHERE a.{$mappingRelationFk} = b.{$model->getPk()} AND a.{$mappingCondition}";
                                if(!empty($val['condition'])) {
                                    $sql   .= ' AND '.$val['condition'];
                                }
                                if(!empty($mappingOrder)) {
                                    $sql .= ' ORDER BY '.$mappingOrder;
                                }
                                if(!empty($mappingLimit)) {
                                    $sql .= ' LIMIT '.$mappingLimit;
                                }
                                $relationData   =   $this->query($sql);
                                if (!empty($val['relation_deep'])){
                                    foreach($relationData as $key=>$data){                                    
                                        $model->getRelation($data,$val['relation_deep']);
                                        $relationData[$key]     =   $data;
                                    }                                      
                                }                                
                                break;
                        }
                        if(!$return){
                            if(isset($val['as_fields']) && in_array($mappingType,array(self::HAS_ONE,self::BELONGS_TO)) ) {
                                // 支持直接把關聯的字段值映射成數據對像中的某個字段
                                // 僅僅支持HAS_ONE BELONGS_TO
                                $fields =   explode(',',$val['as_fields']);
                                foreach ($fields as $field){
                                    if(strpos($field,':')) {
                                        list($relationName,$nick) = explode(':',$field);
                                        $result[$nick]  =  $relationData[$relationName];
                                    }else{
                                        $result[$field]  =  $relationData[$field];
                                    }
                                }
                            }else{
                                $result[$mappingName] = $relationData;
                            }
                            unset($relationData);
                        }else{
                            return $relationData;
                        }
                    }
            }
        }
        return $result;
    }

    /**
     * 操作關聯數據
     * @access protected
     * @param string $opType  操作方式 ADD SAVE DEL
     * @param mixed $data  數據對像
     * @param string $name 關聯名稱
     * @return mixed
     */
    protected function opRelation($opType,$data='',$name='') {
        $result =   false;
        if(empty($data) && !empty($this->data)){
            $data = $this->data;
        }elseif(!is_array($data)){
            // 數據無效返回
            return false;
        }
        if(!empty($this->_link)) {
            // 遍歷關聯定義
            foreach($this->_link as $key=>$val) {
                    // 操作制定關聯類型
                    $mappingName =  $val['mapping_name']?$val['mapping_name']:$key; // 映射名稱
                    if(empty($name) || true === $name || $mappingName == $name || (is_array($name) && in_array($mappingName,$name)) ) {
                        // 操作制定的關聯
                        $mappingType = !empty($val['mapping_type'])?$val['mapping_type']:$val;  //  關聯類型
                        $mappingClass  = !empty($val['class_name'])?$val['class_name']:$key;            //  關聯類名
                        $mappingKey =!empty($val['mapping_key'])? $val['mapping_key'] : $this->getPk(); // 關聯鍵名
                        // 當前數據對像主鍵值
                        $pk =   $data[$mappingKey];
                        if(strtoupper($mappingClass)==strtoupper($this->name)) {
                            // 自引用關聯 獲取父鍵名
                            $mappingFk   =   !empty($val['parent_key'])? $val['parent_key'] : 'parent_id';
                        }else{
                            $mappingFk   =   !empty($val['foreign_key'])?$val['foreign_key']:strtolower($this->name).'_id';     //  關聯外鍵
                        }
                        if(!empty($val['condition'])) {
                            $mappingCondition   =   $val['condition'];
                        }else{
                            $mappingCondition               =   array();
                            $mappingCondition[$mappingFk]   =   $pk;
                        }
                        // 獲取關聯model對像
                        $model = D($mappingClass);
                        $mappingData    =   isset($data[$mappingName])?$data[$mappingName]:false;
                        if(!empty($mappingData) || $opType == 'DEL') {
                            switch($mappingType) {
                                case self::HAS_ONE:
                                    switch (strtoupper($opType)){
                                        case 'ADD': // 增加關聯數據
                                        $mappingData[$mappingFk]    =   $pk;
                                        $result   =  $model->add($mappingData);
                                        break;
                                        case 'SAVE':    // 更新關聯數據
                                        $result   =  $model->where($mappingCondition)->save($mappingData);
                                        break;
                                        case 'DEL': // 根據外鍵刪除關聯數據
                                        $result   =  $model->where($mappingCondition)->delete();
                                        break;
                                    }
                                    break;
                                case self::BELONGS_TO:
                                    break;
                                case self::HAS_MANY:
                                    switch (strtoupper($opType)){
                                        case 'ADD'   :  // 增加關聯數據
                                        $model->startTrans();
                                        foreach ($mappingData as $val){
                                            $val[$mappingFk]    =   $pk;
                                            $result   =  $model->add($val);
                                        }
                                        $model->commit();
                                        break;
                                        case 'SAVE' :   // 更新關聯數據
                                        $model->startTrans();
                                        $pk   =  $model->getPk();
                                        foreach ($mappingData as $vo){
                                            if(isset($vo[$pk])) {// 更新數據
                                                $mappingCondition   =  "$pk ={$vo[$pk]}";
                                                $result   =  $model->where($mappingCondition)->save($vo);
                                            }else{ // 新增數據
                                                $vo[$mappingFk] =  $data[$mappingKey];
                                                $result   =  $model->add($vo);
                                            }
                                        }
                                        $model->commit();
                                        break;
                                        case 'DEL' :    // 刪除關聯數據
                                        $result   =  $model->where($mappingCondition)->delete();
                                        break;
                                    }
                                    break;
                                case self::MANY_TO_MANY:
                                    $mappingRelationFk = $val['relation_foreign_key']?$val['relation_foreign_key']:$model->getModelName().'_id';// 關聯
                                    $prefix =   $this->tablePrefix;
                                    if(isset($val['relation_table'])){
                                        $mappingRelationTable   =   preg_replace_callback("/__([A-Z_-]+)__/sU", function($match) use($prefix){ return $prefix.strtolower($match[1]);}, $val['relation_table']);
                                    }else{
                                        $mappingRelationTable   =   $this->getRelationTableName($model);
                                    }                                    
                                    if(is_array($mappingData)) {
                                        $ids   = array();
                                        foreach ($mappingData as $vo)
                                            $ids[]   =   $vo[$mappingKey];
                                        $relationId =   implode(',',$ids);
                                    }
                                    switch (strtoupper($opType)){
                                        case 'ADD': // 增加關聯數據
                                            if(isset($relationId)) {
                                                $this->startTrans();
                                                // 插入關聯表數據
                                                $sql  = 'INSERT INTO '.$mappingRelationTable.' ('.$mappingFk.','.$mappingRelationFk.') SELECT a.'.$this->getPk().',b.'.$model->getPk().' FROM '.$this->getTableName().' AS a ,'.$model->getTableName()." AS b where a.".$this->getPk().' ='. $pk.' AND  b.'.$model->getPk().' IN ('.$relationId.") ";
                                                $result =   $model->execute($sql);
                                                if(false !== $result)
                                                    // 提交事務
                                                    $this->commit();
                                                else
                                                    // 事務回滾
                                                    $this->rollback();
                                            }
                                            break;                                        
                                        case 'SAVE':    // 更新關聯數據
                                            if(isset($relationId)) {
                                                $this->startTrans();
                                                // 刪除關聯表數據
                                                $this->table($mappingRelationTable)->where($mappingCondition)->delete();
                                                // 插入關聯表數據
                                                $sql  = 'INSERT INTO '.$mappingRelationTable.' ('.$mappingFk.','.$mappingRelationFk.') SELECT a.'.$this->getPk().',b.'.$model->getPk().' FROM '.$this->getTableName().' AS a ,'.$model->getTableName()." AS b where a.".$this->getPk().' ='. $pk.' AND  b.'.$model->getPk().' IN ('.$relationId.") ";
                                                $result =   $model->execute($sql);
                                                if(false !== $result)
                                                    // 提交事務
                                                    $this->commit();
                                                else
                                                    // 事務回滾
                                                    $this->rollback();
                                            }
                                            break;
                                        case 'DEL': // 根據外鍵刪除中間表關聯數據
                                            $result =   $this->table($mappingRelationTable)->where($mappingCondition)->delete();
                                            break;
                                    }
                                    break;
                            }
                            if (!empty($val['relation_deep'])){
                                $model->opRelation($opType,$mappingData,$val['relation_deep']);
                            }                               
                    }
                }
            }
        }
        return $result;
    }

    /**
     * 進行關聯查詢
     * @access public
     * @param mixed $name 關聯名稱
     * @return Model
     */
    public function relation($name) {
        $this->options['link']  =   $name;
        return $this;
    }

    /**
     * 關聯數據獲取 僅用於查詢後
     * @access public
     * @param string $name 關聯名稱
     * @return array
     */
    public function relationGet($name) {
        if(empty($this->data))
            return false;
        return $this->getRelation($this->data,$name,true);
    }
}