<?php
// +----------------------------------------------------------------------
// | ThinkPHP [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2006-2014 http://thinkphp.cn All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: liu21st <liu21st@gmail.com>
// +----------------------------------------------------------------------
namespace Think\Model;
use Think\Model;
/**
 * ThinkPHP視圖模型擴展 
 */
class ViewModel extends Model {

    protected $viewFields = array();

    /**
     * 自動檢測數據表信息
     * @access protected
     * @return void
     */
    protected function _checkTableInfo() {}

    /**
     * 得到完整的數據表名
     * @access public
     * @return string
     */
    public function getTableName() {
        if(empty($this->trueTableName)) {
            $tableName = '';
            foreach ($this->viewFields as $key=>$view){
                // 獲取數據表名稱
                if(isset($view['_table'])) { // 2011/10/17 添加實際表名定義支持 可以實現同一個表的視圖
                    $tableName .=   $view['_table'];
                    $prefix     =   $this->tablePrefix;
                    $tableName  =   preg_replace_callback("/__([A-Z_-]+)__/sU", function($match) use($prefix){ return $prefix.strtolower($match[1]);}, $tableName);
                }else{
                    $class  =   $key.'Model';
                    $Model  =  class_exists($class)?new $class():M($key);
                    $tableName .= $Model->getTableName();
                }
                // 表別名定義
                $tableName .= !empty($view['_as'])?' '.$view['_as']:' '.$key;
                // 支持ON 條件定義
                $tableName .= !empty($view['_on'])?' ON '.$view['_on']:'';
                // 指定JOIN類型 例如 RIGHT INNER LEFT 下一個表有效
                $type = !empty($view['_type'])?$view['_type']:'';
                $tableName   .= ' '.strtoupper($type).' JOIN ';
                $len  =  strlen($type.'_JOIN ');
            }
            $tableName = substr($tableName,0,-$len);
            $this->trueTableName    =   $tableName;
        }
        return $this->trueTableName;
    }

    /**
     * 表達式過濾方法
     * @access protected
     * @param string $options 表達式
     * @return void
     */
    protected function _options_filter(&$options) {
        if(isset($options['field']))
            $options['field'] = $this->checkFields($options['field']);
        else
            $options['field'] = $this->checkFields();
        if(isset($options['group']))
            $options['group']  =  $this->checkGroup($options['group']);
        if(isset($options['where']))
            $options['where']  =  $this->checkCondition($options['where']);
        if(isset($options['order']))
            $options['order']  =  $this->checkOrder($options['order']);
    }

    /**
     * 檢查是否定義了所有字段
     * @access protected
     * @param string $name 模型名稱
     * @param array $fields 字段數組
     * @return array
     */
    private function _checkFields($name,$fields) {
        if(false !== $pos = array_search('*',$fields)) {// 定義所有字段
            $fields  =  array_merge($fields,M($name)->getDbFields());
            unset($fields[$pos]);
        }
        return $fields;
    }

    /**
     * 檢查條件中的視圖字段
     * @access protected
     * @param mixed $data 條件表達式
     * @return array
     */
    protected function checkCondition($where) {
        if(is_array($where)) {
            $view   =   array();
            // 檢查視圖字段
            foreach ($this->viewFields as $key=>$val){
                $k = isset($val['_as'])?$val['_as']:$key;
                $val  =  $this->_checkFields($key,$val);
                foreach ($where as $name=>$value){
                    if(false !== $field = array_search($name,$val,true)) {
                        // 存在視圖字段
                        $_key   =   is_numeric($field)?    $k.'.'.$name   :   $k.'.'.$field;
                        $view[$_key]    =   $value;
                        unset($where[$name]);
                    }
                }
            }
            $where    =   array_merge($where,$view);
         }
        return $where;
    }

    /**
     * 檢查Order表達式中的視圖字段
     * @access protected
     * @param string $order 字段
     * @return string
     */
    protected function checkOrder($order='') {
         if(is_string($order) && !empty($order)) {
            $orders = explode(',',$order);
            $_order = array();
            foreach ($orders as $order){
                $array = explode(' ',trim($order));
                $field   =   $array[0];
                $sort   =   isset($array[1])?$array[1]:'ASC';
                // 解析成視圖字段
                foreach ($this->viewFields as $name=>$val){
                    $k = isset($val['_as'])?$val['_as']:$name;
                    $val  =  $this->_checkFields($name,$val);
                    if(false !== $_field = array_search($field,$val,true)) {
                        // 存在視圖字段
                        $field     =  is_numeric($_field)?$k.'.'.$field:$k.'.'.$_field;
                        break;
                    }
                }
                $_order[] = $field.' '.$sort;
            }
            $order = implode(',',$_order);
         }
        return $order;
    }

    /**
     * 檢查Group表達式中的視圖字段
     * @access protected
     * @param string $group 字段
     * @return string
     */
    protected function checkGroup($group='') {
         if(!empty($group)) {
            $groups = explode(',',$group);
            $_group = array();
            foreach ($groups as $field){
                // 解析成視圖字段
                foreach ($this->viewFields as $name=>$val){
                    $k = isset($val['_as'])?$val['_as']:$name;
                    $val  =  $this->_checkFields($name,$val);
                    if(false !== $_field = array_search($field,$val,true)) {
                        // 存在視圖字段
                        $field     =  is_numeric($_field)?$k.'.'.$field:$k.'.'.$_field;
                        break;
                    }
                }
                $_group[] = $field;
            }
            $group  =   implode(',',$_group);
         }
        return $group;
    }

    /**
     * 檢查fields表達式中的視圖字段
     * @access protected
     * @param string $fields 字段
     * @return string
     */
    protected function checkFields($fields='') {
        if(empty($fields) || '*'==$fields ) {
            // 獲取全部視圖字段
            $fields =   array();
            foreach ($this->viewFields as $name=>$val){
                $k = isset($val['_as'])?$val['_as']:$name;
                $val  =  $this->_checkFields($name,$val);
                foreach ($val as $key=>$field){
                    if(is_numeric($key)) {
                        $fields[]    =   $k.'.'.$field.' AS '.$field;
                    }elseif('_' != substr($key,0,1)) {
                        // 以_開頭的為特殊定義
                        if( false !== strpos($key,'*') ||  false !== strpos($key,'(') || false !== strpos($key,'.')) {
                            //如果包含* 或者 使用了sql方法 則不再添加前面的表名
                            $fields[]    =   $key.' AS '.$field;
                        }else{
                            $fields[]    =   $k.'.'.$key.' AS '.$field;
                        }
                    }
                }
            }
            $fields = implode(',',$fields);
        }else{
            if(!is_array($fields))
                $fields =   explode(',',$fields);
            // 解析成視圖字段
            $array =  array();
            foreach ($fields as $key=>$field){
                if(strpos($field,'(') || strpos(strtolower($field),' as ')){
                    // 使用了函數或者別名
                    $array[] =  $field;
                    unset($fields[$key]);
                }
            }
            foreach ($this->viewFields as $name=>$val){
                $k = isset($val['_as'])?$val['_as']:$name;
                $val  =  $this->_checkFields($name,$val);
                foreach ($fields as $key=>$field){
                    if(false !== $_field = array_search($field,$val,true)) {
                        // 存在視圖字段
                        if(is_numeric($_field)) {
                            $array[]    =   $k.'.'.$field.' AS '.$field;
                        }elseif('_' != substr($_field,0,1)){
                            if( false !== strpos($_field,'*') ||  false !== strpos($_field,'(') || false !== strpos($_field,'.'))
                                //如果包含* 或者 使用了sql方法 則不再添加前面的表名
                                $array[]    =   $_field.' AS '.$field;
                            else
                                $array[]    =   $k.'.'.$_field.' AS '.$field;
                        }
                    }
                }
            }
            $fields = implode(',',$array);
        }
        return $fields;
    }
}