<?php
// +----------------------------------------------------------------------
// | ThinkPHP [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2006-2014 http://thinkphp.cn All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: Jay <yangweijiester@gmail.com> <http://code-tech.diandian.com>
// +----------------------------------------------------------------------
namespace Think\Upload\Driver;
use Think\Upload\Driver\Bcs\BaiduBcs;
class Bcs {
    /**
     * 上傳文件根目錄
     * @var string
     */
    private $rootPath;
    const DEFAULT_URL = 'bcs.duapp.com';

    /**
     * 上傳錯誤信息
     * @var string
     */
    private $error = '';

    public $config = array(
    	'AccessKey'=> '',
        'SecretKey'=> '', //百度雲服務器
        'bucket'   => '', //空間名稱
        'rename'   => false,
        'timeout'  => 3600, //超時時間
    );

    public $bcs = null;

    /**
     * 構造函數，用於設置上傳根路徑
     * @param array  $config FTP配置
     */
    public function __construct($config){
        /* 默認FTP配置 */
        $this->config = array_merge($this->config, $config);
        
        $bcsClass = dirname(__FILE__). "/Bcs/bcs.class.php";
        if(is_file($bcsClass))
            require_once($bcsClass);
        $this->bcs = new BaiduBCS ( $this->config['AccessKey'], $this->config['SecretKey'], self:: DEFAULT_URL );
    }

    /**
     * 檢測上傳根目錄(百度雲上傳時支持自動創建目錄，直接返回)
     * @param string $rootpath   根目錄
     * @return boolean true-檢測通過，false-檢測失敗
     */
    public function checkRootPath($rootpath){
        /* 設置根目錄 */
        $this->rootPath = str_replace('./', '/', $rootpath);
    	return true;
    }

    /**
     * 檢測上傳目錄(百度雲上傳時支持自動創建目錄，直接返回)
     * @param  string $savepath 上傳目錄
     * @return boolean          檢測結果，true-通過，false-失敗
     */
	public function checkSavePath($savepath){
		return true;
    }

    /**
     * 創建文件夾 (百度雲上傳時支持自動創建目錄，直接返回)
     * @param  string $savepath 目錄名稱
     * @return boolean          true-創建成功，false-創建失敗
     */
    public function mkdir($savepath){
    	return true;
    }

    /**
     * 保存指定文件
     * @param  array   $file    保存的文件信息
     * @param  boolean $replace 同名文件是否覆蓋
     * @return boolean          保存狀態，true-成功，false-失敗
     */
    public function save(&$file,$replace=true) {
        $opt = array ();
        $opt ['acl'] = BaiduBCS::BCS_SDK_ACL_TYPE_PUBLIC_WRITE;
        $opt ['curlopts'] = array (
            CURLOPT_CONNECTTIMEOUT => 10,
            CURLOPT_TIMEOUT => 1800
        );
        $object = "/{$file['savepath']}{$file['savename']}";
        $response = $this->bcs->create_object ( $this->config['bucket'], $object, $file['tmp_name'], $opt );
        $url = $this->download($object);
        $file['url'] = $url;
        return $response->isOK() ? true : false;
    }

    public function download($file){
        $file = str_replace('./', '/', $file);
        $opt = array();
        $opt['time'] = mktime('2049-12-31'); //這是最長有效時間!--
        $response = $this->bcs->generate_get_object_url ( $this->config['bucket'], $file, $opt );
        return $response;
    }

    /**
     * 獲取最後一次上傳錯誤信息
     * @return string 錯誤信息
     */
    public function getError(){
        return $this->error;
    }

    /**
     * 請求百度雲服務器
     * @param  string   $path    請求的PATH
     * @param  string   $method  請求方法
     * @param  array    $headers 請求header
     * @param  resource $body    上傳文件資源
     * @return boolean
     */
    private function request($path, $method, $headers = null, $body = null){
        $ch  = curl_init($path);

        $_headers = array('Expect:');
        if (!is_null($headers) && is_array($headers)){
            foreach($headers as $k => $v) {
                array_push($_headers, "{$k}: {$v}");
            }
        }

        $length = 0;
        $date   = gmdate('D, d M Y H:i:s \G\M\T');

        if (!is_null($body)) {
            if(is_resource($body)){
                fseek($body, 0, SEEK_END);
                $length = ftell($body);
                fseek($body, 0);

                array_push($_headers, "Content-Length: {$length}");
                curl_setopt($ch, CURLOPT_INFILE, $body);
                curl_setopt($ch, CURLOPT_INFILESIZE, $length);
            } else {
                $length = @strlen($body);
                array_push($_headers, "Content-Length: {$length}");
                curl_setopt($ch, CURLOPT_POSTFIELDS, $body);
            }
        } else {
            array_push($_headers, "Content-Length: {$length}");
        }

        // array_push($_headers, 'Authorization: ' . $this->sign($method, $uri, $date, $length));
        array_push($_headers, "Date: {$date}");

        curl_setopt($ch, CURLOPT_HTTPHEADER, $_headers);
        curl_setopt($ch, CURLOPT_TIMEOUT, $this->config['timeout']);
        curl_setopt($ch, CURLOPT_HEADER, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 0);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $method);

        if ($method == 'PUT' || $method == 'POST') {
            curl_setopt($ch, CURLOPT_POST, 1);
        } else {
            curl_setopt($ch, CURLOPT_POST, 0);
        }

        if ($method == 'HEAD') {
            curl_setopt($ch, CURLOPT_NOBODY, true);
        }

        $response = curl_exec($ch);
        $status   = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        list($header, $body) = explode("\r\n\r\n", $response, 2);

        if ($status == 200) {
            if ($method == 'GET') {
                return $body;
            } else {
                $data = $this->response($header);
                return count($data) > 0 ? $data : true;
            }
        } else {
            $this->error($header);
            return false;
        }
    }

    /**
     * 獲取響應數據
     * @param  string $text 響應頭字符串
     * @return array        響應數據列表
     */
    private function response($text){
        $items = json_decode($text, true);
        return $items;
    }

    /**
     * 生成請求簽名
     * @return string          請求簽名
     */
    private function sign($method, $Bucket, $object='/', $size=''){
        if(!$size)
            $size = $this->config['size'];
        $param = array(
            'ak'=>$this->config['AccessKey'],
            'sk'=>$this->config['SecretKey'],
            'size'=>$size,
            'bucket'=>$Bucket,
            'host'=>self :: DEFAULT_URL,
            'date'=>time()+$this->config['timeout'],
            'ip'=>'',
            'object'=>$object
        );
        $response = $this->request($this->apiurl.'?'.http_build_query($param), 'POST');
        if($response)
            $response = json_decode($response, true);
        return $response['content'][$method];
    }


    /**
     * 獲取請求錯誤信息
     * @param  string $header 請求返回頭信息
     */
    private function error($header) {
        list($status, $stash) = explode("\r\n", $header, 2);
        list($v, $code, $message) = explode(" ", $status, 3);
        $message = is_null($message) ? 'File Not Found' : "[{$status}]:{$message}";
        $this->error = $message;
    }

}
