<?php
// +----------------------------------------------------------------------
// | ThinkPHP [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2006-2014 http://thinkphp.cn All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 麥當苗兒 <zuojiazi@vip.qq.com> <http://www.zjzit.cn>
// +----------------------------------------------------------------------

namespace Think\Upload\Driver;
class Ftp {
    /**
     * 上傳文件根目錄
     * @var string
     */
    private $rootPath;

    /**
     * 本地上傳錯誤信息
     * @var string
     */
    private $error = ''; //上傳錯誤信息

    /**
     * FTP連接
     * @var resource
     */
    private $link;

    private $config = array(
        'host'     => '', //服務器
        'port'     => 21, //端口
        'timeout'  => 90, //超時時間
        'username' => '', //用戶名
        'password' => '', //密碼
    );

    /**
     * 構造函數，用於設置上傳根路徑
     * @param array  $config FTP配置
     */
    public function __construct($config){
        /* 默認FTP配置 */
        $this->config = array_merge($this->config, $config);

        /* 登錄FTP服務器 */
        if(!$this->login()){
            E($this->error);
        }
    }

    /**
     * 檢測上傳根目錄
     * @param string $rootpath   根目錄
     * @return boolean true-檢測通過，false-檢測失敗
     */
    public function checkRootPath($rootpath){
        /* 設置根目錄 */
        $this->rootPath = ftp_pwd($this->link) . '/' . ltrim($rootpath, '/');

        if(!@ftp_chdir($this->link, $this->rootPath)){
            $this->error = '上傳根目錄不存在！';
            return false;
        }
        return true;
    }

    /**
     * 檢測上傳目錄
     * @param  string $savepath 上傳目錄
     * @return boolean          檢測結果，true-通過，false-失敗
     */
    public function checkSavePath($savepath){
        /* 檢測並創建目錄 */
        if (!$this->mkdir($savepath)) {
            return false;
        } else {
            //TODO:檢測目錄是否可寫
            return true;
        }
    }

    /**
     * 保存指定文件
     * @param  array   $file    保存的文件信息
     * @param  boolean $replace 同名文件是否覆蓋
     * @return boolean          保存狀態，true-成功，false-失敗
     */
    public function save($file, $replace=true) {
        $filename = $this->rootPath . $file['savepath'] . $file['savename'];

        /* 不覆蓋同名文件 */
        // if (!$replace && is_file($filename)) {
        //     $this->error = '存在同名文件' . $file['savename'];
        //     return false;
        // }

        /* 移動文件 */
        if (!ftp_put($this->link, $filename, $file['tmp_name'], FTP_BINARY)) {
            $this->error = '文件上傳保存錯誤！';
            return false;
        }
        return true;
    }

    /**
     * 創建目錄
     * @param  string $savepath 要創建的穆裡
     * @return boolean          創建狀態，true-成功，false-失敗
     */
    public function mkdir($savepath){
        $dir = $this->rootPath . $savepath;
        if(ftp_chdir($this->link, $dir)){
            return true;
        }

        if(ftp_mkdir($this->link, $dir)){
            return true;
        } elseif($this->mkdir(dirname($savepath)) && ftp_mkdir($this->link, $dir)) {
            return true;
        } else {
            $this->error = "目錄 {$savepath} 創建失敗！";
            return false;
        }
    }

    /**
     * 獲取最後一次上傳錯誤信息
     * @return string 錯誤信息
     */
    public function getError(){
        return $this->error;
    }

    /**
     * 登錄到FTP服務器
     * @return boolean true-登錄成功，false-登錄失敗
     */
    private function login(){
        extract($this->config);
        $this->link = ftp_connect($host, $port, $timeout);
        if($this->link) {
            if (ftp_login($this->link, $username, $password)) {
               return true;
            } else {
                $this->error = "無法登錄到FTP服務器：username - {$username}";
            }
        } else {
            $this->error = "無法連接到FTP服務器：{$host}";
        }
        return false;
    }

    /**
     * 析構方法，用於斷開當前FTP連接
     */
    public function __destruct() {
        ftp_close($this->link);
    }

}
