<?php
// +----------------------------------------------------------------------
// | ThinkPHP [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2006-2014 http://thinkphp.cn All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 麥當苗兒 <zuojiazi@vip.qq.com> <http://www.zjzit.cn>
// +----------------------------------------------------------------------

namespace Think\Upload\Driver;
class Local {
	/**
	 * 上傳文件根目錄
	 * @var string
	 */
	private $rootPath;

	/**
	 * 本地上傳錯誤信息
	 * @var string
	 */
	private $error = '';
	//上傳錯誤信息

	/**
	 * 構造函數，用於設置上傳根路徑
	 */
	public function __construct($config = null) {

	}

	/**
	 * 檢測上傳根目錄
	 * @param string $rootpath   根目錄
	 * @return boolean true-檢測通過，false-檢測失敗
	 */
	public function checkRootPath($rootpath) {
		if (!(is_dir($rootpath) && is_writable($rootpath))) {
			$this -> error = '上傳根目錄不存在！請嘗試手動創建:' . $rootpath;
			return false;
		}
		$this -> rootPath = $rootpath;
		return true;
	}

	/**
	 * 檢測上傳目錄
	 * @param  string $savepath 上傳目錄
	 * @return boolean          檢測結果，true-通過，false-失敗
	 */
	public function checkSavePath($savepath) {
		/* 檢測並創建目錄 */
		if (!$this -> mkdir($savepath)) {
			return false;
		} else {
			/* 檢測目錄是否可寫 */
			if (!is_writable($this -> rootPath . $savepath)) {
				$this -> error = '上傳目錄 ' . $savepath . ' 不可寫！';
				return false;
			} else {
				return true;
			}
		}
	}

	/**
	 * 保存指定文件
	 * @param  array   $file    保存的文件信息
	 * @param  boolean $replace 同名文件是否覆蓋
	 * @return boolean          保存狀態，true-成功，false-失敗
	 */
	public function save($file, $replace = true) {
		$filename = $this -> rootPath . $file['savepath'] . $file['savename'];

		/* 不覆蓋同名文件 */
		if (!$replace && is_file($filename)) {
			$this -> error = '存在同名文件' . $file['savename'];
			return false;
		}

		if ($file['is_move']) {
			if (!rename($file['tmp_name'], $filename)) {
				$this -> error = '文件上傳保存錯誤！';
				return false;
			}
		} else {
			/* 移動文件 */
			if (!move_uploaded_file($file['tmp_name'], $filename)) {
				$this -> error = '文件上傳保存錯誤！';
				return false;
			}
		}

		return true;
	}

	/**
	 * 創建目錄
	 * @param  string $savepath 要創建的穆裡
	 * @return boolean          創建狀態，true-成功，false-失敗
	 */
	public function mkdir($savepath) {
		$dir = $this -> rootPath . $savepath;
		if (is_dir($dir)) {
			return true;
		}

		if (mkdir($dir, 0777, true)) {
			return true;
		} else {
			$this -> error = "目錄 {$savepath} 創建失敗！";
			return false;
		}
	}

	/**
	 * 獲取最後一次上傳錯誤信息
	 * @return string 錯誤信息
	 */
	public function getError() {
		return $this -> error;
	}

}
