<?php
// +----------------------------------------------------------------------
// | ThinkPHP [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2006-2014 http://thinkphp.cn All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: yangweijie <yangweijiester@gmail.com> <http://www.code-tech.diandian.com>
// +----------------------------------------------------------------------

namespace Think\Upload\Driver;
use Think\Upload\Driver\Qiniu\QiniuStorage;

class Qiniu{
    /**
     * 上傳文件根目錄
     * @var string
     */
    private $rootPath;

    /**
     * 上傳錯誤信息
     * @var string
     */
    private $error = '';

    private $config = array(
        'secrectKey'     => '', //七牛服務器
        'accessKey'      => '', //七牛用戶
        'domain'         => '', //七牛密碼
        'bucket'         => '', //空間名稱
        'timeout'        => 300, //超時時間
    );

    /**
     * 構造函數，用於設置上傳根路徑
     * @param array  $config FTP配置
     */
    public function __construct($config){
        $this->config = array_merge($this->config, $config);
        /* 設置根目錄 */
        $this->qiniu = new QiniuStorage($config);
    }

    /**
     * 檢測上傳根目錄(七牛上傳時支持自動創建目錄，直接返回)
     * @param string $rootpath   根目錄
     * @return boolean true-檢測通過，false-檢測失敗
     */
    public function checkRootPath($rootpath){
        $this->rootPath = trim($rootpath, './') . '/';
        return true;
    }

    /**
     * 檢測上傳目錄(七牛上傳時支持自動創建目錄，直接返回)
     * @param  string $savepath 上傳目錄
     * @return boolean          檢測結果，true-通過，false-失敗
     */
    public function checkSavePath($savepath){
        return true;
    }

    /**
     * 創建文件夾 (七牛上傳時支持自動創建目錄，直接返回)
     * @param  string $savepath 目錄名稱
     * @return boolean          true-創建成功，false-創建失敗
     */
    public function mkdir($savepath){
        return true;
    }

    /**
     * 保存指定文件
     * @param  array   $file    保存的文件信息
     * @param  boolean $replace 同名文件是否覆蓋
     * @return boolean          保存狀態，true-成功，false-失敗
     */
    public function save(&$file,$replace=true) {
        $file['name'] = $file['savepath'] . $file['savename'];
        $key = str_replace('/', '_', $file['name']);
        $upfile = array(
            'name'=>'file',
            'fileName'=>$key,
            'fileBody'=>file_get_contents($file['tmp_name'])
        );
        $config = array();
        $result = $this->qiniu->upload($config, $upfile);
        $url = $this->qiniu->downlink($key);
        $file['url'] = $url;
        return false ===$result ? false : true;
    }

    /**
     * 獲取最後一次上傳錯誤信息
     * @return string 錯誤信息
     */
    public function getError(){
        return $this->qiniu->errorStr;
    }
}
