<?php
// +----------------------------------------------------------------------
// | ThinkPHP [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2006-2014 http://thinkphp.cn All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: luofei614<weibo.com/luofei614>
// +----------------------------------------------------------------------

namespace Think\Upload\Driver;
class Sae{
    /**
     * Storage的Domain
     * @var string
     */
    private $domain     =   '';

    private $rootPath   =   '';

    /**
     * 本地上傳錯誤信息
     * @var string
     */
    private $error      =   ''; 

    /**
     * 構造函數，設置storage的domain， 如果有傳配置，則domain為配置項，如果沒有傳domain為第一個路徑的目錄名稱。 
     * @param mixed $config 上傳配置     
     */
    public function __construct($config = null){
        if(is_array($config) && !empty($config['domain'])){
            $this->domain   =   strtolower($config['domain']);
        }
    }

    /**
     * 檢測上傳根目錄
     * @param string $rootpath   根目錄
     * @return boolean true-檢測通過，false-檢測失敗
     */
    public function checkRootPath($rootpath){
        $rootpath = trim($rootpath,'./');
        if(!$this->domain){
            $rootpath = explode('/', $rootpath);
            $this->domain = strtolower(array_shift($rootpath));
            $rootpath = implode('/', $rootpath);
        }

        $this->rootPath =  $rootpath;
        $st =   new \SaeStorage();
        if(false===$st->getDomainCapacity($this->domain)){
          $this->error  =   '您好像沒有建立Storage的domain['.$this->domain.']';
          return false;
        }
        return true;
    }

    /**
     * 檢測上傳目錄
     * @param  string $savepath 上傳目錄
     * @return boolean          檢測結果，true-通過，false-失敗
     */
    public function checkSavePath($savepath){
        return true;
    }

    /**
     * 保存指定文件
     * @param  array   $file    保存的文件信息
     * @param  boolean $replace 同名文件是否覆蓋
     * @return boolean          保存狀態，true-成功，false-失敗
     */
    public function save(&$file, $replace=true) {
        $filename = ltrim($this->rootPath .'/'. $file['savepath'] . $file['savename'],'/');
        $st =   new \SaeStorage();
        /* 不覆蓋同名文件 */ 
        if (!$replace && $st->fileExists($this->domain,$filename)) {
            $this->error = '存在同名文件' . $file['savename'];
            return false;
        }

        /* 移動文件 */
        if (!$st->upload($this->domain,$filename,$file['tmp_name'])) {
            $this->error = '文件上傳保存錯誤！['.$st->errno().']:'.$st->errmsg();
            return false;
        }else{
            $file['url'] = $st->getUrl($this->domain, $filename);
        }
        return true;
    }

    public function mkdir(){
        return true;
    }

    /**
     * 獲取最後一次上傳錯誤信息
     * @return string 錯誤信息
     */
    public function getError(){
        return $this->error;
    }

}
