<?php
// +----------------------------------------------------------------------
// | ThinkPHP [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2006-2014 http://thinkphp.cn All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 麥當苗兒 <zuojiazi@vip.qq.com> <http://www.zjzit.cn>
// +----------------------------------------------------------------------

namespace Think\Upload\Driver;
class Upyun{
    /**
     * 上傳文件根目錄
     * @var string
     */
    private $rootPath;

    /**
     * 上傳錯誤信息
     * @var string
     */
    private $error = '';

    private $config = array(
        'host'     => '', //又拍雲服務器
        'username' => '', //又拍雲用戶
        'password' => '', //又拍雲密碼
        'bucket'   => '', //空間名稱
        'timeout'  => 90, //超時時間
    );

    /**
     * 構造函數，用於設置上傳根路徑
     * @param array  $config FTP配置
     */
    public function __construct($config){
        /* 默認FTP配置 */
        $this->config = array_merge($this->config, $config);
        $this->config['password'] = md5($this->config['password']);
    }

    /**
     * 檢測上傳根目錄(又拍雲上傳時支持自動創建目錄，直接返回)
     * @param string $rootpath   根目錄
     * @return boolean true-檢測通過，false-檢測失敗
     */
    public function checkRootPath($rootpath){
        /* 設置根目錄 */
        $this->rootPath = trim($rootpath, './') . '/';
        return true;
    }

    /**
     * 檢測上傳目錄(又拍雲上傳時支持自動創建目錄，直接返回)
     * @param  string $savepath 上傳目錄
     * @return boolean          檢測結果，true-通過，false-失敗
     */
    public function checkSavePath($savepath){
        return true;
    }

    /**
     * 創建文件夾 (又拍雲上傳時支持自動創建目錄，直接返回)
     * @param  string $savepath 目錄名稱
     * @return boolean          true-創建成功，false-創建失敗
     */
    public function mkdir($savepath){
        return true;
    }

    /**
     * 保存指定文件
     * @param  array   $file    保存的文件信息
     * @param  boolean $replace 同名文件是否覆蓋
     * @return boolean          保存狀態，true-成功，false-失敗
     */
    public function save($file, $replace = true) {
        $header['Content-Type'] = $file['type'];
        $header['Content-MD5'] 	= $file['md5'];
        $header['Mkdir'] = 'true';
        $resource = fopen($file['tmp_name'], 'r');

        $save = $this->rootPath . $file['savepath'] . $file['savename'];
        $data = $this->request($save, 'PUT', $header, $resource);
        return false === $data ? false : true;
    }

    /**
     * 獲取最後一次上傳錯誤信息
     * @return string 錯誤信息
     */
    public function getError(){
        return $this->error;
    }

    /**
     * 請求又拍雲服務器
     * @param  string   $path    請求的PATH
     * @param  string   $method  請求方法
     * @param  array    $headers 請求header
     * @param  resource $body    上傳文件資源
     * @return boolean
     */
    private function request($path, $method, $headers = null, $body = null){
        $uri = "/{$this->config['bucket']}/{$path}";
        $ch  = curl_init($this->config['host'] . $uri);

        $_headers = array('Expect:');
        if (!is_null($headers) && is_array($headers)){
            foreach($headers as $k => $v) {
                array_push($_headers, "{$k}: {$v}");
            }
        }

        $length = 0;
        $date   = gmdate('D, d M Y H:i:s \G\M\T');

        if (!is_null($body)) {
            if(is_resource($body)){
                fseek($body, 0, SEEK_END);
                $length = ftell($body);
                fseek($body, 0);

                array_push($_headers, "Content-Length: {$length}");
                curl_setopt($ch, CURLOPT_INFILE, $body);
                curl_setopt($ch, CURLOPT_INFILESIZE, $length);
            } else {
                $length = @strlen($body);
                array_push($_headers, "Content-Length: {$length}");
                curl_setopt($ch, CURLOPT_POSTFIELDS, $body);
            }
        } else {
            array_push($_headers, "Content-Length: {$length}");
        }

        array_push($_headers, 'Authorization: ' . $this->sign($method, $uri, $date, $length));
        array_push($_headers, "Date: {$date}");

        curl_setopt($ch, CURLOPT_HTTPHEADER, $_headers);
        curl_setopt($ch, CURLOPT_TIMEOUT, $this->config['timeout']);
        curl_setopt($ch, CURLOPT_HEADER, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 0);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $method);

        if ($method == 'PUT' || $method == 'POST') {
            curl_setopt($ch, CURLOPT_POST, 1);
        } else {
            curl_setopt($ch, CURLOPT_POST, 0);
        }

        if ($method == 'HEAD') {
            curl_setopt($ch, CURLOPT_NOBODY, true);
        }

        $response = curl_exec($ch);
        $status   = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        list($header, $body) = explode("\r\n\r\n", $response, 2);

        if ($status == 200) {
            if ($method == 'GET') {
                return $body;
            } else {
                $data = $this->response($header);
                return count($data) > 0 ? $data : true;
            }
        } else {
            $this->error($header);
            return false;
        }
    }

    /**
     * 獲取響應數據
     * @param  string $text 響應頭字符串
     * @return array        響應數據列表
     */
    private function response($text){
        $headers = explode("\r\n", $text);
        $items = array();
        foreach($headers as $header) {
            $header = trim($header);
            if(strpos($header, 'x-upyun') !== False){
                list($k, $v) = explode(':', $header);
                $items[trim($k)] = in_array(substr($k,8,5), array('width','heigh','frame')) ? intval($v) : trim($v);
            }
        }
        return $items;
    }

    /**
     * 生成請求簽名
     * @param  string  $method 請求方法
     * @param  string  $uri    請求URI
     * @param  string  $date   請求時間
     * @param  integer $length 請求內容大小
     * @return string          請求簽名
     */
    private function sign($method, $uri, $date, $length){
        $sign = "{$method}&{$uri}&{$date}&{$length}&{$this->config['password']}";
        return 'UpYun ' . $this->config['username'] . ':' . md5($sign);
    }

    /**
     * 獲取請求錯誤信息
     * @param  string $header 請求返回頭信息
     */
    private function error($header) {
        list($status, $stash) = explode("\r\n", $header, 2);
        list($v, $code, $message) = explode(" ", $status, 3);
        $message = is_null($message) ? 'File Not Found' : "[{$status}]:{$message}";
        $this->error = $message;
    }

}
