<?php
// +----------------------------------------------------------------------
// | ThinkPHP [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2006-2014 http://thinkphp.cn All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: liu21st <liu21st@gmail.com>
// +----------------------------------------------------------------------
namespace Think;
/**
 * ThinkPHP 視圖類
 */
class View {
    /**
     * 模板輸出變量
     * @var tVar
     * @access protected
     */ 
    protected $tVar     =   array();

    /**
     * 模板主題
     * @var theme
     * @access protected
     */ 
    protected $theme    =   '';

    /**
     * 模板變量賦值
     * @access public
     * @param mixed $name
     * @param mixed $value
     */
    public function assign($name,$value=''){
        if(is_array($name)) {
            $this->tVar   =  array_merge($this->tVar,$name);
        }else {
            $this->tVar[$name] = $value;
        }
    }

    /**
     * 取得模板變量的值
     * @access public
     * @param string $name
     * @return mixed
     */
    public function get($name=''){
        if('' === $name) {
            return $this->tVar;
        }
        return isset($this->tVar[$name])?$this->tVar[$name]:false;
    }

    /**
     * 加載模板和頁面輸出 可以返回輸出內容
     * @access public
     * @param string $templateFile 模板文件名
     * @param string $charset 模板輸出字符集
     * @param string $contentType 輸出類型
     * @param string $content 模板輸出內容
     * @param string $prefix 模板緩存前綴
     * @return mixed
     */
    public function display($templateFile='',$charset='',$contentType='',$content='',$prefix='') {
        G('viewStartTime');
        // 視圖開始標籤
        Hook::listen('view_begin',$templateFile);
        // 解析並獲取模板內容
        $content = $this->fetch($templateFile,$content,$prefix);
        // 輸出模板內容
        $this->render($content,$charset,$contentType);
        // 視圖結束標籤
        Hook::listen('view_end');
    }

    /**
     * 輸出內容文本可以包括Html
     * @access private
     * @param string $content 輸出內容
     * @param string $charset 模板輸出字符集
     * @param string $contentType 輸出類型
     * @return mixed
     */
    private function render($content,$charset='',$contentType=''){
        if(empty($charset))  $charset = C('DEFAULT_CHARSET');
        if(empty($contentType)) $contentType = C('TMPL_CONTENT_TYPE');
        // 網頁字符編碼
        header('Content-Type:'.$contentType.'; charset='.$charset);
        header('Cache-control: '.C('HTTP_CACHE_CONTROL'));  // 頁面緩存控制
        header('X-Powered-By:ThinkPHP');
        // 輸出模板文件
        echo $content;
    }

    /**
     * 解析和獲取模板內容 用於輸出
     * @access public
     * @param string $templateFile 模板文件名
     * @param string $content 模板輸出內容
     * @param string $prefix 模板緩存前綴
     * @return string
     */
    public function fetch($templateFile='',$content='',$prefix='') {
        if(empty($content)) {
            $templateFile   =   $this->parseTemplate($templateFile);
            // 模板文件不存在直接返回
            if(!is_file($templateFile)) E(L('_TEMPLATE_NOT_EXIST_').':'.$templateFile);
        }else{
            defined('THEME_PATH') or    define('THEME_PATH', $this->getThemePath());
        }
        // 頁面緩存
        ob_start();
        ob_implicit_flush(0);
        if('php' == strtolower(C('TMPL_ENGINE_TYPE'))) { // 使用PHP原生模板
            $_content   =   $content;
            // 模板陣列變量分解成為獨立變量
            extract($this->tVar, EXTR_OVERWRITE);
            // 直接載入PHP模板
            empty($_content)?include $templateFile:eval('?>'.$_content);
        }else{
            // 視圖解析標籤
            $params = array('var'=>$this->tVar,'file'=>$templateFile,'content'=>$content,'prefix'=>$prefix);
            Hook::listen('view_parse',$params);
        }
        // 獲取並清空緩存
        $content = ob_get_clean();
        // 內容過濾標籤
        Hook::listen('view_filter',$content);
        // 輸出模板文件
        return $content;
    }

    /**
     * 自動定位模板文件
     * @access protected
     * @param string $template 模板文件規則
     * @return string
     */
    public function parseTemplate($template='') {
        if(is_file($template)) {
            return $template;
        }
        $depr       =   C('TMPL_FILE_DEPR');
        $template   =   str_replace(':', $depr, $template);

        // 獲取當前模塊
        $module   =  MODULE_NAME;
        if(strpos($template,'@')){ // 跨模塊調用模版文件
            list($module,$template)  =   explode('@',$template);
        }
        // 獲取當前主題的模版路徑
        defined('THEME_PATH') or    define('THEME_PATH', $this->getThemePath($module));

        // 分析模板文件規則
        if('' == $template) {
            // 如果模板文件名為空 按照默認規則定位
            $template = CONTROLLER_NAME . $depr . ACTION_NAME;
        }elseif(false === strpos($template, $depr)){
            $template = CONTROLLER_NAME . $depr . $template;
        }
        $file   =   THEME_PATH.$template.C('TMPL_TEMPLATE_SUFFIX');
        if(C('TMPL_LOAD_DEFAULTTHEME') && THEME_NAME != C('DEFAULT_THEME') && !is_file($file)){
            // 找不到當前主題模板的時候定位默認主題中的模板
            $file   =   dirname(THEME_PATH).'/'.C('DEFAULT_THEME').'/'.$template.C('TMPL_TEMPLATE_SUFFIX');
        }
        return $file;
    }

    /**
     * 獲取當前的模板路徑
     * @access protected
     * @param  string $module 模塊名
     * @return string
     */
    protected function getThemePath($module=MODULE_NAME){
        // 獲取當前主題名稱
        $theme = $this->getTemplateTheme();
        // 獲取當前主題的模版路徑
        $tmplPath   =   C('VIEW_PATH'); // 模塊設置獨立的視圖目錄
        if(!$tmplPath){ 
            // 定義TMPL_PATH 則改變全局的視圖目錄到模塊之外
            $tmplPath   =   defined('TMPL_PATH')? TMPL_PATH.$module.'/' : APP_PATH.$module.'/'.C('DEFAULT_V_LAYER').'/';
        }
        return $tmplPath.$theme;
    }

    /**
     * 設置當前輸出的模板主題
     * @access public
     * @param  mixed $theme 主題名稱
     * @return View
     */
    public function theme($theme){
        $this->theme = $theme;
        return $this;
    }

    /**
     * 獲取當前的模板主題
     * @access private
     * @return string
     */
    private function getTemplateTheme() {
        if($this->theme) { // 指定模板主題
            $theme = $this->theme;
        }else{
            /* 獲取模板主題名稱 */
            $theme =  C('DEFAULT_THEME');
            if(C('TMPL_DETECT_THEME')) {// 自動偵測模板主題
                $t = C('VAR_TEMPLATE');
                if (isset($_GET[$t])){
                    $theme = $_GET[$t];
                }elseif(cookie('think_template')){
                    $theme = cookie('think_template');
                }
                if(!in_array($theme,explode(',',C('THEME_LIST')))){
                    $theme =  C('DEFAULT_THEME');
                }
                cookie('think_template',$theme,864000);
            }
        }
        defined('THEME_NAME') || define('THEME_NAME',   $theme);                  // 當前模板主題名稱
        return $theme?$theme . '/':'';
    }

}