<?php
// +----------------------------------------------------------------------
// | ThinkPHP [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2006-2014 http://thinkphp.cn All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: liu21st <liu21st@gmail.com>
// +----------------------------------------------------------------------
namespace Think;
/**
 * ThinkPHP 控制器基類 抽像類
 */
abstract class Controller {

    /**
     * 視圖實例對像
     * @var view
     * @access protected
     */    
    protected $view     =  null;

    /**
     * 控制器參數
     * @var config
     * @access protected
     */      
    protected $config   =   array();

   /**
     * 架構函數 取得模板對像實例
     * @access public
     */
    public function __construct() {
        //實例化視圖類
        $this->view     = Think::instance('Think\View');
        //控制器初始化
        if(method_exists($this,'_initialize'))
            $this->_initialize();
    }

    /**
     * 模板顯示 調用內置的模板引擎顯示方法，
     * @access protected
     * @param string $templateFile 指定要調用的模板文件
     * 默認為空 由系統自動定位模板文件
     * @param string $charset 輸出編碼
     * @param string $contentType 輸出類型
     * @param string $content 輸出內容
     * @param string $prefix 模板緩存前綴
     * @return void
     */
    protected function display($templateFile='',$charset='',$contentType='',$content='',$prefix='') {
        $this->view->display($templateFile,$charset,$contentType,$content,$prefix);
    }

    /**
     * 輸出內容文本可以包括Html 並支持內容解析
     * @access protected
     * @param string $content 輸出內容
     * @param string $charset 模板輸出字符集
     * @param string $contentType 輸出類型
     * @param string $prefix 模板緩存前綴
     * @return mixed
     */
    protected function show($content,$charset='',$contentType='',$prefix='') {
        $this->view->display('',$charset,$contentType,$content,$prefix);
    }

    /**
     *  獲取輸出頁面內容
     * 調用內置的模板引擎fetch方法，
     * @access protected
     * @param string $templateFile 指定要調用的模板文件
     * 默認為空 由系統自動定位模板文件
     * @param string $content 模板輸出內容
     * @param string $prefix 模板緩存前綴* 
     * @return string
     */
    protected function fetch($templateFile='',$content='',$prefix='') {
        return $this->view->fetch($templateFile,$content,$prefix);
    }

    /**
     * 模板主題設置
     * @access protected
     * @param string $theme 模版主題
     * @return Action
     */
    protected function theme($theme){
        $this->view->theme($theme);
        return $this;
    }

    /**
     * 模板變量賦值
     * @access protected
     * @param mixed $name 要顯示的模板變量
     * @param mixed $value 變量的值
     * @return Action
     */
    protected function assign($name,$value='') {
        $this->view->assign($name,$value);
        return $this;
    }

    public function __set($name,$value) {
        $this->assign($name,$value);
    }

    /**
     * 取得模板顯示變量的值
     * @access protected
     * @param string $name 模板顯示變量
     * @return mixed
     */
    public function get($name='') {
        return $this->view->get($name);      
    }

    public function __get($name) {
        return $this->get($name);
    }

    /**
     * 檢測模板變量的值
     * @access public
     * @param string $name 名稱
     * @return boolean
     */
    public function __isset($name) {
        return $this->get($name);
    }

    /**
     * 魔術方法 有不存在的操作的時候執行
     * @access public
     * @param string $method 方法名
     * @param array $args 參數
     * @return mixed
     */
    public function __call($method,$args) {
        if( 0 === strcasecmp($method,ACTION_NAME.C('ACTION_SUFFIX'))) {
            if(method_exists($this,'_empty')) {
                // 如果定義了_empty操作 則調用
                $this->_empty($method,$args);
            }elseif(file_exists_case($this->view->parseTemplate())){
                // 檢查是否存在默認模版 如果有直接輸出模版
                $this->display();
            }else{
                E(L('_ERROR_ACTION_').':'.ACTION_NAME);
            }
        }else{
            E(__CLASS__.':'.$method.L('_METHOD_NOT_EXIST_'));
            return;
        }
    }

    /**
     * 操作錯誤跳轉的快捷方法
     * @access protected
     * @param string $message 錯誤信息
     * @param string $jumpUrl 頁面跳轉地址
     * @param mixed $ajax 是否為Ajax方式 當數字時指定跳轉時間
     * @return void
     */
    protected function error($message='',$jumpUrl='',$ajax=false) {
        $this->dispatchJump($message,0,$jumpUrl,$ajax);
    }

    /**
     * 操作成功跳轉的快捷方法
     * @access protected
     * @param string $message 提示信息
     * @param string $jumpUrl 頁面跳轉地址
     * @param mixed $ajax 是否為Ajax方式 當數字時指定跳轉時間
     * @return void
     */
    protected function success($message='',$jumpUrl='',$ajax=false) {
        $this->dispatchJump($message,1,$jumpUrl,$ajax);
    }

    /**
     * Ajax方式返回數據到客戶端
     * @access protected
     * @param mixed $data 要返回的數據
     * @param String $type AJAX返回數據格式
     * @param int $json_option 傳遞給json_encode的option參數
     * @return void
     */
    protected function ajaxReturn($data,$type='',$json_option=0) {
        if(empty($type)) $type  =   C('DEFAULT_AJAX_RETURN');
        switch (strtoupper($type)){
            case 'JSON' :
                // 返回JSON數據格式到客戶端 包含狀態信息
                header('Content-Type:application/json; charset=utf-8');
                $data       =   json_encode($data,$json_option);
                break;
            case 'JSONP':
                // 返回JSON數據格式到客戶端 包含狀態信息
                header('Content-Type:application/json; charset=utf-8');
                $handler    =   isset($_GET[C('VAR_JSONP_HANDLER')]) ? $_GET[C('VAR_JSONP_HANDLER')] : C('DEFAULT_JSONP_HANDLER');
                $data       =   $handler.'('.json_encode($data,$json_option).');'; 
                break;
            case 'EVAL' :
                // 返回可執行的js腳本
                header('Content-Type:text/html; charset=utf-8');
                break;      
        }
        exit($data);
    }

    /**
     * Action跳轉(URL重定向） 支持指定模塊和延時跳轉
     * @access protected
     * @param string $url 跳轉的URL表達式
     * @param array $params 其它URL參數
     * @param integer $delay 延時跳轉的時間 單位為秒
     * @param string $msg 跳轉提示信息
     * @return void
     */
    protected function redirect($url,$params=array(),$delay=0,$msg='') {
        $url    =   U($url,$params);
        redirect($url,$delay,$msg);
    }

    /**
     * 默認跳轉操作 支持錯誤導向和正確跳轉
     * 調用模板顯示 默認為public目錄下面的success頁面
     * 提示頁面為可配置 支持模板標籤
     * @param string $message 提示信息
     * @param Boolean $status 狀態
     * @param string $jumpUrl 頁面跳轉地址
     * @param mixed $ajax 是否為Ajax方式 當數字時指定跳轉時間
     * @access private
     * @return void
     */
    private function dispatchJump($message,$status=1,$jumpUrl='',$ajax=false) {
        if(true === $ajax || IS_AJAX) {// AJAX提交
            $data           =   is_array($ajax)?$ajax:array();
            $data['info']   =   $message;
            $data['status'] =   $status;
            $data['url']    =   $jumpUrl;
            $this->ajaxReturn($data);
        }
        if(is_int($ajax)) $this->assign('waitSecond',$ajax);
        if(!empty($jumpUrl)) $this->assign('jumpUrl',$jumpUrl);
        // 提示標題
        $this->assign('msgTitle',$status? L('_OPERATION_SUCCESS_') : L('_OPERATION_FAIL_'));
        //如果設置了關閉窗口，則提示完畢後自動關閉窗口
        if($this->get('closeWin'))    $this->assign('jumpUrl','javascript:window.close();');
        $this->assign('status',$status);   // 狀態
        //保證輸出不受靜態緩存影響
        C('HTML_CACHE_ON',false);
        if($status) { //發送成功信息
            $this->assign('message',$message);// 提示信息
            // 成功操作後默認停留1秒
            if(!isset($this->waitSecond))    $this->assign('waitSecond','1');
            // 默認操作成功自動返回操作前頁面
            if(!isset($this->jumpUrl)) $this->assign("jumpUrl",$_SERVER["HTTP_REFERER"]);
            $this->display(C('TMPL_ACTION_SUCCESS'));
        }else{
            $this->assign('error',$message);// 提示信息
            //發生錯誤時候默認停留3秒
            if(!isset($this->waitSecond))    $this->assign('waitSecond','3');
            // 默認發生錯誤的話自動返回上頁
            if(!isset($this->jumpUrl)) $this->assign('jumpUrl',"javascript:history.back(-1);");
            $this->display(C('TMPL_ACTION_ERROR'));
            // 中止執行  避免出錯後繼續執行
            exit ;
        }
    }

}
