<?php
// +----------------------------------------------------------------------
// | ThinkPHP [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2006-2014 http://thinkphp.cn All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: liu21st <liu21st@gmail.com>
// +----------------------------------------------------------------------

//----------------------------------
// ThinkPHP公共入口文件
//----------------------------------

// 記錄開始運行時間
$GLOBALS['_beginTime'] = microtime(TRUE);
// 記錄內存初始使用
define('MEMORY_LIMIT_ON',function_exists('memory_get_usage'));
if(MEMORY_LIMIT_ON) $GLOBALS['_startUseMems'] = memory_get_usage();

// 版本信息
const THINK_VERSION     =   '3.2.3';

// URL 模式定義
const URL_COMMON        =   0;  //普通模式
const URL_PATHINFO      =   1;  //PATHINFO模式
const URL_REWRITE       =   2;  //REWRITE模式
const URL_COMPAT        =   3;  // 兼容模式

// 類文件後綴
const EXT               =   '.class.php'; 

// 系統常量定義
defined('THINK_PATH')   or define('THINK_PATH',     __DIR__.'/');
defined('APP_PATH')     or define('APP_PATH',       dirname($_SERVER['SCRIPT_FILENAME']).'/');
defined('APP_STATUS')   or define('APP_STATUS',     ''); // 應用狀態 加載對應的配置文件
defined('APP_DEBUG')    or define('APP_DEBUG',      false); // 是否調試模式

if(function_exists('saeAutoLoader')){// 自動識別SAE環境
    defined('APP_MODE')     or define('APP_MODE',      'sae');
    defined('STORAGE_TYPE') or define('STORAGE_TYPE',  'Sae');
}else{
    defined('APP_MODE')     or define('APP_MODE',       'common'); // 應用模式 默認為普通模式    
    defined('STORAGE_TYPE') or define('STORAGE_TYPE',   'File'); // 存儲類型 默認為File    
}

defined('RUNTIME_PATH') or define('RUNTIME_PATH',   APP_PATH.'Runtime/');   // 系統運行時目錄
defined('LIB_PATH')     or define('LIB_PATH',       realpath(THINK_PATH.'Library').'/'); // 系統核心類庫目錄
defined('CORE_PATH')    or define('CORE_PATH',      LIB_PATH.'Think/'); // Think類庫目錄
defined('BEHAVIOR_PATH')or define('BEHAVIOR_PATH',  LIB_PATH.'Behavior/'); // 行為類庫目錄
defined('MODE_PATH')    or define('MODE_PATH',      THINK_PATH.'Mode/'); // 系統應用模式目錄
defined('VENDOR_PATH')  or define('VENDOR_PATH',    LIB_PATH.'Vendor/'); // 第三方類庫目錄
defined('COMMON_PATH')  or define('COMMON_PATH',    APP_PATH.'Common/'); // 應用公共目錄
defined('CONF_PATH')    or define('CONF_PATH',      COMMON_PATH.'Conf/'); // 應用配置目錄
defined('LANG_PATH')    or define('LANG_PATH',      COMMON_PATH.'Lang/'); // 應用語言目錄
defined('HTML_PATH')    or define('HTML_PATH',      APP_PATH.'Html/'); // 應用靜態目錄
defined('LOG_PATH')     or define('LOG_PATH',       RUNTIME_PATH.'Logs/'); // 應用日誌目錄
defined('TEMP_PATH')    or define('TEMP_PATH',      RUNTIME_PATH.'Temp/'); // 應用緩存目錄
defined('DATA_PATH')    or define('DATA_PATH',      RUNTIME_PATH.'Data/'); // 應用數據目錄
defined('CACHE_PATH')   or define('CACHE_PATH',     RUNTIME_PATH.'Cache/'); // 應用模板緩存目錄
defined('CONF_EXT')     or define('CONF_EXT',       '.php'); // 配置文件後綴
defined('CONF_PARSE')   or define('CONF_PARSE',     '');    // 配置文件解析方法
defined('ADDON_PATH')   or define('ADDON_PATH',     APP_PATH.'Addon');

// 系統信息
if(version_compare(PHP_VERSION,'5.4.0','<')) {
    ini_set('magic_quotes_runtime',0);
    define('MAGIC_QUOTES_GPC',get_magic_quotes_gpc()? true : false);
}else{
    define('MAGIC_QUOTES_GPC',false);
}
define('IS_CGI',(0 === strpos(PHP_SAPI,'cgi') || false !== strpos(PHP_SAPI,'fcgi')) ? 1 : 0 );
define('IS_WIN',strstr(PHP_OS, 'WIN') ? 1 : 0 );
define('IS_CLI',PHP_SAPI=='cli'? 1   :   0);

if(!IS_CLI) {
    // 當前文件名
    if(!defined('_PHP_FILE_')) {
        if(IS_CGI) {
            //CGI/FASTCGI模式下
            $_temp  = explode('.php',$_SERVER['PHP_SELF']);
            define('_PHP_FILE_',    rtrim(str_replace($_SERVER['HTTP_HOST'],'',$_temp[0].'.php'),'/'));
        }else {
            define('_PHP_FILE_',    rtrim($_SERVER['SCRIPT_NAME'],'/'));
        }
    }
    if(!defined('__ROOT__')) {
        $_root  =   rtrim(dirname(_PHP_FILE_),'/');
        define('__ROOT__',  (($_root=='/' || $_root=='\\')?'':$_root));
    }
}

// 加載核心Think類
require CORE_PATH.'Think'.EXT;
// 應用初始化 
Think\Think::start();