<?php 
/**
 * This file is part of workerman.
 *
 * Licensed under The MIT License
 * For full copyright and license information, please see the MIT-LICENSE.txt
 * Redistributions of files must retain the above copyright notice.
 *
 * @author walkor<walkor@workerman.net>
 * @copyright walkor<walkor@workerman.net>
 * @link http://www.workerman.net/
 * @license http://www.opensource.org/licenses/mit-license.php MIT License
 */
namespace Config;

/**
 * 存儲配置
 * 這是一個GatewayWorker的配置文件，
 * 用於配置key/value存儲，支持File、Memcache、Redis
 * 生產環境建議用Redis存儲，即配置Store::$driver=self::DRIVER_REDIS;
 * 默認是File存儲，存儲在本地磁盤上
 * 
 * 作用：此存儲用於存儲Gateway進程的內部通訊地址，以及每個客戶端client_id
 *            對應的Gateway地址。
 *            當Gateway啟動後每個gateway進程會將自己的內部通訊地址放到這個存儲裡面
 *            當BusinessWorker進程啟動後，會從這個存儲中讀取所有Gateway通訊地址，
 *            並與其通過socket相連，這樣Gateway與BusinessWorker便可以通訊了
 * 
 * 如果有多個GatewayWorker應用時，每個應用的這個配置都應該不同，
 * 否則會導致多個應用間數據互通
 * 如果有多個GatewayWorker應用時，配置細節如下
 *     當Store::$driver=self::DRIVER_FILE時，每個應用的Store::$storePath應該不同
 *     當Store::$driver=self::DRIVER_MC/DRIVER_REDIS時，每個應用的
 *     Store::$gateway的ip或者端口應該不同
 *     
 * 注意：當使用Redis存儲時，Redis服務端redis-server的timeout配置成0
 *           redis擴展git地址https://github.com/phpredis/phpredis
 *           redis擴展安裝方法 pecl install redis
 *           
 * @author walkor
 */
class Store
{
    // 使用文件存儲，注意使用文件存儲無法支持workerman分佈式部署
    const DRIVER_FILE = 1;
    // 使用memcache存儲，支持workerman分佈式部署
    const DRIVER_MC = 2;
    // 使用redis存儲（推薦），支持workerman分佈式部署
    const DRIVER_REDIS = 3;
    
     // DRIVER_FILE 或者 DRIVER_MC 或者 DRIVER_REDIS（推薦）
    public static $driver = self::DRIVER_FILE;
    
    //$driver為DRIVER_MC/DRIVER_REDIS時需要配置memcached/redis服務端ip和端口
    public static $gateway = array(
        '127.0.0.1:6379',
    );
    
    // $driver為DRIVER_FILE時要配置此項，實際配置在最下面一行
    public static $storePath = '';
}

// 默認系統臨時目錄下
Store::$storePath = sys_get_temp_dir().'/workerman-chat/';
